(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    109144,       3250]
NotebookOptionsPosition[     95646,       2772]
NotebookOutlinePosition[     97129,       2812]
CellTagsIndexPosition[     97043,       2807]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Forms of Input and Output" :> 
          Documentation`HelpLookup["paclet:tutorial/FormsOfInputAndOutput"], 
          "The Interpretation of Textual Forms" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/TheInterpretationOfTextualForms"], 
          "The Representation of Textual Forms" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/TheRepresentationOfTextualForms"], 
          "TraditionalForm Reference Information" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/TraditionalFormReferenceInformation"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Forms of Input and Output\"\>", 
       2->"\<\"The Interpretation of Textual Forms\"\>", 
       3->"\<\"The Representation of Textual Forms\"\>", 
       4->"\<\"TraditionalForm Reference Information\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"StandardForm" :> 
          Documentation`HelpLookup["paclet:ref/StandardForm"], "Text" :> 
          Documentation`HelpLookup["paclet:ref/Text"], "TeXForm" :> 
          Documentation`HelpLookup["paclet:ref/TeXForm"], "MakeExpression" :> 
          Documentation`HelpLookup["paclet:ref/MakeExpression"], "ToBoxes" :> 
          Documentation`HelpLookup["paclet:ref/ToBoxes"], "MathMLForm" :> 
          Documentation`HelpLookup["paclet:ref/MathMLForm"], "Style" :> 
          Documentation`HelpLookup["paclet:ref/Style"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"StandardForm\"\>", 2->"\<\"Text\"\>", 
       3->"\<\"TeXForm\"\>", 4->"\<\"MakeExpression\"\>", 
       5->"\<\"ToBoxes\"\>", 6->"\<\"MathMLForm\"\>", 
       7->"\<\"Style\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Cell Menu" :> 
          Documentation`HelpLookup["paclet:guide/CellMenu"], 
          "Tokens Related to the Cell Menu" :> 
          Documentation`HelpLookup["paclet:guide/CellTokens"], 
          "Converting between Expressions & Strings" :> 
          Documentation`HelpLookup[
           "paclet:guide/ConvertingBetweenExpressionsAndStrings"], 
          "Mathematical Typesetting" :> 
          Documentation`HelpLookup[
           "paclet:guide/MathematicalTypesetting"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Cell Menu\"\>", 
       2->"\<\"Tokens Related to the Cell Menu\"\>", 
       3->"\<\"Converting between Expressions & Strings\"\>", 
       4->"\<\"Mathematical Typesetting\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["TraditionalForm", "ObjectName"], Cell[BoxData[
     TooltipBox[
      TogglerBox[Dynamic[
        FrontEnd`CurrentValue[
         FrontEnd`EvaluationNotebook[], {
         TaggingRules, "ModificationHighlight"}]], {True->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVVly2zAMDQhxEylSsizLaxJn73KafvQAuUDv/1eApJuosceeTDAWF4B8
eFgk71///HoVV1dXK3p+0wNfIzdCLL4I6p1sYBYuPy3SI2AmRBpuaE/TPRsE
3Isg8mrB9l6ILQhhLkbd93MBuwVxAthdZwPr5wVVzBc8wAvMX8TFqPkqE8q6
rDCsKPjZ/g1guz+PKvLFfGsDU1R4A8zDhgLangX9x/WGM7A1qSQ7rraYkaLf
LHZ5FWY9H7rew/n4/6vWPKT2mXFBaH/NGejzqi/VnFEFJ2Rb1Lo+jtofllPD
RVJjdZLr51Eb/ED1K+QI109LcIg+sdSIWqa5g85L6MiNoRloTws+pdBKiFGl
mx3N0jcAlcsKeFivVkteVOgMSNsC18sYS/iIMdZoK43WSdQVK1SLlYy09bZ2
aEO+aoPiACNak0EBbtfLRIz9KJRcroaSKwE11BprpRHqiJ0BrxtJG4pLYqWc
RZO4BQwSbGT4rFivaLjjQdscjSvlih48Mu+WDisOBcB5ehgeDEZQlikkKh3b
KA1FMTDg9yFxLSe4XC37begHTDh5seS1I/gaW025Yo/yUFbmSalShzon1Kch
JTNn2hKS1hyWVIkf5n2LHEQgt0zeUNTkMaYrDdkMZdo3fJCDHx7hxzAC+8rs
XYBokTPfEJk6JVlZx3Yl0UnTYMPvSUt6zghf8dhIi5VDnwO+Hcb1MHK1msK+
oy5qkYS7wVC3cfiq8ojBcMtFMJXnDiIcLPFJClDFGkJBhXGEZV6VcCQFoey7
tyvBF6lw0uKH6nyQ5fqhrKx/Kxe8+3coucpGN4U5+RYux7vnhGO5P7hKenqz
xSO3ivjisf345fg5Pt1ScCRkkzR1U1Dur+NCec4LZ49Ynx9P04GmOvlnqcKZ
79BfJfcjkg==
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlLlKQ0EYRi/iA9gpWIgvIXbjM1iKWAjW2vgeZnWN+AgWZhEULCxELFyi
ZnfJavbeJOr/33xXcj8CNnY5EA7k3GWYmTuzq+uLa2OWZS38/MYt0DbDHH8Q
8uTB64bRNrmsQkaPRoQSGX1ZqZPR9/eEazL6klIlowf8wiUZ3ecV3snowYDw
SEafUmJk9HmlQh4cX4GM7vUId2T0VFIho28or2T0w5DQIKN3PoUaGX1FaZLR
0ymh6sz7hHLk9PMzoU5Gz6SFmvFsCbd9Xzj9qyc0nfe49xfuTyYUEzoQbmh8
+N8e37HTbVpk9MSzUCajbypFMvq0UiOjzyklMnqvKzRMJCwU+/vjzemTSpns
nh97feJmd0e4cvppTKiQ0bsdoW5ecorZDgpPtD6xqFA2fp+Qp/vtdUj1v797
Oqdwnb2Ov++fUVpk9PCJUCC7n4t5wz5xj9/+rj6ceXbPP86NbEb58/k56qP+
n/0bdGyYqQ==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}], False->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVdd22zAMDUBxSaJm5HgljrPTJN177/nWh35AfqD//1aAVGrrJLbbk+BI
FEmQFxcXlDQ9//3zHNfW1gZ0/6IbbsYOhahvCGrO9qHM/mnhmMMLoKv0RD6V
cPyZHTTcDI5NkYnQq4UQ0BdiAkKYZagl1OOw5fWtcgyvPp7AnefsGG0DBIeA
9RZVrNfcwBasb4nlbP9u4cbc/XD/zXcIgC2qYYazJTQiGSYHS0Hr8Yu5LV/h
ePvR5oMOKswAQ0M8R5OloFMWSNRE+IAVeALv38KX26wAV1uU5Ojv16PQy8q+
gMP+9ABW5C9KbkZi6qv19DGc/ID9b+CrZTjbbVagH3p91oIcL+GZ6JDNUet4
HpWUXxx5BaWZxRh1FQgH6JqoKcarF/2/dblez7IE0XmWGlFL/6ygchIqCmPo
CTSmDq9SaCUUhfI7K3pKlwJESZiAveHGxoA7ESYGpM2B62WMJXzEoojRRhpt
IlFHPKFyjGRBQ2fjBG0WttpMcYIFWhNAAXaHA0+M4yiUXK6UxJWAGmKNsdII
cYGVAadTSQPKS2KkEovGc8swk2ALhg8Tww1qdrjRNmSTtOUqHDhk3jktVpwK
QOLoZngwWICyTMFTqdhHMrQTDQPeazzXdgWXK+e4KV3AhH0US1Ergo8x16QV
R5QXZWWeJJW6qLNHPWq8mEFpS0hac1pSeX4YxjlyEhmFZfKGsqaIhd+Sks+Q
0i7lhZx8cwYPmx5wrMA+yaCwyMqnRCb2IiubsF9JTKRJMeX3JKd5VoS3OEyl
xShBFxLebXrDpsfVSlv2FZ2iHMn4NBg6bZy+ihxiZvjIFWAixyeIcLDNT1KC
qogha1Gh14NB6LXpSEpC2bm3y8O3FmHniF9U55INhnttz7pZuWDu79BqFZxJ
F2bhWzjo7Zx6HMvng6ukuztzvGJXa66NmF/+crzrHe1ScmTkk/SouqB8vq42
0jl0EnuF9/RsMR1Io4U/S5Wt+A79AaDyK/w=
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlUtrE1EYhgfxBwguFBTEvyAiFhfzHxRFvC0E17rQhYLiT7D3u/gTXNg2
3sBFFyIutE1qm17UZJKZZJK0KFjBtur7Td4jnhe7dTMPhAfyQObMnO9Mjl69
fvraniAI7v/+7A3IRri7/8VGWJwHVTH72qohZp+ZBnUx+yWjJWYfHwNvxOwX
jKaYfXAAzIrZ+/tARcw+NAhKYvaTRiJmP2gUxH+vLxKzl5cMMXtfL3gvZn84
Cdpi9hvGJzH7yxegJWa/YnTE7Mtl0HTPfZ/xyPWVZZCGvQ/Au65fSV9aNMLJ
CfDW9a0fIBWz/9wBHbcOf/74PX83W99j128ZNTH71BMQidmfFkAiZj9irIvZ
Fz+AWMx+yEjF7KeMVOw/32x/iuHoCHjt+s42aIfTU6DWna/Prm9vgVb4cc0I
h4fAgusZ62L2A0YsZj9h1MX+9bN9LHfP75zrZ42a2L9/3+wXjVTM7q8jm9NE
5q8wA+JwoB/8eX+eNxIx+00jErP3GA2xvy7uG88R+z2jI2Y/bLTE/v1l76WG
mxP/+r7ZN7+Bupj9mFERsz9/Bppi9myeEzH7QgnUxOy3jYaY/a7RFrNfNtpi
9nNGXcw+NgoaYnbOk2///PJ/bXXFcP37JojF7CPDIBazf/0CKmL2+TlQEbPf
MZpi9olxkIrZS0UQidn3G1Ux+3EjErOfMapi9mBX8p73vOc973n/P/0XnFJ2
Rg==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}]}, "\"\<Click me\>\""],
      "Toggle changes in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["TraditionalForm",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/TraditionalForm"], "[", 
       StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]prints as an approximation to the traditional \
mathematical notation for ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->3700]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "Output from ",
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " cannot necessarily be given as unique and unambiguous input to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->17298791]
}], "Notes",
 CellID->15622],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " inserts invisible ",
 Cell[BoxData[
  ButtonBox["TagBox",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TagBox"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["InterpretationBox",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InterpretationBox"]], "InlineFormula"],
 " constructs into the box form of output it generates, to allow unique \
interpretation. "
}], "Notes",
 CellID->7274],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Graphics",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Graphics"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Graphics3D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Graphics3D"]], "InlineFormula"],
 " are displayed graphically in ",
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 ".",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->46047206]
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->28835],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " can be edited in the notebook front end. "
}], "Notes",
 CellID->16828],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " uses special characters as well as ordinary keyboard characters.",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->388790367]
}], "Notes",
 CellID->13914],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " incorporates a large collection of rules for approximating traditional \
mathematical notation. "
}], "Notes",
 CellID->27958],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " prints functions in ",
 Cell[BoxData["Global`"], "InlineFormula"],
 " context in the form ",
 Cell[BoxData[
  RowBox[{
   StyleBox["f", "TI"], 
   RowBox[{"(", 
    StyleBox["x", "TI"], ")"}]}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->25899],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["ToExpression",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ToExpression"], "[", 
   RowBox[{
    StyleBox["boxes", "TI"], ",", "TraditionalForm"}], "]"}]], 
  "InlineFormula"],
 " will attempt to convert from ",
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 ".",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->280553715]
}], "Notes",
 CellID->22427],

Cell[TextData[{
 "The notebook front end contains menu items for conversion to and from ",
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->8592]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->123453807],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->16520565],

Cell["Formatting of a trigonometric function:", "ExampleText",
 CellID->488311467],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TraditionalForm", "[", 
  RowBox[{"Sin", "[", "x", "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->555222942],

Cell[BoxData[
 FormBox[
  RowBox[{"sin", "(", "x", ")"}], TraditionalForm]], "Output",
 ImageSize->{31, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TraditionalForm=",
 CellID->144416873]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->47479645],

Cell["Formatting of a hypergeometric function:", "ExampleText",
 CellID->442222410],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TraditionalForm", "[", 
  RowBox[{"HypergeometricPFQ", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      SubscriptBox["a", "1"], ",", 
      SubscriptBox["a", "2"]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox["b", "1"], ",", 
      SubscriptBox["b", "2"]}], "}"}], ",", "x"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->303989099],

Cell[GraphicsData["CompressedBitmap", "\<\
eJydVdtOwzAMTdOuazdEkQCJx0mIX4EnPqKakLoHBBr7/xInbuseeytjUuvb
iePj1Nl7e+o+PtvTYd/u3o7td3fY/+xev47BlWfOuS48zZMLeh+0+HR9H2QR
1CpoJFfkySkWf9Em0+URSm63ZWwO2PoK7Bpsn5YU00oX8w0YNwQxx2q0GXWz
sKr+1yqsN4s4D15SS4uZtEWHRhXi1PVFHGMKlnhynmsxY+yPOYvJnzz0sRC/
xFFjKrODXuBSxWYPZwisq1R7XcqREJhDnpQ7z0jVb39NXu13fUWlmdmcCIXC
3SrjJOfs9HnKbmg+9jegK4lzswavzHqxJ8g28iglIr0x0x/4ihmhbhWcZZiN
M2cKk7JRFQ85NizF3bQY2fbTfM2r1Z2xGJLZsMS4PK/E+lZ5rDV+HDixOd+7
eLvVYL+A3YD9qHjadwTus5T3Huyph6XB8plZ3rF8MDob/gbV22W/frKFng==
\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{104, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TraditionalForm=",
 CellID->1010261296]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->282226522],

Cell["Partial derivative of an arbitrary function:", "ExampleText",
 CellID->198168244],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TraditionalForm", "[", 
  RowBox[{"D", "[", 
   RowBox[{
    RowBox[{"f", "[", 
     RowBox[{"x", ",", "y"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "2"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"y", ",", "3"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->33948826],

Cell[BoxData[
 FormBox[
  RowBox[{
   SuperscriptBox["f", 
    TagBox[
     RowBox[{"(", 
      RowBox[{"2", ",", "3"}], ")"}],
     Derivative],
    MultilineFunction->None], "(", 
   RowBox[{"x", ",", "y"}], ")"}], TraditionalForm]], "Output",
 ImageSize->{58, 17},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TraditionalForm=",
 CellID->912342467]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(7)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->10802],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Basic Objects",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->106039460],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Integer",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Integer"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Rational",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Rational"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Real",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Real"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Complex",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Complex"]], "InlineFormula"],
 " numbers: "
}], "ExampleText",
 CellID->17800827],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Map", "[", 
  RowBox[{"TraditionalForm", ",", 
   RowBox[{"{", 
    RowBox[{"123", ",", 
     RowBox[{"1", "/", "23"}], ",", "1.23", ",", 
     RowBox[{"1", "+", 
      RowBox[{"23", "I"}]}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->540624369],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    FormBox["123",
     TraditionalForm],
    TraditionalForm,
    Editable->True], ",", 
   TagBox[
    FormBox[
     FractionBox["1", "23"],
     TraditionalForm],
    TraditionalForm,
    Editable->True], ",", 
   TagBox[
    FormBox["1.23`",
     TraditionalForm],
    TraditionalForm,
    Editable->True], ",", 
   TagBox[
    FormBox[
     RowBox[{"1", "+", 
      RowBox[{"23", " ", "\[ImaginaryI]"}]}],
     TraditionalForm],
    TraditionalForm,
    Editable->True]}], "}"}]], "Output",
 ImageSize->{164, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->53757261]
}, Open  ]],

Cell[TextData[{
 "Arbitrary-precision ",
 Cell[BoxData[
  ButtonBox["Real",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Real"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Complex",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Complex"]], "InlineFormula"],
 " numbers:"
}], "ExampleText",
 CellID->738802486],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TraditionalForm", "/@", 
  RowBox[{"N", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"10", "/", "3"}], ",", 
      RowBox[{
       RowBox[{"10", "/", "3"}], "I"}]}], "}"}], ",", "20"}], 
   "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->55230342],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    FormBox["3.33333333333333333333333333333333333333`20.",
     TraditionalForm],
    TraditionalForm,
    Editable->True], ",", 
   TagBox[
    FormBox[
     RowBox[{
     "3.33333333333333333333333333333333333333`20.", " ", "\[ImaginaryI]"}],
     TraditionalForm],
    TraditionalForm,
    Editable->True]}], "}"}]], "Output",
 ImageSize->{335, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->3968078]
}, Open  ]],

Cell["Special constants:", "ExampleText",
 CellID->75126432],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TraditionalForm", "/@", 
  RowBox[{"{", 
   RowBox[{"I", ",", "Pi", ",", "E"}], "}"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->70178760],

Cell[GraphicsData["CompressedBitmap", "\<\
eJydUk0PgjAMLWww4xd488jRq3fOevJHLMQEDgaD/H/sJtHlUYNxydq9fryu
3S62r6832zeVLc6dvddN9ShObccmFRFRyTvbE58HPvldDgNr7aRy2C9aAs4B
Z4CVZ1FgXbGIGe4CHfpjMctZDU3tiVQT2QKcskho2ptcNYxi6au5Oxtf+h0H
3hSyjFgLb5ZAlp+m/viJNhCxAIbopx5ywMiq/p7OHDN2LGLxBd2ot+MPWLPW
47Tns49iFPaH+AD49ZPLL5KiJ8/LpKA=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->56706243]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->56955154],

Cell["Characters and strings of characters:", "ExampleText",
 CellID->125904531],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TraditionalForm", "/@", 
  RowBox[{"{", 
   RowBox[{
   "\"\<a\>\"", ",", "\"\<\[Alpha]\>\"", ",", "\"\<\[CirclePlus]\>\""}], 
   "}"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->48683404],

Cell[GraphicsData["CompressedBitmap", "\<\
eJyVUs0OgjAMLoyfaFT05pGbJ1+AB9CTD7EQEzgYCfL+sx0LLqWAkKzdV9bv
a77tobvq+dJdXer83uqmqstPfnu3WFIBABS4sjPg3uDOrsIYzBFFRdh+sGE4
W8DKsihW3WIIER5dPrH/odhFOIZxPXEsocTi4RQDwfgvNVuNB2zP9H6QVsJP
O17Kqdc5xJGTvSqfUYmqO7G6pxz9epcdCCZ9jWZVUsH1Na6tml/0XJ6a4MFl
99Ss3b7e0g1w3ouZeyWc4yrdHxQTEYIvIRDIXA==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{58, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->304358513]
}, Open  ]],

Cell["Control characters for strings:", "ExampleText",
 CellID->61060215],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TraditionalForm", "[", "\"\<A first line\\nA second line\>\"", 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->49753538],

Cell[BoxData[
 FormBox["\<\"A first line\\nA second line\"\>", TraditionalForm]], "Output",
 ImageSize->{69, 35},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//TraditionalForm=",
 CellID->285736890]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Special Input Forms",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->479371353],

Cell[TextData[{
 "Different ways of representing ",
 Cell[BoxData[
  ButtonBox["Power",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Power"]], "InlineFormula"],
 " expressions:"
}], "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->388790367],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TraditionalForm", "/@", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"a", "^", "x"}], ",", 
    RowBox[{"Sqrt", "[", "a", "]"}], ",", 
    SuperscriptBox["a", 
     RowBox[{"1", "/", "2"}]], ",", 
    SuperscriptBox["a", 
     RowBox[{"1", "/", "3"}]], ",", 
    RowBox[{"Exp", "[", "x", "]"}], ",", 
    SuperscriptBox["x", 
     RowBox[{"-", "1"}]]}], "}"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->25296522],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    FormBox[
     SuperscriptBox["a", "x"],
     TraditionalForm],
    TraditionalForm,
    Editable->True], ",", 
   TagBox[
    FormBox[
     SqrtBox["a"],
     TraditionalForm],
    TraditionalForm,
    Editable->True], ",", 
   TagBox[
    FormBox[
     SqrtBox["a"],
     TraditionalForm],
    TraditionalForm,
    Editable->True], ",", 
   TagBox[
    FormBox[
     RadicalBox["a", "3"],
     TraditionalForm],
    TraditionalForm,
    Editable->True], ",", 
   TagBox[
    FormBox[
     SuperscriptBox["\[ExponentialE]", "x"],
     TraditionalForm],
    TraditionalForm,
    Editable->True], ",", 
   TagBox[
    FormBox[
     FractionBox["1", "x"],
     TraditionalForm],
    TraditionalForm,
    Editable->True]}], "}"}]], "Output",
 ImageSize->{184, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->10041436]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->535271940],

Cell["Special typeset expressions:", "ExampleText",
 CellID->39580944],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TraditionalForm", "/@", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     SubscriptBox["\[PartialD]", 
      RowBox[{"x", " "}]], 
     RowBox[{"y", "[", "x", "]"}]}], ",", 
    RowBox[{"\[Integral]", 
     RowBox[{
      RowBox[{"y", "[", "x", "]"}], 
      RowBox[{"\[DifferentialD]", "x"}]}]}], ",", 
    RowBox[{
     SubsuperscriptBox["\[Sum]", 
      RowBox[{"k", "=", "1"}], "n"], 
     RowBox[{"y", "[", "k", "]"}]}], ",", 
    RowBox[{
     SubsuperscriptBox["\[Product]", 
      RowBox[{"k", "=", "1"}], "n"], 
     RowBox[{"y", "[", "k", "]"}]}], ",", 
    RowBox[{"x", "\[Element]", "Reals"}], ",", 
    RowBox[{
     RowBox[{"x", "&&", "y"}], "||", "z"}], ",", 
    RowBox[{"Limit", "[", 
     RowBox[{
      RowBox[{"f", "[", "x", "]"}], ",", 
      RowBox[{"x", "\[Rule]", "a"}]}], "]"}]}], "}"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->177296101],

Cell[GraphicsData["CompressedBitmap", "\<\
eJy1Wc1OFEEQ7t35gQXEH0RRL0SFCwhRD0DiQSTqycRHcEOMcDAa5KIe9OJ7
qPHoA2niRV9k7Jrpnu39urqrGZZNdmaqf76qrvq6uqfn2fD44OXr4fHh/nD5
6dHw7cHh/rvlJ2+OdFHWU6r3VSm1sqT0c6Wf6j/9vul/84hP7/W1r5uprBbr
X18/DvR9LVL3py76YFrMkJRZbZVaD5Q3vT6aWoLNDabb6o5QP0KxpWTZNIMS
q29Q7usrFT6G2hgaV9+g3aNr0ZYazXtmPANz3wD5J2Bt1v22oJQu1q9uRAp6
zNtxmhZrtZQb6S6DtQFlJYHlI1xNJNO71tCodNoj5kN9mTejo+LS3H9AHEro
h9G9zdUnaXdlZB7GD634zng2ZyyhNqudLNwFeXBCC3910voIZInXqPULyM+T
rKBSEuegfArkAuRZkHODg75CnGsgY/TnAjjoDbQH26N3QvZJuCuMfa68YHBj
9hBDz0P9uuAndu550UPe4+hQtlkGR4HaUEacpQDOOQEHo23twXLJnlTc1YCd
VwQ/uqyw0SMcjBr6BVmQFjXkoM1esQyHsuRBzjJJR8G0sau91BfzA0YgaM/Y
uiaNGj0n8WQyWktm/DR/c9M3U3yejTGHiwdiSDzC0bk5xdpYMOMrTXnf3Mf2
LKrJbfZ+Wp42MwK9YZmGXqmB85HM41NP5JuNETIgDXHMYmeEbb2HQK0w+80m
24CetYjSqpY+ypCGaa9lSAfHRi53Bzzs7bWnAraXwda817k1zmNc0c4Cgyet
+zJPsEevaeYwBecf6rQjQKSLnEccnFAsuXI1BZ40GDaqi9BnRtCVQT1GD/c5
sYzcFb9v+cCwFDPLhZiveJZFrOO5iXFFH0yGkaEok009LRL/Gg6iD/yM1ZWJ
hYc0SS7irszPTRxbsg4slMcRQ7b8w7WUxkJ1l2I+8dhTirbwrMO8N895/MxY
x2c/dscSnWVoqVJ+pmVZ6KHG1nGpvvYPNXKydwH9L0P7QScr0G9JTJ2olpZz
CWt8LJOhnjayorWxnN9qGZsR3TKqtDM4MUMqjuP2BGX8HYLbkUn7e+R5ziKH
9mEx5PZNLncdxL3fYe4aJNnAZUGJS6ETmtNrmmfGRdrs+1mKddI7rsWULU5h
O1EX87fllV2JcGfJvcmlcCGN1eyuHrOfIyNv0J+xkymy8gbU475UGgXu86Qd
gYR3U19KZj7gOQZGjX0Tc+Srgiyda6adMHHnYa6MK/CC4E1sT1bRbLrOjWaU
uauTv9+02kWUByAjg6Szn8WKf/8k6zJGX7cTWjyXuAXynoDqffsBeTLfGnBs
Z6MVv6vg3vPstM5pcdPcf7Mose9vLyr36xr3te9VXbNNV2/3s1v5OXmLKftb
P+5UDftcXlDtDsj/6vtnoVWD+alqZuu2uTelZB9+Y1a9/zljqq8=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{416, 37},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->430947832]
}, Open  ]],

Cell["The same expressions entered as typical input:", "ExampleText",
 CellID->40094399],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TraditionalForm", "/@", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"D", "[", 
     RowBox[{
      RowBox[{"y", "[", "x", "]"}], ",", "x"}], "]"}], ",", " ", 
    RowBox[{"Integrate", "[", 
     RowBox[{
      RowBox[{"y", "[", "x", "]"}], ",", " ", "x"}], "]"}], ",", " ", 
    RowBox[{"Sum", "[", 
     RowBox[{
      RowBox[{"y", "[", "k", "]"}], ",", " ", 
      RowBox[{"{", 
       RowBox[{"k", ",", " ", "1", ",", " ", "n"}], "}"}]}], "]"}], ",", " ", 
    "\n", " ", 
    RowBox[{"Product", "[", 
     RowBox[{
      RowBox[{"y", "[", "k", "]"}], ",", " ", 
      RowBox[{"{", 
       RowBox[{"k", ",", " ", "1", ",", " ", "n"}], "}"}]}], "]"}], ",", " ", 
    
    RowBox[{"Element", "[", 
     RowBox[{"x", ",", " ", "Reals"}], "]"}], ",", " ", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"x", " ", "&&", " ", "y"}], ")"}], " ", "||", " ", "z"}], ",", 
    RowBox[{"Limit", "[", 
     RowBox[{
      RowBox[{"f", "[", "x", "]"}], ",", 
      RowBox[{"x", "\[Rule]", "a"}]}], "]"}]}], "}"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->692214967],

Cell[GraphicsData["CompressedBitmap", "\<\
eJy1Wc1OFEEQ7t35gQXEH0RRL0SFCwhRD0DiQSTqycRHcEOMcDAa5KIe9OJ7
qPHoA2niRV9k7Jrpnu39urqrGZZNdmaqf76qrvq6uqfn2fD44OXr4fHh/nD5
6dHw7cHh/rvlJ2+OdFHWU6r3VSm1sqT0c6Wf6j/9vul/84hP7/W1r5uprBbr
X18/DvR9LVL3py76YFrMkJRZbZVaD5Q3vT6aWoLNDabb6o5QP0KxpWTZNIMS
q29Q7usrFT6G2hgaV9+g3aNr0ZYazXtmPANz3wD5J2Bt1v22oJQu1q9uRAp6
zNtxmhZrtZQb6S6DtQFlJYHlI1xNJNO71tCodNoj5kN9mTejo+LS3H9AHEro
h9G9zdUnaXdlZB7GD634zng2ZyyhNqudLNwFeXBCC3910voIZInXqPULyM+T
rKBSEuegfArkAuRZkHODg75CnGsgY/TnAjjoDbQH26N3QvZJuCuMfa68YHBj
9hBDz0P9uuAndu550UPe4+hQtlkGR4HaUEacpQDOOQEHo23twXLJnlTc1YCd
VwQ/uqyw0SMcjBr6BVmQFjXkoM1esQyHsuRBzjJJR8G0sau91BfzA0YgaM/Y
uiaNGj0n8WQyWktm/DR/c9M3U3yejTGHiwdiSDzC0bk5xdpYMOMrTXnf3Mf2
LKrJbfZ+Wp42MwK9YZmGXqmB85HM41NP5JuNETIgDXHMYmeEbb2HQK0w+80m
24CetYjSqpY+ypCGaa9lSAfHRi53Bzzs7bWnAraXwda817k1zmNc0c4Cgyet
+zJPsEevaeYwBecf6rQjQKSLnEccnFAsuXI1BZ40GDaqi9BnRtCVQT1GD/c5
sYzcFb9v+cCwFDPLhZiveJZFrOO5iXFFH0yGkaEok009LRL/Gg6iD/yM1ZWJ
hYc0SS7irszPTRxbsg4slMcRQ7b8w7WUxkJ1l2I+8dhTirbwrMO8N895/MxY
x2c/dscSnWVoqVJ+pmVZ6KHG1nGpvvYPNXKydwH9L0P7QScr0G9JTJ2olpZz
CWt8LJOhnjayorWxnN9qGZsR3TKqtDM4MUMqjuP2BGX8HYLbkUn7e+R5ziKH
9mEx5PZNLncdxL3fYe4aJNnAZUGJS6ETmtNrmmfGRdrs+1mKddI7rsWULU5h
O1EX87fllV2JcGfJvcmlcCGN1eyuHrOfIyNv0J+xkymy8gbU475UGgXu86Qd
gYR3U19KZj7gOQZGjX0Tc+Srgiyda6adMHHnYa6MK/CC4E1sT1bRbLrOjWaU
uauTv9+02kWUByAjg6Szn8WKf/8k6zJGX7cTWjyXuAXynoDqffsBeTLfGnBs
Z6MVv6vg3vPstM5pcdPcf7Mose9vLyr36xr3te9VXbNNV2/3s1v5OXmLKftb
P+5UDftcXlDtDsj/6vtnoVWD+alqZuu2uTelZB9+Y1a9/zljqq8=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{416, 37},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->39162973]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->175584778],

Cell["Different list structures:", "ExampleText",
 CellID->75098327],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TraditionalForm", "[", 
  RowBox[{"{", 
   RowBox[{"1", ",", "2", ",", "3"}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->287661578],

Cell[BoxData[
 FormBox[
  RowBox[{"{", 
   RowBox[{"1", ",", "2", ",", "3"}], "}"}], TraditionalForm]], "Output",
 ImageSize->{44, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TraditionalForm=",
 CellID->18328889]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TraditionalForm", "/@", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"(", GridBox[{
       {"a", "b", "c"},
       {"d", "e", "f"}
      }], ")"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"d", ",", "e", ",", "f"}], "}"}]}], "}"}]}], "}"}]}]], "Input",\

 CellLabel->"In[2]:=",
 CellID->250695724],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzVV9tOg0AQXS7bUmo0WhM16UPfNdGv0Cc/gjQm7YPR1P5Gvxl3l12lh8GB
gT5IwmWAPWfO7CwzvBb7zdt7sd+ui9XLrvjcbNdfq+ePnbmVREqpg9mXt8pc
l+bK7YeyNOfqeGaPib3rNnUP9gLsB7DnDmUOd1NziI2pEvfYbbm5TP1Zm/MU
xlyCrQUYuXs1sGt4moAde6Sje2DPwOa8Tk/AkdT1NFSQKvWP7YOHPpxLdA1G
RV9jUhHGsJ17opq5l4F9QfkgRmvMbycFDd0hdg0/cD1iBFHNZDRkmTLLX1+l
pV+FiY8ltUpRw1SAIfMWV9odExPEw/GY/xyezOvMx2fpY4JzHr4P6M2MGSfz
5rGDt3X7qRMrfhNxxVCsVhvOCLIhTuTY6pmGc4RMmK3IYKNqC61FjkRaOAZa
Q9954ljGyYb/zGJt7XNK+y+m7Ta6VJQu4+ReqfTX9jWKrcVcFpJ18QQ8o6r+
g5fsBfvrHcAg7w3S1mhzFYfqB+Ro8vpE1R2MX0b6xHUH6PMwdFph2x+DtUMX
EnJFuS2scayp2DdPeiMcd/uYk/g/dsPwXzPv5yTLlfcB+xlEX7S8V6GO829Z
/aeq6Bu2UO/7\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{141, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->134625852]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->120336310],

Cell["Mathematical functions with special representations:", "ExampleText",
 CellID->289611139],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Map", "[", 
  RowBox[{"TraditionalForm", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Gamma", "[", "x", "]"}], ",", 
     RowBox[{"Floor", "[", "x", "]"}], ",", 
     RowBox[{"Zeta", "[", "x", "]"}], ",", 
     RowBox[{"DivisorSigma", "[", 
      RowBox[{"k", ",", "n"}], "]"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->231716069],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzNVs1uwjAMTpPSwTYo3LgBL7Od9hAVmgQHtKnjgfqmwSkNRB/OD2EHKjWp
k/iz/dlp8tUcd9+H5rjfNuvPtvnd7bd/64+floZUIYTo6K2Xgr41ffVvpzX1
pWmVkftHvIP8AvII5Ak1RrQ9zhv9kkTEieFOqZEkCtW72T/3YpxVVSTCCcjl
YPkVxt8YdMl4JTkvEuzVQz+OrMco5TXK8jI6sF4xa5FVrACU0Z8cDMMRVx2P
YFneqpvI1QXGPpgDxHQ4DGSOra+rZY/vctgdeZpYXZjRO5FGLk/IjPBk6FYr
lqMzn7gTcBXasp7ieJ24bhrhKqgXZIbzNo0Z1Cp0TqU9FzN212JtqiQe/2fv
uSgc7xwzofWzB+3xTPnODL52uL+1h5ngjrdW3L8qoiA/qToq057h1wSMp2rO
CZDKC3dXceU5yJitmZutwAmPuKvIPH+CY5QVUxG44xaRCObafytz5U1knr9Z
dZ5WFCcCb3NQ\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{160, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->239489487]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Special Output Forms",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->250137182],

Cell["Some objects use a special output representation:", "ExampleText",
 CellID->483444329],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ser", "=", 
  RowBox[{"Series", "[", 
   RowBox[{
    RowBox[{"Sin", "[", "x", "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", "3"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->270064825],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"x", "-", 
   FractionBox[
    SuperscriptBox["x", "3"], "6"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "4"],
    SeriesData[$CellContext`x, 0, {}, 1, 4, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {1, 0, 
    Rational[-1, 6]}, 1, 4, 1],
  Editable->False]], "Output",
 ImageSize->{87, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->16413206]
}, Open  ]],

Cell[TextData[{
 "Compare the ",
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " with the underlying ",
 Cell[BoxData[
  ButtonBox["FullForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FullForm"]], "InlineFormula"],
 " of the expression:"
}], "ExampleText",
 CellID->18535822],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TraditionalForm", "[", "ser", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->49083534],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"x", "-", 
    FractionBox[
     SuperscriptBox["x", "3"], "6"], "+", 
    InterpretationBox[
     RowBox[{"O", "(", 
      SuperscriptBox["x", "4"], ")"}],
     SeriesData[$CellContext`x, 0, {}, 1, 4, 1],
     Editable->False]}],
   SeriesData[$CellContext`x, 0, {1, 0, 
     Rational[-1, 6]}, 1, 4, 1],
   Editable->False], TraditionalForm]], "Output",
 ImageSize->{78, 35},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//TraditionalForm=",
 CellID->107670578]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullForm", "[", "ser", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->152587590],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"SeriesData", "[", 
    RowBox[{"x", ",", "0", ",", 
     RowBox[{"List", "[", 
      RowBox[{"1", ",", "0", ",", 
       RowBox[{"Rational", "[", 
        RowBox[{
         RowBox[{"-", "1"}], ",", "6"}], "]"}]}], "]"}], ",", "1", ",", "4", 
     ",", "1"}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Output",
 ImageSize->{361, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]//FullForm=",
 CellID->63814020]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->342012676],

Cell["Some objects use an elided output representation:", "ExampleText",
 CellID->65245750],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sp", "=", 
  RowBox[{"SparseArray", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "2"}], "}"}], "\[Rule]", "1"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"5", ",", "5"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->470286855],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "1", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 1, ">"],
     Editable->False], ",", 
    RowBox[{"{", 
     RowBox[{"5", ",", "5"}], "}"}]}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{167, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->77826434]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TraditionalForm", "[", "sp", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->191304613],

Cell[BoxData[
 FormBox[
  TagBox[
   RowBox[{"SparseArray", "[", 
    RowBox[{
     InterpretationBox[
      RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "1", 
       "\[InvisibleSpace]", "\<\">\"\>"}],
      SequenceForm["<", 1, ">"],
      Editable->False], ",", 
     RowBox[{"{", 
      RowBox[{"5", ",", "5"}], "}"}]}], "]"}],
   False,
   Editable->False], TraditionalForm]], "Output",
 ImageSize->{129, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//TraditionalForm=",
 CellID->913683]
}, Open  ]],

Cell[TextData[{
 "The elided information is visible in the ",
 Cell[BoxData[
  ButtonBox["InputForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InputForm"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->444663507],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InputForm", "[", "sp", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->268605706],

Cell["\<\
SparseArray[Automatic, {5, 5}, 0, {1, {{0, 1, 1, 1, 1, 1}, {{2}}}, {1}}]\
\>", "Output",
 ImageSize->{504, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]//InputForm=",
 CellID->405909472]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->146903789],

Cell["Graphic objects display as graphics:", "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->46047206],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Plot", "[", 
   RowBox[{
    RowBox[{"Sin", "[", "x", "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
    RowBox[{"PlotLabel", "\[Rule]", 
     RowBox[{"Sin", "[", "x", "]"}]}]}], "]"}], "//", 
  "TraditionalForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->404421484],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 121},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TraditionalForm=",
 CellID->346786139]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Plot3D", "[", 
   RowBox[{
    RowBox[{"Sin", "[", 
     RowBox[{
      RowBox[{"x", "^", "2"}], "+", 
      RowBox[{"y", "^", "2"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", 
      RowBox[{"-", "Pi"}], ",", "Pi"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"y", ",", 
      RowBox[{"-", "Pi"}], ",", "Pi"}], "}"}]}], "]"}], "//", 
  "TraditionalForm"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->19525682],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 137},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//TraditionalForm=",
 CellID->53842930]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->323487288],

Cell["Euler's formula in traditional mathematical notation:", "ExampleText",
 CellID->24088741],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TraditionalForm", "[", 
  RowBox[{
   RowBox[{"Exp", "[", 
    RowBox[{"I", " ", "\[Theta]"}], "]"}], "\[Equal]", 
   RowBox[{
    RowBox[{"Cos", "[", "\[Theta]", "]"}], "+", 
    RowBox[{"I", " ", 
     RowBox[{"Sin", "[", "\[Theta]", "]"}]}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->468426064],

Cell[BoxData[
 FormBox[
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"\[ImaginaryI]", " ", "\[Theta]"}]], "\[LongEqual]", 
   RowBox[{
    RowBox[{"cos", "(", "\[Theta]", ")"}], "+", 
    RowBox[{"\[ImaginaryI]", " ", 
     RowBox[{"sin", "(", "\[Theta]", ")"}]}]}]}], TraditionalForm]], "Output",\

 ImageSize->{113, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TraditionalForm=",
 CellID->356139557]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->53888257],

Cell["A triangle inequality:", "ExampleText",
 CellID->239212472],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TraditionalForm", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Abs", "[", 
      RowBox[{"x", "-", "y"}], "]"}], "^", "2"}], "+", 
    RowBox[{
     RowBox[{"Abs", "[", 
      RowBox[{"y", "-", "z"}], "]"}], "^", "2"}]}], ">=", 
   RowBox[{
    RowBox[{"Abs", "[", 
     RowBox[{"x", "-", "z"}], "]"}], "^", "2"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->41090091],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    SuperscriptBox[
     RowBox[{"\[LeftBracketingBar]", 
      RowBox[{"x", "-", "y"}], "\[RightBracketingBar]"}], "2"], "+", 
    SuperscriptBox[
     RowBox[{"\[LeftBracketingBar]", 
      RowBox[{"y", "-", "z"}], "\[RightBracketingBar]"}], "2"]}], 
   "\[GreaterEqual]", 
   SuperscriptBox[
    RowBox[{"\[LeftBracketingBar]", 
     RowBox[{"x", "-", "z"}], "\[RightBracketingBar]"}], "2"]}], 
  TraditionalForm]], "Output",
 ImageSize->{141, 17},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TraditionalForm=",
 CellID->22229807]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->232351834],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " is two-dimensional:"
}], "ExampleText",
 CellID->15763429],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TraditionalForm", "[", 
  RowBox[{"Exp", "[", 
   RowBox[{"I", " ", 
    RowBox[{"x", "/", "n"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->37175165],

Cell[BoxData[
 FormBox[
  SuperscriptBox["\[ExponentialE]", 
   FractionBox[
    RowBox[{"\[ImaginaryI]", " ", "x"}], "n"]], TraditionalForm]], "Output",
 ImageSize->{23, 23},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TraditionalForm=",
 CellID->79530781]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["StandardForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StandardForm"]], "InlineFormula"],
 " is two-dimensional and unambiguous for input:"
}], "ExampleText",
 CellID->457767460],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StandardForm", "[", 
  RowBox[{"Exp", "[", 
   RowBox[{"I", " ", 
    RowBox[{"x", "/", "n"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->52050003],

Cell[BoxData[
 SuperscriptBox["\[ExponentialE]", 
  FractionBox[
   RowBox[{"\[ImaginaryI]", " ", "x"}], "n"]]], "Output",
 ImageSize->{27, 23},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//StandardForm=",
 CellID->289768374]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["OutputForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/OutputForm"]], "InlineFormula"],
 " uses only keyboard characters:"
}], "ExampleText",
 CellID->209201139],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"OutputForm", "[", 
  RowBox[{"Exp", "[", 
   RowBox[{"I", " ", 
    RowBox[{"x", "/", "n"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->16589577],

Cell[OutputFormData["\<\
E^((I*x)/n)\
\>", "\<\
 (I x)/n
E\
\>"], "Output",
 ImageSize->{63, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]//OutputForm=",
 CellID->1470021]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["InputForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InputForm"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["FullForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FullForm"]], "InlineFormula"],
 " provide one-dimensional formatting:"
}], "ExampleText",
 CellID->13054338],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InputForm", "[", 
  RowBox[{"Exp", "[", 
   RowBox[{"I", " ", 
    RowBox[{"x", "/", "n"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->114959516],

Cell["E^((I*x)/n)", "Output",
 ImageSize->{77, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]//InputForm=",
 CellID->344120129]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullForm", "[", 
  RowBox[{"Exp", "[", 
   RowBox[{"I", " ", 
    RowBox[{"x", "/", "n"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->223015926],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"Power", "[", 
    RowBox[{"E", ",", 
     RowBox[{"Times", "[", 
      RowBox[{
       RowBox[{"Complex", "[", 
        RowBox[{"0", ",", "1"}], "]"}], ",", 
       RowBox[{"Power", "[", 
        RowBox[{"n", ",", 
         RowBox[{"-", "1"}]}], "]"}], ",", "x"}], "]"}]}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Output",
 ImageSize->{320, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]//FullForm=",
 CellID->427630841]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->52763461],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["ToBoxes",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ToBoxes"]], "InlineFormula"],
 " to see the underlying box structure:"
}], "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->280553715],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToBoxes", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"1", "/", "a"}], "+", 
    RowBox[{"x", "^", "2"}]}], ",", "TraditionalForm"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->367460198],

Cell[BoxData[
 RowBox[{"FormBox", "[", 
  RowBox[{
   RowBox[{"RowBox", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"SuperscriptBox", "[", 
       RowBox[{"\<\"x\"\>", ",", "\<\"2\"\>"}], "]"}], ",", "\<\"+\"\>", ",", 
      
      RowBox[{"FractionBox", "[", 
       RowBox[{"\<\"1\"\>", ",", "\<\"a\"\>"}], "]"}]}], "}"}], "]"}], ",", 
   "TraditionalForm"}], "]"}]], "Output",
 ImageSize->{536, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->116668306]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["ToExpression",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ToExpression"]], "InlineFormula"],
 " to convert the boxes to the original expression:"
}], "ExampleText",
 CellID->526181681],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToExpression", "[", 
  RowBox[{"%", ",", "TraditionalForm"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->157868315],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "a"], "+", 
  SuperscriptBox["x", "2"]}]], "Output",
 ImageSize->{41, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->104985926]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->536718205],

Cell[TextData[{
 "Add formatting via ",
 Cell[BoxData[
  ButtonBox["Format",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Format"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->810203101],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"bin", "[", 
   RowBox[{"x", ",", "y"}], "]"}], "//", "TraditionalForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->161343839],

Cell[BoxData[
 FormBox[
  RowBox[{"bin", "(", 
   RowBox[{"x", ",", "y"}], ")"}], TraditionalForm]], "Output",
 ImageSize->{47, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TraditionalForm=",
 CellID->169092792]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Format", "[", 
   RowBox[{
    RowBox[{"bin", "[", 
     RowBox[{"x_", ",", "y_"}], "]"}], ",", "TraditionalForm"}], "]"}], ":=", 
  
  RowBox[{"MatrixForm", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", "x", "}"}], ",", 
     RowBox[{"{", "y", "}"}]}], "}"}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->734130829],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"bin", "[", 
   RowBox[{"x", ",", "y"}], "]"}], "//", "TraditionalForm"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->88224750],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzdU69vg0AUvivdyrJkoaq4ISuRSNSmllRWQpolVDQjXQWOPwWJrKxEVlZW
ViIrK9n33nFAKP0H1oTre3ff9+79+O4r3EXfm3C3XoXO5zaMo/Xq1/n42WLL
kEKIGb53W8CuYPE3qyr8T7CO4L6xZ9A6KcvydDpV/CMkr4wURnOmsGLE5vl8
TpKEzDH7ikXmM/tZlh0OBzJHHdZyubzdbmQ+DbKCIMB1ZEqVA12Z53kURU3e
Ex0/juMeEvSiKGpEW4eKfb1e5/N5j2FZFvbvGORL13UlKtfoy+UCNLdrCL1Y
LCSS0mjk4TiOrozyrtsn9J5EtjJNU81AuzzPI2dKDHRXnyCs7/v6hDnE/ben
jzvRdnU60EFMyLbtRpPjVl1CvBAe8uvOCFI0TZPm31Wj0GiaPy7sqAUzPh6P
tZ7a6EoPiFbn1mHgNqT/gIE6UUGPgTC4plGNyUjoH8W1yOYNonr9MvsaUzXt
93u8n/YdMsCArFEIma/6bdQoFWB2twr5BwZnO8U=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{23, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]//TraditionalForm=",
 CellID->450130558]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->147767195],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " is ambiguous, i.e. different expressions can display similarly:"
}], "ExampleText",
 CellID->17298791],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", "n", "}"}], ",", 
    RowBox[{"{", "k", "}"}]}], "}"}], "//", "TraditionalForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->81261506],

Cell[BoxData[
 FormBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"n"},
     {"k"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}], 
  TraditionalForm]], "Output",
 ImageSize->{26, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TraditionalForm=",
 CellID->156025448]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Binomial", "[", 
   RowBox[{"n", ",", "k"}], "]"}], "//", "TraditionalForm"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->375700736],

Cell[BoxData[
 FormBox[
  TagBox[
   RowBox[{"(", GridBox[{
      {
       TagBox["n",
        Identity,
        Editable->True,
        Selectable->True]},
      {
       TagBox["k",
        Identity,
        Editable->True,
        Selectable->True]}
     }], ")"}],
   InterpretTemplate[Binomial[#, #2]& ],
   Editable->False,
   Selectable->False], TraditionalForm]], "Output",
 ImageSize->{26, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//TraditionalForm=",
 CellID->355848378]
}, Open  ]],

Cell["The following box structure has similar display:", "ExampleText",
 CellID->958431278],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"RowBox", "[", 
   RowBox[{"{", 
    RowBox[{"\"\<(\>\"", ",", 
     RowBox[{"GridBox", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", "n", "}"}], ",", 
        RowBox[{"{", "k", "}"}]}], "}"}], "]"}], ",", "\"\<)\>\""}], "}"}], 
   "]"}], "//", "DisplayForm"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->302386216],

Cell[BoxData[
 TagBox[
  RowBox[{"(", GridBox[{
     {"n"},
     {"k"}
    }], ")"}],
  DisplayForm]], "Output",
 ImageSize->{31, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]//DisplayForm=",
 CellID->142016877]
}, Open  ]],

Cell["\<\
When interpreting the boxes, a particular interpretation is selected:\
\>", "ExampleText",
 CellID->50335871],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToExpression", "[", 
  RowBox[{
   RowBox[{"RowBox", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<(\>\"", ",", 
      RowBox[{"GridBox", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", "n", "}"}], ",", 
         RowBox[{"{", "k", "}"}]}], "}"}], "]"}], ",", "\"\<)\>\""}], "}"}], 
    "]"}], ",", "TraditionalForm"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->170475121],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", "n", "}"}], ",", 
   RowBox[{"{", "k", "}"}]}], "}"}]], "Output",
 ImageSize->{72, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->135059546]
}, Open  ]],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "-generated formatting includes data for unambiguous interpretation:"
}], "ExampleText",
 CellID->758769474],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToExpression", "[", 
  RowBox[{
   RowBox[{"ToBoxes", "[", 
    RowBox[{
     RowBox[{"Binomial", "[", 
      RowBox[{"n", ",", "k"}], "]"}], ",", "TraditionalForm"}], "]"}], ",", 
   "TraditionalForm"}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->328198665],

Cell[BoxData[
 RowBox[{"Binomial", "[", 
  RowBox[{"n", ",", "k"}], "]"}]], "Output",
 ImageSize->{100, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->18492979]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToExpression", "[", 
  RowBox[{
   RowBox[{"ToBoxes", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", "n", "}"}], ",", 
       RowBox[{"{", "k", "}"}]}], "}"}], ",", "TraditionalForm"}], "]"}], ",",
    "TraditionalForm"}], "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->479002055],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", "n", "}"}], ",", 
   RowBox[{"{", "k", "}"}]}], "}"}]], "Output",
 ImageSize->{72, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->15467883]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->481490785],

Cell["Nested roots:", "ExampleText",
 CellID->370612919],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Nest", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Sqrt", "[", 
      RowBox[{"1", "+", 
       RowBox[{"1", "/", "#"}]}], "]"}], "&"}], ",", "x", ",", "10"}], "]"}], 
  "//", "TraditionalForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->529895193],

Cell[BoxData[
 FormBox[
  SqrtBox[
   RowBox[{"1", "+", 
    FractionBox["1", 
     SqrtBox[
      RowBox[{"1", "+", 
       FractionBox["1", 
        SqrtBox[
         RowBox[{"1", "+", 
          FractionBox["1", 
           SqrtBox[
            RowBox[{"1", "+", 
             FractionBox["1", 
              SqrtBox[
               RowBox[{"1", "+", 
                FractionBox["1", 
                 SqrtBox[
                  RowBox[{"1", "+", 
                   FractionBox["1", 
                    SqrtBox[
                    RowBox[{"1", "+", 
                    FractionBox["1", 
                    SqrtBox[
                    RowBox[{"1", "+", 
                    FractionBox["1", 
                    SqrtBox[
                    RowBox[{"1", "+", 
                    FractionBox["1", 
                    SqrtBox[
                    RowBox[{"1", "+", 
                    
                    FractionBox["1", 
                    "x"]}]]]}]]]}]]]}]]]}]]]}]]]}]]]}]]]}]]]}]], 
  TraditionalForm]], "Output",
 ImageSize->{308, 168},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TraditionalForm=",
 CellID->243967974]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->31493],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["StandardForm",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/StandardForm"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Text",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Text"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["TeXForm",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TeXForm"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MakeExpression",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MakeExpression"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ToBoxes",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ToBoxes"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MathMLForm",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MathMLForm"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Style",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Style"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->32146]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->3921],

Cell[TextData[ButtonBox["Forms of Input and Output",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/FormsOfInputAndOutput"]], "Tutorials",
 CellID->17089],

Cell[TextData[ButtonBox["The Interpretation of Textual Forms",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/TheInterpretationOfTextualForms"]], "Tutorials",\

 CellID->27366],

Cell[TextData[ButtonBox["The Representation of Textual Forms",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/TheRepresentationOfTextualForms"]], "Tutorials",\

 CellID->157498705],

Cell[TextData[ButtonBox["TraditionalForm Reference Information",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/TraditionalFormReferenceInformation"]], "Tutorials",
 CellID->65997988]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->377712759],

Cell[TextData[ButtonBox["Cell Menu",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/CellMenu"]], "MoreAbout",
 CellID->650841053],

Cell[TextData[ButtonBox["Tokens Related to the Cell Menu",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/CellTokens"]], "MoreAbout",
 CellID->1354457],

Cell[TextData[ButtonBox["Converting between Expressions & Strings",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/ConvertingBetweenExpressionsAndStrings"]], "MoreAbout",
 CellID->509989182],

Cell[TextData[ButtonBox["Mathematical Typesetting",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MathematicalTypesetting"]], "MoreAbout",
 CellID->337836689]
}, Open  ]],

Cell["New in 3  |  Last modified in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"TraditionalForm - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 27, 28.8648894}", "context" -> "System`", 
    "keywords" -> {
     "ambiguities", "classical notation", "editing", "formula typesetting", 
      "functions", "invisible tags", "mathematical notation", 
      "publication format", "textbook notation", "traditional notation"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "TraditionalForm[expr] prints as an approximation to the traditional \
mathematical notation for expr. ", "synonyms" -> {"traditional form"}, 
    "title" -> "TraditionalForm", "type" -> "Symbol", "uri" -> 
    "ref/TraditionalForm"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[13185, 372, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->123453807]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 96899, 2800}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3511, 76, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[4134, 103, 4199, 83, 70, "ObjectNameGrid"],
Cell[8336, 188, 611, 19, 70, "Usage",
 CellID->3700]
}, Open  ]],
Cell[CellGroupData[{
Cell[8984, 212, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[9462, 229, 404, 14, 70, "Notes",
 CellID->15622],
Cell[9869, 245, 554, 18, 70, "Notes",
 CellID->7274],
Cell[10426, 265, 685, 23, 70, "Notes",
 CellID->28835],
Cell[11114, 290, 223, 7, 70, "Notes",
 CellID->16828],
Cell[11340, 299, 333, 10, 70, "Notes",
 CellID->13914],
Cell[11676, 311, 278, 8, 70, "Notes",
 CellID->27958],
Cell[11957, 321, 400, 15, 70, "Notes",
 CellID->25899],
Cell[12360, 338, 528, 19, 70, "Notes",
 CellID->22427],
Cell[12891, 359, 257, 8, 70, "Notes",
 CellID->8592]
}, Closed]],
Cell[CellGroupData[{
Cell[13185, 372, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->123453807],
Cell[CellGroupData[{
Cell[13570, 386, 147, 5, 70, "ExampleSection",
 CellID->16520565],
Cell[13720, 393, 82, 1, 70, "ExampleText",
 CellID->488311467],
Cell[CellGroupData[{
Cell[13827, 398, 141, 4, 28, "Input",
 CellID->555222942],
Cell[13971, 404, 233, 7, 50, "Output",
 CellID->144416873]
}, Open  ]],
Cell[14219, 414, 124, 3, 70, "ExampleDelimiter",
 CellID->47479645],
Cell[14346, 419, 83, 1, 70, "ExampleText",
 CellID->442222410],
Cell[CellGroupData[{
Cell[14454, 424, 395, 13, 28, "Input",
 CellID->303989099],
Cell[14852, 439, 718, 16, 50, "Output",
 Evaluatable->False,
 CellID->1010261296]
}, Open  ]],
Cell[15585, 458, 125, 3, 70, "ExampleDelimiter",
 CellID->282226522],
Cell[15713, 463, 87, 1, 70, "ExampleText",
 CellID->198168244],
Cell[CellGroupData[{
Cell[15825, 468, 330, 11, 70, "Input",
 CellID->33948826],
Cell[16158, 481, 392, 14, 52, "Output",
 CellID->912342467]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[16599, 501, 216, 7, 70, "ExampleSection",
 CellID->10802],
Cell[CellGroupData[{
Cell[16840, 512, 234, 7, 70, "ExampleSubsection",
 CellID->106039460],
Cell[17077, 521, 555, 22, 70, "ExampleText",
 CellID->17800827],
Cell[CellGroupData[{
Cell[17657, 547, 286, 9, 70, "Input",
 CellID->540624369],
Cell[17946, 558, 676, 30, 51, "Output",
 CellID->53757261]
}, Open  ]],
Cell[18637, 591, 330, 13, 70, "ExampleText",
 CellID->738802486],
Cell[CellGroupData[{
Cell[18992, 608, 293, 11, 70, "Input",
 CellID->55230342],
Cell[19288, 621, 510, 19, 36, "Output",
 CellID->3968078]
}, Open  ]],
Cell[19813, 643, 60, 1, 70, "ExampleText",
 CellID->75126432],
Cell[CellGroupData[{
Cell[19898, 648, 164, 5, 70, "Input",
 CellID->70178760],
Cell[20065, 655, 486, 12, 70, "Output",
 Evaluatable->False,
 CellID->56706243]
}, Open  ]],
Cell[20566, 670, 124, 3, 70, "ExampleDelimiter",
 CellID->56955154],
Cell[20693, 675, 80, 1, 70, "ExampleText",
 CellID->125904531],
Cell[CellGroupData[{
Cell[20798, 680, 214, 7, 70, "Input",
 CellID->48683404],
Cell[21015, 689, 495, 12, 70, "Output",
 Evaluatable->False,
 CellID->304358513]
}, Open  ]],
Cell[21525, 704, 73, 1, 70, "ExampleText",
 CellID->61060215],
Cell[CellGroupData[{
Cell[21623, 709, 148, 4, 70, "Input",
 CellID->49753538],
Cell[21774, 715, 238, 6, 70, "Output",
 CellID->285736890]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[22061, 727, 240, 7, 70, "ExampleSubsection",
 CellID->479371353],
Cell[22304, 736, 268, 9, 70, "ExampleText",
 CellID->388790367],
Cell[CellGroupData[{
Cell[22597, 749, 434, 14, 70, "Input",
 CellID->25296522],
Cell[23034, 765, 922, 43, 51, "Output",
 CellID->10041436]
}, Open  ]],
Cell[23971, 811, 125, 3, 70, "ExampleDelimiter",
 CellID->535271940],
Cell[24099, 816, 70, 1, 70, "ExampleText",
 CellID->39580944],
Cell[CellGroupData[{
Cell[24194, 821, 888, 28, 70, "Input",
 CellID->177296101],
Cell[25085, 851, 1667, 31, 70, "Output",
 Evaluatable->False,
 CellID->430947832]
}, Open  ]],
Cell[26767, 885, 88, 1, 70, "ExampleText",
 CellID->40094399],
Cell[CellGroupData[{
Cell[26880, 890, 1079, 32, 70, "Input",
 CellID->692214967],
Cell[27962, 924, 1666, 31, 70, "Output",
 Evaluatable->False,
 CellID->39162973]
}, Open  ]],
Cell[29643, 958, 125, 3, 70, "ExampleDelimiter",
 CellID->175584778],
Cell[29771, 963, 68, 1, 70, "ExampleText",
 CellID->75098327],
Cell[CellGroupData[{
Cell[29864, 968, 168, 5, 70, "Input",
 CellID->287661578],
Cell[30035, 975, 259, 8, 50, "Output",
 CellID->18328889]
}, Open  ]],
Cell[CellGroupData[{
Cell[30331, 988, 424, 16, 70, "Input",
 CellID->250695724],
Cell[30758, 1006, 834, 18, 70, "Output",
 Evaluatable->False,
 CellID->134625852]
}, Open  ]],
Cell[31607, 1027, 125, 3, 70, "ExampleDelimiter",
 CellID->120336310],
Cell[31735, 1032, 95, 1, 70, "ExampleText",
 CellID->289611139],
Cell[CellGroupData[{
Cell[31855, 1037, 378, 11, 70, "Input",
 CellID->231716069],
Cell[32236, 1050, 712, 16, 70, "Output",
 Evaluatable->False,
 CellID->239489487]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[32997, 1072, 241, 7, 70, "ExampleSubsection",
 CellID->250137182],
Cell[33241, 1081, 92, 1, 70, "ExampleText",
 CellID->483444329],
Cell[CellGroupData[{
Cell[33358, 1086, 244, 8, 70, "Input",
 CellID->270064825],
Cell[33605, 1096, 499, 17, 54, "Output",
 CellID->16413206]
}, Open  ]],
Cell[34119, 1116, 371, 13, 70, "ExampleText",
 CellID->18535822],
Cell[CellGroupData[{
Cell[34515, 1133, 112, 3, 70, "Input",
 CellID->49083534],
Cell[34630, 1138, 557, 18, 70, "Output",
 CellID->107670578]
}, Open  ]],
Cell[CellGroupData[{
Cell[35224, 1161, 106, 3, 70, "Input",
 CellID->152587590],
Cell[35333, 1166, 563, 19, 50, "Output",
 CellID->63814020]
}, Open  ]],
Cell[35911, 1188, 125, 3, 70, "ExampleDelimiter",
 CellID->342012676],
Cell[36039, 1193, 91, 1, 70, "ExampleText",
 CellID->65245750],
Cell[CellGroupData[{
Cell[36155, 1198, 318, 11, 70, "Input",
 CellID->470286855],
Cell[36476, 1211, 478, 17, 36, "Output",
 CellID->77826434]
}, Open  ]],
Cell[CellGroupData[{
Cell[36991, 1233, 112, 3, 70, "Input",
 CellID->191304613],
Cell[37106, 1238, 533, 18, 50, "Output",
 CellID->913683]
}, Open  ]],
Cell[37654, 1259, 226, 8, 70, "ExampleText",
 CellID->444663507],
Cell[CellGroupData[{
Cell[37905, 1271, 106, 3, 70, "Input",
 CellID->268605706],
Cell[38014, 1276, 240, 7, 50, "Output",
 CellID->405909472]
}, Open  ]],
Cell[38269, 1286, 125, 3, 70, "ExampleDelimiter",
 CellID->146903789],
Cell[38397, 1291, 126, 2, 70, "ExampleText",
 CellID->46047206],
Cell[CellGroupData[{
Cell[38548, 1297, 341, 11, 70, "Input",
 CellID->404421484],
Cell[38892, 1310, 3076, 54, 70, "Output",
 Evaluatable->False,
 CellID->346786139]
}, Open  ]],
Cell[CellGroupData[{
Cell[42005, 1369, 458, 16, 70, "Input",
 CellID->19525682],
Cell[42466, 1387, 31664, 523, 70, "Output",
 Evaluatable->False,
 CellID->53842930]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[74191, 1917, 227, 7, 70, "ExampleSection",
 CellID->323487288],
Cell[74421, 1926, 95, 1, 70, "ExampleText",
 CellID->24088741],
Cell[CellGroupData[{
Cell[74541, 1931, 332, 10, 70, "Input",
 CellID->468426064],
Cell[74876, 1943, 463, 14, 50, "Output",
 CellID->356139557]
}, Open  ]],
Cell[75354, 1960, 124, 3, 70, "ExampleDelimiter",
 CellID->53888257],
Cell[75481, 1965, 65, 1, 70, "ExampleText",
 CellID->239212472],
Cell[CellGroupData[{
Cell[75571, 1970, 410, 14, 70, "Input",
 CellID->41090091],
Cell[75984, 1986, 622, 19, 52, "Output",
 CellID->22229807]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[76655, 2011, 237, 7, 70, "ExampleSection",
 CellID->232351834],
Cell[76895, 2020, 210, 7, 70, "ExampleText",
 CellID->15763429],
Cell[CellGroupData[{
Cell[77130, 2031, 189, 6, 70, "Input",
 CellID->37175165],
Cell[77322, 2039, 299, 9, 58, "Output",
 CellID->79530781]
}, Open  ]],
Cell[77636, 2051, 231, 7, 70, "ExampleText",
 CellID->457767460],
Cell[CellGroupData[{
Cell[77892, 2062, 186, 6, 70, "Input",
 CellID->52050003],
Cell[78081, 2070, 266, 8, 58, "Output",
 CellID->289768374]
}, Open  ]],
Cell[78362, 2081, 212, 7, 70, "ExampleText",
 CellID->209201139],
Cell[CellGroupData[{
Cell[78599, 2092, 184, 6, 70, "Input",
 CellID->16589577],
Cell[78786, 2100, 215, 10, 65, "Output",
 CellID->1470021]
}, Open  ]],
Cell[79016, 2113, 343, 12, 70, "ExampleText",
 CellID->13054338],
Cell[CellGroupData[{
Cell[79384, 2129, 184, 6, 70, "Input",
 CellID->114959516],
Cell[79571, 2137, 170, 5, 50, "Output",
 CellID->344120129]
}, Open  ]],
Cell[CellGroupData[{
Cell[79778, 2147, 183, 6, 70, "Input",
 CellID->223015926],
Cell[79964, 2155, 579, 20, 50, "Output",
 CellID->427630841]
}, Open  ]],
Cell[80558, 2178, 124, 3, 70, "ExampleDelimiter",
 CellID->52763461],
Cell[80685, 2183, 269, 9, 70, "ExampleText",
 CellID->280553715],
Cell[CellGroupData[{
Cell[80979, 2196, 214, 7, 70, "Input",
 CellID->367460198],
Cell[81196, 2205, 518, 16, 36, "Output",
 CellID->116668306]
}, Open  ]],
Cell[81729, 2224, 243, 8, 70, "ExampleText",
 CellID->526181681],
Cell[CellGroupData[{
Cell[81997, 2236, 145, 4, 70, "Input",
 CellID->157868315],
Cell[82145, 2242, 225, 8, 51, "Output",
 CellID->104985926]
}, Open  ]],
Cell[82385, 2253, 125, 3, 70, "ExampleDelimiter",
 CellID->536718205],
Cell[82513, 2258, 198, 8, 70, "ExampleText",
 CellID->810203101],
Cell[CellGroupData[{
Cell[82736, 2270, 161, 5, 70, "Input",
 CellID->161343839],
Cell[82900, 2277, 257, 8, 50, "Output",
 CellID->169092792]
}, Open  ]],
Cell[83172, 2288, 365, 13, 70, "Input",
 CellID->734130829],
Cell[CellGroupData[{
Cell[83562, 2305, 160, 5, 70, "Input",
 CellID->88224750],
Cell[83725, 2312, 756, 16, 70, "Output",
 Evaluatable->False,
 CellID->450130558]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[84530, 2334, 230, 7, 70, "ExampleSection",
 CellID->147767195],
Cell[84763, 2343, 254, 7, 70, "ExampleText",
 CellID->17298791],
Cell[CellGroupData[{
Cell[85042, 2354, 203, 7, 70, "Input",
 CellID->81261506],
Cell[85248, 2363, 689, 21, 66, "Output",
 CellID->156025448]
}, Open  ]],
Cell[CellGroupData[{
Cell[85974, 2389, 166, 5, 70, "Input",
 CellID->375700736],
Cell[86143, 2396, 528, 22, 66, "Output",
 CellID->355848378]
}, Open  ]],
Cell[86686, 2421, 91, 1, 70, "ExampleText",
 CellID->958431278],
Cell[CellGroupData[{
Cell[86802, 2426, 365, 12, 70, "Input",
 CellID->302386216],
Cell[87170, 2440, 255, 11, 63, "Output",
 CellID->142016877]
}, Open  ]],
Cell[87440, 2454, 119, 3, 70, "ExampleText",
 CellID->50335871],
Cell[CellGroupData[{
Cell[87584, 2461, 416, 13, 70, "Input",
 CellID->170475121],
Cell[88003, 2476, 251, 9, 36, "Output",
 CellID->135059546]
}, Open  ]],
Cell[88269, 2488, 174, 5, 70, "ExampleText",
 CellID->758769474],
Cell[CellGroupData[{
Cell[88468, 2497, 288, 9, 70, "Input",
 CellID->328198665],
Cell[88759, 2508, 215, 7, 36, "Output",
 CellID->18492979]
}, Open  ]],
Cell[CellGroupData[{
Cell[89011, 2520, 332, 11, 70, "Input",
 CellID->479002055],
Cell[89346, 2533, 250, 9, 36, "Output",
 CellID->15467883]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[89645, 2548, 228, 7, 70, "ExampleSection",
 CellID->481490785],
Cell[89876, 2557, 56, 1, 70, "ExampleText",
 CellID->370612919],
Cell[CellGroupData[{
Cell[89957, 2562, 285, 10, 70, "Input",
 CellID->529895193],
Cell[90245, 2574, 1179, 39, 203, "Output",
 CellID->243967974]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[91485, 2620, 311, 9, 70, "SeeAlsoSection",
 CellID->31493],
Cell[91799, 2631, 1682, 62, 70, "SeeAlso",
 CellID->32146]
}, Open  ]],
Cell[CellGroupData[{
Cell[93518, 2698, 313, 9, 70, "TutorialsSection",
 CellID->3921],
Cell[93834, 2709, 157, 3, 70, "Tutorials",
 CellID->17089],
Cell[93994, 2714, 179, 4, 70, "Tutorials",
 CellID->27366],
Cell[94176, 2720, 183, 4, 70, "Tutorials",
 CellID->157498705],
Cell[94362, 2726, 189, 4, 70, "Tutorials",
 CellID->65997988]
}, Open  ]],
Cell[CellGroupData[{
Cell[94588, 2735, 319, 9, 70, "MoreAboutSection",
 CellID->377712759],
Cell[94910, 2746, 129, 3, 70, "MoreAbout",
 CellID->650841053],
Cell[95042, 2751, 151, 3, 70, "MoreAbout",
 CellID->1354457],
Cell[95196, 2756, 193, 4, 70, "MoreAbout",
 CellID->509989182],
Cell[95392, 2762, 159, 3, 70, "MoreAbout",
 CellID->337836689]
}, Open  ]],
Cell[95566, 2768, 50, 0, 70, "History"],
Cell[95619, 2770, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

