(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     23160,        820]
NotebookOptionsPosition[     18426,        659]
NotebookOutlinePosition[     19828,        698]
CellTagsIndexPosition[     19743,        693]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"GeometricTransformation" :> 
          Documentation`HelpLookup["paclet:ref/GeometricTransformation"], 
          "AffineTransform" :> 
          Documentation`HelpLookup["paclet:ref/AffineTransform"], 
          "LinearFractionalTransform" :> 
          Documentation`HelpLookup[
           "paclet:ref/LinearFractionalTransform"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"GeometricTransformation\"\>", 
       2->"\<\"AffineTransform\"\>", 
       3->"\<\"LinearFractionalTransform\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Computational Geometry" :> 
          Documentation`HelpLookup["paclet:guide/ComputationalGeometry"], 
          "Geometric Transforms" :> 
          Documentation`HelpLookup["paclet:guide/GeometricTransforms"], 
          "New in 6.0: Mathematics & Algorithms" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60MathematicsAndAlgorithms"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Computational Geometry\"\>", 
       2->"\<\"Geometric Transforms\"\>", 
       3->"\<\"New in 6.0: Mathematics & Algorithms\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["TransformationMatrix", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["TransformationMatrix",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/TransformationMatrix"], "[", 
       StyleBox["tfun", "TI"], "]"}]], "InlineFormula"],
     " \[LineSeparator]gives the homogeneous matrix associated with a ",
     Cell[BoxData[
      ButtonBox["TransformationFunction",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/TransformationFunction"]], "InlineFormula"],
     " object."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "For transformations in ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " dimensions, ",
 Cell[BoxData[
  ButtonBox["TransformationMatrix",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TransformationMatrix"]], "InlineFormula"],
 " normally gives an ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{"n", "+", "1"}], ")"}], "\[Times]", 
    RowBox[{"(", 
     RowBox[{"n", "+", "1"}], ")"}]}], TraditionalForm]], "InlineMath"],
 " matrix."
}], "Notes",
 CellID->104185215],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   StyleBox["mat", "TI"], "[", 
   RowBox[{"[", 
    RowBox[{
     RowBox[{"1", ";;", 
      StyleBox["n", "TI"]}], ",", 
     RowBox[{"1", ";;", 
      StyleBox["n", "TI"]}]}], "]"}], "]"}]], "InlineFormula"],
 " gives the linear part of the transformation; ",
 Cell[BoxData[
  RowBox[{
   StyleBox["mat", "TI"], "[", 
   RowBox[{"[", 
    RowBox[{
     RowBox[{"1", ";;", 
      StyleBox["n", "TI"]}], ",", 
     RowBox[{"-", "1"}]}], "]"}], "]"}]], "InlineFormula"],
 " gives the displacement vector."
}], "Notes",
 CellID->381899861]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->41925859],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->129515605],

Cell[TextData[{
 "Here ",
 Cell[BoxData[
  StyleBox["t", "TI"]], "InlineFormula"],
 " is defined to be a rotation around the ",
 Cell[BoxData[
  StyleBox["z", "TI"]], "InlineFormula"],
 " axis:"
}], "ExampleText",
 CellID->112033164],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"t", "=", 
  RowBox[{"RotationTransform", "[", 
   RowBox[{"\[Theta]", ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->564407265],

Cell[BoxData[
 RowBox[{"TransformationFunction", "[", 
  RowBox[{"(", GridBox[{
     {
      RowBox[{"Cos", "[", "\[Theta]", "]"}], 
      RowBox[{"-", 
       RowBox[{"Sin", "[", "\[Theta]", "]"}]}], "0", "0"},
     {
      RowBox[{"Sin", "[", "\[Theta]", "]"}], 
      RowBox[{"Cos", "[", "\[Theta]", "]"}], "0", "0"},
     {"0", "0", "1", "0"},
     {"0", "0", "0", "1"}
    },
    GridBoxDividers->{
     "ColumnsIndexed" -> {-2 -> True}, "RowsIndexed" -> {-2 -> True}}], ")"}],
   "]"}]], "Output",
 ImageSize->{323, 59},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->573778621]
}, Open  ]],

Cell["Get the transformation matrix: ", "ExampleText",
 CellID->22013913],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"m", "=", 
  RowBox[{"TransformationMatrix", "[", "t", "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->149935127],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Cos", "[", "\[Theta]", "]"}], ",", 
     RowBox[{"-", 
      RowBox[{"Sin", "[", "\[Theta]", "]"}]}], ",", "0", ",", "0"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Sin", "[", "\[Theta]", "]"}], ",", 
     RowBox[{"Cos", "[", "\[Theta]", "]"}], ",", "0", ",", "0"}], "}"}], ",", 
   
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "1", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "1"}], "}"}]}], "}"}]], "Output",
 ImageSize->{502, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->7567181]
}, Open  ]],

Cell["The linear part: ", "ExampleText",
 CellID->535529326],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"m", "[", 
  RowBox[{"[", 
   RowBox[{
    RowBox[{"1", ";;", "3"}], ",", 
    RowBox[{"1", ";;", "3"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->175602828],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Cos", "[", "\[Theta]", "]"}], ",", 
     RowBox[{"-", 
      RowBox[{"Sin", "[", "\[Theta]", "]"}]}], ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Sin", "[", "\[Theta]", "]"}], ",", 
     RowBox[{"Cos", "[", "\[Theta]", "]"}], ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "}"}]], "Output",
 ImageSize->{361, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->221439127]
}, Open  ]],

Cell["The displacement vector:", "ExampleText",
 CellID->305750595],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"m", "[", 
  RowBox[{"[", 
   RowBox[{
    RowBox[{"1", ";;", "3"}], ",", 
    RowBox[{"-", "1"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->434968718],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "0", ",", "0"}], "}"}]], "Output",
 ImageSize->{62, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->170216040]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->115370638],

Cell["Translation matrix in four dimensions:", "ExampleText",
 CellID->278192084],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"m", "=", 
    RowBox[{"TransformationMatrix", "@", 
     RowBox[{"TranslationTransform", "[", 
      RowBox[{"{", 
       RowBox[{"x0", ",", "y0", ",", "z0", ",", "w0"}], "}"}], "]"}]}]}], 
   ")"}], "//", "MatrixForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->513541998],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"1", "0", "0", "0", "x0"},
     {"0", "1", "0", "0", "y0"},
     {"0", "0", "1", "0", "z0"},
     {"0", "0", "0", "1", "w0"},
     {"0", "0", "0", "0", "1"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$, BoxForm`opts$171542]]]], "Output",
 ImageSize->{98, 73},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//MatrixForm=",
 CellID->30049393]
}, Open  ]],

Cell["Transformation of homogenous coordinates:", "ExampleText",
 CellID->646716738],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"m", ".", 
  RowBox[{"{", 
   RowBox[{"x", ",", "y", ",", "z", ",", "w", ",", "1"}], "}"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->58462694],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"x", "+", "x0"}], ",", 
   RowBox[{"y", "+", "y0"}], ",", 
   RowBox[{"z", "+", "z0"}], ",", 
   RowBox[{"w", "+", "w0"}], ",", "1"}], "}"}]], "Output",
 ImageSize->{205, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->16769700]
}, Open  ]],

Cell["Points at infinity do not change under translation:", "ExampleText",
 CellID->658226343],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"m", ".", 
  RowBox[{"{", 
   RowBox[{"x", ",", "y", ",", "z", ",", "w", ",", "0"}], "}"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->37203611],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", ",", "y", ",", "z", ",", "w", ",", "0"}], "}"}]], "Output",
 ImageSize->{98, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->342890985]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->729400319],

Cell["The matrix of a general 2D affine transform:", "ExampleText",
 CellID->253281473],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"TransformationMatrix", "@", 
   RowBox[{"AffineTransform", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Array", "[", 
       RowBox[{"a", ",", 
        RowBox[{"{", 
         RowBox[{"2", ",", "2"}], "}"}]}], "]"}], ",", 
      RowBox[{"Array", "[", 
       RowBox[{"b", ",", "2"}], "]"}]}], "}"}], "]"}]}], "//", 
  "MatrixForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->586558923],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{"a", "[", 
       RowBox[{"1", ",", "1"}], "]"}], 
      RowBox[{"a", "[", 
       RowBox[{"1", ",", "2"}], "]"}], 
      RowBox[{"b", "[", "1", "]"}]},
     {
      RowBox[{"a", "[", 
       RowBox[{"2", ",", "1"}], "]"}], 
      RowBox[{"a", "[", 
       RowBox[{"2", ",", "2"}], "]"}], 
      RowBox[{"b", "[", "2", "]"}]},
     {"0", "0", "1"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$, BoxForm`opts$171613]]]], "Output",
 ImageSize->{162, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//MatrixForm=",
 CellID->452470346]
}, Open  ]],

Cell["\<\
Composition of linear fractional transformations corresponds to the product \
of their matrices:\
\>", "ExampleText",
 CellID->99813733],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"t1", ",", "t2"}], "}"}], "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"LinearFractionalTransform", "[", 
      RowBox[{"Array", "[", 
       RowBox[{"a1", ",", 
        RowBox[{"{", 
         RowBox[{"3", ",", "3"}], "}"}]}], "]"}], "]"}], ",", 
     RowBox[{"LinearFractionalTransform", "[", 
      RowBox[{"Array", "[", 
       RowBox[{"a2", ",", 
        RowBox[{"{", 
         RowBox[{"3", ",", "3"}], "}"}]}], "]"}], "]"}]}], "}"}]}], 
  ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->5999190],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"TransformationMatrix", "[", 
   RowBox[{"Composition", "[", 
    RowBox[{"t1", ",", "t2"}], "]"}], "]"}], "\[Equal]", 
  RowBox[{
   RowBox[{"TransformationMatrix", "[", "t1", "]"}], ".", 
   RowBox[{"TransformationMatrix", "[", "t2", "]"}]}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->459112027],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->82993717]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["GeometricTransformation",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/GeometricTransformation"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["AffineTransform",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/AffineTransform"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["LinearFractionalTransform",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LinearFractionalTransform"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->30291099],

Cell[TextData[ButtonBox["Computational Geometry",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ComputationalGeometry"]], "MoreAbout",
 CellID->25837840],

Cell[TextData[ButtonBox["Geometric Transforms",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GeometricTransforms"]], "MoreAbout",
 CellID->6641080],

Cell[TextData[ButtonBox["New in 6.0: Mathematics & Algorithms",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60MathematicsAndAlgorithms"]], "MoreAbout",
 CellID->170133114]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"TransformationMatrix - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 27, 36.8338434}", "context" -> "System`", 
    "keywords" -> {
     "affine transform", "geometric transformation", "homogenous coordinates",
       "linear transformation"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "TransformationMatrix[tfun] gives the homogeneous matrix associated with \
a TransformationFunction object.", "synonyms" -> {"transformation matrix"}, 
    "title" -> "TransformationMatrix", "type" -> "Symbol", "uri" -> 
    "ref/TransformationMatrix"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6447, 199, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->41925859]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 19601, 686}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1874, 44, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2497, 71, 1585, 37, 70, "ObjectNameGrid"],
Cell[4085, 110, 701, 20, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[4823, 135, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5301, 152, 527, 19, 70, "Notes",
 CellID->104185215],
Cell[5831, 173, 579, 21, 70, "Notes",
 CellID->381899861]
}, Closed]],
Cell[CellGroupData[{
Cell[6447, 199, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->41925859],
Cell[CellGroupData[{
Cell[6831, 213, 148, 5, 70, "ExampleSection",
 CellID->129515605],
Cell[6982, 220, 233, 9, 70, "ExampleText",
 CellID->112033164],
Cell[CellGroupData[{
Cell[7240, 233, 228, 7, 28, "Input",
 CellID->564407265],
Cell[7471, 242, 634, 20, 80, "Output",
 CellID->573778621]
}, Open  ]],
Cell[8120, 265, 73, 1, 70, "ExampleText",
 CellID->22013913],
Cell[CellGroupData[{
Cell[8218, 270, 139, 4, 70, "Input",
 CellID->149935127],
Cell[8360, 276, 688, 22, 36, "Output",
 CellID->7567181]
}, Open  ]],
Cell[9063, 301, 60, 1, 70, "ExampleText",
 CellID->535529326],
Cell[CellGroupData[{
Cell[9148, 306, 196, 7, 70, "Input",
 CellID->175602828],
Cell[9347, 315, 573, 18, 36, "Output",
 CellID->221439127]
}, Open  ]],
Cell[9935, 336, 67, 1, 70, "ExampleText",
 CellID->305750595],
Cell[CellGroupData[{
Cell[10027, 341, 190, 7, 70, "Input",
 CellID->434968718],
Cell[10220, 350, 213, 7, 36, "Output",
 CellID->170216040]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[10482, 363, 220, 7, 70, "ExampleSection",
 CellID->115370638],
Cell[10705, 372, 81, 1, 70, "ExampleText",
 CellID->278192084],
Cell[CellGroupData[{
Cell[10811, 377, 326, 10, 70, "Input",
 CellID->513541998],
Cell[11140, 389, 875, 25, 108, "Output",
 CellID->30049393]
}, Open  ]],
Cell[12030, 417, 84, 1, 70, "ExampleText",
 CellID->646716738],
Cell[CellGroupData[{
Cell[12139, 422, 168, 5, 70, "Input",
 CellID->58462694],
Cell[12310, 429, 333, 11, 36, "Output",
 CellID->16769700]
}, Open  ]],
Cell[12658, 443, 94, 1, 70, "ExampleText",
 CellID->658226343],
Cell[CellGroupData[{
Cell[12777, 448, 168, 5, 70, "Input",
 CellID->37203611],
Cell[12948, 455, 233, 7, 36, "Output",
 CellID->342890985]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[13230, 468, 237, 7, 70, "ExampleSection",
 CellID->729400319],
Cell[13470, 477, 87, 1, 70, "ExampleText",
 CellID->253281473],
Cell[CellGroupData[{
Cell[13582, 482, 428, 14, 70, "Input",
 CellID->586558923],
Cell[14013, 498, 1083, 33, 78, "Output",
 CellID->452470346]
}, Open  ]],
Cell[15111, 534, 146, 4, 70, "ExampleText",
 CellID->99813733],
Cell[15260, 540, 569, 19, 70, "Input",
 CellID->5999190],
Cell[CellGroupData[{
Cell[15854, 563, 333, 9, 70, "Input",
 CellID->459112027],
Cell[16190, 574, 160, 5, 36, "Output",
 CellID->82993717]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[16411, 586, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[16730, 597, 778, 26, 70, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[17545, 628, 318, 9, 70, "MoreAboutSection",
 CellID->30291099],
Cell[17866, 639, 154, 3, 70, "MoreAbout",
 CellID->25837840],
Cell[18023, 644, 149, 3, 70, "MoreAbout",
 CellID->6641080],
Cell[18175, 649, 179, 3, 70, "MoreAbout",
 CellID->170133114]
}, Open  ]],
Cell[18369, 655, 27, 0, 70, "History"],
Cell[18399, 657, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

