(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    533328,      14346]
NotebookOptionsPosition[    518418,      13833]
NotebookOutlinePosition[    519872,      13873]
CellTagsIndexPosition[    519784,      13868]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Expressions as Trees" :> 
          Documentation`HelpLookup["paclet:tutorial/ExpressionsAsTrees"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Expressions as Trees\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"FullForm" :> Documentation`HelpLookup["paclet:ref/FullForm"], 
          "MatrixForm" :> Documentation`HelpLookup["paclet:ref/MatrixForm"], 
          "TreePlot" :> Documentation`HelpLookup["paclet:ref/TreePlot"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"FullForm\"\>", 
       2->"\<\"MatrixForm\"\>", 3->"\<\"TreePlot\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Expressions" :> 
          Documentation`HelpLookup["paclet:guide/Expressions"], 
          "Expression Structure" :> 
          Documentation`HelpLookup["paclet:guide/ExpressionStructure"], 
          "New in 6.0: Core Language" :> 
          Documentation`HelpLookup["paclet:guide/NewIn60CoreLanguage"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Expressions\"\>", 
       2->"\<\"Expression Structure\"\>", 
       3->"\<\"New in 6.0: Core Language\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["TreeForm", "ObjectName"], Cell[BoxData[
     TooltipBox[
      TogglerBox[Dynamic[
        FrontEnd`CurrentValue[
         FrontEnd`EvaluationNotebook[], {
         TaggingRules, "ModificationHighlight"}]], {True->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVVly2zAMDQhxEylSsizLaxJn73KafvQAuUDv/1eApJuosceeTDAWF4B8
eFgk71///HoVV1dXK3p+0wNfIzdCLL4I6p1sYBYuPy3SI2AmRBpuaE/TPRsE
3Isg8mrB9l6ILQhhLkbd93MBuwVxAthdZwPr5wVVzBc8wAvMX8TFqPkqE8q6
rDCsKPjZ/g1guz+PKvLFfGsDU1R4A8zDhgLangX9x/WGM7A1qSQ7rraYkaLf
LHZ5FWY9H7rew/n4/6vWPKT2mXFBaH/NGejzqi/VnFEFJ2Rb1Lo+jtofllPD
RVJjdZLr51Eb/ED1K+QI109LcIg+sdSIWqa5g85L6MiNoRloTws+pdBKiFGl
mx3N0jcAlcsKeFivVkteVOgMSNsC18sYS/iIMdZoK43WSdQVK1SLlYy09bZ2
aEO+aoPiACNak0EBbtfLRIz9KJRcroaSKwE11BprpRHqiJ0BrxtJG4pLYqWc
RZO4BQwSbGT4rFivaLjjQdscjSvlih48Mu+WDisOBcB5ehgeDEZQlikkKh3b
KA1FMTDg9yFxLSe4XC37begHTDh5seS1I/gaW025Yo/yUFbmSalShzon1Kch
JTNn2hKS1hyWVIkf5n2LHEQgt0zeUNTkMaYrDdkMZdo3fJCDHx7hxzAC+8rs
XYBokTPfEJk6JVlZx3Yl0UnTYMPvSUt6zghf8dhIi5VDnwO+Hcb1MHK1msK+
oy5qkYS7wVC3cfiq8ojBcMtFMJXnDiIcLPFJClDFGkJBhXGEZV6VcCQFoey7
tyvBF6lw0uKH6nyQ5fqhrKx/Kxe8+3coucpGN4U5+RYux7vnhGO5P7hKenqz
xSO3ivjisf345fg5Pt1ScCRkkzR1U1Dur+NCec4LZ49Ynx9P04GmOvlnqcKZ
79BfJfcjkg==
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlLlKQ0EYRi/iA9gpWIgvIXbjM1iKWAjW2vgeZnWN+AgWZhEULCxELFyi
ZnfJavbeJOr/33xXcj8CNnY5EA7k3GWYmTuzq+uLa2OWZS38/MYt0DbDHH8Q
8uTB64bRNrmsQkaPRoQSGX1ZqZPR9/eEazL6klIlowf8wiUZ3ecV3snowYDw
SEafUmJk9HmlQh4cX4GM7vUId2T0VFIho28or2T0w5DQIKN3PoUaGX1FaZLR
0ymh6sz7hHLk9PMzoU5Gz6SFmvFsCbd9Xzj9qyc0nfe49xfuTyYUEzoQbmh8
+N8e37HTbVpk9MSzUCajbypFMvq0UiOjzyklMnqvKzRMJCwU+/vjzemTSpns
nh97feJmd0e4cvppTKiQ0bsdoW5ecorZDgpPtD6xqFA2fp+Qp/vtdUj1v797
Oqdwnb2Ov++fUVpk9PCJUCC7n4t5wz5xj9/+rj6ceXbPP86NbEb58/k56qP+
n/0bdGyYqQ==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}], False->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVdd22zAMDUBxSaJm5HgljrPTJN177/nWh35AfqD//1aAVGrrJLbbk+BI
FEmQFxcXlDQ9//3zHNfW1gZ0/6IbbsYOhahvCGrO9qHM/mnhmMMLoKv0RD6V
cPyZHTTcDI5NkYnQq4UQ0BdiAkKYZagl1OOw5fWtcgyvPp7AnefsGG0DBIeA
9RZVrNfcwBasb4nlbP9u4cbc/XD/zXcIgC2qYYazJTQiGSYHS0Hr8Yu5LV/h
ePvR5oMOKswAQ0M8R5OloFMWSNRE+IAVeALv38KX26wAV1uU5Ojv16PQy8q+
gMP+9ABW5C9KbkZi6qv19DGc/ID9b+CrZTjbbVagH3p91oIcL+GZ6JDNUet4
HpWUXxx5BaWZxRh1FQgH6JqoKcarF/2/dblez7IE0XmWGlFL/6ygchIqCmPo
CTSmDq9SaCUUhfI7K3pKlwJESZiAveHGxoA7ESYGpM2B62WMJXzEoojRRhpt
IlFHPKFyjGRBQ2fjBG0WttpMcYIFWhNAAXaHA0+M4yiUXK6UxJWAGmKNsdII
cYGVAadTSQPKS2KkEovGc8swk2ALhg8Tww1qdrjRNmSTtOUqHDhk3jktVpwK
QOLoZngwWICyTMFTqdhHMrQTDQPeazzXdgWXK+e4KV3AhH0US1Ergo8x16QV
R5QXZWWeJJW6qLNHPWq8mEFpS0hac1pSeX4YxjlyEhmFZfKGsqaIhd+Sks+Q
0i7lhZx8cwYPmx5wrMA+yaCwyMqnRCb2IiubsF9JTKRJMeX3JKd5VoS3OEyl
xShBFxLebXrDpsfVSlv2FZ2iHMn4NBg6bZy+ihxiZvjIFWAixyeIcLDNT1KC
qogha1Gh14NB6LXpSEpC2bm3y8O3FmHniF9U55INhnttz7pZuWDu79BqFZxJ
F2bhWzjo7Zx6HMvng6ukuztzvGJXa66NmF/+crzrHe1ScmTkk/SouqB8vq42
0jl0EnuF9/RsMR1Io4U/S5Wt+A79AaDyK/w=
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlUtrE1EYhgfxBwguFBTEvyAiFhfzHxRFvC0E17rQhYLiT7D3u/gTXNg2
3sBFFyIutE1qm17UZJKZZJK0KFjBtur7Td4jnhe7dTMPhAfyQObMnO9Mjl69
fvraniAI7v/+7A3IRri7/8VGWJwHVTH72qohZp+ZBnUx+yWjJWYfHwNvxOwX
jKaYfXAAzIrZ+/tARcw+NAhKYvaTRiJmP2gUxH+vLxKzl5cMMXtfL3gvZn84
Cdpi9hvGJzH7yxegJWa/YnTE7Mtl0HTPfZ/xyPWVZZCGvQ/Au65fSV9aNMLJ
CfDW9a0fIBWz/9wBHbcOf/74PX83W99j128ZNTH71BMQidmfFkAiZj9irIvZ
Fz+AWMx+yEjF7KeMVOw/32x/iuHoCHjt+s42aIfTU6DWna/Prm9vgVb4cc0I
h4fAgusZ62L2A0YsZj9h1MX+9bN9LHfP75zrZ42a2L9/3+wXjVTM7q8jm9NE
5q8wA+JwoB/8eX+eNxIx+00jErP3GA2xvy7uG88R+z2jI2Y/bLTE/v1l76WG
mxP/+r7ZN7+Bupj9mFERsz9/Bppi9myeEzH7QgnUxOy3jYaY/a7RFrNfNtpi
9nNGXcw+NgoaYnbOk2///PJ/bXXFcP37JojF7CPDIBazf/0CKmL2+TlQEbPf
MZpi9olxkIrZS0UQidn3G1Ux+3EjErOfMapi9mBX8p73vOc973n/P/0XnFJ2
Rg==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}]}, "\"\<Click me\>\""],
      "Toggle changes in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["TreeForm",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/TreeForm"], "[", 
       StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]displays ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " as a tree with different levels at different depths. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["TreeForm",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/TreeForm"], "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        StyleBox["n", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]displays ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " as a tree only down to level ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->17059]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "With a notebook front end, ",
 Cell[BoxData[
  ButtonBox["TreeForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TreeForm"]], "InlineFormula"],
 " displays as a graphical tree in ",
 Cell[BoxData[
  ButtonBox["StandardForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StandardForm"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 ". "
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->294977217],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TreeForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TreeForm"]], "InlineFormula"],
 " takes the same options as ",
 Cell[BoxData[
  ButtonBox["TreePlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TreePlot"]], "InlineFormula"],
 ". "
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->158651114],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["VertexLabeling",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/VertexLabeling"], "->", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 " does not display expression fragments at each node, but still gives \
subtree expression as tooltips."
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->170992120],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["VertexLabeling",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/VertexLabeling"], "->", 
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"]}]], "InlineFormula"],
 " does not give expression fragments or tooltips."
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->591815289]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->63645683],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->298189733],

Cell["A symbolic expression formatted as a tree:", "ExampleText",
 CellID->246152652],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TreeForm", "[", 
  RowBox[{"a", "+", 
   RowBox[{"b", "^", "2"}], "+", 
   RowBox[{"c", "^", "3"}], "+", "d"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->18318],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{1.2977713690461004`, 1.2977713690461004`}, {0., 
    0.6488856845230502}, {0.6488856845230502, 0.6488856845230502}, {
    0.3244428422615251, 0.}, {0.9733285267845753, 0.}, {1.9466570535691505`, 
    0.6488856845230502}, {1.6222142113076254`, 0.}, {2.271099895830676, 0.}, {
    2.5955427380922007`, 0.6488856845230502}}, {
     {RGBColor[0.55, 0.45, 0.45], 
      LineBox[{{1, 2}, {1, 3}, {1, 6}, {1, 9}, {3, 4}, {3, 5}, {6, 7}, {6, 
       8}}]}, {
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["Plus", "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.05],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 1],
        TagBox[
         RowBox[{"a", "+", 
           SuperscriptBox["b", "2"], "+", 
           SuperscriptBox["c", "3"], "+", "d"}], HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`a + $CellContext`b^2 + $CellContext`c^3 + \
$CellContext`d], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           TagBox["a",
            HoldForm], "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.05],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 2],
        TagBox["a", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`a], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["Power", "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.05],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 3],
        TagBox[
         SuperscriptBox["b", "2"], HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`b^2], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           TagBox["b",
            HoldForm], "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.05],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 4],
        TagBox["b", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`b], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           TagBox["2",
            HoldForm], "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.05],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 5],
        TagBox["2", HoldForm]],
       Annotation[#, 
        HoldForm[2], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["Power", "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.05],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 6],
        TagBox[
         SuperscriptBox["c", "3"], HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`c^3], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           TagBox["c",
            HoldForm], "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.05],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 7],
        TagBox["c", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`c], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           TagBox["3",
            HoldForm], "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.05],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 8],
        TagBox["3", HoldForm]],
       Annotation[#, 
        HoldForm[3], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           TagBox["d",
            HoldForm], "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.05],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 9],
        TagBox["d", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`d], "Tooltip"]& ]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{1.2977713690461004`, 1.2977713690461004`}, {0.,
      0.6488856845230502}, {0.6488856845230502, 0.6488856845230502}, {
     0.3244428422615251, 0.}, {0.9733285267845753, 0.}, {1.9466570535691505`, 
     0.6488856845230502}, {1.6222142113076254`, 0.}, {2.271099895830676, 
     0.}, {2.5955427380922007`, 0.6488856845230502}}]& ],
  AspectRatio->NCache[2^Rational[-1, 2], 0.7071067811865475],
  FrameTicks->Automatic,
  ImageMargins->0.,
  ImageSize->{260., Automatic},
  PlotRange->All,
  PlotRangePadding->Automatic]], "Output",
 ImageSize->{264, 193},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TreeForm=",
 CellID->34337635]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->596618447],

Cell["\<\
Show the tree form for the first two levels in the expression: \
\>", "ExampleText",
 CellID->449678417],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"p", "=", 
  RowBox[{"HornerForm", "[", 
   RowBox[{
    RowBox[{"1", "+", "x", "+", 
     RowBox[{"x", "^", "2"}], "+", 
     RowBox[{"x", "^", "3"}]}], ",", "x"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->348396419],

Cell[BoxData[
 RowBox[{"1", "+", 
  RowBox[{"x", " ", 
   RowBox[{"(", 
    RowBox[{"1", "+", 
     RowBox[{"x", " ", 
      RowBox[{"(", 
       RowBox[{"1", "+", "x"}], ")"}]}]}], ")"}]}]}]], "Output",
 ImageSize->{118, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->791236011]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TreeForm", "[", 
  RowBox[{"p", ",", "2"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->34833319],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{0.4472135954999579, 1.7888543819998317`}, {0., 
    0.8944271909999159}, {0.8944271909999159, 0.8944271909999159}, {
    0.4472135954999579, 0.}, {1.3416407864998738`, 0.}}, {
     {RGBColor[0.55, 0.45, 0.45], 
      LineBox[{{1, 2}, {1, 3}, {3, 4}, {3, 5}}]}, {
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["Plus", "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.05],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 1],
        TagBox[
         RowBox[{"1", "+", 
           RowBox[{"x", " ", 
             RowBox[{"(", 
               RowBox[{"1", "+", 
                 RowBox[{"x", " ", 
                   RowBox[{"(", 
                    RowBox[{"1", "+", "x"}], ")"}]}]}], ")"}]}]}], HoldForm]],
       
       Annotation[#, 
        HoldForm[
        1 + $CellContext`x (1 + $CellContext`x (1 + $CellContext`x))], 
        "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           TagBox["1",
            HoldForm], "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.05],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 2],
        TagBox["1", HoldForm]],
       Annotation[#, 
        HoldForm[1], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["Times", "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.05],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 3],
        TagBox[
         RowBox[{"x", " ", 
           RowBox[{"(", 
             RowBox[{"1", "+", 
               RowBox[{"x", " ", 
                 RowBox[{"(", 
                   RowBox[{"1", "+", "x"}], ")"}]}]}], ")"}]}], HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x (1 + $CellContext`x (1 + $CellContext`x))], 
        "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           TagBox["x",
            HoldForm], "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.05],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 4],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           TagBox[
            RowBox[{
             RowBox[{"x", " ", 
              RowBox[{"(", 
               RowBox[{"x", "+", "1"}], ")"}]}], "+", "1"}],
            HoldForm], "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.05],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 5],
        TagBox[
         RowBox[{"1", "+", 
           RowBox[{"x", " ", 
             RowBox[{"(", 
               RowBox[{"1", "+", "x"}], ")"}]}]}], HoldForm]],
       Annotation[#, 
        HoldForm[1 + $CellContext`x (1 + $CellContext`x)], "Tooltip"]& ]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{0.4472135954999579, 1.7888543819998317`}, {0., 
     0.8944271909999159}, {0.8944271909999159, 0.8944271909999159}, {
     0.4472135954999579, 0.}, {1.3416407864998738`, 0.}}]& ],
  AspectRatio->NCache[Rational[3, 7]^Rational[1, 2], 0.6546536707079771],
  FrameTicks->Automatic,
  ImageSize->{253., Automatic},
  PlotRange->All,
  PlotRangePadding->Automatic]], "Output",
 ImageSize->{257, 128},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//TreeForm=",
 CellID->4722622]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->76161427],

Cell["A graphics expression formatted as a tree: ", "ExampleText",
 CellID->55864031],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  GraphicsBox[{
    {RGBColor[1, 0, 0], DiskBox[{0, 0}]}, 
    {RGBColor[0, 0, 1], 
     RectangleBox[NCache[{Rational[1, 2], Rational[1, 2]}, {0.5, 0.5}], 
      NCache[{Rational[1, 2], Rational[1, 2]}, {0.5, 0.5}]]}},
   ImageSize->{76., Automatic}], "//", "TreeForm"}]], "Input",
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"In[1]:=",
 CellID->309106279],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{2.9251218826177166`, 3.9001625101569553`}, {
    2.9251218826177166`, 3.250135425130796}, {1.3000541700523183`, 
    2.600108340104637}, {0.6500270850261591, 1.9500812550784776`}, {0., 
    1.3000541700523187`}, {0.6500270850261591, 1.3000541700523187`}, {
    1.3000541700523183`, 1.3000541700523187`}, {1.9500812550784776`, 
    1.9500812550784776`}, {1.9500812550784776`, 1.3000541700523187`}, {
    1.625067712565398, 0.6500270850261591}, {2.275094797591557, 
    0.6500270850261591}, {4.550189595183114, 2.600108340104637}, {
    3.250135425130796, 1.9500812550784776`}, {2.6001083401046365`, 
    1.3000541700523187`}, {3.250135425130796, 1.3000541700523187`}, {
    3.9001625101569553`, 1.3000541700523187`}, {5.850243765235433, 
    1.9500812550784776`}, {4.550189595183114, 1.3000541700523187`}, {
    3.9001625101569553`, 0.6500270850261591}, {3.5751489676438757`, 0.}, {
    4.225176052670035, 0.}, {5.200216680209273, 0.6500270850261591}, {
    4.875203137696194, 0.}, {5.525230222722353, 0.}, {7.150297935287751, 
    1.3000541700523187`}, {6.500270850261592, 0.6500270850261591}, {
    6.175257307748512, 0.}, {6.825284392774671, 0.}, {7.8003250203139105`, 
    0.6500270850261591}, {7.4753114778008305`, 0.}, {8.12533856282699, 
    0.}}, {
     {RGBColor[0.55, 0.45, 0.45], 
      LineBox[{{1, 2}, {2, 3}, {2, 12}, {3, 4}, {3, 8}, {4, 5}, {4, 6}, {4, 
       7}, {8, 9}, {9, 10}, {9, 11}, {12, 13}, {12, 17}, {13, 14}, {13, 15}, {
       13, 16}, {17, 18}, {17, 25}, {18, 19}, {18, 22}, {19, 20}, {19, 21}, {
       22, 23}, {22, 24}, {25, 26}, {25, 29}, {26, 27}, {26, 28}, {29, 30}, {
       29, 31}}]}, {
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["Graphics", "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.023529411764705882`],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 1],
        TagBox[
         GraphicsBox[{{
            RGBColor[1, 0, 0], 
            DiskBox[{0, 0}]}, {
            RGBColor[0, 0, 1], 
            RectangleBox[
             NCache[{
               Rational[1, 2], 
               Rational[1, 2]}, {0.5, 0.5}], 
             NCache[{
               Rational[1, 2], 
               Rational[1, 2]}, {0.5, 0.5}]]}}], HoldForm]],
       Annotation[#, 
        HoldForm[
         Graphics[{{
            RGBColor[1, 0, 0], 
            Disk[{0, 0}]}, {
            RGBColor[0, 0, 1], 
            Rectangle[{
              Rational[1, 2], 
              Rational[1, 2]}, {
              Rational[1, 2], 
              Rational[1, 2]}]}}]], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["List", "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.023529411764705882`],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 2],
        TagBox[
         RowBox[{"{", 
           RowBox[{
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"RGBColor", "[", 
                   RowBox[{"1", ",", "0", ",", "0"}], "]"}], ",", 
                 RowBox[{"Disk", "[", 
                   RowBox[{"{", 
                    RowBox[{"0", ",", "0"}], "}"}], "]"}]}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"RGBColor", "[", 
                   RowBox[{"0", ",", "0", ",", "1"}], "]"}], ",", 
                 RowBox[{"Rectangle", "[", 
                   RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    FractionBox["1", "2"], ",", 
                    FractionBox["1", "2"]}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    FractionBox["1", "2"], ",", 
                    FractionBox["1", "2"]}], "}"}]}], "]"}]}], "}"}]}], "}"}],
          HoldForm]],
       Annotation[#, 
        HoldForm[{{
           RGBColor[1, 0, 0], 
           Disk[{0, 0}]}, {
           RGBColor[0, 0, 1], 
           Rectangle[{
             Rational[1, 2], 
             Rational[1, 2]}, {
             Rational[1, 2], 
             Rational[1, 2]}]}}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["List", "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.023529411764705882`],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 3],
        TagBox[
         RowBox[{"{", 
           RowBox[{
             RowBox[{"RGBColor", "[", 
               RowBox[{"1", ",", "0", ",", "0"}], "]"}], ",", 
             RowBox[{"Disk", "[", 
               RowBox[{"{", 
                 RowBox[{"0", ",", "0"}], "}"}], "]"}]}], "}"}], HoldForm]],
       Annotation[#, 
        HoldForm[{
          RGBColor[1, 0, 0], 
          Disk[{0, 0}]}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["RGBColor", "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.023529411764705882`],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 4],
        TagBox[
         RowBox[{"RGBColor", "[", 
           RowBox[{"1", ",", "0", ",", "0"}], "]"}], HoldForm]],
       Annotation[#, 
        HoldForm[
         RGBColor[1, 0, 0]], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           TagBox["1",
            HoldForm], "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.023529411764705882`],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 5],
        TagBox["1", HoldForm]],
       Annotation[#, 
        HoldForm[1], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           TagBox["0",
            HoldForm], "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.023529411764705882`],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 6],
        TagBox["0", HoldForm]],
       Annotation[#, 
        HoldForm[0], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           TagBox["0",
            HoldForm], "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.023529411764705882`],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 7],
        TagBox["0", HoldForm]],
       Annotation[#, 
        HoldForm[0], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["Disk", "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.023529411764705882`],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 8],
        TagBox[
         RowBox[{"Disk", "[", 
           RowBox[{"{", 
             RowBox[{"0", ",", "0"}], "}"}], "]"}], HoldForm]],
       Annotation[#, 
        HoldForm[
         Disk[{0, 0}]], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["List", "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.023529411764705882`],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 9],
        TagBox[
         RowBox[{"{", 
           RowBox[{"0", ",", "0"}], "}"}], HoldForm]],
       Annotation[#, 
        HoldForm[{0, 0}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           TagBox["0",
            HoldForm], "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.023529411764705882`],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 10],
        TagBox["0", HoldForm]],
       Annotation[#, 
        HoldForm[0], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           TagBox["0",
            HoldForm], "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.023529411764705882`],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 11],
        TagBox["0", HoldForm]],
       Annotation[#, 
        HoldForm[0], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["List", "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.023529411764705882`],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 12],
        TagBox[
         RowBox[{"{", 
           RowBox[{
             RowBox[{"RGBColor", "[", 
               RowBox[{"0", ",", "0", ",", "1"}], "]"}], ",", 
             RowBox[{"Rectangle", "[", 
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{
                    FractionBox["1", "2"], ",", 
                    FractionBox["1", "2"]}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{
                    FractionBox["1", "2"], ",", 
                    FractionBox["1", "2"]}], "}"}]}], "]"}]}], "}"}], 
         HoldForm]],
       Annotation[#, 
        HoldForm[{
          RGBColor[0, 0, 1], 
          Rectangle[{
            Rational[1, 2], 
            Rational[1, 2]}, {
            Rational[1, 2], 
            Rational[1, 2]}]}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["RGBColor", "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.023529411764705882`],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 13],
        TagBox[
         RowBox[{"RGBColor", "[", 
           RowBox[{"0", ",", "0", ",", "1"}], "]"}], HoldForm]],
       Annotation[#, 
        HoldForm[
         RGBColor[0, 0, 1]], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           TagBox["0",
            HoldForm], "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.023529411764705882`],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 14],
        TagBox["0", HoldForm]],
       Annotation[#, 
        HoldForm[0], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           TagBox["0",
            HoldForm], "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.023529411764705882`],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 15],
        TagBox["0", HoldForm]],
       Annotation[#, 
        HoldForm[0], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           TagBox["1",
            HoldForm], "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.023529411764705882`],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 16],
        TagBox["1", HoldForm]],
       Annotation[#, 
        HoldForm[1], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["Rectangle", "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.023529411764705882`],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 17],
        TagBox[
         RowBox[{"Rectangle", "[", 
           RowBox[{
             RowBox[{"{", 
               RowBox[{
                 FractionBox["1", "2"], ",", 
                 FractionBox["1", "2"]}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{
                 FractionBox["1", "2"], ",", 
                 FractionBox["1", "2"]}], "}"}]}], "]"}], HoldForm]],
       Annotation[#, 
        HoldForm[
         Rectangle[{
           Rational[1, 2], 
           Rational[1, 2]}, {
           Rational[1, 2], 
           Rational[1, 2]}]], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["List", "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.023529411764705882`],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 18],
        TagBox[
         RowBox[{"{", 
           RowBox[{
             FractionBox["1", "2"], ",", 
             FractionBox["1", "2"]}], "}"}], HoldForm]],
       Annotation[#, 
        HoldForm[{
          Rational[1, 2], 
          Rational[1, 2]}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["Rational", "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.023529411764705882`],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 19],
        TagBox[
         FractionBox["1", "2"], HoldForm]],
       Annotation[#, 
        HoldForm[
         Rational[1, 2]], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           TagBox["1",
            HoldForm], "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.023529411764705882`],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 20],
        TagBox["1", HoldForm]],
       Annotation[#, 
        HoldForm[1], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           TagBox["2",
            HoldForm], "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.023529411764705882`],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 21],
        TagBox["2", HoldForm]],
       Annotation[#, 
        HoldForm[2], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["Rational", "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.023529411764705882`],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 22],
        TagBox[
         FractionBox["1", "2"], HoldForm]],
       Annotation[#, 
        HoldForm[
         Rational[1, 2]], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           TagBox["1",
            HoldForm], "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.023529411764705882`],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 23],
        TagBox["1", HoldForm]],
       Annotation[#, 
        HoldForm[1], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           TagBox["2",
            HoldForm], "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.023529411764705882`],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 24],
        TagBox["2", HoldForm]],
       Annotation[#, 
        HoldForm[2], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["List", "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.023529411764705882`],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 25],
        TagBox[
         RowBox[{"{", 
           RowBox[{
             FractionBox["1", "2"], ",", 
             FractionBox["1", "2"]}], "}"}], HoldForm]],
       Annotation[#, 
        HoldForm[{
          Rational[1, 2], 
          Rational[1, 2]}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["Rational", "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.023529411764705882`],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 26],
        TagBox[
         FractionBox["1", "2"], HoldForm]],
       Annotation[#, 
        HoldForm[
         Rational[1, 2]], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           TagBox["1",
            HoldForm], "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.023529411764705882`],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 27],
        TagBox["1", HoldForm]],
       Annotation[#, 
        HoldForm[1], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           TagBox["2",
            HoldForm], "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.023529411764705882`],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 28],
        TagBox["2", HoldForm]],
       Annotation[#, 
        HoldForm[2], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["Rational", "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.023529411764705882`],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 29],
        TagBox[
         FractionBox["1", "2"], HoldForm]],
       Annotation[#, 
        HoldForm[
         Rational[1, 2]], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           TagBox["1",
            HoldForm], "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.023529411764705882`],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 30],
        TagBox["1", HoldForm]],
       Annotation[#, 
        HoldForm[1], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           TagBox["2",
            HoldForm], "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.023529411764705882`],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 31],
        TagBox["2", HoldForm]],
       Annotation[#, 
        HoldForm[2], "Tooltip"]& ]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{2.9251218826177166`, 3.9001625101569553`}, {
     2.9251218826177166`, 3.250135425130796}, {1.3000541700523183`, 
     2.600108340104637}, {0.6500270850261591, 1.9500812550784776`}, {0., 
     1.3000541700523187`}, {0.6500270850261591, 1.3000541700523187`}, {
     1.3000541700523183`, 1.3000541700523187`}, {1.9500812550784776`, 
     1.9500812550784776`}, {1.9500812550784776`, 1.3000541700523187`}, {
     1.625067712565398, 0.6500270850261591}, {2.275094797591557, 
     0.6500270850261591}, {4.550189595183114, 2.600108340104637}, {
     3.250135425130796, 1.9500812550784776`}, {2.6001083401046365`, 
     1.3000541700523187`}, {3.250135425130796, 1.3000541700523187`}, {
     3.9001625101569553`, 1.3000541700523187`}, {5.850243765235433, 
     1.9500812550784776`}, {4.550189595183114, 1.3000541700523187`}, {
     3.9001625101569553`, 0.6500270850261591}, {3.5751489676438757`, 0.}, {
     4.225176052670035, 0.}, {5.200216680209273, 0.6500270850261591}, {
     4.875203137696194, 0.}, {5.525230222722353, 0.}, {7.150297935287751, 
     1.3000541700523187`}, {6.500270850261592, 0.6500270850261591}, {
     6.175257307748512, 0.}, {6.825284392774671, 0.}, {7.8003250203139105`, 
     0.6500270850261591}, {7.4753114778008305`, 0.}, {8.12533856282699, 
     0.}}]& ],
  AspectRatio->NCache[Rational[7, 17]^Rational[1, 2], 0.6416889479197478],
  FrameTicks->Automatic,
  ImageMargins->0.,
  ImageSize->{377., Automatic},
  PlotRange->All,
  PlotRangePadding->Automatic]], "Output",
 ImageSize->{381, 239},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TreeForm=",
 CellID->6104705]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(9)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->6094],

Cell["A formatted symbolic expression with mathematical constants:", \
"ExampleText",
 CellID->227887539],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TreeForm", "[", 
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{"n", " ", "\[ImaginaryI]", " ", "\[Pi]"}]], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->342831352],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{0.4082482904638631, 1.6329931618554523`}, {0., 
    0.8164965809277261}, {0.8164965809277261, 0.8164965809277261}, {0., 0.}, {
    0.8164965809277261, 0.}, {1.6329931618554523`, 0.}}, {
     {RGBColor[0.55, 0.45, 0.45], LineBox[{1, 2}], LineBox[{1, 3}], 
      LineBox[{3, 4}], LineBox[{3, 5}], LineBox[{3, 6}]}, 
     {RGBColor[0.55, 0.45, 0.45], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["Power", "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->11,
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 1],
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"\[ImaginaryI]", " ", "n", " ", "\[Pi]"}]]],
       Annotation[#, E^((Complex[0, 1] $CellContext`n) Pi), "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["\[ExponentialE]", "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->11,
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 2],
        "\[ExponentialE]"],
       Annotation[#, E, "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["Times", "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->11,
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 3],
        RowBox[{"\[ImaginaryI]", " ", "n", " ", "\[Pi]"}]],
       Annotation[#, (Complex[0, 1] $CellContext`n) Pi, "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["\[ImaginaryI]", "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->11,
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 4],
        "\[ImaginaryI]"],
       Annotation[#, 
        Complex[0, 1], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["n", "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->11,
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 5],
        "n"],
       Annotation[#, $CellContext`n, "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["\[Pi]", "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->11,
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 6],
        "\[Pi]"],
       Annotation[#, Pi, "Tooltip"]& ]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{0.4082482904638631, 1.6329931618554523`}, {0., 
     0.8164965809277261}, {0.8164965809277261, 0.8164965809277261}, {0., 
     0.}, {0.8164965809277261, 0.}, {1.6329931618554523`, 0.}}]& ],
  AspectRatio->1.,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->0]], "Output",
 ImageSize->{184, 182},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TreeForm=",
 CellID->216174536]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->3145603],

Cell["\<\
A formatted expression with symbolic, exact and inexact values:\
\>", "ExampleText",
 CellID->82299928],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TreeForm", "[", 
  RowBox[{
   FractionBox["1", "3"], " ", 
   SqrtBox["10"], 
   SuperscriptBox["\[ExponentialE]", 
    SuperscriptBox[".25", "x"]]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->14993916],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{1.1523319193960637`, 2.3046638387921274`}, {0., 
    1.5364425591947515`}, {0.7682212795973759, 1.5364425591947515`}, {
    2.3046638387921274`, 1.5364425591947515`}, {0.3841106397986879, 
    0.7682212795973757}, {1.1523319193960637`, 0.7682212795973757}, {
    1.9205531989934397`, 0.7682212795973757}, {2.6887744785908154`, 
    0.7682212795973757}, {2.3046638387921274`, 0.}, {3.0728851183895034`, 
    0.}}, {
     {RGBColor[0.55, 0.45, 0.45], LineBox[{1, 2}], LineBox[{1, 3}], 
      LineBox[{1, 4}], LineBox[{3, 5}], LineBox[{3, 6}], LineBox[{4, 7}], 
      LineBox[{4, 8}], LineBox[{8, 9}], LineBox[{8, 10}]}, 
     {RGBColor[0.55, 0.45, 0.45], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["Times", "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->11,
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 1],
        RowBox[{
          FractionBox["1", "3"], " ", 
          SqrtBox["10"], " ", 
          SuperscriptBox["\[ExponentialE]", 
           SuperscriptBox["0.25`", "x"]]}]],
       Annotation[#, (Rational[1, 3] 10^Rational[1, 2]) 
        E^(0.25^$CellContext`x), "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           FractionBox["1", "3"], "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->11,
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 2],
        FractionBox["1", "3"]],
       Annotation[#, 
        Rational[1, 3], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["Power", "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->11,
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 3],
        SqrtBox["10"]],
       Annotation[#, 10^Rational[1, 2], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["Power", "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->11,
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 4],
        SuperscriptBox["\[ExponentialE]", 
         SuperscriptBox["0.25`", "x"]]],
       Annotation[#, E^(0.25^$CellContext`x), "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["10", "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->11,
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 5],
        "10"],
       Annotation[#, 10, "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           FractionBox["1", "2"], "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->11,
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 6],
        FractionBox["1", "2"]],
       Annotation[#, 
        Rational[1, 2], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["\[ExponentialE]", "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->11,
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 7],
        "\[ExponentialE]"],
       Annotation[#, E, "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["Power", "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->11,
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 8],
        SuperscriptBox["0.25`", "x"]],
       Annotation[#, 0.25^$CellContext`x, "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["0.25`", "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->11,
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 9],
        "0.25`"],
       Annotation[#, 0.25, "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["x", "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->11,
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 10],
        "x"],
       Annotation[#, $CellContext`x, "Tooltip"]& ]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{1.1523319193960637`, 2.3046638387921274`}, {0.,
      1.5364425591947515`}, {0.7682212795973759, 1.5364425591947515`}, {
     2.3046638387921274`, 1.5364425591947515`}, {0.3841106397986879, 
     0.7682212795973757}, {1.1523319193960637`, 0.7682212795973757}, {
     1.9205531989934397`, 0.7682212795973757}, {2.6887744785908154`, 
     0.7682212795973757}, {2.3046638387921274`, 0.}, {3.0728851183895034`, 
     0.}}]& ],
  AspectRatio->0.8660254037844386,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->0]], "Output",
 ImageSize->{184, 158},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TreeForm=",
 CellID->48913076]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->2201895],

Cell["A nested list:", "ExampleText",
 CellID->593202285],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TreeForm", "[", 
  RowBox[{"{", 
   RowBox[{"1", ",", 
    RowBox[{"{", 
     RowBox[{"2", ",", 
      RowBox[{"{", "3", "}"}]}], "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->21186447],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{0.45643546458763845`, 2.7386127875258306`}, {0.,
     1.8257418583505536`}, {0.9128709291752769, 1.8257418583505536`}, {
    0.45643546458763845`, 0.9128709291752768}, {1.3693063937629153`, 
    0.9128709291752768}, {1.3693063937629153`, 0.}}, {
     {RGBColor[0.55, 0.45, 0.45], LineBox[{1, 2}], LineBox[{1, 3}], 
      LineBox[{3, 4}], LineBox[{3, 5}], LineBox[{5, 6}]}, 
     {RGBColor[0.55, 0.45, 0.45], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["List", "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->11,
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 1],
        RowBox[{"{", 
          RowBox[{"1", ",", 
            RowBox[{"{", 
              RowBox[{"2", ",", 
                RowBox[{"{", "3", "}"}]}], "}"}]}], "}"}]],
       Annotation[#, {1, {2, {3}}}, "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["1", "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->11,
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 2],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["List", "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->11,
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 3],
        RowBox[{"{", 
          RowBox[{"2", ",", 
            RowBox[{"{", "3", "}"}]}], "}"}]],
       Annotation[#, {2, {3}}, "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["2", "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->11,
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 4],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["List", "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->11,
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 5],
        RowBox[{"{", "3", "}"}]],
       Annotation[#, {3}, "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["3", "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->11,
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 6],
        "3"],
       Annotation[#, 3, "Tooltip"]& ]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{0.45643546458763845`, 2.7386127875258306`}, {
     0., 1.8257418583505536`}, {0.9128709291752769, 1.8257418583505536`}, {
     0.45643546458763845`, 0.9128709291752768}, {1.3693063937629153`, 
     0.9128709291752768}, {1.3693063937629153`, 0.}}]& ],
  AspectRatio->1.414213562373095,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->0]], "Output",
 ImageSize->{171, 216},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TreeForm=",
 CellID->714191534]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->20790714],

Cell["An expression containing subscripted variables:", "ExampleText",
 CellID->61289366],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TreeForm", "[", 
  RowBox[{
   SubscriptBox["x", "1"], "+", 
   SubscriptBox["x", "2"]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->134713058],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{1.224744871391589, 1.632993161855452}, {
    0.408248290463863, 0.816496580927726}, {0., 0.}, {0.816496580927726, 
    0.}, {2.041241452319315, 0.816496580927726}, {1.632993161855452, 0.}, {
    2.449489742783178, 0.}}, {
     {RGBColor[0.55, 0.45, 0.45], 
      LineBox[{{1, 2}, {1, 5}, {2, 3}, {2, 4}, {5, 6}, {5, 7}}]}, {
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["Plus", "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.044444444444444446`],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 1],
        TagBox[
         RowBox[{
           SubscriptBox["x", "1"], "+", 
           SubscriptBox["x", "2"]}], HoldForm]],
       Annotation[#, 
        HoldForm[Subscript[$CellContext`x, 1] + Subscript[$CellContext`x, 2]],
         "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["Subscript", "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.044444444444444446`],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 2],
        TagBox[
         SubscriptBox["x", "1"], HoldForm]],
       Annotation[#, 
        HoldForm[
         Subscript[$CellContext`x, 1]], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           TagBox["x",
            HoldForm], "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.044444444444444446`],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 3],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           TagBox["1",
            HoldForm], "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.044444444444444446`],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 4],
        TagBox["1", HoldForm]],
       Annotation[#, 
        HoldForm[1], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["Subscript", "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.044444444444444446`],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 5],
        TagBox[
         SubscriptBox["x", "2"], HoldForm]],
       Annotation[#, 
        HoldForm[
         Subscript[$CellContext`x, 2]], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           TagBox["x",
            HoldForm], "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.044444444444444446`],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 6],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           TagBox["2",
            HoldForm], "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.044444444444444446`],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 7],
        TagBox["2", HoldForm]],
       Annotation[#, 
        HoldForm[2], "Tooltip"]& ]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{1.224744871391589, 1.632993161855452}, {
     0.408248290463863, 0.816496580927726}, {0., 0.}, {0.816496580927726, 
     0.}, {2.041241452319315, 0.816496580927726}, {1.632993161855452, 0.}, {
     2.449489742783178, 0.}}]& ],
  AspectRatio->NCache[3^Rational[-1, 2], 0.5773502691896257],
  FrameTicks->None,
  ImageSize->{264., Automatic},
  PlotRange->All,
  PlotRangePadding->Automatic]], "Output",
 ImageSize->{268, 121},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TreeForm=",
 CellID->212210570]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->627944843],

Cell[TextData[{
 "A formatted expression with a special superscript and ",
 Cell[BoxData[
  ButtonBox["OverBar",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/OverBar"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->221149005],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TreeForm", "[", 
  RowBox[{
   SuperscriptBox["x", "\[Dagger]"], "+", 
   OverscriptBox["y", "_"]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->139891573],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{0.4714045207910317, 1.8856180831641267`}, {0., 
    0.9428090415820634}, {0., 0.}, {0.9428090415820634, 0.9428090415820634}, {
    0.9428090415820634, 0.}}, {
     {RGBColor[0.55, 0.45, 0.45], 
      LineBox[{{1, 2}, {1, 4}, {2, 3}, {4, 5}}]}, {
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["Plus", "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.044444444444444446`],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 1],
        TagBox[
         RowBox[{
           OverscriptBox["y", "_"], "+", 
           SuperscriptBox["x", "\[Dagger]"]}], HoldForm]],
       Annotation[#, 
        HoldForm[OverBar[$CellContext`y] + SuperDagger[$CellContext`x]], 
        "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["OverBar", "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.044444444444444446`],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 2],
        TagBox[
         OverscriptBox["y", "_"], HoldForm]],
       Annotation[#, 
        HoldForm[
         OverBar[$CellContext`y]], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           TagBox["y",
            HoldForm], "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.044444444444444446`],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 3],
        TagBox["y", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`y], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["SuperDagger", "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.044444444444444446`],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 4],
        TagBox[
         SuperscriptBox["x", "\[Dagger]"], HoldForm]],
       Annotation[#, 
        HoldForm[
         SuperDagger[$CellContext`x]], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           TagBox["x",
            HoldForm], "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.044444444444444446`],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 5],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{0.4714045207910317, 1.8856180831641267`}, {0., 
     0.9428090415820634}, {0., 0.}, {0.9428090415820634, 
     0.9428090415820634}, {0.9428090415820634, 0.}}]& ],
  AspectRatio->NCache[3^Rational[-1, 2], 0.5773502691896257],
  FrameTicks->None,
  ImageSize->{355., Automatic},
  PlotRange->All,
  PlotRangePadding->Automatic]], "Output",
 ImageSize->{359, 141},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TreeForm=",
 CellID->574734006]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->133086798],

Cell["A graphic object:", "ExampleText",
 CellID->46047206],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  GraphicsBox[{
    {RGBColor[1, 0, 0], DiskBox[{0, 0}]}, 
    {RGBColor[0, 0, 1], 
     RectangleBox[NCache[{Rational[1, 2], Rational[1, 2]}, {0.5, 0.5}], 
      NCache[{Rational[1, 2], Rational[1, 2]}, {0.5, 0.5}]]}}], "//", 
  "TreeForm"}]], "Input",
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"In[1]:=",
 CellID->519156385],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{2.9251218826177166`, 3.9001625101569553`}, {
    2.9251218826177166`, 3.250135425130796}, {1.3000541700523185`, 
    2.6001083401046365`}, {0.6500270850261592, 1.9500812550784776`}, {0., 
    1.3000541700523183`}, {0.6500270850261592, 1.3000541700523183`}, {
    1.3000541700523185`, 1.3000541700523183`}, {1.9500812550784776`, 
    1.9500812550784776`}, {1.9500812550784776`, 1.3000541700523183`}, {
    1.625067712565398, 0.6500270850261591}, {2.2750947975915574`, 
    0.6500270850261591}, {4.550189595183115, 2.6001083401046365`}, {
    3.250135425130796, 1.9500812550784776`}, {2.600108340104637, 
    1.3000541700523183`}, {3.250135425130796, 1.3000541700523183`}, {
    3.9001625101569553`, 1.3000541700523183`}, {5.850243765235433, 
    1.9500812550784776`}, {4.550189595183115, 1.3000541700523183`}, {
    3.9001625101569553`, 0.6500270850261591}, {3.5751489676438757`, 0.}, {
    4.225176052670035, 0.}, {5.200216680209274, 0.6500270850261591}, {
    4.875203137696194, 0.}, {5.525230222722353, 0.}, {7.150297935287751, 
    1.3000541700523183`}, {6.500270850261592, 0.6500270850261591}, {
    6.175257307748512, 0.}, {6.825284392774672, 0.}, {7.8003250203139105`, 
    0.6500270850261591}, {7.475311477800831, 0.}, {8.12533856282699, 0.}}, {
     {RGBColor[0.55, 0.45, 0.45], 
      LineBox[{{1, 2}, {2, 3}, {2, 12}, {3, 4}, {3, 8}, {4, 5}, {4, 6}, {4, 
       7}, {8, 9}, {9, 10}, {9, 11}, {12, 13}, {12, 17}, {13, 14}, {13, 15}, {
       13, 16}, {17, 18}, {17, 25}, {18, 19}, {18, 22}, {19, 20}, {19, 21}, {
       22, 23}, {22, 24}, {25, 26}, {25, 29}, {26, 27}, {26, 28}, {29, 30}, {
       29, 31}}]}, {
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["Graphics", "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.023529411764705882`],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 1],
        TagBox[
         GraphicsBox[{{
            RGBColor[1, 0, 0], 
            DiskBox[{0, 0}]}, {
            RGBColor[0, 0, 1], 
            RectangleBox[
             NCache[{
               Rational[1, 2], 
               Rational[1, 2]}, {0.5, 0.5}], 
             NCache[{
               Rational[1, 2], 
               Rational[1, 2]}, {0.5, 0.5}]]}}], HoldForm]],
       Annotation[#, 
        HoldForm[
         Graphics[{{
            RGBColor[1, 0, 0], 
            Disk[{0, 0}]}, {
            RGBColor[0, 0, 1], 
            Rectangle[{
              Rational[1, 2], 
              Rational[1, 2]}, {
              Rational[1, 2], 
              Rational[1, 2]}]}}]], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["List", "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.023529411764705882`],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 2],
        TagBox[
         RowBox[{"{", 
           RowBox[{
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"RGBColor", "[", 
                   RowBox[{"1", ",", "0", ",", "0"}], "]"}], ",", 
                 RowBox[{"Disk", "[", 
                   RowBox[{"{", 
                    RowBox[{"0", ",", "0"}], "}"}], "]"}]}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"RGBColor", "[", 
                   RowBox[{"0", ",", "0", ",", "1"}], "]"}], ",", 
                 RowBox[{"Rectangle", "[", 
                   RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    FractionBox["1", "2"], ",", 
                    FractionBox["1", "2"]}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    FractionBox["1", "2"], ",", 
                    FractionBox["1", "2"]}], "}"}]}], "]"}]}], "}"}]}], "}"}],
          HoldForm]],
       Annotation[#, 
        HoldForm[{{
           RGBColor[1, 0, 0], 
           Disk[{0, 0}]}, {
           RGBColor[0, 0, 1], 
           Rectangle[{
             Rational[1, 2], 
             Rational[1, 2]}, {
             Rational[1, 2], 
             Rational[1, 2]}]}}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["List", "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.023529411764705882`],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 3],
        TagBox[
         RowBox[{"{", 
           RowBox[{
             RowBox[{"RGBColor", "[", 
               RowBox[{"1", ",", "0", ",", "0"}], "]"}], ",", 
             RowBox[{"Disk", "[", 
               RowBox[{"{", 
                 RowBox[{"0", ",", "0"}], "}"}], "]"}]}], "}"}], HoldForm]],
       Annotation[#, 
        HoldForm[{
          RGBColor[1, 0, 0], 
          Disk[{0, 0}]}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["RGBColor", "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.023529411764705882`],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 4],
        TagBox[
         RowBox[{"RGBColor", "[", 
           RowBox[{"1", ",", "0", ",", "0"}], "]"}], HoldForm]],
       Annotation[#, 
        HoldForm[
         RGBColor[1, 0, 0]], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           TagBox["1",
            HoldForm], "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.023529411764705882`],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 5],
        TagBox["1", HoldForm]],
       Annotation[#, 
        HoldForm[1], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           TagBox["0",
            HoldForm], "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.023529411764705882`],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 6],
        TagBox["0", HoldForm]],
       Annotation[#, 
        HoldForm[0], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           TagBox["0",
            HoldForm], "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.023529411764705882`],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 7],
        TagBox["0", HoldForm]],
       Annotation[#, 
        HoldForm[0], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["Disk", "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.023529411764705882`],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 8],
        TagBox[
         RowBox[{"Disk", "[", 
           RowBox[{"{", 
             RowBox[{"0", ",", "0"}], "}"}], "]"}], HoldForm]],
       Annotation[#, 
        HoldForm[
         Disk[{0, 0}]], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["List", "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.023529411764705882`],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 9],
        TagBox[
         RowBox[{"{", 
           RowBox[{"0", ",", "0"}], "}"}], HoldForm]],
       Annotation[#, 
        HoldForm[{0, 0}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           TagBox["0",
            HoldForm], "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.023529411764705882`],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 10],
        TagBox["0", HoldForm]],
       Annotation[#, 
        HoldForm[0], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           TagBox["0",
            HoldForm], "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.023529411764705882`],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 11],
        TagBox["0", HoldForm]],
       Annotation[#, 
        HoldForm[0], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["List", "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.023529411764705882`],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 12],
        TagBox[
         RowBox[{"{", 
           RowBox[{
             RowBox[{"RGBColor", "[", 
               RowBox[{"0", ",", "0", ",", "1"}], "]"}], ",", 
             RowBox[{"Rectangle", "[", 
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{
                    FractionBox["1", "2"], ",", 
                    FractionBox["1", "2"]}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{
                    FractionBox["1", "2"], ",", 
                    FractionBox["1", "2"]}], "}"}]}], "]"}]}], "}"}], 
         HoldForm]],
       Annotation[#, 
        HoldForm[{
          RGBColor[0, 0, 1], 
          Rectangle[{
            Rational[1, 2], 
            Rational[1, 2]}, {
            Rational[1, 2], 
            Rational[1, 2]}]}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["RGBColor", "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.023529411764705882`],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 13],
        TagBox[
         RowBox[{"RGBColor", "[", 
           RowBox[{"0", ",", "0", ",", "1"}], "]"}], HoldForm]],
       Annotation[#, 
        HoldForm[
         RGBColor[0, 0, 1]], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           TagBox["0",
            HoldForm], "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.023529411764705882`],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 14],
        TagBox["0", HoldForm]],
       Annotation[#, 
        HoldForm[0], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           TagBox["0",
            HoldForm], "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.023529411764705882`],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 15],
        TagBox["0", HoldForm]],
       Annotation[#, 
        HoldForm[0], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           TagBox["1",
            HoldForm], "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.023529411764705882`],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 16],
        TagBox["1", HoldForm]],
       Annotation[#, 
        HoldForm[1], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["Rectangle", "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.023529411764705882`],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 17],
        TagBox[
         RowBox[{"Rectangle", "[", 
           RowBox[{
             RowBox[{"{", 
               RowBox[{
                 FractionBox["1", "2"], ",", 
                 FractionBox["1", "2"]}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{
                 FractionBox["1", "2"], ",", 
                 FractionBox["1", "2"]}], "}"}]}], "]"}], HoldForm]],
       Annotation[#, 
        HoldForm[
         Rectangle[{
           Rational[1, 2], 
           Rational[1, 2]}, {
           Rational[1, 2], 
           Rational[1, 2]}]], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["List", "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.023529411764705882`],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 18],
        TagBox[
         RowBox[{"{", 
           RowBox[{
             FractionBox["1", "2"], ",", 
             FractionBox["1", "2"]}], "}"}], HoldForm]],
       Annotation[#, 
        HoldForm[{
          Rational[1, 2], 
          Rational[1, 2]}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["Rational", "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.023529411764705882`],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 19],
        TagBox[
         FractionBox["1", "2"], HoldForm]],
       Annotation[#, 
        HoldForm[
         Rational[1, 2]], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           TagBox["1",
            HoldForm], "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.023529411764705882`],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 20],
        TagBox["1", HoldForm]],
       Annotation[#, 
        HoldForm[1], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           TagBox["2",
            HoldForm], "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.023529411764705882`],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 21],
        TagBox["2", HoldForm]],
       Annotation[#, 
        HoldForm[2], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["Rational", "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.023529411764705882`],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 22],
        TagBox[
         FractionBox["1", "2"], HoldForm]],
       Annotation[#, 
        HoldForm[
         Rational[1, 2]], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           TagBox["1",
            HoldForm], "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.023529411764705882`],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 23],
        TagBox["1", HoldForm]],
       Annotation[#, 
        HoldForm[1], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           TagBox["2",
            HoldForm], "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.023529411764705882`],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 24],
        TagBox["2", HoldForm]],
       Annotation[#, 
        HoldForm[2], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["List", "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.023529411764705882`],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 25],
        TagBox[
         RowBox[{"{", 
           RowBox[{
             FractionBox["1", "2"], ",", 
             FractionBox["1", "2"]}], "}"}], HoldForm]],
       Annotation[#, 
        HoldForm[{
          Rational[1, 2], 
          Rational[1, 2]}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["Rational", "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.023529411764705882`],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 26],
        TagBox[
         FractionBox["1", "2"], HoldForm]],
       Annotation[#, 
        HoldForm[
         Rational[1, 2]], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           TagBox["1",
            HoldForm], "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.023529411764705882`],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 27],
        TagBox["1", HoldForm]],
       Annotation[#, 
        HoldForm[1], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           TagBox["2",
            HoldForm], "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.023529411764705882`],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 28],
        TagBox["2", HoldForm]],
       Annotation[#, 
        HoldForm[2], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["Rational", "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.023529411764705882`],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 29],
        TagBox[
         FractionBox["1", "2"], HoldForm]],
       Annotation[#, 
        HoldForm[
         Rational[1, 2]], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           TagBox["1",
            HoldForm], "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.023529411764705882`],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 30],
        TagBox["1", HoldForm]],
       Annotation[#, 
        HoldForm[1], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           TagBox["2",
            HoldForm], "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.023529411764705882`],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 31],
        TagBox["2", HoldForm]],
       Annotation[#, 
        HoldForm[2], "Tooltip"]& ]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{2.9251218826177166`, 3.9001625101569553`}, {
     2.9251218826177166`, 3.250135425130796}, {1.3000541700523185`, 
     2.6001083401046365`}, {0.6500270850261592, 1.9500812550784776`}, {0., 
     1.3000541700523183`}, {0.6500270850261592, 1.3000541700523183`}, {
     1.3000541700523185`, 1.3000541700523183`}, {1.9500812550784776`, 
     1.9500812550784776`}, {1.9500812550784776`, 1.3000541700523183`}, {
     1.625067712565398, 0.6500270850261591}, {2.2750947975915574`, 
     0.6500270850261591}, {4.550189595183115, 2.6001083401046365`}, {
     3.250135425130796, 1.9500812550784776`}, {2.600108340104637, 
     1.3000541700523183`}, {3.250135425130796, 1.3000541700523183`}, {
     3.9001625101569553`, 1.3000541700523183`}, {5.850243765235433, 
     1.9500812550784776`}, {4.550189595183115, 1.3000541700523183`}, {
     3.9001625101569553`, 0.6500270850261591}, {3.5751489676438757`, 0.}, {
     4.225176052670035, 0.}, {5.200216680209274, 0.6500270850261591}, {
     4.875203137696194, 0.}, {5.525230222722353, 0.}, {7.150297935287751, 
     1.3000541700523183`}, {6.500270850261592, 0.6500270850261591}, {
     6.175257307748512, 0.}, {6.825284392774672, 0.}, {7.8003250203139105`, 
     0.6500270850261591}, {7.475311477800831, 0.}, {8.12533856282699, 
     0.}}]& ],
  AspectRatio->NCache[Rational[7, 17]^Rational[1, 2], 0.6416889479197478],
  FrameTicks->None,
  ImageMargins->0.,
  ImageSize->Automatic,
  PlotRange->All,
  PlotRangePadding->Automatic]], "Output",
 ImageSize->{364, 227},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TreeForm=",
 CellID->1740707707]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->30596643],

Cell[TextData[{
 "A ",
 Cell[BoxData[
  ButtonBox["Series",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Series"]], "InlineFormula"],
 " expression:"
}], "ExampleText",
 CellID->24278613],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ser", "=", 
  RowBox[{"Series", "[", 
   RowBox[{
    RowBox[{"Sin", "[", "x", "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", "5"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->19030637],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"x", "-", 
   FractionBox[
    SuperscriptBox["x", "3"], "6"], "+", 
   FractionBox[
    SuperscriptBox["x", "5"], "120"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "6"],
    SeriesData[$CellContext`x, 0, {}, 1, 6, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {1, 0, 
    Rational[-1, 6], 0, 
    Rational[1, 120]}, 1, 6, 1],
  Editable->False]], "Output",
 ImageSize->{125, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->115608706]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TreeForm", "[", "ser", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->455863823],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{1.3363062095621219`, 1.0690449676496976`}, {0., 
    0.5345224838248488}, {0.5345224838248488, 0.5345224838248488}, {
    1.0690449676496976`, 0.5345224838248488}, {1.6035674514745464`, 
    0.5345224838248488}, {2.138089935299395, 0.5345224838248488}, {
    2.6726124191242437`, 0.5345224838248488}, {0., 0.}, {0.5345224838248488, 
    0.}, {1.0690449676496976`, 0.}, {1.6035674514745464`, 0.}, {
    2.138089935299395, 0.}}, {
     {RGBColor[0.55, 0.45, 0.45], LineBox[{1, 2}], LineBox[{1, 3}], 
      LineBox[{1, 4}], LineBox[{1, 5}], LineBox[{1, 6}], LineBox[{1, 7}], 
      LineBox[{4, 8}], LineBox[{4, 9}], LineBox[{4, 10}], LineBox[{4, 11}], 
      LineBox[{4, 12}]}, 
     {RGBColor[0.55, 0.45, 0.45], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["SeriesData", "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->11,
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 1],
        InterpretationBox[
         RowBox[{"x", "-", 
           FractionBox[
            SuperscriptBox["x", "3"], "6"], "+", 
           FractionBox[
            SuperscriptBox["x", "5"], "120"], "+", 
           InterpretationBox[
            SuperscriptBox[
             RowBox[{"O", "[", "x", "]"}], "6"], 
            SeriesData[$CellContext`x, 0, {}, 1, 6, 1], Editable -> False]}], 
         
         SeriesData[$CellContext`x, 0, {1, 0, 
           Rational[-1, 6], 0, 
           Rational[1, 120]}, 1, 6, 1], Editable -> False]],
       Annotation[#, 
        SeriesData[$CellContext`x, 0, {1, 0, 
          Rational[-1, 6], 0, 
          Rational[1, 120]}, 1, 6, 1], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["x", "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->11,
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 2],
        "x"],
       Annotation[#, $CellContext`x, "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["0", "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->11,
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 3],
        "0"],
       Annotation[#, 0, "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["List", "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->11,
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 4],
        RowBox[{"{", 
          RowBox[{"1", ",", "0", ",", 
            RowBox[{"-", 
              FractionBox["1", "6"]}], ",", "0", ",", 
            FractionBox["1", "120"]}], "}"}]],
       Annotation[#, {1, 0, 
         Rational[-1, 6], 0, 
         Rational[1, 120]}, "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["1", "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->11,
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 5],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["6", "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->11,
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 6],
        "6"],
       Annotation[#, 6, "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["1", "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->11,
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 7],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["1", "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->11,
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 8],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["0", "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->11,
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 9],
        "0"],
       Annotation[#, 0, "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           RowBox[{"-", 
            FractionBox["1", "6"]}], "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->11,
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 10],
        RowBox[{"-", 
          FractionBox["1", "6"]}]],
       Annotation[#, 
        Rational[-1, 6], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["0", "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->11,
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 11],
        "0"],
       Annotation[#, 0, "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           FractionBox["1", "120"], "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->11,
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 12],
        FractionBox["1", "120"]],
       Annotation[#, 
        Rational[1, 120], "Tooltip"]& ]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{1.3363062095621219`, 1.0690449676496976`}, {0.,
      0.5345224838248488}, {0.5345224838248488, 0.5345224838248488}, {
     1.0690449676496976`, 0.5345224838248488}, {1.6035674514745464`, 
     0.5345224838248488}, {2.138089935299395, 0.5345224838248488}, {
     2.6726124191242437`, 0.5345224838248488}, {0., 0.}, {0.5345224838248488, 
     0.}, {1.0690449676496976`, 0.}, {1.6035674514745464`, 0.}, {
     2.138089935299395, 0.}}]& ],
  AspectRatio->0.6324555320336759,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->0]], "Output",
 ImageSize->{184, 132},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//TreeForm=",
 CellID->119415989]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->670925301],

Cell[TextData[{
 "An expression containing a ",
 Cell[BoxData[
  ButtonBox["Hold",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Hold"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->404704945],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TreeForm", "[", 
  RowBox[{"Hold", "[", 
   RowBox[{"1", "+", "2", "+", "3"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1206989350],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{0.816496580927726, 1.632993161855452}, {
    0.816496580927726, 0.816496580927726}, {0., 0.}, {0.816496580927726, 
    0.}, {1.632993161855452, 0.}}, {
     {RGBColor[0.55, 0.45, 0.45], 
      LineBox[{{1, 2}, {2, 3}, {2, 4}, {2, 5}}]}, {
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["Hold", "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.05],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 1],
        TagBox[
         RowBox[{"Hold", "[", 
           RowBox[{"1", "+", "2", "+", "3"}], "]"}], HoldForm]],
       Annotation[#, 
        HoldForm[
         Hold[1 + 2 + 3]], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["Plus", "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.05],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 2],
        TagBox[
         RowBox[{"1", "+", "2", "+", "3"}], HoldForm]],
       Annotation[#, 
        HoldForm[1 + 2 + 3], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           TagBox["1",
            HoldForm], "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.05],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 3],
        TagBox["1", HoldForm]],
       Annotation[#, 
        HoldForm[1], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           TagBox["2",
            HoldForm], "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.05],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 4],
        TagBox["2", HoldForm]],
       Annotation[#, 
        HoldForm[2], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           TagBox["3",
            HoldForm], "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.05],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 5],
        TagBox["3", HoldForm]],
       Annotation[#, 
        HoldForm[3], "Tooltip"]& ]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{0.816496580927726, 1.632993161855452}, {
     0.816496580927726, 0.816496580927726}, {0., 0.}, {0.816496580927726, 
     0.}, {1.632993161855452, 0.}}]& ],
  AspectRatio->NCache[Rational[3, 2]^Rational[1, 2], 1.224744871391589],
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Automatic]], "Output",
 ImageSize->{182, 216},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TreeForm=",
 CellID->306758386]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1273915790],

Cell["Limit the levels shown:", "ExampleText",
 CellID->1702247929],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TreeForm", "[", 
  RowBox[{
   RowBox[{"Nest", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"{", 
       RowBox[{"#", ",", 
        RowBox[{"{", 
         RowBox[{"#", ",", 
          RowBox[{"{", "#", "}"}]}], "}"}]}], "}"}], "&"}], ",", "x", ",", 
     "2"}], "]"}], ",", " ", "4"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->553374777],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{1.7746549574783568`, 2.9888925599635483`}, {
    0.37361156999544354`, 2.241669419972661}, {0., 1.4944462799817742`}, {
    0.7472231399908871, 1.4944462799817742`}, {0.37361156999544354`, 
    0.7472231399908873}, {1.1208347099863305`, 0.7472231399908873}, {
    1.1208347099863305`, 0.}, {3.17569834496127, 2.241669419972661}, {
    2.241669419972661, 1.4944462799817742`}, {1.8680578499772176`, 
    0.7472231399908873}, {2.6152809899681047`, 0.7472231399908873}, {
    2.241669419972661, 0.}, {2.9888925599635483`, 0.}, {4.109727269949879, 
    1.4944462799817742`}, {4.109727269949879, 0.7472231399908873}, {
    3.736115699954435, 0.}, {4.483338839945322, 0.}}, {
     {RGBColor[0.55, 0.45, 0.45], 
      LineBox[{{1, 2}, {1, 8}, {2, 3}, {2, 4}, {4, 5}, {4, 6}, {6, 7}, {8, 
       9}, {8, 14}, {9, 10}, {9, 11}, {11, 12}, {11, 13}, {14, 15}, {15, 
       16}, {15, 17}}]}, {
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["List", "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.05],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 1],
        TagBox[
         RowBox[{"{", 
           RowBox[{
             RowBox[{"{", 
               RowBox[{"x", ",", 
                 RowBox[{"{", 
                   RowBox[{"x", ",", 
                    RowBox[{"{", "x", "}"}]}], "}"}]}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"x", ",", 
                    RowBox[{"{", 
                    RowBox[{"x", ",", 
                    RowBox[{"{", "x", "}"}]}], "}"}]}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"{", 
                    RowBox[{"x", ",", 
                    RowBox[{"{", 
                    RowBox[{"x", ",", 
                    RowBox[{"{", "x", "}"}]}], "}"}]}], "}"}], "}"}]}], 
               "}"}]}], "}"}], HoldForm]],
       Annotation[#, 
        HoldForm[{{$CellContext`x, {$CellContext`x, {$CellContext`x}}}, \
{{$CellContext`x, {$CellContext`x, {$CellContext`x}}}, {{$CellContext`x, \
{$CellContext`x, {$CellContext`x}}}}}}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["List", "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.05],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 2],
        TagBox[
         RowBox[{"{", 
           RowBox[{"x", ",", 
             RowBox[{"{", 
               RowBox[{"x", ",", 
                 RowBox[{"{", "x", "}"}]}], "}"}]}], "}"}], HoldForm]],
       Annotation[#, 
        HoldForm[{$CellContext`x, {$CellContext`x, {$CellContext`x}}}], 
        "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           TagBox["x",
            HoldForm], "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.05],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 3],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["List", "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.05],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 4],
        TagBox[
         RowBox[{"{", 
           RowBox[{"x", ",", 
             RowBox[{"{", "x", "}"}]}], "}"}], HoldForm]],
       Annotation[#, 
        HoldForm[{$CellContext`x, {$CellContext`x}}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           TagBox["x",
            HoldForm], "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.05],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 5],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["List", "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.05],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 6],
        TagBox[
         RowBox[{"{", "x", "}"}], HoldForm]],
       Annotation[#, 
        HoldForm[{$CellContext`x}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           TagBox["x",
            HoldForm], "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.05],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 7],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["List", "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.05],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 8],
        TagBox[
         RowBox[{"{", 
           RowBox[{
             RowBox[{"{", 
               RowBox[{"x", ",", 
                 RowBox[{"{", 
                   RowBox[{"x", ",", 
                    RowBox[{"{", "x", "}"}]}], "}"}]}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"{", 
                 RowBox[{"x", ",", 
                   RowBox[{"{", 
                    RowBox[{"x", ",", 
                    RowBox[{"{", "x", "}"}]}], "}"}]}], "}"}], "}"}]}], "}"}],
          HoldForm]],
       Annotation[#, 
        HoldForm[{{$CellContext`x, {$CellContext`x, {$CellContext`x}}}, \
{{$CellContext`x, {$CellContext`x, {$CellContext`x}}}}}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["List", "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.05],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 9],
        TagBox[
         RowBox[{"{", 
           RowBox[{"x", ",", 
             RowBox[{"{", 
               RowBox[{"x", ",", 
                 RowBox[{"{", "x", "}"}]}], "}"}]}], "}"}], HoldForm]],
       Annotation[#, 
        HoldForm[{$CellContext`x, {$CellContext`x, {$CellContext`x}}}], 
        "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           TagBox["x",
            HoldForm], "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.05],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 10],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["List", "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.05],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 11],
        TagBox[
         RowBox[{"{", 
           RowBox[{"x", ",", 
             RowBox[{"{", "x", "}"}]}], "}"}], HoldForm]],
       Annotation[#, 
        HoldForm[{$CellContext`x, {$CellContext`x}}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           TagBox["x",
            HoldForm], "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.05],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 12],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           TagBox[
            RowBox[{"{", "x", "}"}],
            HoldForm], "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.05],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 13],
        TagBox[
         RowBox[{"{", "x", "}"}], HoldForm]],
       Annotation[#, 
        HoldForm[{$CellContext`x}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["List", "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.05],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 14],
        TagBox[
         RowBox[{"{", 
           RowBox[{"{", 
             RowBox[{"x", ",", 
               RowBox[{"{", 
                 RowBox[{"x", ",", 
                   RowBox[{"{", "x", "}"}]}], "}"}]}], "}"}], "}"}], 
         HoldForm]],
       Annotation[#, 
        HoldForm[{{$CellContext`x, {$CellContext`x, {$CellContext`x}}}}], 
        "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["List", "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.05],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 15],
        TagBox[
         RowBox[{"{", 
           RowBox[{"x", ",", 
             RowBox[{"{", 
               RowBox[{"x", ",", 
                 RowBox[{"{", "x", "}"}]}], "}"}]}], "}"}], HoldForm]],
       Annotation[#, 
        HoldForm[{$CellContext`x, {$CellContext`x, {$CellContext`x}}}], 
        "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           TagBox["x",
            HoldForm], "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.05],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 16],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           TagBox[
            RowBox[{"{", 
             RowBox[{"x", ",", 
              RowBox[{"{", "x", "}"}]}], "}"}],
            HoldForm], "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.05],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 17],
        TagBox[
         RowBox[{"{", 
           RowBox[{"x", ",", 
             RowBox[{"{", "x", "}"}]}], "}"}], HoldForm]],
       Annotation[#, 
        HoldForm[{$CellContext`x, {$CellContext`x}}], "Tooltip"]& ]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{1.7746549574783568`, 2.9888925599635483`}, {
     0.37361156999544354`, 2.241669419972661}, {0., 1.4944462799817742`}, {
     0.7472231399908871, 1.4944462799817742`}, {0.37361156999544354`, 
     0.7472231399908873}, {1.1208347099863305`, 0.7472231399908873}, {
     1.1208347099863305`, 0.}, {3.17569834496127, 2.241669419972661}, {
     2.241669419972661, 1.4944462799817742`}, {1.8680578499772176`, 
     0.7472231399908873}, {2.6152809899681047`, 0.7472231399908873}, {
     2.241669419972661, 0.}, {2.9888925599635483`, 0.}, {4.109727269949879, 
     1.4944462799817742`}, {4.109727269949879, 0.7472231399908873}, {
     3.736115699954435, 0.}, {4.483338839945322, 0.}}]& ],
  AspectRatio->NCache[Rational[5, 7]^Rational[1, 2], 0.8451542547285166],
  FrameTicks->Automatic,
  ImageSize->{355., Automatic},
  PlotRange->All,
  PlotRangePadding->Automatic]], "Output",
 ImageSize->{359, 259},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TreeForm=",
 CellID->327519934]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->463608210],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "AspectRatio",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->900310349],

Cell["\<\
By default a suitable aspect ratio is calculated for good visual appearance:\
\>", "ExampleText",
 CellID->1707013097],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TreeForm", "[", 
  RowBox[{"Nest", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{"#", ",", "#", ",", "#"}], "}"}], "&"}], ",", "x", ",", "2"}], 
   "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2111380344],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{2.309401076758503, 1.1547005383792515`}, {
    0.5773502691896257, 0.5773502691896257}, {0., 0.}, {0.5773502691896257, 
    0.}, {1.1547005383792515`, 0.}, {2.309401076758503, 0.5773502691896257}, {
    1.7320508075688772`, 0.}, {2.309401076758503, 0.}, {2.8867513459481287`, 
    0.}, {4.041451884327381, 0.5773502691896257}, {3.4641016151377544`, 0.}, {
    4.041451884327381, 0.}, {4.618802153517006, 0.}}, {
     {RGBColor[0.55, 0.45, 0.45], 
      LineBox[{{1, 2}, {1, 6}, {1, 10}, {2, 3}, {2, 4}, {2, 5}, {6, 7}, {6, 
       8}, {6, 9}, {10, 11}, {10, 12}, {10, 13}}]}, {
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["List", "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.05],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 1],
        TagBox[
         RowBox[{"{", 
           RowBox[{
             RowBox[{"{", 
               RowBox[{"x", ",", "x", ",", "x"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"x", ",", "x", ",", "x"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"x", ",", "x", ",", "x"}], "}"}]}], "}"}], HoldForm]],
       Annotation[#, 
        HoldForm[{{$CellContext`x, $CellContext`x, $CellContext`x}, \
{$CellContext`x, $CellContext`x, $CellContext`x}, {$CellContext`x, \
$CellContext`x, $CellContext`x}}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["List", "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.05],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 2],
        TagBox[
         RowBox[{"{", 
           RowBox[{"x", ",", "x", ",", "x"}], "}"}], HoldForm]],
       Annotation[#, 
        HoldForm[{$CellContext`x, $CellContext`x, $CellContext`x}], 
        "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           TagBox["x",
            HoldForm], "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.05],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 3],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           TagBox["x",
            HoldForm], "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.05],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 4],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           TagBox["x",
            HoldForm], "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.05],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 5],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["List", "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.05],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 6],
        TagBox[
         RowBox[{"{", 
           RowBox[{"x", ",", "x", ",", "x"}], "}"}], HoldForm]],
       Annotation[#, 
        HoldForm[{$CellContext`x, $CellContext`x, $CellContext`x}], 
        "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           TagBox["x",
            HoldForm], "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.05],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 7],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           TagBox["x",
            HoldForm], "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.05],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 8],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           TagBox["x",
            HoldForm], "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.05],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 9],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["List", "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.05],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 10],
        TagBox[
         RowBox[{"{", 
           RowBox[{"x", ",", "x", ",", "x"}], "}"}], HoldForm]],
       Annotation[#, 
        HoldForm[{$CellContext`x, $CellContext`x, $CellContext`x}], 
        "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           TagBox["x",
            HoldForm], "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.05],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 11],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           TagBox["x",
            HoldForm], "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.05],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 12],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           TagBox["x",
            HoldForm], "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.05],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 13],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{2.309401076758503, 1.1547005383792515`}, {
     0.5773502691896257, 0.5773502691896257}, {0., 0.}, {0.5773502691896257, 
     0.}, {1.1547005383792515`, 0.}, {2.309401076758503, 
     0.5773502691896257}, {1.7320508075688772`, 0.}, {2.309401076758503, 
     0.}, {2.8867513459481287`, 0.}, {4.041451884327381, 
     0.5773502691896257}, {3.4641016151377544`, 0.}, {4.041451884327381, 
     0.}, {4.618802153517006, 0.}}]& ],
  AspectRatio->NCache[2^Rational[-1, 2], 0.7071067811865476],
  FrameTicks->Automatic,
  ImageSize->{297., Automatic},
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{301, 210},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TreeForm=",
 CellID->917531985]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->870893505],

Cell["Change the aspect ratio:", "ExampleText",
 CellID->1940558099],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TreeForm", "[", 
  RowBox[{
   RowBox[{"Nest", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"{", 
       RowBox[{"#", ",", "#", ",", "#"}], "}"}], "&"}], ",", "x", ",", "2"}], 
    "]"}], ",", 
   RowBox[{"AspectRatio", "\[Rule]", ".3"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1531262091],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{2.309401076758503, 1.1547005383792515`}, {
    0.5773502691896257, 0.5773502691896257}, {0., 0.}, {0.5773502691896257, 
    0.}, {1.1547005383792515`, 0.}, {2.309401076758503, 0.5773502691896257}, {
    1.7320508075688772`, 0.}, {2.309401076758503, 0.}, {2.8867513459481287`, 
    0.}, {4.041451884327381, 0.5773502691896257}, {3.4641016151377544`, 0.}, {
    4.041451884327381, 0.}, {4.618802153517006, 0.}}, {
     {RGBColor[0.55, 0.45, 0.45], 
      LineBox[{{1, 2}, {1, 6}, {1, 10}, {2, 3}, {2, 4}, {2, 5}, {6, 7}, {6, 
       8}, {6, 9}, {10, 11}, {10, 12}, {10, 13}}]}, {
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["List", "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.05],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 1],
        TagBox[
         RowBox[{"{", 
           RowBox[{
             RowBox[{"{", 
               RowBox[{"x", ",", "x", ",", "x"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"x", ",", "x", ",", "x"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"x", ",", "x", ",", "x"}], "}"}]}], "}"}], HoldForm]],
       Annotation[#, 
        HoldForm[{{$CellContext`x, $CellContext`x, $CellContext`x}, \
{$CellContext`x, $CellContext`x, $CellContext`x}, {$CellContext`x, \
$CellContext`x, $CellContext`x}}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["List", "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.05],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 2],
        TagBox[
         RowBox[{"{", 
           RowBox[{"x", ",", "x", ",", "x"}], "}"}], HoldForm]],
       Annotation[#, 
        HoldForm[{$CellContext`x, $CellContext`x, $CellContext`x}], 
        "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           TagBox["x",
            HoldForm], "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.05],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 3],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           TagBox["x",
            HoldForm], "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.05],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 4],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           TagBox["x",
            HoldForm], "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.05],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 5],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["List", "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.05],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 6],
        TagBox[
         RowBox[{"{", 
           RowBox[{"x", ",", "x", ",", "x"}], "}"}], HoldForm]],
       Annotation[#, 
        HoldForm[{$CellContext`x, $CellContext`x, $CellContext`x}], 
        "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           TagBox["x",
            HoldForm], "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.05],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 7],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           TagBox["x",
            HoldForm], "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.05],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 8],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           TagBox["x",
            HoldForm], "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.05],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 9],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["List", "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.05],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 10],
        TagBox[
         RowBox[{"{", 
           RowBox[{"x", ",", "x", ",", "x"}], "}"}], HoldForm]],
       Annotation[#, 
        HoldForm[{$CellContext`x, $CellContext`x, $CellContext`x}], 
        "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           TagBox["x",
            HoldForm], "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.05],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 11],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           TagBox["x",
            HoldForm], "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.05],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 12],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           TagBox["x",
            HoldForm], "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.05],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 13],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{2.309401076758503, 1.1547005383792515`}, {
     0.5773502691896257, 0.5773502691896257}, {0., 0.}, {0.5773502691896257, 
     0.}, {1.1547005383792515`, 0.}, {2.309401076758503, 
     0.5773502691896257}, {1.7320508075688772`, 0.}, {2.309401076758503, 
     0.}, {2.8867513459481287`, 0.}, {4.041451884327381, 
     0.5773502691896257}, {3.4641016151377544`, 0.}, {4.041451884327381, 
     0.}, {4.618802153517006, 0.}}]& ],
  AspectRatio->0.3,
  FrameTicks->Automatic,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{184, 69},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TreeForm=",
 CellID->160490410]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "DirectedEdges",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->203839123],

Cell["Show the direction of edges:", "ExampleText",
 CellID->2036916947],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TreeForm", "[", 
  RowBox[{
   RowBox[{"Integrate", "[", 
    RowBox[{
     RowBox[{"1", "/", 
      RowBox[{"(", 
       RowBox[{"1", "+", 
        RowBox[{"1", "/", 
         RowBox[{"(", 
          RowBox[{"1", "+", "x"}], ")"}]}]}], ")"}]}], ",", "x"}], "]"}], ",",
    
   RowBox[{"DirectedEdges", "\[Rule]", " ", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1851389954],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{0.4537426064865151, 3.629940851892121}, {0., 
    2.7224556389190906`}, {0.9074852129730302, 2.7224556389190906`}, {
    0.4537426064865151, 1.8149704259460604`}, {1.3612278194595453`, 
    1.8149704259460604`}, {1.3612278194595453`, 0.9074852129730302}, {
    0.9074852129730302, 0.}, {1.8149704259460604`, 0.}}, {
     {RGBColor[0.55, 0.45, 0.45], Arrowheads[{{0.026672321898461946`, 0.7}}], 
      ArrowBox[{1, 2}], ArrowBox[{1, 3}], ArrowBox[{3, 4}], ArrowBox[{3, 5}], 
      ArrowBox[{5, 6}], ArrowBox[{6, 7}], ArrowBox[{6, 8}]}, {
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["Plus", "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.05],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 1],
        TagBox[
         RowBox[{"x", "-", 
           RowBox[{"Log", "[", 
             RowBox[{"2", "+", "x"}], "]"}]}], HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x - Log[2 + $CellContext`x]], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           TagBox["x",
            HoldForm], "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.05],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 2],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["Times", "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.05],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 3],
        TagBox[
         RowBox[{"-", 
           RowBox[{"Log", "[", 
             RowBox[{"2", "+", "x"}], "]"}]}], HoldForm]],
       Annotation[#, 
        HoldForm[-Log[2 + $CellContext`x]], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           TagBox[
            RowBox[{"-", "1"}],
            HoldForm], "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.05],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 4],
        TagBox[
         RowBox[{"-", "1"}], HoldForm]],
       Annotation[#, 
        HoldForm[-1], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["Log", "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.05],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 5],
        TagBox[
         RowBox[{"Log", "[", 
           RowBox[{"2", "+", "x"}], "]"}], HoldForm]],
       Annotation[#, 
        HoldForm[
         Log[2 + $CellContext`x]], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["Plus", "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.05],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 6],
        TagBox[
         RowBox[{"2", "+", "x"}], HoldForm]],
       Annotation[#, 
        HoldForm[2 + $CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           TagBox["2",
            HoldForm], "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.05],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 7],
        TagBox["2", HoldForm]],
       Annotation[#, 
        HoldForm[2], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           TagBox["x",
            HoldForm], "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.05],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 8],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{0.4537426064865151, 3.629940851892121}, {0., 
     2.7224556389190906`}, {0.9074852129730302, 2.7224556389190906`}, {
     0.4537426064865151, 1.8149704259460604`}, {1.3612278194595453`, 
     1.8149704259460604`}, {1.3612278194595453`, 0.9074852129730302}, {
     0.9074852129730302, 0.}, {1.8149704259460604`, 0.}}]& ],
  AspectRatio->NCache[Rational[5, 3]^Rational[1, 2], 1.2909944487358056`],
  FrameTicks->Automatic,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{172, 216},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TreeForm=",
 CellID->1327575552]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "EdgeRenderingFunction",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->65693485],

Cell["Draw edges using blue arrows set back by 30%:", "ExampleText",
 CellID->2122510440],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TreeForm", "[", 
  RowBox[{
   RowBox[{"D", "[", 
    RowBox[{
     RowBox[{"x", " ", 
      RowBox[{"Exp", "[", "x", "]"}]}], ",", "x"}], "]"}], ",", 
   RowBox[{"EdgeRenderingFunction", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"Blue", ",", 
        RowBox[{"Arrow", "[", 
         RowBox[{"#", ",", ".3"}], "]"}]}], "}"}], "&"}], ")"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1956840094],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsGroupBox[{{
      {RGBColor[0, 0, 1], 
       ArrowBox[{{1.2510864843424485`, 2.502172968684897}, {
        0.41702882811414954`, 1.668115312456598}}, 0.3]}, 
      {RGBColor[0, 0, 1], 
       ArrowBox[{{1.2510864843424485`, 2.502172968684897}, {
        2.0851441405707476`, 1.668115312456598}}, 0.3]}, 
      {RGBColor[0, 0, 1], 
       ArrowBox[{{0.41702882811414954`, 1.668115312456598}, {0., 
        0.8340576562282989}}, 0.3]}, 
      {RGBColor[0, 0, 1], 
       ArrowBox[{{0.41702882811414954`, 1.668115312456598}, {
        0.8340576562282991, 0.8340576562282989}}, 0.3]}, 
      {RGBColor[0, 0, 1], 
       ArrowBox[{{2.0851441405707476`, 1.668115312456598}, {
        1.6681153124565982`, 0.8340576562282989}}, 0.3]}, 
      {RGBColor[0, 0, 1], 
       ArrowBox[{{2.0851441405707476`, 1.668115312456598}, {2.502172968684897,
         0.8340576562282989}}, 0.3]}, 
      {RGBColor[0, 0, 1], 
       ArrowBox[{{1.6681153124565982`, 0.8340576562282989}, {
        1.2510864843424485`, 0.}}, 0.3]}, 
      {RGBColor[0, 0, 1], 
       ArrowBox[{{1.6681153124565982`, 0.8340576562282989}, {
        2.0851441405707476`, 0.}}, 0.3]}}, 
     GraphicsComplexBox[{{1.2510864843424485`, 2.502172968684897}, {
      0.41702882811414954`, 1.668115312456598}, {0., 0.8340576562282989}, {
      0.8340576562282991, 0.8340576562282989}, {2.0851441405707476`, 
      1.668115312456598}, {1.6681153124565982`, 0.8340576562282989}, {
      1.2510864843424485`, 0.}, {2.0851441405707476`, 0.}, {2.502172968684897,
       0.8340576562282989}}, {
       TagBox[
        TooltipBox[InsetBox[
          FrameBox[
           StyleBox["Plus", "StandardForm", "Output",
            StripOnInput->False,
            FrontFaceColor->GrayLevel[0],
            BackFaceColor->GrayLevel[0],
            GraphicsColor->GrayLevel[0],
            FontSize->Scaled[0.05],
            FontColor->GrayLevel[0]],
           Background->RGBColor[1., 1., 0.871],
           FrameStyle->GrayLevel[0.5],
           StripOnInput->False], 1],
         TagBox[
          RowBox[{
            SuperscriptBox["\[ExponentialE]", "x"], "+", 
            RowBox[{
              SuperscriptBox["\[ExponentialE]", "x"], " ", "x"}]}], 
          HoldForm]],
        Annotation[#, 
         HoldForm[E^$CellContext`x + E^$CellContext`x $CellContext`x], 
         "Tooltip"]& ], 
       TagBox[
        TooltipBox[InsetBox[
          FrameBox[
           StyleBox["Power", "StandardForm", "Output",
            StripOnInput->False,
            FrontFaceColor->GrayLevel[0],
            BackFaceColor->GrayLevel[0],
            GraphicsColor->GrayLevel[0],
            FontSize->Scaled[0.05],
            FontColor->GrayLevel[0]],
           Background->RGBColor[1., 1., 0.871],
           FrameStyle->GrayLevel[0.5],
           StripOnInput->False], 2],
         TagBox[
          SuperscriptBox["\[ExponentialE]", "x"], HoldForm]],
        Annotation[#, 
         HoldForm[E^$CellContext`x], "Tooltip"]& ], 
       TagBox[
        TooltipBox[InsetBox[
          FrameBox[
           StyleBox[
            TagBox["\[ExponentialE]",
             HoldForm], "StandardForm", "Output",
            StripOnInput->False,
            FrontFaceColor->GrayLevel[0],
            BackFaceColor->GrayLevel[0],
            GraphicsColor->GrayLevel[0],
            FontSize->Scaled[0.05],
            FontColor->GrayLevel[0]],
           Background->RGBColor[1., 1., 0.871],
           FrameStyle->GrayLevel[0.5],
           StripOnInput->False], 3],
         TagBox["\[ExponentialE]", HoldForm]],
        Annotation[#, 
         HoldForm[E], "Tooltip"]& ], 
       TagBox[
        TooltipBox[InsetBox[
          FrameBox[
           StyleBox[
            TagBox["x",
             HoldForm], "StandardForm", "Output",
            StripOnInput->False,
            FrontFaceColor->GrayLevel[0],
            BackFaceColor->GrayLevel[0],
            GraphicsColor->GrayLevel[0],
            FontSize->Scaled[0.05],
            FontColor->GrayLevel[0]],
           Background->RGBColor[1., 1., 0.871],
           FrameStyle->GrayLevel[0.5],
           StripOnInput->False], 4],
         TagBox["x", HoldForm]],
        Annotation[#, 
         HoldForm[$CellContext`x], "Tooltip"]& ], 
       TagBox[
        TooltipBox[InsetBox[
          FrameBox[
           StyleBox["Times", "StandardForm", "Output",
            StripOnInput->False,
            FrontFaceColor->GrayLevel[0],
            BackFaceColor->GrayLevel[0],
            GraphicsColor->GrayLevel[0],
            FontSize->Scaled[0.05],
            FontColor->GrayLevel[0]],
           Background->RGBColor[1., 1., 0.871],
           FrameStyle->GrayLevel[0.5],
           StripOnInput->False], 5],
         TagBox[
          RowBox[{
            SuperscriptBox["\[ExponentialE]", "x"], " ", "x"}], HoldForm]],
        Annotation[#, 
         HoldForm[E^$CellContext`x $CellContext`x], "Tooltip"]& ], 
       TagBox[
        TooltipBox[InsetBox[
          FrameBox[
           StyleBox["Power", "StandardForm", "Output",
            StripOnInput->False,
            FrontFaceColor->GrayLevel[0],
            BackFaceColor->GrayLevel[0],
            GraphicsColor->GrayLevel[0],
            FontSize->Scaled[0.05],
            FontColor->GrayLevel[0]],
           Background->RGBColor[1., 1., 0.871],
           FrameStyle->GrayLevel[0.5],
           StripOnInput->False], 6],
         TagBox[
          SuperscriptBox["\[ExponentialE]", "x"], HoldForm]],
        Annotation[#, 
         HoldForm[E^$CellContext`x], "Tooltip"]& ], 
       TagBox[
        TooltipBox[InsetBox[
          FrameBox[
           StyleBox[
            TagBox["\[ExponentialE]",
             HoldForm], "StandardForm", "Output",
            StripOnInput->False,
            FrontFaceColor->GrayLevel[0],
            BackFaceColor->GrayLevel[0],
            GraphicsColor->GrayLevel[0],
            FontSize->Scaled[0.05],
            FontColor->GrayLevel[0]],
           Background->RGBColor[1., 1., 0.871],
           FrameStyle->GrayLevel[0.5],
           StripOnInput->False], 7],
         TagBox["\[ExponentialE]", HoldForm]],
        Annotation[#, 
         HoldForm[E], "Tooltip"]& ], 
       TagBox[
        TooltipBox[InsetBox[
          FrameBox[
           StyleBox[
            TagBox["x",
             HoldForm], "StandardForm", "Output",
            StripOnInput->False,
            FrontFaceColor->GrayLevel[0],
            BackFaceColor->GrayLevel[0],
            GraphicsColor->GrayLevel[0],
            FontSize->Scaled[0.05],
            FontColor->GrayLevel[0]],
           Background->RGBColor[1., 1., 0.871],
           FrameStyle->GrayLevel[0.5],
           StripOnInput->False], 8],
         TagBox["x", HoldForm]],
        Annotation[#, 
         HoldForm[$CellContext`x], "Tooltip"]& ], 
       TagBox[
        TooltipBox[InsetBox[
          FrameBox[
           StyleBox[
            TagBox["x",
             HoldForm], "StandardForm", "Output",
            StripOnInput->False,
            FrontFaceColor->GrayLevel[0],
            BackFaceColor->GrayLevel[0],
            GraphicsColor->GrayLevel[0],
            FontSize->Scaled[0.05],
            FontColor->GrayLevel[0]],
           Background->RGBColor[1., 1., 0.871],
           FrameStyle->GrayLevel[0.5],
           StripOnInput->False], 9],
         TagBox["x", HoldForm]],
        Annotation[#, 
         HoldForm[$CellContext`x], "Tooltip"]& ]}]}],
   Annotation[#, 
    VertexCoordinateRules -> {{1.2510864843424485`, 2.502172968684897}, {
     0.41702882811414954`, 1.668115312456598}, {0., 0.8340576562282989}, {
     0.8340576562282991, 0.8340576562282989}, {2.0851441405707476`, 
     1.668115312456598}, {1.6681153124565982`, 0.8340576562282989}, {
     1.2510864843424485`, 0.}, {2.0851441405707476`, 0.}, {2.502172968684897, 
     0.8340576562282989}}]& ],
  AspectRatio->NCache[2 5^Rational[-1, 2], 0.8944271909999159],
  FrameTicks->Automatic,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{184, 143},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TreeForm=",
 CellID->666174138]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->99207776],

Cell["Draw vertices only:", "ExampleText",
 CellID->26472224],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TreeForm", "[", 
  RowBox[{
   RowBox[{"D", "[", 
    RowBox[{
     RowBox[{"x", " ", 
      RowBox[{"Exp", "[", "x", "]"}]}], ",", "x"}], "]"}], ",", " ", 
   RowBox[{"EdgeRenderingFunction", "\[Rule]", "None"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1020060192],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{1.2510864843424485`, 2.502172968684897}, {
    0.41702882811414954`, 1.668115312456598}, {0., 0.8340576562282989}, {
    0.8340576562282991, 0.8340576562282989}, {2.0851441405707476`, 
    1.668115312456598}, {1.6681153124565982`, 0.8340576562282989}, {
    1.2510864843424485`, 0.}, {2.0851441405707476`, 0.}, {2.502172968684897, 
    0.8340576562282989}}, {
     {RGBColor[0.55, 0.45, 0.45]}, {
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["Plus", "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.05],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 1],
        TagBox[
         RowBox[{
           SuperscriptBox["\[ExponentialE]", "x"], "+", 
           RowBox[{
             SuperscriptBox["\[ExponentialE]", "x"], " ", "x"}]}], HoldForm]],
       
       Annotation[#, 
        HoldForm[E^$CellContext`x + E^$CellContext`x $CellContext`x], 
        "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["Power", "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.05],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 2],
        TagBox[
         SuperscriptBox["\[ExponentialE]", "x"], HoldForm]],
       Annotation[#, 
        HoldForm[E^$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           TagBox["\[ExponentialE]",
            HoldForm], "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.05],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 3],
        TagBox["\[ExponentialE]", HoldForm]],
       Annotation[#, 
        HoldForm[E], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           TagBox["x",
            HoldForm], "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.05],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 4],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["Times", "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.05],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 5],
        TagBox[
         RowBox[{
           SuperscriptBox["\[ExponentialE]", "x"], " ", "x"}], HoldForm]],
       Annotation[#, 
        HoldForm[E^$CellContext`x $CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["Power", "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.05],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 6],
        TagBox[
         SuperscriptBox["\[ExponentialE]", "x"], HoldForm]],
       Annotation[#, 
        HoldForm[E^$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           TagBox["\[ExponentialE]",
            HoldForm], "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.05],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 7],
        TagBox["\[ExponentialE]", HoldForm]],
       Annotation[#, 
        HoldForm[E], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           TagBox["x",
            HoldForm], "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.05],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 8],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           TagBox["x",
            HoldForm], "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.05],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 9],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{1.2510864843424485`, 2.502172968684897}, {
     0.41702882811414954`, 1.668115312456598}, {0., 0.8340576562282989}, {
     0.8340576562282991, 0.8340576562282989}, {2.0851441405707476`, 
     1.668115312456598}, {1.6681153124565982`, 0.8340576562282989}, {
     1.2510864843424485`, 0.}, {2.0851441405707476`, 0.}, {2.502172968684897, 
     0.8340576562282989}}]& ],
  AspectRatio->NCache[2 5^Rational[-1, 2], 0.8944271909999159],
  FrameTicks->Automatic,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{184, 143},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TreeForm=",
 CellID->1409638575]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "LayerSizeFunction",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->230110335],

Cell["Draw a tree with the first level of height 1, second 2, etc:", \
"ExampleText",
 CellID->1920904431],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TreeForm", "[", 
  RowBox[{
   RowBox[{"Nest", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"{", 
       RowBox[{"#", ",", "#"}], "}"}], "&"}], ",", "x", ",", "4"}], "]"}], 
   ",", 
   RowBox[{"LayerSizeFunction", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{"#", "&"}], ")"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->269954683],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{2.0387260583233586`, 2.7183014110978116`}, {
    0.9514054938842341, 2.4464712699880304`}, {0.40774521166467176`, 
    1.902810987768468}, {0.13591507055489058`, 1.0873205644391246`}, {0., 
    0.}, {0.27183014110978115`, 0.}, {0.6795753527744529, 
    1.0873205644391246`}, {0.5436602822195623, 0.}, {0.8154904233293435, 
    0.}, {1.4950657761037964`, 1.902810987768468}, {1.2232356349940152`, 
    1.0873205644391246`}, {1.0873205644391246`, 0.}, {1.3591507055489058`, 
    0.}, {1.7668959172135776`, 1.0873205644391246`}, {1.630980846658687, 
    0.}, {1.9028109877684682`, 0.}, {3.1260466227624835`, 
    2.4464712699880304`}, {2.582386340542921, 1.902810987768468}, {
    2.31055619943314, 1.0873205644391246`}, {2.1746411288782492`, 0.}, {
    2.4464712699880304`, 0.}, {2.8542164816527023`, 1.0873205644391246`}, {
    2.7183014110978116`, 0.}, {2.990131552207593, 0.}, {3.669706904982046, 
    1.902810987768468}, {3.3978767638722647`, 1.0873205644391246`}, {
    3.261961693317374, 0.}, {3.5337918344271553`, 0.}, {3.941537046091827, 
    1.0873205644391246`}, {3.8056219755369365`, 0.}, {4.077452116646717, 
    0.}}, {
     {RGBColor[0.55, 0.45, 0.45], 
      LineBox[{{1, 2}, {1, 17}, {2, 3}, {2, 10}, {3, 4}, {3, 7}, {4, 5}, {4, 
       6}, {7, 8}, {7, 9}, {10, 11}, {10, 14}, {11, 12}, {11, 13}, {14, 15}, {
       14, 16}, {17, 18}, {17, 25}, {18, 19}, {18, 22}, {19, 20}, {19, 21}, {
       22, 23}, {22, 24}, {25, 26}, {25, 29}, {26, 27}, {26, 28}, {29, 30}, {
       29, 31}}]}, {
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["List", "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.025],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 1],
        TagBox[
         RowBox[{"{", 
           RowBox[{
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{
                    RowBox[{"{", 
                    RowBox[{"x", ",", "x"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"x", ",", "x"}], "}"}]}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{
                    RowBox[{"{", 
                    RowBox[{"x", ",", "x"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"x", ",", "x"}], "}"}]}], "}"}]}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{
                    RowBox[{"{", 
                    RowBox[{"x", ",", "x"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"x", ",", "x"}], "}"}]}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{
                    RowBox[{"{", 
                    RowBox[{"x", ",", "x"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"x", ",", "x"}], "}"}]}], "}"}]}], "}"}]}], "}"}],
          HoldForm]],
       Annotation[#, 
        HoldForm[{{{{$CellContext`x, $CellContext`x}, {$CellContext`x, \
$CellContext`x}}, {{$CellContext`x, $CellContext`x}, {$CellContext`x, \
$CellContext`x}}}, {{{$CellContext`x, $CellContext`x}, {$CellContext`x, \
$CellContext`x}}, {{$CellContext`x, $CellContext`x}, {$CellContext`x, \
$CellContext`x}}}}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["List", "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.025],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 2],
        TagBox[
         RowBox[{"{", 
           RowBox[{
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"x", ",", "x"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"x", ",", "x"}], "}"}]}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"x", ",", "x"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"x", ",", "x"}], "}"}]}], "}"}]}], "}"}], 
         HoldForm]],
       Annotation[#, 
        HoldForm[{{{$CellContext`x, $CellContext`x}, {$CellContext`x, \
$CellContext`x}}, {{$CellContext`x, $CellContext`x}, {$CellContext`x, \
$CellContext`x}}}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["List", "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.025],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 3],
        TagBox[
         RowBox[{"{", 
           RowBox[{
             RowBox[{"{", 
               RowBox[{"x", ",", "x"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"x", ",", "x"}], "}"}]}], "}"}], HoldForm]],
       Annotation[#, 
        HoldForm[{{$CellContext`x, $CellContext`x}, {$CellContext`x, \
$CellContext`x}}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["List", "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.025],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 4],
        TagBox[
         RowBox[{"{", 
           RowBox[{"x", ",", "x"}], "}"}], HoldForm]],
       Annotation[#, 
        HoldForm[{$CellContext`x, $CellContext`x}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           TagBox["x",
            HoldForm], "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.025],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 5],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           TagBox["x",
            HoldForm], "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.025],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 6],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["List", "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.025],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 7],
        TagBox[
         RowBox[{"{", 
           RowBox[{"x", ",", "x"}], "}"}], HoldForm]],
       Annotation[#, 
        HoldForm[{$CellContext`x, $CellContext`x}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           TagBox["x",
            HoldForm], "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.025],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 8],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           TagBox["x",
            HoldForm], "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.025],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 9],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["List", "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.025],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 10],
        TagBox[
         RowBox[{"{", 
           RowBox[{
             RowBox[{"{", 
               RowBox[{"x", ",", "x"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"x", ",", "x"}], "}"}]}], "}"}], HoldForm]],
       Annotation[#, 
        HoldForm[{{$CellContext`x, $CellContext`x}, {$CellContext`x, \
$CellContext`x}}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["List", "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.025],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 11],
        TagBox[
         RowBox[{"{", 
           RowBox[{"x", ",", "x"}], "}"}], HoldForm]],
       Annotation[#, 
        HoldForm[{$CellContext`x, $CellContext`x}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           TagBox["x",
            HoldForm], "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.025],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 12],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           TagBox["x",
            HoldForm], "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.025],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 13],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["List", "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.025],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 14],
        TagBox[
         RowBox[{"{", 
           RowBox[{"x", ",", "x"}], "}"}], HoldForm]],
       Annotation[#, 
        HoldForm[{$CellContext`x, $CellContext`x}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           TagBox["x",
            HoldForm], "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.025],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 15],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           TagBox["x",
            HoldForm], "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.025],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 16],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["List", "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.025],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 17],
        TagBox[
         RowBox[{"{", 
           RowBox[{
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"x", ",", "x"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"x", ",", "x"}], "}"}]}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"x", ",", "x"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"x", ",", "x"}], "}"}]}], "}"}]}], "}"}], 
         HoldForm]],
       Annotation[#, 
        HoldForm[{{{$CellContext`x, $CellContext`x}, {$CellContext`x, \
$CellContext`x}}, {{$CellContext`x, $CellContext`x}, {$CellContext`x, \
$CellContext`x}}}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["List", "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.025],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 18],
        TagBox[
         RowBox[{"{", 
           RowBox[{
             RowBox[{"{", 
               RowBox[{"x", ",", "x"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"x", ",", "x"}], "}"}]}], "}"}], HoldForm]],
       Annotation[#, 
        HoldForm[{{$CellContext`x, $CellContext`x}, {$CellContext`x, \
$CellContext`x}}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["List", "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.025],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 19],
        TagBox[
         RowBox[{"{", 
           RowBox[{"x", ",", "x"}], "}"}], HoldForm]],
       Annotation[#, 
        HoldForm[{$CellContext`x, $CellContext`x}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           TagBox["x",
            HoldForm], "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.025],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 20],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           TagBox["x",
            HoldForm], "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.025],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 21],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["List", "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.025],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 22],
        TagBox[
         RowBox[{"{", 
           RowBox[{"x", ",", "x"}], "}"}], HoldForm]],
       Annotation[#, 
        HoldForm[{$CellContext`x, $CellContext`x}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           TagBox["x",
            HoldForm], "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.025],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 23],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           TagBox["x",
            HoldForm], "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.025],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 24],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["List", "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.025],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 25],
        TagBox[
         RowBox[{"{", 
           RowBox[{
             RowBox[{"{", 
               RowBox[{"x", ",", "x"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"x", ",", "x"}], "}"}]}], "}"}], HoldForm]],
       Annotation[#, 
        HoldForm[{{$CellContext`x, $CellContext`x}, {$CellContext`x, \
$CellContext`x}}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["List", "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.025],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 26],
        TagBox[
         RowBox[{"{", 
           RowBox[{"x", ",", "x"}], "}"}], HoldForm]],
       Annotation[#, 
        HoldForm[{$CellContext`x, $CellContext`x}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           TagBox["x",
            HoldForm], "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.025],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 27],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           TagBox["x",
            HoldForm], "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.025],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 28],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["List", "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.025],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 29],
        TagBox[
         RowBox[{"{", 
           RowBox[{"x", ",", "x"}], "}"}], HoldForm]],
       Annotation[#, 
        HoldForm[{$CellContext`x, $CellContext`x}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           TagBox["x",
            HoldForm], "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.025],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 30],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           TagBox["x",
            HoldForm], "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.025],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 31],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{2.0387260583233586`, 2.7183014110978116`}, {
     0.9514054938842341, 2.4464712699880304`}, {0.40774521166467176`, 
     1.902810987768468}, {0.13591507055489058`, 1.0873205644391246`}, {0., 
     0.}, {0.27183014110978115`, 0.}, {0.6795753527744529, 
     1.0873205644391246`}, {0.5436602822195623, 0.}, {0.8154904233293435, 
     0.}, {1.4950657761037964`, 1.902810987768468}, {1.2232356349940152`, 
     1.0873205644391246`}, {1.0873205644391246`, 0.}, {1.3591507055489058`, 
     0.}, {1.7668959172135776`, 1.0873205644391246`}, {1.630980846658687, 
     0.}, {1.9028109877684682`, 0.}, {3.1260466227624835`, 
     2.4464712699880304`}, {2.582386340542921, 1.902810987768468}, {
     2.31055619943314, 1.0873205644391246`}, {2.1746411288782492`, 0.}, {
     2.4464712699880304`, 0.}, {2.8542164816527023`, 1.0873205644391246`}, {
     2.7183014110978116`, 0.}, {2.990131552207593, 0.}, {3.669706904982046, 
     1.902810987768468}, {3.3978767638722647`, 1.0873205644391246`}, {
     3.261961693317374, 0.}, {3.5337918344271553`, 0.}, {3.941537046091827, 
     1.0873205644391246`}, {3.8056219755369365`, 0.}, {4.077452116646717, 
     0.}}]& ],
  AspectRatio->NCache[Rational[1, 4] 5^Rational[1, 2], 0.5590169943749475],
  FrameTicks->Automatic,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{404, 224},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{400, Automatic}},
 CellLabel->"Out[1]//TreeForm=",
 CellID->1974903844]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "PlotRangePadding",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->44888674],

Cell[TextData[{
 "Use different ",
 Cell[BoxData[
  ButtonBox["PlotRangePadding",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotRangePadding"]], "InlineFormula"],
 " around the drawing: "
}], "ExampleText",
 CellID->1808033363],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Framed", "[", 
    RowBox[{
     RowBox[{"TreeForm", "[", 
      RowBox[{
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"x", " ", 
          RowBox[{"Cos", "[", "x", "]"}], " ", 
          RowBox[{"Sin", "[", "x", "]"}]}], ",", "x"}], "]"}], ",", 
       RowBox[{"PlotRangePadding", "\[Rule]", "p"}]}], "]"}], ",", 
     RowBox[{"FrameMargins", "\[Rule]", "0"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"p", ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"Scaled", "[", "0.2", "]"}]}], "}"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->500288768],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FrameBox[
    GraphicsBox[
     TagBox[
      GraphicsComplexBox[{{2.1669453555438456`, 2.8892604740584606`}, {
       0.3611575592573076, 2.1669453555438456`}, {0., 1.4446302370292303`}, {
       0.7223151185146152, 1.4446302370292303`}, {0.3611575592573076, 
       0.722315118514615}, {0.3611575592573076, 0.}, {1.0834726777719228`, 
       0.722315118514615}, {2.1669453555438456`, 2.1669453555438456`}, {
       1.8057877962865378`, 1.4446302370292303`}, {1.8057877962865378`, 
       0.722315118514615}, {2.528102914801153, 1.4446302370292303`}, {
       2.528102914801153, 0.722315118514615}, {3.9727331518303832`, 
       2.1669453555438456`}, {3.250418033315768, 1.4446302370292303`}, {
       3.9727331518303832`, 1.4446302370292303`}, {4.695048270344999, 
       1.4446302370292303`}, {4.333890711087691, 0.722315118514615}, {
       4.333890711087691, 0.}, {5.056205829602306, 0.722315118514615}}, {
        {RGBColor[0.55, 0.45, 0.45], 
         LineBox[{{1, 2}, {1, 8}, {1, 13}, {2, 3}, {2, 4}, {4, 5}, {4, 7}, {5,
           6}, {8, 9}, {8, 11}, {9, 10}, {11, 12}, {13, 14}, {13, 15}, {13, 
          16}, {16, 17}, {16, 19}, {17, 18}}]}, {
         TagBox[
          TooltipBox[InsetBox[
            FrameBox[
             StyleBox["Plus", "StandardForm", "Output",
              StripOnInput->False,
              FrontFaceColor->GrayLevel[0],
              BackFaceColor->GrayLevel[0],
              GraphicsColor->GrayLevel[0],
              FontSize->Scaled[0.04000000000000001],
              FontColor->GrayLevel[0]],
             Background->RGBColor[1., 1., 0.871],
             FrameStyle->GrayLevel[0.5],
             StripOnInput->False], 1],
           TagBox[
            RowBox[{
              RowBox[{"x", " ", 
                SuperscriptBox[
                 RowBox[{"Cos", "[", "x", "]"}], "2"]}], "+", 
              RowBox[{
                RowBox[{"Cos", "[", "x", "]"}], " ", 
                RowBox[{"Sin", "[", "x", "]"}]}], "-", 
              RowBox[{"x", " ", 
                SuperscriptBox[
                 RowBox[{"Sin", "[", "x", "]"}], "2"]}]}], HoldForm]],
          Annotation[#, 
           
           HoldForm[$CellContext`x Cos[$CellContext`x]^2 + 
            Cos[$CellContext`x] Sin[$CellContext`x] - $CellContext`x 
            Sin[$CellContext`x]^2], "Tooltip"]& ], 
         TagBox[
          TooltipBox[InsetBox[
            FrameBox[
             StyleBox["Times", "StandardForm", "Output",
              StripOnInput->False,
              FrontFaceColor->GrayLevel[0],
              BackFaceColor->GrayLevel[0],
              GraphicsColor->GrayLevel[0],
              FontSize->Scaled[0.04000000000000001],
              FontColor->GrayLevel[0]],
             Background->RGBColor[1., 1., 0.871],
             FrameStyle->GrayLevel[0.5],
             StripOnInput->False], 2],
           TagBox[
            RowBox[{"x", " ", 
              SuperscriptBox[
               RowBox[{"Cos", "[", "x", "]"}], "2"]}], HoldForm]],
          Annotation[#, 
           HoldForm[$CellContext`x Cos[$CellContext`x]^2], "Tooltip"]& ], 
         TagBox[
          TooltipBox[InsetBox[
            FrameBox[
             StyleBox[
              TagBox["x",
               HoldForm], "StandardForm", "Output",
              StripOnInput->False,
              FrontFaceColor->GrayLevel[0],
              BackFaceColor->GrayLevel[0],
              GraphicsColor->GrayLevel[0],
              FontSize->Scaled[0.04000000000000001],
              FontColor->GrayLevel[0]],
             Background->RGBColor[1., 1., 0.871],
             FrameStyle->GrayLevel[0.5],
             StripOnInput->False], 3],
           TagBox["x", HoldForm]],
          Annotation[#, 
           HoldForm[$CellContext`x], "Tooltip"]& ], 
         TagBox[
          TooltipBox[InsetBox[
            FrameBox[
             StyleBox["Power", "StandardForm", "Output",
              StripOnInput->False,
              FrontFaceColor->GrayLevel[0],
              BackFaceColor->GrayLevel[0],
              GraphicsColor->GrayLevel[0],
              FontSize->Scaled[0.04000000000000001],
              FontColor->GrayLevel[0]],
             Background->RGBColor[1., 1., 0.871],
             FrameStyle->GrayLevel[0.5],
             StripOnInput->False], 4],
           TagBox[
            SuperscriptBox[
             RowBox[{"Cos", "[", "x", "]"}], "2"], HoldForm]],
          Annotation[#, 
           HoldForm[Cos[$CellContext`x]^2], "Tooltip"]& ], 
         TagBox[
          TooltipBox[InsetBox[
            FrameBox[
             StyleBox["Cos", "StandardForm", "Output",
              StripOnInput->False,
              FrontFaceColor->GrayLevel[0],
              BackFaceColor->GrayLevel[0],
              GraphicsColor->GrayLevel[0],
              FontSize->Scaled[0.04000000000000001],
              FontColor->GrayLevel[0]],
             Background->RGBColor[1., 1., 0.871],
             FrameStyle->GrayLevel[0.5],
             StripOnInput->False], 5],
           TagBox[
            RowBox[{"Cos", "[", "x", "]"}], HoldForm]],
          Annotation[#, 
           HoldForm[
            Cos[$CellContext`x]], "Tooltip"]& ], 
         TagBox[
          TooltipBox[InsetBox[
            FrameBox[
             StyleBox[
              TagBox["x",
               HoldForm], "StandardForm", "Output",
              StripOnInput->False,
              FrontFaceColor->GrayLevel[0],
              BackFaceColor->GrayLevel[0],
              GraphicsColor->GrayLevel[0],
              FontSize->Scaled[0.04000000000000001],
              FontColor->GrayLevel[0]],
             Background->RGBColor[1., 1., 0.871],
             FrameStyle->GrayLevel[0.5],
             StripOnInput->False], 6],
           TagBox["x", HoldForm]],
          Annotation[#, 
           HoldForm[$CellContext`x], "Tooltip"]& ], 
         TagBox[
          TooltipBox[InsetBox[
            FrameBox[
             StyleBox[
              TagBox["2",
               HoldForm], "StandardForm", "Output",
              StripOnInput->False,
              FrontFaceColor->GrayLevel[0],
              BackFaceColor->GrayLevel[0],
              GraphicsColor->GrayLevel[0],
              FontSize->Scaled[0.04000000000000001],
              FontColor->GrayLevel[0]],
             Background->RGBColor[1., 1., 0.871],
             FrameStyle->GrayLevel[0.5],
             StripOnInput->False], 7],
           TagBox["2", HoldForm]],
          Annotation[#, 
           HoldForm[2], "Tooltip"]& ], 
         TagBox[
          TooltipBox[InsetBox[
            FrameBox[
             StyleBox["Times", "StandardForm", "Output",
              StripOnInput->False,
              FrontFaceColor->GrayLevel[0],
              BackFaceColor->GrayLevel[0],
              GraphicsColor->GrayLevel[0],
              FontSize->Scaled[0.04000000000000001],
              FontColor->GrayLevel[0]],
             Background->RGBColor[1., 1., 0.871],
             FrameStyle->GrayLevel[0.5],
             StripOnInput->False], 8],
           TagBox[
            RowBox[{
              RowBox[{"Cos", "[", "x", "]"}], " ", 
              RowBox[{"Sin", "[", "x", "]"}]}], HoldForm]],
          Annotation[#, 
           HoldForm[Cos[$CellContext`x] Sin[$CellContext`x]], "Tooltip"]& ], 
         TagBox[
          TooltipBox[InsetBox[
            FrameBox[
             StyleBox["Cos", "StandardForm", "Output",
              StripOnInput->False,
              FrontFaceColor->GrayLevel[0],
              BackFaceColor->GrayLevel[0],
              GraphicsColor->GrayLevel[0],
              FontSize->Scaled[0.04000000000000001],
              FontColor->GrayLevel[0]],
             Background->RGBColor[1., 1., 0.871],
             FrameStyle->GrayLevel[0.5],
             StripOnInput->False], 9],
           TagBox[
            RowBox[{"Cos", "[", "x", "]"}], HoldForm]],
          Annotation[#, 
           HoldForm[
            Cos[$CellContext`x]], "Tooltip"]& ], 
         TagBox[
          TooltipBox[InsetBox[
            FrameBox[
             StyleBox[
              TagBox["x",
               HoldForm], "StandardForm", "Output",
              StripOnInput->False,
              FrontFaceColor->GrayLevel[0],
              BackFaceColor->GrayLevel[0],
              GraphicsColor->GrayLevel[0],
              FontSize->Scaled[0.04000000000000001],
              FontColor->GrayLevel[0]],
             Background->RGBColor[1., 1., 0.871],
             FrameStyle->GrayLevel[0.5],
             StripOnInput->False], 10],
           TagBox["x", HoldForm]],
          Annotation[#, 
           HoldForm[$CellContext`x], "Tooltip"]& ], 
         TagBox[
          TooltipBox[InsetBox[
            FrameBox[
             StyleBox["Sin", "StandardForm", "Output",
              StripOnInput->False,
              FrontFaceColor->GrayLevel[0],
              BackFaceColor->GrayLevel[0],
              GraphicsColor->GrayLevel[0],
              FontSize->Scaled[0.04000000000000001],
              FontColor->GrayLevel[0]],
             Background->RGBColor[1., 1., 0.871],
             FrameStyle->GrayLevel[0.5],
             StripOnInput->False], 11],
           TagBox[
            RowBox[{"Sin", "[", "x", "]"}], HoldForm]],
          Annotation[#, 
           HoldForm[
            Sin[$CellContext`x]], "Tooltip"]& ], 
         TagBox[
          TooltipBox[InsetBox[
            FrameBox[
             StyleBox[
              TagBox["x",
               HoldForm], "StandardForm", "Output",
              StripOnInput->False,
              FrontFaceColor->GrayLevel[0],
              BackFaceColor->GrayLevel[0],
              GraphicsColor->GrayLevel[0],
              FontSize->Scaled[0.04000000000000001],
              FontColor->GrayLevel[0]],
             Background->RGBColor[1., 1., 0.871],
             FrameStyle->GrayLevel[0.5],
             StripOnInput->False], 12],
           TagBox["x", HoldForm]],
          Annotation[#, 
           HoldForm[$CellContext`x], "Tooltip"]& ], 
         TagBox[
          TooltipBox[InsetBox[
            FrameBox[
             StyleBox["Times", "StandardForm", "Output",
              StripOnInput->False,
              FrontFaceColor->GrayLevel[0],
              BackFaceColor->GrayLevel[0],
              GraphicsColor->GrayLevel[0],
              FontSize->Scaled[0.04000000000000001],
              FontColor->GrayLevel[0]],
             Background->RGBColor[1., 1., 0.871],
             FrameStyle->GrayLevel[0.5],
             StripOnInput->False], 13],
           TagBox[
            RowBox[{
              RowBox[{"-", "x"}], " ", 
              SuperscriptBox[
               RowBox[{"Sin", "[", "x", "]"}], "2"]}], HoldForm]],
          Annotation[#, 
           HoldForm[-$CellContext`x Sin[$CellContext`x]^2], "Tooltip"]& ], 
         TagBox[
          TooltipBox[InsetBox[
            FrameBox[
             StyleBox[
              TagBox[
               RowBox[{"-", "1"}],
               HoldForm], "StandardForm", "Output",
              StripOnInput->False,
              FrontFaceColor->GrayLevel[0],
              BackFaceColor->GrayLevel[0],
              GraphicsColor->GrayLevel[0],
              FontSize->Scaled[0.04000000000000001],
              FontColor->GrayLevel[0]],
             Background->RGBColor[1., 1., 0.871],
             FrameStyle->GrayLevel[0.5],
             StripOnInput->False], 14],
           TagBox[
            RowBox[{"-", "1"}], HoldForm]],
          Annotation[#, 
           HoldForm[-1], "Tooltip"]& ], 
         TagBox[
          TooltipBox[InsetBox[
            FrameBox[
             StyleBox[
              TagBox["x",
               HoldForm], "StandardForm", "Output",
              StripOnInput->False,
              FrontFaceColor->GrayLevel[0],
              BackFaceColor->GrayLevel[0],
              GraphicsColor->GrayLevel[0],
              FontSize->Scaled[0.04000000000000001],
              FontColor->GrayLevel[0]],
             Background->RGBColor[1., 1., 0.871],
             FrameStyle->GrayLevel[0.5],
             StripOnInput->False], 15],
           TagBox["x", HoldForm]],
          Annotation[#, 
           HoldForm[$CellContext`x], "Tooltip"]& ], 
         TagBox[
          TooltipBox[InsetBox[
            FrameBox[
             StyleBox["Power", "StandardForm", "Output",
              StripOnInput->False,
              FrontFaceColor->GrayLevel[0],
              BackFaceColor->GrayLevel[0],
              GraphicsColor->GrayLevel[0],
              FontSize->Scaled[0.04000000000000001],
              FontColor->GrayLevel[0]],
             Background->RGBColor[1., 1., 0.871],
             FrameStyle->GrayLevel[0.5],
             StripOnInput->False], 16],
           TagBox[
            SuperscriptBox[
             RowBox[{"Sin", "[", "x", "]"}], "2"], HoldForm]],
          Annotation[#, 
           HoldForm[Sin[$CellContext`x]^2], "Tooltip"]& ], 
         TagBox[
          TooltipBox[InsetBox[
            FrameBox[
             StyleBox["Sin", "StandardForm", "Output",
              StripOnInput->False,
              FrontFaceColor->GrayLevel[0],
              BackFaceColor->GrayLevel[0],
              GraphicsColor->GrayLevel[0],
              FontSize->Scaled[0.04000000000000001],
              FontColor->GrayLevel[0]],
             Background->RGBColor[1., 1., 0.871],
             FrameStyle->GrayLevel[0.5],
             StripOnInput->False], 17],
           TagBox[
            RowBox[{"Sin", "[", "x", "]"}], HoldForm]],
          Annotation[#, 
           HoldForm[
            Sin[$CellContext`x]], "Tooltip"]& ], 
         TagBox[
          TooltipBox[InsetBox[
            FrameBox[
             StyleBox[
              TagBox["x",
               HoldForm], "StandardForm", "Output",
              StripOnInput->False,
              FrontFaceColor->GrayLevel[0],
              BackFaceColor->GrayLevel[0],
              GraphicsColor->GrayLevel[0],
              FontSize->Scaled[0.04000000000000001],
              FontColor->GrayLevel[0]],
             Background->RGBColor[1., 1., 0.871],
             FrameStyle->GrayLevel[0.5],
             StripOnInput->False], 18],
           TagBox["x", HoldForm]],
          Annotation[#, 
           HoldForm[$CellContext`x], "Tooltip"]& ], 
         TagBox[
          TooltipBox[InsetBox[
            FrameBox[
             StyleBox[
              TagBox["2",
               HoldForm], "StandardForm", "Output",
              StripOnInput->False,
              FrontFaceColor->GrayLevel[0],
              BackFaceColor->GrayLevel[0],
              GraphicsColor->GrayLevel[0],
              FontSize->Scaled[0.04000000000000001],
              FontColor->GrayLevel[0]],
             Background->RGBColor[1., 1., 0.871],
             FrameStyle->GrayLevel[0.5],
             StripOnInput->False], 19],
           TagBox["2", HoldForm]],
          Annotation[#, 
           HoldForm[2], "Tooltip"]& ]}}],
      Annotation[#, 
       VertexCoordinateRules -> {{2.1669453555438456`, 2.8892604740584606`}, {
        0.3611575592573076, 2.1669453555438456`}, {0., 1.4446302370292303`}, {
        0.7223151185146152, 1.4446302370292303`}, {0.3611575592573076, 
        0.722315118514615}, {0.3611575592573076, 0.}, {1.0834726777719228`, 
        0.722315118514615}, {2.1669453555438456`, 2.1669453555438456`}, {
        1.8057877962865378`, 1.4446302370292303`}, {1.8057877962865378`, 
        0.722315118514615}, {2.528102914801153, 1.4446302370292303`}, {
        2.528102914801153, 0.722315118514615}, {3.9727331518303832`, 
        2.1669453555438456`}, {3.250418033315768, 1.4446302370292303`}, {
        3.9727331518303832`, 1.4446302370292303`}, {4.695048270344999, 
        1.4446302370292303`}, {4.333890711087691, 0.722315118514615}, {
        4.333890711087691, 0.}, {5.056205829602306, 0.722315118514615}}]& ],
     AspectRatio->NCache[2^Rational[-1, 2], 0.7071067811865475],
     FrameTicks->Automatic,
     PlotRange->All,
     PlotRangePadding->0],
    FrameMargins->0,
    StripOnInput->False], ",", 
   FrameBox[
    GraphicsBox[
     TagBox[
      GraphicsComplexBox[{{2.1669453555438456`, 2.8892604740584606`}, {
       0.3611575592573076, 2.1669453555438456`}, {0., 1.4446302370292303`}, {
       0.7223151185146152, 1.4446302370292303`}, {0.3611575592573076, 
       0.722315118514615}, {0.3611575592573076, 0.}, {1.0834726777719228`, 
       0.722315118514615}, {2.1669453555438456`, 2.1669453555438456`}, {
       1.8057877962865378`, 1.4446302370292303`}, {1.8057877962865378`, 
       0.722315118514615}, {2.528102914801153, 1.4446302370292303`}, {
       2.528102914801153, 0.722315118514615}, {3.9727331518303832`, 
       2.1669453555438456`}, {3.250418033315768, 1.4446302370292303`}, {
       3.9727331518303832`, 1.4446302370292303`}, {4.695048270344999, 
       1.4446302370292303`}, {4.333890711087691, 0.722315118514615}, {
       4.333890711087691, 0.}, {5.056205829602306, 0.722315118514615}}, {
        {RGBColor[0.55, 0.45, 0.45], 
         LineBox[{{1, 2}, {1, 8}, {1, 13}, {2, 3}, {2, 4}, {4, 5}, {4, 7}, {5,
           6}, {8, 9}, {8, 11}, {9, 10}, {11, 12}, {13, 14}, {13, 15}, {13, 
          16}, {16, 17}, {16, 19}, {17, 18}}]}, {
         TagBox[
          TooltipBox[InsetBox[
            FrameBox[
             StyleBox["Plus", "StandardForm", "Output",
              StripOnInput->False,
              FrontFaceColor->GrayLevel[0],
              BackFaceColor->GrayLevel[0],
              GraphicsColor->GrayLevel[0],
              FontSize->Scaled[0.04000000000000001],
              FontColor->GrayLevel[0]],
             Background->RGBColor[1., 1., 0.871],
             FrameStyle->GrayLevel[0.5],
             StripOnInput->False], 1],
           TagBox[
            RowBox[{
              RowBox[{"x", " ", 
                SuperscriptBox[
                 RowBox[{"Cos", "[", "x", "]"}], "2"]}], "+", 
              RowBox[{
                RowBox[{"Cos", "[", "x", "]"}], " ", 
                RowBox[{"Sin", "[", "x", "]"}]}], "-", 
              RowBox[{"x", " ", 
                SuperscriptBox[
                 RowBox[{"Sin", "[", "x", "]"}], "2"]}]}], HoldForm]],
          Annotation[#, 
           
           HoldForm[$CellContext`x Cos[$CellContext`x]^2 + 
            Cos[$CellContext`x] Sin[$CellContext`x] - $CellContext`x 
            Sin[$CellContext`x]^2], "Tooltip"]& ], 
         TagBox[
          TooltipBox[InsetBox[
            FrameBox[
             StyleBox["Times", "StandardForm", "Output",
              StripOnInput->False,
              FrontFaceColor->GrayLevel[0],
              BackFaceColor->GrayLevel[0],
              GraphicsColor->GrayLevel[0],
              FontSize->Scaled[0.04000000000000001],
              FontColor->GrayLevel[0]],
             Background->RGBColor[1., 1., 0.871],
             FrameStyle->GrayLevel[0.5],
             StripOnInput->False], 2],
           TagBox[
            RowBox[{"x", " ", 
              SuperscriptBox[
               RowBox[{"Cos", "[", "x", "]"}], "2"]}], HoldForm]],
          Annotation[#, 
           HoldForm[$CellContext`x Cos[$CellContext`x]^2], "Tooltip"]& ], 
         TagBox[
          TooltipBox[InsetBox[
            FrameBox[
             StyleBox[
              TagBox["x",
               HoldForm], "StandardForm", "Output",
              StripOnInput->False,
              FrontFaceColor->GrayLevel[0],
              BackFaceColor->GrayLevel[0],
              GraphicsColor->GrayLevel[0],
              FontSize->Scaled[0.04000000000000001],
              FontColor->GrayLevel[0]],
             Background->RGBColor[1., 1., 0.871],
             FrameStyle->GrayLevel[0.5],
             StripOnInput->False], 3],
           TagBox["x", HoldForm]],
          Annotation[#, 
           HoldForm[$CellContext`x], "Tooltip"]& ], 
         TagBox[
          TooltipBox[InsetBox[
            FrameBox[
             StyleBox["Power", "StandardForm", "Output",
              StripOnInput->False,
              FrontFaceColor->GrayLevel[0],
              BackFaceColor->GrayLevel[0],
              GraphicsColor->GrayLevel[0],
              FontSize->Scaled[0.04000000000000001],
              FontColor->GrayLevel[0]],
             Background->RGBColor[1., 1., 0.871],
             FrameStyle->GrayLevel[0.5],
             StripOnInput->False], 4],
           TagBox[
            SuperscriptBox[
             RowBox[{"Cos", "[", "x", "]"}], "2"], HoldForm]],
          Annotation[#, 
           HoldForm[Cos[$CellContext`x]^2], "Tooltip"]& ], 
         TagBox[
          TooltipBox[InsetBox[
            FrameBox[
             StyleBox["Cos", "StandardForm", "Output",
              StripOnInput->False,
              FrontFaceColor->GrayLevel[0],
              BackFaceColor->GrayLevel[0],
              GraphicsColor->GrayLevel[0],
              FontSize->Scaled[0.04000000000000001],
              FontColor->GrayLevel[0]],
             Background->RGBColor[1., 1., 0.871],
             FrameStyle->GrayLevel[0.5],
             StripOnInput->False], 5],
           TagBox[
            RowBox[{"Cos", "[", "x", "]"}], HoldForm]],
          Annotation[#, 
           HoldForm[
            Cos[$CellContext`x]], "Tooltip"]& ], 
         TagBox[
          TooltipBox[InsetBox[
            FrameBox[
             StyleBox[
              TagBox["x",
               HoldForm], "StandardForm", "Output",
              StripOnInput->False,
              FrontFaceColor->GrayLevel[0],
              BackFaceColor->GrayLevel[0],
              GraphicsColor->GrayLevel[0],
              FontSize->Scaled[0.04000000000000001],
              FontColor->GrayLevel[0]],
             Background->RGBColor[1., 1., 0.871],
             FrameStyle->GrayLevel[0.5],
             StripOnInput->False], 6],
           TagBox["x", HoldForm]],
          Annotation[#, 
           HoldForm[$CellContext`x], "Tooltip"]& ], 
         TagBox[
          TooltipBox[InsetBox[
            FrameBox[
             StyleBox[
              TagBox["2",
               HoldForm], "StandardForm", "Output",
              StripOnInput->False,
              FrontFaceColor->GrayLevel[0],
              BackFaceColor->GrayLevel[0],
              GraphicsColor->GrayLevel[0],
              FontSize->Scaled[0.04000000000000001],
              FontColor->GrayLevel[0]],
             Background->RGBColor[1., 1., 0.871],
             FrameStyle->GrayLevel[0.5],
             StripOnInput->False], 7],
           TagBox["2", HoldForm]],
          Annotation[#, 
           HoldForm[2], "Tooltip"]& ], 
         TagBox[
          TooltipBox[InsetBox[
            FrameBox[
             StyleBox["Times", "StandardForm", "Output",
              StripOnInput->False,
              FrontFaceColor->GrayLevel[0],
              BackFaceColor->GrayLevel[0],
              GraphicsColor->GrayLevel[0],
              FontSize->Scaled[0.04000000000000001],
              FontColor->GrayLevel[0]],
             Background->RGBColor[1., 1., 0.871],
             FrameStyle->GrayLevel[0.5],
             StripOnInput->False], 8],
           TagBox[
            RowBox[{
              RowBox[{"Cos", "[", "x", "]"}], " ", 
              RowBox[{"Sin", "[", "x", "]"}]}], HoldForm]],
          Annotation[#, 
           HoldForm[Cos[$CellContext`x] Sin[$CellContext`x]], "Tooltip"]& ], 
         TagBox[
          TooltipBox[InsetBox[
            FrameBox[
             StyleBox["Cos", "StandardForm", "Output",
              StripOnInput->False,
              FrontFaceColor->GrayLevel[0],
              BackFaceColor->GrayLevel[0],
              GraphicsColor->GrayLevel[0],
              FontSize->Scaled[0.04000000000000001],
              FontColor->GrayLevel[0]],
             Background->RGBColor[1., 1., 0.871],
             FrameStyle->GrayLevel[0.5],
             StripOnInput->False], 9],
           TagBox[
            RowBox[{"Cos", "[", "x", "]"}], HoldForm]],
          Annotation[#, 
           HoldForm[
            Cos[$CellContext`x]], "Tooltip"]& ], 
         TagBox[
          TooltipBox[InsetBox[
            FrameBox[
             StyleBox[
              TagBox["x",
               HoldForm], "StandardForm", "Output",
              StripOnInput->False,
              FrontFaceColor->GrayLevel[0],
              BackFaceColor->GrayLevel[0],
              GraphicsColor->GrayLevel[0],
              FontSize->Scaled[0.04000000000000001],
              FontColor->GrayLevel[0]],
             Background->RGBColor[1., 1., 0.871],
             FrameStyle->GrayLevel[0.5],
             StripOnInput->False], 10],
           TagBox["x", HoldForm]],
          Annotation[#, 
           HoldForm[$CellContext`x], "Tooltip"]& ], 
         TagBox[
          TooltipBox[InsetBox[
            FrameBox[
             StyleBox["Sin", "StandardForm", "Output",
              StripOnInput->False,
              FrontFaceColor->GrayLevel[0],
              BackFaceColor->GrayLevel[0],
              GraphicsColor->GrayLevel[0],
              FontSize->Scaled[0.04000000000000001],
              FontColor->GrayLevel[0]],
             Background->RGBColor[1., 1., 0.871],
             FrameStyle->GrayLevel[0.5],
             StripOnInput->False], 11],
           TagBox[
            RowBox[{"Sin", "[", "x", "]"}], HoldForm]],
          Annotation[#, 
           HoldForm[
            Sin[$CellContext`x]], "Tooltip"]& ], 
         TagBox[
          TooltipBox[InsetBox[
            FrameBox[
             StyleBox[
              TagBox["x",
               HoldForm], "StandardForm", "Output",
              StripOnInput->False,
              FrontFaceColor->GrayLevel[0],
              BackFaceColor->GrayLevel[0],
              GraphicsColor->GrayLevel[0],
              FontSize->Scaled[0.04000000000000001],
              FontColor->GrayLevel[0]],
             Background->RGBColor[1., 1., 0.871],
             FrameStyle->GrayLevel[0.5],
             StripOnInput->False], 12],
           TagBox["x", HoldForm]],
          Annotation[#, 
           HoldForm[$CellContext`x], "Tooltip"]& ], 
         TagBox[
          TooltipBox[InsetBox[
            FrameBox[
             StyleBox["Times", "StandardForm", "Output",
              StripOnInput->False,
              FrontFaceColor->GrayLevel[0],
              BackFaceColor->GrayLevel[0],
              GraphicsColor->GrayLevel[0],
              FontSize->Scaled[0.04000000000000001],
              FontColor->GrayLevel[0]],
             Background->RGBColor[1., 1., 0.871],
             FrameStyle->GrayLevel[0.5],
             StripOnInput->False], 13],
           TagBox[
            RowBox[{
              RowBox[{"-", "x"}], " ", 
              SuperscriptBox[
               RowBox[{"Sin", "[", "x", "]"}], "2"]}], HoldForm]],
          Annotation[#, 
           HoldForm[-$CellContext`x Sin[$CellContext`x]^2], "Tooltip"]& ], 
         TagBox[
          TooltipBox[InsetBox[
            FrameBox[
             StyleBox[
              TagBox[
               RowBox[{"-", "1"}],
               HoldForm], "StandardForm", "Output",
              StripOnInput->False,
              FrontFaceColor->GrayLevel[0],
              BackFaceColor->GrayLevel[0],
              GraphicsColor->GrayLevel[0],
              FontSize->Scaled[0.04000000000000001],
              FontColor->GrayLevel[0]],
             Background->RGBColor[1., 1., 0.871],
             FrameStyle->GrayLevel[0.5],
             StripOnInput->False], 14],
           TagBox[
            RowBox[{"-", "1"}], HoldForm]],
          Annotation[#, 
           HoldForm[-1], "Tooltip"]& ], 
         TagBox[
          TooltipBox[InsetBox[
            FrameBox[
             StyleBox[
              TagBox["x",
               HoldForm], "StandardForm", "Output",
              StripOnInput->False,
              FrontFaceColor->GrayLevel[0],
              BackFaceColor->GrayLevel[0],
              GraphicsColor->GrayLevel[0],
              FontSize->Scaled[0.04000000000000001],
              FontColor->GrayLevel[0]],
             Background->RGBColor[1., 1., 0.871],
             FrameStyle->GrayLevel[0.5],
             StripOnInput->False], 15],
           TagBox["x", HoldForm]],
          Annotation[#, 
           HoldForm[$CellContext`x], "Tooltip"]& ], 
         TagBox[
          TooltipBox[InsetBox[
            FrameBox[
             StyleBox["Power", "StandardForm", "Output",
              StripOnInput->False,
              FrontFaceColor->GrayLevel[0],
              BackFaceColor->GrayLevel[0],
              GraphicsColor->GrayLevel[0],
              FontSize->Scaled[0.04000000000000001],
              FontColor->GrayLevel[0]],
             Background->RGBColor[1., 1., 0.871],
             FrameStyle->GrayLevel[0.5],
             StripOnInput->False], 16],
           TagBox[
            SuperscriptBox[
             RowBox[{"Sin", "[", "x", "]"}], "2"], HoldForm]],
          Annotation[#, 
           HoldForm[Sin[$CellContext`x]^2], "Tooltip"]& ], 
         TagBox[
          TooltipBox[InsetBox[
            FrameBox[
             StyleBox["Sin", "StandardForm", "Output",
              StripOnInput->False,
              FrontFaceColor->GrayLevel[0],
              BackFaceColor->GrayLevel[0],
              GraphicsColor->GrayLevel[0],
              FontSize->Scaled[0.04000000000000001],
              FontColor->GrayLevel[0]],
             Background->RGBColor[1., 1., 0.871],
             FrameStyle->GrayLevel[0.5],
             StripOnInput->False], 17],
           TagBox[
            RowBox[{"Sin", "[", "x", "]"}], HoldForm]],
          Annotation[#, 
           HoldForm[
            Sin[$CellContext`x]], "Tooltip"]& ], 
         TagBox[
          TooltipBox[InsetBox[
            FrameBox[
             StyleBox[
              TagBox["x",
               HoldForm], "StandardForm", "Output",
              StripOnInput->False,
              FrontFaceColor->GrayLevel[0],
              BackFaceColor->GrayLevel[0],
              GraphicsColor->GrayLevel[0],
              FontSize->Scaled[0.04000000000000001],
              FontColor->GrayLevel[0]],
             Background->RGBColor[1., 1., 0.871],
             FrameStyle->GrayLevel[0.5],
             StripOnInput->False], 18],
           TagBox["x", HoldForm]],
          Annotation[#, 
           HoldForm[$CellContext`x], "Tooltip"]& ], 
         TagBox[
          TooltipBox[InsetBox[
            FrameBox[
             StyleBox[
              TagBox["2",
               HoldForm], "StandardForm", "Output",
              StripOnInput->False,
              FrontFaceColor->GrayLevel[0],
              BackFaceColor->GrayLevel[0],
              GraphicsColor->GrayLevel[0],
              FontSize->Scaled[0.04000000000000001],
              FontColor->GrayLevel[0]],
             Background->RGBColor[1., 1., 0.871],
             FrameStyle->GrayLevel[0.5],
             StripOnInput->False], 19],
           TagBox["2", HoldForm]],
          Annotation[#, 
           HoldForm[2], "Tooltip"]& ]}}],
      Annotation[#, 
       VertexCoordinateRules -> {{2.1669453555438456`, 2.8892604740584606`}, {
        0.3611575592573076, 2.1669453555438456`}, {0., 1.4446302370292303`}, {
        0.7223151185146152, 1.4446302370292303`}, {0.3611575592573076, 
        0.722315118514615}, {0.3611575592573076, 0.}, {1.0834726777719228`, 
        0.722315118514615}, {2.1669453555438456`, 2.1669453555438456`}, {
        1.8057877962865378`, 1.4446302370292303`}, {1.8057877962865378`, 
        0.722315118514615}, {2.528102914801153, 1.4446302370292303`}, {
        2.528102914801153, 0.722315118514615}, {3.9727331518303832`, 
        2.1669453555438456`}, {3.250418033315768, 1.4446302370292303`}, {
        3.9727331518303832`, 1.4446302370292303`}, {4.695048270344999, 
        1.4446302370292303`}, {4.333890711087691, 0.722315118514615}, {
        4.333890711087691, 0.}, {5.056205829602306, 0.722315118514615}}]& ],
     AspectRatio->NCache[2^Rational[-1, 2], 0.7071067811865475],
     FrameTicks->Automatic,
     PlotRange->All,
     PlotRangePadding->Scaled[0.2]],
    FrameMargins->0,
    StripOnInput->False]}], "}"}]], "Output",
 ImageSize->{394, 132},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->957178633]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "PlotStyle",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->179618439],

Cell["Specify an overall style for the drawing: ", "ExampleText",
 CellID->1676190373],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"TreeForm", "[", 
    RowBox[{
     RowBox[{"Cos", "[", 
      RowBox[{"Exp", "[", "x", "]"}], "]"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", "ps"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"ps", ",", 
     RowBox[{"{", 
      RowBox[{"Red", ",", 
       RowBox[{"PointSize", "[", "Medium", "]"}], ",", "Dashed", ",", 
       RowBox[{"Directive", "[", 
        RowBox[{"Red", ",", 
         RowBox[{"PointSize", "[", "Medium", "]"}], ",", "Dashed"}], "]"}]}], 
      "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->14566157],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[
    TagBox[
     GraphicsComplexBox[{{0.4629100498862757, 1.8516401995451028`}, {
      0.4629100498862757, 0.9258200997725514}, {0., 0.}, {0.9258200997725514, 
      0.}}, {
       {RGBColor[1, 0, 0], LineBox[{{1, 2}, {2, 3}, {2, 4}}]}, 
       {RGBColor[1, 0, 0], 
        TagBox[
         TooltipBox[InsetBox[
           FrameBox[
            StyleBox["Cos", "StandardForm", "Output",
             StripOnInput->False,
             FrontFaceColor->GrayLevel[0],
             BackFaceColor->GrayLevel[0],
             GraphicsColor->GrayLevel[0],
             FontSize->Scaled[0.05],
             FontColor->GrayLevel[0]],
            Background->RGBColor[1., 1., 0.871],
            FrameStyle->GrayLevel[0.5],
            StripOnInput->False], 1],
          TagBox[
           RowBox[{"Cos", "[", 
             SuperscriptBox["\[ExponentialE]", "x"], "]"}], HoldForm]],
         Annotation[#, 
          HoldForm[
           Cos[E^$CellContext`x]], "Tooltip"]& ], 
        TagBox[
         TooltipBox[InsetBox[
           FrameBox[
            StyleBox["Power", "StandardForm", "Output",
             StripOnInput->False,
             FrontFaceColor->GrayLevel[0],
             BackFaceColor->GrayLevel[0],
             GraphicsColor->GrayLevel[0],
             FontSize->Scaled[0.05],
             FontColor->GrayLevel[0]],
            Background->RGBColor[1., 1., 0.871],
            FrameStyle->GrayLevel[0.5],
            StripOnInput->False], 2],
          TagBox[
           SuperscriptBox["\[ExponentialE]", "x"], HoldForm]],
         Annotation[#, 
          HoldForm[E^$CellContext`x], "Tooltip"]& ], 
        TagBox[
         TooltipBox[InsetBox[
           FrameBox[
            StyleBox[
             TagBox["\[ExponentialE]",
              HoldForm], "StandardForm", "Output",
             StripOnInput->False,
             FrontFaceColor->GrayLevel[0],
             BackFaceColor->GrayLevel[0],
             GraphicsColor->GrayLevel[0],
             FontSize->Scaled[0.05],
             FontColor->GrayLevel[0]],
            Background->RGBColor[1., 1., 0.871],
            FrameStyle->GrayLevel[0.5],
            StripOnInput->False], 3],
          TagBox["\[ExponentialE]", HoldForm]],
         Annotation[#, 
          HoldForm[E], "Tooltip"]& ], 
        TagBox[
         TooltipBox[InsetBox[
           FrameBox[
            StyleBox[
             TagBox["x",
              HoldForm], "StandardForm", "Output",
             StripOnInput->False,
             FrontFaceColor->GrayLevel[0],
             BackFaceColor->GrayLevel[0],
             GraphicsColor->GrayLevel[0],
             FontSize->Scaled[0.05],
             FontColor->GrayLevel[0]],
            Background->RGBColor[1., 1., 0.871],
            FrameStyle->GrayLevel[0.5],
            StripOnInput->False], 4],
          TagBox["x", HoldForm]],
         Annotation[#, 
          HoldForm[$CellContext`x], "Tooltip"]& ]}}],
     Annotation[#, 
      VertexCoordinateRules -> {{0.4629100498862757, 1.8516401995451028`}, {
       0.4629100498862757, 0.9258200997725514}, {0., 0.}, {0.9258200997725514,
        0.}}]& ],
    AspectRatio->NCache[Rational[6, 5]^Rational[1, 2], 1.0954451150103321`],
    FrameTicks->Automatic,
    PlotRange->All,
    PlotRangePadding->Scaled[0.1]], ",", 
   GraphicsBox[
    TagBox[
     GraphicsComplexBox[{{0.4629100498862757, 1.8516401995451028`}, {
      0.4629100498862757, 0.9258200997725514}, {0., 0.}, {0.9258200997725514, 
      0.}}, {
       {RGBColor[0.55, 0.45, 0.45], PointSize[Medium], 
        LineBox[{{1, 2}, {2, 3}, {2, 4}}]}, 
       {PointSize[Medium], 
        TagBox[
         TooltipBox[InsetBox[
           FrameBox[
            StyleBox["Cos", "StandardForm", "Output",
             StripOnInput->False,
             FrontFaceColor->GrayLevel[0],
             BackFaceColor->GrayLevel[0],
             GraphicsColor->GrayLevel[0],
             FontSize->Scaled[0.05],
             FontColor->GrayLevel[0]],
            Background->RGBColor[1., 1., 0.871],
            FrameStyle->GrayLevel[0.5],
            StripOnInput->False], 1],
          TagBox[
           RowBox[{"Cos", "[", 
             SuperscriptBox["\[ExponentialE]", "x"], "]"}], HoldForm]],
         Annotation[#, 
          HoldForm[
           Cos[E^$CellContext`x]], "Tooltip"]& ], 
        TagBox[
         TooltipBox[InsetBox[
           FrameBox[
            StyleBox["Power", "StandardForm", "Output",
             StripOnInput->False,
             FrontFaceColor->GrayLevel[0],
             BackFaceColor->GrayLevel[0],
             GraphicsColor->GrayLevel[0],
             FontSize->Scaled[0.05],
             FontColor->GrayLevel[0]],
            Background->RGBColor[1., 1., 0.871],
            FrameStyle->GrayLevel[0.5],
            StripOnInput->False], 2],
          TagBox[
           SuperscriptBox["\[ExponentialE]", "x"], HoldForm]],
         Annotation[#, 
          HoldForm[E^$CellContext`x], "Tooltip"]& ], 
        TagBox[
         TooltipBox[InsetBox[
           FrameBox[
            StyleBox[
             TagBox["\[ExponentialE]",
              HoldForm], "StandardForm", "Output",
             StripOnInput->False,
             FrontFaceColor->GrayLevel[0],
             BackFaceColor->GrayLevel[0],
             GraphicsColor->GrayLevel[0],
             FontSize->Scaled[0.05],
             FontColor->GrayLevel[0]],
            Background->RGBColor[1., 1., 0.871],
            FrameStyle->GrayLevel[0.5],
            StripOnInput->False], 3],
          TagBox["\[ExponentialE]", HoldForm]],
         Annotation[#, 
          HoldForm[E], "Tooltip"]& ], 
        TagBox[
         TooltipBox[InsetBox[
           FrameBox[
            StyleBox[
             TagBox["x",
              HoldForm], "StandardForm", "Output",
             StripOnInput->False,
             FrontFaceColor->GrayLevel[0],
             BackFaceColor->GrayLevel[0],
             GraphicsColor->GrayLevel[0],
             FontSize->Scaled[0.05],
             FontColor->GrayLevel[0]],
            Background->RGBColor[1., 1., 0.871],
            FrameStyle->GrayLevel[0.5],
            StripOnInput->False], 4],
          TagBox["x", HoldForm]],
         Annotation[#, 
          HoldForm[$CellContext`x], "Tooltip"]& ]}}],
     Annotation[#, 
      VertexCoordinateRules -> {{0.4629100498862757, 1.8516401995451028`}, {
       0.4629100498862757, 0.9258200997725514}, {0., 0.}, {0.9258200997725514,
        0.}}]& ],
    AspectRatio->NCache[Rational[6, 5]^Rational[1, 2], 1.0954451150103321`],
    FrameTicks->Automatic,
    PlotRange->All,
    PlotRangePadding->Scaled[0.1]], ",", 
   GraphicsBox[
    TagBox[
     GraphicsComplexBox[{{0.4629100498862757, 1.8516401995451028`}, {
      0.4629100498862757, 0.9258200997725514}, {0., 0.}, {0.9258200997725514, 
      0.}}, {
       {RGBColor[0.55, 0.45, 0.45], Dashing[{Small, Small}], 
        LineBox[{{1, 2}, {2, 3}, {2, 4}}]}, 
       {Dashing[{Small, Small}], 
        TagBox[
         TooltipBox[InsetBox[
           FrameBox[
            StyleBox["Cos", "StandardForm", "Output",
             StripOnInput->False,
             FrontFaceColor->GrayLevel[0],
             BackFaceColor->GrayLevel[0],
             GraphicsColor->GrayLevel[0],
             FontSize->Scaled[0.05],
             FontColor->GrayLevel[0]],
            Background->RGBColor[1., 1., 0.871],
            FrameStyle->GrayLevel[0.5],
            StripOnInput->False], 1],
          TagBox[
           RowBox[{"Cos", "[", 
             SuperscriptBox["\[ExponentialE]", "x"], "]"}], HoldForm]],
         Annotation[#, 
          HoldForm[
           Cos[E^$CellContext`x]], "Tooltip"]& ], 
        TagBox[
         TooltipBox[InsetBox[
           FrameBox[
            StyleBox["Power", "StandardForm", "Output",
             StripOnInput->False,
             FrontFaceColor->GrayLevel[0],
             BackFaceColor->GrayLevel[0],
             GraphicsColor->GrayLevel[0],
             FontSize->Scaled[0.05],
             FontColor->GrayLevel[0]],
            Background->RGBColor[1., 1., 0.871],
            FrameStyle->GrayLevel[0.5],
            StripOnInput->False], 2],
          TagBox[
           SuperscriptBox["\[ExponentialE]", "x"], HoldForm]],
         Annotation[#, 
          HoldForm[E^$CellContext`x], "Tooltip"]& ], 
        TagBox[
         TooltipBox[InsetBox[
           FrameBox[
            StyleBox[
             TagBox["\[ExponentialE]",
              HoldForm], "StandardForm", "Output",
             StripOnInput->False,
             FrontFaceColor->GrayLevel[0],
             BackFaceColor->GrayLevel[0],
             GraphicsColor->GrayLevel[0],
             FontSize->Scaled[0.05],
             FontColor->GrayLevel[0]],
            Background->RGBColor[1., 1., 0.871],
            FrameStyle->GrayLevel[0.5],
            StripOnInput->False], 3],
          TagBox["\[ExponentialE]", HoldForm]],
         Annotation[#, 
          HoldForm[E], "Tooltip"]& ], 
        TagBox[
         TooltipBox[InsetBox[
           FrameBox[
            StyleBox[
             TagBox["x",
              HoldForm], "StandardForm", "Output",
             StripOnInput->False,
             FrontFaceColor->GrayLevel[0],
             BackFaceColor->GrayLevel[0],
             GraphicsColor->GrayLevel[0],
             FontSize->Scaled[0.05],
             FontColor->GrayLevel[0]],
            Background->RGBColor[1., 1., 0.871],
            FrameStyle->GrayLevel[0.5],
            StripOnInput->False], 4],
          TagBox["x", HoldForm]],
         Annotation[#, 
          HoldForm[$CellContext`x], "Tooltip"]& ]}}],
     Annotation[#, 
      VertexCoordinateRules -> {{0.4629100498862757, 1.8516401995451028`}, {
       0.4629100498862757, 0.9258200997725514}, {0., 0.}, {0.9258200997725514,
        0.}}]& ],
    AspectRatio->NCache[Rational[6, 5]^Rational[1, 2], 1.0954451150103321`],
    FrameTicks->Automatic,
    PlotRange->All,
    PlotRangePadding->Scaled[0.1]], ",", 
   GraphicsBox[
    TagBox[
     GraphicsComplexBox[{{0.4629100498862757, 1.8516401995451028`}, {
      0.4629100498862757, 0.9258200997725514}, {0., 0.}, {0.9258200997725514, 
      0.}}, {
       {RGBColor[1, 0, 0], PointSize[Medium], Dashing[{Small, Small}], 
        LineBox[{{1, 2}, {2, 3}, {2, 4}}]}, 
       {RGBColor[1, 0, 0], PointSize[Medium], Dashing[{Small, Small}], 
        TagBox[
         TooltipBox[InsetBox[
           FrameBox[
            StyleBox["Cos", "StandardForm", "Output",
             StripOnInput->False,
             FrontFaceColor->GrayLevel[0],
             BackFaceColor->GrayLevel[0],
             GraphicsColor->GrayLevel[0],
             FontSize->Scaled[0.05],
             FontColor->GrayLevel[0]],
            Background->RGBColor[1., 1., 0.871],
            FrameStyle->GrayLevel[0.5],
            StripOnInput->False], 1],
          TagBox[
           RowBox[{"Cos", "[", 
             SuperscriptBox["\[ExponentialE]", "x"], "]"}], HoldForm]],
         Annotation[#, 
          HoldForm[
           Cos[E^$CellContext`x]], "Tooltip"]& ], 
        TagBox[
         TooltipBox[InsetBox[
           FrameBox[
            StyleBox["Power", "StandardForm", "Output",
             StripOnInput->False,
             FrontFaceColor->GrayLevel[0],
             BackFaceColor->GrayLevel[0],
             GraphicsColor->GrayLevel[0],
             FontSize->Scaled[0.05],
             FontColor->GrayLevel[0]],
            Background->RGBColor[1., 1., 0.871],
            FrameStyle->GrayLevel[0.5],
            StripOnInput->False], 2],
          TagBox[
           SuperscriptBox["\[ExponentialE]", "x"], HoldForm]],
         Annotation[#, 
          HoldForm[E^$CellContext`x], "Tooltip"]& ], 
        TagBox[
         TooltipBox[InsetBox[
           FrameBox[
            StyleBox[
             TagBox["\[ExponentialE]",
              HoldForm], "StandardForm", "Output",
             StripOnInput->False,
             FrontFaceColor->GrayLevel[0],
             BackFaceColor->GrayLevel[0],
             GraphicsColor->GrayLevel[0],
             FontSize->Scaled[0.05],
             FontColor->GrayLevel[0]],
            Background->RGBColor[1., 1., 0.871],
            FrameStyle->GrayLevel[0.5],
            StripOnInput->False], 3],
          TagBox["\[ExponentialE]", HoldForm]],
         Annotation[#, 
          HoldForm[E], "Tooltip"]& ], 
        TagBox[
         TooltipBox[InsetBox[
           FrameBox[
            StyleBox[
             TagBox["x",
              HoldForm], "StandardForm", "Output",
             StripOnInput->False,
             FrontFaceColor->GrayLevel[0],
             BackFaceColor->GrayLevel[0],
             GraphicsColor->GrayLevel[0],
             FontSize->Scaled[0.05],
             FontColor->GrayLevel[0]],
            Background->RGBColor[1., 1., 0.871],
            FrameStyle->GrayLevel[0.5],
            StripOnInput->False], 4],
          TagBox["x", HoldForm]],
         Annotation[#, 
          HoldForm[$CellContext`x], "Tooltip"]& ]}}],
     Annotation[#, 
      VertexCoordinateRules -> {{0.4629100498862757, 1.8516401995451028`}, {
       0.4629100498862757, 0.9258200997725514}, {0., 0.}, {0.9258200997725514,
        0.}}]& ],
    AspectRatio->NCache[Rational[6, 5]^Rational[1, 2], 1.0954451150103321`],
    FrameTicks->Automatic,
    PlotRange->All,
    PlotRangePadding->Scaled[0.1]]}], "}"}]], "Output",
 ImageSize->{452, 109},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->1375370506]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->297939305],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["PlotStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotStyle"]], "InlineFormula"],
 " can be combined with ",
 Cell[BoxData[
  ButtonBox["VertexRenderingFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/VertexRenderingFunction"]], "InlineFormula"],
 " which has higher priority: "
}], "ExampleText",
 CellID->580503372],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TreeForm", "[", 
  RowBox[{
   RowBox[{"Cos", "[", 
    RowBox[{"Exp", "[", "x", "]"}], "]"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{
      RowBox[{"PointSize", "[", "Large", "]"}], ",", "Red"}], "]"}]}], ",", 
   RowBox[{"VertexRenderingFunction", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"p", ",", "l"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"Green", ",", 
        RowBox[{"Point", "[", "p", "]"}]}], "}"}]}], "]"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->317015018],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsGroupBox[{
     GraphicsComplexBox[{{0.4629100498862757, 1.8516401995451028`}, {
      0.4629100498862757, 0.9258200997725514}, {0., 0.}, {0.9258200997725514, 
      0.}}, 
      {RGBColor[1, 0, 0], PointSize[Large], 
       LineBox[{{1, 2}, {2, 3}, {2, 4}}]}], 
     {RGBColor[1, 0, 0], PointSize[Large], 
      {RGBColor[0, 1, 0], 
       PointBox[{0.4629100498862757, 1.8516401995451028`}]}, 
      {RGBColor[0, 1, 0], 
       PointBox[{0.4629100498862757, 0.9258200997725514}]}, 
      {RGBColor[0, 1, 0], PointBox[{0., 0.}]}, 
      {RGBColor[0, 1, 0], PointBox[{0.9258200997725514, 0.}]}}}],
   Annotation[#, 
    VertexCoordinateRules -> {{0.4629100498862757, 1.8516401995451028`}, {
     0.4629100498862757, 0.9258200997725514}, {0., 0.}, {0.9258200997725514, 
     0.}}]& ],
  AspectRatio->NCache[Rational[6, 5]^Rational[1, 2], 1.0954451150103321`],
  FrameTicks->Automatic,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{184, 197},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TreeForm=",
 CellID->1098595773]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->414909817],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["PlotStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotStyle"]], "InlineFormula"],
 " can be combined with ",
 Cell[BoxData[
  ButtonBox["EdgeRenderingFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EdgeRenderingFunction"]], "InlineFormula"],
 " which has higher priority: "
}], "ExampleText",
 CellID->88626299],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TreeForm", "[", 
  RowBox[{
   RowBox[{"Cos", "[", 
    RowBox[{"Exp", "[", "x", "]"}], "]"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{"Dashed", ",", "Red"}], "]"}]}], ",", 
   RowBox[{"EdgeRenderingFunction", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"p", ",", "vl", ",", "el"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"Green", ",", 
        RowBox[{"Line", "[", "p", "]"}]}], "}"}]}], "]"}]}]}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->238367270],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsGroupBox[{
     {RGBColor[1, 0, 0], Dashing[{Small, Small}], 
      {RGBColor[0, 1, 0], 
       LineBox[{{0.4629100498862757, 1.8516401995451028`}, {
        0.4629100498862757, 0.9258200997725514}}]}, 
      {RGBColor[0, 1, 0], 
       LineBox[{{0.4629100498862757, 0.9258200997725514}, {0., 0.}}]}, 
      {RGBColor[0, 1, 0], 
       LineBox[{{0.4629100498862757, 0.9258200997725514}, {0.9258200997725514,
         0.}}]}}, 
     GraphicsComplexBox[{{0.4629100498862757, 1.8516401995451028`}, {
      0.4629100498862757, 0.9258200997725514}, {0., 0.}, {0.9258200997725514, 
      0.}}, 
      {RGBColor[1, 0, 0], Dashing[{Small, Small}], 
       TagBox[
        TooltipBox[InsetBox[
          FrameBox[
           StyleBox["Cos", "StandardForm", "Output",
            StripOnInput->False,
            FrontFaceColor->GrayLevel[0],
            BackFaceColor->GrayLevel[0],
            GraphicsColor->GrayLevel[0],
            FontSize->Scaled[0.05],
            FontColor->GrayLevel[0]],
           Background->RGBColor[1., 1., 0.871],
           FrameStyle->GrayLevel[0.5],
           StripOnInput->False], 1],
         TagBox[
          RowBox[{"Cos", "[", 
            SuperscriptBox["\[ExponentialE]", "x"], "]"}], HoldForm]],
        Annotation[#, 
         HoldForm[
          Cos[E^$CellContext`x]], "Tooltip"]& ], 
       TagBox[
        TooltipBox[InsetBox[
          FrameBox[
           StyleBox["Power", "StandardForm", "Output",
            StripOnInput->False,
            FrontFaceColor->GrayLevel[0],
            BackFaceColor->GrayLevel[0],
            GraphicsColor->GrayLevel[0],
            FontSize->Scaled[0.05],
            FontColor->GrayLevel[0]],
           Background->RGBColor[1., 1., 0.871],
           FrameStyle->GrayLevel[0.5],
           StripOnInput->False], 2],
         TagBox[
          SuperscriptBox["\[ExponentialE]", "x"], HoldForm]],
        Annotation[#, 
         HoldForm[E^$CellContext`x], "Tooltip"]& ], 
       TagBox[
        TooltipBox[InsetBox[
          FrameBox[
           StyleBox[
            TagBox["\[ExponentialE]",
             HoldForm], "StandardForm", "Output",
            StripOnInput->False,
            FrontFaceColor->GrayLevel[0],
            BackFaceColor->GrayLevel[0],
            GraphicsColor->GrayLevel[0],
            FontSize->Scaled[0.05],
            FontColor->GrayLevel[0]],
           Background->RGBColor[1., 1., 0.871],
           FrameStyle->GrayLevel[0.5],
           StripOnInput->False], 3],
         TagBox["\[ExponentialE]", HoldForm]],
        Annotation[#, 
         HoldForm[E], "Tooltip"]& ], 
       TagBox[
        TooltipBox[InsetBox[
          FrameBox[
           StyleBox[
            TagBox["x",
             HoldForm], "StandardForm", "Output",
            StripOnInput->False,
            FrontFaceColor->GrayLevel[0],
            BackFaceColor->GrayLevel[0],
            GraphicsColor->GrayLevel[0],
            FontSize->Scaled[0.05],
            FontColor->GrayLevel[0]],
           Background->RGBColor[1., 1., 0.871],
           FrameStyle->GrayLevel[0.5],
           StripOnInput->False], 4],
         TagBox["x", HoldForm]],
        Annotation[#, 
         HoldForm[$CellContext`x], "Tooltip"]& ]}]}],
   Annotation[#, 
    VertexCoordinateRules -> {{0.4629100498862757, 1.8516401995451028`}, {
     0.4629100498862757, 0.9258200997725514}, {0., 0.}, {0.9258200997725514, 
     0.}}]& ],
  AspectRatio->NCache[Rational[6, 5]^Rational[1, 2], 1.0954451150103321`],
  FrameTicks->Automatic,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{184, 197},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TreeForm=",
 CellID->2056162112]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "VertexLabeling",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->199408923],

Cell["\<\
Do not display expression heads at each node, only subtree expression as \
tooltips.\
\>", "ExampleText",
 CellID->993647161],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TreeForm", "[", 
  RowBox[{
   RowBox[{"Nest", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"{", 
       RowBox[{"#", ",", 
        RowBox[{"{", "#", "}"}], ",", "#"}], "}"}], "&"}], ",", "x", ",", 
     "3"}], "]"}], ",", 
   RowBox[{"VertexLabeling", "\[Rule]", "Automatic"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1186888853],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{5.037210932242526, 3.358140621495017}, {
    1.6790703107475085`, 2.798450517912514}, {0.5596901035825028, 
    2.2387604143300113`}, {0., 1.6790703107475085`}, {0.5596901035825028, 
    1.6790703107475085`}, {0.5596901035825028, 1.1193802071650056`}, {
    1.1193802071650056`, 1.6790703107475085`}, {1.6790703107475085`, 
    2.2387604143300113`}, {1.6790703107475085`, 1.6790703107475085`}, {
    1.1193802071650056`, 1.1193802071650056`}, {1.6790703107475085`, 
    1.1193802071650056`}, {1.6790703107475085`, 0.5596901035825028}, {
    2.2387604143300113`, 1.1193802071650056`}, {2.798450517912514, 
    2.2387604143300113`}, {2.2387604143300113`, 1.6790703107475085`}, {
    2.798450517912514, 1.6790703107475085`}, {2.798450517912514, 
    1.1193802071650056`}, {3.358140621495017, 1.6790703107475085`}, {
    5.037210932242526, 2.798450517912514}, {5.037210932242526, 
    2.2387604143300113`}, {3.91783072507752, 1.6790703107475085`}, {
    3.358140621495017, 1.1193802071650056`}, {3.91783072507752, 
    1.1193802071650056`}, {3.91783072507752, 0.5596901035825028}, {
    4.4775208286600225`, 1.1193802071650056`}, {5.037210932242526, 
    1.6790703107475085`}, {5.037210932242526, 1.1193802071650056`}, {
    4.4775208286600225`, 0.5596901035825028}, {5.037210932242526, 
    0.5596901035825028}, {5.037210932242526, 0.}, {5.596901035825028, 
    0.5596901035825028}, {6.156591139407531, 1.6790703107475085`}, {
    5.596901035825028, 1.1193802071650056`}, {6.156591139407531, 
    1.1193802071650056`}, {6.156591139407531, 0.5596901035825028}, {
    6.716281242990034, 1.1193802071650056`}, {8.395351553737543, 
    2.798450517912514}, {7.275971346572537, 2.2387604143300113`}, {
    6.716281242990034, 1.6790703107475085`}, {7.275971346572537, 
    1.6790703107475085`}, {7.275971346572537, 1.1193802071650056`}, {
    7.83566145015504, 1.6790703107475085`}, {8.395351553737543, 
    2.2387604143300113`}, {8.395351553737543, 1.6790703107475085`}, {
    7.83566145015504, 1.1193802071650056`}, {8.395351553737543, 
    1.1193802071650056`}, {8.395351553737543, 0.5596901035825028}, {
    8.955041657320045, 1.1193802071650056`}, {9.51473176090255, 
    2.2387604143300113`}, {8.955041657320045, 1.6790703107475085`}, {
    9.51473176090255, 1.6790703107475085`}, {9.51473176090255, 
    1.1193802071650056`}, {10.074421864485052`, 1.6790703107475085`}}, {
     {RGBColor[0.55, 0.45, 0.45], 
      LineBox[{{1, 2}, {1, 19}, {1, 37}, {2, 3}, {2, 8}, {2, 14}, {3, 4}, {3, 
       5}, {3, 7}, {5, 6}, {8, 9}, {9, 10}, {9, 11}, {9, 13}, {11, 12}, {14, 
       15}, {14, 16}, {14, 18}, {16, 17}, {19, 20}, {20, 21}, {20, 26}, {20, 
       32}, {21, 22}, {21, 23}, {21, 25}, {23, 24}, {26, 27}, {27, 28}, {27, 
       29}, {27, 31}, {29, 30}, {32, 33}, {32, 34}, {32, 36}, {34, 35}, {37, 
       38}, {37, 43}, {37, 49}, {38, 39}, {38, 40}, {38, 42}, {40, 41}, {43, 
       44}, {44, 45}, {44, 46}, {44, 48}, {46, 47}, {49, 50}, {49, 51}, {49, 
       53}, {51, 52}}]}, 
     {RGBColor[0, 0, 0.7], 
      TagBox[
       TooltipBox[PointBox[1],
        TagBox[
         RowBox[{"{", 
           RowBox[{
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"x", ",", 
                    RowBox[{"{", "x", "}"}], ",", "x"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"{", 
                    RowBox[{"x", ",", 
                    RowBox[{"{", "x", "}"}], ",", "x"}], "}"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"x", ",", 
                    RowBox[{"{", "x", "}"}], ",", "x"}], "}"}]}], "}"}], ",", 
             
             RowBox[{"{", 
               RowBox[{"{", 
                 RowBox[{
                   RowBox[{"{", 
                    RowBox[{"x", ",", 
                    RowBox[{"{", "x", "}"}], ",", "x"}], "}"}], ",", 
                   RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{"x", ",", 
                    RowBox[{"{", "x", "}"}], ",", "x"}], "}"}], "}"}], ",", 
                   RowBox[{"{", 
                    RowBox[{"x", ",", 
                    RowBox[{"{", "x", "}"}], ",", "x"}], "}"}]}], "}"}], 
               "}"}], ",", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"x", ",", 
                    RowBox[{"{", "x", "}"}], ",", "x"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"{", 
                    RowBox[{"x", ",", 
                    RowBox[{"{", "x", "}"}], ",", "x"}], "}"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"x", ",", 
                    RowBox[{"{", "x", "}"}], ",", "x"}], "}"}]}], "}"}]}], 
           "}"}], HoldForm]],
       Annotation[#, 
        HoldForm[{{{$CellContext`x, {$CellContext`x}, $CellContext`x}, \
{{$CellContext`x, {$CellContext`x}, $CellContext`x}}, {$CellContext`x, \
{$CellContext`x}, $CellContext`x}}, {{{$CellContext`x, {$CellContext`x}, \
$CellContext`x}, {{$CellContext`x, {$CellContext`x}, $CellContext`x}}, \
{$CellContext`x, {$CellContext`x}, $CellContext`x}}}, {{$CellContext`x, \
{$CellContext`x}, $CellContext`x}, {{$CellContext`x, {$CellContext`x}, \
$CellContext`x}}, {$CellContext`x, {$CellContext`x}, $CellContext`x}}}], 
        "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[2],
        TagBox[
         RowBox[{"{", 
           RowBox[{
             RowBox[{"{", 
               RowBox[{"x", ",", 
                 RowBox[{"{", "x", "}"}], ",", "x"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"{", 
                 RowBox[{"x", ",", 
                   RowBox[{"{", "x", "}"}], ",", "x"}], "}"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"x", ",", 
                 RowBox[{"{", "x", "}"}], ",", "x"}], "}"}]}], "}"}], 
         HoldForm]],
       Annotation[#, 
        HoldForm[{{$CellContext`x, {$CellContext`x}, $CellContext`x}, \
{{$CellContext`x, {$CellContext`x}, $CellContext`x}}, {$CellContext`x, \
{$CellContext`x}, $CellContext`x}}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[3],
        TagBox[
         RowBox[{"{", 
           RowBox[{"x", ",", 
             RowBox[{"{", "x", "}"}], ",", "x"}], "}"}], HoldForm]],
       Annotation[#, 
        HoldForm[{$CellContext`x, {$CellContext`x}, $CellContext`x}], 
        "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[4],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[5],
        TagBox[
         RowBox[{"{", "x", "}"}], HoldForm]],
       Annotation[#, 
        HoldForm[{$CellContext`x}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[6],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[7],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[8],
        TagBox[
         RowBox[{"{", 
           RowBox[{"{", 
             RowBox[{"x", ",", 
               RowBox[{"{", "x", "}"}], ",", "x"}], "}"}], "}"}], HoldForm]],
       Annotation[#, 
        HoldForm[{{$CellContext`x, {$CellContext`x}, $CellContext`x}}], 
        "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[9],
        TagBox[
         RowBox[{"{", 
           RowBox[{"x", ",", 
             RowBox[{"{", "x", "}"}], ",", "x"}], "}"}], HoldForm]],
       Annotation[#, 
        HoldForm[{$CellContext`x, {$CellContext`x}, $CellContext`x}], 
        "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[10],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[11],
        TagBox[
         RowBox[{"{", "x", "}"}], HoldForm]],
       Annotation[#, 
        HoldForm[{$CellContext`x}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[12],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[13],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[14],
        TagBox[
         RowBox[{"{", 
           RowBox[{"x", ",", 
             RowBox[{"{", "x", "}"}], ",", "x"}], "}"}], HoldForm]],
       Annotation[#, 
        HoldForm[{$CellContext`x, {$CellContext`x}, $CellContext`x}], 
        "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[15],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[16],
        TagBox[
         RowBox[{"{", "x", "}"}], HoldForm]],
       Annotation[#, 
        HoldForm[{$CellContext`x}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[17],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[18],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[19],
        TagBox[
         RowBox[{"{", 
           RowBox[{"{", 
             RowBox[{
               RowBox[{"{", 
                 RowBox[{"x", ",", 
                   RowBox[{"{", "x", "}"}], ",", "x"}], "}"}], ",", 
               RowBox[{"{", 
                 RowBox[{"{", 
                   RowBox[{"x", ",", 
                    RowBox[{"{", "x", "}"}], ",", "x"}], "}"}], "}"}], ",", 
               RowBox[{"{", 
                 RowBox[{"x", ",", 
                   RowBox[{"{", "x", "}"}], ",", "x"}], "}"}]}], "}"}], "}"}],
          HoldForm]],
       Annotation[#, 
        HoldForm[{{{$CellContext`x, {$CellContext`x}, $CellContext`x}, \
{{$CellContext`x, {$CellContext`x}, $CellContext`x}}, {$CellContext`x, \
{$CellContext`x}, $CellContext`x}}}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[20],
        TagBox[
         RowBox[{"{", 
           RowBox[{
             RowBox[{"{", 
               RowBox[{"x", ",", 
                 RowBox[{"{", "x", "}"}], ",", "x"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"{", 
                 RowBox[{"x", ",", 
                   RowBox[{"{", "x", "}"}], ",", "x"}], "}"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"x", ",", 
                 RowBox[{"{", "x", "}"}], ",", "x"}], "}"}]}], "}"}], 
         HoldForm]],
       Annotation[#, 
        HoldForm[{{$CellContext`x, {$CellContext`x}, $CellContext`x}, \
{{$CellContext`x, {$CellContext`x}, $CellContext`x}}, {$CellContext`x, \
{$CellContext`x}, $CellContext`x}}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[21],
        TagBox[
         RowBox[{"{", 
           RowBox[{"x", ",", 
             RowBox[{"{", "x", "}"}], ",", "x"}], "}"}], HoldForm]],
       Annotation[#, 
        HoldForm[{$CellContext`x, {$CellContext`x}, $CellContext`x}], 
        "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[22],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[23],
        TagBox[
         RowBox[{"{", "x", "}"}], HoldForm]],
       Annotation[#, 
        HoldForm[{$CellContext`x}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[24],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[25],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[26],
        TagBox[
         RowBox[{"{", 
           RowBox[{"{", 
             RowBox[{"x", ",", 
               RowBox[{"{", "x", "}"}], ",", "x"}], "}"}], "}"}], HoldForm]],
       Annotation[#, 
        HoldForm[{{$CellContext`x, {$CellContext`x}, $CellContext`x}}], 
        "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[27],
        TagBox[
         RowBox[{"{", 
           RowBox[{"x", ",", 
             RowBox[{"{", "x", "}"}], ",", "x"}], "}"}], HoldForm]],
       Annotation[#, 
        HoldForm[{$CellContext`x, {$CellContext`x}, $CellContext`x}], 
        "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[28],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[29],
        TagBox[
         RowBox[{"{", "x", "}"}], HoldForm]],
       Annotation[#, 
        HoldForm[{$CellContext`x}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[30],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[31],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[32],
        TagBox[
         RowBox[{"{", 
           RowBox[{"x", ",", 
             RowBox[{"{", "x", "}"}], ",", "x"}], "}"}], HoldForm]],
       Annotation[#, 
        HoldForm[{$CellContext`x, {$CellContext`x}, $CellContext`x}], 
        "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[33],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[34],
        TagBox[
         RowBox[{"{", "x", "}"}], HoldForm]],
       Annotation[#, 
        HoldForm[{$CellContext`x}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[35],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[36],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[37],
        TagBox[
         RowBox[{"{", 
           RowBox[{
             RowBox[{"{", 
               RowBox[{"x", ",", 
                 RowBox[{"{", "x", "}"}], ",", "x"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"{", 
                 RowBox[{"x", ",", 
                   RowBox[{"{", "x", "}"}], ",", "x"}], "}"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"x", ",", 
                 RowBox[{"{", "x", "}"}], ",", "x"}], "}"}]}], "}"}], 
         HoldForm]],
       Annotation[#, 
        HoldForm[{{$CellContext`x, {$CellContext`x}, $CellContext`x}, \
{{$CellContext`x, {$CellContext`x}, $CellContext`x}}, {$CellContext`x, \
{$CellContext`x}, $CellContext`x}}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[38],
        TagBox[
         RowBox[{"{", 
           RowBox[{"x", ",", 
             RowBox[{"{", "x", "}"}], ",", "x"}], "}"}], HoldForm]],
       Annotation[#, 
        HoldForm[{$CellContext`x, {$CellContext`x}, $CellContext`x}], 
        "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[39],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[40],
        TagBox[
         RowBox[{"{", "x", "}"}], HoldForm]],
       Annotation[#, 
        HoldForm[{$CellContext`x}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[41],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[42],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[43],
        TagBox[
         RowBox[{"{", 
           RowBox[{"{", 
             RowBox[{"x", ",", 
               RowBox[{"{", "x", "}"}], ",", "x"}], "}"}], "}"}], HoldForm]],
       Annotation[#, 
        HoldForm[{{$CellContext`x, {$CellContext`x}, $CellContext`x}}], 
        "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[44],
        TagBox[
         RowBox[{"{", 
           RowBox[{"x", ",", 
             RowBox[{"{", "x", "}"}], ",", "x"}], "}"}], HoldForm]],
       Annotation[#, 
        HoldForm[{$CellContext`x, {$CellContext`x}, $CellContext`x}], 
        "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[45],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[46],
        TagBox[
         RowBox[{"{", "x", "}"}], HoldForm]],
       Annotation[#, 
        HoldForm[{$CellContext`x}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[47],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[48],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[49],
        TagBox[
         RowBox[{"{", 
           RowBox[{"x", ",", 
             RowBox[{"{", "x", "}"}], ",", "x"}], "}"}], HoldForm]],
       Annotation[#, 
        HoldForm[{$CellContext`x, {$CellContext`x}, $CellContext`x}], 
        "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[50],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[51],
        TagBox[
         RowBox[{"{", "x", "}"}], HoldForm]],
       Annotation[#, 
        HoldForm[{$CellContext`x}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[52],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[53],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{5.037210932242526, 3.358140621495017}, {
     1.6790703107475085`, 2.798450517912514}, {0.5596901035825028, 
     2.2387604143300113`}, {0., 1.6790703107475085`}, {0.5596901035825028, 
     1.6790703107475085`}, {0.5596901035825028, 1.1193802071650056`}, {
     1.1193802071650056`, 1.6790703107475085`}, {1.6790703107475085`, 
     2.2387604143300113`}, {1.6790703107475085`, 1.6790703107475085`}, {
     1.1193802071650056`, 1.1193802071650056`}, {1.6790703107475085`, 
     1.1193802071650056`}, {1.6790703107475085`, 0.5596901035825028}, {
     2.2387604143300113`, 1.1193802071650056`}, {2.798450517912514, 
     2.2387604143300113`}, {2.2387604143300113`, 1.6790703107475085`}, {
     2.798450517912514, 1.6790703107475085`}, {2.798450517912514, 
     1.1193802071650056`}, {3.358140621495017, 1.6790703107475085`}, {
     5.037210932242526, 2.798450517912514}, {5.037210932242526, 
     2.2387604143300113`}, {3.91783072507752, 1.6790703107475085`}, {
     3.358140621495017, 1.1193802071650056`}, {3.91783072507752, 
     1.1193802071650056`}, {3.91783072507752, 0.5596901035825028}, {
     4.4775208286600225`, 1.1193802071650056`}, {5.037210932242526, 
     1.6790703107475085`}, {5.037210932242526, 1.1193802071650056`}, {
     4.4775208286600225`, 0.5596901035825028}, {5.037210932242526, 
     0.5596901035825028}, {5.037210932242526, 0.}, {5.596901035825028, 
     0.5596901035825028}, {6.156591139407531, 1.6790703107475085`}, {
     5.596901035825028, 1.1193802071650056`}, {6.156591139407531, 
     1.1193802071650056`}, {6.156591139407531, 0.5596901035825028}, {
     6.716281242990034, 1.1193802071650056`}, {8.395351553737543, 
     2.798450517912514}, {7.275971346572537, 2.2387604143300113`}, {
     6.716281242990034, 1.6790703107475085`}, {7.275971346572537, 
     1.6790703107475085`}, {7.275971346572537, 1.1193802071650056`}, {
     7.83566145015504, 1.6790703107475085`}, {8.395351553737543, 
     2.2387604143300113`}, {8.395351553737543, 1.6790703107475085`}, {
     7.83566145015504, 1.1193802071650056`}, {8.395351553737543, 
     1.1193802071650056`}, {8.395351553737543, 0.5596901035825028}, {
     8.955041657320045, 1.1193802071650056`}, {9.51473176090255, 
     2.2387604143300113`}, {8.955041657320045, 1.6790703107475085`}, {
     9.51473176090255, 1.6790703107475085`}, {9.51473176090255, 
     1.1193802071650056`}, {10.074421864485052`, 1.6790703107475085`}}]& ],
  AspectRatio->NCache[Rational[7, 22]^Rational[1, 2], 0.5640760748177662],
  FrameTicks->Automatic,
  PlotRange->All,
  PlotRangePadding->Automatic]], "Output",
 ImageSize->{184, 102},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TreeForm=",
 CellID->1552909169]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "VertexRenderingFunction",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->82661052],

Cell["Show no vertices:", "ExampleText",
 CellID->1148726976],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TreeForm", "[", 
  RowBox[{
   RowBox[{"D", "[", 
    RowBox[{
     RowBox[{"Sin", "[", 
      RowBox[{"Cos", "[", "x", "]"}], "]"}], ",", "x"}], "]"}], ",", 
   RowBox[{"VertexRenderingFunction", "\[Rule]", "None"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1976145425],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{0.8660254037844386, 2.598076211353316}, {0., 
    1.7320508075688774`}, {0.8660254037844386, 1.7320508075688774`}, {
    0.8660254037844386, 0.8660254037844388}, {0.8660254037844386, 0.}, {
    1.7320508075688772`, 1.7320508075688774`}, {1.7320508075688772`, 
    0.8660254037844388}}, {
     {RGBColor[0.55, 0.45, 0.45], 
      LineBox[{{1, 2}, {1, 3}, {1, 6}, {3, 4}, {4, 5}, {6, 7}}]}, 
     {RGBColor[0, 0, 0.7]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{0.8660254037844386, 2.598076211353316}, {0., 
     1.7320508075688774`}, {0.8660254037844386, 1.7320508075688774`}, {
     0.8660254037844386, 0.8660254037844388}, {0.8660254037844386, 0.}, {
     1.7320508075688772`, 1.7320508075688774`}, {1.7320508075688772`, 
     0.8660254037844388}}]& ],
  AspectRatio->1,
  FrameTicks->Automatic,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{184, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TreeForm=",
 CellID->1401787777]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1647530537],

Cell["Render vertices using a predefined graphic:", "ExampleText",
 CellID->2039050761],

Cell[BoxData[
 RowBox[{
  RowBox[{"gr", " ", "=", " ", 
   GraphicsBox[RasterBox[CompressedData["
1:eJydVduR2zAMtAiIFEkAVAvpIB+pJCVcA+n/LwtIsn0Xa04Oxp6hqF1w8aJ+
fPz5/ZFut9sv/H/iv/6fsTEfy94XWO/d+BxfyvLSej+jWH+NNztj1Nrr+onV
rbZ6rqoWW9sT4dTzs5Wd0Jdy7vnJeIvcuFxB+wHzDDwv9SLeSuDLJfVuFQf0
y3IQgeP7dbzXoPer8mHmCXoDf71Yd/y8XCpWGDv+tC9f4Mt7eHP8G/ID/046
HX+9HdYW+OsHOP4dQVLeS2jzfl7mKJi19i2+LPPsmthakZKKYNbEjtuIVayx
Wi0VKZG6LBnd4GPGLdWqosmN5I4n8j3CZmkuZMzzgKrUuJaSiMgZAJGyX4SC
HUqkTmi9qJk3W2AkPPvrlKytOIFF42nkPDReUOOiNakfSSEl6RhZVRmxMzff
dJyIL2njJxHNA6vgjRHOiFYm1f3AsAxX/qAKlxmHjimn7SSHiWlWUOAg4IUe
5IIkinMyqIcyg3dm7IofnLiakXvFutYqwaUJZxJYQCHitiLvTfMEXGUEhMh1
ICQ6Ao5D3U0e6150oKZpGsfLtAeZ1Tl4gxJB/BRNbjoeMQ+wfIlA8XOLB10f
jcRbtjTcJTHnatCyOC2W8jQ/vKlwj34+DXPEnr+kk8eTx/2CaXt2o5CeCu8D
8sLR1iwoHHpnOggIRY8wkVniyOE0IUI0o0JPlPbJXPsuaZqk3lNIemQLzfI0
gOgJ1B1vmiHCA0yxFXjhL9ejd9fk3iS0oxjZu9IJ0Ogq06fBZDQnym2Cdg41
UJaxk300PGS085ex5YZmEIePvHfrFoN6C/97ffGW1pCTs48BVGEeoQpD/ILQ
VDCjEK57vB7Ftjq5VKy58mOYkKytyMz0+uuBCWWAAh4ZF2C//dA0w62B62C9
/kk6tb+gLnJc
     "], {{0, 0}, {48, 52}},
     ColorFunction->(Apply[RGBColor, 
       Part[{{0.7607843137254902, 0.8274509803921568, 0.20784313725490197`, 
        1.}, {0.043137254901960784`, 0.3764705882352941, 0.10588235294117647`,
         1.}, {0.011764705882352941`, 0.5254901960784314, 0.09019607843137255,
         1.}, {0.9372549019607843, 0.9372549019607843, 0.9176470588235294, 
        1.}, {0.807843137254902, 0.23529411764705882`, 0.3058823529411765, 
        1.}, {0.3411764705882353, 0.6588235294117647, 0.07450980392156863, 
        1.}, {0.3333333333333333, 0.34509803921568627`, 0.27450980392156865`, 
        1.}, {0.8549019607843137, 0.4666666666666667, 0.4235294117647059, 
        1.}, {0.5215686274509804, 0.5686274509803921, 0.5333333333333333, 
        1.}, {0.5490196078431373, 0.7450980392156863, 0.6039215686274509, 
        1.}, {0.9294117647058824, 0.6980392156862745, 0.6784313725490196, 
        1.}, {0.32941176470588235`, 0.6549019607843137, 0.3803921568627451, 
        1.}, {0.16862745098039217`, 0.5725490196078431, 0.13333333333333333`, 
        1.}, {0.7647058823529411, 0.8352941176470589, 0.7568627450980392, 
        1.}, {0.5254901960784314, 0.7333333333333333, 0.11372549019607843`, 
        1.}, {1., 1., 1., 0.}}, #]]& ),
     ColorFunctionScaling->False],
    Background->None,
    ImageSize->{25., 27.},
    PlotRange->{{0, 48}, {0, 52}}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->876584969],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TreeForm", "[", 
  RowBox[{
   RowBox[{"Nest", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"{", 
       RowBox[{"#", ",", 
        RowBox[{"{", "#", "}"}]}], "}"}], "&"}], ",", "x", ",", "3"}], "]"}], 
   ",", 
   RowBox[{"VertexRenderingFunction", "\[Rule]", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Inset", "[", 
       RowBox[{"gr", ",", "#1"}], "]"}], "&"}], ")"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->280649582],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{200, 190},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//TreeForm=",
 CellID->531430197]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "VertexCoordinateRules",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->74973014],

Cell["Explicitly specify all vertex coordinates: ", "ExampleText",
 CellID->49039736],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TreeForm", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "2"}], "+", 
    RowBox[{"x", "^", "4"}]}], ",", 
   RowBox[{"VertexCoordinateRules", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "2"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"2", ",", 
        RowBox[{"-", "1"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"2", ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "3"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"3", ",", "1"}], "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->930075907],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{0., 2.}, {0., 1.}, {0., 0.}, {2., -1.}, {2., 
    1.}, {1., 3.}, {3., 1.}}, {
     {RGBColor[0.55, 0.45, 0.45], 
      LineBox[{{1, 2}, {1, 5}, {2, 3}, {2, 4}, {5, 6}, {5, 7}}]}, {
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["Plus", "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.05],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 1],
        TagBox[
         RowBox[{
           SuperscriptBox["x", "2"], "+", 
           SuperscriptBox["x", "4"]}], HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x^2 + $CellContext`x^4], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["Power", "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.05],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 2],
        TagBox[
         SuperscriptBox["x", "2"], HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x^2], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           TagBox["x",
            HoldForm], "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.05],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 3],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           TagBox["2",
            HoldForm], "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.05],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 4],
        TagBox["2", HoldForm]],
       Annotation[#, 
        HoldForm[2], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["Power", "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.05],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 5],
        TagBox[
         SuperscriptBox["x", "4"], HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x^4], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           TagBox["x",
            HoldForm], "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.05],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 6],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           TagBox["4",
            HoldForm], "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.05],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 7],
        TagBox["4", HoldForm]],
       Annotation[#, 
        HoldForm[4], "Tooltip"]& ]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{0., 2.}, {0., 1.}, {0., 0.}, {2., -1.}, {2., 
     1.}, {1., 3.}, {3., 1.}}]& ],
  AspectRatio->NCache[Rational[3, 5]^Rational[1, 2], 0.7745966692414834],
  FrameTicks->Automatic,
  ImageSize->{249., Automatic},
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{253, 174},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TreeForm=",
 CellID->344804231]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->2379],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["FullForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FullForm"]], "InlineFormula"],
 " gives a linear expression similar to ",
 Cell[BoxData[
  ButtonBox["TreeForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TreeForm"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->1969492],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullForm", "[", 
  RowBox[{
   RowBox[{"1", "/", 
    RowBox[{"(", 
     RowBox[{"a", "+", "b"}], ")"}]}], "*", 
   RowBox[{"x", "^", "2"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->609632377],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"Times", "[", 
    RowBox[{
     RowBox[{"Power", "[", 
      RowBox[{
       RowBox[{"Plus", "[", 
        RowBox[{"a", ",", "b"}], "]"}], ",", 
       RowBox[{"-", "1"}]}], "]"}], ",", 
     RowBox[{"Power", "[", 
      RowBox[{"x", ",", "2"}], "]"}]}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Output",
 ImageSize->{281, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//FullForm=",
 CellID->155527542]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TreeForm", "[", 
  RowBox[{
   RowBox[{"1", "/", 
    RowBox[{"(", 
     RowBox[{"a", "+", "b"}], ")"}]}], "*", 
   RowBox[{"x", "^", "2"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1232133],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{1.6681153124565982`, 2.5021729686848975`}, {
    0.8340576562282991, 1.6681153124565984`}, {2.5021729686848975`, 
    1.6681153124565984`}, {0.41702882811414954`, 0.8340576562282993}, {
    1.2510864843424487`, 0.8340576562282993}, {0., 0.}, {0.8340576562282991, 
    0.}, {2.0851441405707476`, 0.8340576562282993}, {2.919201796799047, 
    0.8340576562282993}}, {
     {RGBColor[0.55, 0.45, 0.45], LineBox[{1, 2}], LineBox[{1, 3}], 
      LineBox[{2, 4}], LineBox[{2, 5}], LineBox[{3, 8}], LineBox[{3, 9}], 
      LineBox[{4, 6}], LineBox[{4, 7}]}, 
     {RGBColor[0.55, 0.45, 0.45], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["Times", "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->11,
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 1],
        FractionBox[
         SuperscriptBox["x", "2"], 
         RowBox[{"a", "+", "b"}]]],
       Annotation[#, ($CellContext`a + $CellContext`b)^(-1) $CellContext`x^2, 
        "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["Power", "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->11,
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 2],
        FractionBox["1", 
         RowBox[{"a", "+", "b"}]]],
       Annotation[#, ($CellContext`a + $CellContext`b)^(-1), "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["Power", "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->11,
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 3],
        SuperscriptBox["x", "2"]],
       Annotation[#, $CellContext`x^2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["Plus", "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->11,
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 4],
        RowBox[{"a", "+", "b"}]],
       Annotation[#, $CellContext`a + $CellContext`b, "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           RowBox[{"-", "1"}], "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->11,
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 5],
        RowBox[{"-", "1"}]],
       Annotation[#, -1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["a", "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->11,
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 6],
        "a"],
       Annotation[#, $CellContext`a, "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["b", "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->11,
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 7],
        "b"],
       Annotation[#, $CellContext`b, "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["x", "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->11,
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 8],
        "x"],
       Annotation[#, $CellContext`x, "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["2", "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->11,
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 9],
        "2"],
       Annotation[#, 2, "Tooltip"]& ]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{1.6681153124565982`, 2.5021729686848975`}, {
     0.8340576562282991, 1.6681153124565984`}, {2.5021729686848975`, 
     1.6681153124565984`}, {0.41702882811414954`, 0.8340576562282993}, {
     1.2510864843424487`, 0.8340576562282993}, {0., 0.}, {0.8340576562282991, 
     0.}, {2.0851441405707476`, 0.8340576562282993}, {2.919201796799047, 
     0.8340576562282993}}]& ],
  AspectRatio->0.9258200997725515,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->0]], "Output",
 ImageSize->{184, 170},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//TreeForm=",
 CellID->568837046]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["OutputForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/OutputForm"]], "InlineFormula"],
 " of ",
 Cell[BoxData[
  ButtonBox["TreeForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TreeForm"]], "InlineFormula"],
 " gives a textual display of the expression: "
}], "ExampleText",
 CellID->1542255578],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"TreeForm", "[", 
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"(", 
      RowBox[{"a", "+", "b"}], ")"}]}], "*", 
    RowBox[{"x", "^", "2"}]}], "]"}], "//", "OutputForm"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->458044859],

Cell[OutputFormData["\<\
x^2/(a + b)\
\>", "\<\
Times[|                    , |          ]
      Power[|         , -1]  Power[x, 2]
            Plus[a, b]\
\>"], "Output",
 ImageSize->{294, 40},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]//OutputForm=",
 CellID->397945025]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1927757794],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["TreePlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TreePlot"]], "InlineFormula"],
 " to plot a tree graph:"
}], "ExampleText",
 CellID->1065632896],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TreePlot", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"i", "\[Rule]", 
     RowBox[{"RandomInteger", "[", 
      RowBox[{"{", 
       RowBox[{"0", ",", 
        RowBox[{"i", "-", "1"}]}], "}"}], "]"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "50"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->672786244],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{6.8853225377298575`, 3.2243461640100795`}, {
    4.231954340263229, 2.686955136675066}, {3.089998407176326, 
    2.1495641093400533`}, {3.6273894345113393`, 2.1495641093400533`}, {
    4.164780461846353, 2.1495641093400533`}, {7.6578221395239385`, 
    2.686955136675066}, {7.120431112188926, 2.1495641093400533`}, {
    5.911301300685146, 1.6121730820050397`}, {5.642605787017639, 
    1.0747820546700266`}, {1.343477568337533, 1.6121730820050397`}, {
    9.538690735196486, 2.686955136675066}, {5.373910273350132, 
    2.1495641093400533`}, {6.448692328020159, 1.6121730820050397`}, {
    9.135647464695225, 2.1495641093400533`}, {5.373910273350132, 
    1.6121730820050397`}, {7.6578221395239385`, 2.1495641093400533`}, {
    3.2243461640100795`, 1.6121730820050397`}, {0., 1.0747820546700266`}, {
    9.941734005697745, 2.1495641093400533`}, {3.7617371913450928`, 
    1.6121730820050397`}, {1.0747820546700264`, 1.0747820546700266`}, {0., 
    0.5373910273350133}, {6.986083355355172, 1.6121730820050397`}, {
    6.179996814352652, 1.0747820546700266`}, {5.911301300685146, 
    0.5373910273350133}, {1.6121730820050397`, 1.0747820546700266`}, {
    7.5234743826901855`, 1.6121730820050397`}, {4.299128218680106, 
    1.6121730820050397`}, {8.329560923692705, 1.6121730820050397`}, {
    9.673038492030239, 1.6121730820050397`}, {3.2243461640100795`, 
    1.0747820546700266`}, {2.149564109340053, 1.0747820546700266`}, {
    8.195213166858952, 2.1495641093400533`}, {0.8060865410025199, 
    0.5373910273350133}, {9.135647464695225, 1.6121730820050397`}, {
    4.836519246015119, 1.6121730820050397`}, {7.5234743826901855`, 
    1.0747820546700266`}, {7.5234743826901855`, 0.5373910273350133}, {0., 
    0.}, {6.448692328020159, 0.5373910273350133}, {2.686955136675066, 
    1.0747820546700266`}, {8.0608654100252, 1.0747820546700266`}, {
    0.5373910273350132, 0.}, {1.343477568337533, 0.5373910273350133}, {
    4.836519246015119, 1.0747820546700266`}, {8.598256437360211, 
    1.0747820546700266`}, {1.0747820546700264`, 0.}, {10.21042951936525, 
    1.6121730820050397`}, {2.4182596230075597`, 0.5373910273350133}, {
    9.135647464695225, 1.0747820546700266`}, {2.955650650342573, 
    0.5373910273350133}}, {
     {RGBColor[0.5, 0., 0.], 
      LineBox[{{1, 2}, {3, 2}, {4, 2}, {5, 2}, {6, 1}, {7, 6}, {8, 7}, {9, 
       8}, {10, 3}, {11, 1}, {12, 2}, {13, 7}, {14, 11}, {15, 12}, {16, 6}, {
       17, 3}, {18, 10}, {19, 11}, {20, 3}, {21, 10}, {22, 18}, {23, 7}, {24, 
       8}, {25, 24}, {26, 10}, {27, 7}, {28, 3}, {29, 7}, {30, 19}, {31, 
       17}, {32, 10}, {33, 6}, {34, 21}, {35, 14}, {36, 3}, {37, 27}, {38, 
       37}, {39, 22}, {40, 24}, {41, 10}, {42, 29}, {43, 34}, {44, 21}, {45, 
       36}, {46, 29}, {47, 34}, {48, 19}, {49, 41}, {50, 35}, {51, 41}}]}, 
     {RGBColor[0, 0, 0.7], 
      TagBox[
       TooltipBox[PointBox[1],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[2],
        "0"],
       Annotation[#, 0, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[3],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[4],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[5],
        "4"],
       Annotation[#, 4, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[6],
        "5"],
       Annotation[#, 5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[7],
        "6"],
       Annotation[#, 6, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[8],
        "7"],
       Annotation[#, 7, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[9],
        "8"],
       Annotation[#, 8, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[10],
        "9"],
       Annotation[#, 9, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[11],
        "10"],
       Annotation[#, 10, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[12],
        "11"],
       Annotation[#, 11, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[13],
        "12"],
       Annotation[#, 12, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[14],
        "13"],
       Annotation[#, 13, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[15],
        "14"],
       Annotation[#, 14, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[16],
        "15"],
       Annotation[#, 15, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[17],
        "16"],
       Annotation[#, 16, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[18],
        "17"],
       Annotation[#, 17, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[19],
        "18"],
       Annotation[#, 18, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[20],
        "19"],
       Annotation[#, 19, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[21],
        "20"],
       Annotation[#, 20, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[22],
        "21"],
       Annotation[#, 21, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[23],
        "22"],
       Annotation[#, 22, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[24],
        "23"],
       Annotation[#, 23, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[25],
        "24"],
       Annotation[#, 24, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[26],
        "25"],
       Annotation[#, 25, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[27],
        "26"],
       Annotation[#, 26, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[28],
        "27"],
       Annotation[#, 27, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[29],
        "28"],
       Annotation[#, 28, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[30],
        "29"],
       Annotation[#, 29, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[31],
        "30"],
       Annotation[#, 30, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[32],
        "31"],
       Annotation[#, 31, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[33],
        "32"],
       Annotation[#, 32, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[34],
        "33"],
       Annotation[#, 33, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[35],
        "34"],
       Annotation[#, 34, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[36],
        "35"],
       Annotation[#, 35, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[37],
        "36"],
       Annotation[#, 36, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[38],
        "37"],
       Annotation[#, 37, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[39],
        "38"],
       Annotation[#, 38, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[40],
        "39"],
       Annotation[#, 39, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[41],
        "40"],
       Annotation[#, 40, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[42],
        "41"],
       Annotation[#, 41, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[43],
        "42"],
       Annotation[#, 42, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[44],
        "43"],
       Annotation[#, 43, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[45],
        "44"],
       Annotation[#, 44, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[46],
        "45"],
       Annotation[#, 45, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[47],
        "46"],
       Annotation[#, 46, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[48],
        "47"],
       Annotation[#, 47, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[49],
        "48"],
       Annotation[#, 48, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[50],
        "49"],
       Annotation[#, 49, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[51],
        "50"],
       Annotation[#, 50, "Tooltip"]& ]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{6.8853225377298575`, 3.2243461640100795`}, {
     4.231954340263229, 2.686955136675066}, {3.089998407176326, 
     2.1495641093400533`}, {3.6273894345113393`, 2.1495641093400533`}, {
     4.164780461846353, 2.1495641093400533`}, {7.6578221395239385`, 
     2.686955136675066}, {7.120431112188926, 2.1495641093400533`}, {
     5.911301300685146, 1.6121730820050397`}, {5.642605787017639, 
     1.0747820546700266`}, {1.343477568337533, 1.6121730820050397`}, {
     9.538690735196486, 2.686955136675066}, {5.373910273350132, 
     2.1495641093400533`}, {6.448692328020159, 1.6121730820050397`}, {
     9.135647464695225, 2.1495641093400533`}, {5.373910273350132, 
     1.6121730820050397`}, {7.6578221395239385`, 2.1495641093400533`}, {
     3.2243461640100795`, 1.6121730820050397`}, {0., 1.0747820546700266`}, {
     9.941734005697745, 2.1495641093400533`}, {3.7617371913450928`, 
     1.6121730820050397`}, {1.0747820546700264`, 1.0747820546700266`}, {0., 
     0.5373910273350133}, {6.986083355355172, 1.6121730820050397`}, {
     6.179996814352652, 1.0747820546700266`}, {5.911301300685146, 
     0.5373910273350133}, {1.6121730820050397`, 1.0747820546700266`}, {
     7.5234743826901855`, 1.6121730820050397`}, {4.299128218680106, 
     1.6121730820050397`}, {8.329560923692705, 1.6121730820050397`}, {
     9.673038492030239, 1.6121730820050397`}, {3.2243461640100795`, 
     1.0747820546700266`}, {2.149564109340053, 1.0747820546700266`}, {
     8.195213166858952, 2.1495641093400533`}, {0.8060865410025199, 
     0.5373910273350133}, {9.135647464695225, 1.6121730820050397`}, {
     4.836519246015119, 1.6121730820050397`}, {7.5234743826901855`, 
     1.0747820546700266`}, {7.5234743826901855`, 0.5373910273350133}, {0., 
     0.}, {6.448692328020159, 0.5373910273350133}, {2.686955136675066, 
     1.0747820546700266`}, {8.0608654100252, 1.0747820546700266`}, {
     0.5373910273350132, 0.}, {1.343477568337533, 0.5373910273350133}, {
     4.836519246015119, 1.0747820546700266`}, {8.598256437360211, 
     1.0747820546700266`}, {1.0747820546700264`, 0.}, {10.21042951936525, 
     1.6121730820050397`}, {2.4182596230075597`, 0.5373910273350133}, {
     9.135647464695225, 1.0747820546700266`}, {2.955650650342573, 
     0.5373910273350133}}]& ],
  AspectRatio->0.5619514869490164,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{184, 102},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1253958722]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1193968090],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["GraphPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GraphPlot"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["GraphPlot3D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GraphPlot3D"]], "InlineFormula"],
 " for general undirected graphs:"
}], "ExampleText",
 CellID->766867356],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"i", "\[Rule]", 
     RowBox[{"Mod", "[", 
      RowBox[{
       RowBox[{"i", "^", "2"}], ",", "150"}], "]"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "0", ",", "150"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1096912348],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[CompressedData["
1:eJxdl3k81N/3x8eWypIm6yiNMQvmPW/igwhz7JQoSYpkLamQJH1Ei5A264es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    "], {
     {RGBColor[0.5, 0., 0.], 
      LineBox[{{1, 152, 153, 154, 155, 156, 157, 158, 159, 160, 161, 162, 163,
         164, 165, 166, 167, 168, 169, 170, 171, 172, 173, 174, 1}, {2, 175, 
        176, 177, 178, 179, 180, 181, 182, 183, 184, 185, 186, 187, 188, 189, 
        190, 191, 192, 193, 194, 195, 196, 197, 2}, {3, 4}, {4, 7}, {5, 6}, {
        6, 16}, {7, 29}, {8, 9}, {9, 198, 199, 200, 201, 202, 203, 204, 205, 
        206, 207, 208, 209, 210, 211, 212, 213, 214, 215, 216, 217, 218, 219, 
        220, 9}, {10, 11}, {11, 57}, {12, 13}, {13, 2}, {14, 15}, {15, 26}, {
        16, 91}, {17, 18}, {18, 221, 222, 223, 224, 225, 226, 227, 228, 229, 
        230, 231, 232, 233, 234, 235, 236, 237, 238, 239, 240, 241, 242, 243, 
        18}, {19, 20}, {20, 49}, {21, 22}, {22, 11}, {23, 24}, {24, 34}, {25, 
        26}, {26, 7}, {27, 28}, {28, 244, 245, 246, 247, 248, 249, 250, 251, 
        252, 253, 254, 255, 256, 257, 258, 259, 260, 261, 262, 263, 264, 265, 
        266, 28}, {29, 67}, {30, 31}, {31, 20}, {32, 33}, {33, 42}, {34, 
        20}, {35, 18}, {36, 37}, {37, 16}, {38, 39}, {39, 29}, {40, 41}, {41, 
        49}, {42, 267, 268, 269, 270, 271, 272, 273, 274, 275, 276, 277, 278, 
        279, 280, 281, 282, 283, 284, 285, 286, 287, 288, 289, 42}, {43, 
        44}, {44, 290, 291, 292, 293, 294, 295, 296, 297, 298, 299, 300, 301, 
        302, 303, 304, 305, 306, 307, 308, 309, 310, 311, 312, 44}, {45, 
        46}, {46, 37}, {47, 39}, {48, 49}, {49, 51}, {50, 1}, {51, 34}, {52, 
        53}, {53, 44}, {54, 55}, {55, 36}, {56, 9}, {57, 77}, {58, 24}, {59, 
        60}, {60, 67}, {61, 18}, {62, 51}, {63, 64}, {64, 57}, {65, 13}, {66, 
        67}, {67, 26}, {68, 28}, {69, 70}, {70, 51}, {71, 72}, {72, 77}, {73, 
        18}, {74, 313, 314, 315, 316, 317, 318, 319, 320, 321, 322, 323, 324, 
        325, 326, 327, 328, 329, 330, 331, 332, 333, 334, 335, 74}, {75, 4}, {
        76, 70}, {77, 10}, {78, 9}, {79, 67}, {80, 81}, {81, 74}, {82, 15}, {
        83, 51}, {84, 1}, {85, 60}, {86, 87}, {87, 91}, {88, 9}, {89, 31}, {
        90, 53}, {91, 36}, {92, 18}, {93, 49}, {94, 95}, {95, 10}, {96, 41}, {
        97, 44}, {98, 41}, {99, 95}, {100, 18}, {101, 53}, {102, 31}, {103, 
        9}, {104, 26}, {105, 87}, {106, 60}, {107, 20}, {108, 1}, {109, 15}, {
        110, 81}, {111, 9}, {112, 70}, {113, 4}, {114, 2}, {115, 72}, {116, 
        70}, {117, 7}, {118, 28}, {119, 13}, {120, 64}, {121, 18}, {122, 
        60}, {123, 24}, {124, 9}, {125, 29}, {126, 55}, {127, 53}, {128, 
        34}, {129, 1}, {130, 39}, {131, 46}, {132, 9}, {133, 41}, {134, 39}, {
        135, 18}, {136, 34}, {137, 33}, {138, 31}, {139, 29}, {140, 28}, {141,
         24}, {142, 22}, {143, 18}, {144, 15}, {145, 13}, {146, 9}, {147, 
        7}, {148, 6}, {149, 4}, {150, 2}, {151, 1}}]}, 
     {RGBColor[0, 0, 0.7], 
      TagBox[
       TooltipBox[PointBox[1],
        "0"],
       Annotation[#, 0, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[2],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[3],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[4],
        "4"],
       Annotation[#, 4, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[5],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[6],
        "9"],
       Annotation[#, 9, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[7],
        "16"],
       Annotation[#, 16, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[8],
        "5"],
       Annotation[#, 5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[9],
        "25"],
       Annotation[#, 25, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[10],
        "6"],
       Annotation[#, 6, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[11],
        "36"],
       Annotation[#, 36, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[12],
        "7"],
       Annotation[#, 7, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[13],
        "49"],
       Annotation[#, 49, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[14],
        "8"],
       Annotation[#, 8, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[15],
        "64"],
       Annotation[#, 64, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[16],
        "81"],
       Annotation[#, 81, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[17],
        "10"],
       Annotation[#, 10, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[18],
        "100"],
       Annotation[#, 100, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[19],
        "11"],
       Annotation[#, 11, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[20],
        "121"],
       Annotation[#, 121, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[21],
        "12"],
       Annotation[#, 12, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[22],
        "144"],
       Annotation[#, 144, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[23],
        "13"],
       Annotation[#, 13, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[24],
        "19"],
       Annotation[#, 19, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[25],
        "14"],
       Annotation[#, 14, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[26],
        "46"],
       Annotation[#, 46, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[27],
        "15"],
       Annotation[#, 15, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[28],
        "75"],
       Annotation[#, 75, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[29],
        "106"],
       Annotation[#, 106, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[30],
        "17"],
       Annotation[#, 17, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[31],
        "139"],
       Annotation[#, 139, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[32],
        "18"],
       Annotation[#, 18, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[33],
        "24"],
       Annotation[#, 24, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[34],
        "61"],
       Annotation[#, 61, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[35],
        "20"],
       Annotation[#, 20, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[36],
        "21"],
       Annotation[#, 21, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[37],
        "141"],
       Annotation[#, 141, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[38],
        "22"],
       Annotation[#, 22, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[39],
        "34"],
       Annotation[#, 34, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[40],
        "23"],
       Annotation[#, 23, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[41],
        "79"],
       Annotation[#, 79, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[42],
        "126"],
       Annotation[#, 126, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[43],
        "26"],
       Annotation[#, 26, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[44],
        "76"],
       Annotation[#, 76, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[45],
        "27"],
       Annotation[#, 27, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[46],
        "129"],
       Annotation[#, 129, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[47],
        "28"],
       Annotation[#, 28, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[48],
        "29"],
       Annotation[#, 29, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[49],
        "91"],
       Annotation[#, 91, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[50],
        "30"],
       Annotation[#, 30, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[51],
        "31"],
       Annotation[#, 31, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[52],
        "32"],
       Annotation[#, 32, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[53],
        "124"],
       Annotation[#, 124, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[54],
        "33"],
       Annotation[#, 33, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[55],
        "39"],
       Annotation[#, 39, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[56],
        "35"],
       Annotation[#, 35, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[57],
        "96"],
       Annotation[#, 96, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[58],
        "37"],
       Annotation[#, 37, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[59],
        "38"],
       Annotation[#, 38, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[60],
        "94"],
       Annotation[#, 94, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[61],
        "40"],
       Annotation[#, 40, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[62],
        "41"],
       Annotation[#, 41, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[63],
        "42"],
       Annotation[#, 42, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[64],
        "114"],
       Annotation[#, 114, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[65],
        "43"],
       Annotation[#, 43, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[66],
        "44"],
       Annotation[#, 44, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[67],
        "136"],
       Annotation[#, 136, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[68],
        "45"],
       Annotation[#, 45, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[69],
        "47"],
       Annotation[#, 47, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[70],
        "109"],
       Annotation[#, 109, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[71],
        "48"],
       Annotation[#, 48, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[72],
        "54"],
       Annotation[#, 54, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[73],
        "50"],
       Annotation[#, 50, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[74],
        "51"],
       Annotation[#, 51, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[75],
        "52"],
       Annotation[#, 52, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[76],
        "53"],
       Annotation[#, 53, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[77],
        "66"],
       Annotation[#, 66, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[78],
        "55"],
       Annotation[#, 55, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[79],
        "56"],
       Annotation[#, 56, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[80],
        "57"],
       Annotation[#, 57, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[81],
        "99"],
       Annotation[#, 99, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[82],
        "58"],
       Annotation[#, 58, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[83],
        "59"],
       Annotation[#, 59, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[84],
        "60"],
       Annotation[#, 60, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[85],
        "62"],
       Annotation[#, 62, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[86],
        "63"],
       Annotation[#, 63, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[87],
        "69"],
       Annotation[#, 69, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[88],
        "65"],
       Annotation[#, 65, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[89],
        "67"],
       Annotation[#, 67, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[90],
        "68"],
       Annotation[#, 68, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[91],
        "111"],
       Annotation[#, 111, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[92],
        "70"],
       Annotation[#, 70, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[93],
        "71"],
       Annotation[#, 71, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[94],
        "72"],
       Annotation[#, 72, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[95],
        "84"],
       Annotation[#, 84, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[96],
        "73"],
       Annotation[#, 73, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[97],
        "74"],
       Annotation[#, 74, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[98],
        "77"],
       Annotation[#, 77, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[99],
        "78"],
       Annotation[#, 78, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[100],
        "80"],
       Annotation[#, 80, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[101],
        "82"],
       Annotation[#, 82, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[102],
        "83"],
       Annotation[#, 83, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[103],
        "85"],
       Annotation[#, 85, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[104],
        "86"],
       Annotation[#, 86, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[105],
        "87"],
       Annotation[#, 87, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[106],
        "88"],
       Annotation[#, 88, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[107],
        "89"],
       Annotation[#, 89, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[108],
        "90"],
       Annotation[#, 90, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[109],
        "92"],
       Annotation[#, 92, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[110],
        "93"],
       Annotation[#, 93, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[111],
        "95"],
       Annotation[#, 95, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[112],
        "97"],
       Annotation[#, 97, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[113],
        "98"],
       Annotation[#, 98, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[114],
        "101"],
       Annotation[#, 101, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[115],
        "102"],
       Annotation[#, 102, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[116],
        "103"],
       Annotation[#, 103, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[117],
        "104"],
       Annotation[#, 104, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[118],
        "105"],
       Annotation[#, 105, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[119],
        "107"],
       Annotation[#, 107, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[120],
        "108"],
       Annotation[#, 108, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[121],
        "110"],
       Annotation[#, 110, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[122],
        "112"],
       Annotation[#, 112, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[123],
        "113"],
       Annotation[#, 113, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[124],
        "115"],
       Annotation[#, 115, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[125],
        "116"],
       Annotation[#, 116, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[126],
        "117"],
       Annotation[#, 117, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[127],
        "118"],
       Annotation[#, 118, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[128],
        "119"],
       Annotation[#, 119, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[129],
        "120"],
       Annotation[#, 120, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[130],
        "122"],
       Annotation[#, 122, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[131],
        "123"],
       Annotation[#, 123, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[132],
        "125"],
       Annotation[#, 125, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[133],
        "127"],
       Annotation[#, 127, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[134],
        "128"],
       Annotation[#, 128, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[135],
        "130"],
       Annotation[#, 130, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[136],
        "131"],
       Annotation[#, 131, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[137],
        "132"],
       Annotation[#, 132, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[138],
        "133"],
       Annotation[#, 133, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[139],
        "134"],
       Annotation[#, 134, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[140],
        "135"],
       Annotation[#, 135, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[141],
        "137"],
       Annotation[#, 137, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[142],
        "138"],
       Annotation[#, 138, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[143],
        "140"],
       Annotation[#, 140, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[144],
        "142"],
       Annotation[#, 142, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[145],
        "143"],
       Annotation[#, 143, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[146],
        "145"],
       Annotation[#, 145, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[147],
        "146"],
       Annotation[#, 146, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[148],
        "147"],
       Annotation[#, 147, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[149],
        "148"],
       Annotation[#, 148, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[150],
        "149"],
       Annotation[#, 149, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[151],
        "150"],
       Annotation[#, 150, "Tooltip"]& ]}}],
   Annotation[#, VertexCoordinateRules -> CompressedData["
1:eJxNVXk4lOsbHowTIWMaZsKZPsPMWGYQSUTzoEKpnDYjS5Q2ynai+nWoEykt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     "]]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{184, 176},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->2103169330]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot3D", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"i", "\[Rule]", 
     RowBox[{"Mod", "[", 
      RowBox[{
       RowBox[{"i", "^", "2"}], ",", "150"}], "]"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "0", ",", "150"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->292597679],

Cell[BoxData[
 Graphics3DBox[
  TagBox[GraphicsComplex3DBox[CompressedData["
1:eJxlmHk4Vd/3x695nrlmma+pnCuUBnuJRKMUlVQaKFMZEkIUIXOi4SNDGhCp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    "], {
     {RGBColor[0.5, 0., 0.], 
      Line3DBox[{{1, 152, 153, 154, 155, 156, 157, 158, 159, 160, 161, 162, 
        163, 164, 165, 166, 167, 168, 169, 170, 171, 172, 173, 174, 1}, {2, 
        175, 176, 177, 178, 179, 180, 181, 182, 183, 184, 185, 186, 187, 188, 
        189, 190, 191, 192, 193, 194, 195, 196, 197, 2}, {3, 4}, {4, 7}, {5, 
        6}, {6, 16}, {7, 29}, {8, 9}, {9, 198, 199, 200, 201, 202, 203, 204, 
        205, 206, 207, 208, 209, 210, 211, 212, 213, 214, 215, 216, 217, 218, 
        219, 220, 9}, {10, 11}, {11, 57}, {12, 13}, {13, 2}, {14, 15}, {15, 
        26}, {16, 91}, {17, 18}, {18, 221, 222, 223, 224, 225, 226, 227, 228, 
        229, 230, 231, 232, 233, 234, 235, 236, 237, 238, 239, 240, 241, 242, 
        243, 18}, {19, 20}, {20, 49}, {21, 22}, {22, 11}, {23, 24}, {24, 
        34}, {25, 26}, {26, 7}, {27, 28}, {28, 244, 245, 246, 247, 248, 249, 
        250, 251, 252, 253, 254, 255, 256, 257, 258, 259, 260, 261, 262, 263, 
        264, 265, 266, 28}, {29, 67}, {30, 31}, {31, 20}, {32, 33}, {33, 
        42}, {34, 20}, {35, 18}, {36, 37}, {37, 16}, {38, 39}, {39, 29}, {40, 
        41}, {41, 49}, {42, 267, 268, 269, 270, 271, 272, 273, 274, 275, 276, 
        277, 278, 279, 280, 281, 282, 283, 284, 285, 286, 287, 288, 289, 
        42}, {43, 44}, {44, 290, 291, 292, 293, 294, 295, 296, 297, 298, 299, 
        300, 301, 302, 303, 304, 305, 306, 307, 308, 309, 310, 311, 312, 
        44}, {45, 46}, {46, 37}, {47, 39}, {48, 49}, {49, 51}, {50, 1}, {51, 
        34}, {52, 53}, {53, 44}, {54, 55}, {55, 36}, {56, 9}, {57, 77}, {58, 
        24}, {59, 60}, {60, 67}, {61, 18}, {62, 51}, {63, 64}, {64, 57}, {65, 
        13}, {66, 67}, {67, 26}, {68, 28}, {69, 70}, {70, 51}, {71, 72}, {72, 
        77}, {73, 18}, {74, 313, 314, 315, 316, 317, 318, 319, 320, 321, 322, 
        323, 324, 325, 326, 327, 328, 329, 330, 331, 332, 333, 334, 335, 
        74}, {75, 4}, {76, 70}, {77, 10}, {78, 9}, {79, 67}, {80, 81}, {81, 
        74}, {82, 15}, {83, 51}, {84, 1}, {85, 60}, {86, 87}, {87, 91}, {88, 
        9}, {89, 31}, {90, 53}, {91, 36}, {92, 18}, {93, 49}, {94, 95}, {95, 
        10}, {96, 41}, {97, 44}, {98, 41}, {99, 95}, {100, 18}, {101, 53}, {
        102, 31}, {103, 9}, {104, 26}, {105, 87}, {106, 60}, {107, 20}, {108, 
        1}, {109, 15}, {110, 81}, {111, 9}, {112, 70}, {113, 4}, {114, 2}, {
        115, 72}, {116, 70}, {117, 7}, {118, 28}, {119, 13}, {120, 64}, {121, 
        18}, {122, 60}, {123, 24}, {124, 9}, {125, 29}, {126, 55}, {127, 
        53}, {128, 34}, {129, 1}, {130, 39}, {131, 46}, {132, 9}, {133, 41}, {
        134, 39}, {135, 18}, {136, 34}, {137, 33}, {138, 31}, {139, 29}, {140,
         28}, {141, 24}, {142, 22}, {143, 18}, {144, 15}, {145, 13}, {146, 
        9}, {147, 7}, {148, 6}, {149, 4}, {150, 2}, {151, 1}}]}, 
     {RGBColor[0, 0, 0.7], 
      TagBox[
       TooltipBox[Point3DBox[1],
        "0"],
       Annotation[#, 0, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[2],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[3],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[4],
        "4"],
       Annotation[#, 4, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[5],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[6],
        "9"],
       Annotation[#, 9, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[7],
        "16"],
       Annotation[#, 16, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[8],
        "5"],
       Annotation[#, 5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[9],
        "25"],
       Annotation[#, 25, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[10],
        "6"],
       Annotation[#, 6, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[11],
        "36"],
       Annotation[#, 36, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[12],
        "7"],
       Annotation[#, 7, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[13],
        "49"],
       Annotation[#, 49, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[14],
        "8"],
       Annotation[#, 8, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[15],
        "64"],
       Annotation[#, 64, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[16],
        "81"],
       Annotation[#, 81, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[17],
        "10"],
       Annotation[#, 10, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[18],
        "100"],
       Annotation[#, 100, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[19],
        "11"],
       Annotation[#, 11, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[20],
        "121"],
       Annotation[#, 121, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[21],
        "12"],
       Annotation[#, 12, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[22],
        "144"],
       Annotation[#, 144, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[23],
        "13"],
       Annotation[#, 13, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[24],
        "19"],
       Annotation[#, 19, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[25],
        "14"],
       Annotation[#, 14, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[26],
        "46"],
       Annotation[#, 46, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[27],
        "15"],
       Annotation[#, 15, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[28],
        "75"],
       Annotation[#, 75, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[29],
        "106"],
       Annotation[#, 106, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[30],
        "17"],
       Annotation[#, 17, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[31],
        "139"],
       Annotation[#, 139, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[32],
        "18"],
       Annotation[#, 18, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[33],
        "24"],
       Annotation[#, 24, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[34],
        "61"],
       Annotation[#, 61, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[35],
        "20"],
       Annotation[#, 20, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[36],
        "21"],
       Annotation[#, 21, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[37],
        "141"],
       Annotation[#, 141, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[38],
        "22"],
       Annotation[#, 22, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[39],
        "34"],
       Annotation[#, 34, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[40],
        "23"],
       Annotation[#, 23, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[41],
        "79"],
       Annotation[#, 79, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[42],
        "126"],
       Annotation[#, 126, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[43],
        "26"],
       Annotation[#, 26, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[44],
        "76"],
       Annotation[#, 76, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[45],
        "27"],
       Annotation[#, 27, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[46],
        "129"],
       Annotation[#, 129, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[47],
        "28"],
       Annotation[#, 28, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[48],
        "29"],
       Annotation[#, 29, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[49],
        "91"],
       Annotation[#, 91, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[50],
        "30"],
       Annotation[#, 30, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[51],
        "31"],
       Annotation[#, 31, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[52],
        "32"],
       Annotation[#, 32, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[53],
        "124"],
       Annotation[#, 124, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[54],
        "33"],
       Annotation[#, 33, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[55],
        "39"],
       Annotation[#, 39, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[56],
        "35"],
       Annotation[#, 35, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[57],
        "96"],
       Annotation[#, 96, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[58],
        "37"],
       Annotation[#, 37, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[59],
        "38"],
       Annotation[#, 38, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[60],
        "94"],
       Annotation[#, 94, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[61],
        "40"],
       Annotation[#, 40, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[62],
        "41"],
       Annotation[#, 41, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[63],
        "42"],
       Annotation[#, 42, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[64],
        "114"],
       Annotation[#, 114, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[65],
        "43"],
       Annotation[#, 43, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[66],
        "44"],
       Annotation[#, 44, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[67],
        "136"],
       Annotation[#, 136, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[68],
        "45"],
       Annotation[#, 45, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[69],
        "47"],
       Annotation[#, 47, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[70],
        "109"],
       Annotation[#, 109, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[71],
        "48"],
       Annotation[#, 48, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[72],
        "54"],
       Annotation[#, 54, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[73],
        "50"],
       Annotation[#, 50, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[74],
        "51"],
       Annotation[#, 51, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[75],
        "52"],
       Annotation[#, 52, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[76],
        "53"],
       Annotation[#, 53, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[77],
        "66"],
       Annotation[#, 66, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[78],
        "55"],
       Annotation[#, 55, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[79],
        "56"],
       Annotation[#, 56, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[80],
        "57"],
       Annotation[#, 57, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[81],
        "99"],
       Annotation[#, 99, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[82],
        "58"],
       Annotation[#, 58, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[83],
        "59"],
       Annotation[#, 59, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[84],
        "60"],
       Annotation[#, 60, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[85],
        "62"],
       Annotation[#, 62, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[86],
        "63"],
       Annotation[#, 63, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[87],
        "69"],
       Annotation[#, 69, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[88],
        "65"],
       Annotation[#, 65, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[89],
        "67"],
       Annotation[#, 67, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[90],
        "68"],
       Annotation[#, 68, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[91],
        "111"],
       Annotation[#, 111, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[92],
        "70"],
       Annotation[#, 70, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[93],
        "71"],
       Annotation[#, 71, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[94],
        "72"],
       Annotation[#, 72, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[95],
        "84"],
       Annotation[#, 84, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[96],
        "73"],
       Annotation[#, 73, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[97],
        "74"],
       Annotation[#, 74, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[98],
        "77"],
       Annotation[#, 77, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[99],
        "78"],
       Annotation[#, 78, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[100],
        "80"],
       Annotation[#, 80, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[101],
        "82"],
       Annotation[#, 82, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[102],
        "83"],
       Annotation[#, 83, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[103],
        "85"],
       Annotation[#, 85, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[104],
        "86"],
       Annotation[#, 86, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[105],
        "87"],
       Annotation[#, 87, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[106],
        "88"],
       Annotation[#, 88, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[107],
        "89"],
       Annotation[#, 89, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[108],
        "90"],
       Annotation[#, 90, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[109],
        "92"],
       Annotation[#, 92, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[110],
        "93"],
       Annotation[#, 93, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[111],
        "95"],
       Annotation[#, 95, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[112],
        "97"],
       Annotation[#, 97, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[113],
        "98"],
       Annotation[#, 98, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[114],
        "101"],
       Annotation[#, 101, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[115],
        "102"],
       Annotation[#, 102, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[116],
        "103"],
       Annotation[#, 103, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[117],
        "104"],
       Annotation[#, 104, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[118],
        "105"],
       Annotation[#, 105, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[119],
        "107"],
       Annotation[#, 107, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[120],
        "108"],
       Annotation[#, 108, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[121],
        "110"],
       Annotation[#, 110, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[122],
        "112"],
       Annotation[#, 112, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[123],
        "113"],
       Annotation[#, 113, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[124],
        "115"],
       Annotation[#, 115, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[125],
        "116"],
       Annotation[#, 116, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[126],
        "117"],
       Annotation[#, 117, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[127],
        "118"],
       Annotation[#, 118, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[128],
        "119"],
       Annotation[#, 119, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[129],
        "120"],
       Annotation[#, 120, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[130],
        "122"],
       Annotation[#, 122, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[131],
        "123"],
       Annotation[#, 123, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[132],
        "125"],
       Annotation[#, 125, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[133],
        "127"],
       Annotation[#, 127, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[134],
        "128"],
       Annotation[#, 128, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[135],
        "130"],
       Annotation[#, 130, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[136],
        "131"],
       Annotation[#, 131, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[137],
        "132"],
       Annotation[#, 132, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[138],
        "133"],
       Annotation[#, 133, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[139],
        "134"],
       Annotation[#, 134, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[140],
        "135"],
       Annotation[#, 135, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[141],
        "137"],
       Annotation[#, 137, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[142],
        "138"],
       Annotation[#, 138, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[143],
        "140"],
       Annotation[#, 140, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[144],
        "142"],
       Annotation[#, 142, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[145],
        "143"],
       Annotation[#, 143, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[146],
        "145"],
       Annotation[#, 145, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[147],
        "146"],
       Annotation[#, 146, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[148],
        "147"],
       Annotation[#, 147, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[149],
        "148"],
       Annotation[#, 148, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[150],
        "149"],
       Annotation[#, 149, "Tooltip"]& ], 
      TagBox[
       TooltipBox[Point3DBox[151],
        "150"],
       Annotation[#, 150, "Tooltip"]& ]}}],
   Annotation[#, VertexCoordinateRules -> CompressedData["
1:eJxlV3k41GsbHtvYl8GMpUFjjGEoM7ZOi95HCvW1qEQplZapJIkcHFlKIZES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     "]]& ],
  AspectRatio->Automatic,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{184, 122},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1648639604]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1473633882],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["LayeredGraphPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LayeredGraphPlot"]], "InlineFormula"],
 " for hierarchical style drawing of directed graphs"
}], "ExampleText",
 CellID->1849880658],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LayeredGraphPlot", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"RandomInteger", "[", 
      RowBox[{"{", 
       RowBox[{"0", ",", "50"}], "}"}], "]"}], "\[Rule]", "i"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "50"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->331224011],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[CompressedData["
1:eJxV1HlQU1cUB2CILLIoCSSGxShEpCiPlEXpgAzcqukgKlAEYeR1tNRgrYDg
igtLsQKxIlWpuFYUpDpVWlAouPSeGungghvVQAUUixvUsCghEkj7yIX4+geT
+ebdc8/vnfMGl/i1kTKOkZHRDuZv5Fd1s2k4gRYgZfijDN9yZ1BdvcOyGOgN
inlr15u+91Q77pmJJqN2BfdzQ/H7LVwQHZykbaixhHo5cfnxauYeHmS1p/27
s0iCTsdG3f+j1A64/7MQ6O5apo4zWs8BOguzbAnlqcqRewz5klOaWRZDTcZf
6iOp/cHEbmBfX7b9sKXraH8R5NWNWGyop9c/33sYJqLROtzS8ttIH0P/Frl/
z4tSC0M9XTTtXkqA+fv5zCXzIs8dIDlRyTLTL72E6edseH567imWRSBJbNLn
JxaAarGSZQfQ3GHPTwBpKuKxvLEq9ryZeSXU6/OPzVvFa2DNxxXGl5D3N+SV
PWD1E0HKWacbWwo8UUTF6dL8BeZgZDeyH2rUNiC5WM/6HlwhpITMd2wemsAR
uxn8i8PZld7fUqg4/tMFTvt12Mtn5H4Pw/1ev5L9j91f432KlY+Zd+xa/f7H
9pl8SMHqz7gQs97PDejKOv35sffXZLHzMd+rsYI1HwG0VH2j91h93jF2fua8
5W7Wc3dQBdzT9xubt6qKvX9mf2cfssyD8kvNehu+XzHbHFgSQupjzUue0JQD
hIYRm81X+M8fsIf7UcS10UIL0RV76IojTg08HvYi3R4OfEFMaZZZlvgz59cQ
v84LDYzoEcLxDcQVqqQO1Qkh6NKJt86o42SGCUGVSxziH1FkpJ4E4wqID/r2
Px88PAnujvqF52G//uBJELWL+CP34JzuDgHszSDOEXc8eCUXQE4i8cPJ8ukd
EgH4jOafLpRsbGvkQ9Fs4o28xmtNaXy4wCW+ZpXGbxTxISpdycpjCxujlaw8
trApQMnKYwsxlJKVhwcOHkpWHh5c8lOy8vAgKJzYTZ+HCyc2KFl5uNBRRlyn
z8OFwmySr2BdscT4nwkgVxBLVnU29M+eAEhLfDtuVlJnpjXUziD7TYrIsH58
3QrehhFbS+t/arSzgr6viM/62y6s/8wSKtKJF0rozss/WoBPLnGnuExe0Tse
No16l7DHvWzOeGhf3szKYwpvxI+qfWIFKG33NO8NAaZA5z5p/36hAL3tsR/8
e68JTM5/lfGdnwBxirPkEX3jwHeWOl/sIEClh5Y9ro0bBye2m9ksesNHza1l
2qm3OZCQ4MiZUMdHxYmytuwFHNjR671KtoePtNIDuU8bjEEtWhwUHc5HL1f7
DwTFGQN0rcltMeej1U1hngd7jeDZ9dMDYaF2SDrkk5n08l88Obx9m9URW9SQ
1xrTZqfDCdsEfNtBHvpy6bGObNkQVoRJIX4VD9nL1k2Pax3EvtdTsoafclHr
Bdpx1bZ3uLqzKOppIhdVSWlFWbAGLzx/MZBnykUnhanOjjMH8HNpZSo/xgaV
zDzi/XuAGie47Hr9LI9Cu+6kverZp8ONHmY63XIKafZoP5nyuQ7vVOYMbw2g
kAm9pC//wTAWUzVS2olCU99MuZKqHcJzQh1aXEwpVIWTl4V0aPERs2Cvwnce
aGZRqfOmskH8NiYys5ixlas2cEvcO+x/ft8tKXO+SzI/oE2kwS6TjvYXMvdZ
u3Yrp5gP4Jvr7j5RMP1W3q3pOuCpxg9zTQMjV1DITnpjXu3JfpwS2dsUKKdQ
j+ZP+gzz/3zR43N5cyop9HNn+JmlP/TjD2a7Zpk0USi2Kfmqx3Q1FgbmthYM
UGhr2gxdjFaNPzy6oiN6oifavH3RjnM2Glxs8XFftqMnwnKZFWfRO7xe7Gcs
cvJE0TaDZuoDg9ir+WaVkOuJpl50Ojn8QIuFHjfp6EEKOW+rbvu6ewgHXYi7
VviIQn3LV1qpbg1j2eZ5ssXVFCoMeZiSSeuw1Ryvy9vzKaTwOWZSycz3P63K
EBg=
    "], {
     {RGBColor[0.5, 0., 0.], Arrowheads[{{0.014305621356057384`, 0.8}}], 
      ArrowBox[{1, 2}], ArrowBox[{2, 35}], ArrowBox[{3, 4}], 
      ArrowBox[{4, 13}], ArrowBox[{4, 42}], ArrowBox[{4, 48}], 
      ArrowBox[{5, 6}], ArrowBox[{6, 26}], ArrowBox[{7, 8}], 
      ArrowBox[{9, 10}], ArrowBox[{10, 29}], ArrowBox[{10, 45}], 
      ArrowBox[{11, 12}], ArrowBox[{12, 30}], ArrowBox[{14, 15}], 
      ArrowBox[{14, 36}], ArrowBox[{14, 37}], ArrowBox[{16, 17}], 
      ArrowBox[{16, 9}], ArrowBox[{16, 51}], ArrowBox[{18, 19}], 
      ArrowBox[{19, 3}], ArrowBox[{20, 21}], 
      ArrowBox[{20, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 
       70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87,
        88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 103, 
       104, 105, 106, 107, 108, 16}], ArrowBox[{21, 1}], ArrowBox[{22, 23}], 
      ArrowBox[{24, 20}], ArrowBox[{24, 25}], ArrowBox[{25, 18}], 
      ArrowBox[{25, 32}], ArrowBox[{26, 22}], ArrowBox[{26, 31}], 
      ArrowBox[{27, 28}], ArrowBox[{28, 5}], ArrowBox[{29, 24}], 
      ArrowBox[{29, 47}], ArrowBox[{30, 44}], ArrowBox[{31, 41}], 
      ArrowBox[{31, 14}], ArrowBox[{32, 11}], ArrowBox[{33, 34}], 
      ArrowBox[{33, 40}], ArrowBox[{35, 43}], ArrowBox[{36, 46}], 
      ArrowBox[{37, 49}], ArrowBox[{38, 39}], ArrowBox[{38, 33}], 
      ArrowBox[{38, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 
       120, 121, 122, 123, 124, 125, 126, 127, 128, 129, 130, 131, 38}], 
      ArrowBox[{40, 7}], ArrowBox[{48, 50}]}, 
     {RGBColor[0, 0, 0.7], 
      TagBox[
       TooltipBox[PointBox[1],
        "25"],
       Annotation[#, 25, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[2],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[3],
        "30"],
       Annotation[#, 30, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[4],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[5],
        "21"],
       Annotation[#, 21, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[6],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[7],
        "44"],
       Annotation[#, 44, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[8],
        "4"],
       Annotation[#, 4, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[9],
        "31"],
       Annotation[#, 31, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[10],
        "5"],
       Annotation[#, 5, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[11],
        "48"],
       Annotation[#, 48, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[12],
        "6"],
       Annotation[#, 6, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[13],
        "7"],
       Annotation[#, 7, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[14],
        "37"],
       Annotation[#, 37, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[15],
        "8"],
       Annotation[#, 8, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[16],
        "27"],
       Annotation[#, 27, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[17],
        "9"],
       Annotation[#, 9, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[18],
        "14"],
       Annotation[#, 14, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[19],
        "10"],
       Annotation[#, 10, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[20],
        "13"],
       Annotation[#, 13, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[21],
        "11"],
       Annotation[#, 11, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[22],
        "15"],
       Annotation[#, 15, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[23],
        "12"],
       Annotation[#, 12, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[24],
        "17"],
       Annotation[#, 17, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[25],
        "41"],
       Annotation[#, 41, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[26],
        "19"],
       Annotation[#, 19, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[27],
        "0"],
       Annotation[#, 0, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[28],
        "16"],
       Annotation[#, 16, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[29],
        "22"],
       Annotation[#, 22, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[30],
        "18"],
       Annotation[#, 18, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[31],
        "20"],
       Annotation[#, 20, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[32],
        "23"],
       Annotation[#, 23, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[33],
        "33"],
       Annotation[#, 33, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[34],
        "24"],
       Annotation[#, 24, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[35],
        "26"],
       Annotation[#, 26, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[36],
        "28"],
       Annotation[#, 28, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[37],
        "29"],
       Annotation[#, 29, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[38],
        "35"],
       Annotation[#, 35, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[39],
        "32"],
       Annotation[#, 32, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[40],
        "34"],
       Annotation[#, 34, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[41],
        "36"],
       Annotation[#, 36, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[42],
        "38"],
       Annotation[#, 38, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[43],
        "39"],
       Annotation[#, 39, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[44],
        "40"],
       Annotation[#, 40, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[45],
        "42"],
       Annotation[#, 42, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[46],
        "43"],
       Annotation[#, 43, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[47],
        "45"],
       Annotation[#, 45, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[48],
        "46"],
       Annotation[#, 46, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[49],
        "47"],
       Annotation[#, 47, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[50],
        "49"],
       Annotation[#, 49, "Tooltip"]& ], 
      TagBox[
       TooltipBox[PointBox[51],
        "50"],
       Annotation[#, 50, "Tooltip"]& ]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{5.340236631734099, -8.340236629744977}, {
     5.3402366312081835`, -9.340236629744977}, {
     2.6813645643256176`, -9.340236629744977}, {
     2.507158399184773, -10.340236629744977`}, {
     8.518702596039091, -3.340236629744977}, {
     8.518702596023005, -4.340236629744977}, {
     15.29594419813725, -4.910914694212046}, {
     15.29594419813705, -5.910914694212046}, {
     2.340236631976877, -2.340236629744977}, {
     2.340236632138881, -3.340236629744977}, {
     4.340236631655371, -8.340236629744977}, {
     4.340236631771502, -9.340236629744977}, {
     1.340236629744977, -11.340236629744977`}, {
     10.020709891661724`, -7.340236629744977}, {
     9.020709891660559, -8.340236629744977}, {
     3.8440448187306355`, -1.340236629744977}, {
     3.340236632120293, -2.340236629744977}, {
     3.205520512348114, -7.340236629744977}, {
     2.9035354937540614`, -8.340236629744977}, {
     5.340236631702949, -6.340236629744977}, {
     5.340236631654177, -7.340236629744977}, {
     8.020709891278571, -6.340236629744977}, {
     8.020709891484628, -7.340236629744977}, {
     4.340236631712328, -5.340236629744977}, {
     4.340236631647242, -6.340236629744977}, {
     8.518702596054922, -5.340236629744977}, {
     8.518702596068792, -1.340236629744977}, {
     8.518702596068735, -2.340236629744977}, {
     3.3402366323978594`, -4.340236629744977}, {
     4.340236631051523, -10.340236629744977`}, {
     9.02070989164487, -6.340236629744977}, {
     4.34023663153617, -7.340236629744977}, {
     14.780226055029033`, -2.910914694212046}, {
     14.295944198043344`, -3.910914694212046}, {
     5.34023663079874, -10.340236629744977`}, {
     10.020709891644984`, -8.340236629744977}, {
     11.020709891598457`, -8.340236629744977}, {
     14.271861215599387`, -1.910914694212046}, {
     13.78022605497344, -2.910914694212046}, {
     15.295944198118008`, -3.910914694212046}, {
     9.020709891476926, -7.340236629744977}, {
     2.340236629806027, -11.340236629744977`}, {
     5.3402366305002555`, -11.340236629744977`}, {
     4.340236630266288, -11.340236629744977`}, {
     2.340236632319188, -4.340236629744977}, {
     10.02070989162938, -9.340236629744977}, {
     3.340236632240858, -5.340236629744977}, {
     3.340236630427837, -11.340236629744977`}, {
     11.020709891642369`, -9.340236629744977}, {
     3.3402366306411704`, -12.340236629744977`}, {
     4.340236631293676, -2.340236629744977}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  ImageSize->{283., Automatic},
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{287, 223},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->828182580]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->18590],

Cell["Compound heads are not laid out as trees:", "ExampleText",
 CellID->1771660961],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TreeForm", "[", 
  RowBox[{
   RowBox[{"g", "[", "a", "]"}], "[", "b", "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->927617488],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{0., 1.}, {0., 0.}}, {
     {RGBColor[0.55, 0.45, 0.45], LineBox[{{1, 2}}]}, {
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           RowBox[{"g", "(", "a", ")"}], "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.05],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 1],
        TagBox[
         RowBox[{
           RowBox[{"g", "[", "a", "]"}], "[", "b", "]"}], HoldForm]],
       Annotation[#, 
        HoldForm[
         $CellContext`g[$CellContext`a][$CellContext`b]], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           TagBox["b",
            HoldForm], "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.05],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 2],
        TagBox["b", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`b], "Tooltip"]& ]}}],
   Annotation[#, VertexCoordinateRules -> {{0., 1.}, {0., 0.}}]& ],
  AspectRatio->1,
  FrameTicks->Automatic,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{184, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TreeForm=",
 CellID->900665285]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->22881],

Cell["A complete binary tree:", "ExampleText",
 CellID->1805632442],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Nest", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"{", 
     RowBox[{"#", ",", "#"}], "}"}], "&"}], ",", "x", ",", "4"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->57391352],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzNWNtOwkAQ3baIoAKtTyZewtfokx/REBN4IBrkq+UjaleokuOS2dmZ3UJC
2dnLmTlnpku3r/V2+baut6tFPX/Z1B/L1eJz/vy+abuKzJjsyxgzuzNtu2lb
P1/72bVfYwb2WnR9Ddsegz0j5l8J11N40viulePjxhtb37JnfbXzj3ZhL/ur
MEt5a1YOdNuPLE7Nd0XnWs/1j1Xq6z80Hi19bhPpE5ofys6b4Ooa/NqHWPLD
L86+IMbRHkVFd3pLxm2clJsX1zPN61DIPW1e09as4l2MKH8c2kYX56VzBLHs
TPz3k2L6+IjBA/dbbR4hvPrN18gLs698xa47+u7LhSgdk/I4zqPxCXM+4rvW
c/CmQv8h8WjoUyXSR5ofys7sRbzHd8+TXVRDGMfTCjUf8anTDoWHpzmuf248
WvpUJ+Zr6yPNT19PEtN/PbjrIrMQDK7aIT6wQjXilFZtHL1nZ6F3jLro41R8
A7ZTu+DVXpkIRi9VYwuq9ki6TnrVVTfnafb2R0IRHOdmG9fjfkvhS/dSit+T
Mj+ufn5ZltbKPdj4nhHHcT31XhLX43tUCp/rj8vvQZkfVz+f59S9sfNomewb
oLSNaQ==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{490, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->214913544]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TreeForm", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->184812927],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{4.330127018922194, 2.309401076758503}, {
    2.0207259421636903`, 1.7320508075688772`}, {0.8660254037844386, 
    1.1547005383792515`}, {0.28867513459481287`, 0.5773502691896257}, {0., 
    0.}, {0.5773502691896257, 0.}, {1.4433756729740643`, 
    0.5773502691896257}, {1.1547005383792515`, 0.}, {1.7320508075688772`, 
    0.}, {3.1754264805429417`, 1.1547005383792515`}, {2.598076211353316, 
    0.5773502691896257}, {2.309401076758503, 0.}, {2.8867513459481287`, 0.}, {
    3.7527767497325675`, 0.5773502691896257}, {3.4641016151377544`, 0.}, {
    4.041451884327381, 0.}, {6.639528095680697, 1.7320508075688772`}, {
    5.484827557301445, 1.1547005383792515`}, {4.907477288111819, 
    0.5773502691896257}, {4.618802153517006, 0.}, {5.196152422706632, 0.}, {
    6.06217782649107, 0.5773502691896257}, {5.773502691896257, 0.}, {
    6.3508529610858835`, 0.}, {7.794228634059948, 1.1547005383792515`}, {
    7.216878364870322, 0.5773502691896257}, {6.928203230275509, 0.}, {
    7.505553499465135, 0.}, {8.371578903249574, 0.5773502691896257}, {
    8.082903768654761, 0.}, {8.660254037844387, 0.}}, {
     {RGBColor[0.55, 0.45, 0.45], 
      LineBox[{{1, 2}, {1, 17}, {2, 3}, {2, 10}, {3, 4}, {3, 7}, {4, 5}, {4, 
       6}, {7, 8}, {7, 9}, {10, 11}, {10, 14}, {11, 12}, {11, 13}, {14, 15}, {
       14, 16}, {17, 18}, {17, 25}, {18, 19}, {18, 22}, {19, 20}, {19, 21}, {
       22, 23}, {22, 24}, {25, 26}, {25, 29}, {26, 27}, {26, 28}, {29, 30}, {
       29, 31}}]}, {
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["List", "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.025],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 1],
        TagBox[
         RowBox[{"{", 
           RowBox[{
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{
                    RowBox[{"{", 
                    RowBox[{"x", ",", "x"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"x", ",", "x"}], "}"}]}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{
                    RowBox[{"{", 
                    RowBox[{"x", ",", "x"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"x", ",", "x"}], "}"}]}], "}"}]}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{
                    RowBox[{"{", 
                    RowBox[{"x", ",", "x"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"x", ",", "x"}], "}"}]}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{
                    RowBox[{"{", 
                    RowBox[{"x", ",", "x"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"x", ",", "x"}], "}"}]}], "}"}]}], "}"}]}], "}"}],
          HoldForm]],
       Annotation[#, 
        HoldForm[{{{{$CellContext`x, $CellContext`x}, {$CellContext`x, \
$CellContext`x}}, {{$CellContext`x, $CellContext`x}, {$CellContext`x, \
$CellContext`x}}}, {{{$CellContext`x, $CellContext`x}, {$CellContext`x, \
$CellContext`x}}, {{$CellContext`x, $CellContext`x}, {$CellContext`x, \
$CellContext`x}}}}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["List", "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.025],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 2],
        TagBox[
         RowBox[{"{", 
           RowBox[{
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"x", ",", "x"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"x", ",", "x"}], "}"}]}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"x", ",", "x"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"x", ",", "x"}], "}"}]}], "}"}]}], "}"}], 
         HoldForm]],
       Annotation[#, 
        HoldForm[{{{$CellContext`x, $CellContext`x}, {$CellContext`x, \
$CellContext`x}}, {{$CellContext`x, $CellContext`x}, {$CellContext`x, \
$CellContext`x}}}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["List", "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.025],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 3],
        TagBox[
         RowBox[{"{", 
           RowBox[{
             RowBox[{"{", 
               RowBox[{"x", ",", "x"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"x", ",", "x"}], "}"}]}], "}"}], HoldForm]],
       Annotation[#, 
        HoldForm[{{$CellContext`x, $CellContext`x}, {$CellContext`x, \
$CellContext`x}}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["List", "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.025],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 4],
        TagBox[
         RowBox[{"{", 
           RowBox[{"x", ",", "x"}], "}"}], HoldForm]],
       Annotation[#, 
        HoldForm[{$CellContext`x, $CellContext`x}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           TagBox["x",
            HoldForm], "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.025],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 5],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           TagBox["x",
            HoldForm], "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.025],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 6],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["List", "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.025],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 7],
        TagBox[
         RowBox[{"{", 
           RowBox[{"x", ",", "x"}], "}"}], HoldForm]],
       Annotation[#, 
        HoldForm[{$CellContext`x, $CellContext`x}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           TagBox["x",
            HoldForm], "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.025],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 8],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           TagBox["x",
            HoldForm], "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.025],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 9],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["List", "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.025],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 10],
        TagBox[
         RowBox[{"{", 
           RowBox[{
             RowBox[{"{", 
               RowBox[{"x", ",", "x"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"x", ",", "x"}], "}"}]}], "}"}], HoldForm]],
       Annotation[#, 
        HoldForm[{{$CellContext`x, $CellContext`x}, {$CellContext`x, \
$CellContext`x}}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["List", "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.025],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 11],
        TagBox[
         RowBox[{"{", 
           RowBox[{"x", ",", "x"}], "}"}], HoldForm]],
       Annotation[#, 
        HoldForm[{$CellContext`x, $CellContext`x}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           TagBox["x",
            HoldForm], "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.025],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 12],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           TagBox["x",
            HoldForm], "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.025],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 13],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["List", "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.025],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 14],
        TagBox[
         RowBox[{"{", 
           RowBox[{"x", ",", "x"}], "}"}], HoldForm]],
       Annotation[#, 
        HoldForm[{$CellContext`x, $CellContext`x}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           TagBox["x",
            HoldForm], "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.025],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 15],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           TagBox["x",
            HoldForm], "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.025],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 16],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["List", "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.025],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 17],
        TagBox[
         RowBox[{"{", 
           RowBox[{
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"x", ",", "x"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"x", ",", "x"}], "}"}]}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"x", ",", "x"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"x", ",", "x"}], "}"}]}], "}"}]}], "}"}], 
         HoldForm]],
       Annotation[#, 
        HoldForm[{{{$CellContext`x, $CellContext`x}, {$CellContext`x, \
$CellContext`x}}, {{$CellContext`x, $CellContext`x}, {$CellContext`x, \
$CellContext`x}}}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["List", "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.025],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 18],
        TagBox[
         RowBox[{"{", 
           RowBox[{
             RowBox[{"{", 
               RowBox[{"x", ",", "x"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"x", ",", "x"}], "}"}]}], "}"}], HoldForm]],
       Annotation[#, 
        HoldForm[{{$CellContext`x, $CellContext`x}, {$CellContext`x, \
$CellContext`x}}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["List", "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.025],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 19],
        TagBox[
         RowBox[{"{", 
           RowBox[{"x", ",", "x"}], "}"}], HoldForm]],
       Annotation[#, 
        HoldForm[{$CellContext`x, $CellContext`x}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           TagBox["x",
            HoldForm], "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.025],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 20],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           TagBox["x",
            HoldForm], "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.025],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 21],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["List", "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.025],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 22],
        TagBox[
         RowBox[{"{", 
           RowBox[{"x", ",", "x"}], "}"}], HoldForm]],
       Annotation[#, 
        HoldForm[{$CellContext`x, $CellContext`x}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           TagBox["x",
            HoldForm], "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.025],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 23],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           TagBox["x",
            HoldForm], "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.025],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 24],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["List", "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.025],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 25],
        TagBox[
         RowBox[{"{", 
           RowBox[{
             RowBox[{"{", 
               RowBox[{"x", ",", "x"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"x", ",", "x"}], "}"}]}], "}"}], HoldForm]],
       Annotation[#, 
        HoldForm[{{$CellContext`x, $CellContext`x}, {$CellContext`x, \
$CellContext`x}}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["List", "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.025],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 26],
        TagBox[
         RowBox[{"{", 
           RowBox[{"x", ",", "x"}], "}"}], HoldForm]],
       Annotation[#, 
        HoldForm[{$CellContext`x, $CellContext`x}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           TagBox["x",
            HoldForm], "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.025],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 27],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           TagBox["x",
            HoldForm], "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.025],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 28],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["List", "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.025],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 29],
        TagBox[
         RowBox[{"{", 
           RowBox[{"x", ",", "x"}], "}"}], HoldForm]],
       Annotation[#, 
        HoldForm[{$CellContext`x, $CellContext`x}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           TagBox["x",
            HoldForm], "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.025],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 30],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           TagBox["x",
            HoldForm], "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.025],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 31],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{4.330127018922194, 2.309401076758503}, {
     2.0207259421636903`, 1.7320508075688772`}, {0.8660254037844386, 
     1.1547005383792515`}, {0.28867513459481287`, 0.5773502691896257}, {0., 
     0.}, {0.5773502691896257, 0.}, {1.4433756729740643`, 
     0.5773502691896257}, {1.1547005383792515`, 0.}, {1.7320508075688772`, 
     0.}, {3.1754264805429417`, 1.1547005383792515`}, {2.598076211353316, 
     0.5773502691896257}, {2.309401076758503, 0.}, {2.8867513459481287`, 
     0.}, {3.7527767497325675`, 0.5773502691896257}, {3.4641016151377544`, 
     0.}, {4.041451884327381, 0.}, {6.639528095680697, 1.7320508075688772`}, {
     5.484827557301445, 1.1547005383792515`}, {4.907477288111819, 
     0.5773502691896257}, {4.618802153517006, 0.}, {5.196152422706632, 0.}, {
     6.06217782649107, 0.5773502691896257}, {5.773502691896257, 0.}, {
     6.3508529610858835`, 0.}, {7.794228634059948, 1.1547005383792515`}, {
     7.216878364870322, 0.5773502691896257}, {6.928203230275509, 0.}, {
     7.505553499465135, 0.}, {8.371578903249574, 0.5773502691896257}, {
     8.082903768654761, 0.}, {8.660254037844387, 0.}}]& ],
  AspectRatio->NCache[Rational[1, 4] 5^Rational[1, 2], 0.5590169943749475],
  FrameTicks->None,
  ImageSize->{317., Automatic},
  PlotRange->All,
  PlotRangePadding->Automatic]], "Output",
 ImageSize->{321, 178},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//TreeForm=",
 CellID->1951118709]
}, Open  ]],

Cell["A complete 3-ary tree:", "ExampleText",
 CellID->2025128386],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Nest", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"{", 
     RowBox[{"#", ",", "#", ",", "#"}], "}"}], "&"}], ",", "x", ",", "3"}], 
  "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->412473837],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWF1OwkAQ3rbIjwq0PvmIB/DnFPrkIRpiAg9Gg9xOzyI+qNeo3RY0+dh2
ZrZbmgok0J3Ozjcz32zL7tzHy9nDY7ycT+PJ3SJ+ns2nL5Pbp0V6K/CU8l6V
UhfnKh0n6Sj76s9b+s2H+ehE/wYbbaI6IA9AHhMy2h87xsN4q+JR8Ur5CHfM
B4WH8Uj5CPQPyYrW+6kYrq+RAUXfRxyuHVadsjNlYfJP5XHmOI8iu4iZB8p+
cXU6v/Ia219fEeOooh7lfqPeB416N3JRW2W6raqMzDuVW9XKlDw5OOsv5nSw
8dsTatCLnonv6nq9Ya71eePk6oLpvlHTPNN8b+YM7JneXuEU75uYQ7j2YN7Q
0m5kaYdxmvyX4UYFuLZ5FNlFhB1VJS/hvIeCxBxlF+bh7o5rh7tErh3GSe0u
ETcqwLXNo8gOq0Tl4erfYsS4g8815uAGFSvsBlVaf47XcUMM0ajbkckZcrGD
PyVkY1WcoYVO0VgriO1tuFMmytEwFikTdu+ga4JP1ON7AfXSJ/xG6B/1aM9j
hepiXYKM52zU47kf9YhPnduvhP5Rj/a8ro0eYr9PPpKu033rGK4ylgKhVVs6
Zh/87FrSWfjfHad3fr1K9zqHPoddn2OVTfeF/LflFP6Z2Kyutpxev6yyO5z6
BLzt5ZnGbl3VvZPPo5L+v9S9k/7OotJDzt5UeT/DWCJV\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{443, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->200916461]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TreeForm", "[", "%", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->201732629],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{4.913538149119954, 1.1338934190276817`}, {
    1.5118578920369088`, 0.7559289460184545}, {0.3779644730092272, 
    0.3779644730092273}, {0., 0.}, {0.3779644730092272, 0.}, {
    0.7559289460184544, 0.}, {1.5118578920369088`, 0.3779644730092273}, {
    1.1338934190276817`, 0.}, {1.5118578920369088`, 0.}, {1.889822365046136, 
    0.}, {2.6457513110645903`, 0.3779644730092273}, {2.2677868380553634`, 
    0.}, {2.6457513110645903`, 0.}, {3.0237157840738176`, 0.}, {
    4.913538149119954, 0.7559289460184545}, {3.779644730092272, 
    0.3779644730092273}, {3.401680257083045, 0.}, {3.779644730092272, 0.}, {
    4.157609203101499, 0.}, {4.913538149119954, 0.3779644730092273}, {
    4.535573676110727, 0.}, {4.913538149119954, 0.}, {5.2915026221291805`, 
    0.}, {6.047431568147635, 0.3779644730092273}, {5.669467095138408, 0.}, {
    6.047431568147635, 0.}, {6.425396041156863, 0.}, {8.315218406202998, 
    0.7559289460184545}, {7.181324987175317, 0.3779644730092273}, {
    6.80336051416609, 0.}, {7.181324987175317, 0.}, {7.559289460184544, 0.}, {
    8.315218406202998, 0.3779644730092273}, {7.937253933193771, 0.}, {
    8.315218406202998, 0.}, {8.693182879212225, 0.}, {9.44911182523068, 
    0.3779644730092273}, {9.071147352221454, 0.}, {9.44911182523068, 0.}, {
    9.827076298239907, 0.}}, {
     {RGBColor[0.55, 0.45, 0.45], 
      LineBox[{{1, 2}, {1, 15}, {1, 28}, {2, 3}, {2, 7}, {2, 11}, {3, 4}, {3, 
       5}, {3, 6}, {7, 8}, {7, 9}, {7, 10}, {11, 12}, {11, 13}, {11, 14}, {15,
        16}, {15, 20}, {15, 24}, {16, 17}, {16, 18}, {16, 19}, {20, 21}, {20, 
       22}, {20, 23}, {24, 25}, {24, 26}, {24, 27}, {28, 29}, {28, 33}, {28, 
       37}, {29, 30}, {29, 31}, {29, 32}, {33, 34}, {33, 35}, {33, 36}, {37, 
       38}, {37, 39}, {37, 40}}]}, {
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["List", "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.022222222222222223`],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 1],
        TagBox[
         RowBox[{"{", 
           RowBox[{
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"x", ",", "x", ",", "x"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"x", ",", "x", ",", "x"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"x", ",", "x", ",", "x"}], "}"}]}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"x", ",", "x", ",", "x"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"x", ",", "x", ",", "x"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"x", ",", "x", ",", "x"}], "}"}]}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"x", ",", "x", ",", "x"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"x", ",", "x", ",", "x"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"x", ",", "x", ",", "x"}], "}"}]}], "}"}]}], "}"}],
          HoldForm]],
       Annotation[#, 
        HoldForm[{{{$CellContext`x, $CellContext`x, $CellContext`x}, \
{$CellContext`x, $CellContext`x, $CellContext`x}, {$CellContext`x, \
$CellContext`x, $CellContext`x}}, {{$CellContext`x, $CellContext`x, \
$CellContext`x}, {$CellContext`x, $CellContext`x, $CellContext`x}, \
{$CellContext`x, $CellContext`x, $CellContext`x}}, {{$CellContext`x, \
$CellContext`x, $CellContext`x}, {$CellContext`x, $CellContext`x, \
$CellContext`x}, {$CellContext`x, $CellContext`x, $CellContext`x}}}], 
        "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["List", "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.022222222222222223`],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 2],
        TagBox[
         RowBox[{"{", 
           RowBox[{
             RowBox[{"{", 
               RowBox[{"x", ",", "x", ",", "x"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"x", ",", "x", ",", "x"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"x", ",", "x", ",", "x"}], "}"}]}], "}"}], HoldForm]],
       Annotation[#, 
        HoldForm[{{$CellContext`x, $CellContext`x, $CellContext`x}, \
{$CellContext`x, $CellContext`x, $CellContext`x}, {$CellContext`x, \
$CellContext`x, $CellContext`x}}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["List", "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.022222222222222223`],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 3],
        TagBox[
         RowBox[{"{", 
           RowBox[{"x", ",", "x", ",", "x"}], "}"}], HoldForm]],
       Annotation[#, 
        HoldForm[{$CellContext`x, $CellContext`x, $CellContext`x}], 
        "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           TagBox["x",
            HoldForm], "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.022222222222222223`],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 4],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           TagBox["x",
            HoldForm], "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.022222222222222223`],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 5],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           TagBox["x",
            HoldForm], "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.022222222222222223`],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 6],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["List", "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.022222222222222223`],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 7],
        TagBox[
         RowBox[{"{", 
           RowBox[{"x", ",", "x", ",", "x"}], "}"}], HoldForm]],
       Annotation[#, 
        HoldForm[{$CellContext`x, $CellContext`x, $CellContext`x}], 
        "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           TagBox["x",
            HoldForm], "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.022222222222222223`],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 8],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           TagBox["x",
            HoldForm], "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.022222222222222223`],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 9],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           TagBox["x",
            HoldForm], "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.022222222222222223`],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 10],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["List", "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.022222222222222223`],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 11],
        TagBox[
         RowBox[{"{", 
           RowBox[{"x", ",", "x", ",", "x"}], "}"}], HoldForm]],
       Annotation[#, 
        HoldForm[{$CellContext`x, $CellContext`x, $CellContext`x}], 
        "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           TagBox["x",
            HoldForm], "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.022222222222222223`],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 12],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           TagBox["x",
            HoldForm], "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.022222222222222223`],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 13],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           TagBox["x",
            HoldForm], "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.022222222222222223`],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 14],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["List", "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.022222222222222223`],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 15],
        TagBox[
         RowBox[{"{", 
           RowBox[{
             RowBox[{"{", 
               RowBox[{"x", ",", "x", ",", "x"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"x", ",", "x", ",", "x"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"x", ",", "x", ",", "x"}], "}"}]}], "}"}], HoldForm]],
       Annotation[#, 
        HoldForm[{{$CellContext`x, $CellContext`x, $CellContext`x}, \
{$CellContext`x, $CellContext`x, $CellContext`x}, {$CellContext`x, \
$CellContext`x, $CellContext`x}}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["List", "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.022222222222222223`],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 16],
        TagBox[
         RowBox[{"{", 
           RowBox[{"x", ",", "x", ",", "x"}], "}"}], HoldForm]],
       Annotation[#, 
        HoldForm[{$CellContext`x, $CellContext`x, $CellContext`x}], 
        "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           TagBox["x",
            HoldForm], "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.022222222222222223`],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 17],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           TagBox["x",
            HoldForm], "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.022222222222222223`],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 18],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           TagBox["x",
            HoldForm], "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.022222222222222223`],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 19],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["List", "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.022222222222222223`],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 20],
        TagBox[
         RowBox[{"{", 
           RowBox[{"x", ",", "x", ",", "x"}], "}"}], HoldForm]],
       Annotation[#, 
        HoldForm[{$CellContext`x, $CellContext`x, $CellContext`x}], 
        "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           TagBox["x",
            HoldForm], "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.022222222222222223`],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 21],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           TagBox["x",
            HoldForm], "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.022222222222222223`],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 22],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           TagBox["x",
            HoldForm], "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.022222222222222223`],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 23],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["List", "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.022222222222222223`],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 24],
        TagBox[
         RowBox[{"{", 
           RowBox[{"x", ",", "x", ",", "x"}], "}"}], HoldForm]],
       Annotation[#, 
        HoldForm[{$CellContext`x, $CellContext`x, $CellContext`x}], 
        "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           TagBox["x",
            HoldForm], "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.022222222222222223`],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 25],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           TagBox["x",
            HoldForm], "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.022222222222222223`],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 26],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           TagBox["x",
            HoldForm], "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.022222222222222223`],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 27],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["List", "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.022222222222222223`],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 28],
        TagBox[
         RowBox[{"{", 
           RowBox[{
             RowBox[{"{", 
               RowBox[{"x", ",", "x", ",", "x"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"x", ",", "x", ",", "x"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"x", ",", "x", ",", "x"}], "}"}]}], "}"}], HoldForm]],
       Annotation[#, 
        HoldForm[{{$CellContext`x, $CellContext`x, $CellContext`x}, \
{$CellContext`x, $CellContext`x, $CellContext`x}, {$CellContext`x, \
$CellContext`x, $CellContext`x}}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["List", "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.022222222222222223`],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 29],
        TagBox[
         RowBox[{"{", 
           RowBox[{"x", ",", "x", ",", "x"}], "}"}], HoldForm]],
       Annotation[#, 
        HoldForm[{$CellContext`x, $CellContext`x, $CellContext`x}], 
        "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           TagBox["x",
            HoldForm], "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.022222222222222223`],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 30],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           TagBox["x",
            HoldForm], "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.022222222222222223`],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 31],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           TagBox["x",
            HoldForm], "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.022222222222222223`],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 32],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["List", "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.022222222222222223`],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 33],
        TagBox[
         RowBox[{"{", 
           RowBox[{"x", ",", "x", ",", "x"}], "}"}], HoldForm]],
       Annotation[#, 
        HoldForm[{$CellContext`x, $CellContext`x, $CellContext`x}], 
        "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           TagBox["x",
            HoldForm], "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.022222222222222223`],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 34],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           TagBox["x",
            HoldForm], "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.022222222222222223`],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 35],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           TagBox["x",
            HoldForm], "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.022222222222222223`],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 36],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["List", "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.022222222222222223`],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 37],
        TagBox[
         RowBox[{"{", 
           RowBox[{"x", ",", "x", ",", "x"}], "}"}], HoldForm]],
       Annotation[#, 
        HoldForm[{$CellContext`x, $CellContext`x, $CellContext`x}], 
        "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           TagBox["x",
            HoldForm], "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.022222222222222223`],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 38],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           TagBox["x",
            HoldForm], "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.022222222222222223`],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 39],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           TagBox["x",
            HoldForm], "StandardForm", "Output",
           StripOnInput->False,
           FrontFaceColor->GrayLevel[0],
           BackFaceColor->GrayLevel[0],
           GraphicsColor->GrayLevel[0],
           FontSize->Scaled[0.022222222222222223`],
           FontColor->GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 40],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{4.913538149119954, 1.1338934190276817`}, {
     1.5118578920369088`, 0.7559289460184545}, {0.3779644730092272, 
     0.3779644730092273}, {0., 0.}, {0.3779644730092272, 0.}, {
     0.7559289460184544, 0.}, {1.5118578920369088`, 0.3779644730092273}, {
     1.1338934190276817`, 0.}, {1.5118578920369088`, 0.}, {1.889822365046136, 
     0.}, {2.6457513110645903`, 0.3779644730092273}, {2.2677868380553634`, 
     0.}, {2.6457513110645903`, 0.}, {3.0237157840738176`, 0.}, {
     4.913538149119954, 0.7559289460184545}, {3.779644730092272, 
     0.3779644730092273}, {3.401680257083045, 0.}, {3.779644730092272, 0.}, {
     4.157609203101499, 0.}, {4.913538149119954, 0.3779644730092273}, {
     4.535573676110727, 0.}, {4.913538149119954, 0.}, {5.2915026221291805`, 
     0.}, {6.047431568147635, 0.3779644730092273}, {5.669467095138408, 0.}, {
     6.047431568147635, 0.}, {6.425396041156863, 0.}, {8.315218406202998, 
     0.7559289460184545}, {7.181324987175317, 0.3779644730092273}, {
     6.80336051416609, 0.}, {7.181324987175317, 0.}, {7.559289460184544, 
     0.}, {8.315218406202998, 0.3779644730092273}, {7.937253933193771, 0.}, {
     8.315218406202998, 0.}, {8.693182879212225, 0.}, {9.44911182523068, 
     0.3779644730092273}, {9.071147352221454, 0.}, {9.44911182523068, 0.}, {
     9.827076298239907, 0.}}]& ],
  AspectRatio->NCache[Rational[1, 3] 2^Rational[1, 2], 0.4714045207910317],
  FrameTicks->Automatic,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{404, 189},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{400, Automatic}},
 CellLabel->"Out[4]//TreeForm=",
 CellID->435251197]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->520908183],

Cell["A symmetric tree: ", "ExampleText",
 CellID->63865595],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TreeForm", "[", 
  RowBox[{
   RowBox[{"Nest", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"{", 
       RowBox[{"#", ",", 
        RowBox[{"{", "#", "}"}], ",", "#"}], "}"}], "&"}], ",", "x", ",", 
     "5"}], "]"}], ",", 
   RowBox[{"VertexLabeling", "\[Rule]", "Automatic"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->10108729],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[CompressedData["
1:eJx1mGlslVUQhq9FVCKlUGvZKVtZCi1LF9oCvbcYQAKKhRjEpGEtIAYBN2LE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    "], {
     {RGBColor[0.55, 0.45, 0.45], LineBox[CompressedData["
1:eJw912PMZAkQBdDusXds27Zt27Zt27Zt27ZtY20bX/pkf9ycm+pK5eV1epCm
ba+6PcMFAoH3wUAgzP/433Ws4LPwPivMnmYRmICZzCIyGmObRWJkRtWj2I0u
MRiTH+mx3IrDuIyvx/MsCSURkzOtWWImYTI9qd0UkpKpmEZP7VY6pmdGPYN3
kZk5mM8sC7Myu57Nbk7JxdzMq+dxKz8LsJBe0HdVRIqyGluYFWNpVjQrzhIs
pZe0W0bKshwr6OXdqsTKrKpX8SzVpQbrsrFZTdZiHb223XpSnw3YSG/oVhM2
ZXO9mXfRku3YxawVW7Ot3sZue+nAjuysd3KrK7uxh949EPot9eJozjXrzQEc
ZtaHfdlf72d3oAziYA7Vh7g1nCM4Sh/pWcbIWE7iDLNxHM+J+gS7k2UKp3K6
Ps2tmZzFOfps72IeF3Ol2Xwu4CJ9od0lspTLuEJf7tYqruZafU0g9GfhetnA
p4wdDM02+uwQr5ht4nbuNdvMLdymb7W7Q3ZyF/fou93ax/08qB/wLIflCE/y
vNlRHuMJ/bjdU3KaZ3hOP+vWBV7kZf2Sd3GVt/jA7Bqv86Z+w+5tucO7vK/f
c+shH/GJ/th39Uye8yv+Y/aCb/mp2Uu+4hv9td138p4f+In+sVuf8XN+qX/h
Wb6Wb/gjfzf7lt/xB/17uz/Jz/yFv+m/uvUH/+Tf+l/eRdhf+mFGZPRgaBZk
OEbQwwdDu5EkMqMwmh41GLoVgzH5kR4rGPotxWFa5jeLy0RMYRaP8ZlQT2A3
sSRhUibXk7mVkqmYRk/tWdJJemZhLrMMzMjMeia7WSUbszOnnsOt3MzDfHpe
76IAi7K0WUEWYhG9sN1iUpwlWEov6VYZlmV5vVww9G/BihzGPWaV2JhdzSqz
BuuZVWFVVter2a0ptVibdfU6btVnAzbSG3qWJtKUrdjBrBmbs6Xewm5racO2
bK+3c6sjO7GL3tm76MbeHGjWnT3YS+9pt4/0ZT8O0Pu7NYiDOVQf4rsaLiM4
k6vNRnIcp5iN4miO1cfYHS8TOJGT9UluTeU0ztCne5ZZMpsLuMxsDudyvj7P
7kJZxMVcqi9xazlXcJW+0rtYw43cbraW67hBX293k2zmFm7Tt7q1gzu5W98V
DP2W9vIcH5jt42GeNNvPAzykH7R7RI7yGE/ox906xdM8q5/xLOflAq/yttlF
XuIV/bLda3KdN3hLv+nWHd7lff2ed/GQz/jG7BEf86n+xO5zecGXfK2/cust
3/GDHvZ/5H8BqfvLvg==
       "]]}, 
     {RGBColor[0, 0, 0.7], PointBox[1], PointBox[2], PointBox[3], PointBox[4],
       PointBox[5], PointBox[6], PointBox[7], PointBox[8], PointBox[9], 
      PointBox[10], PointBox[11], PointBox[12], PointBox[13], PointBox[14], 
      PointBox[15], PointBox[16], PointBox[17], PointBox[18], PointBox[19], 
      PointBox[20], PointBox[21], PointBox[22], PointBox[23], PointBox[24], 
      PointBox[25], PointBox[26], PointBox[27], PointBox[28], PointBox[29], 
      PointBox[30], PointBox[31], PointBox[32], PointBox[33], PointBox[34], 
      PointBox[35], PointBox[36], PointBox[37], PointBox[38], PointBox[39], 
      PointBox[40], PointBox[41], PointBox[42], PointBox[43], PointBox[44], 
      PointBox[45], PointBox[46], PointBox[47], PointBox[48], PointBox[49], 
      PointBox[50], PointBox[51], PointBox[52], PointBox[53], PointBox[54], 
      PointBox[55], PointBox[56], PointBox[57], PointBox[58], PointBox[59], 
      PointBox[60], PointBox[61], PointBox[62], PointBox[63], PointBox[64], 
      PointBox[65], PointBox[66], PointBox[67], PointBox[68], PointBox[69], 
      PointBox[70], PointBox[71], PointBox[72], PointBox[73], PointBox[74], 
      PointBox[75], PointBox[76], PointBox[77], PointBox[78], PointBox[79], 
      PointBox[80], PointBox[81], PointBox[82], PointBox[83], PointBox[84], 
      PointBox[85], PointBox[86], PointBox[87], PointBox[88], PointBox[89], 
      PointBox[90], PointBox[91], PointBox[92], PointBox[93], PointBox[94], 
      PointBox[95], PointBox[96], PointBox[97], PointBox[98], PointBox[99], 
      PointBox[100], PointBox[101], PointBox[102], PointBox[103], 
      PointBox[104], PointBox[105], PointBox[106], PointBox[107], 
      PointBox[108], PointBox[109], PointBox[110], PointBox[111], 
      PointBox[112], PointBox[113], PointBox[114], PointBox[115], 
      PointBox[116], PointBox[117], PointBox[118], PointBox[119], 
      PointBox[120], PointBox[121], PointBox[122], PointBox[123], 
      PointBox[124], PointBox[125], PointBox[126], PointBox[127], 
      PointBox[128], PointBox[129], PointBox[130], PointBox[131], 
      PointBox[132], PointBox[133], PointBox[134], PointBox[135], 
      PointBox[136], PointBox[137], PointBox[138], PointBox[139], 
      PointBox[140], PointBox[141], PointBox[142], PointBox[143], 
      PointBox[144], PointBox[145], PointBox[146], PointBox[147], 
      PointBox[148], PointBox[149], PointBox[150], PointBox[151], 
      PointBox[152], PointBox[153], PointBox[154], PointBox[155], 
      PointBox[156], PointBox[157], PointBox[158], PointBox[159], 
      PointBox[160], PointBox[161], PointBox[162], PointBox[163], 
      PointBox[164], PointBox[165], PointBox[166], PointBox[167], 
      PointBox[168], PointBox[169], PointBox[170], PointBox[171], 
      PointBox[172], PointBox[173], PointBox[174], PointBox[175], 
      PointBox[176], PointBox[177], PointBox[178], PointBox[179], 
      PointBox[180], PointBox[181], PointBox[182], PointBox[183], 
      PointBox[184], PointBox[185], PointBox[186], PointBox[187], 
      PointBox[188], PointBox[189], PointBox[190], PointBox[191], 
      PointBox[192], PointBox[193], PointBox[194], PointBox[195], 
      PointBox[196], PointBox[197], PointBox[198], PointBox[199], 
      PointBox[200], PointBox[201], PointBox[202], PointBox[203], 
      PointBox[204], PointBox[205], PointBox[206], PointBox[207], 
      PointBox[208], PointBox[209], PointBox[210], PointBox[211], 
      PointBox[212], PointBox[213], PointBox[214], PointBox[215], 
      PointBox[216], PointBox[217], PointBox[218], PointBox[219], 
      PointBox[220], PointBox[221], PointBox[222], PointBox[223], 
      PointBox[224], PointBox[225], PointBox[226], PointBox[227], 
      PointBox[228], PointBox[229], PointBox[230], PointBox[231], 
      PointBox[232], PointBox[233], PointBox[234], PointBox[235], 
      PointBox[236], PointBox[237], PointBox[238], PointBox[239], 
      PointBox[240], PointBox[241], PointBox[242], PointBox[243], 
      PointBox[244], PointBox[245], PointBox[246], PointBox[247], 
      PointBox[248], PointBox[249], PointBox[250], PointBox[251], 
      PointBox[252], PointBox[253], PointBox[254], PointBox[255], 
      PointBox[256], PointBox[257], PointBox[258], PointBox[259], 
      PointBox[260], PointBox[261], PointBox[262], PointBox[263], 
      PointBox[264], PointBox[265], PointBox[266], PointBox[267], 
      PointBox[268], PointBox[269], PointBox[270], PointBox[271], 
      PointBox[272], PointBox[273], PointBox[274], PointBox[275], 
      PointBox[276], PointBox[277], PointBox[278], PointBox[279], 
      PointBox[280], PointBox[281], PointBox[282], PointBox[283], 
      PointBox[284], PointBox[285], PointBox[286], PointBox[287], 
      PointBox[288], PointBox[289], PointBox[290], PointBox[291], 
      PointBox[292], PointBox[293], PointBox[294], PointBox[295], 
      PointBox[296], PointBox[297], PointBox[298], PointBox[299], 
      PointBox[300], PointBox[301], PointBox[302], PointBox[303], 
      PointBox[304], PointBox[305], PointBox[306], PointBox[307], 
      PointBox[308], PointBox[309], PointBox[310], PointBox[311], 
      PointBox[312], PointBox[313], PointBox[314], PointBox[315], 
      PointBox[316], PointBox[317], PointBox[318], PointBox[319], 
      PointBox[320], PointBox[321], PointBox[322], PointBox[323], 
      PointBox[324], PointBox[325], PointBox[326], PointBox[327], 
      PointBox[328], PointBox[329], PointBox[330], PointBox[331], 
      PointBox[332], PointBox[333], PointBox[334], PointBox[335], 
      PointBox[336], PointBox[337], PointBox[338], PointBox[339], 
      PointBox[340], PointBox[341], PointBox[342], PointBox[343], 
      PointBox[344], PointBox[345], PointBox[346], PointBox[347], 
      PointBox[348], PointBox[349], PointBox[350], PointBox[351], 
      PointBox[352], PointBox[353], PointBox[354], PointBox[355], 
      PointBox[356], PointBox[357], PointBox[358], PointBox[359], 
      PointBox[360], PointBox[361], PointBox[362], PointBox[363], 
      PointBox[364], PointBox[365], PointBox[366], PointBox[367], 
      PointBox[368], PointBox[369], PointBox[370], PointBox[371], 
      PointBox[372], PointBox[373], PointBox[374], PointBox[375], 
      PointBox[376], PointBox[377], PointBox[378], PointBox[379], 
      PointBox[380], PointBox[381], PointBox[382], PointBox[383], 
      PointBox[384], PointBox[385], PointBox[386], PointBox[387], 
      PointBox[388], PointBox[389], PointBox[390], PointBox[391], 
      PointBox[392], PointBox[393], PointBox[394], PointBox[395], 
      PointBox[396], PointBox[397], PointBox[398], PointBox[399], 
      PointBox[400], PointBox[401], PointBox[402], PointBox[403], 
      PointBox[404], PointBox[405], PointBox[406], PointBox[407], 
      PointBox[408], PointBox[409], PointBox[410], PointBox[411], 
      PointBox[412], PointBox[413], PointBox[414], PointBox[415], 
      PointBox[416], PointBox[417], PointBox[418], PointBox[419], 
      PointBox[420], PointBox[421], PointBox[422], PointBox[423], 
      PointBox[424], PointBox[425], PointBox[426], PointBox[427], 
      PointBox[428], PointBox[429], PointBox[430], PointBox[431], 
      PointBox[432], PointBox[433], PointBox[434], PointBox[435], 
      PointBox[436], PointBox[437], PointBox[438], PointBox[439], 
      PointBox[440], PointBox[441], PointBox[442], PointBox[443], 
      PointBox[444], PointBox[445], PointBox[446], PointBox[447], 
      PointBox[448], PointBox[449], PointBox[450], PointBox[451], 
      PointBox[452], PointBox[453], PointBox[454], PointBox[455], 
      PointBox[456], PointBox[457], PointBox[458], PointBox[459], 
      PointBox[460], PointBox[461], PointBox[462], PointBox[463], 
      PointBox[464], PointBox[465], PointBox[466], PointBox[467], 
      PointBox[468], PointBox[469], PointBox[470], PointBox[471], 
      PointBox[472], PointBox[473], PointBox[474], PointBox[475], 
      PointBox[476], PointBox[477], PointBox[478], PointBox[479], 
      PointBox[480], PointBox[481], PointBox[482], PointBox[483], 
      PointBox[484], PointBox[485]}}],
   Annotation[#, VertexCoordinateRules -> CompressedData["
1:eJx1mGlslVUQhq9FVCKlUGvZKVtZCi1LF9oCvbcYQAKKhRjEpGEtIAYBN2LE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     "]]& ],
  AspectRatio->NCache[Rational[11, 166]^Rational[1, 2], 0.2574200074605],
  FrameTicks->Automatic,
  ImageSize->{523., Automatic},
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{527, 135},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TreeForm=",
 CellID->228031685]
}, Open  ]],

Cell["An asymmetric tree: ", "ExampleText",
 CellID->2295398],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TreeForm", "[", 
  RowBox[{
   RowBox[{"Nest", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", "#", "}"}], ",", "#", ",", "#"}], "}"}], "&"}], ",", "x",
      ",", "5"}], "]"}], ",", 
   RowBox[{"VertexLabeling", "\[Rule]", "Automatic"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->25804409],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{524, 136},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{400, Automatic}},
 CellLabel->"Out[2]//TreeForm=",
 CellID->64136650]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->24729],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["FullForm",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FullForm"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MatrixForm",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MatrixForm"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["TreePlot",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TreePlot"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->1556]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->6838],

Cell[TextData[ButtonBox["Expressions as Trees",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ExpressionsAsTrees"]], "Tutorials",
 CellID->15179]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Expressions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Expressions"]], "MoreAbout",
 CellID->162141690],

Cell[TextData[ButtonBox["Expression Structure",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ExpressionStructure"]], "MoreAbout",
 CellID->488727676],

Cell[TextData[ButtonBox["New in 6.0: Core Language",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60CoreLanguage"]], "MoreAbout",
 CellID->460564604]
}, Open  ]],

Cell["New in 1  |  Last modified in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"TreeForm - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 27, 41.2402062}", "context" -> "System`", 
    "keywords" -> {
     "pointer structure", "tree formatted expression", "tree formatting", 
      "tree structure", "binary tree", "kary tree", "expression tree", 
      "formula tree"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "TreeForm[expr] displays expr as a tree with different levels at \
different depths. TreeForm[expr, n] displays expr as a tree only down to \
level n.", "synonyms" -> {"tree form"}, "title" -> "TreeForm", "type" -> 
    "Symbol", "uri" -> "ref/TreeForm"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[10768, 297, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->63645683]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 519641, 13861}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2207, 52, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2830, 79, 4192, 83, 70, "ObjectNameGrid"],
Cell[7025, 164, 1091, 35, 70, "Usage",
 CellID->17059]
}, Open  ]],
Cell[CellGroupData[{
Cell[8153, 204, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[8631, 221, 643, 21, 70, "Notes",
 CellID->294977217],
Cell[9277, 244, 454, 15, 70, "Notes",
 CellID->158651114],
Cell[9734, 261, 528, 15, 70, "Notes",
 CellID->170992120],
Cell[10265, 278, 466, 14, 70, "Notes",
 CellID->591815289]
}, Closed]],
Cell[CellGroupData[{
Cell[10768, 297, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->63645683],
Cell[CellGroupData[{
Cell[11152, 311, 148, 5, 70, "ExampleSection",
 CellID->298189733],
Cell[11303, 318, 85, 1, 70, "ExampleText",
 CellID->246152652],
Cell[CellGroupData[{
Cell[11413, 323, 191, 6, 28, "Input",
 CellID->18318],
Cell[11607, 331, 6755, 188, 228, "Output",
 CellID->34337635]
}, Open  ]],
Cell[18377, 522, 125, 3, 70, "ExampleDelimiter",
 CellID->596618447],
Cell[18505, 527, 114, 3, 70, "ExampleText",
 CellID->449678417],
Cell[CellGroupData[{
Cell[18644, 534, 250, 8, 70, "Input",
 CellID->348396419],
Cell[18897, 544, 334, 12, 36, "Output",
 CellID->791236011]
}, Open  ]],
Cell[CellGroupData[{
Cell[19268, 561, 126, 4, 70, "Input",
 CellID->34833319],
Cell[19397, 567, 4687, 131, 70, "Output",
 CellID->4722622]
}, Open  ]],
Cell[24099, 701, 124, 3, 70, "ExampleDelimiter",
 CellID->76161427],
Cell[24226, 706, 85, 1, 70, "ExampleText",
 CellID->55864031],
Cell[CellGroupData[{
Cell[24336, 711, 401, 10, 70, "Input",
 CellID->309106279],
Cell[24740, 723, 25968, 714, 70, "Output",
 CellID->6104705]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[50757, 1443, 215, 7, 70, "ExampleSection",
 CellID->6094],
Cell[50975, 1452, 105, 2, 70, "ExampleText",
 CellID->227887539],
Cell[CellGroupData[{
Cell[51105, 1458, 192, 5, 70, "Input",
 CellID->342831352],
Cell[51300, 1465, 4195, 112, 70, "Output",
 CellID->216174536]
}, Open  ]],
Cell[55510, 1580, 123, 3, 70, "ExampleDelimiter",
 CellID->3145603],
Cell[55636, 1585, 113, 3, 70, "ExampleText",
 CellID->82299928],
Cell[CellGroupData[{
Cell[55774, 1592, 234, 8, 70, "Input",
 CellID->14993916],
Cell[56011, 1602, 7046, 189, 70, "Output",
 CellID->48913076]
}, Open  ]],
Cell[63072, 1794, 123, 3, 70, "ExampleDelimiter",
 CellID->2201895],
Cell[63198, 1799, 57, 1, 70, "ExampleText",
 CellID->593202285],
Cell[CellGroupData[{
Cell[63280, 1804, 228, 8, 70, "Input",
 CellID->21186447],
Cell[63511, 1814, 4313, 118, 70, "Output",
 CellID->714191534]
}, Open  ]],
Cell[67839, 1935, 124, 3, 70, "ExampleDelimiter",
 CellID->20790714],
Cell[67966, 1940, 89, 1, 70, "ExampleText",
 CellID->61289366],
Cell[CellGroupData[{
Cell[68080, 1945, 173, 6, 70, "Input",
 CellID->134713058],
Cell[68256, 1953, 5436, 150, 70, "Output",
 CellID->212210570]
}, Open  ]],
Cell[73707, 2106, 125, 3, 70, "ExampleDelimiter",
 CellID->627944843],
Cell[73835, 2111, 235, 8, 70, "ExampleText",
 CellID->221149005],
Cell[CellGroupData[{
Cell[74095, 2123, 184, 6, 70, "Input",
 CellID->139891573],
Cell[74282, 2131, 4089, 112, 70, "Output",
 CellID->574734006]
}, Open  ]],
Cell[78386, 2246, 125, 3, 70, "ExampleDelimiter",
 CellID->133086798],
Cell[78514, 2251, 59, 1, 70, "ExampleText",
 CellID->46047206],
Cell[CellGroupData[{
Cell[78598, 2256, 372, 10, 70, "Input",
 CellID->519156385],
Cell[78973, 2268, 25957, 713, 70, "Output",
 CellID->1740707707]
}, Open  ]],
Cell[104945, 2984, 124, 3, 70, "ExampleDelimiter",
 CellID->30596643],
Cell[105072, 2989, 191, 8, 70, "ExampleText",
 CellID->24278613],
Cell[CellGroupData[{
Cell[105288, 3001, 243, 8, 70, "Input",
 CellID->19030637],
Cell[105534, 3011, 587, 20, 54, "Output",
 CellID->115608706]
}, Open  ]],
Cell[CellGroupData[{
Cell[106158, 3036, 106, 3, 70, "Input",
 CellID->455863823],
Cell[106267, 3041, 8627, 238, 70, "Output",
 CellID->119415989]
}, Open  ]],
Cell[114909, 3282, 125, 3, 70, "ExampleDelimiter",
 CellID->670925301],
Cell[115037, 3287, 202, 8, 70, "ExampleText",
 CellID->404704945],
Cell[CellGroupData[{
Cell[115264, 3299, 170, 5, 70, "Input",
 CellID->1206989350],
Cell[115437, 3306, 3823, 109, 70, "Output",
 CellID->306758386]
}, Open  ]],
Cell[119275, 3418, 126, 3, 70, "ExampleDelimiter",
 CellID->1273915790],
Cell[119404, 3423, 67, 1, 70, "ExampleText",
 CellID->1702247929],
Cell[CellGroupData[{
Cell[119496, 3428, 371, 13, 70, "Input",
 CellID->553374777],
Cell[119870, 3443, 14905, 403, 70, "Output",
 CellID->327519934]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[134824, 3852, 222, 7, 70, "ExampleSection",
 CellID->463608210],
Cell[CellGroupData[{
Cell[135071, 3863, 232, 7, 70, "ExampleSubsection",
 CellID->900310349],
Cell[135306, 3872, 128, 3, 70, "ExampleText",
 CellID->1707013097],
Cell[CellGroupData[{
Cell[135459, 3879, 257, 9, 70, "Input",
 CellID->2111380344],
Cell[135719, 3890, 9919, 273, 70, "Output",
 CellID->917531985]
}, Open  ]],
Cell[145653, 4166, 125, 3, 70, "ExampleDelimiter",
 CellID->870893505],
Cell[145781, 4171, 68, 1, 70, "ExampleText",
 CellID->1940558099],
Cell[CellGroupData[{
Cell[145874, 4176, 327, 11, 70, "Input",
 CellID->1531262091],
Cell[146204, 4189, 9844, 272, 70, "Output",
 CellID->160490410]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[156097, 4467, 234, 7, 70, "ExampleSubsection",
 CellID->203839123],
Cell[156334, 4476, 72, 1, 70, "ExampleText",
 CellID->2036916947],
Cell[CellGroupData[{
Cell[156431, 4481, 415, 14, 70, "Input",
 CellID->1851389954],
Cell[156849, 4497, 6328, 172, 70, "Output",
 CellID->1327575552]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[163226, 4675, 241, 7, 70, "ExampleSubsection",
 CellID->65693485],
Cell[163470, 4684, 89, 1, 70, "ExampleText",
 CellID->2122510440],
Cell[CellGroupData[{
Cell[163584, 4689, 468, 16, 70, "Input",
 CellID->1956840094],
Cell[164055, 4707, 8162, 212, 70, "Output",
 CellID->666174138]
}, Open  ]],
Cell[172232, 4922, 124, 3, 70, "ExampleDelimiter",
 CellID->99207776],
Cell[172359, 4927, 61, 1, 70, "ExampleText",
 CellID->26472224],
Cell[CellGroupData[{
Cell[172445, 4932, 300, 9, 70, "Input",
 CellID->1020060192],
Cell[172748, 4943, 6870, 188, 70, "Output",
 CellID->1409638575]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[179667, 5137, 238, 7, 70, "ExampleSubsection",
 CellID->230110335],
Cell[179908, 5146, 106, 2, 70, "ExampleText",
 CellID->1920904431],
Cell[CellGroupData[{
Cell[180039, 5152, 366, 13, 70, "Input",
 CellID->269954683],
Cell[180408, 5167, 25715, 693, 70, "Output",
 CellID->1974903844]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[206172, 5866, 236, 7, 70, "ExampleSubsection",
 CellID->44888674],
Cell[206411, 5875, 234, 8, 70, "ExampleText",
 CellID->1808033363],
Cell[CellGroupData[{
Cell[206670, 5887, 663, 21, 70, "Input",
 CellID->500288768],
Cell[207336, 5910, 32191, 801, 70, "Output",
 CellID->957178633]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[239576, 6717, 230, 7, 70, "ExampleSubsection",
 CellID->179618439],
Cell[239809, 6726, 86, 1, 70, "ExampleText",
 CellID->1676190373],
Cell[CellGroupData[{
Cell[239920, 6731, 610, 18, 70, "Input",
 CellID->14566157],
Cell[240533, 6751, 13565, 359, 70, "Output",
 CellID->1375370506]
}, Open  ]],
Cell[254113, 7113, 125, 3, 70, "ExampleDelimiter",
 CellID->297939305],
Cell[254241, 7118, 383, 12, 70, "ExampleText",
 CellID->580503372],
Cell[CellGroupData[{
Cell[254649, 7134, 618, 19, 70, "Input",
 CellID->317015018],
Cell[255270, 7155, 1134, 27, 232, "Output",
 CellID->1098595773]
}, Open  ]],
Cell[256419, 7185, 125, 3, 70, "ExampleDelimiter",
 CellID->414909817],
Cell[256547, 7190, 378, 12, 70, "ExampleText",
 CellID->88626299],
Cell[CellGroupData[{
Cell[256950, 7206, 587, 18, 70, "Input",
 CellID->238367270],
Cell[257540, 7226, 3749, 100, 70, "Output",
 CellID->2056162112]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[261338, 7332, 235, 7, 70, "ExampleSubsection",
 CellID->199408923],
Cell[261576, 7341, 135, 4, 70, "ExampleText",
 CellID->993647161],
Cell[CellGroupData[{
Cell[261736, 7349, 367, 12, 70, "Input",
 CellID->1186888853],
Cell[262106, 7363, 20704, 526, 70, "Output",
 CellID->1552909169]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[282859, 7895, 243, 7, 70, "ExampleSubsection",
 CellID->82661052],
Cell[283105, 7904, 61, 1, 70, "ExampleText",
 CellID->1148726976],
Cell[CellGroupData[{
Cell[283191, 7909, 304, 9, 70, "Input",
 CellID->1976145425],
Cell[283498, 7920, 1069, 24, 215, "Output",
 CellID->1401787777]
}, Open  ]],
Cell[284582, 7947, 126, 3, 70, "ExampleDelimiter",
 CellID->1647530537],
Cell[284711, 7952, 87, 1, 70, "ExampleText",
 CellID->2039050761],
Cell[284801, 7955, 2466, 43, 70, "Input",
 CellID->876584969],
Cell[CellGroupData[{
Cell[287292, 8002, 472, 16, 70, "Input",
 CellID->280649582],
Cell[287767, 8020, 35871, 592, 70, "Output",
 Evaluatable->False,
 CellID->531430197]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[323687, 8618, 241, 7, 70, "ExampleSubsection",
 CellID->74973014],
Cell[323931, 8627, 85, 1, 70, "ExampleText",
 CellID->49039736],
Cell[CellGroupData[{
Cell[324041, 8632, 761, 25, 70, "Input",
 CellID->930075907],
Cell[324805, 8659, 4969, 143, 70, "Output",
 CellID->344804231]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[329835, 8809, 232, 7, 70, "ExampleSection",
 CellID->2379],
Cell[330070, 8818, 338, 12, 70, "ExampleText",
 CellID->1969492],
Cell[CellGroupData[{
Cell[330433, 8834, 226, 8, 70, "Input",
 CellID->609632377],
Cell[330662, 8844, 560, 20, 50, "Output",
 CellID->155527542]
}, Open  ]],
Cell[CellGroupData[{
Cell[331259, 8869, 224, 8, 70, "Input",
 CellID->1232133],
Cell[331486, 8879, 6235, 167, 70, "Output",
 CellID->568837046]
}, Open  ]],
Cell[337736, 9049, 354, 12, 70, "ExampleText",
 CellID->1542255578],
Cell[CellGroupData[{
Cell[338115, 9065, 264, 9, 70, "Input",
 CellID->458044859],
Cell[338382, 9076, 313, 11, 75, "Output",
 CellID->397945025]
}, Open  ]],
Cell[338710, 9090, 126, 3, 70, "ExampleDelimiter",
 CellID->1927757794],
Cell[338839, 9095, 209, 8, 70, "ExampleText",
 CellID->1065632896],
Cell[CellGroupData[{
Cell[339073, 9107, 370, 12, 70, "Input",
 CellID->672786244],
Cell[339446, 9121, 10605, 290, 70, "Output",
 CellID->1253958722]
}, Open  ]],
Cell[350066, 9414, 126, 3, 70, "ExampleDelimiter",
 CellID->1193968090],
Cell[350195, 9419, 353, 13, 70, "ExampleText",
 CellID->766867356],
Cell[CellGroupData[{
Cell[350573, 9436, 346, 11, 70, "Input",
 CellID->1096912348],
Cell[350922, 9449, 28062, 810, 70, "Output",
 CellID->2103169330]
}, Open  ]],
Cell[CellGroupData[{
Cell[379021, 10264, 347, 11, 70, "Input",
 CellID->292597679],
Cell[379371, 10277, 30769, 848, 70, "Output",
 CellID->1648639604]
}, Open  ]],
Cell[410155, 11128, 126, 3, 70, "ExampleDelimiter",
 CellID->1473633882],
Cell[410284, 11133, 253, 8, 70, "ExampleText",
 CellID->1849880658],
Cell[CellGroupData[{
Cell[410562, 11145, 350, 11, 70, "Input",
 CellID->331224011],
Cell[410915, 11158, 11617, 327, 70, "Output",
 CellID->828182580]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[422581, 11491, 226, 7, 70, "ExampleSection",
 CellID->18590],
Cell[422810, 11500, 85, 1, 70, "ExampleText",
 CellID->1771660961],
Cell[CellGroupData[{
Cell[422920, 11505, 161, 5, 70, "Input",
 CellID->927617488],
Cell[423084, 11512, 1768, 51, 70, "Output",
 CellID->900665285]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[424901, 11569, 224, 7, 70, "ExampleSection",
 CellID->22881],
Cell[425128, 11578, 67, 1, 70, "ExampleText",
 CellID->1805632442],
Cell[CellGroupData[{
Cell[425220, 11583, 205, 8, 70, "Input",
 CellID->57391352],
Cell[425428, 11593, 830, 18, 70, "Output",
 Evaluatable->False,
 CellID->214913544]
}, Open  ]],
Cell[CellGroupData[{
Cell[426295, 11616, 104, 3, 70, "Input",
 CellID->184812927],
Cell[426402, 11621, 25633, 691, 70, "Output",
 CellID->1951118709]
}, Open  ]],
Cell[452050, 12315, 66, 1, 70, "ExampleText",
 CellID->2025128386],
Cell[CellGroupData[{
Cell[452141, 12320, 216, 8, 70, "Input",
 CellID->412473837],
Cell[452360, 12330, 927, 19, 70, "Output",
 Evaluatable->False,
 CellID->200916461]
}, Open  ]],
Cell[CellGroupData[{
Cell[453324, 12354, 104, 3, 70, "Input",
 CellID->201732629],
Cell[453431, 12359, 31851, 842, 70, "Output",
 CellID->435251197]
}, Open  ]],
Cell[485297, 13204, 125, 3, 70, "ExampleDelimiter",
 CellID->520908183],
Cell[485425, 13209, 60, 1, 70, "ExampleText",
 CellID->63865595],
Cell[CellGroupData[{
Cell[485510, 13214, 365, 12, 70, "Input",
 CellID->10108729],
Cell[485878, 13228, 15022, 242, 170, "Output",
 CellID->228031685]
}, Open  ]],
Cell[500915, 13473, 61, 1, 70, "ExampleText",
 CellID->2295398],
Cell[CellGroupData[{
Cell[501001, 13478, 365, 12, 70, "Input",
 CellID->25804409],
Cell[501369, 13492, 14592, 243, 70, "Output",
 Evaluatable->False,
 CellID->64136650]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[516022, 13742, 311, 9, 70, "SeeAlsoSection",
 CellID->24729],
Cell[516336, 13753, 699, 26, 70, "SeeAlso",
 CellID->1556]
}, Open  ]],
Cell[CellGroupData[{
Cell[517072, 13784, 313, 9, 70, "TutorialsSection",
 CellID->6838],
Cell[517388, 13795, 149, 3, 70, "Tutorials",
 CellID->15179]
}, Open  ]],
Cell[CellGroupData[{
Cell[517574, 13803, 299, 8, 70, "MoreAboutSection"],
Cell[517876, 13813, 134, 3, 70, "MoreAbout",
 CellID->162141690],
Cell[518013, 13818, 151, 3, 70, "MoreAbout",
 CellID->488727676],
Cell[518167, 13823, 156, 3, 70, "MoreAbout",
 CellID->460564604]
}, Open  ]],
Cell[518338, 13829, 50, 0, 70, "History"],
Cell[518391, 13831, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

