(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    202297,       4173]
NotebookOptionsPosition[    194568,       3902]
NotebookOutlinePosition[    196061,       3942]
CellTagsIndexPosition[    195974,       3937]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Continuous Distributions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ContinuousDistributions"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Continuous Distributions\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"UniformDistribution" :> 
          Documentation`HelpLookup["paclet:ref/UniformDistribution"], 
          "Piecewise" :> Documentation`HelpLookup["paclet:ref/Piecewise"]}, #,
          2]& , Evaluator -> Automatic], {1->"\<\"UniformDistribution\"\>", 
       2->"\<\"Piecewise\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Continuous Statistical Distributions" :> 
          Documentation`HelpLookup[
           "paclet:guide/ContinuousStatisticalDistributions"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Continuous Statistical Distributions\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["TriangularDistribution", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["TriangularDistribution",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/TriangularDistribution"], "[", 
       RowBox[{"{", 
        RowBox[{
         StyleBox["min", "TI"], ",", " ", 
         StyleBox["max", "TI"]}], "}"}], "]"}]], "InlineFormula"],
     " \[LineSeparator]represents a symmetric triangular statistical \
distribution giving values between ",
     Cell[BoxData[
      StyleBox["min", "TI"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      StyleBox["max", "TI"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["TriangularDistribution",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/TriangularDistribution"], "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          StyleBox["min", "TI"], ",", " ", 
          StyleBox["max", "TI"]}], "}"}], ",", " ", 
        StyleBox["c", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]represents a triangular distribution with a maximum at \
",
     Cell[BoxData[
      StyleBox["c", "TI"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->32702]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The mean of a pair of uniformly distributed random variables follows a \
symmetric triangular distribution.",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->24312904,
  ButtonNote->"24312904"]
}], "Notes",
 CellID->10684],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TriangularDistribution",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TriangularDistribution"]], "InlineFormula"],
 " allows ",
 Cell[BoxData[
  StyleBox["min", "TI"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  StyleBox["max", "TI"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  StyleBox["c", "TI"]], "InlineFormula"],
 " to be any real numbers such that ",
 Cell[BoxData[
  RowBox[{
   StyleBox["min", "TI"], "<", 
   StyleBox["c", "TI"], "<", 
   StyleBox["max", "TI"]}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->26584],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TriangularDistribution",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TriangularDistribution"]], "InlineFormula"],
 " can be used with such functions as ",
 Cell[BoxData[
  ButtonBox["Mean",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Mean"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["CDF",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CDF"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["RandomReal",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RandomReal"]], "InlineFormula"],
 ".",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->20877,
  ButtonNote->"20877"]
}], "Notes",
 CellID->33143606]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->152860529],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->46254135],

Cell["\<\
The mean and variance of a symmetric triangular distribution:\
\>", "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->20877],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Mean", "[", 
  RowBox[{"TriangularDistribution", "[", 
   RowBox[{"{", 
    RowBox[{"min", ",", "max"}], "}"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1014],

Cell[BoxData[
 FractionBox[
  RowBox[{"max", "+", "min"}], "2"]], "Output",
 ImageSize->{63, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->274727383]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Variance", "[", 
  RowBox[{"TriangularDistribution", "[", 
   RowBox[{"{", 
    RowBox[{"min", ",", "max"}], "}"}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->484],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "24"], " ", 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{"max", "-", "min"}], ")"}], "2"]}]], "Output",
 ImageSize->{100, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->48082914]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->11495],

Cell["Probability density function:", "ExampleText",
 CellID->26811],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PDF", "[", 
  RowBox[{
   RowBox[{"TriangularDistribution", "[", 
    RowBox[{"{", 
     RowBox[{"min", ",", "max"}], "}"}], "]"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1293],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzFWMFu00AQdWwnbipECyqlIGgLp4KqCITgAFQqApUL7REJEKqiCqkVQkSh
gnCAcOCeYz4hx1zhUj6hn9HPMN71Tjx5O443atJair0zuzPzZnZndyfb9cP9
D5/qhwd79dWXzXpj/2Dvy+rW52bCCkqe5x0lv4dLXtKOk5b+HcVx8p1X70DR
+vHuAv1Tj5oD7lWgLwP9Q0sF6h22Wq1/+jk5OYlgnKYrKc3fYfLxygMybXi+
+s4OWCCTvpXy1HD6aJkyyBiv9LCg3W6bjhlA5xOSSDSlhyodPtjUGCq2jIzl
NAgjJjt4m7hzjT5xqyOiNxa+mon1tjNOHiWKrk/6M7Q2h2TDgSyTDKmDWVsH
WsZYlaSGrKpOzIdXoq5ZGHUL6ArQPtBuVjZg1Bqjvdy5QKk7Traegu7vTrq3
gKbsoLlWKV0238jwI9YfiFZ+m95oeIaSBsZdrwQrH0as6yFtoWg93bOS/ctk
9yO9jjc3N03/AvTf1v0JDTGYNd8q98YRK+koj4zPDNNMluTdISzUuQSRvQ70
/YL+0IouRzfpOcLz6AbQK+o1/XOGWbwYD6983G0C0MF5PsjKWTFvRgeg2R/L
14oVYdS3nKNvgqcfs/ZY9PWS5KODzxwjnRYUVTw1lhm+4WyZ8Fla6O1cnGWo
5aUjQso2ycvpncQbuf7wswQxkX03TMUrVr47zcdsvxuxVzwB+pmoDVck+oT7
4S9Ryx/NTVdFt9vt9Xqq+Zdxs7Gc22g0Op1OxpX1unHRE7yLfMuN5jgVwVdR
C9YV51UPyD4iuvOsB3aNL1fc43gudcEuIHHHe3b1gWq+A96CiBNX+bro83sn
XZhnRTUC7mpvGO3lroQXIPXWCdtz0N100q3uOJG01ssZnWWGmgW6+0s1wT3R
5msW8QyfdILY84J3LvtOivVDTcRQMQhTfn4lcOEUWCkD6NyuMnpUdVGaeNRo
fqheIWQPREuroBPPvUVnJINcZ3zCYld+FCe0J6/vFRiFZ76Swtu4H+ffcXHd
YJ2LK0/n9pnWH74Yh6V4vJqhyIqdUah5Z4TmyVcPstfXpFGF9+pii4Q3r6K4
CXRNtDPdCkOOiLqtuVcYbpYoVzEKO/E0z3b270XY7/fb+jk+Pl6EecqtOXI1
23sORiu901JFVVRXfARa7xHWzoQ48R9zvJG0tJb0v3yv9B8We0JR\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{190, 53},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->143306833]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"PDF", "[", 
    RowBox[{
     RowBox[{"TriangularDistribution", "[", 
      RowBox[{"{", 
       RowBox[{"0", ",", "1"}], "}"}], "]"}], ",", "x"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->6798],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzNWmtsFUUUXnr7oPIsAra8WqQFKVQoCCjIU2iBgoKlAmKBUquthodQNEqM
EqNolPioRNQoGiUG0QgSISg+SVQSAwmRxCiJqYnBHxITiT9ITNYzZ2buzH57
ul4KGG/S2zm78505851vzsxuu7ChtblpbUNrS2NDSfXGhg3NLY2bSqrWb6RL
qS5BELTTT1thQO2QWvzTHob0O/49jr6zqENKWSnVU10NuDnEv5ej7+lPgHdT
6btB1r/cK6aGupQl3OP+QaX6znZ3giAHohsc65EL3gbGemTHrgzKoE8x+E3F
emR1EDNGJI+WnWEclzfWvMzYS8xAJjGrPKo8l1zGSO0YcoSpDGPvPJdxX/Hx
Oo4xB8a9lHm3az3X/C42v5HTQd51G6WEs7ZetX5V6Q0ejydc7U7fJ9Ne0n22
PnpENTG2y213/Y/Hu9S2rjpnzvxJl86e/UvbjtWXdx7b/faJix5l+P9s1mgX
sX3+/N/r1x0IrMI1C2ZdbHno8NGvfi4F3M1gl4E9jG2S5qdHTqfH1X7N/nju
3PmW5n3t7X8EX3Lfve+ebHvh69AqS/fNTXukjtSdQJ9z72Pf/rK59aBq5ku9
6UNBU+if2Sw3rnmPwMEV6d5u16U8U7ZV8xO2XWTdopowc9MozYtqfgx2EoqY
Jt8//fh7cFjFsOv173qIvbMh7kNs6zmppozSNfHE8V8pm6r5Eds0E/JCIwc9
RVQu8H/AskAotT56RTjrCpn9kG1KBqVENXuJY+TB7PezTQPSsKrZW0R1BRY+
YJsGNjWvQETlWxYoKDXr99k+9f1vxIqy+4goVkZq/75T2585qpp72abKQBEr
Fq4UUZzrFEEIqJp77DxpbIog6Bvhrjvc3QPovuIY3SEf70Ck/UQUKyRFXFP8
ata7gYX+Iqon6OwtmwHyoqrkVSKKc57SJVM137TzpLFoxKBQRPUG5bzB9rYn
vjh08AfVdCjFXYFlwazNXaDaInGMArsCdPEIXoMVMkBE9QEWXgUdDhRRSiFq
Rb8CWueTid22+YPPEFnCeYa14FWVnWF03RmviWc+fHLoCxy+BBwO7oTPfsDw
DmB4SIY+ldkfeG8D3osFX/aEiPyxUr3a/rzNCvlScy/pwFe8Cju7EHLyHNgl
sUzbk6HsyWnkWYh2qKiwIuBjO/B1tYgaYDNi6uHTkLFhaZSKdBBo4imrGVN9
SsUxNMqt3SfZJgnQsKqZhHJ1YhvbblcoE1GsUlWZKSJVkx5n29XD4SKKdejV
v8fAHiGiisH3Vhj7mgh3QyH+R2B+I8UxSmwvsytolNsVZNRQG4nZnx6GSMtF
FCvE2xW2gDZGiSh9mnP77oNWh2ZXGC2i9JnR7QoPgOYrItzpk7LbDe4Po2ur
QhyjzKrTVLTNYXQdXSuihsMK2BRG19EYETUCet0HXsaKKKUQtStsgEgrxd4j
YdbrwHYoxVm59WnW5loz1njRdznEey/MR0axIrzzdov1Ys6U14mo0ZCHuyHS
CYzSZdF+pPdcWJFZBd4u2GQ1ZdbORHaInuLP+ViPK6wfs1K1X7eSO+uX9eet
lMYwukonXYBf1YGV6VWtBrCv72ScYyGuVWEYqXM3dNIv69WrZfXA82QN83ZM
+64EM18Jma4Hz5NFHY6z8zBVcgXMc4qIGg+sLgf7xjRKRcpaTtHGR9ufai4F
7qaKY0wAhdUBM9MSUK5XHbAgoyYCC7XAwnQRNQlmvZhtt1fMEFGsQG+vuCWM
roCZEe4mAwsL7fzMHjFLHEOj3F6xgG1XJZNQrgLXhLpazhZ7szK8ajmPbVct
ZRQrw6uW1eBljohihXhnrjk2UlMtqyKccba8Gjgb2KgSx5gGyrkJmK8WUdOl
7HnZnSuiZlilmGcA7cWdOuaJqJnAwlRgYb6ImgVs6Ay4k2cSyulsCrBRE2F8
NrDA1dBb8QvEMTTKrR9cTwtF1BzwrVe8qyb85i1h52RbqJ9VMMPxoAdep7EK
j3+bwfvVwLaut+454GK8usxXgjIWZexVmXNBfWOsOk0dWyx6yw7lfUjXAbcC
KkAbt3boLcmeD9kZBdmp1ZnN4MmyBjJSDhmpFVVXA4yPBMaXiChdd91ZcAQw
W5dGqUj1O2NXQcuAudvEMRRKVelSy4hZsUvF3nq3cTuBft5x1SEJ5d4N6Gcr
d3pdJqIW2fj9txPe/JaLKL2Luh1isOXQ7BC3RzirhTwMhDytEMeohVkPAE0k
oZzmikCTd4ioJZBF/d7F1a96EVUHStFvkVxtXCmiWCHeuYXfyXq1cZWI0ucx
d0YqgHmujjC+DO4WAHq1OMYyG4k5YfWCSBtEFJ4re4C9RkSxQrwK1A1YaBRR
KyCb+TDPOxNQ7tSdD2w4lOKuHtSZB+ptEsfQKFef03/FMNq4S0StBBZSoEN+
4uSHk0yeK1k5eel3FfRxlaaZPdkd1zMSn3xYJznpSqQXo3567sRzFHvL1mfX
HS9+Q4Hewx1j/zcielId9JPi6dNnWzfxn4UuBO/3OG4ux/pkgsrgOU/3jP//
TdDlHx8RjZI=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{225, 147},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->145453398]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->26101],

Cell["\<\
Generate a set of random numbers that are triangularly distributed:\
\>", "ExampleText",
 CellID->8493],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RandomReal", "[", 
  RowBox[{
   RowBox[{"TriangularDistribution", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "1"}], "}"}], ",", ".8"}], "]"}], ",", "5"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->29074],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.29000674067598814`", ",", "0.24271727931211615`", ",", 
   "0.6068025865070076`", ",", "0.6547052137589381`", ",", 
   "0.7019256068882465`"}], "}"}]], "Output",
 ImageSize->{343, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->449969001]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->13774],

Cell["Properties based on higher-order moments:", "ExampleText",
 CellID->20699375],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Skewness", "[", 
  RowBox[{"TriangularDistribution", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"min", ",", "max"}], "}"}], ",", "c"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->9314],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    SqrtBox["2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"2", " ", 
       SuperscriptBox["c", "3"]}], "-", 
      RowBox[{"3", " ", 
       SuperscriptBox["c", "2"], " ", "max"}], "-", 
      RowBox[{"3", " ", "c", " ", 
       SuperscriptBox["max", "2"]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["max", "3"]}], "-", 
      RowBox[{"3", " ", 
       SuperscriptBox["c", "2"], " ", "min"}], "+", 
      RowBox[{"12", " ", "c", " ", "max", " ", "min"}], "-", 
      RowBox[{"3", " ", 
       SuperscriptBox["max", "2"], " ", "min"}], "-", 
      RowBox[{"3", " ", "c", " ", 
       SuperscriptBox["min", "2"]}], "-", 
      RowBox[{"3", " ", "max", " ", 
       SuperscriptBox["min", "2"]}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["min", "3"]}]}], ")"}]}], ")"}], "/", 
  RowBox[{"(", 
   RowBox[{"5", " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["c", "2"], "-", 
       RowBox[{"c", " ", "max"}], "+", 
       SuperscriptBox["max", "2"], "-", 
       RowBox[{"c", " ", "min"}], "-", 
       RowBox[{"max", " ", "min"}], "+", 
       SuperscriptBox["min", "2"]}], ")"}], 
     RowBox[{"3", "/", "2"}]]}], ")"}]}]], "Output",
 ImageSize->{453, 63},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->350571618]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Kurtosis", "[", 
  RowBox[{"TriangularDistribution", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"min", ",", "max"}], "}"}], ",", "c"}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->29218],

Cell[BoxData[
 FractionBox["12", "5"]], "Output",
 ImageSize->{23, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->123808490]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->16833],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  StyleBox["q", "TI"]], "InlineFormula"],
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
 " quantile of a triangular distribution:"
}], "ExampleText",
 CellID->15238],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Quantile", "[", 
  RowBox[{
   RowBox[{"TriangularDistribution", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"min", ",", "max"}], "}"}], ",", "c"}], "]"}], ",", "q"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->19911],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWjtvE0EQPt/DjgMikBdGSMgSQkGKAJGAAIXwflRIqaliRUhJgbBCJNy5
TAFSSGWJxmXKlCkoaJBS5iekTJky5bGzj7v13NzLvrONYkvZu5mdnZndmd3b
+ZQPta31T59rWxtrter7zVp9fWPta/Xdl03GsgqGUfhpGMZixWDvLnvjf/Db
ZX/i1X97Dm+WknCNx4ie5pIWtHaj0fjDfycnJ9A5B9yikNVbmz0MxyPFi2HC
c9xjoTGiBcPCmPiZyJuZvls0/flbzWZTcqG5qeyWSMVcCYwzkQVusRgcwy05
yNuAP5cHYjV8FW5r471W5ouu1VTcckQ8EnozMwCb0Sugr7aSNpUW36cgR421
vbHaSBCr5KrdCZ3Vd7LnEVqV+4i+gOhnMf033M4dCG1F8p4gWXwylUkP5zl9
cHBwdnYGr2No1CKlRaNfxPRXXSpbriGpJukbrHZJrr56QjQmudzKysr+/j68
lohVAxLPxQ7RZyM5rG8sZByWU/oD54jj052nTpTVcdY46hDS+EDbhNdTrpaj
Gv8Voh+Qa13U4pRor3fsI4iIyaIR0IjmE9SFZ+305AeeO9Ze7kk7zifaVxwX
Wntczl1ENF5NJ5HWSVIKdEH+Zp8Z6ksKs3G86K6urrIn0xhYQVPKUXvBUfFM
aRuvFF5ZZdPsQne0X9lE3tRtoNMF2w7XSkd+TFsjf93ZDVWeTXN8soyWQyxX
P4PC5Qpu8swBKVtbU+Hp0dGROM3Zp+jw8JA8DaO+M3REsK243KDPB6wlme3z
fA4Ez84rXM7Txm4b29vbdJTP6TfCu6HinOk1O3R9YbmBZLq7Q8AofDu1JE+f
ITwv8c5Wq8WKZH5xIHThO50txyW1keRel8ZfLGtKHlU/xmUZjtwEoQN/FacI
mXnpwwIPP8ozN75enyAjyatU6/T0VOUEp9vt9vHxsUvkWa9VAq5zZhH9BtF8
tmn2aOyM73CaTY+lJBWvuMptIeUMyzKWVxH/be4zvctptu0kDY3auQtuXAU8
GaGTneiyigTmxwhJ9oWXtRswXyK/Z8mR9zjNqr4m/xl/obFEQkLXLjkKGro2
93vEurHA7+3tqZ4fWk/nGL2nXq/v7Ox09nTjAdUTV89Ph47ku3eEM45wxhHO
qK22kh7hjEGcEe7dQC67w4Ql4ppvGdFN0guFGiZD4fBNRvjcPbaYDfbXH8RR
IYlPXT/rYMPhOKSpB5NVvXgeQOeJH2ZTiw8vekijAEskF+86fBZkH22VV/mg
gdmibsOCCqaJaAn5MQhUr7t9L3Tlg/3luef7iQimyQRH+vMa6eh1T1PYFEY4
hLY8Eb6sULNhRvgoxG6J4Kk9j2vn5MhcFHrFkYOM0LleULJ+InRFQmaJ4OH4
V93/EYH7hujscaYJJHWd0+EI262YGaRF3Bq5z3AASJrNdqPAv9hHU2CWSbC0
h5zrY2e/OHYmoCvo+s2l4BX/z5tR+AdXNlEb\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{400, 51},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->27777078]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->6784],

Cell["\<\
Plot the cumulative distribution function of the random variable:\
\>", "ExampleText",
 CellID->19271],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"CDF", "[", 
    RowBox[{
     RowBox[{"TriangularDistribution", "[", 
      RowBox[{"{", 
       RowBox[{"0", ",", "1"}], "}"}], "]"}], ",", "x"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{
      RowBox[{"-", "1"}], "/", "2"}], ",", 
     RowBox[{"3", "/", "2"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->12368],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{225, 150},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->197239064]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->15258],

Cell[TextData[{
 "A contour plot as both ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  StyleBox["max", "TI"]], "InlineFormula"],
 " are varied:"
}], "ExampleText",
 CellID->4157],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContourPlot", "[", 
  RowBox[{
   RowBox[{"CDF", "[", 
    RowBox[{
     RowBox[{"TriangularDistribution", "[", 
      RowBox[{"{", 
       RowBox[{"0", ",", "max"}], "}"}], "]"}], ",", "x"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"max", ",", 
     RowBox[{"1", "/", "10"}], ",", "5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->9647],

Cell[BoxData[
 GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJx0fQVUVtn3Nt3SBnZit6Nj7mO3Y3fP2GP32F04dncxdostqICgqLSUSjdI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   "], {{{}, 
     {RGBColor[0.33397672886243995`, 0.1279285534584573, 0.5864250111696041], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmG1wldURx597E+597qXel+S5tBVDS62KFYtQJFqc2LG0BWbkJXxoLO8K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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlmlslVUQhk9L6b29H7e3LfeisglCkFUSRRZFUcAEMAjCD0FlFYwKtAiU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         "],
         VertexColors->None]}]}, 
     {RGBColor[0.4150981865873199, 0.26897686037537194`, 0.7004510335088123], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJw1mH+wVVUVxw/v3nsuWL1zf5w7jvIYeYiDODXZ00bjCU1qT34J6Ng0TMJT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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlnmwzmUUx3/vfRdL5fd73/f3JsXExFimIsswVDOVlLGbmpiRyyXakG0o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         "],
         VertexColors->None], 
        PolygonBox[{{5181, 5546, 2374, 5549, 5180}, {4425, 4261, 4260, 4426, 
         892}, {4982, 4980, 464, 3988, 4981}, {4379, 4427, 892, 3992, 4378}, {
         4759, 5320, 5319, 4011, 483}, {5548, 4982, 4981, 4979, 2374}, {4261, 
         4592, 1025, 4593, 4260}},
         VertexColors->None]}]}, 
     {RGBColor[0.4962196443121998, 0.4100251672922865, 0.8144770558480204], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFWHtwFtUV3y/f7rcGJLvf7n4lkUJBjLRJikDRqC0ob1EDPkDBTimJvGaC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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtl3uwTXUUx/d51i3uPmfvc6KkxEi5KvSQDJpLb480CDMpQjU9vKZCzQhh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         "],
         VertexColors->None], 
        PolygonBox[{{4374, 4159, 1011, 4575, 4373}, {4275, 4900, 1302, 4010, 
         4274}, {4160, 4374, 4373, 4578, 1012}, {5547, 5589, 1381, 5548, 
         5546}, {5474, 3990, 3989, 4980, 1381}},
         VertexColors->None]}]}, 
     {RGBColor[0.5737613661287864, 0.5435370519035629, 0.9097253540741592], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmHuwV1UVx8/9vZCke37nnHsuFA+lkuIZlzCgTBQs0Sk0EDBmMLgkYhkO
XJABQSeBAVEslbmozCDXicc4KheuzZhZBAVSoryMePSgKMVBUhMCFKjPl++e
6Y99z/6tvfZaa6/13Wutfbs33j1qWiGKoiU1UVTkeyV/ppaj6LMQe1aiaGgp
ih6G3jePoj6MDu2iaAo8ixlb2TMZ2r4kiu7j91rmP2R+OfwL4ij6TmKexzNk
V6PoR8i9lO/wNIpGIP/LfAcxBjI/De9YRsca80nvKubNdVH0K3jW87sBmZMS
27qK+dzcdvyM78vQ32S+E76TyOvMaEbODfxeD/8y+L8Gz6yidYu+Ejs/hfzp
2PQRvBegVxkPwX8c2t5azgPPK+i/kTOsY88adK1jDGsfRZexdyZ8EX7qUI9t
0I/jn1l832AsgH8P++bAtxn5c7FhPL8nYMM9yJzNaEVXgs6J7PuI+WF0vl9r
2xqhTWr3/3XNG+BpKfq35juQew96LoHnMOf7E+PfrHdDT2dGwvqb6OmB7ldK
liG58ufz0CfB8xTzBZyhhnEO/lPo74mcI9hwgvPN4SxXIXN/ybFSXNYXfQ7p
bWBPlXEa+hPIGK+YML+TtXFFn3Eqe28uOBa7kPkcut9hvo19vUvGW3v8dA7d
b0fmHc3e5+HpgC2T6yxXcRsR5BzC9oOsTWQ+HtqokvlbOOunWYuRfYj55Mxx
/TXfLYwXoP+yZJr2nsKepzLjXBg6yBleYv5H9n4X+icL9lFtwfjcDO0K9twR
zid5msu/zUXzbULGbMbL0G4DK4f4TmZUwMmp3DFaxZmuZ74QvjmcI2LeC/lX
s3Zf2b5WvCYGDDyC3qdzrykW8wNPZ+R0rXPsPoOcV/HtHcgoYeNy9jwA/Ul0
bCw7LrpboimOP4Gnd+47o/UjFcdtrPyWmkd6ZJN0CQcNBd+LVnjbGO/DMzi3
v+SrzcxnoLeRfSuxZz/zmTX2h/winu0lx15xn4Dt/yTugyrGkLAkP0xk30ux
fSr6lrLvZg++G4Ne0bYG+uiSMaDYjcP2XpytCflfZf5Y5nMr33xY9VluyIwh
YeAMegakPptiuy1xTO+KfVeF4Snw3s4Yhb4r2/ks8kF7YrpL9/0Schrrr9fZ
vhrlxsw2LsrNJ55t0H6b2d/y59bg03p0XoPuh5i38W1lJKzthd6H+bGiMbu7
ZJuHYNsxbNsV7m/fdr7DiqXy4APw3MX6B7W+fwsDzy8CPnUGxWKDzsdYCc8R
vn9LzaO8JjnKpe+hf2lmHBxl/R+p6cptuzPnN2GuFf52Bft+Z2L/X8f68Mx5
YgV3obm9+f4Oz8LcNWdmwdjcp3sH719SY0T5fkDsnK/7cyjk7TegbYOnzL69
zM+n1qscLX8oN25D9k8z72lj/mLuu3gr/P+C/4DwwPqm1Fjqin1LS85Ll6O3
PnOtu7Te8VPslJdGFp1/ziLn3apjp3x5stY589vIuzk1HhWrdSFevZBfWzaP
vnGYVwNdmO+PvG8ia17B/tSZVEO7s74EOSdqnKveS52vVLe2h/w5Bdrtqf3U
jJzXal3T9PtAqONdiFfP2PdxUqgD8tWYxLVcdXx9sFn0vcgbnDmP3aT7Uec7
tgnai4yWsnO+sKy8oXw2q2qsbWK+Pfh8JbQnGTXI/zn6b0l8lo3QPlFvnLfA
+2zi+9ANPTNYu4DcA+gZXHWtW8D6QsYaeBaho1PA+ecy3xnJWct3ceg9mpj3
y83XWPQ+YaYJ2nDWlhVc31aHGtex6n5CdSBOvV9779VdZqyA/ljqGq/6vpz1
xxkfI2cIOq8LMt/muyZxntwP/x9S1xzVKclWjlIe2R3qkPL6jzPn9gbVo9QY
GJk4NorLPM77cdl3Uz3AM0X3DK346nTqHH+C77up68OjmWub4q6apPut+tUW
8pZi2pY5xym/9UfOnbFr6HRkTA3zoVXnJuUl1edBiWv0ntT4kBzV4c/HxrnO
o7MqJw9F/tbY2N8ObzfmG0KP9lzROeRuePbF7iU6xa6Fugub4b8/8Vm/hQ3/
YV5i7/cT94s6y0U8Fe3nnsjpEnoeYVy1RzhXbNSvqS99IXXfo3r+ATwtifc3
M28M/Zt62Bm5+VtDzdIZL2DDf6u+/z0y41gYFtbPhv5JPUpTyGVp2bolR1gb
mBgbaxP3VcJbpeB6pvxzFfRjoUdtQP4AxmVl425sZuwpB4gmvTuh/y53Pu2O
La/nzq9NifEq/tHE9MPQbw9Bxlcy63st9x7xn69176WYbgz3WfYrp+6JnYN2
sj4ktz+EwfkV551pnKPK2snQW+jsyuHq3QZWjPcV4c5J/tfR/2ps3CpO8pH8
01jnmt0Uet2WgG3l/q6Z8/9R7BxfZ7nqcbonzpGjwr3SnRoD7+7YfhUGT4be
QD3Xn0NvrJpztOq6cyj0k6opOpfumDCjGjKh7By4BP6YHLWM/H9NZowKn3oL
CcPC8vzgF+1VjVU91j1tFa96cdZ+w3xY5l7mncRvEsV6R+o7IPyrB1FdUU25
qew7q7v719y5UvltILxfylwTVK+6lF2zhNkvZPbn9Mx9mHqwo8iblvk8W8M7
Rz7pqLzIOBP6goUBw23qKYIP32L92tCTrC5anu5sb+T1yax7S+j95RPVdeFR
bwPFV+dW7JRXlFOUT5Qv92a+G6qx3RLXWfXaB0IPebF/qTi3H4S2L7UfduTG
vXSoL5SPRFfcFoT3y+9z41vYVv5YnhtPis+ZEBfJVm2RfPV5qmPKgfOCDMVR
35pgg2Rsjy1HtEWBvlhvvVq/YcYn7ht0Fsk+F+QPCnlB9VE2zgs23FJxXlQP
IBytDvmwH37om7kfOZ37zSDcjlAOqPNboCN6lubG5El8k1fdm8yF597Mb/hv
8L1eWCkbvw8GfuUvvY3Vw8iHs0NP3r/ieys56pU2hdr9CN9Hc2PgMPoPx7Zh
d9WYVuwb+f4gtUzV2ZkV4+eK1D6Sf3rDfyZ1r6d+RP9fUG0SZiaEXkf5pmvi
uXrKi3Wv4P5V9sk2vR1vS4z5JYnfPMoDY7BtLOOLFf+PQblPd7s38+OxeyT1
FleHfvtsiKPiqfogPEqXbFeOlP3nq36TKz/obTQuxPFW/Hp/7LP2S93fqBZd
9HHws3ypvCTM6/zKN7JhY+Y+Q32A5Al/wp5iezjEV2964UPY0F1UXpM9z2au
Q4phS3h3Ku/pzarfmitWb4V4bQh9j/LvsKr7HtWgTsi5NnPfqT7xe5nzgjAo
vCj3CrNPhPfgUnz8YOJ3v97g8rF80inUcuH8mYBh7R2p90HV59f/aSYk/l/N
/wDkCXHU
         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtl3mwlXMYx3/nnHuuSu573vc9J9W9lUSWlK5uWkRkyR5FyGRyI9lCsowl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         "],
         VertexColors->None], 
        PolygonBox[{{5520, 5518, 651, 4160, 5519}, {4580, 4754, 1155, 4753, 
         4579}, {4377, 5623, 1010, 4572, 4376}, {4573, 3969, 3968, 4571, 
         1010}, {5583, 4899, 4898, 5510, 2179}, {5585, 5512, 2189, 5514, 
         5584}, {5517, 5516, 5515, 4375, 2189}, {4597, 4580, 4579, 4173, 
         1028}},
         VertexColors->None], 
        PolygonBox[{{5473, 5656, 3230, 5598, 3990, 2027}, {5658, 5629, 2027, 
         5474, 4983, 2636}, {5653, 5599, 785, 4272, 5598, 3230}},
         VertexColors->None]}]}, 
     {RGBColor[0.6334044084039064, 0.6393668249866483, 0.911085031734951], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFWHlwVeUVv1leeO8uL3nvJjRsCbTYioC0EJAAyqKiUyibFRkLEpMUnYIi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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtmHuQlWUdx5/ddeG85z3n7J5zOMSduFiAEFbIPUEwrHa5CKUOynURnSAR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         "],
         VertexColors->None], 
        PolygonBox[{{4377, 5516, 2190, 2866, 3429}, {4161, 5606, 3437, 3181, 
         1013}, {5517, 5513, 2865, 3580, 2190}, {5520, 4577, 2590, 2557, 
         2195}, {5582, 5493, 2115, 3327, 3166}, {4404, 4163, 3249, 3164, 
         881}, {4950, 5587, 2520, 2628, 1344}, {4163, 5491, 3262, 2748, 
         3249}, {4584, 4412, 2562, 2592, 1016}, {5606, 5521, 2196, 2872, 
         3437}},
         VertexColors->None]}]}, 
     {RGBColor[0.6930474506790265, 0.7351965980697338, 0.912444709395743], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJw1mHuMVdUVxg/M3OGee++5c++dOzNgm1AgJX0oYkGLpiJKeQi18cFroGog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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtl3+QllUVx+/uu+/yvs+zz76/d6GaMWHCqYRwFkwzCRCB2PzDZBeUjNGm
gE0EjRlNbLJSydRcQMEJEESiAldkc0GlHN3lZxg68Wv8ESLKTAqhQCIrpH2+
ffePM88595x77jnnnnPuec6/cfZ3b64OIaSqQqjhuzUK4cE4hFOZEMbDeDwJ
YTtrRegOoAv8j3UhNKWQh74J/jbWCuALgTboMvwA3g6k60N4FX23ZkN4jwNS
0DvhX5sOoRt6APLddeZtkA3wX0F+NvJvs/ZT+Lvgfx/5LdCvgu8GGtDdCETI
/wN6KPwhwG5saYA+UWOZkdCvQD+T9tqP0beFtTy8BcBWeH8B6sHLQA+8mPPb
wJvwvz/yL9bZlj9hX0vsmCgWa4E1kW2SLSf68cWeHVnL1tWGMAb+D+F/uco2
bq6EsByYi8xPgM3IL4gtqxi+ie7fQn8Efho4g8y3kJnBdxSwrxzCfmAcuv5N
mP+O7Cj4W7iPmfDL4Ps483vYvhKZEvQ1kfF+6JucC2FJKYS7oVdUee9ydNRn
rWMq+DdZmwLdmTG+lbWmrNeasK+EPzMzjtFGfHkb+DxnjEF2ONAEXIrsN4BS
ZB9k+7PofxldI+FvStmndvRdhcwd2JNG32vQ9yMzP+07+hi6yHn3geeQv5K9
nfC/AP4wMmeJxTmgC3w78fgIXUcT294MbEfusdh75e9f2b8Rek/KMV4E3oj+
MvEPWef6kcS4cj6H/AZkJiB/Enoesl3wlpAPx2odm6HIXJx2jLYBy1hLJMN5
b6Drgdh7VVN3sb+VM/b03d/fiiHM4T5ugI65s0WJbZatisE4xYr957G2GnoV
eC8yA5EtsvY49JnEeCHrXJsGrKpxzh2El69zrqoGPlEMWRsO/3J8uhN8CvwO
8CXI3AC9I/bd3agc5PtO1rEcqpjBLyA/P2MfzwLjWBtT4xgdg25g/1z4vWnb
ehEwPWObX8PfF8iXO5Ub0A3yL3JuysdQCOE5+LPAJ8Iv6L7g12Z858rth2LX
hnI8gf90bF+Uk5er/0AvrXaMT0NX6pxbyvHzoNfB7w9+mPgMY3+EzofZfwlr
P6A+OriPpWnX8Nfh9bA+j7vuwccFiXuEeoNytgh+KnEvVE6vQPfK2HeRB7Lo
fyp2b/oc9JPgmXrjA7LupdojWfXUSXliyPn70vahv/pl1r1RObqXsy7lzJ3Y
8iFnxqr3xLh65DTwi2P34mZkliTu6erl7fAXQ18dGVdMVauySbaoZp/Hnsnw
D/Sd/yi19WbRvisG6s2qQdWeevRe7moT/OHsmc7ee4jf66zF0C3QH4J3srYf
2Q7WjkEfBz7Fjp9BH8bXTAP5Bt2ic+GNJQdS4JPY/wj0J3nbfyJjXoL8jxLL
nIP/DjAEvBt4En3rBKTSRGzuRb4e+dHYPFDy0Jehby26B0F/yt5eYL1shU7D
G4k/o2vcI/+Arvq8c7GZ+2kAn1C0buXIHNmH7pvY/yz7L0L/GdaCekhknnyU
b5I5DW8kOv5FPEYgs4z4fpX43FXlO32j4hgpNr/Qu5VzDBW7A+y5gL2tnD8Z
2T+nresk/Oci65RvOkO65eMt7O/kjKW17pFH4H0GnES+BplNFfdw9e7dysMG
+yRfbk58N/2AyxLf0VF8eb/k3qX6auG890rGlbOSbdZa1nsUe50h3bqDxcg+
AjwYHGPlgu5Id6Oc0FuiO9Ld6E2Rb6eAnjr7OAnfW4Ap3MU07mQCOsfX+y3V
m/oS/k5H/yRs+R0ywyLLiKeavwXdqyquddX8HGz9Z9GzxRn2jCVWV5bdu7rR
P1B5hu1HuJ+FyG9Dd1zwW9OJTEfBb6r69Vb4x9G3n/MG17onrYT/nZzfAr1/
Gzj76Yp76XXYcAW89oL7r9bGQg/k/BT7h6mfomtPvft1NfQ6bG3N++3RG1RE
tlB2r1fPr5S9JvzjtH1TDat25eO7FeeocvMpYlqBbqhYVjXexvld+Ph76FbO
uxDZ2QX7rhgMAV9b9NmzWBuE7vOLjpVsnsHeA0X3dt3BUs07Bfc29bio4BxW
7uoOF8OvLbiX/ydjfAdwMOW1ZvS9hU2tab+xm9i7Pue7K6VcC4PzvgvVxMvI
X8vabezdnHbv6ELf7pR7yEb41xSdO/LxEPzjOfdu2ai3R2+Aer/eIL1VryPf
WO03ayr798Ifn/YMplxXD1LvUc7vr7iGVDvnoMfzPZW1rbJZs7DedL3lmokf
Q35ZxW+R8vN2bJ0HLE+5Jz8B74Occ0czVG/ePVG9UDU0kzs8mLUtsul2zpsL
rEl5ntirtz/repXMr+Hdk/iulSON6O5B371Z59Bq9eacc3k0a7eC7yo5lieR
31X0zCLdOmMb9jxfcf1VZTzbyqf+ffV4mP2z2D857Rge4OzfEIMXUv5HmJp4
ZlJ9aK0N2QHs+VqV7/yOgmtatayYzIB+lPPn13hmb9N7VWe+cm4Uun+eeJZR
/fQD/yzrXFXOdoP/Cpmj8N8HqrmLNbH/RbT27cgy4snmLyq/y+4N6tGalTQT
qVZVs19i79WJZyXZMDGyTbJF/ziajUbE/tfQjPT/2Sv2v5FqeiL4/aytyDi/
vwJeGzu+eg/WV9wz1CsUkyL8SyLXsmq6i7N2Rv53UUyeID6rC+4ViunxxP8I
+je4grXroS+MjWumbhIvcf0+BD0g8gyh2UEzciP8wZF5munuSxwjxUY2qxbu
LTgXlH/tRb/heruHRn6b1XPUa/RGP4PsdTm/parJX8IbxJ6FWc+I/805B0f3
/Y+kC+4R6g1609UL1WPVWxU/9f71kXNPOahaVs2oVlTTUxL/g6h+NLNuL7jH
qbepx8j36+ucK4rBibxt0NmjgA9Knsk0C2kmeivrmpOv8lm9Wz17WF8+XEWu
jCh6PtQbcBv8LdgzP+sa01usmlIt6U3W7FRDv7gg8QylWUQxVOw0k5xF9oGS
bZHOQ3rb0VkFvxP+i+o9wN3oXqT/l4rXhCummr00U2iW0Az2LvThonNL/xyy
TT1HvUY2vlRxz1avlk7NMpqRNBtppjmUc09WrioH/gd/XDFO
         "],
         VertexColors->None], 
        PolygonBox[{{5632, 4432, 485, 3361, 3355}, {5492, 5590, 2556, 3268, 
         2067}, {4951, 5588, 3175, 2611, 1183}, {5607, 4183, 1495, 2647, 
         3182}, {4772, 5605, 3332, 2521, 498}, {5615, 4456, 2062, 2750, 
         3259}, {5636, 4790, 498, 3368, 3367}, {5593, 3846, 787, 3237, 
         2564}, {4462, 3973, 3157, 2569, 914}, {4182, 5607, 3182, 2661, 
         1772}, {4405, 4788, 1183, 3271, 2561}, {3847, 5593, 2564, 2607, 
         1159}, {5645, 4419, 457, 3581, 3430}, {5594, 3974, 877, 3244, 
         2571}, {3979, 5600, 3250, 2572, 457}, {5631, 5486, 2049, 3331, 
         2802}, {5538, 5632, 3355, 3015, 2360}, {5144, 4644, 2599, 2540, 
         1529}, {4008, 5615, 3259, 2727, 482}, {4644, 5506, 2151, 3376, 
         2599}, {5619, 4741, 2067, 2760, 3267}},
         VertexColors->None]}]}, 
     {RGBColor[0.7526904929541466, 0.8310263711528191, 0.9138043870565348], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJw1l32QV1UZxy+7v/tjMXfvvb/7u2va9ILKi6ClzWg5IcEACWKyrizELjFN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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtl3lsVVUQxk/f66NU7Xvvvvte65KoFa1aQMW4JoIaqYIbWKhYW/zDYFRA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         "],
         VertexColors->None], 
        PolygonBox[{{4508, 3912, 3911, 4509, 949}, {4739, 5620, 5619, 5618, 
         650}, {4293, 4457, 910, 4008, 4292}, {3835, 5088, 1487, 5090, 
         3834}, {5633, 4021, 4020, 5659, 3366}, {4460, 4293, 4292, 4009, 
         912}, {5613, 4602, 1031, 5614, 5612}, {4455, 4926, 1321, 4032, 
         4454}, {4267, 4469, 920, 4468, 4266}, {4751, 5592, 5591, 4752, 
         1154}, {5592, 3985, 888, 4420, 5591}, {4421, 4267, 4266, 4419, 
         888}, {4792, 4455, 4454, 4790, 1185}, {5487, 3835, 3834, 5488, 
         2056}, {4605, 4603, 650, 4155, 4604}, {5560, 5602, 5601, 5558, 
         2410}, {4742, 5489, 2056, 5492, 4741}, {3912, 4990, 1387, 4992, 
         3911}},
         VertexColors->None]}]}, 
     {RGBColor[0.80726725, 0.8618830000000001, 0.894034], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJw1l2uwllUVx59z3vd5QTy8z/VF7QMXM6US0EpCEoIBHEGxAqdkOGg1IHNS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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlnmwzmUUx3/vfd/3ktz7297bYibSIi22miSVrkqRUmgqodRI3ULLTI1b
WkVFRFIoywxZ0iSZbEkZTUTGECK6RBRlDW0afb593z+emec85/ucc57znK3h
fY906V8SBMEqVo5VOwyCXnEQDM0GQYF1dxoEPVh1Ad2YD4Lfy4PgqSQIHgO8
AvxheAdZE+Fvhr+B+5cXguDU0iCow1kr9pexumaCoIKzZuwHRuiDtxb5TcBP
5mwIvMFgqpFVH/kN4PdB3sNgy+AfYn8MTF32F2BfkvHZDfBbc3YavJHceRl5
h+GXYF9/5HeAtxvMPdh6FpiHkH0bZ03ZdwQ/Cd4H4JeBvRR6A3Qqm7h/Pmfr
oK+Efh19U+Bfw35AatuawO+NrF/K7Ytu3PkFfhk6TmFfH/wW7jfmbGnO+Kns
F3Nnaqnf/CD7u8B3h3+d3ofsPGs1+kryxk4J/R+6sw1510O/Cf9M5L/Bfj/2
n4BfzfoEWS2hD2X8hkcq+CtWNftd2HiQ+99h73nIuhp8D+TXAv8BvEs5uwv+
EfR/j+4fWEfhH2PNYr8ITD34C+HPgL4d/Tvh/ZH6rcv1HvgZbKiLvgP6M3hH
WedkLHMA+Aw2H0XWc2Buhf4ee56FroTeyr4Eezpn/UebkTcCepbiER0Xsy9L
7Rv5SL6qw8oUadnyZ9F+2ZQBP5+1Juv/Phvdq7Hvk5xjsgb54+B/nLU/6+Cr
Ldxfxf196D+AfQdZw6BHBPb9M/AfyvsPnkHW3fBbg13H/a3cnwtmL7wEmV+D
XZk6NvrBH4y+lgXngnLkwtgxrVhW/Ort2/BBi1L7YAX7a+H35H5z9LdlX1lw
rvwo/eDfZs3JOmcawatGx1fsv+DsZ+6vhr8zaxtPYNu72PMq+lqBuQXeTN4w
JuecGsLd4Yn/RjlVg7zpoXUtK3Wun1xh3yjn7wQfgT895z9vj7wfFL/Ifxqd
bbnbM3XtWJsztptyOuc7Ueg7wo6DjuE/CX9piXNoYGIfy7dzseEi8Msj2yMf
1IZXK3F+ngCzAF1LY8fq9Lzfvkc+LLUPXoI/iDUW/CXI31/uGqDcVwz+C++F
1PXiJ+6fxD6LzjDrGKsCe7JiIu8YWgO/GWdPcX+P5IM9B50joJehYwa+6gq/
Nth2JwXBFeA/C52fkrmE/ZWpa43OBoFtWGFZG5DRDlmjQse28FWJa5hieSpn
E8BPZDUt8ZsGwfsZeevyzvnT4H2YutZ2BdMGWesj1zL5bB90I+5clHNMPwf2
2dSxrbPj8EemjiX5qHfonJL+98GcBX0udBX8ueBXg20cOdYXI+8I/OaJff04
9BK9P/Vfqqa0C52Dyj3pPAo9BH7rrN80g7udkf981jE6O3YMK3YV4++pN3G/
A/ubwJQX3BOUS4eVw+CvL9Jl8PfGjjnF2t/QG9l/V7Dt//c4sM1j9w71kE2R
a5Bqj2qYau3o0PGqmtsA+85kTSzm3zvYMyd2rXgF/ROgg8j2DoX+CHp2at/d
jPzJ7Cel/kvVmMWxa6xqq3rkj/C2p67dskm1KWAdz7lGXYUt34L/M+P//BRe
Q+h7ufsrmE7sX0ocC4qJEvY7Cq7VysFd4H8qyhfmDPBd1CPZTwE/C3u6hO4V
6pEvgz0W+m90Ng/+8ci+V42txf5q7l+bc40pg56m/M/6jxpAz4eelncP+SJy
z1GvORXMUO4OSzw7KH8Ggu0VORerWL3R9yZrNtjhrL7sH45dC+pl3SsXRZ5d
1DMfhTc+dPyMznq2WRYZK/6CyJjRxXlnH/r2p44N5fAa6kPjYn6oJmRUOxPb
pj/IJ54RlE8hdCV07ch/LR/IF6WRY0H0P+zbcnZdzj7pnrhGqjb2YG1HX8fE
saGerFg7lHq2Uszdj627Q9divV+1SD1XvVY1aQ68mZFjfYx6mvo5mE1Zx8SS
2H+sv9XZa9DDYr9HOTyQ/TflrqWK6eGxZx7NLurB8r1mJNUr/cFfqWce9doa
ZL4Ve+YRXj1pLHQusW/UY8erHofOd/lsV+g3DS/K+xB6YfH/9CeKlfqRa7li
5g7e0iFxLVOP7ATdKnFt0kzTI7FP5Uv1zHnIW1lwL1ZPHoOsleXupeoxD8Dr
U3CtVY9QLW2hGSrnGNdfVRbjWX+m3Ohe8KykHGkPfltqX48q8azaN3LtUU//
HP1PxK7dqu/ryz2DKXekY0PsGVez7T7OasBXpc4F1Zwu8FtG5imGa+BtTa1L
PbYae/qFznXN5Hsj11zVWtXQL0PPCKpNqhGqpfLx6KI89boXU9dnxffGyH+i
v9Afq3a3L3h2FmaV5s/Ys6ZmuDbsK4v1UjVEs2P3yLGgGWws9LjUs51q4L9g
d1S4F6onavZtGrlXaAa+Cmyb1PGgHr8F/qbEvtAMrV71W+haoJz8Dyapt6Y=

         "],
         VertexColors->None], 
        PolygonBox[{{4594, 3978, 3977, 4595, 1026}, {4278, 4177, 4176, 4602, 
         786}, {4497, 5651, 5650, 4499, 942}, {3978, 4875, 1282, 4877, 
         3977}, {4606, 4157, 4156, 4603, 1032}, {5248, 5635, 5634, 5649, 
         2655}, {5635, 5247, 490, 5633, 5634}, {4157, 5096, 1490, 5095, 
         4156}, {4177, 5544, 2373, 5545, 4176}},
         VertexColors->None]}]}, 
     {RGBColor[0.8608307500000001, 0.879745, 0.8700376], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFWGtwVdUVPrn33HPRyL3n3HMOQykmWDWmIo3WSqW8MwPY1ml41QelAuWh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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtl2mQVtURhs+3o6Pz3bkLZbkMgiwTlYxBRREX5IdJFBGBuOIWEZxI5IeK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         "],
         VertexColors->None], 
        PolygonBox[{{5478, 4178, 666, 4278, 5477}, {3982, 4399, 4398, 4416, 
         886}, {3833, 4415, 886, 4414, 3832}, {5655, 5586, 1631, 5248, 
         5654}, {5094, 3833, 3832, 5092, 1489}, {4399, 3983, 887, 4417, 
         4398}, {5249, 5609, 5608, 5247, 1631}},
         VertexColors->None]}]}, 
     {RGBColor[0.91439425, 0.8976069999999999, 0.8460412], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmHuU1VUVx3/3zjB3Zu6de+/M/f3ElEpG8NFDkIQKl8swX1gqakoqiiIO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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlnmIlWUUxt97Z+bO3EVn5t7vK1wq962SpPqjJFyiRYPcMkhU1EJNRSsj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         "],
         VertexColors->None], 
        PolygonBox[{{5610, 5464, 2000, 2688, 3205}, {4023, 5609, 3188, 2659, 
         1710}, {5465, 4570, 2588, 3204, 2000}, {4175, 5610, 3205, 2729, 
         2035}, {5611, 4178, 2036, 2730, 3232}, {5478, 4277, 2546, 3233, 
         2036}, {5466, 5611, 3232, 2689, 2001}, {4570, 5467, 2001, 3206, 
         2588}, {4277, 5323, 1710, 3193, 2546}},
         VertexColors->None]}]}, 
     {RGBColor[0.941176, 0.906538, 0.834043], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmGlw1tUVxu/LYt4kLzjWHQiLEAJJ43QIESh0qLIEAVmyERnhQwybMw1L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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwllEdoVlEQhe8fo3n/u+/PzoW9EwsRQYKCigXFjaioSVTURbDgIsUKscag
saGCBSyguNC1moA1RcWNoLHEEpOYYsBYElvssXzDWRzenDtn5t17Z+4Mysmf
l5fknMsByaDAOxdEzq3Fvh849yx0rg7eB7s3aMSuB32xB4DSBOtgGfYtsDPV
uW/kaEtxLhueB49HyjUSPCffS3j/QDnm4v+OvhZ9E0giVzuaqfhmgJ9o38In
Yk8CK9FeRHMO7U34fOJ/sPYC3gLK8F1KyHcb3I2jhZdiLwVt2OXoh7KeHWNf
fF9EOtt74g9jbwGzsCfiH0L+7fy/Gj4C7XJiu+OvQF8OcvFtgw9CexbNavgO
NC2B1rYT3wlvxPcabIb/hr/EbgC32M8mOz/6GPoKeAs5MuCPwUdyv4KPwx4P
+hG/GX1doDN04W8N5ZsCrhPfDB+L/RCUxVUzq9Uj/ncM+wj+p9iT+d888h2H
T8duZm0b/KvXXbaCSvJt8NpLBT1xA77OK/cF+DfyXYsr11JQSPxP21+KatIQ
6Y7tbvsRk4n/l9fZrUfy4cmR7jIdFMB7wCuxx4DT7O0MqEebQf5OfFfjqs1C
0BGqxlbbaWAFuVPQVAXKsRYews+y1wfwQ+j/sTYhUE1y+Z/DvwCeBsKEetB6
byYoQvsansw/muFHvXrIesfWtnjV0GpXj78Q3oucA+Oq6WLsD15nqQ5Uu9sJ
aa2Gpl3CnhoCxZxiLwci3WU6qPLqQeu94WAv9kfW7gV6oxu9amS1qQlU+zVe
Z7UeqMQenKrYNLAf+4vXXuxO7G39jXR39sa2esWY1vZkvVeVUG7rwT3Ef8Y/
OtAdl8A/wUcFehPrvXrEeuNRoF4uT8i2nl6QqppaLa1HDtr/vd6GvYk/kXra
etlmQBv+N6F6M4eYpkhvzt6avdE55LsS113ZDJkNvwwfFlOP70bfGaqWPVlb
hP+9V63tDrvwdYs0q7LAb3gMnhmoJ3aFymGxNeQrJj4pktY0NstqQ/W2zbQT
8H2RetP2cJ6zF4d6e2X4s4nv8Op1u0ObrSX4n6Roxt5JqOes12yG2Gx9F2r2
2YwtjWvG2WyzmXQS3x+vt/oKLEzVndld2ZvJgrd7zV6r0RKvPdlebCYW4e/y
irU3YbN1ldcstxlrs+FEqNlsM+I/tpjq1g==
         "],
         VertexColors->None]}]}}, {{}, {}, {}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{3818, 5462, 5426, 5456, 5455, 3956, 5299, 3955, 5440, 5064, 
         5374, 5373, 4558, 5405, 5406, 5404, 5408, 5407, 4130, 5173, 4225, 
         5172, 4224, 5403, 4553, 5171, 4222, 5170, 4223, 4544, 4543, 5461, 
         5460, 5425, 4221, 5482, 4121, 5481, 4219, 5424, 5459, 3809, 4536, 
         3805, 5458, 5423, 5480, 5479, 3933, 4712, 3932, 4849, 5026, 5025, 
         4531, 5163, 5164, 5162, 5166, 5165, 4097, 5160, 5161, 5159, 4218, 
         5402, 4526, 5156, 4215, 5157, 4216, 5000, 5354, 5001, 4241, 5179, 
         4248, 4626, 4193, 5454, 4619, 4803, 5435, 4802, 5351, 5352, 5353, 
         5350, 5194, 5195, 4328, 3792, 4650, 4649, 4801, 4800, 3867, 4510, 
         4511, 4191, 5388, 5389, 5119, 5118, 5390, 4368, 5122, 5123, 5121, 
         5125, 5124, 4195, 5126, 5127, 5393, 5392, 4196, 5252, 5253, 5115, 
         4189, 5114, 4190, 5116, 4188, 4614, 5255, 5254, 4233, 5411, 3965, 
         5329, 4043, 5258, 5259, 5260, 4314, 3868, 5262, 5261, 5331, 5330, 
         5410, 4607, 4608, 4232, 5483, 5484, 5430, 5468, 3862, 4611, 3861, 
         5395, 5396, 5394, 4202, 4567, 5453, 4566, 4627, 4391, 5452, 4392, 
         4165, 4263, 3840, 4947, 4042, 4838, 3892, 4839, 3893, 4755, 4756, 
         4300, 3888, 4423, 3887, 5500, 5501, 5494, 5507, 5529, 5530, 4815, 
         4816, 3876, 4634, 5269, 5268, 4814, 4238, 5414, 5413, 5305, 3993, 
         5304, 5307, 5306, 3851, 5244, 5245, 5183, 5186, 3783, 5318, 3782, 
         5457, 5228, 5227, 5226, 3903, 5316, 5317, 4896, 5315, 5314, 3842, 
         4870, 4871, 4868, 3984, 4872, 3976, 4418, 3983, 4399, 3982, 4415, 
         3833, 5094, 4258, 4175, 5610, 5464, 5465, 4570, 5467, 5466, 5611, 
         4178, 5478, 4277, 5323, 4023, 5609, 5249, 5586, 5655}],
        "0.9`"],
       Annotation[#, 0.9, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{5652, 4498}],
        "0.9`"],
       Annotation[#, 0.9, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[LineBox[{5651, 4497}],
        "0.8`"],
       Annotation[#, 0.8, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{5225, 5070, 4143, 5071, 4141, 5409, 4227, 5222, 5223, 3817, 
         4557, 3815, 5214, 4733, 4732, 4731, 3950, 5053, 5054, 5052, 5366, 
         5365, 4545, 5048, 4126, 5047, 4127, 5049, 4122, 4540, 4685, 4684, 
         4220, 5167, 4111, 5038, 4120, 4681, 5207, 3807, 4354, 3804, 5204, 
         4714, 4713, 4711, 3931, 5023, 5024, 5022, 5360, 5359, 4529, 5019, 
         4102, 4671, 4103, 5020, 4095, 4527, 4666, 4665, 4217, 5158, 4087, 
         5008, 4092, 4664, 5198, 3799, 4336, 3796, 4657, 4254, 4253, 4519, 
         3917, 4995, 4996, 4655, 4994, 4993, 5117, 4192, 4988, 4076, 4646, 
         4077, 4989, 3910, 4319, 4642, 5120, 4073, 4506, 4793, 4308, 3902, 
         4615, 4616, 4247, 3788, 4476, 4640, 4639, 4638, 4985, 4984, 3906, 
         4493, 4494, 4313, 4312, 4481, 3860, 5109, 5110, 5107, 5112, 5111, 
         5347, 5346, 4610, 4185, 4624, 4184, 4609, 4200, 5131, 4201, 4812, 
         4813, 3875, 4588, 5175, 5176, 5174, 4229, 5177, 4053, 4747, 4746, 
         4745, 4865, 4864, 5083, 5386, 5387, 5104, 5106, 5105, 3987, 4590, 
         3986, 4422, 4299, 4470, 3841, 5240, 4749, 4230, 5178, 4167, 5134, 
         4204, 5133, 4203, 4565, 4150, 4434, 3994, 4464, 4280, 4282, 4003, 
         5308, 4004, 5441, 5280, 3885, 5281, 5184, 5185, 4007, 5342, 4070, 
         4453, 4069, 4310, 3904, 4924, 4030, 4897, 4029, 4923, 3843, 4873, 
         4874, 4869, 4876, 4875, 3978, 4594, 3975, 4417, 4398, 4416, 4414, 
         3832, 5092, 5093, 4740, 4174, 5096, 4157, 4606, 4179, 5544, 4177, 
         4278, 5477, 4276, 5322, 4022, 5608, 5247, 5635, 5248, 5654}],
        "0.8`"],
       Annotation[#, 0.8, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{5224, 4698, 4142, 5069, 4136, 5065, 5066, 4696, 5220, 3816, 
         4365, 3814, 3827, 4730, 4729, 3949, 5051, 4129, 5050, 4128, 5364, 
         4541, 4542, 4125, 4690, 5211, 5212, 4359, 3808, 4683, 4682, 5040, 
         5039, 3941, 4537, 3940, 4353, 4535, 4534, 4348, 5029, 4108, 4676, 
         4109, 5030, 3929, 4347, 4673, 4672, 4104, 5021, 4096, 5016, 5017, 
         4669, 5200, 3802, 4340, 3800, 3822, 4255, 4524, 4523, 3922, 4999, 
         4086, 4660, 4085, 4998, 4329, 4330, 4084, 4656, 5192, 5193, 4326, 
         3791, 4648, 4647, 4991, 4990, 3912, 4508, 3909, 4318, 4505, 4504, 
         4612, 4613, 4306, 3900, 4317, 3901, 4307, 4794, 4971, 4036, 4477, 
         4503, 4502, 4315, 3880, 4827, 4824, 4062, 4969, 4287, 4288, 4186, 
         5108, 4187, 5113, 4072, 4621, 4207, 4625, 4214, 4245, 3786, 4622, 
         3784, 5187, 4701, 4700, 4699, 3905, 4957, 4958, 4956, 4054, 5335, 
         3874, 4389, 4390, 4492, 4491, 3972, 4388, 4744, 5101, 5102, 4587, 
         4586, 3856, 4424, 5085, 5086, 5084, 4168, 5087, 4017, 4265, 4264, 
         4589, 4166, 4395, 5132, 4394, 3855, 4431, 4777, 4776, 4433, 4014, 
         4281, 3848, 4448, 4291, 4457, 4293, 4460, 4459, 3884, 4295, 4771, 
         4925, 4926, 4455, 4792, 4452, 4500, 4309, 3859, 4789, 4406, 4031, 
         4469, 4267, 4421, 3985, 5592, 4751, 4402, 4877, 3977, 4595, 4170, 
         4400, 5089, 5088, 3835, 5487, 5489, 4742, 5620, 4739, 5095, 4156, 
         4603, 4605, 5602, 5560, 5545, 4176, 4602, 5613, 5596, 4019, 5617, 
         4021, 5633, 5634, 5649}],
        "0.7`"],
       Annotation[#, 0.7, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{5637, 5626, 4499, 5650}],
        "0.7`"],
       Annotation[#, 0.7, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[LineBox[CompressedData["
1:eJwV0k1Mz3EcwPGvh8rDROmBuUjGAQeHTrYuFbbYTKrhxjyskbI2xsVsuXDo
UtqUmdqitB6mGm1WtDK5oYZMJTO0PG0mpbx+h3fvz/fz9P39fv/SjpzZX7wg
hLDQn2NJIRxMDOH56hAGcXZlCO1ypdzGA3KzPIPlCSH0O29aFUKBmc28TG4p
8p0PIA+dejpQZMeA2lPEoio5hBjuxiI06bmH3WZS7GoWHzXzQF9Q3ymfg3i1
BrVDavflO/BXrlLfNLc7t6JSTxUyzcTIXxcXmmlWm+N6/f/4h1oeX1Of4Qz9
e73fUHwIU2oveBI14nqzddij7xZ/4zp7pnhU/ZIdu8S1ajfke/EYPRhAut2X
eSOvcUcqcpCNNLl03hCd7aiwI4tH7G0104YWrJUrcs97zuVRPs3jfIrH+I1d
j/S+5mGclD+BXrUL9l7EefTpOcdPOFWtUpzg/kQkIwkpaslYLR6xq5rfcYnn
SomeG+sx7LzFjhrxuPqEuMSdz8SDKLf7Cl7KH5Yf0vcK6XLzvu8Xua/4jHy7
JvkAf4t+N/7kGQq4ya5GbIv2Re8qX87FzmewFQ3q+zikhHBbvVTcoqfLfCy/
lovj6ujbRL+j8x3nPvW70Ts430QtuvEQ/WrFPI+PqDfbo/e4+U7xYnd18Uu1
Qs+cGP1/Omeoj8pddS4TN9qTxSv0Z/OwWoW+aZ7DH2yXn+APmEWumTj9SzBu
91/fq0R+lfMQl0XfwI5f/BOZ+n/zDp61a0zciS7Em5mWmxJP4i3aPdt3vs/r
1P8Dcxih8g==
         "]],
        "0.6`"],
       Annotation[#, 0.6, "Tooltip"]& ]}, {}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[LineBox[CompressedData["
1:eJwV0ltoj3Ecx/HfIsVkmDHG1kjZQmoz2yiH3WqFtpUaMlwwWzbmdGGKNuVM
anNc2ZSUOZU0rdRm7BQrW8rENnYjRsuNC6/n4t3n+/kePs/z/Pun7izfXBYT
QviHpdNDeD8jhE50IZ0vmhnCzlkhlGCq3si0EIrVR/QPowqlcSE8iQ/hKR5j
vrsXdp8lhDBH/Ugviebb3ep2SMZE80E6hlL9fdFz5PyhW+zk0Vg3d922yWnH
YzzFE/wy/4l683F7l+hlrNabwF9RF0R56lV6Wbigd9vtebrJ7L53aODv4Ch+
2G3Sa8R3dQMds1ev/k2H6Cl7X2mP965RL5a7kh+k/XLrvPsHet1tmpv5/AIk
ocJeMr2JEfsH+RT1sHoIFe5aZR6IvtlttYx2elXvhLrVzjy+zHyIjvI59CXN
pbv196AEH/ldtNN7XvOcTPTxMbJC9L3yEu2s01uPRLzi19Iq71QtM9vNAN+n
X0479N5EuO9CB7qRat5J36Il8rJf21tIa1GDJlnF9Jj5Lfsp6ht2lsldjm38
A77XXoZ5ul5z9PvRNCxBhdv9URa9h0Zs5FdE30ZL+AKajzpZGW4yUcQX4i/2
otnsYfR/M3vuGTvoAN1O+2m2nFzkRN/pt2jR66ZZ5rnIQYpevKxk2i6rDT3q
wuj3cnccleYZyESed6zU20BH+TXo4Q/hstthfhzrzb/pXYr+p7iIL/onZX+K
dvhJs30LncufpedwBnH6tfQdFnmPXjpZ7zSNpVPwSP5nPkH9H/iQlRo=
         "]],
        "0.4`"],
       Annotation[#, 0.4, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{5656, 5473, 5644, 5660}],
        "0.4`"],
       Annotation[#, 0.4, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{5657, 5629, 5658}],
        "0.4`"],
       Annotation[#, 0.4, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{4139, 4856, 3952, 5296, 4855, 5061, 5060, 5370, 4360, 5056, 
         5057, 5055, 4133, 4549, 4548, 4689, 4688, 4687, 5169, 5168, 3945, 
         4721, 3944, 4852, 4117, 5034, 4350, 4351, 4114, 4679, 5205, 5206, 
         4349, 3803, 3824, 4710, 4709, 3928, 4846, 5199, 4668, 4100, 5012, 
         3926, 4707, 4845, 4844, 5005, 4335, 5002, 4088, 4658, 4089, 4332, 
         4331, 3794, 4654, 4251, 4249, 4514, 3915, 4986, 4987, 4651, 4075, 
         5145, 4209, 4831, 5146, 5399, 5400, 4832, 4833, 5278, 5447, 4213, 
         5401, 5279, 4623, 4211, 5422, 4240, 5419, 5421, 5420, 4495, 4478, 
         4934, 4935, 4933, 4039, 4936, 5271, 5339, 4059, 5445, 5270, 4798, 
         4796, 4938, 4937, 5082, 4569, 3879, 4822, 4821, 4206, 5136, 3894, 
         4304, 4035, 4930, 4932, 4931, 4002, 4889, 4001, 4890, 3829, 4393, 
         3828, 4735, 4256, 4490, 4489, 3962, 4954, 4050, 4861, 4049, 4381, 
         3971, 4441, 4442, 4384, 4886, 4382, 3850, 4907, 4908, 4301, 3889, 
         4449, 3890, 4893, 4894, 4891, 4005, 4244, 4243, 5074, 4145, 4762, 
         5073, 5241, 5072, 4429, 3849, 4913, 4914, 4902, 4025, 4436, 4435, 
         4782, 4781, 4961, 4057, 4819, 4820, 3878, 4466, 3877, 4817, 4818, 
         4920, 5326, 4919, 4786, 4787, 4047, 4949, 4048, 4952, 3967, 4483, 
         4484, 4259, 3837, 5129, 3836, 4407, 4409, 4164, 4585, 3981, 4413, 
         4753, 4579, 4173, 4598, 4159, 4374, 4160, 5519, 4576, 3968, 4571, 
         4572, 4376, 5515, 4375, 5514, 5584, 4898, 5510, 4900, 4275, 4272, 
         5598, 3990, 5474, 4983, 5627, 5589, 5547, 5182}],
        "0.3`"],
       Annotation[#, 0.3, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{4137, 4854, 3951, 5294, 5295, 5059, 5058, 5369, 4550, 5368, 
         4131, 5367, 4132, 4547, 4546, 3810, 5209, 4723, 4722, 4720, 3943, 
         5033, 4116, 5032, 4115, 4850, 3937, 5293, 3936, 5292, 5027, 5363, 
         5362, 4343, 4344, 4105, 4674, 5201, 5202, 4342, 3801, 3823, 4708, 
         4706, 3924, 4843, 5196, 4659, 4090, 5003, 3920, 4704, 3919, 4842, 
         4083, 4997, 4324, 4325, 4080, 4652, 5190, 3793, 4321, 3789, 3819, 
         5439, 4702, 5077, 5076, 5380, 5438, 5379, 5378, 5416, 5415, 5417, 
         4635, 4636, 4618, 4617, 4633, 4632, 3882, 5275, 5274, 4239, 5418, 
         3899, 4305, 4060, 5340, 4061, 5341, 4040, 4940, 4942, 5450, 4941, 
         3831, 4482, 3830, 4738, 4737, 4154, 5081, 4153, 4568, 5264, 5263, 
         4194, 5391, 4768, 4367, 3964, 4447, 4257, 4866, 4867, 4748, 5239, 
         4863, 3963, 4858, 4862, 4860, 4953, 4380, 4883, 5449, 4884, 4882, 
         3997, 4887, 4000, 4885, 3999, 4284, 4283, 4895, 4006, 4769, 4770, 
         3853, 4302, 3852, 4297, 4298, 4451, 4450, 3886, 4880, 4881, 4763, 
         4901, 5442, 5444, 5443, 4012, 5321, 4013, 4903, 3996, 4734, 3995, 
         4879, 4912, 4911, 5235, 5234, 5381, 5382, 5233, 5427, 5232, 4026, 
         4785, 5250, 5251, 4366, 3857, 5332, 4044, 4948, 4045, 4370, 4369, 
         5266, 5265, 4804, 4199, 5130, 4743, 4408, 4583, 4582, 3980, 4620, 
         4268, 4270, 4172, 4596, 4574, 4575, 4373, 4578, 3970, 4592, 4261, 
         4425, 4427, 4379, 4758, 5320, 4759, 4010, 4274, 4271, 5597, 3989, 
         4980, 4982, 5548, 5546, 5181}],
        "0.2`"],
       Annotation[#, 0.2, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{4561, 4559, 4560, 4226, 5215, 5216, 5217, 4554, 3812, 3826, 
         4725, 4724, 3947, 4853, 5208, 4719, 4718, 4717, 3942, 5476, 4113, 
         5436, 4112, 5291, 3935, 5289, 3934, 5290, 4106, 5361, 5287, 5288, 
         5284, 5286, 5285, 5358, 4338, 5356, 5357, 5355, 4098, 4521, 4520, 
         3797, 3821, 4705, 4703, 3918, 4841, 5191, 4653, 5349, 5348, 3914, 
         5282, 3913, 5283, 4074, 5412, 4236, 4795, 5256, 5257, 4630, 4631, 
         4235, 5437, 4234, 5485, 4237, 5470, 3966, 5431, 5472, 5471, 3869, 
         5502, 5503, 5496, 3895, 5495, 3896, 5504, 5505, 5336, 5338, 5337, 
         3785, 5231, 5230, 5229, 4147, 5375, 4146, 4564, 5523, 5522, 4205, 
         5528, 5135, 4859, 3961, 4857, 3960, 5344, 5345, 5343, 4071, 5384, 
         5429, 5385, 5091, 5242, 5243, 4600, 4767, 4766, 4765, 4231, 4444, 
         4443, 5237, 5236, 5383, 4151, 5446, 5267, 5469, 3872, 5312, 5313, 
         5309, 5311, 5310, 4296, 4440, 3838, 5463, 5428, 4228, 4629, 4628, 
         3854, 4774, 4773, 3959, 5302, 4943, 5451, 4944, 4041, 5327, 5328, 
         4946, 5448, 4945, 3958, 5301, 3957, 5300, 4917, 4027, 4286, 4285, 
         4637, 4242, 4290, 4289, 4581, 4410, 4411, 4198, 4269, 4197, 5128, 
         3844, 4591, 3845, 4750, 4372, 4169, 5527, 4593, 4260, 4426, 3992, 
         4378, 4757, 5319, 4011, 5550, 5246, 4878, 3991, 5303, 3988, 4981, 
         4979, 5565, 5549, 5180}],
        "0.1`"],
       Annotation[#, 0.1, "Tooltip"]& ]}, {}, {}, {}}}],
  AspectRatio->1,
  Frame->True,
  ImageMargins->0.,
  ImageSize->{225, Automatic},
  PlotRange->NCache[{{0, 5}, {
      Rational[1, 10], 5}}, {{0, 5}, {0.1, 5}}],
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{229, 234},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->806132780]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->30245],

Cell["The probability density function integrates to unity:", "ExampleText",
 CellID->10189],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"PDF", "[", 
    RowBox[{
     RowBox[{"TriangularDistribution", "[", 
      RowBox[{"{", 
       RowBox[{"min", ",", "max"}], "}"}], "]"}], ",", "x"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "min", ",", "max"}], "}"}], ",", 
   RowBox[{"Assumptions", "\[Rule]", 
    RowBox[{"min", "<", "max"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->11156],

Cell[BoxData["1"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->410969707]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->17929],

Cell["Moments can be obtained from the characteristic function:", \
"ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->3912],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ev", "=", 
  RowBox[{"ExpectedValue", "[", 
   RowBox[{
    RowBox[{"x", "^", "4"}], ",", 
    RowBox[{"TriangularDistribution", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"min", ",", "max"}], "}"}], ",", "c"}], "]"}], ",", "x"}], 
   "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->4715],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "15"], " ", 
  RowBox[{"(", 
   RowBox[{
    SuperscriptBox["c", "4"], "+", 
    RowBox[{
     SuperscriptBox["c", "3"], " ", "max"}], "+", 
    RowBox[{
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["max", "2"]}], "+", 
    RowBox[{"c", " ", 
     SuperscriptBox["max", "3"]}], "+", 
    SuperscriptBox["max", "4"], "+", 
    RowBox[{
     SuperscriptBox["c", "3"], " ", "min"}], "+", 
    RowBox[{
     SuperscriptBox["c", "2"], " ", "max", " ", "min"}], "+", 
    RowBox[{"c", " ", 
     SuperscriptBox["max", "2"], " ", "min"}], "+", 
    RowBox[{
     SuperscriptBox["max", "3"], " ", "min"}], "+", 
    RowBox[{
     SuperscriptBox["c", "2"], " ", 
     SuperscriptBox["min", "2"]}], "+", 
    RowBox[{"c", " ", "max", " ", 
     SuperscriptBox["min", "2"]}], "+", 
    RowBox[{
     SuperscriptBox["max", "2"], " ", 
     SuperscriptBox["min", "2"]}], "+", 
    RowBox[{"c", " ", 
     SuperscriptBox["min", "3"]}], "+", 
    RowBox[{"max", " ", 
     SuperscriptBox["min", "3"]}], "+", 
    SuperscriptBox["min", "4"]}], ")"}]}]], "Output",
 ImageSize->{442, 49},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->762919474]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"cf", "=", 
  RowBox[{"CharacteristicFunction", "[", 
   RowBox[{
    RowBox[{"TriangularDistribution", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"min", ",", "max"}], "}"}], ",", "c"}], "]"}], ",", "t"}], 
   "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->24286475],

Cell[BoxData[
 FractionBox[
  RowBox[{"2", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"c", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"\[ImaginaryI]", " ", "max", " ", "t"}]]}], "+", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"\[ImaginaryI]", " ", "min", " ", "t"}]]}], ")"}]}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"\[ImaginaryI]", " ", "c", " ", "t"}]], "-", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"\[ImaginaryI]", " ", "min", " ", "t"}]]}], ")"}], " ", 
      "max"}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"\[ImaginaryI]", " ", "c", " ", "t"}]]}], "+", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"\[ImaginaryI]", " ", "max", " ", "t"}]]}], ")"}], " ", 
      "min"}]}], ")"}]}], 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "c"}], "+", "max"}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "c"}], "+", "min"}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "max"}], "+", "min"}], ")"}], " ", 
   SuperscriptBox["t", "2"]}]]], "Output",
 ImageSize->{414, 39},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->134399298]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{
   RowBox[{"D", "[", 
    RowBox[{"cf", ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "4"}], "}"}]}], "]"}], ",", 
   RowBox[{"t", "\[Rule]", "0"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->12536],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "15"], " ", 
  RowBox[{"(", 
   RowBox[{
    SuperscriptBox["c", "4"], "+", 
    SuperscriptBox["max", "4"], "+", 
    RowBox[{
     SuperscriptBox["max", "3"], " ", "min"}], "+", 
    RowBox[{
     SuperscriptBox["max", "2"], " ", 
     SuperscriptBox["min", "2"]}], "+", 
    RowBox[{"max", " ", 
     SuperscriptBox["min", "3"]}], "+", 
    SuperscriptBox["min", "4"], "+", 
    RowBox[{
     SuperscriptBox["c", "3"], " ", 
     RowBox[{"(", 
      RowBox[{"max", "+", "min"}], ")"}]}], "+", 
    RowBox[{
     SuperscriptBox["c", "2"], " ", 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["max", "2"], "+", 
       RowBox[{"max", " ", "min"}], "+", 
       SuperscriptBox["min", "2"]}], ")"}]}], "+", 
    RowBox[{"c", " ", 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["max", "3"], "+", 
       RowBox[{
        SuperscriptBox["max", "2"], " ", "min"}], "+", 
       RowBox[{"max", " ", 
        SuperscriptBox["min", "2"]}], "+", 
       SuperscriptBox["min", "3"]}], ")"}]}]}], ")"}]}]], "Output",
 ImageSize->{423, 49},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->41981811]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"%", "\[Equal]", "ev"}], "//", "Simplify"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->364373683],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->213505976]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->522933856],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  ButtonBox["Mean",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Mean"]], "InlineFormula"],
 " of 2 random variables from ",
 Cell[BoxData[
  ButtonBox["UniformDistribution",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/UniformDistribution"]], "InlineFormula"],
 " follows a triangular distribution:"
}], "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 CellFrameLabels->{{None, None}, {None, None}},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->24312904],

Cell[BoxData[
 RowBox[{
  RowBox[{"vals", "=", 
   RowBox[{"Mean", "[", 
    RowBox[{"RandomReal", "[", 
     RowBox[{
      RowBox[{"UniformDistribution", "[", 
       RowBox[{"{", 
        RowBox[{"1", ",", "10"}], "}"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"2", ",", 
        RowBox[{"10", "^", "5"}]}], "}"}]}], "]"}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->787117276],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Mean", "[", "vals", "]"}], ",", 
   RowBox[{"Variance", "[", "vals", "]"}], ",", 
   RowBox[{"Skewness", "[", "vals", "]"}], ",", 
   RowBox[{"Kurtosis", "[", "vals", "]"}]}], "}"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->351190034],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"5.508930857749079`", ",", "3.369808933164467`", ",", 
   RowBox[{"-", "0.011317335033736968`"}], ",", "2.4017116223432886`"}], 
  "}"}]], "Output",
 ImageSize->{270, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->31600875]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"dist", "=", 
   RowBox[{"TriangularDistribution", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "10"}], "}"}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->21506059],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Mean", "[", "dist", "]"}], ",", 
    RowBox[{"Variance", "[", "dist", "]"}], ",", 
    RowBox[{"Skewness", "[", "dist", "]"}], ",", 
    RowBox[{"Kurtosis", "[", "dist", "]"}]}], "}"}], "//", "N"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->655094753],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"5.5`", ",", "3.375`", ",", "0.`", ",", "2.4`"}], "}"}]], "Output",
 ImageSize->{143, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->273533894]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->12187],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TriangularDistribution",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TriangularDistribution"]], "InlineFormula"],
 " is not defined when ",
 Cell[BoxData[
  StyleBox["min", "TI"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  StyleBox["max", "TI"]], "InlineFormula"],
 " is not real:"
}], "ExampleText",
 CellID->28540],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Mean", "[", 
  RowBox[{"TriangularDistribution", "[", 
   RowBox[{"{", 
    RowBox[{"I", ",", "3"}], "}"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->31597],

Cell[BoxData[
 RowBox[{
  RowBox[{"TriangularDistribution", "::", "\<\"realparm\"\>"}], ":", 
  " ", "\<\"Parameter \\!\\(\[ImaginaryI]\\) is expected to be real.\"\>"}]], \
"Message", "MSG",
 CellID->57861721],

Cell[BoxData[
 RowBox[{"Mean", "[", 
  RowBox[{"TriangularDistribution", "[", 
   RowBox[{"{", 
    RowBox[{"\[ImaginaryI]", ",", "3"}], "}"}], "]"}], "]"}]], "Output",
 ImageSize->{255, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->358332423]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TriangularDistribution",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TriangularDistribution"]], "InlineFormula"],
 " is not defined when ",
 Cell[BoxData[
  StyleBox["c", "TI"]], "InlineFormula"],
 " is not between ",
 Cell[BoxData[
  StyleBox["min", "TI"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  StyleBox["max", "TI"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->109436897],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Mean", "[", 
  RowBox[{"TriangularDistribution", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "3"}], "}"}], ",", 
    RowBox[{"-", "2"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->678692985],

Cell[BoxData[
 RowBox[{
  RowBox[{"TriangularDistribution", "::", "\<\"midparm\"\>"}], ":", 
  " ", "\<\"Parameter \\!\\(-2\\) is expected to be between the parameters \
\\!\\(1\\) and \\!\\(3\\).\"\>"}]], "Message", "MSG",
 CellID->547018],

Cell[BoxData[
 RowBox[{"Mean", "[", 
  RowBox[{"TriangularDistribution", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "3"}], "}"}], ",", 
    RowBox[{"-", "2"}]}], "]"}], "]"}]], "Output",
 ImageSize->{280, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->82572912]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->19046],

Cell["\<\
Substitution of invalid parameters into symbolic outputs gives results that \
are not meaningful:\
\>", "ExampleText",
 CellID->16727],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Mean", "[", 
   RowBox[{"TriangularDistribution", "[", 
    RowBox[{"{", 
     RowBox[{"min", ",", "max"}], "}"}], "]"}], "]"}], "/.", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"min", "\[Rule]", "2"}], ",", 
    RowBox[{"max", "\[Rule]", 
     RowBox[{"1", "+", "I"}]}]}], "}"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->25838],

Cell[BoxData[
 RowBox[{
  FractionBox["3", "2"], "+", 
  FractionBox["\[ImaginaryI]", "2"]}]], "Output",
 ImageSize->{40, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->214640627]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->13475],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["UniformDistribution",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/UniformDistribution"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Piecewise",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Piecewise"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->20311]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->15023],

Cell[TextData[ButtonBox["Continuous Distributions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ContinuousDistributions"]], "Tutorials",
 CellID->7471]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Continuous Statistical Distributions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ContinuousStatisticalDistributions"]], "MoreAbout",\

 CellID->492772516]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"TriangularDistribution - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 27, 50.5060684}", "context" -> "System`", 
    "keywords" -> {
     "symmetric triangular distribution", "triangle distribution"}, "index" -> 
    True, "label" -> "Built-in Mathematica Symbol", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "TriangularDistribution[{min, max}] represents a symmetric triangular \
statistical distribution giving values between min and max. \
TriangularDistribution[{min, max}, c] represents a triangular distribution \
with a maximum at c.", "synonyms" -> {"triangular distribution"}, "title" -> 
    "TriangularDistribution", "type" -> "Symbol", "uri" -> 
    "ref/TriangularDistribution"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[7653, 246, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->152860529]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 195831, 3930}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1953, 50, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2576, 77, 1587, 37, 70, "ObjectNameGrid"],
Cell[4166, 116, 1381, 43, 70, "Usage",
 CellID->32702]
}, Open  ]],
Cell[CellGroupData[{
Cell[5584, 164, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[6062, 181, 267, 8, 70, "Notes",
 CellID->10684],
Cell[6332, 191, 575, 22, 70, "Notes",
 CellID->26584],
Cell[6910, 215, 706, 26, 70, "Notes",
 CellID->33143606]
}, Closed]],
Cell[CellGroupData[{
Cell[7653, 246, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->152860529],
Cell[CellGroupData[{
Cell[8038, 260, 147, 5, 70, "ExampleSection",
 CellID->46254135],
Cell[8188, 267, 156, 4, 70, "ExampleText",
 CellID->20877],
Cell[CellGroupData[{
Cell[8369, 275, 197, 6, 28, "Input",
 CellID->1014],
Cell[8569, 283, 205, 7, 51, "Output",
 CellID->274727383]
}, Open  ]],
Cell[CellGroupData[{
Cell[8811, 295, 200, 6, 28, "Input",
 CellID->484],
Cell[9014, 303, 279, 10, 51, "Output",
 CellID->48082914]
}, Open  ]],
Cell[9308, 316, 121, 3, 70, "ExampleDelimiter",
 CellID->11495],
Cell[9432, 321, 68, 1, 70, "ExampleText",
 CellID->26811],
Cell[CellGroupData[{
Cell[9525, 326, 222, 7, 28, "Input",
 CellID->1293],
Cell[9750, 335, 1423, 27, 74, "Output",
 Evaluatable->False,
 CellID->143306833]
}, Open  ]],
Cell[CellGroupData[{
Cell[11210, 367, 340, 11, 28, "Input",
 CellID->6798],
Cell[11553, 380, 2787, 50, 168, "Output",
 Evaluatable->False,
 CellID->145453398]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[14389, 436, 216, 7, 70, "ExampleSection",
 CellID->26101],
Cell[14608, 445, 113, 3, 70, "ExampleText",
 CellID->8493],
Cell[CellGroupData[{
Cell[14746, 452, 257, 9, 70, "Input",
 CellID->29074],
Cell[15006, 463, 337, 10, 36, "Output",
 CellID->449969001]
}, Open  ]],
Cell[15358, 476, 121, 3, 70, "ExampleDelimiter",
 CellID->13774],
Cell[15482, 481, 83, 1, 70, "ExampleText",
 CellID->20699375],
Cell[CellGroupData[{
Cell[15590, 486, 227, 7, 70, "Input",
 CellID->9314],
Cell[15820, 495, 1384, 42, 84, "Output",
 CellID->350571618]
}, Open  ]],
Cell[CellGroupData[{
Cell[17241, 542, 228, 7, 70, "Input",
 CellID->29218],
Cell[17472, 551, 179, 6, 51, "Output",
 CellID->123808490]
}, Open  ]],
Cell[17666, 560, 121, 3, 70, "ExampleDelimiter",
 CellID->16833],
Cell[17790, 565, 241, 9, 70, "ExampleText",
 CellID->15238],
Cell[CellGroupData[{
Cell[18056, 578, 258, 9, 70, "Input",
 CellID->19911],
Cell[18317, 589, 1711, 32, 70, "Output",
 Evaluatable->False,
 CellID->27777078]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[20077, 627, 222, 7, 70, "ExampleSection",
 CellID->6784],
Cell[20302, 636, 112, 3, 70, "ExampleText",
 CellID->19271],
Cell[CellGroupData[{
Cell[20439, 643, 415, 14, 70, "Input",
 CellID->12368],
Cell[20857, 659, 2278, 41, 70, "Output",
 Evaluatable->False,
 CellID->197239064]
}, Open  ]],
Cell[23150, 703, 121, 3, 70, "ExampleDelimiter",
 CellID->15258],
Cell[23274, 708, 219, 9, 70, "ExampleText",
 CellID->4157],
Cell[CellGroupData[{
Cell[23518, 721, 447, 14, 70, "Input",
 CellID->9647],
Cell[23968, 737, 155920, 2601, 70, "Output",
 CellID->806132780]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[179937, 3344, 233, 7, 70, "ExampleSection",
 CellID->30245],
Cell[180173, 3353, 92, 1, 70, "ExampleText",
 CellID->10189],
Cell[CellGroupData[{
Cell[180290, 3358, 433, 13, 70, "Input",
 CellID->11156],
Cell[180726, 3373, 158, 5, 36, "Output",
 CellID->410969707]
}, Open  ]],
Cell[180899, 3381, 121, 3, 70, "ExampleDelimiter",
 CellID->17929],
Cell[181023, 3386, 234, 6, 70, "ExampleText",
 CellID->3912],
Cell[CellGroupData[{
Cell[181282, 3396, 327, 11, 70, "Input",
 CellID->4715],
Cell[181612, 3409, 1233, 39, 70, "Output",
 CellID->762919474]
}, Open  ]],
Cell[CellGroupData[{
Cell[182882, 3453, 305, 10, 70, "Input",
 CellID->24286475],
Cell[183190, 3465, 1444, 45, 60, "Output",
 CellID->134399298]
}, Open  ]],
Cell[CellGroupData[{
Cell[184671, 3515, 258, 9, 70, "Input",
 CellID->12536],
Cell[184932, 3526, 1198, 39, 70, "Output",
 CellID->41981811]
}, Open  ]],
Cell[CellGroupData[{
Cell[186167, 3570, 131, 4, 70, "Input",
 CellID->364373683],
Cell[186301, 3576, 161, 5, 36, "Output",
 CellID->213505976]
}, Open  ]],
Cell[186477, 3584, 125, 3, 70, "ExampleDelimiter",
 CellID->522933856],
Cell[186605, 3589, 571, 18, 70, "ExampleText",
 CellID->24312904],
Cell[187179, 3609, 403, 13, 70, "Input",
 CellID->787117276],
Cell[CellGroupData[{
Cell[187607, 3626, 287, 8, 70, "Input",
 CellID->351190034],
Cell[187897, 3636, 317, 9, 36, "Output",
 CellID->31600875]
}, Open  ]],
Cell[188229, 3648, 214, 7, 70, "Input",
 CellID->21506059],
Cell[CellGroupData[{
Cell[188468, 3659, 316, 9, 70, "Input",
 CellID->655094753],
Cell[188787, 3670, 237, 7, 36, "Output",
 CellID->273533894]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[189073, 3683, 226, 7, 70, "ExampleSection",
 CellID->12187],
Cell[189302, 3692, 367, 13, 70, "ExampleText",
 CellID->28540],
Cell[CellGroupData[{
Cell[189694, 3709, 194, 6, 70, "Input",
 CellID->31597],
Cell[189891, 3717, 210, 5, 70, "Message",
 CellID->57861721],
Cell[190104, 3724, 299, 9, 36, "Output",
 CellID->358332423]
}, Open  ]],
Cell[190418, 3736, 438, 16, 70, "ExampleText",
 CellID->109436897],
Cell[CellGroupData[{
Cell[190881, 3756, 244, 8, 70, "Input",
 CellID->678692985],
Cell[191128, 3766, 240, 5, 70, "Message",
 CellID->547018],
Cell[191371, 3773, 332, 11, 36, "Output",
 CellID->82572912]
}, Open  ]],
Cell[191718, 3787, 121, 3, 70, "ExampleDelimiter",
 CellID->19046],
Cell[191842, 3792, 144, 4, 70, "ExampleText",
 CellID->16727],
Cell[CellGroupData[{
Cell[192011, 3800, 364, 12, 70, "Input",
 CellID->25838],
Cell[192378, 3814, 234, 8, 51, "Output",
 CellID->214640627]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[192673, 3829, 311, 9, 70, "SeeAlsoSection",
 CellID->13475],
Cell[192987, 3840, 475, 17, 70, "SeeAlso",
 CellID->20311]
}, Open  ]],
Cell[CellGroupData[{
Cell[193499, 3862, 314, 9, 70, "TutorialsSection",
 CellID->15023],
Cell[193816, 3873, 157, 3, 70, "Tutorials",
 CellID->7471]
}, Open  ]],
Cell[CellGroupData[{
Cell[194010, 3881, 299, 8, 70, "MoreAboutSection"],
Cell[194312, 3891, 184, 4, 70, "MoreAbout",
 CellID->492772516]
}, Open  ]],
Cell[194511, 3898, 27, 0, 70, "History"],
Cell[194541, 3900, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

