(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     14279,        523]
NotebookOptionsPosition[     11059,        415]
NotebookOutlinePosition[     12425,        454]
CellTagsIndexPosition[     12340,        449]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"TrigExpand" :> 
         Documentation`HelpLookup["paclet:ref/TrigExpand"], "TrigFactor" :> 
         Documentation`HelpLookup["paclet:ref/TrigFactor"], "TrigReduce" :> 
         Documentation`HelpLookup["paclet:ref/TrigReduce"], "TrigToExp" :> 
         Documentation`HelpLookup["paclet:ref/TrigToExp"], "Cancel" :> 
         Documentation`HelpLookup["paclet:ref/Cancel"]}, #, 2]& , Evaluator -> 
       Automatic], {1->"\<\"TrigExpand\"\>", 2->"\<\"TrigFactor\"\>", 
      3->"\<\"TrigReduce\"\>", 4->"\<\"TrigToExp\"\>", 
      5->"\<\"Cancel\"\>"}, "\<\"see also\"\>", 
      StyleBox["\<\"see also\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Trig", "ObjectName",
 CellID->14377],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["Trig",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Trig"]], "InlineFormula"],
     " \[LineSeparator]is an option for various polynomial manipulation \
functions that specifies whether trigonometric functions should be treated \
like polynomial elements."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->23924]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{"Trig", "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 ", trigonometric functions will be treated like polynomial elements by using \
their algebraic relations."
}], "Notes",
 CellID->23438]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->591706677],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->63682305],

Cell[TextData[{
 "By default, ",
 Cell[BoxData[
  ButtonBox["Simplify",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Simplify"]], "InlineFormula"],
 " uses trigonometric identities:"
}], "ExampleText",
 CellID->252019676],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Sin", "[", "x", "]"}], "^", "2"}], "+", 
   RowBox[{
    RowBox[{"Cos", "[", "x", "]"}], "^", "2"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->81365330],

Cell[BoxData["1"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->90501811]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"4", 
    RowBox[{
     RowBox[{"Sin", "[", "x", "]"}], "^", "2"}], 
    RowBox[{
     RowBox[{"Cos", "[", "x", "]"}], "^", "2"}]}], "+", 
   RowBox[{"4", 
    RowBox[{"Sin", "[", "x", "]"}], 
    RowBox[{"Cos", "[", "x", "]"}]}], "+", "1"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->373232992],

Cell[BoxData[
 SuperscriptBox[
  RowBox[{"(", 
   RowBox[{
    RowBox[{"Cos", "[", "x", "]"}], "+", 
    RowBox[{"Sin", "[", "x", "]"}]}], ")"}], "4"]], "Output",
 ImageSize->{121, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->560061321]
}, Open  ]],

Cell["\<\
This simplifies the expression without using trigonometric identities:\
\>", "ExampleText",
 CellID->297327276],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"4", 
     RowBox[{
      RowBox[{"Sin", "[", "x", "]"}], "^", "2"}], 
     RowBox[{
      RowBox[{"Cos", "[", "x", "]"}], "^", "2"}]}], "+", 
    RowBox[{"4", 
     RowBox[{"Sin", "[", "x", "]"}], 
     RowBox[{"Cos", "[", "x", "]"}]}], "+", "1"}], ",", 
   RowBox[{"Trig", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->272783486],

Cell[BoxData[
 SuperscriptBox[
  RowBox[{"(", 
   RowBox[{"1", "+", 
    RowBox[{"2", " ", 
     RowBox[{"Cos", "[", "x", "]"}], " ", 
     RowBox[{"Sin", "[", "x", "]"}]}]}], ")"}], "2"]], "Output",
 ImageSize->{141, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->573285874]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->454312950],

Cell[TextData[{
 "By default, ",
 Cell[BoxData[
  ButtonBox["Expand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Expand"]], "InlineFormula"],
 " expands out products and positive integer powers:"
}], "ExampleText",
 CellID->54936664],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Expand", "[", 
  RowBox[{"4", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"1", "+", 
      RowBox[{"Sin", "[", 
       RowBox[{"x", "+", "y"}], "]"}]}], ")"}], "^", "2"}], 
   RowBox[{"Cos", "[", 
    RowBox[{"x", "-", "y"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->161340157],

Cell[BoxData[
 RowBox[{
  RowBox[{"4", " ", 
   RowBox[{"Cos", "[", 
    RowBox[{"x", "-", "y"}], "]"}]}], "+", 
  RowBox[{"8", " ", 
   RowBox[{"Cos", "[", 
    RowBox[{"x", "-", "y"}], "]"}], " ", 
   RowBox[{"Sin", "[", 
    RowBox[{"x", "+", "y"}], "]"}]}], "+", 
  RowBox[{"4", " ", 
   RowBox[{"Cos", "[", 
    RowBox[{"x", "-", "y"}], "]"}], " ", 
   SuperscriptBox[
    RowBox[{"Sin", "[", 
     RowBox[{"x", "+", "y"}], "]"}], "2"]}]}]], "Output",
 ImageSize->{379, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->327450653]
}, Open  ]],

Cell["This also expands out trigonometric functions:", "ExampleText",
 CellID->129519618],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Expand", "[", 
  RowBox[{
   RowBox[{"4", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "+", 
       RowBox[{"Sin", "[", 
        RowBox[{"x", "+", "y"}], "]"}]}], ")"}], "^", "2"}], 
    RowBox[{"Cos", "[", 
     RowBox[{"x", "-", "y"}], "]"}]}], ",", 
   RowBox[{"Trig", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->119568082],

Cell[BoxData[
 RowBox[{
  RowBox[{"6", " ", 
   RowBox[{"Cos", "[", "x", "]"}], " ", 
   RowBox[{"Cos", "[", "y", "]"}]}], "-", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"Cos", "[", "x", "]"}], "3"], " ", 
   RowBox[{"Cos", "[", "y", "]"}]}], "-", 
  RowBox[{
   RowBox[{"Cos", "[", "x", "]"}], " ", 
   SuperscriptBox[
    RowBox[{"Cos", "[", "y", "]"}], "3"]}], "+", 
  RowBox[{"8", " ", 
   RowBox[{"Cos", "[", "x", "]"}], " ", 
   RowBox[{"Sin", "[", "x", "]"}]}], "+", 
  RowBox[{"3", " ", 
   RowBox[{"Cos", "[", "x", "]"}], " ", 
   RowBox[{"Cos", "[", "y", "]"}], " ", 
   SuperscriptBox[
    RowBox[{"Sin", "[", "x", "]"}], "2"]}], "+", 
  RowBox[{"8", " ", 
   RowBox[{"Cos", "[", "y", "]"}], " ", 
   RowBox[{"Sin", "[", "y", "]"}]}], "+", 
  RowBox[{"6", " ", 
   RowBox[{"Sin", "[", "x", "]"}], " ", 
   RowBox[{"Sin", "[", "y", "]"}]}], "+", 
  RowBox[{"3", " ", 
   SuperscriptBox[
    RowBox[{"Cos", "[", "x", "]"}], "2"], " ", 
   RowBox[{"Sin", "[", "x", "]"}], " ", 
   RowBox[{"Sin", "[", "y", "]"}]}], "+", 
  RowBox[{"3", " ", 
   SuperscriptBox[
    RowBox[{"Cos", "[", "y", "]"}], "2"], " ", 
   RowBox[{"Sin", "[", "x", "]"}], " ", 
   RowBox[{"Sin", "[", "y", "]"}]}], "-", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"Sin", "[", "x", "]"}], "3"], " ", 
   RowBox[{"Sin", "[", "y", "]"}]}], "+", 
  RowBox[{"3", " ", 
   RowBox[{"Cos", "[", "x", "]"}], " ", 
   RowBox[{"Cos", "[", "y", "]"}], " ", 
   SuperscriptBox[
    RowBox[{"Sin", "[", "y", "]"}], "2"]}], "-", 
  RowBox[{
   RowBox[{"Sin", "[", "x", "]"}], " ", 
   SuperscriptBox[
    RowBox[{"Sin", "[", "y", "]"}], "3"]}]}]], "Output",
 ImageSize->{548, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->212535793]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->3706],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["TrigExpand",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TrigExpand"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["TrigFactor",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TrigFactor"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["TrigReduce",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TrigReduce"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["TrigToExp",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TrigToExp"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Cancel",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Cancel"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->28419]
}, Open  ]],

Cell["New in 2", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Trig - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 27, 53.8186532}", "context" -> "System`", 
    "keywords" -> {
     "trigonometric simplification", "trigonometric expansion", 
      "trigonometric factoring"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Trig is an option for various polynomial manipulation functions that \
specifies whether trigonometric functions should be treated like polynomial \
elements.", "synonyms" -> {}, "title" -> "Trig", "type" -> "Symbol", "uri" -> 
    "ref/Trig"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[3023, 102, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->591706677]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 12197, 442}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 971, 20, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1594, 47, 42, 1, 70, "ObjectName",
 CellID->14377],
Cell[1639, 50, 529, 15, 70, "Usage",
 CellID->23924]
}, Open  ]],
Cell[CellGroupData[{
Cell[2205, 70, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[2683, 87, 303, 10, 70, "Notes",
 CellID->23438]
}, Closed]],
Cell[CellGroupData[{
Cell[3023, 102, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->591706677],
Cell[CellGroupData[{
Cell[3408, 116, 147, 5, 70, "ExampleSection",
 CellID->63682305],
Cell[3558, 123, 225, 8, 70, "ExampleText",
 CellID->252019676],
Cell[CellGroupData[{
Cell[3808, 135, 238, 8, 28, "Input",
 CellID->81365330],
Cell[4049, 145, 157, 5, 36, "Output",
 CellID->90501811]
}, Open  ]],
Cell[CellGroupData[{
Cell[4243, 155, 365, 12, 28, "Input",
 CellID->373232992],
Cell[4611, 169, 293, 10, 36, "Output",
 CellID->560061321]
}, Open  ]],
Cell[4919, 182, 121, 3, 70, "ExampleText",
 CellID->297327276],
Cell[CellGroupData[{
Cell[5065, 189, 434, 14, 70, "Input",
 CellID->272783486],
Cell[5502, 205, 330, 11, 36, "Output",
 CellID->573285874]
}, Open  ]],
Cell[5847, 219, 125, 3, 70, "ExampleDelimiter",
 CellID->454312950],
Cell[5975, 224, 239, 8, 70, "ExampleText",
 CellID->54936664],
Cell[CellGroupData[{
Cell[6239, 236, 318, 11, 70, "Input",
 CellID->161340157],
Cell[6560, 249, 587, 20, 36, "Output",
 CellID->327450653]
}, Open  ]],
Cell[7162, 272, 89, 1, 70, "ExampleText",
 CellID->129519618],
Cell[CellGroupData[{
Cell[7276, 277, 385, 13, 70, "Input",
 CellID->119568082],
Cell[7664, 292, 1753, 54, 71, "Output",
 CellID->212535793]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9478, 353, 310, 9, 70, "SeeAlsoSection",
 CellID->3706],
Cell[9791, 364, 1196, 44, 70, "SeeAlso",
 CellID->28419]
}, Open  ]],
Cell[11002, 411, 27, 0, 70, "History"],
Cell[11032, 413, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

