(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     40474,       1400]
NotebookOptionsPosition[     33464,       1148]
NotebookOutlinePosition[     35133,       1199]
CellTagsIndexPosition[     35019,       1193]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Putting Expressions into Different Forms" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/PuttingExpressionsIntoDifferentForms"], 
          "Trigonometric Expressions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/TrigonometricExpressions"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Putting Expressions into Different Forms\"\>", 
       2->"\<\"Trigonometric Expressions\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"TrigFactor" :> 
          Documentation`HelpLookup["paclet:ref/TrigFactor"], "TrigReduce" :> 
          Documentation`HelpLookup["paclet:ref/TrigReduce"], "TrigToExp" :> 
          Documentation`HelpLookup["paclet:ref/TrigToExp"], "Expand" :> 
          Documentation`HelpLookup["paclet:ref/Expand"], "FunctionExpand" :> 
          Documentation`HelpLookup["paclet:ref/FunctionExpand"], "Simplify" :> 
          Documentation`HelpLookup["paclet:ref/Simplify"], "FullSimplify" :> 
          Documentation`HelpLookup["paclet:ref/FullSimplify"], 
          "ComplexExpand" :> 
          Documentation`HelpLookup["paclet:ref/ComplexExpand"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"TrigFactor\"\>", 
       2->"\<\"TrigReduce\"\>", 3->"\<\"TrigToExp\"\>", 4->"\<\"Expand\"\>", 
       5->"\<\"FunctionExpand\"\>", 6->"\<\"Simplify\"\>", 
       7->"\<\"FullSimplify\"\>", 
       8->"\<\"ComplexExpand\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Algebraic Transformations" :> 
          Documentation`HelpLookup["paclet:guide/AlgebraicTransformations"], 
          "Formula Manipulation" :> 
          Documentation`HelpLookup["paclet:guide/FormulaManipulation"], 
          "Hyperbolic Functions" :> 
          Documentation`HelpLookup["paclet:guide/HyperbolicFunctions"], 
          "Trigonometric Functions" :> 
          Documentation`HelpLookup["paclet:guide/TrigonometricFunctions"]}, #,
          2]& , Evaluator -> Automatic], {
       1->"\<\"Algebraic Transformations\"\>", 
       2->"\<\"Formula Manipulation\"\>", 3->"\<\"Hyperbolic Functions\"\>", 
       4->"\<\"Trigonometric Functions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["TrigExpand", "ObjectName"], Cell[BoxData[
     TooltipBox[
      TogglerBox[Dynamic[
        FrontEnd`CurrentValue[
         FrontEnd`EvaluationNotebook[], {
         TaggingRules, "ModificationHighlight"}]], {True->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVVly2zAMDQhxEylSsizLaxJn73KafvQAuUDv/1eApJuosceeTDAWF4B8
eFgk71///HoVV1dXK3p+0wNfIzdCLL4I6p1sYBYuPy3SI2AmRBpuaE/TPRsE
3Isg8mrB9l6ILQhhLkbd93MBuwVxAthdZwPr5wVVzBc8wAvMX8TFqPkqE8q6
rDCsKPjZ/g1guz+PKvLFfGsDU1R4A8zDhgLangX9x/WGM7A1qSQ7rraYkaLf
LHZ5FWY9H7rew/n4/6vWPKT2mXFBaH/NGejzqi/VnFEFJ2Rb1Lo+jtofllPD
RVJjdZLr51Eb/ED1K+QI109LcIg+sdSIWqa5g85L6MiNoRloTws+pdBKiFGl
mx3N0jcAlcsKeFivVkteVOgMSNsC18sYS/iIMdZoK43WSdQVK1SLlYy09bZ2
aEO+aoPiACNak0EBbtfLRIz9KJRcroaSKwE11BprpRHqiJ0BrxtJG4pLYqWc
RZO4BQwSbGT4rFivaLjjQdscjSvlih48Mu+WDisOBcB5ehgeDEZQlikkKh3b
KA1FMTDg9yFxLSe4XC37begHTDh5seS1I/gaW025Yo/yUFbmSalShzon1Kch
JTNn2hKS1hyWVIkf5n2LHEQgt0zeUNTkMaYrDdkMZdo3fJCDHx7hxzAC+8rs
XYBokTPfEJk6JVlZx3Yl0UnTYMPvSUt6zghf8dhIi5VDnwO+Hcb1MHK1msK+
oy5qkYS7wVC3cfiq8ojBcMtFMJXnDiIcLPFJClDFGkJBhXGEZV6VcCQFoey7
tyvBF6lw0uKH6nyQ5fqhrKx/Kxe8+3coucpGN4U5+RYux7vnhGO5P7hKenqz
xSO3ivjisf345fg5Pt1ScCRkkzR1U1Dur+NCec4LZ49Ynx9P04GmOvlnqcKZ
79BfJfcjkg==
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlLlKQ0EYRi/iA9gpWIgvIXbjM1iKWAjW2vgeZnWN+AgWZhEULCxELFyi
ZnfJavbeJOr/33xXcj8CNnY5EA7k3GWYmTuzq+uLa2OWZS38/MYt0DbDHH8Q
8uTB64bRNrmsQkaPRoQSGX1ZqZPR9/eEazL6klIlowf8wiUZ3ecV3snowYDw
SEafUmJk9HmlQh4cX4GM7vUId2T0VFIho28or2T0w5DQIKN3PoUaGX1FaZLR
0ymh6sz7hHLk9PMzoU5Gz6SFmvFsCbd9Xzj9qyc0nfe49xfuTyYUEzoQbmh8
+N8e37HTbVpk9MSzUCajbypFMvq0UiOjzyklMnqvKzRMJCwU+/vjzemTSpns
nh97feJmd0e4cvppTKiQ0bsdoW5ecorZDgpPtD6xqFA2fp+Qp/vtdUj1v797
Oqdwnb2Ov++fUVpk9PCJUCC7n4t5wz5xj9/+rj6ceXbPP86NbEb58/k56qP+
n/0bdGyYqQ==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}], False->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVdd22zAMDUBxSaJm5HgljrPTJN177/nWh35AfqD//1aAVGrrJLbbk+BI
FEmQFxcXlDQ9//3zHNfW1gZ0/6IbbsYOhahvCGrO9qHM/mnhmMMLoKv0RD6V
cPyZHTTcDI5NkYnQq4UQ0BdiAkKYZagl1OOw5fWtcgyvPp7AnefsGG0DBIeA
9RZVrNfcwBasb4nlbP9u4cbc/XD/zXcIgC2qYYazJTQiGSYHS0Hr8Yu5LV/h
ePvR5oMOKswAQ0M8R5OloFMWSNRE+IAVeALv38KX26wAV1uU5Ojv16PQy8q+
gMP+9ABW5C9KbkZi6qv19DGc/ID9b+CrZTjbbVagH3p91oIcL+GZ6JDNUet4
HpWUXxx5BaWZxRh1FQgH6JqoKcarF/2/dblez7IE0XmWGlFL/6ygchIqCmPo
CTSmDq9SaCUUhfI7K3pKlwJESZiAveHGxoA7ESYGpM2B62WMJXzEoojRRhpt
IlFHPKFyjGRBQ2fjBG0WttpMcYIFWhNAAXaHA0+M4yiUXK6UxJWAGmKNsdII
cYGVAadTSQPKS2KkEovGc8swk2ALhg8Tww1qdrjRNmSTtOUqHDhk3jktVpwK
QOLoZngwWICyTMFTqdhHMrQTDQPeazzXdgWXK+e4KV3AhH0US1Ergo8x16QV
R5QXZWWeJJW6qLNHPWq8mEFpS0hac1pSeX4YxjlyEhmFZfKGsqaIhd+Sks+Q
0i7lhZx8cwYPmx5wrMA+yaCwyMqnRCb2IiubsF9JTKRJMeX3JKd5VoS3OEyl
xShBFxLebXrDpsfVSlv2FZ2iHMn4NBg6bZy+ihxiZvjIFWAixyeIcLDNT1KC
qogha1Gh14NB6LXpSEpC2bm3y8O3FmHniF9U55INhnttz7pZuWDu79BqFZxJ
F2bhWzjo7Zx6HMvng6ukuztzvGJXa66NmF/+crzrHe1ScmTkk/SouqB8vq42
0jl0EnuF9/RsMR1Io4U/S5Wt+A79AaDyK/w=
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlUtrE1EYhgfxBwguFBTEvyAiFhfzHxRFvC0E17rQhYLiT7D3u/gTXNg2
3sBFFyIutE1qm17UZJKZZJK0KFjBtur7Td4jnhe7dTMPhAfyQObMnO9Mjl69
fvraniAI7v/+7A3IRri7/8VGWJwHVTH72qohZp+ZBnUx+yWjJWYfHwNvxOwX
jKaYfXAAzIrZ+/tARcw+NAhKYvaTRiJmP2gUxH+vLxKzl5cMMXtfL3gvZn84
Cdpi9hvGJzH7yxegJWa/YnTE7Mtl0HTPfZ/xyPWVZZCGvQ/Au65fSV9aNMLJ
CfDW9a0fIBWz/9wBHbcOf/74PX83W99j128ZNTH71BMQidmfFkAiZj9irIvZ
Fz+AWMx+yEjF7KeMVOw/32x/iuHoCHjt+s42aIfTU6DWna/Prm9vgVb4cc0I
h4fAgusZ62L2A0YsZj9h1MX+9bN9LHfP75zrZ42a2L9/3+wXjVTM7q8jm9NE
5q8wA+JwoB/8eX+eNxIx+00jErP3GA2xvy7uG88R+z2jI2Y/bLTE/v1l76WG
mxP/+r7ZN7+Bupj9mFERsz9/Bppi9myeEzH7QgnUxOy3jYaY/a7RFrNfNtpi
9nNGXcw+NgoaYnbOk2///PJ/bXXFcP37JojF7CPDIBazf/0CKmL2+TlQEbPf
MZpi9olxkIrZS0UQidn3G1Ux+3EjErOfMapi9mBX8p73vOc973n/P/0XnFJ2
Rg==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}]}, "\"\<Click me\>\""],
      "Toggle changes in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["TrigExpand",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/TrigExpand"], "[", 
       StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]expands out trigonometric functions in ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->1804]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TrigExpand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TrigExpand"]], "InlineFormula"],
 " operates on both circular and hyperbolic functions. "
}], "Notes",
 CellID->30807],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TrigExpand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TrigExpand"]], "InlineFormula"],
 " splits up sums and integer multiples that appear in arguments of \
trigonometric functions, and then expands out products of trigonometric \
functions into sums of powers, using trigonometric identities when possible. \
"
}], "Notes",
 CellID->3952],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TrigExpand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TrigExpand"]], "InlineFormula"],
 " automatically threads over lists, as well as equations, inequalities and \
logic functions."
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->82730543]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->641343323],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->23828519],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TrigExpand", "[", 
  RowBox[{"Sin", "[", 
   RowBox[{"2", "x"}], "]"}], "]"}]], "Input",
 CellTags->"CellTags",
 CellLabel->"In[1]:=",
 CellID->20145],

Cell[BoxData[
 RowBox[{"2", " ", 
  RowBox[{"Cos", "[", "x", "]"}], " ", 
  RowBox[{"Sin", "[", "x", "]"}]}]], "Output",
 ImageSize->{101, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"CellTags",
 CellLabel->"Out[1]=",
 CellID->238280180]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TrigExpand", "[", 
  RowBox[{"Sin", "[", 
   RowBox[{"x", "+", "y"}], "]"}], "]"}]], "Input",
 CellTags->"CellTags",
 CellLabel->"In[2]:=",
 CellID->30961],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Cos", "[", "y", "]"}], " ", 
   RowBox[{"Sin", "[", "x", "]"}]}], "+", 
  RowBox[{
   RowBox[{"Cos", "[", "x", "]"}], " ", 
   RowBox[{"Sin", "[", "y", "]"}]}]}]], "Output",
 ImageSize->{191, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"CellTags",
 CellLabel->"Out[2]=",
 CellID->470809901]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->7426],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TrigExpand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TrigExpand"]], "InlineFormula"],
 " operates on hyperbolic trigonometric functions:"
}], "ExampleText",
 CellID->70591820],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TrigExpand", "[", 
  RowBox[{"Cosh", "[", 
   RowBox[{"3", "t"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->78056929],

Cell[BoxData[
 RowBox[{
  SuperscriptBox[
   RowBox[{"Cosh", "[", "t", "]"}], "3"], "+", 
  RowBox[{"3", " ", 
   RowBox[{"Cosh", "[", "t", "]"}], " ", 
   SuperscriptBox[
    RowBox[{"Sinh", "[", "t", "]"}], "2"]}]}]], "Output",
 ImageSize->{188, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->644379160]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TrigExpand", "[", 
  RowBox[{"Tanh", "[", 
   RowBox[{"x", "+", "y"}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->5607416],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{
    RowBox[{"Cosh", "[", "y", "]"}], " ", 
    RowBox[{"Sinh", "[", "x", "]"}]}], 
   RowBox[{
    RowBox[{
     RowBox[{"Cosh", "[", "x", "]"}], " ", 
     RowBox[{"Cosh", "[", "y", "]"}]}], "+", 
    RowBox[{
     RowBox[{"Sinh", "[", "x", "]"}], " ", 
     RowBox[{"Sinh", "[", "y", "]"}]}]}]], "+", 
  FractionBox[
   RowBox[{
    RowBox[{"Cosh", "[", "x", "]"}], " ", 
    RowBox[{"Sinh", "[", "y", "]"}]}], 
   RowBox[{
    RowBox[{
     RowBox[{"Cosh", "[", "x", "]"}], " ", 
     RowBox[{"Cosh", "[", "y", "]"}]}], "+", 
    RowBox[{
     RowBox[{"Sinh", "[", "x", "]"}], " ", 
     RowBox[{"Sinh", "[", "y", "]"}]}]}]]}]], "Output",
 ImageSize->{455, 32},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->180716283]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->22686],

Cell[TextData[{
 "Find ",
 Cell[BoxData[
  ButtonBox["ArcSin",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ArcSin"]], "InlineFormula"],
 " addition law:"
}], "ExampleText",
 CellID->311780119],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Sin", "[", 
   RowBox[{
    RowBox[{"ArcSin", "[", "t", "]"}], "+", 
    RowBox[{"ArcSin", "[", "v", "]"}]}], "]"}], "//", "TrigExpand"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->216440586],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SqrtBox[
    RowBox[{"1", "-", 
     SuperscriptBox["t", "2"]}]], " ", "v"}], "+", 
  RowBox[{"t", " ", 
   SqrtBox[
    RowBox[{"1", "-", 
     SuperscriptBox["v", "2"]}]]}]}]], "Output",
 ImageSize->{139, 24},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->456069056]
}, Open  ]],

Cell[TextData[{
 "Because of the multivaluedness of ",
 Cell[BoxData[
  ButtonBox["ArcSin",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ArcSin"]], "InlineFormula"],
 " this law does not hold everywhere:"
}], "ExampleText",
 CellID->98658025],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RegionPlot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"ArcSin", "[", 
     RowBox[{
      RowBox[{
       SqrtBox[
        RowBox[{"1", "-", 
         SuperscriptBox["t", "2"]}]], " ", "v"}], "+", 
      RowBox[{"t", " ", 
       SqrtBox[
        RowBox[{"1", "-", 
         SuperscriptBox["v", "2"]}]]}]}], "]"}], "==", 
    RowBox[{
     RowBox[{"ArcSin", "[", "t", "]"}], "+", 
     RowBox[{"ArcSin", "[", "v", "]"}]}]}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"v", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->446309339],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 172},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->312607267]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"ArcSin", "[", 
    RowBox[{
     RowBox[{
      SqrtBox[
       RowBox[{"1", "-", 
        SuperscriptBox["t", "2"]}]], " ", "v"}], "+", 
     RowBox[{"t", " ", 
      SqrtBox[
       RowBox[{"1", "-", 
        SuperscriptBox["v", "2"]}]]}]}], "]"}], "-", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"ArcSin", "[", "t", "]"}], "+", 
     RowBox[{"ArcSin", "[", "v", "]"}]}], ")"}]}], "/.", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"v", "\[Rule]", "1"}], ",", 
    RowBox[{"t", "\[Rule]", "1"}]}], "}"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->276406691],

Cell[BoxData[
 RowBox[{"-", "\[Pi]"}]], "Output",
 ImageSize->{20, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->935786609]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1705],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TrigExpand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TrigExpand"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["TrigReduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TrigReduce"]], "InlineFormula"],
 " are, generically, inverses of each other:"
}], "ExampleText",
 CellID->98844493],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TrigReduce", "[", 
  RowBox[{"2", 
   RowBox[{
    RowBox[{"Sin", "[", "x", "]"}], "^", "2"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->52668050],

Cell[BoxData[
 RowBox[{"1", "-", 
  RowBox[{"Cos", "[", 
   RowBox[{"2", " ", "x"}], "]"}]}]], "Output",
 ImageSize->{76, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->202387685]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TrigExpand", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->48025656],

Cell[BoxData[
 RowBox[{"1", "-", 
  SuperscriptBox[
   RowBox[{"Cos", "[", "x", "]"}], "2"], "+", 
  SuperscriptBox[
   RowBox[{"Sin", "[", "x", "]"}], "2"]}]], "Output",
 ImageSize->{132, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->235126816]
}, Open  ]],

Cell["\<\
The expressions are identical modulo trigonometric Pythagorean identities:\
\>", "ExampleText",
 CellID->78087853],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "-", 
  RowBox[{"2", 
   RowBox[{
    RowBox[{"Sin", "[", "x", "]"}], "^", "2"}]}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->243389299],

Cell[BoxData[
 RowBox[{"1", "-", 
  SuperscriptBox[
   RowBox[{"Cos", "[", "x", "]"}], "2"], "-", 
  SuperscriptBox[
   RowBox[{"Sin", "[", "x", "]"}], "2"]}]], "Output",
 ImageSize->{132, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->183052993]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->41903298],

Cell[TextData[{
 "Compare ",
 Cell[BoxData[
  ButtonBox["TrigExpand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TrigExpand"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["TrigFactor",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TrigFactor"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["TrigReduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TrigReduce"]], "InlineFormula"],
 " on the same expression:"
}], "ExampleText",
 CellID->318729833],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TrigExpand", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Sin", "[", "x", "]"}], "^", "2"}], "+", 
   RowBox[{
    RowBox[{"Tan", "[", "x", "]"}], "^", "2"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->9961],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox["1", "2"]}], "-", 
  FractionBox[
   SuperscriptBox[
    RowBox[{"Cos", "[", "x", "]"}], "2"], "8"], "+", 
  FractionBox[
   RowBox[{"5", " ", 
    SuperscriptBox[
     RowBox[{"Sec", "[", "x", "]"}], "2"]}], "8"], "+", 
  FractionBox[
   RowBox[{"3", " ", 
    SuperscriptBox[
     RowBox[{"Sin", "[", "x", "]"}], "2"]}], "4"], "+", 
  FractionBox[
   SuperscriptBox[
    RowBox[{"Tan", "[", "x", "]"}], "2"], "2"], "-", 
  RowBox[{
   FractionBox["1", "8"], " ", 
   SuperscriptBox[
    RowBox[{"Sin", "[", "x", "]"}], "2"], " ", 
   SuperscriptBox[
    RowBox[{"Tan", "[", "x", "]"}], "2"]}]}]], "Output",
 ImageSize->{425, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->49170827]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TrigFactor", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Sin", "[", "x", "]"}], "^", "2"}], "+", 
   RowBox[{
    RowBox[{"Tan", "[", "x", "]"}], "^", "2"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->23281],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "2"], " ", 
  RowBox[{"(", 
   RowBox[{"3", "+", 
    RowBox[{"Cos", "[", 
     RowBox[{"2", " ", "x"}], "]"}]}], ")"}], " ", 
  SuperscriptBox[
   RowBox[{"Tan", "[", "x", "]"}], "2"]}]], "Output",
 ImageSize->{155, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->61061921]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TrigReduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Sin", "[", "x", "]"}], "^", "2"}], "+", 
   RowBox[{
    RowBox[{"Tan", "[", "x", "]"}], "^", "2"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->5705],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "8"], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"5", " ", 
     SuperscriptBox[
      RowBox[{"Sec", "[", "x", "]"}], "2"]}], "-", 
    RowBox[{"4", " ", 
     RowBox[{"Cos", "[", 
      RowBox[{"2", " ", "x"}], "]"}], " ", 
     SuperscriptBox[
      RowBox[{"Sec", "[", "x", "]"}], "2"]}], "-", 
    RowBox[{
     RowBox[{"Cos", "[", 
      RowBox[{"4", " ", "x"}], "]"}], " ", 
     SuperscriptBox[
      RowBox[{"Sec", "[", "x", "]"}], "2"]}]}], ")"}]}]], "Output",
 ImageSize->{330, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->558743263]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->203412870],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["TrigExpand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TrigExpand"]], "InlineFormula"],
 " to construct a ",
 Cell[BoxData[
  ButtonBox["ChebyshevT",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ChebyshevT"]], "InlineFormula"],
 " polynomial:"
}], "ExampleText",
 CellID->845007705],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"TrigExpand", "[", 
    RowBox[{"Cos", "[", 
     RowBox[{"5", "x"}], "]"}], "]"}], "/.", 
   RowBox[{
    RowBox[{
     RowBox[{"Sin", "[", "x", "]"}], "^", "n_"}], "\[RuleDelayed]", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "-", 
       RowBox[{
        RowBox[{"Cos", "[", "x", "]"}], "^", "2"}]}], ")"}], "^", 
     RowBox[{"(", 
      RowBox[{"n", "/", "2"}], ")"}]}]}]}], "//", "Expand"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->109189653],

Cell[BoxData[
 RowBox[{
  RowBox[{"5", " ", 
   RowBox[{"Cos", "[", "x", "]"}]}], "-", 
  RowBox[{"20", " ", 
   SuperscriptBox[
    RowBox[{"Cos", "[", "x", "]"}], "3"]}], "+", 
  RowBox[{"16", " ", 
   SuperscriptBox[
    RowBox[{"Cos", "[", "x", "]"}], "5"]}]}]], "Output",
 ImageSize->{211, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->13186698]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ChebyshevT", "[", 
  RowBox[{"5", ",", 
   RowBox[{"Cos", "[", "x", "]"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->616925149],

Cell[BoxData[
 RowBox[{
  RowBox[{"5", " ", 
   RowBox[{"Cos", "[", "x", "]"}]}], "-", 
  RowBox[{"20", " ", 
   SuperscriptBox[
    RowBox[{"Cos", "[", "x", "]"}], "3"]}], "+", 
  RowBox[{"16", " ", 
   SuperscriptBox[
    RowBox[{"Cos", "[", "x", "]"}], "5"]}]}]], "Output",
 ImageSize->{211, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->15039301]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->19539],

Cell["Expand trigonometric functions using half-angles:", "ExampleText",
 CellID->210321181],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TrigExpand", "[", 
  RowBox[{"Cos", "[", "x", "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->673545974],

Cell[BoxData[
 RowBox[{"Cos", "[", "x", "]"}]], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->479361982]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"TrigExpand", "[", 
   RowBox[{
    RowBox[{"Cos", "[", "x", "]"}], "+", 
    RowBox[{"Cos", "[", 
     RowBox[{"x", "/", "2"}], "]"}]}], "]"}], "-", 
  RowBox[{"Cos", "[", 
   RowBox[{"x", "/", "2"}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->739899329],

Cell[BoxData[
 RowBox[{
  SuperscriptBox[
   RowBox[{"Cos", "[", 
    FractionBox["x", "2"], "]"}], "2"], "-", 
  SuperscriptBox[
   RowBox[{"Sin", "[", 
    FractionBox["x", "2"], "]"}], "2"]}]], "Output",
 ImageSize->{120, 29},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->7736476]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"TrigExpand", "[", 
   RowBox[{
    RowBox[{"Cos", "[", "x", "]"}], "/.", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"2", "t"}]}]}], "]"}], "/.", 
  RowBox[{"t", "\[Rule]", 
   RowBox[{"x", "/", "2"}]}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->481371737],

Cell[BoxData[
 RowBox[{
  SuperscriptBox[
   RowBox[{"Cos", "[", 
    FractionBox["x", "2"], "]"}], "2"], "-", 
  SuperscriptBox[
   RowBox[{"Sin", "[", 
    FractionBox["x", "2"], "]"}], "2"]}]], "Output",
 ImageSize->{120, 29},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->99204997]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->31731],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["TrigFactor",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TrigFactor"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["TrigReduce",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TrigReduce"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["TrigToExp",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TrigToExp"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Expand",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Expand"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FunctionExpand",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FunctionExpand"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Simplify",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Simplify"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FullSimplify",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FullSimplify"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ComplexExpand",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ComplexExpand"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->27707]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->27626],

Cell[TextData[ButtonBox["Putting Expressions into Different Forms",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/PuttingExpressionsIntoDifferentForms"]], "Tutorials",
 CellID->2331],

Cell[TextData[ButtonBox["Trigonometric Expressions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/TrigonometricExpressions"]], "Tutorials",
 CellID->4569]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->11296555],

Cell[TextData[ButtonBox["Algebraic Transformations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/AlgebraicTransformations"]], "MoreAbout",
 CellID->7369784],

Cell[TextData[ButtonBox["Formula Manipulation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/FormulaManipulation"]], "MoreAbout",
 CellID->324501337],

Cell[TextData[ButtonBox["Hyperbolic Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/HyperbolicFunctions"]], "MoreAbout",
 CellID->112865816],

Cell[TextData[ButtonBox["Trigonometric Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/TrigonometricFunctions"]], "MoreAbout",
 CellID->664682142]
}, Open  ]],

Cell["New in 3  |  Last modified in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"TrigExpand - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 27, 52.4592434}", "context" -> "System`", 
    "keywords" -> {
     "de Moivre's Theorem", "expansion", "trigonometric expansion"}, "index" -> 
    True, "label" -> "Built-in Mathematica Symbol", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "TrigExpand[expr] expands out trigonometric functions in expr. ", 
    "synonyms" -> {"trig expand"}, "title" -> "TrigExpand", "type" -> 
    "Symbol", "uri" -> "ref/TrigExpand"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[10177, 258, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->641343323]},
 "CellTags"->{
  Cell[10734, 281, 174, 6, 28, "Input",
   CellTags->"CellTags",
   CellID->20145],
  Cell[10911, 289, 274, 9, 36, "Output",
   CellTags->"CellTags",
   CellID->238280180],
  Cell[11222, 303, 179, 6, 28, "Input",
   CellTags->"CellTags",
   CellID->30961],
  Cell[11404, 311, 374, 13, 36, "Output",
   CellTags->"CellTags",
   CellID->470809901]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 34512, 1173},
 {"CellTags", 34648, 1177}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3222, 69, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3845, 96, 4194, 83, 70, "ObjectNameGrid"],
Cell[8042, 181, 566, 18, 70, "Usage",
 CellID->1804]
}, Open  ]],
Cell[CellGroupData[{
Cell[8645, 204, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[9123, 221, 224, 7, 70, "Notes",
 CellID->30807],
Cell[9350, 230, 391, 10, 70, "Notes",
 CellID->3952],
Cell[9744, 242, 396, 11, 70, "Notes",
 CellID->82730543]
}, Closed]],
Cell[CellGroupData[{
Cell[10177, 258, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->641343323],
Cell[CellGroupData[{
Cell[10562, 272, 147, 5, 70, "ExampleSection",
 CellID->23828519],
Cell[CellGroupData[{
Cell[10734, 281, 174, 6, 28, "Input",
 CellTags->"CellTags",
 CellID->20145],
Cell[10911, 289, 274, 9, 36, "Output",
 CellTags->"CellTags",
 CellID->238280180]
}, Open  ]],
Cell[CellGroupData[{
Cell[11222, 303, 179, 6, 28, "Input",
 CellTags->"CellTags",
 CellID->30961],
Cell[11404, 311, 374, 13, 36, "Output",
 CellTags->"CellTags",
 CellID->470809901]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[11827, 330, 215, 7, 70, "ExampleSection",
 CellID->7426],
Cell[12045, 339, 228, 7, 70, "ExampleText",
 CellID->70591820],
Cell[CellGroupData[{
Cell[12298, 350, 155, 5, 70, "Input",
 CellID->78056929],
Cell[12456, 357, 360, 12, 36, "Output",
 CellID->644379160]
}, Open  ]],
Cell[CellGroupData[{
Cell[12853, 374, 159, 5, 70, "Input",
 CellID->5607416],
Cell[13015, 381, 823, 28, 53, "Output",
 CellID->180716283]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[13887, 415, 223, 7, 70, "ExampleSection",
 CellID->22686],
Cell[14113, 424, 197, 8, 70, "ExampleText",
 CellID->311780119],
Cell[CellGroupData[{
Cell[14335, 436, 228, 8, 70, "Input",
 CellID->216440586],
Cell[14566, 446, 357, 14, 45, "Output",
 CellID->456069056]
}, Open  ]],
Cell[14938, 463, 246, 8, 70, "ExampleText",
 CellID->98658025],
Cell[CellGroupData[{
Cell[15209, 475, 690, 24, 70, "Input",
 CellID->446309339],
Cell[15902, 501, 3116, 55, 70, "Output",
 Evaluatable->False,
 CellID->312607267]
}, Open  ]],
Cell[CellGroupData[{
Cell[19055, 561, 605, 22, 70, "Input",
 CellID->276406691],
Cell[19663, 585, 179, 6, 36, "Output",
 CellID->935786609]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[19891, 597, 232, 7, 70, "ExampleSection",
 CellID->1705],
Cell[20126, 606, 355, 12, 70, "ExampleText",
 CellID->98844493],
Cell[CellGroupData[{
Cell[20506, 622, 179, 6, 70, "Input",
 CellID->52668050],
Cell[20688, 630, 234, 8, 36, "Output",
 CellID->202387685]
}, Open  ]],
Cell[CellGroupData[{
Cell[20959, 643, 105, 3, 70, "Input",
 CellID->48025656],
Cell[21067, 648, 301, 10, 36, "Output",
 CellID->235126816]
}, Open  ]],
Cell[21383, 661, 124, 3, 70, "ExampleText",
 CellID->78087853],
Cell[CellGroupData[{
Cell[21532, 668, 166, 6, 70, "Input",
 CellID->243389299],
Cell[21701, 676, 301, 10, 36, "Output",
 CellID->183052993]
}, Open  ]],
Cell[22017, 689, 124, 3, 70, "ExampleDelimiter",
 CellID->41903298],
Cell[22144, 694, 481, 18, 70, "ExampleText",
 CellID->318729833],
Cell[CellGroupData[{
Cell[22650, 716, 236, 8, 70, "Input",
 CellID->9961],
Cell[22889, 726, 793, 28, 54, "Output",
 CellID->49170827]
}, Open  ]],
Cell[CellGroupData[{
Cell[23719, 759, 237, 8, 70, "Input",
 CellID->23281],
Cell[23959, 769, 371, 13, 51, "Output",
 CellID->61061921]
}, Open  ]],
Cell[CellGroupData[{
Cell[24367, 787, 236, 8, 70, "Input",
 CellID->5705],
Cell[24606, 797, 647, 22, 51, "Output",
 CellID->558743263]
}, Open  ]],
Cell[25268, 822, 125, 3, 70, "ExampleDelimiter",
 CellID->203412870],
Cell[25396, 827, 346, 13, 70, "ExampleText",
 CellID->845007705],
Cell[CellGroupData[{
Cell[25767, 844, 504, 17, 70, "Input",
 CellID->109189653],
Cell[26274, 863, 406, 14, 36, "Output",
 CellID->13186698]
}, Open  ]],
Cell[CellGroupData[{
Cell[26717, 882, 160, 5, 70, "Input",
 CellID->616925149],
Cell[26880, 889, 406, 14, 36, "Output",
 CellID->15039301]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[27335, 909, 226, 7, 70, "ExampleSection",
 CellID->19539],
Cell[27564, 918, 92, 1, 70, "ExampleText",
 CellID->210321181],
Cell[CellGroupData[{
Cell[27681, 923, 136, 4, 70, "Input",
 CellID->673545974],
Cell[27820, 929, 187, 6, 36, "Output",
 CellID->479361982]
}, Open  ]],
Cell[CellGroupData[{
Cell[28044, 940, 297, 10, 70, "Input",
 CellID->739899329],
Cell[28344, 952, 335, 12, 50, "Output",
 CellID->7736476]
}, Open  ]],
Cell[CellGroupData[{
Cell[28716, 969, 292, 10, 70, "Input",
 CellID->481371737],
Cell[29011, 981, 336, 12, 50, "Output",
 CellID->99204997]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[29408, 1000, 311, 9, 70, "SeeAlsoSection",
 CellID->31731],
Cell[29722, 1011, 1957, 71, 70, "SeeAlso",
 CellID->27707]
}, Open  ]],
Cell[CellGroupData[{
Cell[31716, 1087, 314, 9, 70, "TutorialsSection",
 CellID->27626],
Cell[32033, 1098, 189, 4, 70, "Tutorials",
 CellID->2331],
Cell[32225, 1104, 159, 3, 70, "Tutorials",
 CellID->4569]
}, Open  ]],
Cell[CellGroupData[{
Cell[32421, 1112, 318, 9, 70, "MoreAboutSection",
 CellID->11296555],
Cell[32742, 1123, 159, 3, 70, "MoreAbout",
 CellID->7369784],
Cell[32904, 1128, 151, 3, 70, "MoreAbout",
 CellID->324501337],
Cell[33058, 1133, 151, 3, 70, "MoreAbout",
 CellID->112865816],
Cell[33212, 1138, 157, 3, 70, "MoreAbout",
 CellID->664682142]
}, Open  ]],
Cell[33384, 1144, 50, 0, 70, "History"],
Cell[33437, 1146, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

