(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     30045,       1046]
NotebookOptionsPosition[     24523,        850]
NotebookOutlinePosition[     26127,        900]
CellTagsIndexPosition[     26015,        894]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Putting Expressions into Different Forms" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/PuttingExpressionsIntoDifferentForms"], 
          "Trigonometric Expressions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/TrigonometricExpressions"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Putting Expressions into Different Forms\"\>", 
       2->"\<\"Trigonometric Expressions\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"TrigExpand" :> 
          Documentation`HelpLookup["paclet:ref/TrigExpand"], "TrigReduce" :> 
          Documentation`HelpLookup["paclet:ref/TrigReduce"], "TrigToExp" :> 
          Documentation`HelpLookup["paclet:ref/TrigToExp"], "Factor" :> 
          Documentation`HelpLookup["paclet:ref/Factor"], "Simplify" :> 
          Documentation`HelpLookup["paclet:ref/Simplify"], "FullSimplify" :> 
          Documentation`HelpLookup["paclet:ref/FullSimplify"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"TrigExpand\"\>", 
       2->"\<\"TrigReduce\"\>", 3->"\<\"TrigToExp\"\>", 4->"\<\"Factor\"\>", 
       5->"\<\"Simplify\"\>", 6->"\<\"FullSimplify\"\>"}, "\<\"see also\"\>", 
       
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Algebraic Transformations" :> 
          Documentation`HelpLookup["paclet:guide/AlgebraicTransformations"], 
          "Hyperbolic Functions" :> 
          Documentation`HelpLookup["paclet:guide/HyperbolicFunctions"], 
          "Trigonometric Functions" :> 
          Documentation`HelpLookup["paclet:guide/TrigonometricFunctions"]}, #,
          2]& , Evaluator -> Automatic], {
       1->"\<\"Algebraic Transformations\"\>", 
       2->"\<\"Hyperbolic Functions\"\>", 
       3->"\<\"Trigonometric Functions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["TrigFactor", "ObjectName"], Cell[BoxData[
     TooltipBox[
      TogglerBox[Dynamic[
        FrontEnd`CurrentValue[
         FrontEnd`EvaluationNotebook[], {
         TaggingRules, "ModificationHighlight"}]], {True->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVVly2zAMDQhxEylSsizLaxJn73KafvQAuUDv/1eApJuosceeTDAWF4B8
eFgk71///HoVV1dXK3p+0wNfIzdCLL4I6p1sYBYuPy3SI2AmRBpuaE/TPRsE
3Isg8mrB9l6ILQhhLkbd93MBuwVxAthdZwPr5wVVzBc8wAvMX8TFqPkqE8q6
rDCsKPjZ/g1guz+PKvLFfGsDU1R4A8zDhgLangX9x/WGM7A1qSQ7rraYkaLf
LHZ5FWY9H7rew/n4/6vWPKT2mXFBaH/NGejzqi/VnFEFJ2Rb1Lo+jtofllPD
RVJjdZLr51Eb/ED1K+QI109LcIg+sdSIWqa5g85L6MiNoRloTws+pdBKiFGl
mx3N0jcAlcsKeFivVkteVOgMSNsC18sYS/iIMdZoK43WSdQVK1SLlYy09bZ2
aEO+aoPiACNak0EBbtfLRIz9KJRcroaSKwE11BprpRHqiJ0BrxtJG4pLYqWc
RZO4BQwSbGT4rFivaLjjQdscjSvlih48Mu+WDisOBcB5ehgeDEZQlikkKh3b
KA1FMTDg9yFxLSe4XC37begHTDh5seS1I/gaW025Yo/yUFbmSalShzon1Kch
JTNn2hKS1hyWVIkf5n2LHEQgt0zeUNTkMaYrDdkMZdo3fJCDHx7hxzAC+8rs
XYBokTPfEJk6JVlZx3Yl0UnTYMPvSUt6zghf8dhIi5VDnwO+Hcb1MHK1msK+
oy5qkYS7wVC3cfiq8ojBcMtFMJXnDiIcLPFJClDFGkJBhXGEZV6VcCQFoey7
tyvBF6lw0uKH6nyQ5fqhrKx/Kxe8+3coucpGN4U5+RYux7vnhGO5P7hKenqz
xSO3ivjisf345fg5Pt1ScCRkkzR1U1Dur+NCec4LZ49Ynx9P04GmOvlnqcKZ
79BfJfcjkg==
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlLlKQ0EYRi/iA9gpWIgvIXbjM1iKWAjW2vgeZnWN+AgWZhEULCxELFyi
ZnfJavbeJOr/33xXcj8CNnY5EA7k3GWYmTuzq+uLa2OWZS38/MYt0DbDHH8Q
8uTB64bRNrmsQkaPRoQSGX1ZqZPR9/eEazL6klIlowf8wiUZ3ecV3snowYDw
SEafUmJk9HmlQh4cX4GM7vUId2T0VFIho28or2T0w5DQIKN3PoUaGX1FaZLR
0ymh6sz7hHLk9PMzoU5Gz6SFmvFsCbd9Xzj9qyc0nfe49xfuTyYUEzoQbmh8
+N8e37HTbVpk9MSzUCajbypFMvq0UiOjzyklMnqvKzRMJCwU+/vjzemTSpns
nh97feJmd0e4cvppTKiQ0bsdoW5ecorZDgpPtD6xqFA2fp+Qp/vtdUj1v797
Oqdwnb2Ov++fUVpk9PCJUCC7n4t5wz5xj9/+rj6ceXbPP86NbEb58/k56qP+
n/0bdGyYqQ==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}], False->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVdd22zAMDUBxSaJm5HgljrPTJN177/nWh35AfqD//1aAVGrrJLbbk+BI
FEmQFxcXlDQ9//3zHNfW1gZ0/6IbbsYOhahvCGrO9qHM/mnhmMMLoKv0RD6V
cPyZHTTcDI5NkYnQq4UQ0BdiAkKYZagl1OOw5fWtcgyvPp7AnefsGG0DBIeA
9RZVrNfcwBasb4nlbP9u4cbc/XD/zXcIgC2qYYazJTQiGSYHS0Hr8Yu5LV/h
ePvR5oMOKswAQ0M8R5OloFMWSNRE+IAVeALv38KX26wAV1uU5Ojv16PQy8q+
gMP+9ABW5C9KbkZi6qv19DGc/ID9b+CrZTjbbVagH3p91oIcL+GZ6JDNUet4
HpWUXxx5BaWZxRh1FQgH6JqoKcarF/2/dblez7IE0XmWGlFL/6ygchIqCmPo
CTSmDq9SaCUUhfI7K3pKlwJESZiAveHGxoA7ESYGpM2B62WMJXzEoojRRhpt
IlFHPKFyjGRBQ2fjBG0WttpMcYIFWhNAAXaHA0+M4yiUXK6UxJWAGmKNsdII
cYGVAadTSQPKS2KkEovGc8swk2ALhg8Tww1qdrjRNmSTtOUqHDhk3jktVpwK
QOLoZngwWICyTMFTqdhHMrQTDQPeazzXdgWXK+e4KV3AhH0US1Ergo8x16QV
R5QXZWWeJJW6qLNHPWq8mEFpS0hac1pSeX4YxjlyEhmFZfKGsqaIhd+Sks+Q
0i7lhZx8cwYPmx5wrMA+yaCwyMqnRCb2IiubsF9JTKRJMeX3JKd5VoS3OEyl
xShBFxLebXrDpsfVSlv2FZ2iHMn4NBg6bZy+ihxiZvjIFWAixyeIcLDNT1KC
qogha1Gh14NB6LXpSEpC2bm3y8O3FmHniF9U55INhnttz7pZuWDu79BqFZxJ
F2bhWzjo7Zx6HMvng6ukuztzvGJXa66NmF/+crzrHe1ScmTkk/SouqB8vq42
0jl0EnuF9/RsMR1Io4U/S5Wt+A79AaDyK/w=
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlUtrE1EYhgfxBwguFBTEvyAiFhfzHxRFvC0E17rQhYLiT7D3u/gTXNg2
3sBFFyIutE1qm17UZJKZZJK0KFjBtur7Td4jnhe7dTMPhAfyQObMnO9Mjl69
fvraniAI7v/+7A3IRri7/8VGWJwHVTH72qohZp+ZBnUx+yWjJWYfHwNvxOwX
jKaYfXAAzIrZ+/tARcw+NAhKYvaTRiJmP2gUxH+vLxKzl5cMMXtfL3gvZn84
Cdpi9hvGJzH7yxegJWa/YnTE7Mtl0HTPfZ/xyPWVZZCGvQ/Au65fSV9aNMLJ
CfDW9a0fIBWz/9wBHbcOf/74PX83W99j128ZNTH71BMQidmfFkAiZj9irIvZ
Fz+AWMx+yEjF7KeMVOw/32x/iuHoCHjt+s42aIfTU6DWna/Prm9vgVb4cc0I
h4fAgusZ62L2A0YsZj9h1MX+9bN9LHfP75zrZ42a2L9/3+wXjVTM7q8jm9NE
5q8wA+JwoB/8eX+eNxIx+00jErP3GA2xvy7uG88R+z2jI2Y/bLTE/v1l76WG
mxP/+r7ZN7+Bupj9mFERsz9/Bppi9myeEzH7QgnUxOy3jYaY/a7RFrNfNtpi
9nNGXcw+NgoaYnbOk2///PJ/bXXFcP37JojF7CPDIBazf/0CKmL2+TlQEbPf
MZpi9olxkIrZS0UQidn3G1Ux+3EjErOfMapi9mBX8p73vOc973n/P/0XnFJ2
Rg==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}]}, "\"\<Click me\>\""],
      "Toggle changes in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["TrigFactor",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/TrigFactor"], "[", 
       StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]factors trigonometric functions in ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->7030]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TrigFactor",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TrigFactor"]], "InlineFormula"],
 " operates on both circular and hyperbolic functions. "
}], "Notes",
 CellID->18138],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TrigFactor",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TrigFactor"]], "InlineFormula"],
 " splits up sums and integer multiples that appear in arguments of \
trigonometric functions, and then factors resulting polynomials in \
trigonometric functions, using trigonometric identities when possible. "
}], "Notes",
 CellID->24932],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TrigFactor",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TrigFactor"]], "InlineFormula"],
 " automatically threads over lists, as well as equations, inequalities and \
logic functions."
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->82730543]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->785915952],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->64680115],

Cell["Factor into a product of terms:", "ExampleText",
 CellID->22219],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TrigFactor", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Sin", "[", "x", "]"}], "^", "2"}], "+", 
   RowBox[{
    RowBox[{"Tan", "[", "x", "]"}], "^", "2"}]}], "]"}]], "Input",
 CellTags->"CellTags",
 CellLabel->"In[1]:=",
 CellID->9818],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "2"], " ", 
  RowBox[{"(", 
   RowBox[{"3", "+", 
    RowBox[{"Cos", "[", 
     RowBox[{"2", " ", "x"}], "]"}]}], ")"}], " ", 
  SuperscriptBox[
   RowBox[{"Tan", "[", "x", "]"}], "2"]}]], "Output",
 ImageSize->{155, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"CellTags",
 CellLabel->"Out[1]=",
 CellID->560389704]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->28646],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TrigFactor", "[", 
  RowBox[{
   RowBox[{"Cos", "[", 
    RowBox[{"x", "+", "y"}], "]"}], "+", 
   RowBox[{
    RowBox[{"Sin", "[", "x", "]"}], 
    RowBox[{"Sin", "[", "y", "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->41],

Cell[BoxData[
 RowBox[{
  RowBox[{"Cos", "[", "x", "]"}], " ", 
  RowBox[{"Cos", "[", "y", "]"}]}]], "Output",
 ImageSize->{91, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->349698754]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TrigFactor", "[", 
  RowBox[{
   RowBox[{"Sin", "[", "x", "]"}], "+", 
   RowBox[{"Cos", "[", "x", "]"}]}], "]"}]], "Input",
 CellTags->"CellTags",
 CellLabel->"In[2]:=",
 CellID->6718],

Cell[BoxData[
 RowBox[{
  SqrtBox["2"], " ", 
  RowBox[{"Sin", "[", 
   RowBox[{
    FractionBox["\[Pi]", "4"], "+", "x"}], "]"}]}]], "Output",
 ImageSize->{98, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->"CellTags",
 CellLabel->"Out[2]=",
 CellID->79480062]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->168923],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TrigFactor",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TrigFactor"]], "InlineFormula"],
 " operates on hyperbolic trigonometric functions:"
}], "ExampleText",
 CellID->78216613],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TrigFactor", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Cosh", "[", "x", "]"}], "^", "2"}], "-", 
   RowBox[{
    RowBox[{"Cosh", "[", "x", "]"}], "^", "4"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->643954209],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   SuperscriptBox[
    RowBox[{"Cosh", "[", "x", "]"}], "2"]}], " ", 
  SuperscriptBox[
   RowBox[{"Sinh", "[", "x", "]"}], "2"]}]], "Output",
 ImageSize->{124, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->154223502]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->9033],

Cell["Solve a trigonometric polynomial equation:", "ExampleText",
 CellID->2529272],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TrigFactor", "[", 
  RowBox[{
   RowBox[{
    SuperscriptBox[
     RowBox[{"Cos", "[", "x", "]"}], "3"], "+", 
    RowBox[{"3", " ", 
     SuperscriptBox[
      RowBox[{"Cos", "[", "x", "]"}], "2"], " ", 
     RowBox[{"Sin", "[", "x", "]"}]}], "+", 
    RowBox[{"3", " ", 
     RowBox[{"Cos", "[", "x", "]"}], " ", 
     SuperscriptBox[
      RowBox[{"Sin", "[", "x", "]"}], "2"]}], "+", 
    SuperscriptBox[
     RowBox[{"Sin", "[", "x", "]"}], "3"]}], "\[Equal]", "2"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->95275887],

Cell[BoxData[
 RowBox[{
  RowBox[{"2", " ", 
   SqrtBox["2"], " ", 
   SuperscriptBox[
    RowBox[{"Sin", "[", 
     RowBox[{
      FractionBox["\[Pi]", "4"], "+", "x"}], "]"}], "3"]}], "\[Equal]", 
  "2"}]], "Output",
 ImageSize->{138, 29},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->772352009]
}, Open  ]],

Cell["Reduce it to elementary trigonometric equations:", "ExampleText",
 CellID->682352226],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{"%", ",", 
   RowBox[{"Sin", "[", 
    RowBox[{
     RowBox[{"Pi", "/", "4"}], "+", "x"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->132729679],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{
     FractionBox["\[Pi]", "4"], "+", "x"}], "]"}], "\[Equal]", 
   FractionBox["1", 
    SuperscriptBox["2", 
     RowBox[{"1", "/", "6"}]]]}], "||", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{
     FractionBox["\[Pi]", "4"], "+", "x"}], "]"}], "\[Equal]", 
   RowBox[{"-", 
    FractionBox[
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"-", "1"}], ")"}], 
      RowBox[{"1", "/", "3"}]], 
     SuperscriptBox["2", 
      RowBox[{"1", "/", "6"}]]]}]}], "||", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{
     FractionBox["\[Pi]", "4"], "+", "x"}], "]"}], "\[Equal]", 
   FractionBox[
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"-", "1"}], ")"}], 
     RowBox[{"2", "/", "3"}]], 
    SuperscriptBox["2", 
     RowBox[{"1", "/", "6"}]]]}]}]], "Output",
 ImageSize->{426, 34},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->184743825]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->14672],

Cell[TextData[{
 "Compare ",
 Cell[BoxData[
  ButtonBox["TrigExpand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TrigExpand"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["TrigReduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TrigReduce"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["TrigFactor",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TrigFactor"]], "InlineFormula"],
 " on the same expression:"
}], "ExampleText",
 CellID->318729833],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TrigFactor", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Sin", "[", "x", "]"}], "^", "2"}], "+", 
   RowBox[{
    RowBox[{"Tan", "[", "x", "]"}], "^", "2"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->23281],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "2"], " ", 
  RowBox[{"(", 
   RowBox[{"3", "+", 
    RowBox[{"Cos", "[", 
     RowBox[{"2", " ", "x"}], "]"}]}], ")"}], " ", 
  SuperscriptBox[
   RowBox[{"Tan", "[", "x", "]"}], "2"]}]], "Output",
 ImageSize->{155, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->84510512]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TrigExpand", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Sin", "[", "x", "]"}], "^", "2"}], "+", 
   RowBox[{
    RowBox[{"Tan", "[", "x", "]"}], "^", "2"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->26962],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox["1", "2"]}], "-", 
  FractionBox[
   SuperscriptBox[
    RowBox[{"Cos", "[", "x", "]"}], "2"], "8"], "+", 
  FractionBox[
   RowBox[{"5", " ", 
    SuperscriptBox[
     RowBox[{"Sec", "[", "x", "]"}], "2"]}], "8"], "+", 
  FractionBox[
   RowBox[{"3", " ", 
    SuperscriptBox[
     RowBox[{"Sin", "[", "x", "]"}], "2"]}], "4"], "+", 
  FractionBox[
   SuperscriptBox[
    RowBox[{"Tan", "[", "x", "]"}], "2"], "2"], "-", 
  RowBox[{
   FractionBox["1", "8"], " ", 
   SuperscriptBox[
    RowBox[{"Sin", "[", "x", "]"}], "2"], " ", 
   SuperscriptBox[
    RowBox[{"Tan", "[", "x", "]"}], "2"]}]}]], "Output",
 ImageSize->{425, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->832117660]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TrigReduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Sin", "[", "x", "]"}], "^", "2"}], "+", 
   RowBox[{
    RowBox[{"Tan", "[", "x", "]"}], "^", "2"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->5705],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "8"], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"5", " ", 
     SuperscriptBox[
      RowBox[{"Sec", "[", "x", "]"}], "2"]}], "-", 
    RowBox[{"4", " ", 
     RowBox[{"Cos", "[", 
      RowBox[{"2", " ", "x"}], "]"}], " ", 
     SuperscriptBox[
      RowBox[{"Sec", "[", "x", "]"}], "2"]}], "-", 
    RowBox[{
     RowBox[{"Cos", "[", 
      RowBox[{"4", " ", "x"}], "]"}], " ", 
     SuperscriptBox[
      RowBox[{"Sec", "[", "x", "]"}], "2"]}]}], ")"}]}]], "Output",
 ImageSize->{330, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->221573420]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->145221788],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TrigFactor",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TrigFactor"]], "InlineFormula"],
 " threads element\[Hyphen]wise over lists, inequalities, equations and \
logical operations:"
}], "ExampleText",
 CellID->9322563],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TrigFactor", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Sin", "[", "x", "]"}], "+", 
    RowBox[{"Cos", "[", "x", "]"}]}], "\[Equal]", "0"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->172258685],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SqrtBox["2"], " ", 
   RowBox[{"Sin", "[", 
    RowBox[{
     FractionBox["\[Pi]", "4"], "+", "x"}], "]"}]}], "\[Equal]", 
  "0"}]], "Output",
 ImageSize->{122, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->274981985]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->8579],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["TrigExpand",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TrigExpand"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["TrigReduce",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TrigReduce"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["TrigToExp",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TrigToExp"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Factor",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Factor"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Simplify",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Simplify"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FullSimplify",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FullSimplify"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->31673]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->7001],

Cell[TextData[ButtonBox["Putting Expressions into Different Forms",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/PuttingExpressionsIntoDifferentForms"]], "Tutorials",
 CellID->29102],

Cell[TextData[ButtonBox["Trigonometric Expressions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/TrigonometricExpressions"]], "Tutorials",
 CellID->16191]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->1014632065],

Cell[TextData[ButtonBox["Algebraic Transformations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/AlgebraicTransformations"]], "MoreAbout",
 CellID->657757100],

Cell[TextData[ButtonBox["Hyperbolic Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/HyperbolicFunctions"]], "MoreAbout",
 CellID->13247897],

Cell[TextData[ButtonBox["Trigonometric Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/TrigonometricFunctions"]], "MoreAbout",
 CellID->676503825]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["NKS|Online",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/index/search.cgi?SearchIndex=\
TrigFactor"], None}],
 " (",
 StyleBox[ButtonBox["A New Kind of Science",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/"], None}],
  FontSlant->"Italic"],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell["New in 3  |  Last modified in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"TrigFactor - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 27, 53.0998848}", "context" -> "System`", 
    "keywords" -> {"factoring"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "TrigFactor[expr] factors trigonometric functions in expr. ", 
    "synonyms" -> {"trig factor"}, "title" -> "TrigFactor", "type" -> 
    "Symbol", "uri" -> "ref/TrigFactor"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[9770, 251, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->785915952]},
 "CellTags"->{
  Cell[10400, 277, 259, 9, 28, "Input",
   CellTags->"CellTags",
   CellID->9818],
  Cell[10662, 288, 395, 14, 51, "Output",
   CellTags->"CellTags",
   CellID->560389704],
  Cell[11888, 343, 209, 7, 70, "Input",
   CellTags->"CellTags",
   CellID->6718],
  Cell[12100, 352, 295, 11, 49, "Output",
   CellTags->"CellTags",
   CellID->79480062]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 25511, 874},
 {"CellTags", 25646, 878}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2831, 63, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3454, 90, 4194, 83, 70, "ObjectNameGrid"],
Cell[7651, 175, 562, 18, 70, "Usage",
 CellID->7030]
}, Open  ]],
Cell[CellGroupData[{
Cell[8250, 198, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[8728, 215, 224, 7, 70, "Notes",
 CellID->18138],
Cell[8955, 224, 379, 9, 70, "Notes",
 CellID->24932],
Cell[9337, 235, 396, 11, 70, "Notes",
 CellID->82730543]
}, Closed]],
Cell[CellGroupData[{
Cell[9770, 251, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->785915952],
Cell[CellGroupData[{
Cell[10155, 265, 147, 5, 70, "ExampleSection",
 CellID->64680115],
Cell[10305, 272, 70, 1, 70, "ExampleText",
 CellID->22219],
Cell[CellGroupData[{
Cell[10400, 277, 259, 9, 28, "Input",
 CellTags->"CellTags",
 CellID->9818],
Cell[10662, 288, 395, 14, 51, "Output",
 CellTags->"CellTags",
 CellID->560389704]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[11106, 308, 216, 7, 70, "ExampleSection",
 CellID->28646],
Cell[CellGroupData[{
Cell[11347, 319, 261, 9, 70, "Input",
 CellID->41],
Cell[11611, 330, 240, 8, 36, "Output",
 CellID->349698754]
}, Open  ]],
Cell[CellGroupData[{
Cell[11888, 343, 209, 7, 70, "Input",
 CellTags->"CellTags",
 CellID->6718],
Cell[12100, 352, 295, 11, 49, "Output",
 CellTags->"CellTags",
 CellID->79480062]
}, Open  ]],
Cell[12410, 366, 122, 3, 70, "ExampleDelimiter",
 CellID->168923],
Cell[12535, 371, 228, 7, 70, "ExampleText",
 CellID->78216613],
Cell[CellGroupData[{
Cell[12788, 382, 243, 8, 70, "Input",
 CellID->643954209],
Cell[13034, 392, 313, 11, 36, "Output",
 CellID->154223502]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[13396, 409, 222, 7, 70, "ExampleSection",
 CellID->9033],
Cell[13621, 418, 83, 1, 70, "ExampleText",
 CellID->2529272],
Cell[CellGroupData[{
Cell[13729, 423, 558, 18, 70, "Input",
 CellID->95275887],
Cell[14290, 443, 349, 13, 50, "Output",
 CellID->772352009]
}, Open  ]],
Cell[14654, 459, 91, 1, 70, "ExampleText",
 CellID->682352226],
Cell[CellGroupData[{
Cell[14770, 464, 208, 7, 70, "Input",
 CellID->132729679],
Cell[14981, 473, 983, 36, 55, "Output",
 CellID->184743825]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[16013, 515, 233, 7, 70, "ExampleSection",
 CellID->14672],
Cell[16249, 524, 481, 18, 70, "ExampleText",
 CellID->318729833],
Cell[CellGroupData[{
Cell[16755, 546, 237, 8, 70, "Input",
 CellID->23281],
Cell[16995, 556, 371, 13, 51, "Output",
 CellID->84510512]
}, Open  ]],
Cell[CellGroupData[{
Cell[17403, 574, 237, 8, 70, "Input",
 CellID->26962],
Cell[17643, 584, 794, 28, 54, "Output",
 CellID->832117660]
}, Open  ]],
Cell[CellGroupData[{
Cell[18474, 617, 236, 8, 70, "Input",
 CellID->5705],
Cell[18713, 627, 647, 22, 51, "Output",
 CellID->221573420]
}, Open  ]],
Cell[19375, 652, 125, 3, 70, "ExampleDelimiter",
 CellID->145221788],
Cell[19503, 657, 270, 8, 70, "ExampleText",
 CellID->9322563],
Cell[CellGroupData[{
Cell[19798, 669, 224, 7, 70, "Input",
 CellID->172258685],
Cell[20025, 678, 311, 12, 49, "Output",
 CellID->274981985]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[20397, 697, 310, 9, 70, "SeeAlsoSection",
 CellID->8579],
Cell[20710, 708, 1445, 53, 70, "SeeAlso",
 CellID->31673]
}, Open  ]],
Cell[CellGroupData[{
Cell[22192, 766, 313, 9, 70, "TutorialsSection",
 CellID->7001],
Cell[22508, 777, 190, 4, 70, "Tutorials",
 CellID->29102],
Cell[22701, 783, 160, 3, 70, "Tutorials",
 CellID->16191]
}, Open  ]],
Cell[CellGroupData[{
Cell[22898, 791, 320, 9, 70, "MoreAboutSection",
 CellID->1014632065],
Cell[23221, 802, 161, 3, 70, "MoreAbout",
 CellID->657757100],
Cell[23385, 807, 150, 3, 70, "MoreAbout",
 CellID->13247897],
Cell[23538, 812, 157, 3, 70, "MoreAbout",
 CellID->676503825]
}, Open  ]],
Cell[CellGroupData[{
Cell[23732, 820, 305, 8, 70, "RelatedLinksSection"],
Cell[24040, 830, 388, 13, 70, "RelatedLinks"]
}, Open  ]],
Cell[24443, 846, 50, 0, 70, "History"],
Cell[24496, 848, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

