(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     22777,        732]
NotebookOptionsPosition[     19233,        625]
NotebookOutlinePosition[     20975,        669]
CellTagsIndexPosition[     20890,        664]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Introduction to Dynamic" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/IntroductionToDynamic"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Introduction to Dynamic\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Animator" :> Documentation`HelpLookup["paclet:ref/Animator"], 
          "Manipulator" :> Documentation`HelpLookup["paclet:ref/Manipulator"],
           "Setter" :> Documentation`HelpLookup["paclet:ref/Setter"], 
          "Button" :> Documentation`HelpLookup["paclet:ref/Button"], 
          "EmitSound" :> Documentation`HelpLookup["paclet:ref/EmitSound"], 
          "Manipulate" :> 
          Documentation`HelpLookup["paclet:ref/Manipulate"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Animator\"\>", 
       2->"\<\"Manipulator\"\>", 3->"\<\"Setter\"\>", 4->"\<\"Button\"\>", 
       5->"\<\"EmitSound\"\>", 6->"\<\"Manipulate\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Control Objects" :> 
          Documentation`HelpLookup["paclet:guide/ControlObjects"], 
          "Interactive Manipulation" :> 
          Documentation`HelpLookup[
           "paclet:guide/InteractiveManipulation"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Control Objects\"\>", 
       2->"\<\"Interactive Manipulation\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["Trigger", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Trigger",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Trigger"], "[", 
       RowBox[{
        ButtonBox["Dynamic",
         BaseStyle->"Link",
         ButtonData->"paclet:ref/Dynamic"], "[", 
        StyleBox["u", "TI"], "]"}], "]"}]], "InlineFormula"],
     "\[LineSeparator]represents a trigger that can be pressed to make the \
dynamically updated value of ",
     Cell[BoxData[
      StyleBox["u", "TI"]], "InlineFormula"],
     " be continually increased with time from 0 to 1. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Trigger",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Trigger"], "[", 
       RowBox[{
        RowBox[{
         ButtonBox["Dynamic",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/Dynamic"], "[", 
         StyleBox["u", "TI"], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["u", "TI"], 
           StyleBox["min", "TI"]], ",", 
          SubscriptBox[
           StyleBox["u", "TI"], 
           StyleBox["max", "TI"]]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]makes ",
     Cell[BoxData[
      StyleBox["u", "TI"]], "InlineFormula"],
     " vary from ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["u", "TI"], 
       StyleBox["min", "TI"]]], "InlineFormula"],
     " to ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["u", "TI"], 
       StyleBox["max", "TI"]]], "InlineFormula"],
     " when triggered. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Trigger",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Trigger"], "[", 
       RowBox[{
        RowBox[{
         ButtonBox["Dynamic",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/Dynamic"], "[", 
         StyleBox["u", "TI"], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["u", "TI"], 
           StyleBox["min", "TI"]], ",", 
          SubscriptBox[
           StyleBox["u", "TI"], 
           StyleBox["max", "TI"]], ",", 
          StyleBox["du", "TI"]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]makes ",
     Cell[BoxData[
      StyleBox["u", "TI"]], "InlineFormula"],
     " vary in steps ",
     Cell[BoxData[
      StyleBox["du", "TI"]], "InlineFormula"],
     " when triggered. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Trigger",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Trigger"], "[", 
       RowBox[{
        RowBox[{
         ButtonBox["Dynamic",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/Dynamic"], "[", 
         StyleBox["u", "TI"], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["u", "TI"], 
           StyleBox["min", "TI"]], ",", 
          SubscriptBox[
           StyleBox["u", "TI"], 
           StyleBox["max", "TI"]]}], "}"}], ",", 
        StyleBox["ups", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]makes the value of ",
     Cell[BoxData[
      StyleBox["u", "TI"]], "InlineFormula"],
     " increase at a rate of ",
     Cell[BoxData[
      StyleBox["ups", "TI"]], "InlineFormula"],
     " units per second when triggered. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->27692]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "In ",
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ControlType",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ControlType"], "->", "Trigger"}]], 
  "InlineFormula"],
 " specifies that a particular variable should be controlled by a trigger. "
}], "Notes",
 CellID->1067943069],

Cell["\<\
The default duration after triggering for a variable to go through its range \
is 5 seconds. \
\>", "Notes",
 CellID->25293],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Trigger",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Trigger"], "[", 
   RowBox[{
    RowBox[{
     ButtonBox["Dynamic",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Dynamic"], "[", 
     StyleBox["u", "TI"], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["u", "TI"], 
       StyleBox["min", "TI"]], ",", 
      ButtonBox["Infinity",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Infinity"]}], "}"}]}], "]"}]], 
  "InlineFormula"],
 " runs forever after being triggered, with ",
 Cell[BoxData[
  StyleBox["u", "TI"]], "InlineFormula"],
 " increasing by 1 every second. "
}], "Notes",
 CellID->7717],

Cell["The following options can be given: ", "Notes",
 CellID->3943],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["AnimationRate",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/AnimationRate"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "the rate at which to take variables to vary", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["AnimationRepetitions",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/AnimationRepetitions"], "1", Cell[
    "how many times to run before stopping", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Appearance",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Appearance"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "the overall appearance of the trigger object ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["AppearanceElements",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/AppearanceElements"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "elements to include in the displayed trigger ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Exclusions",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Exclusions"], 
    RowBox[{"{", "}"}], Cell[TextData[{
     "specific ",
     Cell[BoxData[
      StyleBox["u", "TI"]], "InlineFormula"],
     " values to exclude"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["DefaultDuration",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/DefaultDuration"], "5.", Cell[
    "the default duration in seconds ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["DisplayAllSteps",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/DisplayAllSteps"], 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell[
    "whether to force all discrete steps to be displayed ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Enabled",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Enabled"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "whether the trigger is enabled, or grayed out ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ImageMargins",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ImageMargins"], "0", Cell[
    "margins around the image of the displayed trigger ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ImageSize",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ImageSize"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "the overall image size of the displayed trigger ", "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, None, None, None, None, None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{
     True, True, True, True, True, True, True, True, True, True, True}}}},
 CellID->17893],

Cell[TextData[{
 "The following elements are included in a default trigger: ",
 Cell[BoxData["\"\<TriggerButton\>\""], "InlineFormula"],
 ", ",
 Cell[BoxData["\"\<PauseButton\>\""], "InlineFormula"],
 ", ",
 Cell[BoxData["\"\<ResetButton\>\""], "InlineFormula"],
 ".",
 " ",
 "These elements can be specified in any order in a list given as the setting \
for ",
 Cell[BoxData[
  ButtonBox["AppearanceElements",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AppearanceElements"]], "InlineFormula"],
 ". Additional possible elements include all the appearance elements for ",
 Cell[BoxData[
  ButtonBox["Animator",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Animator"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->10118849]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->724498043],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->159340999],

Cell["Dynamically trigger a variable update:", "ExampleText",
 CellID->982437217],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Trigger", "[", 
    RowBox[{"Dynamic", "[", "x", "]"}], "]"}], ",", 
   RowBox[{"Dynamic", "[", "x", "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->305245641],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   AnimatorBox[Dynamic[$CellContext`x], {0, 1},
    AnimationRepetitions->1,
    AppearanceElements->{"ResetPlayButton", "PauseButton", "ResetButton"},
    DefaultBaseStyle->{},
    PausedTime->0.], ",", 
   DynamicBox[ToBoxes[$CellContext`x, StandardForm],
    ImageSizeCache->{7., {0., 6.}}]}], "}"}]], "Output",
 ImageSize->{102, 25},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->57018594]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Animator",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Animator"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Manipulator",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Manipulator"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Setter",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Setter"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Button",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Button"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["EmitSound",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/EmitSound"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Manipulate",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Manipulate"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->250839057],

Cell[TextData[ButtonBox["Introduction to Dynamic",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/IntroductionToDynamic"]], "Tutorials",
 CellID->445434225]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["Demonstrations with Trigger",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=Trigger"], 
    None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Control Objects",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ControlObjects"]], "MoreAbout",
 CellID->448412090],

Cell[TextData[ButtonBox["Interactive Manipulation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/InteractiveManipulation"]], "MoreAbout",
 CellID->218226671]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Trigger - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 27, 53.4436436}", "context" -> "System`", 
    "keywords" -> {
     "clock", "trigger", "synchronizing variable", "triggering variable", 
      "clocked variable", "trigger signal", "synchronizing signal", 
      "clocked signal"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Trigger[Dynamic[u]] represents a trigger that can be pressed to make the \
dynamically updated value of u be continually increased with time from 0 to \
1. Trigger[Dynamic[u], {u_min, u_max}] makes u vary from u_min to u_max when \
triggered. Trigger[Dynamic[u], {u_min, u_max, du}] makes u vary in steps du \
when triggered. Trigger[Dynamic[u], {u_min, u_max}, ups] makes the value of u \
increase at a rate of ups units per second when triggered. ", 
    "synonyms" -> {}, "title" -> "Trigger", "type" -> "Symbol", "uri" -> 
    "ref/Trigger"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[14129, 429, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->724498043]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 20746, 657}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2407, 56, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3030, 83, 1572, 37, 70, "ObjectNameGrid"],
Cell[4605, 122, 3597, 116, 70, "Usage",
 CellID->27692]
}, Open  ]],
Cell[CellGroupData[{
Cell[8239, 243, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[8717, 260, 425, 15, 70, "Notes",
 CellID->1067943069],
Cell[9145, 277, 134, 4, 70, "Notes",
 CellID->25293],
Cell[9282, 283, 717, 26, 70, "Notes",
 CellID->7717],
Cell[10002, 311, 68, 1, 70, "Notes",
 CellID->3943],
Cell[10073, 314, 3284, 86, 70, "3ColumnTableMod",
 CellID->17893],
Cell[13360, 402, 732, 22, 70, "Notes",
 CellID->10118849]
}, Closed]],
Cell[CellGroupData[{
Cell[14129, 429, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->724498043],
Cell[CellGroupData[{
Cell[14514, 443, 148, 5, 70, "ExampleSection",
 CellID->159340999],
Cell[14665, 450, 81, 1, 70, "ExampleText",
 CellID->982437217],
Cell[CellGroupData[{
Cell[14771, 455, 221, 7, 28, "Input",
 CellID->305245641],
Cell[14995, 464, 484, 14, 46, "Output",
 CellID->57018594]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[15540, 485, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[15859, 496, 1439, 53, 70, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[17335, 554, 318, 9, 70, "TutorialsSection",
 CellID->250839057],
Cell[17656, 565, 159, 3, 70, "Tutorials",
 CellID->445434225]
}, Open  ]],
Cell[CellGroupData[{
Cell[17852, 573, 305, 8, 70, "RelatedLinksSection"],
Cell[18160, 583, 359, 12, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[18556, 600, 299, 8, 70, "MoreAboutSection"],
Cell[18858, 610, 141, 3, 70, "MoreAbout",
 CellID->448412090],
Cell[19002, 615, 159, 3, 70, "MoreAbout",
 CellID->218226671]
}, Open  ]],
Cell[19176, 621, 27, 0, 70, "History"],
Cell[19206, 623, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

