(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    222882,       4986]
NotebookOptionsPosition[    212283,       4605]
NotebookOutlinePosition[    213709,       4645]
CellTagsIndexPosition[    213622,       4640]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Grouping and Combining Elements of Lists" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/GroupingAndCombiningElementsOfLists"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Grouping and Combining Elements of Lists\"\>"}, "\<\"tutorials\
\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Outer" :> Documentation`HelpLookup["paclet:ref/Outer"], 
          "Array" :> Documentation`HelpLookup["paclet:ref/Array"], 
          "IntegerDigits" :> 
          Documentation`HelpLookup["paclet:ref/IntegerDigits"], 
          "Permutations" :> 
          Documentation`HelpLookup["paclet:ref/Permutations"], "Subsets" :> 
          Documentation`HelpLookup["paclet:ref/Subsets"], "Distribute" :> 
          Documentation`HelpLookup["paclet:ref/Distribute"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Outer\"\>", 2->"\<\"Array\"\>", 
       3->"\<\"IntegerDigits\"\>", 4->"\<\"Permutations\"\>", 
       5->"\<\"Subsets\"\>", 6->"\<\"Distribute\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Constructing Lists" :> 
          Documentation`HelpLookup["paclet:guide/ConstructingLists"], 
          "Discrete Mathematics" :> 
          Documentation`HelpLookup["paclet:guide/DiscreteMathematics"], 
          "List Manipulation" :> 
          Documentation`HelpLookup["paclet:guide/ListManipulation"], 
          "Rearranging & Restructuring Lists" :> 
          Documentation`HelpLookup[
           "paclet:guide/RearrangingAndRestructuringLists"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Constructing Lists\"\>", 
       2->"\<\"Discrete Mathematics\"\>", 3->"\<\"List Manipulation\"\>", 
       4->"\<\"Rearranging & Restructuring Lists\"\>"}, "\<\"more about\"\>", 
       
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Tuples", "ObjectName",
 CellID->12154],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Tuples",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Tuples"], "[", 
       RowBox[{
        StyleBox["list", "TI"], ",", 
        StyleBox["n", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]generates a list of all possible ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     "\[Hyphen]tuples of elements from ",
     Cell[BoxData[
      StyleBox["list", "TI"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Tuples",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Tuples"], "[", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox[
          StyleBox["list", "TI"], 
          StyleBox["1", "TR"]], ",", 
         SubscriptBox[
          StyleBox["list", "TI"], 
          StyleBox["2", "TR"]], ",", 
         StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}]], "InlineFormula"],
     "\[LineSeparator]generates a list of all possible tuples whose ",
     Cell[BoxData[
      StyleBox["i", "TI"]], "InlineFormula"],
     Cell[BoxData[
      FormBox[
       RowBox[{"\[Null]", 
        SuperscriptBox["\[Null]", "th"]}], TraditionalForm]]],
     " element is from ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["list", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->16094]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The elements of ",
 Cell[BoxData[
  StyleBox["list", "TI"]], "InlineFormula"],
 " are treated as distinct, so that ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Tuples",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Tuples"], "[", 
   RowBox[{
    StyleBox["list", "TI"], ",", 
    StyleBox["n", "TI"]}], "]"}]], "InlineFormula"],
 " for a list of length ",
 Cell[BoxData[
  StyleBox["k", "TI"]], "InlineFormula"],
 " gives output of length ",
 Cell[BoxData[
  SuperscriptBox[
   StyleBox["k", "TI"], 
   StyleBox["n", "TI"]]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->23513],

Cell[TextData[{
 "The order of elements in ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Tuples",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Tuples"], "[", 
   RowBox[{
    StyleBox["list", "TI"], ",", 
    StyleBox["n", "TI"]}], "]"}]], "InlineFormula"],
 " is based on the order of elements in ",
 Cell[BoxData[
  StyleBox["list", "TI"]], "InlineFormula"],
 ", so that ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Tuples",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Tuples"], "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["a", "TI"], 
       StyleBox["1", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"], ",", 
      SubscriptBox[
       StyleBox["a", "TI"], 
       StyleBox["k", "TI"]]}], "}"}], ",", 
    StyleBox["n", "TI"]}], "]"}]], "InlineFormula"],
 " gives ",
 Cell[BoxData[
  FormBox[
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["a", "1"], ",", 
       SubscriptBox["a", "1"], ",", "\[Ellipsis]", ",", 
       SubscriptBox["a", "1"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["a", "1"], ",", 
       SubscriptBox["a", "1"], ",", "\[Ellipsis]", ",", 
       SubscriptBox["a", "2"]}], "}"}], ",", "\[Ellipsis]", ",", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["a", "k"], ",", 
       SubscriptBox["a", "k"], ",", "\[Ellipsis]", ",", 
       SubscriptBox["a", "k"]}], "}"}]}], "}"}], TraditionalForm]], 
  "InlineMath"],
 ". "
}], "Notes",
 CellID->18538],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Tuples",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Tuples"], "[", 
   RowBox[{
    StyleBox["list", "TI"], ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["n", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["n", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula", 
  "TemplateInclusion"],
 " generates a list of all possible ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["n", "1"], "\[Cross]", 
    SubscriptBox["n", "2"], "\[Cross]", "\[Ellipsis]"}], TraditionalForm]], 
  "InlineMath"],
 " arrays of elements in ",
 Cell[BoxData[
  StyleBox["list", "TI"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->2398],

Cell[TextData[{
 "The object ",
 Cell[BoxData[
  StyleBox["list", "TI"]], "InlineFormula"],
 " need not have head ",
 Cell[BoxData[
  ButtonBox["List",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/List"]], "InlineFormula"],
 ". The head at each level in the arrays generated by ",
 Cell[BoxData[
  ButtonBox["Tuples",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Tuples"]], "InlineFormula"],
 " will be the same as the head of ",
 Cell[BoxData[
  StyleBox["list", "TI"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->32505]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->97036708],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->383742161],

Cell[TextData[{
 "All possible 3-tuples of ",
 Cell[BoxData["0"], "InlineFormula"],
 " and ",
 Cell[BoxData["1"], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->30600],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Tuples", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "1"}], "}"}], ",", "3"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->23498],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "1"}], "}"}]}], "}"}]], "Output",
 ImageSize->{556, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->647257171]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->141],

Cell["The first element given is always picked first:", "ExampleText",
 CellID->7925],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Tuples", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "0"}], "}"}], ",", "3"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->27840],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]], "Output",
 ImageSize->{556, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1446600942]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->9009],

Cell["All ways of picking one element from each list:", "ExampleText",
 CellID->23656],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Tuples", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"a", ",", "b"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "3", ",", "4"}], "}"}], ",", 
    RowBox[{"{", "x", "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->23443],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "1", ",", "x"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "2", ",", "x"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "3", ",", "x"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "4", ",", "x"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b", ",", "1", ",", "x"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b", ",", "2", ",", "x"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b", ",", "3", ",", "x"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b", ",", "4", ",", "x"}], "}"}]}], "}"}]], "Output",
 ImageSize->{556, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1359664507]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->3458],

Cell["Each occurrence of an element is picked separately:", "ExampleText",
 CellID->24079],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Tuples", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b"}], "}"}], ",", "2"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->21288],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "a"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b", ",", "a"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b", ",", "b"}], "}"}]}], "}"}]], "Output",
 ImageSize->{209, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->411827773]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Tuples", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "a", ",", "b"}], "}"}], ",", "2"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->18300],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "a"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "a"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "a"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "a"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b", ",", "a"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b", ",", "a"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b", ",", "b"}], "}"}]}], "}"}]], "Output",
 ImageSize->{461, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->376513265]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->24654],

Cell[TextData[{
 "All possible 2x2 arrays formed from ",
 Cell[BoxData[
  StyleBox["a", "TI"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  StyleBox["b", "TI"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->9067],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Tuples", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->26930],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztnG1vEzEMx6+9lhXGHph4MUBI+y5I8IoPUU2TthcINPY54SOVy7WbOi+p
7cRO3OJKnS652P7bTe7pp9v35cPtzY/lw9318urb/fLX7d3176uvP++Hrn7S
dZM/Xdd9ueyG7dWwNX7D5+/wXW+ut47D3/5x76qbgfZr0D5Dxr8ptMf8leqD
+VrTh9Xv3Lg+bv368AdVGfZPh+a7iHXoh/ap8bHoMXtufDirasdP5X/ROD6W
P2xPV8nZMHtqD5/50JiDUfNEP4yxiOQQ7HrQf5Tox3KA/mXVw/WWUk/1V1f9
guRtYbLyNO25dd8x8+Go+baGYXscFVbbUXIv9BlGw5kk5ZsSSzMvWMNDyYv3
ey0ONK/83+vlasOy7KOxTqK9cL2fCPqCuqBvSd2ne6qbVu/TPdWdV2/Ynox2
eeeYuAJoC6/+QzazTd1nhHWK3T2UaIN3To/aaNY1lULfcV9nBmpKU5pX4fwr
pHCemIL+40Q/bGtmRPklSrTDGZ7WTvFWW32s8jG7tyZrT1VP9Sd4v7C5Z+nG
z+mLHngWiR3D+83xpo+MzzreMDXFjt09ybKGuugx45nFecPa4er4VSyYjTuU
vUL2f5aoHiM+nHXvkfHaeqK/5Fb7gzE9mD1tVmGEYrpZX093h1v74PPHT4gv
7HnlrljwWetFYpxkTGgbxnysHC81lvbkP2xCJsXfcoplS59TrFRUp1iHR7Ee
7cf+THpFpU026RU1mk16xaq9MXolq93pFSWWZl5Or5xepWKtrzKcWjm12g/d
efUe137muSTFmdpwqZR3CySKWqkW7KlMW14Vx6NqEV1qS8tK+AafndohS3lV
t8GV5LTnUiX6rH/OB1IsqD47SnluSYyo1anJifI18SvGmFVb7UtEmTT9gfFq
0x4sX226w43PpTnrWUChNzAzDWoDY2jSGiwfKUpDiUOlM+NqHRtOY5zG2NLn
NKZF/AOmMWB0CYFowmME9TchMtL1r8tkqqt3KkOJpZmXUxmnMqlYTmVSsZzK
WNStSWV4JEObyvDU1KUyZZXSpTIa2rSpTD6NaE1l8pW3pzKyVa9LZfS161IZ
OtHQpjJ0JfWoTH519KiMpCYtKoNRD2kqg8XTpjLcfKWpTGl8HSqToiHSZCYV
R4vOUPOSIDScWC0oDeX+9sXMYcxspza69TtMasN9QusU53+gONxZUUphrFId
0+/ZSNffHNWx9K4NN+d9fbrulKc8L6c8UpSH+19arD7Nd+rj1Ieie019cq6+
dnGcWtzHxvs33GrUYTvt3rGRuXJpz6byGcM+vG8jWXELXMfKuzY5x9K+a/fG
DeavPtFp/3ZNuZJcesOdPZDOSNMbaK9Na7B8pOkMN14ejaHcg2y3IXWRpjLQ
XovGYHlIUBhKDB360k3+AdkD2QY=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{462, 67},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->18666600]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixForm", "/@", "%"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->2852],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWm1y0zAQVWI7hDQMNGWG8tkcgxOUXxwi02Gm/cHAlJ4KDhksy4LmedWV
5I/I8XamsVd6u1qt1pItva+7h9tv33cPdze77Zf73c/bu5tf2+sf92VRNlNq
9lsp9flSlff78q76139/yn9za+7W+jeztXv1HuQLkD/0XI/tv+7Zv7MqCmdQ
mpc/RSmu6msB9ecgFzVuWV+fMfisxq097Vv8ytN+Afgc6jeO/h7L/xU5ClnV
lX9yhTE2mqULxoNcbB2U4ohhRpxi7HWf5rbvkm0D2ppitmGf5xVuRaByZbJR
X3FmfAnyosbRPnDaBanl2zatHeeJ7YdtG6P3yhGnsfUbV146C0LyLN5bPffN
KTRjjdJbRvvmshbrXezziRnmHoPxx80vC7WWFtf1dcl4tahx1Uqam3JV/XGa
RUPDt82mZnjr1m/bJkafmnvG0E+/Ub4COQP5Ocj4BYb1nD7m4mVLffxiDfWH
6z/GC78gU+9/fBbMVRN3UZdTb8sUPq/L3wXiXwS24/If9TdH9j9uNFALn/Rt
YnjOf+4ZHNp//1HQY4reU9aHwLn8G7ofOCPNvKKJKxxa7boe28dVvWv/9FvF
rBR1NCQie8kTR33cXCRRkai4ooK78fili63kieJdpwMYZTxN4L6l0H5bfEp7
OtO0Fb+XM54+pryTOE1bknVhWdduf3282pI94dkzzF75dKxR5TgaVAZ2fTqT
kj06G0keALlnz7Fi8pFrNk8YcM4iz+0ZG1340YcNDzbII/mNjwcJ4/HUAKNB
juwT+vhNFNp+1/o0g0w/4XqM3zKtZUfG2dMD3HnFUZkDHldSzn5bvImycEZ1
FPQtsmn/30mMqOdReLXD+m+eV/teh9ZOkXWXiq0pMh5NtuGbg2TdcLYk6w4s
QhYKz/Z0ebbVmzObBcKzFZ5tn3Hzy0Lh2Zr6sfJs/Ub5CmTh2R7KY+fZor1K
jsoK4d32538eNSrH5tOG4jn/0+Tfcqsp5aXwcd04MwPZi/7FFRc9OXX+nFmp
Q/NsGlEJnRMlKhIViUpIVPC0gOPBLhLFu04vqO+3x3if78Mu8SntAU3T1hQ5
bpJ1x7YlWffUChRz6pEaPm7c251ltDsBCtOWOWRYW7Hs2G7PLVKxZrLPxRLR
5Vr05ZXi6UYq+HB2a+7UjG+zO02a8fiRsf+p53rcxed4pihzvFC03xafZhTt
7jnHBz3f+/E6Ny1xwvvUt8j7VLO/5hUMUA==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{426, 56},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->457727264]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->24177],

Cell["Tuples with any head:", "ExampleText",
 CellID->20734],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Tuples", "[", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"x", ",", "y", ",", "z"}], "]"}], ",", "2"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->16620],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"x", ",", "x"}], "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{"x", ",", "y"}], "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{"x", ",", "z"}], "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{"y", ",", "x"}], "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{"y", ",", "y"}], "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{"y", ",", "z"}], "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{"z", ",", "x"}], "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{"z", ",", "y"}], "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{"z", ",", "z"}], "]"}]}], "}"}]], "Output",
 ImageSize->{524, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->503390993]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(8)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->25940],

Cell["Digits of successive base-2 numbers:", "ExampleText",
 CellID->19959],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Tuples", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "1"}], "}"}], ",", "3"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2118],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "1"}], "}"}]}], "}"}]], "Output",
 ImageSize->{556, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->304782575]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"FromDigits", "[", 
    RowBox[{"#", ",", "2"}], "]"}], "&"}], "/@", "%"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->17376],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0", ",", "1", ",", "2", ",", "3", ",", "4", ",", "5", ",", "6", ",", "7"}],
   "}"}]], "Output",
 ImageSize->{153, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->259536021]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->10453],

Cell["All possible trigrams of A and B:", "ExampleText",
 CellID->27035],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringJoin", "/@", 
  RowBox[{"Tuples", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"\"\<A\>\"", ",", "\"\<B\>\""}], "}"}], ",", "3"}], 
   "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->15565],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"AAA\"\>", ",", "\<\"AAB\"\>", ",", "\<\"ABA\"\>", 
   ",", "\<\"ABB\"\>", ",", "\<\"BAA\"\>", ",", "\<\"BAB\"\>", 
   ",", "\<\"BBA\"\>", ",", "\<\"BBB\"\>"}], "}"}]], "Output",
 ImageSize->{265, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->775894607]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->15670],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"ArrayPlot", "[", 
    RowBox[{"#", ",", 
     RowBox[{"ImageSize", "->", "20"}], ",", 
     RowBox[{"Mesh", "->", "All"}]}], "]"}], "&"}], "/@", 
  RowBox[{"Tuples", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "0"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"2", ",", "2"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->16712],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztW0tuwjAQdQh/FalqKrVLTtOueogIVYJF1YpynhywB2iXrn9BwWB74gTh
SC8SxGPP2PM8byCZwFt52L5/lIfdply/7suv7W7zvX753IuuPGMs+2WMPT0z
0eaipV7y+BMv3dStsXgfiUGWi0ZVVbI5U7IRjLyS2o2+aa2jZuVsWo8beWnJ
04C9Uz80vz1faH7HeGHNP0vc35j9XnEHxoR9br3nYy3rGSaqJanNJnUGyEOu
MQfLwfJEfG6955OjzDXXxxxMB9PT9xlMB9PBdDAdTAfTTVcE05VmftQMMqF5
Z6CXXFBw0SzCa/hiQ7MwGgsXbt8+JIciLhrOmDvkdJFERKSXjJF1njkFUUM+
sfFhotpQ1vHFh2pjdBY2bpstA8AQG5OzmNvYB4IjKi6dM0bpNz5vQp5dXpWE
j25FW8sXM7qVUVm69sHIFzMpaUTxkXJywt6LQaHqK1o6w0bWHo0CaOtck5nd
8jrOtvJhpFvR1vLFjm5l1lo6fApczyWIJD5CZxyw92BQaCKj1Pym46d5lHGV
Zbk+KcfEWyEMVuZ8Rzg/9qgnn65kwhfpmfYuJvedVQtPrtxE3xEnctWigbnL
fFe7Q++g76xatJ2zLcYb6V/OzR4qdeA8OJ+S/vVq0mA6mJ6SPpge0AfTwXQw
PWY+MB1MB9NPxsF0MB1MB9PBdDAdTO/IdDn2UOnnAPXZrteramWlDnbv6PPZ
F9a4b7263/7FjqqaHp/zyK4f09b/05A9+l9JLPsHsV/gJA==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{502, 23},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->69055466]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->12526],

Cell["Neighborhood rules for an elementary cellular automaton:", "ExampleText",
 CellID->28959],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Thread", "[", 
  RowBox[{
   RowBox[{"Tuples", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "0"}], "}"}], ",", "3"}], "]"}], "->", 
   RowBox[{"IntegerDigits", "[", 
    RowBox[{"30", ",", "2", ",", "8"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->10460],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "1", ",", "1"}], "}"}], "\[Rule]", "0"}], ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "1", ",", "0"}], "}"}], "\[Rule]", "0"}], ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "0", ",", "1"}], "}"}], "\[Rule]", "0"}], ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "0", ",", "0"}], "}"}], "\[Rule]", "1"}], ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"0", ",", "1", ",", "1"}], "}"}], "\[Rule]", "1"}], ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"0", ",", "1", ",", "0"}], "}"}], "\[Rule]", "1"}], ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "1"}], "}"}], "\[Rule]", "1"}], ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "0"}], "}"}], "\[Rule]", "0"}]}], 
  "}"}]], "Output",
 ImageSize->{374, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->268553970]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->4200],

Cell["Digit sequences, or evolution of a substitution system:", "ExampleText",
 CellID->31274],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{"Transpose", "[", 
   RowBox[{"Tuples", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "0"}], "}"}], ",", "6"}], "]"}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->5783],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzzTSzJSM1NLMlMTlRwL0osyMhMLlZwyy8CCjEzMjAwZjAwMOhLMADZ/4Es
MAYRmQxgwAzmgwCYSgVixiElwwIk2IBcViDNCqTZ0GhWEuSxqaNUntbu4B0N
ldFQGQ2V0VChW6hwA7ncUJqLQj6I5iKBLzTqqlFX0dVVYkCuKAFaDEiLYqFl
R00dFqZqA7naSLQOEt9oxOkKA3LDgHQ4kI4dpqrWALlbBpUsiBhMfTCkPiQj
AJfr1cc=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{360, 47},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{Automatic, Automatic}},
 CellLabel->"Out[1]=",
 CellID->637614064]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->30506],

Cell["2D lattice of points:", "ExampleText",
 CellID->4987],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"Point", "[", 
   RowBox[{"Tuples", "[", 
    RowBox[{
     RowBox[{"Range", "[", 
      RowBox[{"0", ",", "9"}], "]"}], ",", "2"}], "]"}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->9501],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztkcEJwzAMRSWSgkfo0aP41B5ChzCh4BxKSpodPIbH8HiuFAffek2h/QcZ
vY8FH97Nr+H+8Os0entd/DNM48te5kWijolo0DmT7EW2On0pJcYoewhBgbqG
dPoCs6CWZQ1o62etlc0YU/s13O+PZRbc+mlQ++WcnXMppdqv4X5/LLMgC7MG
NOiPjy/swz7swz7swz7swz7swz7swz7swz7s/5J9eP8H78RvuTpOAA==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{75, 75},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{75, Automatic}},
 CellLabel->"Out[1]=",
 CellID->64620090]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->28192],

Cell["Connect pairs of points in all possible ways:", "ExampleText",
 CellID->23714],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"Line", "/@", 
   RowBox[{"Tuples", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Cos", "[", 
          RowBox[{"2", "Pi", " ", 
           RowBox[{"i", "/", "8"}]}], "]"}], ",", 
         RowBox[{"Sin", "[", 
          RowBox[{"2", "Pi", " ", 
           RowBox[{"i", "/", "8"}]}], "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "8"}], "}"}]}], "]"}], ",", "2"}], "]"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1741],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{150, 150},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->45035295]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->11694],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Tuples", "[", 
  RowBox[{
   RowBox[{"x", "\[CirclePlus]", "y", "\[CirclePlus]", "z"}], ",", "2"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->8130],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"x", "\[CirclePlus]", "x"}], ",", 
   RowBox[{"x", "\[CirclePlus]", "y"}], ",", 
   RowBox[{"x", "\[CirclePlus]", "z"}], ",", 
   RowBox[{"y", "\[CirclePlus]", "x"}], ",", 
   RowBox[{"y", "\[CirclePlus]", "y"}], ",", 
   RowBox[{"y", "\[CirclePlus]", "z"}], ",", 
   RowBox[{"z", "\[CirclePlus]", "x"}], ",", 
   RowBox[{"z", "\[CirclePlus]", "y"}], ",", 
   RowBox[{"z", "\[CirclePlus]", "z"}]}], "}"}]], "Output",
 ImageSize->{335, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1323430557]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->7614],

Cell["All possible digit sequences:", "ExampleText",
 CellID->26598],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"IntegerDigits", "[", 
    RowBox[{"i", ",", "2", ",", "3"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "0", ",", 
     RowBox[{
      RowBox[{"2", "^", "3"}], "-", "1"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->17139],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "1"}], "}"}]}], "}"}]], "Output",
 ImageSize->{556, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1409239520]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Tuples", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "1"}], "}"}], ",", "3"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->4762],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "1"}], "}"}]}], "}"}]], "Output",
 ImageSize->{556, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->491469877]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->26854],

Cell[TextData[{
 "Results from ",
 Cell[BoxData[
  ButtonBox["Outer",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Outer"]], "InlineFormula"],
 " involve extra sublists:"
}], "ExampleText",
 CellID->28448],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Outer", "[", 
  RowBox[{"List", ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->23828],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "x"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"a", ",", "y"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"a", ",", "z"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"b", ",", "x"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"b", ",", "y"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"b", ",", "z"}], "}"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{338, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->912116377]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Tuples", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"a", ",", "b"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1224],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "x"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "y"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "z"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b", ",", "x"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b", ",", "y"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b", ",", "z"}], "}"}]}], "}"}]], "Output",
 ImageSize->{310, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1201675953]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->11114],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Subsets",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Subsets"]], "InlineFormula"],
 " picks each elements at most once, and treats reorderings as equivalent:"
}], "ExampleText",
 CellID->18887],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Subsets", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
   RowBox[{"{", "2", "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->25960],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "c"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b", ",", "c"}], "}"}]}], "}"}]], "Output",
 ImageSize->{158, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1631525683]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Tuples", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", "2"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->26245],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "a"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "c"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b", ",", "a"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b", ",", "b"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b", ",", "c"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"c", ",", "a"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"c", ",", "b"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"c", ",", "c"}], "}"}]}], "}"}]], "Output",
 ImageSize->{461, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1980949285]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->31643],

Cell[TextData[{
 "With one argument, ",
 Cell[BoxData[
  ButtonBox["Tuples",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Tuples"]], "InlineFormula"],
 " picks an element from each sublist:"
}], "ExampleText",
 CellID->8819],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Tuples", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"a", ",", "b"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->19326],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "x"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "y"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "z"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b", ",", "x"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b", ",", "y"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b", ",", "z"}], "}"}]}], "}"}]], "Output",
 ImageSize->{310, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1375653554]
}, Open  ]],

Cell[TextData[{
 "With two arguments, ",
 Cell[BoxData[
  ButtonBox["Tuples",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Tuples"]], "InlineFormula"],
 " treats each sublist as a complete element:"
}], "ExampleText",
 CellID->24544],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Tuples", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "}"}], ",", "2"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1863],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"a", ",", "b"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"a", ",", "b"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{539, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->800338476]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->23360],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLinePlot", "[", 
  RowBox[{"Accumulate", "[", 
   RowBox[{"Flatten", "[", 
    RowBox[{"Tuples", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", 
        RowBox[{"-", "1"}]}], "}"}], ",", "10"}], "]"}], "]"}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->17908],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{311, 196},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{311., Automatic}},
 CellLabel->"Out[1]=",
 CellID->81096756]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->23063],

Cell["3D lattice of points:", "ExampleText",
 CellID->30584],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"PointSize", "[", "0", "]"}], ",", 
    RowBox[{"Point", "[", 
     RowBox[{"Tuples", "[", 
      RowBox[{
       RowBox[{"Range", "[", 
        RowBox[{"0", ",", "9"}], "]"}], ",", "3"}], "]"}], "]"}]}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->3925],

Cell[BoxData[
 Graphics3DBox[
  {PointSize[0], Point3DBox[CompressedData["
1:eJwlltlRBEEMQ33bCoOUCGETIG3CQGq2+KG6ZsZtS0/++vx8f8LMftOMf/8/
N4v3b5m12Zit2ZlBJ+7mYZ7mZd7mY77mZw49FG4RFmlRFm0xFmtxFtD70i3D
Mi3Lsi3Hci3PEvpUuVVYpVVZtdVYrdVZQVW0W4d1Wpd1W4/1Wp81VOC4Tdik
Tdm0zdiszdlAta/bhm3alm3bju3ani10rXO7sEu7smu7sVu7swNvbHBDGNJQ
hjaMYQ1ngJqhdvDOvBirZ4msgx/jG6E+6Rfu6V7u7T7u637uUAt5EuGRHuXR
HuOxHucBdZcPZXimZ3m253iu53lCjef7KrzSq7zaa7zW67ygmfBTHd7pXd7t
Pd7rfd7QuFjFhE/6lE/7jM/6nA80SRa44Zu+5du+47u+5wsNmbVf+KVf+bXf
+K3f+YHz57Uc4UhHOdoxjnWcA5KGdENxUAEcM2fJgXEqbD2kGnWK7eCdeTFW
zxJZBz8GCUpn/GVERXTERGzERUBaYwt5khlZkR05kRt5kZAM2V0+VBlVUR01
URt1UZBC2Xi+rzO6ojt6ojf6oiHxcib81GRMxXTMxGzMxUC65rhYxWZsxXbs
xG7sxUKS5yRZ4GVcxXXcxG3cxYFu4JBZeyADFejABDZwATwruq4lq9APFD2V
TflSo5CHJClemuKgAjhmzpID41Qge6mJ7AfbwTvzYqyeJbIOyHl6jGf8VWZn
TuZmXiZkSmqNLeRJVVZnTdZmXRbkV8qQ3eVDXdmdPdmbfdmQlalQNp7vm8rp
nMnZnMuBXE7xcib81FZu507u5l4uBADqmuNiFVd5nTd5m3d5IBsoeU6SBSYq
0YlJbOISEDZEolDtAgfpQATQ5zQzRBR5L3QtWYV+oOipbMoXgo3UFrqxxEEF
cMycJQcGcUj9DTVD7eCdeTFWzxIhROmNoT7p11VTtVVXBdGLpqTW2EKedFdP
9VZfNQQ2+pUyZHf50HTN1GzN1UDMo5WpUDae79uundqtvVoIh3Q5xcuZ8FPX
dVO3dVcHkpIAoK45LlZR6MIUtnAFCKJCdmiSIiwxSlYSiKQexFdBKjRkMYXg
IB2IAPocQq9sGZq/XESr0A8UPZUNUVlCDElDuqE4qACOmbOEgK3Wh1SjTrEd
vDMvxuohlutjIUHpjL/p3u7rhjBPetGU1BpbyJOZnu25HigBCDb6lTJkd/nQ
Tu/2Xi8UDmQerUyFsvF8303f9l0fmBvEIV1O8XIm/FRjGtu4BhQpyraQrhVF
LIShwuRgPEBpI5qHJC/4skZilKwkEKEgEr9CbhBuWD7BQToQAVBGybEho8hg
vBmtQj9Q9FB8SaMhD0lSvDTFQQVwzFCyaSohe6mJ7AfbwTvzYlDoqY6Q8/QY
z/jbmZuB8pCYJ71oSmqNLeTJ7uzNQlHJBCDY6FfKkN3lQ7dzNwemKMOBzKOV
qVA2nu8b7OAGUMBqCQi5XJnd+pQiljkKZa9iLwQApVSrCoUKkwOKZYE+xAZx
uVWgMEpWQokttIWwIRK1ahc4SAcozGXmEFHkvda1ZBX6Acp5yTcEG6mtdWOJ
gwqAVgANLMQh9bfVDLWDd4a2A5UYQpTe2OqTfrcLLQ7MQ2Ke9KIpqTW2kCd3
e+BOwahkAhBs9CtlyO7yocUtoHVD21KIeVpuWo3XLsKFA9pEtB+EcKg4b81E
6cuIhZYUJWKIlAqw1riUNwwVaH9RBoQgKmS3JinCEqPQaiPqhfgqSLWGLKYQ
HNDWI5+H0CtbtuYvF9Eq0EIkZYeoLCG2pCHdUBzQrqRZhoCt1rdUo06xHdAa
pepDLNfHWoLSGX/ghsXFgXlIzJNeNCW1xhby5AC8jRNvd8TbAvH2ObzNDG/H
wtuW8PYevA0GbxfB2yrw9gO8pMfLbLz0xctRvETEyza8lMLLG7zkwMsAPJrj
cRmPsHisxKMeHr/wSITHFDw64Pkcz7F43sNzEZ4f8JSNp1E8teHpBk8BeLPE
mwpef/E6hXdnvOrx6sB7I97ZH7c9N1M=
    "]]}]], "Output",
 ImageSize->{211, 225},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{207., Automatic}},
 CellLabel->"Out[1]=",
 CellID->1930399980,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->6914],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Graphics3D", "[", 
    RowBox[{
     RowBox[{"Cuboid", "/@", 
      RowBox[{"Position", "[", 
       RowBox[{"#", ",", "1"}], "]"}]}], ",", 
     RowBox[{"ImageSize", "->", "40"}]}], "]"}], "&"}], "/@", 
  RowBox[{"Take", "[", 
   RowBox[{
    RowBox[{"Tuples", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"2", ",", "2", ",", "2"}], "}"}]}], "]"}], ",", "50"}], 
   "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->23130],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   Graphics3DBox[{CuboidBox[{1, 1, 1}], CuboidBox[{1, 1, 2}], 
     CuboidBox[{1, 2, 1}], CuboidBox[{1, 2, 2}], CuboidBox[{2, 1, 1}], 
     CuboidBox[{2, 1, 2}], CuboidBox[{2, 2, 1}], CuboidBox[{2, 2, 2}]},
    ImageSize->40,
    ImageCache->GraphicsData["CompressedBitmap", "\<\
eJytVstu1DAUdWwnnmSeQBFQsegSCfEbsOIjRlWkdoGKhu75Fvgk/ieC+3Js
33g6IBF1XDu55xzfc+04n4+Pd+OX4+P97fHm0+n49e7+9tvNx4cT3HKNMeYd
/N6/NtD/DT36XU/TZNw4jhNdZo2NeQWth5tbGr2E1sLIAsC4hw/fR7rMhp4+
hxYJjIOn8BD+jIUGERxxyPAdPia9HycEsd5OInKOgI3nSLgLnYFi1xW9Potl
Yo7t9cwZYgZs2jle5tITpjuTz0Kvy/E8wxUx+EW+CulmpLHYZP53iQFAV9Vo
1krRLtZQNF5ETTHP/RXqgDWDIBs1oV9oikuMthEtju4F7dWMvdL2VfSK6je7
JFxB5dEqr9xZLgQNkXNeQhpvq/gg6htaIzOeKSSfsxzipS+8TNUfVEZBsTWJ
zc9swtVe4MI6YZyrcpJZnKTBqNUFNmJpuepph7gF16B41rUV+594yNGL2f3L
jNKqLmdUOJI5ZGmPlyu6uYikd0BgBF8/f008hN3EeTUwQKYlG+5LXAwtgha7
YTmPtJK3uBPwXUjI5AAitV5CDYLaKZR/EtVlu0WOB7ieZRxG1maFQ3xykqmP
mcJ/7O4jS/ZGeoIFutfKK0JkLjPgLURhUHYSSFXK/JDsDTT0fsPB4uSQeM9V
Y9ReZWGFocdBcVY15ftYFHcSn9chacUzJlcIko9VypvMjcTQKT0n6FBBl96F
7HzbqOihqtUrLY3y0V0I4Z04nHEDI8L8HVBzIFdHAv7C2Co+m/Ed5m8QPNKv
uJbNH9xXdcs=\
\>"]], ",", 
   Graphics3DBox[{CuboidBox[{1, 1, 1}], CuboidBox[{1, 1, 2}], 
     CuboidBox[{1, 2, 1}], CuboidBox[{1, 2, 2}], CuboidBox[{2, 1, 1}], 
     CuboidBox[{2, 1, 2}], CuboidBox[{2, 2, 1}]},
    ImageSize->40,
    ImageCache->GraphicsData["CompressedBitmap", "\<\
eJytVsFu2zAMZSTZjp04KFZ0LXrqdRj2G9tpHxEUBtpD0SHrfd/SfdL+x+hI
kZJo2lnabUYiWBLfI/lESf66f7obHvZP97f7my+H/be7+9vvN58fDzjkVwDw
Af8frwDfX/At/q/HcQQ/DMMYH9hSA5fYBhzcxd4Ftg57DgHgHz/9GOIDfZw9
l1nwOIuT+ANHDbHiELXMeoatN5YhWY7Ph2K5Ux7X0YwtmG4TbTYLbC01Fdtm
c+iifWuzYBh0U4zEwZjmaG7GZ63x7LaNDOFozobBl6gdNWpNmsyU9Zih2WdB
Sz+jfVpnydqyUJ+VsXEUpnrKpJCaqY56lj6vQWVyqha5dhJFUDlRUMFEwmhn
ctoKujGKWN9hEd0KOtZDKGiY4f0ivhH8NnYynim4nSm6zBSEyVbaZqlOKmYv
lauyC1lZYaz+EyPEp/lXtj9U0Vu4ooxSKd0JHk9NyDw48Zcc1c9fY17YuMFP
8lCfThOqJ0dwzwRzdD6XFJrUpiAYOVXm7WxeVTk/NXEEfY75xCrV6k6yErwl
VG3qH8fK6cK7aCVspe47yXA3jQTUOXEUm9R5p9SBVyHnSrxPHCSo7NIVdgk7
x1Og19kre3EzRM7Lsxr0uk2qVBkpxcNK55tH7HuDbwRfpZ2ZCdzsXCF765+q
hrrrI3i/gHf6NNb3k2Rfog/67lQRU1fX6+SmEcZ1uqsjU23iCBJHyt+i003P
yqc7nCx75ZeE30wsW+OnF37yT0vEu6oTTFYz3So4FpXkbxjFs0664RB/3/TG
wqWVxKGzMX0B0UfFBdfb6jd6i8OX\
\>"]], ",", 
   Graphics3DBox[{CuboidBox[{1, 1, 1}], CuboidBox[{1, 1, 2}], 
     CuboidBox[{1, 2, 1}], CuboidBox[{1, 2, 2}], CuboidBox[{2, 1, 1}], 
     CuboidBox[{2, 1, 2}], CuboidBox[{2, 2, 2}]},
    ImageSize->40,
    ImageCache->GraphicsData["CompressedBitmap", "\<\
eJydVtlO6zAQdW2nabpwKxDbfeL1CvEb8HQ/okKR4AGBCu98C3wS/xPBbN4m
oQ1E6iS255zxbHb/b17u2ofNy/3t5uJmu3m6u799vrh+3MKUmxhj/sHv8szA
9yd80e9v13XGtW3b0WOWKMwZSA+TKxodg0QV4wHxePXa0sNrRyAtjCwsOVgj
LvhGyVzrgHaMRiUfNLu3bdI8yLhmpMYarLQgnaXo5GwNiirqivU56TfKOkiz
IH1Wi/SiX/f8UXZcxBmLIotdTQz+W3/3Mck4MrmQG8PPbA+LU/uZ9lgQMI4F
QLKXcSxTEBgzDhpnwO9mEqRmcsJUZdUUYmRVtfpRjLGeXKoRijjWMzPBQkVc
VvmJ0UGq+S/xtXizoiDlNcrSKY/sIIsXlnXZFRgRmMUJn3A+4mTvh0N7r+Le
eftGMUivQPf/FL0jEwvF5Qa53K+4sNp0NCfEFGrQxDzuZinz6vZy4BjPjDp0
ceHHLiRWBxq37x/dcIw5z2P5qPk8tx8/U2ROZyMXXe+kKOMUfArnPZcCqs+R
LdXfaCa6SwibzpnvsWX34PAwi0/afzov+0gvyBMVWUROYIgIQaV+EYqGMDCA
N34eDGSn5Ij+ZaglCDoRi+ijLenxcEeIvsbXgveUQX1b9c+JtNPEYYWjKWOP
FRdPTr0P3DcOV5nXyWKlLDZiwSrLES13AcdpqtBe0Kf4loiWd/B54I+rjeLQ
cfNhzA1Aqtw58wFvF+ItZnDWhX8YOf8s5AGm+H/KSniGLK1J4w9ITPsxV9jk
C6bMsYg=\
\>"]], ",", 
   Graphics3DBox[{CuboidBox[{1, 1, 1}], CuboidBox[{1, 1, 2}], 
     CuboidBox[{1, 2, 1}], CuboidBox[{1, 2, 2}], CuboidBox[{2, 1, 1}], 
     CuboidBox[{2, 1, 2}]},
    ImageSize->40,
    ImageCache->GraphicsData["CompressedBitmap", "\<\
eJyllktO40AQhjv9cGzHCaAZEGLFFiGuwazmEBGyBAvEKMN+zjIcae5jDfXq
pzskAisppdv1f11dVW3n5/b1cXzevj49bK9/7La/Hp8efl/fv+xgyiyUUjfw
vb1U8Ps//KLv1TRNyozjONGlBjTqEqyFyTWNzsGii7KgeLn7M9LF976B1TDS
cMvAPWb93aE7s87EQxlWo5MlA2OcJ7si341fKfFtEl8Gs++QrNyjjws+Au7J
ryuYYNUq95d42X8521GMpfNjWUejSbK3JILbt+ODJBkHkqmQmoLUJ1mvxdQE
Es1KEtoD8Rg20yTxHEfB2DBvuhoT3GDgkTQjNOdpCDhME3Xra8xjqXybRIZj
YllmMc7tpRnfaeXOjtA3oh9qehf0siNLDF3kx0o+yq6kmGxgwge9cKLO0Vle
93cS9kDYh3STjkTLRL7OK1pbaBd5NLLqxReVec9+XjmvAu1d+VOgQvXLjDGH
6/Y5zhIMpdO8/Zu+GBN2CW61AZRyaVcolfRllp8Zz0aeIvceabHHsL9AsoAJ
JOSU2JMhM3BtkJDU+WN9zAjMgxLFTIhVqxHy04JD51UZReLAZMwpNlIY2e1l
xFORM+jtWagGMHjuuCppVfWsCieFdila509eECcnUnaf5Ur0GgwOu6T+ceXs
PSOKtayIPd0XKt6jK9bsRGH82skzrk5oKutqobTUcYECn5V4s7adPYOGYt3c
v5PRJvWSNxti+GStij1FJlcaS8fv5qHwbH2+YIr/+az97mzYXeJzSj4nYBsY
fecOWLwDFTHkPA==\
\>"]], ",", 
   Graphics3DBox[{CuboidBox[{1, 1, 1}], CuboidBox[{1, 1, 2}], 
     CuboidBox[{1, 2, 1}], CuboidBox[{1, 2, 2}], CuboidBox[{2, 1, 1}], 
     CuboidBox[{2, 2, 1}], CuboidBox[{2, 2, 2}]},
    ImageSize->40,
    ImageCache->GraphicsData["CompressedBitmap", "\<\
eJydlkuO2zAMhmVJtiPbk6YvYNDVbIui12hXPUQwCDCzKKZIZ9+ztEfqfYxW
FEmJoh03qJEosf3zM0WRlL8cnx9OX4/Pj/fHu8/n47eHx/vvd5+ezvGSa4wx
7+P3w62J///Ef+n7bp5n406n05wOM8FgbuNo40XjogZv0p23cXR85+njjzga
UOLd12Rn41UHd8keDFDxUihaUHhU4DgmzV49A2Sd0M4/z1k7Cd4AmjZrUGaG
pBvkjIg5JX0WkyMh6fsVH/a1nviob4Ufr9LMC9fCIGLcJQvPkadA9hwvetqw
SinrgRSnKDtFCWIVEuC/KBB9ODXu1+9ZkGy6Vmbmr6I5ovkIY101Q4rshm8+
0+IHvOiZBb+Qk8DyyEJcW9PIF6CBLIBdh/aIwIzQUXerFI7PBKZeUlq19nbV
3tMsLEcqWoH9AEObeTQ3r3xCplVxssRsBRMMx1WmzgvB9MjEI0c/18CWj2Xe
zaqPQfkG0Q56Jbmqq6pzV/PSOTnWJjbOkjPR5lW+6K2uJaI7RS9dr9hc5f0F
fl5nUTfQY/wGM/3Qgo0bvGQB/Yp7Wq6mXD2LbNhiQyyA163ydHY1/+bhlFIN
5u7oS6yuYQ5iz8BDR7QXq8VZ28RTYNU8VnveEy6s0Y6J1EHcJhFWEsQ5L3Vm
VZlR7wWK6nMVEDMopr3EFN23ZgLyJlJKhdSRSzvCYj9c5spBeGKoI3nu/4v9
t9Qe5PqBno+FhYflfu1pK0qGzWJXBcme7G+S3oj3hybv21IfSO/YZ6rtSXSO
4mUn3yq4C8TB5R2pJtj83N2is05Kz54Um7DytFFZebICNHaEUc1QPocXsK/e
pYJgTPmNTDKsUByS4kUcYft8g6vf/AWT6N3d\
\>"]], ",", 
   Graphics3DBox[{CuboidBox[{1, 1, 1}], CuboidBox[{1, 1, 2}], 
     CuboidBox[{1, 2, 1}], CuboidBox[{1, 2, 2}], CuboidBox[{2, 1, 1}], 
     CuboidBox[{2, 2, 1}]},
    ImageSize->40,
    ImageCache->GraphicsData["CompressedBitmap", "\<\
eJyVVttu1DAQdWwn2VxYthShiqe+IsRvwBMfsaoitQ+o1dJ3vgU+if+JwDPj
scezTlmirpvYc47PHNuTfD0+3y/fjs8Pd8fbL6fj0/3D3ffbz4+n0OUaY8yH
8Pt4Y8L9n3CHv/fruhq3LMuKl5mhMTehtaHTuBBDg3HknRx5/PQjtAaeafQ6
tE6MQoANTY64ingbAjoYxrl/ngA0YcRrNQME9dB4iiRFI8bOlfkGEUvEFDuK
mY0j6dCO0LQpnujNgJh+I5+z+TI+5kL4Vsz5RmQL81hohPNdQkj26yoqrwqh
PK9igYpRALgIdQiNQ3d+/V4hCbhlZMyLkI6R0cOd8sTDmodHH4g4Lqn38QHV
tNt8PvFFXR2zwX8DXpUOuk0uoBoV2itP6uguoud/zG1LtPIh7RnK20zA4omN
CLUawecTX2RrBRvAFFv4s2nlssIGGS0zGr6S12n/Sqfg1kLTygg8EplP+DUo
bbDiA+C77J0xdPOCwhcYAdWjQnILk8cmxYTey9SB6y76ZVXWnueo5ytPv2Lk
nQ8nvxPKSK/9Lx4kWviqaYSoJnSBe+QgSo1LPFXc86yrlm3cfxcwQX9LaaXS
aVrF6y5SCAA8AcUuS3zFfgXoNhu+KVrKgy7o7UQVK6ooq0TispLU5+BTDZLY
fa/Yc80UdUnVCsXuE3t0Yzw7c1x14J1E7xu+IElb8NC1L0+FxG+oKb08iBOQ
a17Oq60qyac4vcWjy6+iX5qn45qUSJry/RQrxl7oqfksM8tK+B08cl1ULFax
7GI8oXulAdAQ3FfXZyq83J3V2vlsRcZitqHi2qRWAdzyqcJNSt/M1SxGoX78
TtK8sobiUGjoC2yvOC3v89B1WPkbDQr6W9ozzV+ttjRI\
\>"]], ",", 
   Graphics3DBox[{CuboidBox[{1, 1, 1}], CuboidBox[{1, 1, 2}], 
     CuboidBox[{1, 2, 1}], CuboidBox[{1, 2, 2}], CuboidBox[{2, 1, 1}], 
     CuboidBox[{2, 2, 2}]},
    ImageSize->40,
    ImageCache->GraphicsData["CompressedBitmap", "\<\
eJydls1u1DAQx2dtJ2my2agFVSBOvSLEa8CJh1hVkdoDKlp651ngkXifCObT
mTpJFxpt3ST2/+eZ8XicL8fHu/Hr8fH+9njz+XT8dnd/+/3m08MJX8UdALzH
vw9vAe//4B3/vZumCeI4jhNf0FMDb7BN+HLgp2tsAz4FFEB8+Phj5AsO3PsK
WwJAxF7sxB8EavglALVCvXSc2kZMP0/ziMGNuKARSUYIZs9j9ivztW6sAGVs
W1ouEuioqfJ4taFjTaOapT/FfLXXi4UtE9KKhWmNEDMBAjVuHZpMyrE4qxYb
ZnW0tVWvS0p+1iBHo6COVAVFVVfYkE3h1+9paYNISVKvqgdsaIpkappO1aHI
xcSEUHjRK6F5MaFVQmcE+k8eISEWhLhKaJTQk7IWgkAkFUpKWKUki6Stg4hh
v0GlBHcepRxV5VQMleGiYA9TJuEvPG+dMoGvhndJ5ql1rYsa3XIeVJI1cpGH
YqflA+k656WtV+s8lTll8nULn6NR7kpGSD5zt7f/PyxLlAcaq1zJykqg0Sgz
bneWXtkuc0SqN1whar96wohPiLl6FUSikBnBKlvODC59xd4MZ5kcA+yrrbJm
WK4SBWvO6wWLayHeKaPZYC6j+JRJj+Rr+wJ9o3qI844iVufWF/6JFG2XjXZV
lncuF/fuBFyr0I5rJwSdHwWJVP3GWSNxJ8DAu9zvU4oQvViecbrX8faymKtS
DVfmLZ2rYDRscAwLS2s1J4vD4jQyLe2wwZ0j80zJn8JaaWh/x3zyzO8PRMrz
1MU8UVVNoepdtZhXxE7/YNXdKTqLc175Xf7K8DO+Vs/met1t+E4jLib7qlnz
1yzkLmzkO+lQ8ILjXU32JUVJcy15tvsLzFnowQ==\
\>"]], ",", 
   Graphics3DBox[{CuboidBox[{1, 1, 1}], CuboidBox[{1, 1, 2}], 
     CuboidBox[{1, 2, 1}], CuboidBox[{1, 2, 2}], CuboidBox[{2, 1, 1}]},
    ImageSize->40,
    ImageCache->GraphicsData["CompressedBitmap", "\<\
eJyVlktu2zAQQGlySEn+JAGKoEFX2RZFr9GueggjEJAsghRO9jlLc6TeR0jm
R4oeqa4s2JRIzrz5cEjp1/7lvn/cvzzc7W9/Hva/7x/unm9/PB1wKKycc1/x
/+3G4fM7PvH/yzAMLvR9P/DlttS4z9hGHNxx7xpbjz2PCi48fX/t+XIy+0ln
XcBZnMSf89QQFYeoFeoVtsFIQpYc/hxGyYvKYstiIiFCG5bZztjtqIlFVq2v
Wb4z1imYzbG8+iDyTeVDYC+NnST42lTHmvDPOA0hFILz1FTr0BRSycEJ7WC0
E2uHvLYasKVQX9Z0DEP8QEWBLSQlJfm3v8MZtMqPmkbZpi5kGj5nmjf1CsuI
+NjM0BxQhy+ciMzyJta1xrbO+nSnWBfqNxrNlvSS6AtCyiaYiPwsBdSLoPcN
IaDQ8EejNACjPhR91Uo5GWJaYppQTngEkmPHV8O7R2hlF7iuyhM9ck3EkidJ
lYPjKO26HdUP9pWVKn/Fhzjra645jtEwg2FKleleQuXWEFf/JYIhyp6iSVHp
zibGTKzy4PP5chapwaacRSp2OsJc8zZCUgiTmm+WsaCuEhJPHKatirSIBmx3
zBDFDUbT1nAmmX3JmRl3Y0d5nqFRf4VdokxJIUfY5yvmmtL8tcXbee/ClD/u
XTXWGWZjmNZnP2EScmcoyVB4P8VC0XXREyDXkda5ZUXD4tWEwqJ36WDPNkJc
GA4s5FDWyKdLox+Mfl2jYzTReNFiE/Qd5nUD15TWUCSnyVBAtVvujD7hia3e
il79dVHn0U0kO2PhKOu6YpH3JkmvVXfMqVYHjnEE8oVl4s7vDvn62imjPhl5
6bG5YolLtXkttbr6AEkvY9I=\
\>"]], ",", 
   Graphics3DBox[{CuboidBox[{1, 1, 1}], CuboidBox[{1, 1, 2}], 
     CuboidBox[{1, 2, 1}], CuboidBox[{1, 2, 2}], CuboidBox[{2, 1, 2}], 
     CuboidBox[{2, 2, 1}], CuboidBox[{2, 2, 2}]},
    ImageSize->40,
    ImageCache->GraphicsData["CompressedBitmap", "\<\
eJyVlslO40AQhtu9eA9BoACaE1eEeA3mNA8RoUhwGIECd54FHon3sZjaerWB
TKSU3e36v66qLi9/ti/3u7/bl4e77eXv/fbp/uHu+fL2cQ9TplJKXcH/+kLB
+Sec0f/XNE3K7Ha7iX5qRKMuwFqYXNFoAxZdNBx1mD2VkUsIYIVwLJoGRzbw
4WSg60eiHgo1Xx3lqjIQo0TWz0g0ozpZSVnwfbx5RcXbfvjCuxGyBjeD3ob9
wfIKLmgkoo50Lo0IdCi1ZFjPiK6opi7GNbHMAqtG4wJLImoTPY4x6mUezUoB
2iQvBGkwtA84x25KJz441RxEMmAoek9owJczCJX/PxqSHM1HvzK2IktZbJYl
1suTpH462SHO3X3JQlSf6ImZ73DQ6yKzRvQjbWXU+4Y0lG7RFzMK9lPWlxId
RWUDVap2GFML86TMDE3Wb3QLRYaVRqHfplDXtDZXdGFtifusUJl8TWlGc5C2
KbKtFlVtUbnBj6UllikUgqTbL9QeBTaJPXam+VHfiF6/f0zf1D+rxXc8K7wa
eS7tCbXQE3l+sZcijx8nPdJihx1MoncEaWONvTZ2x1zrq6IMipVCu6YKRQ5W
vIJzVHtCfq/g0HkVHPH0qKizmVNspDCy+4GhZ4yQd6IawdDzOdsVXEvPdnVd
aBvRunwf5J2b39UxwqjH7sJhm+9F0GdvnCReHK6SNVlZhTdeumYnMZ746kjP
snctKzjxOsdjYLWzJ8pYZODpUdMV65f1tqJALN83/UKWg2Tp/LcIf58k3Dbh
8LfLSjg26UjCgjkmjzVYJG54Z6t/CbLCqQ==\
\>"]], ",", 
   Graphics3DBox[{CuboidBox[{1, 1, 1}], CuboidBox[{1, 1, 2}], 
     CuboidBox[{1, 2, 1}], CuboidBox[{1, 2, 2}], CuboidBox[{2, 1, 2}], 
     CuboidBox[{2, 2, 1}]},
    ImageSize->40,
    ImageCache->GraphicsData["CompressedBitmap", "\<\
eJytVktu2zAQpUTSkmzFaRAnCLrKtih6jXbVQxiBgGRRpFCy71ncI+U+QjI/
UkNSFbyoYI801LzH+ZHUz+Pr4/Dr+Pr0cLz/MR5/Pz49vNx/fx5hyFbGmC/w
/3pn4Pkdnuj/eZomY4dhmOgyPQpzB9LB4AVpNyDRxMK9hjvbXIu2SUavRGsV
L0izo7d7Ydouvu0FW4NjNOKiXwFjtmJjHBg9f/sDv2Dto7WwdoRoZE5jZ0SN
AvXpNKJRt4L3yiuPOCe40wgPXZa/OtM3xOHCKLtgGhQ+8jCVaXMuHCy4bMbV
6liAqEZBOqN4btAZYmywZ+IzWS0Iqj8McfbAVmUz99WdzRrzSujTmNcH0Ss+
Op1F5GoUlwnezlbwwqdsEgWy4ZRbhad8prWSRLpFjo1w9KREDonKULxFt8w9
I3H5MCOzMpQ5neasz2YMFfIhr0JbxIpik/WlrHxhddJGdLWLfNJbAG4y76pF
724zFMWUrA5avilWZlzCUo+uz/xf0DcKzT0hfv99m+beZb/pJqk7AI7SaNmQ
rWasHs2xV9hhuOuikdfdQL0Oo+h/BS/Q56rAb8NqiL1F+zGypb21yhRr7WL0
cO1TFjH/N0MT8zDHTRyqIm6VwYn/PqCWWLBoJYuL/Scc3SJHurJSDjohM1Qv
eStPk7qoxWWGbUCg6sI6i+B5VeNJdBC7rrCritMmRFIT72nMT15G+AzRCcIG
D9X+sMwQvgJ0PKGHWuoLvZ53Ys3YtthX+hRh5nOfEZ1oe+Uf4tALF/erXRZV
rI3UgNwF0Uzh60NbtyFrQ/i2uZjUtwfHqGw+kc0lSNz4D1zt6gPQH+/4\
\>"]], ",", 
   Graphics3DBox[{CuboidBox[{1, 1, 1}], CuboidBox[{1, 1, 2}], 
     CuboidBox[{1, 2, 1}], CuboidBox[{1, 2, 2}], CuboidBox[{2, 1, 2}], 
     CuboidBox[{2, 2, 2}]},
    ImageSize->40,
    ImageCache->GraphicsData["CompressedBitmap", "\<\
eJytVsGO0zAQdWwnabJttyAQsOKwRyTEb8CJj6hWlXYPaFHZO98Cn8T/RDBv
PI4nk2y3KxG1bsad92bmje3k6/7h9vBt/3B3s7/+ctx/v727+XH9+f5IU6Fy
zn2g78e3ju7/0h1/r4ZhcOFwOAx8uQsM7g2NkSY3bL2m0ZMV5HfNsy9pBLCe
zO7EWileGoV3K//2sOIYNc+wF0AuUG6SUfeIbydcnlxduP/006WL/61Hf4nP
LK7R/AQBymPgeL+OwHdGEW/shpmiit4oBpA8g4FAK6DjiKbPyvgHY9eMH2el
DuapNQ+q4VjILcE56plcqiKPQfUEeSfdICZPz5jZLrUnwV1nmAMNYIuZDfM5
L6vBjG2uHbjaHCPRPYMLoD5zCtrN8H4Rj6iIvs59kGJSH6w6hkN0j8IxrkmZ
701F6IeXPaqqiSOT8NRn8OjVYVdqxdwsWCrUjSv2BGtg0cfVIuAw4+oNz4Ve
Azm7/8TDqj5Z3fkZcVcXM5ooohTCadFK3yq6R/TqSSSfLW3SNl2//wzJpL1d
diVsP2Pb0YBFUQM02RHTvuc8ymreYDfgrGVkUQBIm31B9YLaGlQ8iWrUjkkX
evFCcfARv8whOgWpNOZK6Re3l5lFmuZPs9DtldGKEWRmVAK8Jy84pSdN3uaI
M60PZO9o4DMORvGnj/KPqWsJdWmq8MLQwYgjQ8lInUVw2Yq/7kOJlZ9dOkIr
9XgTea3UKAyNiRcE3S6gp9q1Q3luro13vxirM7EsKmZ1x7Owf0SNyDswv2cs
KaCjgyC9tWwMn1d8uyG/1zRkvUq9rP4BBiTjaA==\
\>"]], ",", 
   Graphics3DBox[{CuboidBox[{1, 1, 1}], CuboidBox[{1, 1, 2}], 
     CuboidBox[{1, 2, 1}], CuboidBox[{1, 2, 2}], CuboidBox[{2, 1, 2}]},
    ImageSize->40,
    ImageCache->GraphicsData["CompressedBitmap", "\<\
eJydls9u2zAMxhXJf2InDooOXYueeh2GvcZ22kMERYD2MLRIe9+zdI+09zE6
fiQly7SxOA0SxpL1/UjRlOSf+9eHw6/96+P9/u7Hcf/88Hj/cvf96UhdYeWc
+0K/rzeOrt/pin+3fd+7cDgcev64LYy7JltQ545bV2Q9tYL+d9z7SVtlRiCr
hAuy6Kxn7+5U26JVJO90seH7G1W7QDFqZA1MmcYqjwl8DzxPw114+vbbyaf9
j6ZWDfsgCVQehn2+HaFvTHa8afPsXJFHq6SCjZAEtl7MwizWYz19T8VSsT7E
XglFOGGIw5Op1EeuDoZWjmk6qzmaK9MzYo0bsig4ntP57EAGURYZDfTS0Jg+
ZEPn3dhI6bLO40Lgi0lQt/GJqHoaSZjV16rfolEmvVaYZfhZRqGMlFnN2YZv
JiAy1svKzeZSpBwrpZyjhCEseap21UyJssbqRbS8RgxtrgY+wOL0a420Jzio
LVvx/kMUW9urkxS0Zd88pY6jczWyDYH/87e3mTmfFrKalk8F7qiizqdC3oAz
qXab88gaKr3V+e3GcSzSxtxcZrlZ5nWah8+RIcXGjBU1oZ3qEeht8jrU01iR
5oVc0T8ut2R4L56sN90J4rmi4zujr1VfxnWZANOdBOOtf9RRiKfTjD7M6HlX
5gUwnM72nBc1n2ZmBrV69DGSfG1nxLVqhVSZOAqNI87fquMbgWQ+nvUY2WV+
kfjNaGRj/HTKh388ItnjW9WkbKpXJJAzKe85GWcd80Zd8g7UmRE+Pknquujj
W1JFrSupt9U/Y/1BSA==\
\>"]], ",", 
   Graphics3DBox[{CuboidBox[{1, 1, 1}], CuboidBox[{1, 1, 2}], 
     CuboidBox[{1, 2, 1}], CuboidBox[{1, 2, 2}], CuboidBox[{2, 2, 1}], 
     CuboidBox[{2, 2, 2}]},
    ImageSize->40,
    ImageCache->GraphicsData["CompressedBitmap", "\<\
eJydls1u2zAMxxVL8kc+2gJDsXanXotir7Ge+hBBYaA9FB2y3vcs2yPtfYyO
f5KSJcVJ3BoIHUnkj5RI2n7Yvj31L9u358ftzf1u+/Pp+fHXzY/XHU3ZhTHm
ln53V4b+v9M//n0bhsHYvu8HvswawlyRdDS54dElSahUdK/i7Bcd+YRAUgkX
atNMrp6p7RIjF73TnxWvr3XdWIpRI+sgfNRVHhN4DU6MI/3X779h9We32qOL
dqP0itQstK3okxTenhf2bVzwYsULTB0LsRdEV5xoVYxrZtkwa+RqwfGRo9G0
iS3GiPg4C5g22RNAFYk2nEUMvWT5WSxLAucg1rRIqlCpEj1YNzlNT2uSFrLg
o55kkONOI3SzmI5EzXOjTpVkiWSo2jE3utvugyzZ7DSrIQFUfYiRZZuLd5Lj
NFdW7/4zvCzziMoXdX9wp6eomiut4KwT7Gd3fiCzUg/juA5VY8LFHmLlSKZj
D57k24TPS2mXpPHXRZ/SspUOtfrAwJNkopbCkyP0cjV1OklWyg5YnPTiEy+B
iGedy+OOjXo6bhBB4TfArGzOOwtgYgazvrdHdw2lZV5rSmNDxTSsMUY6lwoT
RLdMdnospqLfOYq//wZNoT9IGmtzn+SU5AEq6nMVaOoBcwsagqKksdcV2xUc
VNU6cJK5nMPvf1hm54wnJCbkHZlmXXssvB/JEsabwrdXe4d5r6dQMpInINTO
kijGJ1gXZoWg3yeS0DKKNQkMJZpooP584Q9k7s4Qe7YX0YOUc6oLa6fWX3HX
E82/Oa4DP652BWNTeHZh3PPFqtJly4ndrnS3yCC/9+WrK+G3GgE05Itso5wp
TxescU4SSb+UKlv8B7DO+hQ=\
\>"]], ",", 
   Graphics3DBox[{CuboidBox[{1, 1, 1}], CuboidBox[{1, 1, 2}], 
     CuboidBox[{1, 2, 1}], CuboidBox[{1, 2, 2}], CuboidBox[{2, 2, 1}]},
    ImageSize->40,
    ImageCache->GraphicsData["CompressedBitmap", "\<\
eJytls1OHDEMgDP5mZ2B3aUIKiFOXBHqa7SnPsQKjbQcEGjh3mdpH6nvMyq2
Y2cSTxZGoivwbjL2Zzt2Mvm5e90Pj7vXh/vdzY/D7nn/cP9y8/3pAFOuMcbc
wv/dlYHf/+AX/V+P42jcMAwjfcwahbkC6WFyQ6OvIFHFwrdNsxc8ChkBJBPO
+Wmnnp7S0y0TT6pP12xrIUCa8Sk+sTE9E4wHpadvv0COvw/HtFcZ0aG2i/rw
Z0gjJBuOpCe7wHakD3Zo6klM9jGWfA2tGrfEchVWiyIkVsSZfM1wjFHXeTTL
C9CpvCwKGkcrqtMq6ac1w5nVIqID4XHdJR7GWBA6Rr+cmGpSEkUPrVXGrKVp
XjLm51UqVw6k9O5/5caA61ysNmLaJbyiK6jRiWnVinpee93Vi2Je6EPqGzIf
WO5P+/DRR/x0s33llvBbtXvgsSuzYO2+utfsOz6mvffn78hpR/2pz5vjvqp7
MXp13AlkA3Dkk5Oii97JQ+2hIEEu4FFb8sKfcGVTR2a2eFa1NJj2YZ2QRxNA
IJFKi5gYkEkkPtbshyTsLifnZZ5TlqNfRp1WQZg+FiLOtJWVwxwamML6NgUV
gYk6yIeAhR+iFh2OgOPMFQgv+epdnPWRRCe2ctpqcnlG4DBk1ZTO0XSqnXp/
VeL2Ez266hXbVtj520j7sDMfdP9A6mzPesUK1Tf4vBfOyh2BJxp8dXISJVM7
OwXRcAvCsU3+xp98FW947qVNZc31radJd43cX891dpWVrRPain/LlK7Mne9K
llec7xxFt66V31K/59E21+K7iU9nzanKaWJy5eBRvHuslWbHcSMr3ig3kp1P
2WU6X0jnDGQLo8tY++YNtGVyKw==\
\>"]], ",", 
   Graphics3DBox[{CuboidBox[{1, 1, 1}], CuboidBox[{1, 1, 2}], 
     CuboidBox[{1, 2, 1}], CuboidBox[{1, 2, 2}], CuboidBox[{2, 2, 2}]},
    ImageSize->40,
    ImageCache->GraphicsData["CompressedBitmap", "\<\
eJytVktu2zAQpUjqZzuOi7ZA0FW2RdFrtKsewggMJIsihZt9z9IeKfcR0vmR
Go0o20AiyLSGnHnz5kNKP/ZP94ef+6eHu/3t9+P+1/3D3e/bb49HmAqVc+4z
/L7cOHh+gSf6fRqGwYXD4TDQ5TY4uBsYPUy6AA+8KCsfYUT1IBo8+16kZjL7
TqRO+UDQNa1uBWlVXN2IrQeSNBMzx2TjVpklKD1+/QO3Q31arbO+4PZk04rX
iQ0OKA9/j6jUn7CvFa9G2cHIGiqX3sgNIcQ0ywRci0Mt3ulGrM7YBiPXhBUM
VqcjASCPA8nK6tWowaBGg1KUz6JGGJo3Q9L8ilHaLIxa0hUlVKy65WQ5+yIa
9gqCNZkb19lyuwwtwoBcfCnyOMpu1oPIPsr+VauSSS+49WlcuDVv2k4JU/mq
Rh+RffBVrFdjdsDA+5QZjrW08VTFOPrFjpjvC7TKuayzpxTXRfjeVDX1iq5Z
yu2ZCETbeggZUVzgI+lMPeSTZCmCBfycIVlHbDznojmdNGZ6OyCX9Qm81B/M
L3NAifIhmvKe8WexMQWI1xTxgsGrzuNxSJTXfCLHMVeXYK7IhjX4shltVbVS
j1QgItYUL2nH9J5aqFGXEKXxwklErCQq1/+eh+JpPukMDHTsbYMa804QzN5g
+iVMYTrHRMgrQPG6I1TmUOR3cjojaN/O6rBTTJycZFiWiPOjPRdK7T3s9Z34
543FF8oUXWRbNhTO6lRAla3YX5G+dAsRZf3a6PeiHxJn+MfHTZK5kYRl+rbS
mh4GFNsCgs9+u9kJvDH6iclo0xe8rY1VFKvxfbI2EWo/qYDtoL/veoXBX41b
g+GVxo40rmFsQPrA1a/+Aye/erc=\
\>"]], ",", 
   Graphics3DBox[{CuboidBox[{1, 1, 1}], CuboidBox[{1, 1, 2}], 
     CuboidBox[{1, 2, 1}], CuboidBox[{1, 2, 2}]},
    ImageSize->40,
    ImageCache->GraphicsData["CompressedBitmap", "\<\
eJy1lktu2zAQhsckJduS5VectMtss+gFeoB21UMYgYFkEaRws+9Z2iP1PkI7
L0nkiEWUtDFiRhT/bzgzHJr8cny6Oz0cn+5vj9efz8evd/e3364/PZ7xlZ8B
wA1+P74HfP6NT/y9adsW4ICtO51OF9zbYeuxBx4VJ/7Ankc2qoPAXfo8fvhO
b2R8paTDgYAjQJ32x5mQHSuqzoLvLUBJyiBKmXHLg4uMdkHaQrS9nP0CKKLZ
61SnPoiuJLuoaUhTxhoxt2YVh8hp4CBhHcVDUkeNZoikq0mU50YQktYpheoc
FQxVvYAaPBTKGw83hirMXMtJVGmoxQuowcNp1NxQ8yy1osqkkvH4oMW1NF6W
WbJS0pt5LV1k6bnSZURzlXNy8SGpXOOBrmRQG8toZwhTpFa0riMrobeCf77b
CbmcJ3U8RCWbzZmoyBtbX3lLw7rkLW2fsWJ3iJtkhakQZ9dW5GySnRB5A6+2
QqvkXk3bjNjdb6xozbydFdfV3T/5QNnM+8CFIumAfc5Csq62Pp630Zi6/B+E
RDqcj03kp7x1I4bPm9AzpPn5q43nraN8ETS2Qb9NtMXLv5FZj/mgG81eZ2zM
sEvsmPcjft3xGnaGDwMPLN0bphoxFN2VUbl2XMv5maTzjvii56O9nFKUX7lh
4DAyhF1SE4a5c1x8ypP8KspkfqaiI/B/QugstL/oitZReksxvu2w8aCpjHOR
kAvjXaNUYdY7ziLIOR9RS2xo51eG8glVmbiCUhtDuYSqNTZSHrq1Sk400TXG
p0O3Nr1QdOucLrp7impjfCWV621sM/neajSD53szU92viNQf79pefWHUZbcS
+EpuD4fuzBafdJxeyG3tElu6osqdFGZ/AFAA5KU=\
\>"]], ",", 
   Graphics3DBox[{CuboidBox[{1, 1, 1}], CuboidBox[{1, 1, 2}], 
     CuboidBox[{1, 2, 1}], CuboidBox[{2, 1, 1}], CuboidBox[{2, 1, 2}], 
     CuboidBox[{2, 2, 1}], CuboidBox[{2, 2, 2}]},
    ImageSize->40,
    ImageCache->GraphicsData["CompressedBitmap", "\<\
eJzVVs1u1DAQdmwnabK7UVupgCoOvSLEa8CJh1hVkdoDKlp651ngkXifCObP
9mTiansl6k5je75vfm3n6/H5Yf52fH68P959OR2/Pzze/7j7/HSCqdA45z7A
7+M7B+9/4Y1+t8uyuDDP80KP26Nwb0FGmJxodAPSw8gDwIWnTz9netyBVq9B
IoELsAqL8Oc8Cpp0DiWzXiqeLmksv05FY1IaF6gRWYNpdqSzq9gblC4Tsu5g
PWeIG1G0WV98GAnTC2Ybj7HXaTx7OBBDrHgYawwhMziPQtWhz0w5F2fR7ENB
h1Rbidqy5LEkOYDgTBU/2jWTIK8of4WJq9yaGOrYCQRaico6Go0mBkZ7E8Ne
0L3x3dqOVfQgaKp/LGi3wYcqvhf8ngYZzxQsN7WoM0Vhsp01VmpCmV51qoou
5swKY2sYd+u9ITUOJl6/YXT09DU223kv+EehS3XH/4yHujHmqsJCOMuBYzw5
+so+alboVaUF3ame5Mf//rNonzpTs/OcYcPZEqfdN6VbvXCWTrWc2B4DsrSm
/zc91VS5cDghPmrweWwv2GuVlddZ3WbhTeKQAts9qzhU1LeIqpz6nDNUfg8a
SLO9W2R/wetlqgD8x9ceBJ2HlNMXcOr0QLXJcHjhGNZ5Lb5V8Kg/qVwWa1Hf
gMrL4JInZf6ATNlOZ+yElA97MiuGve7InPt0C1NmzDdKaxhGilrXt8m3/+ZM
N3dsl7IP03xKjEbLm/EFjdEkP4ikOfoyyblQCMwKFpa/cQ5qNZ1NyHG1pC8g
bLEb7sDmH8C6zHM=\
\>"]], ",", 
   Graphics3DBox[{CuboidBox[{1, 1, 1}], CuboidBox[{1, 1, 2}], 
     CuboidBox[{1, 2, 1}], CuboidBox[{2, 1, 1}], CuboidBox[{2, 1, 2}], 
     CuboidBox[{2, 2, 1}]},
    ImageSize->40,
    ImageCache->GraphicsData["CompressedBitmap", "\<\
eJydVttO3DAQdTx2stkLrFigFU+8oqq/0T7xESsUCR4QaMt7v4V+Uv8namc8
E18mBi1Eu1Zsn3M8czxOcrt/uR8e9y8Pd/vrn4f98/3D3a/rH08HHILGGHOD
/29fDd7/w7vwvxrH0cAwDGO4zJoa8wVbj4Ob0LvA1mLPIsHA0/ffQ7gMz+5k
1gDO4iT+jKWGVHGIWlbdYgsK6Sbk+HpIyJNsxUWAMYJBq4BZV9btqfERK6sv
A75Xq1MyqxIvMTC+y2KAEKVap2X5fKk+MN2beSoFiArGUpPtQxeVogfvsEGx
28CGaW8lYa1Cfd7TlAbHIcpHK7VRiY0lpFcx+VIpiyFXAlFyWYYkrNXcUWqk
1NW8ctiPu8aRWZXjsuq5ckp0uHDqOp1ktAlG5QXDrXYcqipOVLblacBfqE/l
jk0aLmqIwq6Wh495yBlwpYKcl8xNcWX1UbV3dktrwcxh1gkWSV3oXapqpHik
oOCTOn/+jnk4R+hQ34bawJ0iOrDAcWxym4JgZsXlGNBcr1bD4Xg6NoGvlhSK
JyDFESOVmrR1ZZeU+SHSE08/F3EsPWW4PpuqHhXaJl+ZMjVZ3Sh2ecaoe5b5
REtSvTTYJcacNXfjcuKTqXIWFT+dpzxn4Dzp9iTGkM5iqVHkKaz15JKPTCkL
OcvT+0Twmt8J308nNgpkzwLJLEWZ+Fb4/Rt8kLfhKeKItsn2JEXp1SoLQZ8p
NPvQKrSLlcIwmj6XdZvZO9mPZVXsCmSvZp3q0xcGWc1nZilcjaJxMmMxTl8c
8/1ZCIa/XMgXECWCbsPoqfQuuIaa/7qNxmU=\
\>"]], ",", 
   Graphics3DBox[{CuboidBox[{1, 1, 1}], CuboidBox[{1, 1, 2}], 
     CuboidBox[{1, 2, 1}], CuboidBox[{2, 1, 1}], CuboidBox[{2, 1, 2}], 
     CuboidBox[{2, 2, 2}]},
    ImageSize->40,
    ImageCache->GraphicsData["CompressedBitmap", "\<\
eJyVlktu2zAQhik+JEu24yCBiyCrbIui12hXPYQRCEgWQQI3+56lPVLvI6Tz
4mukxo5g06Q0/8eZ4ZDyj8Prw/h0eH28P9x9Px5eHh7vf959ez7CLdcYYz7D
98uNgf4b9Oh7O02TceM4TnSZDTbmBloPN7c02kOLJsaD4vnrr5EufnYNrYWR
hUcOnjHr9xHNmXUZ1Y7VaOSpYUu4C5012V4UtBXZ8FMGss2msBnQJiQb7piB
7Ho1L7RmXduLn2zfzSLJ/vZxLPNYbIqsdUQIQphFepIk40RyC6T2BMkpn9pE
oruShNVZFBCJP+dR0DfMmy0qIEf3UZoTWog06Fe5YqCmiVrTUi25VCRM8kxi
WPgvy8U603Et6K2KrBP9hpKU9RxPMZ+smV2keMmHrsqh2EX8QSu84Rc5VjhX
Khpc83c88Uzga7+g9Urb1LOLt58WlLQXp3hRwZ+l9QseL8+qq2Gt6j1g1hZJ
sW5NWv86847yHGPgRS1jeE/fid7++TvN6kp4+Tw7zfPCa5EXyoowJKxPhjq+
XEmZZ8h8QFqur7NJ9OYgbXkyO3XSzbUxK8ah2Bhsd5ShzMGMN9BHdSTUOwWH
IargF7sXKs9uTvGZwsj+BMPOGCnuQrWBBvdcvSo4l52t6k5pO9GGeh2wbmb7
O3uY9VhdOFzVa5H01Vum8BeH22JOVjbpHVfO2YuPyNrFDEndsqKVWULMRPE+
CKKyib+anTj6dGEPssfRg8zolUITWkXwQsBpea8N4rNW4tvZyWLym5r+44Rk
IYuJUSCN/wFtU55z5LgCKLski52M9lwTzT+XhOVj\
\>"]], ",", 
   Graphics3DBox[{CuboidBox[{1, 1, 1}], CuboidBox[{1, 1, 2}], 
     CuboidBox[{1, 2, 1}], CuboidBox[{2, 1, 1}], CuboidBox[{2, 1, 2}]},
    ImageSize->40,
    ImageCache->GraphicsData["CompressedBitmap", "\<\
eJytVttO3DAQdXxJNtllKWVBqE+8VlV/o33iI1YoEjxUVFve+y3tJ/V/LDo3
O87ELBQ1Uiaxfc7xjGfs5Gb/eDd+2z/e3+6vvx723+/ub39cf3k4QJdrjDEf
4f50ZeD9Cd7o/hBjNG4cx0iX2aAxV2A9dJ5Q6wIsQowDxsPnn2CNhTZjz8Fi
y0Kvw1FEjXSJ2pkgEh9Bngwj2a4Ju1VzIawtsPHXIWM3xcwDYkLGMMwMhBsq
869JuMTze0+MruLFlmbIcJmB8aHwJKQ1EB551pY8nmlFTJ/WX5a2q7Hd5KRF
U+SrJRWnVFZKpS/yQgJkpP1qFcwDRmirPsEA8JH9OjUnauHtaj6riVZXaFGV
4tOzFsuFuZr4gmouVZH2JWS+eOSrGq1obJQGrnXGStYsKVgVU0g1nGMySU/X
D1jcn76qY2cr+1It5egmHWk3k7pndb50JodKdfnntQpPL/+dKXPWmMtMuf/O
vVAnnD/CpYcs3A54tIju958ox96xeUvuGVYWvLdIDaoSqBob6MR1ahbcYbFP
UGlAJV8qPa+SM+xz1HBtUaGopeP8LkcP/cBEMitMWTiu4MXzkFg1FUzVUsXn
ehONvqox351zDfoWKtYGDO4yzkiZQbvIwqnidmCc5I7zkMjTyYDfk53g+gVO
/Cr2U4oEfdoWewhHGR0Uuhf0+yq6jcVXU/y2KWaJDYE7wTFrtTgt9H4+n+F7
aQWFOo38B8K7Ya1G9UmFX3hMQxfTf8EyKytR5H+SkxzdFIkTxDtCoAd47O44
m81fD4TeKA==\
\>"]], ",", 
   Graphics3DBox[{CuboidBox[{1, 1, 1}], CuboidBox[{1, 1, 2}], 
     CuboidBox[{1, 2, 1}], CuboidBox[{2, 1, 1}], CuboidBox[{2, 2, 1}], 
     CuboidBox[{2, 2, 2}]},
    ImageSize->40,
    ImageCache->GraphicsData["CompressedBitmap", "\<\
eJyVVs1u00AQXu+u7dhJkwiKQJx6REK8Bpx4iKiy1B5QUeidZ4FH4n0smN/1
eOzQ1nI2a+983/zurL+eHu+Gb6fH+9vTzZfz6fvd/e2Pm88PZ3iVqhDCB/h9
fBdg/hdm9Hs/jmNIwzCMdIUtDuEtjBleXtHTGxgjPEUAhPTw6edAV9jR6isY
kSAkWIVFuEOEAREscTT4BpdJ368zgljfXiQsR4tDZkl4C5OeZLcr+jojy8Qs
23nLGRJ6HOoiL7Z0hGku+LPQ11g8W7ghhrzw1yFTQYaIg4l/MzEA6HpVmnVN
0klzKDpeq04JXnoW6ghDojj9/jOi/zhVpESIkVGREs0DZhvmGYD6HoHZ6c2r
6A3lrkRIrGhXuaY4pYtcSNUrGv/hqh06rqJb0b1DVGY0E3jtDi8RzBKHUi1c
F2G74PP2VBNfLnzCVmt8SqH1cz64Y8mV56RASTZRajNng9vGCqcRh9pK0GZY
sPXGS63NDrHNFHeO63Ns82yI4Brg+qFlje+L2TB/SeIUdU/ZvV2XbK36W3qG
47Q7O0nPy9QbbPzYg/hyRkRppyo1ESQC6EsFC+h99SQ3xhNLptFOWch8d1Cu
aV8suDhA5NisUxdO9MTbNufDR+9vazITnmRpNG+DXohpHOfGcaZ1TpNDdCRL
rXgLS/eWcon/Z8NzaLGb0IrdhfODORC3pz1ud30nvc2cWwxyGUPgQXeO6KsF
Sx16ce4JPnP1MMtBIqCnpvaPTntPgVfz00Qs2At+r91lpktPSLJR+g7u9hS0
q07vd6YLTAyN05cEbftCXmGqzK6BU8ac1Nl9CdUO3a/a0TlUcs+NYymVBSLc
Y3qHiO6ZvilSaaiEbEf9EoraWZxOTDJ/W12ZVbQb/USO46hfXliI11wD1T9C
/O51\
\>"]], ",", 
   Graphics3DBox[{CuboidBox[{1, 1, 1}], CuboidBox[{1, 1, 2}], 
     CuboidBox[{1, 2, 1}], CuboidBox[{2, 1, 1}], CuboidBox[{2, 2, 1}]},
    ImageSize->40,
    ImageCache->GraphicsData["CompressedBitmap", "\<\
eJyVlttO3DAQhr0+JGQPKSpFrbjiFiFeA654iBWKBBcV1Zb7Pgt9pL5PVOZk
ezKbaNso643j+T/PjCdOHvdvz8P3/dvL0/764bD/8fzy9PP6/vUAt8LKOXcD
v9tvDq7/whX9rsZxdGEYhpEOt8XGfYU2ws2eepfQeuh5ELjwevdroMPtaPRC
Rl2AURiE03lskAq3sGXqObTBWMZsOb4fqmWvZjwjM7Zg3IZsNjO0DpvEtsXc
rcm+s1GwzK2nGvGDNe1ibGbORut52o4IcTFmQwjVa4+NWpO2kEo+jtQ8Z1VL
v6hDXmeJ2lKwz5mxflRSMyUppSY1QvK//4yaFkxUaZbWQ4OwmNVwXdXVF1Z7
E9VW1K1RRzN3nFV3ol5nNf7DkYw6zKpbUW9R1bCaAVwSNpvzlJizl7PKYrdZ
oNqs+kqNJavCTDQBS1lNkcZChdP/E9PR0dKTU3jiaaeyh5dUBxMrjNasgK0l
W4HCalQW2Ae+mPeYUsyp5adckVHBVcIrQomgptjA3XiSg5UVJG/eRK55PEs4
yUsmYmTiDlR8lfxNSWUfWyChgva+OQ//i0rxwlizRJLq9qdJXAbvh1LRlukl
r3plV8KtTwxysZtkJXT2gqpvrpey3yzyWuGxmBcP2dGyjWenySE/f0M+ksp/
rsooUSfDQ/4Kusg9ZmOQnaHh04PdzpD8EQkH+2n1w0nv91R0UrSyG+R3mmRj
Z+bu825RhGoXEb9R0msdDO0WdGFRxzHtVIzVS3pnGk/xScLuZxljy8bwY6k9
BuLwF1FwzvK3wdxaXUwsbf5tpXyCJpXdYS1aa4XfO5iYM7LaHuWpk3H+grL5
iDLH+Zi/r3AbveQ6Wn0A3uJAJg==\
\>"]], ",", 
   Graphics3DBox[{CuboidBox[{1, 1, 1}], CuboidBox[{1, 1, 2}], 
     CuboidBox[{1, 2, 1}], CuboidBox[{2, 1, 1}], CuboidBox[{2, 2, 2}]},
    ImageSize->40,
    ImageCache->GraphicsData["CompressedBitmap", "\<\
eJyVls1u2zAMgBX92LHjtAWGAsVOvQ7DXmM77SGCwkB7KFpkve9Zukfa+xgt
f2WZdho3SBRLJj9SNEX69+Hlvn88vDzcHW5/HQ/P9w93f25/Ph1hKWycc9/g
9/3GwfUbXNHv6zAMLvR9P9DHdTi4GxgjLO5pdg0jirgIGk8//vb04XtfYPQw
83ArwD1iwTWOzLpS7cDaKBRVcng9jpIXBWtLYizBQjuS6USmpDU4pCwr1luS
b4x1GN2O5Fks40W+nu3H2AlZz3kcitjVRIgn93uOJPNMCvpsHH+2ZyjB+FPN
KKiwjgJK4ss6SgUDTl34939YRxJNSwpCigBSixojb7I1riPCZb1Ao3xmEtxI
xPJmn41406o+/ju3Wr8W/Q71KtZnBGdqMDvyixTMH81I/N8hImYafHEVF+Ko
H7O++JA0GGya9zSjfOBR5BgX2RiZxsCmiBFeehxSjhGHycXpDu0zE1o+EcKq
iDXGn+Oy5O9mFT8YPmcbnwLNwiyvUZhZ0eymaBoL0VhAX73WPfHKmyfyeStJ
rRRErF9Ucary6TAjrCIiBd1Y9DdlWYGcZ2IsEFNppWae5JKtW9Ndo1A7zTWh
kaJgau0XGbuOymfm9dgWO/3IJ3OyyYvxPKeTpLG2z0lRSElzsMjRXdFTdW0D
U6QIaTzngm0MB89SV3RcXZtyqN/TUSjjjPUPF4r+Kv1S6oJ2OsnyvbGdRD9q
LZj03Hm1Q7GLwouxejW6ml8bfK7+1gustjjda0Wa2EvGXiOVj/2wexnfZzhO
ldGOol12OrRwiesS4el7RbYvuYXzTn3IGs1Sr7Pd/UQFo3Dk096KbUtAn4Ik
0HbQtyt+0mXFxnsow29p+xzvcb8YOVS7IolLmV1zfm7eAcj/LXQ=\
\>"]], ",", 
   Graphics3DBox[{CuboidBox[{1, 1, 1}], CuboidBox[{1, 1, 2}], 
     CuboidBox[{1, 2, 1}], CuboidBox[{2, 1, 1}]},
    ImageSize->40,
    ImageCache->GraphicsData["CompressedBitmap", "\<\
eJydlktu2zAQQGl+9LPltE0KBF1lWxS9RrvqIYxAQLIoUrjZ5yzpkXofoZ0f
RyTFJE4Em9bQM4/D+VD6cbi/mX4e7m+vD1ffj4dfN7fXv6++3R1hym2MMZ/h
++XSwP0/uKPvp3mejZumaabL7HAwlzB6mBxJ+ggjqhgPFndfHya6+L9zGC1I
Fv5y8B+zHo+ozqz3omEcW6OSpwFknKdxS7r7uFKi2yS6DGbdXbLygDpBdQQ8
kF5fMGE021xf/GX9drWjxZc+yrKOxSGJXkuE8NSOXySJrCRXITUFaUiiXvOp
URLNShC6F/xxPMyz+HMaBX1D0bg/f+eMBHMMO5HkhOQBFPWyONVpYt3FmmEZ
PpjNNrLwFy5ieWYxLjxJQ7X+jfYxKju0a9ieEVyrqi8Zs0SxRYS87EJrEoyR
MuDglQof1MIJX+VY4YSEg7sZcu/UwWe880zlS2MudZjHC28tyRqvxTORN7m/
aWUG5Yq3Xck23Hcn8tzip1aUkLxEcNVDrya7gkxUzxvgeumq3Nh3Rk42tGu0
7guv+TA2p5FSQoAhVkra6e2rSbglfT5oisrs1rOz4i4MpTKPC5L2HbSGxBh9
3sANMnOunpBeY0WdAZRmyUxsAl/46J/ltnguxNM5iQWtlXVjuXdX4eadjmLQ
fknq6S1sv7B5ob4gY1RR7Cu9nrPorQCtVx1JT/ugtpIZu8ryGTVZWiljPEvU
bH0CotEeBvRyn3i5rJE9KyWvY3HijIUl7ykU6/QS2Q9V7aayjtUzY+mjC9Fj
qy7uUc/LstbOM/1epDK7ZzO/mdGpbLaVfKUyvtFgSvhtop6hToj8tjbq7pad
ONF4RxroAT4mLjizm/+/CWl2\
\>"]], ",", 
   Graphics3DBox[{CuboidBox[{1, 1, 1}], CuboidBox[{1, 1, 2}], 
     CuboidBox[{1, 2, 1}], CuboidBox[{2, 1, 2}], CuboidBox[{2, 2, 1}], 
     CuboidBox[{2, 2, 2}]},
    ImageSize->40,
    ImageCache->GraphicsData["CompressedBitmap", "\<\
eJyNls1u2zAMx2V9+KtZuqLN0O3U6zDsNbbTHiIoDLSHoUXW+55le6S9j7GR
FCnTtBc3SARL4v8niqKpfDu+PAzfjy+P98e7r6fj88Pj/Y+7L08nGAqVc+4j
/D7dOnj+C0/0+zCOowvDMIz0cTts3C20HgZdgIc8yTMHaNE8sEUeveZePRu9
4l6r1kDoBc3umdSvzu5Y68FJGonFR9G4vngJRk+ff8LXoT3NpmLP3I40Da86
02CD/fHXCY26M/qk/KqVDtpsoWLpTb8mQpTR7IBrsEm8On2R1RotLqP7iVjB
sFq9EwB5bKifVVFQWeKC2PMZ16+iBkPFWOQYgkbF1Buf46vpqExChL49JVSf
8TXqaCKrUSwn3k5WMGHiybtAGi7ZY6fO+ozAATfFl+MXVik1U3ZzCu/LcTxN
3iwokSNa4sDj5FvUVF+Yk2eZ6U205JTSGlPUkke1yVGuAkyNnFL0aTd4jdlx
tepdt0GhPc7eHClZS9a7Fa0vJ/hfT3jlNfXmyqw9KC1axTNaqbcYwxvQUVDD
7z8jv7Jm3TJqtVeYcViPUZp0briV3KgW+j3re9SHKe/jprKXN2uQz36FUUEX
tXO9VMMo9RmUKL40hHCWENn3RKqJspe+OkNDiSVfmNGtMrKVvBdzBiLeGNUO
GqqFs5NAil/E7z3YojTOT45PespOvIMOzCUvY6lu7M/8phHv0Z78iyUSxT4Z
+47tg9waaj86o7Na7n5t6Xk3i1vARqf40C5qSdmFvvmUXrycGB17koyyNsrI
ylgq2cXGDd4oghwojU3/V1bWRH7+R7RXs7kW5Nm3NHsJLV4PNzkrqn/zdwD7
\
\>"]], ",", 
   Graphics3DBox[{CuboidBox[{1, 1, 1}], CuboidBox[{1, 1, 2}], 
     CuboidBox[{1, 2, 1}], CuboidBox[{2, 1, 2}], CuboidBox[{2, 2, 1}]},
    ImageSize->40,
    ImageCache->GraphicsData["CompressedBitmap", "\<\
eJy1lktuFDEQht22+x0mhEQoRCyyRYhrwIpDjKKRkgUKGrLnLHAk7tOCqvJf
bnfN9BAWWBqPH1VfPfzqz9un+92X7dPD3fb203779f7h7tvtx8c9DYXKOfeO
fu+vHbV/U0t+N9M0ubDb7SYp7owrd021p0EXqJEmMfMaMwH/afSSaobUi9EL
9LrCBkNHmT3H7MC9mD3QEbEXxAfyE971K7IDWJ5EXXj88N2lIrN1lod9obi2
5JMKa3muxN6PPev3J/TrwmZT6LFqb7LqTb/JhNJ6y1WcKc51Ri9IfHNfCC6q
FDgdV3XmIBaxyXQOQUqOFivcrNOK2DxXxZr4TEpgm0ceTeSgZEhZclQyLAel
0nimxrw62G8r3FjGzz62BU3iWEqdpLFTA3caZEscSPss5wNZDEcpDShnSwoi
Y3mmmB0zU5CRSJUvVw7jQ7mSukaN2QE4taDGTAWzfgbTH/G0EqZXptPS/YUn
nMUu1QvHzecF2ev/I2u0+wJx+vU4/5Emnv38Nc3nwXgGXcvqiyhZK+qqZlaa
80dpr+RKydpUkpqSPHU5zooGOLYUn974vIIXROAlrVnR7IRQjuXslNob3vF8
Q7NkzBl5luURupulLoTW9Vq9+XLMEof4mo/tCYaeMTYZNUL65+a5UtLVJ/k2
lJgp8P/GZGldJ5W3yIy9CVRnGe0bkg5AHL5S8371+sohkhcmMl2Pw9e1Wr4I
2HobyG+K12m2qO/iAKlL9NNsa1gBMZQRXy0i7g5ulljY5ebSQo9ebaT4eyPm
O3A0s/aFHiEt/sq3iNeTZt5xTnz6orH5iGC8nPR7p6HeVVrH6g+bFfih\
\>"]], ",", 
   Graphics3DBox[{CuboidBox[{1, 1, 1}], CuboidBox[{1, 1, 2}], 
     CuboidBox[{1, 2, 1}], CuboidBox[{2, 1, 2}], CuboidBox[{2, 2, 2}]},
    ImageSize->40,
    ImageCache->GraphicsData["CompressedBitmap", "\<\
eJy9lk1u2zAQhWmSkizZFpIAaYugi2yLotdoVz2EERhIFkEKN/uepT1S7yO0
84ZDajSSU6MFKthjkuL7OJzhjz/vn+8Pj/vnh7v97afj/sv9w93X249PR2oK
K+fcO/q+f+Oo/ItK/L0ZhsGFw+Ew8OO2MO412UiNPdeuyXqqBfndcesVWQgr
RSArhAvpu15828vbDrVYRqfCht9vhO0C+SietSf6tsLy1NWFpw/fXHqYXZX+
Mj63ukY0zCcJVB6Gx/t+hL41kfGm3jApak+FFNkkUoKtz2ZhFuupnj5WH0y9
Zn1pTa4kTqU5mBf3hbdJ7irDqqYsmdNaRQcgD1OV7LDGjTEUdvwrdiCDOERF
A916yvQxljLr1npKxUb7BcfPJkHd5XyIeu5JWNQ3ot/mPCS95MEy/CIjCqNE
VmLWmRkhH9Big6jZxBJl4VSGs4Gpi2PJN9nrJ7wTZtplzRIvjBOdrxPMLXnI
YZPcdv+dQ/V/4EQ2xZ8csRcZqOPUaXiRJy0fHRPlJLuirNUKTI//8XPQ/lRp
4zBhzNdLzDBjVszUu0T8NMxxdVomlkYLymy1B2aN62m1yEK1hz5q8Z+1jWiv
VFTOG3UehVeZIVeBN1FQDDXrG6gW9lGKGTq/pR6BN77uhXFkb1HxImeAflFs
yPBJyDE9oVMnBrr1huGF0U7jOvq2oEf/XsVyHI3vqHzfKS9R9flmkfYdSGWc
2owTcjzsOawIW70iS+zz7c2RWbphFKHjWev8Joa93e15hzHqHP1ypnZLp6Kq
p3saQ6YHSm7jfzQlFubmRmLT/6KdepvPJTAuh/yvCUvsOq3A1W+/SDG5\
\>"]], ",", 
   Graphics3DBox[{CuboidBox[{1, 1, 1}], CuboidBox[{1, 1, 2}], 
     CuboidBox[{1, 2, 1}], CuboidBox[{2, 1, 2}]},
    ImageSize->40,
    ImageCache->GraphicsData["CompressedBitmap", "\<\
eJy9Vttu00AQXXvXtzRpo4YC4qmvCPEb8MRHRJWl9gEVhb7zLfBJ/I8Fc2Zm
Lxk7JfCAlYy9u3POzJ7dWfvT/ul+/Lx/erjb33487L/cP9x9vf3weKAuXznn
3tL/3WtHz7/oif9vpmlyfhzHiS+3hnGvyDbUueHWDdmaWl7v0rvTVlMwkFWG
LVl0doujl4pdoRVSdHq44PG1jjtPOWpmA0yTfJWPGXgMQVwg/8f33xxfq2cQ
nUaoyc8DwZG+H07jOL4LMZKXSIAGNoIXiuVcMwOi9sco+g1mLWrTbhnvY69O
tS+yR/SaTKsxSrQ3bM3ZbJJlvIRXRAaueZ5XNbK8ngyYQuyXFGZs4Sw2MHUF
E/paw8QcWVOd70AG6AtGCxRom8cyulP0htcyo+fzqBfxQfFbNNqEFwryBWXI
yJCQituZrHm1ZvvOMKT6SIqpqlYDYSvX3rAtrcgJLqy33YGiCUurq786gyUY
luo/saAt592/oKE1APWPn9OfNfZHfDF6yefj6THGqwVzY/bQrOqrZeaQmeXQ
GJgtVdNfsWGTbYAPuRpPY4+rCc3rQiNEhdoVNYGYo+ZKvIx4kZUjG3yupHK+
0JfueLxMOeS9esyRZlmg1mT4fJzVoNZ/fHOov8V3im9irSaC+fmRs8z4WvHD
CXx8g1+RH2CbYk1ylo2J0qv3tfEWHVrjHaIGuisw/ELjCqJ899pzcnfkad+I
tu7wHQGppV5WirVe6IcY/RS/Lebr06uPfJ9AF69McN1y75W2bmQPVb8Bws8v
vA==\
\>"]], ",", 
   Graphics3DBox[{CuboidBox[{1, 1, 1}], CuboidBox[{1, 1, 2}], 
     CuboidBox[{1, 2, 1}], CuboidBox[{2, 2, 1}], CuboidBox[{2, 2, 2}]},
    ImageSize->40,
    ImageCache->GraphicsData["CompressedBitmap", "\<\
eJytlktu20AMhsczI8mS7SRAESDoKtui6DXaVQ9hBAaSRZHCzb5naY/U+wgt
f5LzEKUYQtsAZjwj8uND5Hg+H18eT1+OL08Px/tP5+PXx6eHb/cfn8+0FTbO
uXf0eX/n6Ptv+saft+M4unA6nUb+c3sId0cy0uaBV7ckoeLpv8+7b3TVVASS
SrhRmw6rmPn0ZcfPr9R6Z6zl6V6fukAxamTDjMQ7rldPLpLu84fvsPhx3r2i
3SnZk1qAdhB9kuKhyTYaUc92TR0R2cE0shB7QfSmmt6sW2aFBVYL0WSWRrSt
7LFG1Ms83tUCbKu8APIkmNRlnVwn7HSrKIFERK0RA0iC+VtSrn8mOV/pwdpk
p1qWFhlZ0lqkxvyWU8f+V64ELFxvsu9IANOu4U06gJt6kYnOsx28OuaVPrz6
aMyU/LOPKD7kbzubobCG35pJocdhmoVq94tzhYmQiRNNiYXp+pQj0MHzr5PN
lKV1ijvP60KHF5syz5tFT5c6M50KocomT6VqWj63vr6EwbAbU31EDECs6lgm
NKziJYa/3ClS8BVMZAVMu5hzuJgzlIZpzymNDRXTsUaJdC0VJohuqDItMZWO
mlt3WiMXfv4atcyo3S6RdA+kDS1BSJTpuYBlA4g5cVeQYiEJtjcc9Os+caq9
KYdvDrCc1Bjzgg35ha3PBj9749fGb6tnKOcVs73eSaZnF1SuSPAkq89tikZM
s93kl5h0oLYngeWh8iWWm3wTqH316gssiVueQYpFq14a1UyZ8nVDrXzmb2dn
ZDS3CImgRJwiKAx7D7GE1hCiEmI+RweN2Vp2egNo0t1O7nuzWxOyAE1ug4dc
55I53gDMbljjWle30gubP812MNA=\
\>"]], ",", 
   Graphics3DBox[{CuboidBox[{1, 1, 1}], CuboidBox[{1, 1, 2}], 
     CuboidBox[{1, 2, 1}], CuboidBox[{2, 2, 1}]},
    ImageSize->40,
    ImageCache->GraphicsData["CompressedBitmap", "\<\
eJytlstu1DAUQB0/Msm8WmiRKlbdIsRvwIqPGFUjtQtUNHTPt5RP4n8suE/H
djzttBDNOLFz7/F92fHX3cPt/tvu4e5md/3lsPt+e3fz4/rz/QGGXGeM+QD/
j1cGnv/AE/3fxxiN2+/3kS6zxsZcQethcEO9d9CiiIO7hTvLXEivL0bfSG/I
uNCaFb3dCmnZfLsWXQuG0YhPdqmOWYqM8SB0/+kn/FQ6JGmhjqSxkDmNmzQs
NtiPjwcUGp/QD5lVAfW86D0e4GGs4merfk8Mr6NsgllgExKHUWaoWTg4Y7mK
NeS+AMhiQ33WCpV88p3BJ1IdNOiFU5uySNZ2+pOIHhrsOhoviSqH2qfZ59Vr
oTSpU+bgRSi5Ivcqbsgrgoqzye6hQVT/MqbEgZm2ikNQWdbl5fBfZ9AMh9dE
pq9qXHYRmcXzLHw9F3lPNie+eMpSU+11TR/G5nqzrRn63KZfvyNW6NNziPZ4
dB3ybD5fKQBGtsOmqEp3EhstwtBagvw7L8U649DeTp1pLTKNbhKmVYOEXmJq
a+u80mTnsc/S0M+0d+c+VlScsYMhzEw3oy7Lta/MwIkRDFZ4I5rHyQhN5L1e
FEmfYymGRaUj4DgTvw1efc7zExJV7FX7VFv33uNsrEF0MGR51ThnVsMPX6Yv
R/Ztq9g+rTEhjxXZyi7f+k6WLDpvoPZsna6bX+d59ZxN8SDFqOeZ4hxh04rA
Cj8Xne1Mrpt9udG4bfKP/dhkfqEUa4VKa5RZ3jal9QSVV7lt5PZS5FhrmO2g
PpYxvijkR+nVWT2LfNbjtb1q5Cnv4/kLU7GIemKbZ2YQIp8IN8m7yRMnEuck
gRbgtnvJGe3+ArjsdnI=\
\>"]], ",", 
   Graphics3DBox[{CuboidBox[{1, 1, 1}], CuboidBox[{1, 1, 2}], 
     CuboidBox[{1, 2, 1}], CuboidBox[{2, 2, 2}]},
    ImageSize->40,
    ImageCache->GraphicsData["CompressedBitmap", "\<\
eJylls1u1DAQx53YyW6W7bZCIBCnHpEQrwEnHmJVRWoPqGjpnWeBR+J9Ipj/
eGxPJl7a0GjXu+N4fp4vf3w5PtyOX48PdzfH68+n47fbu5vv15/uT9TlG+fc
e/p+eOvo/x/6x9930zQ5P47jxI97gca9oTZQ5wVLr6ltSfLyu+fel9RCsZv1
Xom0VVxqhXuQtztIIc+aengUlJwn28Si4czYQVgtDXX+/uMPFx9+2+XxMj9T
XK/5pAKtFg3P9/ME/cFEpDVyz6SgZu8VAZAVBFLaQjtkbfpszXhv5I71c6/4
wZxOc+DN5v9ZyqMWjcpJMJSqXPyOwXaDoXpDrdpmbV9Qra1hpa1rqSRXKNbW
tkrdUANIp2jI0kqaZClQgwqyFcy2lopybhFZyEFWtHBD5gq1m9clU+hnUWG2
un3iqr6G5+FpYzBcrvxzMZaqAz2u2IhwFW+W9N0TyCyP/PDftIfkeD97hrgz
lXy1KV/PoqfoxazP6Sk70Q0VNmFjyFm2cBAG7GxhsQdMU0P9sLZZT8VeyRbq
Oov1U9YrLG4fZaMOUa6875a6TRUqedWRLStwwYpB4pClFTpnwhPr95wH0fq7
Udlxj1L6lLsxPdDpDXNrmL7OVHmEI+HXbz5nrIVDoknJtP+m4dwl0nL979kB
BFz1CiciDtCb7SSYGx3xnFZKJmNQvESjar8T3cDW6HmVfojVEymXEgF9S4A8
sF2ZUGxWuzaGHESf/fBxfJkr3QTYRhqBQRtqfF7ppX+ffBHbIqE383nRXp5a
cxKudE22ejOVG0n9PCnau6od9t5i99neUHJl5ZNkVzu3lBxvNtCNDzT5hsI3
P7a+MieSHO+PF+ot7A5yjl1N6XaJQnwVa6D5C4pLoso=\
\>"]], ",", 
   Graphics3DBox[{CuboidBox[{1, 1, 1}], CuboidBox[{1, 1, 2}], 
     CuboidBox[{1, 2, 1}]},
    ImageSize->40,
    ImageCache->GraphicsData["CompressedBitmap", "\<\
eJytV0tu2zAQpUhKshz/kzZdZptFL9ADtKsewggEJIsihZt9z9IeqfcRWs5H
JDUcI3JbAiZE6r3HIecj+vPx5bH/cnx5ejjefTodvz4+PXy7+/h8ClOuMsbc
h9+HdyY8/w5P+LsfhsGY69Dbvu9vcLQLvQsj4wKix4YIYzaMMy0OoT2//w4T
CDQHnF6NKBdRxgWcAdHhxykhO17JBkQDCE8IAu0R0ypqC8DWEcur7xBQMx6M
X05xvDbhPPSObIe2ziwETQsdjrGZNbJcxgLCRmWRQfNZTrBWs1heWHg1i1UL
1nLKCujzrGThPFYj1uouYKW1iGXFvrYKy2KopfValYme9nnstnic4SEG00Jl
QjxZEc3RYuZTkOn8lvmNxq8jn+NUt96zRjfNF2PIR02uQntpVB3LOldFjsAh
+tEHZ7LBJ01PnqQsUvOhFjYVMeimFnJcaB7ObZJZ83cqMosslRkQ4+KwV/Mu
RksR5a8r1ByrlzP/3fr1xYxWPfdzCkDWFX7+GvjQpOfmKVgQUOLbzWLj8kWO
/Q+urEnpq9kFpAfupDaUvNVYkfqx4V41v4d5eEXvSVW3pSs0G6FZC003agqv
JE2oW5DuS6HkL1ayhXVboekyTYhKyJeY2xx5VdLlCgSP10LJcrbVKhsmbtG/
sgY2Kp7uImmvb9G/eR2Gul2FCcBXRe0F+G1moVEZLlt7wgCXh1dNwYCKLG27
eZXVCMsOoXPiK1oXrFawNqHTTtgXzIXYV8fMpWC6gtkp+7PMdoLdibEt1PCu
5Pt4+yu9jRbVcczlkSJ5JbCSG9UjkXhrgZPnleum1cZbt0SvBZp2tlP2no9H
NULv1V2Cso9WH4rddPyebhbw3wAWAG+DFN0N3/BoiyNT/QGNkX6k\
\>"]], ",", 
   Graphics3DBox[{CuboidBox[{1, 1, 1}], CuboidBox[{1, 1, 2}], 
     CuboidBox[{1, 2, 2}], CuboidBox[{2, 1, 1}], CuboidBox[{2, 1, 2}], 
     CuboidBox[{2, 2, 1}], CuboidBox[{2, 2, 2}]},
    ImageSize->40,
    ImageCache->GraphicsData["CompressedBitmap", "\<\
eJydlttO20AQhje7azt2EohAUNorbquqr9Fe8RARsgQXCBS477O0j8T7WHRO
exqbOGDBxBvP/+3OYde52b3c9Q+7l/vb3fXv/e7p7v72+frX4x6+cgtjzHf4
/3Fl4P4N7uj/2zAMxvV9P9Bl1mjMFVgPX25odAEWXYwHxePPPz1d/OwcrIWR
hUcOnhEL7tEyaxvUjtXo5IPn8HefPE8y1pLc2IOdVuSzFp+c1qKpoq/M3pF/
q2YHa1bkz24RL/7NKB41j4s6Y9FkuWuI4N+Nd44k40hyoTaGr+UMxan11CMK
Co6jpLUcR6nBYM44aVyBSq2nKkmi1CQnpCrrJgR5RfNH0WIvudQflG0vWFoq
r8yqGDEziOoO6Ll5pvWNRLKhBOX9yVbXy05SvFC25Y6AP3uY4SND4jibiqOK
ccg+8CVB9gycAh9VH6jKSrFcyZL+cZ9i1ap/OSMEk63UzRD8qL5uloFjPDea
MLvkY16JXYKT23+vw3x+53m0AT3Hz1eN5HQ+coJHnbMoyCGmcOZzG6B7h7TU
h0eT6H1C2nTWvK8tdxEOz7L8pPWnOo+VXpSXKrOoXMAQFaJKe0UQLWlgAJ94
ezJRnZIR48tUazB0KhbZx7lkn4b3hPhrfSN6TxXUb6zxeZFWmhhWGG2Ze+y4
eILqdeC6cbjJok4zVmrGVmawauaolv3MeaqV2ov6C35KRsv38NfAj09bxdB5
82HMG4Bceed0E9GuJFqs4DL+ysj5y1AH+Ip/q2yEMzXTljxOwWLZL7jDFv8B
AoOZTA==\
\>"]], ",", 
   Graphics3DBox[{CuboidBox[{1, 1, 1}], CuboidBox[{1, 1, 2}], 
     CuboidBox[{1, 2, 2}], CuboidBox[{2, 1, 1}], CuboidBox[{2, 1, 2}], 
     CuboidBox[{2, 2, 1}]},
    ImageSize->40,
    ImageCache->GraphicsData["CompressedBitmap", "\<\
eJyVVktu2zAQpURSlmTZadAmCLrKtih6jXbVQxiBgGQRpHCzz1mSI+U+Qjo/
/qnEJWBCQ817M/M4FP378Hg73x8e724O17+Ohz+3dzd/r38+HGFJN0qpb/D7
fqXg+Q2e6Pd1WRal53leaKgJJ3UFs4HFHVkXMKOLMoB4+PE00+B3n2FuwWrh
lYZ3zPV8RHfmOhcPpRmNToYmsHGd5i357l2kyLeLfJmYfaco8og+1vsI8Uh+
Q8YJs9qm/pIv+2+KikIug7MlTotTpN6GGOxaxR8yie2ZdIWpy5jGSPVaTp1n
olURof8gH5Ox2JNYMDfUra3khOsxozmJUQujdYzwnOgle5dVKeje7TPbsvt9
lB3axGWEmBSwq2zadVuuuOA5nTq+E/xUw1uPl4pYnzbTx4geeWdSTsZzit46
28W2ytkmGq93VrfOZpiNx0UVF3o7y0KiXWYoXVVFv4MN3cvYl9cl3pT/wLau
K6JqG0ITiRQ7VvViJt5BqcAnErJ4j2cDEwmqAZhUxFxMdxoX9gsW0SHIxv1B
nY+rxc4UfCbw8REeERe6TZhQtQYWUalUrdChXh0Y+4IF3dcZgi5Bh31cAX23
Sob09KBpHSphkUywPUoWE1iYcljlCKcj5aAbNUNNohvvjRsYq9yLswy7Eax1
J9CDy3OeaCV43DM0h+g/QIic3D2C2ElE7OwxQzX+7otjDoLQLnb0zaszdJW4
rrt66pj4m7AVb8b2xbdoyuKm/oNY+9hL7kyk4fO1zWoKnHI3wiu+r6fMs3d6
wRL/G9q56oyvLvL5RD5nMHdgfeEOaP4BGRnKqg==\
\>"]], ",", 
   Graphics3DBox[{CuboidBox[{1, 1, 1}], CuboidBox[{1, 1, 2}], 
     CuboidBox[{1, 2, 2}], CuboidBox[{2, 1, 1}], CuboidBox[{2, 1, 2}], 
     CuboidBox[{2, 2, 2}]},
    ImageSize->40,
    ImageCache->GraphicsData["CompressedBitmap", "\<\
eJydls9u1DAQxh3bSZps2FLoosKpV4R4DXriIVbVSu0BFS298yzwSLxPBPPP
znjillUjrTcbf9/P4/HE3q/7x7vDt/3j/e3++ua4/353f/vj+svDER6Fxjn3
ET6frhzc/4U7+nyY59mFw+Ew0+UmbNwVtB4eugAa7pSeHbQh9Tx8/gmtQyX3
vhWfh6cBe8WPBlZcKEWLisgKbjek2ZoxUNYp7fzrmLWT4o2oabOGZW4k3ahn
JMyJ9FksgQyk7ysxbEu98Fnfqjje0MwXrsdG5bgjR0yZl0T2KV8y2lilLOvB
lGAoZ4YyqFUgwIsomH2cmX8qJvCj+zRaEFr7clrMNGH1ikU1id+RWYxrS5rE
grSQaqfTtcBt1sva+SqlE8pkZoTZPo0QiwybKuh1zXFoaI/wmDjMVDnyRYZt
TS3VYGvKm1ibhR6ZzpddUcvFecenWSrS4QQSvdNzuuilrLLeVbyU0+cjkZFr
bh6Zsl0fWbw7s9dF7SX74qUvSeYl+Cix4fefWfafUHrzU+u9wJqD+w6tramQ
1XverPxb8Y/oVzUb/+sc1V7M17bCaOAnekt/2uli2lvBieZzQwjPEqLE3pJr
oWzTb7WGhhJzvQhjqDJYld6RkoGIV8Y1QYO1tj4f/Cp/70GL1liunKz0Up14
nuyES1HGvL9JPOUpkqJHPcVXnJdNPqe0fhB9qMxHVzS7O32KitLLbPpaRvK4
Z6s9ZDL6FMniGSqjbYwrimvZCzdmhnqctEB98d9hUIwp/wPRDK8Ur0lxDi0e
F5e8us0//NagVA==\
\>"]], ",", 
   Graphics3DBox[{CuboidBox[{1, 1, 1}], CuboidBox[{1, 1, 2}], 
     CuboidBox[{1, 2, 2}], CuboidBox[{2, 1, 1}], CuboidBox[{2, 1, 2}]},
    ImageSize->40,
    ImageCache->GraphicsData["CompressedBitmap", "\<\
eJy9Vktu2zAQpUjKsiXVSZogSIMusi2KXqNd9RBGYCBZBCmc7HOW9ki9j9DO
4wzJEUPb3TQCPJbEeW++HOr75vlu+7B5vr/d3HzbbX7c3d8+3Xx93NEr1xhj
PtHv85Wh+z90F37X0zQZt91up3CZEcJckbT00jjS4UVZudQrj19eSBo88+o5
SadWoWBJZI0zwVtSWGA52P65A2gIGieFBSh1EJ412aM+6I4Veyuly8Ss2yvL
xrHrkD1Em/SZ3qwCptsTzyt7GS+xML5VNt+raGHHQqjMLxJCs59XUbkqjPKx
ijOUaAHwT6hTVAr1jDbpfmaT9PGW0S6iJY/LIi++eHa1SDyzMnG7n9cnHvGx
K9gQoS162e3lg1t95E1tBY9cwWGrHAvhGCt5PsKgspNznbPUVyvH+YF9dJOK
yydG4WuP8CFG6JVeNoHTRk4Tr7KqVf/aVEXpEJfZVNZW/5FrqHXXW3LpaVBO
B4kRKK/2UuyOhhaQ/6bKGOZGlxjo+vV7kikFNv+KIfYL6ndGaBS0Bajog8PI
NXoc0xPIPE+P4gbBrYPFnMXDqLCfWx1l8F5xGAHUOeKegqM+xkr/uD2JLJz2
Ss6DcynlUL3W+TqI4esj6fPJMt/5ETOP9gNpO6Hgs0N3Vu6DdA5KJO+KyKzw
LOO+TSTMkSY8Q8xavCy7sFPTIHsQT69eUC5aL88iYVmKPqO7wrYTXzs8tIlF
KjvMcpXiSXNoDF2YbefznBGrSrYG5S84cG75ND+Hwr9RorSiFfwPXxglb6d6
IyyR4G+XdcFpY77p1ekUv24W9HTBPdH8BZX92sA=\
\>"]], ",", 
   Graphics3DBox[{CuboidBox[{1, 1, 1}], CuboidBox[{1, 1, 2}], 
     CuboidBox[{1, 2, 2}], CuboidBox[{2, 1, 1}], CuboidBox[{2, 2, 1}], 
     CuboidBox[{2, 2, 2}]},
    ImageSize->40,
    ImageCache->GraphicsData["CompressedBitmap", "\<\
eJydVs1u2zAMViTZrp3EaDcUG3bqdRj2GttpDxEUBtrD0CHrvc/SPdLex9j4
I1IM4yzBDIeRLX4ff0RR/rZ7fpi+754f73d3X/e7Hw+P9z/vvjzt4VVahRA+
wu/T+wDjPzCi34d5nkOapmmmK2xQhHcgM7wc6ekWZISnCICQnj6/THSFLc2+
AYkEIcEsTMIdIgp6GQJKZr02PK1ozK/7qjEajSvUyKzBNGvSWS/Y640uE7Ju
7z1nSBhQNKpffBgI0xXMcTzOXmvx7GFPDHnBw7zEkJQhRBRmHTpl0lycRbMP
FZ1kbUvUnkWfS5ITCM5U9aM5ZCrIGxCoGX/9nq0fyUWxjB5BoNksaBhXdI2C
0dFFsSnozqGzs50X0X1BD4LGf7gah06L6K6gN4hqGc0EXAJ+HZZZsmRP8s/g
sD7B6rMaK2vWrBbOhgwwlNEUaVZWuONFnIGujnaK8hVPe5M9HFIdHGhhtLwC
lAQOnvddqt5hvnoTNdtk48se/osNEVwVvAI0feT/ZZ5hNaWSK+1mthu0ujy6
+9NZ1kbqwzBhr8k+L24Xrg6YtYM5ZmRDUJTuppWBdH5/nOekHMBcK91VyfxO
lbWpNX7ERf0QRoWjO8F57N8hJz5irP1/4LuCD6nuLuQazPqGi5iS7LJJrkbq
ztTi2pyCS13a8MopgWeIY0LU5sR5w3lHgpF2ua1zzFCm1ubPubLXYXjtbDUF
Q535FM50M1QbDYekpZeeo+B4dCIJFmt9NOdItZTtSVw6De7vpCdPfb9FJrXT
OjupoDqH2phuUVdEvgCidHqDGCTPuvIr/dKwFt+WyDAJ3G2GE7GjxpV+2SzF
Kx7SFAj+Vto6vmj4bvRrCovmluts9Rd0utnN\
\>"]], ",", 
   Graphics3DBox[{CuboidBox[{1, 1, 1}], CuboidBox[{1, 1, 2}], 
     CuboidBox[{1, 2, 2}], CuboidBox[{2, 1, 1}], CuboidBox[{2, 2, 1}]},
    ImageSize->40,
    ImageCache->GraphicsData["CompressedBitmap", "\<\
eJyVlktu2zAQQGn+JPmTBAiCFl1lWxS9RrvqIYxAQLIoUjjZ9yztkXofoZ0f
ydFYrh3BpkVx5s2XtL7tXx/H7/vXp4f9/dfD/sfj08PL/ZfnAzwKK+fcR/h+
eu/g/i/c0ffDNE0ujOM40eW2OLh3MCZ4uKPZHYweZh4UXHj+/HOky/Hqray6
AKuwCB/ncUAqPMKRqTcwBiMZi+T069Akr5TFnsRYgoU2JLNdsDvgkKqsWF+T
/GCsYzCbubz4wPKd8iGQl8ZOZrw2NZBmPBmnIYRKcB4HVYeukmoO/qMdjHYm
7VBqKwFbCs65pi0M9kPIF5OykPzvP5OmWb/SnKb80DTMNk5jocE9gqKhxcto
cNsZEkUZZUKxsmfexLmWuNZFH38xTqXPTbOs30kkW9TLrM8INmyzHRYpUbwI
8rtBRKw0+NCqyY5vrFhZQsglMewGx/dWouwhR1G6VLMhzEHlDG+pN2ZS6FWc
R2xraLtSWFn5yz4QfVYRJlNKOXyqpqYGQ+V+42rUefNYTpNwlhsNd7YztK2Z
v+e5yXKxTiDbFb8lp+dJmdwEtbFci/6dZJa9YaNGQD5Fkh73y6SWC+Egz7K8
dKbuytUiD5ujW6qv7AXpGvPvV1hmB1MC2r4dDDcYj7DzVjBF2jExlGhr7pPK
NaL7whdeMF6GY37b4WJsMMzOMKNh+iMmIneGkg2FTr1UKdJwck6Uf0DJkmUl
w8rlXKkgdd5I/hBxZTjxQg5mDX26NvrB6HcqMy2aZLzoYQiyr9tZ2Si9oXBO
s6FE0e7npwGe8eIt6+l3EZ1HdyQ5GAuzrEvFUj1t1qLbcirdAc8oAn4fM3F7
aTh+V9sJQ+9zKj0MNyRxLTbvuFdX/wB86k0V\
\>"]], ",", 
   Graphics3DBox[{CuboidBox[{1, 1, 1}], CuboidBox[{1, 1, 2}], 
     CuboidBox[{1, 2, 2}], CuboidBox[{2, 1, 1}], CuboidBox[{2, 2, 2}]},
    ImageSize->40,
    ImageCache->GraphicsData["CompressedBitmap", "\<\
eJyllktu2zAQQCl+9LOcBC2CBF1lWxS9RrvqIYxAQLIoUrjZ5yzpkXofo50v
NaLUWEAFmyapmTfDIWfob4fnh/H74fnx/nD39Xj48fB4//Puy9MRpkLlnPsI
30+3Dvp/oEffD6fTyYVxHE/0uAEbdwtthMk9ja6hRREXQePp88tID797D62H
kYdXAd4x6/WI4sy6Uu3A2igUqWFJmIXOjmQvDK0lGX7LQJYZjEyPMinLcMf1
JNcVdqF1u7m8+MnyzWIlk7+djsWOx8ZErSFCEsJipWdJMs6ksEKqz5BC4VOd
STQrQWg3UUBJ/NlGQd9w6MKv36f/IgUhRQCp3CxODCxpor2gQbdREv7CQ6TI
JIalf7JQv9+o74uVNaI/oF7N+ozgk5rtyX75VQqen9mJBGWkkFcxU+GDUjgR
VzleOMlwnK6uthx+94Z3kan85CzldIJOZ+KFXU/jHK/JMxlXc3/tuUyZK962
yEo2lrS2lWi+QQ2Tt/lUCS+qr6wyi/p239vCSiys5P1MWUfqE/qzbkMzyWnV
M/ykfAHhXiMgmhhOmRM28ZThtaYbttkXqbjnmRgDxNSr6y5r13zNKNTPz5nQ
SFEwjd4pGbuNyjnzeuzNSiefpsq81G4kRlT1JMwYu52SZA5JFQyRoJR5huMw
5TzhiIVtpDiRGNsVHDxTg7mZdW7OodueUsDGGPMFJ2jH8ixa9Isdvyzs6p2Q
tFJl5WWlQ5ELqWFebLbqTb7//fJulIzCGovDvbHFmlW+ma2tTmy9M7cMtixd
i4UkUjf4m1ntogYOunLxRumTTlfY3xca0dRvzqV+ZZU7WSVuBv9PGApuazj8
72svHFvZCAvNFUlcQovEa97R6i9UV+oY\
\>"]], ",", 
   Graphics3DBox[{CuboidBox[{1, 1, 1}], CuboidBox[{1, 1, 2}], 
     CuboidBox[{1, 2, 2}], CuboidBox[{2, 1, 1}]},
    ImageSize->40,
    ImageCache->GraphicsData["CompressedBitmap", "\<\
eJydlttuEzEQhh0fNntI0yJAqrjqLUK8BlzxEFG1UntRFYXe8yzwSLzPCubk
sTNroqhR4643/3yek7377fDyMD8dXh7vD3dfj4fvD4/3P+6+PB/hVtg45z7C
99Otg+u/cEXfD8uyuDDP80Ift8PB3cIY4eYVzd7DiBIXwOL5808YnYc5a9/C
iDMPdwP+iqqZPkJ7I4psj6JIAyt5nEi7N2uhrKu0y6+janfVyiNqkmpY5kbS
jY31JwLXer4eyGLb8GJPK6hcVmB9qjxJOQdiR551tR2v1JNlzPmX1G5b1qE4
6XGo6tURJRhKbyhDVRcC0CDziylYB5y68PvPYklgi5aXkYKQIoCyrkR3ES0q
Df4w79vMwv/YociKzGJcOqWJL0hD2dCyT2ovHsUmI2dmh7aRGYxBiqqlZp4Y
3kSVckdqVJyUCUGdMhkL93GZ2CR5yYh2ovTOWEWIl57mGmHhyHxT6JHp/NH8
a0cTORkfS2+veZW3Q9659f7gasRSDd5jZ2i200/2C8zFrZRjls7fvooaDDU4
t8pe9ypyrHYASeVk6Zs0+llKMzVI2AWYROtbO5fnaBixnoiVbzbiDUyRtiaO
q64hXuKCl8pb39J/qXo+Rn3i0J7I+z6vYysRzxLxBI4aqa1K6SpLDWep+LxD
sfaf7STbr5Wv9uwwq0TdS7LGYNbwZo3Q8H7Npec/bRm7N7FktG+S2kuZ/arq
10Dw9MzQOlM2qZ+j2uceJQL2+43Y4VrDSise5hh4I7p9I7djFScq2TIZy0FW
C43MtQndUr1TVOcpUno6u+qsTaJmW41dT9TdqYUr7yxsMcisjhDt0AsE0U50
k4lqV3JPrpO7MFDt+N2sUveiRh6/t13lGKPGWGluSHMNIz6c3nHlN/8AYBdo
sQ==\
\>"]], ",", 
   Graphics3DBox[{CuboidBox[{1, 1, 1}], CuboidBox[{1, 1, 2}], 
     CuboidBox[{1, 2, 2}], CuboidBox[{2, 1, 2}], CuboidBox[{2, 2, 1}], 
     CuboidBox[{2, 2, 2}]},
    ImageSize->40,
    ImageCache->GraphicsData["CompressedBitmap", "\<\
eJytlk1u2zAQhSmSkizFdtyiRdOgiywLFL1Gs+ohjEBAsihSuNn3LMmRch+h
nTcckiNKsRugQkKL9Lxv/iha3/cPt8OP/cPdzf7q+rD/eXt38+vq2/2Bllxl
jPlM/18uDN3/oTv+vxzH0bhhGEa+zBkG84FGT4sbnr2n0dLMyeeaV9/SCGE9
Wd3JbKW4NAp3K9/2mPnkNa6wFUTGUWwSUfeCbScsS6bG3X/9bcLF39bJXvwz
xTSaTxKoLAb293iAvisqYot5wySvvDeKAMgrCCRaQe2Tmv5Whb3jDPO8Zr2L
VpIHc2rNgYx9gY6s+Ur5BqBEs0hTOVkMqis2kQK4rCRWAzllL1ZdQXY0gOYj
jeaJ5lNfZKfNefP6gdbqLBH/1OooDbIekybrw7eGo531dkaBd0Sxjl4DRWI7
wZAOeGGkqsp6X2aWOqM7lelVpvtEF3b9D+yliAOTN43sq7STj9CYMtmh/CjO
WH3BOVM7I2X4nzhc4ZPZvSaivP+nEU0qoioUTkvpoTyT1UklnzltUITr6XmU
x7yRvCqagDSn7WjAZqghUh2qX4gj7+wNng+cwazMFYCy9JdVvai2hcofVTXx
REs5ohdvFMPI3lxgSJ2cZOpjpvSJ2/NIkabZ4xS6vSxqxQpV5SD4RFZ8Xtc5
y9CVaX6AfaSBTz5Msr3sHrH3oWtBdV5kYYXQYeITIUekziWYbMVe9yH7ir9p
2kMr+djC81pVIxOawp8TdbugntauVb+n68K6X/TVFb5KlY/VHcKbi7wZLFQD
Fu0Y3z+WKqC9AxDeZjYFzyrebozvOw3N3oVeVn8ByOK/CQ==\
\>"]], ",", 
   Graphics3DBox[{CuboidBox[{1, 1, 1}], CuboidBox[{1, 1, 2}], 
     CuboidBox[{1, 2, 2}], CuboidBox[{2, 1, 2}], CuboidBox[{2, 2, 1}]},
    ImageSize->40,
    ImageCache->GraphicsData["CompressedBitmap", "\<\
eJylVt1u0zAYdW0nadKmmpgGaFe7RYjXgCseopoibRdoU9k9zwKPxPtE8P3a
n92sKyNK3djxOd/x8WfHX/dPd9O3/dP97f7my2H/eHd/+/3m88MBmsLKOfcB
fh/fO3j+A0/0u57n2YVpmma63BYL9w7KCI07ql1B6aEW5H+k1kupNYYBSmG4
gBIbu8W3O8EOWIspOjxs6P1G0C6ARlHWY9GkvsJHDPQO+Tx0d+Hh0w/H13AC
0wmGYgAEUR4LivnzgPi+csdXdRqdi1atMEUqmInJ1mdz4SjWJR5uqwW18Vgz
vqX2oL1YCvOErMND0UoMcj5Jrvmakk/GtcTnmjRLqk17MbDwFWN2Z3EHKFBV
NGyJPaZZglYeu6/G3tda4bEzXNRW+nySC/EDVtqM57eOtFr3wiJLJyxbqiQW
S8SOqsJnmaIwJWfFww3pS7RwL+vzmTWmGRDOZokzZKl5zjUG6opHjLwGu/9l
W8qQV3CRkZJBwws85FaRFa/kaH79nm2iymye4sE676uQ/Qg366ZEa2+LRrdR
BCNLZ/6dLejqmPRqkSPa/ArKKvnqX2RFeI+ovI7YIGird6GVsOXMH2SEu1KJ
M/vJs1h1541xx52FPHbirXLw5kccK6gi9hiPQq9T1LwGS0QaV2A38HGrrhx9
x2QN65dH+o8VvhN8oyszEZg9QJRi/zo+Zk3Q79cCPizgadfWfcx+38xJwOfv
XTWCTiLafE2r2zCuBctMbaUjig4df43WMwM7r6cB7DmauGj8pujZV3FG4cf4
jZyS+OTh7WxKVDSQnOSTkOFZq2/QxKekserhdSah6WLWcxRu9lecb6u/obEI
Ag==\
\>"]], ",", 
   Graphics3DBox[{CuboidBox[{1, 1, 1}], CuboidBox[{1, 1, 2}], 
     CuboidBox[{1, 2, 2}], CuboidBox[{2, 1, 2}], CuboidBox[{2, 2, 2}]},
    ImageSize->40,
    ImageCache->GraphicsData["CompressedBitmap", "\<\
eJydlktu2zAQhmmSsi3ZTowUbtOusi2KXqNd5RBGICBZFCnc7HuW9ki5j5DO
PzN8iGIdtQI8Eqn5vxkOH/Lt8em+/3Z8erg73nw9Hb/fP9z9uPnyeKIutzDG
fKTfp2tDzy/0xL8PwzAY1/f9wJfZwphrsp46d9w6kIWLpbuNvW+01WQEskrY
q2ZVfXuh2g4tH6PTw4bfb/W9cZSjZtbCNNFXeUzgdwhiPPk/fv4J1a/TZkIX
75XSLbk5eDvxJyu8SRSObXyI4iQKpJ6N6AXRFhW1RXvJLBd6jVxrcJrI0WzW
/8wCZp2NCSBLRuaB+kTMY8lJzSySIwMfVE5Kx0DTnKdprWo0kBrul6i13Pws
mg1VZCX1hTwyEjNSFXWULRmAulxNxHnqFRnE3vFKSGoz0duq3qt+j8Yy6gWh
+9AnpY9KzfqqyNpy6uUKLggydXQdquq466bq2gxoe1OwXJXl/ovldeXl9Vww
iYG6kboZFNmtIR33KgNtyycZhiTaNI5zSqwMPjd/Pw/1GstMz+W5cNb04VqC
3BRrRur+1zqFMYWzUpYC3DvQRit4Hom/FKzV8+Wsdrxz0LzK6pPyT2fVVOlV
+baoLJQLakKhqrRfFNGyhhp0x+NFZXbGjDi+TLUlw6fgqPqIpbs8fCfUv9Sv
VO95BmPdxozspEiZJoZVRjuuvX6pZZrKPJA3mrts1CliU0RsNYItIke1nv9S
p2Wh9qp+h7tWdPz1fR/48W1bMMq6+dCWDcCusnO6ymg3OlrMIH9L5f9Hxl+H
eaAu+W+yU04t0p49Lsli2g+ywhZ/AAIa+Mg=\
\>"]], ",", 
   Graphics3DBox[{CuboidBox[{1, 1, 1}], CuboidBox[{1, 1, 2}], 
     CuboidBox[{1, 2, 2}], CuboidBox[{2, 1, 2}]},
    ImageSize->40,
    ImageCache->GraphicsData["CompressedBitmap", "\<\
eJyllktu2zAQhmk+ZMmW7QR5IOgq26LoNZpVDmEEBpJFkMDJPmdpj5T7CO28
xMeIbo1asMcmNf9HcmZI6X77/rh73r4/PWxv7/bb18enh7fbHy976HIzY8xX
+H67MfD/N/yj75dhGIzb7XYDXaZHY27AeuhcUesKLLpY+LWx90JaISOAFcK5
3G3V3SXdXQtxUb3bi9bCBKnHx/mNGtMJwXhwevn+AXb4uT/kPc+IDr0d+8PH
kEeIGplJR7ogOvIHHUo9maTnueQxtKrdEMtVWA2aEFmMM+3RPOqVALRqXRYN
tVnlyR/aDJJ2ooajqA4MrQS6LN1LBE30RxORFkYaT/lfNIlgW49gnBm3g2K5
gyyc2CJTI+A4dSPqnuojquGj9ZTPlFWJC9ZVUZ/Cpdk0OY8DhEP4KskKKdRI
2bqoQiaVnzE9M/m6UmrMm87RrJyPjHt9olJq9mQl10m+Vs4k/chSF9WYMYej
83+cORgKp/v1OZw4J6wUXGoDKM5fXvuxLov4THg+8Qy5L5CW6hZ6MdIz6EBC
SYmR8TEycK2RkOX57/oUEegHJYqZkLJWI5Q7BpthVBUUmYfsV0XxicLI7iAj
7dmSQc9HperBWDpw9K6ykyxslHYu2jDuvCienhdFrERvwTj1NEojF08fUaxk
RKxp/STmNQY1ZicKN46dnSR1QlMZ1wqlpYrLz+6leLO2nZxBvRq39O+ktc69
5HmJGN5ZS7WmxORMY+rmw/geknu2Y7ygi99yVuPqfFxd5nNGPhuweHxfcgXM
/gBuNjaO\
\>"]], ",", 
   Graphics3DBox[{CuboidBox[{1, 1, 1}], CuboidBox[{1, 1, 2}], 
     CuboidBox[{1, 2, 2}], CuboidBox[{2, 2, 1}], CuboidBox[{2, 2, 2}]},
    ImageSize->40,
    ImageCache->GraphicsData["CompressedBitmap", "\<\
eJydVs2O1DAMTpP0b2Z2GARIK057RYjXgBMPMVpV2j2gRcPeeRZ4JN6nAtux
EzdNO2WrjqdOPn92bCft1/Pzw/Dt/Px4f777cjl/f3i8/3H3+ekCQ64yxnyA
38dbA89/4Yl+78dxNG4YhpEuc0BhbkFaGDQOHsIkz7wDiXDHiDD6hrVmMvqa
tU75QNI9zR6ZaVecPbCthSBpxMcYxcbsYpQAevr0E26DeJqtI555e7Jp2evE
BgXq468LgvoV+1rF1Sg7kAGhcmkzvSEGL6MhANOiqNk73cjVZbboRus1cbmM
q9MrASKLgnRlpfBx5VzjZhOrQ+EjK2ZUolMZtVnEfhO3B4Gqo/Epo+DQeluk
XtbPLEVWH/EwkeWVcS/iTTUNCc4zwFjsIqRq/o+T81Dm9Jx/+5K4m6wXebeb
1M+qe9BLfcWLp8ijF9SwwoLi3rPJhw8+wnUt92X2gErdVxVX0G/hdimacg3K
2cm5014MO1xqVNo3dj16RuceMKOBkZOwtI+urWCBv9Q9eBb6FU55g2As+xU+
ssBztVhNW+yVNW7MBfI1m3qvus4XlkSli6e2T7nawrmT02aQK89oq6olXVyB
ilxTPkF7eZct1KhTHSx5WWbESiK4/v1nnJ34irUXVtXbGauPO4E5+4zTLnFy
pHNOpLwBlrRDppmjt1Ado+I+nPfKSUVi+PzCsngcT/Z8aqe9h71+Yv96j6FO
q/PBNhhWs7c9Qo5sf0N47hYKtIrfFxrfM95JzPCPjwfRQyNxlPL9pZEWBKpt
gcFGv93s3D1keIkk2fQFb/vMyrOVj2+RfbZC7UcK2I76G7BXHOHL8phxWIU4
EeIVyAa0t6H61T+GcRju\
\>"]], ",", 
   Graphics3DBox[{CuboidBox[{1, 1, 1}], CuboidBox[{1, 1, 2}], 
     CuboidBox[{1, 2, 2}], CuboidBox[{2, 2, 1}]},
    ImageSize->40,
    ImageCache->GraphicsData["CompressedBitmap", "\<\
eJytls2O1DAMx9Mk/R6GRSC04rRXhHgNOPEQo1Wl3QNaNOydZ4FH4n0qiB07
cTzpqouo1Mw0sX/+x3HSfjk93i1fT4/3t6ebz+fTt7v72+83nx7Oocs1xpj3
4f5wbcL/P+Ef3u/WdTVuWZYVL3OAxlyH1oZO48KfOEgjb2nE0W/sfR1agLRF
7yt6GkQMgM44+pJGJ3jySQH3YDyHGoJOUjdu2E7EssHUuIePP0y8cLRN9hQf
KaaX/OACXhYajPfzDP7jE/6tiNkJP3AdVVateu4SQUbvofGZYsyg/BzOLz8j
wXi2Is4ATZs4NJeerSg3aa60vt02S8zMQuPTikAOWVMlhxAtcp2IXuP60Dhe
PE3zaUWoxvbxZG6f4kah/8b1mOvEpdKzbEW5dVU2VA1IaHcxHVqpmspM4Wvl
6tLq79PtlG4Rw0tbiNDuyYzOeFGVfMCYGMfn2jT78n6hSeeoyXSR93EPu5Nq
fv1e/xvdklb0CWBgO2iKanTPZmPdwY3AzPb4nPejIpOqGhlo4A2nXCcUxvqw
z+IgaOGrphGsmtAFWY2Z5bcPuM+KC2vhWVdttlTBO0jQ38Zp5dOyVVy3SyE4
4JpcnL7IKyocXLdpPe+WlDPo7Xi95WnsYoHyxIv3xWYMrnOQxNn3ip5OA0HT
J5Ci+0SnbEwg6zIb4bevvlttwYnXsdwd0n9DTZnLK7EDOLqcV1tVkne35a8E
yvILypfmdHyKJUhTvlPpJDkKPbU8y5llJfy9MVF0pyhWUQayj9690gDeYNxX
12cucjlcnM6HixWZimhjJWuzWgXIlk8n3az0HWiWlqxQP34Tam4vdjwOhSZ+
YR4V03Kdh66rlb9B4aB/E2um+QuEkoLK\
\>"]], ",", 
   Graphics3DBox[{CuboidBox[{1, 1, 1}], CuboidBox[{1, 1, 2}], 
     CuboidBox[{1, 2, 2}], CuboidBox[{2, 2, 2}]},
    ImageSize->40,
    ImageCache->GraphicsData["CompressedBitmap", "\<\
eJzNlstu1DAUhj2xnUwyF5WiCsSqW4R4DVjxEKMqUrtArUL3PMvwSLxPBOc/
PnacE0edsiLquLHj//O52cm30/N9//30/HB3uv06nJ7uH+5+3H55HGjIbowx
H+n36b2h+z90x78P4zga2/f9yJfZozHvqHU0eOTeDbUV9az8P/DoNbUQ+oxA
rRCuZO62+PQoTzv0XFqdbnb8fCdsY8lGsaxdmdsKq6Kpxj5+/mnCxWyf5sv6
PGoa0TCfJFBVaHi98wB9qyJTqX7DJJdbKiTHTSAF2PZiFrzYzvX0p/VW9WvW
p9FgSuD4nAO/GqV1qu/nLPFpm0UHoApNlh3/goWXUa2iatuK/Sma4nf7X1CL
EVlQG2oAqYlWl7Kqq2ZBQLWhanT9+gIRNmALZR66lA3h+EX1uhJJzoMV+4Qa
dmJTrEMr1LB7WGrCeInKw8Fp06lMwNPomc1OgaR+PQ3PXLIJEct94Cub8gIt
I6U8TXtA501bvLlsDXWSVdHmOs9kYNgZEZNKRFBgBtvn8yqJ2YuEZVxLTCdx
rbm+Jv/NtJMUa6rxBSvUzHkQRrPCXEZxzgzvr/PQ/oO+Eb2xv36Pkj6wuiy/
5iKSjTuuj5cHUp01u8iVtSoVtYwb30N02yoSVHuuC8iy/YhMMwGAI1SzNxAi
5PhYyXWwRnY93V6ptbxoHMbXdNlphmnHjBHDwj64pJ8sLWhxggVGmD+txG/X
+KamGZjUUINuFVeV8QNIaZ1arWNF1SjVPvZnGYnfGrBsrxRdjHPKfNC0asW3
4tl0dncrvrv4zcXfUCV/o4X8iJrwRXZQvCrjvRnjNxuK5ibU2eYvJyBshg==
\
\>"]], ",", 
   Graphics3DBox[{CuboidBox[{1, 1, 1}], CuboidBox[{1, 1, 2}], 
     CuboidBox[{1, 2, 2}]},
    ImageSize->40,
    ImageCache->GraphicsData["CompressedBitmap", "\<\
eJy9lktu3DAMhjmWbI/n/QqSZbZZ9AI9QLvqIQbBAMmiSDHNvmdpj9T7GC0p
cmSJZmJPFzUwgjX+v1+URMr+cnx9On09vj4/Hu8/n4/fnp4fv99/ejnjX24C
AA/4+3gHeP8H78LvoW1bgD22xel0OoTeVnrg8OYUrqAAWGHrsFsgCv7lww96
BIDtLjxfpCTw5VAGBLU/z/SIlU3iVJHCs4JF26CpDbcpacuo5cFhEwSloZ+R
vor6iKyDxAlBUSyTOElWUBP64YJlJMK/SBCwUpRT1OIKiiMbT3k11nwUVSpq
dgXVRagoVFtUpajmf1CctEIVal60yyF75b9IeiYZnprsTFhnjTyCr4WvLL6M
vMRfmx6leEzzmgHodkj2NZLS96ZfIX7zvK7YUjJslKdnT7703hRxhql7qdyc
GeH6nX2OMSQuRe4i2aJdamxoPArbjyK6tZCaxUfOHPtybtIct2/VEfVRrNdg
2GHc/N9zqAccJoMOU2yqf6LScfXqDTs0A/mYOxBszt13uwgDUbzp0cvm4Vg2
VGt437R5JlF1vEV3dbAIFc+nIl/Fr9+tnRnpW4XHTzOj82x6npXyLE3P7mzu
e9LpRlU1U066fvTbqz9jOmepu1ZO7iqny2G/Vy6F6dLNjF0IuCWydzbqt1Q/
e++Iy85om0lPPEJuk0jJh/Jtgl1SS1RJtmRE8kbLCapx/jbiQQi4MfY6pyoV
Ga0hvz3xRgLsU7WiVkLp3HI9cqrm1Qg5N/YuJxtjflQf1F2p1enT4cspe4Pt
L3seE4TuOdsXan6Hyz6zlioz6JZGTLtEy3nAEayNlb70qWXVRqm2sj5F9Nkq
xULWwMeodkZUHhsvqrDncFA+JKbl4O++G2ypx1/RMPkLzEFMtw==\
\>"]], ",", 
   Graphics3DBox[{CuboidBox[{1, 1, 1}], CuboidBox[{1, 1, 2}], 
     CuboidBox[{2, 1, 1}], CuboidBox[{2, 1, 2}], CuboidBox[{2, 2, 1}], 
     CuboidBox[{2, 2, 2}]},
    ImageSize->40,
    ImageCache->GraphicsData["CompressedBitmap", "\<\
eJyNlktu2zAQhik+JEu246CFiyCrbIOi12hXPYQRCEgWRQon+5ylPVLvIyTz
4kMjuZJg06Q0/8eZ4VD0z9PrY//r9Pr0cLr7cT79fnx6eLn7/nyGW64yxtzD
9+uNgf479Oh7OwyDcX3fD3SZHTbmBloPN/c0OkKLJsaD4vnbW08XP/sMrYWR
hUcOnjHrzxnNmXUd1Y7VaOSpYUu4C50t2V4VtA3Z8FMGss2usOnQJiQb7piO
7Fo1L7RmO7YXP9m+mUSS/W3jWOax2BRZa4gQhDCJdJEk40RyM6R6geSUT3Ui
0V1JwmaB4hUlrKKgb5g3W1TAnE/raE5oIdKgP8qVrJuKUNSalmrJpSJhkhcs
xR4uslyssyKuUs/OsN6qyBrR7yhJWR8n1vmxsxQv+dBV2RW7iD92NdMK85OK
rL6s9qzm6ziry3WsZhWPv8zVR0h5lP3rVmkb5Wk1q9LVsFX1Pk8hFyTcbibr
KPCF77km3aK+Eb39+2+Y1NSFXPyP54VXIy+U1WBmqmEcX66izDNk3iEt19Zq
Ep0apC3fyk5Vx1Qbs2Icio3B9kAZGr+bKuijOhLGuwSHIargF7tXKs9uSvGZ
wsh2gWEnjBR3odpBg3tsvCo4l52s6kFpG9GG8Tpg3Uz2c/Yw67G6cLgZr0XS
j06Ywl8c7os5WVml862csxUfkXWIGZK6ZUUts4SYCYk4ngWosom/mbxlfJyx
PD8Kj6MHmdEqhSbUiuCFgNPyXuvEZ63Ek9nJYvIpTf9vQrKQxcQokMb/fvYp
zzlyXAGUXZPFQUZHronqA0hS0Wg=\
\>"]], ",", 
   Graphics3DBox[{CuboidBox[{1, 1, 1}], CuboidBox[{1, 1, 2}], 
     CuboidBox[{2, 1, 1}], CuboidBox[{2, 1, 2}], CuboidBox[{2, 2, 1}]},
    ImageSize->40,
    ImageCache->GraphicsData["CompressedBitmap", "\<\
eJytVktu2zAQpfiRLNlxmsYJgq6yLYpeo13lEEYgIFkUKdzse5b2SLmPkMyP
FDVkXC9KwLRIvff4hjMSdbd/fhh/7J8f7/e33w/7nw+P979uvz0dYMo1xpjP
8PtyY+D6Fa7o92maJuPGcZyomQ125gZ6D5NnNLqCHiHGAePp62/ojYUxYy+h
x5GFWYd3ETVSE7ULQUQ+gjx1jOR+TditWgthbYad/hwSdpOtPCAmJAzDzEC4
obL+moRzPF/3xOgqLra0QoLLCowPmZMQ90B45KzNebzSipg+7r9sbVdju9mk
xS7LV0sqTqmslEqf5YUEqJPxySqYB4zQVjzhfO7Ln6ToRDFUo4QbsstH/Pmk
JlpdpkWViv+etVguLNXEC6q5WEnaS0h8KVlf1WhFY6M0WpU1S2yr4gmxhlM8
JmoFVT+w/imKdrG//6iqNsWYwnSzqmdVbjqPg6qvTrlrqu6ua1UZchf0CC65
smKNa2O231/5v7Cv1FvOR99/X6a5Ztk3/cnW7YBH2+gYyKiZm89q7gVWFly3
CCqqwcIs+m/gBnpuCv5QPCuoNqCaz9WOK6Vc+xQ9tO1SReDvK3RpH+a4SSPL
iD+q4MV/iKyaCiatVPGp/kSjr2osn6ylBp2MirWRfePcxIZr2SIX54rbQeeM
nAU+8fE8SfWHp8tOcH2Ba4qzJEaCnrZxXiw06czK0b2gP1bRbX6Giu9YKzE2
BO4Ex6xV8ebwmTpeXi7wvYyCQp1P/D3Cz8Va3bVqjOc9pqGb4ldCmZWVKPIX
ylmKbo7ECeIDIdABHuI7zmbzBka5www=\
\>"]]}], "}"}]], "Output",
 ImageSize->{519, 279},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->49524984]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->30803],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{
   RowBox[{"Position", "[", 
    RowBox[{
     RowBox[{"Tuples", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "0"}], "}"}], ",", "7"}], "]"}], ",", "1"}], "]"}], 
   ",", 
   RowBox[{"Filling", "\[Rule]", "Axis"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->15399],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{360, 234},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{Automatic, Automatic}},
 CellLabel->"Out[1]=",
 CellID->359116657]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->27000],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Sphere", "[", 
     RowBox[{"#", ",", 
      RowBox[{"1", "/", "2"}]}], "]"}], "&"}], "/@", 
   RowBox[{"Tuples", "[", 
    RowBox[{
     RowBox[{"Range", "[", 
      RowBox[{"0", ",", "5"}], "]"}], ",", "3"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->15651],

Cell[BoxData[
 Graphics3DBox[{SphereBox[{0, 0, 0}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{0, 0, 1}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{0, 0, 2}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{0, 0, 3}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{0, 0, 4}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{0, 0, 5}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{0, 1, 0}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{0, 1, 1}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{0, 1, 2}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{0, 1, 3}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{0, 1, 4}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{0, 1, 5}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{0, 2, 0}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{0, 2, 1}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{0, 2, 2}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{0, 2, 3}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{0, 2, 4}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{0, 2, 5}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{0, 3, 0}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{0, 3, 1}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{0, 3, 2}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{0, 3, 3}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{0, 3, 4}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{0, 3, 5}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{0, 4, 0}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{0, 4, 1}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{0, 4, 2}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{0, 4, 3}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{0, 4, 4}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{0, 4, 5}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{0, 5, 0}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{0, 5, 1}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{0, 5, 2}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{0, 5, 3}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{0, 5, 4}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{0, 5, 5}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{1, 0, 0}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{1, 0, 1}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{1, 0, 2}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{1, 0, 3}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{1, 0, 4}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{1, 0, 5}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{1, 1, 0}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{1, 1, 1}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{1, 1, 2}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{1, 1, 3}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{1, 1, 4}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{1, 1, 5}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{1, 2, 0}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{1, 2, 1}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{1, 2, 2}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{1, 2, 3}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{1, 2, 4}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{1, 2, 5}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{1, 3, 0}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{1, 3, 1}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{1, 3, 2}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{1, 3, 3}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{1, 3, 4}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{1, 3, 5}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{1, 4, 0}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{1, 4, 1}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{1, 4, 2}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{1, 4, 3}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{1, 4, 4}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{1, 4, 5}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{1, 5, 0}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{1, 5, 1}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{1, 5, 2}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{1, 5, 3}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{1, 5, 4}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{1, 5, 5}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{2, 0, 0}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{2, 0, 1}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{2, 0, 2}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{2, 0, 3}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{2, 0, 4}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{2, 0, 5}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{2, 1, 0}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{2, 1, 1}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{2, 1, 2}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{2, 1, 3}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{2, 1, 4}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{2, 1, 5}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{2, 2, 0}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{2, 2, 1}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{2, 2, 2}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{2, 2, 3}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{2, 2, 4}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{2, 2, 5}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{2, 3, 0}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{2, 3, 1}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{2, 3, 2}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{2, 3, 3}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{2, 3, 4}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{2, 3, 5}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{2, 4, 0}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{2, 4, 1}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{2, 4, 2}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{2, 4, 3}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{2, 4, 4}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{2, 4, 5}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{2, 5, 0}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{2, 5, 1}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{2, 5, 2}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{2, 5, 3}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{2, 5, 4}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{2, 5, 5}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{3, 0, 0}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{3, 0, 1}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{3, 0, 2}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{3, 0, 3}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{3, 0, 4}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{3, 0, 5}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{3, 1, 0}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{3, 1, 1}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{3, 1, 2}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{3, 1, 3}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{3, 1, 4}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{3, 1, 5}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{3, 2, 0}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{3, 2, 1}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{3, 2, 2}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{3, 2, 3}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{3, 2, 4}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{3, 2, 5}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{3, 3, 0}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{3, 3, 1}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{3, 3, 2}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{3, 3, 3}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{3, 3, 4}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{3, 3, 5}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{3, 4, 0}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{3, 4, 1}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{3, 4, 2}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{3, 4, 3}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{3, 4, 4}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{3, 4, 5}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{3, 5, 0}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{3, 5, 1}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{3, 5, 2}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{3, 5, 3}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{3, 5, 4}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{3, 5, 5}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{4, 0, 0}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{4, 0, 1}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{4, 0, 2}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{4, 0, 3}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{4, 0, 4}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{4, 0, 5}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{4, 1, 0}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{4, 1, 1}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{4, 1, 2}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{4, 1, 3}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{4, 1, 4}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{4, 1, 5}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{4, 2, 0}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{4, 2, 1}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{4, 2, 2}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{4, 2, 3}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{4, 2, 4}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{4, 2, 5}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{4, 3, 0}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{4, 3, 1}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{4, 3, 2}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{4, 3, 3}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{4, 3, 4}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{4, 3, 5}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{4, 4, 0}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{4, 4, 1}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{4, 4, 2}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{4, 4, 3}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{4, 4, 4}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{4, 4, 5}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{4, 5, 0}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{4, 5, 1}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{4, 5, 2}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{4, 5, 3}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{4, 5, 4}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{4, 5, 5}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{5, 0, 0}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{5, 0, 1}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{5, 0, 2}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{5, 0, 3}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{5, 0, 4}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{5, 0, 5}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{5, 1, 0}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{5, 1, 1}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{5, 1, 2}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{5, 1, 3}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{5, 1, 4}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{5, 1, 5}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{5, 2, 0}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{5, 2, 1}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{5, 2, 2}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{5, 2, 3}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{5, 2, 4}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{5, 2, 5}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{5, 3, 0}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{5, 3, 1}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{5, 3, 2}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{5, 3, 3}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{5, 3, 4}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{5, 3, 5}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{5, 4, 0}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{5, 4, 1}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{5, 4, 2}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{5, 4, 3}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{5, 4, 4}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{5, 4, 5}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{5, 5, 0}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{5, 5, 1}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{5, 5, 2}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{5, 5, 3}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{5, 5, 4}, NCache[Rational[1, 2], 0.5]], 
   SphereBox[{5, 5, 5}, NCache[Rational[1, 2], 0.5]]}]], "Output",
 ImageSize->{184, 195},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->20385010,
 ImageCache->GraphicsData["CompressedBitmap", "\<\
eJyUvAd4HNlyHrpPsiQrR0uyLT3ryfKzJb0Gc9jlkptJLncbIMEE5tSIBEAQ
gUQkcs4550TknHPOOec0wGAQZjCYPNP/99zdAHlpcu+1vB+IRU/oc07VOVV/
Vf3V5BNrI32zJ9bGz578wyXLJxZGxs+s/uHiC0vmpd/+vz777LNy5l/b337G
/P3/M39x/2wBfPbb+vr64P777HP212c2zO9/x7x4jruyYn7/FnP124f//4J7
9eXh1e98cAfm9+EdzJnf7Iu/94vvmh5+9w/Yq3/3fnTmj7Pc+8aH3/6jX/O+
4eH3/5S9+p337x+OcYb7jP7hZ/78oxX+1kfXJ7lPPz0c8S//TZ9+fHjvv/7o
3d/+6PoE9+kHh/f+j/+bex98+t7hvf8D9+4rgnIjKE4M/5uxjnPfvnP4bW4d
v08S1GOCek1QgQSVRFD5WlS1FtV0kmo5Rn0y+sf3P8bd79bh3P+KvfrjqwT1
kLtfAGGSfORF0RnLxguWvZdejpOmc7r6i9epmSsUq4Hf/cV73fhQan/CzO0O
YfSCsPYk3sSe8Mo/F1B3Oaj3RvDkw6AVA1+BqZvoha3Y/PlHe4j98yh3N93D
u/0Ne/VnzN1IwuIJ4Wp/JDj4VGza1ynlOpnt97NHDbOXLLO27NP2XRNUnhFq
b2/mK1Jb6uN7HuHuqXO42r9lr/6Cu+erW4S/CRHveiIr6tuinGuVtY9re8zq
p20b1t3r9/yrleFlmpg8xKewt4qw33OkPl77wZ3Jw9n+58M7W5NE8D0izeJY
sddXdXFX2wqe9DS+GBh0HJr3GRaEDUnj+zRpXfTbZuRXsLfKiUTi64/nrMXd
+crhnP+OvforktAniQCSyLh3rML6XKsv2Z/4aLz4xWyL0+Kw3/Ji5Mp2yrIi
Z4EunkblCOq62bvV5qI0VBz2ycwP7n/5wx31e8wOeE5Q7gQVSVBpBJVLUIVa
1Ge/czj2G5JIuUZUPDzZaXNpzP/ufPLztRIHQavv7kiUaCltbydfpKzYoRv4
aFtB9zQ7Unc9WjNR5PTx2ghu7Isfjv2HjD5uE5QVQfkSVAJBFRBU7Smq80tq
8Btq9Dtq6Dx1cCaYeYSSRPG1Yx2PLkzY6C77628lvxKXeClaItQjqZqlAnqn
SqNsVtHdMgwKMbbBjjrRh6EKNIf/+4/m8f9x8/jufzkFzDz0CMqMMPEirOOO
2Oefda7/1rWHdJm49Wbpge36EwvBUwP+w8MTxswmldRqJI+PPrq8Yv1g1++F
PNFFUxRCNydhKA+LldhugbwX9CiNaTUW9tmxl6Yw24r+1F+ezTcfnqN/4nap
yVPC1oHwCjsaknk+qvJKXKdewvjT+GXT2C3riH27ALmjm8rRSmrD3ockckmi
W+fc/N1r25YGCm9bdbwvXRCDhmwMlGGuCZs9kIwBc8AKjQ0VO/rmKtb6MZb7
+x/N51+5+Xz14Un8b9x8zG8SHmZEuOex5Liv3hboFDQ+KBk0KZuzKeU7F+97
5ysDM+nQBDo8mA52VHoYkkQpeWSY/JqnpycxN1O7OyM6BDkpqClETx2mOsEb
wd4s1KvAJrDLGnkIBRCMqacKP/vlOX2JD2wuMydTkvB7QCRan8z1v1CRcrWh
9HFrm3nHmEPXslfXbki7MqZFnVSL9FJkZSMjCkkuJFFGHpkgf9jWfaAyssQb
L4RGISML5eVob8HoAKuj7WXINqEWAvvcnCQi7EyJxnM++4OP5vQv3Jy++NAG
/A9OTj7MgXmsVWL3ZWOIdnfGo6FK8/Eup6lJvxle5Mxe0pQme4wuHEBZBypr
UZmPkhiSyCeJSfKy8NoT+slrvPaDfzwS81BYg4ZO9I9ieh68dQh3IZdALWen
RcvEyp3JRILKIqhsgvpYXv/Mze3Mobz+gr36XeaUWxCUB0FFEFQKQWUQFHfC
/4UkXpNEwlWi7NnJNsfLQ2H3Z7JMl6sdeT1+m9PRgvU0wX4+ny5fo+sW0TyJ
9j50NKI1H9VhpNYoM2ftZxo9O5gHMnuQ9SOvuJMcx02siKDKtdgjLVGxc5bI
RJsbA5UnqdazVN95auhrqvfcJzb7YOanPrQRf3Dg8RwIKpSg0gmq5DjVeIrq
+oLqP0/1f05x9uFfSSKQJAqvH22jvh5zurkUZriZZSus9pH0RMmn0xQbhYr9
KhndvI/uXQysY3gOI4MYakBXBkm0kT8IyKdqXTt2CU8Iyu6da2WsYN2BMfqW
GvueGv2G9YNrIn7leaeOS06jug7zd16tPTTnP6Z4d6nPPl7J/+BWcuJwJZyV
+eJARraESTBhmX7EtvwL+7bv7Yd17GZuWa/cM9t4qM/caPpnijvRiaRWvc6J
EerKsuOjnVBLaaa7piqM7k7BVAHWqyFuhbqPxqgKU/uY28T8HGZ7MVpKN/iQ
5+aYgbQJ6gFrWU19Cet4xqKdeVP3jUv3T87jN5wW7tnyHr8UPDXafMQuqeVa
zNCDmHmjaL5F2N4rf5m9q9L+pcTyE938d25FRw93FYdl/isz0A3C7AXh6E14
J5wKKvo2olknavBe1JxB5IZ5iNDaV2rrorC1lFjp854wZ+MtY6aunp9/cn3b
3kgR7KBJD6ArEtCZg4lKrLVA1AfVOGOmaCyrwZNggw/eJOYb1Z0Rn/0WM9Rn
f3ONMDcmHJwJz/BjQZlfRlRcjm6/GTvyKHbBmJl9+N6rALm9u9LBhpnf6mNq
0qKY51Akcs+T+2XQwQl0aBAd5KBw+RTLHKxM60Obd54ZToewfkz42mtFh55O
zbqYXX0rv/tZ4dSLQp59gdDtrdwnjQ6Mo4ODNIFOak9jxj2Rx4avfrf+8J70
lYXG3x3JESjJQGsJRhqx1IOdMcjngTVAAOyosLuH7SWsdUp7YxkPz4x1l/C2
JMK9TyTGX8jM/zm3/m5Bn0HR9MuidYcCkXuO3DeDDkrQhIQwM1R7mcy5dgj8
26URzar4WqSWIiMb6VFIcPpkH/6/3Nr+9UPbeYGBQDeJEOOjqW6nC2MuVeXr
NTQatgzatM27tG35t8rCG9Vx1UgpRloW0qKR5EESJeTRCfLyzp0nKotX8PJF
XBzyc9FQjf4OzA6DPwvxKtTMwkSs4YREjr11mt/HGUTb60TgU60k2xM5gRdK
U7VrSu43tpi0DL9qW3BlhmuRhjeqmOGSS5jh2GkneaiDDHbiJpXpY3TeAEo6
UVGHigKURCPV8mPNHazunz+0wl8xrpOBC7eI7Bcnqrx/aE283VtsNNz6enzU
Y3I5ZHI3blyVPkLn9qG4HWW1KGfuHE8S2aTWNPnT3g192tgBzkEIT0ZmESob
0NmL8QksL2F7E1IRVBLQCuZHA8mmgt9LElYM6rtOpBlqlTh9WR/6c3vG/b6K
58MdtmPjHuMrweO7sWPK1CHN214UtqGklp15cTyyXYVv+eoSHl2ziKYptA2g
vZm1qpVBn+jvv3Er/O+HK+Rs+e9d42y5J0FFcYjtLWfOD9A+s3pvksi6fbTW
8kKP3/WxZP25slcr7Z7r42Ebq4kborfrmpJVunoBjRNo7UdbE1qKUBtDao0x
q79qoHnkhFeh8E/H/XfGPJIzhskEtbMPiQIKFVRKtUzC53TrRxLpuloVJmda
nS/3R9yZyDKeq7Jd7vJcmwzlrSXwRFlr6sJlumIOdeNo6mNX1VSE6mhVirG6
YZ/uEKJvA0PzGBlirXFn6mcfo6N/4lb/Tx96sj88sKLv/UHZcar5NNXNmOkL
LGBsfxcHMZJIIInqu6f7rH6a8X+0lmK5Xea21xEqmUiSreXK9sqlmgYx3bGD
3nUMzmGYmUIzehgg1Uxe2ib1NTedcICMXTmfyUi45BjVcJzqOEN1n6XaT1Pb
KmzJlas7iyRhx9hrbaL81tH259+MuN6Yi9TnZdsIqt2F3aHiycT9tez9vRKx
plZItwjQtYq+WXaFA03oykGFh6ob9LAGk1LMbmF+AbN9GCn6NZL4xw/9CUke
xm6mwYRVxjG7inOO7RcdR67Zz+nZrD5gHJPBxgNqQZc6RIhHOu99NW11a8PP
ZC/ZSVkWSLcnYDwHqxUQNUHdTWNYhYl9zAowx0xiEBM16Iolz80zo1wnKCOC
ciGMwgnzzGOWFZ9bt35rNXjl5dQ1s8WbBiu3qaXrVN0JqmKgmtsS+aRW6+2z
o89/XnR9JIiw2MtyllcHabrjMZmNtVKI6qFu19D9coyKMMln1zg9gLFqtEcp
RoAZGksa8OTYEHDmv/4TPPhfOVn8Az6Iqv+RmeU1wsyccPImfBJPhxR/F8n4
teEH0QtGUXyL0L1Xfpxfs5a+MhQYMRu3Svv46K3L6xaP932s1YledHE0zQQt
I6VYbsRuN5Sj7+axJsM6M48ZLLZjOJPzQv/yhHjxmrAL1HJPOe1b8lVgy8/B
g7eDZp8E8ox8ts1cxS9tJS9Nhc+pMR1moChmD5JHBm58s2h8a8vZSBpup870
pSuj0ZmJ8RKs1kHYAeUgMEFjTo0lLlhYmcZ8GwbSJLMMYgf4jMNQY1fMOoyV
1l+Wxt8fnhEugtA58F4PCD97rdiws2lZl3Nq9Ap7DYpZd+JYuOeRq/BPp4Pj
6VAGrjtrfJ6TRAN5Zu62zq6podLDEbFByE9CYwEGazHfCcEIZO9nss3MRIKd
NWwMcibA+BphZ0L4uB4Pjz6TkPNDau31jJ5HWZMmWavWGbuOKRK3OLVXmNrH
S+Nlo3BiItkUkmghT01d/5Fv8FDqaKEKcaPTQlGWgrYCjNRgqR3bA5BPAguM
s6TB56IVwSp4A/R4rmgZKiZeEB54GQX2eOq1tk+w+T9yEvnPh/uD83m6jKW+
ToQYHk13O1Mc+2NNwd2mZpO24dcdi+4d24FtiqgmdWIN0kqQmYWMGKR4snbg
7IrOTamBGd64ITwC2ZmoKUd3C6YGwJvGr6YiZqaihHgL2+OMOLQJl3tEmJVW
su/nOYmXSopuVTZTNUMWdfMOdQLPGklgpTK8GLFv6fgkxAcjyoENJolu8szS
VR3RU32V7WsE+CIpBkXZaCrHQDPm+sCfwP4C6HVgix2RXaloE4JR+UTO5gb2
hVC+c0ua/fWdhdqSI1QNQVUT1MdW5P/hJPO3h3vlP7FXNzktMj7srdmJau9L
7Yl3+ktMRtvtJse9p1fDpkSJk5qsUbqgH6UdrCeuLEQZY1dryC9WtfVUD17i
lRcCYpGci5IatHZheBQLC2BntcvOCnJuYjIhN4qLDhHzlHhre6o86IeGtFvt
5fo97Vb9Y86DK34DuxH9ysRudXobcuqRX4qCTOSGk0QcSfSR59au3pDeN4Gl
E7yCEJuE3ALU1qK7E5MjWJ3D7hrkW9DsMYrgwiPJrmZ7PIpLKWyJIZZDroJC
qd4TrVSfNuq8YDh8kZq8Qk3/SLWdpj5Bgwcy+usPPe7v6xCUCRc9RRNUJuMJ
jlBVBFWlxXrfA29ziyQcSSLzhlbdy6/6/G5MpBgulNuudXrzJyM3eSmb4ryN
D4KofnQ0o60Y9bHk2SVST3XdCqa+cEvADc6xuxNUMDcS4+AEe++mr6KlrBRf
kUQ0Y2H1T9Y6ftMZdmMok5qosprtcl2YDFxai1ncS1tQ587QJeOoGkBdO+qr
UZuNslCS6CEvbJC3VXpm9HNXuIQjLB0ZpShrQmsfhiYxt4SNTYiEkEuhVrBS
1MiEUsFIyVGq/hjr7rpOUY1aFF8mn1wd7PjZa+y25+IjF76B3a7JC6ERNXfj
k1zTP3By/KsPYznyOrdABlUkHTEoPmrU+Llh7zfU2CVq6go1dZka+urAVzFq
r7pzps/yp1m/J+up1rvlnvudEbLJVMV6gZwJ5DTvA7mReYwOY6QZfUwIPUhe
l+pYQJvzVc4EFc457WImijtGtZ6kOk5QTVqUgHHaCg1vb4tLqeXcIOoNz/W+
0Z4Mf7yYZcGrdhZ0B+5MxQrXM3bFhTt0lYBuXEPbArrH0duD7hq0ZbCm8ss1
Uk959QWeeuB1FDsi44ZtCMqLQ0sp7J5govLP/lIoxz4X++5JtmfmGlu+fjlw
+cXU1ecLN6jlm9ScNtV0I2XwSeq8acqmTbzYMVLlFqB2d1K+ef4JCvwvnCz/
HB/krC5eY/ekmRdhm3Dcueice/Mlr0Fdj5l7rrxnjluGVrvGJjsGFO8+c+rS
ySPtehdmXt7e9DXdT3FWl4XQHUmYyAev6n0cqca0BPNb7NmdH8RULXoYUEzp
EpQB6/f1I4jnWSfMK09btH3zYvCy6ZSO0bwutaRLzZLUpFjRtTJ9ALZune41
/GHG+S4v3HQny3G/2k/eHaOaylDzitTiGpW6VU73iDG0jbFVTExhohvD5WiN
JE/PkDel2i/Aede/owjKnqCCCCqRoPKOUlXHqZbTVM/nVN85qvMMG7DObS02
Xgnsvxk488h/zdBr29RZbGGzb2G8Y0hNWFWvvakS+ZQpggsQlUXHxiLGmw56
/vHePJDnn330KifXf2Bs+H3CwUHLP+JE5Ntv4+uuJvU9TJkxTl63TBDZR8ud
g5VuHhq310onYxbpHBnWvbRu/ljiZaNO9KGLY9H6FqMVWGmB8CCanaexosG6
DHwBNmax3MGt8vvHhKkt8TroiEvaaa+yr33bfvYfuuU399h73dB929Rhz/yl
2Nxw24DKu1rCYjetjmufTxleXXd6thdmo8z00lRF0l1pmCzEWg1EbVD3A2M0
ZhRYEGJpDUvjmG1mAAR/BCS5xWGjg7KBgR9hmkBY5J+yqj1n3fmD1fDPFjPX
TZdu66/eZkVbdTW980HmuFHmimXGjn2yxDVW7RWi9vagPV/uv6b4wX2SmG51
Shuy65BXgrxUZPkKvT85+f83J90//RCfXSQJI13C04SI8TyVkfh9QcnNsjaq
ctyyasWpcterTB5UqInIpqOTEBNKR7myAeeJKV1y18hQ6eaEmGDkp6KxCIMN
WOjB1hhkTCTN4yLpXQ1EEtYB8Bk4YniVeG1KeLsfC409G5t/Mbn+elr/44yZ
5+k86xSRY4LUNULtGaDxcta4m0tsmZNRTh4Zuvrt6jM9kb2pMviNJj0Y5Ylo
z8NYFQO0sNsPxXsNbiixKQR/Cau9mMhbnT7Yrf/lHvH8BWHtTjhFHffIPutX
+V1Au07gsF7A3BO/dSPPHbM34pdsOmLXmOo3q521q+W71+wHVCjDixDDYIAE
xAUgwnorcVGePUcXTaByEHUdqK9ETSrynD7xTb+S7IcVOG7fGpKEpx6RbHm8
KOC7uvRbbVWG3T2v+mbc+/lBfZLobnVyG53VgNwy5GUjL5YkkshjczrX9p+Y
wsENoZFslrS6Et1tmBoCbxaiNai2QHMuFVIV9pldZKhNvGGwjY1WcsAXb1Mu
F5fdrmjTrxqzrFl2rN72qpQHlarC8xCTTsfFINYHYUxsXEsen9K5vPXokfyV
Fe3viaQoFGeiuRRDjawqBWOQvk+K7NIQySDcwOaIarqIAwzMiFZPCFfbI4EB
JyKTvowv+jGl8Sar02mT9DWr1F2HRIlLlMozSO3lxghCZk8t+gxsh/XL47vV
aW14ewAk0pETjDgzZfk23bCB9iX0TKCvGz0VaIz8xNL+/a8k/L9UKTnU/bv6
nGcJ5ULiNM5CcflHI5J4yUj07rFy2wvtodcHsw0m6l7N9nsuzIctbiUuyLNn
Wd1WDKG2C/V1qC9AdTx5bIbUld01p196wjeOTfgW16K5G0PjmF8Cnw+xCAop
i540SlrDuv43OkT0M+Ktw+ny0Ev1WXrt1Ybd3TZ9U679vIC+vcgedVKHJqMJ
OVXIK0BeMrIDWPEfm9Mm9+7o0xZ28PJHbALy8lBXg94OTA9zel6FUgBadKBn
NSS79M7k7kQec15Jwv4W4W9MxDgfSws7n5txpbhCr7xdv3LUonrRvkrgXiHx
L1GE5iEqg7GzrKzCX+27UMKUBVXOLF08jsoDBFKF2kwU+7DlmR4ZhoWY4GGK
sf7t6M/+GJ/+3a+k/0kNmDsLVre4YmUwJ/6SE1TjSarrLNX3JdX3OdV89AA+
BOsQpQ9Odtn/PBH+ZCnHaqPeY3swXLiYItzJE7KboH4DbcvonkbvAHqZILyA
BUc6Eh1zGHizztyQoN5wQ8RzzpxRMl+MA18uVWpIwoyL6vINT9Y6f9cZeWsw
x5DR9kyf+/xsyAI/bl6SMUvnT9KlI6jqQW0T6stQzUD8IvLEPDPKLSPa2Alv
QhCWgoxiVDSirRcjE1hYwiajcyEUB1BeyYBmkWJnkjsGTJAQeo9IeXEs3+OL
yugr9Tl3WmsMO7utuiede1d9e4RhXcq4dnVKIzKrkFPICi4rGAlWooIddaWA
buC9gzDMpq9CS5K8D/T4QbgpxioPyyOYKv8k4/CBLj6ucGt/qBtmhnfZZJFR
MGGRedSm6gvbjh9ej+rYzN2yWL1nvH6fTY/PsqFwKqnV9ujrKXs9XriZMMdZ
Vh+iGkzSLOZ9ULwbEmGcj6l51giNNzIbhPxug6sqs/AqgNNF/jGq5ijVeorq
/pzqPU21alE8JdbkjF68SOItA+iMv+xzvToZ/Wwpz2q93k0wELI9n7AryN6R
FQvo6g00r6BjBt1D6GlDVxmaE8ljk6TOvo4x/cgZNmHwzQCzx8xZ2MMWAn6L
CSM++2eBGCI5awblKs2+VLjG6+PqvQysTn9wpNTqbIPP5c44vYF8w7F668k+
l+mZgNn1qJm95ClN9jhdOISyblQ1sUKrSkeR/3YQpW5R0D37GNphsdDkJCY6
MVgoL3nNRr08GpsMTBVicw6LdZ9kP7gs52d/8tGrXPbP9v01STw3I+x9CK/k
00Fl34e160aOPoxYMgrdsggU23hIbe0Vti+kVoxSChkEc//HNdun4tDX6mw/
ujYO/TmYr8RWC9h9wqCKWTUWpVgRYHUeS32YqjjQuDVB+RHPk7Usis9YNV6w
6rtsOaFjtnDTaFWPWrlFzWpT/TtSkohhsPyt030ml2bd7q9Hv9jNc5bUB8kH
4lXz2SpBqUpWr6DbpegTYXgT44uYGMVYKwYKWNP14w5pSF93BhN86XMJvyDO
7uYRVOURquEE1XqMajpO8ZXgy9VLu+vcSfElibSrRPmj46023w343phIoOYL
rVYbXNb7A/izMZsbaZv7TChWtkbXMqHYNNqHWIm1l6MpGQX2yr4DFKXEggjL
DIoaxXTtfo2rigm8twHGF+7LGIOpXm74t+mEq7DZM9ck8eI+4eOgFR15Ni33
x7cNd/IHjQrmrfIFTrkSz0yVf5ImKBIhvnSQLYtJTs/o6Qqtn6sCXej0cHbH
dJdiugkbvdgfB33gLvlqbMmwxQd/ksPpRs8JGw/COfaEV8GXAQ0/BvXdDJp+
FLhq6LNl5ia2tJdYvti3oAQGFJfp7tD9YtpYl+9iII6yU+X40nUxdF8mZkux
WQ9JJzSDNCY0mJVicRtLi1gcYsRAdzPB6sFY1LNDbeinHDMqOm5S/4VJ9zfG
I5f1p36m5nWo2Z9Ze1x0hYmUzEmCQRolukfbHn85/Ep7zu/RWuKLrcI3okb/
/YFo6Wy6jF8g26+UaBr32Exs3zqGFljxjbShvwiNwXIWfQGrNIu+BLvYXMBy
++YaJNtQiwEZIFdjn7c5VVR9nGpiIlWtT6pW/+nXa+Y7xsddJYIMj6Z5nC1O
/Kmm9EFju2nrhH3bmlerKLhJGVNHJ1UgLR8ZKUgPYzHpmaUbtyVmL+HthcRY
lOSirQZjnVgZwe4cFGtceobxpGI1xHsHRfP7hJutVkjwqdiMb1Iqr2Z0Psga
N85ascrccUiVuMWrvSM0vr4aH3u1x3PuKA5d/W5N/67Y6YUq3JXODmMcB3oK
2XBsvQPiIaingEUaaxrwZdgUsHWXlQ7NcPpBdez0Q8LIinjpq2UXf/xN/udu
dd95dJMe47fdFh++2aBsd4xe7hobbuuzsTpJOHE7oVHn+PCTHxZs9Pi+xqIE
O3mBj6Yhku5PxWwBNqqw38wlhoeUbGJ4RsDKb24YUw3ojpfMgz6AbUIae1II
17Des8LHtggSGVQqqJXqfdFS45em/T8YT5L681epee1PtPMff712HJnDfI3I
Nj9Z43+5I+3+QKXZaI/TxIzf1GbUpDRlTPN2iC7qQVkzKitQ+RalUeTpZZ07
Ssoab/wRmYScItQ1oq8PM1PYWMGeAEoRaAZQyZkfOXMirxN+hiwLKDv6u+K8
65UNT2sHXtTN2ddtetayWbqIEsTlIjEFieGId2O5A8cmtX/cfvJEYfcKwb5I
i0X5W3RUsvZqZQC7k1AsAQeWQqiGaB+7q9g4KIEZ6BAvjQhnZ8I3/Hho5oWo
iitx7bcSRh7HL5jE8S2jRHahijd+Cuc3aueXcjuKK+GUMqBE59zsA22+9ZN9
H0tVnJsmL4SuS0JvLqYrsd6MvR6oRoBpGotqrEpZ8a3NYqkTI5nMyIr34F3G
gPdN1UZ3vhZVRlDlBLXDOBeZvH+6oU/Xb/qBD8/AbcfUTmxuJjT5JJL7Dfph
NlDqdaLO6pv+wNtTmc+Xahx5ff78+djNrUy+vHCdrlpG4yxaR9HRhY5atOWS
x6ZIPdVtG1gFwj8VyaUobUXrEFuNX+CBv8vGcTIFu3U4xpP/bSLV/GiJ99f1
ibrtxc96Wi0HRp0Hl/0GdyMHlIm9mox25DagsBxFb1HIWJk88sgMA3XvGsDS
AT5BSEhGUSGa6jHYjbkx8Bewvw7VNpeulTI/Suzz1YIhzgbY3SH8XxJR3sdT
4r/Kzifz6+8V9RmWTFuy9WOhe77ML5sOSdGERyHCD6F2XI2jhjw+cvWbtXu3
xBbGSk97OtoPb2NQk4WuUkw0YrUbuyNQzADLzKagIVCz4ttew8aQejyHQfd7
Qhbda5QsuldJNjcW65sZPPM1Nfo9Nf491XOWar+bMWaYsWqZvuuQJHOLUnv7
a7wdFM4Gn8SEf/vrdfSG2bZ3zvRbac8HUfxMW2Gtr6Q/Rj6fpdgukSvqpHT7
Hvq2MLSKsWmM9WG4Fr2ZpI5YxxJ6BGVJUD4clyP7gMtxhN0+PCkESmyzOnJh
NsDtYxVW59r9dQZTnkyUvZzrcFmcCFxei13eS1/U5M/RZZOoHkJDFxrr2GpC
TSx5dIrU3r9pTJs4wzUMkenIZtBxC7oGMD6N5VVsbUGyB6WMA8BKWi3d4jaD
wzUi5AmRYnsyL/BCeYpOXcmDphaT1oMassC/VRrepIqrpVPKkZ6HzGRkhCDJ
gU3UHZsmL27p3ZebvoCLK8JDkZHMVnwZsz3Szvo1wTQky6DZAgvr31nxMYZi
a1Q4kh7LwP59CBUs7Jco1VvC5ebv3wzqOM3o2a0+shI8e771lFrRo2bs6jY9
aqVBlaqoIsRnIjEacW5SL+p3flFLf/zRq797oCWt1lvnZy3vbAVayDLcNdUR
dF865kogaIC8C/QQjUkl5vawuIGlGcz3YKKcMSv3Oa7KQSRUepRq+pzq+Yoa
/o6auEiNfUt1naFmpIyWIrWJ8jvHu2wujwfcX0w1X694s9UVKJyME/EyReJi
IV2zTTevo2MJvZPo70d/A7ry2Hjopz1tBhG74FUE/LPwlKsGexFUGFd0XtmB
QII9BSScbITiTZKwIYmwa0SmwZEyx/MNoWRnxoP+g0L4mMfEMlcIV6QOa972
o7ATpQ0oL0V5BooZt9pIHp8nfxLpPqENrOHghaAoJGeiqBSNTejvxfQ4eAsQ
rkOxAw3n9NkMv3RXtT1WSFDVx6jm41TbCapOi1qRSGt/ju7Vi5l6Fr1mFrFr
Eyyz91I42sntjQXPqZ3IQWVynya7Hfl1KC5CUQIyHT8+S3/zm7RE9OleXDd/
KvO106QG0hVJTOTIACNsdEIyDJo96jR4KjC7ZnMdGxPvULJZIGGddsS+7JxT
6w9vhq46zurZMhto86np1jOK/4iaZ71xJrMF7n05YX19NcBoJ9VeUuGn7IzR
TGbSvBJ6r06jblfSfVKM7LKx8/QspvsxXoe+NPIbHqnPRD7UPYJ6SVDeXNUg
i9kOBFV7nGo+xrKCK7SodSZAkiqmNhcYq8qMdY2oND7T5nx5IOLuZJbJ/EHB
fiKUt5rAE2WuqdiC/TzqJtE8iNY2tFaiKYMFPyfnSFKsQ9EPbWHlB+84xOSw
yYbqNnQMYXQGC6vgb0G0B7mMcf6slpTSne31vsZzJj3fGo39SM1os/Bw+keq
5WHhyPOixVeFW855Up9sTVCyJjSCDvOkA8yE6SuawgW6cgr1Q2huYzNFNdEf
o4a//k1aOjKs/fOuoZHa3QXxEWyyqbWCc9GDEE5DdVhNZWCaCnuiA4xmQjh5
ED5xp0IKv41s0okevB8zZxC9/iJc+CpQZu+pcLRXOprLXlOsDI4M6V1csXwg
9LdUpnhoyiLo9jSMF7FVXFEHVL+q4jJh9QZbxV3swnihqNZNm+OXHqgo7ohB
7jGj6tPGHReMBn9gC1GzJAuaR7+jegQ7HGhOJImKW8c6TL4ddbkxH2nAy7bZ
OiQTJLBkAlGJWM2SCbbQxUP/PAZHMdSB/nK0xZPHxsmf95hNoWcPkwC8ScQ7
IhhbVgrh7HkSd4Z3FRBzxYmtPX7995492h4Tem5Lj9/wDV7vmrwQmegLnlGT
Du1rXm17Ic3KmHo6uQIZjHVNQpovHWGoqRPSbZvoXcbgOIba0Zv/f6Qlop/x
1Q9NYe+B8Fi8zUNdLZuTmx0Hf5FxzFAJD7AL8yPXJqzuEL6viJjg06kZF99W
3SroflY0+aKIZ18odMuV+WbSwUmasHCEeSP4FVtuPzV9S3v7hb7C216TEMAe
9JY8jFRjqe1daXnxfZAtxhbjk0cwX83shZss38PMjbCJOurw9pRL1dduHVfc
R2+4zt134j2z3TJ8uWtktGNArT1g9oIzizi0Wm+eGTP5ecmFpTmIOZqD+pDm
UAJRHVTtGrpPgRExJgWYWcLsGKZaMJQjKrYhf+CTT9U6HOvwOpdzsucyHPEc
n4fxtHUnqdYTrGWr0WIz872LgwxkHH2SsPg8btMqas8+VOnsq3R1Ujmb7VlT
/MgJSfKYJvsAEzehsgwVqcj3UHcx6F2BSRFmeZgfx1T9x1me//CLWvq9A4R3
RXTdlH7hBZ8EJBWhpJGlDI0wu3oNgm2I96GQQ8NCAXMdIviZVprz6cKoi1V5
LJ2s9Vd0sogmVXwNUsuQkYOsJGQEseDp9OK16/vGprSrC6LDkZuO+lL0N7Hc
F7bWvcjVurcPgikl9raxM82dVdOHhN1rwivwSHDKFxGlF2NarscNPYybM4pd
t4gSvg6VO/rJnV3UzlYKByMOpVWSWoPXvl40urn9xkga9p56kYHxYqzUYbcd
yoH3h1aK1S2sLWJ5ANMVO9XO5NEe8q7kQD/POGfrT1AJzOk9alR12qjtS8N+
xtleoWZ+puZIVkXvUGMJz7FY5JEv889GaIomIhIRzMZ8ufmKkuXz6Ipl1DOw
eAQdHWzeoTFeyWD4WRrLKvBEWF/CcucnGZ+/+k06OrdCGmoeebIu2pFLkcRz
iCCDq0WuS7CtgJDVUYAOkWVyrMrj+9b4W33FhoeMuJWQSWE8x4jL6+e4dg2o
LEVFOkpCyTPLOrfkjy1g54mQGFZ7FVXsrMeHsTzHQlkZE4XvsWCaDalkYk5B
L24QHsZEmOvRxKhzmW+v5NboFXZTxZMWxWv2RbtueVLfbE1wqiYsGhEBdJgj
p6NG8tTk9Ut8/QdSBwtViCvHBklGWz57ZBfbsDUA2cR7NogaW1Iu7TGBxfqx
OSzxwHFdqIeEwUvC3IuwiT5in33yTcUFl9ZLLoNXnaf1HFce2fKpl9sGxozs
1h9SQ6/aF1zbBf5tHHuyDqnlyMzldqY/YszkNRK6RYQeAQaXMTqBUcawFsiK
rN/VKBTYZeLugV+joz/66FXuU866HJj2e5e+rD1KtZ2ier5g6cudJ9mGiwU5
s4pUXaLG7Mseb93xJP350kPSHn8tib93QNqrWeC4goPoaGfDzpYM1iPfUt6y
pF/4wCse8fkoqENDD/omML2EtU3siCCVQqGEUgWlXMJR5n3vEvEWJ7K9vyhN
+Kmm8G5jk1HLoHXbnHPbpl/rfliTKraWNfTp+chMRWYEUlxYhvTJBVJb9OSZ
6tVr+Ptw5JQsNJaxDLbZXmyMQzwPNe+QnII9FZvG3p1XrzTHsFuCjX+vERaG
hIMj4RGsFZByNrT428hG7ai+O9FTT6NWnodvWYaIX/vKHFwZwcntjHbMqeXg
iZ3YcUXaiCZnAMWdKGe2ZQlr0gp8ZO3Q9NMYl2NGiPlVLDA2tU5S46Le4jJ0
TGgnEakFg+XHqPojrO38pMLzl7+oKe5TTJhP3eL8tB9hmnzkZclZq+avrAZ+
fDl51WzxltHaXWpNj2XUccFP6e1TPS9+nPZ5uJb88oBaKD2kFlZINY1iumOX
YzcuYHQMo50YrEBnEnlNomOBpz4stdCEqyUdlBlSOSrjihgCOXZVzIGlt6T7
XEY76QFRZPN5bcCP7Sl3+kqNhtpejY24jy8Fje/EjMlTDgB1F0obUVGOimw2
DUK0sidXV3LHCBaO8AxCTBJy8lFTg+4OTAxjZRY7q5AJoOaKPjQTa8kk9N7S
/nLjQePJVeL1XcL7BRHqfjwu6mxq9sXMyus57Q9zR4zzFqxyNx3eit0zFT7J
msBoOjiQJYr4Pt+0poRZPFXRCl25gPpJtAyivQ1tZWhIUGaZ05M0FjRYU2Jj
FxsLWO4QbLJhnkrOhnkamUiw3NL9tSEDEQ+Q0Meo/DdozJ0kDI3Y+qtL3Amf
wvOBTT8dcvHWjX12XrjuW9nJrM0llkwIGUxqtdz4Ysr8xoa3sTjJUVX6EQGy
h8awmmVhzm1jYQUL45htw2gBeX7xAF/bcOaf0VXuEZb503SSZSP0nKbaj7PH
d15Gk4QlScTpEMWPTzTbfdcXfGs8zXCu/NVSh/vaeDBvJZ4nZMB1wXtwPYS2
DrRVo+UtCyzPLpHX5Tee00YueBOG0DSWisYotaUXgxOYXcQ6H0IhZBIoFVzS
QCGXiRbLTr3gynSON4jAJ0T8q2OZvl8UxF8uy79RXfekrsesYdK2YdW1Ydev
VhFWpYopRUIeUlJZCSZ60OHGopJ9da2Ibt1G9zoGFljq1nAb+grpGi/1ErDB
eGCarXvtbmCjj4GOjOXdUzLhML0t5neS3hN3PFeeumwZ2+6ZmQqNP+VR/cUv
ao37lCdjivQIt9daoSGn47O+S63Rzex9nD1tms17lSlyTpV5xql9w+gAH42/
PZfS77v63arJfbGHpSreU1MUhZZMjJRhuQm7PRxVk/WfGvAUbBaJz5i+QcxV
fVCkMEo8Ylpw0rz+nHn3d2ajV4xnr+kv3aCWb1BzOmx/B9ezk3dNq/nJl0P2
V2eDn66lWwoqXIWdweLx+P3VrH1RsVhdI6JbttG1jv5FtkQ71IWBKnSlkSen
SV2Ztin90BXWEfDOYDlcxhyY8+bwNhMw8/awLWPNIiM6kUyyzB9/X9S7SaQa
EAX2ZyoDf2hMvtFe9LSn6UX/gP3ArOfgRvDAXnSfOrlbk9mG3HoUlrNCLIxB
tpuwHqoOmu5XYmwf0wJ2f7Bp2Xq6I1K2Ac0ux46UarC/reb3lR+hGo9SLcep
Jamy6Wbq0NO0RfPUbdsEiUuk2tNf422vcP60I+LPf1F3XE7Dm6NZ+FJEguvJ
nNiLpYW3qpv160asGpbe1G/71CpCq1TRJUjIQUoKUsKQ6EYeHdH5cUv/mcLZ
HlGByE1CQwEG6jDfxRJLpbPAQRPYjobdbEIBtqY5LG5oSlh6EA4xJ13zPveq
/cGnW8dn4q730hN3vpGT0OyV2NxMbEZtG1IcIa5G+/jg04vzdnf5waZ76U7y
igBNRxzGs7BaAiELxGm6T4mRfUxuY3YFc4yL7MBoMd0SRF7ZJo2h68IGSk+4
NIcPF0YfcMeqjlD1R1lPwhivVTk9syuo1k4mCQvWnhBpukdKjU43OH3bGaI7
mPZkrNR8usVhbsh7YT50YTN+QZIxR+dP06VjqOpHXTsrx/pcVEVpsl4qmFCR
MYrzaqzIwNsCj0EyHfRginAbin3mdLN2US3d2Vxu6vraaOQyNUOyofP4RWrS
pnbdtWbfv0IZUYg4Lt0U77b95rBf89+sQU9dItX0aJnPt43JtzrLDPs7Xw1N
ug/zgof3Ygc1ab2at+0oaEBJOUrfojiWJEa1fxY9MIKtM4LDkZGBqnJ0tWBy
AGvTEK5AuQla+G7XSQ9LHw8JZzst/+DjEelfxVX8lNSulzL6LGXJPEnAct2i
lG7BKg9Pjaet2u05R4Ft1/l8+pEO//Wz/cBX6lQvuiySbkvHaBGWa7HTDsUh
TtdgWY61HfCWscqEbfWqnuiJKRYDXuUYTu8b0HIIqvIE1foupzp5iZr4gaWQ
FV4rbnxUThKM40jWIUpvEi0m5/udtSfCHs6nm66W2W+0egmGw7YXErcFWdvS
IgFdtU43rqBtDl2jrBx7atGRjSpv2WEYyaBCNXYYmM3DxoB0MGlDhF0ZmxeT
KjU7e+sdP3FMyccum4Z2QlOLPVP99ceUIGxQntCnyexAfj2Ki1GciEzHT87g
n/16Df5AEom6WpUvv+z0vzaSpj9d9Wqhx3N5JmyVn7giyV6ii+fpqkkug9KJ
1lo057Mg7qe9W8a0mRu8mC3zFoXVaOpkMwdzC9jYwN4uSzxQHxAP5DKSeHmD
8DEmot2Op8V8lZurXVT/oKzfpGLGpmLDuWzPu1gelEdHZNLRCYgNQYwbRzLs
17mweu+22Pq5yu8NnRiEokQ052GoCgttEPRDOgF6gStebmqwLcf2FgSzWG2T
DCQe1K++vs+yQ008CYtowib7uG3lObY/bkjbbvrmq+X7LzcemwiesBmzhZtU
m3kXRxMtJLWa734++PzSjLPeapiRIP21sMxD0hoqG06QL2QrBCUKaY2MbtlH
txCDmxhdYgU53o3hCnTE7C1C/avKLsfg3hrJ5YLvqqNsyntVKm/UTRp8lDz/
PIlv/Y6h6emsdjNbNqJU+Yt0xTTqh9HcjpYy1Eb/sgb/8Jc84PckUXT7RJfV
j5OBj1YyLDer3Xd7w/Zmk8WbuWJZuYhu2Eb7BnqXMDCJoT6W+NabR367SRrS
j91gH4OQXFAcE8aNQ5Hzm1jfw46MjZYlKgaKGJOE/x0i2eJ4vu+FqkSdxuJH
bS1mnSP23YueXdvBnbLoNlVSIzKq8bYYuZnIjUGWF9uw+92m3n25+Ut4eCA2
EnkZqCtFbyOme8Abg2geqvcwX8z4FzFEy5qNbk5731wjzAyI146ES4iWT+rp
wJJvQprIsP7bYdNPQleNA7ctfMXWbtLXtgpbc6k1tc6WolPYKv/RvtsXZkyu
rb95uhtqKU1zUZcF0a1xGM7CQjEEtZC0QXPY6ShhsBkrx8UxzLZgMJ05c9J3
lWA2BpXuKgRDDWeprvPU8LfseR/7lmqnKsZfVq46VQi9SuUsKTSTjo1DnC/C
zFnw0yZA7wrLfx7uQF/+J7HCn/56Df49qdV4+4sJyxu8ABNR+ht5VZCmNxGz
edishLQZmh4VhqWY2MXMOuZm2MzGZC0G0smHimscQnDlsAED/Au02KJc9VE2
UxvNcofXFByjjAFJqfeOlNmcawoke1IfDpWbjXc4TI37zKyGzwgTp1RZ43TB
MMp6UdWKmirU5qEqjiSGyIs71x7Thq/gxKwxDhm5qKhGeztGh7A4wzZSSLag
+qASSu/zZOvdXI3SSo9wtyCCPE9ExZxNzPkhjYFlXQ+zx42yl9nnLaTvuyYp
vWLUfsF0gCftb6N0N+Q6Otu0T03qXuQZ3RE5miiD7dWpvnRJFN2cjsFCzNWA
34b9fqjHOJTGNvbIWEEyUQDHo+RtYpeJUmVQKqFS0jLp9vBIQe8V+4nrr5fu
WW48fs4c+fUH1LRrHz+wVxLdpU5u5cinxShIRY7/rh+FIRUmxZhbx8IEEwl+
nN/6k1+vQcYP9l77ftXiodjPWp3qTVfEoCsbU+VscXW/F5rDKauwJsb6Btvz
sdx5QIAw57rvYrmHJVSdpNqYUJ7zMhMXqfHv2PawfiFzBuOuEmUPj7fbXhoO
vjuT/nyp0p7X5XPYELCXy9eU8ejaZTTPon0UXd3oqkNHHmuov9/WfqJ5YAub
APgmIbEQBfVo6EYvE+gusHnl7V3sSyBXQM1W2VVSMY+rkb2+Tvg9IWJeH03z
/yI36VJJ0c2KxqfVA2a1M7a16241Ir9KRWipOjof8RlIikNiIGLtOQvaR55d
vEnuUI/ldpaaADckhqCQAWm56KvEdAt4fRCNQTn3qwYgVo476+CPKKcKYrhk
8haXZNpVqFd2ljqvR4w9DF8yDNmyCBDbeMjs7BV2ZmJLSpAwL8+aoQvHOZJr
OxoqUZeGfEdWyCtqbOyDv4KVzk94aL9Rg0eHr1/ZMtFXeDrSCcEoTmHbKsYa
sNID4cGcWWxJswXLXTET9h4k84wJIzfOyeScsKs979B12X5M13b+jvXaQ/PN
p0ZbT6mNh9QMG+XnXT3a9vj8mN31xRADfsZrYaXXfleEbDJFzsuT71XINI37
dKcQ/ZsYXsbYFMZ7MVKLvizyy1XyoeqGLYwD4ZzM1lLNOSvtz3USMmd8ZQ+b
MuwqWaHtyOVLW3NcI2ngDSLJQCvP8UxFyMX6tJutZc862yx6Rhz6Frz6tkJ6
pTFdLIs3sxG5lSgoYE9AXghLLNQaIs/ztK9LHhuorW3h44PYaNao15SgqwHj
XSy/b3sW0hXQ3LMWIOYKnVzDEm8gueIo1XCUaj7BsmemROJGvZwB/dzZFzkb
dtlitwyFT6I6MJwO8UagtdiJUpRt0fXraFs8JNH2VqApAgfMF2Yxoi3w+z/7
LeZYfGxJ//jXa9GP1BrWJveemsDJDZFRyM1mCdAD7ZgfxuYsJKvQ/KqzmAlA
t5mg9wFhbUu4hmj5ZXweXHExvON6xOiD8EXD0M0XQXs23jI7Z6WDtdzOeJ+l
uFWRx4YeX1qyfbAdZCFNd9VUhtCdSZjIxVolRM0Hkb8GkzLM7WJhDYtTmO/G
RBndEU7e3H/fBeHA0QETOWRZdpSqY8Kq41TDEbbctiDDpFD4jn+Wcl2r2ORU
vct3HeHXBzKfjlZaTHY4zYz5zC6Hz+4kzMozpzT5Y3TZIKq6UNvIJr5r00ki
kiSGya/52rcVd57jhRPcAhGRwFrv8iq0tmJoALNTbHpYxId8F+r9XxVCldtj
7ENTzlNDjAFiQoWf2FaaNqOGUZvGJefGHd96RVi1OrYUSblIS0ZaEOKsFU1K
uluKoYN64hQm2zGQpeS4EWw6SCpSbHS3f8521I589Ykm/+gXNcl9yp/8ee+O
KW3liYA4pOahnDFpPRg76J/mQ/q+UU3JIHaT64SzCRHscTwu7lxawU9ZjXdy
Bg3y5l7m8u3fchsvic0whQTSwS4IeEESzdpnZ+7pbNkYyAPs1Kl+dFks2rMx
Vo4VLg+geN+yyVOCQeH8VayPYqFB0X/YyaLPJciDOU5vkRZVd5qV2eD31Pgl
avoKNXWJfaBEhk4V180br0MU3ySaTc/3ueqMRz6azzZfqXJc7/LZnIgQrCYJ
dt9uKkvW6epVNC6gbZKlL3S3smzSViY27CW/3iTvqK+b04aucAhFYCpbPCmo
Q10XukcwziWtN7exJ4ZMzjg9Vo1y6c7aamfnZfaxEnN3Xq89shRQz7f1Kf5j
atJ9ZC1oWBQzqEnt07ztQGEDSstQloHCIGkUdcjPXBZjjcfy0CaL9/bYsgzj
GhTSnY6L9uO6rCPlPzFmHOnIT5/GiQfa/LiD8t8faPNbgbYxre8J53hEFSCn
AbX96JnG5CqWGfAuxh7HieW8j8c9Itb6eFbA+eI0sqr8QV2HSeP466ZVt8Zd
/3plRI06rgzJeUhLZx9TkMp43g7y3MrtWxILU7W3CxJCUZSK5iIM1WHhfVrg
0N3QLAmDCYx35sDrOEj2PyYMXhFm/oRVkpZtwWn7+q8cu390GNO1W7hrs/bI
QvDMZItiRccR3fy4Ql3T3bMDZpdn3O6uRpkIsu2E1d77XeHSiWTZao5MWCZT
1knoNhF6tjC4htFZjA1hjEGYhXRTEHl+jbyj0H6Bh+6wjIBH+iHh+TlnErw4
qxBEUHwpdhRsVZktMoh4rVcjBu9GzFHh66bBu1Z+Ult3hYOtwv652IpaT1jZ
z1qii+bpSiZGG0RzB1qq0JiOojcs2ZFHQ6DCtpAJjuj5qnCC2lEynoKe35wZ
ehC9aBS5bRUitfdWvrFTOBhxT0di2xT++Be1+PsHWnyovElQplyoEM7t/hzu
ABRwleBVOdbZ0+hEEgmPiUL7L2rDfmrLftBbYzrYaz884zWyETq8HzeoSe+j
c5jN14jSSpTlojSBidjJC+vX7imMLeHqhagY5GSjtgK9rVyD7BTbIKvkgz7M
RtGQ7mNvhTOS+jcICzPC0Y3wiDrm//ZcSNWlsM7r4YwBXzAI5ZsHCq28ZbYu
CvtXcrvnEmuKs42V5NFevQszprrrrpQw0lqW7a6uYsx4IsbfYqUMuw1QdoAe
0GBMjmkR5vlYmMP8AKZq6Z448ugAeWOfNMN1t8Ny60Hs5M1hl1TuKWoHQV+l
FrXMPWGn9mZ29+Ociec5KzZvd5wypR4par9YTWAIHeyOgJeMI5SUCum6bbp1
A92LGBjHYBdbgG+OYLnCOxzJjOUKL+9O5NYfp9qOs72Hnc+KpyyKN5yKJN65
6uB0TUQ0HeWlCTT57N2T+D7U3R/++nMZcPC0qgNGPKPCgmMs26P9DJveGLpA
DZ5nex2H95mlRmgTRc9ONb+52Bd5dzz3+Vy9/WK/z8p8xKogeUX2dokumXuX
J+hCaz1aCtGQwCiVfEA/toGtH4ISkJrPPiXjsLF3Hvx17O1wOSoud08rFErx
GtcEbvuI8HlNhAecik++kFr8c2aTXvYA9XbW/O366yyRc5rMM1HjF6UJDKSD
XBkJkkQya9FPTuhe4pncFTmbKsMd1Zn+dAVj1LMwWoKlemx3QD4IeoLGvAYr
KvDEbKZinYHhbZrhtKlVkN/OkQbqg9zPM06jPgQVc8CAOUE1nKQ6vqAGzlMj
31DDX7EF2iaqduBF/ax9Pd+jThxQrYwop+MKkJSJlFgk+yHm5X6DRtOpxKAE
4zuYXsXsBKZbMZAh2YZq/6CXWaXaW2q7YDJ0yXBGm1rUZbs45926toM6lLGt
mrQ6Lp5ORbbvx3b2l/XJec07Bx0OVmxznlmy1sviM1ZNX1n1/2g5edV88bbJ
2j1q/R61doeavcrSt68RzfoXhl2uz0Ub8vJebzV4Cwcj9hZSxFt5e/IKId2w
hfZ19LxLHAw1oa+APD1H3lXdtIGZPzySEF3EmvKaXnRNYnwZi5vgiyCUsdhK
poJEoWSCQcYg3CKCDYnEN8ezw74uzNQur7xf3WFUO2Zdt/ymbtu7RhZcqYos
RnwuktKQEoVkH7aljOgizy4wsYTBE7mjtSbEA6nhKE1FSwGGajDfjs0BSCah
OUwD0WBtmxA7S1jvlY5mcJ2zbC7hhC7XUmtJ6HsSJpGEecYxi9KDBxNefDlG
ms/dMFnR01+7y+p0RocacRpY9BnYCuuXxfWo0zrYR+wVVKG4AMVJyPOTR1Ga
YRpTNBaVWBWCt8Jygcbzt/fYx9QoVEwgpVrnjwze8Jp76L5h+EZkZrP/wnjX
hBImz9I5k3TpMGo62T7qunQ62/KTZyr+sl5/951etQkTE+KVB1ue8i74MqDx
ShDbt/o4YM3QZ9vcbd/KQWbzUmptJH7JqLZC+/ig/o+Lzo8EUZbiXDdFQ5hm
IBnz+diqhKxZo+lWYkjCZhSmeZidwWw/puoxmEleE+u8xIFNsOCsfCiHUzPf
PRlmVcaa+A0FViRSDt2E3yHSzY4Wu5+vjSabc+931pr09rzun3Yb4AX0iyJ7
VUldmoxWtg2fZdfmsASaPP+DNnwmyHhqpHltD39/JMahIBsN5ehrxnQveOMQ
zkPxPj+0T7MWcG9dszmYp0V99tucXu+w4rB0IuyCjzonn3IvPOdVd5FN7I/p
ec8/9lg3dNkxtRe/sGRbps2o1cfUcuTCbvK8InuG658bRm03GhrRWIy6RBQ4
qQ7otRs0mPhzZwubk+rp4jQu/bupxPLebvf91CmjFJ5V0p5jrNI9VO3tSXtb
iu0ounoTLavonmEpj32M8w35P9FrMEmY3yXcbbVCQ07FZn6bXH0tvfth5qRx
5pp1+q5jitQtTu0TrvH30/i/gR8DXJt0vph5qitwMpJFOKjfBtB18ejLwWwF
NpshOXhM4IwGiyqs7oF3kGfowlSxqNnv/cM+A7hnGeRqsQ7qsPJ4hqV41hyj
RsRoXWNMcBBJZOodq3j5eYv3ld64uyMFJpMNr2f7PeZngxf4sfP7abN03hRd
MsoVIzrQUIvGQtQmss+eOL+ufUtx1xQWzvAIQXQy3hagqpbleowOHyaN9jn6
vOYgacQcGsmmlN9fc9aU8+ds++MDwsmK8PY8EhR9KiLr65iKK/FtNxOGHiXO
GiXwLGJ3baMkTiEqVx+2XOxuoXDSX03ZFuZuqco26ToeWhbRNcW24zFbqZtx
QqGylcPnAh6mGXdnywm216+DW3Xj48pB8+oF++ptzwp5cIkmKhfxyUgMRswr
TQdjvvcxIcDMPGa6MJD+azT7MX+D0ywTTZvqEn4GRILbybex3xcX3KhoelY9
ZFG74FC75VktDapQRhQhLgdJKUiORBKDYzu1L6w+vCOxtVCHuCMjAlUZ6C7B
VCN4PdgbheoQxzJbVImdPWyvgj/yjrHCatafMEg8alxw4nnd58+7vjEZvmw4
rcNSDJauUwtXqZEfKO4BfSk6ROXd4x1W3w/73JpJMFwufLXe6L45GLI1H7+9
mbklKRTQlRt0w0GdYhy9vehtQHcB26DOPqtApWtOG7nBKRzB6UgtQTFzhnrR
N46pRaxsYGsX4l8llNTSff7UTM3Bw120CdsbhLc+EWpPxAecSk38OjufzKu7
U9BNFU2YFy2/Ltxyzpd65ygD0+nQRDoinBVo2Cult76wQqFqlNEdYvTvYISH
iTlMMma3Hr2pTAirEEIjOeANSZW7M21fPR+8ZMQsnFn18g1q+Adq1Y+1ROrk
Tjq7CQX/k7L3jI3r6trFDCPJLcmPC9wg+ZFyk9wguQlyVC256bUsd8saqvcu
HoqkKPbeey9ip9h77733NmzDOuxTOMMylTPD6TNnATl7D6nXr63vhT/AMCDD
sui9zjn7WWs9pQOaqqA+zZhtg4dFemzJwwZ27b+itvRbG3uXKHE60xJ7pa/w
zmgryRx3n2WHzAni5xQZM6YCprl8BC1aG9ugqRqa8lCPcuXgwTO9qyfExUJh
LhL8jHQhRhBvAaQboP3dQAWZ0agkFpoa9sB1jSJ8s88F1XwR1vNdxOS1iOV7
4Zxnwfs2frI37oq3Dsq3pMzOsnluZJwee3pp2f06N/blfp6bvCHkaDBJy8rR
b1foRU16dbfOPKymmApgiWFpB9h0/zUDy30wW8H4bI1xV2flBE/p1iQDosoB
90aIvxKEsVA8Qe4o0KhJhkdNUp2eI94avJmDL3h/BpH4kMhxOFsWfKE+5Upr
iVVX8+O+QdvBObehjYChvchBRWK/IaPHlNsORY1Qit3ZShMg30s+CAbm73jp
vAPgbwKHCcu1Ihkoj5CMw2Cku1s1hzfKuh21+TR873Ww/K23yvkt/V1fvUce
lXGohg3oWIa+aRjqg8EaaI1CyzSJGQ7pTor7pz71n1e26O6ZDvdLY4k3WaXW
7A73TWYYZ/0ddz+He1S2TdVtUK0r0D2H7DQHe5EDWV8B3aPffEHZ+UJoEmQV
QQ0WC9GvzTobdnlweAC6QzD93b7GwhR2sSaCAojYlDMppX/LaPsle+xu7uLz
HI599oFrpsInRR8Urw8NM4d5G0Md8Haqh3Fm4ckPXLeHkhiHo9wAY30cNfCe
miuDrSY46IGjUYv3hhnWtbAtx74Na+gYV1u0Q/GMq2LGG7gRChb6iRPeGCTj
m73qRJDRju93jpYGBfLOe/X4h/TGV0HBE6LW+Vx72OX+dMZo+WNmm93sqDtr
IWhhO2ZBlDp/lDOH17zjUD8IzZ3oQFsKoSHBVGCvW8CaIjRHMcKBCkS7sLcI
m61067ivBamB/ovaURwwHxeuvi4QuuQd+r7XhqQYI6PNUT6GUFvUF/XRGHQX
preAxQJWH4zlmWWWJtAISv6f9pz//qOVxfX/lUFEMIiWB+cmvX5lv3vGLXPZ
6wqRTL+Tb+YdHlQeqptlVLeIGt6FCQ5Ms2FuBlHSphsZX/Csnpke+4JXMiTS
6LQVWoYRJWl+A7YEsCdFs2ANxn56tCuzWELHOhIZyNz2bxW1yHyxwWK+uOvf
cBheo42rMCMB0HvISKIyQnFxR60+37jHEDu/1ES6m7IjzLVpVG8RDbZhvQv2
RkE5+8HL0ozg18EhstylT5LTIx9LTjpBuj8+wq9rOJ4M09Cl8Rzq5UYtvdxl
ZGjH/Jysvd/XZzOEl3o0JCi0Ihqenu9x+3os8ups1sOlSts1+okfD+YsxXF5
6VxJAVdTsU3Vb1Bt9EPPgv5JdKhD9EOfD00hR+tg5n/g9uhBIQXpmn6zpfU0
2XMajTNXFNqB562st+3b3m3isBZNfIMxtQphgpxUyA4xxNsgGEo3l2sS2LR4
1dVpj8CIWElmhXT1X1PdX9A5nhp+dInteUeYZC8r81d3JRimc0wbleaDFrO6
z2ge18HsESzJYBXrHjZY6GZdqGHc1d70AtskuItMm/8+Ws/ELMudIzjQoyGK
WE9hmXbSU6LQ87OahL+1FiH7yf4R+6FFrxFOyLAkbkiT2m/M6UbSobJaqCiB
ykwoi2KcmmJ8tXP3tuqNnSHUHzLioTIHuqpgsh3YQ2hxJV8B/dYfiCsS+k4w
C4YKCdJS2Yd46BJC2KYQDsVnnBovOPddcmb+4Lz429uNm3a8e6TgAaITbt0k
h9xpSOCHva4abhF9zy4y3X9airq78Z7kVbnudgWJJuIkyxlSfqFMWiXVNiMZ
OzUogLFtYK6gM50ZoO96GEw95IF+H09cVJaJi5I63Oy+SI5/jQy1EXvkZ5J1
mVzyZ+5EM+UpE8bcUXNJP1S1QV011GVDeRAaJ26Z8Q0rgb012OwQ69DNIdFq
/7Qb/SeV/Rn9v5yau/fjjvszRaK7sSTK3JFJMctgrRn2+kA1AWZ0edCNvZGG
6SDcR8pF/gxsdhqns2/gcbtlVGuRe7dhZe/AWfR3+pdrWlhWmrCBU+nLUy1+
l/qSr40j38038xM+iysRyztJy/L3iye+m+NIbtTeBh3V0JaD4O43ezce6EhH
8A+BdylQUgStDTDSCwuTwFlEC4cji5Xp7wgtoODqhaPHb+wtwpYknHwIz/jT
AXnnQ+u+jOj5IWqCEbV0L3LrWdiuTZD0jY/SyZVuIum7bs/acslX0rfBrfNT
zy+z6Xs+6vn+eydZVYCyK0Yzka5bLtTzq/XSFr22V0uNHMGUhavAR4eKrvoe
GjPRX2HV7+cuuiONbHXiJ5+lG15b992ET9+KXr4WvyJ59COVsaksWjdXs6nm
ebRi6O3DfiOZRo5FnWq5YPnG7Y4uAhGb/rRv+3hd8Xv9I+P8yt1rUqfX+hh/
c2EStBTAWD2s9IBgHA7nwbAOwLPIHWmwoQLpHojYluG77e8suVrOHovVFn8g
V39BgqDVn8hpxMPzob9uN4g2mwsjgT/PpT1kV9pvdXnzmJE7aymC3VyBsnzH
1MCl2jeRnejQHIyOwVg3jNYyiD5kbvbI/MSVco+AmEwkxKtrhd4hmJ5F7go7
v18/HB+gWq/gWipKf4cc7xO+jkRE2Kn49HOpZX/LpC/3kdu5rGe5m7Y5u85Z
cq90dUCSISTaFB5oDnPRB73GV0AL49SE1QX2i5/57g/FUfaqLG99VSTVmUKN
58NyFfBaQNILiK9s4S8ghy0ZOlHeKmzTvVUNXwxiJSi1oDWAzkipNIphq5T5
h8lb1u/2HOIP3SI13oEGPzet9+tdO/KoXkR17FEDfBhfhymLc0m1vsHrhO5H
363C4a/Iue/xEugq8tj++Lf4j/X+N5bO58yq1U2V7VsqNAwxP+rKYaANWMOw
PQviVdDwgNo/FkkiqsyR3GIx/Yp47Uc4JRPupad9Wr/0G/7ej8Ww0HXc9l++
lVjbSPEgHttzN94+M/r68mLw7e10G2Glp7g7XD6VolzPV+1VKlXNCnOPnBoW
waQQKZrml2GBCfP0k1/F+JLHeGi85Qb20RD8HlKrobQTWsdgeB5Y9I0gBKEE
PWsqHRpe0ad4pFPvSzcseO0WEfqcSPIk3seeL8z9prz2t+qe+3VM63q2YwPf
u14SXKOOqjQklFApuVR6KmREQ6o3dizoZZyev/4N98l1ietLdYSrMSPYXJFI
teeg2eRiE3B6QTwG6lkwr1i4pybY1aEDPeDBLgs2WjLwlndPByID7OvMqyIO
89gSs1weWKyJyDPHZVCJ8VSivynG7qhbbx5Rw/QhLB4AmwNrdJvUTQ3G6zAR
kL5WtQoe60bw5iP/PWtPmR3i2m49+JO+9J/Wlphj3NA8cQKfSEjORmqHzm6Y
nEBmG4JttMnXyk5YNAjsqun24B7h6koExhBR+Z8lNF5OHriGmDwbr1KEb5Jk
rrFHXuFaXz+jv6vO1xYd2Kn+G58tvr7KDX4mTndWVgbrupNMU7nUeiXstVj0
i0ZqRguLSqyD4iP6Jd2bs9thKodxS33dGR5HgXs2IsXbYApfBP74Z2IJC/8I
LAd5oKd4SnmrVTmmX0bdIzJfny7x/6wm6XJzEaOz6WHv4OuBOdfBDf/BvcgB
RWKfIaPblNsGRfVQWg7lOVCWgGs7zDi/avX9/qP7R4705e5DpUZDacbxkJLV
BVsjsD8DyhUwWu53unO3EB7k+yBeMW61NZ1Gxpp9Z8meU+SUSDL4qovl1LPl
23MQgY290puQbUBBMRSlQX6IMfm1eQ67aWxpgH7dd7aAM64ZTZLpEB/4UKdn
Pshds0GfGIVvqiEk1hzubwyx/2u1/beW2v56eNORcoiGiFzIqcdUkWmYXYV1
PgjFSAFypAWdAWFd7MDmZ03EBZzOSPs8v+KHkq5bFZPPK9lvKnc8KqQBpZrw
QmNstjkxhXoXTb3zw6zMyRt/2yJviQNsj9VTnVkwWQ6rTSC0SB4/qKf4WszK
3AHhMnCHqKVyX/oNfG226JQtppapePlUi2MBejCvtusUuaqBRYWh6kY73iJG
0SW6T1Q6nGkN/ltv6m8jZY+YbbYzuHOZ58TMi1Pn1Tmz5pIpTFAdgOYOaK1D
aqHGREScObfN+EV274ne3gkCgiApEfXsDVVoREl/LNemQLAEsk3QCv6RB3Ek
A/n6/lLl8Ofk1DfHxLGVH0j6l4uBs7yYWWnqzLGfWDX2G2iqgsYsqAwwrtG3
HQV7JhBrQLIH+yy6L2vAc9f+p80sh1aud4s0rEmbUAvppVR2FuREmZJe/7G2
/+6jtf13lr7WxvwoHPV/JEoNQJSjBPxi0Nibp6I/LBjjouVd0H0i7e3p4siL
tTk/tdTf7Riw7mFhL4uDiJ6jxE5DeuvxoqM4D4qTETg7M3/ju90Xj9Q+TsYk
LLlqK0RX+VI38Ef/0YBXZELsdZkEJNuwyzSwayxffkvfEoFf0TKcytB/EYcl
XEZhCfT5LV4hBy6Sdc8n8aThPYOouX+my+nLkbBfpjPuL1a8XrU0Lct005LB
lRZwtRVbVMM61baMOvWBCTQVoJuW/gJkxHuBy7imvPmSeuUO3uEQmwY5xVBN
g5pupIVaYgFnDQ74oDwAvRzMH6gR2kODbHX4isfcVffVmy7cB293n6AQl70n
5DKD3MnYPizcMlatY6cyFvRNwEAPDNRAV5qOhxfP9AOiNCHUJVka+AwZULLw
bm05YEoQw1SmT5jyh6GiB1HRGoqgKvJPE4t/UtmzlqgJn5PBLv3gNBPobaBf
i45T6AmiMS5uXTIeE5Xu59vivx8oujvWQk6Nus0uBc3xY+dkabP6vClz6ThU
DyIyb3MjtJRBUwbj9CLjJ8nj53o3T4iNhnys1Rqkr3KLkfAKMhI2/53EaYKj
I1AIzSKWBQs9wV2LTSjhkEY4l55xa/nCY/Cyx/Qv7ivXXbbvOQoe2e4/JelD
FDwk56+SGINXXie6H56bcP5+IeL2RqY1r9J1txO3LCt0y1Ikk1VLdXTL0r1H
IeetLZhaQar+2QFkbDOcybiAVeXW5sde4BwNYVmQVo4yW5oHYHAKZpaRF9jO
LpabqkB3QpfQauRc3tj0rfjVJ3E8MlrkEKZw8dd4uGs87FUupKBYqqiVmNoO
qD6LeSsbZug/sZf+cqn2wSDHqidEF1VoDmbmfnVdv+nIf2BLPxbCR+Te+y11
6QZVz4Z2+pkYg8EO6Cv4a5XFvz57Ha8iA/DXrsSSVnKRnLxEztMN2I/o07L0
HTn2hQURVT851+N9eeLdrflSa3a728ZEyDY7gSvM4iiKt7GLLxs6F6BvCgaH
YKgdBivRRf6z/LY19cYXQhMgMx+q/lHYJRWABtM7j1WZOj2lPrBU9pkVYW9N
uPoQvgmnQgsuRjZciu37OW7qZhz7cSz3VdSBffihc8CRu6fWw1HtTsrekrgf
bUO28V8vOzM4Ec/2shxlVf6oaZlM160U6ndq9LJWvb5PS40eIfgyL4JlPqyu
wdoMsieYLUPEtN8OGdamuz7wOhZ8syG+CnLboWYYNe4k7t03DmDnEEQapKy0
sCeEh7tjDwoXXxVy3hYeeOQpA97rQlNNUXHmmGAq2kUfQio69KZBLTWpApYU
loWwuo4+7kut9ENCP8w6nFGg0cimbiWuPUOLNqQD8/DReb9VupLaZinVuw9j
fOR3MceEmRZ9i+8fp8iW+v6x38X1TbWsZHwJh3eES+lpj9YvvIaveLGuea7d
duM9ctx7Zid6SYpekEJkvFtEvxnPPp/2vbaa/Ixb7oxeC2aCdO29bLdUpqyX
mjtE2JuPhzg1M/OI8TbbCcwKxg8S+oV47g8+7yCxCAVxNPfD0DTM0aiJC8ID
kB2CWg36D/N6tegkoSnQkYgJO5Oc8VlmxZWcjmv5JwdZsO+Rq/B/rw1JRZqf
mDAq2tMYYc8gyhjEIOPs4qPvuU73ROG2qgwvfSXdwaQig+DlauC3grQfdOOA
QMyyETbUwJEBTwD8VeBMwEqDO/3nfidgvDAyvOBx7LEU9xEubACexVjSI8rw
rcjXg4Vc0fekedq2Zc21ReDfLA9v1MbXmlIqqMwCyE6HnGjIcBcFksYpAJSf
pcdebLuww4atAfq/eaBF4SkSvXn4QdmCTTnPpUzqV6wJyzXFplGJ0ZDgoQwg
KaYOYc21fdhch40R80jSX6sw/vX/i8VHzi6EfywRkX8htuly4tC1d3P3322+
TBTax8mcI488g3Q+nnpfR603DVnqGaeZL66s+94TJr+RlfsddcbqmFmGtVLj
boNR2WUwDesopsXobx/xd9eXYG0cltsYn7ERR9QXHN5BaDFkNMNDzCn61IN+
V19v0FBReTy4l+OcCVxh1xtE5DMi1ZPIi71Ylnelpv56Q9+Tphn6LN1ahOgs
G/BZllMZhVR2JmTHQ1YAoj8RTKsvNu/+Jnr77CjE2ZgWZC7H3cwo3c00A7cP
xOOgQUwLPK/cMSHAfSADER9252GrIxdXj3FbynABy+X/HEO638+j0fzwLHIc
GT1HDmHDgiF75AGwFTx6EDuqShkyZvebi7qgvBmqKqEmDyrjIN9Jv2z5E7G7
rvgQxDwQTNQQZMtpsuUUObm/N2Hfs+rVuxvao4rvRI5cuTVIVlacDLmeyMFy
2wwCDezvgZD18W/0HyuMO2KChpo3CO9XREzgmbT0i7lVPxR13yqbel6++uZk
hRuea47JMCckUIlhVCLylLA6v/z0qtD7heKdu6E0wtyRRk0UA7sehF2gGAHj
DH5YN4zAOcJGiVzExeMMwVIVgyFluMHNE3FSFJ5TFmJTpU8+pbHwJ6fp+39b
B1taWD5UYYl29G0i2+ZUuf/FxndXOkpu9LVgs6N5L2SogFXa9GH2mQs7oYw+
zGqoLoCqZGxFzWJcEty9pbSz0Qd6UclRUJwOzcUw1ACsbtgahf05ULHBaDEQ
FOFMiUMN2nVI2EZudxOBKnjMv7h5snMIxjU+dl38jBz+As9tvkeTxLVfUJlH
vZYWQ5e5CcuSzGVNwYK5Yo6qZ6J5e0c3dDVARz40RmosrdSxV5wWFHvU/hSN
qZg0pvoWcXNGLpKbkSxRypw2d8ZcNgG1g9DcDq2V0JRs5uJpNfpZFfQP+i+g
rI/W+SmD8L1PJL89VRj1eXXeT4gQP2zdteDSzfHvlkR2ahLbTra5dLeWBUUJ
yDHqi+0Ht+Qedob4AHNRIrTmwWgNLHUAfxhkM4D8CE9C9DDqF4N4C3anTOtN
lhfj9YlPZT7WBnRYltYX0bae+RU5fJ4cEOlzrw9h+VnubaLW/mxn8LeDadcn
yp/NdjjMj3svLYcv8xKXpVlL2kL6MGePD7OdPswm6CzBTv6LjG8PbtzXWjuA
TwDEJ2AiRhX04S5ndRoEy4gqqRUC9WGIiWya5NThpmyzbeAr2w9cDNKOsPEj
3sQTTrmEW/V5j44vPYeveM5e9WDfcOXcdxI+sTvACWG7NGJOFPDfC2QlAl0N
j2rZprrXYGABRpgw1g9jDTDw/h98hLU0rBQp+IOzP7us3njLu2+7izlMbCtS
WshDWZUt69CziNyOkTqtApoCKIvfi0Zjkq78aYfwbz9aY/wkPMPfxdTHRIXH
+baEH/pL7o222zAn3KdXQ2aFcTOK9Clj/oSp9ITN0lQLzYXIIuarnbv31Y5O
VGQY5KZBQykMNiOR1RYTREtwtAVm4QkBAfUACCKDeOGD+6WfJSPujG39Wbue
z1GixPxPJHK/vIEoYZybyBYE97PIJ/jOqd63X06E/cbKeMyuerPV5c2djNhh
vxMIsgXy0h1DLY9q3YK/n+cgjLXAcAnKM/hOYvXI9NiZcg2FyBS0pqysR6/V
2DgKTNpeR7aGCtEfN5V6+Ub/d8FT14IsbzKN+l4QLm6EdwQRmH4urPRiVPM3
MQO/xE3fjGU/iuW+jNq3C5M7BRy5IeBHH67MkeSXKuX1Cn27nOoXYzIZF1ir
sDAD830wXXnsUoy960wGs/Zoj8aQq49jd8hIydtglZv3MYCsUxg75dSQCCZ3
YG4d//ZOGE49/o36P+8T/kmV/zPeA1Y+Od/te3ki5Targlzpcl+fCt3aSNre
/8BtaVlCoRd0IzfYh8o5UMr4UnDjocHGDYKiIT0bKquhqxM5nLPnQbABsp2T
qEdsgoCmJGqx5fvnhJ00XWIJr9zTfrWfB/Z8Gzzxa/DS7aCtx367L70kr13k
9vaKN6TM1jK0rmAQPQ8+m3L8cSX83nbWa2GVp6g7TMZ8h3zWhGWKwwaFsUNG
DYjRWpQ+TUTNm4OFYZhrhvEc+m1mPDbecgW7CAhMRwyNomZoHEBOHtPLaCDI
2wORDBlKanXYycNoVmsOucKZidsZFncNGvrdIvxeE+F+p+Ljz6bkfpFR8112
17Xc8fv5Cy/ytuzz9lyzD30yNUEpxvA4UySy2TCG2x96k7JOk37QSE3qgKWC
FSmmPK7BBhNWWnlSEGH7O5WR/rth5H7RwqtirmOR2CvvKCjLFJlijo2iYr0M
Ea8No2ZqVg/LSqCx/PYGbE3AbKEMC4J2Dvc/XuU/vuH/zTG2zr5OdD3/fNqf
gQI5qlx3e0JEM0mSzRyZqFyqRmLck8XXFBtRt+aGYaYV+0qaHnqAeyzE5UFB
HTT1wiAT5pbRhnJ3H+Ry0FiMExBcNluM5a8TrvZEYDARlX4msfyrlPaf0kZv
ZSw8ydi2SdtzTD70SND4RukCg0zBHoagN3iF00y3Qg++Yjta8cNfijNdlFXB
2u4EAzPbtFpmFjSaD7tMJwm0+CzXhJikNwfrA7BQxbhI/5C66y7wNALcMiGy
HLLawCJZdsLAwJkguYewp0FUNilaXZo48t2BB5WWn5ZBuN0gQh8SiY5EZsjp
/JQvSou/r2y6Xtv/qH7apmHVqWEHjbNr1dFVhgTMxMnIQIebEUAlv5EOgW4K
KMSBNANHBztyEArRLcHpz8ZQJIVApOd50S7Ttn3VvV0Y2KaIbsZayUoqNx/x
qnICZOEk2tdxTSBUIxbu7qJhvriOIJcVuo/2wR+vcBpahJ2epOGy/4PdNAdZ
VcBRT4JuJtuwWWEUNRvUPXrzqAamlbAggRUhrG3C+jxyzFpqRK6UrmATixzN
UhugvB/J9Ufp94gPmyIQKECM9VR0BynTGxmE3XXC9xER606kxZzPzbtUXH+1
vP9+1Yx19ZpjtdCrUh5Upo0sMsXnmt+lQWoclRqEPzC9VmcX73zPd3ggC7XX
ZPiaKmOozkyUs7FSDztdIBsG/TRQix8O8hCEe0gBz2fCWnM8XairIoYD3Dwh
mVufzLJT8JCnFAPlaoLcwmhv6fCo/XHXmG0PrrA7g4i6RaQ/RwEOlZFfNGT+
0FZ+o6vtSe+Ibf+828Cm/wAaaif0YilFGxQ2QGklOtzyZCgJ1qeR6kXsQIjm
kWZkIiORImQiGG3Ge/3Bc8gcv89+YtZrcjOUKUqYVGeOmQqG8PyqBRrKoT4d
yryAd5I1RmMt6Xr/OSRlZF0iZ776s4vOP6nyf6LfFatzS09/2/V9qUzxNFRE
Ud2Z1HQZbDTBfi8cjeF2csUMm3rgKhABTbCFOLnbfbBYxnhNfZguhuFpZw4e
G5diTLWpgU8+pY8ed2kMIuAWkWx9qsDvXOW7bxpKrrW1Puoafd2z6NbLCegV
R/WokzoNGa1UbgMUVkBJAZSmQXEE2gB8vnHnqtjuuTbI1ZgaSpUlQ3sBjGGc
xx0CyRRolk78HOnTFOmRF7tkBw4WKU5XKebe4Fvi7B0cNeSLG933uEmiQXQX
Nl4cO48yk+gTrHo83m03Nek5g439ohhE1i2ijCQavS52xnw3kH1jtPrpZKf9
9LjH7FIQixMzJ06ZO8qeMRUxzRWjUDsATZic01oMzSlQ6a1cB6OFvoEsDE2I
tqfYMe2O0bh8BitQP/l0/Vfyk/+eeYnkvNuQ5KzrylbNdUvQNgvdYyivs78K
Ot+h3LLjwAeNWb4x+7Pz2k0H/gMbGqLtPPzT1vCfVPoqskX+YuvBrUPPN4ak
IKr0HXQUwmQdrHaDcAwUc2BEc2TKEuQGkiOQ7iPPVeG4BS7bnLje5eEXo+00
2quM0Kf3GfL1byPIEamFwZFymyi1P9UU8nV3+m9DlY/Gu/CRskNmBXGz8vQZ
fR7TVDqGJqH1lkloOTRnIYHK5/zrN1TWNkZfH0iMQSC/uRyGLEhvEtn+KTd+
f55mUGlBKQLpqp7b03bOUuX/9s7J/D0WS37pxq31LDnwBTn5DbmAFXeffLrx
G/nJpeWfyF7P9enQTewOlYWo+qdabS72+14ej7eazX28WGvH7vZYnwzeXInd
5qdtS/O2NGUbVO0qBi6zNHBBp0sDl/4S6IiT8kCzDybLchfZINI3sXD4ivfc
b15rt934j5z2X9hLXpGil+TKTVJWKTI07VPdAhjahgmcVTXTA+PFKBkO4y1K
r2PeTFh9Gi98HSVzClF7eGm93sid/7RF/Hit8bv/P9OHeee+2smFio6A/Exo
roCRNpS9xZsBKRu0XEwvOB4rG1F6iYL/e7v4fxDeXSLn8Z76081r5Cf/79qv
5PQ3FqlW2e3T7Y5fDIf/MpX1YKHGlt3ruTEdurWeuL2XtaUs2jRVr1FNy1hA
zET+sGgqWo38BL8UXL+NEuLcA5H3c04+jjnpRBkP7DnYWYPj45Sd2D9rTchC
Vr6xs9aMq3z1Jp5quBH2kYRTBuFWdsaz5XOvgcte0794Ld9w377vInjicPDC
VoyPnPfIArveMYhyK6L9LjFs+/W039XlhAcb+a+5de6C3qA9ZtwBO120UyCi
i6Nr3Kc6hFQ/D0Y2YWIZc3YGYaoJRnL2dpG2DVGodBZjJ8ORgjt1O2n1aSLf
Jk7sGKlyD9Z6e+p8HNSepKxFZ+jTUONKmJXAkgBNPleZsNiEkJoBbRQPVNIF
sozrUir1K9KE55hiU6jESEhw+VfU+T8wzm9ff6An3SE4FjJzocaSFzMB64vI
puZQiKzFzR98/3RafH4Xnh9L8twKCK+GCz59l/2mfvVdueXNeegufOYktraX
2ZASktxDZIBcBtF27/SY03fzkXfWs0lenftuX+jBbKJ4M1uyXypR1Ymo9n2q
TwAjHMwLZ8HsGKLpM6sYn3MZd/R331JvQiAkFdKKoawR2vpQ4zS/BJvbsLsL
ciloVMcW0iYDpdceyiRsC67/P+mq3UUR0p4BREDS6bCCi1H1l2J7f4qfvBG/
9DBu+2UMymxyCjly99N6uWq97LH8zAWHm7UwTg0/+GLO9oc1/zu8hFd7+S7S
+kBFb4xqKl3NLtDsVGpkTRpd1xE1pIBJGczuI1XXJ/8XsGeQIH2ukiNCqlSL
RceREeRazeiDkgXrEo5jyYFXoSooVx+RYYpNpBLCIN5NF0bqJy2YTQ/blgHo
Cmz1FWIHso0j47hdN9uzBw/GsFV9XjUUF0JJImQ7/rHW/+ajtcZPgD3jrv6+
O7LzjS9AHN+WfuQ4Ns8+TgNEjmMaNGc2otBfGlbZ3ELCPf9wIjzrXGzNV0nd
P7+bvJW8/OQd1yZR5BincIvQeAfp/Tz1/m91vjbIHeLU8MMvF52vbUc+38tx
ltUFqfoTNLPvdZtl+v0GnOU3qKYmFDAngUUhsLdhbRFW0XgUpgsYNzVWb6nn
oeCZhkJZclvQWKh7BiZWYYmHFH67hyDFLtT0cSoNZpFK2mFVYrGwu054PiFC
3Yi4iLPJmRfQMLz9av7I3QLWi4JN+wKha57cJ/soKN0YkWSKjjLHBECMM2bO
ViIq0ZnZe5fWbRkCv6eSBAdlvq+uLsrUm0ox84FdCTvNIOsB3YjlMD/5L7Ah
ge0ddK7biLibiOdlOzpkdrejoyb4bBpUs93aBQHt8sgWXWKjKb0askvQXq4g
DrI9tAtYtcy3JFzQMJYLOyPd2LgZeUR6z22guRgLzcXKJ6BuEFraoK0cGuM/
XuWPTseuML7dtXIC61gILIC0RrCYEY+twcIOihwWnAyaZYgjYHuT8HlGRPuc
Sk28kF18uaD1WunIg7J5snzbqezAu0QZXKiNyDbFpSH6SlIIJHngHdHcvW85
TvfEEXaqbF9DbQzVl0HNlMBGPex1gmr4g8SeBr4KzBbnIE+C7SFYqmZc5jNe
m28Gg10aWHRw9hhSRWBckIKZnTyE+gR6+OT/4KgNE3xLJtIb7HsXSxLpvkR+
/MXSvG+r6hh1PQ+R3+iKUxPPu1EcXH8UXatPrKC/E1RmNnIqyo6ATHdkekGM
W11g3/xBYHNX5mOjifcw5oaaa5Oo7hxEb0CK2k/+vZkG+usUcFC4AuxKYQ8T
8ra7LezrT9tOkZ/8p/onI/3247OeExshk/txE6q0MWPuEJYBtkFdLbLRqE0w
5dmaLXKWQwoBDMWeUTA89S2KvdzEtl6s70lJId9Qw6FaN6B3CYaZiNY2XPKn
an68xpgd8pLx4Og6Biq+v0vtLsWrFxpAr2tgUwfryBDe/y7xzo7IDzlXkXGl
vsqqpftJB9O+c9WjSxDUKY9GehpjRh3kVEBBIRRlQFEsul4/Y9/+5eDNM3Wo
izEz1FydTHUXwFQtrHWAcAgUU7/LSz42QD9ARMrdafNGM43aGYxdCxJ4dRKT
aZmBV2PA3H4KEUJqCXJWQbVuc5uej+K7lW7J3j0g8uzPVARdbEj+tq3Yqrvp
Ud/g68FZ16F1/6HdiKHDxAF9eq8ptxOKWhB7t7IEqrKgIgaB0lNzSIh4VfLq
icbrrTHG35wde/zGnl7sBM4wiKbgaAlMG79jLMo0IBMh4gC/v/s0OYx3/nOX
kIKUhvKssNXtxDVR1qqmaMVcvUg1zULHOPT0QV8T9BZCU6hODGa8dwWdGY4O
mFcD2Xf9+M+8RKSL3M5Obkeu3CGNXTgCfEqAqOhL07DQ9hdrjN/j5xaNnzNm
glhoF/TxdZ9DDvg0Yh79DPUbaFODjChTHhClTmeaor7pzrEarH86NuAwOec9
tRU2dZDIPMqYMOWPmssGoLoL6ptR1DCSu3TSN/9Nq0Mb0hDoQ6XGQPl76KiA
8RZYHkAtrnQRtMeCOwt7nEYcSjgUgHhBt93eeJq0YHprjJUtHVHFKbTKQfmx
n5PTX6NWcu4bcvIiWfJsvvXtMh6dJTOIokdEndO5jtDL/WlIqzDVZjs74s6a
D5rfjlk4SJlXZc8h64PKCagfhuZelBzQUQntObjMi4xLQqubquevDJbq/sfy
PGitQnZcrAHYnITdBWT7rj/+oU8MpVVyONyi//Xxy/asn16vMdDI9pNP+XfI
T/6Xld9Ibva+pHRPWyek2vlU3zaMsGFiFqaGgNkIg+nHEbl4+CmXcxafZnDt
0sSuyUe+sbqgEHOomz7QxjAG1JwB2CrYEiEB3dbIX6wzvpWf0gd5H2/YonDH
YbGyQyZD35F0k7H+G/Kb3riGPiAYMyPZn/tXw3HXpguezDc7rIz4ri1EbnCT
Uf+nLV011yxTzSzoYELvMGoBB+qhr5DxGff6zaNn9uAVCAlJUFgATXUw1AWs
Mdhiwf46KD+o94/zUnQoRUa6IlxrssSJPsfvcjSqs23FWfu2828Gv7af/s52
+VekyeXeRhG3vDvkuhXZ7iOwGKNYEY2Pz/W6fj0ecXU28+FS5esT4UIsl5vG
Fedz1OVbWK3Dhu4FNP8cGkbxAyPV0E+3U0uWCl946wPB0ZBMf5pKUMJLfzdM
jSGUz18FCfc45IX6nS+18XBr9Kcg+reuP/AXPPcR2bjJ7d8qHVAk5/YTUtqg
1nWqqKFDmBTDHDZ/WGGhJ362bO8ImWfLjfT1qJ16VbvmVLvnW6MMrzDEF5tT
3kNGIqT762Nt0CXBN8O+BsU+7M39xUrjf3qBPso7yAn4TTjhkkl4Vp3z6fra
d/xH38XrPpv3PQRPXUSvHKQ2NrLXpJiki513nWh/fG7c66dFutMosue1egvH
IveXUg74eSJZxYG+cY/qtHiSrMHkAkxPwkwfTDWgGJSb2gcOlGMIRKRCVglU
N0F3P0xOwcoK8Dgg3sPschWYtBbzSbNBI5WLlyyo+T8/IuwcCadQwiPtlE/p
2YDmr4IGvw+evhbEvhvAfeK798pTaut8+MZe6UDSZypACP89fcfeJPqfXJhy
+3Ep8u5GFlYydAYeTMRKltOlvAKppFKisQx0BwSYpLMGMywcufnJF8hA5b7x
jgNlEwA+CRCXAzmVUN0KnYMwNoWMCDa3YFeIOGlq5fEmwoiAvlIiXp65n7b6
IpX+z6CkO69orX+IMcjbEPRW60dKuhFuM0+bYFELawrY3gfuJnCmgd1YgKdL
62oYsBlguQ1uBw1KYgd0afTl0gElDVBRClXpUOJ3vMVUmJBfonjhr1UaI+8H
GLM4PCe8fImQ5NMxpZ8ntH3/bvR6ysLD5G3rpD2HeLlrlMY7VOfnYwxwwfb1
NYzTo0//tux1k5tovV/sIWsLV40lq5fzNPxKrbxZo+85okYUMCUF1h4scYHN
Rss/dj/M1zKuKa3eUC9DwTcdksqhqA2ahmFgDmbWYJUPfBGIFGjze2TAwa4G
k0QlOhkzu7wi/HyIsHgiNu+zxLpvUnp+TZ28k7b8NBVbcyQdesRqfSN0AQGm
YHdD0BuNH84uIXqun5169g3b7YO0wV/ZGa2eSNMuF+h4VTpps06LbRgp5iF+
h7+GtQVYHYWlZmo8HRms3NfTUP9JELgkQVg+pNVCSSc0jUD/HEytwjJG+3vy
v6N9FUL7krHH5YuvK7adyw+8S5GHTmSuOT6depdAJdO41EUbQWos+YXIM9QI
eypkXrG3DFsdnRZL3PMoR3AxdImfuCR/v2gsZlE1U9A8DB2d0FUN7WkGCVAW
VrRW9fEN85+0xfjfOssgHO8QoW+Rk15WzlcF9b+U9N8tm31ZvuFQvutZehhY
pInINcdmmhOTqHeRVLIfg2hnnJl/8iPP87EkwfGoKMjYmkiN5sBSBfDodqMX
9BbP82U9rKtQSjdvB33tuEzY6DTP5TOsTbeCwSEdQsuR+7A1np0GYA0ofYdw
lCDQ0vh5z0DjZ55aPy3cwPNx73tEpAORFHI2M+3zvLIrRW1WZcMPy1lkxaZj
+Z5X2SHiqeebYrOQ6UlyNJUcQCU5IrEqQs4rT3/iuz4QR9qpsrx0lRFmJHnI
g6VK4DaDpAdnlH/yDaxpYOsQhRbxt4DPortX+mctQESSI4YD3AoCm3fgUwix
9ZDdDZXj0DYPQxvIjXFZjNqEHQ0ydKZ/avpn7nvWPkVjVHeUFi2LREbIhnT6
t1VijJoORVGQ46JaAdNxlDCFrdXkINvUb7UiM8jvEVlh/SoSnAhyhIryHXMj
j+rahMFl9EGZ6IOxSnWNC6IXGkGtkf21WuN/ehu/NdFPifdeZ0oTL9WWXG1u
e9g+9rpz2a2LF9AljezQJrVir95qZJRRnA0lSUgYemH9PkPsZq2N9TIVRFNN
mdRwKSw0AqcHJGOgmbO4nli4OFq0/RPtwP4S8Id0i8glw3JtWKaS0SdougJT
Dmox6l9WA0sJPXwh3kL73SQS6J/Q7XRx9OdV2d83VF+nUX/7pG3nilsnz79T
EtGuTmjRpzagRJ+8EijMgeJ3UBiGHsvTc9cvcR5aSZxfqMNcjOnB5vIEqj2b
Gi0/RtPfHs2A6QP4F2LnLZR+tAY7o5r5whaC7D1HMkgTwx8eJoFDAQTWQWIP
5I1D9QK0bQL98afvXZYCOVmvaGBeCc3PRwcdJua8JumWai9uUpE6bswZQade
2YUyxxsqoDEbaqP0OaTuQ+CimgL1ESg4kz+jYR3ngcvuszfiV6TEmuQ+IpUt
KnPfITUmhhkBLG6goLOlLmogVmIAkd78x+3VP6n1dQZBn0k+SdQFfNGR9utA
5cOxbrvJKc+p9dDp3fgpZfqkKX/cXDoE1b0nXINiBFIvcu/cVr21N0YEQnYS
1OVDfy0i+m2OwP4sZuRwThKwZSaUgK2QgGzLvDcpXiw/wQdk4AmrpBrT5/vO
I7g/iZ0ghs6TMb8y8x6xGIQXg0i6SRRYEzU+n7UkXOkuuDHY8HSk/834jOfk
evDkbuzkYcq4IXvUVDSIVj81rVBfi5y3GtIR+j+zwriyd//ukYOtIdibstzF
37E6kdfq3jQolsCweQL/JWbE16RfMTkX9qfaz5PDFqPlH0mGk8kqGh5mg2M1
BHVC4ijksKB8DRp50LkPfRIYkEHHvrns+Xyrw9KI98o83VclrIoyV48KVswV
i1T9HDr1riE0ve2rge5saPBXiUGvBLNFnqLTqKSrCw8St1/F7ztEK1xD1d6+
Bj9nnQ+p7AeUd7OghzUlujFQVtpYGd66fVTN9vEqX6PRCw1UbS/2h/7IzLo/
X2u70u+1Phe2sZW0KcreVJesm2vYVPMidM4gH40BzDUYLGd8zrtxT0s6IQ/D
tHSEGDqbYXIAVqaAvwzSbdAIwSw5sTHUmCmNCpQ7uv1pS4ltT9JbkJ8T3dRd
IMe+Rnh/5Wdk6LdlhUYFK7+S3Z9ZIH/h9VONr893+18eeWc1VfyE1Wy/NOS1
wgpd3YpfPchYVaGzXKLqWNAyBZ2j0NMLfc3QV47tPtcYP0rwu/tLYgIyAm2o
RB6E0/2wOolYa9IN0PwuEg/UZvRuKQWG/amhK16zV73Yt9y5D+k3zEH8yoYR
B7cLwLYRvPsgchKSF+D9GuRvQc4GhFstZTxdr3jDaffij4UJFhN3uVm74mKh
pkZAtfCo7i0YZKOjn5wAZjdMVENfovgQJYlqkA0RpdAop5+VrtmXCN2LDwPy
teHv8TA7mkryMca8NlpCcyy2oUihzurFC7epz8nhC39yLPwn1f6Vxlm3iUH7
b+bCb63lkNx6D+Fg2AHrnYiTK5aUi7UNB1THLhLdjW4CcxnFic4Ow0wb48wq
467+iQvlEQnx76GgEho7YHAU5liwsY5UMHIRaBV/dzukwakW+WShxukV8dqb
eBtHuOYRHrWfeXV/jfKyF6y8Nu667zx23n/5RkLayGxIsTXJf2IZljfeIfrt
vmQGXl1IebRWarfd6skfCRUsJOxysnZFRbvqagHVzKe6tmFgDUYXYWIKmIPA
bLN8oa9df0Y9dwWPMIhOgexCxBjv7ELpHItzsL0K+1xQ7IPu9wIwnc6gEnK3
eqZuJbAfx/OsY0QOkQrXYLWnj8HHRedjq3Q/7jvpj8atc2NPv1pw/XU94iEv
03avwkPcESofS1QsvVdyS1SSOiUys+6ToaiwKQGwttHxL0/CYgcwc3nKY2XX
rs489LJ93rFj26dDFNamjm82pNVBdgUU5EPRO8j3123C7zxGkSJj+rvXq78h
n5Sdu8gX66PbyY9X/CcG0XX7wtybX7cinu7luMgaglWDiZr5HB2nQidpooGq
hhpRIQ0uorPvwOoG5iCMwHILw0p13QlsoyA4G9JroLwbOiZgbBEFmG7twq4M
pEfIERGR7ejnF2XMIm+c+4SLE+EbToRknIuq+CKu/buEUUbi/P2EzRfx2AQq
QuUepPX2Rp8wXzsco1jFIPruX5y2/54dfJeTSu6WuYnbQuSjCYrFLHSo4lqV
Bh2qnBoRA3MX5ri4zjdgoRmxuX+UWj033XMHh0gIzoCUUihugqY+GJiE6UXk
wsITggjH9Gm1KBpIbwStXieWc0bvFy68RE7n++55Cv9sbWi6KSrRHBdJxfuY
Yx2wCV8T49Qo4+zis++2XG/vRlhLM1xVFUHajnjjWJZpqdjMraMk7WbNgAl5
qM1pYPkQ1g/wzHQJXXYL5UV4ZpVH32DWY2POk8v+TH4UU5Y8oc8ZMxUPQlUX
1NM/axk0pkKpC8rzsTySGqV6f5p9P2TnZYDEzlPp+FblTO5Y/2l3aan5H330
8LfgewYxcv2rDfvbojBbNKGui6UGsihWGWw3gbgXNMfw2gQbWuAcAn8PCfV2
5oEzAMvVDBvz3TBwfo/m5haOtideW3vQDaMcuEcgxBaKApThhHq8m4TvSyLS
5/S7hPMZBV/nNP5c0H+rcOZZ0ZptkcClQOqTexScZYxINcfEU/HhVIKPOc4B
oYTTk3e/XLVn7AQ9E6c4KUsDtG1xxtFM02IxxamlxO2Uut9sHj+ect2GTQEi
AG7PwkYffbCMr7mMJ4Yb7vAyCjyzIKYC3rdC5SC0T8Mwm35AEBWeJ0ffSgnO
F5IZKOGRsvdR09Tr5lWX5h2/ZllYgzau1phcAZlFVM57yEuE3GC89+phEHPX
v9589Nu+8xNFmIMu3c9UHk21pVOjhbBQA5x2EA+AevL3iv4j2MVZ0YIZarWu
4ww5cJocOUcOnyInA9fYsRvCtHVFwZqpcoVqXICOaTSWGuiAgQroiEXZr9i8
VKs5XHiWw32TLfHIUAe8M4ZHmaN8jRF2f9pj/df/ctUvM4jp698KyEeqIGdj
Rpi5OvXYoWOjG/ZH4WgOTGzAKNvCP1eCZB9E9OebadxoXuoMvY61i26Yh5KM
F28WCk8NfowX1DB/BBNSI/a/Cr5PJNkT2SFnS9IuVZX/Wtd+r2nsVfOiYwvH
q0UU3KSKbtAl1aDEhPcFkJsJ+QmQF4x0xmeXbn7Hf31XGmCrSfY2lUSaW1Kp
4QKYrwEL/vof/h5OJ5TBnhD2VmFnglprQHPem3KGM9yOALtMCKiAxDbIH4aa
WehchREezBzAshw2jgDzZS6vqoxNTwaG7Ibn3Ec2A0f2o4eVyYOG933mgi4o
a4GqGqgtgpo0fN8MMc6xr38rfHhb8ZbUh7ibUsMQs6MlD4aqgNUKW/0o81Q1
D0gB+SFKUaoC2S79IysWy5DfxLdI7kR3XYgojh3PVTX7VOsu1cuDkQ2YXISZ
CeQvPpYr1mAXbIN50hrlxO36Nyoj6wxJFVRGIeSg6G1j8us/zVT+SdX/IzIh
/EH07AXK6U6OhfJs6LQ4dwzTDyQcskH/AW/LKZRopFSAYocSz1umXf/3hwF2
9u+yVIfPk+PYfmz4HBq6R/02iyMg0x4TxS7n6qK+asv+tbvm/kAPOcx0GVn1
HxVEjMgSh3UZA6a8HijpgMpGZGtdVwC1KVjQuHHnF5H1U42vkzExiCpMPO6m
HtNv894EKFhgWP1d5J1UBzIZojDsz+k3m2m0PfQ5yXgsZwRS91LBoRSCWiBp
EPJmoJoNbVzo34MxKTAVMKWEESlV9mSmzZ416rmwELLIiVsSpy+q8+bNZbNU
LROaR6C9B7qaobsMOtIQY+bsFuMnyb2HGjsHc4AfJMVCYRY0lkJ/I2KUrI2h
bCUUdc49iTpXUKDC1ldShOYWrrls3nHceYSI48i5/zm5V6tVtWvMg0fU5CGw
DtAwZ3UFGU4v1NBt66YOem1GZtzHtoJRIp82Y8hU0AsVbVBbDfU5UBXyFyuP
u7gvGN9L7lhTLn6IApJfCE0NMNyLkpq2F+FgC1RCMJ4w1HHomRbUB5a9lEWL
GY/vplps6T/yJTlzBfUz61dRIhmNvtm/oo87g0ilgc/T0y0eX/bF/TyWf2+q
gZwbcF2YDVzaiFneS1lS5iyYSlhU9TQ0TkDbIHR2Qk8jdJcgbcFnXAZD8fyV
Adf6f6otht56mOoG9igKkJexQcuxBMp8kGaqkX+iZPGAXTf8rcfcrxYZqyMj
lLqVDXa14NcNseOQsQBF61DFg08+rRPCJ1cQ0/zRSoXdRofn9ngobzmBz8vk
S4v42iou1YQNX/sXYHgKxodgvA1GSxEh7gIXJTA/N1m7gHcIxL5DDJoauvvq
gIlh1DBzV0DMgaPdv8/WQUdRGrlGPM+6E41Eezbh0reBiP3t6aTxfC13IZUW
Z/VFE1o7cmSww4edBVhvayMQI7HrFNqocZPWZDmrhrJlqp4F7ZPQ048etJ73
/5qq/wfGlztWL81kAASlQHoJVLZA1yBMzsDKKvB4IMZ0dZ0aWxQZwWwwWWba
T9GX/U004ZxDuFef9+z6ymvsB695hsf6HVf+Y6f9F28k1qQUo3AGEcogSm4S
7S/Oj3h/P5Nwe6nQer3ZdXsokMeK5W+n74jysaFzA4dq38DOJCwYm4CJfpho
oY/X8ma/dPSFsDjIyIaKSpTOOjYIC1OwvQz7W6AUgt6yPMS6VAsRXSNZRCz9
W7Grj2P51lFY4hqg8fTUezveKgGbVnAbAP9xcOrTPro44/wTIp5n2ggq3fY7
gyUTCbKVLDm/+FBWK9e1SqleEYzsIp/i2TVYYMHiCLBaYCLbor21emV+4km5
REJ4Ojq+skZo7YXhCZhbgI1NEApAJsZjdq2F8E9p1dKpR3lsMo/vmEP/nx0F
pBnDE03REeZYH1O0vdiHNH4QdR3oQCwB0QbF6Zr4EinDV74nl78neXmiw8oD
Uwu+DEY3gDmPmqrp2r9YddzLn2E80N/zAedkiC6F3FaoH0FW2tMbwBYAVwL7
KsS0UWBCsMVy+ibKefYOJoLTzkaUfx7TdiVu9FoC61785vM4oW201DFM5R6o
9fYy+FpgeDKDaL55ZvTlpXlfq43EZ/wip72WAMlwjGwh/ZBTqBBXW8zHJNTQ
PkzswMw2vq1JNEO5ob5hR9GPo18SJOYj0/OGLugfRSwm9hrw+eiJVP7jE6lR
i9c4I+MPCpZe5XPf5h945Cj9M/WhKaaoOCoulIrzNMXY43arj3Fm5vE3a843
dsJfiDKdDysD1Z1xuolMw3KxkV9rlLUbdf16alwDs0pYksKqEJVwi4Uo6PNl
aCeO1bj3vME2BoUIJVRAfisilSBWDRsWubC1D0I5SNSgOCb+G1m8OZZd46Zb
w35APRqyx1dAajGV9R6yEyE7mEqz02196M2wUuaQO/mDyxLDcfuu/e4TFNe0
95Q8bNOZBrCHId1UsbmISrba+9eqjdkN/x/jLTyOAwuDwB1PtqPw5NOfxuAq
4GiBq4dtJJm3xcyfcM9TiXHn0vO/ym74KR+h76c0+i4UuORj9J1pjEgxx8RR
8WE0+saeIP1WZ+df/rjt82Av0V5W5HPUEqUbTjXMFxg51SZxq0ndazCP6vB7
bIftS9aQln69HxarGb9IGa/NjwLA+R1EFEFGA1T0QtskDC/C3BbSAPClyESP
fhiVmKAn1Rm2JLx+lBTctO6K0M5heJ02vtqcUkZl5kNOBuTFQU4AkpUS41YX
Vx/8LHB6KAuzV2f4GCuiqI40arwQlmqA1wbSAdDSsJtlsRfRAV9xQkefhNW6
llMk41vuB2WuSw6EVUFaB5SMQNMc9K0Bkw+LIthQ4NxjrMxliQ/GHQaXvIZ4
IWj9pUntQ2UoaoHyWqgqhuo0qAhWCcD4IWhVqzcquAv3YrZfRB7YhypckJmx
1svu0JU0TgOgzQv9U8lAyAH+xMer/ekf/il2efx/8JDk2KA9A9NGLc4azfjv
9C8nFNAvMjMI3ztEvA3xPvB0cerXlWW/0Ki7kUbdS44tXO9mUUjTUUy9Lqka
0suo7HzIy6BRN95MTtCt4DOrfa+XygQ3Q2GouekdNZQHrErYajnGYQ6wQsGm
EbhqEEhhVwC7NOqehI0WQX8046me4QsvksCrEGIbIacPqpnIyHKEA7N7yDd8
S4UOc0cPXB2NwBWtTwdG3gwteA5zgodFsUNHKQMoY7eoA8obkWN+LX3RJiN2
4WkW42vePSuZw0tdsKsxNcRc9o5qy4WRSlhoBU4/iCdAPQ9mBLkpEJ7Q0pGf
7Lx+rZ5GhNPfkoxrfIYLdTMKXr4HzyqI6oDMEShjQdM69O7AmAhmDlHTwjqC
mufT3W/nmD4o9k+QOC/PZBkKZ80VTFSKlj6UAd1VjlZg5Y4fvv1GvX76SeGa
bcGua57C770ujG5hkccxFfdWv4LR6p4Z9ZcyEezP/gvf8j/WG3/L/4uFOPL7
EShSm54mBy8gxD2NuSOTF8m+zyzUlnf3icK3Z2oivmx9/wsNuvtp0D3lMrLm
PyqMHJEnDeszB0z5PVDafgy66wugLoX++Fl9I3h8V+luZ4jxNefFUvVZlj2V
0x4mqhuOW0Es7ZRoQSpFgPtg3sTpop+5ngskw4G6FQ1kLvjWQXwP5E5C1RK0
bUP/LoxLYEaBTnVWBf376opnMx1vWBPeC8thi/yERVnmgq6AZa6YpuonoGUQ
Orqgm0aExWgYe3qJcXn/9l31azuTvw8kxSAn9aZSZFE61wOb47DHAuUaGP+O
tj9Q1FcGv/Wc/dVj9aYr96HT3nN7hp/ZKgVelYJHC0QOQtoMFLKhmgNNQmg7
gOY9yH3GrnPY6PXZno7grr/j7WZzlSUcU+0W1boG3TjacHQExjpgtIzqjERN
GbaM3VGIF962crxbxKFN2rh6U2oVZBdBfgYUREHWG7QKQAx1M6gP9XuTf+zN
/6uP1hyjtv/u95ksyfilbjpt03cRs+p/Ild/Q8S4T7m3yE/+R2x7H8sgih+c
anb9vDfm57E8hLpZA26Lc4FLm7HL+6lLqtwFcymLqpmGpnFoH0Q6v54G6MEq
yisH9x9pLd20S3ctMDtRJ7gzA7IV0H7QQh8LPdXIREbGVnG7ey75TPzkvXjd
c+u+GyMJXpaCZxtEDUP6HBStQjUXGoXQsg8NuxB+bT7rMbv6zWa3N4cZzltN
4gve8w9LeIZaDtWyAd1sGJhHAQrjAzDRDKN03ZfpRuXmI/0LR/AMgtgkyM1D
/U5vBzCHEV14hw1SDmj2wCT98KU1URqZTrLERHYdcTzraJFDuNI1UOPlpfd1
ZESq75SBXSt4D0HYFMSwwPoSy+faWtxjTp69sN77oC9cMvNOtpEj3yuz+E6I
qYE97IGxgcqyMIa6+tF0PxxEvqLUjzmNrfhN7ESNHyaPGrOHzMWYz1hfg53g
I3Vy7AOuB5P28I+T9o9XHP1bGHX/7y8IOy/COQEFt3g3XPTtRyxxv5VbPpxH
nrsvXCU2b+V2todvSJk9GnzfIFoenxnyvDITf3u54BUNuTnDQbz5uB1Oxo64
cEdTxaOaOFTnBvStIHPX8QmUdjXZYvmCu792g8BISMmA0lJoa4aRfmQoRzeC
+5ugFGC8bVEcI+GnkdJI9fK1pYXaUavEhQeJWy/jUXy0S7jaK8jqPbxoANc+
CByH8BmwIgYx3mZH3Oe8txXWeB70hEmmkuRr2YfCskNFvdzUIaH6D2BMANMc
lN28MAOLg8BqRFOJ7yVWT8wPXSmnMAhLg/RidAW09cLIBMwvwtYmGu/IJaBV
fiCvm7Ua6ci9gvnjuWyu0p/+7KaZohMwdvEyxdJINR8TcMduXVi0/mnL+54w
3kaS56GoD1X3JSJl3UaZYa/BoOzSm4a02IhCDiv7qDRbi7AxCHOFdZhFWEmQ
kwGrqzFru2mrqgK2uXKJapxD8+3ePhhohN4cuRrlQ6iN1J98b/7lmn/yv9GA
7Bbh5kgERhAR7y2U8Z/+Thk/cIw7dI9EWS8BPqYgF0MQjXKrrU4PPfly3uva
RgJC3fs06h6JlS9mKLhFCkmNQtsqp3ol1MgBMHdgdgvX2gsWWpCH/VPzY09w
j4HYbBRwWteOBotTs8DGfaDoAHF2EOrWHSuXNRrZrmip/3bRzLPiNbtioVuh
zC9PHfreFJ1mjo9HMSVJXhgddjPOTD/6G0Ldka/E710V1cGangT9VLZxrcwo
bDAqOo2mIT3K02IpYEWMRLRb6xgg9gKrmPGNkPHEcMsNyEjwzYSE8mPI3TsD
k2zE20HUFguR3XAMuTfF20ybZvaHuSy2R0Hy79wsyI+HPH8sOB5knFm48c32
y+sHXs8Vsc663EBzXRzVm0VNl8J6A+x2gWIYEA5DLioG4KpAgMitsDNlWCi2
ZAhMf0FOXiDXMw72i/aPavaoNgHVh/OsmNiJf7oOmboZaBAj/2s1x9///5VB
2N0g/J4TsT6n0pKOOeQlIw9KF6zLth1L972KlUEFmEOejtJgkiOoFD/0CJ+Z
ffrdlue9vXg7eaGPuiVaP5JuXCg0cWvMkjaTpt9oHtfjavvAJh+21/Dsux+W
a+hG8JY72MZCYA6k1EBJF7SMwSDdUm6inCqeBA6Uf4ffMr2Rf3jQdq959FXr
olMb16dVHNqsjm3UJ9dAVjnkFkBBBhTG4SiTEasL7Hs/Cx0fycMdtJl+pqoY
JGNkliDbD0EnHA6DwaIGXTcBR4NktbtCBBT546aVqha66byjYrjA/UhwzIKQ
Skhth5JhhL3719GzuySGzd9h72X54YDt8Kz7yAaazY4ok08MUypaoKYa6guh
Lhk7uUwyLq7f+nH/+X2Vh50h2tuUHUXVpEFPETDrYLUTBMMgnwa9JboSzbUt
qjs0mB39GpuD/opuVt4tcusGuV+nUXeoqSElMGUwT4PXbVj7/xt7z+i2zjRN
0N3T06enu6u7p3dnd3amt8+k3Z6zc2SXXeWyq1zlKleVq+yyL5VztERREpVF
SqICRYpJpJhzzjnnnHMGSIIBAEEABAMAEolEBu5zzuK9oGSVrdpZ/9AxSQgC
73fv973v8z6B7+rMijmawXdn5u415xo09zfdO8F/YPb5H90Xf/Xd7Oc/Kkn5
rKrco77jTNP41eZFH4pd1YY2WqLr7EnueV4eafCIAdPl8eHiyT9s+Jw3vLxr
y3HV4HFsXzb45W7uvf8rU0Ejh3oryIpYMQZxk2oonrmOY6G4lY7gCiS7rs8w
GmfRt4yJNQi2Id6BzAw5V3wv6E1lx3vbPQfG7gwtPh1WhA1pYwdtaX2O3C4U
t6KijvJLarNRE0t+zz+Vuopv728sgT72pCC2JB4tORiugKAF8j5sj8NMOfNu
TaiDFLbbbkR2ame+vPdnXhOfXWYuWTwCcToJd4sR0oSkfhROo25pr/Ke0JEu
fHoHHev6+iu8ft9ZfuDcykuBOmnOlO22TRlH4wDlbnTWobOAe8anmI/kzNe6
M+csd+6wIQFIiUFpJsHZw00Q9EI2jq05mF8bUZO7CmGx7BbVc0tHH6yevae6
dJPO1GueG56eu/2cFa3ADvEuZCoacslGOjgqydhHngMffl/l+/01517x75l9
N7kYmaLb79e9+LQty6On5uxA7/Vh3oOR5eejysiRnaQhe1Y/5y7tppiXc8Yb
XcxHKycO6m57WcMeOTMi3BV4kBv1NrgHCitvug5qoJFDNWOXdlR84N32kTfj
x55IwJ0ShLYgeRBFfNSJ0KHAoJomtq7ye8KA/i1nxrHJKk9+1725yWfzooiF
zcT5naw5Z/EMWzWFhlG09qGzDd016MqjWJufrx84YrzsqsAfI/YlCtLQUIL+
BvC7SdKjmsWuGI7V15aATuyaYNhwqPk9n/lPfPV04ehj2dmHSs97TDhO5eB2
LZ53I24c2fMolaBGsVclxp9YKPQSN/quDAbKZ6NWZSmK7fzVV2YqQvTOEhNt
tNdVwGAwh1b+5+seB01HL+P6AwSEIT4JBQVoqCVEmzeC5RlsiqiQ+dZzhcNj
t9dGFs7GEPv1dvju/WDz48euc9Xq77V5x5NmXSss1h1QGTm7yunxX3nOf+G5
zO0GQo/vzdD/xNr/O84MoeTkBy2+n/RHfT2ed4bXcH1u0G9hNmRRGru4nb5o
zncrJKY5SLefGNquEqKniPl49cBRk7s+CyvLRVsVRtteod+L31GQOugy7yhZ
zaJe1tXyaeDQF4EzhwLEp58eSIV3Ffw7ET2GDAGKllG5She4UgGfz6bDD81n
XRTX3JX2Pludfrm2nLyuyl0zlq+y9TK2bRk9ixjiY3QU490Yq6NJzKeb+09Y
z7oq8QCCvbNyUF1FYU8TQ+TDuyaEVg6z8g0dLhWLat3m1MjhBMHZBKlXnOp2
tOFBuOXJc3vgI8fzW2cqcasdjwfxfAInaIg//+yIJOHSWtFdZVPA9lCkbi5V
Ly/Qa6rcBitcWtekDHwh5qYh6AO/iiYFv1hnjloPXmMvPYFfJCIzkPWqoBnj
Chq5DFtK7HI+LA6O/WwybvEvFi7fJCbsTkC2NSzNEUnETcQ/ckResbmvLTF6
7NjROFTT80ceyc+SOEXnfVV/3VP+zffW/1+9ff3/kdmX4bGv5cyPhh/+bibm
pLDg2krTw9XhkHVB3MZq5oa2eMNao2CbZSDlxCJGZjA+hskebtUjzt2GXzBi
kpBfhIZ69PeAP45lATYl0K+TsNTx2rrQ6rrQGrNWOCeo69ufPH0qWeyZtH4z
QesbY3oSYQ0IOluDW53w6QPxEt4bPPvJrM/X4ohziuxbqtqnmr4IPS/ZIMl/
gy0xpMbEOvgrlEc6P4n5HrrWn6wyJ+1Hb7PXg/E8CUmFKKlHcw8GxzEjgGQF
GxvQaUiea7O47UMchl1l7/Hi6UscT/ZhkSEg3xKW5YxKYeNj2MQQJN7nou3a
mfcmjv5saW+ef1Nf+NTUFGEbSiGehKzKqWlx7hmv8HexoIF4HRIxVlwlTVul
q3L4SMQcNTPX2dPPCFcMzoHr+CxqR+Mw+mcIVxSuYXUbas6fxV3VjHhRzLn8
SbMmtNF1pe3JlRTznJeFgljkPSVRxGvbS7Nu5jQlLarvxOz6hZNmJcjHFuj1
vcn6n1j/vyOCyntD534h8DsojfXcKPTdbg7Sj8TtzGfurpYYdXW7tnYD26/F
qJo7y6MpMmGugTlkPnSbvRmKkFSklVKCcfsA5aYKliCVQ6mC/pXY1GGHzebc
MWmkm3PtR76NYdz2LzaFFtijsp3xqUiOZVNCkfyQZug/5J/5jcTnuDLiqi7b
z1QbZu9NdPLyWEklVM2sscfpHLGDZ3Y1tm6tJgX8SicgbrNNZjBHTB63cSEE
D1LwsgRZTajqR8c0qY4FripThXU9gUFuLERltracahn2ahPcaydub1iLOabJ
nlzLiW8LUJiGopecpeIg8yPSFl45pnk91m9MZAdyMVsJaQu2+mAed1eOTgKu
1/RkYbfhalP6On/kOfxTT+ZrNXMN+wNwKR5++XjJoYwV42idp+Dl6U0s6iAx
Utno6tc7rwyP+4wsPRtdjxjRJwzZMzmybHkrampQX4i6BLbojnGXLqzridIY
1hdvlK8/LNU/L7JG5DrjUknGkvLUFn35e4jdn1j/v+GccPhnP5c9PL0Vc3O3
4Jm1OZodzsB8CVbroO3Yw1DjiYW5vAWpAnIh5NOQ9GC+gvFmz4bgYRqiypDj
+oxD6HJtEGJye1nZwrqBfFzcUlSlxS7SbNYca+19w8x4J5pSG52ZdcgrR1EB
StNQEsXsG/L4SHT8a+WdC7sv7pKSszqW7c7GVLmrYoSyB7tjcM6AIgBJzGnG
hobSgTfnXZXdDi+n9UNP5ioF7VxNhn8JYpuRN4haHrpEGFWQEw2xSc10qUUm
lJ8e6rg6Ou47vhQ4sf5yXJ84as/iOL8VnRQc1VCBxmzaAFwF5U9WDn+1femc
+dFtR3QAmxuDukyOQNGE5R6oxmCcg3MvHczJCY200EjZ9aGR31BEyPIRb+bU
NvOIPRKDq3l4WovobmSNo2IeLVL0bpLG3FXsjOlRfWWu23dhKnBRHLmkTF7c
zZ13ls25Tl9atM5e8v7tKULLC5WFfIXWzdap293LT7rVYV3muHZHOmeQTvqW
ZBQ9/ZP3wHf6+r+iaRRHYff1NEc+cOS9YBtS2MFCdz2XZJ4CuTPuOeObodRC
tQblEtZGHeIGcW8k8wSXkvCkFLEtyBtC7Qw6xRhZA38LiwaITTQ4WDJhcns3
/9hwo+fY4L3JuW+9uMedBcNseT9qO9DYiJYKV6XOvDvG/Ex+7JDhxhVb8CNn
agTK09BRjPF6LHVjfRT6mTfSKbYc0JrJdkErcW6Mtn7sO/hrH/5X9xhf9lAs
vAvxrBFx/cidRtUSWuXoVWHYtZ3pMaBhM07yq67Od91fmnwuFEeLNlNFu3lL
XNjGDBGCu4bQ14n+WvTm7AUmHtw9f9nh+xDhL5CZjKpC0otOdEI4QtJEvQi2
PWkwF5hodFWWCq20a+ZI6PI5LjPr5iPjvXtMoPNgGq5UcAP/EaTOIl+Ecjkq
1xB1XJjjtVLrs9obuMaL2pCkbqryN0yVa2zTKvXyA4u0cpODmGzEUPrLfZQW
2HeX3NSlL/maZJ4td9JZNoraPjRzopfWpP/5HcB1fX/B/HjlyOGdW972MH/3
qqfyWsk8XzmJXbcSQ+FO+OTCcfQa6ORQ800rrTUfPuz+1M8jBBdz8KgOUb3I
mkL5Eprk6FKifxuDOvRpUCs3xh/hF11aaLkrHAlYXoiUKF47dtcuoGWGSw4b
xGAHhmqYfT2ukunAcbPXTfgHICEOxblorsJwGwRDkPGwtfRGhMUOR2rm+NfG
jdH+P7ycPhIhOhe+5kXWD0wCLpXjYTtejCBpBrkiFEtRIofP57MUvXdZWuO7
1vN8YzpauZymUhWqjFWbbDNn7eFmCE9NkPJ0qsYdj8wcs57wZm/5I9i1y2ah
tAKtLRgeoFrPdQqp5TCqYNOBdZ/MVpvFsDpxihIB1m6laR8mm5/FOUIi2PAA
9uU9e5gX58hcz7zbd/TDac9fLz06TD4UuXe36p7peyN3eKm7kgKjutpoatlh
e3UY3cI09f1YnMViP/hltVzKcdU+z7lI+WoqQdTO6hW2RYjuWQyOYbQTI2X/
P3YAbv1zmA9IQOv+LzkJZYVor8dYN/mRkM3+Mmez/0cpOkbsbtq2BTJhU/vv
oscOxsyfiZZdjjyQhev1COhH9BRSF5AjRq4ECQKH5895/vuXEi9IS26vtT1T
jkWql1K31vO3DJVqcvbuXCOOGwV4zoI/hpluglg/WWNOOs7cYe+H4GUycopQ
24CeHloS0TzWV6DbIKKzfeeVWaLFYt5RdOzPHj+du3A5Z/V2lsYvwxiQ7AiL
db4Md0b7I/rOXjH3w/Gzny76HJCFf7OZdVdTE2DoiTLy0kySIrOqxmxqNbJ9
OxjTcvwmOZaWIJzEUiem812bEnPcduAmezmQouBj8sllg9i4Y5iaI29zxQa2
tUT0cUfmGa3WgXPVM941K77V6meVphfl9pgiNjmbIlmyIpDxcI8G8O70gU9E
nsya39ntqBu7OU+stRHO3mSWlw9JNVStMLk6/XEnZjnB2ApHxnSdwIu1/R9y
ovZP6E9FkUFfq3e2a9gBFcmuZoTE9BG0/c/vAHoFV9tlu6q607fZ+2GISkNe
GeUx9A+Qt+HyEjbk0Klg1sH+KnPHabVbjGqVWtD4Vd7AnvdJPud9kmUNTXW8
jGdjX5J2L87X9Svu/4Dv+btl/1Mbidc1JY932iJMYymWpXzrepXV0GJx9JrI
/3va7aosg3gR4gkCXGdKXI/cwbvwDsPzNCSXoaQFLYMY4mFWSLXfxha0BsrE
MHMqA4PFsqwU9p2r419vkNyvVwXQzNgaW46UQjYzCzkJyA3jXEEGPT5cOP37
1XuntinK74mtOoLtSWGnC7BcA1UbjANwTLhDfkxY0WJ1DYolyEbYhYrW90jx
5nETJ4NwOwkhRUhpQIlrw52k9ognh1BNo3ulmRJClTbMb2+O3uhd8OtTBPdq
o3psyZ3O7BYU1qGsjLRDldEcDDjMfLh08Dfr3xzTPbhiffnAkRXqrE5gu3Mx
VQlxC5T92J2AU/BaJWGEmqjYNmEt/3NP4ddkU6o45ik57KnvZB3DDvAsdPK6
RTMrQ9/rBf78e/cAfYe+5FCCHzCfrnncYL1CEZiO5AqUtqN1GMOzmF2GZI0S
9zRcQs87f260450YvdW2rleWMXUdpxvHrzYv+TSvP2vShTVYYmodrr/talxy
s8m8uCDc9YtSeO5+5ZNL5CRXHOJsTWRH87BYibUW6PtgdxfSS3ZIdqknWlNg
jRiyENWXuBqpmzgVSsky4eXIbEPlMNpnMbJMeaRiDVa5ZBnXJV+zYkG73Xyh
b/jmwPyjwdWQQQ2NkXuJi1jcjIoaVBejNoPzs5liPpEdP6C5fckS6svF/iWw
XbmYrIKoFZsD2JmEY/61qbUVai05x23yLEtVQ7+8xv/9FcbL6SrsLyTiQTEi
mpDRj/JpuPbggVVMqslE01X3LJpQ8c1k5y3exOMZYdjsRtzMTgbfWTjFVo5y
+tR2ohR25NGN4Po8P5F5fKU9d87ic9vxIoBoOZWZ6CzDRBOWeimFVi/gsmzc
wkhXG2PQQ0t7t+i439oF3+0rt/XXr1JSmZennc9FP8pfqWo2p/+/7wPaAsjl
iDsRspjjxkMBuJ2KsHJSdFaMoH0OwxICloUa4skrLFgnVxwIDebmpRlCDL2H
eQ9HJEEj6qgRY/KgPbuPLeqi3rCmlvzFGjKZdyf3/3Lt3PEdv+u2GH9nQTTb
lIWhMjIIkvdCMw7LnDuByY3KmvdQWSXfJmlp+vB2/69uMf44n4yHpYhsJdVh
5SzalokNN7GNGQMERszuok+5W/YNr/3W7PgTwdKL+fV4gSFzzlk0w1ZNomGE
6ISdLSTa68oiw4lfbR49bvT2djx/iuSovWDAsSYscsGAOgGsklf0Yp2T3K4N
KnZbMPC7QP7BQPEp//VLj5lbNo8oXMzDw3pE9CJtEsWLqJOhjdPHtauRcX6p
+uZy92Pp1Av5coJcmS03lkrZOgnbuoSeWQInCCisx0AGzbd/vr7/oPHEZfbW
AwSFITmZ057VkapVMEo2O9tizgz6FWuHNZvsWtHC+XjXwmnuRpoehVqf+TuD
7toCvSyi1z7drttE41Tx3r7+tOY/oP9LPxKFO4UIa0baIErdgs41rvDQE7Ax
vYMhDfvyq/HcM/yG64JBv4W5kCVZHHE+rYXzzsoZNEyhbQRdri6lFX1VzL5x
5jeqk2ct9+6xESHITiIuRF8d+Q5LRgmJNYrhXH0jnIWDCJ2aBbW4uff3oVMH
Q4Wng5kgnM6GTx3CepEyhcIlVMvQtIFWFRo3EcTMpZ4TVdxc6XwinwxXiBLX
NnPWdss4fJCTpBE+ODZCJfp4FV3d32wdPG33vIMnQYhNQEE+Gmsx2IlZLixQ
LcbuGhyvCVEWJ2vS7KpnJk6kLF1MVtxI1NyPMz99aXse7Ax9dKQA15vwtB/h
U4gTIGoWvl+Jwk/LMq9vVD9S94RpphN0khyiFpoaaMiJwU1MyF8hg73glXM1
5SZzzHbEm73yFE+jEJuJ/HI6dvsGKGxVLMTGKvRqWAyclYMNNouR70kaeZUf
IYO2CM7yNCkCSY/s0ZfdGhsiQ5v038P+Xz3r3/b/3JqnMZHwKoN/B2LGkCVA
yTKqFajbQPU6MhbN9z+fjTohzL8qbXqoGA7dmI/fVGRt6ko37HVrLPVSyxha
xBgPUyOY7sRkDV3gC+y1B3gegdQMlJejg7PtW+TRCbqHvupeUWOtxIMwahbb
v04fO5m5cClj9Waa5kGy0T/eHhx5qhx3OmhOHzIJ5t3eEx9P3/i9MPikPM1b
Wflou+uFfirRIM7dUVbsGJsMe4jg5DpmVsgFY3EcC53gFTO/Vnucc5zyZe+9
QHgaMktR1YSufgond9V1Cjm2VTDqX7tOOI3G7YEz5bNXK6Q+5eqnpcbQIkdU
rjMhDamxSA/hrCBrCBF6f/bcbyU+xzbCvbSZ93erQyw98fbpbMdyuVPV6DR1
O5wjVvCMrnMI4g2siCGdgrC57X1PkvYct7rKh3OB8InHizyk11JKdfsYRgQQ
rGBlk7JltSbytTHY2UWleN6nfdW/TfuixbVsjrQa5JaiKAclcSh47NbXuApN
3c73nJn3nu3vfPfv6Y/Ec7W40kpfu8G/0z+fv8/ZUhT4apqDDSPxxoVso6LM
pG8wOjp3WFcHN6HGzDo3UJyHcBxLXcxPlj3OO8764WE0onOQX42GTnK64guw
LCGYVauBaRdWyx7+ZzBqFuSTfWer+ddqJL41Kv8qY1i5LaaYTcpl09OQFYOs
IBobvzt55Bfi64c2gjx1qb6mimBbZ7xzMgfiCiibYexhHaMO8C2cFc8WpKuQ
L0A6gqXaaldZdsZ26D43Oc6kyXFhGwewzoK3DNE6FBqojVxErh1qi73tfOfo
9a7Fh91rQV36yA5bUqszqwEFlSgtJKyhPILZ1+Iqy/d/IjnFqO6e33lxx54R
4KyKZrsyMVUKcSOU3ZxMasYN+9mxZiDYb3MR0q6RXxDpiTmkY27g0HNcTcLT
QsQ2IK8XtVPoXqKBMbkiGPaYhTNaw9j9iaXAyfXICUPymCNnmBasuoMw9eYi
NMapTAShbZjt32NruFeZHmraxf+RvorlQkz4Jz+X+5zejrppzH9mb4phhzMx
XwpFA3TdsI+A5Tkxb4HYAKmauPyKBeKZipuYI8aD93E1CoG5SK5DaQ8pulyP
+Ixsz5jZ9VEoNNr1aSx2gVrRcr5n5Ebfgl+/IpgMvGwpXc7sVlIglVeiKh/V
KaQ4+9H8od9tXD1lCLxpS37mLItmOzIxUQZhEzZ6sDMGx6w7o5pyFympxNVI
b844Ja2dH18b/dVVmrqH43YmQqqQ0oHSUTS76ZmbWNBh2UhQntiMyvPjXTen
Jh9Ni0N5yjhy3XUWjLEVQ6jrRnMz2irRlkW93/skiz9xbPfWVQ5aCkd5CjqK
yL1zqYugJcMM7CI3jsdyQeuup1FqlXXMHngkOflg45u7zHkD8wzHE3CrCM8b
kdCPgmnUCtGxCppJ6AnHq7y60HlfOPlcLIpeVqaRypytXGAbZ2nhXHv7YDMG
Ck3V91zFyveSWd0r+t2u7R/cK/vh0tGvt+5csrh9JupT2YEizNVD1gXNCCx8
DhSVOrFmh9JEKVtbcihnnbIu+Vgqc9l5JAy3shFSg7QelE2iZREDckypINBT
mKnIjHkjBpXasgtTHbf4E49nRWFzm/GzO5l8Z9E0WzmOhkG0dqGjEV2lZDDw
gWT/19pLF61P77PxYShORkshRuqw0AXFKHSzsO5dRi5SmYwQ1NAsGSQtI18G
CI4ErJx9wvizJ1JwtxyhbUgZQfEc6iXoXMfANoZ16Ncg8+x89Q1Rz2MJL2xF
kkCWUhQrVytkW+fRzSOm1XAnRqq5kZGIorTO2K7dRkAgEjnIqOUVZCTnQyOE
5TU2x1klswb51PE40Tdx69ejdT7hlsdB9oBHTCh7JAvXa/CsG9HjyJhHkQTl
q3hxXJzhJa/yXe/mnE2X07dURWpTjZJt3UCfHKNiWir+MPiNbE9EFac0+xPP
6l/uPavcisYxHywfOLRz7Zoj2B/psURu7ani8l2GoOJhdwlO2WuyqAM7JiKL
aoWWtYHmz0KHvgqdPRpyIA7XSxHUhqRRFAhQI0HrOrrV6NVQ7fn865nUs0uV
NyVdT2RT4avLSauqHI5rV7/CzakFGJqiDIXxNoyVMz9e2X9g98xV3H+CyGjk
ZqG+Ev1txChc4ZHRs1EOp+oVCGR2VUd6m1bUdyCZdzp52Stp83aC/mGM7Vm4
Rzqu1OBpDyInkDpPIFCOBD5fLoWfkmZ5r9X6qXrDtvkJmpUc7Xa5xtKwxXYq
MbhGDDv+AvnozXVhuoR5f5H5g+HAN+w39+H3AlGpyC1GXSN6XaXTJMQL2JRx
EYE6ODj6otNq3d5eElwplt8r2n5SYArJdkamsfFxbFIIkny57I5a5t1+j/d5
5z4T+RxaDb+oyryrqwrYJQvTdMtysVVVazG1c+lnkzrMqbAko7UT9VGCO0ep
GPnQ87tr+mfcmn73u1xlFc/sm/c4bL5wE0+CkeCq44vR1khS/sVJ2m41Upg3
4HxtYUzFps6qk0glXb0HM3hnM5evZmzeTdU/SnJVmrdbEDiEKB4S5hE9h2M/
mfT+fCnohCzt2mbVo62eFzpekl6SZ1BXGMxNOrbb9fwoMbmKGTEEs1gYwXwb
tToHzUevszcCEZyAtAIizHT0YHyCBHwKKTSbe4nKTivF8lnMhtXN2bELFYs3
KtYelOsCSyzhBWxsNpuUjLQopAcw+zgR3A95Zz4T3zuyHn55O+v+Tk2wuTfe
xs8mpcV2k93SY2NHzORds7BFGucVIVZc1UNDk6uX/1LDXHIef4TbkZR1mlpJ
zJK2YRowC5YhXYdKCz1HUjTZsWXamfBuEz5o23jethPZbEusR2YVDZ2LM1AS
yZEm93TNZ77auHdG9+KmOeOpo/Il25XKThVCXAtlB4xuo/oFJyQmrG5ziuaJ
sU89535HekDpQYpu/17V7F7ff7P3zP6de12ZnSO32NuhVFBml6PW1esMgzcD
sZgoY9otwqLdHHubjTWad9a2RK1Hq0cv1izcqlU8qtEGVZpfljkTCtnUbBoi
5ERy5KDRgz8TXjuwHnRJm+ZrrAy2dSc4pnNZCScWN/c6nWM28E1Y1HMehFLI
BFgZwmIN8+U24022un7JiC5BXjOJQPt4mBYRc1HhOgJ2oLdwVEQbK9Orey51
Tt+hiZEqrMsY225Pa0ZuHYrKUebWC7t29lGPj0XHv9q8c87w4rYtM8BZHcP2
ZLK8MkgaSRxuHns17JRZsKbD5hrZcEk7Bj7xmv6tJ3PBvv8RLkbDLwdRNcjp
Qs04UXrHZRCoyPtYYSbYQGpme2+M8x5NSEIm1LHj5vRRR/4gyskgH03VaMnl
wPEB5oNFj882Th0x3PayhjxwpIay5YnoyMdENYTt2BjCDo/TULiDW7fMbsdP
wYH70pP3Nr+5qblC9ONNL8/vIWDudf2b73z3b9178lX2fAgepyOuEkUdJP8Z
FBDRQLwJhZaqSA1nI6i2Olf0msrj3d2X+6bu9S8/61eF9xkTeuwZHWx+C0rr
UFlGlrE1Ccz7Mwd+veZ1Uh9wgwqg8mi2MwuT5RA3Q9kL4ziclDbmKoDsWDdC
uUW2wZs8h6Sl9aObzDmLxzMqIQNKSO9TPISmGfQvY2qdiAaSXVoEqQVzeku9
58TAvenZZzzZS54madqaM+ksGSUlXWMnWhvQXoK2FHeo2PHDhhte1mA/Z1o4
KlLRWYTJemJfbo5id/aNKSalvmigWbbKOqc8/IUnHq9985C5yx5+iSvZ8K9B
XDfyJlCziA75nhqFt4thLVt3Y7H/kWgmTCyLX9Zkia0lS2ztPFr56B7DQA+G
6tGfTZjnj1aYL7XHz1iu32IDA5AUg5IstFZgpAULA1BMQ7cI2+vw1l0HqRKU
k67V2rweYfAJMT1+6gy4aw3wevva/u3b1/YxLicjoByJ7SgeRZMA/dI9bb1w
l3I8hGZMaW2ZxyZqvYjVNxM4J4ua06TOWfP4zrIp1Lmqz350tKO7Dt1FzA8X
mC+2v7lgfeLrdJVAJSloK8KYe0g5BsMc7OLXgzMH9Cboldhe0EtaBr4Injkc
vHw28GAUvAsQ2ITEARTwUSdGxxoGtjCqw7AeDQpz/qWlxrvLwwEr85FSRapU
/1rkQc7CUxgexGgrRsqYfXzm16qDJy1XbuEZV/+U5KK1GqPtWBiGYgY6EWx7
doecwZbJ6DTIRo8kLZxPXPWO1/jEmB6HWwMDmURcLqPBZOQI0uf26Fg0mDwt
yfVebfDbGAhTzSVsyXO2tOVqeyM3uRmUYmKJ8IrZfvCqiMLxsYzx2D10ib18
H0/CEJP8LT9oZhwr83R/G5Ww6zgAi5QH2oUrhYp7Ba7VModkOCITEf8SiU/e
kq/sXtsf7O3HP3BXxQH4JgdPGhE7gFw+qsRoUaBbRWNH10lYIbOEH5rP8RQ3
+EgHn68KYhSr6Qpd0aq9Wsa2SKgbG5wl68yJPkw0URrb14aTl1mfx1QB5WWj
oRKD7ZgbhmwGWyKYFHCqX8VtcKkDNq2wyyN98lS66HL6+u0UnV+iJSDmXAke
tHEzx1nkiJC/gvOfzPh5iGPOywtubzY/2xqJ0i6k6dYKdYYarbOV051SsNYy
ZucwPwJBKzmm/2aLOcue88GDUESlUPlT34j+PvCnyOlHKceOCjb9KyMtq2V7
W8i7XCa5U6Z6XGIMKbRHZjsTUpASjbRALtnXVf4MeHww881vlx8eW4/y2sp7
YGgIMQ3EW+ZyrPJyq7bJau/hclj5GixskCunhAdRe+f7nsxPRMxB0/4rzjOP
4ROFF5kUil7Zhs4hjM9gcRmK9b25l4XmMM6p6y3iBy3K583GyAZau8wysrMv
TkThs+91Nu4V/fu3VVBRnjV41IvwScTPIX6eUKCTP+Xf+Wo54vxa7h11Y4B2
KNown7GjKNnR1xmcHTrW1TmMb1KKkEBIkNMi5/Pzpe7AFfbaMwTFk1dqRT3R
KCYmsbSINdkrZycTTbTsNtZs1ss2ZgbPV89dr5E/qN4OrDRFlDrjCtmULEqW
yw5n9uW5Q1YvfL7y8KQy2ltX8Ji4YMOp9oVCx1qtw9DucAza2EmTa0+G0HXk
ySB1ndWDmC9nPpExZ21H7+NGBIK5mqe8He0jZJ8xL+FywbS0SbiFGSqjYehq
57xv12pAp/Zluy2xxZlZj4IK8sUuT+FYm+3Mu7wDv5Cc81A+uGCIvGvNDXTW
x7L9WZgtI0Wpphe2cbDuJEvZLtZV2BBBPjD2q8uCLz0pyfIqe9gfV2PxLA/x
tSjoJn+xvgVMy7gploEyyZU29N0Y5T8aWwkZ244dtaRz2ERFJ5XiTaVoSn77
ev7D3hP6b+mrCCpw3p08+kvJnWOq8GuG3CeWhpfOoTTMF0NRD30n7MMsOSy7
+k+xFtLXfj29jrli5pLjzDMKDYgq5qqbQfTxwRNDtMZVN69JczanRKtqv9gz
fpv8xDfC+nbium1pnDSzpBaVpajJQk0Ms2/c42eS0/vV9y8Zo+7b80LZxkR2
KB+Caqy2QzcI+zSIrS7hmEWb21DJsMGzCWsHf3WTOWJgfHD2Je5nI7Ia2e7S
ZuFVaWPAKqevWDY5265Njj2YEgZPb8RM76S5gYhBAiJamtBejrY07hZa8vjN
5ukTuz7etvDHzqyXbE0aektIy7/SQ6lFxFBfdrOnXb/eLrQK58aI4PBT6dlH
ysu+zHkjmTDG4U4BQuqR0ouSKTQJ0afAxBZmdjBrRP2NhYHHwrkwkTxBpM0W
2ksX2TpOGtgzhIF2DJY6Gv255/HPXN+kdXOv3T++DTMMZ34kOPyF8sZ5Y5iP
PSvEWZfEDhRgrhbyTmiGYf0We7CRQlqthFrkOgSNi5Udn/gyD4n79rQY8c0o
HOIY/hJOXqsl6vqKhQhCUxpz5cXp7jsz0/6zkgjyNTHn8J2lU6h9feTWojvf
dcszv1w/cdx457o93J/NjiEVW38FZlohHXgVdS/leEHbDujMFKm4Pd/3+1De
oRDxmaANr4D9IbiYQbLP6C7kTKB6Ae0ykKGZDpM76N9my68JOx4uT4asiOOk
qkypqUTC1oqIrdfDw6CrQ+nASAW1Pj+SMH/QHT9vu3UPIcFIS0BFPjprMNkJ
EZdGtLPMRbO7VX+uh3p3c/pk0vLlxM1bcTsPo6wBoc6Qp8wLnMzGnVoE95DI
M38RVTI0bKBKgfzrq42PNobCVIJE9WqOWl+ucjZyMSpDnO0a0SRa2YG476/f
/7L37HHr9oJ5b4nx0Ht52QOfIDUKlVk0+uK1QTIINQ+mJbAyd2ISS9DojgF6
hUM13fLrl8MekYJTkR5BxOx5Uo/YfuTxUC1CmwJ9agxq0aclV8D0C6Lq2yu9
z+T8SIU0lTJFrVUytkmCLuGrk9W13dYz+yZc59mhs3bvewgKRWoyKorIqHCy
l0b9mwvYkcKxpz91Yws6q2Zx7GTmomeG4laazi/ZEhjHPDGfKoBPM0IHkcRH
ngglMhRKEXSUYhor7pM0cipOs5ytVZdpzQ2cVcbQGiZXMLMAwTgEHZjMZX4i
YfYbj1xmr/jB/yUSMlBcjpYWKqXmeZCLoFHAvM0Z6BHPgTXvrM97E2NVG1Bs
Cc9n4zLZlESkv0C6mxvcwrw3fPDHc56/lzw+sR5zdTv/oaEx1DiUQG7Jigqr
vpmjN4wZMLONRQWn1Rvm+pE/XrV/97YTMMz1Sc94wy8QcYkoLqQ63g0grC1A
J4V1E07ugtHMx2J1GpXbyuneI3m8b/IlN/KUD3J2AjI8kuHdgIABRPOQsoDU
JRz7iHfjC1HI6dWMG6qap5q+l/qZ1B1Z4Y62ZsfWpmf7tzHGnaHz3Bm61Ie5
ahqjXHBeeIhHLxGXicJKirAdHiZ0QbaMrXUYNd9CB64ztPdMDf9a7YpvjTqg
2hRe4YgrZlNzkJXCibHiCTx8b+LoJ0Lv/Yqgb7ZT7u5UBJq7Ym1TWY7lMnJo
MPe4ydQ7WNzG8hqRqyifvLz/I09m/67r2DrrD99YvMxFdi1qutAzjql5CGVY
U0FjwK6FQAO91TZxs0v0qGszpGs3xt3p1qKkDBXZqIziOt1+5v25A7+SXTyo
9ru4E33PlhfkbIhjB7MxV47VZuj68Mr5wIpVPTbWXMvz/ZX7397WaYQxX2gP
XGdvBCMslej+ta3o5VCC5WVQSJSbhc7Ro602x/aOsvlE48jlpoW7FNhI5InY
Gja1AtmFKMhEERcIvW/i4C+Wrx9WhnjpMx6aq184+pIxUwBZDTTtsA2y7JQd
AhPEnEkznaDTWG6r/6Enc9Z+zA83oxGaS9Omym7i2k0scubhaqh3iNHnPkEX
1PKhG/3zjwYUIf26mD5bGqdZK21AVTlqc1AbSxKLHy8c/Hz9qquZvW5Nfuoo
i2Q70jFZwo1EemBygwMiJ+Q2EkKqFK6d0LxYwfvyjujwTeYKe8DVzCbgWSES
GlHUh6Zp8g/jrRGnQGYk6oarn+25PT39hCd5wdtK5FmyuTa2hnO2aq9DZz6z
r5z4uD+WHPxCff405YFEPnXmRKEuA/2cu4K0F5oJ7JkYrLNExNFq3rpy//ub
fUSYq9I4FURk5pgKFLr6/jEMzoMvhVj57eDD9V4Kk7X0xEDHFXLhFT8f3Utf
zO1HaTeqW1Bfg6YiNKcyHwgOfb5x5QxFtKc+d1bGE52HV42VdvKEtrjKjEXu
vFy3Q7VDVnXqJXa1r/uXjya/8mPu4Uwk7uchsh45faidRrcI425F3Kvzckip
ab05M/ZYIHwxv5Eg2M2edZbw2doJtAyhsxM99egt4IhF0gOMzvOi9amrRQ0l
lL61EGPuYccYdubg2COTOLnh2DY0ixMHw4VnXqx5hWhvBzAP2aNxuFWI4EYk
D6CYj0YxetYxuo1JA0b0qLm13Pd0ZSZCJkuWafJk9goJ2yhEpwADkxjtx3gD
Bl3VzjTzM4XHgZ3Tlxx37yMsFBlJxJ119dDT7pBmAUwreGU/4GpOdy1qvmtd
vn+2/R/fedY4BCeY8SUKzpMyxLejcAyN8+iTYUKFOR0WjcS/4RmQwnn/9jxY
4gULV2JF25lCa9Gis3oOzVz6XF8vTWUGy5j3hMzXum8u2Z76ISGC+CDtZZho
gWiAAtd3FzlA3n1cGtyxeNJdRf/oobiFc7GrV6OZAPZMOh5UI7KbHNwql9Cy
Soxj13HZq0HiGVHpDWn749WJ8DVxEpm9kn1ukwxdy3SvjU1hagBTjdRC/2xt
/2HT2Wt48BRRrxvRNmpE5TPQiGFZA7v9ylLTvGPRLMxdypHfyt72yzAFpjjC
Y9mYFx5puFYN/27ETCBzAUUrKJYh/Iw8+8Zm3ZOt/nDtbLJOnq/XVuscrRrK
dh5TgL8MwQxZKsyU0d1D/ATrcW/2+lM8j0ZyFkor0daG0WEszlDOp24DVi0F
VrtaULt553vz5j//3gr+hzefucCTmXhQj8gBZPFRLkaDAm1KtKpRvGIPOkRh
ctW+633Bypk4lSxLrS1T2Rs22Q4FBqQYF5Kn1cwwZtqYfTOMx+6Ja/B9hsg4
5OWjsY6SzF0n/uo8Ae0W9zlp3Iu4sxrkfccpBGvldrH6cYExONcRme6MT/Cq
xZNevJxC4jxiBfD8rdD/+GriVVWpn7YjzDCZtLucb1RV7ZrdASNjW+CvkwWr
cAbCAcxVMD+VMsdtx26xN4MQ4qoQilDVgK4+SjYWLXFMji1YduCwkMbLZDaM
X2kU+jRuPmvYDa+1xlfQX8jNQmE8CgM5w6BBjw/mzvxWeu+4MvyKLuuhqTbM
1pdEDqLyalbb5rQPOtgpMniAWA2ZlIZcwnrXRWV+LmdOWvffxsUg+CUimgug
ru9F3yR4S1hepa5Gt0txETt29rueum+u1zvv/NPbapKbF+txt4e+Zvb17P/R
3JU/SIPOKdPv6KoDd/tizbNZFg5MsNh7OFInT4P5TYikkMxDMoKlJuYP+gPe
7NXnCEpGagkqm9E1iEnXhxdzcX8aohZbX9FnF9cFI1fbFnzb1wPbDC9bbIlc
/mt+KUpyUJbAXabx/T8TXfLYfHJRl+BjLg12tiewE7kQVxGR0zTASWTnraQk
dh12aytQ8CBuGvj5Veaw0cN1jULJOSu2jBIqGoepYJ2RUJKI6+jSmIk3tW1j
e64N8R4MrwSNbEUPW1IHHHk9NKuorUNjMZpSOFt9nscn0uMeW3e+MYXds2cE
Oavj2d5c8KsgbYNmENa93Z6TT6jUUAktwlr3s/ID5oieuU0a6JupCCpFcgtK
h9A6S6nYM5t0mMvNxBFwI9j/+vVawM3Xc6/T//m2ju0as29s/y9WPI9sBVw1
pT5xVEWyvRksvxTSP4IGHNy5u41NOTbmIOuRDsUzno7jz+GTgshy5LajfhR9
ArKdFSqpClKaoXad7VbMbqs7ro1PPpwUh0ypYidN6aTkQGUf6jvQUo+2Yjqp
fzh34LP18yeI8Rfr7yyKZluzMFYBYQvRK3enwC5yDkjrDqgprwtbSxZJy/T+
ANEpf+YaDoXAOx3PK5DcgdIxtMxjUAaeipOVcFht7TVB/8PF2ZAledySNmvR
UcK50LZOoHsA/a20n5OdxgLza+Wx48Yb3vbgp0iNREUGusow1UwKB9U0NUFk
hE84s9PteeZGqf7a4zlOp8KnDC/akD6CMgGJdfqUHDqrg1s58fqqv35q/vnN
/usacTp/vXnhjPnJXUdiCFueTHj7VD3ZrqrHXjX5Ck4irbFwKpZl+/pQz+/D
pw6/YO7jTAL8ShHThrxR1M2jW4YxFfg6ojrO7CL55FzFtaVuPzEvVLKSsLKd
LbGWitn6ReJq9k6SLfhoK0ZdF2GR+UJz+rzVxxeRYeRK5Lp1hxox37fnoWqX
vTp9dxwwGli9ZPRY6uLFFMWNJO2DeOuzyP0JNGV+zk2ZiwSok6J9k9DVFiWy
r8jqH6wNhGwK4pWr2Sp9+aazcZ3tkmNIjIk5rk9tx0Qe5bp/oT14zkFWLiFI
eGWqP9ZDQTfrC9DLsJdkTIpRq0krck/j/vJIHm424PkA4njIWEKmGH/9J678
f3rbfnWF+Z3mxEWHrx+io1CYTayA0XYsjmB9Fvpl2N1ud8T4c6Piq0p5/+jJ
nIXLOWt3snSP0w+n424dXvQjjYdiEWpWyX6pVI7AI9R0Vj5Q9oRu8RM00lyt
pkJjb95iezgPwallzAowPwpBG+m/vzK4Os7rjxESjfQcVFejpxO8UbKMVK1g
d5PAcNa0l4iwvbXIu1K14lO55V9uelHijMtnUzKQGYfs4ButxIgLmsDpT4X3
Dq5GXFLn+Ojqg3YH49ztpsXQzIVwjulJ6ra4StR9ySjmK2m7/oN+/yXnWT/c
f4nITORWoL6drCFn5rCyAtUmVTM0t3RtvBbzH1Va3+40//nN09uL+ZVqvyd7
zR8h8cgsRE0D+vpIL7AipIST3S3YuJwHLgjXqtHJu8828K6T/dTW83pzZI0j
sRwZruPJ1VC6esJ8OvF+suD1tSLgwnbKvZ3KICLV8XMc0kqHpsVh77exE2bM
GQibXJFDtgDpEBYqmc/VjJfz/DM8SkBcIYoa0dKP4WkIROSNrtaQCxSXQQC1
0TDk3Tv/kKj4+uhuW2oHm9eM0hpUFaM2jZNijHj8RHjsy407Z3QvblmyA5x1
MexA1rfdIIkC5p2vu0HXhukQcUfur6SU2vME3jF4nkfEqbIetE1yulMFpNtE
2HfLAf7j3vVzX83/+rZq9ihzzn7KHw8SEVuCwhY0c9T7OQl1dW5qoIEzwtww
mevODwzeHBY8GVGEjejjh+yZ/WxRNypbUVdLsaLNaa6Taf8vVy8e0/l7W5Oe
OsqjiL82XY6VFmz3wzoJcsaTOKjvUmqhXoWSbxHVjX35mDlnPeAP70QElyCt
BRVD6JjF2AoESprhrnEzXImJbbnOH300Kwyb20zgbIhLplA7RgvQ2UZElu4M
5r1p5pNVUvJ5WUP8yCOimkM5+e42bRLWhddwHce10ojdTgV/w/jhVCzuFeBF
A9HqK3loF2N4g3M8MhK6yZ1639Yq/23vynLd9xHGB9/Ekf4zsRWlI2gVYEhK
bpWUE2aCxEIBNXnnZppuzY8+XVqKEG4kC3fzuGy9Rj7ax9Hbj8FWDFUw7865
brCz5yx+Ps44V/uUQkZ6E43ktaSchHEBrNSdReikKbthi9UsDh5ImDuTILsS
x1wxH47B7SIy7ksfRvkcWlcwsIlxLfVO3Wq22FvS9kg+8UIhTlpT5SrMFats
0wq1ekNzGB/HVDemqmiw95nq4EnrlVsIeI7kBJTno7OWkuDE41DNwyh9tXVz
rCa7bpk7u/6KCXAcz8LdWrKPS51GsRC1q2Re8c9/dAf+32+7Aw+ey8LjBsQN
IH8GNctoW0cPl/RSKXdEnZIU3FhtebIx/lIlSlUrC1Wmmk22dZ06rlExpl0F
1ChmOzBdynypO+JJ9s0R0RRI2FiNoU7Mj0EhgHaFoCv2Ww27Qb81P3mxTHSr
VPmoZDe40B6Z40xIvVSBJ92InkDGAvIkSF7E4yPyeC9lyQNNe6h+MnFnOW9X
XbVraeUE6uMqzCgo4EE0BWGHdTSZDLrOOc/7sg9fICYdBeVoasXwEOZnCB3R
bMCig91N/LVa3vkX129O5ZVbH/UvbztJPvXpQtAYAsfBvDd28hdCn8NrUVe2
C/0MreGm8RSLqMiqqrOaOyzskBFTOjKPEq3SqG5lHKJm5rfq/V7Oy88o6Dql
CBVN6HL1enxijWysk6LSYiQ8yGpndSZd3+XO2Xtdsmdd2ohX3NTCKpQXoirV
vU/t/6nw/Ncbfhd0cffMxUGOtvi9mlfdBvMgnNNOLFi4kcQm1kRYHdmrNc/b
jz7EjSiE5CC9hkOCJilGTrhKFSDlXXDKeO5Z+otXSpB3/vub9czPaY74geDw
Fxt3zhle3rPnBzubE8lGSVgLZSeMI1xyAFFiLZTorFzjhNm9XZ8+Ys7bjjzD
3SRElCK3DfUj6BeAJ+V4pQaoLJTZqrA4G7wmh3x5C0H89RgeZYUWTrBVw2js
Jffqrkp0ZTLv8Zlfrp0+tnPf2xb91FkYzba4S8pWigEw8sAuuROY7fQbadZd
Fd6/cu8ormoqeg9Vye1HHQ89Yky6pxBGqie5+uFfv9pD3vl/3nYPfMJ8sHxo
v/76FVvYEzY7Gg3ZGKrCQjvWhok66nBrLlRcoJJe5yolbetDIwfj58/GMXfY
k3F4UIJorpirn0ePjLtp9ZgzEm80z1PU7LsyGiQTxsk3s+SmUilbv4yOJSIx
j45RpM9ENQ2oP98+dtZ65x7CQ5GTgobXldwU9EuwyzmSIw2oXef49s7mhHs/
/TfMc/ZMFh7UIrIP2TxUitCyhi41CSm4nfQvXk3r3vkfb57xP2M+EO0/bLp0
EwHBhNq7zsreJvAHIOVhW8jJQr+VopjtO4ruYyU8z9KVOyVbT4pMIXlMCm65
9qA+pPJRKOLYBAr4MJLIC2sFdyldZixOL8o2qMq5aBnXHjOqBG+VsGfhNPEo
+AXM77UHL7FXHiEwCqk5qKxGt6t0Gqd+UiUjxa3dwOHfNlhMGjeb9nr7Xov0
zn/c+804dP2dfW/b7T5mDpmP32F9XZtEJj1lrZ00tFhceDUd5vz7nATT2hXb
kqErHfP3O9eedxqi2u0pzcipo/FBRR6qEpl97R7vzx7/jezuya2XN3bz/W3N
0exYFoTlRF4nDeeEAwILGYXJN6EQY3XcvlDBfLJCwONT3I+nXr2gEU0DGOYT
C062AcpQMlNGos7m/K97dydXmb3z7pvn3X/3uEmB4IE5SK2jXPWuaUyKsLRO
NmZEHrdRyyY27LZcmxp7yNsLIc+achaPoWYQza9JvV3Mh8vHmO1blywvHjpy
wtnGNHa4FItN2OjjmrUFlpq1DTt5Sms2oZ7be7Ie43ICnpUgqYVO2zYBRqRk
Ryw2EJy7bHE/WbQO/8x99h9+Zx24ev5fPAJxLRMhtcjoo+O+U4xR93G/S91O
n9pefJVMOSfDZJJE+Xau3FohZZvENIEd5GF8hBINJsqZj1f3HzFdvcEGBSA9
HjUF6K/DXA9WJ171OUo3gZXoRHbN4t7T4REOrwIENCNpmHjIDVJOva5B2xtP
x3/hPvv7b7uH/tuFQjxtQ/w48hZQKUXdOspW8eDASuyljZL7Wx2huulEw0r+
jqbawIVGb2Figwy6XXcZySnaaCZ1wn7uLh6HISGd4js62ihSQzwHpas9UHKq
cq49sFl23GzTi3V4PAD/Ufc9TvcFd5a/88Gbu/V/Yva1eLw/d+J3q75nNDG3
TcXP7R3x7FQe6Yq320HBxjwHAaQkcl3H2hJWh3dnCpgj5sM+uBmJFzk0Yanv
wcAUKW5X1ii8UG8k8MhgZ5e21//L3rX5H9y//ePvXBvu3vy3RM/+cPn4fu1d
L2vkY2dBFGEAE5UQt0E9BDOfixskf3nXhm2g6ZuK58ZG/pa5jlMR5Mwc4zr/
BtA8g0EJ+Jtkcy01UxU3oNT/895v/x73CT58c+/6B+Yj+YFjZu9bCA0mk9uG
EnJaWxjAOg87IjgVrzo/YlxsGVV87l74q+OpeFCD6D7k8qj6aV9H7xY6t/BP
e78r91u+89Hb7oO/Y044zvviaQRBpbRTdYE3gZVFUo2atva06g4bazJp/q+9
d/uYe7eP3/ZE/IBhdId8cSsaEfnIbSA/uaEZCCSQbXKZr2aCoLesTq4ro2vw
c+69fvrmzvDXxyJwPx8xTSgaQvMckbWoDObwkwUTVw3Sp/iM+5uffOdTcLvp
X7m+9kjAnWpE9BFMW7mMpnU6Nl5dj8+5v/vzvX/1u3qGf9r7bF9yr/r0Oz/9
Lnfv3++9pwf36l/uved3X/W/7r3qEPeqz77z0+96zv/93ic4xr3619/56ds8
y+m9T3Ov/s3eJ3ibNya953nuVZ+/8VPqlf9i7z08uZ/+zvXnX7q+usp99c6f
/b+Jnv33\
\>"]]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->10980],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{"Line", "/@", 
     RowBox[{"Tuples", "[", 
      RowBox[{
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Cos", "[", 
            RowBox[{"2", "Pi", " ", 
             RowBox[{"i", "/", "n"}]}], "]"}], ",", 
           RowBox[{"Sin", "[", 
            RowBox[{"2", "Pi", " ", 
             RowBox[{"i", "/", "n"}]}], "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"i", ",", "n"}], "}"}]}], "]"}], ",", "2"}], "]"}]}], "]"}],
    ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "2", ",", "15", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->13888],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`n$$ = 5, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`n$$], 2, 15, 1}}, Typeset`size$$ = {180., {92., 97.}},
     Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`n$8290$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`n$$ = 2}, 
      "ControllerVariables" :> {
        Hold[$CellContext`n$$, $CellContext`n$8290$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Graphics[
        Map[Line, 
         Tuples[
          Table[{
            Cos[2 Pi ($CellContext`i/$CellContext`n$$)], 
            Sin[
            2 Pi ($CellContext`i/$CellContext`n$$)]}, {$CellContext`i, \
$CellContext`n$$}], 2]]], "Specifications" :> {{$CellContext`n$$, 2, 15, 1}}, 
      "Options" :> {}, "DefaultOptions" :> {}],
     ImageSizeCache->{250., {136., 141.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{254, 279},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->775014591]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->10219],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Outer",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Outer"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Array",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Array"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["IntegerDigits",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/IntegerDigits"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Permutations",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Permutations"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Subsets",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Subsets"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Distribute",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Distribute"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->21479]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->20339],

Cell[TextData[ButtonBox["Grouping and Combining Elements of Lists",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/GroupingAndCombiningElementsOfLists"]], "Tutorials",
 CellID->31251]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->78251594],

Cell[TextData[ButtonBox["Constructing Lists",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ConstructingLists"]], "MoreAbout",
 CellID->599567172],

Cell[TextData[ButtonBox["Discrete Mathematics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DiscreteMathematics"]], "MoreAbout",
 CellID->241764206],

Cell[TextData[ButtonBox["List Manipulation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ListManipulation"]], "MoreAbout",
 CellID->468120590],

Cell[TextData[ButtonBox["Rearranging & Restructuring Lists",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/RearrangingAndRestructuringLists"]], "MoreAbout",
 CellID->218897649]
}, Open  ]],

Cell["New in 5.1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Tuples - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 27, 59.6781782}", "context" -> "System`", 
    "keywords" -> {
     "combinations", "generating tuples", "ordered pairs", "pairs", "triples",
       "vectors"}, "index" -> True, "label" -> "Built-in Mathematica Symbol", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "Tuples[list, n] generates a list of all possible n-tuples of elements \
from list. Tuples[{list_1, list_2, ...}] generates a list of all possible \
tuples whose i\\[Null] \\[Null]^th element is from list_i. ", 
    "synonyms" -> {}, "title" -> "Tuples", "type" -> "Symbol", "uri" -> 
    "ref/Tuples"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[9085, 304, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->97036708]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 213480, 4633}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2807, 64, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3430, 91, 44, 1, 70, "ObjectName",
 CellID->12154],
Cell[3477, 94, 1610, 52, 70, "Usage",
 CellID->16094]
}, Open  ]],
Cell[CellGroupData[{
Cell[5124, 151, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5602, 168, 600, 23, 70, "Notes",
 CellID->23513],
Cell[6205, 193, 1496, 53, 70, "Notes",
 CellID->18538],
Cell[7704, 248, 809, 30, 70, "Notes",
 CellID->2398],
Cell[8516, 280, 532, 19, 70, "Notes",
 CellID->32505]
}, Closed]],
Cell[CellGroupData[{
Cell[9085, 304, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->97036708],
Cell[CellGroupData[{
Cell[9469, 318, 148, 5, 70, "ExampleSection",
 CellID->383742161],
Cell[9620, 325, 171, 7, 70, "ExampleText",
 CellID->30600],
Cell[CellGroupData[{
Cell[9816, 336, 170, 6, 28, "Input",
 CellID->23498],
Cell[9989, 344, 736, 23, 36, "Output",
 CellID->647257171]
}, Open  ]],
Cell[10740, 370, 119, 3, 70, "ExampleDelimiter",
 CellID->141],
Cell[10862, 375, 85, 1, 70, "ExampleText",
 CellID->7925],
Cell[CellGroupData[{
Cell[10972, 380, 170, 6, 70, "Input",
 CellID->27840],
Cell[11145, 388, 737, 23, 36, "Output",
 CellID->1446600942]
}, Open  ]],
Cell[11897, 414, 120, 3, 70, "ExampleDelimiter",
 CellID->9009],
Cell[12020, 419, 86, 1, 70, "ExampleText",
 CellID->23656],
Cell[CellGroupData[{
Cell[12131, 424, 302, 10, 70, "Input",
 CellID->23443],
Cell[12436, 436, 737, 23, 36, "Output",
 CellID->1359664507]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[13222, 465, 238, 7, 70, "ExampleSection",
 CellID->3458],
Cell[13463, 474, 90, 1, 70, "ExampleText",
 CellID->24079],
Cell[CellGroupData[{
Cell[13578, 479, 170, 6, 70, "Input",
 CellID->21288],
Cell[13751, 487, 420, 15, 36, "Output",
 CellID->411827773]
}, Open  ]],
Cell[CellGroupData[{
Cell[14208, 507, 180, 6, 70, "Input",
 CellID->18300],
Cell[14391, 515, 715, 25, 36, "Output",
 CellID->376513265]
}, Open  ]],
Cell[15121, 543, 121, 3, 70, "ExampleDelimiter",
 CellID->24654],
Cell[15245, 548, 219, 9, 70, "ExampleText",
 CellID->9067],
Cell[CellGroupData[{
Cell[15489, 561, 219, 8, 70, "Input",
 CellID->26930],
Cell[15711, 571, 1642, 31, 70, "Output",
 Evaluatable->False,
 CellID->18666600]
}, Open  ]],
Cell[CellGroupData[{
Cell[17390, 607, 97, 3, 70, "Input",
 CellID->2852],
Cell[17490, 612, 1468, 28, 70, "Output",
 Evaluatable->False,
 CellID->457727264]
}, Open  ]],
Cell[18973, 643, 121, 3, 70, "ExampleDelimiter",
 CellID->24177],
Cell[19097, 648, 60, 1, 70, "ExampleText",
 CellID->20734],
Cell[CellGroupData[{
Cell[19182, 653, 185, 6, 70, "Input",
 CellID->16620],
Cell[19370, 661, 760, 25, 36, "Output",
 CellID->503390993]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[20179, 692, 223, 7, 70, "ExampleSection",
 CellID->25940],
Cell[20405, 701, 75, 1, 70, "ExampleText",
 CellID->19959],
Cell[CellGroupData[{
Cell[20505, 706, 169, 6, 70, "Input",
 CellID->2118],
Cell[20677, 714, 736, 23, 36, "Output",
 CellID->304782575]
}, Open  ]],
Cell[CellGroupData[{
Cell[21450, 742, 170, 6, 70, "Input",
 CellID->17376],
Cell[21623, 750, 270, 9, 36, "Output",
 CellID->259536021]
}, Open  ]],
Cell[21908, 762, 121, 3, 70, "ExampleDelimiter",
 CellID->10453],
Cell[22032, 767, 72, 1, 70, "ExampleText",
 CellID->27035],
Cell[CellGroupData[{
Cell[22129, 772, 226, 8, 70, "Input",
 CellID->15565],
Cell[22358, 782, 352, 9, 36, "Output",
 CellID->775894607]
}, Open  ]],
Cell[22725, 794, 121, 3, 70, "ExampleDelimiter",
 CellID->15670],
Cell[CellGroupData[{
Cell[22871, 801, 406, 14, 70, "Input",
 CellID->16712],
Cell[23280, 817, 991, 20, 70, "Output",
 Evaluatable->False,
 CellID->69055466]
}, Open  ]],
Cell[24286, 840, 121, 3, 70, "ExampleDelimiter",
 CellID->12526],
Cell[24410, 845, 95, 1, 70, "ExampleText",
 CellID->28959],
Cell[CellGroupData[{
Cell[24530, 850, 311, 10, 70, "Input",
 CellID->10460],
Cell[24844, 862, 995, 32, 54, "Output",
 CellID->268553970]
}, Open  ]],
Cell[25854, 897, 120, 3, 70, "ExampleDelimiter",
 CellID->4200],
Cell[25977, 902, 94, 1, 70, "ExampleText",
 CellID->31274],
Cell[CellGroupData[{
Cell[26096, 907, 251, 9, 70, "Input",
 CellID->5783],
Cell[26350, 918, 522, 13, 70, "Output",
 Evaluatable->False,
 CellID->637614064]
}, Open  ]],
Cell[26887, 934, 121, 3, 70, "ExampleDelimiter",
 CellID->30506],
Cell[27011, 939, 59, 1, 70, "ExampleText",
 CellID->4987],
Cell[CellGroupData[{
Cell[27095, 944, 255, 9, 70, "Input",
 CellID->9501],
Cell[27353, 955, 500, 12, 70, "Output",
 Evaluatable->False,
 CellID->64620090]
}, Open  ]],
Cell[27868, 970, 121, 3, 70, "ExampleDelimiter",
 CellID->28192],
Cell[27992, 975, 84, 1, 70, "ExampleText",
 CellID->23714],
Cell[CellGroupData[{
Cell[28101, 980, 576, 19, 70, "Input",
 CellID->1741],
Cell[28680, 1001, 5331, 92, 70, "Output",
 Evaluatable->False,
 CellID->45035295]
}, Open  ]],
Cell[34026, 1096, 121, 3, 70, "ExampleDelimiter",
 CellID->11694],
Cell[CellGroupData[{
Cell[34172, 1103, 181, 6, 70, "Input",
 CellID->8130],
Cell[34356, 1111, 599, 16, 36, "Output",
 CellID->1323430557]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[35004, 1133, 232, 7, 70, "ExampleSection",
 CellID->7614],
Cell[35239, 1142, 68, 1, 70, "ExampleText",
 CellID->26598],
Cell[CellGroupData[{
Cell[35332, 1147, 308, 10, 70, "Input",
 CellID->17139],
Cell[35643, 1159, 737, 23, 36, "Output",
 CellID->1409239520]
}, Open  ]],
Cell[CellGroupData[{
Cell[36417, 1187, 169, 6, 70, "Input",
 CellID->4762],
Cell[36589, 1195, 736, 23, 36, "Output",
 CellID->491469877]
}, Open  ]],
Cell[37340, 1221, 121, 3, 70, "ExampleDelimiter",
 CellID->26854],
Cell[37464, 1226, 209, 8, 70, "ExampleText",
 CellID->28448],
Cell[CellGroupData[{
Cell[37698, 1238, 241, 8, 70, "Input",
 CellID->23828],
Cell[37942, 1248, 640, 23, 36, "Output",
 CellID->912116377]
}, Open  ]],
Cell[CellGroupData[{
Cell[38619, 1276, 256, 9, 70, "Input",
 CellID->1224],
Cell[38878, 1287, 539, 19, 36, "Output",
 CellID->1201675953]
}, Open  ]],
Cell[39432, 1309, 121, 3, 70, "ExampleDelimiter",
 CellID->11114],
Cell[39556, 1314, 243, 7, 70, "ExampleText",
 CellID->18887],
Cell[CellGroupData[{
Cell[39824, 1325, 205, 7, 70, "Input",
 CellID->25960],
Cell[40032, 1334, 362, 13, 36, "Output",
 CellID->1631525683]
}, Open  ]],
Cell[CellGroupData[{
Cell[40431, 1352, 180, 6, 70, "Input",
 CellID->26245],
Cell[40614, 1360, 716, 25, 36, "Output",
 CellID->1980949285]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[41379, 1391, 226, 7, 70, "ExampleSection",
 CellID->31643],
Cell[41608, 1400, 228, 8, 70, "ExampleText",
 CellID->8819],
Cell[CellGroupData[{
Cell[41861, 1412, 257, 9, 70, "Input",
 CellID->19326],
Cell[42121, 1423, 539, 19, 36, "Output",
 CellID->1375653554]
}, Open  ]],
Cell[42675, 1445, 237, 8, 70, "ExampleText",
 CellID->24544],
Cell[CellGroupData[{
Cell[42937, 1457, 288, 11, 70, "Input",
 CellID->1863],
Cell[43228, 1470, 884, 31, 36, "Output",
 CellID->800338476]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[44161, 1507, 224, 7, 70, "ExampleSection",
 CellID->23360],
Cell[CellGroupData[{
Cell[44410, 1518, 320, 11, 70, "Input",
 CellID->17908],
Cell[44733, 1531, 5966, 102, 70, "Output",
 Evaluatable->False,
 CellID->81096756]
}, Open  ]],
Cell[50714, 1636, 121, 3, 70, "ExampleDelimiter",
 CellID->23063],
Cell[50838, 1641, 60, 1, 70, "ExampleText",
 CellID->30584],
Cell[CellGroupData[{
Cell[50923, 1646, 352, 12, 70, "Input",
 CellID->3925],
Cell[51278, 1660, 8031, 138, 246, 2144, 37, "CachedBoxData", "BoxData", \
"Output",
 CellID->1930399980]
}, Open  ]],
Cell[59324, 1801, 120, 3, 70, "ExampleDelimiter",
 CellID->6914],
Cell[CellGroupData[{
Cell[59469, 1808, 546, 19, 70, "Input",
 CellID->23130],
Cell[60018, 1829, 54622, 1007, 300, "Output",
 CellID->49524984]
}, Open  ]],
Cell[114655, 2839, 121, 3, 70, "ExampleDelimiter",
 CellID->30803],
Cell[CellGroupData[{
Cell[114801, 2846, 347, 12, 70, "Input",
 CellID->15399],
Cell[115151, 2860, 9282, 156, 70, "Output",
 Evaluatable->False,
 CellID->359116657]
}, Open  ]],
Cell[124448, 3019, 121, 3, 70, "ExampleDelimiter",
 CellID->27000],
Cell[CellGroupData[{
Cell[124594, 3026, 354, 12, 70, "Input",
 CellID->15651],
Cell[124951, 3040, 81229, 1357, 216, 11918, 216, "CachedBoxData", "BoxData", \
"Output",
 CellID->20385010]
}, Open  ]],
Cell[206195, 4400, 121, 3, 70, "ExampleDelimiter",
 CellID->10980],
Cell[CellGroupData[{
Cell[206341, 4407, 739, 23, 70, "Input",
 CellID->13888],
Cell[207083, 4432, 1782, 41, 70, "Output",
 CellID->775014591]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[208926, 4480, 311, 9, 70, "SeeAlsoSection",
 CellID->10219],
Cell[209240, 4491, 1439, 53, 70, "SeeAlso",
 CellID->21479]
}, Open  ]],
Cell[CellGroupData[{
Cell[210716, 4549, 314, 9, 70, "TutorialsSection",
 CellID->20339],
Cell[211033, 4560, 189, 4, 70, "Tutorials",
 CellID->31251]
}, Open  ]],
Cell[CellGroupData[{
Cell[211259, 4569, 318, 9, 70, "MoreAboutSection",
 CellID->78251594],
Cell[211580, 4580, 147, 3, 70, "MoreAbout",
 CellID->599567172],
Cell[211730, 4585, 151, 3, 70, "MoreAbout",
 CellID->241764206],
Cell[211884, 4590, 145, 3, 70, "MoreAbout",
 CellID->468120590],
Cell[212032, 4595, 177, 3, 70, "MoreAbout",
 CellID->218897649]
}, Open  ]],
Cell[212224, 4601, 29, 0, 70, "History"],
Cell[212256, 4603, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

