(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    122468,       2928]
NotebookOptionsPosition[    114066,       2631]
NotebookOutlinePosition[    115403,       2668]
CellTagsIndexPosition[    115316,       2663]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Continuous Distributions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ContinuousDistributions"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Continuous Distributions\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"TriangularDistribution" :> 
          Documentation`HelpLookup["paclet:ref/TriangularDistribution"], 
          "Piecewise" :> Documentation`HelpLookup["paclet:ref/Piecewise"], 
          "RandomReal" :> 
          Documentation`HelpLookup["paclet:ref/RandomReal"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"TriangularDistribution\"\>", 
       2->"\<\"Piecewise\"\>", 3->"\<\"RandomReal\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Continuous Statistical Distributions" :> 
          Documentation`HelpLookup[
           "paclet:guide/ContinuousStatisticalDistributions"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Continuous Statistical Distributions\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["UniformDistribution", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["UniformDistribution",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/UniformDistribution"], "[", 
       RowBox[{"{", 
        RowBox[{
         StyleBox["min", "TI"], ",", 
         StyleBox["max", "TI"]}], "}"}], "]"}]], "InlineFormula"],
     " \[LineSeparator]represents a continuous uniform statistical \
distribution giving values between ",
     Cell[BoxData[
      StyleBox["min", "TI"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      StyleBox["max", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->3480]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The probability density for value ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " in a uniform distribution is constant for ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["min",
     FontSlant->"Italic"], "<", "x", "<", 
    StyleBox["max",
     FontSlant->"Italic"]}], TraditionalForm]], "InlineMath"],
 ", and is zero for ",
 Cell[BoxData[
  FormBox[
   RowBox[{"x", "<", 
    StyleBox["min",
     FontSlant->"Italic"]}], TraditionalForm]], "InlineMath"],
 " or ",
 Cell[BoxData[
  FormBox[
   RowBox[{"x", ">", 
    StyleBox["max",
     FontSlant->"Italic"]}], TraditionalForm]], "InlineMath"],
 ".",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->19919,
  ButtonNote->"19919"]
}], "Notes",
 CellID->429991538],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["UniformDistribution",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/UniformDistribution"]], "InlineFormula"],
 " allows ",
 Cell[BoxData[
  StyleBox["min", "TI"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  StyleBox["max", "TI"]], "InlineFormula"],
 " to be any real numbers with ",
 Cell[BoxData[
  RowBox[{
   StyleBox["min", "TI"], "<", 
   StyleBox["max", "TI"]}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->10777],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["UniformDistribution",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/UniformDistribution"]], "InlineFormula"],
 " can be used with such functions as ",
 Cell[BoxData[
  ButtonBox["Mean",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Mean"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["CDF",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CDF"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["RandomReal",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RandomReal"]], "InlineFormula"],
 ".",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->14752,
  ButtonNote->"14752"]
}], "Notes",
 CellID->33143606]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->118102213],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->186429671],

Cell["The mean and variance of a uniform distribution:", "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->14752],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Mean", "[", 
  RowBox[{"UniformDistribution", "[", 
   RowBox[{"{", 
    RowBox[{"min", ",", "max"}], "}"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->521],

Cell[BoxData[
 FractionBox[
  RowBox[{"max", "+", "min"}], "2"]], "Output",
 ImageSize->{63, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->92315435]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Variance", "[", 
  RowBox[{"UniformDistribution", "[", 
   RowBox[{"{", 
    RowBox[{"min", ",", "max"}], "}"}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->21982],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "12"], " ", 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{"max", "-", "min"}], ")"}], "2"]}]], "Output",
 ImageSize->{100, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->118732657]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->7688],

Cell["Probability density function:", "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->19919],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PDF", "[", 
  RowBox[{
   RowBox[{"UniformDistribution", "[", 
    RowBox[{"{", 
     RowBox[{"min", ",", "max"}], "}"}], "]"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->17236],

Cell[GraphicsData["CompressedBitmap", "\<\
eJytVUtOAzEMTfNp2nKAlgVShZC4A12xgRUHQGLBqEJqhSpQ6R1Y9UxztJCP
HTzGSAzTSJPEjuf5xXaSh+awedk1h+26Wd7vm/fNdv2xvHvbR5UZKaWO8Zsv
VJyHOMvfMYQ4mtibKH5WSSUx5KYmqRsXmfY2DspVsUzU+BfrBFigS9PMy2Mv
3wbANCDZ6rprmr24igfue/h2DLBYWYqYOHjRdqh3TWKWek12TDjA1rO1pfmg
0XkSvcgZv2Lyc49/ixaZruLoWeYNqZvSECKRd7CI3DXIqPeg92RdV5+UyUrM
iWVWco6mzMr+iPhMsuhTAR00I+4gV6Bp2xbidJnDF2VYPxuwQw+xwzqbhv6V
jCfQipVwM4AdVsCMsEKW8pm0J+RTa4roHWHSzd0k/PMOECqAc56HUvkXoXuD
IlN6D9IzxquT3pU1jmyd46NOs3+1yPScya9/srpm8u0JsWWrBexiV1e/X77y
GqrRF7hRePA=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{141, 23},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->394866916]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"PDF", "[", 
    RowBox[{
     RowBox[{"UniformDistribution", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1"}], ",", "1"}], "}"}], "]"}], ",", "x"}], "]"}], ",", 
   
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->27065],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWr1OAkEQXti7Q1sqGxOCpY1gY2KMnVaWxtYLwUBBVMRX0GfQB7DQXluf
wcrOUNFLZXXMLnvcMvfH/SDLZQm3ezM3890wuzvfLXBmDzrtnj3otuzaad++
6XRbd7WT6z6oaIkQMoTjeYvAuQNn/Bg6DvT+1oLWAIMm9BT6tugbQm9yqwpr
mZpLhOxLMjttI7mB7KcohAoRXmVXlLx2xT2xHqM3kWxw2M2IGIJQ8GegOaJY
PCxPG5+xPZ+Hl/my8Gf9FZIt34jeIuRehLYM7Q8fDwtd30ByJeZ6qP3H+3ci
+6T4We1Ho99l4EvzQNJuI7kakyVsj69Xw+zFpwq9X2SU0/X1+PAposJzt4nu
csBRDhfyujh/ifVy5/di1unuUVQvnTudBbWzsCMiwyxPXc5LjFhnzRx34opm
LBGXiqcn1eNUB9edAZbU63Whq4POwnp5LTt3QUzB9ip5MoWJsFVnoKB9RhYG
Cty35BCnEZnp5HNAc0WRV3qRvXTu1M1CGMOkrzT/V2HzZgLTyVJhV8uA6Ufe
FFnTvLIKL50FnQW1szDHEObMm9uqXysZzuxXvLye6iWeZHGrxDnZ8NyxxgyT
bjSKthJ0PdBZWC+vVX0/ta67h0Vx316/jo+e4E3qrGG4QgZc1lFPQ6HhDMEF
wBuP/zy8S19cYRW8F2Ev22F56mc7XmVn/T3X+v8NQ0oT/4t+mw==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{225, 154},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->39625058]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->31496],

Cell["\<\
Generate a set of random numbers that are uniformly distributed:\
\>", "ExampleText",
 CellID->26386],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RandomReal", "[", 
  RowBox[{
   RowBox[{"UniformDistribution", "[", 
    RowBox[{"{", 
     RowBox[{"0", ",", "2"}], "}"}], "]"}], ",", "5"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->21011],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1.3794052475071847`", ",", "0.6467909036293302`", ",", 
   "0.6944792321882582`", ",", "1.651834791721217`", ",", 
   "0.368966341354271`"}], "}"}]], "Output",
 ImageSize->{329, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->72960747]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->7547],

Cell["\<\
Properties based on higher\[Hyphen]order moments:\
\>", "ExampleText",
 CellID->20699375],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Skewness", "[", 
  RowBox[{"UniformDistribution", "[", 
   RowBox[{"{", 
    RowBox[{"min", ",", "max"}], "}"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->12121],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->240316009]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Kurtosis", "[", 
  RowBox[{"UniformDistribution", "[", 
   RowBox[{"{", 
    RowBox[{"min", ",", "max"}], "}"}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->6702],

Cell[BoxData[
 FractionBox["9", "5"]], "Output",
 ImageSize->{16, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->217910278]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->31539],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  StyleBox["q", "TI"]], "InlineFormula"],
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
 " quantile of a uniform distribution:"
}], "ExampleText",
 CellID->2572],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Quantile", "[", 
  RowBox[{
   RowBox[{"UniformDistribution", "[", 
    RowBox[{"{", 
     RowBox[{"min", ",", "max"}], "}"}], "]"}], ",", "q"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2257],

Cell[BoxData[
 RowBox[{
  RowBox[{"min", " ", 
   RowBox[{"(", 
    RowBox[{"1", "-", "q"}], ")"}]}], "+", 
  RowBox[{"max", " ", "q"}]}]], "Output",
 ImageSize->{113, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->12885900]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->19359],

Cell["\<\
Obtain a random number from the inverse CDF of a distribution:\
\>", "ExampleText",
 CellID->58263126],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"invcdf", "[", "q_", "]"}], "=", 
  RowBox[{"InverseCDF", "[", 
   RowBox[{
    RowBox[{"ExtremeValueDistribution", "[", 
     RowBox[{"2", ",", "3"}], "]"}], ",", "q"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->414756667],

Cell[BoxData[
 RowBox[{"2", "-", 
  RowBox[{"3", " ", 
   RowBox[{"Log", "[", 
    RowBox[{"Log", "[", 
     FractionBox["1", "q"], "]"}], "]"}]}]}]], "Output",
 ImageSize->{115, 32},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->870878425]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"invcdf", "[", 
  RowBox[{"RandomReal", "[", 
   RowBox[{"UniformDistribution", "[", 
    RowBox[{"{", 
     RowBox[{"0", ",", "1"}], "}"}], "]"}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->643111847],

Cell[BoxData["6.088804877323454`"], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->251302002]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->108450639],

Cell["\<\
Plot the cumulative distribution function of the random variable:\
\>", "ExampleText",
 CellID->29591],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"CDF", "[", 
    RowBox[{
     RowBox[{"UniformDistribution", "[", 
      RowBox[{"{", 
       RowBox[{"0", ",", "1"}], "}"}], "]"}], ",", "x"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{
      RowBox[{"-", "1"}], "/", "2"}], ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->25867],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJxF03lME3YUwPFSFJ0DM9ChSKhrUcZhdThCgdFhCYdWEUVQXMe4RXEBAhLQ
AQM3jiIjVsoN1jJQSpAQZVKnHHYuUsY1OboSDkcpYIsglEJBaLdl23u/5OWT
75/vJT9yWKxfJJFAICT9Pf+oqqSJdbrxNsJ/r2j+/ECsCtuJkTI+PoWdNtmu
buvG3mbHpKSXY1OEX35DoGGfeplB1YsZg6436OIQR0agP+RaiCOuSKF9QnY9
ZHsNQTONLufXWPdDv2lZaWTk90LLxy7VtXwuhnY9djZDEyWCdlHMJrqHNUMn
XKuIojfXQPNtwmlcJnbvHzZblKPV0Ha05rslm7Blqt/lqtNV0DXD2zv8pZXQ
Ee2T7Qc9bkKn0yfbhYP5eM81rW6H5Q/QtQkOaZ0tbOjsC7xrNNV1aFP7wW7P
5EhohXc6N5IVBO3Hqt/zbZ4v7l8eYt+VQ4ZuMlrXM+vwcvtfc7J1zuHVQLDB
QuB9wDsc1JRf+tgmJg7MoTgI4vsTwN0Cre1TpyTQ+VHBQV/9NJA+M1bm0pUJ
kgzjiNrQbFB7SC/62UoO2Jpk6XzUMg+8o9+ktKVzQEqBhu3ELQZ3SI/IbMhV
4C6NeK9nbwO4UWywZWLwCVjcV/rnacFzkCMJ/oK61AkWdQ6u7ZP1gbc7yOdc
XQdASfavBA5LAoZQ6j/Lah0G96QpfhFOj4K3hn+a86x7BTZliolNgRNgjDG7
5YhCBvZtU7RXVsrB3yaXo80cpsGInrMVpaIZsHp/oKkiXgGmBm2mnTeYBXVE
/zslT96AA2zTRh8RWvuBtI0oRk+Rvhr/egitcr5IYiygXnEpFa+t5sD80eoS
l1toWERU7XwJSlPaCKt56CtNg2T7ffTwzsemshfoELObe2MDJQnVN0cuzoOJ
c37mpFi0a19jTXAiepUT/fNEBjoQPS6bKUPt+K4xtnz0uqRUc/ke+omHv9H8
Q/SGhdhR3YVOnLF65tiPOuV+dzxZik4t00PeyVE6tVzhOotywzVX0hZRZWmA
rk2Duvc9YOvp0BP6W3P5xLdu//7et27Jtx19RZuxf3SO3Cnbit0zUCDVN8Te
//5CuKcJdgrj5FzWbuxPl2iMAia24i6Zy0vBFkVZnDjwGrvU2mzT44AF6MKy
Cy9CP1qEDuYG9RhOY2941KzyWlXQM3L3ZFH2EvQ9ur15d6ga+kFmonEUdRk6
LyD8uL4a22WEL8juXoF2OOPIKi/WQBMzzO2L41eheY51zMJja9A5I/nNFJN3
0J7Oz4+WKLFPZvlSKx+tQ1uxvg+oTt2Afjn1XlVBgBa6M0zOMNmrgy4qNDa4
uoqd23oo5ek6duq0z6JOh/0XuVcRFA==
     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  ImageMargins->0.,
  ImageSize->{225, Automatic},
  PlotRange->NCache[{{
      Rational[-1, 2], 2}, {0., 1.}}, {{-0.5, 2}, {0., 1.}}],
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{229, 150},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->326071763]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1675],

Cell[TextData[{
 "A contour plot as both ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  StyleBox["max", "TI"]], "InlineFormula"],
 " are varied:"
}], "ExampleText",
 CellID->12136],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContourPlot", "[", 
  RowBox[{
   RowBox[{"CDF", "[", 
    RowBox[{
     RowBox[{"UniformDistribution", "[", 
      RowBox[{"{", 
       RowBox[{"0", ",", "max"}], "}"}], "]"}], ",", "x"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"max", ",", "1", ",", "5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->30499],

Cell[BoxData[
 GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJyNfQmYzdUb/7135t47+8ydoULZSpEoLUjpHHsqilKJkCWhVEr7QhSSKEmW
7PRLG7IvFUJkG7sxtoxhNrPd2bf/veeczznPe+7zf/7/eb7Pc73O+Z79vPv7
fhsNfrX3MJfD4VgR7XAEf+lfHtvwypn1r5w5wSicruHuX98SePKt8mINNxEV
Kq36Tg5Y/oZz+r5Hw6OD4PpITtuL0XBqsPiVeA3L9n0avkX8R6LVXy0Ldjhk
Pb+eL4XTNYz50vJiDWO+tL6TA8Z86fseDWO+tL0YDWO+tH2fhjFf2l8tC3Y4
Hhbvlen5Ujhdw5gvLS/WMOZL6zs5YMyXvu/RMOZL24vRMOZL2/dpGPOl/dWy
YIfjZdFPlZ4vhdM1jPnS8mINY760vpMDxnzp+x4NY760vRgNY760fZ+GMV/a
Xy0Lxv46Od1fwOkapvuL8mIN0/1Ffewv7nE4p+97NEz3F+3FaJjuL9r3aZju
L/qrZcEOR4poJ0zPl8LpGsZ8aXmxhjFfWt/JAWO+9H2PhjFf2l6MhjFf2r5P
w5gv7a+WBeM8uzk9z25Oz7Nbz5eWF2uYnme3ni9gep7dnJ5nN6fn2c3peXZz
ep7der6A6Xl26/lS2OGorgn+efV8KZyuYcyXlhdrGPOl9Z0cMOZL3/doGPOl
7cVoGPOl7fs0jPnS/mpZsMMxQ1SM0vOlcLqGMV9aXqxhzJfWd3LAmC9936Nh
zJe2F6NhzJe279Mw5kv7q2XBDkdj1S7mS+F0DWO+tLxYw5gvre/kgDFf+r5H
w5gvbS9Gw5gvbd+nYcyX9lfLgh2OtaLfOD1fCqdrGPOl5cUaxnxpfScHjPnS
9z0axnxpezEaxnxp+z4NY760v1oW7HDcLOol6PlSOF3DmC8tL9Yw5kvrOzlg
zJe+79Ew5kvbi9Ew5kvb92kY86X91bJg4GefhZ99Fn72WfjZZ+Fnn4WffRZ+
9un50vc9Gqb42WfhZ5+Fn30WfvZZ+Nmn50thh2Od6DdRz5fC6RrGfGl5sYYx
X1rfyQFjvvR9j4YxX9pejIYxX9q+T8OYL+2vlgXjr5aeL4XTNYz50vJiDVP5
qJaeL2DMl77v0TCVj2pxKh/V4lQ+qqXnCxjzpf3Zv34mXuteoPjXMrZezQOw
5E8qFP9ao+hrjeJXXfwr8Q+XGo9b3Zdw/ohoOJqfFv8frfqL46NEu7Fqvrt1
/1h5wLL9bKvcr+VN+f9JnJbX0jDal+NP0vsLGO/bMN2P3bo/jMfuHzCtb9YZ
7cvy9VoOEb/LkvQ5Qrn8Uf8fKAeM/bDlN3v98P+i+iu5If3R8a4PGS/6o+WY
f4GlF7DvgcNhjx/1MH57P3HecH/sctmvX58/1Mf9AizPWwWTx7NE18f5Rf84
v1QeMOVUHnNx1Ed7OO+4z3Y5lX/c+n6gPdwPOb/wkHLIA3IdInR9tLdO4QlK
/0w55a/j9P3DfcT9Az6xyyk/lKDro70qMd14jX/scsp/lIXoU9aTfS5V571I
7zf2g8pvFbq+XK9yvd62/I79kO1VK3pTrffTlnex/nJcoL9m/2z5EOst5wd5
IkyvXzfxG6lh8MPYT6w38Dtg2V+UWr8ovZ42v4r1lu3F8q7iH7Ec9x33VbZX
pO8rYFmvUMNYf9wfG8Z6A75ZrTNgrK9sz8FtWK67gwPG+srxh4XAch9cGqbr
6wmB5X66+UbxXrReP8CyfrSGsV5y/eNCYLlf4G9tvWCBXj/ANv2k9KHUWv8a
RvVX1SHnGe0Bxv1BfewPxRcVGsZ9wHmm++G28JXb0ueEW/sRoe8HYKrP8Or9
QLmNnwBjv+T6evT5xn0BTO9LrN5P4CN6XxLo/UhM0PuJchtfAcZ+n1L/j/FT
/YVXjxftEXkq0B/ex3nA/uP8YL9xX2x8Zd8XGz9hP3B+bXyA+cr6F/X5AT8C
fItywHK82RoGPgD9pPxThX6fnrdsC1/v1vgX9Sm/mG3hZ7+G8T6lrxcZpY/Z
GsZ9A4z3gZ/xPmC8T+mvn1F8XqZhtIfzi/YAoz3AaA8w7i+t77Lux26G84/2
AaN9ej/8GsZ4AaM/wGgf9wXtA0b7lD/3M0qfyhi9bzXW+y7rPrq53R/uG/oD
jP7ofSxj9L7WWO+79P1F+/K++HT7gOn981n8s0/fd8Cg14DRvrz/ibp9wGif
lrs4YKwHhRM0TO9Tkm4fMOVfk/T4qLxSqukx6MMtit4C/4Oe0vNdqe+7ff9B
j9A+7jfax32V5VWqHPSkXK1vFZP4qkKtT7Wsv9ehxq/oTWvoo4x+0MZfoH9Y
L+BXyOOoj3LUl/PNsOh3tsWP7g6xj9n40pa3bPxp29tsfGjbo2x8atunbPxq
26uwPzh/tHy3Zc+5yKi9JTvEHmTjYxu/0vq7Q+wvNr627TE2/rbtMyin/L+x
19jjofaWmhB8Te0RF0PsJTY9oPKSP8R+YtMHSg+clvxVwyj/4LLsK7st+8RF
Ru0H2SH2DZu+2PYOlFP51qvHY9s/bHpE6Yeb2/SD6v8vMqr/z2ZU3+9n1L5Q
FmKfsOmVba+g9M8VIj/Z47XLqb1jN4O8hPEDxvip/OrXMMYPGOOl77s4LXdb
8lmEpe86wSicHjI+2z5gj9e2F9jjt+0H9nxse4I9P9u+YM/XtjfY86f0PDJk
PVAOembTc6qPz2ZU/+5nVN9fxqh+v8biB1yanmO89vgAY3y2/cAeLx1PXAi/
QPXr2Yzq0/2M6u/LGOUHnLo9Kp/5LHzis/Q9Puv8J1r6B8N/0PYTLPvARUb1
5dmM6sf9IfwJbb/Get/FaX23hqn9MVGvpz1+2n+c1V6ChjF+Wa+WHj9gSj+M
PhXlGD9grCfltyI4yjE++n68ri/5BF/IeFEf5YDl+JO1fkH+5moY/VP7ZLLm
G6CvRX3A8r0C3R5grA/eB7+E99E++C35e029Z/TdeF/+btfl+H86nzzFPxXo
+mhfvleg5U/AchpGPwhYzqNUy8+A5XsOzR9T/5saRvV51Yzq+2o0LMfp1PoN
wNA3Aab8iFvb+3E+KD6N0/gD47PnC/4OsM2vA6b2U1NO+ccStd7lWr8gYaO/
Boxyyo9FWvrISK1PQ//YD4xX/voZ9D1yPF6t/7H1Q9Cv4PzR8+a39OkOvR9U
X2/4Ldu/w+Zn6P25yKh9P5tRe76fUf+BMkb14zXW+y5Lf+62/AMiLf2UW58P
3G/A0PdAHwkY+ibK/ybo/il9jFP7mWCtl7Ev2/IwynF+bXuyLV/b9l1bHqb2
WXeI/dbG/7R+gmUPLtb4m/pnAf/7LPwLucehzzvBD3txHxx6f7Bfcj1i9Xmn
/kDRWn6V48f+77fw33aFV/M1/rRhnHdZP0u/j/No41OKV/N0e4Apvs/T76M/
+n6uLpftXFP4AjDsw7DXFKr7WCT1l4m4j7BrVzPgE8C2fhn4APYOnG+sN84r
9hv4EftD7VXFenyy33yNN3CeqXzl1f2LauPgH2T00xKO0PdHtpugx0vx3269
flhPez8ofb2mxmXwG+gjxkf1hw6tr6f0SPEp46Cnd1j+a8begfXC+hJ9XQ78
RaI5xkvocWKeHi/2n6zvXgftv7Vpj/JvHj0+Ks9G0v1wRGp6QPntcAsfua3z
g/Uq0voYjA/nj9qPvHq8uO/UfgR6nab3BzDOI86f3LdSvf84/+J89IvU+EG+
D/kc9Hm/pc8y9BL0lNqL/Ba/kGrZ49MsfVdqyPhBr0FvAWP8drk9Xzm+Eo0f
MH/Zb7LFv6Ra+qq0kHLwL+gP5RgPYJTb/A74P7QP/g3vA8b72B95bkt1ObXP
OHU56qM98B90f9z6fZRjfNTeVc2wv7L9MOv8OjT+ke2XaH0q7ruEwzT+e1nR
degXsN/YD9ADrDdgrBelPxcteSI95PzgfaynDct+/Jp+4X20R/F5muVvlGHp
VwtCyml8QKrlv5Fh8b8Flv7ar88P9pfaQ4v0/tP+zXkBPqHn05RT/rk6BLbP
C/Yf7+N8AN8D/+G84Hyg/GWFV6n9NlLTO8A4D+A/sf6AsZ6gx5gftY9n6HKs
F32/QJdjfijH/Oj7Dk7HU80oPxCmyzFf2r7Hst+H63LM364P/hn0htpvvZr/
AH2hsEPzAxgfYIxP7p/Pwgc+i//x6f5RTv0VfLp/ud+J2t6M9ym9S9Lrh/rU
PyJJ03+Ug78h5XsTNIz+JD0w9iYblv3W0uuHcsAol/jLp8vRPil3HNP6AQlf
C4GBb+TvVYvfy7H4lRzNz8rzv93ix4CPbX8fr6U/i9P4FvRbrpdDyzmg9+B/
5Hyx/l4+U9SHvs7LnaIc9nz4S+3V4we/KMeVr+cj+zP8mZx/ga6P+dH1U/xF
P8gb+ZqeAx9j/OAfgQ9AH4C/aftpGt9jPzA+4A+Uo75tT7P5D4wHMK2fbNk7
0zSM+jZ/QPU/0FM4rPtj6D/KAVP7WUEIf2Hbq2x+AvQDsK1/ov5MFSH0Afwu
8A3KAdN4nXBO6UkYt/kN8L/AV6An1D/L0BPKj6SG0AMb/9v43sbvNj638Tdt
z6th6j9k8DmNZ4iy6Emk5c8VaelbYjX+B/8EfgPnjdwPHZ9Uo8txXmi8Uo11
PxzanoNyej8cun9qT02m8oSOrwjX5TgPVB8Ybp1vE09G7ZfJmt+g/vzgV9N0
eXd1D2z5lL5/wvJnSWY4T2if+rOkMcqf5OtyrA99v9jydymyyk9Y/i7JjMrr
6Za/S5ouR/8oR/+2vpP6uxQxqh+qZFQ/UWG177T8ZRwa38rxhFvyepilb/BY
+g8Pt9un/jMOzb+gfWrvCgvRt1D7EPTJJl6F+stUWOUxWj8IfgblWF/o+7C+
4EdofFui7p+Weyz7kEfzM2gf+j+0T/gNHa+ZpMdH+ZX9Wn8D/Y5sp1Dr58CP
gB6DPsr/z7fKCy15ucySV8u0/wz1l4Y+skzLf9T/3cWhfwP/It9zaf24qNYa
9vNwXQ58AHyL+yzbc2t+BfgU9lvJv0D/ZfyPqT+X0TeDvwA+BZ9G/YsKNT9F
65db+gbDb0HfCJj6b+eH+OeiX/BjFH+Va/8kKo9hfxwOmx6AX4F9zdbHoBww
lXcRf1Kh3we/gvapv3pqiH7DLsd5AT1GOc4/YCqfOzS9pu0VWPQq2ZKHU0Ng
nEeKb8N0uQ1TepRu+ddk6HKKX8M0P2HDqI/+qb4ljdn2JRum9C3f8tcsYFRf
7dD81XrFv9gwbS+ZgX/CeABT/Bdh4bsIPT8bBr0DPqb0tJrZ8j6136VpGP1T
/+oiDeM+0HKHtgeCftD6Hg1jf6m/BfR7Jh6U+ncWMJseUXpVymx5nPpvh1n8
XLqmV3S/DX2T+5Zg8esmvpT6X3g1PQP9QH3KL/is82viO0G/cF5seR31qT9h
kr4/oFfoj8jrOp7J6ANQH+O16+O+y/VD3ICB5a+hR1Rf69f0jfILRj8M/STa
A/9L/QurtP8o9WdcH4JP5a/xB0U5xW95Wh6l9Hx9iP7Zlkdt+RP4X9bPDpEH
bPxt+39Se316iPxK9ZWpev6YH20/P0TetfWfNH4tW9fH/aLlqZZ9LsPC79ka
3kDWwWGdb+P/i/OD80LhNEueSbfshWmWv2iqlpcpfnDp8dr6dtp+sYapf7NL
t4f3wSfY9IXm/yiz2qux3k+z6NFFDdP7avxR7XKbHlL/hoIQewKV9xyctm/8
VVBO4x+qGbU/1DCbnqF/8ZMDfy635i8B0/No/Fkp/Syy5M3ikHKb/lL66dcw
lT+8Fv7z6nK0R/kHr54/pb9ubrdP9SFlGsb62P6stv4E5agP+ijn59Iw6lN6
67bqey36G2GVp1r+nhmW/2hBSDmln6Uh9am+vJpRf85SXY750faN/yjKqb7d
FaJ/t8cn34P8Gmn5s0Ra8q3x50R7eB/9g75S/GfoJYXDLf+/ME0/8b6sV0vL
j7KfAks/5Nf6WJxj0A/gAfn/xyx/jWMh9IvSv+26PcC0/+1WfESWbg/3EzDK
7fHIX/iR7A/xQ0F/Atxr/Pjk/6OfUg3L8Rh/EsCYh10O+g56AvlMtlti0Zdq
C1+DHw7T/AzkR8jPoG/AZ6gvmhvn1PhNvh+rz5Psz/iHYD3AX2C+8tfA4HfA
HwGGvAuY6mNMuc1/oX2qT3Jy2p/xzwOM9QY9p/yY8aez/feovs3AKKfxacbf
DfYFxPtQ/33j/wYY+hrgB/hryPbitb1EzlPdF474Y6fef9jLsX8k/8uyWDU/
wBGq/Wi9frhv8nxAr+NnsOfMUOPGeHB/xW9inrbfgD4CRjn1Bztm3YOr+v4B
n9j2EJofLk3D6A8w8DW1n5dY/gPGn4D2B/+uNA2jfRpvlKzvH+6D7U9L2tP3
y8S7UjhZ8z9UnnNzOl/wN5cZ7ivVD5t4HvBraJ/yA2kaxvhx/jFflEs4j8Ge
R++fibcBP4X+aLxLmobRPs2/VaRhal+KtPwHEO8OfXOkXk/bvmPH26Ac46P+
qmkaxviof2uRhjEeWu6w/CnDOK1v8nMBP9j5wgj+COw/jXfOt8qLNYz1ovWd
ln0onOKnM8afAPiCzCfHxCvSfFomPxmNF6lgVB9aYcWrOCx/8DArXxXOr8/i
R038B/X3Dbfok4GBj6n/bmSIPwLah74AMPaf+ucWWXCNHh/oMfgtev+M/zH0
IfR8GBjtU/9x4y9M419iOe0vxvKniNf9wf/B9odA+5iv7MfEj6Cc4tMky36S
ZOGzJL3fkp8xMNoH/aPxM15O2zf+HNgfvH+Lmgf6k/QqUfcHGPWBf9cr/gnj
BSzmW+zgUrx36PMPf0bqv63u81Dkk4nR8S00vslH93tvAqf2nd3/F/sK4oFX
WPEn6ym9/Xqr5gcAy3byLH5J5RvqB/6nWPOXsr5D8YflCv9XaX8RWd/I/xJ2
aH6DrN964/9M408Mvynrh2t+RNY38SEYL+g19GtUfi7R5eA/wa/IcRQqfqVc
3b8qRu2TNTpeG/YoKk+bctgLsF9yG4w9hKyvzudQrsvt+GYaz5HBqH7Cr/UR
sn5BSH4Fqh+oDsl/AHwMekLlw1RG5c9URuXLjBD9tK2Ppu3v1vpm9Ef1x6la
ngUM/EvtHz7r/vt0+7g/aJ/GW6QyW77F/ZL9OkPun13f1h8DlvcB/gTGnkn9
e8u0PALYzt+EcolPwM8ofXAx7HlOjU+kPgDxOtu1/CL3P5P6NwXOF/hbKS+U
qPUos/xHnZY+z2HZB4y+kfj3JDose2qB5i+xXnY8EvhR1Lf1Tza/SPRj/cJ1
fAJg2GcB4z5AHpH8SIS130a/ROO3vRacquN/sR40H2gBo/4zpVa8cHWIvoj6
59SE6IvsfKVE/kuMUvJfrIZhfwZM9VWpVnxwBiPynta3+vR8cB+BbwDT852g
+Q9qn/Jwu9zWPxF+LkA/R4p24Z8RFRJfgvrwP7TxhZ1vlPIzGdb9z7bsUQ7L
H8Np+ZM6NL7B/tB45XCNL6i/seFHCf+VmBAC0/qh+Ifyd9UWHGnxawZGOV2P
SIv/itL8E833YuKZJRoB/jN5b8Efohz8JGCU2/G/KJfz22/pXbZSfd84nE8V
L5sD/FOk6T2115fQ/Crav9rkk7LxF/RblF83+dCJPWOcU9en5yFM8ysSTtD6
EugPqD2m3IrHCbPsE2FWPJ5L8Ue4n9CfZmh+Tr6fZeW7y7T4vQwLDo13pPQ3
zroP8SHlVH6qDol3pPJLbEh8Iy0v1fQV+ILGN64I0f9S/e1WzR9jPKBnOB+y
Hzu/poqnaO2l9OWMx4JPWPrXY5r+UvwDfuyywjfGvkX9HfIY9GXUvz1G43PI
07g/5P6P8+n7ivNG9df5lj6tjNqT+5VZ/Lxf+x/JdSm0+BejX5Xjz2U0/rZI
w+CnAaM+pS+RGp/L/sK4jZ8pPioK2T+Mh55n468F+gj5EPQJ8hrxn8iJ0fIG
zjfwnfz9W98f7B/WBesNGPgL8gbOM/wTcd8ofFXr6yj+MPwR7Fs0H7rRd8nz
E2XdN+PfS/iPHKM/Br6R43RofAdY/PZWctp6E9+I8aM94r/5V4zSf8fo+chx
FOj1Ad8h+zf6YciLsr6RHzEe6m9RoeUx1Mf6AAZ/LffXofEL8W/N8Wp9N/YH
MPgHys/5GdHHB/A8lZ+y9XlHe4CBH6l/S7olb6RZ+pOLzKbPND6lSMvv4Pcl
bPInAH8Dtv2BKD+RYfmfRln0PsqKN9+u7wfwLeRlwMR/b5xTyw+AiT56WYTW
p9D1sb/3Ye4HzX9UpfW/gHE/IF/hPEO+oufVZ/F/Jl888K/N/5F8C/3CdXwL
YOoP4OVEn5zj1fPFfblF8UOACZ4Zl0/tKTleGr+c47XyjVdrexnN51Wp7w+1
r1Xo+wV/FtAHwDS+JMrKxxAV8n0EiTcLtf5Kzsvos4AfaHyK37IHFmkY9Jja
45T8OQ7+Ywam8SDI1xep8QvOC9YLMLUnVDD4B2N/Kf/v1f7BiGei+qACzZ9i
PQBjvrgv1F7p1f4rgEm8S2uvni/mZ8cT4Dzh/Mjx5Gl+ieonqvR8IR9gfzE/
0A/sH/AiYMyP2neL9P5S2K33B/I75kP9Ad26HPwZtT96+Nw5wb/TIfFaH+56
5oNdzwA/mXitJ7xjA0+eho91uCn4aP3JUQGHxmu91j7q5NLXilhc5qLAY74X
Bv7kRfEHP0FjL3xYvQ8Y607LzS/6667gu+8J/lVY9kVjN8yvPTDwGHvhy+qe
AP619PPfSj838VKyvaNa/7Jf/IXa7447blzZ8X4Pf1Ms2HGNbyV8WcO/iPaN
/Q7jSpj3SKeDH0Kvb75/s07tD+Buar603Hz/ppHCO7S++f4N6Ah939jXcC9o
ezEh9rZbCJyuYexHE1JerMuBX28l9c13wbCe9H3odc33eWh7MRztyfNk7GW3
//Ff8z/+M/ay98Q5r7TsT+F8sWNWTf5KlJvvo8So82vnr7nj/eT5G8+g3BOS
rwblwd3+rTTBskeZ7xBifSoe6Nvi1RhjvwFM437M9zsWPs9fvj02iU9o97/A
c5Qta3TloS3jShnOB/a9s/U7s2WDSd0zjrBagxa9UDnXy+933/nDhcvH2Ibf
J56tvC6K+x7tckft1WlsyU3NE7qmRP5/n0eck7VqPoAbqPVqqOCuahwNFFyp
ziPgNWr+9RX8ktrvmxScpH5rqd8M1+AnR/wTxns88tn5mA8SOD//Qtlj7SvZ
qYEXWqUu9/FnC79eGpUXzXtkT1hUNNbHv9hR1LT/9GJ2fvUFR5v9ifymGaMa
zxjl4St/Df4l8qNZd/b0fJXLspNmDxyyOYlL/FbG+vxb7+bvrlawy10GpHUZ
sJ/1G9vYH7c1n+1bWLl3YWWAnz3Ya8K8+gVM4te9Gr8eEPjCfA9EnNvELSwj
eGyu5bFeCr+Cvsv3N+n6X5Qdm1r2lJ9dGDM78BSzIQpvNnv1i0FL/qxhzRrs
rtq8rIytXb37Du41efU1nvS/vea5AS4ec+S6b7e9FM7T+v757s9TXHzrA6Mv
3DEnnE878dK0E1ej+PzXfz+8LN3Yx6kcaX7/uPJt26L3C1nc7C9r9T0Z4HeG
X58wL7OETdnSfs+ub8rZv2K+5vsKj7Wp3jZ2YgRf+eZbGzs+FM0jh8cs7zK+
gt34/ORFnb+CfQh+pObXzmf6aAA7vuUsY8Hb3PwP4/8NfmxXn/otb2pWze5b
9fZjsdkX2fDLt/3dtyxf0Zlz7N604EgL2fiGEZ80jNjBqi4PrL48sJj1LYt8
/emPdrBbd59of/OjJWzFwPLlA8svsgFXPw08xcz/6J+BJ5W9WlMceErYMNFe
Jhvx7pDwpKoiNZ5rbKSCg9jjg11ZLOLW8sANLmGj1nYdtfazItb3pd6FzuwS
9qSz+pMt6bvY97uilj7Up4ItF/3tYh3bTuzUdmIF69Q5+HeBLZv9S0x1Euxf
F5i85xXsx/hpRYtXZ7KOniMVb/xSzs413XK+6ZYstlP8VbD5FdmBG7GXOZcP
LT3wVw3bLf7+Y/fU//PAhmdrWP273v8r25nLhr/2YL+pnhqWOjSqxc4emex/
Ler9W/dNB282e0zgKWS5zY70mdHWwad2Wv1Fp9X7WVf+73tvVDv5mgFzu7XO
OsuaurfPyd3o4itfbjs4JSmHdcq8bVO7O118+d5LBxPfKmNcwS2GdLvli6Vl
7J1Gqf+dfcLFi8adDnsx/jDbPH7Sog31wvn7At9eYOXBYY8I531a39gqZ8oF
tvnLFsWtV4dzud5+Xd7kNddtr7nKWAr/IfbNlHDeM262c+GN/7EeW0q+Sv7R
w/sLAp/Fpol77uHPtAhelCx2LuaDiBHRXn7Hv2sCTwGLWj8oev0gL8+59e2Z
W/YG5MUfTnoWrvfwoTN7tD491MXXfdel454aD3c16JiyY80llttx464tiyP4
xJsmpI45lcMODPdve/pSBL/iO3RgVW0/m5gffvvlepH80ey/e2b/Xcru37/z
wf07I/imu5+f8+tjgfv6YO0FUY/ju2PV7G9xUCL5uG1DRg7KLWdtm+1IXZsX
xTe2u7Pl1NYOPrJNyg8zvNH8s4Wzcz8odfH8ZfOPFNaL5oejtwWegJx3es8q
1jKabxg1YMxTzkz2eWWyb02HBN7uUOGDhwoLWLdN3zy66Zt4vkscxELWvvqr
4c81SuB/b2x46ZMvylj2HzP+ic+N52GbP3yw96Iy9otn+Ynx4Qn8sbPHepw9
VsNGbjsxatuJeN71ibk92lS7eO09d5z/4cd43j9Idu7PYvcO2Nw9xuXjH0Y7
lz41M4stfzS9se8hH+9+ZU2dJW/62dG7hq98KNbHWxx2BZ4K1rjlf4Engd91
+9K7b1/q5Y0U/Oc/cZ/+UieCH5pwfO2XbXz83xkF7ec9Ec1r7x5VtyjRx7P/
fH1UypFUNnngH2+1C0vk1Uuemrnn+7MsqvmSthkTE/m7X99Xs+W2HHas9cLf
7m6XyKe93mG3u46LT3L2v3/pDYn8+NjnT4593sUvCbydyDvOnphauMvNndWs
9FSTRD5w26pOV15P4P6NXZfv65LI62X4Uy4cPcd+HffjO290SOLH3mS9Hu1x
np28+9f6V2cm8dXNt6xpvuUau2fRCMcrrZP45k7xM87nVLNFL/uHNXkqib8h
CHMNy220rMUd7yfx64b/9Fxyi2g+ueUCb/jIJJ737Gvj6qVXsdv//PfzZfMd
/P7gtR5SxQQ6fxJ6dxM/UyIZiBD76MjEbw+/U1nODjz65e1/PV7OGtZbduLz
B833be9T+O66ILubf1zTF8nP/6X5ecHe3nMpRB6g71/W7wvyNCfDau9CSLwN
+H/R3ryrTDQzy/gTJzc+U/bRSL+SH/4Oya++kdAdk299m0C453R9SWZM/A3G
Bbi2mr8dbwM+rraaH8ox/ltV+eOKPtv+CPS7bX5dX9bLCsmffjXAnZ16yqHw
mcmnXhXbefCdjxexXVktFvh2OvmswZ9cu31XAWtcVevFpD0uXkuND/Eozwv8
dl7LN1+p+aJc1jfxKylKzkT9G4UAVxWSj33DpcUTV412c8wX/hVXFwkJTstH
+xR9R3nfpouGFJ4tZ59ffaTR0GEe9b6JH5H8im3vzmYnBw38Nfywie+g9N/k
M5fyV6GWv06rfUD5q40GfTOywMmj1zw25e1lJv4CcsJ34ryGxl8s/Gr5pHtb
RfEj4vyZ+Au5Py7L3u3iN7tyt86bDHnO5BOHfN713quF7wfk/k8EnTb28vs6
fXNw2D0BfmxpyphZ98bxBF/wz8V/Hd3rwwfqx/GedyeOXud287e63LMrPiqO
57V+vr+z1Ms3718x7O+SWP604CdO6ngKCV/RMBfieL5VXqLhkYpPAlys8An0
T/J9E4/xu+IfUS7w0wSTzxvr0fFOf+CJ4x1rX8rYHuPhP18Z7d85Lp63FfUz
GZW/CkPyc0PekucjNN92/6fOfzkpMYHPFvtn4jX2ivNn8m3L/ow9fGn2R4En
jrc7kB94EhR/YfJr4/w1V/IZ1Q/4LP2Cj0+vOhV4wvmBjjPnxg/y8Xri/rhD
7NktVHtbFX6CvCfxlbFPd5u4IuW3lmH8noXDBt52p8lvfVnRp2/VfKFfnr9p
/M+Dp8byT2P/S9/7diIfKtYrSsuT15Xcev6RH+P4qM0lPWuaQT9+QcuXUv/i
5YJ9Xp2k/PRMviXYL5f1eey5XcuS+ACBX0x+6o/W/XP26FIfX7zqg9xWc429
evsf/SMXnUxS5+Mgk/JoIRPL/cEhFhCWcoeuK2Q7BXyNLVDlUh+Xy8Q1mVDI
3l1wJfAcZWME4wn68yeLD477QiGrL9Z7m6X/NPEn9yj9DOiXpKc5ip7mMUlv
cxS9hR3lX/2+HK/JB/Bk3pioAX/ksSkxy0quzDV5AU4I/U4xE7fncxNvEn/1
5n2HPytlE8N333z9ymq2/KHzcy9/W8IyXp8yadZpB39G3UfIK3J9TX5p4KPl
Yv3DeDNxX0x+aY9Ax05+S1CcyA3jkm8MzSd9SuFTJu5zbEj++UXqvon7f2cB
O1qwO8AZlrG+S+97bunYAibPd7mW++h3I0w8iVwfB5frY/JDlwt9RZjSdxj7
POyVp53vuxp1cPHgbZp+UySv/9fBjX2vRnN5Dgos/W4BG7zt1Vl5S8z3WSQ+
MHbFr8f7q/v/ZOJRNir6BXlSyn2RPFbpZ0K+B/HwDd2Gf2/iSVo32nF4c784
vuLz/n3rfRLN26Zc/HHOjDieP/6rm6LqxfDOPP7po+3iNV0Dflin8CLgOoq+
2vZ++V4iryvKQ+39366ad77jX4lyv58o0fYuCRt7v9x/k79Y3O+G+/R5X9Zv
b+DZx9IG3fpR+Z95rOLwsw3qZm1hsYHtem5YPktcuidh6Z6tbO21b+v2qcpn
T7a83Ltlkzz2w8PPdPgvz+SjfZZVft2hQwErHhJ4Pr7Geox8aNz3+XnsqT6B
vyYOHr3zrpidgXO5NLh971WzErX/vwVfHxLLWwf39ckELvnXCMveEsldV8dO
Oronmq9S54v+emQ7gd/FKwN/UR5+MHhuPjT5EHoJfU4+ayHui8mnK/lJ8z01
Sf9NvvU+4j5Gh+TP7qzombyfl7S+4Lng/bgvndWPbzJx7FSc00uKD4YfwH9M
6o1LQvhVqW++xI7MCEoGpUzof6OKWazQ95ay8LsPXGvbsJg1+/ahoztnlarx
5rB4Ue7ikr8G/gzjnfeG/XznyEi+qcP0e59uD/1YGauv7qccV76e/z2Kf5J4
v4R9Ie5nCis57f57xRHonS6wD5T+f6K4kGeUHiGfPf9mcpfrn09jt+w7vLtP
TR6b2nLz1SVT01mXOikbMxvkqX4u635futjigdu6nGLOu6+eyOvuV/z6Bfbk
iH82HWrpZ1VH7gw8l9nxJ9sHHsQFpGs8Mzglqc7DuRls+f++mt59UZGiI3ns
rc472rbL8rPDYn9zWOuudyWf3wv7xFW2XOk/se7AY9e/+9X17/r8bP7QS4dm
X1fG0rqODjzH2PJ7vPxAQO69Tijej7NJUd98fbFNBcsWiO0cm3/97C7zksvY
22ueO3fD9jQ2q9PUl69UlKl9vsyiJvcIdFnOrggCdpJVCsSm8iLUy5R2j4bl
rPXycW2Wj8tlRwfEeb/uUM7GifXNZff3DSomytkk8XeFPRY+pkf4mCpW8cYv
ay5OLmKHHhx7cvWuavaQwOdFLEzok2rYhUMTWVJ1GmM3jNgTNdHJD9X9Jbnu
L5fZnd1WzP4lxhViP5nz4LU7Xmhzhb03Laykdz8VJzGvVNKhWU7uXP1j4KhX
sLx54+MbveLkv/eck7qyaQnruLPRnOSeYTwze+r/TpzOZYObtogalBmm8Gge
k3xOOL/xuaEPnH88n6Xlt35jynI3z9r8a+CpYFO3/hN4wrjUtwX4+aC6Jdqj
7RVr1f3esGp6dMXGSvb80rlLP83z8ln1j/x9anMY79dsbFjLa27+7HsPJw3J
cvA/f+4+4M8WEfzN4PKMKGFLzrS/4Y4uVexLz76+nZ8J4KFb1w9v2iWMfxF9
d8t/Nhaz8Fo/Z3TnZUwcjydOavou+YkDmp8Qy9vhbEj+22/bBA8Y9Ifpmr+Q
v2msTOC1PNX+Fcte+V9IvtvtY76exgYWKHn+qqZ3KH9dyctCfKttvuch5Z8s
Dct7fEXfZ/SHcw/5EzDo6YLC+xcW3g+7aQb1fw70v6Te5sX1NpcpefeClndP
q/YAt1L4xM6f65l+88tFU2AHL9T8gsRn5nvKQr6oV8T6q/Mn9OBxhRq/Vat5
4fxC33Ffdt/A41Tya46WX2er9u38uZNaVZz75S8Xn36wX0zG1io2Nuaezi8x
N58ZrF6nikm7QTgfLxBdOfuh6cJFvSrc/P7W52PZyhK277dWZ7v84tXyD+h+
ABltbfVJGF9ee4lr+dAIxU+5+BHBT0Vy58obFzdYFM5nzP+uc/TeSC7sHr3D
+QuKH6kzq1fg8fL/Lcj8cUHm/9u+svHCkDvumnSKHawY5/thVRxPPRv8O8ke
HPf9678fjtX3/WZVf/rFb9rPHnWVTXl6/UvDpsbx9ktiXulfdIVlXy4c8FBu
rJavUf9QAKuPe6iArXn2hWM/jIzj34t9KGC3zexX+3IS/BArdf0WU1svPdO+
lGW/cFOT//WI4yzsXh52byl79ZGUk6t4nJafUF/Yc96vZssEnxCn5I8wXX78
9npffveWi5/ZUvtU111xWv+PckHXjrj5OoFv4hV9juTPTQ8qeOP5QLWutwgG
KJ7/IxTxXv64sgddOvZw/+h7ovj2R/8YMH9QAt+SuK55ry0O3uyDZ+8asjVB
20e7Kf6t69zai3Oywni7U1s/fGJuAv8vIN32+cLJ/6n/U+/npvl4ceWOF54a
VsnGbuja8vSfPv598PjWdfOGQTo1y8cvTB7x+NCGkfzU4FeTogsD8qS4T5G8
p6B/ibzmltGOJqNj+PsTSh9+YpePOzbd6tp0axT/RdmfBvds+1386nh+eMHd
jbPm+figiLD2C34qZi3WeeZXpSXy15ZcLj+7p4rFTJ/dZML3ifzlpz/qOH9W
FVsw7adq54eJ/GT/Wz99+XcPT025udXorETFn8XxEmVP/JkHCYePv1h7TVhC
XkCe7D/j9Q67A3L1tqnPz0pN4vn+QZ/dvruETfvohtdik5P4yA1vjdrwVglr
NfDWObu+gPxYouXLg0F181Yv/yh7T+CB/Gny9bKg2qvuCZZQu2mTna8WsIXO
uoucda+xs/eHr/QkA//mUP83xzV1fwvY8PHXvTT+uqusc4dagcfPrlX8kVvx
xxVFXwpZWYvwL3r3yGGHGv77zTvd4H+4Rct3H2XM/ijj+ho2WhB+pzo/ofl7
pf0oTuEXk8/3tp8uT/M9VszG97678sULFWyNuj+wa34UpG+THfyCkN9dIXas
V4Pmiklu3vh595SdWV4+M3i/pkXz2S2CFuIA/yn09/vYVKG/z2Mfi/HmqvHm
M6mfMfl8JV9zzfJjvca+uqNd5scJJp+v1K/kKb7O5PeVfJr5fq/E59b3evpF
8od/mp51/g7Y4y9Q++XX5vsBoEeAQR9fitwS2Bo/y9178e4LM6+wu9v1SduX
kqfsg+b7muDn8z5s1vT2H0z+eNj7JP9s8v+K14bmKb6vhOUFyxfmMIG2NpUq
vuSapm9oP0Mg7nI2fnZQgj3BLtfaOv+T2RUss9OQD1/6eQ8b/nPQsFal3ktX
/VXI93+5KOf5cRVbKf7yWPDYP3iogp0Q9oUc9uy3w/p+O6yKSf8Q871N+PMM
+yjv3NcLqlmF++0Dj35ZzFb37/d8Sn0H/3F80ADkZ+IYVENvar5nVC/I3m0v
Z4eXpYed2mTyDX98qMXrmSUOfmDf45N/L8hnRbGjzq8qxvk2+YYx/8QhWQu+
Wm7yD1//7baXeqY6LX8Ip9Jflit9jsk3vKj/Vw2nDYFfTKXS34Tzq1Wbnj6d
V8YeGP5Jwo8L3UpfXK71vaK7xiouoJPJRwx989aeb2ztWejiDWZdzn5hjVfp
e03+YdR/tt8nBf56EfyWmaObzBzt5K2arx82ICOC90sa3z9pfA0rGdahdFiH
KC75/XA+T/D7kbxXj/pvf7vqJBvbfNW0zxfH8meFPfAKu2FdTUff9FgpX6/K
Z58F2fmPYjnkuNGCH4vl13/2wg2fvVDF2gtBOJYvf3fo7wPmOvlTjTMfXfBs
LN8eNDN+Es4PB83rPWO5YN9HePliwZ/G8qbH014fPsXNzyn6NlvJo5A/9wv7
TRRvIOw3sVzqkyK41CfFafmZ+gtG8kd63dxgJkd84RGL/ztjyUFHlP24RN3/
vZofm6P8wQD/KPiSvWx5UeGpprchrncfk25LDrU/l6z3MzR8us3PH+5MucRu
bBSckINL/d4lpd+D31Surk/1+zWKn85jV5S9pJ7i18Hf1VP8OuC/On8cQNEH
2MY+vR7qsNSl9D4HNT8p8cRhba8Afwv4ne/TA89h9uLMXvcOqu/m9836LMAR
HmZVQXPp7W59H1Ef+nPAN5x6YIWn2M8GvXz2njX+cD6hU9CQX8QWCn7brfcH
9oqtQXPvdwH4Wp2+7z2M7wj8p8vBbwM+MOjTg4M+/Y+NqGo0qqqRV84vPSBf
HA8wnCu8Sg9uvh+OdQF8VOAnB/coe7eQS19y8OCqTXvdq/xbjul4WPn+MeXn
EMnh34fyrXveDzxp7EKdBRfrLIjkWxS+RTkfvqrj8FXX2O/VM9ZVz4jkH7wU
RKzX2Me9Vu69dDBS2VvM98m7KTyt2xft+dmuALfUsHWk0p/62THFX8OeB31S
zvnqwHOcLR5wU+SuCdEc9jyUS/kinbmSqr7/+dtobd9CuehmVh77JfxwVtwP
eL9Il4t707SYNRJ6iGhO5aJo/sRbf/Z6688K1jJ6x53RO6K1/QvlyUI+d/B2
l15c3P1ANG+l8BvKpT9NGJf+NOjffB9d8h8ePk7wH9HKX8p873z+e60WvtfK
wd+OafVeTKsEeT+fdPDRQh+YoPtDfTm+MJ4YXI42CRa98fHKQZeSK7f72cVT
9d8Y8KiP37xoUI/HXQH6teVESasJPssf0yf7+72C/RwUmHuh3HwfXcrR0bze
iz++XTTKp/SfOVo/2kfQzRz2n7J/eD++tXJOXg6bOO+xxcM2JvIktR+oL89P
QK4VCmeUm++nC370QQ+fNDn4l6jspblan3o4uN2f5bKIEdH/DlibpPCZ+V56
aXBZugbOlbLfxwT1nKui+ceKv80Junf03M9c9VY56wXohpTXD2n5XMJ/alji
3UxtH5H4IId9eW/k10265DFJ/wqYpH8lEs/+Zr5XKdsrY/2EvGPyYVbEdt2T
kuhQ+nPEMcBvH3l7KhnsT9DHS/mihkn5AnEFJr7goR33lt7aPsDHtl39dL3O
Jh/0C0IfH67sn+b7AvDvvnRi7fLu4V5+X5BxzwnniwedClvbwcsvCP+oKOv7
v1H8gzuneW8eYPKnyPVI4G6B/8333WR/5nvzlUq/0FDNL1n4wxSxR4Q/TAXD
/cU5hT/8TfPebTD21wom/T0cvEj4e7j0fbXzQ/98+uHj950CP2rsQFI+MPmf
g+R6d59kVnfq4Abhv+D7FMnKD6yIHRd4ayf7t3du5smUUtYwLCPIMTHP8Iph
z/qKFP28wNoofeb3QqGYwhqLv2Imlu+/VKWPLlXwHvaTuFhVrH6vz1r/Wn6S
jV8yZnPPvCq136fZkKCaYkoN+0ggkP/Y1UsN3l1Ru5pFfb898KSwv8SfQ9kn
U1i6orc/iAN7lb14fVAxWs2k+f8q8yr9ozgnH19Tdj2UZ7IXhILXwcMC0lj9
twvYQaW/rDvm2u/RkwvY5+l/n11wqZqVCXvEvyxa2COcPFPcp1TmEPfJqfx0
Ullf4V/pVPqXc5qeSz7oEBN2nQthXI7jPGss8HOYos9XNX1e0WZbRo9XM9hr
dfICkoibTzhbeZ2rawb7eGDNSEecm2cLebKETVb6yheFvFnKOgl5M5wvDQ5z
ZzI7pvy73xH8TDL7Z3n/fcv7e+T6jbrIJmT12lh/l5u/ETyvkzLZjhVHZrzR
wKP9M0CPpTxXwG4Q6+LlkUH3qT1OfkS1L/jmE04u5KQA3s+Z+FmTjq8dZe88
0qffxGciuPRDPcqiXM0nXXc6QvGTl5Q9IYJHi3XJZgOD+xEfoexFpSxOlb/R
/7HVL958nD2yIqprk7FRfEzviZtGXDzOeg9/dOz6p6I5e2pOZnWnyyxuxpRG
i+dG8SyhJ7vMVh3bUr6udTQ/de1M08SIPPb0/ppR+ZujeFGQLWZ5LLN9l81R
idH8ndpTnvnqnSLW6dew3tedjFL2+SI2Riiao/gVIW+Vsy+E/S6KjwzKxz/U
sL3C/hil5mPyaYh9bpjJQM8qnR92rpNSyKZ0/+m7tZ8n8FPLeqQs65HNvht6
3T3VvwXoS9BgkFbOut7yxdLfDyZw75wZkXNmFLEdR3YVu8t8/GOBMItYb3Ew
lX3uyHnJd15I4rBXlyl9idyvKo1fpb6hSukbHArf+ZnEdya/sfRvKVH2XpPv
WPhF9/azwcqPV+oL/UzqC03+Y4kPjX0TcptYznblIfmQ3xf4tIpJ/vUvxb8W
KX3zKS1vS3na5ENup/w1oF9YKfw3M1hn4b9ZoPr7m60KmgmGm/gO2FukvJun
9QmQNyPeOLqj31smH7LgD5JLVP3Q/MjU3mzyJUs4ND8yrW/yJT+j/GUgf0u+
MjQ/Mvy14L9O37+i32+sxo/yDsrfBuWQtyCvy/XOYgFs8GlWL5Mf+Tolb1N/
FMSrlOjz1V7oy9KVvszkP16k8J+0Z5t8yNC/tx4xM/C4+LSSd6aXvHOFJbed
drTttDDejDU6uO/xq+z0xswGh7uFK/xezIQae4rJf0zbD82HDH2BsP/OKmSf
BsXi70w+ZPGdKgfi/Ap1vh5qzzb5kSfW/H3jnAEu5c9SrvuDPIP3rwj6epHV
EfTVzSW9uaDz+wn55Ps8lq30+dhf6Bdk/TxG+ZUM7S/wt/L/GHl77P0lp91K
3s2XfiQTPFxs40YH//eUL/LS1XDt70DbN/mU4e9w+e0HFr8wJVzqB3ZUs5XK
vgB/jznzrju35g0Pv0vsv8mnLO+nyafsfvkvz8t/ZbMFX+8MYDCv4n9NvmTI
+aAvwDMoF/zC4EKp33jI5Ece0SH+40WOSKXvKdTx94Ks7atgj+//KmNYc5Mv
Gf4lsv/Q/MklzaLPDFzo0fYbqr8pZamORwJPBK9555EZP4RXsS3Knif81ZZX
sblB8rQ+QrVvvq8rluEmZVdqEKX9Y+38yn/PnfbU8xMidfwDyqV/i4vvV/RF
6h9NPuX0djW9hrR088bXvAcOvB+lzoPJpyzjG7x8sohvMPmU1zSsDDxRSl41
+ZWnf3rH0EbRGey8kJ/i5XhbZ7Axgi+I5ysG7P9hwP4CFvX+07HvP23y31w5
0f2pNQ6VVyIHekyT/+Z/v628qdPOWOV/GR6SP/nEiHYDKmfHyv2c7OKHzu8d
+e4l5Kkz+ZOlf6DXyofj5S28O5p9+XYsXyr8RzKV/0gCl/ElkVzGlyQo/Z75
3qH0d/Jy6e+UwHcf++tcqyInb95+2ZTVRT7FX5/T9FSgx3eqNQy8APlL7E9M
GC9V5b+LeIMDKt4A/saHLX/jZO1vLPc9W9E1+BMd03g/VeFrwFJfdVTpq/LY
ESGvH2ethD29gF0U9vZjrIOwt+ezYhG/8BfbIuIX/Mo+/IeW77YLfdQ2tkno
owqYS9jXs1i+sK8b/2dJD/JV3GVofuWPhH7XfBca7U8V4mGejpedIOwPeSou
qYA1EfrRfHa30I+WynZP5Eu6+1gxixP8Zj47pfzZvhX29kIm7e1FTKD/uND8
yhLfFTHpvx/gY4T/voPflTMlZlmbGvapt7L8mQlhfK+IhwrQZREPZb4/JP0j
nTylQc704m5OfsfI6+6bOtfNpX3C5EdGfCTkPamHKtCw1L/msz5C/1rFRJjH
J36WLBa0yrJ7Vyp9ovk+rrzvRexmcd/Llf3D5EOesaHljg+75bO52349nTW3
iEn503zPvLnyZwW9FvaHgaH5kN/7vc37v7fxchkfZPIjS/8EDw8T/gmROi+H
nR95/ps/dp89N4KvEPTafK/uFVUP9lHJP5j8yJK+h+ZHbqnso4ijBz4Qx+r+
f9l9Ip4jn0l/0mom/UkD9Hr4w/vPzInlw1rekVLzegLvIeLJCliiiCfzMyb0
BQVsg9AX+Fm7sZnHfjzq5lFp3xRv4hFKP7FP85dDhf4hlyUL/UM+KxDrF5rv
WPrn5qt4uAxtf5L82R7Nf0l+7KKG5W8O/X5F7xIlp2KfTD5juS//huQvhn/h
80q/Azz1srqn4N+Af8APyPNgvk8EfpvmHy7S/Afoa6WKb5L8j/k+NNW3exX+
z9Yw+I3ml493efEdr9J3mnzC4McXKH936FPs/MHwX8c9Q7m8HyY/sLyfNVZ+
4nBO+Qnz/WGP8r/B+fUofxnA4L9oeYmGu6l7S+ub/LySfzT5eeEvSeFyFvR2
m/FGgpJHy0Py6y48vKpzxOgEZV8w+XSxPvDvDlrbkgaH8+lNO9V7pipB3TeT
P1fQr/kRvLHyB5D7FUHzYwTWifqLX9P+4TJ+rYr1Vv4CiLdAPo3yxivHFu9y
8YFBNe3uRO1ni/f/Efg3hkv8i/dNftsVI+auGFE3jsecPRx79jD8000+2xcz
xx/f1baETWxTZ0l0vyQ+RdAbk69Wygs1bLG4T7D3m/y0kye+/uaJZl7+ZLd/
d/TtifdD89EOqZ/+Qv30JC7V8T4u1Eu5aM/kn+0pKiRo/e57gt4l8DNKX9xb
+CMn8MnCHzlR4ZvNGt8s/+XOJ55N2cy2rYl8d/SuAH2/6WzyTWc3sXt/6+v8
4NY81va9T5be1nYzq9942yk23OQ5AB1BfobkWR3/2RdewjLFRfKzHu2fWXX7
G8VMrmc1ixXr6VLxB9VMxh+Y/DzSPm/yu/YW/qtOnivwg8n3mrH25zr9e8Ty
xRsm7XizW4K6TyXW94hK1H0ul/QtLyDPivUrZDKet5zJeN4q9uiiJRverFvJ
WvU7mPLIAyZfa0sVPyzbNflbJX41+VuR36OT8I+tVvqD7Vp/IPmDHXq9JH7Z
pccr9bG7QvzFQB+3KP20/X0y4JPZyj6p82UH6c+5U6z/r0GDTbxav9PsdkXf
Wov9TGE3if1M4IfFfp9m94j9NvkeEV8Cfza0D38ywFS+9/Fl4jylsK3iPKl8
RYlnVDx3As+ud+KPF3LOsCdUvLl/8eqH7j1xhq2+GHQMgn0kS7cHPA64rrJv
4rzHCX/tVLZG+Gv7lH//WSbjWhPVvXDp+0HjwxDPUaPh/ff7Lx+fUMp+HvPR
dzsewvfuy1iY8MeuUPpjk39V0Ne1laye0KvVhOThAB9yi/qV9tS/lD21iEn/
hUzlv5DHgP9BT7888PbO6bc7+ImckvMb7wvn8Pew86WCXlJ86OWfi/j4cH5e
xMd7+CVxMQL0QNxPD18zIyCQLQ7na1JdWXOykUfC5ENF/qHM7nz73AUBvuyt
5bO6NPTwL+9ovnbTrAgtXx1+54dTnS5Hannpe0VPoV+DfR76Zxo/VRCSHxXx
U5CPEX/wwKCghFHDngu6ZbnjNb5AnM4pBYN/k/QsRdOzjz0vjfNcLQzIlx8u
qzUb9Ck0XynOP/w1IM+tef04WzTdw4dXz7uzd32Tv/RVpX+V8nNoPtOkZ7ac
m7EkXt0nk88U69X5XHGv7icSpD51bYzS08ZzIW5tj+LyfJj8pnXuW7po50ST
33RM7uBnmpQkcCn/mHyoUp+WasV3per4LsmPZbP8oBlmi8/in0LjvYCHkQ8M
fB7ahzyO9hetbTrux8fdfGL8y7su7PBp/w6031vEVwT2QcRX+FR8T7xuD/lO
wQ8g36mMl0lU62nyn+I+IF5kiRB8I/n7n3TN+fOJRGUfNvlOxfaujOKQt7Ge
4UNc64YNUfL2/qiQ/KaIB1ul+D2J75N4KyHvxXMp7yVxGQ8Vmt/085aT57xx
dxK/JOQfk99UynuHmQgvGOFX/tv5TPpvq+/nNlZxFZ2KlP9wkaZH+SI+soTJ
+EjzvRJ5f6qZPO8mv+kQ4d9Yw/4R/o1hmn9FftIPRXybU8W3mfylMr4tjF8U
4zf5TL2Xrv78ZHosz5k0L/HL+Qkq/jSfyfhTk8+0m+Cny1V8mclvKv0vnXy4
8L90qfsZmt/0j4yRRUdXuPhlka+jgG0T+Tr8rLnQx2SwdUIfE5D7hX9rJtsh
/FvzlPxu5zcN5+kJWROf6WTymWbF9w08PhXvavKbSn/JeC79D01+096Knkl6
G5rvVPI3PnXvQ/ObjsnZULGnR6LWO6Ec+AHnTepDtmp9SL6I/9/KPhfx/yZ/
qfRvdKjzZPKZIr8T+BMpD6Vo2Nt3zqBuYVG8ZtCrDV+9EsPl+fOp+IEkPknk
WyhgBSLfQgXrKOityZ85KWPa4A2OWP799R+9W3pjAv/K++uS75vlsQe+2D/z
vdZ+JuMl89kScZ4KmaxfxWR9B282+qkhlW0i+ANz3G/dlhGl/DxMPsV1Sq8D
/A7/GMDSPSBT43N5P8z3y6g936f0+ec0/y5h8/0y8IO3qV/kj7rZ+kW9z65W
lw2IqmH9vune8rtzkSoPTyWrrX7rvHn84RHt3Dx+U90N27/1KvniD62v+j/d
ITqL
   "], {{{}, 
     {RGBColor[0.33397672886243995`, 0.1279285534584573, 0.5864250111696041], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNVc9LlGEQfl2/3W/fbyuWMkE7WEG3MIigBH9k3mIt6WKgUnkoCCmkOvQX
FEqFYRgeykMo0SGN0lWxpNoSOhQaKoZsF09h6kkkwp6HecQOw/fuvDPzPjPz
zOyB1uvnrsWcc88ghZCwwLk/+M5A7sWd28QXKjeI8xBkAOeF0LnxpHMlcFx3
Zr8KmUs4Nwq5AP2xlHMpyGNnuinpK/Edg/yCfgTx3uDbLxlU/DTsevC9Kx3v
+DtCvF0pw8E3YwWGM4t4s5C0sDCHNXwrgHMlci7A77YAseFXFBgmxmXMdvx+
jnMJvvOwuwMph34xsJjEPKa8iHkv3s9AhnH+AL8W2DUH9u6a6jAB/VtIDud3
OtN+WHfMeSxpNSKWdfl9h3yUDX1ZK9Z/A1Ljnav1hm9TvdlQbbPCRt39//TE
fTFm+fOOfaxFkzNx610h6vMpst8v8B33VoO+Aqv9bUgxcvuK+zKcp+AbwK8X
93FgbwytfozJeOzbceiWk4ahHjalKatBN3w2IFehv4G3noZW46O4OxHYXV3c
YnXpDb5FDK9g/wXYlqB7AFmBNEGfx7cTUoXzE7zThZjTwbZdBvpS9ZU9vRyZ
HW3IIXKA9WeMJdmzvnnFPIz7I4G9Nwjfz97uWvHOaW9+vOsWnm/CzvpVwPdk
YDm8L7T8aFeE93dDsnGzZb5p1Y41JJ6beOuRN+4VwvZsaPxljF7VsCU0ThAv
8yEXycMdKZuTIcVnXPZyGTF/R8YP4uva0qNX1epXj2aPGMidSvFnTvNFnkWw
vRWJV8qVPboCPGe81b0T533AMBm3XIuVL+dgUtzeCV1lyuad+gnNSCNilIVW
szzOP73Vsd4bD9intDe+zosjvO9Tz9kH9rENNgdD68nL0Hxo/xp+Kwnrba+w
s57E3iD8f73VnTVnnzPqdSwy3pPzzGdE+4q98knr1ylvXMmr34zdpH3CeGlx
jPwiJx8C26q3PVLubbeSB5ybjtBmh/PHN8vEVeZHf+4t8pu7i/uD/ecOmdZO
ymlmycUtHnLeyCPO36HU9p5bFDbimFWcZsXN6dwifSphb1DPncodwb16Cfj3
h/Ym54Kzwxqw5/TJaedn1etp2M94s4vpf4e7kHjmtHsH5NOv+aoTr0dlQ06S
R3vEJfKIO5Q7djUy3pPzNehPB2yqE5bTmnZtTruX5ynteXKbPtyZ3J1VmgXO
yKb2Mvct9dWyp65KZ/aDfSkXjhHl26Y6sc4NqNOwt9q1q4fsL3vDfUhunodN
FFmsBdj+8HbHGMWy/wc4Ygtb
         "],
         VertexColors->None], 
        PolygonBox[{{2110, 2953, 1597, 249}, {2758, 2350, 537, 1356}, {2235, 
         2234, 152, 537}, {2838, 2837, 182, 1464}, {2411, 2412, 976, 416}, {
         2845, 1938, 1117, 1475}, {2799, 2800, 1422, 260}, {2507, 1895, 399, 
         485}, {1826, 1785, 1347, 976}, {2057, 2675, 1245, 607}, {2491, 1885, 
         391, 472}, {2892, 2893, 1471, 182}, {2486, 1960, 1487, 1046}, {1930, 
         2841, 1470, 1471}, {2827, 2828, 1457, 152}, {2380, 2381, 485, 395}, {
         2853, 2557, 1132, 1245}, {2232, 1795, 1356, 833}, {2503, 1890, 395, 
         479}, {2037, 2662, 1234, 1547}, {1960, 2562, 1137, 1487}, {2820, 
         1872, 1046, 1447}, {1778, 2522, 1080, 1330}, {2677, 2982, 1736, 
         608}, {1823, 1778, 1330, 962}, {2369, 2370, 479, 391}, {2954, 2058, 
         608, 1598}, {2570, 1967, 472, 1050}, {2982, 2676, 607, 1736}, {1879, 
         2822, 1449, 1137}, {2544, 2045, 1238, 1117}, {1824, 1781, 1337, 
         968}, {2400, 2401, 968, 410}, {2830, 2829, 167, 1457}, {2798, 1847, 
         249, 1422}, {1871, 2820, 1447, 1132}, {1937, 2845, 1475, 1234}, {
         2841, 1931, 1472, 1470}, {2515, 2390, 404, 1071}, {1781, 2527, 1088, 
         1337}, {2523, 2400, 410, 1080}, {2835, 2836, 1464, 167}, {2385, 2740,
          1324, 495}, {2843, 2037, 1547, 1472}, {1785, 2232, 833, 1347}, {
         2953, 2111, 1598, 1597}, {2528, 2411, 416, 1088}, {2822, 1880, 1050, 
         1449}, {2390, 2391, 962, 404}, {1775, 2514, 1071, 1324}, {2384, 2385,
          495, 399}},
         VertexColors->None]}]}, 
     {RGBColor[0.41509818658731984`, 0.2689768603753719, 0.7004510335088123], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFVltoXFUUPZm5d+4999oGsbU0sWq1NtWCRUQKolGTfFRsyFSwLT7ApqWj
aWh9RBT1o2BBM0lMnWBB8mM/DPmKoJMYZ5o+flofESE+KipN1C+DmlFS0ELU
tbJ26cfh7LvP3vvs5zp3feehhw9mnHO/Y2WxLkbONabOtYLZEzu3InFuC/jV
OueKOefOgo4g+GLg3BHwPgghD9lR0Dno7YrED0B3gD4MegDyL5l8CNnj2F+G
nZ+8cz9jPYCzGciU7Gw01B2UPwIbv0FmR6A7tnGHbpzIP/p2CPszsXRewfoW
dhbBPwP6begcAJ2B/ChszeD7Sdj7AesczrvAD6B7HnabwbsOMmXwL0Fu2HTL
kNmBs5NZ6Qyb/3PQmcRd86CncH4/1jjOCxn5sB9rBHl4AfqzgXJ5wsvnbRbP
O045YQ6OW3wPWoytsHUK9NU4ryEn08afNNu8dyv2Meh9BLov1D3kb8C+Ad/N
oLcwXsTVANk28Fos1/ty8rNgeSevF/JrILMy1Nld8P+RRH6uA/0W7FQgmw9U
E967B+fDqfzrSRQz/dhsfUGfT8GHVYn8eRU25r3ipE7e4hozu7TZiP36ULna
CLofqx30vajVu4n8+zjUHdRjzdaFqi97YI35z0VZ5os+zVl+mAPmg7l9HvY8
7F4IVMPTVscS8jOENQ6b9an8ps9D2N/0momrwE9TzQHXLzYPzO0xrC7Q/4ay
xdkZhN4d0K/BfrlOZ+S3ZSTDu/4LxWceDkB+DuvLrOJdsJg5i7z/Gyd5+kmd
o6HuZU2nYtWPtWP9T8aKuR/nfTnVcRXOr0llu2h8+lNDThYS2avY7PMu1mfM
akpZ2iJWkC6azXbY2461ZDVgLjiP9Guf+UZ/6ffleJ3F3u0VM+PlzOVt7vZi
X48YPsvqjP3KXu3FPc2xZuJv7PfEqv8uyO/0woBp7E9BdxN8byHeYE2A/xx4
nV7z3I59O9YJ8LvB3+2FHZ9if4i1zsreV2ZzED43WCx9kF+bqp6Mq2S12OOF
NcuYgfPXIvU7z8o2s/3gve4VO3uLc87cDkB+HPzV4C1ApiNVjvYnwmjm/CDO
b46EndVQ88j6hMhBAfJrId8N+bLZWcyKN12nOnQZTjKnxCDm4X3YSxLh9Qz0
FiD3OGTqQftEWM676T/7hLhJ3Jm3NyKfUZ/0WV9QZtZkFm1GidOcU/Z81ew8
azktGGZwhti37PcPree5SPN8iTMEnzrA+w5+/ellrwl3NYXCisfAqyTC8lnQ
F3PC7e9B/5UTtrMPOOvEpRHofREqP8zJ3aHyUoqEfeztBLktpsKRreD/kcjv
27BPYNUgswLnK1P52mgYw1h4/rWXDHvrkr0vfJcmvHLCvBLT2Ru8n+8CfWAc
P3rpEDvyljvOWCWUDvvxqOWQfcaeYD8cMz7rfWug+1nTYXuPmZOdsP+r1/vD
XhmxPLBWo4arqxHTtemV+7gTC26H3lnov5fVKlnMTyOuzYnu3B3p/4Bvej7S
/wH/DS7ngv5Qp8FyRRzl+8f83RdrzicNI9usr+rBH/LC9groanzlzaQftMeZ
n8qqHzjbVaP5Nk5Y3QP4cw5+toPX69VPy70USofyjIk2iTn/wIebItHEJtqn
/6cj9UHN3iPmjDESq4hZzDPfwE+87uUbxDsZM3vzxkgyxJ5HDX/4nzVg/0Ks
e0+o2rPvK4b/7OUbIvUS30zK892kX8w9fZuM5XevzVrB/iF4xxnzn/nlGfnE
s2KkfmSfEMNon1jDf4iSvbvLbzz/HSPdQfucJ77f9KGTufX6H6E/TfaOs66t
VqMCZD73OrtgOMXeI2act2/2I/vysP2ntJgusY1YyTPi6BuGpfxf2GR3LYF3
S6rZfgJ3Vb3828v3xOv/4k7Qg7HhWFb+Nhu90ez8D1GOeyQ=
         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlVuIVlUUx/fMd7722eeYI5UNaTfNUgmKSJFiUrw8ZDmOCmloPjiClk7e
pbCXIB/SrLHMhwjUHhIhsNAZa2a89eKYjQgqBBpe8SFJ5wskQhD7/fl/D4uz
1v7vtfa6n1Htq+etagwhdEAZ9GkKYQs0g8PuhhBGliF8FkPogp/O2VbkKXkI
v8BfQeFLsF2cbXsghF7u3CpCqEHbqyGM4GwU+L98X0U+VQmhmbubOZuLbh9n
E5B7sTcd7Lp0kFuhe/CTeOM2d2cj30f+Gf9q+PZV9Ftt4DeRbyDXwGdis4W7
D0IHkQehl8CaoQ3wNd7YGv2GbCumAn4IdAB8H/JD8I9APcj7kf/CflNp269D
/cT2Imcj0G/lzk74DZxdBruD/X+Qd/BGX4Nz+HBpn+SLbM4CfwPq4+5haBbY
cOWg6phXYqsDGo69AcWo3EbXIpDHQbBXkFc0OsdzsDUbOoKto1BZOqfKpWJ6
hrt30ZsBfxb8IncvQCsx14/cD/8TNseAj1FNqMUFdI5lrslx8GPQZO53I//A
3WHIn8M/WbXuNORDFdtQra8iT81c8zfhl2LvucwxXwdfzRsR/gnwNvD3wMdn
jmEv9l4DHwrWDK2B3w/+QWadjeBF7t5Tzq+gfxnahH9nwKfAL+b+yMz+XkN+
H/quwT615H5Dtj8CPwQ2h/sfg5+FEliuGgfHeAC+NblWY9XDqh33t2WOqV3x
Jff2t+iPButI9mULNp5CXoD8a8U5fxp5SXLu5XMn/qzgjT+wdRN5N/h65Ev1
+k9E/i+3r3fApybHqNiU80Hy2VW49u+At6hWUFfFMd1CdxI2OvF9LWcLwRZB
d8F2Qifhf6v3o2qsXK1K7hXl7C1szy/c+9+AH1av1d9Xjr6A70yeLfW8ZnEJ
9wcyz+QC5Cr9uA9+c4N7vz3Wew2dlHuGNDuK+dnSOVDsp9F5N7pH1BvjMu+C
wehZ0E6YnDtGxaadpN78EfzDzPXbgy9N4Msa3VPypbFwreVTRbsm+a290KOl
d4BmXzPZl9zz6nX1lHbdssK7UDtveemZlb+PIbdF25Qt5f8obx/JnTvtjAz+
63q8qrl6aSA5NvXUefiO6NrUoE+id6Z2pXJa8Nbb0blUjENL7zDtLu28E+CV
6N77njcej545zZp6QrtiOWdj6/N2u/DO1q5Wj2hX9ODjtIp3RndyTykW7aQd
8C9H96pyqliquWNXTNLNonejbGh2m+r7QjP8e/JMaZbkg3bNC8m+auecU+8l
97Jm5k/4ddGzpZ59Ht3j0bnRzvg7+R+hf4P+Kf8DphXm6A==
         "],
         VertexColors->None]}]}, 
     {RGBColor[0.4962196443121997, 0.41002516729228644`, 0.8144770558480204], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJw1Vm9olWUUf+6973vf93lvNPKLlnMqJYHVnU4ql38+1K5BwgRhuZQGqbNy
c84F9WElZUaZoYsbVHKD6MOFQVpSOm251hxcjSIM04gFbhpLE8c0KiZEv5+/
sw8P57znPc95zp/fOc8zf+P2tR1p59xfWBms3ZFzM3POfZZybi34r7xzswLn
vsiIzoPOv7FzD+LfFDb+h/99WHdA/g3oIFYN9O6FjTmJc42QL8T3+1g9sFkb
OpcP9d2cde5NrPthpwa6P3jpUsZ/9OFCSvbeAu2B7F2sz8E3ge7GmoO9k6H+
HcNZQ4HkvdApgW7FehryNbD9XCQfToD/GqsaujMhW4x1DjrzEOMNrBbYbIXN
K+ArTvSy8UdT4nlWAXoTJn8V9l7z8m0KZ94Nm29D/jf4+eC7wS8BLXqdcRr0
FNYC+LASdLlXjg8jD39gzwKcvxmyVqxSSus0/rfDzifgz2Rksz6t2Hnu9VD5
mbT8fmA5XwXZ45aHxYG+yY/irHrU8iBsxLB3PqX6jsPPlajfDdgZhv4R0CdA
F9nek9BtAC1kVffjsWJmvCvAl2G3DzarYOMy/P8S+5+B7PdItea+XwLtbYP8
2Zy+WSvW7AHov4d9AWxtgP4g6EPQOWD1vRSq7sQR46Jfs2B7DLZegmwX9p5J
lJuWjGSMsQF8I/hq8GfBF8AX08JkyXISws6pRHqMlflivFextkBWNrwRn71O
GOU38cD8k6e8JRCGKiZnLlkj5pHYZSzEaZNhlXW7bjpViPdj5itQLlhL9kV7
onwxV8QNe+MdrDx8S6x+2xD7mBc+9kBn3HSIryOGsaVp+U2fJxBvY04y5uuo
yTdBvtprbzYtzBFvxGDJ+BciYbRk/cjYGEsYq36sHfNWNrvMedFsHcLezlg+
sy6syYy0evLXlPqdOekxPLOOrOF0z5GyZxkn7RF7LbD5mNfeEfDfxrLbbDYY
M7G8OpCvC60/OKMOQ3+G19nsiTHriwrkjyDnNyFfB/phTj3BGcCYKlZH4pKY
JL6ZA2KA8+xHm2k3rYfZv23YOzej/LA+rBN9YE13WV33BpIz/8xJt+XlGuxN
YDUHqhcp/fgesv5I9qoy2s+9e5gPrxnWGmtes+9ixOKxXqQe9q1BXOsC5ZbY
ZVzEFP+zRlVeNSNfBJ300mMeuO+YYaM+UIxd0Bnx+maumXPmpNd6gPyw/WMv
MD6exxg5OzanNYefjzS7WaeRQDOact5FXXYf7YTOn15n1CKmIXyXwHeALsN3
XaBv9jJ7nHh+NBBu2Nt15nM79M96zZOLoJe89DhjVtmc4exmX9KHNyLNffZs
jNx2JJJzPhUywsMtTKcV423Q6UwU2wWrE2u0HnZuTxT/XaA7Y+GhG/TlWHqz
Q2GGtWPcnNeMfYv1xnSPkbJ2nG0N1m/n7K467+QTfaNfZZuP/Me8thkmy9Zn
tMNZvjxWTegDZw917oR8diKM8oxyRj34EWLZF8vX6fgP2PkHzYey+cV//bDx
m1d/1FmfsBas97j1JnH9ndf3slA1YQ1LNps4i3hfMk/MK3v0lUj4+hT2B6yv
OeeuRZp1o/DxYix/eC9d8erdZnuPEJ+sc5/hsMneGoylFrqVRHHsgI2nItWD
ulOGXc4t9if7gmde9Tr3p0Q9zL5l3yw1nYdzmi/0uQt0RyK8cx7U2EwgXpk3
5pkY4RuL+XkSuk2JZhDvMd5nvDf24pzaSDN4O+PNCjPsySWh8sx5WbCZSVwM
BqrLBsjWYw1nNP/6bQay/sQBcTjXcEk8nID9gVg29mPfPq9ZsshrFrMH6FOt
3Wc8p2w4zJucvcleyxu/CXs3es2VUa+3FGs9CHv3JXrfbAXdHwu/jGnY3kg/
Q39bpJ6n7KTJb70xbA6wZnm7N/lGGbL7qxN774l0Xw3A/j9Z4Y75q46UwyDS
u4e1KNrbgrHwDiHmiLfj4FfYndvhdTfzvuL7+vVI99H/QOF6bA==
         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlVuMT1cUxvf8/+c/+5wzYUo80I5bygtqqLQljDRivEhIJK1bMonLULeZ
MZV6GJpUiWuHxANxCx4kIk0rpdIJY1wSNEJIXYImHZRSyQQPhBe/L5+Hlazv
rLX3Wnutb60zcG7jtIZCCGEpkiB98xD6IUMAU8CvykN4kIUwATy2FMIHFSF8
H0OYDD4OfoptFfhwWQjDuOhv8LfgPeC3yHZwZRrCv/i/LIbwHHyb++s5W8e3
++BOpIVY17CfRO+GvQVbFfKW+Cc5PxFbLWcuYhuBTxWxpoDvobfxbRT6GPzb
wXXE30DsO8if4HngLeiPkYvgXvivwXcwUg9egJQXnHMVvuPBvxFvADkNxXcR
37Zh24l/LbZJyD9ljvENtsuZ75bPcfyvgBeT9yfk9Ax9LT6/YBtNjEHRb9Jb
/iLGeOq5jm+/Yn/Jtyf4f80dZ4l1TD7g38HD0Ufw7QJ6gv8mcjvE+Z7od6hP
HfoCfH7ivmOcqSXGRKQ62ke2Z/hswLYeeYL+tOhebMysqyc/oK9BxhSc0//o
j9Tf4J63E+suuEO14MxI9K34dKHfDI69lDtvJ87hK/TPyOlhyW9aHc0hcee8
+s99ncgtzv5ccG5b8JmeOMcu8CbVgFxmJI5dnfntyqEVfXs0l5TDWOJdiObe
p3z7EX038daXuwdniNWB7Arm0H78a8AnCubof/i1gCu5azA5Lse+jzsGgO9h
bwKnqjf+85Gz2G6Qw0hsexL3ojffVpbckxps08C9E3OqA/xlZu700wxl7pl6
JfsQ7u+I5tqOxNxszz174mgDenPuXJTD55z9osK11JtO4N/6/r4ewVw9mvst
4qxmtbLC3NLMzlC/orl1jvgPwY3IwTLP/Fz05ujZulQ0F2o4/6JkTqzivW18
25y4Zlczz4C4rx0yE9wQ3Qvd/wj/veD+6EuQBLw4d31nF1ybU5lnXzW6hu16
7t6Lk5oF1Ui10Uxolk9nrqVmWlzZnJnr4oze0pR51vQm7YrZ4PNF74zu4KPR
uyLn231wZ24uqodt+B7B3py4h5rt6ty91oyLW3Ny7z5xbCG4lPotmgFx/1Tq
WdEMZPhWcsct4n2HfSr2rujdIM5/hP3D3Lt3I3gcZ18jbwrmqGrdJ7dNNV+B
Lc19l/JX7/94v7/EgSbsjal3mWLO5PwB8HDsadG7tRS9S7VjxXX1SL1RT7ai
j4re3cI6Oys6lu6YTKxLmXepdmwr9vrU3FOPB+I7LzN3tOPFncfRu04cmpWZ
g+KGeqJaL0+dm2r+Mbgh879BO0//Br1Z8fWPWBbNMZ3XDL4DTyXjEg==
         "],
         VertexColors->None]}]}, 
     {RGBColor[0.5737613661287864, 0.5435370519035628, 0.9097253540741592], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFlm1ol2UUxp/5f3le/hLZMHthk0F9CDMVp8UiFappYMVWiFqpSSombr7U
iLJCp0FKI0EEMwuRmEy/+KFMCVMRUxaGrSwtEd1chURQUR/6UNev64gfbp5z
n/u83edc59xP0+LO9o4RSZL8oVXSWpUnSafWgDZTK0myq5okK8V/vJwkf2p/
n4Sn15JkRs37E1qLdLZQa0XV8s0V6++pS5It0h2Uvb/FX5dY5nzFNgfK1kf3
edlbrFWv8ylZkvyo1StfTTo7K5npku+XzV11ttMj/oD4v2i/UbL3SHeB+FMq
jhv7r4g/qkiSiaIPpElyk+h10hstOzv13Srd37V2lK0Lb0fwx+jbobVe9O3S
Oyz9YdHf6i7HU+vhc2Jh3VGyublsmTvEu7Pwnti7y46/p2T/mySzX99ZkdvV
inOfbH4jfi6ZV0MGW+i+o+9HOv83d0z7Kr4/cbaEHXLD97Gw+Zls/lN1/s/p
rFU625TPM4rrq8J1HBb/OfF3i27Reln0Kcm3iv+k6EbxNsjneq0h8aqK4XTh
sxbZ7tK3TTKTxDsnmcmKZVzER2yD4g9pPTXC8fYFn/z3Re3awu9p+a2X/QuS
X14xryvimVsyDzwMij4gvUPif1IxLmeTL8UzR6uvznvonYEHckKeJsj2mdwx
gtMVkStk0R8r+9dKzgV+X5Ts59JJte9QbPO0315nvINT7rWk5FxwD3CNzWad
X5T8icw5PF8Y08QP1tH/PrHdh8vuk6uyPZx7zzm2kaFO3LcvMRbABFjqihzh
d2nJcbSLfk+YfFO+T5a9bws7E2X7lOLoLd2oNzm8ILkftJgBB3XWUHa/zIl8
kMO3S8Yl+ASnh3PT+McOtftJ/Ifke7z2y+Tnw5r7m/pwB+KHty01v0f0wdx9
Rk+TC/q6foRzht97wWnhntwevUqvDccdyAs+h1P7vap4ZpYcNxj/Nbdv5gT9
Cd4y1WFV4Tu3l61HbNi4lnuPfn3EQL62xf4DyayWbr/sjKz6Htx9uOJ8Iw8+
sYvNTZKfVvOe3uiNezCfwCX7B3R+KbWNppKHcH/0xcLAyUDMV3zNjpxif17h
euN7uuiXUufya9FntZ4N7M8K/K/V+cXc9MnoG2LuFP+73Lh9Q/TNNfcRWBhb
MR5eU95+rt6Yw/ujbmAemj5C7/XUutxtb9z3C/EeLLynPsfKzuek3H1CvdvB
T+55S22GApPNMc+xx12mxGx/Rr7+Sl0H4kaOHOfMqqoxu1Uxv5s5r/Q7dpqj
VswO7n9B57ek7vf7ZXNqzTh6X/ynM8cDNvfEu7NPvHmZZ/K5wAZnu+GnnttP
6Ls0cy3X6N4dhfvssnhXMvcqs/mu1PN5cuQJbGOLtxNfo3SXkYXfjWWil+fO
OfUk59ThkuiFmXO1Rt+1mXuV92pd5nlxWTauFJ4ZB/RtlZ1PJXO08Nxh5hwR
vVT0l8wS6fVE/PR3b/Q4sXFfYv6YdyRm6f89FDOK92Ru9CdvTmvkiF7dHTPn
+jtHrvDXH/dl5lATbDGn8YF9+n5cvHe8jT2hO18xNuTua3AKH6yCL/oWjOG/
Mfr3UO65w8zh/sw78Ex8yG+JGdgU7zX/Dsdy21zEPM99Ri+2RU4WiH8kd680
6rsh8/u2kVmSelatEX13arxsFv1b7neGPPXGLOZ9ZXaQn0b5bSj8ZoLNCYHP
t/Ttzp3L4/o+kjvelni30N2S28e1eCexSV2YBUMhUyv8b8S90pr7nx4aX/hf
Chy2pe4B8D8/Nb7JOdh5NPDDvFkWmOSfcSj+G19I3Sf0yDTZnFEYr8zVmVGX
ozo/lnl//c3ui/9DepR4dpG/zPOQ/wXyujUw2Bp2bi3sD1/kvju78X9B/sAG
i/mPDG/4ytT9Bo/+gN8ebzl1xSezHr+3pZ4R5L+S+r8KnIyW3zGF3+QdgVFi
a45ZRU/TT0uip8D+3KjVfw7edSY=
         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlWtolmUYx2/d++557ucdxhLPTBkUfdB5IE2b5ARPn0pakc7ME81Q2Kub
4Aedh9QJKg6FFET8VDEpP7QPpiWo05GnMmxleEJ0cxqSQYh+iez37/9+uOD6
P//ruu7rvq/DU71iTX1xYAihiOSQlWkIXyQhNAmUhfA++APk1wEhfIo0ZyG0
IDfhr4AHoS/Cvg29lW+vov9THsLcfAjX8X8RQ3g3sW8R/ntwfQkr5sxCCFeJ
MZ4knuJzCLwAPAbcRpwn2P8CXgz3HSktJZc1pfOVdyt4I1KH3k+87djvQPo5
uxM8Hdsi5x1EP4rPBPQ98I/hL+JzH354Yn09ZwwDD0X2Khb2q7BdjSQcdoRv
K8ivF/498GDyO4N+FpmVs81o+APEWwbuJt5P+I6Gbwd/Db4L1wD+AdwPvgye
AT4GvgF+RMxO8Mky3+kc/ATwWPi/Ob+LeOeQE/AT4V/jvM3cvxLcg/9WuDZ8
6rHv5VsDenOpfqpRF/ptvnXBz4N/E3wv891ry/22y1PXVm/8BvHPprZ9gM39
1D6ybVQO2E9CXsd2Cfmc5PwvE9d6GFKl+yNDsP2DmH34teAfwbuQZ9h+gn8P
thVwtegXEteqA+nDtxdpJXYP9pXksxX+bbhvyacfrhn5fIBr8Bh9M/xX4Brq
8TK4M3FvtuM/A/+HiTm9kXo7Rufyf49Hv6Herg8ZRT4jMvfWbuxr8H0J+Sjv
HpsJV5e5N1TDP/Hdmbj31NPHMuegs8fg81d0T6uX1YP7OP+dxLNWjZwBl4Pn
YzsX/C+2jal5zaRqN5FvHWWu4XX1JneanHMN1HvLC+5N9aBmWTVRLeTfBR5H
TofQDyOz4ZbxrTrnntLdejhvYZnvuA79G75tyLlmt8AfFlyrS6RVQaxC5l7U
HTW7UwvuFc3weeynFdzrh7G5CJ/XDAbfQbtCd9ZdtTNOR7+Z3qqKM09l7gn1
whS+XUPfFl0b7QTlVll6X+U4C31JYl/dZ3vqO+uu6sFe9Xvq3l2JfJZ4ZjWr
6kHdfTDfVuX9Bt3EOw6+lvcbzYk+Q7E1ox+jr4Ov1T4E34nOWbnqW1XmGdVs
ageciK5pU2k+NGv7U9deM9cYHVOxfkSe8z6nM+uagbfUO6V6aocqtyGZd5Vy
1C4YmblXtRN+j94x2i3qEc1KS/Ru1sxc0vxqRge65xrwX5R6VrUDx8PXZJ5t
9Ux36pqqlvLZkngmNYvaabdT94h6owO+Cf636N2lHdwOdyTxXdXTmxLvfO16
zWyRs1LFyHn/aNbrCv43aOZvwt/IHFs1egV+bfRuUE+thavAvy/nGD9H72Dt
Xu3Q/wBJj+o+
         "],
         VertexColors->None]}]}, 
     {RGBColor[0.6334044084039064, 0.6393668249866482, 0.911085031734951], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFVm1ollUYPu/77HnP89EoP7J+mDpMSdDUiFGp2Y/aR5G2qW3vFkyF2qvE
JM147YMV2iLIqGgFltYPhc1tkIhUS9DXidTA+ZWr6TCibAsKlLD96eu6vG7p
x+Hcz33uc9/X/XmeivWb6tuyzrlfsQKsGalz73vnDmec+yvn3BzQb4F/psy5
PNZXoMdC5xqwPga9F+fPRM6dgnxr4tyf+K7OSrYJaxAyVfZNugPnv8fOrcL3
HvAXYvWAfzkQj/Rm6PsZtitArwOeTsPzNvbXU+n12Iehpw84puHuVZy/hzUK
DBuwuqB3N+R6cf4h+Fuhsxn3U8g2gc5jTUCmBd+VOWFswN5Bu6CfxPlqrGug
B3HvO9j6G3pOQn4Z9L4CbM2Q3ZmTv8REm/SxFOqbPu8Gzp1e8bs9EJ4/oOc8
6L0ZxbYAvBew1+D+CGmsAuRaGEvYfdPsLoGONshlYLM1VOwWQ3ZRIl+bYeti
JJ8+jeQz/X0OOn6JZXMaZG/D2gH5SpxftFjtwPn2WHl4OhFuYq4Hb3Ws2J4G
vxyYmkLFijXQA/5r4L0EmV7QN4NegNUPnLcEsvMj+EXwtsTyuRz8beCPgJ4E
3mde9PUclsnWVGCalVWNfRGrzlhjD6SyR1vLQb/qhWEBsN2NtQv3XwDvsUR5
+jaUzpXQMx16DuNsHPIzwWvHGs1I1x6rw3cRk3VY/1g9VBiG+dBX8sKYgr4p
kQ/ME3PB+uG9TYnuNmIfJo5AeaIMY0L/O7PKex9kBmJh4HnBZKqx1wSSY35G
LUd10Pcv5DM4a4WtQiSadVMMVXsNlhtiPhcpH/3Wg7TB/n0R+zasEaf6ZR2z
vy4bVsozJ1si5YW6KUP9G2F/A9YQZC9h3wq5pYjD3FD5Zq5ZH2sCxfSDQH22
0rAx1owz7RcNA/s+H4pPmUarK/ZlwWJ7CHaOx9L/FOjJieqoaL4QP3uXvvNu
/oYepx6gH5wnJ3H3UdyNoLMqkQ/E/2CiPmePN9p8413mb9xmHW1d71HDOWb+
fG+5Ym7pK+uL/t6aCDcxsy5arK7Yx7TDXmbfDttMuDdQvfJuZPo4Z/K4+4NX
LVYGijNtjBsGYusIVAvsEc6HbE65voJ7dam+mZMgpxyztzmnOKPYH1cNM2sk
Y3fZH4wx6/MssNen4m/0mgvsU85mvhmMP3VnTP+wzWX6tSjU7CPNfp2UKkfs
p+2RbPMO648x50xnXDi3OVdettmyFvIP2zxkbzNGjE8J8RmL9X0k0rvF/mJe
2EvMTcjaySlOvYaH+tlnT4SaNd3Q/xHuzwOvA/sbkeRWgP8O6HbIe9CDie7Q
H/rIOPCd4D3WWJfVA2fYhOWM+WIdLrRaZA7vCsXvD9Q/rBOel5vMuNUE8zIb
++NeGJ4Flk8i2foNPh1MpKvX4kZcR8E7grUUvG6rN/r7JXR0RdI7PdE3afZE
yfpiBmJ1R6zeZb3SNu3ybRm19+V+5HBJqvpjPtttDs+GjjmJamo59oew+kBP
8ZpHnC05rzwxRz1lwkdsA+Adx6q1+DE3jCHn6IlIvcgeqA3+fx/IY/1X21te
Zf3VZz4fwL1HEvXaYvj0TaL8UMdAmfQwxz2GgTHutFxXWA6p/2vwl+HufsO7
397i+1Lhpr4h+ptqfnD2rbF5egrnpyN9E1O33b0HeC55+TE11nvAXuOsr7F/
CWKpMzxxrP+Sa/Y/RV/Zj5zF/D9gLxyDTCnW+9Zv85j9sjnWfwD/ARjXWeYb
Zx/vttn/TNFm6fOQnevVQ6tS/RNwZvyEfX2qmcuYV93AmVVcmdO1kWqGtcMY
d1m+9nm95ZxRdyaaI+wd1uiQ4Wc/7bJ5NOH1b8RYNNt/Fm3Vsj69/DvoFTvG
bcT+oS7YO3vedH4OHVdymkMz7c1nTP4DIuptAg==
         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlVuIVWUUx79z9jnz7b2PQqOoPYzVYEqK11DJRtOHahShHJ0BZxSmRBwV
UVALk4aBnCaCjBIpsIsiBaOjD+FDYOIdUUFHpbyEJkNqBgWKpE9mv3//87A4
a+211v9b91O/bN3CtcUQwlqoBH2dhtAUQygkIYyDLiDfR05qQmhBvpOFcBvq
xPYX5I/Qn0Hfh/PTyDsqIbTmIdQD2oPPZ+g/h/5F7iqEsBN+F1TBth6M6/DT
oOnYtvPtT347kZ+CH1MOYZNswXsP/MF8W4H8RjRWP9RMLC3QA/ht0Blsa9B/
AnYv9g3E8zK0D90f4I3Etg2MR8TzReJcjuIzs+yc9uLbgv6fovN/TDzHkefC
N2LzKvbHoWeJ52MwT8C3R/PXC479L3xeKDuHDcjrU+d6Df2vvDUU+4PIK7GZ
g/wK9BjdfjA3gLcRuorvdwXXfgHxF2rcg1tQljk+YXbCX8C/Daxv+XYMuRa5
q+QYx0TnoNiFORp5febeqUbvZ8aQ7/81gt8U/XbKtyXwu4l/UuKeDYDVkXo+
eqDl6IfzXnfJ+Q6Cr82cq3pWR+yfYtMGf6xsrKXRvRTmQvSLoIvofyKeOfCz
oT78F2M/GbyxyJfhv8GmG/8JfNsBPxz/LcgfQG/ie7/gWZyJfk/JM/kQeUnF
s9VIPh/CT8e+t+iYmpAvpX67WONZvJa7N5rJVfCPwJhbtM9g+P7Uu6Car0OO
YOyH/5L3X8P+dc1TyTulXmiGla960kht5kEHE8/MRvxn5+59A9SKbZ/2IfGM
/o1tP/pW8Behb0d3k7i6E+/UEHQHomdPb4xAHgYNFNyTK5ljVGyasSLyW9V9
FMZJ+BvoT2A7D/kU8gDyXd6bn3j2o2aw7B2YBfYPqXPbi88t5N+1n+g3K0Z0
5cyzof08hG8d+qnId7X/1Kojdy+2ksdZ+Bexf67oN1bCv4vPLLDP4XMT/qWK
Y9NNGRl9I3QbVMN3on1kq5pvjZ45zZpmaj7456JnWZgT4Lt1wxLvYFf0zdKt
0sxp9/fwbWziHbvH957Ut21y2bOoGdTsaSaPgL8avPOJb8hhfEfxbRtv/ax8
Ut8U3RLtjGo7o+JbpBo/wff76FpJ35F5Jhqq+femxhSWangA7LrMtdSNWQbW
29ChgnugW/hj7lh1E7eoF9Gzo5ybUvdI7+mGntQ8VO+XZmYivuNz75J2bHt0
z9QrvaHdOh3de+2YbtO96N3RjdIuPpP5tmonR2P/fO7brJp8hX5N9R6qxr/h
uzj3rGkGVmWugXJXTTWbUzLfcs2oduF87tugndCu6Abp9mhnLmM7Jfet0E42
p/5PG1ft5384L+GH
         "],
         VertexColors->None]}]}, 
     {RGBColor[0.6930474506790265, 0.7351965980697337, 0.912444709395743], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNVntolmUUf/a+7/fePi1RggaLpnP2x77CEopc39ZlpRaGc23VjFwSOOcu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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlVuIllUUhvfM//3//v7tIbHpIkhKx8OFU1RCoYOHTjoqE82MdlLTomhS
0wsdTbTpAFmBo8gkClKZEimkaSoqFJWmmCKOORlUHtLUUglBo5vQnpf3v1iw
3u9da+219zp8/V+Y2zynOoQwD8mQr2MId6YQVgBWIuPQG5BR6HPh95VD2Ay+
q4jwbR32nXkINwlypCqEGvBJ8IxCCK9i04a+DrkbfAK+Hf83kLPgzeD+ioU8
EXzmV/jfAb8KvgN8Gd9LSF/4gXxrgz8FfxPfj5AP4SbzLYMbirSCX67YH4f/
ldgPgB8shTCLfFajr0GqC7ZpRv8kOvZ17tALvQufM+DP4bvgj+bW6+EHw8/n
/J+VH99+Sz5DsWcjU6LvrLsuRUbCHeTbf+j1+IyAe68HOaJvId5j8Ntyc9u4
bxuxFyC/gD/F5yp578LmW/B0zpuGfo54h7D9IfPdS3xry/wGk4h9nW8RvyLS
F25qdC5vYnOMs/qAZ5Drk9hvwP4oOJHLXuwfwf7h5Fpvwf4w3EPJ+lbkd8Ut
+630fhGuZ9n3VQ79sB8P3kPsMfB94G9B7lN9+bYf7kCF17dT2N8P3iQO/y70
Y8g3BfdES3SNVVvVrAZue/RdFO8lYrdwh4y8RpLTl3C3ls21Y3MR/Tv1L/d9
NHNv3o7N60X3aD2+w5FafP/i27vwS3O/tWo2Cf/mSj6qwWFiDQMPwL4J+wvg
88m1VMx5cK9Fn6UeWQx+C/w4+DS4F7g30rMyD43JNdDbj8bm3ugZ0uz8XbDv
iB7OTTG2Y3+l5LfVjPxJrEXRvaIaNpH7KmRQpZ+fw/7t6FlTz0wEL4ienZ3g
a9E9o14pIeujZ0K+iqG7z+RbXeY3qEPvjUwpeoa/112Te+OfKs/m2ORe1oy2
ov+LzU/gbqQB/nlwbeYeGMZZ7Zz/DPp6zmyBnwV/T+W8E+hPJ/fGbfDj4KdH
7x75N+F7NXo2nwIvg+8o++12V3l3lbH5ougdprdpjN5Xup92WU2lX7TTzkbP
mGbrEvgD9Dp8llc7p07wUPCyat/hD+0+fFoLnuk92l/Ju+sc5x/MHVOxGuHP
oD+brKuHJqAfia7Fjsy9qm/S1bNr8d8Uvcs03y/mrpFy1x26c9dQtdMbDkG/
gd5Q9A5ZUnYPqve008Ttx2dCwTaHOCtG7zLNYDNv9WPut9RMfYw+O/fZ2uEL
c8+YZks9rF7QTtEuUU9szP0Guvtl5EDuGqp2mrHPwLsrvN4w57yF0b2vGg0i
n9pk387MuebRs6ac38F+OXhXlXf6ZPCK6Fpr53Xjezy5l7Tj1LsDk2Oph19J
3tna1erJrbl7WL2rGndo3xDz/ZLPUK4Dkv+Fylmcdo52jWz+B8By8Rs=
         "],
         VertexColors->None]}]}, 
     {RGBColor[0.7526904929541465, 0.831026371152819, 0.9138043870565348], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtVltsVUUUPffec+85Z459KQ+xH0gtuUQgok2owQYsBYWkpknh8tHSgoo/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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlVuIVlUUx/d853yefc6Xo2XqDD3oDNpITmRNZFhI42gXsAQvPXiZsSuE
YD2YU2JTGlPT2E2dylSImlIy0wjJDH0p0kgzp8yxC2FkJYY9lOFIYP3+/edh
wfqv21577bXWrrv7wdlLSyGEVVAKdWUhPF4J4ZohIcxD8FYMYReyH6tCWInh
7UUI7eDXwLvRN8Avz0P4Ngnhefw3o78Kn43YzkK2CH4Z8RqIV4++BX4atAP+
73III/EdBVUnPqMVvg0K+G8ATyBeHfgM/Euc1wj/Zeaze/G5FrwQm8/A4/C5
A/4r9B+B90DXgycXjvUG+Bn45dG5nAPX4D8RXCKXtcTrhW/Bv0A3CTwL+xXg
LVWO+Sn2I5Ctgq+HToE/ATfjPwPclzkHnX0CWT94PvgAeBT5rcP+N3AHujvB
Yzivu3AuqtEF7Luozw3wc9EfBs9EP5VccvBo/D9A1pk63wnw/2J7G/F+ALej
fyQ3r5zvR99QuHaXIquDHwOdRvcisifh3yaHZurxB7gHvASf9egTYt6LLiFe
J76HkV2uu0fH6kl9d72J3kI1uA/f7egngy+BWtH/jGy8+gH7ufBlZMvgVxOv
RbWDLsDvRPYAvhugBnz7kA1HN4L438M/lrpWY9EPpK5ZF/y0wr61+CyAP565
99QTuzPXTLV6KnVv7VVPlN1j/6Bvpd4XU8MvEK1Hdxey7ir3xH746wr3Tn/Z
d1NNdX/dcSd4B7QY37P4TKw4J+XyXdm6Kyr2lc3a3D2gt9+H/QliNYG3Je6R
SeDn1O/gQ9gfyV1z1fpK6Cj8cGzeRddW9luMLfyWyumWwjno7PeRvYL+NLQ0
cU0XohvAv5r7DoU+R3dSPVLyzB4DnwcPQzcf+ybw14XPulo7Af+z6Kdiu4D4
Z5B1YjMa21dV8+ieV6/rzQ+Ac/Bs/GeiH899xkGb4Dcnnu363L6a8V3RM6TZ
Uc//RfxuZJclfrNDhWdes66YR9H9if2NJef0NHwNOe5Fd0Q7AvwyNveU3L8R
XV5xbbTDFHuAM24q+4yhxL4IWgP/LLQd/8ogVs+ejJ5RzeY8aDGx2ip+S/XQ
PnT15NiUeMb2wH9YuDdUo4/1PrlnWWem4KTwPtIZuktHxbXWnTJ0QwrPyv85
4ftCNlh7cKP2NbKfEvfEkugZk73mZ0X0DKj3tWO1+6pz301n6i0ao2ddb5KC
t2D/UOqZPwXfXPGuPgctgj8ePSvqIe0evbHeVjvoYfwfzbwL9Se0R+9czapm
WLtmW/Ru0M5Rr6kn1YvquTn49+Xude2gOZl3gu6iO83A9uaK31Z/yEH004k/
JfEO0W5eA51PvaOPwfcX7uVe6llVuCfUC7pjD7FfH8TqkV/R12aevZXc5wnO
+qawr/7E96J7WL2rM7WL3oz+K7STNsJvzZyv4tXgOzJ6t2pnv5P7T9Vfqj/m
9+gcZKsZ7UC/OvOu1JtqNqdXXHvNaG3uP0v7bF3iuw4rvBt15ynE+qVw7vpD
tkb7yFY9qdnQH6+/XTNyENuY+e/WDroV2/25/zbtwP8AH9cCiw==
         "],
         VertexColors->None], 
        PolygonBox[{{2147, 1760, 901, 2307, 2146}, {2194, 2147, 2146, 2195, 
         802}},
         VertexColors->None]}]}, 
     {RGBColor[0.8072672499999999, 0.861883, 0.8940340000000001], EdgeForm[
      None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNV1lsFlUUnnbmn7kzw5NQIFGL8IAFgtJKBSQmKEu0AlLaF0NZ2oIvICVR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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlllsVVUUhnfvObdn8kVNgeCAYIItRIVqKYo+KEi04gA8UoYyvDAVo8xi
SZQhDgxRqwJiEANJoZIoEo1EExWMCtWoZYihAdRYCMaBKISi8fv9+7Bu1tpr
2Ous4d934PTmCfNLIYRXoBiaUfCThtCnMoQq6D7kw8gToxAulkP4NAnhxiyE
TchbcViDvAWbtdi+UxHCGGy35SH8hu5zAh+Gr8N+MPxE/APyYOw74Jux6Y/u
Gugl4q2JHWsmNreVHPN28VATrm+gn038nzl/FvsI2oTciv9f8NWR+VbOBkc+
2yCZHJvw/QN5DrqEs7W9/jGxC+ROcn8cm070RzmbQX4fcWc/+H34n0bfTE6t
yNXYr4ePsRlNvvdAw5H/Rt6O/0bkieQ4FJ8+yHOQr0euJd4IfG/lLMe2nfsv
E3sW+r7oHyLGZHQruKObXC4jt+ku5H+RM6gL/gTUhm4BMaZg30CMJdw1p+Te
vI9+eNk96kF3DJtG+HEl134p+h9j92Alckvh3k1HbsG2DarD/qcKf8tbyMtL
/qZm5PlQK/6DkGcrXupvuw65RvXhrLNsm+nIZ8ihA/4wtCy1j2xV0xfQD+Ts
MroeaBq6KYVzvarSseqw2RY7ZjX8TdA6fF8lx3Zib0397eqhZm0a+q9iz9yX
6Oo5exvb8Zox4o3kbBe6JuRBqXPQ3f9AZ7lzJWdXR57JA8SvzT17ymEe/nNV
g5J7+gG6VdiPD675d9g/ytmH2J5CPoQ8TjOEXMLnSOoZ02w1IH+Mvj31rpwj
/0ew/ZazK5DH4nMUXVXiXk8in3Xon+utt2p2PvU3KPeF6CvQ78D+mwrvwKzE
PVUvVbMV5P5k4d0bRv6V6F5LvTtzobuw30y9euBfVP7Eyzhbz327Is/iQvyr
Kz2T3fieSe17DpsD6D/TTpH/3ZF3b2rhXmoHA/IX2D+MrqHsWn3P2f7YNRuA
7onCs6+Za1fvMn9bC/IW7I9h37fkHdqH/XvQyuA7d6Mr595tzcMn8Be5ewH6
NznrQD80M6+e7E3dI/VGNY/RVUJrItdwObkMSV2rm6GK1BgpbNTOCqvGFsZG
YVY9+tWFZ0s7OgN9B2d7gndgPPJy7ttZ4W+u4a4hmWslTNmSGROFheqBepNA
x2P36DF8X86NPfWcjYQfAV0g3nbkmdx9EvuuYAzvSo0xwhbN/I7UPVZvayP3
Ik+MzeqJsP7ewlgmzFfuDyD3lP0Nk7irMfcsqAcF+kXIp2JjyiHks8T7Gn5C
5FqeJA/Y/2u6AF197lzrYmPxvNzfJ0zui/8zyL/HfkMuoL+YGfuEcdL1S409
smnMHFOxDuD/NPqq1FgtDFuFfjXUDf8u/qcr/YZoPnTfLfheCc0s22ayepl4
N4WZv2I/KDPWaMenKlfteGSMOQg/BJ87IvfgBmwHZN5lYYiwR5gvrBcGVcE/
T4xL+G6IPLu1hbFCM6zaCTOFlarh5Mw9r+/9vj2p32C9vbqzLfeMajavJUZN
4h3TbnWh34X/6MRv0XDkbvgxhbFQb9YS/Bfn3l31UG9PlPst1Buk2Ut730v1
6E74UZl7uxn/17EdlppXTfoT/xfO/oQ/QczF2C5LjGU/aJ713wG6FBlDj8Ef
z/xteuM1CzsTz7rue5BcGwr37hLfdA7d/YV5zeQR7Dtzv116s6v1Fma+S5il
3gpDhZ3q8SJ8d2fGEmGYerE3cW3Uk6XKN3PttKMbM/+H0H8HfdN5fPbjczAy
poxKvFPaJX1TC7qncmOP/qNMyTyj+j756K3sk7n3wvD/AKdaOyE=
         "],
         VertexColors->None]}]}, 
     {RGBColor[0.8608307499999999, 0.879745, 0.8700376000000001], EdgeForm[
      None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmHmwl2UVx9/7W97fu1SjoGZoAkkoN1xCoetSmamUOA5Sg0sieAVkUTZ3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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlmeMlVUQhr+9Ze9XlIAUUZASFGGlNxdQQUKRYkMiSBCVJn1p0kGKgAQ0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         "],
         VertexColors->None]}]}, 
     {RGBColor[0.9143942499999999, 0.8976069999999999, 0.8460412], EdgeForm[
      None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmGuwlVUZx9+999nvfs/eHFGcSZGw6IQWBSGoOTCoIMjtxCFJpYa+MFMN
H4zbiOccyBQYbhkjNAmIILdT9qHMg9WMxe3EOShiA6IzQFw0udTYBQ7I/dL/
5/Nn6sOatd61nrWeZz3X/3p7TJz8yA/zSZKcySVJQf2Pi0nSof4DtVJVkqzR
YqNaD81/Qa1W85M0v1Pjdu1p0aY71fdUe1rtfrVBaitL2lNJkrdEd2d1ktyh
tkq0K8tJktPaEp3zddHdpzZb48+L9kXNvyn6fWmS7FcborXLWsvUn05iXND4
Q/XXdNZpydFN3zuKwae3eSPDP0TzUj6+12r8lM7vmYmX5mrUnleblsQ6dD3U
f1nrTaKbr+/eGi8rB93kNOg4s0F8L2luQT50M1Xzr2m+yTpCPwM1N8D3Qibm
ryQxx9rfk7j3QNMc1d6P1LaqzRPtV6SH+er/mIYuOolujvg+pXZENBukyz6S
M6/7dxLto6J9TG1nLnrsMFat1rwGWs+M/6k7fay2SHQtOrtR88PUXtd4Yxrj
zer/qvY5jV8WzwMad9f4mWL4B75xUnK8jd41365+qPqjmt+u+SfyYTv6fbbj
FfEcXQp+yIfM2OketRPaN1FtShq6xp+eEf3NWZzxicbP6b7LtGehWqvaNtHf
ofXntXatKnxxg+ab1J+TzI/BQ62mKtZHanxNtEkl6Kblgs86TRVF/wPRtOr7
E+n2bHV8jzMNdscv8TPuOEf97brL3GLYHz/oaX2/nw89YyfG+Dl6u1X3Gq/v
u8R/pOTYq/G/dMYCjd+zP+61T24V7bsaT8qFr+5Wm675PR5Ds0k0f7GeV+v8
VWq79L0+Dd20JHHGTbrHQvXN+eCDrxakt+9XQqaz+dhXaz9sVXsAv5Rck0TT
5nsMsP9s0HyL9HNjVdiGdfyzWfNjdO4p7ixZFqehzwlp+ARy3kpsa7zZfP6s
9j33fCe56Ld6vDuNcRXxpXF9Gns7E/dp2Pl0PuKXGCcu91g/T2r99/mIgyOS
6zPS9W7ND7Yu0MPtmp9eifyGnohtdPWQ9b+Ic9OwdwvnptGPyIXtiQG+idWO
fPBrdF7gfPJTT+2ZQZ4Qn2mV+F6XRpxD/8UschN5ab/aG9b/1lzM9VP/Xcl1
dxpyo+/51vkp5yHue7PO2yx+c/V9thwxQ7wMtp/My8fdoCeWD6Xx3d25in3k
omcly91Z8JopmllqW3JxFuMXipEniPcuannR59SaNT9b/ZxKyIrvLC2HvL9S
X6czbxNNXS5y9jjxmqf5rprvqIrY+WYu8jA26Z6FLgeXwrfx8cvyu5f0vUM0
Y3KRn8gdY0Vbn4UvrNOZwzTuYl/D5/AlbDjXdhyt9VfgXYz1rqYZbdmOJ2Fj
7npM4+Gif1jtHe0dKv4Xy5HX8fOlxfDvdZLtAa111fzD6pdXwibEFvJTH4j7
UVnEOTlntde/pLn15bArNXdlMfIJ/DgD29xmWfH/ATr/dDl4YxfkvCUX9uEb
e1HHOJcz24ohK/H4b80NKgU9PrvLdYPaSo3tMAYgZ5Gvznvu3SRydZ1t15xG
Lt5memj3JOEHb+YiD6+WjC+rdSqGXkd77wXp6oVK4AjO2aC2oBgxMd9xMTWN
fcT1T8j9pbgXeWdNMXJ7XSnqCjVlkWsDMU7OIHdsUl8pBeYgD2P7mbmw7UHH
8TFjCu7PXftoPNzz1LZZuagd+52jyFfggj5Z5GxwCDrB7nW+B3p41jr8wLpD
h3vcnza+6pAelvte7a4v+NU5nX9ebYW+rxaix17U5AOuy/SHXJePSycn1K4m
MU/NhmaozwV7/MjxVeuae69jZ1Qa+Z35Zun5P+TEQvgc+aQz+bYYMTrS++6x
HcFzjKndOd0lqQ6cctj4gfp1k86bVQ75qKlt1/1Q673AOsXIj1sde3dRQ7LI
6a8WQi5yAtizh/Xz2zTs1D8JPoetlybxmVm2PpLQAbI1FuJO5L6Dlg2M05gG
LXo75HOQGTu0u9bvcz3Cl9h30DTYZaZ9A39Fv2Odt/s5h4zXPR7Posbir2CS
vyXhw8ecx88b136KuV2vqLPLpMt75RtnC3Fv8scV48Z602T22w/VZhcip5BP
dhpjYe8D5g3fcdSESti1QfcYk4ZM4CNszF3A6euN1dFxX+uZOMBe/XOBtZq8
RoxgQ9bbPEfsUFsOWVes9bdewFPgqnWieU18fl6Jer5K4xW677bc/3IQ8dLP
e9HnfuNhcDG4YrGxBbj4HWOU91yDqb/cf5D9B5w2Q22K8x46wmZgaOKFOPpd
GjgYDAyvPxm7ks8arYcZPgv5wZazfC900Mt6GOuz8d21utea6sgTfa03zoEP
/LgvOAI94k/w3GS+C4mFNHyYfAg+5r2VVkVPjXiwEHkInPhL8bmvOuKGtxX1
HNw4Oo04Z573waN+IwzOhS7BEjt8/2GOb+xPTuOd8TW/NdAp+muxbp+2fq+/
Eya6bnKPW2xrcHZP62ya9Ya9wW745Q2648Us8upG65+4u5LFGvP4MLIi55pK
xD86vKz1IVngR2Jstv2/1VgKHAVm/LV9HRu2eC+5caN5gY/QORgJ3Af+Bvsh
V41l4P4Hi3HPr0qG3pX4fkQx9X4p8mS78xNxut3vKTASvjnX/omdsAm2Ad/N
KIT/ULuaXT9qxfNMFmufzSIvk786xOtUOWo5uWy6/XZLGjITa8Rdg3Md+LDR
Y/RCDgHnc+4NVcH32zr7O2rlNOoqtsEuz4lvAzisEPfYbt940viVnIes1O7W
JGogPk4Ob9He+42FuP+GSuz/g+aXl8Nnz6Th3/gM/nyhGD6NHlmvMd5ea8w9
JB84GPwOz2a/c9YbPzDuVgqsDwaY6RyNH57U3IOlyAPNio+lkqdQFfqjvx77
xADxCO0vqoP+kuT9TTnqD5gSfPYpLs1HHMD3hPb+NAvdUifhSy7l7LzPBxui
F3SSVz8wC8wE1uP+xAh1EH1TQ8C3m13r8eejrkPEwjHndHxmgTEP9qyxTckz
fZyHR5TiTcTbCJw4wrGJz2d+87Yao5BveVvjC+i7phiYem0S+PqcMTa273DN
419OL//PIffVGCcsME/eJnvti9OMwU4ah60x3uXu1L4Trn/EIH6MP3/kuxPL
YLbj13FbPuooekD3x9PQ/3zrh1yBvtjP+/EN5wRiGbxzxPGI/lp99zrnPmw0
3PzQ4THrnTPrLSv1F/zQ4HfoEdchzgS31hi7gi8aTdPZeXq2cRd5eYnfidie
2GkwLgGT7DY9eutfifghNroZt3Bmk+tTf2OVJr+RGyuRR4h18j78ap0Pm4yN
yZ1XnT+RearrC3V1id81U3ROtyzk4y05IgvfQYejLD9+BPbAly5WRy0njobL
LzZWh3zHHc/YrksW/3f4f9C3EvmUXIo/UZepLcTcq467Xf/3fwveE1wfwQ43
ZpGzfqbxx6WIJd7vI7Pwo3rn/qvOCdRZ/PN1117yP3WVu2OvxcYW3IW6UW9d
jbGtOQcM9a1y4CjwyBP2DezRYEyFL5Mr8WfeOsNK8d6hPr9YDptstnycedh4
HhyLH5ADwDxgKt7hvBHeNl5+y37Le2O3adod98iOjpC/Oo2cOcT5k5xFvmrx
fxDqOfbm/tRq/AIf4r68sy9VR05kjf9y/AebbByCruD/DctAzzc5jRwyxLyo
e53t82AA8AN8B/nMtX6vwZc3+NxK/BcDx/GPmX913K3RGIUa9Ep12Btbky+p
o+gL3shALI/X+uOV0AHvYnRI/ltRjn9w5CRqTifXHdagId4n+X9imzHLVGMY
1tucVwcTi1nYEB03W7+8D7a4FvNm5Y2H7S6I9lIWdwTnTsjC//4L4yUdgQ==

         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwllVlsV1UQxs9/4557L7UsiVIqaFkkSuoCPBiNBtBSoEgMmlq3FxK3B1wT
BNTEChEXEktfKKC0lFbwqYpvJmJUCLjGuDyYmPhiQC1BWuofS2vr7/N7mGTm
zDdzZs4sp2HjUxueLIYQXoLK0FAWwi1JCJ2VEHZDV+Uh7Ef+Av4k1In+2hjC
ToxOQL3oe6Cl2B6dEsI4+g/SEGpx1gO+B342+AvIk6UQrsPXg8i/Yrsbm3bw
M5A3IR+HbkNf5WwPtlcUQliH7jDyLOTZUBPye/hM8DcD+RC6Pmha2TF1Eksf
+iJyCRpFdwR5Cvx+8N3wFznbCz9BPH3gD0JN3HWc+Efw/z6Yy8BvRv8z8ivo
l6F7GPkn4luKvBy+lvuWK57MsR1DXoJ8t/KFr+Hsevi96H9A7oCexfZpaDP8
Qnw2wN+Jz8aC37ge/C5oTsmYG9DfCP1ScU778PUWcgu2A2DuAPsqZ8PoasEs
Q96B/kds+4t++2dy36UabIFfoJyKvqML+R7sj6Gbif0YunHoczUFMc2B7838
1ls564JvjM5FbzCAfAbf84HPq/jtBqCast/wZnJbEf02E2A+Bj8CfiN8N/Z1
0TVRLZTD7eAPpu6VOu6/HPksNm/g+ztsHiXeIjZt+JuFn9fQzY2OTTnXwJ+F
PoJ/BNoF/k3ok4J76nH4bdic5q567NeDrcqe+4bA3wc/qfdBriIPKjdsvsL2
PPIhYutNHds7Jed6jWzKzrlIvAvAfw1+WP5y95B6J8XXQ/BLwPxGLp/iYx76
SfUw+C+hFnTj+DyJbiv0Ify6xPwp6HewpejcXwa/Bt3fyFvwP73su6dy1lpx
DIr9HNjFFeewCewK9AfgK9jsSzzjmu1T0IXMM6lZ1A5QrFfn1ilmzW6BmLaX
PMOaHe0Azb5mSL2ZJ55t9eiLmXtAtT9Tdm32YF8tuUbdmWdGszJV96MbhZ4A
ewJ/f6LvwP4zdK9DHfivT9wLd+H/EvqxzL2nGerIPBOaBdVkpmqZeVdpxzRj
fyDzXaPqd+66lLoWevOmxDVRLRRDV+KYFIt66AF0rdBKfGXcvzLxm+otI/i/
4PtT757nOBtMfKfu0g6qohuRP+THkF8glunRb6OePI3Ptuje00wFbCfAbCu4
R97F9nDq2W/gbDDzG+ltNCPTontcva0dvDhxT6oXd1Yce1vuXlQO/2B7LnrX
aicugm+GvkH3fMm9tRr7saJ7rIBtc+Je7K94dq6MzlUzdGt0jVQbzegQ8vno
WN9Gvgh/UzSvHXmE+0ejd02ddjL8v9Gz+/8OSh2TYlHPafdrp2uX6w9Qb9yf
uxbqkVVgVyXeZcphbuIZ1uzu4OyPzDOk2WmvuBbDmf861WSt6pd5F2hnr46u
sWr7LXKr5i117VTzIXwvSr0LtNO0O4SRTjtEtSvmfivVcE30zGpWv8ff0dR/
pv5K/WELtYty/z3a0fei25D5r9GO1l/YEv1W+hMbc+9U7VL9EduR23Pvfv1Z
/wFf+wkR
         "],
         VertexColors->None]}]}, 
     {RGBColor[0.941176, 0.906538, 0.834043], EdgeForm[None], 
      GraphicsGroupBox[PolygonBox[CompressedData["
1:eJxNmF1s1+UVx5/ff/ZXWWkxpJZSKmGsQFuZCRELCDGtnZSXoAm0lReHWmjB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        "],
        VertexColors->None]]}}, {{}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[LineBox[{2980, 2977, 2978, 2976, 1712}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{2120, 1858, 2157, 1857, 1437}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{2121, 1865, 2293, 1864, 721}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{1771, 2851, 1774, 1322}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{1794, 2852, 1804, 1365}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{1411, 1822, 1771}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{1414, 1835, 1794}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{2120, 1601}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{2121, 1603}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{274, 2980}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1846, 2455, 2284, 2061, 2298, 2062, 2301, 2302, 2114, 2300, 
         2299, 2297, 2728, 2123, 2727, 2124, 2729, 2112, 2113, 1848, 2684, 
         2065, 2683, 2682, 2920, 2064, 2965, 2481, 2812, 2482, 2724, 2723, 
         2088, 2938, 2089, 2706, 2921, 2690, 2067, 2688, 2066, 2689, 2803, 
         1850, 2801, 2802, 2548, 2550, 2549, 1878, 2303, 2135, 2136, 1766, 
         2189, 1767, 2735, 2734, 2811, 2810, 1860, 2849, 1947, 2847, 1946, 
         2848, 1842, 2140, 1945, 2461, 2554, 2555, 1948, 2556, 1867, 2813, 
         1868, 2483, 1863, 2817, 2818, 2814, 2816, 2815, 2850, 1861, 2966, 
         2553, 2547, 1944, 2546, 1943, 2955, 2956, 2805, 2806, 1853, 2286, 
         2808, 2807, 2463, 2073, 2694, 2115, 2704, 2086, 2479, 2480, 2292, 
         2083, 2937, 2085, 2935, 2084, 2936, 2188, 2075, 2928, 2930, 2929, 
         2074, 2464, 2465, 1854, 2226, 1855, 2466, 2467, 2342, 2343, 1777, 
         2185, 1780, 2749, 2861, 2860, 2864, 2863, 2862, 2468, 2962, 2469, 
         2287, 2981, 2076, 2294, 2126, 2725, 2122, 2633, 2865, 2713, 2094, 
         2711, 2093, 2712, 2231, 2867, 2005, 2642, 2644, 2967, 2643, 2968, 
         1862, 2118, 2119, 2087, 2304, 2305, 2139, 1834, 1793, 2715, 1803, 
         2959, 2714, 2360, 2471, 2470, 1856, 2288, 2289, 2097, 2295, 2127, 
         2128, 2098, 2719, 2718, 2887, 2027, 2963, 2472, 2809, 2473, 2117, 
         2722, 2077, 2931, 2078, 2696, 2029, 2948, 2100, 2945, 2947, 2946, 
         2265, 2903, 2904, 2902, 2906, 2905, 1936, 2794, 2795, 2796, 1814, 
         2271, 1819, 2960, 2107, 2050, 2918, 2051, 2792, 2793}],
        "0.9`"],
       Annotation[#, 0.9, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{2277, 2272, 2916, 2048, 2915, 2049, 2917, 2044, 2270, 2784, 
         2783, 2104, 2951, 2042, 2950, 2103, 2781, 2782, 1813, 2263, 1809, 
         1838, 2438, 2437, 1929, 2890, 2891, 2888, 2028, 2889, 2254, 2659, 
         2025, 2658, 2026, 2252, 2251, 2363, 2362, 2361, 2096, 2717, 2009, 
         2655, 2656, 2357, 2765, 1802, 2249, 1792, 1833, 2426, 2425, 1915, 
         2641, 2004, 2640, 2003, 2866, 2229, 2230, 2000, 2349, 2756, 2757, 
         2227, 2346, 2345, 2344, 2710, 2709, 1905, 2397, 2521, 2520, 2617, 
         2695, 2611, 2612, 2610, 1989, 2613, 2856, 2601, 2926, 2927, 2072, 
         2692, 2071, 2721, 2116, 2462, 2804, 2221, 1983, 2693, 2335, 2336, 
         2176, 1770, 2331, 2330, 2460, 2459, 1852, 2214, 1851, 2458, 2457, 
         2068, 2924, 2925, 2923, 2070, 2187, 2702, 2081, 2701, 2082, 2291, 
         2290, 2478, 2477, 2476, 2934, 2933, 2703, 2474, 2552, 2551, 2125, 
         2158, 1866, 2142, 2456, 2206, 1965, 2686, 2687, 2314, 2705, 1765, 
         2154, 1762, 2964, 2312, 2055, 2201, 2054, 2279, 2281, 2280, 1844, 
         2679, 2680, 2678, 2059, 2681, 2854, 2560, 2940, 2941, 2090, 2939, 
         2730}],
        "0.8`"],
       Annotation[#, 0.8, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1818, 2791, 2450, 2449, 2448, 1942, 2911, 2912, 2910, 2043, 
         2264, 2909, 2040, 2908, 2041, 2262, 2261, 2775, 2774, 2773, 2944, 
         2943, 1928, 2840, 1927, 2972, 2660, 2886, 2885, 2253, 2882, 2883, 
         2881, 2024, 2884, 2020, 2250, 2359, 2358, 2095, 2716, 2008, 2651, 
         2652, 2356, 2764, 1801, 2247, 1791, 1832, 2424, 2423, 1914, 2639, 
         2002, 2638, 2001, 2228, 1996, 2636, 1998, 2347, 2754, 1784, 2186, 
         1779, 2748, 2399, 2398, 2396, 1904, 2615, 2616, 2614, 1990, 2858, 
         2222, 2223, 1987, 2339, 2744, 2745, 2181, 1773, 2338, 2337, 2600, 
         2599, 1894, 2220, 1893, 2175, 2218, 2217, 2691, 2069, 2584, 1974, 
         2327, 1975, 2170, 2922, 2169, 2326, 2325, 2700, 1972, 2213, 2475, 
         1859, 2211, 2961, 2212, 2080, 2698, 2079, 2932, 2141, 2685, 2563, 
         2564, 2315, 1964, 2565, 1876, 2155, 2311, 2669, 1959, 2202, 2454, 
         2198, 1955, 2561, 1958, 2308, 2310, 1760, 2147, 2194}],
        "0.7`"],
       Annotation[#, 0.7, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1952, 2195, 2146, 2307, 2148, 1954, 2130, 1953, 2196, 2283, 
         2282, 2199, 2200, 2153, 1875, 2205, 1877, 2566, 2567, 2316, 2317, 
         2318, 2166, 2697, 2167, 1970, 2323, 2576, 2575, 2699, 2579, 2501, 
         2502, 2376, 1889, 2707, 2091, 2328, 2329, 2215, 1976, 2594, 1981, 
         2591, 2593, 2592, 2177, 2598, 2512, 2513, 2387, 1899, 2708, 2092, 
         2340, 2341, 2224, 1988, 2628, 1995, 2625, 2627, 2626, 2184, 2859, 
         2631, 2632, 2825, 2824, 1911, 2637, 2979, 1999, 2348, 2755, 2536, 
         1913, 2421, 2422, 1831, 1790, 2245, 1800, 2763, 2355, 2016, 2650, 
         2007, 2248, 2018, 2653, 2019, 2654, 1922, 2430, 2431, 1836, 1806, 
         2257, 1808, 2772, 2771, 2099, 2942, 2034, 2260, 2035, 2900, 2036, 
         2901, 1935, 2444, 2445, 1840, 1812, 2269, 1817, 2790, 2789, 2106, 
         2952, 2046, 2276, 2047}],
        "0.6`"],
       Annotation[#, 0.6, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{218, 2664, 2039, 2665, 2780, 2779, 2102, 2949, 1934, 2844, 
         1933, 2973, 2661, 2899, 2898, 2258, 2897, 2032, 2896, 2033, 2256, 
         2255, 1805, 2768, 2429, 2428, 2427, 1921, 2874, 2875, 2873, 2017, 
         2246, 2006, 2648, 2014, 2354, 2762, 1799, 2242, 1789, 1830, 2420, 
         2419, 1912, 2535, 2753, 2634, 1997, 2635, 1910, 2408, 1909, 2526, 
         2630, 2629, 2225, 2621, 1992, 2620, 1993, 2183, 2182, 1776, 2743, 
         2389, 2388, 2386, 1898, 2596, 2597, 2595, 1982, 2216, 1977, 2588, 
         1980, 2332, 2739, 1772, 2173, 1769, 1821, 2377, 2375, 1887, 2499, 
         2733, 2324, 1971, 2578, 1884, 2210, 1883, 2165, 2208, 2207, 2156, 
         2203, 1961, 2133, 1962, 2152, 2151, 1761, 2309, 2131, 2129, 2197, 
         1869, 803, 2144, 2306}],
        "0.5`"],
       Annotation[#, 0.5, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1759, 2143, 2671, 2145, 2193, 2192, 1870, 2150, 1956, 2488, 
         1957, 2559, 1873, 2204, 2132, 2134, 2313, 1764, 2162, 2163, 1968, 
         2321, 2572, 2571, 2168, 2577, 2497, 2498, 2372, 1888, 2500, 1973, 
         2581, 2583, 2582, 1892, 2219, 2137, 2138, 2333, 2334, 2178, 2179, 
         1985, 2604, 2606, 2605, 2180, 2857, 2608, 2609, 2518, 2823, 1903, 
         2519, 1994, 2622, 2624, 2623, 1908, 2407, 2409, 2410, 2751, 2752, 
         2533, 2534, 2417, 2418, 1829, 1788, 2239, 1798, 2761, 2353, 2013, 
         2244, 2243, 2872, 2015, 2649, 2970, 1919, 2833, 1920, 2879, 2880, 
         2766, 2767, 2541, 1926, 2435, 2436, 1837, 1807, 2259, 1811, 2778, 
         2777, 2101, 2268, 2267, 2907, 2038, 2663, 2975, 1940, 2846, 1941, 
         2913, 2914, 2787, 2788}],
        "0.4`"],
       Annotation[#, 0.4, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{2060, 2672, 2056, 2670, 2674, 2673, 1950, 2278, 1949, 2190, 
         2149, 2558, 2487, 2958, 2489, 2365, 1874, 2490, 1963, 2161, 1881, 
         2209, 1882, 2574, 1969, 2322, 2732, 2494, 1886, 2371, 2373, 2374, 
         2737, 1768, 2171, 2172, 1978, 2585, 2587, 2586, 2174, 2855, 2589, 
         2590, 2509, 2511, 2741, 2510, 2607, 1986, 2517, 1901, 2393, 1902, 
         2619, 1991, 2618, 2747, 2525, 1907, 2404, 2405, 2406, 2750, 1783, 
         2531, 2532, 2415, 2416, 1828, 1787, 2236, 1797, 2760, 2352, 2012, 
         2241, 2240, 2870, 2871, 2647, 2969, 1917, 2832, 1918, 2539, 2022, 
         2877, 2023, 2878, 1925, 2432, 2433, 2434, 2769, 2770, 2542, 2543, 
         2442, 2443, 1839, 1810, 2266, 1816, 2786, 2785, 2105, 2274, 2273, 
         2275}],
        "0.3`"],
       Annotation[#, 0.3, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1815, 1841, 2447, 2446, 1939, 2545, 2776, 2441, 2440, 2439, 
         1932, 2895, 2031, 2894, 2030, 2540, 1924, 2839, 1923, 2971, 2657, 
         2021, 2538, 1916, 2831, 2537, 2646, 2645, 2869, 2237, 2238, 2011, 
         2351, 2759, 1796, 2233, 1786, 1827, 2414, 2413, 2530, 2529, 1782, 
         1825, 2403, 2402, 1906, 2524, 2746, 2395, 2394, 2392, 1900, 2516, 
         2742, 2602, 1984, 2603, 1897, 2383, 1896, 2508, 1979, 2506, 1891, 
         2379, 2505, 2504, 2580, 2495, 2496, 2368, 2493, 2492, 2573, 2164, 
         2568, 2569, 2319, 1966, 2160, 2159, 1763, 1820, 2366, 2364, 2485, 
         2957, 2484, 2668, 2667, 2919, 2053, 2452, 2052, 2666, 2191, 1843, 
         2451, 2063, 2720, 2109, 2726, 2108, 2296, 1845}],
        "0.2`"],
       Annotation[#, 0.2, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1849, 2799, 2800, 2797, 2798, 1847, 2285, 2110, 2953, 2111, 
         2954, 2058, 2677, 2982, 2676, 2453, 2057, 2675, 1951, 2853, 2557, 
         2819, 1871, 2820, 1872, 2486, 1960, 2562, 2821, 1879, 2822, 1880, 
         2570, 1967, 2320, 2731, 2491, 1885, 2367, 2369, 2370, 2736, 2503, 
         1890, 2378, 2380, 2381, 2738, 2507, 1895, 2382, 2384, 2385, 2740, 
         1775, 2514, 2515, 2390, 2391, 1823, 1778, 2522, 2523, 2400, 2401, 
         1824, 1781, 2527, 2528, 2411, 2412, 1826, 1785, 2232, 1795, 2758, 
         2350, 2010, 2235, 2234, 2868, 2827, 2828, 2826, 2830, 2829, 2876, 
         2835, 2836, 2834, 2838, 2837, 2892, 2893, 2842, 1930, 2841, 1931, 
         2843, 2037, 2662, 2974, 1937, 2845, 1938, 2544, 2045}],
        "0.1`"],
       Annotation[#, 0.1, "Tooltip"]& ]}, {}, {}, {}}}],
  AspectRatio->1,
  Frame->True,
  ImageMargins->0.,
  ImageSize->{225, Automatic},
  PlotRange->{{0, 5}, {1, 5}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{229, 234},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->353264365]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->25790],

Cell["The probability density function integrates to unity:", "ExampleText",
 CellID->5086],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"PDF", "[", 
    RowBox[{
     RowBox[{"UniformDistribution", "[", 
      RowBox[{"{", 
       RowBox[{"min", ",", "max"}], "}"}], "]"}], ",", "x"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "min", ",", "max"}], "}"}], ",", 
   RowBox[{"Assumptions", "\[Rule]", 
    RowBox[{"min", "<", "max"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->20967],

Cell[BoxData["1"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->862737987]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->243173396],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["DiscreteUniformDistribution",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DiscreteUniformDistribution"]], "InlineFormula"],
 " is the discrete analog of ",
 Cell[BoxData[
  ButtonBox["UniformDistribution",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/UniformDistribution"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->189625740],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PDF", "[", 
  RowBox[{
   RowBox[{"UniformDistribution", "[", 
    RowBox[{"{", 
     RowBox[{"min", ",", "max"}], "}"}], "]"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1944295],

Cell[GraphicsData["CompressedBitmap", "\<\
eJytVUtOAzEMTfNp2nKAlgVShZC4A12xgRUHQGLBqEJqhSpQ6R1Y9UxztJCP
HTzGSAzTSJPEjuf5xXaSh+awedk1h+26Wd7vm/fNdv2xvHvbR5UZKaWO8Zsv
VJyHOMvfMYQ4mtibKH5WSSUx5KYmqRsXmfY2DspVsUzU+BfrBFigS9PMy2Mv
3wbANCDZ6rprmr24igfue/h2DLBYWYqYOHjRdqh3TWKWek12TDjA1rO1pfmg
0XkSvcgZv2Lyc49/ixaZruLoWeYNqZvSECKRd7CI3DXIqPeg92RdV5+UyUrM
iWVWco6mzMr+iPhMsuhTAR00I+4gV6Bp2xbidJnDF2VYPxuwQw+xwzqbhv6V
jCfQipVwM4AdVsCMsEKW8pm0J+RTa4roHWHSzd0k/PMOECqAc56HUvkXoXuD
IlN6D9IzxquT3pU1jmyd46NOs3+1yPScya9/srpm8u0JsWWrBexiV1e/X77y
GqrRF7hRePA=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{141, 23},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->40331222]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PDF", "[", 
  RowBox[{
   RowBox[{"DiscreteUniformDistribution", "[", 
    RowBox[{"{", 
     RowBox[{"min", ",", "max"}], "}"}], "]"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->104651907],

Cell[BoxData[
 FractionBox["1", 
  RowBox[{"1", "+", "max", "-", "min"}]]], "Output",
 ImageSize->{83, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->168594113]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->17929],

Cell["Moments can be obtained from the characteristic function:", \
"ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->3912],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExpectedValue", "[", 
  RowBox[{
   RowBox[{"x", "^", "4"}], ",", 
   RowBox[{"UniformDistribution", "[", 
    RowBox[{"{", 
     RowBox[{"min", ",", "max"}], "}"}], "]"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->4715],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "5"], " ", 
  RowBox[{"(", 
   RowBox[{
    SuperscriptBox["max", "4"], "+", 
    RowBox[{
     SuperscriptBox["max", "3"], " ", "min"}], "+", 
    RowBox[{
     SuperscriptBox["max", "2"], " ", 
     SuperscriptBox["min", "2"]}], "+", 
    RowBox[{"max", " ", 
     SuperscriptBox["min", "3"]}], "+", 
    SuperscriptBox["min", "4"]}], ")"}]}]], "Output",
 ImageSize->{295, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->639197896]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"cf", "=", 
  RowBox[{"CharacteristicFunction", "[", 
   RowBox[{
    RowBox[{"UniformDistribution", "[", 
     RowBox[{"{", 
      RowBox[{"min", ",", "max"}], "}"}], "]"}], ",", "t"}], "]"}]}]], "Input",\

 CellLabel->"In[2]:=",
 CellID->24286475],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{"\[ImaginaryI]", " ", 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"\[ImaginaryI]", " ", "max", " ", "t"}]], "-", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"\[ImaginaryI]", " ", "min", " ", "t"}]]}], ")"}]}], 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"max", "-", "min"}], ")"}], " ", "t"}]]}]], "Output",
 ImageSize->{129, 38},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->218729635]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{
   RowBox[{"D", "[", 
    RowBox[{"cf", ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "4"}], "}"}]}], "]"}], ",", 
   RowBox[{"t", "\[Rule]", "0"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->12536],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "5"], " ", 
  RowBox[{"(", 
   RowBox[{
    SuperscriptBox["max", "4"], "+", 
    RowBox[{
     SuperscriptBox["max", "3"], " ", "min"}], "+", 
    RowBox[{
     SuperscriptBox["max", "2"], " ", 
     SuperscriptBox["min", "2"]}], "+", 
    RowBox[{"max", " ", 
     SuperscriptBox["min", "3"]}], "+", 
    SuperscriptBox["min", "4"]}], ")"}]}]], "Output",
 ImageSize->{295, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->37662692]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->522933856],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  ButtonBox["Mean",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Mean"]], "InlineFormula"],
 " of 2 uniform random variables follows a ",
 Cell[BoxData[
  ButtonBox["TriangularDistribution",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TriangularDistribution"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->24312904],

Cell[BoxData[
 RowBox[{
  RowBox[{"vals", "=", 
   RowBox[{"Mean", "[", 
    RowBox[{"RandomReal", "[", 
     RowBox[{
      RowBox[{"UniformDistribution", "[", 
       RowBox[{"{", 
        RowBox[{"2", ",", "5"}], "}"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"2", ",", 
        RowBox[{"10", "^", "5"}]}], "}"}]}], "]"}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->787117276],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Mean", "[", "vals", "]"}], ",", 
   RowBox[{"Variance", "[", "vals", "]"}], ",", 
   RowBox[{"Skewness", "[", "vals", "]"}], ",", 
   RowBox[{"Kurtosis", "[", "vals", "]"}]}], "}"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->351190034],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"3.50243817789774`", ",", "0.37218836096498553`", ",", 
   RowBox[{"-", "0.0002525154446925353`"}], ",", "2.4078821641471455`"}], 
  "}"}]], "Output",
 ImageSize->{291, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->5671127]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"dist", "=", 
   RowBox[{"TriangularDistribution", "[", 
    RowBox[{"{", 
     RowBox[{"2", ",", "5"}], "}"}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->21506059],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Mean", "[", "dist", "]"}], ",", 
    RowBox[{"Variance", "[", "dist", "]"}], ",", 
    RowBox[{"Skewness", "[", "dist", "]"}], ",", 
    RowBox[{"Kurtosis", "[", "dist", "]"}]}], "}"}], "//", "N"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->655094753],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"3.5`", ",", "0.375`", ",", "0.`", ",", "2.4`"}], "}"}]], "Output",
 ImageSize->{143, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->47184764]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[Cell[BoxData[
   InterpretationBox[Cell[TextData[{
     "Possible Issues",
     "\[NonBreakingSpace]\[NonBreakingSpace]",
     Cell["(2)", "ExampleCount"]
    }], "ExampleSection"],
    $Line = 0; Null]]]], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->20340],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["UniformDistribution",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/UniformDistribution"]], "InlineFormula"],
 " is not defined when either ",
 Cell[BoxData[
  StyleBox["min", "TI"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  StyleBox["max", "TI"]], "InlineFormula"],
 " is a not a real number:"
}], "ExampleText",
 CellID->1360],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Mean", "[", 
  RowBox[{"UniformDistribution", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"3", "+", "I"}], ",", "4"}], "}"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2814],

Cell[BoxData[
 RowBox[{
  RowBox[{"UniformDistribution", "::", "\<\"realparm\"\>"}], ":", 
  " ", "\<\"Parameter \\!\\(3 + \[ImaginaryI]\\) is expected to be \
real.\"\>"}]], "Message", "MSG",
 CellID->916019427],

Cell[BoxData[
 RowBox[{"Mean", "[", 
  RowBox[{"UniformDistribution", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"3", "+", "\[ImaginaryI]"}], ",", "4"}], "}"}], "]"}], 
  "]"}]], "Output",
 ImageSize->{253, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->646779334]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["UniformDistribution",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/UniformDistribution"]], "InlineFormula"],
 " is not defined when ",
 Cell[BoxData[
  RowBox[{
   StyleBox["b", "TI"], "<", 
   StyleBox["a", "TI"]}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->19752],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Mean", "[", 
  RowBox[{"UniformDistribution", "[", 
   RowBox[{"{", 
    RowBox[{"8", ",", "6"}], "}"}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->3338],

Cell[BoxData[
 RowBox[{
  RowBox[{"UniformDistribution", "::", "\<\"posdiff\"\>"}], ":", 
  " ", "\<\"The difference \\!\\(-2\\) is expected to be positive.\"\>"}]], \
"Message", "MSG",
 CellID->31455775],

Cell[BoxData[
 RowBox[{"Mean", "[", 
  RowBox[{"UniformDistribution", "[", 
   RowBox[{"{", 
    RowBox[{"8", ",", "6"}], "}"}], "]"}], "]"}]], "Output",
 ImageSize->{233, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->102835170]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->19046],

Cell["\<\
Substitution of invalid parameters into symbolic outputs gives results that \
are not meaningful:\
\>", "ExampleText",
 CellID->16727],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Mean", "[", 
   RowBox[{"UniformDistribution", "[", 
    RowBox[{"{", 
     RowBox[{"min", ",", "max"}], "}"}], "]"}], "]"}], "/.", 
  RowBox[{"{", 
   RowBox[{"min", "\[Rule]", 
    RowBox[{"3", "+", "I"}]}], "}"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->25838],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "2"], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"3", "+", "\[ImaginaryI]"}], ")"}], "+", "max"}], 
   ")"}]}]], "Output",
 ImageSize->{108, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->164051492]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->18345],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["TriangularDistribution",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TriangularDistribution"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Piecewise",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Piecewise"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["RandomReal",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RandomReal"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->20979]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->786],

Cell[TextData[ButtonBox["Continuous Distributions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ContinuousDistributions"]], "Tutorials",
 CellID->7471]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["Demonstrations with UniformDistribution",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=\
UniformDistribution"], None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Continuous Statistical Distributions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ContinuousStatisticalDistributions"]], "MoreAbout",\

 CellID->52007390]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"UniformDistribution - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 28, 15.8348418}", "context" -> "System`", 
    "keywords" -> {"rectangular distribution"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "UniformDistribution[{min, max}] represents a continuous uniform \
statistical distribution giving values between min and max. ", 
    "synonyms" -> {"uniform distribution"}, "title" -> "UniformDistribution", 
    "type" -> "Symbol", "uri" -> "ref/UniformDistribution"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[7587, 248, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->118102213]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 115173, 2656}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2075, 52, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2698, 79, 1584, 37, 70, "ObjectNameGrid"],
Cell[4285, 118, 793, 25, 70, "Usage",
 CellID->3480]
}, Open  ]],
Cell[CellGroupData[{
Cell[5115, 148, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5593, 165, 781, 30, 70, "Notes",
 CellID->429991538],
Cell[6377, 197, 470, 18, 70, "Notes",
 CellID->10777],
Cell[6850, 217, 700, 26, 70, "Notes",
 CellID->33143606]
}, Closed]],
Cell[CellGroupData[{
Cell[7587, 248, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->118102213],
Cell[CellGroupData[{
Cell[7972, 262, 148, 5, 70, "ExampleSection",
 CellID->186429671],
Cell[8123, 269, 135, 2, 70, "ExampleText",
 CellID->14752],
Cell[CellGroupData[{
Cell[8283, 275, 193, 6, 28, "Input",
 CellID->521],
Cell[8479, 283, 204, 7, 51, "Output",
 CellID->92315435]
}, Open  ]],
Cell[CellGroupData[{
Cell[8720, 295, 199, 6, 28, "Input",
 CellID->21982],
Cell[8922, 303, 280, 10, 51, "Output",
 CellID->118732657]
}, Open  ]],
Cell[9217, 316, 120, 3, 70, "ExampleDelimiter",
 CellID->7688],
Cell[9340, 321, 116, 2, 70, "ExampleText",
 CellID->19919],
Cell[CellGroupData[{
Cell[9481, 327, 220, 7, 28, "Input",
 CellID->17236],
Cell[9704, 336, 712, 16, 44, "Output",
 Evaluatable->False,
 CellID->394866916]
}, Open  ]],
Cell[CellGroupData[{
Cell[10453, 357, 387, 14, 28, "Input",
 CellID->27065],
Cell[10843, 373, 935, 19, 175, "Output",
 Evaluatable->False,
 CellID->39625058]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[11827, 398, 216, 7, 70, "ExampleSection",
 CellID->31496],
Cell[12046, 407, 111, 3, 70, "ExampleText",
 CellID->26386],
Cell[CellGroupData[{
Cell[12182, 414, 223, 7, 70, "Input",
 CellID->21011],
Cell[12408, 423, 332, 10, 36, "Output",
 CellID->72960747]
}, Open  ]],
Cell[12755, 436, 120, 3, 70, "ExampleDelimiter",
 CellID->7547],
Cell[12878, 441, 99, 3, 70, "ExampleText",
 CellID->20699375],
Cell[CellGroupData[{
Cell[13002, 448, 199, 6, 70, "Input",
 CellID->12121],
Cell[13204, 456, 158, 5, 36, "Output",
 CellID->240316009]
}, Open  ]],
Cell[CellGroupData[{
Cell[13399, 466, 198, 6, 70, "Input",
 CellID->6702],
Cell[13600, 474, 178, 6, 51, "Output",
 CellID->217910278]
}, Open  ]],
Cell[13793, 483, 121, 3, 70, "ExampleDelimiter",
 CellID->31539],
Cell[13917, 488, 237, 9, 70, "ExampleText",
 CellID->2572],
Cell[CellGroupData[{
Cell[14179, 501, 224, 7, 70, "Input",
 CellID->2257],
Cell[14406, 510, 279, 10, 36, "Output",
 CellID->12885900]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[14734, 526, 223, 7, 70, "ExampleSection",
 CellID->19359],
Cell[14960, 535, 112, 3, 70, "ExampleText",
 CellID->58263126],
Cell[CellGroupData[{
Cell[15097, 542, 266, 8, 70, "Input",
 CellID->414756667],
Cell[15366, 552, 291, 10, 53, "Output",
 CellID->870878425]
}, Open  ]],
Cell[CellGroupData[{
Cell[15694, 567, 237, 7, 70, "Input",
 CellID->643111847],
Cell[15934, 576, 175, 5, 36, "Output",
 CellID->251302002]
}, Open  ]],
Cell[16124, 584, 125, 3, 70, "ExampleDelimiter",
 CellID->108450639],
Cell[16252, 589, 112, 3, 70, "ExampleText",
 CellID->29591],
Cell[CellGroupData[{
Cell[16389, 596, 386, 13, 70, "Input",
 CellID->25867],
Cell[16778, 611, 1939, 42, 171, "Output",
 CellID->326071763]
}, Open  ]],
Cell[18732, 656, 120, 3, 70, "ExampleDelimiter",
 CellID->1675],
Cell[18855, 661, 220, 9, 70, "ExampleText",
 CellID->12136],
Cell[CellGroupData[{
Cell[19100, 674, 418, 13, 70, "Input",
 CellID->30499],
Cell[19521, 689, 79740, 1364, 70, "Output",
 CellID->353264365]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[99310, 2059, 233, 7, 70, "ExampleSection",
 CellID->25790],
Cell[99546, 2068, 91, 1, 70, "ExampleText",
 CellID->5086],
Cell[CellGroupData[{
Cell[99662, 2073, 430, 13, 70, "Input",
 CellID->20967],
Cell[100095, 2088, 158, 5, 36, "Output",
 CellID->862737987]
}, Open  ]],
Cell[100268, 2096, 125, 3, 70, "ExampleDelimiter",
 CellID->243173396],
Cell[100396, 2101, 389, 12, 70, "ExampleText",
 CellID->189625740],
Cell[CellGroupData[{
Cell[100810, 2117, 222, 7, 70, "Input",
 CellID->1944295],
Cell[101035, 2126, 711, 16, 70, "Output",
 Evaluatable->False,
 CellID->40331222]
}, Open  ]],
Cell[CellGroupData[{
Cell[101783, 2147, 232, 7, 70, "Input",
 CellID->104651907],
Cell[102018, 2156, 215, 7, 51, "Output",
 CellID->168594113]
}, Open  ]],
Cell[102248, 2166, 121, 3, 70, "ExampleDelimiter",
 CellID->17929],
Cell[102372, 2171, 234, 6, 70, "ExampleText",
 CellID->3912],
Cell[CellGroupData[{
Cell[102631, 2181, 263, 8, 70, "Input",
 CellID->4715],
Cell[102897, 2191, 530, 18, 51, "Output",
 CellID->639197896]
}, Open  ]],
Cell[CellGroupData[{
Cell[103464, 2214, 272, 9, 70, "Input",
 CellID->24286475],
Cell[103739, 2225, 551, 17, 59, "Output",
 CellID->218729635]
}, Open  ]],
Cell[CellGroupData[{
Cell[104327, 2247, 258, 9, 70, "Input",
 CellID->12536],
Cell[104588, 2258, 529, 18, 51, "Output",
 CellID->37662692]
}, Open  ]],
Cell[105132, 2279, 125, 3, 70, "ExampleDelimiter",
 CellID->522933856],
Cell[105260, 2284, 508, 17, 70, "ExampleText",
 CellID->24312904],
Cell[105771, 2303, 402, 13, 70, "Input",
 CellID->787117276],
Cell[CellGroupData[{
Cell[106198, 2320, 287, 8, 70, "Input",
 CellID->351190034],
Cell[106488, 2330, 318, 9, 36, "Output",
 CellID->5671127]
}, Open  ]],
Cell[106821, 2342, 213, 7, 70, "Input",
 CellID->21506059],
Cell[CellGroupData[{
Cell[107059, 2353, 316, 9, 70, "Input",
 CellID->655094753],
Cell[107378, 2364, 236, 7, 36, "Output",
 CellID->47184764]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[107663, 2377, 327, 9, 70, "ExampleSection",
 CellID->20340],
Cell[107993, 2388, 378, 13, 70, "ExampleText",
 CellID->1360],
Cell[CellGroupData[{
Cell[108396, 2405, 216, 7, 70, "Input",
 CellID->2814],
Cell[108615, 2414, 212, 5, 70, "Message",
 CellID->916019427],
Cell[108830, 2421, 325, 11, 36, "Output",
 CellID->646779334]
}, Open  ]],
Cell[109170, 2435, 323, 12, 70, "ExampleText",
 CellID->19752],
Cell[CellGroupData[{
Cell[109518, 2451, 190, 6, 70, "Input",
 CellID->3338],
Cell[109711, 2459, 204, 5, 70, "Message",
 CellID->31455775],
Cell[109918, 2466, 284, 9, 36, "Output",
 CellID->102835170]
}, Open  ]],
Cell[110217, 2478, 121, 3, 70, "ExampleDelimiter",
 CellID->19046],
Cell[110341, 2483, 144, 4, 70, "ExampleText",
 CellID->16727],
Cell[CellGroupData[{
Cell[110510, 2491, 302, 10, 70, "Input",
 CellID->25838],
Cell[110815, 2503, 318, 12, 51, "Output",
 CellID->164051492]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[111194, 2522, 311, 9, 70, "SeeAlsoSection",
 CellID->18345],
Cell[111508, 2533, 730, 26, 70, "SeeAlso",
 CellID->20979]
}, Open  ]],
Cell[CellGroupData[{
Cell[112275, 2564, 312, 9, 70, "TutorialsSection",
 CellID->786],
Cell[112590, 2575, 157, 3, 70, "Tutorials",
 CellID->7471]
}, Open  ]],
Cell[CellGroupData[{
Cell[112784, 2583, 305, 8, 70, "RelatedLinksSection"],
Cell[113092, 2593, 380, 12, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[113509, 2610, 299, 8, 70, "MoreAboutSection"],
Cell[113811, 2620, 183, 4, 70, "MoreAbout",
 CellID->52007390]
}, Open  ]],
Cell[114009, 2627, 27, 0, 70, "History"],
Cell[114039, 2629, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

