(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     16159,        586]
NotebookOptionsPosition[     12098,        449]
NotebookOutlinePosition[     13604,        492]
CellTagsIndexPosition[     13478,        486]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"MathLink" :> 
          Documentation`HelpLookup["paclet:tutorial/MathLink"], 
          "Installing Existing MathLink-Compatible Programs" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/InstallingExistingMathLinkCompatiblePrograms"], 
          "Setting Up External Functions to Be Called from Mathematica" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/\
SettingUpExternalFunctionsToBeCalledFromMathematica"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"MathLink\"\>", 
       2->"\<\"Installing Existing MathLink-Compatible Programs\"\>", 
       3->"\<\"Setting Up External Functions to Be Called from \
Mathematica\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Install" :> Documentation`HelpLookup["paclet:ref/Install"], 
          "LinkClose" :> Documentation`HelpLookup["paclet:ref/LinkClose"], 
          "Close" :> Documentation`HelpLookup["paclet:ref/Close"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Install\"\>", 
       2->"\<\"LinkClose\"\>", 3->"\<\"Close\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Installable MathLink Programs" :> 
          Documentation`HelpLookup[
           "paclet:guide/InstallableMathLinkPrograms"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Installable MathLink Programs\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Uninstall", "ObjectName",
 CellID->31498],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Uninstall",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Uninstall"], "[", 
       StyleBox["link", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]terminates an external program started by ",
     Cell[BoxData[
      ButtonBox["Install",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Install"]], "InlineFormula"],
     ", and removes ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " definitions set up by it. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->31507]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The argument of ",
 Cell[BoxData[
  ButtonBox["Uninstall",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Uninstall"]], "InlineFormula"],
 " is a ",
 Cell[BoxData[
  ButtonBox["LinkObject",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LinkObject"]], "InlineFormula"],
 " representing a ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " link as returned by ",
 Cell[BoxData[
  ButtonBox["Install",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Install"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->21153],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Uninstall",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Uninstall"]], "InlineFormula"],
 " calls ",
 Cell[BoxData[
  ButtonBox["Unset",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Unset"]], "InlineFormula"],
 " to remove definitions set up by ",
 Cell[BoxData[
  ButtonBox["Install",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Install"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->2474]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->202476192],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->50639116],

Cell[TextData[{
 "Start a ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 "-compatible external program:"
}], "ExampleText",
 CellContext->"Global`",
 CellID->672120963],

Cell[BoxData[
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{
   "$InstallationDirectory", "<>", " ", 
    "\"\</SystemFiles/Links/MathLink/DeveloperKit/\>\"", "<>", "$SystemID", 
    "<>", "\"\</PrebuiltExamples/\>\""}], "]"}], ";"}]], "Input",
 CellContext->"Global`",
 CellLabel->"In[1]:=",
 CellID->204973273],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"link", " ", "=", " ", 
  RowBox[{"Install", "[", "\"\<addtwo\>\"", "]"}]}]], "Input",
 CellContext->"Global`",
 CellLabel->"In[2]:=",
 CellID->576167007],

Cell[BoxData[
 RowBox[{"LinkObject", "[", 
  RowBox[{"\<\"addtwo\"\>", ",", "152", ",", "7"}], "]"}]], "Output",
 CellContext->"Global`",
 ImageSize->{181, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->361042881]
}, Open  ]],

Cell["Get usage information: ", "ExampleText",
 CellContext->"Global`",
 CellID->55592386],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "AddTwo"}]], "Input",
 CellContext->"Global`",
 CellLabel->"In[3]:=",
 CellID->789323511],

Cell[BoxData[
 StyleBox["\<\"AddTwo[x, y] gives the sum of two machine integers x and \
y.\"\>", "MSG"]], "Print", "PrintUsage",
 CellTags->"Info3384534718-5418799",
 CellID->93953692]
}, Open  ]],

Cell["Call an external function: ", "ExampleText",
 CellContext->"Global`",
 CellID->81592447],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AddTwo", "[", 
  RowBox[{"2", ",", "3"}], "]"}]], "Input",
 CellContext->"Global`",
 CellLabel->"In[4]:=",
 CellID->287478044],

Cell[BoxData["5"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->409763528]
}, Open  ]],

Cell["Terminate the external program:", "ExampleText",
 CellContext->"Global`",
 CellID->1721532427],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Uninstall", "[", "link", "]"}]], "Input",
 CellContext->"Global`",
 CellLabel->"In[5]:=",
 CellID->748324558],

Cell[BoxData["\<\"addtwo\"\>"], "Output",
 CellContext->"Global`",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->742651096]
}, Open  ]],

Cell["The external function is no longer available: ", "ExampleText",
 CellContext->"Global`",
 CellID->260617443],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AddTwo", "[", 
  RowBox[{"2", ",", "3"}], "]"}]], "Input",
 CellContext->"Global`",
 CellLabel->"In[6]:=",
 CellID->175341099],

Cell[BoxData[
 RowBox[{"AddTwo", "[", 
  RowBox[{"2", ",", "3"}], "]"}]], "Output",
 ImageSize->{86, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->64056550]
}, Open  ]],

Cell["Reset the directory to its previous value: ", "ExampleText",
 CellContext->"Global`",
 CellID->65464260],

Cell[BoxData[
 RowBox[{
  RowBox[{"ResetDirectory", "[", "]"}], ";"}]], "Input",
 CellContext->"Global`",
 CellLabel->"In[7]:=",
 CellID->24792145]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->24939],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Install",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Install"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["LinkClose",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LinkClose"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Close",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Close"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->6253]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->7522],

Cell[TextData[StyleBox[ButtonBox["MathLink",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/MathLink"],
 FontSlant->"Italic"]], "Tutorials",
 CellID->8685],

Cell[TextData[{
 ButtonBox["Installing Existing ",
  BaseStyle->"Link",
  ButtonData->
   "paclet:tutorial/InstallingExistingMathLinkCompatiblePrograms"],
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/InstallingExistingMathLinkCompatiblePrograms"],
  
  FontSlant->"Italic"],
 ButtonBox["-Compatible Programs",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/InstallingExistingMathLinkCompatiblePrograms"]
}], "Tutorials",
 CellID->22184],

Cell[TextData[{
 ButtonBox["Setting Up External Functions to Be Called from ",
  BaseStyle->"Link",
  ButtonData->
   "paclet:tutorial/SettingUpExternalFunctionsToBeCalledFromMathematica"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->
   "paclet:tutorial/SettingUpExternalFunctionsToBeCalledFromMathematica"],
  FontSlant->"Italic"]
}], "Tutorials",
 CellID->361474453]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->229989391],

Cell[TextData[ButtonBox["Installable MathLink Programs",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/InstallableMathLinkPrograms"]], "MoreAbout",
 CellID->264753474]
}, Open  ]],

Cell["New in 2  |  Last modified in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Uninstall - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 28, 17.2880040}", "context" -> "System`", 
    "keywords" -> {
     "remove external program", "terminate MathLink", 
      "uninstall external program"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Uninstall[link] terminates an external program started by Install, and \
removes Mathematica definitions set up by it. ", "synonyms" -> {}, "title" -> 
    "Uninstall", "type" -> "Symbol", "uri" -> "ref/Uninstall"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5386, 177, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->202476192]},
 "Info3384534718-5418799"->{
  Cell[7137, 250, 184, 4, 70, "Print",
   CellTags->"Info3384534718-5418799",
   CellID->93953692]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 13205, 475},
 {"Info3384534718-5418799", 13354, 479}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2434, 57, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3057, 84, 47, 1, 70, "ObjectName",
 CellID->31498],
Cell[3107, 87, 738, 23, 70, "Usage",
 CellID->31507]
}, Open  ]],
Cell[CellGroupData[{
Cell[3882, 115, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4360, 132, 536, 21, 70, "Notes",
 CellID->21153],
Cell[4899, 155, 450, 17, 70, "Notes",
 CellID->2474]
}, Closed]],
Cell[CellGroupData[{
Cell[5386, 177, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->202476192],
Cell[CellGroupData[{
Cell[5771, 191, 147, 5, 70, "ExampleSection",
 CellID->50639116],
Cell[5921, 198, 171, 7, 70, "ExampleText",
 CellID->672120963],
Cell[6095, 207, 319, 9, 70, "Input",
 CellID->204973273],
Cell[CellGroupData[{
Cell[6439, 220, 177, 5, 28, "Input",
 CellID->576167007],
Cell[6619, 227, 268, 8, 36, "Output",
 CellID->361042881]
}, Open  ]],
Cell[6902, 238, 90, 2, 70, "ExampleText",
 CellID->55592386],
Cell[CellGroupData[{
Cell[7017, 244, 117, 4, 70, "Input",
 CellID->789323511],
Cell[7137, 250, 184, 4, 70, "Print",
 CellTags->"Info3384534718-5418799",
 CellID->93953692]
}, Open  ]],
Cell[7336, 257, 94, 2, 70, "ExampleText",
 CellID->81592447],
Cell[CellGroupData[{
Cell[7455, 263, 150, 5, 70, "Input",
 CellID->287478044],
Cell[7608, 270, 158, 5, 36, "Output",
 CellID->409763528]
}, Open  ]],
Cell[7781, 278, 100, 2, 70, "ExampleText",
 CellID->1721532427],
Cell[CellGroupData[{
Cell[7906, 284, 133, 4, 70, "Input",
 CellID->748324558],
Cell[8042, 290, 196, 6, 36, "Output",
 CellID->742651096]
}, Open  ]],
Cell[8253, 299, 114, 2, 70, "ExampleText",
 CellID->260617443],
Cell[CellGroupData[{
Cell[8392, 305, 150, 5, 70, "Input",
 CellID->175341099],
Cell[8545, 312, 212, 7, 36, "Output",
 CellID->64056550]
}, Open  ]],
Cell[8772, 322, 110, 2, 70, "ExampleText",
 CellID->65464260],
Cell[8885, 326, 147, 5, 70, "Input",
 CellID->24792145]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9081, 337, 311, 9, 70, "SeeAlsoSection",
 CellID->24939],
Cell[9395, 348, 689, 26, 70, "SeeAlso",
 CellID->6253]
}, Open  ]],
Cell[CellGroupData[{
Cell[10121, 379, 313, 9, 70, "TutorialsSection",
 CellID->7522],
Cell[10437, 390, 158, 4, 70, "Tutorials",
 CellID->8685],
Cell[10598, 396, 480, 14, 70, "Tutorials",
 CellID->22184],
Cell[11081, 412, 395, 11, 70, "Tutorials",
 CellID->361474453]
}, Open  ]],
Cell[CellGroupData[{
Cell[11513, 428, 319, 9, 70, "MoreAboutSection",
 CellID->229989391],
Cell[11835, 439, 168, 3, 70, "MoreAbout",
 CellID->264753474]
}, Open  ]],
Cell[12018, 445, 50, 0, 70, "History"],
Cell[12071, 447, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

