(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     90433,       2724]
NotebookOptionsPosition[     78804,       2317]
NotebookOutlinePosition[     80426,       2359]
CellTagsIndexPosition[     80340,       2354]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Numerical Functions" :> 
          Documentation`HelpLookup["paclet:tutorial/NumericalFunctions"], 
          "Generalized Functions and Related Objects" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/GeneralizedFunctionsAndRelatedObjects"], 
          "Piecewise Functions" :> 
          Documentation`HelpLookup["paclet:tutorial/PiecewiseFunctions"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Numerical Functions\"\>", 
       2->"\<\"Generalized Functions and Related Objects\"\>", 
       3->"\<\"Piecewise Functions\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Sign" :> Documentation`HelpLookup["paclet:ref/Sign"], 
          "Positive" :> Documentation`HelpLookup["paclet:ref/Positive"], 
          "HeavisideTheta" :> 
          Documentation`HelpLookup["paclet:ref/HeavisideTheta"], 
          "DiscreteDelta" :> 
          Documentation`HelpLookup["paclet:ref/DiscreteDelta"], 
          "KroneckerDelta" :> 
          Documentation`HelpLookup["paclet:ref/KroneckerDelta"], "Unitize" :> 
          Documentation`HelpLookup["paclet:ref/Unitize"], "Boole" :> 
          Documentation`HelpLookup["paclet:ref/Boole"], "Piecewise" :> 
          Documentation`HelpLookup["paclet:ref/Piecewise"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Sign\"\>", 2->"\<\"Positive\"\>", 
       3->"\<\"HeavisideTheta\"\>", 4->"\<\"DiscreteDelta\"\>", 
       5->"\<\"KroneckerDelta\"\>", 6->"\<\"Unitize\"\>", 7->"\<\"Boole\"\>", 
       8->"\<\"Piecewise\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Conditionals" :> 
          Documentation`HelpLookup["paclet:guide/Conditionals"], 
          "Numerical Functions" :> 
          Documentation`HelpLookup["paclet:guide/NumericalFunctions"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Conditionals\"\>", 
       2->"\<\"Numerical Functions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["UnitStep", "ObjectName",
 CellID->30086],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["UnitStep",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/UnitStep"], "[", 
       StyleBox["x", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]represents the unit step function, equal to 0 for ",
     Cell[BoxData[
      FormBox[
       RowBox[{"x", "<", "0"}], TraditionalForm]], "InlineMath"],
     " and 1 for ",
     Cell[BoxData[
      FormBox[
       RowBox[{"x", "\[GreaterEqual]", "0"}], TraditionalForm]], 
      "InlineMath"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["UnitStep",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/UnitStep"], "[", 
       RowBox[{
        SubscriptBox[
         StyleBox["x", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["x", "TI"], 
         StyleBox["2", "TR"]], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]represents the multidimensional unit step function \
which is 1 only if none of the ",
     Cell[BoxData[
      FormBox[
       SubscriptBox["x", "i"], TraditionalForm]], "InlineMath"],
     " are negative. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->464]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "Some transformations are done automatically when ",
 Cell[BoxData[
  ButtonBox["UnitStep",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/UnitStep"]], "InlineFormula"],
 " appears in a product of terms. "
}], "Notes",
 CellID->31933],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["UnitStep",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/UnitStep"]], "InlineFormula"],
 " provides a convenient way to represent piecewise continuous functions. "
}], "Notes",
 CellID->11652],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["UnitStep",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/UnitStep"]], "InlineFormula"],
 " has attribute ",
 Cell[BoxData[
  ButtonBox["Orderless",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Orderless"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->29624],

Cell[TextData[{
 "For exact numeric quantities, ",
 Cell[BoxData[
  ButtonBox["UnitStep",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/UnitStep"]], "InlineFormula"],
 " internally uses numerical approximations to establish its result. This \
process can be affected by the setting of the global variable ",
 Cell[BoxData[
  ButtonBox["$MaxExtraPrecision",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$MaxExtraPrecision"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->8181]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->399493001],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->16633122],

Cell["Evaluate numerically:", "ExampleText",
 CellID->442651168],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"UnitStep", "[", "1", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->84672389],

Cell[BoxData["1"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->106586258]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->29525647],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"UnitStep", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", "Thick"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->179058532],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWD9PwkAUP7gWdDHRQQo68B1wNW6aiC4SZXAwDTGBQTHI7udw0c1BJyPR
L2EwcTI6GxYnmZzq/SvU12vvWhusCQ19d+/d77378353bdm2u83DI7vbatjl
jY590mw1Tsvr7Q4x4QxCqEfuMwuRukNq7O45Din9MkckJoAiKQ1RUr0iSkvY
LaGbzGuWSqo67EIFj04kKoH2CtAtgF8C7Vlux6KZXFlyGwA1L8aGgX0hwA5H
UQQ6HDUfRZ5I2vtyyBxk0WG0gojDV3BGgY4aHeKxNE+LVBhjXZ2pgs9DniuX
RyUxS7dcAbrLL74KXibug7h7zMpweDD4fOq/kx+qUUFRw+HXGEVne8t4wvEP
9y+k3j6+QwYVmCu0mgU6VugqfNLxYuPfXj9G2YA8CNGTxk+6/zH7wna2aqfD
3TgXMR4fhZzB6bbSPVlPaS9V4enlAN3jo/PD57HpwNPKBL66fpBRxo9Z+PF5
gIe8Deonrp8ROlP/GuY8ZRp498/ZaI5a+eIHrKser3TzbYgsU3goLzx81x2X
6YTxIyreXSvIbvlsp+xTe8rOQlqNkjPdM0PXU8nD2H3hiEz04sLPQfdtXo6a
HAumDJRnLzkGRj3Rkh7bb57Ff8nBdDG+KrLse+8PXL8tYMWa2VH78acX/7a8
vHhENSrwzfWzQGSixGEfpu61s7Z6jnB99ypOpARGpMfXA2b1/4eEMt9F0Ko8
\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 127},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->387730729]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{"UnitStep", "[", 
    RowBox[{"x", ",", "y"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
   RowBox[{"Mesh", "\[Rule]", "5"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->107805883],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 136},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->133644787]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->132468250],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["UnitStep",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/UnitStep"]], "InlineFormula"],
 " to construct piecewise functions:"
}], "ExampleText",
 CellID->12019838],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PiecewiseExpand", "[", 
  RowBox[{
   RowBox[{"x", "^", "2"}], "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"x", "-", 
      RowBox[{"x", "^", "2"}]}], ")"}], " ", 
    RowBox[{"UnitStep", "[", "x", "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->58994339],

Cell[GraphicsData["CompressedBitmap", "\<\
eJy9U0uOwjAMNW3aIn4DYkDsYAk3ADbdDSsOUSEkWIxAwP2D3TpQ3NAUkIgU
v9hO/M86uey2/8llv0kmq1Ny3O0358nf4YQivwYAMe7xCPCs8ZTuWGvEPPWR
KlTNbxz4dDNdECDxkPUY+4ikpnsBI8mzh9ny2KJntRgSUXceYCBuyBeSN/Hk
ZcrqK+LohlU8BDeeU/mWj+DDWpF39TwDu9TZaUJS/8jqs57LAZkm/9LX9xkp
+mkLvlXIUdb912qnI/gmksj0wXl76oyNEpulaPLqWm3IaJclUulv8VWp7HBP
8KSnYYlK+1ecyX5BEoo3dV19Ds1/GjDWc/iujQZj+IKNKnkaP67YFH8XV/Wr
1mxeols8dC/OdLUrHwsPhg==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{63, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->48497813]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->10604],

Cell["\<\
The precision of the output does not track the precision of the input:\
\>", "ExampleText",
 CellID->654782],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"UnitStep", "[", 
  RowBox[{"{", 
   RowBox[{"1.6", ",", "1.6000000000000000000000000"}], "}"}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->436076370],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "1"}], "}"}]], "Output",
 ImageSize->{44, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->482539117]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->627475792],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["UnitStep",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/UnitStep"]], "InlineFormula"],
 " threads element-wise over lists:"
}], "ExampleText",
 CellID->549218757],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"UnitStep", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"-", "1"}], ",", "0", ",", "1"}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->61347541],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "1", ",", "1"}], "}"}]], "Output",
 ImageSize->{62, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->416919794]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->12964440],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["UnitStep",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/UnitStep"]], "InlineFormula"],
 " can deal with real\[Hyphen]valued intervals:"
}], "ExampleText",
 CellID->454344003],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"UnitStep", "[", 
  RowBox[{"Interval", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1"}], ",", " ", "2"}], "}"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->4213865],

Cell[BoxData[
 RowBox[{"Interval", "[", 
  RowBox[{"{", 
   RowBox[{"0", ",", "1"}], "}"}], "]"}]], "Output",
 ImageSize->{114, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->454661456]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->194090247],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " formatting:"
}], "ExampleText",
 CellID->121923236],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"UnitStep", "[", "x", "]"}], "//", "TraditionalForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->392273175],

Cell[BoxData[
 FormBox[
  RowBox[{
   InterpretationBox["\[Theta]",
    UnitStep,
    Editable->False,
    Selectable->False], "(", "x", ")"}], TraditionalForm]], "Output",
 ImageSize->{22, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TraditionalForm=",
 CellID->412100384]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->26476],

Cell[TextData[{
 "Multidimensional ",
 Cell[BoxData[
  ButtonBox["UnitStep",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/UnitStep"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->189683140],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"UnitStep", "[", 
  RowBox[{"1", ",", "2", ",", "3"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->261736169],

Cell[BoxData["1"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->241760341]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->28161],

Cell["Generate a square wave:", "ExampleText",
 CellID->11473347],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"UnitStep", "[", 
    RowBox[{"Sin", "[", 
     RowBox[{"Pi", " ", "x"}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"Exclusions", "\[Rule]", "None"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", "Thick"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->80590506],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztnEFrE0EUgCc7mwq2SVQ8aK3SP9DqHxAPolKKiAfxIB5iEJKDVmoPone9
15MghqIVqh4Ei8WbKHgSC6IgepAcJB4sBYOHgBDfezvdzMxOTBop7MS3dGf2
vbfvzTeTmd2ZdDcni3Pli5eKc5VScfzEbPFKuVK6On58ZhZUMiOEWIb92h4B
xy04on251YI8mU5AGsIJ+1GSeCZtYgySQOkxRxnNgZIleU9qXsIRZR8mYVsW
Ds1YQoNlYDUymJPqoBV3VFEnffuLf8iKv9dVr0TUwGnpHn1U85VOwl6YJzoy
Hej6KfQSf7JDNL1H6Lk0eobex3ZYERac2hGSa7X11Xff4E8UMJHN5m9lH4Zk
J+m+fP6h6YSs138aPmtrvwz7xw/flT1PdpANe6PRNPwhnrIHRJqDdFG1UZI7
a8khybduvgTV+XNLYmjm8jOyQ46HIcnHjt4FFZSU8I/lI4fv4KlZp3/pwpNI
JYac5VfvvQXV2TMPO5R/+tR9UK08/9TBHz2FqJSfdigfLSq+0x8bUojpqWqi
/DgeFE6n/qU3QCtCKyBlTqPCVkM5AFtOKw0D57TaY5rTPg0jDvhinJGNHqRq
E8dTrZ+3uDZJq0pJ0KroMS3IBm2HODEtyC7a3Z7Q4XWiWzRuM6b7P+h4NDAd
0/Fo6I9OTUlokxopybCH6aY3ViFZi98ndnseLD1i32ax4koHRd+YfWlv6tdJ
TXrptWsM9vPAGqvpI073NZvvc0zHdDwamI7peDRswRooG5MqQ7pnK4OzksB5
bKjytK8g9Dm3b30k2/JhFu4ls3YtsdeY6R6JfOdgOqbj0cB0TMejYev+s4KH
Hsxj/P7GeeDpfVgdSc96uftZvNSyWyuNIPX9Ot3Xa77HMR3T8WhgOqbj0cDr
n0FfQfhCr3/v78Oqx9+W9o7ey+fK+D7CdEzHo4HpmI5Hw7/OX6Is2uxn+NM/
H7CJaULj0QysO7/c8BPqjWpM8P1zR7m359+Q3ean8skPSnbw37j+Qtmnp6oO
fnyPPLJH52+aP6zSG+HRlocIQq7Q6+doHNZqgKaCRb+ho9Y3fCKatr0e/3LA
do2+bQduZd/VZ+sXqBVqtXWD4/Gj96BHU57siw9WDTtwKHvkD/EM++tXXw17
o9E06gGyYW+3Xa/1sEfBglY9c/6/RKrkL5WIzB/7ICHm\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 120},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->444570865]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->21770173],

Cell["Compute a step response for a continuous-time system:", "ExampleText",
 CellID->292949489],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"y", "''"}], "[", "t", "]"}], "+", 
       RowBox[{
        RowBox[{"y", "'"}], "[", "t", "]"}], "+", 
       RowBox[{"y", "[", "t", "]"}]}], "\[Equal]", 
      RowBox[{"UnitStep", "[", "t", "]"}]}], ",", 
     RowBox[{
      RowBox[{"y", "[", "0", "]"}], "\[Equal]", 
      RowBox[{
       RowBox[{"y", "'"}], "[", "0", "]"}], "\[Equal]", "0"}]}], "}"}], ",", 
   "y", ",", "t"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->114225948],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"y", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", "t", "}"}], ",", 
      RowBox[{
       FractionBox["1", "3"], " ", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         RowBox[{"-", "t"}], "/", "2"}]], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"3", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"t", "/", "2"}]]}], "-", 
         RowBox[{"3", " ", 
          RowBox[{"Cos", "[", 
           FractionBox[
            RowBox[{
             SqrtBox["3"], " ", "t"}], "2"], "]"}]}], "-", 
         RowBox[{
          SqrtBox["3"], " ", 
          RowBox[{"Sin", "[", 
           FractionBox[
            RowBox[{
             SqrtBox["3"], " ", "t"}], "2"], "]"}]}]}], ")"}], " ", 
       RowBox[{"UnitStep", "[", "t", "]"}]}]}], "]"}]}], "}"}], 
  "}"}]], "Output",
 ImageSize->{537, 40},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->22888739]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", 
    RowBox[{
     RowBox[{"y", "[", "t", "]"}], "/.", "%"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->585549717],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 116},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->354084760]
}, Open  ]],

Cell["Using transform methods:", "ExampleText",
 CellID->813591872],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseLaplaceTransform", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"s", "^", "2"}], "+", "s", "+", "1"}], ")"}]}], 
    RowBox[{"LaplaceTransform", "[", 
     RowBox[{
      RowBox[{"UnitStep", "[", "t", "]"}], ",", "t", ",", "s"}], "]"}]}], ",",
    "s", ",", "t"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->265878822],

Cell[BoxData[
 RowBox[{"1", "-", 
  RowBox[{
   FractionBox["1", "3"], " ", 
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{
     RowBox[{"-", "t"}], "/", "2"}]], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"3", " ", 
      RowBox[{"Cos", "[", 
       FractionBox[
        RowBox[{
         SqrtBox["3"], " ", "t"}], "2"], "]"}]}], "+", 
     RowBox[{
      SqrtBox["3"], " ", 
      RowBox[{"Sin", "[", 
       FractionBox[
        RowBox[{
         SqrtBox["3"], " ", "t"}], "2"], "]"}]}]}], ")"}]}]}]], "Output",
 ImageSize->{278, 40},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->370896592]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{"%", ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->104156304],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 116},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->35903199]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->495562840],

Cell["Compute a step response for a discrete-time system:", "ExampleText",
 CellID->61075986],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"y", "[", 
        RowBox[{"k", "+", "2"}], "]"}], "-", 
       RowBox[{
        RowBox[{"8", "/", "5"}], 
        RowBox[{"y", "[", 
         RowBox[{"k", "+", "1"}], "]"}]}], "+", 
       RowBox[{
        RowBox[{"16", "/", "25"}], 
        RowBox[{"y", "[", "k", "]"}]}]}], "\[Equal]", 
      RowBox[{"UnitStep", "[", "k", "]"}]}], ",", 
     RowBox[{
      RowBox[{"y", "[", "0", "]"}], "\[Equal]", 
      RowBox[{"y", "[", "1", "]"}], "\[Equal]", "0"}]}], "}"}], ",", "y", ",",
    "k"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->35377973],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"y", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", "k", "}"}], ",", 
      RowBox[{
       FractionBox["1", "4"], " ", 
       SuperscriptBox["5", 
        RowBox[{"2", "-", "k"}]], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", 
          SuperscriptBox["4", 
           RowBox[{"1", "+", "k"}]]}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["5", "k"]}], "-", 
         RowBox[{
          SuperscriptBox["4", "k"], " ", "k"}]}], ")"}], " ", 
       RowBox[{"UnitStep", "[", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "k"}], "]"}]}]}], "]"}]}], "}"}], 
  "}"}]], "Output",
 ImageSize->{423, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->477818777]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"y", "[", "k", "]"}], "/.", 
      RowBox[{"First", "[", "%", "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"k", ",", "0", ",", "50"}], "}"}]}], "]"}], ",", 
   RowBox[{"Filling", "\[Rule]", "Axis"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->49964138],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 118},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->85068108]
}, Open  ]],

Cell["Using transform methods:", "ExampleText",
 CellID->549651142],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseZTransform", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"1", "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"z", "^", "2"}], "-", 
        RowBox[{
         RowBox[{"8", "/", "5"}], "z"}], "+", 
        RowBox[{"16", "/", "25"}]}], ")"}]}], ")"}], 
    RowBox[{"ZTransform", "[", 
     RowBox[{
      RowBox[{"UnitStep", "[", "k", "]"}], ",", "k", ",", "z"}], "]"}]}], ",",
    "z", ",", "k"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->68132496],

Cell[BoxData[
 RowBox[{
  FractionBox["25", "4"], " ", 
  RowBox[{"(", 
   RowBox[{"4", "-", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       FractionBox["4", "5"], ")"}], "k"], " ", 
     RowBox[{"(", 
      RowBox[{"4", "+", "k"}], ")"}]}]}], ")"}]}]], "Output",
 ImageSize->{134, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->371080167]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{"%", ",", 
     RowBox[{"{", 
      RowBox[{"k", ",", "0", ",", "50"}], "}"}]}], "]"}], ",", 
   RowBox[{"Filling", "\[Rule]", "Axis"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->739179271],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 118},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->329588547]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->683291284],

Cell["\<\
Solve the time\[Hyphen]independent Schr\[ODoubleDot]dinger equation with \
piecewise analytic potential:\
\>", "ExampleText",
 CellID->348322225],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"-", 
        RowBox[{
         RowBox[{"\[Psi]", "''"}], "[", "z", "]"}]}], "+", 
       RowBox[{
        RowBox[{"UnitStep", "[", "z", "]"}], 
        RowBox[{"\[Psi]", "[", "z", "]"}]}]}], "==", 
      RowBox[{"\[CurlyEpsilon]", " ", 
       RowBox[{"\[Psi]", "[", "z", "]"}]}]}], ",", 
     RowBox[{
      RowBox[{"\[Psi]", "[", "0", "]"}], "==", "\[Psi]0"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"\[Psi]", "'"}], "[", "0", "]"}], "==", "\[Psi]1"}]}], "}"}], 
   ",", 
   RowBox[{"\[Psi]", "[", "z", "]"}], ",", "z"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->11999398],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"\[Psi]", "[", "z", "]"}], "\[Rule]", 
    RowBox[{
     FractionBox[
      RowBox[{
       RowBox[{
        SqrtBox["\[CurlyEpsilon]"], " ", "\[Psi]0", " ", 
        RowBox[{"Cos", "[", 
         RowBox[{"z", " ", 
          SqrtBox["\[CurlyEpsilon]"]}], "]"}]}], "+", 
       RowBox[{"\[Psi]1", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"z", " ", 
          SqrtBox["\[CurlyEpsilon]"]}], "]"}]}]}], 
      SqrtBox["\[CurlyEpsilon]"]], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        FractionBox[
         RowBox[{
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "z"}], " ", 
            SqrtBox[
             RowBox[{"1", "-", "\[CurlyEpsilon]"}]]}]], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SqrtBox[
              RowBox[{"1", "-", "\[CurlyEpsilon]"}]], " ", "\[Psi]0"}], "+", 
            RowBox[{
             SuperscriptBox["\[ExponentialE]", 
              RowBox[{"2", " ", "z", " ", 
               SqrtBox[
                RowBox[{"1", "-", "\[CurlyEpsilon]"}]]}]], " ", 
             SqrtBox[
              RowBox[{"1", "-", "\[CurlyEpsilon]"}]], " ", "\[Psi]0"}], "-", 
            "\[Psi]1", "+", 
            RowBox[{
             SuperscriptBox["\[ExponentialE]", 
              RowBox[{"2", " ", "z", " ", 
               SqrtBox[
                RowBox[{"1", "-", "\[CurlyEpsilon]"}]]}]], " ", "\[Psi]1"}]}],
            ")"}]}], 
         RowBox[{"2", " ", 
          SqrtBox[
           RowBox[{"1", "-", "\[CurlyEpsilon]"}]]}]], "-", 
        FractionBox[
         RowBox[{
          RowBox[{
           SqrtBox["\[CurlyEpsilon]"], " ", "\[Psi]0", " ", 
           RowBox[{"Cos", "[", 
            RowBox[{"z", " ", 
             SqrtBox["\[CurlyEpsilon]"]}], "]"}]}], "+", 
          RowBox[{"\[Psi]1", " ", 
           RowBox[{"Sin", "[", 
            RowBox[{"z", " ", 
             SqrtBox["\[CurlyEpsilon]"]}], "]"}]}]}], 
         SqrtBox["\[CurlyEpsilon]"]]}], ")"}], " ", 
      RowBox[{"UnitStep", "[", "z", "]"}]}]}]}], "}"}], "}"}]], "Output",
 ImageSize->{417, 176},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->433887622]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->190175],

Cell[TextData[{
 "This gives the probability of the random variable being in the interval ",
 Cell[BoxData[
  FormBox[
   RowBox[{"[", 
    RowBox[{"X", ",", "Y"}], "]"}], TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->454425265],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"PDF", "[", 
     RowBox[{
      RowBox[{"NormalDistribution", "[", 
       RowBox[{"\[Mu]", ",", "\[Sigma]"}], "]"}], ",", "x"}], "]"}], 
    RowBox[{"UnitStep", "[", 
     RowBox[{"x", "-", "X"}], "]"}], 
    RowBox[{"UnitStep", "[", 
     RowBox[{"Y", "-", "x"}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "\[Infinity]"}], ",", "\[Infinity]"}], "}"}], ",", 
   RowBox[{"Assumptions", "->", 
    RowBox[{
     RowBox[{"\[Mu]", "\[Element]", "Reals"}], "&&", 
     RowBox[{"\[Sigma]", ">", "0"}], "&&", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"X", ",", "Y"}], "}"}], "\[Element]", "Reals"}]}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->110754687],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "2"], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", 
     RowBox[{"Erf", "[", 
      FractionBox[
       RowBox[{"X", "-", "\[Mu]"}], 
       RowBox[{
        SqrtBox["2"], " ", "\[Sigma]"}]], "]"}]}], "+", 
    RowBox[{"Erf", "[", 
     FractionBox[
      RowBox[{"Y", "-", "\[Mu]"}], 
      RowBox[{
       SqrtBox["2"], " ", "\[Sigma]"}]], "]"}]}], ")"}], " ", 
  RowBox[{"UnitStep", "[", 
   RowBox[{
    RowBox[{"-", "X"}], "+", "Y"}], "]"}]}]], "Output",
 ImageSize->{306, 37},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->74322162]
}, Open  ]],

Cell["Here is the resulting probability plotted:", "ExampleText",
 CellID->26437348],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{"%", "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"\[Mu]", "->", "0"}], ",", 
      RowBox[{"\[Sigma]", "->", "1"}]}], "}"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"X", ",", 
     RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"Y", ",", 
     RowBox[{"-", "3"}], ",", "3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->776051879],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 136},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->404897079]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->56205019],

Cell[TextData[{
 "Construct the ",
 ButtonBox["Walsh function",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://mathworld.wolfram.com/WalshFunction.html"], None}],
 ":"
}], "ExampleText",
 CellID->217822324],

Cell[BoxData[
 RowBox[{
  RowBox[{"Walsh", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"n_", ",", "k_"}], "}"}], ",", "y_"}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"li", "=", 
      RowBox[{"Split", "[", 
       RowBox[{"Extract", "[", 
        RowBox[{
         RowBox[{"Nest", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"Sequence", "@@@", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"Join", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{"Riffle", "[", 
                   RowBox[{"#", ",", "#"}], "]"}], "&"}], "/@", "#"}], "]"}], 
               ",", 
               RowBox[{"Join", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{"Riffle", "[", 
                   RowBox[{"#", ",", 
                    RowBox[{"-", "#"}]}], "]"}], "&"}], "/@", 
                 RowBox[{"Reverse", "[", "#", "]"}]}], "]"}]}], "}"}]}], 
            "&"}], ",", 
           RowBox[{"{", 
            RowBox[{"{", "1", "}"}], "}"}], ",", "n"}], "]"}], ",", 
         RowBox[{"{", "k", "}"}]}], "]"}], "]"}]}], "}"}], ",", 
    RowBox[{
     RowBox[{"-", "1"}], "-", 
     RowBox[{"2", 
      RowBox[{"Total", "[", 
       RowBox[{
        RowBox[{"MapIndexed", "[", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"-", "1"}], ")"}], "^", "#2"}], " ", 
            RowBox[{"UnitStep", "[", 
             RowBox[{
              RowBox[{"Mod", "[", 
               RowBox[{"y", ",", 
                RowBox[{"2", "^", "n"}]}], "]"}], "-", "#1"}], "]"}]}], "&"}],
           ",", 
          RowBox[{"Most", "[", 
           RowBox[{"FoldList", "[", 
            RowBox[{"Plus", ",", "0", ",", 
             RowBox[{"Length", "/@", "li"}]}], "]"}], "]"}]}], "]"}], ",", 
        "Infinity"}], "]"}]}]}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->61836473],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"Walsh", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2", ",", "k"}], "}"}], ",", "x"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "4"}], "}"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"k", ",", "4"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->246474166],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{386, 240},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->659168214]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->19293],

Cell[TextData[{
 "Expand into ",
 Cell[BoxData[
  ButtonBox["UnitStep",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/UnitStep"]], "InlineFormula"],
 " of linear factors:"
}], "ExampleText",
 CellID->72057886],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"UnitStep", "[", 
   RowBox[{
    RowBox[{"x", "^", "15"}], "-", "1"}], "]"}], "//", 
  "FunctionExpand"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->261115949],

Cell[BoxData[
 RowBox[{"UnitStep", "[", 
  RowBox[{
   RowBox[{"-", "1"}], "+", "x"}], "]"}]], "Output",
 ImageSize->{109, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->2039232]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"UnitStep", "[", 
   RowBox[{
    RowBox[{"x", "^", "2"}], "-", 
    RowBox[{"11", "x"}], "+", "1"}], "]"}], "//", "FunctionExpand"}]], "Input",\

 CellLabel->"In[2]:=",
 CellID->807517485],

Cell[BoxData[
 RowBox[{
  RowBox[{"UnitStep", "[", 
   RowBox[{
    RowBox[{
     FractionBox["1", "2"], " ", 
     RowBox[{"(", 
      RowBox[{"11", "-", 
       RowBox[{"3", " ", 
        SqrtBox["13"]}]}], ")"}]}], "-", "x"}], "]"}], "+", 
  RowBox[{"UnitStep", "[", 
   RowBox[{
    RowBox[{
     FractionBox["1", "2"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "11"}], "-", 
       RowBox[{"3", " ", 
        SqrtBox["13"]}]}], ")"}]}], "+", "x"}], "]"}]}]], "Output",
 ImageSize->{395, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->274316061]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->376752709],

Cell[TextData[{
 "Convert into ",
 Cell[BoxData[
  ButtonBox["Piecewise",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Piecewise"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->509536520],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PiecewiseExpand", "[", 
  RowBox[{
   RowBox[{"UnitStep", "[", "x", "]"}], 
   RowBox[{"UnitStep", "[", 
    RowBox[{"1", "-", "x"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1088631],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzNVM0OgjAMLozxp8ajHrnxJupF3mEhJnAwEuT9ZxkdYNlBDQdJ1m9f2/Tb
uo2r6qrbXXV1qbJzq5qqLp/Z6dGiS3gAUOA4HAHnGmdmFFojCrQC6WVk0FNt
vj/2hmgk0h2t33KJ6CP6hJL8Nu6bajaasqrb3siRm1yAhGUFxkx8WSdkfFKd
e3ldt3pEa40JkxmupWG7lhJazY1Tg59F/NU+okX35jtbS43XEvr9XvC4+8R+
084/qmX7sdfDDc6JB87sNd/R9N6HfwB4L365KMY=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{78, 23},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->143511201]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PiecewiseExpand", "[", 
  RowBox[{"Exp", "[", 
   RowBox[{"x", " ", 
    RowBox[{"UnitStep", "[", "x", "]"}], 
    RowBox[{"UnitStep", "[", 
     RowBox[{"1", "-", 
      RowBox[{"UnitStep", "[", "x", "]"}]}], "]"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->732875634],

Cell[GraphicsData["CompressedBitmap", "\<\
eJytU8FuwjAMNWky2mmgDRDjgsRt075gwKE3dtpHVGgSPSBQx/9nTut0kRPa
qhApsf1iPyd28p1dDj/H7JLvs9VXkZ0P+f53tTsVCEUDAEhxLheAukatnKnW
KKs1wlUi+FlbEBmfcsA6iD7gotCcojRwRLaRAkiBagjiF0Em5djG+5Xtc39u
C8vsYPJ+mVRtU1S/XEad9c6nOlePn24SyGEqJq/fLYwGX4C0jZb/OMCYd4hy
Uqmg2rF9E8RhX5GfaUxeT14mfttZa/wQ5TzoNfLY30thz7itLTdq04B2+0m3
o/YvvrCqJsxPNVY5ZvbEq0dMvEPd/ZVw1qnDUZ/xRq7kDufyb/vIPBp+TCs7
78xzC5e0t3E43hpiRsT7od0Op5XP4A9mhAwJ\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{63, 29},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->141517816]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->126323931],

Cell["Integrate over finite and infinite domains:", "ExampleText",
 CellID->288313745],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"UnitStep", "[", 
     RowBox[{"x", "-", "a"}], "]"}], " ", 
    RowBox[{"Sinc", "[", "x", "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "Infinity"}], ",", "Infinity"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->131905135],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "2"], " ", 
  RowBox[{"(", 
   RowBox[{"\[Pi]", "-", 
    RowBox[{"2", " ", 
     RowBox[{"SinIntegral", "[", "a", "]"}]}]}], ")"}]}]], "Output",
 ImageSize->{161, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->235114356]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"UnitStep", "[", 
    RowBox[{"x", " ", 
     RowBox[{"Cos", "[", "x", "]"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "5"}], ",", "5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->723794854],

Cell[BoxData["5"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->163009037]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->4447],

Cell[TextData[{
 "Symbolic preprocessing of functions containing ",
 Cell[BoxData[
  ButtonBox["UnitStep",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/UnitStep"]], "InlineFormula"],
 " can be time\[Hyphen]consuming:"
}], "ExampleText",
 CellID->325475782],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"NIntegrate", "[", 
   RowBox[{
    RowBox[{"UnitStep", "[", 
     RowBox[{
      RowBox[{"x", " ", 
       RowBox[{"Sin", "[", "x", "]"}]}], "+", 
      RowBox[{"Exp", "[", "x", "]"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", "20"}], "}"}]}], "]"}], "//", 
  "Timing"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->298771227],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"5.234000000000225`", ",", "20.00000000000002`"}], "}"}]], "Output",\

 ImageSize->{86, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->448691530]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"NIntegrate", "[", 
   RowBox[{
    RowBox[{"UnitStep", "[", 
     RowBox[{
      RowBox[{"x", " ", 
       RowBox[{"Sin", "[", "x", "]"}]}], "+", 
      RowBox[{"Exp", "[", "x", "]"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", "20"}], "}"}], ",", 
    RowBox[{"Method", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"Automatic", ",", 
       RowBox[{"\"\<SymbolicProcessing\>\"", "\[Rule]", "False"}]}], 
      "}"}]}]}], "]"}], "//", " ", "Timing"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->14184467],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1.2434497875801753`*^-13", ",", "20.00000000000002`"}], 
  "}"}]], "Output",
 ImageSize->{140, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->341114391]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->497105592],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Limit",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Limit"]], "InlineFormula"],
 " does not give ",
 Cell[BoxData[
  ButtonBox["UnitStep",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/UnitStep"]], "InlineFormula"],
 " as a limit of smooth functions:"
}], "ExampleText",
 CellID->393847507],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Assuming", "[", 
  RowBox[{
   RowBox[{"x", "\[Element]", "Reals"}], ",", 
   RowBox[{
    RowBox[{
     FractionBox[
      RowBox[{"1", " "}], "\[Pi]"], 
     RowBox[{"Limit", "[", 
      RowBox[{
       RowBox[{"ArcTan", "[", 
        FractionBox["x", "\[CurlyEpsilon]"], "]"}], ",", 
       RowBox[{"\[CurlyEpsilon]", "\[Rule]", 
        RowBox[{"+", "0"}]}]}], "]"}]}], "+", 
    FractionBox["1", "2"]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->219945576],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "2"], "+", 
  FractionBox[
   RowBox[{"Abs", "[", "x", "]"}], 
   RowBox[{"2", " ", "x"}]]}]], "Output",
 ImageSize->{74, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->354194417]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{"%", ",", " ", 
   RowBox[{"x", "\[Element]", "Reals"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->40497557],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzzTSzJSM1NLMlMTlRwL0osyMhMLlZwyy8CCjEzMjAwWAKxuAQDkP0fyAJj
y///gTQzkGQGco3hPAYQ9z8YDGJRNiDBCuRyA2kmIM0EpVmh4uxQf4H1wWW5
0EzhAREsCD4D2FxkFRwgghXOhygCmwclkdRyovF5obZyINGUmsUFpdnwmIUe
VhwEfc1OhAsJmYotJogNSUJmK5KgF+YXlf/IKYCW6RKRfyB5ioERAPzIzRk=
\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{57, 23},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->275545464]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->471929091],

Cell[TextData[{
 "Differentiating ",
 Cell[BoxData[
  ButtonBox["Abs",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Abs"]], "InlineFormula"],
 " does not yield ",
 Cell[BoxData[
  ButtonBox["UnitStep",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/UnitStep"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->374117240],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"D", "[", 
  RowBox[{
   RowBox[{"Abs", "[", "t", "]"}], ",", " ", "t"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->326792217],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["Abs", "\[Prime]",
   MultilineFunction->None], "[", "t", "]"}]], "Output",
 ImageSize->{50, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->629717902]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->14959],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Sign",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Sign"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Positive",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Positive"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["HeavisideTheta",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/HeavisideTheta"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["DiscreteDelta",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DiscreteDelta"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["KroneckerDelta",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/KroneckerDelta"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Unitize",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Unitize"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Boole",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Boole"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Piecewise",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Piecewise"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->13862]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->17760],

Cell[TextData[ButtonBox["Numerical Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/NumericalFunctions"]], "Tutorials",
 CellID->8874],

Cell[TextData[ButtonBox["Generalized Functions and Related Objects",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/GeneralizedFunctionsAndRelatedObjects"]], "Tutorials",
 CellID->32351],

Cell[TextData[ButtonBox["Piecewise Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/PiecewiseFunctions"]], "Tutorials",
 CellID->869807265]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection",
 CellID->15347],

Cell[TextData[{
 ButtonBox["Demonstrations with UnitStep",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=UnitStep"], 
    None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"],

Cell[TextData[StyleBox[ButtonBox["MathWorld",
 BaseStyle->"MathWorldLink",
 ButtonData->{
   URL["http://mathworld.wolfram.com/HeavisideStepFunction.html"], 
   None}], "IT"]], "RelatedLinks"],

Cell[TextData[ButtonBox["The Wolfram Functions Site",
 BaseStyle->"FunctionsSiteLink",
 ButtonData->{
   URL["http://functions.wolfram.com/GeneralizedFunctions/UnitStep/"], 
   None}]], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->14750995],

Cell[TextData[ButtonBox["Conditionals",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Conditionals"]], "MoreAbout",
 CellID->48796712],

Cell[TextData[ButtonBox["Numerical Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumericalFunctions"]], "MoreAbout",
 CellID->398787914]
}, Open  ]],

Cell["New in 4", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"UnitStep - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 28, 23.5381640}", "context" -> "System`", 
    "keywords" -> {
     "causal signals", "characteristic function", "Heaviside", 
      "Heaviside function", "Heaviside step function", "indicator function", 
      "one-sided functions", "piecewise continuous functions", 
      "step function", "theta function", "unit step function"}, "index" -> 
    True, "label" -> "Built-in Mathematica Symbol", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "UnitStep[x] represents the unit step function, equal to 0 for x < 0 and \
1 for x >= 0. UnitStep[x_1, x_2, ...] represents the multidimensional unit \
step function which is 1 only if none of the x_i are negative. ", 
    "synonyms" -> {"unit step"}, "title" -> "UnitStep", "type" -> "Symbol", 
    "uri" -> "ref/UnitStep"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6906, 214, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->399493001]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 80197, 2347}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2972, 65, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3595, 92, 46, 1, 70, "ObjectName",
 CellID->30086],
Cell[3644, 95, 1416, 45, 70, "Usage",
 CellID->464]
}, Open  ]],
Cell[CellGroupData[{
Cell[5097, 145, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5575, 162, 253, 8, 70, "Notes",
 CellID->31933],
Cell[5831, 172, 239, 7, 70, "Notes",
 CellID->11652],
Cell[6073, 181, 310, 12, 70, "Notes",
 CellID->29624],
Cell[6386, 195, 483, 14, 70, "Notes",
 CellID->8181]
}, Closed]],
Cell[CellGroupData[{
Cell[6906, 214, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->399493001],
Cell[CellGroupData[{
Cell[7291, 228, 147, 5, 70, "ExampleSection",
 CellID->16633122],
Cell[7441, 235, 64, 1, 70, "ExampleText",
 CellID->442651168],
Cell[CellGroupData[{
Cell[7530, 240, 103, 3, 28, "Input",
 CellID->84672389],
Cell[7636, 245, 158, 5, 36, "Output",
 CellID->106586258]
}, Open  ]],
Cell[7809, 253, 124, 3, 70, "ExampleDelimiter",
 CellID->29525647],
Cell[CellGroupData[{
Cell[7958, 260, 291, 9, 28, "Input",
 CellID->179058532],
Cell[8252, 271, 945, 20, 148, "Output",
 Evaluatable->False,
 CellID->387730729]
}, Open  ]],
Cell[CellGroupData[{
Cell[9234, 296, 399, 13, 28, "Input",
 CellID->107805883],
Cell[9636, 311, 3393, 60, 157, "Output",
 Evaluatable->False,
 CellID->133644787]
}, Open  ]],
Cell[13044, 374, 125, 3, 70, "ExampleDelimiter",
 CellID->132468250],
Cell[13172, 379, 219, 8, 70, "ExampleText",
 CellID->12019838],
Cell[CellGroupData[{
Cell[13416, 391, 296, 10, 28, "Input",
 CellID->58994339],
Cell[13715, 403, 600, 14, 52, "Output",
 Evaluatable->False,
 CellID->48497813]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[14364, 423, 216, 7, 70, "ExampleSection",
 CellID->10604],
Cell[14583, 432, 118, 3, 70, "ExampleText",
 CellID->654782],
Cell[CellGroupData[{
Cell[14726, 439, 181, 6, 70, "Input",
 CellID->436076370],
Cell[14910, 447, 203, 7, 36, "Output",
 CellID->482539117]
}, Open  ]],
Cell[15128, 457, 125, 3, 70, "ExampleDelimiter",
 CellID->627475792],
Cell[15256, 462, 210, 7, 70, "ExampleText",
 CellID->549218757],
Cell[CellGroupData[{
Cell[15491, 473, 180, 6, 70, "Input",
 CellID->61347541],
Cell[15674, 481, 213, 7, 36, "Output",
 CellID->416919794]
}, Open  ]],
Cell[15902, 491, 124, 3, 70, "ExampleDelimiter",
 CellID->12964440],
Cell[16029, 496, 222, 7, 70, "ExampleText",
 CellID->454344003],
Cell[CellGroupData[{
Cell[16276, 507, 212, 7, 70, "Input",
 CellID->4213865],
Cell[16491, 516, 240, 8, 36, "Output",
 CellID->454661456]
}, Open  ]],
Cell[16746, 527, 125, 3, 70, "ExampleDelimiter",
 CellID->194090247],
Cell[16874, 532, 203, 7, 70, "ExampleText",
 CellID->121923236],
Cell[CellGroupData[{
Cell[17102, 543, 142, 4, 70, "Input",
 CellID->392273175],
Cell[17247, 549, 319, 11, 50, "Output",
 CellID->412100384]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[17615, 566, 239, 7, 70, "ExampleSection",
 CellID->26476],
Cell[17857, 575, 200, 8, 70, "ExampleText",
 CellID->189683140],
Cell[CellGroupData[{
Cell[18082, 587, 137, 4, 70, "Input",
 CellID->261736169],
Cell[18222, 593, 158, 5, 36, "Output",
 CellID->241760341]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[18429, 604, 223, 7, 70, "ExampleSection",
 CellID->28161],
Cell[18655, 613, 65, 1, 70, "ExampleText",
 CellID->11473347],
Cell[CellGroupData[{
Cell[18745, 618, 381, 11, 70, "Input",
 CellID->80590506],
Cell[19129, 631, 1416, 27, 70, "Output",
 Evaluatable->False,
 CellID->444570865]
}, Open  ]],
Cell[20560, 661, 124, 3, 70, "ExampleDelimiter",
 CellID->21770173],
Cell[20687, 666, 96, 1, 70, "ExampleText",
 CellID->292949489],
Cell[CellGroupData[{
Cell[20808, 671, 582, 19, 70, "Input",
 CellID->114225948],
Cell[21393, 692, 1039, 34, 61, "Output",
 CellID->22888739]
}, Open  ]],
Cell[CellGroupData[{
Cell[22469, 731, 276, 9, 70, "Input",
 CellID->585549717],
Cell[22748, 742, 2307, 42, 70, "Output",
 Evaluatable->False,
 CellID->354084760]
}, Open  ]],
Cell[25070, 787, 67, 1, 70, "ExampleText",
 CellID->813591872],
Cell[CellGroupData[{
Cell[25162, 792, 411, 13, 70, "Input",
 CellID->265878822],
Cell[25576, 807, 654, 24, 61, "Output",
 CellID->370896592]
}, Open  ]],
Cell[CellGroupData[{
Cell[26267, 836, 183, 6, 70, "Input",
 CellID->104156304],
Cell[26453, 844, 2306, 42, 70, "Output",
 Evaluatable->False,
 CellID->35903199]
}, Open  ]],
Cell[28774, 889, 125, 3, 70, "ExampleDelimiter",
 CellID->495562840],
Cell[28902, 894, 93, 1, 70, "ExampleText",
 CellID->61075986],
Cell[CellGroupData[{
Cell[29020, 899, 676, 22, 70, "Input",
 CellID->35377973],
Cell[29699, 923, 832, 28, 51, "Output",
 CellID->477818777]
}, Open  ]],
Cell[CellGroupData[{
Cell[30568, 956, 432, 13, 70, "Input",
 CellID->49964138],
Cell[31003, 971, 2643, 47, 70, "Output",
 Evaluatable->False,
 CellID->85068108]
}, Open  ]],
Cell[33661, 1021, 67, 1, 70, "ExampleText",
 CellID->549651142],
Cell[CellGroupData[{
Cell[33753, 1026, 512, 17, 70, "Input",
 CellID->68132496],
Cell[34268, 1045, 408, 15, 52, "Output",
 CellID->371080167]
}, Open  ]],
Cell[CellGroupData[{
Cell[34713, 1065, 338, 10, 70, "Input",
 CellID->739179271],
Cell[35054, 1077, 2644, 47, 70, "Output",
 Evaluatable->False,
 CellID->329588547]
}, Open  ]],
Cell[37713, 1127, 125, 3, 70, "ExampleDelimiter",
 CellID->683291284],
Cell[37841, 1132, 155, 4, 70, "ExampleText",
 CellID->348322225],
Cell[CellGroupData[{
Cell[38021, 1140, 718, 23, 70, "Input",
 CellID->11999398],
Cell[38742, 1165, 2287, 67, 197, "Output",
 CellID->433887622]
}, Open  ]],
Cell[41044, 1235, 122, 3, 70, "ExampleDelimiter",
 CellID->190175],
Cell[41169, 1240, 249, 8, 70, "ExampleText",
 CellID->454425265],
Cell[CellGroupData[{
Cell[41443, 1252, 779, 24, 70, "Input",
 CellID->110754687],
Cell[42225, 1278, 638, 23, 58, "Output",
 CellID->74322162]
}, Open  ]],
Cell[42878, 1304, 84, 1, 70, "ExampleText",
 CellID->26437348],
Cell[CellGroupData[{
Cell[42987, 1309, 438, 15, 70, "Input",
 CellID->776051879],
Cell[43428, 1326, 14865, 248, 70, "Output",
 Evaluatable->False,
 CellID->404897079]
}, Open  ]],
Cell[58308, 1577, 124, 3, 70, "ExampleDelimiter",
 CellID->56205019],
Cell[58435, 1582, 217, 8, 70, "ExampleText",
 CellID->217822324],
Cell[58655, 1592, 2001, 60, 70, "Input",
 CellID->61836473],
Cell[CellGroupData[{
Cell[60681, 1656, 412, 14, 70, "Input",
 CellID->246474166],
Cell[61096, 1672, 2510, 45, 70, "Output",
 Evaluatable->False,
 CellID->659168214]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[63655, 1723, 233, 7, 70, "ExampleSection",
 CellID->19293],
Cell[63891, 1732, 212, 8, 70, "ExampleText",
 CellID->72057886],
Cell[CellGroupData[{
Cell[64128, 1744, 194, 7, 70, "Input",
 CellID->261115949],
Cell[64325, 1753, 233, 8, 36, "Output",
 CellID->2039232]
}, Open  ]],
Cell[CellGroupData[{
Cell[64595, 1766, 223, 8, 70, "Input",
 CellID->807517485],
Cell[64821, 1776, 622, 23, 51, "Output",
 CellID->274316061]
}, Open  ]],
Cell[65458, 1802, 125, 3, 70, "ExampleDelimiter",
 CellID->376752709],
Cell[65586, 1807, 198, 8, 70, "ExampleText",
 CellID->509536520],
Cell[CellGroupData[{
Cell[65809, 1819, 224, 7, 70, "Input",
 CellID->1088631],
Cell[66036, 1828, 495, 12, 70, "Output",
 Evaluatable->False,
 CellID->143511201]
}, Open  ]],
Cell[CellGroupData[{
Cell[66568, 1845, 309, 9, 70, "Input",
 CellID->732875634],
Cell[66880, 1856, 613, 14, 70, "Output",
 Evaluatable->False,
 CellID->141517816]
}, Open  ]],
Cell[67508, 1873, 125, 3, 70, "ExampleDelimiter",
 CellID->126323931],
Cell[67636, 1878, 86, 1, 70, "ExampleText",
 CellID->288313745],
Cell[CellGroupData[{
Cell[67747, 1883, 342, 11, 70, "Input",
 CellID->131905135],
Cell[68092, 1896, 319, 11, 51, "Output",
 CellID->235114356]
}, Open  ]],
Cell[CellGroupData[{
Cell[68448, 1912, 302, 10, 70, "Input",
 CellID->723794854],
Cell[68753, 1924, 158, 5, 36, "Output",
 CellID->163009037]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[68960, 1935, 225, 7, 70, "ExampleSection",
 CellID->4447],
Cell[69188, 1944, 260, 8, 70, "ExampleText",
 CellID->325475782],
Cell[CellGroupData[{
Cell[69473, 1956, 383, 13, 70, "Input",
 CellID->298771227],
Cell[69859, 1971, 239, 8, 36, "Output",
 CellID->448691530]
}, Open  ]],
Cell[CellGroupData[{
Cell[70135, 1984, 561, 17, 70, "Input",
 CellID->14184467],
Cell[70699, 2003, 247, 8, 39, "Output",
 CellID->341114391]
}, Open  ]],
Cell[70961, 2014, 125, 3, 70, "ExampleDelimiter",
 CellID->497105592],
Cell[71089, 2019, 342, 12, 70, "ExampleText",
 CellID->393847507],
Cell[CellGroupData[{
Cell[71456, 2035, 494, 16, 70, "Input",
 CellID->219945576],
Cell[71953, 2053, 277, 10, 52, "Output",
 CellID->354194417]
}, Open  ]],
Cell[CellGroupData[{
Cell[72267, 2068, 172, 5, 70, "Input",
 CellID->40497557],
Cell[72442, 2075, 455, 12, 70, "Output",
 Evaluatable->False,
 CellID->275545464]
}, Open  ]],
Cell[72912, 2090, 125, 3, 70, "ExampleDelimiter",
 CellID->471929091],
Cell[73040, 2095, 329, 13, 70, "ExampleText",
 CellID->374117240],
Cell[CellGroupData[{
Cell[73394, 2112, 156, 5, 70, "Input",
 CellID->326792217],
Cell[73553, 2119, 246, 8, 36, "Output",
 CellID->629717902]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[73860, 2134, 311, 9, 70, "SeeAlsoSection",
 CellID->14959],
Cell[74174, 2145, 1941, 71, 70, "SeeAlso",
 CellID->13862]
}, Open  ]],
Cell[CellGroupData[{
Cell[76152, 2221, 314, 9, 70, "TutorialsSection",
 CellID->17760],
Cell[76469, 2232, 147, 3, 70, "Tutorials",
 CellID->8874],
Cell[76619, 2237, 192, 4, 70, "Tutorials",
 CellID->32351],
Cell[76814, 2243, 152, 3, 70, "Tutorials",
 CellID->869807265]
}, Open  ]],
Cell[CellGroupData[{
Cell[77003, 2251, 321, 9, 70, "RelatedLinksSection",
 CellID->15347],
Cell[77327, 2262, 361, 12, 70, "RelatedLinks"],
Cell[77691, 2276, 192, 4, 70, "RelatedLinks"],
Cell[77886, 2282, 201, 4, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[78124, 2291, 318, 9, 70, "MoreAboutSection",
 CellID->14750995],
Cell[78445, 2302, 135, 3, 70, "MoreAbout",
 CellID->48796712],
Cell[78583, 2307, 149, 3, 70, "MoreAbout",
 CellID->398787914]
}, Open  ]],
Cell[78747, 2313, 27, 0, 70, "History"],
Cell[78777, 2315, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

