(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     17375,        690]
NotebookOptionsPosition[     12689,        521]
NotebookOutlinePosition[     13971,        557]
CellTagsIndexPosition[     13886,        552]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Putting Constraints on Patterns" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/PuttingConstraintsOnPatterns"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Putting Constraints on Patterns\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Equal" :> Documentation`HelpLookup["paclet:ref/Equal"], 
          "Order" :> Documentation`HelpLookup["paclet:ref/Order"], "SameQ" :> 
          Documentation`HelpLookup["paclet:ref/SameQ"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Equal\"\>", 2->"\<\"Order\"\>", 
       3->"\<\"SameQ\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[TextData[{
 "UnsameQ ",
 StyleBox["(=!=)", "OperatorCharacter"]
}], "ObjectName",
 CellID->20150],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       StyleBox["lhs", "TI"], "=!=", 
       StyleBox["rhs", "TI"]}]], "InlineFormula"],
     "\[LineSeparator]yields ",
     Cell[BoxData[
      ButtonBox["True",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/True"]], "InlineFormula"],
     " if the expression ",
     Cell[BoxData[
      StyleBox["lhs", "TI"]], "InlineFormula"],
     " is not identical to ",
     Cell[BoxData[
      StyleBox["rhs", "TI"]], "InlineFormula"],
     ", and yields ",
     Cell[BoxData[
      ButtonBox["False",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/False"]], "InlineFormula"],
     " otherwise. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->2228]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   SubscriptBox[
    StyleBox["e", "TI"], 
    StyleBox["1", "TR"]], "=!=", 
   SubscriptBox[
    StyleBox["e", "TI"], 
    StyleBox["2", "TR"]], "=!=", 
   SubscriptBox[
    StyleBox["e", "TI"], 
    StyleBox["3", "TR"]]}]], "InlineFormula"],
 " gives ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 " if no two of the ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["e", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " are identical. "
}], "Notes",
 CellID->19560]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->191260268],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->3954862],

Cell["Test whether two expressions are not identically the same:", \
"ExampleText",
 CellID->6016],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"x", "=!=", "y"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->735],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->22804]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"x", "=!=", "x"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->31918],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->4513]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData["!="], "InlineFormula"],
 " remains symbolic unless literal values are given:"
}], "ExampleText",
 CellID->15408],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"x", "!=", "y"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1594],

Cell[BoxData[
 RowBox[{"x", "\[NotEqual]", "y"}]], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->31018]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->25247],

Cell["Full form:", "ExampleText",
 CellID->32546],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"UnsameQ", "[", 
  RowBox[{"x", ",", "y"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->32735],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->6152]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->12561],

Cell["Test equivalence of strings:", "ExampleText",
 CellID->21568],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\"\<abc\>\"", "=!=", "\"\<ABC\>\""}]], "Input",
 CellLabel->"In[1]:=",
 CellID->13213],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->17970]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->6689],

Cell["Numbers in different representations are not the same:", "ExampleText",
 CellID->25149],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"0.", "=!=", "0"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->18781],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->29711]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData["!="], "InlineFormula"],
 " nevertheless treats them as equal:"
}], "ExampleText",
 CellID->14455],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"0.", "!=", "0"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->12218],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1706]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->27934],

Cell["Test whether multiple expressions are all distinct:", "ExampleText",
 CellID->21417],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"x", "=!=", "x", "=!=", "y"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->32581],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->6122]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"x", "=!=", "y", "=!=", "z"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->4092],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->25714]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->7997],

Cell["\<\
Construct the permanent analog of the totally antisymmetric tensor:\
\>", "ExampleText",
 CellID->9387],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Boole", "[", 
  RowBox[{"Array", "[", 
   RowBox[{"UnsameQ", ",", 
    RowBox[{"{", 
     RowBox[{"3", ",", "3", ",", "3"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->31394],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1", ",", "0"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "0", ",", "0"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "1", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{447, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->27948]
}, Open  ]],

Cell["1 appears at positions corresponding to permutations:", "ExampleText",
 CellID->686],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Position", "[", 
  RowBox[{"%", ",", "1"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->23414],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "3", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "1", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "3", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "1", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "2", ",", "1"}], "}"}]}], "}"}]], "Output",
 ImageSize->{419, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->8994]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->21466],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Equal",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Equal"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Order",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Order"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SameQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SameQ"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->30262]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->32367],

Cell[TextData[ButtonBox["Putting Constraints on Patterns",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/PuttingConstraintsOnPatterns"]], "Tutorials",
 CellID->14945]
}, Open  ]],

Cell["New in 2", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"UnsameQ (=!=) - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 28, 25.0382024}", "context" -> "System`", 
    "keywords" -> {"non-identical expressions", "nonsame"}, "index" -> True, 
    "label" -> "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "lhs =!= rhs yields True if the expression lhs is not identical to rhs, \
and yields False otherwise. ", "synonyms" -> {"=!=", "unsame q"}, "title" -> 
    "UnsameQ", "type" -> "Symbol", "uri" -> "ref/UnsameQ"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4087, 146, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->191260268]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 13743, 545}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1359, 33, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1982, 60, 102, 4, 70, "ObjectName",
 CellID->20150],
Cell[2087, 66, 868, 29, 70, "Usage",
 CellID->2228]
}, Open  ]],
Cell[CellGroupData[{
Cell[2992, 100, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3470, 117, 580, 24, 70, "Notes",
 CellID->19560]
}, Closed]],
Cell[CellGroupData[{
Cell[4087, 146, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->191260268],
Cell[CellGroupData[{
Cell[4472, 160, 146, 5, 70, "ExampleSection",
 CellID->3954862],
Cell[4621, 167, 98, 2, 70, "ExampleText",
 CellID->6016],
Cell[CellGroupData[{
Cell[4744, 173, 88, 3, 28, "Input",
 CellID->735],
Cell[4835, 178, 157, 5, 36, "Output",
 CellID->22804]
}, Open  ]],
Cell[CellGroupData[{
Cell[5029, 188, 90, 3, 28, "Input",
 CellID->31918],
Cell[5122, 193, 157, 5, 36, "Output",
 CellID->4513]
}, Open  ]],
Cell[5294, 201, 143, 4, 70, "ExampleText",
 CellID->15408],
Cell[CellGroupData[{
Cell[5462, 209, 88, 3, 70, "Input",
 CellID->1594],
Cell[5553, 214, 186, 6, 36, "Output",
 CellID->31018]
}, Open  ]],
Cell[5754, 223, 121, 3, 70, "ExampleDelimiter",
 CellID->25247],
Cell[5878, 228, 49, 1, 70, "ExampleText",
 CellID->32546],
Cell[CellGroupData[{
Cell[5952, 233, 122, 4, 70, "Input",
 CellID->32735],
Cell[6077, 239, 156, 5, 36, "Output",
 CellID->6152]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6282, 250, 216, 7, 70, "ExampleSection",
 CellID->12561],
Cell[6501, 259, 67, 1, 70, "ExampleText",
 CellID->21568],
Cell[CellGroupData[{
Cell[6593, 264, 110, 3, 70, "Input",
 CellID->13213],
Cell[6706, 269, 157, 5, 36, "Output",
 CellID->17970]
}, Open  ]],
Cell[6878, 277, 120, 3, 70, "ExampleDelimiter",
 CellID->6689],
Cell[7001, 282, 93, 1, 70, "ExampleText",
 CellID->25149],
Cell[CellGroupData[{
Cell[7119, 287, 91, 3, 70, "Input",
 CellID->18781],
Cell[7213, 292, 157, 5, 36, "Output",
 CellID->29711]
}, Open  ]],
Cell[7385, 300, 128, 4, 70, "ExampleText",
 CellID->14455],
Cell[CellGroupData[{
Cell[7538, 308, 90, 3, 70, "Input",
 CellID->12218],
Cell[7631, 313, 157, 5, 36, "Output",
 CellID->1706]
}, Open  ]],
Cell[7803, 321, 121, 3, 70, "ExampleDelimiter",
 CellID->27934],
Cell[7927, 326, 90, 1, 70, "ExampleText",
 CellID->21417],
Cell[CellGroupData[{
Cell[8042, 331, 102, 3, 70, "Input",
 CellID->32581],
Cell[8147, 336, 157, 5, 36, "Output",
 CellID->6122]
}, Open  ]],
Cell[CellGroupData[{
Cell[8341, 346, 101, 3, 70, "Input",
 CellID->4092],
Cell[8445, 351, 157, 5, 36, "Output",
 CellID->25714]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[8651, 362, 222, 7, 70, "ExampleSection",
 CellID->7997],
Cell[8876, 371, 113, 3, 70, "ExampleText",
 CellID->9387],
Cell[CellGroupData[{
Cell[9014, 378, 220, 7, 70, "Input",
 CellID->31394],
Cell[9237, 387, 954, 31, 54, "Output",
 CellID->27948]
}, Open  ]],
Cell[10206, 421, 90, 1, 70, "ExampleText",
 CellID->686],
Cell[CellGroupData[{
Cell[10321, 426, 123, 4, 70, "Input",
 CellID->23414],
Cell[10447, 432, 593, 19, 36, "Output",
 CellID->8994]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[11101, 458, 311, 9, 70, "SeeAlsoSection",
 CellID->21466],
Cell[11415, 469, 678, 26, 70, "SeeAlso",
 CellID->30262]
}, Open  ]],
Cell[CellGroupData[{
Cell[12130, 500, 314, 9, 70, "TutorialsSection",
 CellID->32367],
Cell[12447, 511, 170, 3, 70, "Tutorials",
 CellID->14945]
}, Open  ]],
Cell[12632, 517, 27, 0, 70, "History"],
Cell[12662, 519, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

