(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     24246,        912]
NotebookOptionsPosition[     18737,        720]
NotebookOutlinePosition[     20042,        757]
CellTagsIndexPosition[     19957,        752]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Manipulating Value Lists" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ManipulatingValueLists"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Manipulating Value Lists\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"UpSet" :> Documentation`HelpLookup["paclet:ref/UpSet"], "Set" :> 
          Documentation`HelpLookup["paclet:ref/Set"], "DownValues" :> 
          Documentation`HelpLookup["paclet:ref/DownValues"], 
          "HoldAllComplete" :> 
          Documentation`HelpLookup["paclet:ref/HoldAllComplete"], "ClearAll" :> 
          Documentation`HelpLookup["paclet:ref/ClearAll"], "Information" :> 
          Documentation`HelpLookup["paclet:ref/Information"], "Save" :> 
          Documentation`HelpLookup["paclet:ref/Save"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"UpSet\"\>", 2->"\<\"Set\"\>", 
       3->"\<\"DownValues\"\>", 4->"\<\"HoldAllComplete\"\>", 
       5->"\<\"ClearAll\"\>", 6->"\<\"Information\"\>", 
       7->"\<\"Save\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Assignments" :> 
          Documentation`HelpLookup["paclet:guide/Assignments"], 
          "Symbol Handling" :> 
          Documentation`HelpLookup["paclet:guide/SymbolHandling"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Assignments\"\>", 
       2->"\<\"Symbol Handling\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["UpValues", "ObjectName",
 CellID->11337],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["UpValues",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/UpValues"], "[", 
       StyleBox["f", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives a list of transformation rules corresponding to \
all upvalues defined for the symbol ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->27372]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "You can specify the upvalues for ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 " by making an assignment of the form ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"UpValues", "[", 
    StyleBox["f", "TI"], "]"}], "=", 
   StyleBox["list", "TI"]}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->11902],

Cell[TextData[{
 "The list returned by ",
 Cell[BoxData[
  ButtonBox["UpValues",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/UpValues"]], "InlineFormula"],
 " has elements of the form ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["HoldPattern",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/HoldPattern"], "[", 
    StyleBox["lhs", "TI"], "]"}], ":>", 
   StyleBox["rhs", "TI"]}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->4425]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->712131825],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->115528747],

Cell[TextData[{
 "Define upvalues for a symbol ",
 Cell[BoxData["g"], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->717516357],

Cell[BoxData[
 RowBox[{"g", "/:", 
  RowBox[{"f", "[", 
   RowBox[{"g", "[", "x_", "]"}], "]"}], ":=", 
  RowBox[{"h", "[", "x", "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->418380780],

Cell[TextData[{
 "These are the upvalues associated with ",
 Cell[BoxData["g"], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->277292788],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"UpValues", "[", "g", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->130436990],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"HoldPattern", "[", 
    RowBox[{"f", "[", 
     RowBox[{"g", "[", "x_", "]"}], "]"}], "]"}], "\[RuleDelayed]", 
   RowBox[{"h", "[", "x", "]"}]}], "}"}]], "Output",
 ImageSize->{209, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->278171399]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1845],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["UpValues",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/UpValues"]], "InlineFormula"],
 " returns rules corresponding to upvalues defined for a symbol:"
}], "ExampleText",
 CellID->4421672],

Cell[BoxData[
 RowBox[{"g", "/:", 
  RowBox[{
   RowBox[{"g", "[", "x_", "]"}], "+", 
   RowBox[{"g", "[", "y_", "]"}]}], ":=", 
  RowBox[{"gplus", "[", 
   RowBox[{"x", ",", "y"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->258442925],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"UpValues", "[", "g", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->460331481],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"HoldPattern", "[", 
    RowBox[{
     RowBox[{"g", "[", "x_", "]"}], "+", 
     RowBox[{"g", "[", "y_", "]"}]}], "]"}], "\[RuleDelayed]", 
   RowBox[{"gplus", "[", 
    RowBox[{"x", ",", "y"}], "]"}]}], "}"}]], "Output",
 ImageSize->{282, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->70425515]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->427955768],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["UpValues",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/UpValues"]], "InlineFormula"],
 " can be used to set the values directly:"
}], "ExampleText",
 CellID->553008221],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"UpValues", "[", "h", "]"}], "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"h", "[", "x_", "]"}], "*", 
      RowBox[{"h", "[", "y_", "]"}]}], "\[RuleDelayed]", 
     RowBox[{"htimes", "[", 
      RowBox[{"x", ",", "y"}], "]"}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->325312032],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"h", "[", "a", "]"}], " ", 
  RowBox[{"h", "[", "b", "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->317447194],

Cell[BoxData[
 RowBox[{"htimes", "[", 
  RowBox[{"a", ",", "b"}], "]"}]], "Output",
 ImageSize->{86, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->801723130]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->4592],

Cell["Copy a symbol's definitions to another symbol:", "ExampleText",
 CellID->8029391],

Cell[BoxData[
 RowBox[{"g", "/:", 
  RowBox[{
   RowBox[{"g", "[", "x_", "]"}], "+", 
   RowBox[{"g", "[", "y_", "]"}]}], ":=", 
  RowBox[{"gplus", "[", 
   RowBox[{"x", ",", "y"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->17716176],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"UpValues", "[", "h", "]"}], "=", 
  RowBox[{
   RowBox[{"UpValues", "[", "g", "]"}], "/.", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"g", "\[Rule]", "h"}], ",", 
     RowBox[{"gplus", "\[Rule]", "hplus"}]}], "}"}]}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->218087578],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"HoldPattern", "[", 
    RowBox[{
     RowBox[{"h", "[", "x_", "]"}], "+", 
     RowBox[{"h", "[", "y_", "]"}]}], "]"}], "\[RuleDelayed]", 
   RowBox[{"hplus", "[", 
    RowBox[{"x", ",", "y"}], "]"}]}], "}"}]], "Output",
 ImageSize->{282, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->38282828]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"h", "[", "a", "]"}], "+", 
  RowBox[{"h", "[", "b", "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->12395406],

Cell[BoxData[
 RowBox[{"hplus", "[", 
  RowBox[{"a", ",", "b"}], "]"}]], "Output",
 ImageSize->{79, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->630979329]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->6607],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["HoldPattern",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HoldPattern"]], "InlineFormula"],
 " is used to protect the rules from their own definitions:"
}], "ExampleText",
 CellID->46349163],

Cell[BoxData[
 RowBox[{"g", "/:", 
  RowBox[{"f", "[", 
   RowBox[{"g", "[", "x_", "]"}], "]"}], ":=", 
  RowBox[{"h", "[", "x", "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->249717458],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"UpValues", "[", "g", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->214604288],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"HoldPattern", "[", 
    RowBox[{"f", "[", 
     RowBox[{"g", "[", "x_", "]"}], "]"}], "]"}], "\[RuleDelayed]", 
   RowBox[{"h", "[", "x", "]"}]}], "}"}]], "Output",
 ImageSize->{209, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->12947533]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", 
   RowBox[{"g", "[", "x_", "]"}], "]"}], "\[RuleDelayed]", 
  RowBox[{"h", "[", "x", "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->5732677],

Cell[BoxData[
 RowBox[{
  RowBox[{"h", "[", "x_", "]"}], "\[RuleDelayed]", 
  RowBox[{"h", "[", "x", "]"}]}]], "Output",
 ImageSize->{83, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->400578437]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->68063005],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Definition",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Definition"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Information",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Information"]], "InlineFormula"],
 " display upvalues but do not return them as values:"
}], "ExampleText",
 CellID->172195385],

Cell[BoxData[
 RowBox[{"g", "/:", 
  RowBox[{"f", "[", 
   RowBox[{"g", "[", "x_", "]"}], "]"}], ":=", 
  RowBox[{"h", "[", "x", "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1963017],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Definition", "[", "g", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->509726874],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzFVcuOwjAMNEnT5bmVgAMnxA3xIdDTfkSFVoIDWgT862q/JjjUpsEbAkWV
iNQ440bjGZPQr+K0+d4Vp+26mOWHYr/Zro+z1c8BU7oFoJYAkE0A1xZXl4dH
jg9AF2eF6QSjxmgIDykyXlDsUXQMf1cG0FdmSAVWAndwShFqkU8EngvcE9hN
vxcFJVU5NHnxd7rXCecTvwfOifKcxfQMaN8ndarcwENHuSVXpV12x4S6Z3xe
CPCp2+q46D/pxuUdffpiHam3aWeadA4e+JnWYpNn9F2qR7W635B6HzdylkxQ
PavNbHUXolr+1b1/tp658QrEvlt+W+/2+z3n34bdMWtZx0TrvP5PIBUOHyj+
EHgccRTir5S5zmnPc9+GvxEdwTCifNve+3Zwh/KaCFpnPLqqZw==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{581, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->143753872]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["UpValues",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/UpValues"]], "InlineFormula"],
 " returns a value that can be used in a program:"
}], "ExampleText",
 CellID->257978063],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"UpValues", "[", "g", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->14087175],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"HoldPattern", "[", 
    RowBox[{"f", "[", 
     RowBox[{"g", "[", "x_", "]"}], "]"}], "]"}], "\[RuleDelayed]", 
   RowBox[{"h", "[", "x", "]"}]}], "}"}]], "Output",
 ImageSize->{209, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->77977802]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->108406],

Cell["\<\
Evaluation of an expression involves applying matching upvalues:\
\>", "ExampleText",
 CellID->750199789],

Cell[BoxData[
 RowBox[{"g", "/:", 
  RowBox[{"f", "[", 
   RowBox[{"g", "[", "x_", "]"}], "]"}], ":=", 
  RowBox[{"h", "[", "x", "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->503300199],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Hold", "[", 
   RowBox[{"f", "[", 
    RowBox[{"g", "[", "a", "]"}], "]"}], "]"}], "/.", 
  RowBox[{"UpValues", "[", "g", "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->144365139],

Cell[BoxData[
 RowBox[{"Hold", "[", 
  RowBox[{"h", "[", "a", "]"}], "]"}]], "Output",
 ImageSize->{74, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->247723703]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->4955],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["UpSet",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/UpSet"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Set",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Set"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["DownValues",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DownValues"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["HoldAllComplete",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/HoldAllComplete"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ClearAll",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ClearAll"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Information",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Information"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Save",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Save"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->26341]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->7315],

Cell[TextData[ButtonBox["Manipulating Value Lists",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ManipulatingValueLists"]], "Tutorials",
 CellID->27425]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Assignments",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Assignments"]], "MoreAbout",
 CellID->480621441],

Cell[TextData[ButtonBox["Symbol Handling",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SymbolHandling"]], "MoreAbout",
 CellID->90311562]
}, Open  ]],

Cell["New in 2  |  Last modified in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"UpValues - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 28, 47.8669118}", "context" -> "System`", 
    "keywords" -> {
     "assignments", "definitions", "evaluation", "symbol table"}, "index" -> 
    True, "label" -> "Built-in Mathematica Symbol", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "UpValues[f] gives a list of transformation rules corresponding to all \
upvalues defined for the symbol f. ", "synonyms" -> {"up values"}, "title" -> 
    "UpValues", "type" -> "Symbol", "uri" -> "ref/UpValues"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5078, 164, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->712131825]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 19814, 745}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2459, 57, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3082, 84, 46, 1, 70, "ObjectName",
 CellID->11337],
Cell[3131, 87, 610, 19, 70, "Usage",
 CellID->27372]
}, Open  ]],
Cell[CellGroupData[{
Cell[3778, 111, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4256, 128, 328, 12, 70, "Notes",
 CellID->11902],
Cell[4587, 142, 454, 17, 70, "Notes",
 CellID->4425]
}, Closed]],
Cell[CellGroupData[{
Cell[5078, 164, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->712131825],
Cell[CellGroupData[{
Cell[5463, 178, 148, 5, 70, "ExampleSection",
 CellID->115528747],
Cell[5614, 185, 131, 5, 70, "ExampleText",
 CellID->717516357],
Cell[5748, 192, 190, 6, 70, "Input",
 CellID->418380780],
Cell[5941, 200, 141, 5, 70, "ExampleText",
 CellID->277292788],
Cell[CellGroupData[{
Cell[6107, 209, 104, 3, 28, "Input",
 CellID->130436990],
Cell[6214, 214, 347, 11, 36, "Output",
 CellID->278171399]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6610, 231, 215, 7, 70, "ExampleSection",
 CellID->1845],
Cell[6828, 240, 237, 7, 70, "ExampleText",
 CellID->4421672],
Cell[7068, 249, 243, 8, 70, "Input",
 CellID->258442925],
Cell[CellGroupData[{
Cell[7336, 261, 104, 3, 70, "Input",
 CellID->460331481],
Cell[7443, 266, 402, 13, 36, "Output",
 CellID->70425515]
}, Open  ]],
Cell[7860, 282, 125, 3, 70, "ExampleDelimiter",
 CellID->427955768],
Cell[7988, 287, 217, 7, 70, "ExampleText",
 CellID->553008221],
Cell[8208, 296, 363, 12, 70, "Input",
 CellID->325312032],
Cell[CellGroupData[{
Cell[8596, 312, 148, 5, 70, "Input",
 CellID->317447194],
Cell[8747, 319, 213, 7, 36, "Output",
 CellID->801723130]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[9009, 332, 222, 7, 70, "ExampleSection",
 CellID->4592],
Cell[9234, 341, 87, 1, 70, "ExampleText",
 CellID->8029391],
Cell[9324, 344, 242, 8, 70, "Input",
 CellID->17716176],
Cell[CellGroupData[{
Cell[9591, 356, 308, 10, 70, "Input",
 CellID->218087578],
Cell[9902, 368, 402, 13, 36, "Output",
 CellID->38282828]
}, Open  ]],
Cell[CellGroupData[{
Cell[10341, 386, 147, 5, 70, "Input",
 CellID->12395406],
Cell[10491, 393, 212, 7, 36, "Output",
 CellID->630979329]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[10752, 406, 232, 7, 70, "ExampleSection",
 CellID->6607],
Cell[10987, 415, 239, 7, 70, "ExampleText",
 CellID->46349163],
Cell[11229, 424, 190, 6, 70, "Input",
 CellID->249717458],
Cell[CellGroupData[{
Cell[11444, 434, 104, 3, 70, "Input",
 CellID->214604288],
Cell[11551, 439, 346, 11, 36, "Output",
 CellID->12947533]
}, Open  ]],
Cell[CellGroupData[{
Cell[11934, 455, 189, 6, 70, "Input",
 CellID->5732677],
Cell[12126, 463, 250, 8, 36, "Output",
 CellID->400578437]
}, Open  ]],
Cell[12391, 474, 124, 3, 70, "ExampleDelimiter",
 CellID->68063005],
Cell[12518, 479, 367, 12, 70, "ExampleText",
 CellID->172195385],
Cell[12888, 493, 188, 6, 70, "Input",
 CellID->1963017],
Cell[CellGroupData[{
Cell[13101, 503, 106, 3, 70, "Input",
 CellID->509726874],
Cell[13210, 508, 630, 14, 70, "Output",
 Evaluatable->False,
 CellID->143753872]
}, Open  ]],
Cell[13855, 525, 224, 7, 70, "ExampleText",
 CellID->257978063],
Cell[CellGroupData[{
Cell[14104, 536, 103, 3, 70, "Input",
 CellID->14087175],
Cell[14210, 541, 346, 11, 36, "Output",
 CellID->77977802]
}, Open  ]],
Cell[14571, 555, 122, 3, 70, "ExampleDelimiter",
 CellID->108406],
Cell[14696, 560, 115, 3, 70, "ExampleText",
 CellID->750199789],
Cell[14814, 565, 190, 6, 70, "Input",
 CellID->503300199],
Cell[CellGroupData[{
Cell[15029, 575, 218, 7, 70, "Input",
 CellID->144365139],
Cell[15250, 584, 216, 7, 36, "Output",
 CellID->247723703]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[15527, 598, 310, 9, 70, "SeeAlsoSection",
 CellID->4955],
Cell[15840, 609, 1676, 62, 70, "SeeAlso",
 CellID->26341]
}, Open  ]],
Cell[CellGroupData[{
Cell[17553, 676, 313, 9, 70, "TutorialsSection",
 CellID->7315],
Cell[17869, 687, 157, 3, 70, "Tutorials",
 CellID->27425]
}, Open  ]],
Cell[CellGroupData[{
Cell[18063, 695, 299, 8, 70, "MoreAboutSection"],
Cell[18365, 705, 134, 3, 70, "MoreAbout",
 CellID->480621441],
Cell[18502, 710, 140, 3, 70, "MoreAbout",
 CellID->90311562]
}, Open  ]],
Cell[18657, 716, 50, 0, 70, "History"],
Cell[18710, 718, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

