(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     22682,        787]
NotebookOptionsPosition[     17636,        610]
NotebookOutlinePosition[     19013,        649]
CellTagsIndexPosition[     18928,        644]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Characters in Strings" :> 
          Documentation`HelpLookup["paclet:tutorial/CharactersInStrings"]}, #,
          2]& , Evaluator -> Automatic], {
       1->"\<\"Characters in Strings\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"LowerCaseQ" :> 
          Documentation`HelpLookup["paclet:ref/LowerCaseQ"], "LetterQ" :> 
          Documentation`HelpLookup["paclet:ref/LetterQ"], "ToUpperCase" :> 
          Documentation`HelpLookup["paclet:ref/ToUpperCase"], 
          "ToCharacterCode" :> 
          Documentation`HelpLookup["paclet:ref/ToCharacterCode"], 
          "StringExpression" :> 
          Documentation`HelpLookup["paclet:ref/StringExpression"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"LowerCaseQ\"\>", 
       2->"\<\"LetterQ\"\>", 3->"\<\"ToUpperCase\"\>", 
       4->"\<\"ToCharacterCode\"\>", 
       5->"\<\"StringExpression\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Character Operations" :> 
          Documentation`HelpLookup["paclet:guide/CharacterOperations"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Character Operations\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["UpperCaseQ", "ObjectName",
 CellID->17500],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["UpperCaseQ",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/UpperCaseQ"], "[", 
       StyleBox["string", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]yields ",
     Cell[BoxData[
      ButtonBox["True",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/True"]], "InlineFormula"],
     " if all the characters in the string are uppercase letters, and yields \
",
     Cell[BoxData[
      ButtonBox["False",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/False"]], "InlineFormula"],
     " otherwise. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->26380]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["UpperCaseQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/UpperCaseQ"]], "InlineFormula"],
 " treats both ordinary and special characters. "
}], "Notes",
 CellID->9072]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->55682695],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->162411286],

Cell["Test whether a character is an uppercase letter:", "ExampleText",
 CellID->18469],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"UpperCaseQ", "[", "\"\<A\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->4692],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"UpperCaseQ", "[", "\"\<z\>\"", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->10410],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]="]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->21049],

Cell["\<\
Test whether all characters in a string are upper-case letters:\
\>", "ExampleText",
 CellID->15871],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"UpperCaseQ", "[", "\"\<abcdABCD\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->13600],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]="]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->7471],

Cell["Accented letters are still treated as letters:", "ExampleText",
 CellID->5809],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"UpperCaseQ", "[", "\"\<\[CapitalADoubleDot]\[CapitalEAcute]\>\"", 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->6025],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]="]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->23965],

Cell["Gothic letters are treated as letters:", "ExampleText",
 CellID->26277],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"UpperCaseQ", "[", 
  "\"\<\[GothicCapitalA]\[GothicCapitalB]\[GothicCapitalC]\[GothicCapitalD]\
\[GothicCapitalE]\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->28978],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]="]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->26026],

Cell["Greek letters are treated as letters:", "ExampleText",
 CellID->27702],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"UpperCaseQ", "[", 
  "\"\<\[CapitalAlpha]\[CapitalBeta]\[CapitalGamma]\[CapitalDelta]\
\[CapitalEpsilon]\[CapitalZeta]\[CapitalEta]\[CapitalTheta]\>\"", 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->10394],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]="]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->24173],

Cell["All characters treated as uppercase letters:", "ExampleText",
 CellID->301],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Style", "[", 
  RowBox[{
   RowBox[{"StringJoin", "[", 
    RowBox[{"Select", "[", 
     RowBox[{
      RowBox[{"Characters", "[", 
       RowBox[{"FromCharacterCode", "[", 
        RowBox[{"Range", "[", 
         RowBox[{
          RowBox[{"2", "^", "16"}], "-", "1"}], "]"}], "]"}], "]"}], ",", 
      "UpperCaseQ"}], "]"}], "]"}], ",", "14"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->8902],

Cell[BoxData[
 StyleBox["\<\"ABCDEFGHIJKLMNOPQRSTUVWXYZ\[CapitalAGrave]\[CapitalAAcute]\
\[CapitalAHat]\[CapitalATilde]\[CapitalADoubleDot]\[CapitalARing]\[CapitalAE]\
\[CapitalCCedilla]\[CapitalEGrave]\[CapitalEAcute]\[CapitalEHat]\
\[CapitalEDoubleDot]\[CapitalIGrave]\[CapitalIAcute]\[CapitalIHat]\
\[CapitalIDoubleDot]\[CapitalEth]\[CapitalNTilde]\[CapitalOGrave]\
\[CapitalOAcute]\[CapitalOHat]\[CapitalOTilde]\[CapitalODoubleDot]\
\[CapitalOSlash]\[CapitalUGrave]\[CapitalUAcute]\[CapitalUHat]\
\[CapitalUDoubleDot]\[CapitalYAcute]\[CapitalThorn]\[CapitalABar]\
\[CapitalACup]\[CapitalCAcute]\[CapitalCHacek]\[CapitalEBar]\[CapitalECup]\
\[CapitalICup]\[CapitalLSlash]\[CapitalODoubleAcute]\[CapitalSHacek]\
\[CapitalUDoubleAcute]\[CapitalAlpha]\[CapitalBeta]\[CapitalGamma]\
\[CapitalDelta]\[CapitalEpsilon]\[CapitalZeta]\[CapitalEta]\[CapitalTheta]\
\[CapitalIota]\[CapitalKappa]\[CapitalLambda]\[CapitalMu]\[CapitalNu]\
\[CapitalXi]\[CapitalOmicron]\[CapitalPi]\[CapitalRho]\[CapitalSigma]\
\[CapitalTau]\[CapitalUpsilon]\[CapitalPhi]\[CapitalChi]\[CapitalPsi]\
\[CapitalOmega]\[CurlyCapitalUpsilon]\[CapitalStigma]\[CapitalDigamma]\
\[CapitalKoppa]\[CapitalSampi]\[ScriptCapitalH]\[GothicCapitalH]\
\[ScriptCapitalI]\[GothicCapitalI]\[ScriptCapitalL]\[ScriptCapitalR]\
\[GothicCapitalR]\[GothicCapitalZ]\[ScriptCapitalB]\[GothicCapitalC]\
\[ScriptCapitalE]\[ScriptCapitalF]\[ScriptCapitalM]\[ScriptCapitalA]\
\[ScriptCapitalC]\[ScriptCapitalD]\[ScriptCapitalG]\[ScriptCapitalJ]\
\[ScriptCapitalK]\[ScriptCapitalN]\[ScriptCapitalO]\[ScriptCapitalP]\
\[ScriptCapitalQ]\[ScriptCapitalS]\[ScriptCapitalT]\[ScriptCapitalU]\
\[ScriptCapitalV]\[ScriptCapitalW]\[ScriptCapitalX]\[ScriptCapitalY]\
\[ScriptCapitalZ]\[GothicCapitalA]\[GothicCapitalB]\[GothicCapitalD]\
\[GothicCapitalE]\[GothicCapitalF]\[GothicCapitalG]\[GothicCapitalJ]\
\[GothicCapitalK]\[GothicCapitalL]\[GothicCapitalM]\[GothicCapitalN]\
\[GothicCapitalO]\[GothicCapitalP]\[GothicCapitalQ]\[GothicCapitalS]\
\[GothicCapitalT]\[GothicCapitalU]\[GothicCapitalV]\[GothicCapitalW]\
\[GothicCapitalX]\[GothicCapitalY]\[DoubleStruckCapitalA]\
\[DoubleStruckCapitalB]\[DoubleStruckCapitalC]\[DoubleStruckCapitalD]\
\[DoubleStruckCapitalE]\[DoubleStruckCapitalF]\[DoubleStruckCapitalG]\
\[DoubleStruckCapitalH]\[DoubleStruckCapitalI]\[DoubleStruckCapitalJ]\
\[DoubleStruckCapitalK]\[DoubleStruckCapitalL]\[DoubleStruckCapitalM]\
\[DoubleStruckCapitalN]\[DoubleStruckCapitalO]\[DoubleStruckCapitalP]\
\[DoubleStruckCapitalQ]\[DoubleStruckCapitalR]\[DoubleStruckCapitalS]\
\[DoubleStruckCapitalT]\[DoubleStruckCapitalU]\[DoubleStruckCapitalV]\
\[DoubleStruckCapitalW]\[DoubleStruckCapitalX]\[DoubleStruckCapitalY]\
\[DoubleStruckCapitalZ]\"\>",
  StripOnInput->False,
  FontSize->14]], "Output",
 ImageSize->{586, 56},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]="]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->675],

Cell["No letters are both uppercase and lowercase:", "ExampleText",
 CellID->6303],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Select", "[", 
  RowBox[{
   RowBox[{"Characters", "[", 
    RowBox[{"FromCharacterCode", "[", 
     RowBox[{"Range", "[", 
      RowBox[{
       RowBox[{"2", "^", "16"}], "-", "1"}], "]"}], "]"}], "]"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"UpperCaseQ", "[", "#", "]"}], "&&", 
     RowBox[{"LowerCaseQ", "[", "#", "]"}]}], "&"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->30324],

Cell[BoxData[
 RowBox[{"{", "}"}]], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]="]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->20649],

Cell["Some letters are neither upper- nor lowercase:", "ExampleText",
 CellID->22029],

Cell[CellGroupData[{

Cell[BoxData["\"\<\[Aleph]\>\""], "Input",
 CellLabel->"In[1]:=",
 CellID->25059],

Cell[BoxData["\<\"\[Aleph]\"\>"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"LetterQ", "[", "%", "]"}], ",", 
   RowBox[{"UpperCaseQ", "[", "%", "]"}], ",", 
   RowBox[{"LowerCaseQ", "[", "%", "]"}]}], "}"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->24449],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"True", ",", "False", ",", "False"}], "}"}]], "Output",
 ImageSize->{139, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]="]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->3561],

Cell["Find all letters that are neither upper- nor lowercase:", "ExampleText",
 CellID->6096],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Select", "[", 
  RowBox[{
   RowBox[{"Characters", "[", 
    RowBox[{"FromCharacterCode", "[", 
     RowBox[{"Range", "[", 
      RowBox[{
       RowBox[{"2", "^", "16"}], "-", "1"}], "]"}], "]"}], "]"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"LetterQ", "[", "#", "]"}], "&&", 
     RowBox[{"!", 
      RowBox[{"UpperCaseQ", "[", "#", "]"}]}], "&&", 
     RowBox[{"!", 
      RowBox[{"LowerCaseQ", "[", "#", "]"}]}]}], "&"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->26403],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"\[Aleph]\"\>", ",", "\<\"\[Bet]\"\>", ",", "\<\"\[Gimel]\"\>", 
   ",", "\<\"\[Dalet]\"\>", ",", "\<\"\[FiLigature]\"\>", 
   ",", "\<\"\[FlLigature]\"\>"}], "}"}]], "Output",
 ImageSize->{116, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]="]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->6662],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["LowerCaseQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LowerCaseQ"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["LetterQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LetterQ"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ToUpperCase",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ToUpperCase"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ToCharacterCode",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ToCharacterCode"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["StringExpression",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/StringExpression"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->15626]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->21343],

Cell[TextData[ButtonBox["Characters in Strings",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/CharactersInStrings"]], "Tutorials",
 CellID->23794]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->517384166],

Cell[TextData[ButtonBox["Character Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/CharacterOperations"]], "MoreAbout",
 CellID->358580224]
}, Open  ]],

Cell["New in 2  |  Last modified in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"UpperCaseQ - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 28, 35.8822300}", "context" -> "System`", 
    "keywords" -> {
     "C isupper", "test for uppercase", "upper case character", 
      "upper case string", "upper case test"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "UpperCaseQ[string] yields True if all the characters in the string are \
uppercase letters, and yields False otherwise. ", 
    "synonyms" -> {"upper case q"}, "title" -> "UpperCaseQ", "type" -> 
    "Symbol", "uri" -> "ref/UpperCaseQ"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4480, 144, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->55682695]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 18786, 637}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2221, 54, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2844, 81, 48, 1, 70, "ObjectName",
 CellID->17500],
Cell[2895, 84, 817, 26, 70, "Usage",
 CellID->26380]
}, Open  ]],
Cell[CellGroupData[{
Cell[3749, 115, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4227, 132, 216, 7, 70, "Notes",
 CellID->9072]
}, Closed]],
Cell[CellGroupData[{
Cell[4480, 144, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->55682695],
Cell[CellGroupData[{
Cell[4864, 158, 148, 5, 70, "ExampleSection",
 CellID->162411286],
Cell[5015, 165, 87, 1, 70, "ExampleText",
 CellID->18469],
Cell[CellGroupData[{
Cell[5127, 170, 109, 3, 28, "Input",
 CellID->4692],
Cell[5239, 175, 141, 4, 36, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[5417, 184, 110, 3, 28, "Input",
 CellID->10410],
Cell[5530, 189, 142, 4, 36, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[5721, 199, 216, 7, 70, "ExampleSection",
 CellID->21049],
Cell[5940, 208, 110, 3, 70, "ExampleText",
 CellID->15871],
Cell[CellGroupData[{
Cell[6075, 215, 117, 3, 70, "Input",
 CellID->13600],
Cell[6195, 220, 142, 4, 36, "Output"]
}, Open  ]],
Cell[6352, 227, 120, 3, 70, "ExampleDelimiter",
 CellID->7471],
Cell[6475, 232, 84, 1, 70, "ExampleText",
 CellID->5809],
Cell[CellGroupData[{
Cell[6584, 237, 147, 4, 70, "Input",
 CellID->6025],
Cell[6734, 243, 141, 4, 36, "Output"]
}, Open  ]],
Cell[6890, 250, 121, 3, 70, "ExampleDelimiter",
 CellID->23965],
Cell[7014, 255, 77, 1, 70, "ExampleText",
 CellID->26277],
Cell[CellGroupData[{
Cell[7116, 260, 199, 5, 70, "Input",
 CellID->28978],
Cell[7318, 267, 141, 4, 36, "Output"]
}, Open  ]],
Cell[7474, 274, 121, 3, 70, "ExampleDelimiter",
 CellID->26026],
Cell[7598, 279, 76, 1, 70, "ExampleText",
 CellID->27702],
Cell[CellGroupData[{
Cell[7699, 284, 235, 6, 70, "Input",
 CellID->10394],
Cell[7937, 292, 141, 4, 36, "Output"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[8127, 302, 233, 7, 70, "ExampleSection",
 CellID->24173],
Cell[8363, 311, 81, 1, 70, "ExampleText",
 CellID->301],
Cell[CellGroupData[{
Cell[8469, 316, 425, 13, 70, "Input",
 CellID->8902],
Cell[8897, 331, 2867, 45, 77, "Output"]
}, Open  ]],
Cell[11779, 379, 119, 3, 70, "ExampleDelimiter",
 CellID->675],
Cell[11901, 384, 82, 1, 70, "ExampleText",
 CellID->6303],
Cell[CellGroupData[{
Cell[12008, 389, 421, 13, 70, "Input",
 CellID->30324],
Cell[12432, 404, 155, 5, 36, "Output"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[12636, 415, 226, 7, 70, "ExampleSection",
 CellID->20649],
Cell[12865, 424, 85, 1, 70, "ExampleText",
 CellID->22029],
Cell[CellGroupData[{
Cell[12975, 429, 81, 2, 70, "Input",
 CellID->25059],
Cell[13059, 433, 153, 4, 36, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[13249, 442, 232, 7, 70, "Input",
 CellID->24449],
Cell[13484, 451, 205, 6, 36, "Output"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[13738, 463, 223, 7, 70, "ExampleSection",
 CellID->3561],
Cell[13964, 472, 93, 1, 70, "ExampleText",
 CellID->6096],
Cell[CellGroupData[{
Cell[14082, 477, 513, 16, 70, "Input",
 CellID->26403],
Cell[14598, 495, 330, 8, 36, "Output"]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[14989, 510, 310, 9, 70, "SeeAlsoSection",
 CellID->6662],
Cell[15302, 521, 1224, 44, 70, "SeeAlso",
 CellID->15626]
}, Open  ]],
Cell[CellGroupData[{
Cell[16563, 570, 314, 9, 70, "TutorialsSection",
 CellID->21343],
Cell[16880, 581, 151, 3, 70, "Tutorials",
 CellID->23794]
}, Open  ]],
Cell[CellGroupData[{
Cell[17068, 589, 319, 9, 70, "MoreAboutSection",
 CellID->517384166],
Cell[17390, 600, 151, 3, 70, "MoreAbout",
 CellID->358580224]
}, Open  ]],
Cell[17556, 606, 50, 0, 70, "History"],
Cell[17609, 608, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

