(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     62108,       2258]
NotebookOptionsPosition[     50017,       1826]
NotebookOutlinePosition[     51353,       1864]
CellTagsIndexPosition[     51267,       1859]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Basic Statistics" :> 
          Documentation`HelpLookup["paclet:tutorial/BasicStatistics"], 
          "Descriptive Statistics" :> 
          Documentation`HelpLookup["paclet:tutorial/DescriptiveStatistics"], 
          "Discrete Distributions" :> 
          Documentation`HelpLookup["paclet:tutorial/DiscreteDistributions"], 
          "Continuous Distributions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ContinuousDistributions"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Basic Statistics\"\>", 
       2->"\<\"Descriptive Statistics\"\>", 
       3->"\<\"Discrete Distributions\"\>", 
       4->"\<\"Continuous Distributions\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"StandardDeviation" :> 
          Documentation`HelpLookup["paclet:ref/StandardDeviation"], 
          "Covariance" :> Documentation`HelpLookup["paclet:ref/Covariance"], 
          "Correlation" :> Documentation`HelpLookup["paclet:ref/Correlation"],
           "Mean" :> Documentation`HelpLookup["paclet:ref/Mean"], "Quantile" :> 
          Documentation`HelpLookup["paclet:ref/Quantile"], "MeanDeviation" :> 
          Documentation`HelpLookup["paclet:ref/MeanDeviation"], 
          "MedianDeviation" :> 
          Documentation`HelpLookup["paclet:ref/MedianDeviation"], "Kurtosis" :> 
          Documentation`HelpLookup["paclet:ref/Kurtosis"], "CentralMoment" :> 
          Documentation`HelpLookup["paclet:ref/CentralMoment"], 
          "ExpectedValue" :> 
          Documentation`HelpLookup["paclet:ref/ExpectedValue"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"StandardDeviation\"\>", 
       2->"\<\"Covariance\"\>", 3->"\<\"Correlation\"\>", 4->"\<\"Mean\"\>", 
       5->"\<\"Quantile\"\>", 6->"\<\"MeanDeviation\"\>", 
       7->"\<\"MedianDeviation\"\>", 8->"\<\"Kurtosis\"\>", 
       9->"\<\"CentralMoment\"\>", 
       10->"\<\"ExpectedValue\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Descriptive Statistics" :> 
          Documentation`HelpLookup["paclet:guide/DescriptiveStatistics"], 
          "Math & Counting Operations on Lists" :> 
          Documentation`HelpLookup[
           "paclet:guide/MathematicalAndCountingOperationsOnLists"], 
          "Numerical Data" :> 
          Documentation`HelpLookup["paclet:guide/NumericalData"], 
          "Precollege Education" :> 
          Documentation`HelpLookup["paclet:guide/PrecollegeEducation"], 
          "Statistical Distributions" :> 
          Documentation`HelpLookup["paclet:guide/StatisticalDistributions"], 
          "Statistics" :> Documentation`HelpLookup["paclet:guide/Statistics"],
           "New in 6.0: Mathematics & Algorithms" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60MathematicsAndAlgorithms"], 
          "New in 6.0: Statistics" :> 
          Documentation`HelpLookup["paclet:guide/NewIn60Statistics"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Descriptive Statistics\"\>", 
       2->"\<\"Math & Counting Operations on Lists\"\>", 
       3->"\<\"Numerical Data\"\>", 4->"\<\"Precollege Education\"\>", 
       5->"\<\"Statistical Distributions\"\>", 6->"\<\"Statistics\"\>", 
       7->"\<\"New in 6.0: Mathematics & Algorithms\"\>", 
       8->"\<\"New in 6.0: Statistics\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["Variance", "ObjectName"], Cell[BoxData[
     TooltipBox[
      TogglerBox[Dynamic[
        FrontEnd`CurrentValue[
         FrontEnd`EvaluationNotebook[], {
         TaggingRules, "ModificationHighlight"}]], {True->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVVly2zAMDQhxEylSsizLaxJn73KafvQAuUDv/1eApJuosceeTDAWF4B8
eFgk71///HoVV1dXK3p+0wNfIzdCLL4I6p1sYBYuPy3SI2AmRBpuaE/TPRsE
3Isg8mrB9l6ILQhhLkbd93MBuwVxAthdZwPr5wVVzBc8wAvMX8TFqPkqE8q6
rDCsKPjZ/g1guz+PKvLFfGsDU1R4A8zDhgLangX9x/WGM7A1qSQ7rraYkaLf
LHZ5FWY9H7rew/n4/6vWPKT2mXFBaH/NGejzqi/VnFEFJ2Rb1Lo+jtofllPD
RVJjdZLr51Eb/ED1K+QI109LcIg+sdSIWqa5g85L6MiNoRloTws+pdBKiFGl
mx3N0jcAlcsKeFivVkteVOgMSNsC18sYS/iIMdZoK43WSdQVK1SLlYy09bZ2
aEO+aoPiACNak0EBbtfLRIz9KJRcroaSKwE11BprpRHqiJ0BrxtJG4pLYqWc
RZO4BQwSbGT4rFivaLjjQdscjSvlih48Mu+WDisOBcB5ehgeDEZQlikkKh3b
KA1FMTDg9yFxLSe4XC37begHTDh5seS1I/gaW025Yo/yUFbmSalShzon1Kch
JTNn2hKS1hyWVIkf5n2LHEQgt0zeUNTkMaYrDdkMZdo3fJCDHx7hxzAC+8rs
XYBokTPfEJk6JVlZx3Yl0UnTYMPvSUt6zghf8dhIi5VDnwO+Hcb1MHK1msK+
oy5qkYS7wVC3cfiq8ojBcMtFMJXnDiIcLPFJClDFGkJBhXGEZV6VcCQFoey7
tyvBF6lw0uKH6nyQ5fqhrKx/Kxe8+3coucpGN4U5+RYux7vnhGO5P7hKenqz
xSO3ivjisf345fg5Pt1ScCRkkzR1U1Dur+NCec4LZ49Ynx9P04GmOvlnqcKZ
79BfJfcjkg==
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlLlKQ0EYRi/iA9gpWIgvIXbjM1iKWAjW2vgeZnWN+AgWZhEULCxELFyi
ZnfJavbeJOr/33xXcj8CNnY5EA7k3GWYmTuzq+uLa2OWZS38/MYt0DbDHH8Q
8uTB64bRNrmsQkaPRoQSGX1ZqZPR9/eEazL6klIlowf8wiUZ3ecV3snowYDw
SEafUmJk9HmlQh4cX4GM7vUId2T0VFIho28or2T0w5DQIKN3PoUaGX1FaZLR
0ymh6sz7hHLk9PMzoU5Gz6SFmvFsCbd9Xzj9qyc0nfe49xfuTyYUEzoQbmh8
+N8e37HTbVpk9MSzUCajbypFMvq0UiOjzyklMnqvKzRMJCwU+/vjzemTSpns
nh97feJmd0e4cvppTKiQ0bsdoW5ecorZDgpPtD6xqFA2fp+Qp/vtdUj1v797
Oqdwnb2Ov++fUVpk9PCJUCC7n4t5wz5xj9/+rj6ceXbPP86NbEb58/k56qP+
n/0bdGyYqQ==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}], False->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVdd22zAMDUBxSaJm5HgljrPTJN177/nWh35AfqD//1aAVGrrJLbbk+BI
FEmQFxcXlDQ9//3zHNfW1gZ0/6IbbsYOhahvCGrO9qHM/mnhmMMLoKv0RD6V
cPyZHTTcDI5NkYnQq4UQ0BdiAkKYZagl1OOw5fWtcgyvPp7AnefsGG0DBIeA
9RZVrNfcwBasb4nlbP9u4cbc/XD/zXcIgC2qYYazJTQiGSYHS0Hr8Yu5LV/h
ePvR5oMOKswAQ0M8R5OloFMWSNRE+IAVeALv38KX26wAV1uU5Ojv16PQy8q+
gMP+9ABW5C9KbkZi6qv19DGc/ID9b+CrZTjbbVagH3p91oIcL+GZ6JDNUet4
HpWUXxx5BaWZxRh1FQgH6JqoKcarF/2/dblez7IE0XmWGlFL/6ygchIqCmPo
CTSmDq9SaCUUhfI7K3pKlwJESZiAveHGxoA7ESYGpM2B62WMJXzEoojRRhpt
IlFHPKFyjGRBQ2fjBG0WttpMcYIFWhNAAXaHA0+M4yiUXK6UxJWAGmKNsdII
cYGVAadTSQPKS2KkEovGc8swk2ALhg8Tww1qdrjRNmSTtOUqHDhk3jktVpwK
QOLoZngwWICyTMFTqdhHMrQTDQPeazzXdgWXK+e4KV3AhH0US1Ergo8x16QV
R5QXZWWeJJW6qLNHPWq8mEFpS0hac1pSeX4YxjlyEhmFZfKGsqaIhd+Sks+Q
0i7lhZx8cwYPmx5wrMA+yaCwyMqnRCb2IiubsF9JTKRJMeX3JKd5VoS3OEyl
xShBFxLebXrDpsfVSlv2FZ2iHMn4NBg6bZy+ihxiZvjIFWAixyeIcLDNT1KC
qogha1Gh14NB6LXpSEpC2bm3y8O3FmHniF9U55INhnttz7pZuWDu79BqFZxJ
F2bhWzjo7Zx6HMvng6ukuztzvGJXa66NmF/+crzrHe1ScmTkk/SouqB8vq42
0jl0EnuF9/RsMR1Io4U/S5Wt+A79AaDyK/w=
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlUtrE1EYhgfxBwguFBTEvyAiFhfzHxRFvC0E17rQhYLiT7D3u/gTXNg2
3sBFFyIutE1qm17UZJKZZJK0KFjBtur7Td4jnhe7dTMPhAfyQObMnO9Mjl69
fvraniAI7v/+7A3IRri7/8VGWJwHVTH72qohZp+ZBnUx+yWjJWYfHwNvxOwX
jKaYfXAAzIrZ+/tARcw+NAhKYvaTRiJmP2gUxH+vLxKzl5cMMXtfL3gvZn84
Cdpi9hvGJzH7yxegJWa/YnTE7Mtl0HTPfZ/xyPWVZZCGvQ/Au65fSV9aNMLJ
CfDW9a0fIBWz/9wBHbcOf/74PX83W99j128ZNTH71BMQidmfFkAiZj9irIvZ
Fz+AWMx+yEjF7KeMVOw/32x/iuHoCHjt+s42aIfTU6DWna/Prm9vgVb4cc0I
h4fAgusZ62L2A0YsZj9h1MX+9bN9LHfP75zrZ42a2L9/3+wXjVTM7q8jm9NE
5q8wA+JwoB/8eX+eNxIx+00jErP3GA2xvy7uG88R+z2jI2Y/bLTE/v1l76WG
mxP/+r7ZN7+Bupj9mFERsz9/Bppi9myeEzH7QgnUxOy3jYaY/a7RFrNfNtpi
9nNGXcw+NgoaYnbOk2///PJ/bXXFcP37JojF7CPDIBazf/0CKmL2+TlQEbPf
MZpi9olxkIrZS0UQidn3G1Ux+3EjErOfMapi9mBX8p73vOc973n/P/0XnFJ2
Rg==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}]}, "\"\<Click me\>\""],
      "Toggle changes in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Variance",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Variance"], "[", 
       StyleBox["list", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the statistical variance of the elements in ",
     Cell[BoxData[
      StyleBox["list", "TI"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Variance",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Variance"], "[", 
       StyleBox["dist", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the variance of the symbolic distribution ",
     Cell[BoxData[
      StyleBox["dist", "TI"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->11886]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Variance",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Variance"], "[", 
   StyleBox["list", "TI"], "]"}]], "InlineFormula"],
 " gives the unbiased estimate of variance. "
}], "Notes",
 CellID->9312],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Variance",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Variance"], "[", 
   StyleBox["list", "TI"], "]"}]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Total",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Total"], "[", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       StyleBox["list", "TI"], "-", 
       RowBox[{
        ButtonBox["Mean",
         BaseStyle->"Link",
         ButtonData->"paclet:ref/Mean"], "[", 
        StyleBox["list", "TI"], "]"}]}], ")"}], "^", "2"}], "]"}], "/", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      ButtonBox["Length",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Length"], "[", 
      StyleBox["list", "TI"], "]"}], "-", "1"}], ")"}]}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->7734],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Variance",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Variance"]], "InlineFormula"],
 " handles both numerical and symbolic data. "
}], "Notes",
 CellID->23205],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Variance",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Variance"], "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["x", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["y", "TI"], 
        StyleBox["1", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["x", "TI"], 
        StyleBox["2", "TR"]], ",", 
       SubscriptBox[
        StyleBox["y", "TI"], 
        StyleBox["2", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
     StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}]], "InlineFormula", 
  "TemplateInclusion"],
 " gives ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Variance", "[", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["x", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["x", "TI"], 
        StyleBox["2", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}], ",", 
    RowBox[{"Variance", "[", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["y", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["y", "TI"], 
        StyleBox["2", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}]}], "}"}]], 
  "InlineFormula"],
 ". "
}], "Notes",
 CellID->12470],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Variance",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Variance"]], "InlineFormula"],
 " works with ",
 Cell[BoxData[
  ButtonBox["SparseArray",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SparseArray"]], "InlineFormula"],
 " objects. "
}], "Notes",
 CellID->12504]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->23411706],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->235412924],

Cell["Variance of a list of numbers:", "ExampleText",
 CellID->46582167],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Variance", "[", 
  RowBox[{"{", 
   RowBox[{
   "1.21", ",", "3.4", ",", "2", ",", "4.66", ",", "1.5", ",", "5.61", ",", 
    "7.22"}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->7799],

Cell[BoxData["5.161223809523809`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->25091]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->4613],

Cell["Variance of elements in each column:", "ExampleText",
 CellID->14137],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Variance", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"5.2", ",", "7"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"5.3", ",", "8"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"5.4", ",", "9"}], "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->30818],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.010000000000000018`", ",", "1"}], "}"}]], "Output",
 ImageSize->{65, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->29003]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->791078686],

Cell["Variance of a symbolic lognormal distribution:", "ExampleText",
 CellID->95484360],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Variance", "[", 
  RowBox[{"LogNormalDistribution", "[", 
   RowBox[{"0", ",", "1"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->834848358],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", "1"}], "+", "\[ExponentialE]"}], ")"}], " ", 
  "\[ExponentialE]"}]], "Output",
 ImageSize->{63, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->18545455]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->28963],

Cell["Exact numeric input:", "ExampleText",
 CellID->18799],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Variance", "[", 
  RowBox[{"{", 
   RowBox[{"1", ",", "3", ",", "4", ",", "1", ",", "2"}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->29442],

Cell[BoxData[
 FractionBox["17", "10"]], "Output",
 ImageSize->{23, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->312146806]
}, Open  ]],

Cell["Numerical approximation:", "ExampleText",
 CellID->10736],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Variance", "[", 
   RowBox[{"{", 
    RowBox[{"1", ",", "3", ",", "4", ",", "1", ",", "2"}], "}"}], "]"}], "//",
   "N"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->30301],

Cell[BoxData["1.7`"], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->547034687]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->9954],

Cell["Variance of symbolic values:", "ExampleText",
 CellID->18079],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Variance", "[", 
  RowBox[{"{", 
   RowBox[{"a", ",", "b", ",", "c"}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->19196],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "2"], " ", 
  RowBox[{"(", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"Abs", "[", 
      RowBox[{"a", "+", 
       RowBox[{
        FractionBox["1", "3"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "a"}], "-", "b", "-", "c"}], ")"}]}]}], "]"}], "2"], 
    "+", 
    SuperscriptBox[
     RowBox[{"Abs", "[", 
      RowBox[{"b", "+", 
       RowBox[{
        FractionBox["1", "3"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "a"}], "-", "b", "-", "c"}], ")"}]}]}], "]"}], "2"], 
    "+", 
    SuperscriptBox[
     RowBox[{"Abs", "[", 
      RowBox[{
       RowBox[{
        FractionBox["1", "3"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "a"}], "-", "b", "-", "c"}], ")"}]}], "+", "c"}], 
      "]"}], "2"]}], ")"}]}]], "Output",
 ImageSize->{484, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->448435295]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->23906],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "18"], " ", 
  RowBox[{"(", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"Abs", "[", 
      RowBox[{"a", "+", "b", "-", 
       RowBox[{"2", " ", "c"}]}], "]"}], "2"], "+", 
    SuperscriptBox[
     RowBox[{"Abs", "[", 
      RowBox[{
       RowBox[{"2", " ", "a"}], "-", "b", "-", "c"}], "]"}], "2"], "+", 
    SuperscriptBox[
     RowBox[{"Abs", "[", 
      RowBox[{"a", "-", 
       RowBox[{"2", " ", "b"}], "+", "c"}], "]"}], "2"]}], ")"}]}]], "Output",\

 ImageSize->{355, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->355710398]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->13036],

Cell["Mixed numeric and symbolic data:", "ExampleText",
 CellID->20164],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Variance", "[", 
   RowBox[{"{", 
    RowBox[{"1", ",", "4", ",", "5", ",", "x"}], "}"}], "]"}], "//", 
  "Simplify"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->3749],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "48"], " ", 
  RowBox[{"(", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"Abs", "[", 
      RowBox[{"6", "-", "x"}], "]"}], "2"], "+", 
    SuperscriptBox[
     RowBox[{"Abs", "[", 
      RowBox[{"10", "-", "x"}], "]"}], "2"], "+", 
    RowBox[{"16", " ", 
     SuperscriptBox[
      RowBox[{"Abs", "[", 
       RowBox[{
        FractionBox["5", "2"], "-", 
        FractionBox[
         RowBox[{"3", " ", "x"}], "4"]}], "]"}], "2"]}], "+", 
    SuperscriptBox[
     RowBox[{"Abs", "[", 
      RowBox[{"6", "+", "x"}], "]"}], "2"]}], ")"}]}]], "Output",
 ImageSize->{388, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->403845016]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->28583],

Cell["Exact numeric data:", "ExampleText",
 CellID->22629],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Variance", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Sqrt", "[", "2", "]"}], ",", 
     RowBox[{"Sqrt", "[", "3", "]"}], ",", 
     RowBox[{"Sqrt", "[", "5", "]"}]}], "}"}], "]"}], "//", 
  "Simplify"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->11917],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "3"], " ", 
  RowBox[{"(", 
   RowBox[{"10", "-", 
    SqrtBox["6"], "-", 
    SqrtBox["10"], "-", 
    SqrtBox["15"]}], ")"}]}]], "Output",
 ImageSize->{170, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->205229140]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->359275129],

Cell["Arbitrary\[Hyphen]precision data:", "ExampleText",
 CellID->188291280],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Variance", "[", 
  RowBox[{"N", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"2", ",", "5", ",", "3", ",", "10", ",", "1"}], "}"}], ",", 
    "20"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->24927221],

Cell[BoxData["12.7`19.295457685215567"], "Output",
 ImageSize->{151, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->62479024]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->650909219],

Cell["Compute results for a large vector or matrix:", "ExampleText",
 CellID->285474028],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Variance", "[", 
  RowBox[{"RandomReal", "[", 
   RowBox[{"1", ",", 
    RowBox[{"10", "^", "7"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->315224713],

Cell[BoxData["0.08336602189868006`"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->110364229]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Variance", "[", 
  RowBox[{"RandomReal", "[", 
   RowBox[{"1", ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"10", "^", "6"}], ",", "10"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->594479966],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.0833232293422085`", ",", "0.08326088411791724`", ",", 
   "0.08343468266285094`", ",", "0.08338978959030359`", ",", 
   "0.08321141105568597`", ",", "0.08339465062631819`", ",", 
   "0.08334638420694322`", ",", "0.08345237345012292`", ",", 
   "0.08345535470320171`", ",", "0.08333627664111852`"}], "}"}]], "Output",
 ImageSize->{378, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->36588108]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->28609],

Cell[TextData[{
 "Compute results for a ",
 Cell[BoxData[
  ButtonBox["SparseArray",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SparseArray"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->625271644],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sp", "=", 
  RowBox[{"SparseArray", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{"i_", ",", "i_"}], "}"}], ":>", "i"}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{"{", 
         RowBox[{"i_", ",", "j_"}], "}"}], "/;", 
        RowBox[{"j", "\[Equal]", 
         RowBox[{"i", "+", "1"}]}]}], "\[RuleDelayed]", 
       RowBox[{"i", "-", "1"}]}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"100", ",", "10"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->19878761],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "18", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 18, ">"],
     Editable->False], ",", 
    RowBox[{"{", 
     RowBox[{"100", ",", "10"}], "}"}]}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{195, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->373694810]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Variance", "[", "sp", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->235263230],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["1", "100"], ",", 
   FractionBox["1", "25"], ",", 
   FractionBox["82", "825"], ",", 
   FractionBox["491", "2475"], ",", 
   FractionBox["278", "825"], ",", 
   FractionBox["17", "33"], ",", 
   FractionBox["1814", "2475"], ",", 
   FractionBox["817", "825"], ",", 
   FractionBox["354", "275"], ",", 
   FractionBox["4019", "2475"]}], "}"}]], "Output",
 ImageSize->{377, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->182029555]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(9)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->17310],

Cell[TextData[{
 "The square root of ",
 Cell[BoxData[
  ButtonBox["Variance",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Variance"]], "InlineFormula"],
 " is ",
 Cell[BoxData[
  ButtonBox["StandardDeviation",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StandardDeviation"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->180528295],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Variance", "[", 
  RowBox[{"{", 
   RowBox[{"1", ",", "2", ",", "3", ",", "4"}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->11119],

Cell[BoxData[
 FractionBox["5", "3"]], "Output",
 ImageSize->{16, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->123914350]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StandardDeviation", "[", 
  RowBox[{"{", 
   RowBox[{"1", ",", "2", ",", "3", ",", "4"}], "}"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->12868],

Cell[BoxData[
 SqrtBox[
  FractionBox["5", "3"]]], "Output",
 ImageSize->{35, 39},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->116342001]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->353623198],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Variance",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Variance"]], "InlineFormula"],
 " is a scaled squared ",
 Cell[BoxData[
  ButtonBox["Norm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Norm"]], "InlineFormula"],
 " of deviations from the ",
 Cell[BoxData[
  ButtonBox["Mean",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Mean"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->7602946],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"data", "=", 
  RowBox[{"RandomReal", "[", 
   RowBox[{"10", ",", "20"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->691934725],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "2.5356066363418006`", ",", "5.846601839138068`", ",", 
   "2.7360547388504086`", ",", "2.5189809151154896`", ",", 
   "6.139404972928082`", ",", "3.1565158476399313`", ",", "8.58524385673501`",
    ",", "6.175019207882593`", ",", "4.901626333586629`", ",", 
   "3.273233756745415`", ",", "0.5679008760362514`", ",", 
   "3.382390794276151`", ",", "0.6008257395802863`", ",", 
   "4.391471930298822`", ",", "7.184789358612187`", ",", "4.586454109028491`",
    ",", "3.6655371894017907`", ",", "6.481194161483388`", ",", 
   "9.599813629687912`", ",", "5.606504746545198`"}], "}"}]], "Output",
 ImageSize->{443, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->90393666]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Variance", "[", "data", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->214941188],

Cell[BoxData["5.74578462263852`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->145372700]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Norm", "[", 
    RowBox[{"data", "-", 
     RowBox[{"Mean", "[", "data", "]"}]}], "]"}], "^", "2"}], "/", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"Length", "[", "data", "]"}], "-", "1"}], ")"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->650778682],

Cell[BoxData["5.745784622638519`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->44707512]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->137012746],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Variance",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Variance"]], "InlineFormula"],
 " is a scaled ",
 Cell[BoxData[
  ButtonBox["CentralMoment",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CentralMoment"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->22673528],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"data", "=", 
  RowBox[{"RandomReal", "[", 
   RowBox[{"10", ",", "20"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->86545193],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "9.475224574390012`", ",", "8.227422306037361`", ",", "6.526011967549881`", 
   ",", "0.9975346958120856`", ",", "9.19965910366453`", ",", 
   "1.614489390282039`", ",", "9.433687498127624`", ",", 
   "0.015639229847406177`", ",", "6.994823306779456`", ",", 
   "9.91853313840929`", ",", "4.2357720398103105`", ",", 
   "4.3040741170656505`", ",", "0.7801947660090103`", ",", 
   "1.242091104892944`", ",", "4.5643971333511875`", ",", 
   "6.5400504413892335`", ",", "7.995787347306016`", ",", 
   "7.051209501515916`", ",", "0.16015642013766485`", ",", 
   "1.5338011754736236`"}], "}"}]], "Output",
 ImageSize->{450, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->203171170]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Variance", "[", "data", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->309913758],

Cell[BoxData["12.353176043683105`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->278463864]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"CentralMoment", "[", 
   RowBox[{"data", ",", "2"}], "]"}], " ", 
  RowBox[{
   RowBox[{"Length", "[", "data", "]"}], "/", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"Length", "[", "data", "]"}], "-", "1"}], ")"}]}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->154126311],

Cell[BoxData["12.353176043683105`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->196909558]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->97257252],

Cell[TextData[{
 "The square root of ",
 Cell[BoxData[
  ButtonBox["Variance",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Variance"]], "InlineFormula"],
 " is a scaled ",
 Cell[BoxData[
  ButtonBox["RootMeanSquare",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RootMeanSquare"]], "InlineFormula"],
 " of the deviations:"
}], "ExampleText",
 CellID->22987128],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"data", "=", 
  RowBox[{"RandomReal", "[", 
   RowBox[{"10", ",", "10"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->451046271],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "5.555301041709684`", ",", "3.1029362286109463`", ",", 
   "0.39979165803084804`", ",", "0.8858122130594248`", ",", 
   "4.509439982336496`", ",", "9.508763003481423`", ",", "8.026073627758088`",
    ",", "9.855221184392963`", ",", "9.756998995612784`", ",", 
   "5.5187422825281836`"}], "}"}]], "Output",
 ImageSize->{354, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->456745029]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"RootMeanSquare", "[", 
   RowBox[{"data", "-", 
    RowBox[{"Mean", "[", "data", "]"}]}], "]"}], 
  RowBox[{"Sqrt", "[", 
   RowBox[{
    RowBox[{"Length", "[", "data", "]"}], "/", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Length", "[", "data", "]"}], "-", "1"}], ")"}]}], 
   "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->162394754],

Cell[BoxData["3.5453499768233545`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->269688458]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Variance", "[", "data", "]"}], "//", "Sqrt"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->251299893],

Cell[BoxData["3.5453499768233545`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->75569549]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->396400762],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Variance",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Variance"]], "InlineFormula"],
 " is a scaled ",
 Cell[BoxData[
  ButtonBox["Mean",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Mean"]], "InlineFormula"],
 " of squared deviations from the ",
 Cell[BoxData[
  ButtonBox["Mean",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Mean"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->19399639],

Cell[BoxData[
 RowBox[{
  RowBox[{"data", "=", 
   RowBox[{"RandomReal", "[", 
    RowBox[{"5", ",", "20"}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->89934925],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Variance", "[", "data", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->443930393],

Cell[BoxData["1.489134294397024`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->26994932]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Mean", "[", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"data", "-", 
      RowBox[{"Mean", "[", "data", "]"}]}], ")"}], "^", "2"}], "]"}], " ", 
  RowBox[{
   RowBox[{"Length", "[", "data", "]"}], "/", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"Length", "[", "data", "]"}], "-", "1"}], ")"}]}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->134444918],

Cell[BoxData["1.489134294397024`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->32697588]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->70099947],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Variance",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Variance"]], "InlineFormula"],
 " as a scaled ",
 Cell[BoxData[
  ButtonBox["SquaredEuclideanDistance",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SquaredEuclideanDistance"]], "InlineFormula"],
 " from the ",
 Cell[BoxData[
  ButtonBox["Mean",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Mean"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->394865487],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"data", "=", 
  RowBox[{"RandomReal", "[", 
   RowBox[{"10", ",", "20"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->148442668],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "6.872592416142142`", ",", "5.8529930463499635`", ",", "9.599697082253766`",
    ",", "1.135456067404088`", ",", "8.441297557442255`", ",", 
   "0.25148018635270386`", ",", "1.9167911243317004`", ",", 
   "3.2566429392813734`", ",", "7.772060912249124`", ",", 
   "2.1519360382173525`", ",", "7.811542670514129`", ",", 
   "5.009754145559759`", ",", "0.9566301929008669`", ",", 
   "4.917291186590287`", ",", "8.571106803241813`", ",", "5.593478862725741`",
    ",", "0.2331773820248917`", ",", "0.36562652496615167`", ",", 
   "4.947827302718242`", ",", "5.532315675121349`"}], "}"}]], "Output",
 ImageSize->{443, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->254916920]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"mean", "=", 
  RowBox[{"Mean", "[", "data", "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->618390570],

Cell[BoxData["4.559484905819385`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->5990024]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"len", "=", 
  RowBox[{"Length", "[", "data", "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->5648062],

Cell[BoxData["20"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->111916264]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"SquaredEuclideanDistance", "[", 
   RowBox[{"data", ",", 
    RowBox[{"Table", "[", 
     RowBox[{"mean", ",", 
      RowBox[{"{", "len", "}"}]}], "]"}]}], "]"}], "/", 
  RowBox[{"(", 
   RowBox[{"len", "-", "1"}], ")"}]}]], "Input",
 CellLabel->"In[4]:=",
 CellID->263731272],

Cell[BoxData["9.527838816387778`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->879169100]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Variance", "[", "data", "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->35249381],

Cell[BoxData["9.527838816387776`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->894273159]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->211774243],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Variance",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Variance"]], "InlineFormula"],
 " is less than ",
 Cell[BoxData[
  ButtonBox["MeanDeviation",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MeanDeviation"]], "InlineFormula"],
 " if all absolute deviations are less than 1:"
}], "ExampleText",
 CellID->250203883],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"data", "=", 
  RowBox[{"RandomReal", "[", 
   RowBox[{"1", ",", "10"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->390325569],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.6256126231731385`", ",", "0.7637434738757025`", ",", 
   "0.7124789841434953`", ",", "0.12372320991233687`", ",", 
   "0.10847461159471394`", ",", "0.7344538831188652`", ",", 
   "0.08590867929142232`", ",", "0.2112032216923896`", ",", 
   "0.6580993502204688`", ",", "0.439334740144665`"}], "}"}]], "Output",
 ImageSize->{417, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->97227503]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MeanDeviation", "[", "data", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->287940559],

Cell[BoxData["0.2525743851896142`"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->122761081]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Variance", "[", "data", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->421485872],

Cell[BoxData["0.08167210501666819`"], "Output",
 ImageSize->{67, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1032270]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->156147355],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Variance",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Variance"]], "InlineFormula"],
 " is greater than ",
 Cell[BoxData[
  ButtonBox["MeanDeviation",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MeanDeviation"]], "InlineFormula"],
 " if all absolute deviations are greater than 1:"
}], "ExampleText",
 CellID->486490344],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"data", "=", 
  RowBox[{"Join", "[", 
   RowBox[{
    RowBox[{"RandomReal", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "2"}], "}"}], ",", "5"}], "]"}], ",", 
    RowBox[{"RandomReal", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"5", ",", "6"}], "}"}], ",", "5"}], "]"}]}], "]"}]}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->471760332],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1.5376445441650077`", ",", "1.3515256087086687`", ",", 
   "1.4856340562255481`", ",", "1.542003777856425`", ",", 
   "1.6379864555685375`", ",", "5.422085727877857`", ",", "5.33638436781507`",
    ",", "5.951810066214467`", ",", "5.2560268144653985`", ",", 
   "5.024445510988919`"}], "}"}]], "Output",
 ImageSize->{368, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->770071228]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MeanDeviation", "[", "data", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->106654448],

Cell[BoxData["1.9435958044837522`"], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->492248326]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Variance", "[", "data", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->309580972],

Cell[BoxData["4.25447779648368`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->26799490]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->797726614],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Variance",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Variance"]], "InlineFormula"],
 " of a random variable as an ",
 Cell[BoxData[
  ButtonBox["ExpectedValue",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ExpectedValue"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->572927312],

Cell[BoxData[
 RowBox[{
  RowBox[{"dist", "=", 
   RowBox[{"GammaDistribution", "[", 
    RowBox[{"\[Alpha]", ",", "\[Beta]"}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->173202917],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExpectedValue", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"x", "-", 
      RowBox[{"Mean", "[", "dist", "]"}]}], ")"}], "^", "2"}], ",", "dist", 
   ",", "x"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->140877037],

Cell[BoxData[
 RowBox[{"\[Alpha]", " ", 
  SuperscriptBox["\[Beta]", "2"]}]], "Output",
 ImageSize->{27, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->82060103]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Variance", "[", "dist", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->259210552],

Cell[BoxData[
 RowBox[{"\[Alpha]", " ", 
  SuperscriptBox["\[Beta]", "2"]}]], "Output",
 ImageSize->{27, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->274259420]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->25032],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["StandardDeviation",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/StandardDeviation"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Covariance",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Covariance"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Correlation",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Correlation"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Mean",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Mean"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Quantile",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Quantile"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MeanDeviation",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MeanDeviation"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MedianDeviation",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MedianDeviation"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Kurtosis",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Kurtosis"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["CentralMoment",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CentralMoment"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ExpectedValue",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ExpectedValue"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->7802]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->31778],

Cell[TextData[ButtonBox["Basic Statistics",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/BasicStatistics"]], "Tutorials",
 CellID->30845],

Cell[TextData[ButtonBox["Descriptive Statistics",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/DescriptiveStatistics"]], "Tutorials",
 CellID->4063544],

Cell[TextData[ButtonBox["Discrete Distributions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/DiscreteDistributions"]], "Tutorials",
 CellID->4738],

Cell[TextData[ButtonBox["Continuous Distributions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ContinuousDistributions"]], "Tutorials",
 CellID->7471]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->527546416],

Cell[TextData[ButtonBox["Descriptive Statistics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DescriptiveStatistics"]], "MoreAbout",
 CellID->59722704],

Cell[TextData[ButtonBox["Math & Counting Operations on Lists",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/MathematicalAndCountingOperationsOnLists"]], "MoreAbout",
 CellID->239081509],

Cell[TextData[ButtonBox["Numerical Data",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumericalData"]], "MoreAbout",
 CellID->379642328],

Cell[TextData[ButtonBox["Precollege Education",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PrecollegeEducation"]], "MoreAbout",
 CellID->336758028],

Cell[TextData[ButtonBox["Statistical Distributions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/StatisticalDistributions"]], "MoreAbout",
 CellID->147041923],

Cell[TextData[ButtonBox["Statistics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Statistics"]], "MoreAbout",
 CellID->58513070],

Cell[TextData[ButtonBox["New in 6.0: Mathematics & Algorithms",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60MathematicsAndAlgorithms"]], "MoreAbout",
 CellID->126881086],

Cell[TextData[ButtonBox["New in 6.0: Statistics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60Statistics"]], "MoreAbout",
 CellID->246370521]
}, Open  ]],

Cell["New in 5  |  Last modified in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Variance - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 28, 55.0233450}", "context" -> "System`", 
    "keywords" -> {
     "dispersion", "sample variance", "spread", "VAR", "variance"}, "index" -> 
    True, "label" -> "Built-in Mathematica Symbol", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "Variance[list] gives the statistical variance of the elements in list. \
Variance[dist] gives the variance of the symbolic distribution dist.", 
    "synonyms" -> {}, "title" -> "Variance", "type" -> "Symbol", "uri" -> 
    "ref/Variance"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[13869, 381, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->23411706]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 51124, 1852}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 4374, 89, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[4997, 116, 4192, 83, 70, "ObjectNameGrid"],
Cell[9192, 201, 961, 30, 70, "Usage",
 CellID->11886]
}, Open  ]],
Cell[CellGroupData[{
Cell[10190, 236, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[10668, 253, 262, 9, 70, "Notes",
 CellID->9312],
Cell[10933, 264, 868, 32, 70, "Notes",
 CellID->7734],
Cell[11804, 298, 210, 7, 70, "Notes",
 CellID->23205],
Cell[12017, 307, 1493, 55, 70, "Notes",
 CellID->12470],
Cell[13513, 364, 319, 12, 70, "Notes",
 CellID->12504]
}, Closed]],
Cell[CellGroupData[{
Cell[13869, 381, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->23411706],
Cell[CellGroupData[{
Cell[14253, 395, 148, 5, 70, "ExampleSection",
 CellID->235412924],
Cell[14404, 402, 72, 1, 70, "ExampleText",
 CellID->46582167],
Cell[CellGroupData[{
Cell[14501, 407, 221, 7, 28, "Input",
 CellID->7799],
Cell[14725, 416, 171, 5, 36, "Output",
 CellID->25091]
}, Open  ]],
Cell[14911, 424, 120, 3, 70, "ExampleDelimiter",
 CellID->4613],
Cell[15034, 429, 75, 1, 70, "ExampleText",
 CellID->14137],
Cell[CellGroupData[{
Cell[15134, 434, 316, 11, 70, "Input",
 CellID->30818],
Cell[15453, 447, 219, 7, 36, "Output",
 CellID->29003]
}, Open  ]],
Cell[15687, 457, 125, 3, 70, "ExampleDelimiter",
 CellID->791078686],
Cell[15815, 462, 88, 1, 70, "ExampleText",
 CellID->95484360],
Cell[CellGroupData[{
Cell[15928, 467, 176, 5, 70, "Input",
 CellID->834848358],
Cell[16107, 474, 277, 10, 36, "Output",
 CellID->18545455]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[16433, 490, 216, 7, 70, "ExampleSection",
 CellID->28963],
Cell[16652, 499, 59, 1, 70, "ExampleText",
 CellID->18799],
Cell[CellGroupData[{
Cell[16736, 504, 180, 6, 70, "Input",
 CellID->29442],
Cell[16919, 512, 180, 6, 51, "Output",
 CellID->312146806]
}, Open  ]],
Cell[17114, 521, 63, 1, 70, "ExampleText",
 CellID->10736],
Cell[CellGroupData[{
Cell[17202, 526, 206, 7, 70, "Input",
 CellID->30301],
Cell[17411, 535, 161, 5, 36, "Output",
 CellID->547034687]
}, Open  ]],
Cell[17587, 543, 120, 3, 70, "ExampleDelimiter",
 CellID->9954],
Cell[17710, 548, 67, 1, 70, "ExampleText",
 CellID->18079],
Cell[CellGroupData[{
Cell[17802, 553, 157, 5, 70, "Input",
 CellID->19196],
Cell[17962, 560, 984, 36, 52, "Output",
 CellID->448435295]
}, Open  ]],
Cell[CellGroupData[{
Cell[18983, 601, 104, 3, 70, "Input",
 CellID->23906],
Cell[19090, 606, 634, 22, 51, "Output",
 CellID->355710398]
}, Open  ]],
Cell[19739, 631, 121, 3, 70, "ExampleDelimiter",
 CellID->13036],
Cell[19863, 636, 71, 1, 70, "ExampleText",
 CellID->20164],
Cell[CellGroupData[{
Cell[19959, 641, 202, 7, 70, "Input",
 CellID->3749],
Cell[20164, 650, 728, 25, 52, "Output",
 CellID->403845016]
}, Open  ]],
Cell[20907, 678, 121, 3, 70, "ExampleDelimiter",
 CellID->28583],
Cell[21031, 683, 58, 1, 70, "ExampleText",
 CellID->22629],
Cell[CellGroupData[{
Cell[21114, 688, 295, 10, 70, "Input",
 CellID->11917],
Cell[21412, 700, 314, 12, 51, "Output",
 CellID->205229140]
}, Open  ]],
Cell[21741, 715, 125, 3, 70, "ExampleDelimiter",
 CellID->359275129],
Cell[21869, 720, 76, 1, 70, "ExampleText",
 CellID->188291280],
Cell[CellGroupData[{
Cell[21970, 725, 243, 8, 70, "Input",
 CellID->24927221],
Cell[22216, 735, 180, 5, 36, "Output",
 CellID->62479024]
}, Open  ]],
Cell[22411, 743, 125, 3, 70, "ExampleDelimiter",
 CellID->650909219],
Cell[22539, 748, 88, 1, 70, "ExampleText",
 CellID->285474028],
Cell[CellGroupData[{
Cell[22652, 753, 191, 6, 70, "Input",
 CellID->315224713],
Cell[22846, 761, 177, 5, 36, "Output",
 CellID->110364229]
}, Open  ]],
Cell[CellGroupData[{
Cell[23060, 771, 245, 8, 70, "Input",
 CellID->594479966],
Cell[23308, 781, 491, 12, 54, "Output",
 CellID->36588108]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[23848, 799, 239, 7, 70, "ExampleSection",
 CellID->28609],
Cell[24090, 808, 211, 8, 70, "ExampleText",
 CellID->625271644],
Cell[CellGroupData[{
Cell[24326, 820, 570, 19, 70, "Input",
 CellID->19878761],
Cell[24899, 841, 484, 17, 36, "Output",
 CellID->373694810]
}, Open  ]],
Cell[CellGroupData[{
Cell[25420, 863, 105, 3, 70, "Input",
 CellID->235263230],
Cell[25528, 868, 541, 17, 51, "Output",
 CellID->182029555]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[26118, 891, 233, 7, 70, "ExampleSection",
 CellID->17310],
Cell[26354, 900, 348, 13, 70, "ExampleText",
 CellID->180528295],
Cell[CellGroupData[{
Cell[26727, 917, 167, 5, 70, "Input",
 CellID->11119],
Cell[26897, 924, 178, 6, 51, "Output",
 CellID->123914350]
}, Open  ]],
Cell[CellGroupData[{
Cell[27112, 935, 176, 5, 70, "Input",
 CellID->12868],
Cell[27291, 942, 190, 7, 60, "Output",
 CellID->116342001]
}, Open  ]],
Cell[27496, 952, 125, 3, 70, "ExampleDelimiter",
 CellID->353623198],
Cell[27624, 957, 453, 17, 70, "ExampleText",
 CellID->7602946],
Cell[CellGroupData[{
Cell[28102, 978, 158, 5, 70, "Input",
 CellID->691934725],
Cell[28263, 985, 764, 16, 71, "Output",
 CellID->90393666]
}, Open  ]],
Cell[CellGroupData[{
Cell[29064, 1006, 107, 3, 70, "Input",
 CellID->214941188],
Cell[29174, 1011, 174, 5, 36, "Output",
 CellID->145372700]
}, Open  ]],
Cell[CellGroupData[{
Cell[29385, 1021, 297, 10, 70, "Input",
 CellID->650778682],
Cell[29685, 1033, 174, 5, 36, "Output",
 CellID->44707512]
}, Open  ]],
Cell[29874, 1041, 125, 3, 70, "ExampleDelimiter",
 CellID->137012746],
Cell[30002, 1046, 324, 12, 70, "ExampleText",
 CellID->22673528],
Cell[CellGroupData[{
Cell[30351, 1062, 157, 5, 70, "Input",
 CellID->86545193],
Cell[30511, 1069, 773, 17, 71, "Output",
 CellID->203171170]
}, Open  ]],
Cell[CellGroupData[{
Cell[31321, 1091, 107, 3, 70, "Input",
 CellID->309913758],
Cell[31431, 1096, 176, 5, 36, "Output",
 CellID->278463864]
}, Open  ]],
Cell[CellGroupData[{
Cell[31644, 1106, 307, 10, 70, "Input",
 CellID->154126311],
Cell[31954, 1118, 176, 5, 36, "Output",
 CellID->196909558]
}, Open  ]],
Cell[32145, 1126, 124, 3, 70, "ExampleDelimiter",
 CellID->97257252],
Cell[32272, 1131, 368, 13, 70, "ExampleText",
 CellID->22987128],
Cell[CellGroupData[{
Cell[32665, 1148, 158, 5, 70, "Input",
 CellID->451046271],
Cell[32826, 1155, 478, 12, 54, "Output",
 CellID->456745029]
}, Open  ]],
Cell[CellGroupData[{
Cell[33341, 1172, 379, 13, 70, "Input",
 CellID->162394754],
Cell[33723, 1187, 176, 5, 36, "Output",
 CellID->269688458]
}, Open  ]],
Cell[CellGroupData[{
Cell[33936, 1197, 134, 4, 70, "Input",
 CellID->251299893],
Cell[34073, 1203, 175, 5, 36, "Output",
 CellID->75569549]
}, Open  ]],
Cell[34263, 1211, 125, 3, 70, "ExampleDelimiter",
 CellID->396400762],
Cell[34391, 1216, 454, 17, 70, "ExampleText",
 CellID->19399639],
Cell[34848, 1235, 176, 6, 70, "Input",
 CellID->89934925],
Cell[CellGroupData[{
Cell[35049, 1245, 107, 3, 70, "Input",
 CellID->443930393],
Cell[35159, 1250, 174, 5, 36, "Output",
 CellID->26994932]
}, Open  ]],
Cell[CellGroupData[{
Cell[35370, 1260, 387, 13, 70, "Input",
 CellID->134444918],
Cell[35760, 1275, 174, 5, 36, "Output",
 CellID->32697588]
}, Open  ]],
Cell[35949, 1283, 124, 3, 70, "ExampleDelimiter",
 CellID->70099947],
Cell[36076, 1288, 473, 17, 70, "ExampleText",
 CellID->394865487],
Cell[CellGroupData[{
Cell[36574, 1309, 158, 5, 70, "Input",
 CellID->148442668],
Cell[36735, 1316, 769, 16, 71, "Output",
 CellID->254916920]
}, Open  ]],
Cell[CellGroupData[{
Cell[37541, 1337, 129, 4, 70, "Input",
 CellID->618390570],
Cell[37673, 1343, 173, 5, 36, "Output",
 CellID->5990024]
}, Open  ]],
Cell[CellGroupData[{
Cell[37883, 1353, 128, 4, 70, "Input",
 CellID->5648062],
Cell[38014, 1359, 159, 5, 36, "Output",
 CellID->111916264]
}, Open  ]],
Cell[CellGroupData[{
Cell[38210, 1369, 311, 10, 70, "Input",
 CellID->263731272],
Cell[38524, 1381, 175, 5, 36, "Output",
 CellID->879169100]
}, Open  ]],
Cell[CellGroupData[{
Cell[38736, 1391, 106, 3, 70, "Input",
 CellID->35249381],
Cell[38845, 1396, 175, 5, 36, "Output",
 CellID->894273159]
}, Open  ]],
Cell[39035, 1404, 125, 3, 70, "ExampleDelimiter",
 CellID->211774243],
Cell[39163, 1409, 369, 12, 70, "ExampleText",
 CellID->250203883],
Cell[CellGroupData[{
Cell[39557, 1425, 157, 5, 70, "Input",
 CellID->390325569],
Cell[39717, 1432, 484, 12, 54, "Output",
 CellID->97227503]
}, Open  ]],
Cell[CellGroupData[{
Cell[40238, 1449, 112, 3, 70, "Input",
 CellID->287940559],
Cell[40353, 1454, 176, 5, 36, "Output",
 CellID->122761081]
}, Open  ]],
Cell[CellGroupData[{
Cell[40566, 1464, 107, 3, 70, "Input",
 CellID->421485872],
Cell[40676, 1469, 175, 5, 36, "Output",
 CellID->1032270]
}, Open  ]],
Cell[40866, 1477, 125, 3, 70, "ExampleDelimiter",
 CellID->156147355],
Cell[40994, 1482, 375, 12, 70, "ExampleText",
 CellID->486490344],
Cell[CellGroupData[{
Cell[41394, 1498, 392, 14, 70, "Input",
 CellID->471760332],
Cell[41789, 1514, 477, 12, 54, "Output",
 CellID->770071228]
}, Open  ]],
Cell[CellGroupData[{
Cell[42303, 1531, 112, 3, 70, "Input",
 CellID->106654448],
Cell[42418, 1536, 176, 5, 36, "Output",
 CellID->492248326]
}, Open  ]],
Cell[CellGroupData[{
Cell[42631, 1546, 107, 3, 70, "Input",
 CellID->309580972],
Cell[42741, 1551, 173, 5, 36, "Output",
 CellID->26799490]
}, Open  ]],
Cell[42929, 1559, 125, 3, 70, "ExampleDelimiter",
 CellID->797726614],
Cell[43057, 1564, 340, 12, 70, "ExampleText",
 CellID->572927312],
Cell[43400, 1578, 196, 6, 70, "Input",
 CellID->173202917],
Cell[CellGroupData[{
Cell[43621, 1588, 262, 9, 70, "Input",
 CellID->140877037],
Cell[43886, 1599, 216, 7, 36, "Output",
 CellID->82060103]
}, Open  ]],
Cell[CellGroupData[{
Cell[44139, 1611, 107, 3, 70, "Input",
 CellID->259210552],
Cell[44249, 1616, 217, 7, 36, "Output",
 CellID->274259420]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[44527, 1630, 311, 9, 70, "SeeAlsoSection",
 CellID->25032],
Cell[44841, 1641, 2474, 89, 70, "SeeAlso",
 CellID->7802]
}, Open  ]],
Cell[CellGroupData[{
Cell[47352, 1735, 314, 9, 70, "TutorialsSection",
 CellID->31778],
Cell[47669, 1746, 142, 3, 70, "Tutorials",
 CellID->30845],
Cell[47814, 1751, 156, 3, 70, "Tutorials",
 CellID->4063544],
Cell[47973, 1756, 153, 3, 70, "Tutorials",
 CellID->4738],
Cell[48129, 1761, 157, 3, 70, "Tutorials",
 CellID->7471]
}, Open  ]],
Cell[CellGroupData[{
Cell[48323, 1769, 319, 9, 70, "MoreAboutSection",
 CellID->527546416],
Cell[48645, 1780, 154, 3, 70, "MoreAbout",
 CellID->59722704],
Cell[48802, 1785, 190, 4, 70, "MoreAbout",
 CellID->239081509],
Cell[48995, 1791, 139, 3, 70, "MoreAbout",
 CellID->379642328],
Cell[49137, 1796, 151, 3, 70, "MoreAbout",
 CellID->336758028],
Cell[49291, 1801, 161, 3, 70, "MoreAbout",
 CellID->147041923],
Cell[49455, 1806, 131, 3, 70, "MoreAbout",
 CellID->58513070],
Cell[49589, 1811, 179, 3, 70, "MoreAbout",
 CellID->126881086],
Cell[49771, 1816, 151, 3, 70, "MoreAbout",
 CellID->246370521]
}, Open  ]],
Cell[49937, 1822, 50, 0, 70, "History"],
Cell[49990, 1824, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

