(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    326539,       5887]
NotebookOptionsPosition[    321178,       5709]
NotebookOutlinePosition[    322465,       5746]
CellTagsIndexPosition[    322378,       5741]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"VertexNormals" :> 
          Documentation`HelpLookup["paclet:ref/VertexNormals"], "Style" :> 
          Documentation`HelpLookup["paclet:ref/Style"], "RGBColor" :> 
          Documentation`HelpLookup["paclet:ref/RGBColor"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"VertexNormals\"\>", 
       2->"\<\"Style\"\>", 3->"\<\"RGBColor\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"3D Graphics Options" :> 
          Documentation`HelpLookup["paclet:guide/3DGraphicsOptions"], 
          "Colors" :> Documentation`HelpLookup["paclet:guide/Colors"], 
          "Polygons" :> Documentation`HelpLookup["paclet:guide/Polygons"], 
          "New in 6.0: Graphics & Visualization Options" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60GraphicsAndVisualizationOptions"], 
          "New in 6.0: Graphics Primitives & Directives" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60GraphicsPrimitivesAndDirectives"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"3D Graphics Options\"\>", 
       2->"\<\"Colors\"\>", 3->"\<\"Polygons\"\>", 
       4->"\<\"New in 6.0: Graphics & Visualization Options\"\>", 
       5->"\<\"New in 6.0: Graphics Primitives & Directives\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["VertexColors", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["VertexColors",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/VertexColors"]], "InlineFormula"],
     " \[LineSeparator]is an option for ",
     Cell[BoxData[
      ButtonBox["Polygon",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Polygon"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      ButtonBox["GraphicsComplex",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/GraphicsComplex"]], "InlineFormula"],
     " which specifies the colors to assign to vertices of 2D and 3D \
polygons."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->7918]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"VertexColors", "->", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox[
      StyleBox["col", "TI"], 
      StyleBox["1", "TR"]], ",", 
     SubscriptBox[
      StyleBox["col", "TI"], 
      StyleBox["2", "TR"]], ",", 
     StyleBox["\[Ellipsis]", "TR"]}], "}"}]}]], "InlineFormula"],
 " specifies that color ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["col", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " should be assigned to vertex ",
 Cell[BoxData[
  StyleBox["i", "TI"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->12060],

Cell[TextData[{
 "The interior of the polygon is colored by interpolating between the colors \
specified by ",
 Cell[BoxData[
  ButtonBox["VertexColors",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/VertexColors"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->2797],

Cell[TextData[{
 "In 3D, settings for ",
 Cell[BoxData[
  ButtonBox["VertexColors",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/VertexColors"]], "InlineFormula"],
 " can include any surface or material property, to be used with simulated \
lighting."
}], "Notes",
 CellID->2268],

Cell[TextData[{
 "The colors ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["col", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " for each vertex can be an explicit color directive such as ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["GrayLevel",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/GrayLevel"], "[", 
   StyleBox["g", "TI"], "]"}]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["RGBColor",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RGBColor"], "[", 
   RowBox[{
    StyleBox["r", "TI"], ",", 
    StyleBox["g", "TI"], ",", 
    StyleBox["b", "TI"]}], "]"}]], "InlineFormula"],
 ", or can have the following forms:"
}], "Notes",
 CellID->30624],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    StyleBox["g", "TI"], Cell[TextData[Cell[BoxData[
     RowBox[{
      ButtonBox["GrayLevel",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/GrayLevel"], "[", 
      StyleBox["g", "TI"], "]"}]], "InlineFormula"]], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{
      StyleBox["g", "TI"], ",", 
      StyleBox["a", "TI"]}], "}"}], Cell[TextData[Cell[BoxData[
     RowBox[{
      ButtonBox["GrayLevel",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/GrayLevel"], "[", 
      StyleBox[
       RowBox[{"g", ",", "a"}], "TI"], 
      StyleBox["]", "TI"]}]], "InlineFormula"]], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{
      StyleBox["r", "TI"], ",", 
      StyleBox["g", "TI"], ",", 
      StyleBox["b", "TI"]}], "}"}], Cell[TextData[Cell[BoxData[
     RowBox[{
      ButtonBox["RGBColor",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/RGBColor"], "[", 
      RowBox[{
       StyleBox["r", "TI"], ",", 
       StyleBox["g", "TI"], ",", 
       StyleBox["b", "TI"]}], "]"}]], "InlineFormula"]], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{
      StyleBox["r", "TI"], ",", 
      StyleBox["g", "TI"], ",", 
      StyleBox["b", "TI"], ",", 
      StyleBox["a", "TI"]}], "}"}], Cell[TextData[Cell[BoxData[
     RowBox[{
      ButtonBox["RGBColor",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/RGBColor"], "[", 
      RowBox[{
       StyleBox["r", "TI"], ",", 
       StyleBox["g", "TI"], ",", 
       StyleBox["b", "TI"], ",", 
       StyleBox["a", "TI"]}], "]"}]], "InlineFormula"]], "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True}}}},
 CellID->23438]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->255483953],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(4)", "ExampleCount"]
}], "ExampleSection",
 CellID->115738023],

Cell["Specify vertex colors for 2D polygons:", "ExampleText",
 CellID->4515505],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"Polygon", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1"}], ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", 
        RowBox[{"Sqrt", "[", "3", "]"}]}], "}"}]}], "}"}], ",", 
    RowBox[{"VertexColors", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"Red", ",", "Green", ",", "Blue"}], "}"}]}]}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->102104999],

Cell[BoxData[
 GraphicsBox[
  PolygonBox[
   NCache[{{-1, 0}, {1, 0}, {0, 3^Rational[1, 2]}}, {{-1, 0}, {1, 0}, {
     0, 1.7320508075688772`}}],
   VertexColors->{
     RGBColor[1, 0, 0], 
     RGBColor[0, 1, 0], 
     RGBColor[0, 0, 1]}]]], "Output",
 ImageSize->{154, 131},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->283293075,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1021723544],

Cell["Specify vertex colors for 3D polygons:", "ExampleText",
 CellID->222606742],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{"Polygon", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", 
        RowBox[{"-", "1"}], ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "1", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1"}], ",", "0", ",", "1"}], "}"}]}], "}"}], ",", 
    RowBox[{"VertexColors", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"Red", ",", "Green", ",", "Blue"}], "}"}]}]}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->718803155],

Cell[BoxData[
 Graphics3DBox[Polygon3DBox[{{0, -1, 0}, {0, 1, 0}, {-1, 0, 1}},
   VertexColors->{
     RGBColor[1, 0, 0], 
     RGBColor[0, 1, 0], 
     RGBColor[0, 0, 1]}]]], "Output",
 ImageSize->{154, 167},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->44015166,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->168526974],

Cell["Opacity can be specified for each vertex, as well:", "ExampleText",
 CellID->80001071],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{"Polygon", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", 
        RowBox[{"-", "1"}], ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "1", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1"}], ",", "0", ",", "1"}], "}"}]}], "}"}], ",", 
    RowBox[{"VertexColors", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"Red", ",", "Green", ",", 
       RowBox[{"Directive", "[", 
        RowBox[{"Blue", ",", 
         RowBox[{"Opacity", "[", ".5", "]"}]}], "]"}]}], "}"}]}]}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->18787816],

Cell[BoxData[
 Graphics3DBox[Polygon3DBox[{{0, -1, 0}, {0, 1, 0}, {-1, 0, 1}},
   VertexColors->{
     RGBColor[1, 0, 0], 
     RGBColor[0, 1, 0], 
     Directive[
      RGBColor[0, 0, 1], 
      Opacity[0.5]]}]]], "Output",
 ImageSize->{154, 167},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->189309091,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->224642460],

Cell["Assign colors for shared vertices:", "ExampleText",
 CellID->236432817],

Cell[BoxData[
 RowBox[{
  RowBox[{"v", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "2", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "2", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1", ",", "2"}], "}"}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->23974798],

Cell[BoxData[
 RowBox[{
  RowBox[{"i", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "3", ",", "5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "4", ",", "5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "1", ",", "5"}], "}"}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->11945553],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{"{", 
   RowBox[{"GraphicsComplex", "[", 
    RowBox[{"v", ",", 
     RowBox[{"Polygon", "[", "i", "]"}], ",", 
     RowBox[{"VertexColors", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"Red", ",", "Green", ",", "Yellow", ",", "Blue", ",", 
        RowBox[{"Opacity", "[", 
         RowBox[{".8", ",", "White"}], "]"}]}], "}"}]}]}], "]"}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->255357399],

Cell[BoxData[
 Graphics3DBox[
  GraphicsComplex3DBox[{{0, 0, 0}, {2, 0, 0}, {2, 2, 0}, {0, 2, 0}, {1, 1, 
   2}}, Polygon3DBox[{{1, 2, 5}, {2, 3, 5}, {3, 4, 5}, {4, 1, 5}}],
   VertexColors->{
     RGBColor[1, 0, 0], 
     RGBColor[0, 1, 0], 
     RGBColor[1, 1, 0], 
     RGBColor[0, 0, 1], 
     Opacity[0.8, 
      GrayLevel[1]]}]]], "Output",
 ImageSize->{184, 195},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->67197058,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->9431],

Cell[TextData[{
 "Some plot functions, such as ",
 Cell[BoxData[
  ButtonBox["ListPlot3D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ListPlot3D"]], "InlineFormula"],
 ", support ",
 Cell[BoxData[
  ButtonBox["VertexColors",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/VertexColors"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->318227809],

Cell[BoxData[
 RowBox[{
  RowBox[{"data", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Sin", "[", 
      RowBox[{"x", " ", "y"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "3", ",", ".06"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", "0", ",", "3", ",", ".06"}], "}"}]}], "]"}]}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->364566213],

Cell[BoxData[
 RowBox[{
  RowBox[{"vc", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"RGBColor", "[", 
      RowBox[{
       RowBox[{"x", "/", "3"}], ",", 
       RowBox[{"y", "/", "3"}], ",", ".3"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "3", ",", ".06"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", "0", ",", "3", ",", ".06"}], "}"}]}], "]"}]}], 
  ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->194427560],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot3D", "[", 
  RowBox[{"data", ",", 
   RowBox[{"Mesh", "\[Rule]", "None"}], ",", 
   RowBox[{"VertexColors", "\[Rule]", 
    RowBox[{"{", "vc", "}"}]}], ",", 
   RowBox[{"Lighting", "\[Rule]", "\"\<Neutral\>\""}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->641305084],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 141},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->60510855]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->26038],

Cell["Create opacity gradients on 3D polygons:", "ExampleText",
 CellID->603700488],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"PolyhedronData", "[", "\"\<GreatRhombicosidodecahedron\>\"", "]"}],
   "/.", 
  RowBox[{
   RowBox[{"Polygon", "[", "x_", "]"}], ":>", 
   RowBox[{"Polygon", "[", 
    RowBox[{"x", ",", 
     RowBox[{"VertexColors", "->", 
      RowBox[{"Map", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Opacity", "[", 
          RowBox[{
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{"EvenQ", "[", "#", "]"}], ",", "0", ",", "1"}], "]"}], 
           ",", "White"}], "]"}], "&"}], ",", "x", ",", 
        RowBox[{"{", 
         RowBox[{"-", "1"}], "}"}]}], "]"}]}]}], "]"}]}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->120042929],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{244, 265},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->58325211]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->37733174],

Cell[TextData[{
 "Use an image from ",
 Cell[BoxData[
  ButtonBox["ExampleData",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ExampleData"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->178717042],

Cell[BoxData[
 RowBox[{
  RowBox[{"pic", "=", 
   RowBox[{"Reverse", "[", 
    RowBox[{
     RowBox[{"ExampleData", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"\"\<TestImage\>\"", ",", "\"\<Lena\>\""}], "}"}], ",", 
       "\"\<Data\>\""}], "]"}], "/", "255."}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->399614848],

Cell["Plot the dataset with vertex colors, simulating the texture:", \
"ExampleText",
 CellID->438457957],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot3D", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"x", "+", " ", 
      RowBox[{"Sin", "[", 
       RowBox[{"x", " ", "y"}], "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "5"}], ",", "5", ",", ".1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", 
       RowBox[{"-", "5"}], ",", "5", ",", ".1"}], "}"}]}], "]"}], ",", 
   RowBox[{"Mesh", "\[Rule]", "None"}], ",", 
   RowBox[{"VertexColors", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"pic", "[", 
      RowBox[{"[", 
       RowBox[{
        RowBox[{"5", ";;", 
         RowBox[{"-", "5"}], ";;", "5"}], ",", 
        RowBox[{"5", ";;", 
         RowBox[{"-", "5"}], ";;", "5"}]}], "]"}], "]"}], "}"}]}], ",", 
   RowBox[{"Lighting", "\[Rule]", "\"\<Neutral\>\""}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->829685482],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{300, 239},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{300, Automatic}},
 CellLabel->"Out[2]=",
 CellID->631608212]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->22683],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["VertexNormals",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/VertexNormals"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Style",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Style"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["RGBColor",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RGBColor"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->6773]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->214008953],

Cell[TextData[ButtonBox["3D Graphics Options",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/3DGraphicsOptions"]], "MoreAbout",
 CellID->485522111],

Cell[TextData[ButtonBox["Colors",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Colors"]], "MoreAbout",
 CellID->141005210],

Cell[TextData[ButtonBox["Polygons",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Polygons"]], "MoreAbout",
 CellID->771576508],

Cell[TextData[ButtonBox["New in 6.0: Graphics & Visualization Options",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/NewIn60GraphicsAndVisualizationOptions"]], "MoreAbout",
 CellID->64595445],

Cell[TextData[ButtonBox["New in 6.0: Graphics Primitives & Directives",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/NewIn60GraphicsPrimitivesAndDirectives"]], "MoreAbout",
 CellID->104399977]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"VertexColors - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 29, 2.9141720}", "context" -> "System`", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "VertexColors is an option for Polygon and GraphicsComplex which \
specifies the colors to assign to vertices of 2D and 3D polygons.", 
    "synonyms" -> {"vertex colors"}, "title" -> "VertexColors", "type" -> 
    "Symbol", "uri" -> "ref/VertexColors"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[9368, 290, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->255483953]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 322235, 5734}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2013, 44, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2636, 71, 1577, 37, 70, "ObjectNameGrid"],
Cell[4216, 110, 787, 24, 70, "Usage",
 CellID->7918]
}, Open  ]],
Cell[CellGroupData[{
Cell[5040, 139, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5518, 156, 580, 22, 70, "Notes",
 CellID->12060],
Cell[6101, 180, 271, 9, 70, "Notes",
 CellID->2797],
Cell[6375, 191, 283, 9, 70, "Notes",
 CellID->2268],
Cell[6661, 202, 693, 25, 70, "Notes",
 CellID->30624],
Cell[7357, 229, 1974, 56, 70, "2ColumnTableMod",
 CellID->23438]
}, Closed]],
Cell[CellGroupData[{
Cell[9368, 290, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->255483953],
Cell[CellGroupData[{
Cell[9753, 304, 148, 5, 70, "ExampleSection",
 CellID->115738023],
Cell[9904, 311, 79, 1, 70, "ExampleText",
 CellID->4515505],
Cell[CellGroupData[{
Cell[10008, 316, 566, 19, 28, "Input",
 CellID->102104999],
Cell[10577, 337, 35622, 592, 152, 252, 8, "CachedBoxData", "BoxData", \
"Output",
 CellID->283293075]
}, Open  ]],
Cell[46214, 932, 126, 3, 70, "ExampleDelimiter",
 CellID->1021723544],
Cell[46343, 937, 81, 1, 70, "ExampleText",
 CellID->222606742],
Cell[CellGroupData[{
Cell[46449, 942, 585, 19, 70, "Input",
 CellID->718803155],
Cell[47037, 963, 24019, 400, 188, 185, 5, "CachedBoxData", "BoxData", \
"Output",
 CellID->44015166]
}, Open  ]],
Cell[71071, 1366, 125, 3, 70, "ExampleDelimiter",
 CellID->168526974],
Cell[71199, 1371, 92, 1, 70, "ExampleText",
 CellID->80001071],
Cell[CellGroupData[{
Cell[71316, 1376, 696, 22, 70, "Input",
 CellID->18787816],
Cell[72015, 1400, 24206, 405, 188, 224, 7, "CachedBoxData", "BoxData", \
"Output",
 CellID->189309091]
}, Open  ]],
Cell[96236, 1808, 125, 3, 70, "ExampleDelimiter",
 CellID->224642460],
Cell[96364, 1813, 77, 1, 70, "ExampleText",
 CellID->236432817],
Cell[96444, 1816, 503, 16, 70, "Input",
 CellID->23974798],
Cell[96950, 1834, 430, 14, 70, "Input",
 CellID->11945553],
Cell[CellGroupData[{
Cell[97405, 1852, 464, 13, 70, "Input",
 CellID->255357399],
Cell[97872, 1867, 44915, 745, 216, 346, 10, "CachedBoxData", "BoxData", \
"Output",
 CellID->67197058]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[142836, 2618, 215, 7, 70, "ExampleSection",
 CellID->9431],
Cell[143054, 2627, 358, 13, 70, "ExampleText",
 CellID->318227809],
Cell[143415, 2642, 394, 13, 70, "Input",
 CellID->364566213],
Cell[143812, 2657, 464, 15, 70, "Input",
 CellID->194427560],
Cell[CellGroupData[{
Cell[144301, 2676, 306, 8, 70, "Input",
 CellID->641305084],
Cell[144610, 2686, 31301, 517, 70, "Output",
 Evaluatable->False,
 CellID->60510855]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[175960, 3209, 224, 7, 70, "ExampleSection",
 CellID->26038],
Cell[176187, 3218, 83, 1, 70, "ExampleText",
 CellID->603700488],
Cell[CellGroupData[{
Cell[176295, 3223, 691, 21, 70, "Input",
 CellID->120042929],
Cell[176989, 3246, 27641, 457, 70, "Output",
 Evaluatable->False,
 CellID->58325211]
}, Open  ]],
Cell[204645, 3706, 124, 3, 70, "ExampleDelimiter",
 CellID->37733174],
Cell[204772, 3711, 207, 8, 70, "ExampleText",
 CellID->178717042],
Cell[204982, 3721, 346, 11, 70, "Input",
 CellID->399614848],
Cell[205331, 3734, 105, 2, 70, "ExampleText",
 CellID->438457957],
Cell[CellGroupData[{
Cell[205461, 3740, 877, 26, 70, "Input",
 CellID->829685482],
Cell[206341, 3768, 112527, 1849, 70, "Output",
 Evaluatable->False,
 CellID->631608212]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[318929, 5624, 311, 9, 70, "SeeAlsoSection",
 CellID->22683],
Cell[319243, 5635, 699, 26, 70, "SeeAlso",
 CellID->6773]
}, Open  ]],
Cell[CellGroupData[{
Cell[319979, 5666, 319, 9, 70, "MoreAboutSection",
 CellID->214008953],
Cell[320301, 5677, 148, 3, 70, "MoreAbout",
 CellID->485522111],
Cell[320452, 5682, 124, 3, 70, "MoreAbout",
 CellID->141005210],
Cell[320579, 5687, 128, 3, 70, "MoreAbout",
 CellID->771576508],
Cell[320710, 5692, 196, 4, 70, "MoreAbout",
 CellID->64595445],
Cell[320909, 5698, 197, 4, 70, "MoreAbout",
 CellID->104399977]
}, Open  ]],
Cell[321121, 5705, 27, 0, 70, "History"],
Cell[321151, 5707, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

