(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     35719,       1133]
NotebookOptionsPosition[     31089,        982]
NotebookOutlinePosition[     32516,       1021]
CellTagsIndexPosition[     32430,       1016]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"General Graph Drawing" :> 
          Documentation`HelpLookup["paclet:tutorial/GraphDrawing"], 
          "Hierarchical Drawing of Directed Graphs" :> 
          Documentation`HelpLookup["paclet:tutorial/LayeredGraphDrawing"], 
          "Tree Drawing" :> 
          Documentation`HelpLookup["paclet:tutorial/TreeDrawing"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"General Graph Drawing\"\>", 
       2->"\<\"Hierarchical Drawing of Directed Graphs\"\>", 
       3->"\<\"Tree Drawing\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"VertexRenderingFunction" :> 
          Documentation`HelpLookup["paclet:ref/VertexRenderingFunction"], 
          "DataRange" :> Documentation`HelpLookup["paclet:ref/DataRange"], 
          "LayeredGraphPlot" :> 
          Documentation`HelpLookup["paclet:ref/LayeredGraphPlot"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"VertexRenderingFunction\"\>", 
       2->"\<\"DataRange\"\>", 
       3->"\<\"LayeredGraphPlot\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["VertexCoordinateRules", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["VertexCoordinateRules",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/VertexCoordinateRules"]], "InlineFormula"],
     " \[LineSeparator]is an option for ",
     Cell[BoxData[
      ButtonBox["GraphPlot",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/GraphPlot"]], "InlineFormula"],
     " and related functions which specifies rules for determining the \
coordinates at which vertices should placed."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"VertexCoordinateRules", "->", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SubscriptBox[
       StyleBox["v", "TI"], 
       StyleBox["a", "TI"]], "->", 
      SubscriptBox[
       StyleBox["r", "TI"], 
       StyleBox["a", "TI"]]}], ",", 
     RowBox[{
      SubscriptBox[
       StyleBox["v", "TI"], 
       StyleBox["b", "TI"]], "->", 
      SubscriptBox[
       StyleBox["r", "TI"], 
       StyleBox["b", "TI"]]}], ",", 
     StyleBox["\[Ellipsis]", "TR"]}], "}"}]}]], "InlineFormula"],
 " specifies explicit coordinates for vertices with names ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["v", "TI"], 
   StyleBox["a", "TI"]]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["v", "TI"], 
   StyleBox["b", "TI"]]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  StyleBox["\[Ellipsis]", "TR"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->1067943069],

Cell[TextData[{
 "Vertices whose coordinates are not explicitly specified in the rules given \
by ",
 Cell[BoxData[
  ButtonBox["VertexCoordinateRules",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/VertexCoordinateRules"]], "InlineFormula"],
 " are automatically assigned coordinates by the graph layout procedure."
}], "Notes",
 CellID->414851900],

Cell[TextData[{
 "A setting ",
 Cell[BoxData[
  RowBox[{
   SubscriptBox[
    StyleBox["v", "TI"], 
    StyleBox["k", "TI"]], "->", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 " specifies that the vertex with name ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["v", "TI"], 
   StyleBox["k", "TI"]]], "InlineFormula"],
 " should be assigned coordinates automatically."
}], "Notes",
 CellID->26077013],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   SubscriptBox[
    StyleBox["v", "TI"], 
    StyleBox["k", "TI"]], "->", 
   RowBox[{"{", 
    RowBox[{
     StyleBox["x", "TI"], ",", 
     ButtonBox["Automatic",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Automatic"]}], "}"}]}]], "InlineFormula"],
 " defines an explicit ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " coordinate, but specifies that the ",
 Cell[BoxData[
  StyleBox["y", "TI"]], "InlineFormula"],
 " coordinate should be assigned automatically.",
 " ",
 Cell[BoxData[
  RowBox[{
   SubscriptBox[
    StyleBox["v", "TI"], 
    StyleBox["k", "TI"]], "->", 
   RowBox[{"{", 
    RowBox[{
     ButtonBox["Automatic",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Automatic"], ",", 
     StyleBox["y", "TI"]}], "}"}]}]], "InlineFormula"],
 " defines instead an explicit ",
 Cell[BoxData[
  StyleBox["y", "TI"]], "InlineFormula"],
 " coordinate. "
}], "Notes",
 CellID->267849229],

Cell[TextData[{
 "The rules given for ",
 Cell[BoxData[
  ButtonBox["VertexCoordinateRules",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/VertexCoordinateRules"]], "InlineFormula"],
 " can contain arbitrary patterns."
}], "Notes",
 CellID->104201225],

Cell[TextData[{
 "The range of coordinates generated automatically is determined by the \
setting for the ",
 Cell[BoxData[
  ButtonBox["DataRange",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DataRange"]], "InlineFormula"],
 " option."
}], "Notes",
 CellID->172541295]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->176218835],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(4)", "ExampleCount"]
}], "ExampleSection",
 CellID->625629395],

Cell["Specify coordinates for all vertices:", "ExampleText",
 CellID->1548390837],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "\[Rule]", "4"}], ",", 
     RowBox[{"1", "\[Rule]", "5"}], ",", 
     RowBox[{"2", "\[Rule]", "4"}], ",", 
     RowBox[{"2", "\[Rule]", "5"}], ",", 
     RowBox[{"3", "\[Rule]", "4"}], ",", 
     RowBox[{"3", "\[Rule]", "5"}]}], "}"}], ",", 
   RowBox[{"VertexLabeling", "\[Rule]", "True"}], ",", 
   RowBox[{"VertexCoordinateRules", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"1", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"1", ",", "0"}], "}"}]}], ",", 
      RowBox[{"2", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "1"}], ",", "0"}], "}"}]}], ",", 
      RowBox[{"3", "->", 
       RowBox[{"{", 
        RowBox[{"0", ",", "1"}], "}"}]}], ",", 
      RowBox[{"4", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"0", ",", "2"}], "}"}]}], ",", 
      RowBox[{"5", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}]}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1110289063],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{1., 0.}, {0., 2.}, {0., 0.}, {-1., 0.}, {0., 
    1.}}, {
     {RGBColor[0.5, 0., 0.], 
      LineBox[{{1, 2}, {1, 3}, {4, 2}, {4, 3}, {5, 2}, {5, 3}}]}, {InsetBox[
       FrameBox["1",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 1], InsetBox[
       FrameBox["4",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 2], InsetBox[
       FrameBox["5",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 3], InsetBox[
       FrameBox["2",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 4], InsetBox[
       FrameBox["3",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 5]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{1., 0.}, {0., 2.}, {0., 0.}, {-1., 0.}, {0., 
     1.}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{184, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->632552954]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->55441458],

Cell["\<\
Specify coordinates for all vertices using just the coordinates:\
\>", "ExampleText",
 CellID->1490726115],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "\[Rule]", "4"}], ",", 
     RowBox[{"1", "\[Rule]", "5"}], ",", 
     RowBox[{"2", "\[Rule]", "4"}], ",", 
     RowBox[{"2", "\[Rule]", "5"}], ",", 
     RowBox[{"3", "\[Rule]", "4"}], ",", 
     RowBox[{"3", "\[Rule]", "5"}]}], "}"}], ",", 
   RowBox[{"VertexLabeling", "\[Rule]", "True"}], ",", 
   RowBox[{"VertexCoordinateRules", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "2"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1"}], ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1242710117],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{1., 0.}, {0., 2.}, {0., 0.}, {-1., 0.}, {0., 
    1.}}, {
     {RGBColor[0.5, 0., 0.], 
      LineBox[{{1, 2}, {1, 3}, {4, 2}, {4, 3}, {5, 2}, {5, 3}}]}, {InsetBox[
       FrameBox["1",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 1], InsetBox[
       FrameBox["4",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 2], InsetBox[
       FrameBox["5",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 3], InsetBox[
       FrameBox["2",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 4], InsetBox[
       FrameBox["3",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 5]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{1., 0.}, {0., 2.}, {0., 0.}, {-1., 0.}, {0., 
     1.}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{184, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->572991534]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->257533641],

Cell["Specify coordinates for some vertices:", "ExampleText",
 CellID->1878917218],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "\[Rule]", "4"}], ",", 
     RowBox[{"1", "\[Rule]", "5"}], ",", 
     RowBox[{"2", "\[Rule]", "4"}], ",", 
     RowBox[{"2", "\[Rule]", "5"}], ",", 
     RowBox[{"3", "\[Rule]", "4"}], ",", 
     RowBox[{"3", "\[Rule]", "5"}]}], "}"}], ",", 
   RowBox[{"VertexLabeling", "\[Rule]", "True"}], ",", 
   RowBox[{"VertexCoordinateRules", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"1", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"1", ",", "0"}], "}"}]}], ",", 
      RowBox[{"3", "->", 
       RowBox[{"{", 
        RowBox[{"0", ",", "1"}], "}"}]}], ",", 
      RowBox[{"4", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"0", ",", "2"}], "}"}]}], ",", 
      RowBox[{"5", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}]}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->624559890],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{1., 0.}, {0., 2.}, {0., 
    0.}, {-0.44732396166188343`, 1.0321631485139013`}, {0., 1.}}, {
     {RGBColor[0.5, 0., 0.], 
      LineBox[{{1, 2}, {1, 3}, {4, 2}, {4, 3}, {5, 2}, {5, 3}}]}, {InsetBox[
       FrameBox["1",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 1], InsetBox[
       FrameBox["4",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 2], InsetBox[
       FrameBox["5",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 3], InsetBox[
       FrameBox["2",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 4], InsetBox[
       FrameBox["3",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 5]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{1., 0.}, {0., 2.}, {0., 
     0.}, {-0.44732396166188343`, 1.0321631485139013`}, {0., 1.}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{161, 216},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->792295292]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->43721026],

Cell[TextData[{
 "Specify coordinates for ",
 Cell[BoxData[
  StyleBox["y", "TI"]], "InlineFormula"],
 " coordinates:"
}], "ExampleText",
 CellID->1415217121],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "\[Rule]", "4"}], ",", 
     RowBox[{"1", "\[Rule]", "5"}], ",", 
     RowBox[{"2", "\[Rule]", "4"}], ",", 
     RowBox[{"2", "\[Rule]", "5"}], ",", 
     RowBox[{"3", "\[Rule]", "4"}], ",", 
     RowBox[{"3", "\[Rule]", "5"}]}], "}"}], ",", 
   RowBox[{"VertexLabeling", "\[Rule]", "True"}], ",", 
   RowBox[{"VertexCoordinateRules", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"1", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"Automatic", ",", "0"}], "}"}]}], ",", 
      RowBox[{"2", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"Automatic", ",", "0"}], "}"}]}], ",", 
      RowBox[{"3", "->", 
       RowBox[{"{", 
        RowBox[{"Automatic", ",", "1"}], "}"}]}], ",", 
      RowBox[{"4", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"Automatic", ",", "2"}], "}"}]}], ",", 
      RowBox[{"5", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"Automatic", ",", "0"}], "}"}]}]}], "}"}]}]}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->148938812],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{0.7661131399207392, 0.}, {0.37582935595629957`, 
    2.}, {0.37622713690903087`, 0.}, {-0.014292013992469762`, 0.}, {
    0.3759545596181707, 1.}}, {
     {RGBColor[0.5, 0., 0.], 
      LineBox[{{1, 2}, {1, 3}, {4, 2}, {4, 3}, {5, 2}, {5, 3}}]}, {InsetBox[
       FrameBox["1",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 1], InsetBox[
       FrameBox["4",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 2], InsetBox[
       FrameBox["5",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 3], InsetBox[
       FrameBox["2",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 4], InsetBox[
       FrameBox["3",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 5]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{0.7661131399207392, 0.}, {0.37582935595629957`,
      2.}, {0.37622713690903087`, 0.}, {-0.014292013992469762`, 0.}, {
     0.3759545596181707, 1.}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{89, 216},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1582043171]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->258228157],

Cell[TextData[{
 "Visualize a connected bipartite graph by fixing the ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " coordinates of the layout: "
}], "ExampleText",
 CellID->485866441],

Cell[BoxData[
 RowBox[{
  RowBox[{"bipartite", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "\[Rule]", "b"}], ",", 
     RowBox[{"2", "\[Rule]", "a"}], ",", 
     RowBox[{"3", "\[Rule]", "a"}], ",", 
     RowBox[{"3", "\[Rule]", "d"}], ",", 
     RowBox[{"4", "\[Rule]", "c"}], ",", 
     RowBox[{"4", "\[Rule]", "a"}], ",", 
     RowBox[{"4", "\[Rule]", "b"}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->617165445],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{"bipartite", ",", 
   RowBox[{"VertexCoordinateRules", "\[Rule]", 
    RowBox[{"Flatten", "[", 
     RowBox[{"Map", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"#", "[", 
             RowBox[{"[", "1", "]"}], "]"}], "\[Rule]", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"-", "1"}], ",", "Automatic"}], "}"}]}], ",", 
           RowBox[{
            RowBox[{"#", "[", 
             RowBox[{"[", "2", "]"}], "]"}], "\[Rule]", 
            RowBox[{"{", 
             RowBox[{"1", ",", "Automatic"}], "}"}]}]}], "}"}], ")"}], "&"}], 
       ",", "bipartite"}], "]"}], "]"}]}], ",", 
   RowBox[{"VertexLabeling", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->57634983],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{-1., 5.397474910049244}, {1., 
    4.073411004347803}, {-1., -0.7742771888840135}, {
    1., -0.487350343199831}, {-1., -2.6096624786562876`}, {
    1., -3.9337263844922394`}, {-1., 1.9510988689682327`}, {1., 
    2.2380257146856546`}}, {
     {RGBColor[0.5, 0., 0.], 
      LineBox[{{1, 2}, {3, 4}, {5, 4}, {5, 6}, {7, 8}, {7, 4}, {7, 2}}]}, {
      InsetBox[
       FrameBox["1",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 1], InsetBox[
       FrameBox["b",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 2], InsetBox[
       FrameBox["2",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 3], InsetBox[
       FrameBox["a",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 4], InsetBox[
       FrameBox["3",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 5], InsetBox[
       FrameBox["d",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 6], InsetBox[
       FrameBox["4",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 7], InsetBox[
       FrameBox["c",
        Background->RGBColor[1, 1, 0.8],
        FrameStyle->RGBColor[0.94, 0.85, 0.36],
        StripOnInput->False], 8]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{-1., 5.397474910049244}, {1., 
     4.073411004347803}, {-1., -0.7742771888840135}, {
     1., -0.487350343199831}, {-1., -2.6096624786562876`}, {
     1., -3.9337263844922394`}, {-1., 1.9510988689682327`}, {1., 
     2.2380257146856546`}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{57, 216},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->384499006]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->167559057],

Cell["\<\
Draw a disconnected bipartite graph by linking every left and right node with \
phantom nodes: \
\>", "ExampleText",
 CellID->1836301133],

Cell[BoxData[{
 RowBox[{
  RowBox[{"bipartite", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "\[Rule]", "b"}], ",", 
     RowBox[{"2", "\[Rule]", "a"}], ",", 
     RowBox[{"3", "\[Rule]", "a"}], ",", 
     RowBox[{"3", "\[Rule]", "d"}], ",", 
     RowBox[{"4", "\[Rule]", "c"}], ",", 
     RowBox[{"4", "\[Rule]", "a"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"g", "=", 
   RowBox[{"Join", "[", 
    RowBox[{"bipartite", ",", 
     RowBox[{"Map", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"Left", "\[Rule]", 
          RowBox[{"#", "[", 
           RowBox[{"[", "1", "]"}], "]"}]}], ")"}], "&"}], ",", "bipartite"}],
       "]"}], ",", 
     RowBox[{"Map", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"Right", "\[Rule]", 
          RowBox[{"#", "[", 
           RowBox[{"[", "2", "]"}], "]"}]}], ")"}], "&"}], ",", "bipartite"}],
       "]"}]}], "]"}]}], ";"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->516942635],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot", "[", 
  RowBox[{"g", ",", 
   RowBox[{"VertexCoordinateRules", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"left", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "2"}], ",", "0"}], "}"}]}], ",", 
      RowBox[{"right", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"2", ",", "0"}], "}"}]}], ",", 
      RowBox[{"Sequence", "@@", 
       RowBox[{"Flatten", "[", 
        RowBox[{"Map", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{
               RowBox[{"#", "[", 
                RowBox[{"[", "1", "]"}], "]"}], "\[Rule]", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"-", "1"}], ",", "Automatic"}], "}"}]}], ",", 
              RowBox[{
               RowBox[{"#", "[", 
                RowBox[{"[", "2", "]"}], "]"}], "\[Rule]", 
               RowBox[{"{", 
                RowBox[{"1", ",", "Automatic"}], "}"}]}]}], "}"}], ")"}], 
           "&"}], ",", "bipartite"}], "]"}], "]"}]}]}], "}"}]}], ",", 
   RowBox[{"VertexLabeling", "\[Rule]", "True"}], ",", 
   RowBox[{"VertexRenderingFunction", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"#2", "=!=", "Left"}], "&&", 
         RowBox[{"#2", "=!=", "Right"}]}], ",", 
        RowBox[{"Text", "[", 
         RowBox[{"#2", ",", "#1", ",", 
          RowBox[{"Background", "\[Rule]", "White"}]}], "]"}], ",", 
        RowBox[{"{", "}"}]}], "]"}], "&"}], ")"}]}], ",", 
   RowBox[{"EdgeRenderingFunction", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"!", 
          RowBox[{"MemberQ", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"Left", ",", "Right"}], "}"}], ",", 
            RowBox[{"#2", "[", 
             RowBox[{"[", "1", "]"}], "]"}]}], "]"}]}], "&&", 
         RowBox[{"!", 
          RowBox[{"MemberQ", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"Left", ",", "Right"}], "}"}], ",", 
            RowBox[{"#2", "[", 
             RowBox[{"[", "2", "]"}], "]"}]}], "]"}]}]}], ",", 
        RowBox[{"Line", "[", "#1", "]"}], ",", 
        RowBox[{"{", "}"}]}], "]"}], "&"}], ")"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->904668580],

Cell[BoxData[
 GraphicsBox[
  TagBox[{{LineBox[{{-1., 3.1823899242566}, {1., 3.2172060027562743`}}], 
     LineBox[{{-1., 1.2241207443335924`}, {1., 0.38330889854301586`}}], 
     LineBox[{{-1., 0.22444259483200554`}, {1., 0.38330889854301586`}}], 
     LineBox[{{-1., 0.22444259483200554`}, {1., 0.7440893277698374}}], 
     LineBox[{{-1., 0.7674196925614547}, {1., 1.4133556930868705`}}], 
     LineBox[{{-1., 0.7674196925614547}, {1., 
      0.38330889854301586`}}], {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}}, {InsetBox["1", {-1., 3.1823899242566},
      Background->GrayLevel[1]], InsetBox["b", {1., 3.2172060027562743`},
      Background->GrayLevel[1]], InsetBox["2", {-1., 1.2241207443335924`},
      Background->GrayLevel[1]], InsetBox["a", {1., 0.38330889854301586`},
      Background->GrayLevel[1]], InsetBox["3", {-1., 0.22444259483200554`},
      Background->GrayLevel[1]], InsetBox["d", {1., 0.7440893277698374},
      Background->GrayLevel[1]], InsetBox["4", {-1., 0.7674196925614547},
      Background->GrayLevel[1]], InsetBox["c", {1., 1.4133556930868705`},
      Background->GrayLevel[1]], {}, {}}},
   Annotation[#, 
    VertexCoordinateRules -> {{-1., 3.1823899242566}, {1., 
     3.2172060027562743`}, {-1., 1.2241207443335924`}, {1., 
     0.38330889854301586`}, {-1., 0.22444259483200554`}, {1., 
     0.7440893277698374}, {-1., 0.7674196925614547}, {1., 
     1.4133556930868705`}, {-1.5863633422104475`, 1.7089286043423664`}, {
     1.6171961803853026`, 1.776740160448382}}]& ],
  AspectRatio->Automatic,
  FrameTicks->None,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{149, 216},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->24180505]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["VertexRenderingFunction",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/VertexRenderingFunction"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["DataRange",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DataRange"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["LayeredGraphPlot",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LayeredGraphPlot"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->250839057],

Cell[TextData[ButtonBox["General Graph Drawing",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/GraphDrawing"]], "Tutorials",
 CellID->99260146],

Cell[TextData[ButtonBox["Hierarchical Drawing of Directed Graphs",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/LayeredGraphDrawing"]], "Tutorials",
 CellID->106430589],

Cell[TextData[ButtonBox["Tree Drawing",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/TreeDrawing"]], "Tutorials",
 CellID->341631938]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"VertexCoordinateRules - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 29, 4.3360834}", "context" -> "System`", 
    "keywords" -> {
     "vertex embedding", "vertex constraints", "graph layout constraints"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "VertexCoordinateRules is an option for GraphPlot and related functions \
which specifies rules for determining the coordinates at which vertices \
should placed.", "synonyms" -> {"vertex coordinate rules"}, "title" -> 
    "VertexCoordinateRules", "type" -> "Symbol", "uri" -> 
    "ref/VertexCoordinateRules"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[8464, 276, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->176218835]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 32287, 1009}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1758, 40, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2381, 67, 1586, 37, 70, "ObjectNameGrid"],
Cell[3970, 106, 688, 19, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[4695, 130, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5173, 147, 919, 35, 70, "Notes",
 CellID->1067943069],
Cell[6095, 184, 352, 9, 70, "Notes",
 CellID->414851900],
Cell[6450, 195, 467, 17, 70, "Notes",
 CellID->26077013],
Cell[6920, 214, 973, 36, 70, "Notes",
 CellID->267849229],
Cell[7896, 252, 254, 8, 70, "Notes",
 CellID->104201225],
Cell[8153, 262, 274, 9, 70, "Notes",
 CellID->172541295]
}, Closed]],
Cell[CellGroupData[{
Cell[8464, 276, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->176218835],
Cell[CellGroupData[{
Cell[8849, 290, 148, 5, 70, "ExampleSection",
 CellID->625629395],
Cell[9000, 297, 81, 1, 70, "ExampleText",
 CellID->1548390837],
Cell[CellGroupData[{
Cell[9106, 302, 1067, 32, 47, "Input",
 CellID->1110289063],
Cell[10176, 336, 1336, 37, 201, "Output",
 CellID->632552954]
}, Open  ]],
Cell[11527, 376, 124, 3, 70, "ExampleDelimiter",
 CellID->55441458],
Cell[11654, 381, 116, 3, 70, "ExampleText",
 CellID->1490726115],
Cell[CellGroupData[{
Cell[11795, 388, 896, 27, 70, "Input",
 CellID->1242710117],
Cell[12694, 417, 1336, 37, 201, "Output",
 CellID->572991534]
}, Open  ]],
Cell[14045, 457, 125, 3, 70, "ExampleDelimiter",
 CellID->257533641],
Cell[14173, 462, 82, 1, 70, "ExampleText",
 CellID->1878917218],
Cell[CellGroupData[{
Cell[14280, 467, 941, 28, 70, "Input",
 CellID->624559890],
Cell[15224, 497, 1406, 37, 237, "Output",
 CellID->792295292]
}, Open  ]],
Cell[16645, 537, 124, 3, 70, "ExampleDelimiter",
 CellID->43721026],
Cell[16772, 542, 158, 6, 70, "ExampleText",
 CellID->1415217121],
Cell[CellGroupData[{
Cell[16955, 552, 1083, 32, 70, "Input",
 CellID->148938812],
Cell[18041, 586, 1521, 39, 237, "Output",
 CellID->1582043171]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[19611, 631, 227, 7, 70, "ExampleSection",
 CellID->258228157],
Cell[19841, 640, 207, 6, 70, "ExampleText",
 CellID->485866441],
Cell[20051, 648, 441, 13, 70, "Input",
 CellID->617165445],
Cell[CellGroupData[{
Cell[20517, 665, 866, 25, 70, "Input",
 CellID->57634983],
Cell[21386, 692, 2177, 56, 237, "Output",
 CellID->384499006]
}, Open  ]],
Cell[23578, 751, 125, 3, 70, "ExampleDelimiter",
 CellID->167559057],
Cell[23706, 756, 147, 4, 70, "ExampleText",
 CellID->1836301133],
Cell[23856, 762, 1013, 32, 70, "Input",
 CellID->516942635],
Cell[CellGroupData[{
Cell[24894, 798, 2421, 69, 70, "Input",
 CellID->904668580],
Cell[27318, 869, 1749, 33, 237, "Output",
 CellID->24180505]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[29128, 909, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[29447, 920, 748, 26, 70, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[30232, 951, 318, 9, 70, "TutorialsSection",
 CellID->250839057],
Cell[30553, 962, 147, 3, 70, "Tutorials",
 CellID->99260146],
Cell[30703, 967, 173, 3, 70, "Tutorials",
 CellID->106430589],
Cell[30879, 972, 138, 3, 70, "Tutorials",
 CellID->341631938]
}, Open  ]],
Cell[31032, 978, 27, 0, 70, "History"],
Cell[31062, 980, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

