(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     74775,       2554]
NotebookOptionsPosition[     63872,       2183]
NotebookOutlinePosition[     65766,       2228]
CellTagsIndexPosition[     65680,       2223]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Introduction to Dynamic" :> 
          Documentation`HelpLookup["paclet:tutorial/IntroductionToDynamic"], 
          "Generalized Input" :> 
          Documentation`HelpLookup["paclet:tutorial/GeneralizedInput"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Introduction to Dynamic\"\>",
        2->"\<\"Generalized Input\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Slider" :> Documentation`HelpLookup["paclet:ref/Slider"], 
          "Slider2D" :> Documentation`HelpLookup["paclet:ref/Slider2D"], 
          "Locator" :> Documentation`HelpLookup["paclet:ref/Locator"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Slider\"\>", 
       2->"\<\"Slider2D\"\>", 3->"\<\"Locator\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Control Objects" :> 
          Documentation`HelpLookup["paclet:guide/ControlObjects"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Control Objects\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["VerticalSlider", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["VerticalSlider",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/VerticalSlider"], "[", 
       StyleBox["y", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]represents a vertical slider at position ",
     Cell[BoxData[
      StyleBox["y", "TI"]], "InlineFormula"],
     " with range 0 to 1. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["VerticalSlider",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/VerticalSlider"], "[", 
       RowBox[{
        ButtonBox["Dynamic",
         BaseStyle->"Link",
         ButtonData->"paclet:ref/Dynamic"], "[", 
        StyleBox["y", "TI"], "]"}], "]"}]], "InlineFormula"],
     " \[LineSeparator]takes the position to be the dynamically updated \
current value of ",
     Cell[BoxData[
      StyleBox["y", "TI"]], "InlineFormula"],
     ", with the value of ",
     Cell[BoxData[
      StyleBox["y", "TI"]], "InlineFormula"],
     " being reset if the slider is moved. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["VerticalSlider",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/VerticalSlider"], "[", 
       RowBox[{
        StyleBox["y", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["y", "TI"], 
           StyleBox["min", "TI"]], ",", 
          SubscriptBox[
           StyleBox["y", "TI"], 
           StyleBox["max", "TI"]]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]represents a vertical slider with range ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["y", "TI"], 
       StyleBox["min", "TI"]]], "InlineFormula"],
     " to ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["y", "TI"], 
       StyleBox["max", "TI"]]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["VerticalSlider",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/VerticalSlider"], "[", 
       RowBox[{
        StyleBox["y", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["y", "TI"], 
           StyleBox["min", "TI"]], ",", 
          SubscriptBox[
           StyleBox["y", "TI"], 
           StyleBox["max", "TI"]], ",", 
          StyleBox["dy", "TI"]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]represents a vertical slider that jumps in steps ",
     Cell[BoxData[
      StyleBox["dy", "TI"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["VerticalSlider",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/VerticalSlider"], "[", 
       RowBox[{
        StyleBox["y", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{"{", 
          RowBox[{
           SubscriptBox[
            StyleBox["e", "TI"], 
            StyleBox["1", "TR"]], ",", 
           SubscriptBox[
            StyleBox["e", "TI"], 
            StyleBox["2", "TR"]], ",", 
           StyleBox["\[Ellipsis]", "TR"]}], "}"}], "}"}]}], "]"}]], 
      "InlineFormula"],
     "\[LineSeparator]represents a slider in which equally spaced intervals \
correspond to successive settings ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["e", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["VerticalSlider",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/VerticalSlider"], "[", 
       RowBox[{
        StyleBox["y", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             SubscriptBox[
              StyleBox["e", "TI"], 
              StyleBox["1", "TR"]], ",", 
             SubscriptBox[
              StyleBox["h", "TI"], 
              StyleBox["1", "TR"]]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             SubscriptBox[
              StyleBox["e", "TI"], 
              StyleBox["2", "TR"]], ",", 
             SubscriptBox[
              StyleBox["h", "TI"], 
              StyleBox["2", "TR"]]}], "}"}], ",", 
           StyleBox["\[Ellipsis]", "TR"]}], "}"}], "}"}]}], "]"}]], 
      "InlineFormula"],
     "\[LineSeparator]uses intervals of relative heights ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["h", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     " for the ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["e", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->1513]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["VerticalSlider",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/VerticalSlider"], "[", 
   StyleBox["\[Ellipsis]", "TR"], "]"}]], "InlineFormula"],
 " displays in a notebook as a vertical slider that can be manipulated \
interactively. "
}], "Notes",
 CellID->32327],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["VerticalSlider",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/VerticalSlider"], "[", 
   RowBox[{
    ButtonBox["Dynamic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Dynamic"], "[", 
    StyleBox["y", "TI"], "]"}], "]"}]], "InlineFormula"],
 " will reset the value of ",
 Cell[BoxData[
  StyleBox["y", "TI"]], "InlineFormula"],
 " when the slider is moved; ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["VerticalSlider",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/VerticalSlider"], "[", 
   StyleBox["y", "TI"], "]"}]], "InlineFormula"],
 " will not. "
}], "Notes",
 CellID->20317],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["VerticalSlider",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/VerticalSlider"], "[", 
   RowBox[{
    StyleBox["n", "TI"], ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["n", "TI"], 
       StyleBox["min", "TI"]], ",", 
      SubscriptBox[
       StyleBox["n", "TI"], 
       StyleBox["max", "TI"]], ",", 
      StyleBox["dn", "TI"]}], "}"}]}], "]"}]], "InlineFormula"],
 " jumps to integer positions if ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["n", "TI"], 
   StyleBox["min", "TI"]]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  StyleBox["dn", "TI"]], "InlineFormula"],
 " are integers. ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->206701725]
}], "Notes",
 CellID->27385],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["VerticalSlider",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/VerticalSlider"], "[", 
   RowBox[{
    StyleBox["y", "TI"], ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["y", "TI"], 
       StyleBox["min", "TI"]], ",", 
      SubscriptBox[
       StyleBox["y", "TI"], 
       StyleBox["max", "TI"]], ",", 
      StyleBox["dy", "TI"]}], "}"}]}], "]"}]], "InlineFormula"],
 " in general jumps to positions given by ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Range",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Range"], "[", 
   RowBox[{
    SubscriptBox[
     StyleBox["y", "TI"], 
     StyleBox["min", "TI"]], ",", 
    SubscriptBox[
     StyleBox["y", "TI"], 
     StyleBox["max", "TI"]], ",", 
    StyleBox["dy", "TI"]}], "]"}]], "InlineFormula"],
 ". ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->427403885]
}], "Notes",
 CellID->29498],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["VerticalSlider",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/VerticalSlider"], "[", 
   StyleBox["y", "TI"], "]"}]], "InlineFormula"],
 " represents a slider running from value 0 at the bottom to value 1 at the \
top. "
}], "Notes",
 CellID->29225],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["VerticalSlider",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/VerticalSlider"], "[", 
   RowBox[{
    StyleBox["y", "TI"], ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["y", "TI"], 
       StyleBox["max", "TI"]], ",", 
      SubscriptBox[
       StyleBox["y", "TI"], 
       StyleBox["min", "TI"]]}], "}"}]}], "]"}]], "InlineFormula"],
 " with ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["y", "TI"], 
   StyleBox["max", "TI"]]], "InlineFormula"],
 " > ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["y", "TI"], 
   StyleBox["min", "TI"]]], "InlineFormula"],
 " represents a slider running from value ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["y", "TI"], 
   StyleBox["min", "TI"]]], "InlineFormula"],
 " at the top to value ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["y", "TI"], 
   StyleBox["max", "TI"]]], "InlineFormula"],
 " at the bottom. ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->65925503]
}], "Notes",
 CellID->29565],

Cell["\<\
If the value of the slider is outside the range given, it will be displayed \
at one of the ends. \
\>", "Notes",
 CellID->25996],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["VerticalSlider",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/VerticalSlider"], "[", 
   RowBox[{
    StyleBox["y", "TI"], ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "1", ",", 
      StyleBox["dy", "TI"]}], "}"}]}], "]"}]], "InlineFormula"],
 " displays at position ",
 Cell[BoxData[
  StyleBox["y", "TI"]], "InlineFormula"],
 ", even if this is not a multiple of ",
 Cell[BoxData[
  StyleBox["dy", "TI"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->7147],

Cell[TextData[{
 "In ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["VerticalSlider",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/VerticalSlider"], "[", 
   RowBox[{
    StyleBox["y", "TI"], ",", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["e", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["e", "TI"], 
        StyleBox["2", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}], "}"}]}], "]"}]], 
  "InlineFormula"],
 ", the ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["e", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " can be any expressions, not just numbers. "
}], "Notes",
 CellID->18200],

Cell["The following options can be given: ", "Notes",
 CellID->16097],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Appearance",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Appearance"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "the overall appearance of the slider ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["AutoAction",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/AutoAction"], 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell["\<\
whether to move the slider automatically when the mouse is over it \
\>", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["BaselinePosition",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/BaselinePosition"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "alignment relative to surrounding text", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["BaseStyle",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/BaseStyle"], 
    RowBox[{"{", "}"}], Cell[
    "base style specifications for the slider", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ContinuousAction",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ContinuousAction"], 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell[
    "whether to update continuously when the slider is moved", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Enabled",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Enabled"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "whether the slider is enabled, or grayed out ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ImageMargins",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ImageMargins"], "0", Cell[
    "margins around the image of the displayed slider ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ImageSize",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ImageSize"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "the overall image size of the displayed slider ", "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, None, None, None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{True, True, True, True, True, True, True, True, True}}}},
 CellID->32524],

Cell[TextData[{
 "Possible settings for ",
 Cell[BoxData[
  ButtonBox["Appearance",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Appearance"]], "InlineFormula"],
 " include ",
 Cell[BoxData[
  ButtonBox["Tiny",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Tiny"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Small",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Small"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Medium",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Medium"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Large",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Large"]], "InlineFormula"],
 ", as well as typically some other settings such as ",
 Cell[BoxData["\"\<LeftArrow\>\""], "InlineFormula"],
 " and ",
 Cell[BoxData["\"\<RightArrow\>\""], "InlineFormula"],
 ". "
}], "Notes",
 CellID->19882],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["VerticalSlider",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/VerticalSlider"], "[", "]"}]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["VerticalSlider",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/VerticalSlider"], "[", "0.5", "]"}]], 
  "InlineFormula"],
 "."
}], "Notes",
 CellID->25442],

Cell[TextData[{
 "The settings for ",
 Cell[BoxData[
  ButtonBox["BaseStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BaseStyle"]], "InlineFormula"],
 " are appended to the default style typically given by the ",
 Cell[BoxData["\"\<VerticalSlider\>\""], "InlineFormula"],
 " style in the current stylesheet. "
}], "Notes",
 CellID->307511469]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->236833020],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->40286398],

Cell[TextData[{
 "A vertical slider set at ",
 Cell[BoxData[
  FormBox["0.8`", TraditionalForm]], "InlineMath"],
 " in the default range ",
 Cell[BoxData[
  FormBox["0", TraditionalForm]], "InlineMath"],
 " to ",
 Cell[BoxData[
  FormBox["1", TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->258827707],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"VerticalSlider", "[", "0.8", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->48781270],

Cell[BoxData[
 SliderBox[0.8,
  Appearance->"Vertical"]], "Output",
 ImageSize->{27, 203},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->258063218]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->106640528],

Cell[TextData[{
 "Dynamically change the value of ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->23867402],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"VerticalSlider", "[", 
    RowBox[{"Dynamic", "[", "x", "]"}], "]"}], ",", 
   RowBox[{"Dynamic", "[", "x", "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->123252361],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SliderBox[Dynamic[$CellContext`x],
    Appearance->"Vertical"], ",", 
   DynamicBox[ToBoxes[$CellContext`x, StandardForm],
    ImageSizeCache->{14., {0., 8.}}]}], "}"}]], "Output",
 ImageSize->{67, 203},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->328750417]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1233371],

Cell["Specify integer values only: ", "ExampleText",
 CellID->206701725],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"VerticalSlider", "[", 
    RowBox[{
     RowBox[{"Dynamic", "[", "x", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "100", ",", "1"}], "}"}]}], "]"}], ",", 
   RowBox[{"Dynamic", "[", "x", "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->60092720],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SliderBox[Dynamic[$CellContext`x], {0, 100, 1},
    Appearance->"Vertical"], ",", 
   DynamicBox[ToBoxes[$CellContext`x, StandardForm],
    ImageSizeCache->{7., {0., 8.}}]}], "}"}]], "Output",
 ImageSize->{60, 203},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->661030950]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->516662394],

Cell[TextData[{
 "Use the range ",
 Cell[BoxData[
  FormBox[
   RowBox[{"-", "1"}], TraditionalForm]], "InlineMath"],
 " to ",
 Cell[BoxData[
  FormBox["2", TraditionalForm]], "InlineMath"],
 ", increasing when going from bottom to top:"
}], "ExampleText",
 CellID->65925503],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "=", "0"}], ";", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"VerticalSlider", "[", 
     RowBox[{
      RowBox[{"Dynamic", "[", "x", "]"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1"}], ",", "2"}], "}"}]}], "]"}], ",", 
    RowBox[{"Dynamic", "[", "x", "]"}]}], "}"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->29048653],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SliderBox[Dynamic[$CellContext`x], {-1, 2},
    Appearance->"Vertical"], ",", 
   DynamicBox[ToBoxes[$CellContext`x, StandardForm],
    ImageSizeCache->{7., {0., 8.}}]}], "}"}]], "Output",
 ImageSize->{60, 203},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1014270719]
}, Open  ]],

Cell[TextData[{
 "A vertical slider with range ",
 Cell[BoxData[
  FormBox["2", TraditionalForm]], "InlineMath"],
 " to ",
 Cell[BoxData[
  FormBox[
   RowBox[{"-", "1"}], TraditionalForm]], "InlineMath"],
 ", increasing when going from top to bottom:"
}], "ExampleText",
 CellID->59076423],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"y", "=", "0"}], ";", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"VerticalSlider", "[", 
     RowBox[{
      RowBox[{"Dynamic", "[", "y", "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"2", ",", 
        RowBox[{"-", "1"}]}], "}"}]}], "]"}], ",", 
    RowBox[{"Dynamic", "[", "y", "]"}]}], "}"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->73847791],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SliderBox[Dynamic[$CellContext`y], {2, -1},
    Appearance->"Vertical"], ",", 
   DynamicBox[ToBoxes[$CellContext`y, StandardForm],
    ImageSizeCache->{14., {0., 8.}}]}], "}"}]], "Output",
 ImageSize->{67, 203},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->122784347]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->97700515],

Cell["Use rational steps:", "ExampleText",
 CellID->427403885],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"VerticalSlider", "[", 
    RowBox[{
     RowBox[{"Dynamic", "[", "x", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "5", ",", 
       RowBox[{"1", "/", "4"}]}], "}"}]}], "]"}], ",", 
   RowBox[{"Dynamic", "[", "x", "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2052218909],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SliderBox[Dynamic[
     BoxForm`RemapVariable[$CellContext`x, {0, 5, 
       Rational[1, 4]}], BoxForm`RemapValue[#, $CellContext`x, {0, 5, 
       Rational[1, 4]}]& ], {0, 20, 1},
    Appearance->"Vertical"], ",", 
   DynamicBox[ToBoxes[$CellContext`x, StandardForm],
    ImageSizeCache->{7., {0., 8.}}]}], "}"}]], "Output",
 ImageSize->{60, 203},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->908349096]
}, Open  ]],

Cell[TextData[{
 "Use increments of ",
 Cell[BoxData[
  FormBox["\[Pi]", TraditionalForm]], "InlineMath"]
}], "ExampleText",
 CellID->220041078],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"VerticalSlider", "[", 
    RowBox[{
     RowBox[{"Dynamic", "[", "y", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"5", "\[Pi]"}], ",", "\[Pi]"}], "}"}]}], "]"}], ",", 
   RowBox[{"Dynamic", "[", "y", "]"}]}], "}"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->162009949],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SliderBox[Dynamic[
     BoxForm`RemapVariable[$CellContext`y, {0, 5 Pi, Pi}], 
     BoxForm`RemapValue[#, $CellContext`y, {0, 5 Pi, Pi}]& ], {0, 5, 1},
    Appearance->"Vertical"], ",", 
   DynamicBox[ToBoxes[$CellContext`y, StandardForm],
    ImageSizeCache->{14., {0., 8.}}]}], "}"}]], "Output",
 ImageSize->{67, 203},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->2039432094]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->91782911],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Appearance",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->220021224],

Cell["Different appearance sizes:", "ExampleText",
 CellID->197643473],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"VerticalSlider", "[", 
    RowBox[{"0.5", ",", 
     RowBox[{"Appearance", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"Vertical", ",", "a"}], "}"}]}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", 
     RowBox[{"{", 
      RowBox[{"Tiny", ",", "Small", ",", "Medium", ",", "Large"}], "}"}]}], 
    "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->116610926],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SliderBox[0.5,
    Appearance->{Vertical, Tiny}], ",", 
   SliderBox[0.5,
    Appearance->{Vertical, Small}], ",", 
   SliderBox[0.5,
    Appearance->{Vertical, Medium}], ",", 
   SliderBox[0.502,
    Appearance->{Vertical, Large}]}], "}"}]], "Output",
 ImageSize->{131, 203},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->16854705]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->524825075],

Cell["Different appearance for the slider thumb:", "ExampleText",
 CellID->25814459],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"VerticalSlider", "[", 
    RowBox[{
     RowBox[{"Dynamic", "[", "x", "]"}], ",", 
     RowBox[{"Appearance", "\[Rule]", "a"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", 
     RowBox[{"{", 
      RowBox[{"\"\<RightArrow\>\"", ",", "\"\<LeftArrow\>\""}], "}"}]}], 
    "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->423799388],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SliderBox[Dynamic[$CellContext`x],
    Appearance->"RightArrow"], ",", 
   SliderBox[Dynamic[$CellContext`x],
    Appearance->"LeftArrow"]}], "}"}]], "Output",
 ImageSize->{76, 203},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->149719481]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "AutoAction",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->35378384],

Cell["Change the value by moving the mouse over the slider area:", \
"ExampleText",
 CellID->7226803],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"VerticalSlider", "[", 
    RowBox[{"0.5", ",", 
     RowBox[{"AutoAction", "\[Rule]", "a"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", 
     RowBox[{"{", 
      RowBox[{"True", ",", "False"}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->374235839],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SliderBox[0.248,
    Appearance->"Vertical",
    AutoAction->True], ",", 
   SliderBox[0.5,
    Appearance->"Vertical",
    AutoAction->False]}], "}"}]], "Output",
 ImageSize->{76, 203},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->14913072]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Background",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->94625298],

Cell["Change the background color:", "ExampleText",
 CellID->426254386],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"VerticalSlider", "[", 
    RowBox[{"0.5", ",", 
     RowBox[{"Background", "\[Rule]", "c"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"c", ",", 
     RowBox[{"{", 
      RowBox[{"Pink", ",", "Green", ",", "Gray", ",", "Yellow"}], "}"}]}], 
    "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->748714091],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SliderBox[0.5,
    Appearance->"Vertical",
    Background->RGBColor[1, 0.5, 0.5]], ",", 
   SliderBox[0.5,
    Appearance->"Vertical",
    Background->RGBColor[0, 1, 0]], ",", 
   SliderBox[0.5,
    Appearance->"Vertical",
    Background->GrayLevel[0.5]], ",", 
   SliderBox[0.5,
    Appearance->"Vertical",
    Background->RGBColor[1, 1, 0]]}], "}"}]], "Output",
 ImageSize->{144, 203},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1531039664]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->87176321],

Cell["Change the background color dynamically:", "ExampleText",
 CellID->115579179],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"VerticalSlider", "[", 
  RowBox[{
   RowBox[{"Dynamic", "[", "x", "]"}], ",", 
   RowBox[{"Background", "\[Rule]", 
    RowBox[{"Dynamic", "[", 
     RowBox[{"Hue", "[", "x", "]"}], "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->36443047],

Cell[BoxData[
 SliderBox[Dynamic[$CellContext`x],
  Appearance->"Vertical",
  Background->Dynamic[
    Hue[$CellContext`x]]]], "Output",
 ImageSize->{27, 203},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->774730800]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "BaselinePosition",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->251067218],

Cell["Align with surrounding text:", "ExampleText",
 CellID->1034574494],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Row", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"VerticalSlider", "[", 
      RowBox[{"0.5", ",", 
       RowBox[{"BaselinePosition", "\[Rule]", "b"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"b", ",", 
       RowBox[{"{", 
        RowBox[{"Bottom", ",", "Center", ",", "Top"}], "}"}]}], "}"}]}], 
    "]"}], ",", "\"\<xxx\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2065914546],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   SliderBox[0.5,
    Appearance->"Vertical",
    BaselinePosition->Bottom], "xxx", 
   SliderBox[0.5,
    Appearance->"Vertical",
    BaselinePosition->Center], "xxx", 
   SliderBox[0.5,
    Appearance->"Vertical",
    BaselinePosition->Top]}],
  Row[{
    VerticalSlider[0.5, BaselinePosition -> Bottom], 
    VerticalSlider[0.5, BaselinePosition -> Center], 
    VerticalSlider[0.5, BaselinePosition -> Top]}, "xxx"]]], "Output",
 ImageSize->{127, 402},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1310169926]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "ContinuousAction",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->380359719],

Cell["By default, variables are continuously updated:", "ExampleText",
 CellID->11191181],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"VerticalSlider", "[", 
    RowBox[{"Dynamic", "[", "x", "]"}], "]"}], ",", 
   RowBox[{"Dynamic", "[", "x", "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->357598064],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SliderBox[Dynamic[$CellContext`x],
    Appearance->"Vertical"], ",", 
   DynamicBox[ToBoxes[$CellContext`x, StandardForm],
    ImageSizeCache->{14., {0., 8.}}]}], "}"}]], "Output",
 ImageSize->{67, 203},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->5444668]
}, Open  ]],

Cell[TextData[{
 "Setting ",
 Cell[BoxData[
  ButtonBox["ContinuousAction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ContinuousAction"]], "InlineFormula"],
 " to False, makes variable updates only when the slider is released:"
}], "ExampleText",
 CellID->93663830],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"VerticalSlider", "[", 
    RowBox[{
     RowBox[{"Dynamic", "[", "y", "]"}], ",", 
     RowBox[{"ContinuousAction", "\[Rule]", "False"}]}], "]"}], ",", 
   RowBox[{"Dynamic", "[", "y", "]"}]}], "}"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->470641416],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SliderBox[Dynamic[$CellContext`y],
    Appearance->"Vertical",
    ContinuousAction->False], ",", 
   DynamicBox[ToBoxes[$CellContext`y, StandardForm],
    ImageSizeCache->{14., {0., 8.}}]}], "}"}]], "Output",
 ImageSize->{67, 203},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->322064773]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Enabled",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->367159608],

Cell[TextData[{
 "By default ",
 Cell[BoxData[
  ButtonBox["VerticalSlider",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/VerticalSlider"]], "InlineFormula"],
 " is enabled: "
}], "ExampleText",
 CellID->154813376],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"VerticalSlider", "[", "0.5", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->94729581],

Cell[BoxData[
 SliderBox[0.5,
  Appearance->"Vertical"]], "Output",
 ImageSize->{27, 203},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->162294760]
}, Open  ]],

Cell[TextData[{
 "By setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Enabled",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Enabled"], " ", "\[Rule]", " ", 
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"]}]], "InlineFormula"],
 ", the slider is disabled but visible in its current state:"
}], "ExampleText",
 CellID->200632079],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"VerticalSlider", "[", 
  RowBox[{"0.3", ",", 
   RowBox[{"Enabled", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->227336428],

Cell[BoxData[
 SliderBox[0.3,
  Appearance->"Vertical",
  Enabled->False]], "Output",
 ImageSize->{27, 203},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->35703368]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Exclusions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->269134367],

Cell["Exclude values from the range of the slider:", "ExampleText",
 CellID->41461407],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"VerticalSlider", "[", 
    RowBox[{
     RowBox[{"Dynamic", "[", "x", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", "1", ",", "0.1"}], "}"}], ",", 
     RowBox[{"Exclusions", "\[Rule]", 
      RowBox[{"{", "0", "}"}]}]}], "]"}], ",", 
   RowBox[{"Dynamic", "[", 
    RowBox[{"1", "/", "x"}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->90441566],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SliderBox[Dynamic[$CellContext`x], {-1, 1, 0.1},
    Appearance->"Vertical",
    Exclusions->{0}], ",", 
   DynamicBox[ToBoxes[1/$CellContext`x, StandardForm],
    ImageSizeCache->{21.6875, {0., 8.}}]}], "}"}]], "Output",
 ImageSize->{74, 203},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->575849908]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "ImageMargins",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->362437272],

Cell["Add margins to the slider area:", "ExampleText",
 CellID->806494342],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"VerticalSlider", "[", 
  RowBox[{"0.5", ",", 
   RowBox[{"Background", "\[Rule]", "LightBlue"}], ",", 
   RowBox[{"ImageMargins", "\[Rule]", "10"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->25004971],

Cell[BoxData[
 SliderBox[0.52,
  Appearance->"Vertical",
  Background->RGBColor[0.87, 0.94, 1],
  ImageMargins->10]], "Output",
 ImageSize->{47, 223},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->103531498]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "ImageSize",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->8077918],

Cell["Use preset values:", "ExampleText",
 CellID->537423939],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"VerticalSlider", "[", 
    RowBox[{
     RowBox[{"Dynamic", "[", "x", "]"}], ",", 
     RowBox[{"ImageSize", "\[Rule]", "i"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", 
     RowBox[{"{", 
      RowBox[{"Tiny", ",", "Small", ",", "Medium", ",", "Large"}], "}"}]}], 
    "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->276206941],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SliderBox[Dynamic[$CellContext`x],
    Appearance->"Vertical",
    ImageSize->Tiny], ",", 
   SliderBox[Dynamic[$CellContext`x],
    Appearance->"Vertical",
    ImageSize->Small], ",", 
   SliderBox[Dynamic[$CellContext`x],
    Appearance->"Vertical",
    ImageSize->Medium], ",", 
   SliderBox[Dynamic[$CellContext`x],
    Appearance->"Vertical",
    ImageSize->Large]}], "}"}]], "Output",
 ImageSize->{131, 403},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->9598097]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->876501613],

Cell["Use any height value and default width:", "ExampleText",
 CellID->73815513],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"VerticalSlider", "[", 
    RowBox[{"0.5", ",", 
     RowBox[{"ImageSize", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"Automatic", ",", "i"}], "}"}]}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", 
     RowBox[{"{", 
      RowBox[{"50", ",", "150", ",", "300"}], "}"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->643525534],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SliderBox[0.5,
    Appearance->"Vertical",
    ImageSize->{Automatic, 50}], ",", 
   SliderBox[0.5,
    Appearance->"Vertical",
    ImageSize->{Automatic, 150}], ",", 
   SliderBox[0.5,
    Appearance->"Vertical",
    ImageSize->{Automatic, 300}]}], "}"}]], "Output",
 ImageSize->{97, 303},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->232209118]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->194434227],

Cell["A fully custom image size:", "ExampleText",
 CellID->114063303],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"VerticalSlider", "[", 
    RowBox[{"0.5", ",", 
     RowBox[{"ImageSize", "\[Rule]", "i"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"50", ",", "50"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"75", ",", "50"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"100", ",", "200"}], "}"}]}], "}"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->663785717],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SliderBox[0.5,
    Appearance->"Vertical",
    ImageSize->{50, 50}], ",", 
   SliderBox[0.5,
    Appearance->"Vertical",
    ImageSize->{75, 50}], ",", 
   SliderBox[0.5,
    Appearance->"Vertical",
    ImageSize->{100, 200}]}], "}"}]], "Output",
 ImageSize->{266, 203},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->259490848]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->102532882],

Cell["A color selector:", "ExampleText",
 CellID->101468260],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DynamicModule", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "=", "0"}], "}"}], ",", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"VerticalSlider", "[", 
       RowBox[{
        RowBox[{"Dynamic", "[", "x", "]"}], ",", 
        RowBox[{"Appearance", "\[Rule]", "\"\<RightArrow\>\""}]}], "]"}], ",",
       
      RowBox[{"Graphics", "[", 
       RowBox[{
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"Hue", "[", "i", "]"}], ",", 
            RowBox[{"Rectangle", "[", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"0", ",", "i"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"0.1", ",", 
                RowBox[{"i", "+", "0.01"}]}], "}"}]}], "]"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"i", ",", "0", ",", "1", ",", "0.01"}], "}"}]}], "]"}], 
        ",", 
        RowBox[{"ImageSize", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{"30", ",", "200"}], "}"}]}]}], "]"}], ",", 
      RowBox[{"VerticalSlider", "[", 
       RowBox[{
        RowBox[{"Dynamic", "[", "x", "]"}], ",", 
        RowBox[{"Appearance", "\[Rule]", "\"\<LeftArrow\>\""}]}], "]"}], ",", 
      "\"\<   \>\"", ",", 
      RowBox[{"Dynamic", "@", 
       RowBox[{"Graphics", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Hue", "[", "x", "]"}], ",", 
          RowBox[{"Disk", "[", "]"}]}], "}"}], "]"}]}]}], "}"}], "]"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->29234675],

Cell[BoxData[
 DynamicModuleBox[{$CellContext`x$$ = 0.58}, 
  InterpretationBox[
   RowBox[{
    SliderBox[Dynamic[$CellContext`x$$],
     Appearance->"RightArrow"], "\[InvisibleSpace]", 
    GraphicsBox[{
      {Hue[0.], RectangleBox[{0, 0.}, {0.1, 0.01}]}, 
      {Hue[0.01], RectangleBox[{0, 0.01}, {0.1, 0.02}]}, 
      {Hue[0.02], RectangleBox[{0, 0.02}, {0.1, 0.03}]}, 
      {Hue[0.03], RectangleBox[{0, 0.03}, {0.1, 0.04}]}, 
      {Hue[0.04], RectangleBox[{0, 0.04}, {0.1, 0.05}]}, 
      {Hue[0.05], RectangleBox[{0, 0.05}, {0.1, 0.060000000000000005`}]}, 
      {Hue[0.06], RectangleBox[{0, 0.06}, {0.1, 0.06999999999999999}]}, 
      {Hue[0.07], RectangleBox[{0, 0.07}, {0.1, 0.08}]}, 
      {Hue[0.08], RectangleBox[{0, 0.08}, {0.1, 0.09}]}, 
      {Hue[0.09], RectangleBox[{0, 0.09}, {0.1, 0.09999999999999999}]}, 
      {Hue[0.1], RectangleBox[{0, 0.1}, {0.1, 0.11}]}, 
      {Hue[0.11], RectangleBox[{0, 0.11}, {0.1, 0.12}]}, 
      {Hue[0.12], RectangleBox[{0, 0.12}, {0.1, 0.13}]}, 
      {Hue[0.13], RectangleBox[{0, 0.13}, {0.1, 0.14}]}, 
      {Hue[0.14], RectangleBox[{0, 0.14}, {0.1, 0.15000000000000002`}]}, 
      {Hue[0.15], RectangleBox[{0, 0.15}, {0.1, 0.16}]}, 
      {Hue[0.16], RectangleBox[{0, 0.16}, {0.1, 0.17}]}, 
      {Hue[0.17], RectangleBox[{0, 0.17}, {0.1, 0.18000000000000002`}]}, 
      {Hue[0.18], RectangleBox[{0, 0.18}, {0.1, 0.19}]}, 
      {Hue[0.19], RectangleBox[{0, 0.19}, {0.1, 0.2}]}, 
      {Hue[0.2], RectangleBox[{0, 0.2}, {0.1, 0.21000000000000002`}]}, 
      {Hue[0.21], RectangleBox[{0, 0.21}, {0.1, 0.22}]}, 
      {Hue[0.22], RectangleBox[{0, 0.22}, {0.1, 0.23}]}, 
      {Hue[0.23], RectangleBox[{0, 0.23}, {0.1, 0.24000000000000002`}]}, 
      {Hue[0.24], RectangleBox[{0, 0.24}, {0.1, 0.25}]}, 
      {Hue[0.25], RectangleBox[{0, 0.25}, {0.1, 0.26}]}, 
      {Hue[0.26], RectangleBox[{0, 0.26}, {0.1, 0.27}]}, 
      {Hue[0.27], RectangleBox[{0, 0.27}, {0.1, 0.28}]}, 
      {Hue[0.28], RectangleBox[{0, 0.28}, {0.1, 0.29000000000000004`}]}, 
      {Hue[0.29], RectangleBox[{0, 0.29}, {0.1, 0.3}]}, 
      {Hue[0.3], RectangleBox[{0, 0.3}, {0.1, 0.31}]}, 
      {Hue[0.31], RectangleBox[{0, 0.31}, {0.1, 0.32}]}, 
      {Hue[0.32], RectangleBox[{0, 0.32}, {0.1, 0.33}]}, 
      {Hue[0.33], RectangleBox[{0, 0.33}, {0.1, 0.34}]}, 
      {Hue[0.34], RectangleBox[{0, 0.34}, {0.1, 0.35000000000000003`}]}, 
      {Hue[0.35000000000000003`], 
       RectangleBox[{0, 0.35000000000000003`}, {0.1, 0.36000000000000004`}]}, \

      {Hue[0.36], RectangleBox[{0, 0.36}, {0.1, 0.37}]}, 
      {Hue[0.37], RectangleBox[{0, 0.37}, {0.1, 0.38}]}, 
      {Hue[0.38], RectangleBox[{0, 0.38}, {0.1, 0.39}]}, 
      {Hue[0.39], RectangleBox[{0, 0.39}, {0.1, 0.4}]}, 
      {Hue[0.4], RectangleBox[{0, 0.4}, {0.1, 0.41000000000000003`}]}, 
      {Hue[0.41000000000000003`], 
       RectangleBox[{0, 0.41000000000000003`}, {0.1, 0.42000000000000004`}]}, \

      {Hue[0.42], RectangleBox[{0, 0.42}, {0.1, 0.43}]}, 
      {Hue[0.43], RectangleBox[{0, 0.43}, {0.1, 0.44}]}, 
      {Hue[0.44], RectangleBox[{0, 0.44}, {0.1, 0.45}]}, 
      {Hue[0.45], RectangleBox[{0, 0.45}, {0.1, 0.46}]}, 
      {Hue[0.46], RectangleBox[{0, 0.46}, {0.1, 0.47000000000000003`}]}, 
      {Hue[0.47000000000000003`], 
       RectangleBox[{0, 0.47000000000000003`}, {0.1, 0.48000000000000004`}]}, \

      {Hue[0.48], RectangleBox[{0, 0.48}, {0.1, 0.49}]}, 
      {Hue[0.49], RectangleBox[{0, 0.49}, {0.1, 0.5}]}, 
      {Hue[0.5], RectangleBox[{0, 0.5}, {0.1, 0.51}]}, 
      {Hue[0.51], RectangleBox[{0, 0.51}, {0.1, 0.52}]}, 
      {Hue[0.52], RectangleBox[{0, 0.52}, {0.1, 0.53}]}, 
      {Hue[0.53], RectangleBox[{0, 0.53}, {0.1, 0.54}]}, 
      {Hue[0.54], RectangleBox[{0, 0.54}, {0.1, 0.55}]}, 
      {Hue[0.55], RectangleBox[{0, 0.55}, {0.1, 0.56}]}, 
      {Hue[0.56], RectangleBox[{0, 0.56}, {0.1, 0.5700000000000001}]}, 
      {Hue[0.5700000000000001], 
       RectangleBox[{0, 0.5700000000000001}, {0.1, 0.5800000000000001}]}, 
      {Hue[0.58], RectangleBox[{0, 0.58}, {0.1, 0.59}]}, 
      {Hue[0.59], RectangleBox[{0, 0.59}, {0.1, 0.6}]}, 
      {Hue[0.6], RectangleBox[{0, 0.6}, {0.1, 0.61}]}, 
      {Hue[0.61], RectangleBox[{0, 0.61}, {0.1, 0.62}]}, 
      {Hue[0.62], RectangleBox[{0, 0.62}, {0.1, 0.63}]}, 
      {Hue[0.63], RectangleBox[{0, 0.63}, {0.1, 0.64}]}, 
      {Hue[0.64], RectangleBox[{0, 0.64}, {0.1, 0.65}]}, 
      {Hue[0.65], RectangleBox[{0, 0.65}, {0.1, 0.66}]}, 
      {Hue[0.66], RectangleBox[{0, 0.66}, {0.1, 0.67}]}, 
      {Hue[0.67], RectangleBox[{0, 0.67}, {0.1, 0.68}]}, 
      {Hue[0.68], RectangleBox[{0, 0.68}, {0.1, 0.6900000000000001}]}, 
      {Hue[0.6900000000000001], 
       RectangleBox[{0, 0.6900000000000001}, {0.1, 0.7000000000000001}]}, 
      {Hue[0.7000000000000001], 
       RectangleBox[{0, 0.7000000000000001}, {0.1, 0.7100000000000001}]}, 
      {Hue[0.71], RectangleBox[{0, 0.71}, {0.1, 0.72}]}, 
      {Hue[0.72], RectangleBox[{0, 0.72}, {0.1, 0.73}]}, 
      {Hue[0.73], RectangleBox[{0, 0.73}, {0.1, 0.74}]}, 
      {Hue[0.74], RectangleBox[{0, 0.74}, {0.1, 0.75}]}, 
      {Hue[0.75], RectangleBox[{0, 0.75}, {0.1, 0.76}]}, 
      {Hue[0.76], RectangleBox[{0, 0.76}, {0.1, 0.77}]}, 
      {Hue[0.77], RectangleBox[{0, 0.77}, {0.1, 0.78}]}, 
      {Hue[0.78], RectangleBox[{0, 0.78}, {0.1, 0.79}]}, 
      {Hue[0.79], RectangleBox[{0, 0.79}, {0.1, 0.8}]}, 
      {Hue[0.8], RectangleBox[{0, 0.8}, {0.1, 0.81}]}, 
      {Hue[0.81], RectangleBox[{0, 0.81}, {0.1, 0.8200000000000001}]}, 
      {Hue[0.8200000000000001], 
       RectangleBox[{0, 0.8200000000000001}, {0.1, 0.8300000000000001}]}, 
      {Hue[0.8300000000000001], 
       RectangleBox[{0, 0.8300000000000001}, {0.1, 0.8400000000000001}]}, 
      {Hue[0.84], RectangleBox[{0, 0.84}, {0.1, 0.85}]}, 
      {Hue[0.85], RectangleBox[{0, 0.85}, {0.1, 0.86}]}, 
      {Hue[0.86], RectangleBox[{0, 0.86}, {0.1, 0.87}]}, 
      {Hue[0.87], RectangleBox[{0, 0.87}, {0.1, 0.88}]}, 
      {Hue[0.88], RectangleBox[{0, 0.88}, {0.1, 0.89}]}, 
      {Hue[0.89], RectangleBox[{0, 0.89}, {0.1, 0.9}]}, 
      {Hue[0.9], RectangleBox[{0, 0.9}, {0.1, 0.91}]}, 
      {Hue[0.91], RectangleBox[{0, 0.91}, {0.1, 0.92}]}, 
      {Hue[0.92], RectangleBox[{0, 0.92}, {0.1, 0.93}]}, 
      {Hue[0.93], RectangleBox[{0, 0.93}, {0.1, 0.9400000000000001}]}, 
      {Hue[0.9400000000000001], 
       RectangleBox[{0, 0.9400000000000001}, {0.1, 0.9500000000000001}]}, 
      {Hue[0.9500000000000001], 
       RectangleBox[{0, 0.9500000000000001}, {0.1, 0.9600000000000001}]}, 
      {Hue[0.96], RectangleBox[{0, 0.96}, {0.1, 0.97}]}, 
      {Hue[0.97], RectangleBox[{0, 0.97}, {0.1, 0.98}]}, 
      {Hue[0.98], RectangleBox[{0, 0.98}, {0.1, 0.99}]}, 
      {Hue[0.99], RectangleBox[{0, 0.99}, {0.1, 1.}]}, 
      {Hue[1.], RectangleBox[{0, 1.}, {0.1, 1.01}]}},
     ImageSize->{30, 200}], "\[InvisibleSpace]", 
    SliderBox[Dynamic[$CellContext`x$$],
     Appearance->"LeftArrow"], "\[InvisibleSpace]", "\<\"   \"\>", 
    "\[InvisibleSpace]", 
    DynamicBox[ToBoxes[
      Graphics[{
        Hue[$CellContext`x$$], 
        Disk[]}], StandardForm],
     ImageSizeCache->{180., {88., 92.}}]}],
   Row[{
     VerticalSlider[
      Dynamic[$CellContext`x$$], Appearance -> "RightArrow"], 
     Graphics[{{
        Hue[0.], 
        Rectangle[{0, 0.}, {0.1, 0.01}]}, {
        Hue[0.01], 
        Rectangle[{0, 0.01}, {0.1, 0.02}]}, {
        Hue[0.02], 
        Rectangle[{0, 0.02}, {0.1, 0.03}]}, {
        Hue[0.03], 
        Rectangle[{0, 0.03}, {0.1, 0.04}]}, {
        Hue[0.04], 
        Rectangle[{0, 0.04}, {0.1, 0.05}]}, {
        Hue[0.05], 
        Rectangle[{0, 0.05}, {0.1, 0.060000000000000005`}]}, {
        Hue[0.06], 
        Rectangle[{0, 0.06}, {0.1, 0.06999999999999999}]}, {
        Hue[0.07], 
        Rectangle[{0, 0.07}, {0.1, 0.08}]}, {
        Hue[0.08], 
        Rectangle[{0, 0.08}, {0.1, 0.09}]}, {
        Hue[0.09], 
        Rectangle[{0, 0.09}, {0.1, 0.09999999999999999}]}, {
        Hue[0.1], 
        Rectangle[{0, 0.1}, {0.1, 0.11}]}, {
        Hue[0.11], 
        Rectangle[{0, 0.11}, {0.1, 0.12}]}, {
        Hue[0.12], 
        Rectangle[{0, 0.12}, {0.1, 0.13}]}, {
        Hue[0.13], 
        Rectangle[{0, 0.13}, {0.1, 0.14}]}, {
        Hue[0.14], 
        Rectangle[{0, 0.14}, {0.1, 0.15000000000000002`}]}, {
        Hue[0.15], 
        Rectangle[{0, 0.15}, {0.1, 0.16}]}, {
        Hue[0.16], 
        Rectangle[{0, 0.16}, {0.1, 0.17}]}, {
        Hue[0.17], 
        Rectangle[{0, 0.17}, {0.1, 0.18000000000000002`}]}, {
        Hue[0.18], 
        Rectangle[{0, 0.18}, {0.1, 0.19}]}, {
        Hue[0.19], 
        Rectangle[{0, 0.19}, {0.1, 0.2}]}, {
        Hue[0.2], 
        Rectangle[{0, 0.2}, {0.1, 0.21000000000000002`}]}, {
        Hue[0.21], 
        Rectangle[{0, 0.21}, {0.1, 0.22}]}, {
        Hue[0.22], 
        Rectangle[{0, 0.22}, {0.1, 0.23}]}, {
        Hue[0.23], 
        Rectangle[{0, 0.23}, {0.1, 0.24000000000000002`}]}, {
        Hue[0.24], 
        Rectangle[{0, 0.24}, {0.1, 0.25}]}, {
        Hue[0.25], 
        Rectangle[{0, 0.25}, {0.1, 0.26}]}, {
        Hue[0.26], 
        Rectangle[{0, 0.26}, {0.1, 0.27}]}, {
        Hue[0.27], 
        Rectangle[{0, 0.27}, {0.1, 0.28}]}, {
        Hue[0.28], 
        Rectangle[{0, 0.28}, {0.1, 0.29000000000000004`}]}, {
        Hue[0.29], 
        Rectangle[{0, 0.29}, {0.1, 0.3}]}, {
        Hue[0.3], 
        Rectangle[{0, 0.3}, {0.1, 0.31}]}, {
        Hue[0.31], 
        Rectangle[{0, 0.31}, {0.1, 0.32}]}, {
        Hue[0.32], 
        Rectangle[{0, 0.32}, {0.1, 0.33}]}, {
        Hue[0.33], 
        Rectangle[{0, 0.33}, {0.1, 0.34}]}, {
        Hue[0.34], 
        Rectangle[{0, 0.34}, {0.1, 0.35000000000000003`}]}, {
        Hue[0.35000000000000003`], 
        Rectangle[{0, 0.35000000000000003`}, {0.1, 0.36000000000000004`}]}, {
        Hue[0.36], 
        Rectangle[{0, 0.36}, {0.1, 0.37}]}, {
        Hue[0.37], 
        Rectangle[{0, 0.37}, {0.1, 0.38}]}, {
        Hue[0.38], 
        Rectangle[{0, 0.38}, {0.1, 0.39}]}, {
        Hue[0.39], 
        Rectangle[{0, 0.39}, {0.1, 0.4}]}, {
        Hue[0.4], 
        Rectangle[{0, 0.4}, {0.1, 0.41000000000000003`}]}, {
        Hue[0.41000000000000003`], 
        Rectangle[{0, 0.41000000000000003`}, {0.1, 0.42000000000000004`}]}, {
        Hue[0.42], 
        Rectangle[{0, 0.42}, {0.1, 0.43}]}, {
        Hue[0.43], 
        Rectangle[{0, 0.43}, {0.1, 0.44}]}, {
        Hue[0.44], 
        Rectangle[{0, 0.44}, {0.1, 0.45}]}, {
        Hue[0.45], 
        Rectangle[{0, 0.45}, {0.1, 0.46}]}, {
        Hue[0.46], 
        Rectangle[{0, 0.46}, {0.1, 0.47000000000000003`}]}, {
        Hue[0.47000000000000003`], 
        Rectangle[{0, 0.47000000000000003`}, {0.1, 0.48000000000000004`}]}, {
        Hue[0.48], 
        Rectangle[{0, 0.48}, {0.1, 0.49}]}, {
        Hue[0.49], 
        Rectangle[{0, 0.49}, {0.1, 0.5}]}, {
        Hue[0.5], 
        Rectangle[{0, 0.5}, {0.1, 0.51}]}, {
        Hue[0.51], 
        Rectangle[{0, 0.51}, {0.1, 0.52}]}, {
        Hue[0.52], 
        Rectangle[{0, 0.52}, {0.1, 0.53}]}, {
        Hue[0.53], 
        Rectangle[{0, 0.53}, {0.1, 0.54}]}, {
        Hue[0.54], 
        Rectangle[{0, 0.54}, {0.1, 0.55}]}, {
        Hue[0.55], 
        Rectangle[{0, 0.55}, {0.1, 0.56}]}, {
        Hue[0.56], 
        Rectangle[{0, 0.56}, {0.1, 0.5700000000000001}]}, {
        Hue[0.5700000000000001], 
        Rectangle[{0, 0.5700000000000001}, {0.1, 0.5800000000000001}]}, {
        Hue[0.58], 
        Rectangle[{0, 0.58}, {0.1, 0.59}]}, {
        Hue[0.59], 
        Rectangle[{0, 0.59}, {0.1, 0.6}]}, {
        Hue[0.6], 
        Rectangle[{0, 0.6}, {0.1, 0.61}]}, {
        Hue[0.61], 
        Rectangle[{0, 0.61}, {0.1, 0.62}]}, {
        Hue[0.62], 
        Rectangle[{0, 0.62}, {0.1, 0.63}]}, {
        Hue[0.63], 
        Rectangle[{0, 0.63}, {0.1, 0.64}]}, {
        Hue[0.64], 
        Rectangle[{0, 0.64}, {0.1, 0.65}]}, {
        Hue[0.65], 
        Rectangle[{0, 0.65}, {0.1, 0.66}]}, {
        Hue[0.66], 
        Rectangle[{0, 0.66}, {0.1, 0.67}]}, {
        Hue[0.67], 
        Rectangle[{0, 0.67}, {0.1, 0.68}]}, {
        Hue[0.68], 
        Rectangle[{0, 0.68}, {0.1, 0.6900000000000001}]}, {
        Hue[0.6900000000000001], 
        Rectangle[{0, 0.6900000000000001}, {0.1, 0.7000000000000001}]}, {
        Hue[0.7000000000000001], 
        Rectangle[{0, 0.7000000000000001}, {0.1, 0.7100000000000001}]}, {
        Hue[0.71], 
        Rectangle[{0, 0.71}, {0.1, 0.72}]}, {
        Hue[0.72], 
        Rectangle[{0, 0.72}, {0.1, 0.73}]}, {
        Hue[0.73], 
        Rectangle[{0, 0.73}, {0.1, 0.74}]}, {
        Hue[0.74], 
        Rectangle[{0, 0.74}, {0.1, 0.75}]}, {
        Hue[0.75], 
        Rectangle[{0, 0.75}, {0.1, 0.76}]}, {
        Hue[0.76], 
        Rectangle[{0, 0.76}, {0.1, 0.77}]}, {
        Hue[0.77], 
        Rectangle[{0, 0.77}, {0.1, 0.78}]}, {
        Hue[0.78], 
        Rectangle[{0, 0.78}, {0.1, 0.79}]}, {
        Hue[0.79], 
        Rectangle[{0, 0.79}, {0.1, 0.8}]}, {
        Hue[0.8], 
        Rectangle[{0, 0.8}, {0.1, 0.81}]}, {
        Hue[0.81], 
        Rectangle[{0, 0.81}, {0.1, 0.8200000000000001}]}, {
        Hue[0.8200000000000001], 
        Rectangle[{0, 0.8200000000000001}, {0.1, 0.8300000000000001}]}, {
        Hue[0.8300000000000001], 
        Rectangle[{0, 0.8300000000000001}, {0.1, 0.8400000000000001}]}, {
        Hue[0.84], 
        Rectangle[{0, 0.84}, {0.1, 0.85}]}, {
        Hue[0.85], 
        Rectangle[{0, 0.85}, {0.1, 0.86}]}, {
        Hue[0.86], 
        Rectangle[{0, 0.86}, {0.1, 0.87}]}, {
        Hue[0.87], 
        Rectangle[{0, 0.87}, {0.1, 0.88}]}, {
        Hue[0.88], 
        Rectangle[{0, 0.88}, {0.1, 0.89}]}, {
        Hue[0.89], 
        Rectangle[{0, 0.89}, {0.1, 0.9}]}, {
        Hue[0.9], 
        Rectangle[{0, 0.9}, {0.1, 0.91}]}, {
        Hue[0.91], 
        Rectangle[{0, 0.91}, {0.1, 0.92}]}, {
        Hue[0.92], 
        Rectangle[{0, 0.92}, {0.1, 0.93}]}, {
        Hue[0.93], 
        Rectangle[{0, 0.93}, {0.1, 0.9400000000000001}]}, {
        Hue[0.9400000000000001], 
        Rectangle[{0, 0.9400000000000001}, {0.1, 0.9500000000000001}]}, {
        Hue[0.9500000000000001], 
        Rectangle[{0, 0.9500000000000001}, {0.1, 0.9600000000000001}]}, {
        Hue[0.96], 
        Rectangle[{0, 0.96}, {0.1, 0.97}]}, {
        Hue[0.97], 
        Rectangle[{0, 0.97}, {0.1, 0.98}]}, {
        Hue[0.98], 
        Rectangle[{0, 0.98}, {0.1, 0.99}]}, {
        Hue[0.99], 
        Rectangle[{0, 0.99}, {0.1, 1.}]}, {
        Hue[1.], 
        Rectangle[{0, 1.}, {0.1, 1.01}]}}, ImageSize -> {30, 200}], 
     VerticalSlider[
      Dynamic[$CellContext`x$$], Appearance -> "LeftArrow"], "   ", 
     Dynamic[
      Graphics[{
        Hue[$CellContext`x$$], 
        Disk[]}]]}]],
  DynamicModuleValues:>{}]], "Output",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 ImageSize->{281, 203},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1876113591]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->16614],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["VerticalSlider",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/VerticalSlider"]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  ButtonBox["Slider",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Slider"]], "InlineFormula"],
 " with a vertical appearance:"
}], "ExampleText",
 CellID->276961494],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Slider", "[", 
  RowBox[{"0.8", ",", 
   RowBox[{"Appearance", "\[Rule]", "\"\<Vertical\>\""}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->76773364],

Cell[BoxData[
 SliderBox[0.8,
  Appearance->"Vertical"]], "Output",
 ImageSize->{27, 203},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->694533397]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->24805],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Slider",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Slider"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Slider2D",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Slider2D"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Locator",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Locator"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->1729]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->20657],

Cell[TextData[ButtonBox["Introduction to Dynamic",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/IntroductionToDynamic"]], "Tutorials",
 CellID->445434225],

Cell[TextData[ButtonBox["Generalized Input",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/GeneralizedInput"]], "Tutorials",
 CellID->341631938]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->702250468],

Cell[TextData[ButtonBox["Control Objects",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ControlObjects"]], "MoreAbout",
 CellID->39245379]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"VerticalSlider - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 29, 11.1331324}", "context" -> "System`", 
    "keywords" -> {
     "slider", "upright slider", "y slider", "scrollbar", "dimmer"}, "index" -> 
    True, "label" -> "Built-in Mathematica Symbol", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "VerticalSlider[y] represents a vertical slider at position y with range \
0 to 1. VerticalSlider[Dynamic[y]] takes the position to be the dynamically \
updated current value of y, with the value of y being reset if the slider is \
moved. VerticalSlider[y, {y_min, y_max}] represents a vertical slider with \
range y_min to y_max. VerticalSlider[y, {y_min, y_max, dy}] represents a \
vertical slider that jumps in steps dy. VerticalSlider[y, {{e_1, e_2, ...}}] \
represents a slider in which equally spaced intervals correspond to \
successive settings e_i. VerticalSlider[y, {{{e_1, h_1}, {e_2, h_2}, ...}}] \
uses intervals of relative heights h_i for the e_i. ", 
    "synonyms" -> {"vertical slider"}, "title" -> "VerticalSlider", "type" -> 
    "Symbol", "uri" -> "ref/VerticalSlider"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[19615, 654, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->236833020]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 65536, 2216}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2042, 49, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2665, 76, 1579, 37, 70, "ObjectNameGrid"],
Cell[4247, 115, 4884, 156, 70, "Usage",
 CellID->1513]
}, Open  ]],
Cell[CellGroupData[{
Cell[9168, 276, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[9646, 293, 326, 10, 70, "Notes",
 CellID->32327],
Cell[9975, 305, 657, 23, 70, "Notes",
 CellID->20317],
Cell[10635, 330, 800, 30, 70, "Notes",
 CellID->27385],
Cell[11438, 362, 966, 36, 70, "Notes",
 CellID->29498],
Cell[12407, 400, 311, 10, 70, "Notes",
 CellID->29225],
Cell[12721, 412, 1058, 41, 70, "Notes",
 CellID->29565],
Cell[13782, 455, 139, 4, 70, "Notes",
 CellID->25996],
Cell[13924, 461, 524, 19, 70, "Notes",
 CellID->7147],
Cell[14451, 482, 696, 27, 70, "Notes",
 CellID->18200],
Cell[15150, 511, 69, 1, 70, "Notes",
 CellID->16097],
Cell[15222, 514, 2735, 72, 70, "3ColumnTableMod",
 CellID->32524],
Cell[17960, 588, 865, 32, 70, "Notes",
 CellID->19882],
Cell[18828, 622, 396, 15, 70, "Notes",
 CellID->25442],
Cell[19227, 639, 351, 10, 70, "Notes",
 CellID->307511469]
}, Closed]],
Cell[CellGroupData[{
Cell[19615, 654, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->236833020],
Cell[CellGroupData[{
Cell[20000, 668, 147, 5, 70, "ExampleSection",
 CellID->40286398],
Cell[20150, 675, 320, 12, 70, "ExampleText",
 CellID->258827707],
Cell[CellGroupData[{
Cell[20495, 691, 111, 3, 28, "Input",
 CellID->48781270],
Cell[20609, 696, 198, 7, 224, "Output",
 CellID->258063218]
}, Open  ]],
Cell[20822, 706, 125, 3, 70, "ExampleDelimiter",
 CellID->106640528],
Cell[20950, 711, 152, 6, 70, "ExampleText",
 CellID->23867402],
Cell[CellGroupData[{
Cell[21127, 721, 228, 7, 70, "Input",
 CellID->123252361],
Cell[21358, 730, 354, 11, 70, "Output",
 CellID->328750417]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[21761, 747, 218, 7, 70, "ExampleSection",
 CellID->1233371],
Cell[21982, 756, 72, 1, 70, "ExampleText",
 CellID->206701725],
Cell[CellGroupData[{
Cell[22079, 761, 318, 10, 70, "Input",
 CellID->60092720],
Cell[22400, 773, 366, 11, 70, "Output",
 CellID->661030950]
}, Open  ]],
Cell[22781, 787, 125, 3, 70, "ExampleDelimiter",
 CellID->516662394],
Cell[22909, 792, 275, 10, 70, "ExampleText",
 CellID->65925503],
Cell[CellGroupData[{
Cell[23209, 806, 383, 13, 70, "Input",
 CellID->29048653],
Cell[23595, 821, 363, 11, 70, "Output",
 CellID->1014270719]
}, Open  ]],
Cell[23973, 835, 290, 10, 70, "ExampleText",
 CellID->59076423],
Cell[CellGroupData[{
Cell[24288, 849, 383, 13, 70, "Input",
 CellID->73847791],
Cell[24674, 864, 363, 11, 70, "Output",
 CellID->122784347]
}, Open  ]],
Cell[25052, 878, 124, 3, 70, "ExampleDelimiter",
 CellID->97700515],
Cell[25179, 883, 62, 1, 70, "ExampleText",
 CellID->427403885],
Cell[CellGroupData[{
Cell[25266, 888, 346, 11, 70, "Input",
 CellID->2052218909],
Cell[25615, 901, 499, 14, 70, "Output",
 CellID->908349096]
}, Open  ]],
Cell[26129, 918, 144, 5, 70, "ExampleText",
 CellID->220041078],
Cell[CellGroupData[{
Cell[26298, 927, 348, 11, 70, "Input",
 CellID->162009949],
Cell[26649, 940, 472, 13, 70, "Output",
 CellID->2039432094]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[27170, 959, 221, 7, 70, "ExampleSection",
 CellID->91782911],
Cell[CellGroupData[{
Cell[27416, 970, 231, 7, 70, "ExampleSubsection",
 CellID->220021224],
Cell[27650, 979, 70, 1, 70, "ExampleText",
 CellID->197643473],
Cell[CellGroupData[{
Cell[27745, 984, 439, 14, 70, "Input",
 CellID->116610926],
Cell[28187, 1000, 426, 15, 70, "Output",
 CellID->16854705]
}, Open  ]],
Cell[28628, 1018, 125, 3, 70, "ExampleDelimiter",
 CellID->524825075],
Cell[28756, 1023, 84, 1, 70, "ExampleText",
 CellID->25814459],
Cell[CellGroupData[{
Cell[28865, 1028, 409, 13, 70, "Input",
 CellID->423799388],
Cell[29277, 1043, 333, 11, 70, "Output",
 CellID->149719481]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[29659, 1060, 230, 7, 70, "ExampleSubsection",
 CellID->35378384],
Cell[29892, 1069, 101, 2, 70, "ExampleText",
 CellID->7226803],
Cell[CellGroupData[{
Cell[30018, 1075, 343, 11, 70, "Input",
 CellID->374235839],
Cell[30364, 1088, 336, 13, 70, "Output",
 CellID->14913072]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[30749, 1107, 230, 7, 70, "ExampleSubsection",
 CellID->94625298],
Cell[30982, 1116, 71, 1, 70, "ExampleText",
 CellID->426254386],
Cell[CellGroupData[{
Cell[31078, 1121, 376, 12, 70, "Input",
 CellID->748714091],
Cell[31457, 1135, 539, 19, 70, "Output",
 CellID->1531039664]
}, Open  ]],
Cell[32011, 1157, 124, 3, 70, "ExampleDelimiter",
 CellID->87176321],
Cell[32138, 1162, 83, 1, 70, "ExampleText",
 CellID->115579179],
Cell[CellGroupData[{
Cell[32246, 1167, 275, 8, 70, "Input",
 CellID->36443047],
Cell[32524, 1177, 267, 9, 70, "Output",
 CellID->774730800]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[32840, 1192, 237, 7, 70, "ExampleSubsection",
 CellID->251067218],
Cell[33080, 1201, 72, 1, 70, "ExampleText",
 CellID->1034574494],
Cell[CellGroupData[{
Cell[33177, 1206, 450, 14, 70, "Input",
 CellID->2065914546],
Cell[33630, 1222, 610, 20, 70, "Output",
 CellID->1310169926]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[34289, 1248, 237, 7, 70, "ExampleSubsection",
 CellID->380359719],
Cell[34529, 1257, 89, 1, 70, "ExampleText",
 CellID->11191181],
Cell[CellGroupData[{
Cell[34643, 1262, 228, 7, 70, "Input",
 CellID->357598064],
Cell[34874, 1271, 352, 11, 70, "Output",
 CellID->5444668]
}, Open  ]],
Cell[35241, 1285, 272, 8, 70, "ExampleText",
 CellID->93663830],
Cell[CellGroupData[{
Cell[35538, 1297, 305, 9, 70, "Input",
 CellID->470641416],
Cell[35846, 1308, 383, 12, 70, "Output",
 CellID->322064773]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[36278, 1326, 228, 7, 70, "ExampleSubsection",
 CellID->367159608],
Cell[36509, 1335, 218, 8, 70, "ExampleText",
 CellID->154813376],
Cell[CellGroupData[{
Cell[36752, 1347, 111, 3, 70, "Input",
 CellID->94729581],
Cell[36866, 1352, 198, 7, 70, "Output",
 CellID->162294760]
}, Open  ]],
Cell[37079, 1362, 369, 12, 70, "ExampleText",
 CellID->200632079],
Cell[CellGroupData[{
Cell[37473, 1378, 175, 5, 70, "Input",
 CellID->227336428],
Cell[37651, 1385, 215, 8, 70, "Output",
 CellID->35703368]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[37915, 1399, 231, 7, 70, "ExampleSubsection",
 CellID->269134367],
Cell[38149, 1408, 86, 1, 70, "ExampleText",
 CellID->41461407],
Cell[CellGroupData[{
Cell[38260, 1413, 444, 14, 70, "Input",
 CellID->90441566],
Cell[38707, 1429, 395, 12, 70, "Output",
 CellID->575849908]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[39151, 1447, 233, 7, 70, "ExampleSubsection",
 CellID->362437272],
Cell[39387, 1456, 74, 1, 70, "ExampleText",
 CellID->806494342],
Cell[CellGroupData[{
Cell[39486, 1461, 233, 6, 70, "Input",
 CellID->25004971],
Cell[39722, 1469, 258, 9, 70, "Output",
 CellID->103531498]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[40029, 1484, 228, 7, 70, "ExampleSubsection",
 CellID->8077918],
Cell[40260, 1493, 61, 1, 70, "ExampleText",
 CellID->537423939],
Cell[CellGroupData[{
Cell[40346, 1498, 411, 13, 70, "Input",
 CellID->276206941],
Cell[40760, 1513, 563, 19, 70, "Output",
 CellID->9598097]
}, Open  ]],
Cell[41338, 1535, 125, 3, 70, "ExampleDelimiter",
 CellID->876501613],
Cell[41466, 1540, 81, 1, 70, "ExampleText",
 CellID->73815513],
Cell[CellGroupData[{
Cell[41572, 1545, 416, 14, 70, "Input",
 CellID->643525534],
Cell[41991, 1561, 441, 16, 70, "Output",
 CellID->232209118]
}, Open  ]],
Cell[42447, 1580, 125, 3, 70, "ExampleDelimiter",
 CellID->194434227],
Cell[42575, 1585, 69, 1, 70, "ExampleText",
 CellID->114063303],
Cell[CellGroupData[{
Cell[42669, 1590, 527, 18, 70, "Input",
 CellID->663785717],
Cell[43199, 1610, 421, 16, 70, "Output",
 CellID->259490848]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[43681, 1633, 227, 7, 70, "ExampleSection",
 CellID->102532882],
Cell[43911, 1642, 60, 1, 70, "ExampleText",
 CellID->101468260],
Cell[CellGroupData[{
Cell[43996, 1647, 1574, 46, 70, "Input",
 CellID->29234675],
Cell[45573, 1695, 14954, 349, 70, "Output",
 CellID->1876113591]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[60576, 2050, 233, 7, 70, "ExampleSection",
 CellID->16614],
Cell[60812, 2059, 355, 12, 70, "ExampleText",
 CellID->276961494],
Cell[CellGroupData[{
Cell[61192, 2075, 180, 5, 70, "Input",
 CellID->76773364],
Cell[61375, 2082, 198, 7, 70, "Output",
 CellID->694533397]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[61634, 2096, 311, 9, 70, "SeeAlsoSection",
 CellID->24805],
Cell[61948, 2107, 689, 26, 70, "SeeAlso",
 CellID->1729]
}, Open  ]],
Cell[CellGroupData[{
Cell[62674, 2138, 314, 9, 70, "TutorialsSection",
 CellID->20657],
Cell[62991, 2149, 159, 3, 70, "Tutorials",
 CellID->445434225],
Cell[63153, 2154, 148, 3, 70, "Tutorials",
 CellID->341631938]
}, Open  ]],
Cell[CellGroupData[{
Cell[63338, 2162, 319, 9, 70, "MoreAboutSection",
 CellID->702250468],
Cell[63660, 2173, 140, 3, 70, "MoreAbout",
 CellID->39245379]
}, Open  ]],
Cell[63815, 2179, 27, 0, 70, "History"],
Cell[63845, 2181, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

