(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     36137,        960]
NotebookOptionsPosition[     32139,        835]
NotebookOutlinePosition[     33846,        878]
CellTagsIndexPosition[     33761,        873]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"The Structure of Graphics" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/TheStructureOfGraphics"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"The Structure of Graphics\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"ViewPoint" :> Documentation`HelpLookup["paclet:ref/ViewPoint"],
           "ViewVertical" :> 
          Documentation`HelpLookup["paclet:ref/ViewVertical"], "ViewVector" :> 
          Documentation`HelpLookup["paclet:ref/ViewVector"], 
          "PreserveImageOptions" :> 
          Documentation`HelpLookup["paclet:ref/PreserveImageOptions"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"ViewPoint\"\>", 
       2->"\<\"ViewVertical\"\>", 3->"\<\"ViewVector\"\>", 
       4->"\<\"PreserveImageOptions\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"3D Graphics Options" :> 
          Documentation`HelpLookup["paclet:guide/3DGraphicsOptions"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"3D Graphics Options\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["ViewCenter", "ObjectName"], Cell[BoxData[
     TooltipBox[
      TogglerBox[Dynamic[
        FrontEnd`CurrentValue[
         FrontEnd`EvaluationNotebook[], {
         TaggingRules, "ModificationHighlight"}]], {True->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVVly2zAMDQhxEylSsizLaxJn73KafvQAuUDv/1eApJuosceeTDAWF4B8
eFgk71///HoVV1dXK3p+0wNfIzdCLL4I6p1sYBYuPy3SI2AmRBpuaE/TPRsE
3Isg8mrB9l6ILQhhLkbd93MBuwVxAthdZwPr5wVVzBc8wAvMX8TFqPkqE8q6
rDCsKPjZ/g1guz+PKvLFfGsDU1R4A8zDhgLangX9x/WGM7A1qSQ7rraYkaLf
LHZ5FWY9H7rew/n4/6vWPKT2mXFBaH/NGejzqi/VnFEFJ2Rb1Lo+jtofllPD
RVJjdZLr51Eb/ED1K+QI109LcIg+sdSIWqa5g85L6MiNoRloTws+pdBKiFGl
mx3N0jcAlcsKeFivVkteVOgMSNsC18sYS/iIMdZoK43WSdQVK1SLlYy09bZ2
aEO+aoPiACNak0EBbtfLRIz9KJRcroaSKwE11BprpRHqiJ0BrxtJG4pLYqWc
RZO4BQwSbGT4rFivaLjjQdscjSvlih48Mu+WDisOBcB5ehgeDEZQlikkKh3b
KA1FMTDg9yFxLSe4XC37begHTDh5seS1I/gaW025Yo/yUFbmSalShzon1Kch
JTNn2hKS1hyWVIkf5n2LHEQgt0zeUNTkMaYrDdkMZdo3fJCDHx7hxzAC+8rs
XYBokTPfEJk6JVlZx3Yl0UnTYMPvSUt6zghf8dhIi5VDnwO+Hcb1MHK1msK+
oy5qkYS7wVC3cfiq8ojBcMtFMJXnDiIcLPFJClDFGkJBhXGEZV6VcCQFoey7
tyvBF6lw0uKH6nyQ5fqhrKx/Kxe8+3coucpGN4U5+RYux7vnhGO5P7hKenqz
xSO3ivjisf345fg5Pt1ScCRkkzR1U1Dur+NCec4LZ49Ynx9P04GmOvlnqcKZ
79BfJfcjkg==
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlLlKQ0EYRi/iA9gpWIgvIXbjM1iKWAjW2vgeZnWN+AgWZhEULCxELFyi
ZnfJavbeJOr/33xXcj8CNnY5EA7k3GWYmTuzq+uLa2OWZS38/MYt0DbDHH8Q
8uTB64bRNrmsQkaPRoQSGX1ZqZPR9/eEazL6klIlowf8wiUZ3ecV3snowYDw
SEafUmJk9HmlQh4cX4GM7vUId2T0VFIho28or2T0w5DQIKN3PoUaGX1FaZLR
0ymh6sz7hHLk9PMzoU5Gz6SFmvFsCbd9Xzj9qyc0nfe49xfuTyYUEzoQbmh8
+N8e37HTbVpk9MSzUCajbypFMvq0UiOjzyklMnqvKzRMJCwU+/vjzemTSpns
nh97feJmd0e4cvppTKiQ0bsdoW5ecorZDgpPtD6xqFA2fp+Qp/vtdUj1v797
Oqdwnb2Ov++fUVpk9PCJUCC7n4t5wz5xj9/+rj6ceXbPP86NbEb58/k56qP+
n/0bdGyYqQ==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}], False->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVdd22zAMDUBxSaJm5HgljrPTJN177/nWh35AfqD//1aAVGrrJLbbk+BI
FEmQFxcXlDQ9//3zHNfW1gZ0/6IbbsYOhahvCGrO9qHM/mnhmMMLoKv0RD6V
cPyZHTTcDI5NkYnQq4UQ0BdiAkKYZagl1OOw5fWtcgyvPp7AnefsGG0DBIeA
9RZVrNfcwBasb4nlbP9u4cbc/XD/zXcIgC2qYYazJTQiGSYHS0Hr8Yu5LV/h
ePvR5oMOKswAQ0M8R5OloFMWSNRE+IAVeALv38KX26wAV1uU5Ojv16PQy8q+
gMP+9ABW5C9KbkZi6qv19DGc/ID9b+CrZTjbbVagH3p91oIcL+GZ6JDNUet4
HpWUXxx5BaWZxRh1FQgH6JqoKcarF/2/dblez7IE0XmWGlFL/6ygchIqCmPo
CTSmDq9SaCUUhfI7K3pKlwJESZiAveHGxoA7ESYGpM2B62WMJXzEoojRRhpt
IlFHPKFyjGRBQ2fjBG0WttpMcYIFWhNAAXaHA0+M4yiUXK6UxJWAGmKNsdII
cYGVAadTSQPKS2KkEovGc8swk2ALhg8Tww1qdrjRNmSTtOUqHDhk3jktVpwK
QOLoZngwWICyTMFTqdhHMrQTDQPeazzXdgWXK+e4KV3AhH0US1Ergo8x16QV
R5QXZWWeJJW6qLNHPWq8mEFpS0hac1pSeX4YxjlyEhmFZfKGsqaIhd+Sks+Q
0i7lhZx8cwYPmx5wrMA+yaCwyMqnRCb2IiubsF9JTKRJMeX3JKd5VoS3OEyl
xShBFxLebXrDpsfVSlv2FZ2iHMn4NBg6bZy+ihxiZvjIFWAixyeIcLDNT1KC
qogha1Gh14NB6LXpSEpC2bm3y8O3FmHniF9U55INhnttz7pZuWDu79BqFZxJ
F2bhWzjo7Zx6HMvng6ukuztzvGJXa66NmF/+crzrHe1ScmTkk/SouqB8vq42
0jl0EnuF9/RsMR1Io4U/S5Wt+A79AaDyK/w=
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlUtrE1EYhgfxBwguFBTEvyAiFhfzHxRFvC0E17rQhYLiT7D3u/gTXNg2
3sBFFyIutE1qm17UZJKZZJK0KFjBtur7Td4jnhe7dTMPhAfyQObMnO9Mjl69
fvraniAI7v/+7A3IRri7/8VGWJwHVTH72qohZp+ZBnUx+yWjJWYfHwNvxOwX
jKaYfXAAzIrZ+/tARcw+NAhKYvaTRiJmP2gUxH+vLxKzl5cMMXtfL3gvZn84
Cdpi9hvGJzH7yxegJWa/YnTE7Mtl0HTPfZ/xyPWVZZCGvQ/Au65fSV9aNMLJ
CfDW9a0fIBWz/9wBHbcOf/74PX83W99j128ZNTH71BMQidmfFkAiZj9irIvZ
Fz+AWMx+yEjF7KeMVOw/32x/iuHoCHjt+s42aIfTU6DWna/Prm9vgVb4cc0I
h4fAgusZ62L2A0YsZj9h1MX+9bN9LHfP75zrZ42a2L9/3+wXjVTM7q8jm9NE
5q8wA+JwoB/8eX+eNxIx+00jErP3GA2xvy7uG88R+z2jI2Y/bLTE/v1l76WG
mxP/+r7ZN7+Bupj9mFERsz9/Bppi9myeEzH7QgnUxOy3jYaY/a7RFrNfNtpi
9nNGXcw+NgoaYnbOk2///PJ/bXXFcP37JojF7CPDIBazf/0CKmL2+TlQEbPf
MZpi9olxkIrZS0UQidn3G1Ux+3EjErOfMapi9mBX8p73vOc973n/P/0XnFJ2
Rg==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}]}, "\"\<Click me\>\""],
      "Toggle changes in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["ViewCenter",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/ViewCenter"]], "InlineFormula"],
     "\[LineSeparator]is an option for ",
     Cell[BoxData[
      ButtonBox["Graphics3D",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Graphics3D"]], "InlineFormula"],
     " and related functions which gives the scaled coordinates of the point \
which should appear at the center of the final image. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->8342]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "With the default setting ",
 Cell[BoxData[
  RowBox[{"ViewCenter", "->", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 ", the whole bounding box is centered in the final image. "
}], "Notes",
 CellID->20344],

Cell[TextData[{
 "With the setting ",
 Cell[BoxData[
  RowBox[{"ViewCenter", "->", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "/", "2"}], ",", 
     RowBox[{"1", "/", "2"}], ",", 
     RowBox[{"1", "/", "2"}]}], "}"}]}]], "InlineFormula"],
 ", the center of the three\[Hyphen]dimensional bounding box will be placed \
at the center of the final image. "
}], "Notes",
 CellID->3868],

Cell[TextData[{
 "The setting for ",
 Cell[BoxData[
  ButtonBox["ViewCenter",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ViewCenter"]], "InlineFormula"],
 " is given in scaled coordinates, which run from 0 to 1 across each \
dimension of the bounding box. "
}], "Notes",
 CellID->19652],

Cell[TextData[{
 " ",
 Cell[BoxData[
  RowBox[{"ViewCenter", "->", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       StyleBox["x", "TI"], ",", 
       StyleBox["y", "TI"], ",", 
       StyleBox["z", "TI"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       StyleBox["px", "TI"], ",", 
       StyleBox["py", "TI"]}], "}"}]}], "}"}]}]], "InlineFormula"],
 " makes the 3D point with scaled coordinates ",
 Cell[BoxData[
  RowBox[{"(", 
   RowBox[{
    StyleBox["x", "TI"], ",", 
    StyleBox["y", "TI"], ",", 
    StyleBox["z", "TI"]}], ")"}]], "InlineFormula"],
 " appear at scaled coordinate position ",
 Cell[BoxData[
  RowBox[{"(", 
   RowBox[{
    StyleBox["p", "TI"], 
    StyleBox["x", "TI"], ",", 
    StyleBox["p", "TI"], 
    StyleBox["y", "TI"]}], ")"}]], "InlineFormula"],
 " in the final 2D image. "
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->14787],

Cell[TextData[{
 "The default is ",
 Cell[BoxData[
  RowBox[{"ViewCenter", "->", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       StyleBox["x", "TI"], ",", 
       StyleBox["y", "TI"], ",", 
       StyleBox["z", "TI"]}], "}"}], ",", 
     RowBox[{
      ButtonBox["ImageScaled",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/ImageScaled"], "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "1"}], "}"}], "/", "2"}], "]"}]}], "}"}]}]], 
  "InlineFormula"],
 ". "
}], "Notes",
 CellID->28114],

Cell[TextData[{
 "In a notebook front end, rotating a 3D object by dragging the mouse does \
not change the setting for ",
 Cell[BoxData[
  ButtonBox["ViewCenter",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ViewCenter"]], "InlineFormula"],
 ". Panning changes the second element in the ",
 Cell[BoxData[
  ButtonBox["ViewCenter",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ViewCenter"]], "InlineFormula"],
 " list."
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->437731689],

Cell[TextData[{
 "Explicit settings for ",
 Cell[BoxData[
  ButtonBox["ViewVector",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ViewVector"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["ViewMatrix",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ViewMatrix"]], "InlineFormula"],
 " override settings for ",
 Cell[BoxData[
  ButtonBox["ViewCenter",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ViewCenter"]], "InlineFormula"],
 ". "
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->6767]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->6128850],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->772980326],

Cell["\<\
Place the center of the objects at the center of the final image:\
\>", "ExampleText",
 CellID->378553342],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Framed", "[", 
  RowBox[{"Graphics3D", "[", 
   RowBox[{
    RowBox[{"Cylinder", "[", "]"}], ",", 
    RowBox[{"ViewCenter", "\[Rule]", "Automatic"}], ",", 
    RowBox[{"SphericalRegion", "\[Rule]", "True"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->801142657],

Cell[BoxData[
 FrameBox[
  Graphics3DBox[CylinderBox[{{0, 0, -1}, {0, 0, 1}}],
   SphericalRegion->True,
   ViewCenter->Automatic,
   ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]],
  StripOnInput->False]], "Output",
 ImageSize->{164, 162},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->6112603]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->134043151],

Cell["\<\
Place the top right corner of the objects at the center of the final image:\
\>", "ExampleText",
 CellID->528477373],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Framed", "[", 
  RowBox[{"Graphics3D", "[", 
   RowBox[{
    RowBox[{"Cylinder", "[", "]"}], ",", 
    RowBox[{"ViewCenter", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"1", ",", ".5", ",", "1"}], "}"}]}], ",", 
    RowBox[{"SphericalRegion", "\[Rule]", "True"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->294959548],

Cell[BoxData[
 FrameBox[
  Graphics3DBox[CylinderBox[{{0, 0, -1}, {0, 0, 1}}],
   SphericalRegion->True,
   ViewCenter->{1, 0.5, 1},
   ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]],
  StripOnInput->False]], "Output",
 ImageSize->{164, 162},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->72382262]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->34576125],

Cell[TextData[{
 "Use the ",
 Cell[BoxData[
  RowBox[{"ViewCenter", "->", 
   RowBox[{"{", 
    RowBox[{
     StyleBox["vc", "TI"], ",", 
     StyleBox["vp", "TI"]}], "}"}]}]], "InlineFormula"],
 " to specify that 3D point ",
 Cell[BoxData[
  StyleBox["vc", "TI"]], "InlineFormula"],
 " gets mapped to the 2D point ",
 Cell[BoxData[
  StyleBox["vp", "TI"]], "InlineFormula"],
 ": "
}], "ExampleText",
 CellID->274695607],

Cell[BoxData[{
 RowBox[{
  RowBox[{"vc", "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", "0.5", ",", "1"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"vp", "=", 
   RowBox[{"{", 
    RowBox[{"0.5", ",", "0.7"}], "}"}]}], ";"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->522072669],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Framed", "[", 
  RowBox[{"Graphics3D", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Cylinder", "[", "]"}], ",", "Red", ",", 
      RowBox[{"PointSize", "[", ".1", "]"}], ",", 
      RowBox[{"Point", "[", 
       RowBox[{"Scaled", "[", "vc", "]"}], "]"}]}], "}"}], ",", 
    RowBox[{"ViewCenter", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"vc", ",", "vp"}], "}"}]}], ",", 
    RowBox[{"SphericalRegion", "\[Rule]", "True"}], ",", 
    RowBox[{"Epilog", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"Green", ",", 
       RowBox[{"PointSize", "[", "Medium", "]"}], ",", 
       RowBox[{"Point", "[", 
        RowBox[{"Scaled", "[", "vp", "]"}], "]"}]}], "}"}]}]}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->265420768],

Cell[BoxData[
 FrameBox[
  Graphics3DBox[{CylinderBox[{{0, 0, -1}, {0, 0, 1}}], 
    {RGBColor[1, 0, 0], PointSize[0.1], Point3DBox[Scaled[{1, 0.5, 1}]]}},
   Epilog->{
     RGBColor[0, 1, 0], 
     PointSize[Medium], 
     PointBox[
      Scaled[{0.5, 0.7}]]},
   RotationAction->"Fit",
   SphericalRegion->True,
   ViewCenter->{{1, 0.5, 1}, {0.5, 0.7}},
   ImageCache->GraphicsData["CompressedBitmap", "\<\
eJzVnIuXVVUdx4/zYBhFsXAZRSQLo6JcLl2KgIDyJhxbFeGDROOGk5AiMg4q
DA9heAwM82LuPfgsslKGfyLNVOwhiYmppeajSKOigATbq/br3HvO7/x+e+9z
7rkz4yyGNWfP/u29P3ufOef7++5z7tdyzcsaV+Saly/NjZnXlLtr2fKld4+Z
u7KJF1Wf4XmeL75Hevzn//Gf1Pf8n33df+qb/i8W+M8u9A9c7//yBv/Xi/wX
bvJ/u9g/dIv/uyX+yzn/laX+q7f6r3/P/+OywpvLC2/dXnj7jsI7dxbeW1n4
y6rCkab8+835D1bnj96b/8d9+X+u6T3W0vvvdb3HN/Se2Lj75P27P9y8+1Rr
z+mtPR9t62Hbe9iObrazm7V3sV1drLOLdXWy7k62u4P1drD8LlbY1djYyB5o
Zw/uZA/tYA/vYI+0sUfb2A+3s73b2I+2sse2sB+3sp9sZj/l/+5nj29kT2xg
+9azvnWsby3ru4/tv4ftX83pvGrGmFctmpNf3jzxn+ddw5l/zpm/FTDfCJkP
5/zfc+ZGyPxulPlvRea1JPN/EeZOJ+YfJGY+vb+J41UR1E8Wqa/znw9T3xxQ
f1dQv9bo/yGg/lOEOv9XI/V/NtHUHQbqnVHq7emo4VrPhdTPSepf3ej/5tsk
9Ruc+vsl6j8T1P8yULdh1D0VoT7Rt5KgbnjyG4L6GUV9g6Y+eJP/4s3+S9+J
Ut8Wol4hqe+S1HdL6nvyfw9Tr49Sb+n5qF+pmxU19rc9p0T+9IIY+WJN/vIS
/xVOfiskfydK/kGRfE2E/CRC3m0h92PkjzqStyQjf0qRLwzIF0XJc4L81RD5
W1HyIzHyYyVycUkjyXdlQf64A3kNIJ8NyQ9cp29gmvyWCPnrgrzwxnJJfocg
55c1Qd6Eka+D5KcV+XaMvLuC5Ef33W4hj9+6ITm/oBvIVyPkJ4rkrVbyDk1e
MJBvi5FvciKvBeSzAnJatGjypZD8bYz8KCcXoiVEvpEmbzeQt0fIH6kU+bVW
6RImfxMjf3+Qk3sx9plRdkrAKNkWk6oR2QbYWwT78RD7KQN7l5W9rdLspIzJ
6Ru6WbKG2Hsh++aAfVuYvQthz8fYH07Ovh9hHwLYZ+i/9qcxMeMsXGNyPZai
IOw7+4n9uGKvo8jjYgaVcTHx6iLZg0RFk7NBR76QlHEmATsA5FvTkA8F5NMj
5ErMQBnnJmAdk1OEvDNE3qvJxQj3tAvyhypMDm7pqIx7Tcm4mIB1TVqsVkRP
NGnJlrwekF+Nk9tlnHPSYknNMyZfl5ycEDOUjFMC9t2VeNIyGMnPBORXhciB
lEFdN4OAxdO1UKKKGhNmcmC8VYL8mZCQsYs4o3Sn0jWLORE3ohKRP2EjPwuQ
T0PIKScKOq0O0v3jQx6VMYdiMsZVuMcT1WKKTtkylSYfBsinBuSEjAE+nEG6
Jk7XgC3jYrCXyLdkSU7JmMOYjAlL17BoxxMWF3LEhMyU/GxAPkWTIzKG8OHs
0hUjR9LUQUj+AunDuUlXxyR1cJEbZYxVulKinUjPaRMStdzLJD8HkF8ZkCeR
MVrAodLVlqgNOvLnaC+KIn8Pla6xnSWQqNmtONR4Lp98OCCfHCGnnCi9eeom
Xe2JGkjOB57c6ENZpWt6csSCTEe+3kR+LiCfhJOjPhTykACQrrF0BU/UBhX5
AXRTLal0Ne6r4Smqi+1cfGCgHPJPAPKJAfn1mIDLxXwom3S1J2qG5Bw14cDW
Wom81YX8VOR+XsubnRwhpuSLVbJa05SBJxZeTA1vFu4rTozNAOZDmR4bKEpX
wwy0ZjcDe9POQI1ec+hEhmcAyJmwkAs8SLOEDe8x4QkbkqQjBiy9xRZsKKeZ
Ad4kVLIBPSrmDgMZS/iQ1tTFSN+Zhv4xM/0ahJ642k3RnhQqaWgZe8SN/FRr
MouC3nIokXtVHJzLU2d06jpvkDSOMtaeuiSyKJQJS5PLBc9gzRvMnpRhI91K
/mE/kW8omxzzpAw+ZIKkLZFFgRvv2ZNPJT0pm4zFkzYoY5NbFOSWQ4m8inNz
sVI+Obq1psWcTcbaUxdDok6R4wI+Y/IGStLYZWz8Iamk5KhF4UAePBhYJjnq
SbnIWTppK8lZu0UxaMjDnpRBxrqmLnaLwt2KRMk3pidHt9bsPqRjCmO3KLIg
35eWPO5J2aVrEnIni2KgyLWMcZOurilLIovCbsJWiHwxFHCGLXTXdMVA3pmC
fGvW5IscBByQrknInRJ1VxM2U3K4teYiXQ3kGyIp6kCT32khB96UWbo6pisJ
rIkEJiz9ikNKckrAYU9/OqYrA0d+LyT/JCC/ApIfcpSuhnSFSs4NtoTVfu4f
ci3gaB/SMV0x2RIoOWVFVpQcyJio/5ie3NWWqCD5Kjv5QWfp6rDTIsk3VYh8
S/bkL5o3kqPS1ZiuJLElzMZrf5CHBZyLdKVFO0/UEtgSZZFHH/1NTn4RKuDQ
LXRH8pPJycV+gDeq35i/6C5aTbtLLaa0PM7siT0f7wLEXq888Vh+KS9JNgex
akhQDOm4JPw8tZ/A9kjmTIEJ3tGIUEMlqoM4D/OqNRyPGC4xe1EB8xUWg6v8
Co8kBVpUmlqJJeHFFrehH4EJ3hFFcWJ2FONJiFrDyxKk2jZgfkqL8bk8ClHG
Cp8D5RjtoUrCSUjOkQg45qSFgfkKixEizwNktcL1B2n5qdZwmiHVQJIsg6WQ
Anhv9itcC2Sn3Cf3ZhYVJ9Da+PNc7m6CC7Q4pyV32dA4s1zHuajKdMosHPNo
2h0u0er9L7HDL0ZZCVqvAZFahLy2JBZpwDuM4G2ZgJMK2yoyS4mFww6Q3UCw
kj8ItzzFmEuPtGRFXic+PmJ2WFmCPAJ/csvdL6C9YAH6AALKl1iMMi0owbnn
IKsXrFPw9MDRBjAD7akIELFy53KiIYJoAkhpU47fD48f2ZaQCBmO/3w+/lox
/ktMObjRZXQbcGs2Z9CoYLxfyWqA/IwQnSQfIDGjY/gIq8UIv+Q2MMsOlGg+
k5m7MBjXOMJGqtRwiHn6QjCesSmGwZdLtFf+rIwPRnFBos75HIiWkM7XJpmD
i3jvVaL30f3b78UB9Wes3fE5FtFu3eG9XRpQjjT3w7FkV2n7uSzopxb0oJ5B
HI500RfuYrXDzE0I+qjGW+cTJUJStj6Rt+6JhcFb5uMWEWlanqTHnV2LVwYz
EWpNvrIiKiZubaogHy7IIy+/rJeNJWppWjCuYS6NjABtTJBtXC1GM0yMJlhI
2YRz/HQRf5aID2ZW1IgT4NEzRPSZIpoOxSNnish6GSlwZaRLj7NEXK2ME4wy
rpn/GXmxfU5Vf3bxPJWVvaHMi72NpGrOKdb0vKAmfFdN1ZyL1ITPf5d6rxH5
gvyNDPCGkLUFm/htDa8niOC7wANVS1DUAYpqI/NQULvKWLse1MZnfQ7SLl5z
XmS86jd47/PF3YXFPwkQn4eG4rkXfInVx8fQUDxHVCn8LFH4bj8eBccFPwVC
RV0DouC7KG5R8NOy4KeM4FHwc6bgWyDlRM0HUbAW/LwjPApywL5V1FdBFJwz
tyi4qnBOS+dnOAqem3D94FVHlcLzzi0KXvvgGQavhaoUXlvh2QyvtaoU3vXw
qFkg6jw5ccVaTP2VqadWZug75qcsLV8ua08HLY9EW1b34qt0y5+VU1msw38o
3avDbVH1puh2xoRGVOplsv7thfyoqhhzhda44yKll+u6Y/lRHS9VM3Cprjta
l6rPgQlU8qd16RxZ+mVx9+Gl5/OjIbz0Wlk6TuelI3TdBbL0c+Ka6am7qChd
pEpDJUtkyXjd1m3yKBjbCnk0Sh81y6Pz9FGLPDpbH22WR3W6lR3yyDvj/1fe
izw=\
\>"]],
  StripOnInput->False]], "Output",
 ImageSize->{164, 162},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[2]=",
 CellID->372358094]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->29147],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["ViewPoint",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ViewPoint"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ViewVertical",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ViewVertical"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ViewVector",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ViewVector"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PreserveImageOptions",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PreserveImageOptions"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->21881]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->19458],

Cell[TextData[ButtonBox["The Structure of Graphics",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/TheStructureOfGraphics"]], "Tutorials",
 CellID->659944600]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->50920750],

Cell[TextData[ButtonBox["3D Graphics Options",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/3DGraphicsOptions"]], "MoreAbout",
 CellID->146039903]
}, Open  ]],

Cell["New in 2  |  Last modified in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ViewCenter - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 29, 12.5706692}", "context" -> "System`", 
    "keywords" -> {
     "centering in 3D", "centering of three-dimensional object", 
      "center of gaze", "framing of 3D object", "Plot3Matrix", 
      "camera target", "camera focus", "view target", "view focus", 
      "view center point", "view focus point", "view target point", 
      "camera center point", "camera focus point", "camera target point", 
      "center of projection", "center of 2D projection"}, "index" -> True, 
    "label" -> "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "ViewCenter is an option for Graphics3D and related functions which gives \
the scaled coordinates of the point which should appear at the center of the \
final image. ", "synonyms" -> {"view center"}, "title" -> "ViewCenter", 
    "type" -> "Symbol", "uri" -> "ref/ViewCenter"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[11902, 346, 358, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->6128850]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 33619, 866}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2124, 52, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2747, 79, 4194, 83, 70, "ObjectNameGrid"],
Cell[6944, 164, 678, 19, 70, "Usage",
 CellID->8342]
}, Open  ]],
Cell[CellGroupData[{
Cell[7659, 188, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[8137, 205, 292, 9, 70, "Notes",
 CellID->20344],
Cell[8432, 216, 387, 12, 70, "Notes",
 CellID->3868],
Cell[8822, 230, 292, 9, 70, "Notes",
 CellID->19652],
Cell[9117, 241, 995, 35, 70, "Notes",
 CellID->14787],
Cell[10115, 278, 542, 21, 70, "Notes",
 CellID->28114],
Cell[10660, 301, 590, 17, 70, "Notes",
 CellID->437731689],
Cell[11253, 320, 612, 21, 70, "Notes",
 CellID->6767]
}, Closed]],
Cell[CellGroupData[{
Cell[11902, 346, 358, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->6128850],
Cell[CellGroupData[{
Cell[12285, 360, 148, 5, 70, "ExampleSection",
 CellID->772980326],
Cell[12436, 367, 116, 3, 70, "ExampleText",
 CellID->378553342],
Cell[CellGroupData[{
Cell[12577, 374, 301, 8, 28, "Input",
 CellID->801142657],
Cell[12881, 384, 6409, 112, 183, "Output",
 CellID->6112603]
}, Open  ]],
Cell[19305, 499, 125, 3, 70, "ExampleDelimiter",
 CellID->134043151],
Cell[19433, 504, 126, 3, 70, "ExampleText",
 CellID->528477373],
Cell[CellGroupData[{
Cell[19584, 511, 357, 10, 70, "Input",
 CellID->294959548],
Cell[19944, 523, 3508, 64, 183, "Output",
 CellID->72382262]
}, Open  ]],
Cell[23467, 590, 124, 3, 70, "ExampleDelimiter",
 CellID->34576125],
Cell[23594, 595, 420, 16, 70, "ExampleText",
 CellID->274695607],
Cell[24017, 613, 299, 11, 70, "Input",
 CellID->522072669],
Cell[CellGroupData[{
Cell[24341, 628, 778, 22, 70, "Input",
 CellID->265420768],
Cell[25122, 652, 4546, 85, 183, "Output",
 CellID->372358094]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[29729, 744, 311, 9, 70, "SeeAlsoSection",
 CellID->29147],
Cell[30043, 755, 979, 35, 70, "SeeAlso",
 CellID->21881]
}, Open  ]],
Cell[CellGroupData[{
Cell[31059, 795, 314, 9, 70, "TutorialsSection",
 CellID->19458],
Cell[31376, 806, 162, 3, 70, "Tutorials",
 CellID->659944600]
}, Open  ]],
Cell[CellGroupData[{
Cell[31575, 814, 318, 9, 70, "MoreAboutSection",
 CellID->50920750],
Cell[31896, 825, 148, 3, 70, "MoreAbout",
 CellID->146039903]
}, Open  ]],
Cell[32059, 831, 50, 0, 70, "History"],
Cell[32112, 833, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

