(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     71582,       1456]
NotebookOptionsPosition[     68798,       1366]
NotebookOutlinePosition[     70099,       1403]
CellTagsIndexPosition[     70013,       1398]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"AffineTransform" :> 
          Documentation`HelpLookup["paclet:ref/AffineTransform"], 
          "ViewVector" :> Documentation`HelpLookup["paclet:ref/ViewVector"], 
          "ViewPoint" :> Documentation`HelpLookup["paclet:ref/ViewPoint"], 
          "ViewCenter" :> Documentation`HelpLookup["paclet:ref/ViewCenter"], 
          "ViewVertical" :> 
          Documentation`HelpLookup["paclet:ref/ViewVertical"], "ViewAngle" :> 
          Documentation`HelpLookup["paclet:ref/ViewAngle"], "ViewRange" :> 
          Documentation`HelpLookup["paclet:ref/ViewRange"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"AffineTransform\"\>", 
       2->"\<\"ViewVector\"\>", 3->"\<\"ViewPoint\"\>", 
       4->"\<\"ViewCenter\"\>", 5->"\<\"ViewVertical\"\>", 
       6->"\<\"ViewAngle\"\>", 7->"\<\"ViewRange\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"3D Graphics Options" :> 
          Documentation`HelpLookup["paclet:guide/3DGraphicsOptions"], 
          "Graphics Coordinates" :> 
          Documentation`HelpLookup["paclet:guide/GraphicsCoordinates"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"3D Graphics Options\"\>", 
       2->"\<\"Graphics Coordinates\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["ViewMatrix", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["ViewMatrix",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/ViewMatrix"]], "InlineFormula"],
     "\[LineSeparator]is an option for ",
     Cell[BoxData[
      ButtonBox["Graphics3D",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Graphics3D"]], "InlineFormula"],
     " and related functions that can be used to specify an explicit \
homogeneous transformation matrix for 3D coordinates. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->9339]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ViewMatrix",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ViewMatrix"]], "InlineFormula"],
 " can be set to a 4\[Times]4 matrix ",
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"],
 " which is applied to the list ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    StyleBox["x", "TI"], ",", 
    StyleBox["y", "TI"], ",", 
    StyleBox["z", "TI"], ",", "1"}], "}"}]], "InlineFormula"],
 " for each point. "
}], "Notes",
 CellID->12692],

Cell[TextData[{
 "If the result is ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    StyleBox["tx", "TI"], ",", 
    StyleBox["ty", "TI"], ",", 
    StyleBox["tz", "TI"], ",", 
    StyleBox["tw", "TI"]}], "}"}]], "InlineFormula"],
 ", then the screen coordinates for each point are taken to be given by ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     StyleBox["tx", "TI"], ",", 
     StyleBox["ty", "TI"]}], "}"}], "/", 
   StyleBox["tw", "TI"]}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->16914],

Cell[TextData[{
 "With the default setting ",
 Cell[BoxData[
  RowBox[{"ViewMatrix", "->", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 ", the matrix ",
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"],
 " is found automatically from the settings for options such as ",
 Cell[BoxData[
  ButtonBox["ViewPoint",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ViewPoint"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["ViewVertical",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ViewVertical"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["PlotRange",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotRange"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->16429],

Cell[TextData[{
 "With the setting ",
 Cell[BoxData[
  RowBox[{"ViewMatrix", "->", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 ", explicit forms for the matrix ",
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"],
 " can be found using ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["AbsoluteOptions",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/AbsoluteOptions"], "[", 
   RowBox[{
    StyleBox["g", "TI"], ",", "ViewMatrix"}], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->29260],

Cell[TextData[{
 "An explicit setting ",
 Cell[BoxData[
  RowBox[{"ViewMatrix", "->", 
   StyleBox["m", "TI"]}]], "InlineFormula"],
 " overrides settings for ",
 Cell[BoxData[
  ButtonBox["ViewVector",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ViewVector"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["ViewPoint",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ViewPoint"]], "InlineFormula"],
 " and other view options. "
}], "Notes",
 CellID->25868]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->33743190],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->256811521],

Cell[TextData[{
 "Orthographic view of a sphere from the negative ",
 Cell[BoxData[
  FormBox["z", TraditionalForm]], "InlineMath"],
 " direction:"
}], "ExampleText",
 CellID->483196289],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"Sphere", "[", "]"}], ",", 
   RowBox[{"Boxed", "\[Rule]", "False"}], ",", 
   RowBox[{"ViewMatrix", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"TransformationMatrix", "[", 
       RowBox[{"RescalingTransform", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "}"}], "]"}], "]"}], ",",
       
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"1", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "1", ",", "0", ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "0", ",", 
          RowBox[{"-", "1"}], ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "0", ",", "0", ",", "1"}], "}"}]}], "}"}]}], 
     "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->68916472],

Cell[BoxData[
 Graphics3DBox[SphereBox[{0, 0, 0}],
  Boxed->False,
  ViewMatrix->NCache[{{{
       Rational[1, 2], 0, 0, 
       Rational[1, 2]}, {0, 
       Rational[1, 2], 0, 
       Rational[1, 2]}, {0, 0, 
       Rational[1, 2], 
       Rational[1, 2]}, {0, 0, 0, 1}}, {{1, 0, 0, 0}, {0, 1, 0, 0}, {0, 0, -1,
      0}, {0, 0, 0, 
     1}}}, {{{0.5, 0, 0, 0.5}, {0, 0.5, 0, 0.5}, {0, 0, 0.5, 0.5}, {0, 0, 0, 
      1}}, {{1, 0, 0, 0}, {0, 1, 0, 0}, {0, 0, -1, 0}, {0, 0, 0, 
     1}}}]]], "Output",
 ImageSize->{154, 150},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->30922892,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->8113],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["AffineTransform",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/AffineTransform"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ViewVector",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ViewVector"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ViewPoint",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ViewPoint"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ViewCenter",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ViewCenter"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ViewVertical",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ViewVertical"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ViewAngle",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ViewAngle"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ViewRange",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ViewRange"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->653]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->111610867],

Cell[TextData[ButtonBox["3D Graphics Options",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/3DGraphicsOptions"]], "MoreAbout",
 CellID->464348120],

Cell[TextData[ButtonBox["Graphics Coordinates",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GraphicsCoordinates"]], "MoreAbout",
 CellID->343849288]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ViewMatrix - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 29, 13.2269360}", "context" -> "System`", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "ViewMatrix is an option for Graphics3D and related functions that can be \
used to specify an explicit homogeneous transformation matrix for 3D \
coordinates. ", "synonyms" -> {"view matrix"}, "title" -> "ViewMatrix", 
    "type" -> "Symbol", "uri" -> "ref/ViewMatrix"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[8204, 262, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->33743190]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 69871, 1391}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1964, 42, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2587, 69, 1575, 37, 70, "ObjectNameGrid"],
Cell[4165, 108, 670, 19, 70, "Usage",
 CellID->9339]
}, Open  ]],
Cell[CellGroupData[{
Cell[4872, 132, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5350, 149, 488, 17, 70, "Notes",
 CellID->12692],
Cell[5841, 168, 517, 19, 70, "Notes",
 CellID->16914],
Cell[6361, 189, 765, 27, 70, "Notes",
 CellID->16429],
Cell[7129, 218, 566, 20, 70, "Notes",
 CellID->29260],
Cell[7698, 240, 469, 17, 70, "Notes",
 CellID->25868]
}, Closed]],
Cell[CellGroupData[{
Cell[8204, 262, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->33743190],
Cell[CellGroupData[{
Cell[8588, 276, 148, 5, 70, "ExampleSection",
 CellID->256811521],
Cell[8739, 283, 186, 6, 70, "ExampleText",
 CellID->483196289],
Cell[CellGroupData[{
Cell[8950, 293, 1168, 35, 65, "Input",
 CellID->68916472],
Cell[10121, 330, 55860, 925, 171, 501, 13, "CachedBoxData", "BoxData", \
"Output",
 CellID->30922892]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[66042, 1262, 310, 9, 70, "SeeAlsoSection",
 CellID->8113],
Cell[66355, 1273, 1710, 62, 70, "SeeAlso",
 CellID->653]
}, Open  ]],
Cell[CellGroupData[{
Cell[68102, 1340, 319, 9, 70, "MoreAboutSection",
 CellID->111610867],
Cell[68424, 1351, 148, 3, 70, "MoreAbout",
 CellID->464348120],
Cell[68575, 1356, 151, 3, 70, "MoreAbout",
 CellID->343849288]
}, Open  ]],
Cell[68741, 1362, 27, 0, 70, "History"],
Cell[68771, 1364, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

