(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     28513,        721]
NotebookOptionsPosition[     25310,        621]
NotebookOutlinePosition[     26761,        660]
CellTagsIndexPosition[     26676,        655]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"ViewAngle" :> Documentation`HelpLookup["paclet:ref/ViewAngle"],
           "ViewVector" :> Documentation`HelpLookup["paclet:ref/ViewVector"], 
          "PlotRange" :> Documentation`HelpLookup["paclet:ref/PlotRange"]}, #,
          2]& , Evaluator -> Automatic], {1->"\<\"ViewAngle\"\>", 
       2->"\<\"ViewVector\"\>", 3->"\<\"PlotRange\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"3D Graphics Options" :> 
          Documentation`HelpLookup["paclet:guide/3DGraphicsOptions"], 
          "New in 6.0: Graphics & Visualization Options" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60GraphicsAndVisualizationOptions"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"3D Graphics Options\"\>", 
       2->"\<\"New in 6.0: Graphics & Visualization Options\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["ViewRange", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["ViewRange",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/ViewRange"]], "InlineFormula"],
     "\[LineSeparator]is an option for ",
     Cell[BoxData[
      ButtonBox["Graphics3D",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Graphics3D"]], "InlineFormula"],
     " and related functions which specifies the range of distances from the \
view point to be included in displaying a three\[Hyphen]dimensional scene. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->32096]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["The following settings can be used: ", "Notes",
 CellID->22109],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["All",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/All"], Cell[
    "a range sufficient to see everything (default) ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{
      StyleBox["min", "TI"], ",", 
      StyleBox["max", "TI"]}], "}"}], Cell[
    "minimum and maximum distances ", "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True}}}},
 CellID->18952],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{"ViewRange", "->", 
   RowBox[{"{", 
    RowBox[{
     StyleBox["min", "TI"], ",", 
     StyleBox["max", "TI"]}], "}"}]}]], "InlineFormula"],
 ", the 3D scene is effectively clipped by planes which are distances ",
 Cell[BoxData[
  StyleBox["min", "TI"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  StyleBox["max", "TI"]], "InlineFormula"],
 " away from the camera. "
}], "Notes",
 CellID->14101],

Cell[TextData[{
 "Explicit settings for ",
 Cell[BoxData[
  ButtonBox["ViewMatrix",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ViewMatrix"]], "InlineFormula"],
 " override settings for ",
 Cell[BoxData[
  ButtonBox["ViewRange",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ViewRange"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->3055]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->667705354],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->128755531],

Cell["\<\
By default, the range is sufficient to include all the objects:\
\>", "ExampleText",
 CellID->1699070],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Cylinder", "[", "]"}], ",", 
     RowBox[{"Cylinder", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", "3", ",", 
          RowBox[{"-", "1"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "3", ",", "1"}], "}"}]}], "}"}], "]"}]}], "}"}], 
   ",", 
   RowBox[{"ViewPoint", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"0", ",", 
      RowBox[{"-", "1"}], ",", ".5"}], "}"}]}], ",", 
   RowBox[{"SphericalRegion", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->752636905],

Cell[BoxData[
 Graphics3DBox[{CylinderBox[{{0, 0, -1}, {0, 0, 1}}], 
   CylinderBox[{{0, 3, -1}, {0, 3, 1}}]},
  SphericalRegion->True,
  ViewPoint->{0, -1, 0.5}]], "Output",
 ImageSize->{154, 150},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->794899828,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->96446105],

Cell["\<\
Specify the minimum and maximum distances from the camera to be included:\
\>", "ExampleText",
 CellID->176039510],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Cylinder", "[", "]"}], ",", 
     RowBox[{"Cylinder", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", "3", ",", 
          RowBox[{"-", "1"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "3", ",", "1"}], "}"}]}], "}"}], "]"}]}], "}"}], 
   ",", 
   RowBox[{"ViewPoint", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"0", ",", 
      RowBox[{"-", "1"}], ",", ".5"}], "}"}]}], ",", 
   RowBox[{"ViewRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"3.5", ",", "7.2"}], "}"}]}], ",", 
   RowBox[{"SphericalRegion", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->78577120],

Cell[BoxData[
 Graphics3DBox[{CylinderBox[{{0, 0, -1}, {0, 0, 1}}], 
   CylinderBox[{{0, 3, -1}, {0, 3, 1}}]},
  SphericalRegion->True,
  ViewPoint->{0, -1, 0.5},
  ViewRange->{3.5, 7.2}]], "Output",
 ImageSize->{154, 150},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->29452037,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->24338],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["ViewAngle",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ViewAngle"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ViewVector",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ViewVector"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PlotRange",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PlotRange"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->9514]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->100283727],

Cell[TextData[ButtonBox["3D Graphics Options",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/3DGraphicsOptions"]], "MoreAbout",
 CellID->113149237],

Cell[TextData[ButtonBox["New in 6.0: Graphics & Visualization Options",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/NewIn60GraphicsAndVisualizationOptions"]], "MoreAbout",
 CellID->352430587]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ViewRange - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 29, 18.6489498}", "context" -> "System`", 
    "keywords" -> {
     "near field", "far field", "aperture", "frustum", "view frustum", 
      "pinhole camera", "camera view", "scene view", "camera"}, "index" -> 
    True, "label" -> "Built-in Mathematica Symbol", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "ViewRange is an option for Graphics3D and related functions which \
specifies the range of distances from the view point to be included in \
displaying a three-dimensional scene. ", "synonyms" -> {"view range"}, 
    "title" -> "ViewRange", "type" -> "Symbol", "uri" -> "ref/ViewRange"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6684, 205, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->667705354]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 26533, 648}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1577, 36, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2200, 63, 1574, 37, 70, "ObjectNameGrid"],
Cell[3777, 102, 698, 19, 70, "Usage",
 CellID->32096]
}, Open  ]],
Cell[CellGroupData[{
Cell[4512, 126, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4990, 143, 69, 1, 70, "Notes",
 CellID->22109],
Cell[5062, 146, 782, 21, 70, "2ColumnTableMod",
 CellID->18952],
Cell[5847, 169, 449, 16, 70, "Notes",
 CellID->14101],
Cell[6299, 187, 348, 13, 70, "Notes",
 CellID->3055]
}, Closed]],
Cell[CellGroupData[{
Cell[6684, 205, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->667705354],
Cell[CellGroupData[{
Cell[7069, 219, 148, 5, 70, "ExampleSection",
 CellID->128755531],
Cell[7220, 226, 112, 3, 70, "ExampleText",
 CellID->1699070],
Cell[CellGroupData[{
Cell[7357, 233, 651, 21, 47, "Input",
 CellID->752636905],
Cell[8011, 256, 7108, 122, 171, 174, 4, "CachedBoxData", "BoxData", "Output",
 CellID->794899828]
}, Open  ]],
Cell[15134, 381, 124, 3, 70, "ExampleDelimiter",
 CellID->96446105],
Cell[15261, 386, 124, 3, 70, "ExampleText",
 CellID->176039510],
Cell[CellGroupData[{
Cell[15410, 393, 753, 24, 70, "Input",
 CellID->78577120],
Cell[16166, 419, 7287, 126, 171, 199, 5, "CachedBoxData", "BoxData", "Output",
 
 CellID->29452037]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[23514, 552, 311, 9, 70, "SeeAlsoSection",
 CellID->24338],
Cell[23828, 563, 703, 26, 70, "SeeAlso",
 CellID->9514]
}, Open  ]],
Cell[CellGroupData[{
Cell[24568, 594, 319, 9, 70, "MoreAboutSection",
 CellID->100283727],
Cell[24890, 605, 148, 3, 70, "MoreAbout",
 CellID->113149237],
Cell[25041, 610, 197, 4, 70, "MoreAbout",
 CellID->352430587]
}, Open  ]],
Cell[25253, 617, 27, 0, 70, "History"],
Cell[25283, 619, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

