(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     33882,        931]
NotebookOptionsPosition[     29969,        802]
NotebookOutlinePosition[     31393,        841]
CellTagsIndexPosition[     31308,        836]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"The Structure of Graphics" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/TheStructureOfGraphics"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"The Structure of Graphics\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"ViewPoint" :> Documentation`HelpLookup["paclet:ref/ViewPoint"],
           "ViewCenter" :> Documentation`HelpLookup["paclet:ref/ViewCenter"], 
          "ViewMatrix" :> 
          Documentation`HelpLookup["paclet:ref/ViewMatrix"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"ViewPoint\"\>", 
       2->"\<\"ViewCenter\"\>", 3->"\<\"ViewMatrix\"\>"}, "\<\"see also\"\>", 
       
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"3D Graphics Options" :> 
          Documentation`HelpLookup["paclet:guide/3DGraphicsOptions"], 
          "Graphics Coordinates" :> 
          Documentation`HelpLookup["paclet:guide/GraphicsCoordinates"], 
          "New in 6.0: Graphics & Visualization Options" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60GraphicsAndVisualizationOptions"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"3D Graphics Options\"\>", 
       2->"\<\"Graphics Coordinates\"\>", 
       3->"\<\"New in 6.0: Graphics & Visualization Options\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["ViewVector", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["ViewVector",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/ViewVector"]], "InlineFormula"],
     "\[LineSeparator]is an option for ",
     Cell[BoxData[
      ButtonBox["Graphics3D",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Graphics3D"]], "InlineFormula"],
     " and related functions which specifies the position and direction of a \
simulated camera used to view three\[Hyphen]dimensional objects. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->12120]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "With the default setting ",
 Cell[BoxData[
  RowBox[{"ViewVector", "->", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 ", the position and direction of the simulated camera is determined by the \
settings for ",
 Cell[BoxData[
  ButtonBox["ViewPoint",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ViewPoint"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["ViewCenter",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ViewCenter"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->8148],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"ViewVector", "->", 
   RowBox[{"{", 
    RowBox[{
     StyleBox["x", "TI"], ",", 
     StyleBox["y", "TI"], ",", 
     StyleBox["z", "TI"]}], "}"}]}]], "InlineFormula"],
 " specifies that the camera should be at the position with coordinates ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    StyleBox["x", "TI"], ",", 
    StyleBox["y", "TI"], ",", 
    StyleBox["z", "TI"]}], "}"}]], "InlineFormula"],
 ", aimed in the direction specified by ",
 Cell[BoxData[
  ButtonBox["ViewCenter",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ViewCenter"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->10939],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"ViewVector", "->", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       StyleBox["x", "TI"], ",", 
       StyleBox["y", "TI"], ",", 
       StyleBox["z", "TI"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       StyleBox["tx", "TI"], ",", 
       StyleBox["ty", "TI"], ",", 
       StyleBox["tz", "TI"]}], "}"}]}], "}"}]}]], "InlineFormula"],
 " specifies that the camera should be aimed in the direction of the point ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    StyleBox["tx", "TI"], ",", 
    StyleBox["ty", "TI"], ",", 
    StyleBox["tz", "TI"]}], "}"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->3106],

Cell["Scaled coordinates can be used. ", "Notes",
 CellID->23560],

Cell[TextData[{
 "How much the simulated camera sees is determined by settings for ",
 Cell[BoxData[
  ButtonBox["ViewAngle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ViewAngle"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["ViewRange",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ViewRange"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->24754],

Cell[TextData[{
 "Explicit settings for ",
 Cell[BoxData[
  ButtonBox["ViewVector",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ViewVector"]], "InlineFormula"],
 " override settings for ",
 Cell[BoxData[
  ButtonBox["ViewPoint",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ViewPoint"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["ViewCenter",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ViewCenter"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->17299],

Cell[TextData[{
 "Explicit settings for ",
 Cell[BoxData[
  ButtonBox["ViewMatrix",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ViewMatrix"]], "InlineFormula"],
 " override settings for ",
 Cell[BoxData[
  ButtonBox["ViewVector",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ViewVector"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->7809]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->120252967],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->498106692],

Cell["Specify the view vectors using ordinary coordinates:", "ExampleText",
 CellID->30861637],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"Cylinder", "[", "]"}], ",", 
   RowBox[{"ViewVector", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"5", ",", 
        RowBox[{"-", "5"}], ",", "5"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"5", ",", "0", ",", 
        RowBox[{"-", "5"}]}], "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->6602843],

Cell[BoxData[
 Graphics3DBox[CylinderBox[{{0, 0, -1}, {0, 0, 1}}],
  ViewVector->{{5, -5, 5}, {5, 0, -5}}]], "Output",
 ImageSize->{154, 108},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->311864414,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1080],

Cell["Camera path following a particular parametric curve:", "ExampleText",
 CellID->671775041],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"With", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"obj", "=", 
     RowBox[{"PolyhedronData", "[", "\"\<Icosahedron\>\"", "]"}]}], "}"}], 
   ",", 
   RowBox[{"Animate", "[", 
    RowBox[{
     RowBox[{"Show", "[", 
      RowBox[{"obj", ",", 
       RowBox[{"SphericalRegion", "\[Rule]", "True"}], ",", 
       RowBox[{"ViewVector", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"5", 
           RowBox[{"Cos", "[", "t", "]"}]}], ",", 
          RowBox[{"5", 
           RowBox[{"Sin", "[", "t", "]"}]}], ",", 
          RowBox[{"10", 
           RowBox[{"Sin", "[", 
            RowBox[{"t", "/", "2"}], "]"}]}]}], "}"}]}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "0", ",", 
       RowBox[{"4", "Pi"}]}], "}"}], ",", 
     RowBox[{"AnimationRunning", "\[Rule]", "False"}]}], "]"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->16355681],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`t$$ = 0, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`t$$], 0, 4 Pi}}, Typeset`size$$ = {180., {88., 92.}}, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`t$25300$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`t$$ = 0}, 
      "ControllerVariables" :> {
        Hold[$CellContext`t$$, $CellContext`t$25300$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Show[
        Graphics3D[
         GraphicsComplex[{{
           0, 0, (-5) (50 - 10 5^Rational[1, 2])^Rational[-1, 2]}, {
           0, 0, 5 (50 - 10 5^Rational[1, 2])^
             Rational[-1, 2]}, {-(2/(5 - 5^Rational[1, 2]))^Rational[1, 2], 
            0, -(10 - 2 5^Rational[1, 2])^Rational[-1, 2]}, {(2/(5 - 5^
             Rational[1, 2]))^Rational[1, 2], 0, (10 - 2 5^Rational[1, 2])^
            Rational[-1, 2]}, {
           Rational[1, 2] (10 - 2 5^Rational[1, 2])^Rational[-1, 2] (1 + 
             5^Rational[1, 2]), 
            Rational[-1, 2], -(10 - 2 5^Rational[1, 2])^Rational[-1, 2]}, {
           Rational[1, 2] (10 - 2 5^Rational[1, 2])^Rational[-1, 2] (1 + 
             5^Rational[1, 2]), 
            Rational[1, 2], -(10 - 2 5^Rational[1, 2])^Rational[-1, 2]}, {
           Rational[-1, 2] (10 - 2 5^Rational[1, 2])^Rational[-1, 2] (1 + 
             5^Rational[1, 2]), 
            Rational[-1, 2], (10 - 2 5^Rational[1, 2])^Rational[-1, 2]}, {
           Rational[-1, 2] (10 - 2 5^Rational[1, 2])^Rational[-1, 2] (1 + 
             5^Rational[1, 2]), 
            Rational[1, 2], (10 - 2 5^Rational[1, 2])^Rational[-1, 2]}, {
           Rational[-1, 2] (10 - 2 5^Rational[1, 2])^Rational[-1, 2] (-1 + 
             5^Rational[1, 2]), 
            Rational[-1, 
              2] ((5 - 5^Rational[1, 2])^(-1) (5 + 5^Rational[1, 2]))^
             Rational[1, 2], -(10 - 2 5^Rational[1, 2])^Rational[-1, 2]}, {
           Rational[-1, 2] (10 - 2 5^Rational[1, 2])^Rational[-1, 2] (-1 + 
             5^Rational[1, 2]), 
            Rational[
             1, 2] ((5 - 5^Rational[1, 2])^(-1) (5 + 5^Rational[1, 2]))^
             Rational[1, 2], -(10 - 2 5^Rational[1, 2])^Rational[-1, 2]}, {
           Rational[1, 2] (10 - 2 5^Rational[1, 2])^Rational[-1, 2] (-1 + 
             5^Rational[1, 2]), 
            Rational[-1, 
              2] ((5 - 5^Rational[1, 2])^(-1) (5 + 5^Rational[1, 2]))^
             Rational[1, 2], (10 - 2 5^Rational[1, 2])^Rational[-1, 2]}, {
           Rational[1, 2] (10 - 2 5^Rational[1, 2])^Rational[-1, 2] (-1 + 
             5^Rational[1, 2]), 
            Rational[
             1, 2] ((5 - 5^Rational[1, 2])^(-1) (5 + 5^Rational[1, 2]))^
             Rational[1, 2], (10 - 2 5^Rational[1, 2])^Rational[-1, 2]}}, 
          
          Polygon[{{2, 12, 8}, {2, 8, 7}, {2, 7, 11}, {2, 11, 4}, {2, 4, 
           12}, {5, 9, 1}, {6, 5, 1}, {10, 6, 1}, {3, 10, 1}, {9, 3, 1}, {12, 
           10, 8}, {8, 3, 7}, {7, 9, 11}, {11, 5, 4}, {4, 6, 12}, {5, 11, 
           9}, {6, 4, 5}, {10, 12, 6}, {3, 8, 10}, {9, 7, 3}}]]], 
        SphericalRegion -> True, 
        ViewVector -> {
         5 Cos[$CellContext`t$$], 5 Sin[$CellContext`t$$], 10 
          Sin[$CellContext`t$$/2]}], 
      "Specifications" :> {{$CellContext`t$$, 0, 4 Pi, AnimationRunning -> 
         False, AppearanceElements -> {
          "ProgressSlider", "PlayPauseButton", "FasterSlowerButtons", 
           "DirectionButton"}}}, 
      "Options" :> {
       ControlType -> Animator, AppearanceElements -> None, 
        SynchronousUpdating -> True, ShrinkingDelay -> 10.}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{326., {125., 130.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{330, 257},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->231308752]
}, Open  ]],

Cell["Parametric plot of the camera path:", "ExampleText",
 CellID->82752900],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParametricPlot3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"5", 
      RowBox[{"Cos", "[", "t", "]"}]}], ",", 
     RowBox[{"5", 
      RowBox[{"Sin", "[", "t", "]"}]}], ",", 
     RowBox[{"10", 
      RowBox[{"Sin", "[", 
       RowBox[{"t", "/", "2"}], "]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", 
     RowBox[{"4", "Pi"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->48232501],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{138, 216},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->735204143]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->24521],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["ViewPoint",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ViewPoint"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ViewCenter",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ViewCenter"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ViewMatrix",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ViewMatrix"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->19197]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->16503],

Cell[TextData[ButtonBox["The Structure of Graphics",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/TheStructureOfGraphics"]], "Tutorials",
 CellID->659944600]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["Demonstrations with ViewVector",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=ViewVector"], 
    None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->31711211],

Cell[TextData[ButtonBox["3D Graphics Options",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/3DGraphicsOptions"]], "MoreAbout",
 CellID->453173729],

Cell[TextData[ButtonBox["Graphics Coordinates",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GraphicsCoordinates"]], "MoreAbout",
 CellID->139191420],

Cell[TextData[ButtonBox["New in 6.0: Graphics & Visualization Options",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/NewIn60GraphicsAndVisualizationOptions"]], "MoreAbout",
 CellID->946100984]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ViewVector - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 29, 19.0864610}", "context" -> "System`", 
    "keywords" -> {
     "view point", "view vector", "camera location", "camera direction", 
      "eye location", "eye direction"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "ViewVector is an option for Graphics3D and related functions which \
specifies the position and direction of a simulated camera used to view \
three-dimensional objects. ", "synonyms" -> {"view vector"}, "title" -> 
    "ViewVector", "type" -> "Symbol", "uri" -> "ref/ViewVector"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[8991, 292, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->120252967]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 31165, 829}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2351, 57, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2974, 84, 1575, 37, 70, "ObjectNameGrid"],
Cell[4552, 123, 690, 19, 70, "Usage",
 CellID->12120]
}, Open  ]],
Cell[CellGroupData[{
Cell[5279, 147, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5757, 164, 584, 20, 70, "Notes",
 CellID->8148],
Cell[6344, 186, 645, 22, 70, "Notes",
 CellID->10939],
Cell[6992, 210, 681, 24, 70, "Notes",
 CellID->3106],
Cell[7676, 236, 65, 1, 70, "Notes",
 CellID->23560],
Cell[7744, 239, 372, 13, 70, "Notes",
 CellID->24754],
Cell[8119, 254, 482, 18, 70, "Notes",
 CellID->17299],
Cell[8604, 274, 350, 13, 70, "Notes",
 CellID->7809]
}, Closed]],
Cell[CellGroupData[{
Cell[8991, 292, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->120252967],
Cell[CellGroupData[{
Cell[9376, 306, 148, 5, 70, "ExampleSection",
 CellID->498106692],
Cell[9527, 313, 94, 1, 70, "ExampleText",
 CellID->30861637],
Cell[CellGroupData[{
Cell[9646, 318, 426, 14, 28, "Input",
 CellID->6602843],
Cell[10075, 334, 6426, 110, 129, 118, 2, "CachedBoxData", "BoxData", "Output",
 
 CellID->311864414]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[16550, 450, 223, 7, 70, "ExampleSection",
 CellID->1080],
Cell[16776, 459, 95, 1, 70, "ExampleText",
 CellID->671775041],
Cell[CellGroupData[{
Cell[16896, 464, 915, 28, 70, "Input",
 CellID->16355681],
Cell[17814, 494, 4582, 90, 70, "Output",
 CellID->231308752]
}, Open  ]],
Cell[22411, 587, 77, 1, 70, "ExampleText",
 CellID->82752900],
Cell[CellGroupData[{
Cell[22513, 592, 468, 16, 70, "Input",
 CellID->48232501],
Cell[22984, 610, 3746, 65, 70, "Output",
 Evaluatable->False,
 CellID->735204143]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[26791, 682, 311, 9, 70, "SeeAlsoSection",
 CellID->24521],
Cell[27105, 693, 706, 26, 70, "SeeAlso",
 CellID->19197]
}, Open  ]],
Cell[CellGroupData[{
Cell[27848, 724, 314, 9, 70, "TutorialsSection",
 CellID->16503],
Cell[28165, 735, 162, 3, 70, "Tutorials",
 CellID->659944600]
}, Open  ]],
Cell[CellGroupData[{
Cell[28364, 743, 305, 8, 70, "RelatedLinksSection"],
Cell[28672, 753, 365, 12, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[29074, 770, 318, 9, 70, "MoreAboutSection",
 CellID->31711211],
Cell[29395, 781, 148, 3, 70, "MoreAbout",
 CellID->453173729],
Cell[29546, 786, 151, 3, 70, "MoreAbout",
 CellID->139191420],
Cell[29700, 791, 197, 4, 70, "MoreAbout",
 CellID->946100984]
}, Open  ]],
Cell[29912, 798, 27, 0, 70, "History"],
Cell[29942, 800, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

