(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     58605,       1329]
NotebookOptionsPosition[     54433,       1193]
NotebookOutlinePosition[     55885,       1233]
CellTagsIndexPosition[     55799,       1228]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"The Structure of Graphics" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/TheStructureOfGraphics"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"The Structure of Graphics\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"ViewVector" :> 
          Documentation`HelpLookup["paclet:ref/ViewVector"], "ViewMatrix" :> 
          Documentation`HelpLookup["paclet:ref/ViewMatrix"], 
          "PreserveImageOptions" :> 
          Documentation`HelpLookup["paclet:ref/PreserveImageOptions"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"ViewVector\"\>", 
       2->"\<\"ViewMatrix\"\>", 
       3->"\<\"PreserveImageOptions\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"3D Graphics Options" :> 
          Documentation`HelpLookup["paclet:guide/3DGraphicsOptions"], 
          "Interactive 3D Control" :> 
          Documentation`HelpLookup["paclet:guide/Interactive3DControl"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"3D Graphics Options\"\>", 
       2->"\<\"Interactive 3D Control\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["ViewVertical", "ObjectName"], Cell[BoxData[
     TooltipBox[
      TogglerBox[Dynamic[
        FrontEnd`CurrentValue[
         FrontEnd`EvaluationNotebook[], {
         TaggingRules, "ModificationHighlight"}]], {True->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVVly2zAMDQhxEylSsizLaxJn73KafvQAuUDv/1eApJuosceeTDAWF4B8
eFgk71///HoVV1dXK3p+0wNfIzdCLL4I6p1sYBYuPy3SI2AmRBpuaE/TPRsE
3Isg8mrB9l6ILQhhLkbd93MBuwVxAthdZwPr5wVVzBc8wAvMX8TFqPkqE8q6
rDCsKPjZ/g1guz+PKvLFfGsDU1R4A8zDhgLangX9x/WGM7A1qSQ7rraYkaLf
LHZ5FWY9H7rew/n4/6vWPKT2mXFBaH/NGejzqi/VnFEFJ2Rb1Lo+jtofllPD
RVJjdZLr51Eb/ED1K+QI109LcIg+sdSIWqa5g85L6MiNoRloTws+pdBKiFGl
mx3N0jcAlcsKeFivVkteVOgMSNsC18sYS/iIMdZoK43WSdQVK1SLlYy09bZ2
aEO+aoPiACNak0EBbtfLRIz9KJRcroaSKwE11BprpRHqiJ0BrxtJG4pLYqWc
RZO4BQwSbGT4rFivaLjjQdscjSvlih48Mu+WDisOBcB5ehgeDEZQlikkKh3b
KA1FMTDg9yFxLSe4XC37begHTDh5seS1I/gaW025Yo/yUFbmSalShzon1Kch
JTNn2hKS1hyWVIkf5n2LHEQgt0zeUNTkMaYrDdkMZdo3fJCDHx7hxzAC+8rs
XYBokTPfEJk6JVlZx3Yl0UnTYMPvSUt6zghf8dhIi5VDnwO+Hcb1MHK1msK+
oy5qkYS7wVC3cfiq8ojBcMtFMJXnDiIcLPFJClDFGkJBhXGEZV6VcCQFoey7
tyvBF6lw0uKH6nyQ5fqhrKx/Kxe8+3coucpGN4U5+RYux7vnhGO5P7hKenqz
xSO3ivjisf345fg5Pt1ScCRkkzR1U1Dur+NCec4LZ49Ynx9P04GmOvlnqcKZ
79BfJfcjkg==
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlLlKQ0EYRi/iA9gpWIgvIXbjM1iKWAjW2vgeZnWN+AgWZhEULCxELFyi
ZnfJavbeJOr/33xXcj8CNnY5EA7k3GWYmTuzq+uLa2OWZS38/MYt0DbDHH8Q
8uTB64bRNrmsQkaPRoQSGX1ZqZPR9/eEazL6klIlowf8wiUZ3ecV3snowYDw
SEafUmJk9HmlQh4cX4GM7vUId2T0VFIho28or2T0w5DQIKN3PoUaGX1FaZLR
0ymh6sz7hHLk9PMzoU5Gz6SFmvFsCbd9Xzj9qyc0nfe49xfuTyYUEzoQbmh8
+N8e37HTbVpk9MSzUCajbypFMvq0UiOjzyklMnqvKzRMJCwU+/vjzemTSpns
nh97feJmd0e4cvppTKiQ0bsdoW5ecorZDgpPtD6xqFA2fp+Qp/vtdUj1v797
Oqdwnb2Ov++fUVpk9PCJUCC7n4t5wz5xj9/+rj6ceXbPP86NbEb58/k56qP+
n/0bdGyYqQ==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}], False->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVdd22zAMDUBxSaJm5HgljrPTJN177/nWh35AfqD//1aAVGrrJLbbk+BI
FEmQFxcXlDQ9//3zHNfW1gZ0/6IbbsYOhahvCGrO9qHM/mnhmMMLoKv0RD6V
cPyZHTTcDI5NkYnQq4UQ0BdiAkKYZagl1OOw5fWtcgyvPp7AnefsGG0DBIeA
9RZVrNfcwBasb4nlbP9u4cbc/XD/zXcIgC2qYYazJTQiGSYHS0Hr8Yu5LV/h
ePvR5oMOKswAQ0M8R5OloFMWSNRE+IAVeALv38KX26wAV1uU5Ojv16PQy8q+
gMP+9ABW5C9KbkZi6qv19DGc/ID9b+CrZTjbbVagH3p91oIcL+GZ6JDNUet4
HpWUXxx5BaWZxRh1FQgH6JqoKcarF/2/dblez7IE0XmWGlFL/6ygchIqCmPo
CTSmDq9SaCUUhfI7K3pKlwJESZiAveHGxoA7ESYGpM2B62WMJXzEoojRRhpt
IlFHPKFyjGRBQ2fjBG0WttpMcYIFWhNAAXaHA0+M4yiUXK6UxJWAGmKNsdII
cYGVAadTSQPKS2KkEovGc8swk2ALhg8Tww1qdrjRNmSTtOUqHDhk3jktVpwK
QOLoZngwWICyTMFTqdhHMrQTDQPeazzXdgWXK+e4KV3AhH0US1Ergo8x16QV
R5QXZWWeJJW6qLNHPWq8mEFpS0hac1pSeX4YxjlyEhmFZfKGsqaIhd+Sks+Q
0i7lhZx8cwYPmx5wrMA+yaCwyMqnRCb2IiubsF9JTKRJMeX3JKd5VoS3OEyl
xShBFxLebXrDpsfVSlv2FZ2iHMn4NBg6bZy+ihxiZvjIFWAixyeIcLDNT1KC
qogha1Gh14NB6LXpSEpC2bm3y8O3FmHniF9U55INhnttz7pZuWDu79BqFZxJ
F2bhWzjo7Zx6HMvng6ukuztzvGJXa66NmF/+crzrHe1ScmTkk/SouqB8vq42
0jl0EnuF9/RsMR1Io4U/S5Wt+A79AaDyK/w=
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlUtrE1EYhgfxBwguFBTEvyAiFhfzHxRFvC0E17rQhYLiT7D3u/gTXNg2
3sBFFyIutE1qm17UZJKZZJK0KFjBtur7Td4jnhe7dTMPhAfyQObMnO9Mjl69
fvraniAI7v/+7A3IRri7/8VGWJwHVTH72qohZp+ZBnUx+yWjJWYfHwNvxOwX
jKaYfXAAzIrZ+/tARcw+NAhKYvaTRiJmP2gUxH+vLxKzl5cMMXtfL3gvZn84
Cdpi9hvGJzH7yxegJWa/YnTE7Mtl0HTPfZ/xyPWVZZCGvQ/Au65fSV9aNMLJ
CfDW9a0fIBWz/9wBHbcOf/74PX83W99j128ZNTH71BMQidmfFkAiZj9irIvZ
Fz+AWMx+yEjF7KeMVOw/32x/iuHoCHjt+s42aIfTU6DWna/Prm9vgVb4cc0I
h4fAgusZ62L2A0YsZj9h1MX+9bN9LHfP75zrZ42a2L9/3+wXjVTM7q8jm9NE
5q8wA+JwoB/8eX+eNxIx+00jErP3GA2xvy7uG88R+z2jI2Y/bLTE/v1l76WG
mxP/+r7ZN7+Bupj9mFERsz9/Bppi9myeEzH7QgnUxOy3jYaY/a7RFrNfNtpi
9nNGXcw+NgoaYnbOk2///PJ/bXXFcP37JojF7CPDIBazf/0CKmL2+TlQEbPf
MZpi9olxkIrZS0UQidn3G1Ux+3EjErOfMapi9mBX8p73vOc973n/P/0XnFJ2
Rg==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}]}, "\"\<Click me\>\""],
      "Toggle changes in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["ViewVertical",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/ViewVertical"]], "InlineFormula"],
     "\[LineSeparator]is an option for ",
     Cell[BoxData[
      ButtonBox["Graphics3D",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Graphics3D"]], "InlineFormula"],
     " and related functions which specifies what direction in scaled \
coordinates should be vertical in the final image. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->193]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The default setting is ",
 Cell[BoxData[
  RowBox[{"ViewVertical", "->", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "1"}], "}"}]}]], "InlineFormula"],
 ", which specifies that the ",
 Cell[BoxData[
  StyleBox["z", "TI"]], "InlineFormula"],
 " axis in your original coordinate system should end up vertical in the \
final image. "
}], "Notes",
 CellID->25538],

Cell[TextData[{
 "The setting for ",
 Cell[BoxData[
  ButtonBox["ViewVertical",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ViewVertical"]], "InlineFormula"],
 " is given in scaled coordinates, which run from ",
 Cell[BoxData["0"], "InlineFormula"],
 " to ",
 Cell[BoxData["1"], "InlineFormula"],
 " across each dimension of the bounding box. "
}], "Notes",
 CellID->30195],

Cell[TextData[{
 "Only the direction of the vector specified by ",
 Cell[BoxData[
  ButtonBox["ViewVertical",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ViewVertical"]], "InlineFormula"],
 " is important; its magnitude is irrelevant. "
}], "Notes",
 CellID->9971],

Cell[TextData[{
 "Changing ",
 Cell[BoxData[
  ButtonBox["ViewVertical",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ViewVertical"]], "InlineFormula"],
 " has the effect of tipping a simulated camera. "
}], "Notes",
 CellID->20907],

Cell[TextData[{
 "Explicit settings for ",
 Cell[BoxData[
  ButtonBox["ViewMatrix",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ViewMatrix"]], "InlineFormula"],
 " override settings for ",
 Cell[BoxData[
  ButtonBox["ViewVertical",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ViewVertical"]], "InlineFormula"],
 ". "
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->31497]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->447025225],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->151682156],

Cell[TextData[{
 "By default, ",
 Cell[BoxData[
  FormBox["z", TraditionalForm]], "InlineMath"],
 "-axis direction as the vertical direction in the final image:"
}], "ExampleText",
 CellID->437805468],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"Cylinder", "[", "]"}], ",", 
   RowBox[{"ViewVertical", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "1"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->119194694],

Cell[BoxData[
 Graphics3DBox[CylinderBox[{{0, 0, -1}, {0, 0, 1}}],
  ViewVertical->{0, 0, 1}]], "Output",
 ImageSize->{104, 108},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->242812741,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->13839727],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 "-axis direction as the vertical direction in the final image:"
}], "ExampleText",
 CellID->492828696],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"Cylinder", "[", "]"}], ",", 
   RowBox[{"ViewVertical", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"1", ",", "0", ",", "0"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->18642276],

Cell[BoxData[
 Graphics3DBox[CylinderBox[{{0, 0, -1}, {0, 0, 1}}],
  ViewVertical->{1, 0, 0}]], "Output",
 ImageSize->{104, 100},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->424476745,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->186679887],

Cell["Various view vertical directions:", "ExampleText",
 CellID->133718463],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Graphics3D", "[", 
    RowBox[{
     RowBox[{"Cylinder", "[", "]"}], ",", 
     RowBox[{"ViewVertical", "\[Rule]", "v"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"v", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "0", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{".5", ",", "0", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", 
         RowBox[{"-", ".5"}], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", 
         RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "}"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->105404779],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   Graphics3DBox[CylinderBox[{{0, 0, -1}, {0, 0, 1}}],
    ViewVertical->{1, 0, 1},
    ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]], ",", 
   Graphics3DBox[CylinderBox[{{0, 0, -1}, {0, 0, 1}}],
    ViewVertical->{0.5, 0, 1},
    ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]], ",", 
   Graphics3DBox[CylinderBox[{{0, 0, -1}, {0, 0, 1}}],
    ViewVertical->{0, -0.5, 1},
    ImageCache->GraphicsData["CompressedBitmap", "\<\
eJyVW/l/VcUVvyQvGyQYLCKoCMqiCPNeEkjCIoJLocUmgOyKYMh9kLDv+75D
CDth3yEkamttCxYt0lW6t1Yp1lpkX37rP8CnnTln7ty5Z+behHzIzbvvzXLO
+Z7le+ZdSsrmViSnlc2tLC9rP3B22cyKyvI57QfMmM3fSm3iOE6S/5a3dvjr
//FX8Jt88OCB43Tm15RkMtkX7jqJayq/5X/51RGf9IFPOoprBn6CP/6o3jCi
gzZXvEyh9/xlT+vIVHFJI2s7xTD2WTI2ZtlFrFwIo58hn6bbdtLuC2BWe/Ju
RgN75sOsduTdLMssIRmOfpp82rQBSeMwqy15N9syS+yBo5+yjhboJwX+8JLu
0xVmPmmxQLqYkv7XQTM+f30q/+TK4Iqvhya/GebGxEpyX5z9BJmdxi9iL6fF
+b7LftFvyS9fXvSbVxd89t25fxw4+y/fn/n3QdP42MullV8NmfTvN9z/DHev
jXRvjHZvveneGes6KXwi9Z3nYZ82FjRhn1bvF6/9ca/VP+uz8qO+yz95aemn
/Rf/+pWFv3tt3u8HzPnT92aZOlwd4V4f5d4c495+y73ztntvvJviSLVweblj
a5u3iZFtj+RtPlGwsbbH+neL1v6o55qf9F519sUV519adsFT91Ij1L091r07
zr33jnuv3OWLPpBR8hzs/Tg4kR4VsHO73Ymt+xLVh/OqjudvOt19Q33huh8W
r/G177f04sNrf6/Mve8KEQzLQ9w7rcT1OV0WPnRTfOfW+I6d8W17E9UHE1uO
5m8+2X3jmR7r3yta+0HP1dwi54RFll7ovxgsMj/CIt+aFpng3k+6dya5KsJR
kscoIkLojmvYng3xXVviO7bHt+9JbN2f2CLsU7DpdI8N9UXCPh8K+6z4ed9l
n/RbcrH/ImWfPwft86+hE0373EX7lLt3J7rSSXQJIOc4LSGY/HcdZwHbt5Tt
XcX2rGe7NwtTbd+VQFNVSVMVrn+vWJjqp71Xnntx+cfSVAt/GzTVFz+YwpcF
UyVDTeWCqbTIRKm+I67ddKlmsgPz2P7FbO8KVrOW7d4Y31Ud37Ejvq0msfVA
Ygt49abaHhvelVZbhVbjQXzxZW61BdFWuwZWu6VZjTv2vYnurQo3jVgN8qHz
KKQ6Xb4Kdmg6OziH7V/I9i1jNauF+XZVxXdui29Hxz+UqDqWv+lU9w11hevf
N8z3K2q+6ab5ro92bxrmuwvmS5PWQ+laiGtCl66MHZnIDk9lB2exA/PZviVs
70q2Zx3bzUOhGkKhJlHtmRGTwzqeHLgZzxpm/EOkGW+MgXSomzHp3q5wjdoE
mdvJFdd8XdIx7Nh4dtRlhyezQzPYwbls/yK2bzmrsUcKZJK6wnWYR7lBP1IG
faVxBtWTCRp0ovvtZFNeqBXOI+JaoMs7nJ0YxY6NZUcnsCPcB6axg7PZARVC
62gIQbYpENnGz799VpzXTPxZgyb2Ko5KwdzEdyrcTOkDKGlzce2hSzqUnRzG
Toxkx99kx94Bf5jCDplhtQXCiiYjZeI+0sSfRpr4a2ViW77mJr5e6WYE5M0R
10Jd3hJ2egg79QY7MYIdH82OjQOvqAwPs12JrTRL6SXOM7Go6NEmHmmYWOX0
9GBt4y/a+NIXEekHs1Pc5sPB5uggk4wYXBuIQT+Voc31Aunb/LVIm1trJGaz
StfGQvV7qJfIv4qD2tRyhUpBIeVE49mRpIzTAxCne1WcVkGcBhOfROQDQORc
Q4j8UyFi5R2qdNCqRu9Ro2bi2ofwgBJ2BvXS3extdrQ8MpKNZKlXap/HNQDU
MAoUyZfoXEYWAhaBHNzUpk4ppHveW+xomYx29DwZ7Wu8aDeAEhVKK/CCHfpk
OAQoTocigOJFSuRU2mkA9zDeBZ8sJhpx1xsCrsdRUiWiUisRXjIQKG0L5ltV
0hQziEDpHxpK32goUXIAKTdEo0xrlHka1TkpXC2nh+Z7HKrjo8D3SBXRkoTk
O3piNslEI6Gyc/kJfm6megEfM7wRYq0X6FWPqoV4IK03mCpWy1Sh41WF9VGn
IB7/teH1+jSC11WCl1ciZf6260V7S8iSva16lQrEfD8kRUnPFpjWFUM9nLdZ
lNIgWwHEll7wO02J2N8GTTcR8wm0UU1vmogBQ3Uoe4X7mPJE/k/3xcHSFzmj
MQtWVNpQLRSSmg97S97ImxZsaTXQZlhBkwzcVnTpiQOwW+NsIz0QY/Uixuqc
IuKPOv9JahQTyYTe8gSzvKJAaxRuH/sNosJtZhhulGh6FZkneoobakerWIZN
u2KrVyJV0msYkg2d4IXVZkVIJeeXDef8SwM4drModkOTlPYbWf+qJesD5zeY
R6aZI9E3C4lvIpkqC0sojCQUWqZ1DhsEcPZDARheA1A//UymKY26egM/6Z0j
JLGyZJWVwayi6gAp2YTtIn7iQCUav5BScK3S1A96IGS8MY9FmTrVlmq8StU2
az5BvqgaZVIEfA6sHTXgsVzjMQvUbV4HaE5pjlHH3wCmmAoqBP2wKKywRSYS
v7eWvZRXAPyTpgBU83yoBj0cVDfMGtBceqJWsflLiLRYCTvRGG8cY2QTnZVE
VgJVvjVSLJCbL5AbGImcjRfftyOXY0Sbd5KUIZE8o+fMnso/Ne4lO3h1SEJy
Cu8wJamEI0MsCnpfTJiyfuJEsLwSgaV3AIHnThRLU084reavYw/hsdi14emK
6qNNyoLJxSwOPhvTDgDscA4JgTPYvlE0sw0tvVONFOm1p4Je29PaIZA+zpZv
9BMDrUZQcvYweGqM+s44rc5DQ0c1bWatEmKA4bNdrD4bbO1EHVSNEMk/llLh
oXnWQPNSEE0413eafyXgDBzp3DLg5OX+2mTDb5tZq30wy9aLl3XOC2FsTa+H
0RkIawc2fH6994i2FUsuFMfycmklaJptwdIo+RTLppE6npZxCTr2ivBXvT7i
oZyef3RSqtUSStv8PsnDkkuEWH5ZMplHJi8n/B39pMjC3KCcGJXfrme2Lc8y
3WcHB31Wr5leBqrx6I1sc0lB0amAT980OLk4emhyOPFID/23KeIZRgconlmN
0hPwfNb0Wa1qHjY5eDD/+E2Gj6dG41QLhVqQ2AQ8K9WBNozJsjNxKClG7cx8
YOs1KAMCPfNIr6F4neoTzRwUVlEUQSDUjouAdNxMtZdLJ18JHgiCthmN4wh2
Pa1+WxDmt6pp9Gi5SkOBtoqUFE4RdLrHIeX7I6TWdPtlyRSEVJ0RIksAbdN9
SL3ukWqa0ShNAdHukZ4rKqctE/ntcbCqeIhCVeE7qwgNQXQqQVTn6xizaQ2d
HkbrGvDewqD3iq4ETtz8TlJn8Eu14lLtFRf9NFERP74tLy56oNpQnfZFEFWT
+6HGqX5PaX3KwjjzELqC18b0gyr+Tq3T0XRfJH6VlozkH8MFKgywBc79+IY+
lQ82zohrrvj+HTTA00OVQ+nJk1UDwzPbWDsRvUZO8Tm6JdfotQPlygjyOtFz
cbigfc39/L/wfIIYR60eLXPAw542PMxS71Q7v0Q7SsPWV5UCvo862cXSLqR8
nEvpPREDaZ7IFLNKmhPuH20Iy8IzdVWxFGMOxr3M5HyHQ1qTDs8yPCUkjOHD
ICgkPQWHSDVOJK0e0NrqAXiKoBivNV4xC/PlMV6Fydp5tpM7CqStz1eFyhZA
upWSzWDjokLoRJWH2GL1pRiQOL42DzFhrw5CqjQlFVrNOIlOCZfL7OBbktpF
krqil2boiP6Ki9KJWuoB9l7Wbw0NWa1I5hK+q/OGsiAPxLjAPMJl4LIIcToT
mbzunub9JpEyBRDMDeunVKuhgoDbSdqmC5HDe+JC2KIJ/yv2j5DB7Fxzw9BS
iU41dkl4DK4rkUDUv1SvMzZ2zbGhkWOiQbIU912xGyN7ZUltUUP6PZDVytkR
TAopBl8gbtknaE3rXjHVVUlrwnlHltWW8jHChMV6yo+MXazWywpaT2oUsb6Z
YcL2CVgu3fQMIWleiAciN6DZ1rNTrWmnmFKCDy8gq1q/VzFWt9onpuzTiHUz
GrGutAfe1wor01W9bNA0fDXDBrAeHySWouvRng/XtZ7F0c4hFaNULJjfwKrN
GrFqnUMzYZ5WYfFHjGgevlYaas7fFULynwJrzcm1rgDrxmBuHU7Pt87G76us
53g4W6jjzSZV+FHrXLBOGt6jBkJ2oj3/uKV1Ntynq/sSdhIXSBjzH7PO984b
0V9963eTPNE7sRO6a8+WRDwRTVfqakjS2rqO9btbbZ0XDMbVxrpO6Delcp3n
DXmetK5DK24mWaeTx6TJOHy+K1tD1feeZmSNDtoaAoW2/lz51BVqmk3mPSPn
URn9+WK1R8isp+UsaiF8ilLEkNg0h8x6Qs7y8i8+sdpCjhb+lCIZu+25dRwt
fE8YI0OObsFHCwhoBoP/RQAWFKPFjiIAU/noTPLct1fPOsGMdnJGiwZ8Ckd3
lKNzGkC8M4zuIkdnaqjgj9i/C4yJyzGpwTFJ78n77vwqgrQb3DlN/g+L/k3h
\
\>"]], ",", 
   Graphics3DBox[CylinderBox[{{0, 0, -1}, {0, 0, 1}}],
    ViewVertical->{0, -1, 1},
    ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]}], "}"}]], "Output",
 ImageSize->{452, 110},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->479564170]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->10379],

Cell["Orient a 3D rendering of a 2D cellular-automaton evolution:", \
"ExampleText",
 CellID->1974],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"Cuboid", "/@", 
    RowBox[{"Position", "[", 
     RowBox[{
      RowBox[{"CellularAutomaton", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"2", ",", " ", 
          RowBox[{"{", 
           RowBox[{"2", ",", " ", "1"}], "}"}], ",", " ", 
          RowBox[{"{", 
           RowBox[{"1", ",", " ", "1"}], "}"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"{", "1", "}"}], "}"}], ",", "0"}], "}"}], ",", "12"}], 
       "]"}], ",", "1"}], "]"}]}], ",", 
   RowBox[{"ViewVertical", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "1"}], ",", "0", ",", "0"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1390],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 130},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->124900769]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->7146],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["ViewVector",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ViewVector"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ViewMatrix",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ViewMatrix"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PreserveImageOptions",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PreserveImageOptions"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->27046]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->6735],

Cell[TextData[ButtonBox["The Structure of Graphics",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/TheStructureOfGraphics"]], "Tutorials",
 CellID->659944600]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["Demonstrations with ViewVertical",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=ViewVertical"], 
    None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->160213531],

Cell[TextData[ButtonBox["3D Graphics Options",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/3DGraphicsOptions"]], "MoreAbout",
 CellID->1543892],

Cell[TextData[ButtonBox["Interactive 3D Control",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Interactive3DControl"]], "MoreAbout",
 CellID->78511002]
}, Open  ]],

Cell["New in 2  |  Last modified in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ViewVertical - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 29, 19.6020992}", "context" -> "System`", 
    "keywords" -> {
     "orientation of 3D object", "rotation in 3D", 
      "rotation of three-dimensional object", "up direction", 
      "vertical direction"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "ViewVertical is an option for Graphics3D and related functions which \
specifies what direction in scaled coordinates should be vertical in the \
final image. ", "synonyms" -> {"view vertical"}, "title" -> "ViewVertical", 
    "type" -> "Symbol", "uri" -> "ref/ViewVertical"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[9976, 275, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->447025225]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 55656, 1221}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2168, 53, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2791, 80, 4196, 83, 70, "ObjectNameGrid"],
Cell[6990, 165, 671, 19, 70, "Usage",
 CellID->193]
}, Open  ]],
Cell[CellGroupData[{
Cell[7698, 189, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[8176, 206, 383, 12, 70, "Notes",
 CellID->25538],
Cell[8562, 220, 378, 12, 70, "Notes",
 CellID->30195],
Cell[8943, 234, 269, 8, 70, "Notes",
 CellID->9971],
Cell[9215, 244, 236, 8, 70, "Notes",
 CellID->20907],
Cell[9454, 254, 485, 16, 70, "Notes",
 CellID->31497]
}, Closed]],
Cell[CellGroupData[{
Cell[9976, 275, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->447025225],
Cell[CellGroupData[{
Cell[10361, 289, 148, 5, 70, "ExampleSection",
 CellID->151682156],
Cell[10512, 296, 200, 6, 70, "ExampleText",
 CellID->437805468],
Cell[CellGroupData[{
Cell[10737, 306, 262, 8, 28, "Input",
 CellID->119194694],
Cell[11002, 316, 4827, 84, 129, 105, 2, "CachedBoxData", "BoxData", "Output",
 CellID->242812741]
}, Open  ]],
Cell[15844, 403, 124, 3, 70, "ExampleDelimiter",
 CellID->13839727],
Cell[15971, 408, 192, 6, 70, "ExampleText",
 CellID->492828696],
Cell[CellGroupData[{
Cell[16188, 418, 261, 8, 70, "Input",
 CellID->18642276],
Cell[16452, 428, 6299, 108, 121, 105, 2, "CachedBoxData", "BoxData", "Output",
 
 CellID->424476745]
}, Open  ]],
Cell[22766, 539, 125, 3, 70, "ExampleDelimiter",
 CellID->186679887],
Cell[22894, 544, 76, 1, 70, "ExampleText",
 CellID->133718463],
Cell[CellGroupData[{
Cell[22995, 549, 708, 23, 70, "Input",
 CellID->105404779],
Cell[23706, 574, 21307, 362, 131, "Output",
 CellID->479564170]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[45062, 942, 223, 7, 70, "ExampleSection",
 CellID->10379],
Cell[45288, 951, 99, 2, 70, "ExampleText",
 CellID->1974],
Cell[CellGroupData[{
Cell[45412, 957, 773, 24, 70, "Input",
 CellID->1390],
Cell[46188, 983, 5158, 89, 70, "Output",
 Evaluatable->False,
 CellID->124900769]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[51407, 1079, 310, 9, 70, "SeeAlsoSection",
 CellID->7146],
Cell[51720, 1090, 728, 26, 70, "SeeAlso",
 CellID->27046]
}, Open  ]],
Cell[CellGroupData[{
Cell[52485, 1121, 313, 9, 70, "TutorialsSection",
 CellID->6735],
Cell[52801, 1132, 162, 3, 70, "Tutorials",
 CellID->659944600]
}, Open  ]],
Cell[CellGroupData[{
Cell[53000, 1140, 305, 8, 70, "RelatedLinksSection"],
Cell[53308, 1150, 369, 12, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[53714, 1167, 319, 9, 70, "MoreAboutSection",
 CellID->160213531],
Cell[54036, 1178, 146, 3, 70, "MoreAbout",
 CellID->1543892],
Cell[54185, 1183, 153, 3, 70, "MoreAbout",
 CellID->78511002]
}, Open  ]],
Cell[54353, 1189, 50, 0, 70, "History"],
Cell[54406, 1191, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

