(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    139338,       3151]
NotebookOptionsPosition[    131600,       2879]
NotebookOutlinePosition[    132971,       2916]
CellTagsIndexPosition[    132884,       2911]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Continuous Distributions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ContinuousDistributions"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Continuous Distributions\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"ExtremeValueDistribution" :> 
          Documentation`HelpLookup["paclet:ref/ExtremeValueDistribution"], 
          "GumbelDistribution" :> 
          Documentation`HelpLookup["paclet:ref/GumbelDistribution"]}, #, 2]& ,
         Evaluator -> Automatic], {1->"\<\"ExtremeValueDistribution\"\>", 
       2->"\<\"GumbelDistribution\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Continuous Statistical Distributions" :> 
          Documentation`HelpLookup[
           "paclet:guide/ContinuousStatisticalDistributions"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Continuous Statistical Distributions\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["WeibullDistribution", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["WeibullDistribution",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/WeibullDistribution"], "[", 
       RowBox[{
        StyleBox["\[Alpha]", "TR"], ",", 
        StyleBox["\[Beta]", "TR"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]represents a Weibull distribution with shape parameter \
",
     Cell[BoxData[
      StyleBox["\[Alpha]", "TR"]], "InlineFormula"],
     " and scale parameter ",
     Cell[BoxData[
      StyleBox["\[Beta]", "TR"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->28168]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The probability density for value ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " in a Weibull distribution is proportional to ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["x", 
     RowBox[{"\[Alpha]", "-", "1"}]], 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"-", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"x", "/", "\[Beta]"}], ")"}], "\[Alpha]"]}]]}], 
   TraditionalForm]], "InlineMath"],
 " for ",
 Cell[BoxData[
  FormBox[
   RowBox[{"x", ">", "0"}], TraditionalForm]], "InlineMath"],
 ", and is zero for ",
 Cell[BoxData[
  FormBox[
   RowBox[{"x", "<", "0"}], TraditionalForm]], "InlineMath"],
 ".",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->1495,
  ButtonNote->"1495"]
}], "Notes",
 CellID->429991538],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["WeibullDistribution",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/WeibullDistribution"]], "InlineFormula"],
 " allows ",
 Cell[BoxData[
  StyleBox["\[Alpha]", "TR"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  StyleBox["\[Beta]", "TR"]], "InlineFormula"],
 " be any positive real numbers."
}], "Notes",
 CellID->655],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["WeibullDistribution",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/WeibullDistribution"]], "InlineFormula"],
 " can be used with such functions as ",
 Cell[BoxData[
  ButtonBox["Mean",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Mean"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["CDF",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CDF"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["RandomReal",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RandomReal"]], "InlineFormula"],
 ".",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->25587,
  ButtonNote->"25587"]
}], "Notes",
 CellID->33143606]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1998831],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->261423698],

Cell[TextData[{
 "The mean and variance of a Weibull distribution depend on the ",
 Cell[BoxData[
  ButtonBox["Gamma",
   BaseStyle->"FunctionLink",
   ButtonData->"paclet:ref/Gamma"]], "InlineFormula"],
 " function:"
}], "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->25587],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Mean", "[", 
  RowBox[{"WeibullDistribution", "[", 
   RowBox[{"\[Alpha]", ",", "\[Beta]"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->31417],

Cell[BoxData[
 RowBox[{"\[Beta]", " ", 
  RowBox[{"Gamma", "[", 
   RowBox[{"1", "+", 
    FractionBox["1", "\[Alpha]"]}], "]"}]}]], "Output",
 ImageSize->{94, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->178202048]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Variance", "[", 
  RowBox[{"WeibullDistribution", "[", 
   RowBox[{"\[Alpha]", ",", "\[Beta]"}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->6153],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["\[Beta]", "2"], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", 
     SuperscriptBox[
      RowBox[{"Gamma", "[", 
       RowBox[{"1", "+", 
        FractionBox["1", "\[Alpha]"]}], "]"}], "2"]}], "+", 
    RowBox[{"Gamma", "[", 
     RowBox[{"1", "+", 
      FractionBox["2", "\[Alpha]"]}], "]"}]}], ")"}]}]], "Output",
 ImageSize->{219, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->150014838]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->20595],

Cell["Probability density function:", "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->1495],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PDF", "[", 
  RowBox[{
   RowBox[{"WeibullDistribution", "[", 
    RowBox[{"\[Alpha]", ",", "\[Beta]"}], "]"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->29213],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{"-", 
    SuperscriptBox[
     RowBox[{"(", 
      FractionBox["x", "\[Beta]"], ")"}], "\[Alpha]"]}]], " ", 
  SuperscriptBox["x", 
   RowBox[{
    RowBox[{"-", "1"}], "+", "\[Alpha]"}]], " ", "\[Alpha]", " ", 
  SuperscriptBox["\[Beta]", 
   RowBox[{"-", "\[Alpha]"}]]}]], "Output",
 ImageSize->{101, 23},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->211639360]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"PDF", "[", 
    RowBox[{
     RowBox[{"WeibullDistribution", "[", 
      RowBox[{"1", ",", "1"}], "]"}], ",", "x"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->27370],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwVzns803scx3H3xKrNOhJl0/FIVunqODun+nyj00mbnQ4T042tKDnKOiP9
IkdOzpyzOOJYcxld6DZS6eS249JqLiOtdKGH6ziRRnIqyc63P96P9+P538uJ
f8h3n4mRkREH7/PnxvMtVu0lNizK82gwGPRwV0tnB9B5oCR2soTjejDcU56k
0w/A0n2UipcDesitkdDM6bFwxE3oP6jRQ8R60U/vaGL4odqVszBHD9qP+zNG
aWdh/qYKmZCphxkdvS4jtMvACdSGlMW8hoJGedQwrRxK/Jzs15qMQHGJuCPC
rREqhemehXOHIAzazr4SaqHawEpi5g5CpM6171bxM3hieYW5KkIHVk5JLl1f
d0OSPmnad3MfnCY3MQqC+4CUfybCKKYH+B3cf0ybBwCdKs2uFXRBlCqJf8hl
CDL/3k+K8uqE0sMkPzvvEaCzMwNe5z+DAuLg0MqAUWiXjpUJSE8gUT7149tX
YzAQpI3TdT0CI203qjo2DlF29XHcsYew+OfQo1zGBPQ8p7J3kNqgfyJru3X1
f6C0YLYFDbbAVl14XHrUe2jODVudeb8JOP1pSx0dJyFmgU+ek3kDDNXzE9SK
j1DinuOmKL0HbpT2hV57PoFDdHn4xvC7YAUTIZ3j01Bc9SnyenwdfD8S9G6R
vxH6d8DxC7u8Gnhat9c4aJkx2mx97XHscDWU/XZ3N33CGMV/aZjrQa+EUHNR
d0uLCXq7VaufEtwBgZAoI8lMUcaJwG12trdhRdjSFnaIGWJcuuoxPPMWtNos
sxYxzdFadbnCxvIGVBYnZi8ztUBb2kuO2QZcB8KYsa35hQVa40BKsd+jAKvO
Y1sib81AL1ODn08Kr4Cu0ClDftwSdTNatx6aKoKMJfPNyv1notJzwf3a9IuQ
Jgu9H0K3QiY5Os3xlPMQlLGrhTRohXylviqTqgJ4v+niB7nSGlmSeY8evZJD
n87zaF0yCXGfbJFwR3Pg3PpVDpqQWUihfTxvkZkMFL+KKGHLZyNxjI/shSQL
kv0FLNOJ2WiqPobZvysT3DsLLidr5qCy5Dsn6MwzIHXNVmhYZET+pep3Zfif
cKJGImWVk1F1PG3lSp9U8HHwv9joTEGyGxWzzrv9ARsj7++giCnomzg7Yb5E
DPIFfOfmCQo63Mn97tzkKXCuL/qLs8MG0Slid1FrEqQtr2M8VNogx+ueOba9
iRA6btbWwKAilWpOb+B0AvBL39DFqVS0OrDJJVITD+pGy5NVU1Tko/Iu0pQQ
EOHVk9aAraJfZR/BJleV57Vj5/PWjNthByrCK0axRdw7XnuLCRhMbR5z/kRF
+8wz3kxeI8DCPy1Ygp1glZq85AoBXl3zNuyepiL+9tjTSRcIGAgYZR3EVtqW
BDKwUx6oeUexN62zdn5wnoCHtbGidOz+oq+UDtj8Cx3X7mHzpDyjmwUEJByQ
O6wwUFFDZnNlTx4Bzr0xruuwPw6ESpOx1UHbPLyxeSEu0cuxyWxjPwF2Vp29
e2wuAXI3QUoWNqOlsYacQ4Bn0bfSC9j1hszC29m4jza3sBQ7cV2yZCe2G0VV
24QtVnfsviTDfeLc1qfYfmTw5mBHm0S/0GGzuOq1b88SYE9wht9g30yLcZJh
K8cXfzBgN9Wy5yDs/wEsKk4W
     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  ImageMargins->0.,
  ImageSize->{225, Automatic},
  Method->{},
  PlotRange->{{0, 5}, {0., 0.9999998979591889}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{229, 148},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->656989588]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->22496],

Cell["\<\
Generate a set of pseudorandom numbers that are Weibull distributed:\
\>", "ExampleText",
 CellID->24833],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RandomReal", "[", 
  RowBox[{
   RowBox[{"WeibullDistribution", "[", 
    RowBox[{"1", ",", "1"}], "]"}], ",", "5"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->24223],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "3.1805704734343303`", ",", "0.9074774235917996`", ",", 
   "2.683010564857773`", ",", "0.41319638521203195`", ",", 
   "1.670157164991176`"}], "}"}]], "Output",
 ImageSize->{322, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->12777045]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->17879],

Cell["Properties based on higher order moments:", "ExampleText",
 CellID->20699375],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Skewness", "[", 
  RowBox[{"WeibullDistribution", "[", 
   RowBox[{"\[Alpha]", ",", "\[Beta]"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->30519],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{"2", " ", 
    SuperscriptBox[
     RowBox[{"Gamma", "[", 
      RowBox[{"1", "+", 
       FractionBox["1", "\[Alpha]"]}], "]"}], "3"]}], "-", 
   RowBox[{"3", " ", 
    RowBox[{"Gamma", "[", 
     RowBox[{"1", "+", 
      FractionBox["1", "\[Alpha]"]}], "]"}], " ", 
    RowBox[{"Gamma", "[", 
     RowBox[{"1", "+", 
      FractionBox["2", "\[Alpha]"]}], "]"}]}], "+", 
   RowBox[{"Gamma", "[", 
    RowBox[{"1", "+", 
     FractionBox["3", "\[Alpha]"]}], "]"}]}], 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", 
      SuperscriptBox[
       RowBox[{"Gamma", "[", 
        RowBox[{"1", "+", 
         FractionBox["1", "\[Alpha]"]}], "]"}], "2"]}], "+", 
     RowBox[{"Gamma", "[", 
      RowBox[{"1", "+", 
       FractionBox["2", "\[Alpha]"]}], "]"}]}], ")"}], 
   RowBox[{"3", "/", "2"}]]]], "Output",
 ImageSize->{377, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->100914601]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Kurtosis", "[", 
  RowBox[{"WeibullDistribution", "[", 
   RowBox[{"\[Alpha]", ",", "\[Beta]"}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->31585],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "3"}], " ", 
     SuperscriptBox[
      RowBox[{"Gamma", "[", 
       RowBox[{"1", "+", 
        FractionBox["1", "\[Alpha]"]}], "]"}], "4"]}], "+", 
    RowBox[{"6", " ", 
     SuperscriptBox[
      RowBox[{"Gamma", "[", 
       RowBox[{"1", "+", 
        FractionBox["1", "\[Alpha]"]}], "]"}], "2"], " ", 
     RowBox[{"Gamma", "[", 
      RowBox[{"1", "+", 
       FractionBox["2", "\[Alpha]"]}], "]"}]}], "-", 
    RowBox[{"4", " ", 
     RowBox[{"Gamma", "[", 
      RowBox[{"1", "+", 
       FractionBox["1", "\[Alpha]"]}], "]"}], " ", 
     RowBox[{"Gamma", "[", 
      RowBox[{"1", "+", 
       FractionBox["3", "\[Alpha]"]}], "]"}]}], "+", 
    RowBox[{"Gamma", "[", 
     RowBox[{"1", "+", 
      FractionBox["4", "\[Alpha]"]}], "]"}]}], ")"}], "/", 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", 
      SuperscriptBox[
       RowBox[{"Gamma", "[", 
        RowBox[{"1", "+", 
         FractionBox["1", "\[Alpha]"]}], "]"}], "2"]}], "+", 
     RowBox[{"Gamma", "[", 
      RowBox[{"1", "+", 
       FractionBox["2", "\[Alpha]"]}], "]"}]}], ")"}], "2"]}]], "Output",
 ImageSize->{518, 63},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->118737442]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->31371],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  StyleBox["q", "TI"]], "InlineFormula"],
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
 " quantile of a Weibull distribution:"
}], "ExampleText",
 CellID->15444],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Quantile", "[", 
  RowBox[{
   RowBox[{"WeibullDistribution", "[", 
    RowBox[{"\[Alpha]", ",", "\[Beta]"}], "]"}], ",", "q"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->17107],

Cell[BoxData[
 RowBox[{"\[Beta]", " ", 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{"-", 
     RowBox[{"Log", "[", 
      RowBox[{"1", "-", "q"}], "]"}]}], ")"}], 
   FractionBox["1", "\[Alpha]"]]}]], "Output",
 ImageSize->{106, 22},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->40377227]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->16519],

Cell["\<\
Plot the cumulative distribution function of a Weibull distribution:\
\>", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->13370],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"CDF", "[", 
    RowBox[{
     RowBox[{"WeibullDistribution", "[", 
      RowBox[{"2", ",", "5"}], "]"}], ",", "x"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->26124],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{225, 150},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->87336137]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->112332000],

Cell[TextData[{
 "A contour plot as both ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  StyleBox["\[Alpha]", "TR"]], "InlineFormula"],
 " are varied:"
}], "ExampleText",
 CellID->2435],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContourPlot", "[", 
  RowBox[{
   RowBox[{"CDF", "[", 
    RowBox[{
     RowBox[{"WeibullDistribution", "[", 
      RowBox[{"\[Alpha]", ",", "1"}], "]"}], ",", "x"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Alpha]", ",", 
     RowBox[{"1", "/", "10"}], ",", "3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1028],

Cell[BoxData[
 GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJxkXQdcjd8bv+0hZcvOTvYe4XnJFhHZRGZGyEiSUQgJZfxESEZkR4mMSlOh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   "], {{{}, 
     {RGBColor[0.33397672886243995`, 0.1279285534584573, 0.5864250111696041], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNl2lsVVUQx897vL7l3ssWoMhSKBjQhIqyJkYhErYYtWpZXMAgoJKo0c8S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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwllNlLlWEQxt/jOcfzbWmrpS0qUV0ULRBB0EVBIRG02A6JqdVNUf+BWWCp
aFGZ2k5l+25kWriVGlRoCdVNXXQRCUWXCdH2G56LB2a+53ln5p1v5s0v3Ve4
N805tw0kwKnIudNgEOcMRFEIB+bFnHvBt0/YjSnn/qJdn3RuP9qbnnNRunMh
WAu/DnSgreL8Ht+53SCD87fxZ6CfCY4lFaOeWNcC55ahb4sTG+1b4p1G2wmW
E2sZ2I/9EE0t2mH8Ms7PwX+Dtgz/JfZry0nsGtCTUM13sO+Cb+h/kW8a+kZi
jBCvDb4e+wSohpufUOyvoDSpHFuwn3GmH64P/KM+F6jWds5H+NVovsN1EHMx
9hJwP6Gad2HXcH5VXD1dg78a5Dr1aDK1naUHmcS6QL6D+JWR7voFzSa0G0P1
0u5UjrYIZKM9HldsB1+ZUI4r1NYc6G69YAr8FOJdRH8ZxOAi0Iu2Gf9qoG9m
LyVGCdrtIC+mnh0mdhb8KfJ/gx/DfXPgzyfVs2ziZ+OfS+pbM7XVoSkmfh+I
cb4Pf3WaapyEdqKnf3cGfRV8a0qxrYez4G+QbwX2c3DI7gYaOD+MX4xdEmoW
69N0t8nEu5TUHbuxN4c6WwdfAd+Q0r+3Gf0JPwLGG8cdC+E/pmS/53zo65/a
v7QZzLVeRJp164ndpd9X7+1OU+HG4jc51dBF7HpfuWvBHPjZ4EFMM7WD2lrI
twD/FTWug9vgKfe7pHrdxLf8dPV8EtwGX7tgMYbgP4ACzuK6RqsNTV66znTi
d4EB+Jq4ahsHHsdU4z3yD3nabdOcJFZDoNm3HW3CzvU027YjFttqtNosRyvn
H4Xa5enEz4Q7gOaHzWNSszwt0qzZTA/A7Qy1m/YPszzNgP17+8e2+ydTmj17
A255elPsLRllb0qgmbJZspm13h2Fn5CuHm4N1XPrte2o7cZGX7XZjtxEeyvS
7NjOFRDvM5qqmGbgiK+clstmth3/qa/emSaDsxme7mZvVgX5ykPN3hfbeeI9
CbSrKxPahRxPu2w7cQX/eiTtaDS/if3H127aP+m2XQx0di5+C/bdQLb94x5P
b5C9PXbnRdgLQ8WyN8bevkFPs2Rv4H+JbsGE
         "],
         VertexColors->None]}]}, 
     {RGBColor[0.4150981865873199, 0.26897686037537194`, 0.7004510335088123], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmHuQlnUVx5933+fd93nf51FKAgENxEtO4FSKojNJjf1TmUELLNaojcUq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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtl3mwl2MUx99+9739fu9CSDuRylaG0oLCZDSY5FZaJDMt034bZkJGKNoU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         "],
         VertexColors->None], 
        PolygonBox[{{2910, 1969, 1968, 2908, 1224}, {2236, 2900, 2899, 3210, 
         1552}, {1969, 3209, 1552, 3208, 1968}, {2900, 2237, 1218, 2902, 
         2899}, {2907, 2253, 1224, 2909, 2906}},
         VertexColors->None]}]}, 
     {RGBColor[0.4962196443121998, 0.4100251672922865, 0.8144770558480204], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmH2Ql1UVx5/d39vz+z2/okRw1ZlmCJg0jBzSgMrGsklexpIFoxlmanez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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlneMVVUQxu++93bfLc8GoZoYEYgFBIIFSMACipSgFBETEiSgNOkGVAzF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         "],
         VertexColors->None], 
        PolygonBox[{{2226, 2867, 2866, 2877, 1202}, {2224, 2875, 1202, 2874, 
         2223}, {2872, 2394, 2393, 2869, 1201}, {2867, 2225, 1201, 2871, 
         2866}, {2394, 3239, 1582, 3238, 2393}},
         VertexColors->None]}]}, 
     {RGBColor[0.5737613661287864, 0.5435370519035628, 0.9097253540741593], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmH2Q1VUZx3+7997fy/3dJDZomv4Tl02ZeEtTA8yZIAhbknSQRluWQsuK
ZTeYAGMgQMgaQpRyBhsjwUIaLXKXTUFcYVotdBKckRxba6EXJ8qXbZrKJhz7
fvg+O/5x5pz7/M55zvP6fZ5zL/x893UrmpMk6WpKkormTxdJcr9Gm35/WPPl
GmP14VMa79bYJfpczRt0aK7GVH2fpjFGtJEsSabHelqzz7G/p5okF2i9Tvw3
6ntTrjvgrz3jRL9P61mi/7nw74UaLUG/VmOL9l2s+df1JDlbJskC8XtBPG7V
ere+HWskyVGNhWmSHNK3p0TbqvGq9vxYPE9o/R6dbdF4Vnw/oHM79e16rQf1
bZrmJuTV+U7NF+muDq1f0vyMxljtv6KwTKs0v5VbtrG1JBnW/g7pVcdu0v+1
Zst7e8hcE32HxllsJdlWa+4Vvb/qvce1fljfn5X868V/gtYP674a+mt9SDwX
aM8juvNS0TfqzD7dO1PnZ2hUpdME0Y9o/yc1P6Z9j4s+Ivoyrbu03ike68Tr
dck5oH2LxeMz4jm9Yjuhe6n7N+jMdvH+eLPtjh22iscyfZsn2vP6fqfGFPFs
TW37+dqzrGIbj+o9Wb8bovfp7HW6d1Oz7dqrcVYyPBd7uaOnZvvjh6Em26Zd
42Wd/WrpM69pfbNkOKn1ytR3Y5PDVdOmiudNuudB7WkTr9tS84M+gg3F5yP6
fUD0n2lM0Lk+2eQefbtafJan9j3yLNFc6lu79gzr+6OlY/nvot0o3TPR9+ie
BzQu0d77NO/WmKj1Zdr/ocJ5go1PhZ3R9UTYBv2IAXxxv/j9qbQvySVyCrt1
yCZXVf17Uc1+4szN4n1LYXvN1rm5GgfRJTVvzh5M/fuY1vMy5wB3L63YD+T1
0xXHEWv8/1TEwGCssdtsnVta2JdjUscv54mN58J3B2rORWx1UvvakUHjB7LH
4YjbjcRMaZsPit4l+j6tLxf/06VzjLyZ3HA+EMc9yNPk3LpMv8dr/qlk6Sud
I8R9Z8TSL1PrvLTZNpoeufwj7e/PbZea9n9X9OXa/0PJk9adB3drvqvuvHyy
Yh9gwysL5zz5fj7GK47zL6bGDHw7bxT/xPOboq0J/U/GN+jdqc9C/434XSR5
Zstm39bcV5i+XXpv02hJHWszC8fbAsn1hNbbwlf4D3+t09k5heN5sez29cx6
Paaza+rG1H2irS2cvxeKvkFnPir6Dq23abxRdU5vyS3rucy4BqZ9T7R/FdZx
suY3MmP37aIfKe3//2r9Zm7/LNadf8ts41kVYz7yb5Y+m1L7+gLteVfdcfdZ
nWsr7NMR8Xs8MwZg61lxFp/Xwu8tQUO2G3XuytI5Pqz5D6XxOS2Ms8RorW5M
JI6Qe33UnTGFcZC8e1PrFZnzEx3GB4Y/L5v8szBGjNY86tdDumd/yDxan5CH
enVV1CxiakrpuHqlahnB9vNxErF1Unv26N73i76paixAniOiP6lxTdVxhO7k
EXV4S9TirxWukeMC3+B3QPRjFecitaaSu75SW8khYpU8GpBcH8uct9/Snrfr
jkvwBZwg5r8g3c/VLdcL2v9B4ixqFDmKLncVxgUwoS3iEnqmcxsazqHVgSXo
BY6CpzujJg/Gt1+Jzw115+RBrddmzqHjhb9BL/T9RN36UauL0vq8LF5DVdeF
Ae09EjlCXRiK2vFMxTKD7cOB58gAJlFTwaWJ1MO6/U49mRg15ZKoL/CZU3O+
gjMTgw4OgDnYBpvDd07s4R7uaw/fYkv4nBHtdOqe4g7p8pbu3Vw1Fh4unSOr
UuuADOiGjvB8PXf9A1dOidaTGmt/J/l/Xzg+kZGeAFwkd/8T+dsaPJHhaMX+
wddbC9fX3sAw6MQSMoLnV4fsm0P+vZL3gfo7NYmZuMmRi1rYZNnawj6tuWsb
dW04/I8ul+bu4biDHKMecxacW1i3H9k/FDUFfeABjr0KFkVsd4Q9kbMtfMe9
Q3Efd1EfZsRZcHZN5NSAbL677rr8Xsk+Prfuk1L7Hn1bYw3279HeVu37iex7
a+oaQI7jh+7wxUsRc8djJv9Z84093M/cE3Kuks9Xlo5leMETf9G/gHFtQeM+
8pdYIw+IN/pX7jjft4hHV2nb7224J0bmtan7OHCe9UjV9aKhPVlum88P2ZBn
kWhfLm2fttJ1mpj8n3h0psbYv2rP9tK86LtPxV3Xh6zISQ9FLwW+EXerIiep
P92laxA1AWxm3VO6P6A3AFOORnwSX9ibGOuSLLtyy4L90BWZp+rsrsz3/jtz
PpALXSED9qI+TMotP7+XR49HnNC7EGPYCRthn69o//vq9ttI2A4bgnNPh3/B
4/2ZMZncAYup9fDuCt17U9OJK/pF3j/UIPoUsOPiyNkZkRf7CvugEVjbEbFN
v9+b+34wZElgS2es0WtR3X0APcAd1PSG+7WZOvvz3H3DbYXrN7UbeXgngbFL
ApPgc67i9wx4yBuK3hq9itxxQ8zwruDb1uizHo31H3X/NXXzIG7wMf4FX9sD
Y8H/Q8GT+va5qvXFrv2RLy+WzknsNk/rX+Tmv0T8v5HZhmDSpMhT5D+TvoMH
Z8I+1NjvNOyL5tzYAW78VjxXNNwrvp27Z6JfWifa/tw1897MsUVcoQd9DPTe
0nIgw7UR62ALfdu4eDcS61MC+4nxTXEWe2cRA7yfdsQb6sHcd7OH3uqJ6K/g
3RI8W+Jtgi7g5unQkXcdPRd+/4TOzS/tD/zNm4BenXjrj96YeOyNd9Gp0rZY
Gr087zfeKNjm+7npezP3K9wLLuNb/Nit7/8QfWXV7xzm0f8EeLdQH/6i76/U
7WN6a94wq6PX4G1CjtNP0QvSUw1GXnAv82DUV97E9P30cPTxfaO5I9rq3L4j
F8AGagzx0Bn1Zn3D8UQs9ccbgft5B9/ScH/SF3R4DojfnQ378kWtr8jtzy+V
7pnAy/8D9wodaA==
         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlnusz3UYx7+/y/H7Xn5xiK31n9vpsnDcRdQiIgpNtZqlXCY5jliRhois
cRy6bJgU6lC5nnPk2okyormVU0OmZVlqOafVSovp9d7798ezPc/n/TzP5/N5
bp9P62fLR05JB0HwMZSFhsZBMAxanAmC0chdwiC4PR8EW4uC4BwKG5FvS4Lg
UfCpGM4Bmy08FQSfs1YP/hz4YPg14JfwVRUFQR7+Gexbo9sOnT7wVfjcDL4D
qoU2QZux/Rf8AvrNwZuzdhH5EvpH8fknvuay1gZ5S5Mg6IC/HuBn2P/3tLG/
0OmXts4C8KW5ILiM3Az9ccgL0R+EfBK6yH5V4G1TPlMv5O3gr4KVsN/Z2GfU
2c4oLuC/gDei2wAdwt9K7FPYT8T/j+AXoKMpn+k4/DGoP3cZANViG0c+6w7s
24aOiWIhnRXITdF/E+w/5K7olrM2DbmY8+xlr3GslSr+4N+Brca+PXuXQN/A
R6ytZ++tyEeQv0c+hzwd+T58L8o7FvM4QzvZgh8A/6jIsX4q8t0V82mJa0C5
/wFaj/66vHN7Bz5mcZ66yPUymXo5g+7avLE7oVXgE8A7g4/Cfw3+qqFX0J2d
cW11xWZY1jW2C34I+G7kvVANtrXQ6+gOZc816L8LDUv5ztvJyVb22AJtg7+M
bQ38vSn7rEf3NGsD4A+iX4lOBVQN3pG10+D14GOUD/Cd7H8ldG3sAT8GviF0
rc8H/xa5Af2DyNXIbeBbJ663fZxxA3uvw39fbEdzn7LEOVJu6lm7BWxyYv4k
+v3Qr2fttGzgy9DtyH2bgvXO+G5fgn0R+46L2b8OnZb4a6EYw5flXSuquSXw
FXljtyLvSXwHnb0q694oSczrzOXwUxP3iuTD7LMb2gUdgq7HzqlyOR+dw8p/
zr7LWIuwfRv88bRnwg74ZezRAf41xUi9rvhm3FO626bIudcdn8T/JMUX3zlo
DvKSxL1VwZ06oztFPtBtBq2EX8haNb6eTjuXy6FOWedUtaMcKneqoRtgb4Su
Hc2kweCDoIXIO8HncpcD3Gl4E9fkPnz/xNq1jGv6K+Tfcj7bW8iTsH0+ce40
09bjf23s3lHOb4rd4+rtQ+iswLYodm1oRmxEbhobK0F+B/83I3+dcc12TDxT
NEvqWOuh3sLfw/DNoRfApyfuRcXgGraLQudmnmIIX1mIn2ZAX+wrWRuObUto
YOIZoN6vVYxynhGaDeqpE7FzrNweQP8k/Km8Z6387cY2yTs3d+PjU3w/lLhX
FVPNEvWUekkzZWnimaRZpBprFbqH1Dt6Mx5hv0aoLOv5URq5B3oX8r0G7L3Y
sXgi5d5rTDz71IOrQve4els9PB5+Qt6xuIK/Teh+ArUCK8LHGPyH+NufcY2q
9joU+k012BN+KnQPcguoD/w1YrSavUvxMQA5g837Kd9/JvLL0ANpvyGfsVcd
dDzttWWxZ6Bmn2r0Lmyj2LHVTNLbpxm2rfAGnsfXhch7rcDfVfQnInfL+E3U
W7YPvSFZv2maHWcLb5NmSDG6zSLfPQXeIvYbqrdTNTY8dswVa9X3efz9HPtt
VnyGFN5gvb3qgf3E8kjk2lePlMC3j/w3UEwfQ39UwZ90fs25Z8QXZT27Dhdm
iWZYA/iUyPlVzLvofYvc33rfXuK+L0au1e74n4FNuhBvyX8g/51zbPQmalaE
hfdONf8Ptleh+rRn0kj4EZF7TTWvvTpFri3tqdgqBrq7YpzCV//Ie2nPWZFn
umb5QPAKvV2hc68/gGaT3ujigj/VTvfIvaoaKgVvEjlXyplqLxf7r6QaHKvZ
GTtW6oH72Ws5+mMzriH9BfSH0N9Bf4IFoc+ks+gP0wDfGPk8Oq9i25jz/RRj
9X6vyLWsGbA07xmq2ak3ZJvum3gWaEZr70HYn0j7DJXINaFjpzvoLX8w8ezU
m/4h8geRZ71sZmI7ApqR8Zt9HdsboeOpHuoJfyr226s/iWZbt0L8NONk2yZy
PuRjfOSaVi3rz/M/HLpiPw==
         "],
         VertexColors->None], PolygonBox[{{2745, 2096, 1098, 2751, 2744}},
         VertexColors->None]}]}, 
     {RGBColor[0.6334044084039064, 0.6393668249866483, 0.911085031734951], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFV2lsVVUQvm+579577gNBQKDQBYptLJC4ROPyg2gwPKRgaWKhYBAKqJjQ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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlmlslVUQhr97e5dvueCCYBTS0lZKZIlLonFJSFwIIJYgiYVWwlJF4QdU
NI3FAtFSXMDEBitCYrSi2CoURCSAihtqVcCUshgxggn8MEqgpq4JFJ83Lz8m
d+bMer4z884tra2btigdBMF6KANNioJgRBIEGxG6kOchPwRNSwXBnxhG6NaE
QVAF/wI2O9Htgq5EbsKmIR8EHyCvLAqCKfi/CJ+FNqOby9nYQhC0YXMV8vvZ
IHiQWL2xk5cQYxTycXJUo9sMNWLfztlI+HwuCB4n1jn8BxFrHFSPrh86lbZ8
nFizsbmekDXE7MC2GbkKXRfUgP5JaBP8O9i0obsPGo68GPoR+2XI98CnoDfJ
/wb0LvFHk38I/A/UV0k966EebA9Dr2Lbyp364A9i04ntFs7mIN9FfX3o6okx
D10jZxPQ9eH/FPlmQ0Ph13K2A9u30NfD10LPIS8g3yHuMhn/v9FVQkepfSv6
Rfj+i/xekc+akGuhkqxr+pJ8FYlrqcr528fYN6X9Bs3I86BS7DfozSLnUGy9
8WnyT0A/nNh7kcuRDxBvFvyn+D9K/PGcPaDmIf7V+A6FJqb9Bkv51o3QrsDf
/Dt0+yPftQX/bvxD/Esz/mY12P6et66CGI9huzjyW+mNB6AfGPstdYdO+GNQ
Ff5buMNP8NcRrxv/6ZxNQT5FvFUp9+gKdEuINx7/s1n38kju057xfSuRiyO/
/Y3Q+dA9p95S/rXU+xVnLfAl1Ps08VdAnUW+Ywu5eog3kdjtUFnBZ+I7oHux
PQMtIF8/PnNj95B6p8DZjth30l0mIj+hb0e8cuTijHtvGTGjnHvwJmrZh81U
dNOgreTaFtt3FvrTxE6H9tX3P4BuPzQqddEH/fbQs6kZWIluL/Hvz/lOy+Hz
sXtXOf9SraFnXz2yW28BTUbuIebHib+xvu1o6GX8vw39rYqhvbFrVG3ymQE/
g7Mc/BDOpsLvifxewoQ1+H+N/1D1FjQ49Axq9uqgQ+R7DVqY9TevwHcmNo/g
m6e+2yJjhN5PmPGFZiVxLuHNavKtgsrId23G2Dc5ci8IA3cj9wq/8K3A5wi2
46j5v4x7TrM2n7NBGc/cM+Rain1/2jOgt7twEZ/0hjuRT0SeNc2cZu/WyLVJ
vhP5E2zGZD1zmq2fiV+d8Yy9jq4NqiXe1JSxY07s3hGG7En8Bvr2irEwbwzQ
7AvPB8FfDl0G34r+GPz+xHevwHY7tTxPzuaMMfwcsR8uGKsmkbMN+ZrQs78M
+SV0q/E7GfiN6pAXF4wFqlFv0UHMJUV+E/X+iMhvoxkQNguDhb3C6PPonw2d
S5h7BH4+9R3MGAMHYDsQ6kz5Dt3SQZ+lfNYVumfUK8Ny7qXK2LOmntIuykXu
Ve2kfYm/QcXFO6zh95LIu24bPv9E7nn1ujD2F+xvDr27arSjkMsi77pLkZeT
Kym4V4Rpqq284NlXjdotx8iRLvKOuQP743nvzgHkPAs/NjL2CRN+Q54eu1eF
iZ9H7mHJuk8D/NvYzMwa0y7E3hnaFXpD7RrdSXfRzrkBuTfv2GOULzJGCBvU
41dQ6+CCe0MzISxojt07wgT14t2hd6t68sPEPSa9dnRH6J2tXS1MPYr9LaGx
WPNye+QZUK+r5/W2h9H3ZPzGGyPvHO0a7cCTiXtOvaY7Ctu/j411wnj5bih4
NyvGR9TSmxgb9J/lD2zrQt9VM6r/FicSv53+Y5xJPFOaJWFIdewdpW8tTPom
NIYJu4SZwv7WgntLO0C7vSXyrtaOHxZ5h2h3CAPU+5sS94ZmYB26hQX/t9EO
fSXxN9K3Eab8Kj50L6hH/gfr3zn6
         "],
         VertexColors->None], 
        PolygonBox[{{2523, 2526, 930, 2525, 2522}, {2665, 2523, 2522, 2038, 
         1043}},
         VertexColors->None]}]}, 
     {RGBColor[0.6930474506790265, 0.7351965980697337, 0.912444709395743], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFVluIlVUU3uf855z/OkmmPpSo0wXKBBEMb6mjdUYzHFEoRhMvE0YFXqYL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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlVuIVmUUhr//sNv/9/3bRBu9SNFKL9ICCRJSMo/YiTSlYkQ0HVHS0JnJ
QMvxNIllQ0aZFUlRiJZdhDdad+pNKjM1kV3kgRmVspw0sTLtQu15eb1YsNZ+
1+lbp313U/PsFeUQwkqoCh2KIRyA3qqEsBVanEJoqYED9oeWI69EXg0/GLpS
D+FwHsKCUgi90PtFCEfB38XpEuz34asH/Ar869BU7OeBL8P2KvKf2H8ClbMQ
KtB88BfBW8ET9Bvyc8iL4Jugg/g7h79y1TkW2CZoDvG2yif6E9EZDLYGuYF8
dqHfrdwyv+0X5JsV228D/xb/72A/OXNus/BRqjrHZvAdfLsJdgOaiX078jRs
h0Eb8NXFt+3wbdRvLbZt4GuxvQvajLweeR38SGg/uqdzv1316AGfBv4P+d2P
fAysDZ3H4FtL9tWOzoiqfV6DX5PsW3IH/BboA3IbjbwJ+x7sP8P+I/I5Bv9X
7t7t4Nsk5FU110Y1GsD7BhWuzZfEuwd+BPQoch/2LfCthd+uHH+g1t3Q9Mw6
Z4h9Fros34oH9mPdturpebA+6F/wmcG5doFPypyzavtp3b1XjTvJ72Lu3qum
itWAzoeZY87GfjFyc9UzMAP9bcjP3OpHO7Y/Rb+1g3hvI9frno0pmXvxBPjQ
invSCdaRu/fK6SWwG+g8yDxMqDj27Xz7u+wc7ihcM9Vqe+ZavkJOw6uu6Sl0
r+XeDfXgP7BNyb1XvDvBF0FjwK7j89fcM61Z1MytTp5h+ZLP3eT3MHLHbbyD
eL25Z0izo5pq1lujc1U/H4+OqVh64zj4h5J7c7Hi2M9Hz5pyOEf+ryE/C/+y
SO/P7Wsi9HndO6jdK4g/Fv3vke8F+5kaHEZ+r/Cua4dmgH2FzcDMO9YffGN0
f5TPvOieqBejkJ9GHli4lsORW8CmQl/gawzfvsNfZ3KsWeRwAN8H68Z0cyYk
10i10QxOTs5ZuermfB19g1SvNyrO7ZtoXjl2F55RzaZq3AS2EHoAeU/Zt+PN
5N3SDRnHe8bXfOtG4+Ok6ot8quSazNfu5ra9D/lq7pnQLDTgoxf908m9UAzd
uibkflXfvCPIe7C5VPYN7UPeGd2bRuRGsL113+bl2G9Mvgm6BboRv8OfQOfV
km/mhdw7pV2qIc8Bb0y21bel8C8k74pyVO31BuWuHlzOfUO0T8pxIboLkm+d
vg2Nvlm6VWX026NrpNpopvSWruTe6U1/1PwmvUU3ezP8kOhd0M1bBf9U9C7r
xmq3n7y1r5qhftEzo1nRTh7H/7Do2HqzZm1AzfbS179rWXLt9Q/T7ZibXAvd
EP3LHsFmUMX/tOu5d0Czr28fR8+sZnUFNF7vi76tuhH/A8626to=
         "],
         VertexColors->None], 
        PolygonBox[{{2542, 2053, 1056, 2684, 2541}, {2546, 2059, 1060, 2693, 
         2545}, {2052, 2542, 2541, 2682, 1055}, {2058, 2546, 2545, 2691, 
         1059}},
         VertexColors->None]}]}, 
     {RGBColor[0.7526904929541466, 0.8310263711528191, 0.9138043870565348], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNV1lslVUQPr3Lv5xbQIMtKkZtQVESMNBCbEFAgYJLXPCp0mJEeChVINJL
WTRIiRREQ4pRkYgJoVHARE1EiNGEIi4xphhAKiBCbZTIIgiEtL0s8fv6DakP
554585+ZM/vMLZo5b9rchHPu/jznktgfiJwryXeuA+ePQ+e+xLkRF2oD5+YE
grvTzr2Z0v2vU/pG/BjsY7FqQHsA6y3gyvL0nfc84A8zeMM7dwHE47BPwLoI
+E+vM+EZsXMT8XYx+Ffg/QuReKaxn8W3TYD7gM+7ODeBb4Z3gG8Gfi7OHXh3
DWAH3C24dwLnRsjQgh2fe/bdCclPeSn3YMD1acGDAHdj7zJdXsc+Gqsv8JfB
YDXgHPZVgeDpuNMFZiuwP4k77ZB9R6xzF+CjgN8DfAJwSyzZJkHXCi+6bCC9
lwJ/AXcO4M7bgBdB9qmAB+JbC+BdWMMh4wc434l9GHRoBlwMeATgeaA9D1u0
AW4A7l98O4f1Pujuwlu/Ay7DW+WBbPsP7v8E/k1461KevlH30kD2oq1Ogd9p
rFbwbM8T70rsnVjDk6Ij39+w+jjtR7EQQu478B/sdW61uKHNd2L/Ii0+n+D9
x7DG4/tB3C/3krsBbz4B/EPAb7f7haCtTMqfjIFELHrS3oy1JCnbpoD71Giv
gWcd4I3AZ9PiRT7PATczlg5TQ8UcbUKZeAeoHttRlgcBV6d0HslcgYxlWGdp
e+zf4vIRwHcA/gbwr4CXJeW3csjwMnR5xQseDN63Aj8acD3wE2LBOeAd1tqU
/DkwJZ8uwJ0XveC+CeUN42SsVy7x/FKeZKOcyYTkIq4k6GHpbnKK91aL+WXg
udLLboyL70P5sAv8fgS8BER3A38P1jGLtYKU4o22X2Z6Xc8BqOCGpRU/tCFz
d77l7wbLfebporRyrMDuNwWSbSSC5Su8/YzVDdaMfk41iDjynwH6bYF0Zw6s
C8SDOcoYZNyy3jRazanC/a2B7HAUenwWK09rAslCOxPeYGfyazKefI/vwkxu
PeQala+8rwvEs9P470kLJl2J6RJZDDF+mC+VxocxlbW4KpCrHUh66scqqyes
A9SRPvR4Nz+jOssatjrsrWPMz2Pg2wz8eMjWnSf5aZf+rF3Aj85XTcsAXkta
wKOMlnf2Y99nctM/tIM3Xdb9706p1QHahfrRzrTDOYuxQ3jndti3Lam62miy
LcT9xebrErMteVJ/2oG63wfa4Vif0xjYfwmVZ6UmV3+zU4HFcNb4kZa61pm+
P4DuUkZnxtGuUP5jrA0yWt6nDsUWV6usbvOtUSYzbZ+1GLtodZk5dTGSrbtN
r6zVEPaZAYCLEqpP262m8ftCk3WJwYWmR73ZkfauMZuvx1u3AT8koR5ba3jG
KA3AvvMOZNiY0bnR7jHOO4HLZXpzizv9PoS9NVRNZv29llJNXmx3KMth4K+y
fzr57wp7tFMPrDc+ZZYTgyxWmQe0G/ec3SfdZYMZF4wP1knmSp3l4Aok1YlI
dWhLUnWQde8G4N7At49w53HAj0LIvfj2NPbTXv30KezVkWr8ZMDnsJ51qvfs
96z5rA+taeVOY1pn+jEXKKYoD+nZk0l7Em+uDCUL+2GZ1RH6cYf5i36NU+qP
7JNnQsF1VgPIkzWAPaSnJlBOL5pO66m8w57/Vyg5T+L7z9BtFu68mlYdoX2m
Az870pvMy/2Wd6UGMx844/hIcw77PnsC5wrOA6zNnBmq2eti5Tt7F23JGN5i
PYd9kDbim8Qz5mmrpPWXpTbDjIvVe0bYXFdjNXYm5KyNFKvjvfzE+4u9+hnf
eCRWj2F/afDqf+wXcwDPjyQrY6PK7PQ88LOw+qY0+5wPpUsh4Emh5Rrg18Je
vdkfqQvntJzF2wLwqPP69rf1EvYRzoypSDMD9eiyOYd7t9G2cV4LZctu41tj
PuyyO6wZHdaPtuFna6wYZK1ptzq/OdbMxF7LutZmcxN1Zg+lv2oh4wteZ8Ym
5eebnBM7Q5sVE7LZJpu5dlpt2Ys7y0PVDMbLNK+YoRyMb8Y2c2Wi15k5wXmA
/s2ZvnyLdYtxSlrKwHmRuTsA/B8Olfv08wwvXzNvGB/0NWOXcwfP/Ea/0V/s
RVMi8R/D2MlXLjHn2RtYYzkXHw/FL2u9jnFIfsxbxh/7cc5moRU2W1Mv6sGc
uT7b7LP55nq9pmyl+er3rFGcyQ7ZLDoC8mwLFRO0HeVmLrP+cV5jDewA3R9e
+UC6w4Y/mFR9ZH0bCvkrQ8mzO1T/a7N5iPMec3MP8EVe9OR90PgM9ZqrOFO1
Yz/ulQPMGc6E9DVn1auhYnsy4IpY36bE+j/AN0551RH6YTnw/SLVT+bWbK9Y
uwJ4aagexXpJuSnzXsh7r9d/Gs4F1VYr2H/oR9qFNEX2H4p944jZ8IzX/xb6
gzU7aXV7M95aA7iKfczrPyTzpBx7WSS/U+4qsw/1qTR9OZe1hPIXZxbGX0/f
AV1DLNobI+nJt/4DQD/MmQ==
         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlVtslUUUhafn/If5z5xD1RjRiBdaSLwkVquCWmoLKOUi8cIbUFBLNSoI
JhIjEKO2EaLEB2JQUNAYSFR88oLGxAQQ7wn1QVvxBrVqvYBGQIQiEL+V1Yed
7DV7z97/zKy9/rqOpbOXFEIIK7EMa85DuKIawrZSCO9iT8QQ7sbq8bcUQziY
O0exPja+hB/KIQzizyG+vRLCJ+QvI96AXZBC2MDaCYr3Ed8HbqH+LmLtrM0H
72b/2hrKgBuILY2u/RY55xPfGb23F1uEP4380fiPYpPwT7G2if0TCq59J2sN
Rfe4CnwlNpf4APYP33J51bX7wXPYu5X8FeTfzlHG0G8Xa9+A92CziJ3OGV8h
t5X6x9k/hI0j92Fq1JH/PPhk5j3d7F2IjSH2Ingc8ReInyL+Pfgmev/E2mT2
95DTSe0T2AC1l5Czlb2fg58Bf0nP/eQewI6x91b2VKlVwQbxnya/kXqj+MZR
4HdKvssebH3Rd/oA9XZU/Bb15LxBfhP19xIbPyKEH6k9k7XdxBdQbz+xddiQ
avEN24i1ge8lv5n8L8DN7DlE/U7yj1C7lR5nBr/5JvBkcC04gMeS+1H02b/D
LgG/SY0J1HoK6+dbB8rm1gZ6tNCrMffZf8OayL859139Tc4g/uayv20n9i/9
PqX+cuIPYY/j34GdV/IdfIVfQ78u8PzM3J6Y+67E8efwF7N2HH8t8V+p/Tv2
atGcmkT/1uS7P8zaeHKvxuYR+y9zr4XEazP31Kw8CB6deWbuAU+l3rniAvgg
uIP4RXz7Ompk9F+ezN2XwdPJ3cxae9EcT/hdxJuIb6kxtxaBz8rMsaPg+8CX
FXx/i5PvVL5y9BY9Vd+13uQkuIV4Y8Hnayt7hjW7+kZxtZ4a3xbN2Tb8qcmz
IQ52kL+H/CM1njFxJVXMRXFGd/ls7rfXnV7P3onY6pI5c7HOjo0kZS/4w+iZ
06yp50rwXOzskmfiOmLXYI+B/yL+QbQmSAu+xm7QeVnr5nvOIb+G7yuUPau6
r9P4lpnDWDOs2u3JWqMemsWfk99WM7mm7BraqzfQWd/WzIzwmT+L5py4tgKb
ET0jmg1pQpG9GTZluF8vfl/ZWqD3XpbMMd29OPJktKZJy6Sh4vLRirVFnBZ3
e6O5Lw7/gn9b8lnXUGM2/mC0X8daF7W7y54Nzbjurj9Za3WHeouB5FnXmyzA
/zNaK8RJac/r4NUFa9At1DpjWP90prs0+9FnEefulzZF802c6kw+s+KaiSng
P5K1opb4vug1+XqzHZrVZG3WTK2KnhnNimZwe7RmS6ul4Y+QW8o9K5qJA8Tn
JZ9dZ5CWXZvMFWnaKvxK7vcUB2ZRa2TFs/5+5redHq2NemP9q9ZXPNv6Z0nb
L0zmmjR+mrhdtZYMSR/Yu5GcH4rmtLTt0mRuS+OkjdJcaa008r3c36DeuuND
4MO5a0ljbyT/WMXckqZ/HK2h0k71eK3sf4b+Ffpn/Q9tNgV1
         "],
         VertexColors->None]}]}, 
     {RGBColor[0.80726725, 0.861883, 0.894034], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFl32QlmUVxp/38/l4H6yZZgJWFpU+BMX8wGZKLT4mUJO+LSrdJWBxkt1g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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlmlslVUQhs/d+O797tWYaIRqW4SoLZukgBuIVGMLCK7FLUIbFUyMWNK0
VaElsRoNKj/QH0AiVQq4UBc0MVFEo2gxcauaIBQxoaVsbhDBRNqi+Lx5+THJ
zDfbOXPemflG3b/k9vpkCOEFKA1dXghhbT6E/kQIH2VCKI1D6OFbzzB/W58N
oRj9yxg/hOM2+EnoP8R2DDQL/a4ohNPohrDvy4UwiDwC+42pEOYR7wu+rUSX
4ttOdAH/Nnwb+XYJ+nXEPI3uEPI45G+w2Y9vHzQB+Tvkg/AHoO3YnoJa8V+I
/VPodhG/Hd1KQl9VsI10n2ScuwtalfIZ2rDvRl6DvBz7d+F/Icfd5H+Sb5fC
j4V64euw/4B4s7njYvhKanIZ8kSokdjD8T8P/03I49FtRZ4T2Ue2ZcjH8a2G
TuLfQ41a0J9Cvgi+Hv0R/ANyCflfJ+d0fK9HPpZwDaYhT4UWJfztJvhb0WeS
rvkc5JuR0/B1xKjU2cixB3kHZ5yBvIl65OC7oBvQna83Qv8b8R7lrsvwb037
DCXYvoq8Hv4VaAn6JuSlab/pe+jr+DYa/xHEq5WOmL3IRdBcYr8DPcHZS6Cl
2Pdh04/vfqgIOeSMpXXIr2WdU7k6oA3IF+StE+bWIJ+F3IT9AmgquX+KjB3d
+dvImBFW+qHuyJgRVg5Bk+AroBLSHkbeSrw35ZNwTOXq4Ft72jlrqNcM7P/G
drfemLNewbdt8EPYT4afjv3WjHtgHvJdyD/D74HakN9G3kKss4UXYnWQI50x
hhvIXQX9Sf7dSdeuBjo34xpW4D8N/76E30i5iomxM+WcX2F7Mu+3uw+6suCY
ivVxxmcdQN+S8ZmFhRsj96Yw8Tn8SNUHeT7UjDwXGoZuL/QX+ZZExrbOcBzb
Br41c58m6Fr5xsbaCuEJ/g9oEfJzyBH59+K/POGYt2SdQ7GF2f3ILZzvAPYT
qE9v1hgRNtRDrfhv5ltD0jWcHfkNVHv1kLDYTL7itDFZmndMxRJmu7Afjf4g
tgugmVn3gLCvmfNl5JmjWVMLXZh3D6t3hYGUZhVUS72PkHMzfCfUknLPCksb
8clkjKn/4K8ruNcGiTdK8y5ybtV4A/qJsbEoH2FhfGysChN6+5rYs1EYUK+e
yHpWqGfvQT+W/HHKZ1BvJaHDSffYFvh0zmdtQy6CH5Hz7BHGKol1dcGz8Cjy
MuJv4tsjSfek7npO1r2qOz+OfuaZeuhNPo088zXrNfO+j3xn3VUzcZzuA72R
9psNwv+TNzaFwcrYmBFW1FOT4afE7sVSclTHxpCwM8C3Z4j/a86zsBP909oF
Oe+Sl5Bn5XxGnU13GINvN/dblfbM/hr7f/O+q2bmCfVybOyuTvjuI/OeNfJ/
NvJMUu/rzncQq4wctwX3dDV8Vc5n0czSWxwj3sNpv0kl/mXI+1LeYQvhH4i9
W7STfo89UzRL1CPqpXq+DU+7p8aqttDu4Bo+Br8Pm/eTnsmfRd5R2k2aAdrN
2yP3rnb0g8Q6Eflu5fKBvzfybNbO+wHfH3PWvYjNW1nPKM0m9eBi3SX27lSN
NduPRrbVjO+Er8DnmoRn5p2adwXPOvV4O+ddnfVs1husyPmfQbXSHVTL8px3
g2r6vN7yDP6E4YvJtyNyL6pnh/KeaZpl2vFN6Btjv70wsQB+fuzdqR2u3T2l
4H8X7XC9TVVsLOmNTkfesfLVzBiI/I+iu+oNymPvfO16veH/TUk5ow==
         "],
         VertexColors->None]}]}, 
     {RGBColor[0.8608307500000001, 0.879745, 0.8700376], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmGuQlmUZx5/38Bze932aIetDlqQUynLQkgV2ZcVRFlrWQxigCKVBH3YZ
yd0AORlt08SW5TB+IJ3JcTygNZH1oQ+5AU2mGSFUgtNUk6uyNpSl0+SBDuK6
/X/8r50+3HNfz31f13Vf93X439f7Tvvc4IqBapIkWypJUtP8wVaS7CuSZKMW
FzST5Lk8SV7TxlqNQxr/Fs+NjST5iHim6/v9oj8kmf+I/8dVz6ul61bNB7Xf
qXmo5m/oOyS3rWn6Eo2HtLdHOgvpaWi8prV/af8q0fdr/fGq12rS+YDG3KrX
b5eewaa/Z4j3hlI6pOsDos/VeEfrL6deG5Zcl+hvaHRLdr3u9JT4Z4rnedF5
6b3z9N0S/3rx/FXrN5f+5t4H4+57K5YbEv3eepI8WDPd1rAdnLdTsrfIvnVa
zzR/U9/7JLdccyqdl4Web4t3kLtrraFxV2p/PBg+mV71GrzY8dGqbdtT8R6y
99WsBxu2Sv/ywnf8o+i6dA5L/hzZ+ZfUOvHFFMmuEL1avKtKf09t2D5sO1/0
CtFLRb9TsS9v03yd1n6Cn/W9Xd+55g7xvKrzJ/Q9R/Q10tlb+vs5nTlaNd+2
iuXQ+YnS53HWfRXnAbZtkuwbTX8Tr4Wp7XxE+XWp1l/ROVu0t1kjxS6tP8me
+J7VWJP57l1BI/8xye0Tz+viH9B4QmuzxfNkanoWsRDvtzRmij5PvA8Vzvfz
RT8q+mbRc1PzwcNd7hG9IHHOk+9nEscYmjz5aubc3aXxN8lnkn9De3drvkjx
uLBuuzn345p3VC2P7BydO1vj+3XvcW6n1uelPhcffq3ifCUfFsqfXRo/1/4S
zd0avxJ9tOVcJ1+5/4aIUXtq3lkRX2K7IPzAPTmrI+wivg8XxgUwgTrGVuw8
Hn7H589oPpLaxyOZ/dsn+iXJbpfsWN01xEztw3tTZhuWy95Pls6XTHNNY3fq
89ZG3bUHP/bNUUwfls5/Vjz6K/+P6VNxLn4iTvhqUWbfLRH9Fen+QeG43CDf
/LS0H2cqH1fpe6V4pqauK2pqUDrGQ/8/tP9Znd2qu+aYqcEx8U/ojJOa39U8
njkuxAiaHGZmj/pjngh6UgZ+cO6x1FhHjd9dM4ZQI+fWjXvEkDy6WPSnZc+u
3Das0J2uL12X+OaSpn0zpnv9N7eOy7R/pfh+pjOe1vovGj4Dn+6OuG+v+yzq
8ZfS84fcOq+X3HWSP5Ha369HLpFnf6raR2+Kt0/nTpH8WvGulcxL2n9A6zNE
H664nu5ouaa6xbdX+zM0X6D1o5I5JJ6DmXNrq+jDqXOU/Fxcd/1QO9g7HDZT
r3c2nCvU36GoR96nzTXX4WnZdSb3/dg/HDyLJbdT8h1V4+45cXdqBnwnB05L
rr/pPXimxDo2ngg7eUS5Ezq/B2/h+3E+ccWGEzrreMO59Xjm+JBX86Xj3sjR
pfJBT+l6ujY3plNfF0vnb3P7nnPAHc7aFbrJGfKQfCJn1uj8NdLzYupcYp0c
u7YwRoPPYOrcwNWRwCr0TA+fTasYxw4Ejd8H4tzvSMfUlr/f1fysbBvSGV+u
Wx5+auVHLdcJMd4c+s8Urj3q7mXRH275jMfEs79ujCfP/15zjs2Wnl/nrutx
8R4V/aXU+kZC503Sc1pjKHKTO20In9AHDEcdk6sDofvV0E9/wzc1dbt0v1WY
b2HgG7hBXm0M3OM9G403rZlaHtmVud/+dfEW/C7ehqVa26TRpvWrNW/RmJ8Y
D28NndTJC6ntHw0aLBqTLTtbjjdrL8Y6+DEW95qUwU56hD9XHfN1kn27MA6R
36eq7qHupBY02uq+42joBDPvjXdtZdP34S7dmTGAt+BT0ndBw295T+azOZf+
YnvUzjLl3dMtYyf5czRy6FT0guD/8+K/PHXv8Xuds6yIOmq6D6AHAAcOZI4B
tULN9EXsNgQGzgmMnh31eDD4n4i3iPcFGll4mEdCz29y11V/vFnsTfYH/YFv
vCkjsY5fbgs/EP8icgDcBSvxEf7sDcxfktl3YBT34B2ajBHxoR6vzsyP//Hn
svApa+wRu6tK1xj1BfbwPoE/4FmztN/B8lVN4zk4wlnk2Ge031f4TLC2LWqR
HLyyNA+8VwQ/bz42c8dbtL8jsHG16BtLx2083i7uuIPzNdK465LIFe5LLIjp
oogj9A8Lv8FgzVuy902NbXX/btgY9UKuDATmdES/he/nibe96X7qWG5c6Ass
520Al3g/wV0wgRw8njs/jqXGVHJibvQq9J/0j52le7FNTf/24J3d2vRvDH5f
gAXHQhasPhy5wPeR6KOOhH50UveHohek1wMTuQt5eSBygBqdHnlAn1dkxjLW
6Pd50/ELvweohe6IG/cC96Dpgd8jG7/e9Dn89qCehgOrL4pzO3S/My3jD28/
2Ekf2xv5RRzx94XB/77CGEGuTETfcjLelrO4Iv799FCl7V4c/Sz+x662sI1a
r2fGOPxID4JvT8VvQbBoq3RsK81H3vaEf15RPk/k5pn8/UAuUAPEgFxdLBsW
le75eqPfp46+INs3N93HvJ27B+LsNYEN8NFrTCscJ3o5fE5NgUld8bujO3pg
6jcpbBP2jEj2mtx9CTq7ogfumXzDyQf5+5mW9RKTy0Mn+Do/8ofec33hd5Df
AZdGXDrCN/gK7D9ZGP95vwYC687iUNQpbwsxJr7o2Rt2Uyf0imAlvTM5Su5T
qzuilz/b42eW5Xy+ob/Y8ttMLfYWvjP3pW8YDGx8tPTvf2r3isA3apw73hO+
6MysH3vps8AU7kdsiAnvxWjEhLiDX3si/9vDXnxCP8JbQn7OlG2zWu4VdgcP
dUdetwf/C/GuDcXd26NOeYvQA/5gV2fcnf8DPl+47xuPugCf6UX2R+9CnY7E
709+B/MW8gb0F8ZZMJbYzov8BMt74vcavdJ3C9fZ/wAxkBnP
         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlktsVVUUhve99N5z7rmHpOJEIgoo0RYREawWQYWWYsECplSEIooOqA+k
2mDbYEEHKioDBowkPqCIEdGB8RVoYnylSlFpiYEqKlbjmxiVNlFaUr8/v4OV
rLXXY++z97/+dSbf1Vy/IRtC2IaUIKNRCA8lIcxk8flMCIVCCOVxCPtzIZxi
7V/8G/BPR9+Jfwx6Fjk4JoQu5E5ifyamiD6BmLfTEBZjV1D7+nwIEXYddjX2
U9TsLIawB/mF+L+oV4r/XGqUcZgd+L9k/+PIC/h3IWPxj8V/Cf7t+Jeh17HW
m3PNGdR6jbUO9n4H6Ui9Jj1m/yPs/SF2BfFbkNOJ91DtVmrehP887BHiRzjP
B8ReS433iJ2FtGFvon4l/gHi16MPknMOennWtauI7855jwT9AfYYj78NyWIv
Q47ii4jvZa8jyDPsvxOZRexC6uXx/4o9j9j5qc+qOyyj/jTkFWq1kP8Gvhri
y/BV8n0V5Pdh/07ub8jT6OuRL4jt5HsuJHcvZ9ajH0CuI/8w/nX6VvaYSf4M
5O6M32QT8QPEv0XsGuzp+D4jvgn/n3p/8vuxHyf3MWQ33xIXjJUW4jvJnUCN
RvT7sj5bHWujGZ9xjr4Pe2rwHa/EXoX9Lfo3SA47n7r2bGKORv5Gfdsp5CVi
JxZ9Nn1TCbFLiakMPlMH+kecZzv+5mAsv0x+dYkxvZH4diTH3d1L/mXU2hcb
K7rjnsgY0NtvRgbxLUYOo39FfAO1liNrg/cYz1434L8/YwyNkruA+h8Tf5a1
87F3x76Lf5Az6MOxe+UJ/Peo/4gvYf8t1FuEXos0Z3xnh8jvKRprO7BbyB1K
jK2f2OMWYm9lrVR4J38d+mZq/oB9MbJCZyF/LrEnkKbENZQ7jhpD6I3EnFR/
UP+i2G+qt5yiesS/Sf4F+EuJb4z9Znor5dzGXjH2NvQp7Hcp/hSpIrabemvw
NcU+izjiDvV6wWf9npy5+KtiY/H9nLnlZOxeE8e0o29ljx/JvwY5SPzK2Get
5c62Ev8o9iMl5ohV+MupvzwYUy3kzmbtXfRy1pait7L2ddY9WR+5pmrVqKdS
5yj2Svw3Yi9MjcVD2EvQj+nN2L8PexJ7TSw4N6bmfPSqgs/6bDA3LIrNLeKI
auyNkbEkjAg76mn1sjDUhv4c/vasMVobm1PFpdrzAHo9a23oC/LGvtakqwe6
easTkbl2DjLM/ZxBchlz7DxyzxaNbd1JA7Fd4uy87+xz7CsSc7N6XlwyiZyu
jDlFd72iYGzoznXWfGyu0ZmnFs1Z4qp9+I9R++Giuacnb24/HRlL4vjeyD2j
XhHmG4Tn1FgVpnW2tbF7RWcUdwgzwoo4ZFzsGaLZoR5Xr9akfiv17OvUXh2Z
C4r4j0fmZHGx7rA1NSeIC9SDwq5mjmaNMCzs9xXM1eoBYVE9q14VJvvxDUXu
JX1PgdxPiu5V9YS4/o/Ie4vz9+K7OjGXJfhfjX1HuhvNsCcLnrGareLQ2/Gv
xj+QM+do9vT/Px81g1oTAc+zWzNK2F4SGYvCuGblzbGxqpnZQvyDibGpGfUd
vhdTc5M4v1l4iTzr9U/wKfq0xNyvmSFuUc+r18Uxk7V35F4XRsQ1wqCwJ87R
2dXz6nV9g2bNVYlnnWbO3+iDiWex/jGGyR0puvc04y4X9xWNpf3If1vnGOs=

         "],
         VertexColors->None]}]}, 
     {RGBColor[0.91439425, 0.8976069999999999, 0.8460412], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmGuM1OUVxt+ZYWb+sx2TspAQWS3ahJRFayWFFWhrq7a6ULHJchGXbdJi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         "],
         VertexColors->None], 
        PolygonBox[{{2806, 2673, 1050, 1146}, {1930, 2054, 274, 186}, {2695, 
         2061, 421, 576}, {3082, 2043, 411, 1420}, {2369, 2806, 1146, 791}, {
         3165, 2023, 398, 1509}, {3077, 1871, 522, 1414}, {2081, 3274, 1659, 
         276}, {2169, 2370, 791, 1513}, {2674, 2672, 1420, 1050}, {3166, 2169,
          1513, 1512}, {2168, 3166, 1512, 171}, {2129, 3256, 1602, 383}, {
         1871, 2333, 768, 522}, {3161, 2137, 530, 777}, {3152, 2130, 521, 
         1491}, {3266, 1889, 127, 1620}, {2087, 1950, 276, 421}, {3256, 1869, 
         70, 1602}, {3164, 2151, 1509, 1508}, {2000, 3012, 1335, 1407}, {1877,
          2299, 737, 98}, {1889, 3018, 1343, 127}, {2336, 2129, 383, 771}, {
         3076, 2008, 376, 521}, {3017, 3016, 1342, 1343}, {3012, 3144, 1484, 
         1335}, {2002, 2614, 512, 368}, {3013, 3152, 1491, 1337}, {2007, 3013,
          1337, 1411}, {3274, 2080, 186, 1659}, {2298, 2144, 539, 737}, {3190,
          3189, 171, 1539}, {1874, 2335, 771, 529}, {2138, 3162, 733, 530}, {
         2663, 2037, 407, 559}, {2066, 2728, 456, 424}, {3191, 3192, 1539, 
         274}, {3139, 3140, 1407, 58}, {2313, 2312, 446, 456}, {2293, 2136, 
         529, 733}, {2123, 2124, 368, 59}, {2292, 1908, 58, 510}, {2043, 2805,
          559, 411}, {1876, 2345, 777, 539}, {3150, 3151, 1411, 70}, {2696, 
         2067, 424, 579}, {3081, 3080, 112, 1342}, {2150, 3164, 1508, 112}, {
         3260, 1877, 98, 1613}, {2811, 2696, 579, 1152}, {3143, 3141, 510, 
         1482}, {3145, 2123, 59, 1484}, {3075, 3078, 1414, 376}, {2145, 3260, 
         1613, 398}, {2156, 3266, 1620, 407}, {2082, 2390, 576, 446}, {2333, 
         3142, 1482, 768}},
         VertexColors->None]}]}, 
     {RGBColor[0.941176, 0.906538, 0.834043], EdgeForm[None], 
      GraphicsGroupBox[
       PolygonBox[{{314, 301, 280}, {210, 263, 209}, {280, 301, 263}, {301, 
        264, 263}, {280, 263, 210}, {263, 224, 209}, {263, 264, 224}, {301, 
        318, 264}, {301, 314, 225}, {318, 301, 225}},
        VertexColors->None]]}}, {{}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{2810, 2811, 2696, 2067, 3088, 2066, 2728, 2089, 2313, 2312, 
         2465, 2082, 2390, 2176, 2695, 2061, 3085, 2060, 2087, 1950, 2081, 
         3274, 2080, 1900, 1930, 2054, 1949, 3191, 3192, 3188, 3190, 3189, 
         1897, 1927, 2168, 3166, 2169, 2370, 2369, 2806, 2673, 2674, 2672, 
         3082, 2043, 2805, 2162, 2663, 2037, 2520, 2036, 2156, 3266, 1889, 
         3018, 3017, 3016, 3081, 3080, 1884, 1917, 2150, 3164, 2151, 3165, 
         2023, 2145, 3260, 1877, 2299, 2298, 2144, 3259, 1876, 2345, 3161, 
         2137, 3160, 2138, 3162, 2293, 2136, 3258, 1874, 2335, 2336, 2129, 
         3256, 1869, 1910, 3150, 3151, 3074, 2007, 3013, 3152, 2130, 3257, 
         1870, 3076, 2008, 3075, 3078, 3077, 1871, 2333, 3142, 3143, 3141, 
         2122, 2292, 1908, 3139, 3140, 3071, 2000, 3012, 3144, 3145, 2123, 
         2124, 2001, 2613, 2002, 2614, 2981}],
        "0.9`"],
       Annotation[#, 0.9, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1862, 2611, 2612, 2608, 2610, 2609, 2979, 2978, 2607, 1998, 
         2605, 1997, 2606, 2977, 2604, 1996, 2603, 1995, 3133, 2114, 3132, 
         2113, 3131, 3130, 3010, 1994, 3069, 2112, 3129, 1906, 3128, 3009, 
         3068, 3067, 3127, 1905, 1861, 3251, 2111, 2329, 2328, 1867, 3255, 
         2121, 3138, 3011, 1999, 3070, 3137, 3136, 1907, 1866, 3254, 2120, 
         2006, 3149, 2128, 3148, 2127, 1909, 1868, 3079, 2011, 3014, 3015, 
         3158, 3159, 3156, 2135, 3157, 2343, 2344, 2143, 3163, 2142, 1913, 
         1875, 2643, 2644, 2499, 2500, 1916, 1883, 2993, 2655, 2030, 2511, 
         2512, 2513, 2996, 2662, 2035, 2519, 2521, 2803, 2804, 2802, 2161, 
         2670, 2041, 2529, 2042, 2671, 2164, 2677, 2047, 2536, 2048, 2678, 
         2170, 2935, 2271, 2562, 2563, 2440, 2208, 2844, 2210, 2842, 2209, 
         2843, 2324, 3236, 2272, 2937, 2273, 2938, 2212, 2847, 2214, 2845, 
         2213, 2846, 2274, 2939, 3286, 2220, 3201, 2221, 2864, 3196, 2217, 
         2859, 2860, 2856, 2858, 2857, 2861}],
        "0.8`"],
       Annotation[#, 0.8, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{2110, 2097, 1962, 2250, 1963, 2233, 2892, 2829, 2199, 3180, 
         2198, 2973, 1857, 3278, 2601, 3250, 2602, 2598, 2600, 2599, 1856, 
         2972, 2597, 1990, 2595, 1989, 2596, 2971, 2594, 1988, 2592, 1987, 
         2593, 2970, 2591, 1986, 2589, 1985, 3288, 2590, 2969, 2968, 3125, 
         3124, 2780, 2480, 1984, 2588, 2109, 3123, 3122, 3003, 1983, 3060, 
         3119, 3118, 1903, 2289, 2108, 3120, 2107, 3121, 2326, 1860, 3064, 
         1993, 3062, 1992, 3063, 3066, 3065, 3126, 2327, 1865, 3253, 2118, 
         2290, 2291, 2980, 3135, 2119, 3072, 2004, 3073, 2005, 2618, 2126, 
         3147, 2787, 2788, 2622, 2624, 2623, 3155, 2795, 2796, 2628, 2630, 
         2629, 2799, 2346, 1881, 2474, 2473, 2148, 2300, 1915, 1882, 2652, 
         2653, 2509, 2510, 1921, 1888, 2659, 2660, 2517, 2518, 1923, 1891, 
         2667, 2668, 2528, 2530, 1925, 1894, 2675, 2676, 2535, 2537, 1926, 
         1896, 2373, 2374, 2207, 2304, 2841, 1929, 1899, 2375, 2936, 2376, 
         2211, 2443, 2305, 2306, 2478, 2380, 2064, 2444, 2307, 2308, 2479}],
        "0.7`"],
       Annotation[#, 0.7, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{2178, 2383, 2065, 2433, 2063, 2378, 2175, 2694, 2059, 2546, 
         2058, 2690, 2172, 2685, 2053, 2542, 2052, 2681, 2167, 2368, 2046, 
         2420, 2045, 2366, 2163, 2669, 2040, 2524, 2039, 2666, 2160, 2661, 
         2034, 2515, 2033, 2658, 2155, 2654, 2029, 2507, 2028, 2651, 2149, 
         2642, 2022, 2496, 2021, 2641, 2141, 2627, 2016, 2486, 2015, 2626, 
         2794, 2793, 3279, 2620, 2982, 2621, 2619, 2786, 2785, 3146, 2616, 
         2617, 2615, 2784, 2783, 3134, 2401, 2402, 2264, 3252, 1864, 2398, 
         1859, 1904, 3008, 3007, 1991, 3061, 1855, 3249, 2106, 2105, 2434, 
         2435, 2278, 2467, 2282, 2283, 2197, 2826, 2828, 2827, 1935, 2397, 
         2461}],
        "0.6`"],
       Annotation[#, 0.6, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{2423, 2381, 2550, 2382, 2195, 2379, 2853, 2377, 2809, 2692, 
         3267, 2693, 2545, 2691, 2689, 2808, 2683, 2684, 2541, 2682, 2680, 
         2807, 2367, 2417, 2418, 2302, 2165, 2362, 2361, 1893, 1924, 2526, 
         2523, 2665, 2664, 1890, 1922, 2516, 2514, 2657, 2656, 1887, 1920, 
         2508, 2506, 2649, 2648, 1880, 2992, 2498, 2497, 2495, 2020, 2638, 
         2990, 2488, 2487, 2485, 2014, 2625, 2983, 2791, 2134, 2792, 2010, 
         2429, 2009, 2334, 2125, 2332, 2003, 2428, 2182, 2331, 2330, 2403, 
         2399, 2782, 2116, 2781, 2117, 3184, 3185, 3183, 2203, 2976, 2975, 
         3054, 2974, 3027, 3026, 1936, 3106, 3107, 3025, 3024, 3023, 2068, 
         2318, 2317, 2384, 3090, 3091, 3089, 3093, 3092, 1957, 2698, 2699, 
         2697, 3020, 3290, 3019, 1931, 3219, 2246, 3218, 2247, 3220, 2245, 
         3222, 2249, 3221, 2248, 1961, 2764, 2765, 2763, 2101, 2766, 2095, 
         2779, 2104, 2774, 2967}],
        "0.5`"],
       Annotation[#, 0.5, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1902, 2552, 2551, 2549, 2196, 2825, 2194, 2855, 2216, 3195, 
         2215, 3277, 3002, 1901, 3268, 2854, 2548, 2687, 2547, 3281, 3280, 
         2056, 2956, 2686, 3083, 3001, 2544, 2543, 2540, 2050, 2679, 3000, 
         2303, 2301, 2419, 2044, 2363, 2999, 2527, 2525, 2522, 2038, 2801, 
         2159, 2355, 2158, 2353, 2032, 2414, 2031, 2349, 2154, 2650, 2027, 
         2504, 2026, 2647, 2147, 2800, 2639, 2640, 2493, 2637, 2636, 2798, 
         2341, 2342, 2140, 2472, 2987, 2988, 2338, 1873, 1912, 2484, 2483, 
         2185, 2815, 2184, 2921, 2261, 2920, 2260, 3234, 3235, 3233, 2265, 
         2813, 2183, 2812, 3174, 3173, 2427, 1938, 2319, 2320, 2405, 2404, 
         1979, 3056, 3055, 3283, 2069, 3094, 3031, 3197, 3198, 2567, 2568, 
         2400, 2115, 2448, 2229, 2468, 2469, 2284, 1863, 2449, 1858, 3006, 
         3005, 3004, 2179, 2425, 2424, 1958, 3043, 2720, 2084, 3105, 2083, 
         3021, 3022, 2830, 2200, 3181, 2090, 3038, 3039, 3040, 2102, 3117, 
         1952, 2314, 2228, 2573, 2574, 1960, 2436, 2464, 2385, 2386, 2227, 
         2447, 2309, 2310, 2096, 2745, 2759, 2755, 1967, 2737, 2741, 2733, 
         2778, 2773, 1854}],
        "0.4`"],
       Annotation[#, 0.4, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1982, 2718, 2719, 2566, 2862, 3270, 1945, 2863, 1944, 2565, 
         2564, 2850, 2849, 2174, 2927, 2928, 2688, 2958, 3282, 2057, 3084, 
         2055, 2959, 2955, 2280, 2957, 2171, 2372, 2051, 2432, 2049, 2371, 
         2166, 2421, 2364, 2532, 2365, 2191, 2360, 2833, 2359, 2416, 2357, 
         2358, 2187, 2356, 2354, 2415, 2351, 2352, 2157, 2350, 2476, 3275, 
         2477, 2995, 2994, 1886, 1919, 3265, 3264, 2505, 2503, 2646, 2645, 
         1879, 1914, 2494, 2492, 2018, 2634, 2989, 2297, 2296, 2408, 2013, 
         2789, 2790, 2470, 2133, 2922, 2923, 2584, 2924, 2925, 2262, 3228, 
         3230, 3229, 1978, 2460, 1977, 3273, 2263, 2103, 2769, 2702, 2703, 
         2701, 2705, 2704, 1946, 2406, 2888, 2889, 2887, 2230, 2891, 2232, 
         2890, 2231, 2286, 2285, 3172, 2181, 3171, 2180, 2426, 1959, 2722, 
         2723, 2721, 3108, 2085, 3284, 3029, 3030, 3182, 2202, 3285, 3028, 
         2092, 2569, 2767, 3271, 1954, 2768, 1953, 3212, 3213, 3211, 2238, 
         3214, 2201, 2437, 2268, 2929, 2931, 2930, 2098, 3112, 2099, 2760, 
         3049, 1971, 2453, 2579, 2578, 2577, 2275, 2395, 3239, 2394, 2872, 
         2225, 2867, 2226, 2875, 2224, 2883, 2886, 2880, 3207, 3204, 1934, 
         2748, 2751, 2744, 2758, 2754, 1966, 2736, 2740, 2732, 2777, 2772, 
         1853}],
        "0.3`"],
       Annotation[#, 0.3, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{2325, 2714, 2715, 2713, 2717, 2716, 1951, 2851, 2852, 2848, 
         3194, 3193, 2422, 2462, 2463, 2267, 2961, 2962, 2960, 3248, 3247, 
         2173, 2966, 2964, 2965, 2963, 2281, 2442, 2441, 1898, 1928, 2539, 
         2538, 2824, 2823, 2193, 2839, 2840, 2836, 2838, 2837, 1895, 2534, 
         2533, 2531, 2192, 2822, 2190, 2835, 2206, 2832, 2205, 2834, 1892, 
         2288, 2189, 2821, 2188, 3179, 2431, 3035, 3034, 2554, 2204, 2831, 
         2287, 2819, 2820, 2818, 3178, 3177, 2413, 1939, 2553, 2409, 3276, 
         2153, 2410, 2152, 2348, 2025, 2430, 2024, 2347, 2146, 2635, 2019, 
         2490, 2633, 2632, 2797, 2339, 2340, 2139, 2471, 2984, 2985, 2337, 
         1872, 1911, 2482, 2481, 2814, 3176, 3175, 2585, 2926, 3231, 3232, 
         3052, 3053, 1976, 2459, 1975, 2586, 2587, 3059, 3058, 1980, 3057, 
         3287, 2259, 3227, 3050, 3051, 2456, 2457, 2277, 2954, 2276, 3244, 
         2391, 1937, 3033, 3032, 3187, 3186, 2094, 2570, 3041, 3042, 2387, 
         1955, 3217, 2243, 3216, 2244, 2439, 2438, 2933, 2269, 2932, 2270, 
         2934, 2100, 3113, 3114, 2762, 3289, 2761, 1973, 2454, 1972, 2581, 
         2580, 2948, 2947, 2091, 2898, 2235, 2575, 3044, 3045, 2450, 2451, 
         2237, 2900, 2236, 3209, 1969, 2910, 2253, 2907, 2914, 2912, 2252, 
         2943, 2945, 2941, 3241, 3238, 2393, 2869, 2871, 2866, 2877, 2874, 
         2223, 2882, 2885, 2879, 3206, 3203, 1933, 2747, 2750, 2743, 2757, 
         2753, 1965, 2735, 2739, 2731, 2776, 2771, 1852}],
        "0.2`"],
       Annotation[#, 0.2, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1851, 2770, 2775, 2730, 2738, 2734, 1964, 2752, 2756, 2742, 
         2749, 2746, 1932, 3202, 3205, 2878, 2884, 2881, 2222, 2873, 2876, 
         2865, 2870, 2868, 2392, 3237, 3240, 2940, 2944, 2942, 2251, 2911, 
         2913, 2906, 2909, 2908, 1968, 3208, 3210, 2899, 2902, 2901, 2234, 
         2896, 2897, 2893, 2895, 2894, 2396, 3242, 3243, 2946, 2950, 2949, 
         2254, 2917, 2256, 2915, 2255, 2916, 1970, 3215, 2241, 2904, 2242, 
         2905, 2239, 2452, 3046, 2576, 2240, 2903, 2093, 3111, 2729, 3095, 
         2070, 3096, 2071, 2700, 3048, 3047, 3116, 3115, 2311, 2458, 2072, 
         2388, 2583, 2455, 2257, 2466, 2315, 2316, 2953, 2952, 1974, 3272, 
         2951, 2582, 3224, 3223, 2131, 3153, 2132, 3154, 2012, 2407, 2294, 
         2295, 2986, 2631, 2017, 2489, 2491, 3261, 3262, 3263, 1878, 2991, 
         2258, 3225, 3226, 2919, 2918, 2186, 2816, 2817, 2501, 2502, 1918, 
         1885, 2389, 2998, 2997, 2475, 2266, 2412, 2411, 1947, 2709, 2710, 
         2706, 2708, 2707, 2321, 3098, 2073, 3097, 2074, 3099, 1948, 3102, 
         2076, 3100, 2075, 3101, 2322, 2323, 2077, 2555, 2556, 2557, 2086, 
         2725, 2724, 2558, 2078, 2711, 1981, 2712, 2079, 2559, 2560, 1940, 
         2727, 1941, 3269, 2726, 2561, 2572, 2571, 1956, 2445, 2446, 2219, 
         3199, 2218, 3200, 1942, 2279, 3245, 3246, 3167, 3169, 3168, 3170, 
         3103, 3104, 3036, 3037, 1943, 2088, 3109, 3110, 3086, 2062, 3087, 
         2177}],
        "0.1`"],
       Annotation[#, 0.1, "Tooltip"]& ]}, {}, {}, {}}}],
  AspectRatio->1,
  Frame->True,
  FrameTicks->True,
  ImageMargins->0.,
  ImageSize->{225, Automatic},
  Method->{},
  PlotRange->NCache[{{0, 4}, {
      Rational[1, 10], 3}}, {{0, 4}, {0.1, 3}}],
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{229, 226},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->31235361]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->10468],

Cell["The probability density function integrates to unity:", "ExampleText",
 CellID->26074],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"PDF", "[", 
    RowBox[{
     RowBox[{"WeibullDistribution", "[", 
      RowBox[{"\[Alpha]", ",", "\[Beta]"}], "]"}], ",", "x"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "\[Infinity]"}], "}"}], ",", 
   RowBox[{"Assumptions", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"\[Alpha]", ">", "0"}], ",", 
      RowBox[{"\[Beta]", ">", "0"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->11395],

Cell[BoxData["1"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->484042982]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->202447451],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["WeibullDistribution",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/WeibullDistribution"]], "InlineFormula"],
 " is exponentially related to ",
 Cell[BoxData[
  ButtonBox["ExtremeValueDistribution",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ExtremeValueDistribution"]], "InlineFormula"],
 " :"
}], "ExampleText",
 CellID->28196863],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"PDF", "[", 
   RowBox[{
    RowBox[{"WeibullDistribution", "[", 
     RowBox[{"1", ",", "1"}], "]"}], ",", 
    RowBox[{"Exp", "[", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"x", "-", "a"}], ")"}], "/", "b"}], "]"}]}], "]"}], 
  RowBox[{"D", "[", 
   RowBox[{
    RowBox[{"Exp", "[", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"x", "-", "a"}], ")"}], "/", "b"}], "]"}], ",", "x"}], 
   "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->219525460],

Cell[BoxData[
 FractionBox[
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{
    RowBox[{"-", 
     SuperscriptBox["\[ExponentialE]", 
      FractionBox[
       RowBox[{
        RowBox[{"-", "a"}], "+", "x"}], "b"]]}], "+", 
    FractionBox[
     RowBox[{
      RowBox[{"-", "a"}], "+", "x"}], "b"]}]], "b"]], "Output",
 ImageSize->{78, 44},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->15710885]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PDF", "[", 
  RowBox[{
   RowBox[{"ExtremeValueDistribution", "[", 
    RowBox[{
     RowBox[{"-", "a"}], ",", "b"}], "]"}], ",", 
   RowBox[{"-", "x"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->90830430],

Cell[BoxData[
 FractionBox[
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{
    RowBox[{"-", 
     SuperscriptBox["\[ExponentialE]", 
      FractionBox[
       RowBox[{
        RowBox[{"-", "a"}], "+", "x"}], "b"]]}], "+", 
    FractionBox[
     RowBox[{
      RowBox[{"-", "a"}], "+", "x"}], "b"]}]], "b"]], "Output",
 ImageSize->{78, 44},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->140289021]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->63845401],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["WeibullDistribution",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/WeibullDistribution"]], "InlineFormula"],
 " is exponentially related to ",
 Cell[BoxData[
  ButtonBox["GumbelDistribution",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GumbelDistribution"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->77807631],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"PDF", "[", 
   RowBox[{
    RowBox[{"WeibullDistribution", "[", 
     RowBox[{"1", ",", "1"}], "]"}], ",", 
    RowBox[{"Exp", "[", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"x", "-", "a"}], ")"}], "/", "b"}], "]"}]}], "]"}], 
  RowBox[{"D", "[", 
   RowBox[{
    RowBox[{"Exp", "[", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"x", "-", "a"}], ")"}], "/", "b"}], "]"}], ",", "x"}], 
   "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->42817944],

Cell[BoxData[
 FractionBox[
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{
    RowBox[{"-", 
     SuperscriptBox["\[ExponentialE]", 
      FractionBox[
       RowBox[{
        RowBox[{"-", "a"}], "+", "x"}], "b"]]}], "+", 
    FractionBox[
     RowBox[{
      RowBox[{"-", "a"}], "+", "x"}], "b"]}]], "b"]], "Output",
 ImageSize->{78, 44},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->80802939]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PDF", "[", 
  RowBox[{
   RowBox[{"GumbelDistribution", "[", 
    RowBox[{"a", ",", "b"}], "]"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->890175076],

Cell[BoxData[
 FractionBox[
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{
    RowBox[{"-", 
     SuperscriptBox["\[ExponentialE]", 
      FractionBox[
       RowBox[{
        RowBox[{"-", "a"}], "+", "x"}], "b"]]}], "+", 
    FractionBox[
     RowBox[{
      RowBox[{"-", "a"}], "+", "x"}], "b"]}]], "b"]], "Output",
 ImageSize->{78, 44},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->2081109]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->34754496],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["WeibullDistribution",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/WeibullDistribution"]], "InlineFormula"],
 " is related to ",
 Cell[BoxData[
  ButtonBox["ExponentialDistribution",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ExponentialDistribution"]], "InlineFormula"],
 " through a power:"
}], "ExampleText",
 CellID->306560643],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"wpdf", "=", 
  RowBox[{"PDF", "[", 
   RowBox[{
    RowBox[{"WeibullDistribution", "[", 
     RowBox[{"a", ",", "b"}], "]"}], ",", "x"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->811178942],

Cell[BoxData[
 RowBox[{"a", " ", 
  SuperscriptBox["b", 
   RowBox[{"-", "a"}]], " ", 
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{"-", 
    SuperscriptBox[
     RowBox[{"(", 
      FractionBox["x", "b"], ")"}], "a"]}]], " ", 
  SuperscriptBox["x", 
   RowBox[{
    RowBox[{"-", "1"}], "+", "a"}]]}]], "Output",
 ImageSize->{101, 22},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->45681483]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"PDF", "[", 
   RowBox[{
    RowBox[{"ExponentialDistribution", "[", "1", "]"}], ",", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"x", "/", "b"}], ")"}], "^", "a"}]}], "]"}], 
  RowBox[{"D", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"x", "/", "b"}], ")"}], "^", "a"}], ",", "x"}], 
   "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->580910229],

Cell[BoxData[
 FractionBox[
  RowBox[{"a", " ", 
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"-", 
     SuperscriptBox[
      RowBox[{"(", 
       FractionBox["x", "b"], ")"}], "a"]}]], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     FractionBox["x", "b"], ")"}], 
    RowBox[{
     RowBox[{"-", "1"}], "+", "a"}]]}], "b"]], "Output",
 ImageSize->{102, 44},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->443692479]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"%", "\[Equal]", "wpdf"}], "//", "PowerExpand"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->9976307],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->26906268]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->18585],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["WeibullDistribution",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/WeibullDistribution"]], "InlineFormula"],
 " is not defined when either ",
 Cell[BoxData[
  StyleBox["\[Alpha]", "TR"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  StyleBox["\[Beta]", "TR"]], "InlineFormula"],
 " is not a positive real number:"
}], "ExampleText",
 CellID->5722],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Mean", "[", 
  RowBox[{"WeibullDistribution", "[", 
   RowBox[{
    RowBox[{"-", "1"}], ",", "2"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->8971],

Cell[BoxData[
 RowBox[{
  RowBox[{"WeibullDistribution", "::", "\<\"posparm\"\>"}], ":", 
  " ", "\<\"\\!\\(\\*StyleBox[\\\"\\\\\\\"Parameter \\\\\\\"\\\", \
\\\"MSG\\\"]\\)\\!\\(-1\\)\\!\\(\\*StyleBox[\\\"\\\\\\\" is expected to be \
positive.\\\\\\\"\\\", \\\"MSG\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->10057],

Cell[BoxData[
 RowBox[{"Mean", "[", 
  RowBox[{"WeibullDistribution", "[", 
   RowBox[{
    RowBox[{"-", "1"}], ",", "2"}], "]"}], "]"}]], "Output",
 ImageSize->{226, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->14095]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->8174],

Cell["\<\
The characteristic function of the Weibull distribution does not have a \
closed\[Hyphen]form representation:\
\>", "ExampleText",
 CellID->5038],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CharacteristicFunction", "[", 
  RowBox[{
   RowBox[{"WeibullDistribution", "[", 
    RowBox[{"\[Alpha]", ",", "\[Beta]"}], "]"}], ",", "t"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2183],

Cell[BoxData[
 RowBox[{"CharacteristicFunction", "[", 
  RowBox[{
   RowBox[{"WeibullDistribution", "[", 
    RowBox[{"\[Alpha]", ",", "\[Beta]"}], "]"}], ",", "t"}], "]"}]], "Output",\

 ImageSize->{363, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->26658]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->19046],

Cell["\<\
Substitution of invalid parameters into symbolic outputs gives results that \
are not meaningful:\
\>", "ExampleText",
 CellID->16727],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Mean", "[", 
   RowBox[{"WeibullDistribution", "[", 
    RowBox[{"\[Alpha]", ",", "\[Beta]"}], "]"}], "]"}], "/.", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"\[Alpha]", "\[Rule]", "2"}], ",", 
    RowBox[{"\[Beta]", "\[Rule]", 
     RowBox[{"1", "-", "I"}]}]}], "}"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->25838],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    FractionBox["1", "2"], "-", 
    FractionBox["\[ImaginaryI]", "2"]}], ")"}], " ", 
  SqrtBox["\[Pi]"]}]], "Output",
 ImageSize->{82, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->670179028]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->19406],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["ExtremeValueDistribution",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ExtremeValueDistribution"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["GumbelDistribution",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/GumbelDistribution"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->29427]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->3850],

Cell[TextData[ButtonBox["Continuous Distributions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ContinuousDistributions"]], "Tutorials",
 CellID->7471]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->636469],

Cell[TextData[ButtonBox["Continuous Statistical Distributions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ContinuousStatisticalDistributions"]], "MoreAbout",\

 CellID->474513230]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"WeibullDistribution - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 29, 20.8052550}", "context" -> "System`", 
    "keywords" -> {"distribution of lifetimes", "Weibull distribution"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "WeibullDistribution[\\[Alpha], \\[Beta]] represents a Weibull \
distribution with shape parameter \\[Alpha] and scale parameter \\[Beta].", 
    "synonyms" -> {"weibull distribution"}, "title" -> "WeibullDistribution", 
    "type" -> "Symbol", "uri" -> "ref/WeibullDistribution"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[7429, 241, 358, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1998831]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 132743, 2904}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2005, 51, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2628, 78, 1584, 37, 70, "ObjectNameGrid"],
Cell[4215, 117, 771, 24, 70, "Usage",
 CellID->28168]
}, Open  ]],
Cell[CellGroupData[{
Cell[5023, 146, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5501, 163, 818, 30, 70, "Notes",
 CellID->429991538],
Cell[6322, 195, 367, 13, 70, "Notes",
 CellID->655],
Cell[6692, 210, 700, 26, 70, "Notes",
 CellID->33143606]
}, Closed]],
Cell[CellGroupData[{
Cell[7429, 241, 358, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1998831],
Cell[CellGroupData[{
Cell[7812, 255, 148, 5, 70, "ExampleSection",
 CellID->261423698],
Cell[7963, 262, 300, 9, 70, "ExampleText",
 CellID->25587],
Cell[CellGroupData[{
Cell[8288, 275, 179, 5, 28, "Input",
 CellID->31417],
Cell[8470, 282, 272, 9, 51, "Output",
 CellID->178202048]
}, Open  ]],
Cell[CellGroupData[{
Cell[8779, 296, 182, 5, 28, "Input",
 CellID->6153],
Cell[8964, 303, 495, 17, 52, "Output",
 CellID->150014838]
}, Open  ]],
Cell[9474, 323, 121, 3, 70, "ExampleDelimiter",
 CellID->20595],
Cell[9598, 328, 115, 2, 70, "ExampleText",
 CellID->1495],
Cell[CellGroupData[{
Cell[9738, 334, 203, 6, 70, "Input",
 CellID->29213],
Cell[9944, 342, 486, 16, 44, "Output",
 CellID->211639360]
}, Open  ]],
Cell[CellGroupData[{
Cell[10467, 363, 310, 10, 70, "Input",
 CellID->27370],
Cell[10780, 375, 2192, 46, 169, "Output",
 CellID->656989588]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[13021, 427, 216, 7, 70, "ExampleSection",
 CellID->22496],
Cell[13240, 436, 115, 3, 70, "ExampleText",
 CellID->24833],
Cell[CellGroupData[{
Cell[13380, 443, 197, 6, 70, "Input",
 CellID->24223],
Cell[13580, 451, 333, 10, 36, "Output",
 CellID->12777045]
}, Open  ]],
Cell[13928, 464, 121, 3, 70, "ExampleDelimiter",
 CellID->17879],
Cell[14052, 469, 83, 1, 70, "ExampleText",
 CellID->20699375],
Cell[CellGroupData[{
Cell[14160, 474, 183, 5, 70, "Input",
 CellID->30519],
Cell[14346, 481, 1006, 34, 71, "Output",
 CellID->100914601]
}, Open  ]],
Cell[CellGroupData[{
Cell[15389, 520, 183, 5, 70, "Input",
 CellID->31585],
Cell[15575, 527, 1309, 43, 84, "Output",
 CellID->118737442]
}, Open  ]],
Cell[16899, 573, 121, 3, 70, "ExampleDelimiter",
 CellID->31371],
Cell[17023, 578, 238, 9, 70, "ExampleText",
 CellID->15444],
Cell[CellGroupData[{
Cell[17286, 591, 208, 6, 70, "Input",
 CellID->17107],
Cell[17497, 599, 343, 12, 43, "Output",
 CellID->40377227]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[17889, 617, 223, 7, 70, "ExampleSection",
 CellID->16519],
Cell[18115, 626, 252, 7, 70, "ExampleText",
 CellID->13370],
Cell[CellGroupData[{
Cell[18392, 637, 311, 10, 70, "Input",
 CellID->26124],
Cell[18706, 649, 2627, 47, 70, "Output",
 Evaluatable->False,
 CellID->87336137]
}, Open  ]],
Cell[21348, 699, 125, 3, 70, "ExampleDelimiter",
 CellID->112332000],
Cell[21476, 704, 224, 9, 70, "ExampleText",
 CellID->2435],
Cell[CellGroupData[{
Cell[21725, 717, 426, 13, 70, "Input",
 CellID->1028],
Cell[22154, 732, 96211, 1609, 70, "Output",
 CellID->31235361]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[118414, 2347, 233, 7, 70, "ExampleSection",
 CellID->10468],
Cell[118650, 2356, 92, 1, 70, "ExampleText",
 CellID->26074],
Cell[CellGroupData[{
Cell[118767, 2361, 506, 15, 70, "Input",
 CellID->11395],
Cell[119276, 2378, 158, 5, 36, "Output",
 CellID->484042982]
}, Open  ]],
Cell[119449, 2386, 125, 3, 70, "ExampleDelimiter",
 CellID->202447451],
Cell[119577, 2391, 385, 12, 70, "ExampleText",
 CellID->28196863],
Cell[CellGroupData[{
Cell[119987, 2407, 497, 18, 70, "Input",
 CellID->219525460],
Cell[120487, 2427, 448, 16, 65, "Output",
 CellID->15710885]
}, Open  ]],
Cell[CellGroupData[{
Cell[120972, 2448, 238, 8, 70, "Input",
 CellID->90830430],
Cell[121213, 2458, 449, 16, 65, "Output",
 CellID->140289021]
}, Open  ]],
Cell[121677, 2477, 124, 3, 70, "ExampleDelimiter",
 CellID->63845401],
Cell[121804, 2482, 372, 12, 70, "ExampleText",
 CellID->77807631],
Cell[CellGroupData[{
Cell[122201, 2498, 496, 18, 70, "Input",
 CellID->42817944],
Cell[122700, 2518, 448, 16, 65, "Output",
 CellID->80802939]
}, Open  ]],
Cell[CellGroupData[{
Cell[123185, 2539, 193, 6, 70, "Input",
 CellID->890175076],
Cell[123381, 2547, 447, 16, 65, "Output",
 CellID->2081109]
}, Open  ]],
Cell[123843, 2566, 124, 3, 70, "ExampleDelimiter",
 CellID->34754496],
Cell[123970, 2571, 385, 12, 70, "ExampleText",
 CellID->306560643],
Cell[CellGroupData[{
Cell[124380, 2587, 223, 7, 70, "Input",
 CellID->811178942],
Cell[124606, 2596, 445, 16, 43, "Output",
 CellID->45681483]
}, Open  ]],
Cell[CellGroupData[{
Cell[125088, 2617, 405, 15, 70, "Input",
 CellID->580910229],
Cell[125496, 2634, 471, 17, 65, "Output",
 CellID->443692479]
}, Open  ]],
Cell[CellGroupData[{
Cell[126004, 2656, 134, 4, 70, "Input",
 CellID->9976307],
Cell[126141, 2662, 160, 5, 36, "Output",
 CellID->26906268]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[126350, 2673, 226, 7, 70, "ExampleSection",
 CellID->18585],
Cell[126579, 2682, 394, 13, 70, "ExampleText",
 CellID->5722],
Cell[CellGroupData[{
Cell[126998, 2699, 185, 6, 70, "Input",
 CellID->8971],
Cell[127186, 2707, 316, 6, 70, "Message",
 CellID->10057],
Cell[127505, 2715, 275, 9, 36, "Output",
 CellID->14095]
}, Open  ]],
Cell[127795, 2727, 120, 3, 70, "ExampleDelimiter",
 CellID->8174],
Cell[127918, 2732, 155, 4, 70, "ExampleText",
 CellID->5038],
Cell[CellGroupData[{
Cell[128098, 2740, 221, 6, 70, "Input",
 CellID->2183],
Cell[128322, 2748, 313, 10, 36, "Output",
 CellID->26658]
}, Open  ]],
Cell[128650, 2761, 121, 3, 70, "ExampleDelimiter",
 CellID->19046],
Cell[128774, 2766, 144, 4, 70, "ExampleText",
 CellID->16727],
Cell[CellGroupData[{
Cell[128943, 2774, 353, 11, 70, "Input",
 CellID->25838],
Cell[129299, 2787, 301, 11, 51, "Output",
 CellID->670179028]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[129661, 2805, 311, 9, 70, "SeeAlsoSection",
 CellID->19406],
Cell[129975, 2816, 503, 17, 70, "SeeAlso",
 CellID->29427]
}, Open  ]],
Cell[CellGroupData[{
Cell[130515, 2838, 313, 9, 70, "TutorialsSection",
 CellID->3850],
Cell[130831, 2849, 157, 3, 70, "Tutorials",
 CellID->7471]
}, Open  ]],
Cell[CellGroupData[{
Cell[131025, 2857, 316, 9, 70, "MoreAboutSection",
 CellID->636469],
Cell[131344, 2868, 184, 4, 70, "MoreAbout",
 CellID->474513230]
}, Open  ]],
Cell[131543, 2875, 27, 0, 70, "History"],
Cell[131573, 2877, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

