(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    306959,       5640]
NotebookOptionsPosition[    301268,       5447]
NotebookOutlinePosition[    302742,       5487]
CellTagsIndexPosition[    302655,       5482]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Elliptic Integrals and Elliptic Functions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/EllipticIntegralsAndEllipticFunctions"]}, #, 2]& ,
         Evaluator -> Automatic], {
       1->"\<\"Elliptic Integrals and Elliptic Functions\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"WeierstrassP" :> 
          Documentation`HelpLookup["paclet:ref/WeierstrassP"], 
          "InverseWeierstrassP" :> 
          Documentation`HelpLookup["paclet:ref/InverseWeierstrassP"], 
          "ModularLambda" :> 
          Documentation`HelpLookup["paclet:ref/ModularLambda"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"WeierstrassP\"\>", 
       2->"\<\"InverseWeierstrassP\"\>", 
       3->"\<\"ModularLambda\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Elliptic Functions" :> 
          Documentation`HelpLookup["paclet:guide/EllipticFunctions"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Elliptic Functions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["WeierstrassHalfPeriods", "ObjectName",
 CellID->824],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["WeierstrassHalfPeriods",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/WeierstrassHalfPeriods"], "[", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox[
          StyleBox["g", "TI"], 
          StyleBox["2", "TR"]], ",", 
         SubscriptBox[
          StyleBox["g", "TI"], 
          StyleBox["3", "TR"]]}], "}"}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the half\[Hyphen]periods ",
     Cell[BoxData[
      RowBox[{"{", 
       RowBox[{
        StyleBox["\[Omega]", "TR"], ",", 
        SuperscriptBox[
         StyleBox["\[Omega]", "TR"], 
         StyleBox["\[Prime]", "TI"]]}], "}"}]], "InlineFormula"],
     " for Weierstrass elliptic functions corresponding to the invariants ",
     Cell[BoxData[
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["g", "TI"], "2"], ",", 
        SubscriptBox[
         StyleBox["g", "TI"], "3"]}], "}"}]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->16745]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
Mathematical function, suitable for both symbolic and numerical manipulation.\
\
\>", "Notes",
 CellID->20640],

Cell[TextData[{
 "The half\[Hyphen]periods ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    StyleBox["\[Omega]", "TR"], ",", 
    SuperscriptBox[
     StyleBox["\[Omega]", "TR"], 
     StyleBox["\[Prime]", "TI"]]}], "}"}]], "InlineFormula"],
 " define the fundamental period parallelogram for the Weierstrass elliptic \
functions. "
}], "Notes",
 CellID->12549],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["WeierstrassHalfPeriods",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/WeierstrassHalfPeriods"]], "InlineFormula"],
 " is the inverse of ",
 Cell[BoxData[
  ButtonBox["WeierstrassInvariants",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/WeierstrassInvariants"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->7724],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["WeierstrassHalfPeriods",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/WeierstrassHalfPeriods"]], "InlineFormula"],
 " can be evaluated to arbitrary numerical precision."
}], "Notes",
 CellID->31226]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->438256462],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->859779327],

Cell["Evaluate numerically:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->285478447],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"WeierstrassHalfPeriods", "[", 
  RowBox[{"{", 
   RowBox[{"1.", ",", "2."}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->249957289],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"1.3083647626370964`", "\[InvisibleSpace]", "+", 
    RowBox[{"0.`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{"0.6541823813185482`", "\[InvisibleSpace]", "+", 
    RowBox[{"1.2293687516329148`", " ", "\[ImaginaryI]"}]}]}], 
  "}"}]], "Output",
 ImageSize->{245, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->3529434]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->171968836],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Re", "[", 
    RowBox[{"WeierstrassHalfPeriods", "[", 
     RowBox[{"{", 
      RowBox[{"g2", ",", 
       RowBox[{"1", "-", "I"}]}], "}"}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"g2", ",", 
     RowBox[{"-", "4"}], ",", "4"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->97309377],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 123},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->341596932]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->2578970],

Cell[TextData[{
 "Given the half\[Hyphen]periods, calculate a value of a Weierstrass ",
 Cell[BoxData[
  FormBox["\[WeierstrassP]", TraditionalForm]], "InlineMath"],
 " function:"
}], "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->78801090],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"WeierstrassP", "[", 
  RowBox[{"2.6", ",", 
   RowBox[{"WeierstrassInvariants", "[", 
    RowBox[{"{", 
     RowBox[{"1.5", ",", 
      RowBox[{"1", "-", "I"}]}], "}"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->67668500],

Cell[BoxData[
 RowBox[{"6.2387960932792135`", "\[InvisibleSpace]", "+", 
  RowBox[{"0.03368755892934194`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{133, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->343520363]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->175383112],

Cell["Evaluate to high precision:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->47300755],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"WeierstrassHalfPeriods", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}], "]"}], ",", "50"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->237003654],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
   "1.3083647626370968653240501853340822887833812579379000232220407008054`50.\
15051499783199", "+", 
    RowBox[{"0``50.03378615880089", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{
   "0.6541823813185484326620250926670411443916906289689500116110203525957`49.\
82239110559163", "+", 
    RowBox[{
    "1.2293687516329150991198952049855018530054666213339367819190297874769`50.\
09637443215636", " ", "\[ImaginaryI]"}]}]}], "}"}]], "Output",
 ImageSize->{461, 54},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->580451519]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->301702721],

Cell["\<\
The precision of the output track the precision of the input:\
\>", "ExampleText",
 CellID->204645271],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"WeierstrassHalfPeriods", "[", 
  RowBox[{"{", 
   RowBox[{"1", ",", "2.00000000000000000000000000000"}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->720882513],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
   "1.308364762637096865324050185334082288783381257938`29.451544993495975", 
    "+", 
    RowBox[{"0``29.334816154464875", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{
   "0.654182381318548432662025092667041144391690628969`29.123421101255612", 
    "+", 
    RowBox[{
    "1.229368751632915099119895204985501853005466621334`29.397404427820337", 
     " ", "\[ImaginaryI]"}]}]}], "}"}]], "Output",
 ImageSize->{476, 37},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->141010546]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->87254061],

Cell["Plot an elliptic function over a period parallelogram:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->266998498],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Module", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"g2", "=", "2."}], ",", 
     RowBox[{"g3", "=", "3"}], ",", "\[Omega]1", ",", "\[Omega]3"}], "}"}], 
   ",", 
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\[Omega]1", ",", "\[Omega]3"}], "}"}], "=", 
     RowBox[{"WeierstrassHalfPeriods", "[", 
      RowBox[{"{", 
       RowBox[{"g2", ",", "g3"}], "}"}], "]"}]}], ";", 
    RowBox[{"Graphics", "[", 
     RowBox[{"GeometricTransformation", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"ContourPlot", "[", 
          RowBox[{
           RowBox[{"Evaluate", "[", 
            RowBox[{"Sin", "[", 
             RowBox[{"Arg", "[", 
              RowBox[{"WeierstrassPPrime", "[", 
               RowBox[{
                RowBox[{
                 RowBox[{"x", " ", "\[Omega]1"}], "+", 
                 RowBox[{"y", " ", "\[Omega]3"}]}], ",", 
                RowBox[{"{", 
                 RowBox[{"g2", ",", "g3"}], "}"}]}], "]"}], "]"}], "]"}], 
            "]"}], ",", 
           RowBox[{"{", 
            RowBox[{"x", ",", 
             RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"y", ",", 
             RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
           RowBox[{"MaxRecursion", "->", "1"}]}], "]"}], "//", "First"}], "//",
         "Quiet"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Re", "[", "\[Omega]1", "]"}], ",", 
           RowBox[{"Im", "[", "\[Omega]1", "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Re", "[", "\[Omega]3", "]"}], ",", 
           RowBox[{"Im", "[", "\[Omega]3", "]"}]}], "}"}]}], "}"}]}], "]"}], 
     "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->713111678],

Cell[BoxData[
 GraphicsBox[GeometricTransformationBox[GraphicsComplexBox[CompressedData["
1:eJyMvXVclc/zPmyL3d3dnai4dgd2Y6LYid0KGCigiAhIKLYioIIKOLSgIo2U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    "], {{{}, 
      {RGBColor[0.33397672886243995`, 0.1279285534584573, 0.5864250111696041],
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmXmUVcURxu97bwZGmOW9mXkzOBhlERdAEGMUZRlQTCIqiycmIANCQFGQ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          "],
          VertexColors->None], PolygonBox[CompressedData["
1:eJwtlnmQFnIYx3/vVSvvu++177vbJkrkKEKYWK1Sg1zRDDPbNUWSs6hFMqPt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          "],
          VertexColors->None]}]}, 
      {RGBColor[0.4150981865873199, 0.26897686037537194`, 0.7004510335088123],
        EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJw1mHmQVNUVxt9MdyOl87pfd7/umSGpuCdiooJ7SqOmTKwYY0goA0FA0CAi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          "],
          VertexColors->None], PolygonBox[CompressedData["
1:eJwtmHmQVNUVxt9Md7Nov+7X3a9nTVwwLqAIGpdKgWBKJbFEsawEMwOCWrII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          "],
          VertexColors->None], 
         PolygonBox[{{4310, 4092, 4091, 3539, 896}, {3974, 4406, 933, 3611, 
          3973}, {4136, 6263, 1917, 6271, 4135}, {6693, 6690, 6689, 6696, 
          2191}, {3971, 5158, 5157, 3602, 453}, {6038, 5779, 5778, 5786, 
          1615}, {6094, 6697, 2191, 5213, 6093}, {3199, 4353, 916, 4352, 
          3198}, {6189, 6822, 6821, 6192, 1887}, {3556, 4347, 914, 4350, 
          3555}, {3850, 4132, 816, 3419, 3849}, {6267, 6259, 6258, 4558, 
          1917}, {4560, 4561, 819, 3424, 4559}, {5245, 3674, 3673, 4002, 
          749}, {5103, 3413, 3412, 5101, 1276}, {4358, 3199, 3198, 4356, 
          918}, {6892, 6193, 1887, 3968, 6891}, {5094, 3571, 1276, 5102, 
          5093}, {4374, 3964, 3963, 3592, 924}, {5779, 6166, 1873, 6165, 
          5778}, {6098, 6217, 1898, 6224, 6097}, {4221, 4723, 1103, 4725, 
          4220}, {6374, 6375, 1096, 4707, 6373}, {4092, 4650, 1071, 4649, 
          4091}, {5792, 4656, 4655, 3859, 1617}, {4120, 3181, 3180, 4119, 
          813}, {3955, 3569, 3568, 5607, 730}, {3346, 3225, 1084, 4688, 
          3345}, {5798, 5788, 1617, 5802, 5797}, {4484, 3888, 3887, 4482, 
          968}, {6105, 6115, 6114, 6123, 1830}, {4546, 3556, 3555, 4547, 
          1015}, {6881, 6158, 6157, 6167, 1873}, {4127, 5068, 5067, 6670, 
          2181}, {3418, 5785, 1615, 5784, 3417}, {3359, 5612, 1532, 5611, 
          3358}, {6422, 6421, 6420, 6346, 1961}, {3413, 4309, 895, 4308, 
          3412}, {5380, 4869, 4868, 3755, 1410}, {3696, 4221, 4220, 4495, 
          975}, {6475, 5215, 5214, 6447, 2018}, {4377, 3962, 433, 4375, 
          4376}, {4724, 3359, 3358, 3254, 1103}, {4524, 6325, 1953, 6321, 
          4523}, {6322, 3749, 3748, 6320, 1953}, {4004, 5437, 1439, 5436, 
          4003}, {3749, 4526, 774, 4048, 3748}, {4478, 4477, 4476, 3439, 
          837}, {3888, 4506, 982, 4505, 3887}, {5109, 3572, 439, 4145, 5108}},
          
          VertexColors->None]}]}, 
      {RGBColor[0.4962196443121998, 0.4100251672922865, 0.8144770558480204], 
       EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtmHuQl2UVx1/2wq7s/u7vb/f3YymykFsJWCCQMZEw2cUYRyNwqZh0tKYM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          "],
          VertexColors->None], PolygonBox[CompressedData["
1:eJwtmHlwVtUZxq8k7Pn2hS9fsIEKslhAtBAoWlE7rUVgqIqkgFBbxI46wCga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          "],
          VertexColors->None], PolygonBox[CompressedData["
1:eJwtlFtIk2EYxx+nNl3b3Nr2zSkEQuUi6GzgRXRREGl4EXQgAyvyyuEGQXXV
ybKuZ0pCRBQeqmWkaRcmXaSYVpaRoNSGJjSpSeGhzJT6vbzfxZ/nfH6/r+Bk
+EC1RUR2gUwQsYskXCJX0kXi0DByllvEyBHpThNZcohYkV9DH3lEYiDuE5kl
eGVApHKVyCmQzBXpsooc8YrsRb8AXwo9jPwGOggGwFtQliWymlptBjlBI9hE
/Xy/yDbsk8SWE5eH3Etuv1PESb0gupfILaAVlBPTQJ5m+J3U3wFfBIbp9x+2
v+gt9BvNEEmDLiJPuvTMas4J+FpVF/8p5kuCPPjb6M4x/1lwBixT/w5LG4NO
IXuwJ6GjyCfIGQFl1AhDj4PNAb0HNftWc57t5B6j5ig4RK8RdC3ssQk8Zs9Z
5GuGn8Y2ZO5okZgUsp2eLhF3Edjgb1K/ntwh6leBdmJn6M8Cb0OfDfKBlZ3V
EOMkppEYB/Qy8nqv1iu+0Kt368Vmo16CPAa8BwzncVPq36XXGPJ7ZDc7W8eM
G5k3CHWpHXK/Im7VtII5oVeRa8mbwB4HFfRVnKn3GTD7yvXq3X4n/jf2Eubt
Ze5v6g2CY+j66Pk8dauRQ+oO0CWwlhr11Epx0xl67mJ/p1Uuj/aphi8mXyyg
/efIsQfdC2abh58F15i9Mp9bM5uDHLXIMfb/EDwAPnUP/J3Ef8A+DEbgg/S0
j7zv6GEIVHj1Wz/o1+9Xvdmj6HrorxP/OuKiYLdZv4MeS5FLwBP4Kfb4y6n3
oGa3szuD2Dr4EXbfRu4xaBR5Qr1f8JQ8W8g3Dn+Del+4ywQw8PtK7HN0PX7N
N0C7/frbHXLoeu3md+ym7hp6HSdfDflcyJnMlgHSwT3kC+pWTv0dqm9vA/45
6DpydY+qr07zjbyC3qKPj/AG8f3I88Quk7uAve2n/hyyH9s0fingC2j/emw/
8fsBnpGzCv9B+r7Ojfqz+YfAD4BCevjDrRbU/ez6HaZzr/vkbQVN2EMZ2uez
+Z/65NP+/wHJtL5h
          "],
          VertexColors->None], 
         PolygonBox[{{6947, 5812, 5811, 6092, 2503, 2837}},
          VertexColors->None]}]}, 
      {RGBColor[0.5737613661287864, 0.5435370519035629, 0.9097253540741592], 
       EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtmGmQldURhr9ZmBlk7iz3Xu7c7xqQVcCIhkq5hMWwGlKYHwIBFCqpwlAB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          "],
          VertexColors->None], PolygonBox[CompressedData["
1:eJwtmHmQVNUVxt/s7UxPz0xPT3e/BlkHVDAsCsquIASUxRJRIGqsaJHSaMAo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          "],
          VertexColors->None], PolygonBox[CompressedData["
1:eJwtlVlIlVEQx8d7za3u9db9tPuZ1/bVFiIKygQ1hXooaFUKgjQJIlohWmyx
IqOHilLSp0iIdlrVaH0oy7Tcgh5aLC1S2xBtIZfqd5jv4c/MnPPNzP/MmTPf
8OwNi9a7RGQJ6AduWCL7Bonkg51ekcUsJvlFUqNFUkAy+rlQECPSwDf14Az6
G74rZ6/OI3IqRMTrEynDDgc9xOkGEeiF+PpskS3k2QwGojeGi4wMiIwaggT7
QEekSAX7d0EmsXfjX45eOlgkgThBcAr9exicydUEt7fgBPnXukVqYkVeEPMS
sS8PFKnGvhLHPj7HwT3gYu82McvxKwN3nFy/ib0JeyPoRv8L58v4JhEvG59k
Exf7Ed+3cf5WsBd+K/BtYK8e1IFGJ38lMUKIJeAJehfxJnDuRNDM/iTkeFvr
WeXsv/dobbuJEWTvFd8NRf7B7uIs4ejPWOuDQyf2GFvXjd7LWhN7UawVYB8E
ucSqZe2FuQ/nTL/J0Yh+hHrPA3PBfJDVn5zUtJgatVLfk8h4n9b9I7Gms7Ym
Vu8gSB124LMtSmQYenyc1uQzOEyOdqc+q+H9i72fIAd9K1w6/crHcPgJl75Q
rd1oW/mPtbWOd/Dpg0MGawXU8Db2NXPXnDOVmhchr2J3sV7L9xf4bhp8O7E7
kGHs9TP76EfpjQTitsL/E9hpaW3b8MuAZzpoR69gbQ6clsHtBryWItOwfewd
c2pkahWNXWwpH8OhBD0dTkHkY2JVgnj0CNYKkdnYq8A6r3IvJmYFdjlII8d5
ct0aIPLQ0n6qRFYM0NqlkSsXXgeitY4rkd+I8xV08U2tS/ssjJiv8S2N0Z4z
/X3d0rd809JeNzWJ8Oi7PRuj9blIPWYRdyaYDJ+p5v7glIAeBJ183xOqs+Ca
T99ZmU/nQk9Ae9X0Zy94Eq7v3o3PW3hti9YZYOr+2alvnqV3EMX6D+duhvBW
I706H4R7quY7l62zwrzJVr9y+OrX91nPuUPgn8853Mg67BriPwVV4LnTD/fg
n8X3IREiy4l3F3sP99fIWRvAAvOGmDktyIUBnSun6bnmWL2fEs5xgbzpfr0r
c7eRzjzL8ug9zw5oD5q+m+HTWSGsZ8LrKvyykP843yi+fwDP++CL805c7PWi
94DzXj3PRPjlgRHwGgePRPR37LeAAnyakU1gO+dy4+MCtqX1LvVobpMv0+nh
KXDq8Os7+4WcjJ2BdPOdC8zx6xnN/D9geKPvd/4FL4l7AnkcHCJPLvyGebRX
TX9+cDiZNxRp66zpb+t7umXpLDfzexe+y/BNCehMNXM01elrE78I5BCn0Mn1
HylBBik=
          "],
          VertexColors->None], 
         PolygonBox[{{6836, 3641, 3640, 6688, 2680, 3125}},
          VertexColors->None], 
         PolygonBox[{{6175, 6179, 2544, 7059, 2911, 6946, 6945, 6174}},
          VertexColors->None]}]}, 
      {RGBColor[0.6334044084039064, 0.6393668249866483, 0.911085031734951], 
       EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmXmcVMW1xy/M0N333u6ZoadnuR0WF9REjSGAsigQFA1RcUGDRkXRF4NR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          "],
          VertexColors->None], PolygonBox[CompressedData["
1:eJwtmXm0VNWVxu9jqFu3br3BV/Ve1S0FQUFswQEkzIMMThHUANLBoTV0HDqC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          "],
          VertexColors->None], PolygonBox[CompressedData["
1:eJwtlFtI1FEQxkdN2/3vmqa7tq6QeaOgLFICXcKSqNTcJN0SyksJ2sXMHiKQ
wAoEiyCShKSkMomIkHpYuklkBvXQiwRd0AqtHtIuaipSUfY7zMJ+/GfmfDPz
nXPmbEpNY+mhcBHJB5EgIUFk0Cvy0hJpBclRIkVJIks8ImXz8fkW4s8tgB8N
l6Qut8g//AbyCkEBGMbvtolsx64CN7GniAWw79AjgxrpIC1UtzNRpALU0XOZ
U2QF/OhYkWC8yOg8kbt8nfhj5M/yPRMh8hruWTBCjX7if8nJww9Sbyn+cpCM
/YF4DjWPgOMxIs3AgfZG9vscTjj5BfA+2UU2O1THLvCCg2mxVNMovLX0LYc3
A68W3jr20UPuVWId1M7D/wiq2dcJ1i3y6lmbgvOE/D/oKCD2mNgqF/snHsDe
DTecmrnsMQusBu3ou8G+fy4UGUIvP/HTYxJ/grxJ8MhoJneTpfWnifUR++LQ
XslxIj6QTZ1cvovBD8OB+5v1DeQ9hF9MrB3NdvwS7C3gD5xtHtV/knpDluaN
E+slNuzQGuXEqsEYPQbQvAN7H6hEcAW4ELp745/HvsSZVoXWgvhN9J1g3Uf+
qzDmgvrdxEeITdv1vI96tY+pfRE8Y+3aItVodAXMfTCn+/HrqFsL7serpgfU
uwey4PWjuZt6YuaO+32PXUncxrmm48+YveO/telaKbwO+pRRO58eleQ3MAO3
4I+j9TD2QbDSpXNkZieb/OvkrmHW3ZyHC2yN073ddmtv06/I0rtqI2+PV9+K
eTPnsH2xOm9mxibtOiNtzFUkuU34l8n1oynCo3NkZmfQpjNcb+6W/f8CGfTN
5Az8xGq8aqcRK8b+znpOvM6Yj++3GH1DvR7V/9Sh76kL/QHWy4Afzl72kYmW
ZrQMsH7KvNXQf0YbZ/UZXZ12/f+YI5bCub6jXgV+JNygR+/E3MNX8nfyjlMT
dabNHL+xKf+AU9+/efOt1OkifoyeTnglrF8BfWh0sf98OOtBDHYU/0enk/Rt
mveYil0NL421UnIbyGvBD0Njj1s1Gl0bLZ1rMwOz5v/E6HPoPPwHjpi4FQ==

          "],
          VertexColors->None]}]}, 
      {RGBColor[0.6930474506790265, 0.7351965980697338, 0.912444709395743], 
       EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtmHu4jVUex1869j7v3ufC2Td7q5HpISKXgwaTy4MYhxQhFaVDRx0cpItK
mpLphihdTEqaSqmhMHKZmaaIPFGTqKfponpqlEuNjJLLNJ9v3/eP9bzr/a3f
+t3W77ZWs+rJQ+vqB0FwsF4QnML3/HQQvFcRBHcUBcEbySBoFQZB91gQ3M93
LmMn81xJEIxNBMHJeBD8g/le9owCfwL4K4FfBJ0jfJeDfxT82fkg+CobBDXM
z2JPK0YOnLXAmjcJguHAVzUMgt7lQfA58K7QW5IJgkyDIOhbCIJrGS8UB8HN
jYOgNXgdEDQP36vgEQDvD/48/ifxuxoZWgN/BB6L2DeE8Ro4t0H7OnA2oeej
wHowlgA/CH41ck5Ghu+Yj2U+hfk+5mOY1zE/jrBd2N8XmnuBjwY+CXiG77OM
48h5Evi1zP8A/Fpwj6aCoB68tvHdGdnze3BqwJkKzlrmZyPnImgmkOsO4E8C
b4reBxsFQUPh890DrYan2E4vZW2r5ey7XufB/CvojGI+kfkueB1m/FBkfQ4z
WiPbq9CsAr4C+IPYcCHjQfgOhubLEc0tshl0PmbeFnnm8P8v+Nai+wTGW8Cf
wc6dkGctDjMenBOMamzesdxrgteBW8PYCn4lNu7EeBQ7n+S/ATy3IUOcfb+H
1xJgLZHtBHrmgO/O2ickTzdwCxG+7Pd8xjb8OmX7yrYLgd2LP7SDb1vmxeD9
qsj7Gkd7G8M7z7wzcnYCpxycM4CfSNlespXWm0U4B9B7WcJnWsl6V8Yz4Gzm
u4O9tzM/JBzk/xE5l0F/BeNG5OmODXow8uy9DL3nlSEXsvXC/w9jkzbwaFAa
BD8DnwivZnx7RvhlnOProWWJo98h9KoDp5L5NfD9C3RuD2072W0D8KXsPQr8
afj/mVGDDP2AvR3JORW6xTHbZ6Rihb0fQP8Ydjie8doS7P08I2TvEXgmyxwj
P7E+p8Jx3RrZKzmjReBfCM78Ess2l30voVuV6KBXi4xlmI3u3RlPINMFyPy+
Ykz+w/9qRlf2tsWenSPbynYbim3LedA5DTrD6pnW+mLrNyt0nChGHkaXh/jv
xPzK0DEsf6/Br0eVWhf5WrfIB5qyvpg9/cEZzvxx5qvAOQf5/4du/cDryVoV
33NFB9kHFizTBawPxCZtsOVMeO0odu66mfkR5tdDvxt2aspow3wh+34st54P
Mz/GfA3znxhPwncGOO9LDniNiNnvlYek577Q8km2YewbX/C51hXMQ/THhc5T
ylHS9ZOU9R0KzjTG6+APRsAOjCfAKWe9JDrTatbPZ2wsdn7R+axjfA5OJ+hX
ArsqdJ5SjtrL2T7N6ADOtNA5TvlNOk0oWK8ewLoz+qDPrdqLjovBeS50nChG
2uMzt0a5oj1ybYDXTfCaAe1b8o67ReBex557lLPAncp/pWzGmS5lPAb9lnw3
cmYjY/7W5D0fBM3zGS2gMwObNEGfRUWOgz5px8I3wC/P27ZvKycgc1/w9/C9
GL61qkFFzpHyvbMae4/w+4LzWWg/OZ1vBtlagh8Dfh//bzL/hG+vpGuE8tmI
jM92CLBzQse+bLo0Zl/agvw94TEO+JesDwBvAPO3mQ9KukZ+GpqfeA0E9lVo
H90Zmq5oNimx30hO5Q7lO+W+9ay3S9huozmvqwvOU1MLrouqib3J/3MYX4Q+
/ykZ+4Dy6JiMc+mjcdeoueSQFiW2new2AHtX5RwLVcA/ZZzGfBJnvZj5Tarj
fFuHzl3dmLdh/kp95+BxGefhZ+PmcRz4VmzSB5vU8P8eOtfxvYbveeytzf9S
6n/xv79GNszkfPY6d+Ut1Xj5uWpjo4Tr4/bQ8a/Y/5DvEP7Hxtzj/C7tmpLh
nDuXWeaLsc0NjDfk8/CcmDUd5f6nM/Yl+W/vnH34bGSbBq/OysHQPzPh2qoz
7Bj6HE8Hf2LG8XsgZ9vJbleE7jPUY6j3OTfl/ucd4C2S7pVa4ku7Glm2n+Pu
d1Rnm4b2P/neaojN4hxXAFsdyhigya6h67pq+iLm25n3iDl37GF0ZdyNvQej
5zHwh6DLlzozSDSBxrbQdfHnpOuHase9zOdFfWCH0PaVba/EZgsYLyLfI+Ak
k/bbTayXJ12Ta7HxvfCbG3esf5twvP8H+xyucK2shv8RxnBk+Ds2mZSzb/TP
+F/zu2Xv0HVnAfPhoXtL5SD1HfKxifA8CvyyCCY7aW8B2rMStuELoftU9ajq
4w5EdV/16sLQNUt15rWEa83glOuT8oN6tCEZ51HJMj9heZ5KOA8qB34BnUuZ
T4hs3jXqxz4KnTclbwn2uIWz2w9sNP+Xx53TzkbvNRWuL62QeTJ022Hbd8E7
M4r9diWuK6opyqMzo1yq+lNbcA1SjdqUMJ1d2H972rHchr33AP9vfdvv44Rt
OBr4IUZ/6DwG/F3gu5B5hPJMiWv3M/BvlvA5XgTPYXnfBSTXzijXKe5nJxz7
54amJTqq37sZZ8Tcd+xo5Pp1CfLeyHgTeR9I2F/lq3XQPBbaJiND52vl6t7S
o8R91IXsW1/uXki1bmhD54ENUV+mPJaC5nz23ohsQ0PnAuWBB/imWZsOfAx0
zmO8zL7O0JtZYV/ayjnXcvavFjn3KAdtbeDefE1D9+ey12b2PcfomXLvqN5m
H3J+k3Yv1lE9USP31XfBtyzhHCdYvGC4aN8V0S9n/W71NuA8UHBPoH6gLz7z
JrYbH/edTDGpeHyw4FyvPH9/meNKMVWXcn+mfkp5cU7SOW0N8NKGjrWlkV7K
q7LBlMgOT8Hramgtlm8CG16wnpPS7o2Er7qlnka90+34wp151wj1NaqByiez
2BfDjtuBvYpc6/L22/ll7pUlp/T8Luacr/r0eQPX8UMp9xDqH7Lq/7O+k86C
3pCcbaW7yKcZ46yPemHxngbu9Vn7Uh9w84z7Yr5f/ibtO+YXzHdEdwH1Q4pv
xfVIeL6SdZ+mM6mOzqVK/XvasVwP2dsX7OcD+E4qmMYVBdcS1RH1y1Vp98wV
oe9+qqk3sT6qYJv8FPr+rLvzSfWnoXvYG7D/TMYMnTXwfcW+//7A+njl5bh9
WvVS/XkXzvnFhq4j6tkX5wzfgx6plH1+DbZv1di58Y68z0znNRZ634fuTWt0
70C2lfA7DGwcayOA10eGGxQ7zFfC57PofrqgsfOLcot8qjbK4StizvHKP9PZ
d0rCPY9yc23SMlzD90f+L4n7fG7N+4xE+7kovnpDuwZ9XmE+GrkuYmxCtjvR
aXmp4/w6YIfYs0p9ecH+LRlyofsh9ULKwVMjP7+LvHsqYzPrXcA9WO4eZhC6
7M6531gKfB3079FdJO87j/J8e/TYmHRcKJdNjnL7BM75u6xrutY3RDjKu7sj
+6h/fCSqj9OR81LGtmLf16dEdMaDfzDre30N8wNZ15Hn2dec/QvifudYlfRb
h+q9/EX37EnAToSuJU8i89K8a0dMtSnpvNEfnuMYa4ud54oKznXvqMdB53eK
fO+sF/n2h8AfB74H+EBs0zbnGjcNnZ5Avn66a4K7DF6diq3T5EivTdGdT/lz
DTb+d951Z7/68ZxlVvx9EMXgGOjtyzoPnJ5wvVGtGQ9+m8auk+pT/pZxblG/
8H7GZ63atSPjfLwbekNK/Vawt8i+rHNULp8c5fMu8Dq1zHngSIXfFHRfHgv/
6qzrflno3k593W3IsDnnHlvnsDzps1BOFE/ZbUTeekpH2XJ2ZE/VzzcytoVs
+VRkT71hLCgzX91BdIfTPaRjyvGsWG6CLKdm7Wu7I3/TXL5ZmbFeH5X7zUjx
ojeG11Ouj/WBb0n5fUz1aU0kq2yzLHqnUi8uG4lOJfqNS/ud4fLQb15671L8
fx1zPlSftyq6K1URQ/czDobWTeetu/70Cr9TqC4vVg1EpvOw81T0SKdcLxSr
qhM6x3ipZZWcVxXcE6gf2Jjxe4Hq6SWh+yrFwmWh378UI/KjWXn70vKUe271
273g+2v4FuC7n/ktpa7FEwuOAfm/8kebjHPIVuhtSfpe8o18qsw9oXrbQeXW
W/34mKgn17tj37Rl/n0j5ynlqLDU7zjK+X9UDs7ZdsOQbWmpbdcDX96cdS5t
wXxd1vn8zoxrm2rNaTnfQ1SvdW/XGemsJuB7zeGdArYDei+lvPZCie9gkq1l
6Ddc1cpOCesmvVYq7vKuNb2gn805Tz+Ucm1WXdb66ginJXtXsndh3G9OzUt9
pjOANUj4vjYW+/RTrij2W8i+lO3/W2gchP6BuN8RdKdXXHQE509Z3zd1d1yf
ce79FtjVafvbQ8Aezrhv3A/8yrR7vxnQ3pf3245yje5e6p1079RdTrrrnfif
WddKvX1eEL1/So8VkS5TS/wepxjZE9UF1Ye3MuaxLXojUS8g2f4PDWIabA==

          "],
          VertexColors->None], PolygonBox[CompressedData["
1:eJwtmXeAVEUSxh9pdt7MwsLOzM7OW+PheWRlgTvFQAZZI6iIAcQlKWFlQQEV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          "],
          VertexColors->None], PolygonBox[CompressedData["
1:eJwtlFtIlFEQxydF3f0+WzV1XdeIjLJa0xS6KJEmbkE9GFjRhShw0zUJJSrb
pbTLSxddLTN60C5WUBmIFV1fIiy17KEgsIhIgoruD0VFkfU7TA9/zjdz/v+Z
OXPmfJkVdeW1USLiBzHga5rIF/DIKfIYzIgTGe8SGRwnMgAKU0RSIY54RY54
APtTLZGLtkhzvEjB//25rE3Y1WiH4Z5hPw9eJ/xNbhE7Q2Qf8bvxRWJFAkki
jfAaQABcdYj8YPWTI4imAf1i+OPTRbxgJbq/+IbZ2wuvk3wLydvBuge7IEHk
KWsOmhfAD+8Z9jy0H/l2UdtYUJyidZta5/OdToxScvbAfUMNO8lRBT+b+qaB
MD2azZl8Scopghtgv95W/n1871JFfhPnHDVmkDtEzjBIZn8KeWrwD8E7hbYD
7Uzs6+hr4NSCjdgT4EGXMuw+uE7iuPH9gt+F7gTIhZfm1Bg36OkyelpNnO/4
VuGzk0USQN8Yka1oLb6L0X0j3iJTF9wN8J5gLyPPH74DxPTAvUu8NcTbDifK
0jP2e7X/pucCZ5S9TOKVwVvBHfaimYjdDC/ErPxksG5yD03YHfg7wTG0l9H5
iJkLP4j2NnYjaw72Znq7FH4Z2OXVO11HzvUgaPpJ3sucp51YbSALn8upc3iC
+9tO3nrQas4Yoz25RdzV7P9wan8OZ2jdptYlfH/CfxD+bu70erRIJesB7EqP
zqCZuzZ0IWJUsZfNmXxgv1f5g8RfS5wdcGItndcW9ra4tIbj1BXBjmUuHCAO
hLEfOvRt1MCLoMm09J2M8v7O4n/Fvh97EXu9hkc9+eR7j/+tQ++n3613GG3p
XS2nT+WgwsxGvN5pHtp8EMZXiO9qlNY74NbZjrG09mJ0C9L1zc/hzInxWkeW
R+cpaGtNQ/Q306VvpYizPcD+zBog3izm4A7xLPTnE9GDM+A5/Uqk9ktw9pA7
YulZzNyYubhHniQ0V2ydETPfpz36v7hl66yb+z4K2vH12Hr3JcSa49YejaAv
xd8C5xA4jK8b+zzYBidEja9NHFBE3gjaa+ZfA+Lhf0DfxflPmncIZzrnn+nQ
WK1gMr4LtsZ9ad5vuu7X4ffBneTS3ph+lJDLS3/+AWPwtCk=
          "],
          VertexColors->None]}]}, 
      {RGBColor[0.7526904929541466, 0.8310263711528192, 0.9138043870565348], 
       EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJw1mHlw1dUVx39AeHltk/eyvPd77/0e2EEQEJKIhCUsFYSwCAbCYqAUFEJY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          "],
          VertexColors->None], PolygonBox[CompressedData["
1:eJw1mHmQVcUVxu/AzJtBZt6b5b1334IJAwZRVh2QUVB2MKjIopgoKJsg2yBq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          "],
          VertexColors->None], PolygonBox[CompressedData["
1:eJwtlGtMzXEYxx/VocY5OPo755SYF+7EVObygpVIpk7m9gbJZcMmm1szlyi8
wMlmy23ltppcpkbl6KYXHWNiprwiQ7ExEd6wks9vz//Fd8/l9/ye++83Nid3
+Y4wEVkOHGCjJfJziEgPWAuCKBtGiqyJFVkN5npFNgwS2T5CpMIp0hwhkgu/
DZRHY+MT+cd54lCRMuTj6G9hdxMUwr/Evscj8hv8Aguw78b+OmdBbB6Aq/Dv
IzRmPbGzOU/yavydnF3B5jLYMULj+8n5Hbl2gHRwh5zXo/sK/wWsAjXoVqLr
gu8EWeAuuov4vQDOg5YYkWJi+fFbhP8AyICvJMYszm9yXgESvZqTsRmNzwB+
4iy1L/dpH0ztCfQgIVLktkuk301fQCR2BdiXYLsU3+mgCd0nh+Ybgv8C32Jp
7tXYHcXmCHiBrtuh83lu862WziqF3qTTq3FRIqfgk0H3cJFMS/uRBf2GfMOp
szPzemzHOoluOnI8qEPXia6NXKeQdxx8GrW8cmvvGu1cGyzto+ldLDW/ph+h
GO1j1jCRA5y3YHcGGz/yfWZdC+6SXwG53YPfhs8w7uynRwOgW5E9nMWBUeAE
GDYYoM+xdBc3QYci/8B+jr2Ls6HfkQupvwP6FrwBIexTsW8l/2egjXrK0J2j
zgC2p0GQ3OcTvwF7wc9i/PWTWz2yj7On0Ccgxq5xCX6KqCkAFkdrf7ymZnL1
g03YDcRfFDmus3TvsqGRyJmc54OF9KCK2BnwbmayiP6kAgf5XQoXOYytg5gH
8RMBPYT819TLnc+cV3LnT4zu/EN7XkFL9/+eS+duZj3G3s0X3B+PPhY+hZyf
u3Wnap36Ho/Z+3XdpzMxc5jJ7s4gfg33+vDVCybi76yZvUtnYuaQiO6CQ/tZ
jI953Kn02b3Ff4J9PtPSt23+gmnwxeimWvovBF3aL9OjePvMzCwNvhy+3aXz
M+9+gp3DeEv/gB7u/AYB6vhl9sKt76rUqe82035jzfSmCx+53P0MfWT+NlBH
nQ9BHvf82H+KVp/GT5FL7Sd7dN/MjrnhCwcyF2a3lzrd1JsHDUfeAN1ozz8H
mg32gd1gF4jzqH0KfqcSs4qPdwt9TUbebf5YaCLx9sDvAk1mxuxWFXvXAW1E
Pjxc75s7+fAh9qEP/ThqrMbuI3a9yKXIIaf+o9fgS8Ak7NvBAHRtZp5gs0f3
zexYEjmFqK3Tq7FNvA9e9TvNpX+C+QeW0aPR5DnBpbtl9mkRulEOfRupNr8w
Wt+J2Z8Vlv63qyzdpf90Efeh
          "],
          VertexColors->None], 
         PolygonBox[{{6071, 3855, 3854, 6838, 2903, 2479}},
          VertexColors->None]}]}, 
      {RGBColor[0.80726725, 0.8618830000000001, 0.894034], EdgeForm[None], 
       GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtl3mQlsURxl9291s0fud+134LJALhEHZjThBIQSzkPlwQBEJxu+hymxCO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          "],
          VertexColors->None], PolygonBox[CompressedData["
1:eJwtl3mQVNUVxh8DDSjTr6en5013M8HIJhoGMAkMIhDjgjMMy7A4WGaRTbYI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          "],
          VertexColors->None], PolygonBox[CompressedData["
1:eJwtlElIlGEYx5/KpcwZnWa+yS1CMbPUVtHcEnJJIcmmDk5SB6XIXLKjGhSh
XSzS0pIOiQVuQ2rZApFSFq0wptFoomVFG9KlQ0Fd+r283+HPs6/f837RZcdc
NYtFJBf4gycWkU67yFUwY4j8QhllEylcIVIA8pwiSQEir60il8NE2gNFLkHH
kWvxWxMiEguOw48uEdmGfw+2bpAGn0jsD2hQpMgyUAufga6Fup+I+wiGQkUq
iN1ED+fQd/uJpMBvBA3kfQ8C0c1D68HucJFB4gZAMfw/etoZLFIFH7RUpBKa
j3yGXN/xtxAbR64m5HQwYNa7AU1D/oPvtDn7FPQ38myYjlcxc/BD1CggVz7I
AznEppJjF3w4fYSBIngPulJmLMW+HxyA38K8M9T/FiHyFUSSz0U+D/tNN3fk
Q9+PbLC3SfIIPb+BOpCzQCl8F7kToZnITeTugp9D147ciJzF3P7QBHJvh88E
d8EYM8yS7x78HVBp6JnVnOVgxF/v87xDJBu+1aF3G7OSGek1BTygTzd9jjPH
T7Uz8k3De0E0vuXElIFceplZJLKPPhqoUw9OgHT6TCbHQXMfI8y7Ff4vfoEg
QIE6rfi9JH8Mu4gGHvJ/oVY2Nc6ibwb3yTfKEd+GTuHjA7fg5+m9Fz8P6AeJ
YJpebOSIobfl2C30F4p8Cv/T1M+hl0boSUPfbSt9uOnhpk3fcBX14skzSD03
tkpkN/WqQRF9VUFLwDty7sXmAj673s9a7r3EfD87oHHILQ4dr2IqrHrfataj
hv4O1Yae+wP1D1PvEPBa9f2n2vX9qptNtut3cgR7PTnrQAl+C8zrIv4x9cbA
BvJcU3eDbbXaDXMU4ptg1Teaib0He6pT32snchu2i6DF3IV64071lojtMN/7
IHdzAd8J7G3QAfWGoD6b3nk28VPq/wDWcUcd7GA9NBZ5OFi/a/WWa8w9qjdk
tehvOGzo96T22Wd+/1673u0z8Iq+6qh7Hd1Ti76BDGZyErvKqu8hkvgQbJ/p
uRk+Aixge4TuIWgj9gq2JHp4gf45eGu+sc3YJ+lxAniJ80MXj30P9mIQhW6c
GdNs+j7UTWSYe/wP3lu3Yg==
          "],
          VertexColors->None]}]}, 
      {RGBColor[0.86083075, 0.879745, 0.8700376], EdgeForm[None], 
       GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJw1mHmQVcUVxi/zZsBl3n3vznv3DQMWChEFVzQKaqQ0RhMRdIABF+I2AwpE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          "],
          VertexColors->None], PolygonBox[CompressedData["
1:eJw1mHew1dURx3/c9y46422/d++lvIeF3iICQVAiEFHhUaQjIB0U6SWAgpRR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          "],
          VertexColors->None], 
         PolygonBox[{{5756, 5902, 1667, 3220, 5755}, {6342, 6835, 6834, 6338, 
          1960}, {4702, 4703, 835, 4200, 4701}, {3649, 4487, 970, 4486, 
          3648}, {5237, 4700, 4699, 3671, 1331}, {4437, 3870, 3869, 4438, 
          945}, {6709, 6711, 6710, 4391, 928}, {4663, 5486, 1470, 5490, 
          4662}, {5018, 3407, 3406, 5019, 1246}, {6011, 5719, 1584, 6019, 
          6010}, {5722, 6959, 6958, 5707, 1582}, {4401, 4689, 1085, 4690, 
          4400}, {3169, 4298, 4297, 4636, 1067}, {3327, 5601, 1525, 5600, 
          3326}, {4569, 3649, 3648, 4566, 1026}, {4387, 4444, 947, 3645, 
          4386}, {5986, 5984, 5983, 5742, 1733}, {5434, 3786, 636, 4397, 
          5433}, {4442, 3599, 3598, 4443, 947}, {4826, 5864, 1640, 5865, 
          4825}, {5896, 6241, 6240, 5885, 1656}, {3616, 4168, 4167, 4427, 
          938}, {3312, 3164, 3163, 3930, 716}, {5201, 3632, 466, 4180, 
          5200}, {4828, 5505, 5504, 5502, 468}, {4215, 3685, 974, 4492, 
          4214}, {3879, 3352, 746, 3998, 3878}, {3432, 5153, 5152, 5154, 
          1173}, {6074, 6963, 6962, 5850, 1633}, {4086, 4538, 1007, 3772, 
          4085}, {3870, 3344, 740, 3982, 3869}, {3164, 4303, 893, 4305, 
          3163}, {3566, 4106, 807, 5081, 3565}, {5823, 5921, 1683, 5922, 
          5822}, {4000, 5236, 1331, 5238, 3999}, {5487, 3327, 3326, 3177, 
          1470}, {3684, 4215, 4214, 4491, 973}, {5606, 5083, 5082, 6169, 
          1526}, {4058, 3473, 3472, 4270, 783}, {6888, 5084, 1960, 6341, 
          6887}, {4577, 4000, 3999, 4578, 1032}, {4900, 3759, 1418, 5400, 
          4899}, {4535, 4086, 4085, 3771, 1006}, {5763, 5985, 1733, 5987, 
          5762}, {4445, 4447, 4446, 3603, 454}, {4345, 3408, 806, 4346, 
          4344}, {3564, 5072, 5071, 5604, 1525}, {4298, 4534, 1006, 4536, 
          4297}},
          VertexColors->None]}]}, 
      {RGBColor[0.91439425, 0.8976069999999999, 0.8460412], EdgeForm[None], 
       GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmXmQlNUVxV/3dCua6Z7pnukZGARnMHGNUXDBwhhZZHMBQdxRVhVThQtL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          "],
          VertexColors->None], PolygonBox[CompressedData["
1:eJwtlnmQD2QYx9/f/tYezf7u/dm1ojRJKmXNZBspqSxK2LVSBntY1x8R2SJT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          "],
          VertexColors->None]}]}}, {{}, {}, {}, 
      {GrayLevel[0], Opacity[0.4], 
       TagBox[
        TooltipBox[LineBox[{3139, 6122, 6112}],
         "0.8`"],
        Annotation[#, 0.8, "Tooltip"]& ], 
       TagBox[
        TooltipBox[
         LineBox[{3745, 4521, 3378, 3283, 4252, 4253, 3758, 4051, 4532, 5662, 
          5719, 6011, 6028, 6065}],
         "0.8`"],
        Annotation[#, 0.8, "Tooltip"]& ], 
       TagBox[
        TooltipBox[
         LineBox[{4263, 4267, 4067, 3473, 4058, 4057, 4588, 4587, 4056, 3383, 
          4257, 3382, 4907, 4908, 4905, 5560, 5559, 3293, 5454, 5453, 4586, 
          3466, 4909, 3390, 4936, 3483, 4934, 3482, 5564, 3299, 5459, 5458, 
          4602, 3484, 4937, 3393, 4967, 3495, 4965, 5572, 5571, 3305, 3156, 
          5469, 4614, 4969, 4968, 3397, 4296, 3398, 4538, 4086, 4535, 4534, 
          4298, 3169, 4635, 4634, 3525, 5024, 3940, 5030, 3529, 5028, 3528, 
          5029, 4105, 4106, 3566, 5072, 3564, 5601, 3327, 5487, 5486, 4663, 
          5092, 5088, 3423, 6249, 6257, 6253, 6835, 6342, 5084, 6888, 5083, 
          5606, 3567, 4104, 3408, 4345, 3407, 5018, 5020, 4633, 5481, 3939, 
          3938, 4306, 4307, 4304, 4303, 3164, 3312, 5580, 3507, 4991, 3508, 
          4084, 4083, 4964, 4962, 4963, 4961, 3494, 5570, 3806, 4904, 3465, 
          5558, 3464, 5639, 5402, 3760, 5632, 4054, 4055, 3463, 4582, 5452, 
          4256, 3460, 5401, 3759, 4900, 5451, 6214, 6505, 6509, 3144}],
         "0.8`"],
        Annotation[#, 0.8, "Tooltip"]& ], 
       TagBox[
        TooltipBox[
         LineBox[{4423, 4425, 4168, 3616, 4175, 4174, 5608, 3614, 5180, 3615, 
          4190, 4189, 5512, 5511, 5231, 3666, 4824, 3667, 5232, 3238, 4191, 
          4192, 3621, 4194, 4193, 3239, 4195, 4435, 3625, 4434, 3626, 3983, 
          3344, 3870, 4437, 4439, 4441, 4440, 3984, 3985, 3631, 5198, 3632, 
          5201, 3431, 5153, 3432, 5982, 4878, 5901, 5902, 5756, 5761, 3857, 
          6073, 6070, 6818, 6963, 6074, 5854, 4827, 5864, 4826, 5984, 5986, 
          5985, 5763, 5505, 4828, 3634, 5199, 3633, 5202, 4199, 4703, 4702, 
          4700, 5237, 5236, 4000, 4577, 3438, 4196, 4473, 4472, 3353, 3240, 
          5513, 4698, 3668, 5233, 3440, 4493, 3685, 4215, 3684, 4013, 4012, 
          5259, 3687, 5257, 3686, 5258, 4218, 3258, 4733, 4732, 5288, 5287, 
          4019, 5293, 5294, 5290, 5292, 5291, 4222, 3267, 4750, 4749, 5327, 
          5326, 4029, 5621, 5622, 5619, 3719, 5620, 4225, 4226, 3734, 4227, 
          4764}],
         "0.8`"],
        Annotation[#, 0.8, "Tooltip"]& ], 
       TagBox[
        TooltipBox[
         LineBox[{5895, 6241, 5896, 5890, 5392, 5389, 5394, 5393, 4050, 5390, 
          5391, 4781, 4784, 3291, 4251, 4519, 4520, 4238, 3454, 4518, 3453, 
          3895, 3277, 3373, 4037, 3730, 4508, 4507, 3266, 3367, 4028, 3714, 
          4503, 4502, 4731, 4730, 4729, 5442, 5441, 3683, 4501, 3682, 4488, 
          4580, 4579, 4210, 4485, 3680, 4009, 3681, 4487, 3649, 4569, 4452, 
          4692, 4691, 3786, 5434, 3599, 4442, 6568, 4444, 4387, 4682, 4381, 
          5721, 6952, 6975, 6959, 5722, 4382, 6569, 5705, 6570, 5921, 5823, 
          6711, 6709, 6665, 5956, 4390, 5960, 5957, 4689, 4401, 4447, 4445, 
          3606, 4455, 3986, 3987, 3872, 4456, 4457, 3655, 3990, 4693, 4694, 
          4211, 3248, 4461, 4462, 3788, 4571, 3657, 4463, 4712, 4468, 3663, 
          4573, 3664, 4469, 3249, 4212, 4213, 3665, 4695, 5509, 5510, 3352, 
          3879, 3881, 3437, 4410, 4413, 4188, 5724, 5727, 5685, 7018, 5681, 
          3237}],
         "0.8`"],
        Annotation[#, 0.8, "Tooltip"]& ]}, 
      {GrayLevel[0], Opacity[0.4], 
       TagBox[
        TooltipBox[LineBox[{5718, 6019, 6010, 6027, 6064}],
         "0.6`"],
        Annotation[#, 0.6, "Tooltip"]& ], 
       TagBox[
        TooltipBox[LineBox[{3138, 6121, 6111}],
         "0.6`"],
        Annotation[#, 0.6, "Tooltip"]& ], 
       TagBox[
        TooltipBox[
         LineBox[{3143, 6508, 6504, 6213, 5450, 4899, 5400, 3459, 6364, 3462, 
          4584, 3145, 3912, 4903, 3298, 3151, 3921, 4960, 6678, 3304, 3155, 
          4989, 3506, 4992, 3929, 6636, 3930, 3163, 4305, 3819, 3521, 6582, 
          3522, 5016, 3523, 4099, 5019, 3406, 4344, 4346, 4103, 6461, 4101, 
          6130, 5605, 6169, 5082, 6887, 6341, 7022, 6338, 6834, 6252, 6256, 
          6248, 3422, 5087, 5091, 4662, 5490, 3177, 3326, 5600, 5604, 5071, 
          3565, 5081, 3411, 5033, 3530, 4642, 5482, 5483, 3319, 5592, 3524, 
          5023, 3527, 4299, 4636, 4297, 4536, 3771, 4085, 3772, 4537, 3931, 
          4995, 3510, 4613, 4621, 4622, 4294, 5417, 3768, 4966, 5419, 5418, 
          3923, 4972, 4973, 4601, 4615, 3157, 4284, 5410, 5411, 4935, 5413, 
          5412, 3914, 4940, 4941, 4585, 4603, 3152, 4258, 5403, 3761, 4906, 
          3762, 5404, 3902, 3903, 3468, 4912, 3469, 4919, 3386, 4270, 3472, 
          4066, 4266, 4262}],
         "0.6`"],
        Annotation[#, 0.6, "Tooltip"]& ], 
       TagBox[
        TooltipBox[
         LineBox[{3236, 5680, 7017, 5684, 5726, 5723, 4187, 4412, 4409, 3436, 
          3880, 3878, 3998, 3997, 4470, 4471, 4183, 4181, 4467, 3351, 3996, 
          3789, 4466, 4464, 3877, 3350, 3993, 3787, 4460, 4459, 3874, 3989, 
          3988, 4458, 3654, 3873, 5219, 5657, 4404, 3605, 4562, 3603, 4446, 
          4400, 4690, 5827, 5908, 5905, 5959, 4389, 5929, 4391, 6710, 5822, 
          5922, 6199, 6827, 6972, 5704, 6980, 5707, 6958, 6974, 6951, 5720, 
          4380, 4681, 4386, 3645, 4443, 3598, 5433, 4397, 3785, 4450, 4568, 
          4566, 3648, 4486, 4008, 4011, 3247, 4498, 4499, 3701, 4837, 3700, 
          5279, 4489, 5638, 5439, 5440, 5615, 5614, 3702, 5283, 3795, 5321, 
          3715, 4850, 3716, 5322, 3894, 4235, 4236, 3744, 4237, 3743, 4515, 
          3377, 3282, 4783, 3901, 3757, 4864, 5388, 5881, 5889, 6236, 5885, 
          6240, 5894}],
         "0.6`"],
        Annotation[#, 0.6, "Tooltip"]& ], 
       TagBox[
        TooltipBox[
         LineBox[{4422, 4424, 4167, 4427, 4426, 3429, 4414, 3976, 3977, 5430, 
          5429, 5178, 5179, 4823, 5556, 3342, 3865, 4428, 4430, 3620, 3980, 
          3343, 3867, 4433, 3624, 4436, 3981, 3982, 3869, 4438, 3871, 3628, 
          4821, 3630, 5196, 5499, 4180, 5200, 3430, 5152, 5154, 4881, 4877, 
          3220, 5755, 5760, 3856, 6072, 6069, 6817, 6962, 5850, 7032, 5853, 
          6966, 6969, 6922, 5865, 4825, 5983, 5742, 6517, 5987, 5762, 5504, 
          5502, 5729, 3636, 5205, 5664, 5242, 4200, 4701, 4699, 3671, 5238, 
          3999, 4578, 6295, 3792, 4198, 4575, 4574, 4475, 3251, 4717, 4697, 
          5264, 5263, 4015, 6479, 3441, 4492, 4214, 4491, 4490, 3357, 3250, 
          5517, 4715, 5261, 5260, 3443, 5289, 3704, 5284, 3703, 5616, 3361, 
          5519, 5518, 4736, 3705, 5295, 3446, 5328, 3718, 5323, 3717, 5618, 
          3368, 3268, 5522, 4752, 5330, 5329, 3448, 4514, 3449, 4513, 4229, 
          3732, 4511, 4239, 4241, 3751, 5688, 5690, 4779, 6942, 6936}],
         "0.6`"],
        Annotation[#, 0.6, "Tooltip"]& ]}, 
      {GrayLevel[0], Opacity[0.4], 
       TagBox[
        TooltipBox[
         LineBox[{6935, 6941, 4778, 6870, 6928, 6906, 5689, 3750, 4529, 5665, 
          5357, 4240, 3731, 4228, 3733, 4512, 4038, 5999, 5991, 5993, 3897, 
          4751, 3278, 4509, 5444, 5445, 5325, 5448, 5446, 5996, 5988, 5989, 
          4735, 6661, 3269, 6662, 6565, 6566, 5286, 6487, 6485, 6629, 6562, 
          6563, 4714, 6658, 3259, 6659, 6557, 6558, 4216, 3885, 6481, 6480, 
          4014, 5265, 6303, 3689, 4696, 4716, 6279, 4718, 4474, 4576, 6284, 
          3790, 4197, 3791, 6294, 6298, 6297, 6427, 6425, 6858, 5610, 3670, 
          5748, 3672, 5241, 5663, 5204, 3635, 5728, 5501, 5503, 5764, 6878, 
          6916, 6518, 6519, 6516, 5741, 6924, 5744, 6921, 6968, 6965, 5852, 
          7031, 5849, 6961, 6816, 6068, 6071, 3855, 5759, 5754, 3219, 4876, 
          4880, 3597, 4179, 4177, 5500, 5498, 5195, 3629, 4820, 3627, 5193, 
          3215, 5189, 3623, 4815, 3622, 3868, 4432, 3866, 3979, 3978, 4431, 
          3619, 4429, 3864, 5555, 5554, 4822, 3613, 5431, 5432, 5174, 5497, 
          4171, 3428, 4369, 4370, 4166, 5142, 4163, 4421}],
         "0.4`"],
        Annotation[#, 0.4, "Tooltip"]& ], 
       TagBox[
        TooltipBox[
         LineBox[{7037, 5698, 6950, 6973, 6957, 5706, 6979, 5703, 6971, 6826, 
          6198, 5820, 7000, 5821, 6201, 6896, 5930, 4388, 5958, 5904, 5907, 
          5826, 4398, 6043, 4399, 5829, 5923, 5833, 4563, 3604, 4403, 5656, 
          5218, 3652, 5737, 3653, 5221, 5658, 5225, 3875, 3656, 4570, 3991, 
          3992, 3876, 4465, 3660, 4572, 3994, 5968, 3995, 3661, 4182, 3662, 
          5230, 3433, 5739, 3434, 4885, 5661, 4185, 3435, 4411, 5817, 5920, 
          5687, 4186, 5725, 6144, 6845, 5683, 7016, 5679, 3235}],
         "0.4`"],
        Annotation[#, 0.4, "Tooltip"]& ], 
       TagBox[
        TooltipBox[LineBox[{7040, 6991, 6178, 7058}],
         "0.4`"],
        Annotation[#, 0.4, "Tooltip"]& ], 
       TagBox[
        TooltipBox[LineBox[{3137, 6120, 6110}],
         "0.4`"],
        Annotation[#, 0.4, "Tooltip"]& ], 
       TagBox[
        TooltipBox[
         LineBox[{3142, 6507, 6511, 7009, 6216, 6909, 4901, 6372, 6847, 6367, 
          6365, 3461, 4902, 4583, 5932, 3911, 5951, 3913, 5911, 4600, 5935, 
          3920, 5953, 3922, 6679, 6681, 6680, 4612, 5578, 3505, 6633, 6701, 
          6700, 6702, 4990, 6638, 6637, 3818, 5012, 3520, 6581, 6583, 5015, 
          5774, 5014, 6577, 5017, 6183, 4098, 6501, 4100, 6187, 6493, 6150, 
          4102, 6460, 6462, 6129, 6132, 6128, 6497, 6499, 6168, 6993, 6171, 
          6886, 6340, 7021, 6337, 6833, 6251, 6255, 6247, 3421, 5086, 5090, 
          4661, 5489, 3176, 3325, 5599, 5603, 5070, 5080, 5078, 3410, 5032, 
          5035, 4641, 5485, 3171, 3318, 5591, 5594, 5022, 3526, 5027, 3513, 
          5427, 3773, 4624, 5474, 5475, 3314, 5582, 3509, 4994, 3511, 4998, 
          3499, 5421, 3769, 4617, 5470, 5471, 3307, 5574, 3496, 4971, 3497, 
          4976, 3488, 5415, 3766, 4605, 5460, 5461, 3301, 5566, 3485, 4939, 
          3486, 4944, 3471, 5406, 3763, 4590, 5455, 5456, 3295, 5562, 3467, 
          4911, 4918, 4916, 3385, 4269, 4272, 4065, 4265, 4261}],
         "0.4`"],
        Annotation[#, 0.4, "Tooltip"]& ], 
       TagBox[
        TooltipBox[LineBox[{5717, 6018, 6009, 6026, 6063}],
         "0.4`"],
        Annotation[#, 0.4, "Tooltip"]& ], 
       TagBox[
        TooltipBox[
         LineBox[{5893, 6239, 5884, 6235, 5888, 5880, 5387, 4863, 3756, 3900, 
          4782, 3281, 4046, 4045, 4516, 4517, 4233, 4232, 3276, 3372, 4852, 
          4849, 5350, 5349, 3265, 3366, 5282, 4027, 3257, 4838, 4836, 5280, 
          3698, 4500, 3246, 4010, 3884, 3651, 4479, 3647, 4567, 4449, 3784, 
          4565, 4393, 4396, 3644, 4385, 4680, 5701, 6319, 5697, 7051}],
         "0.4`"],
        Annotation[#, 0.4, "Tooltip"]& ]}, 
      {GrayLevel[0], Opacity[0.4], 
       TagBox[
        TooltipBox[
         LineBox[{3141, 6506, 6510, 7008, 6215, 6908, 6371, 7026, 6370, 6846, 
          6366, 7025, 6368, 6873, 6459, 6125, 6126, 6124, 5961, 5962, 5963, 
          5934, 5933, 4788, 5952, 5910, 5912, 5909, 5964, 5965, 5966, 5937, 
          5936, 4794, 5954, 5955, 5913, 6525, 6524, 6523, 6526, 6528, 6527, 
          6084, 5579, 4988, 6634, 6635, 6066, 6531, 6530, 6529, 6532, 6534, 
          6533, 5861, 5013, 4799, 6584, 6586, 6585, 5773, 6576, 6575, 6578, 
          6579, 6580, 6185, 6184, 5819, 6502, 6503, 6188, 6186, 3561, 6494, 
          6495, 6981, 6151, 6875, 6463, 6464, 6131, 6127, 6496, 6498, 6500, 
          6992, 6170, 6885, 6339, 7020, 6336, 6832, 6250, 6254, 6246, 3420, 
          5085, 5089, 4660, 5488, 3175, 3324, 5598, 5602, 5069, 5079, 5077, 
          3409, 5031, 5034, 4640, 5484, 3170, 3317, 5590, 5593, 5021, 5026, 
          5025, 3512, 5426, 5428, 4623, 5476, 3165, 3313, 5581, 5583, 4993, 
          4997, 4996, 3498, 5420, 5422, 4616, 5472, 3158, 3306, 5573, 5575, 
          4970, 4975, 4974, 3487, 5414, 5416, 4604, 5462, 3153, 3300, 5565, 
          5567, 4938, 4943, 4942, 3470, 5405, 5407, 4589, 5457, 3146, 3294, 
          5561, 5563, 4910, 4917, 4915, 3384, 4268, 4271, 4064, 4264, 4260}],
         "0.2`"],
        Annotation[#, 0.2, "Tooltip"]& ], 
       TagBox[
        TooltipBox[LineBox[{7041, 5809, 6990, 6177, 7057}],
         "0.2`"],
        Annotation[#, 0.2, "Tooltip"]& ], 
       TagBox[
        TooltipBox[
         LineBox[{7043, 6067, 6815, 6960, 5848, 7030, 5851, 6964, 6967, 6920, 
          5743, 6923, 5740, 6515, 5917, 6521, 6520, 6915, 6877, 6876, 6930, 
          5506, 6914, 6929, 6910, 5206, 6932, 5203, 6918, 6925, 6913, 5239, 
          6933, 5240, 5749, 5747, 3669, 5609, 6857, 6426, 6428, 6854, 6296, 
          6853, 6300, 6299, 6867, 6287, 6288, 6286, 6283, 6852, 7012, 6285, 
          6860, 6281, 7011, 6851, 6478, 6280, 6282, 3690, 6871, 3688, 6306, 
          6302, 6305, 6304, 6859, 6856, 6482, 6484, 6483, 6868, 3886, 6559, 
          6561, 6560, 6879, 6861, 6705, 6704, 6657, 4713, 3890, 6564, 6631, 
          6630, 4020, 6486, 6488, 3892, 5285, 3891, 6567, 6664, 6663, 4510, 
          6707, 6708, 6706, 6660, 4734, 3893, 5990, 5998, 5997, 4030, 5447, 
          6301, 3797, 5324, 3796, 6289, 6293, 6290, 6292, 6291, 6880, 6862, 
          3898, 6872, 3896, 6139, 5992, 5995, 5994, 5771, 5526, 5525, 5730, 
          5731, 5358, 6934, 5356, 6919, 6926, 6904, 4527, 6931, 4528, 6905, 
          6927, 6869, 4777, 6940, 7047}],
         "0.2`"],
        Annotation[#, 0.2, "Tooltip"]& ], 
       TagBox[
        TooltipBox[
         LineBox[{7052, 6978, 5702, 6970, 6825, 6196, 6197, 6999, 6202, 6200, 
          6895, 5906, 7029, 5903, 6811, 5824, 7024, 5825, 6900, 6207, 5830, 
          7002, 5828, 6206, 6830, 6211, 5831, 7004, 5832, 6212, 6903, 6245, 
          6044, 4402, 5931, 6000, 5866, 5216, 6051, 5217, 5867, 6030, 5868, 
          5222, 6052, 5220, 5938, 6001, 5869, 5223, 6053, 5224, 5870, 6031, 
          5871, 5227, 6054, 5226, 5660, 5659, 5228, 3658, 5738, 3659, 5967, 
          5229, 5970, 5969, 5507, 5508, 4882, 6045, 4883, 5855, 6032, 5746, 
          4886, 5750, 4884, 5745, 6002, 5815, 4184, 6041, 6042, 5818, 6995, 
          5816, 6182, 6820, 6142, 5686, 6977, 6145, 6143, 6844, 5682, 7015, 
          5678, 3234}],
         "0.2`"],
        Annotation[#, 0.2, "Tooltip"]& ], 
       TagBox[
        TooltipBox[
         LineBox[{7053, 6838, 3854, 5758, 5753, 3218, 4875, 4879, 3596, 4178, 
          4176, 3216, 5194, 5197, 4819, 5192, 5191, 3214, 5188, 5190, 4814, 
          5187, 5186, 3213, 5184, 3618, 4811, 3617, 5183, 3212, 5176, 3612, 
          4808, 5173, 5171, 3210, 4170, 4173, 3589, 4165, 5141, 4162, 4420}],
         "0.2`"],
        Annotation[#, 0.2, "Tooltip"]& ], 
       TagBox[
        TooltipBox[LineBox[{3136, 6119, 6109}],
         "0.2`"],
        Annotation[#, 0.2, "Tooltip"]& ], 
       TagBox[
        TooltipBox[LineBox[{5716, 6017, 6008, 6025, 6062}],
         "0.2`"],
        Annotation[#, 0.2, "Tooltip"]& ], 
       TagBox[
        TooltipBox[
         LineBox[{5892, 6238, 5883, 6234, 5887, 5879, 5386, 4862, 5384, 5382, 
          6787, 3899, 4891, 3452, 5557, 3451, 5355, 3729, 4234, 5524, 4853, 
          4851, 4848, 3727, 5351, 3264, 3365, 5281, 4026, 4728, 6796, 4727, 
          5278, 3699, 6798, 6735, 3697, 5276, 6786, 3883, 4454, 3650, 4480, 
          6794, 6720, 6782, 4451, 4448, 4564, 4392, 4395, 3643, 4384, 4679, 
          5700, 6318, 5696, 7050}],
         "0.2`"],
        Annotation[#, 0.2, "Tooltip"]& ]}, 
      {GrayLevel[0], Opacity[0.4], 
       TagBox[
        TooltipBox[
         LineBox[{7035, 6156, 6837, 3853, 5757, 5752, 3217, 4874, 3188, 3967, 
          3595, 4341, 4337, 3847, 3337, 5545, 4818, 5065, 5062, 3842, 3335, 
          5540, 4813, 5060, 5058, 3839, 3333, 3185, 5185, 4810, 5182, 5181, 
          3211, 5175, 5535, 5177, 4807, 5172, 5170, 3209, 4169, 4172, 3588, 
          4164, 5140, 4161, 4419}],
         "0"],
        Annotation[#, 0, "Tooltip"]& ], 
       TagBox[
        TooltipBox[LineBox[{7038, 5677, 3233}],
         "0"],
        Annotation[#, 0, "Tooltip"]& ], 
       TagBox[
        TooltipBox[
         LineBox[{7049, 5695, 6317, 5699, 4678, 4383, 3642, 4394, 3637, 3349, 
          3228, 4205, 3243, 6726, 6755, 6781, 6719, 6793, 4453, 6756, 6727, 
          6764, 6792, 3882, 6785, 5275, 6775, 6745, 6757, 6783, 6734, 6797, 
          5277, 6767, 6746, 6776, 6799, 4726, 6795, 4025, 6736, 6768, 6725, 
          6752, 6780, 4748, 5625, 3726, 6747, 3728, 5352, 5627, 5626, 5353, 
          5354, 4889, 6737, 6809, 6769, 4890, 6770, 6724, 6748, 6777, 5383, 
          4861, 5385, 5878, 5886, 6233, 5882, 6237, 5891}],
         "0"],
        Annotation[#, 0, "Tooltip"]& ], 
       TagBox[
        TooltipBox[LineBox[{7060, 6220, 6101}],
         "0"],
        Annotation[#, 0, "Tooltip"]& ], 
       TagBox[
        TooltipBox[LineBox[{3135, 6118, 6108}],
         "0"],
        Annotation[#, 0, "Tooltip"]& ], 
       TagBox[
        TooltipBox[
         LineBox[{4259, 4059, 4594, 4063, 4276, 4274, 3906, 4924, 4927, 4914, 
          4921, 4920, 4077, 6789, 6717, 6729, 6765, 6721, 6753, 6801, 3916, 
          4948, 3489, 6738, 6771, 4946, 4945, 6772, 4081, 6808, 6718, 6730, 
          3812, 6802, 3924, 6759, 6722, 6778, 6749, 6739, 3815, 6804, 4087, 
          6762, 3166, 6784, 6758, 6731, 3822, 6803, 3933, 6760, 6723, 6779, 
          6750, 6741, 3826, 6806, 4090, 6763, 3172, 4644, 6754, 6733, 3533, 
          5040, 3942, 6761, 5047, 5049, 6751, 6743, 6774, 6744, 6773, 5044, 
          4109, 3178, 6766, 4666, 4639, 5098, 5096, 3954, 5112, 5116, 5076, 
          5107, 5105, 4144, 3197, 4659, 5795, 5791, 5801, 4557, 6262, 6270, 
          6266, 4139, 5840, 5845, 5814, 6949, 5808, 6176, 6986, 7055}],
         "0"],
        Annotation[#, 0, "Tooltip"]& ], 
       TagBox[
        TooltipBox[LineBox[{5715, 6016, 6007, 6024, 6061}],
         "0"],
        Annotation[#, 0, "Tooltip"]& ]}, 
      {GrayLevel[0], Opacity[0.4], 
       TagBox[
        TooltipBox[
         LineBox[{3149, 4593, 4062, 4275, 4273, 3905, 4923, 4926, 4913, 3476, 
          4922, 4076, 6788, 6716, 6728, 3808, 6800, 3915, 4947, 3917, 5463, 
          4608, 3490, 4950, 3395, 3814, 4982, 3811, 3309, 3160, 4627, 3817, 
          3400, 3824, 5004, 3821, 3934, 3932, 6807, 3827, 6740, 3825, 6805, 
          4089, 4645, 4643, 6732, 3532, 5039, 3941, 5048, 3536, 6742, 6810, 
          3535, 5046, 4108, 6791, 4668, 4665, 4638, 5097, 5095, 3953, 5111, 
          5115, 5075, 5106, 5104, 4143, 3196, 4658, 5794, 5790, 5800, 4556, 
          6261, 6269, 6265, 4138, 5839, 5844, 5813, 6948, 6179, 6175, 6985, 
          7054}],
         RowBox[{"-", "0.2`"}]],
        Annotation[#, -0.2, "Tooltip"]& ], 
       TagBox[
        TooltipBox[
         LineBox[{3290, 3381, 6232, 6228, 5877, 4867, 4860, 5378, 5377, 3280, 
          3376, 4888, 4043, 3275, 3371, 5348, 4035, 3263, 3364, 4842, 4840, 
          5316, 5315, 3256, 3360, 4834, 4831, 5255, 5253, 3245, 3356, 4006, 
          3677, 4208, 4204, 3227, 3348, 4686, 3641, 6836, 7033}],
         RowBox[{"-", "0.2`"}]],
        Annotation[#, -0.2, "Tooltip"]& ], 
       TagBox[
        TooltipBox[
         LineBox[{7034, 6685, 6692, 6695, 6699, 6096, 6474, 6477, 6472, 5209, 
          6449, 6454, 6452, 5916, 5974, 6104, 5972, 5977, 3242, 5945, 5942, 
          5767, 6410, 6412, 6409, 4677, 6376, 6379, 6378, 5863, 6430, 6432, 
          6429, 6394, 6395, 6398, 6397, 5872, 6401, 6400, 5235, 6416, 6419, 
          6418, 5898, 6444, 6443, 6442, 3253, 5769, 4721, 4706, 5268, 5897, 
          5267, 4017, 5272, 5873, 5274, 5262, 6640, 6641, 5899, 6466, 6467, 
          6465, 6535, 3260, 6456, 6455, 6055, 4740, 4738, 5299, 6078, 5298, 
          4022, 5306, 6080, 5308, 5303, 5304, 6079, 6592, 6591, 6593, 3270, 
          6458, 6457, 6056, 4757, 4755, 5334, 6081, 5333, 6649, 6650, 6651, 
          6082, 6545, 6544, 5338, 6546, 6548, 6547, 5918, 5339, 5978, 5946, 
          5948, 5947, 5770, 4766, 4753, 6643, 5361, 6644, 6645, 6538, 6539, 
          6537, 6536, 6540, 6542, 6541, 6083, 6551, 6550, 5364, 6552, 6554, 
          6553, 5919, 5980, 6133, 5979, 5981, 3284, 5950, 5949, 5772, 6414, 
          6415, 6413, 4763, 6406, 6408, 6407, 5875, 6438, 6440, 6437, 6352, 
          6353, 6356, 6355, 5835, 6360, 6363, 6358, 4244, 6324, 6329, 6327, 
          6866, 7039}],
         RowBox[{"-", "0.2`"}]],
        Annotation[#, -0.2, "Tooltip"]& ], 
       TagBox[
        TooltipBox[
         LineBox[{7036, 6956, 5669, 6824, 6191, 6998, 6195, 6894, 6424, 7028, 
          6813, 6345, 6347, 7023, 6350, 6899, 6204, 7001, 6203, 6829, 6208, 
          7003, 6210, 6902, 6244, 7010, 6814, 5155, 6226, 5117, 6512, 5120, 
          6608, 6382, 6848, 6383, 5549, 6911, 6433, 6434, 6384, 6385, 5121, 
          6513, 5123, 6612, 6387, 6849, 6388, 5551, 6912, 6435, 6436, 6389, 
          6391, 6390, 5124, 6613, 6615, 6617, 6616, 6392, 5552, 5553, 3863, 
          5164, 3609, 6330, 6369, 6850, 6331, 5166, 6855, 6146, 6147, 5167, 
          6180, 4154, 6889, 4156, 6181, 6819, 6140, 6976, 6141, 6843, 6312, 
          7014, 3208, 5676, 3232}],
         RowBox[{"-", "0.2`"}]],
        Annotation[#, -0.2, "Tooltip"]& ], 
       TagBox[
        TooltipBox[
         LineBox[{7056, 6160, 6883, 6037, 6035, 6831, 5804, 7019, 5807, 6884, 
          6994, 6040, 4125, 6714, 5803, 5900, 6600, 5776, 6573, 5775, 5787, 
          3949, 5928, 5927, 5777, 6917, 6890, 4343, 6666, 6668, 4333, 6632, 
          6598, 5655, 6148, 6149, 4801, 5640, 4800, 5847, 5651, 6470, 6469, 
          3518, 6138, 5587, 6137, 6136, 5751, 6555, 6556, 6492, 6491, 3928, 
          4797, 3927, 4611, 4933, 6272, 3481, 4791, 3480, 6278, 4929, 3764, 
          4075, 3765, 6242, 5409, 6135, 6134, 5736, 3389, 6277, 6274, 6468, 
          4870, 6276, 6275, 5653, 5654, 6874, 6033, 4787, 5846, 6029, 5860, 
          4894, 6050, 6907, 6225, 5858, 7007, 6223, 6219, 6100}],
         RowBox[{"-", "0.2`"}]],
        Annotation[#, -0.2, "Tooltip"]& ], 
       TagBox[
        TooltipBox[LineBox[{3134, 6117, 6107}],
         RowBox[{"-", "0.2`"}]],
        Annotation[#, -0.2, "Tooltip"]& ], 
       TagBox[
        TooltipBox[
         LineBox[{4418, 4160, 5135, 5139, 5131, 3587, 3961, 3331, 3835, 4871, 
          4873, 4806, 5149, 5534, 3332, 5150, 3590, 5056, 3547, 4809, 5536, 
          5537, 3838, 5057, 5059, 4812, 5539, 3334, 3841, 5061, 5064, 4817, 
          5544, 3336, 3846, 4336, 4340, 3594, 3966, 3339, 4373, 4130, 4134, 
          3852, 5783, 6155, 6164, 6335, 3192, 6316, 3224, 5694, 6946}],
         RowBox[{"-", "0.2`"}]],
        Annotation[#, -0.2, "Tooltip"]& ], 
       TagBox[
        TooltipBox[LineBox[{5714, 6015, 6006, 6023, 6060}],
         RowBox[{"-", "0.2`"}]],
        Annotation[#, -0.2, "Tooltip"]& ]}, 
      {GrayLevel[0], Opacity[0.4], 
       TagBox[
        TooltipBox[
         LineBox[{7042, 6947, 5812, 5843, 5838, 4137, 6264, 6268, 6260, 4555, 
          5799, 5789, 5793, 4657, 3195, 4142, 5110, 3573, 5074, 3575, 5114, 
          3952, 5100, 3570, 4637, 4664, 4667, 6790, 4107, 5045, 4110, 3538, 
          4113, 4646, 4647, 3321, 5596, 3531, 5037, 3534, 5043, 3403, 3829, 
          4093, 3167, 3315, 3820, 5003, 3823, 3399, 3816, 4626, 3159, 3308, 
          3810, 4981, 3813, 3394, 4949, 4951, 4607, 5464, 3154, 3302, 3807, 
          4952, 3809, 3391, 4278, 3477, 4080, 4596, 3908, 4925, 3904, 4277, 
          3475, 4061, 4592, 3148}],
         RowBox[{"-", "0.4`"}]],
        Annotation[#, -0.4, "Tooltip"]& ], 
       TagBox[
        TooltipBox[
         LineBox[{7048, 6090, 6841, 5672, 6955, 5668, 6823, 6190, 6997, 6194, 
          6893, 6423, 7027, 6812, 6344, 6349, 4147, 6898, 4150, 6205, 6828, 
          6209, 3972, 6901, 6243, 5156, 3601, 5119, 6602, 6604, 6607, 6606, 
          6381, 5547, 5548, 3860, 5122, 6609, 6611, 3581, 6386, 5550, 3862, 
          4360, 3201, 4364, 6614, 3582, 4552, 3583, 4366, 3203, 5161, 3607, 
          4804, 3608, 5168, 5169, 5165, 3610, 4155, 3427, 4407, 4408, 3975, 
          6842, 6311, 7013, 3207, 5675, 3231}],
         RowBox[{"-", "0.4`"}]],
        Annotation[#, -0.4, "Tooltip"]& ], 
       TagBox[
        TooltipBox[LineBox[{3133, 6116, 6106}],
         RowBox[{"-", "0.4`"}]],
        Annotation[#, -0.4, "Tooltip"]& ], 
       TagBox[
        TooltipBox[
         LineBox[{3289, 3380, 6231, 6227, 5876, 4866, 4859, 3753, 5379, 3279, 
          3375, 4887, 4042, 3274, 3370, 5347, 4034, 3262, 4843, 4841, 4839, 
          3712, 5317, 3255, 4835, 4833, 4830, 5254, 5252, 3244, 3355, 4005, 
          3676, 4207, 4203, 3226, 3347, 4685, 3640, 6688, 6684, 6691, 6694, 
          6698, 6095, 6473, 6476, 6471, 5208, 6448, 6453, 6451, 5915, 5973, 
          6103, 5971, 5976, 3241, 5944, 5941, 5766, 4709, 6411, 4676, 6377, 
          5244, 5862, 5243, 6431, 6393, 6396, 5248, 6514, 5250, 6623, 6402, 
          5234, 6417, 5247, 6522, 5246, 6628, 6445, 6441, 3252, 5768, 4720, 
          4705, 3692, 5269, 4016, 5273, 3695, 6639, 3694, 5271, 4219, 4741, 
          4739, 4737, 3707, 5300, 4021, 5307, 3710, 5302, 3709, 5305, 4223, 
          4758, 4756, 4754, 3720, 5335, 4031, 5341, 6652, 6653, 3722, 6543, 
          3721, 5340, 4230, 4767, 4765, 6642, 3735, 6703, 6646, 6648, 6647, 
          4039, 5366, 6654, 6656, 3737, 6549, 3736, 5365, 4245, 4776, 4775, 
          6404, 6405, 5373, 5874, 5372, 6439, 6351, 6354, 4525, 5834, 6359, 
          6362, 6357, 4243, 6323, 6328, 6326, 6865, 5710, 6939, 6087, 7046}],
         RowBox[{"-", "0.4`"}]],
        Annotation[#, -0.4, "Tooltip"]& ], 
       TagBox[
        TooltipBox[
         LineBox[{4417, 4159, 5134, 5138, 5130, 3586, 5145, 3959, 3960, 3834, 
          4872, 3416, 4805, 5148, 5151, 3591, 4122, 4674, 4316, 3545, 4541, 
          3546, 4318, 3184, 4323, 3548, 4543, 3549, 3843, 5538, 3840, 5063, 
          3552, 4816, 5541, 5543, 3845, 4339, 3560, 4379, 3593, 3965, 3338, 
          4372, 4129, 4133, 3851, 5782, 6154, 6163, 6334, 3191, 6315, 3223, 
          5693, 6945, 6174, 6984, 6989, 6159, 6882, 6036, 6034, 6077, 6076, 
          5806, 4126, 6039, 4124, 6713, 4654, 6715, 4653, 6673, 6674, 6574, 
          3950, 4349, 3948, 5926, 5924, 4342, 3554, 6667, 6597, 6599, 3831, 
          4331, 3830, 5648, 5649, 5641, 5642, 5652, 3519, 5647, 5011, 5589, 
          5588, 5586, 4631, 6595, 6594, 6489, 6490, 4796, 3926, 4610, 4931, 
          4932, 4790, 4930, 4928, 5408, 4073, 4074, 4283, 4282, 3388, 6273, 
          4072, 3801, 5397, 3803, 4786, 5733, 5735, 4893, 6047, 6049, 5857, 
          7006, 6222, 6218, 6099}],
         RowBox[{"-", "0.4`"}]],
        Annotation[#, -0.4, "Tooltip"]& ], 
       TagBox[
        TooltipBox[LineBox[{5713, 6014, 6005, 6022, 6059}],
         RowBox[{"-", "0.4`"}]],
        Annotation[#, -0.4, "Tooltip"]& ]}, 
      {GrayLevel[0], Opacity[0.4], 
       TagBox[
        TooltipBox[LineBox[{6105, 6115, 3132}],
         RowBox[{"-", "0.6`"}]],
        Annotation[#, -0.6, "Tooltip"]& ], 
       TagBox[
        TooltipBox[
         LineBox[{3147, 4591, 4060, 3474, 3907, 3296, 4597, 4595, 4079, 4279, 
          3392, 4285, 3918, 4956, 4957, 4953, 4955, 4954, 4082, 4619, 4618, 
          4606, 3500, 4978, 3925, 4985, 3502, 4983, 3501, 4984, 4088, 4629, 
          4628, 4625, 3514, 5000, 3935, 5008, 5009, 5005, 5007, 5006, 4094, 
          3174, 4650, 4092, 4310, 3404, 3828, 3402, 5041, 5042, 5036, 5597, 
          5595, 3320, 3173, 4648, 4112, 3537, 4309, 3413, 5103, 3571, 5094, 
          3569, 3955, 5099, 3951, 5113, 3574, 5073, 3572, 5109, 4141, 3194, 
          4656, 5792, 5788, 5798, 4554, 6259, 6267, 6263, 4136, 5837, 5842, 
          5811, 6092, 6089, 6840, 5671, 6954, 5667, 6822, 6189, 6996, 6193, 
          6892, 6421, 6422, 6343, 6348, 4146, 6897, 4149, 4561, 4560, 3970, 
          5158, 3971, 3600, 5118, 6601, 6605, 3578, 6380, 5546, 3861, 4353, 
          3199, 4358, 6610, 3579, 4551, 3580, 4359, 3200, 4362, 4363, 3783, 
          4367, 4365, 3202, 5159, 5160, 4803, 5163, 5533, 5162, 3204, 5496, 
          4151, 3425, 4368, 3426, 4405, 4406, 3974, 6308, 6310, 3341, 3206, 
          5674, 3230}],
         RowBox[{"-", "0.6`"}]],
        Annotation[#, -0.6, "Tooltip"]& ], 
       TagBox[
        TooltipBox[
         LineBox[{3288, 6230, 5532, 4869, 5380, 4865, 4858, 3752, 4773, 4772, 
          4044, 4855, 4041, 4762, 4036, 4845, 4033, 4747, 5318, 3713, 5443, 
          3711, 4506, 3888, 4484, 3889, 4832, 4829, 3679, 5256, 5516, 4007, 
          5437, 4004, 4477, 4478, 4206, 4202, 3225, 3346, 4684, 3639, 6687, 
          6683, 6690, 6693, 6697, 6094, 5215, 6475, 5207, 6450, 5211, 5914, 
          5210, 5975, 5939, 5943, 5940, 5765, 4708, 6375, 6374, 3674, 5245, 
          4001, 5249, 6618, 6620, 6622, 6621, 6399, 6676, 6675, 6677, 6625, 
          6627, 6626, 4217, 4722, 4719, 4704, 3691, 4018, 5612, 3359, 4724, 
          4723, 4221, 3696, 4494, 3444, 5301, 3708, 5296, 3706, 5617, 3362, 
          5521, 5520, 4743, 5310, 5309, 3447, 5336, 5337, 5331, 5624, 5623, 
          3369, 3271, 5523, 4760, 5343, 5342, 3450, 5362, 5363, 5359, 5629, 
          5628, 3374, 5528, 6655, 5527, 4769, 3738, 5367, 3455, 4246, 4774, 
          6403, 3747, 5374, 4047, 4526, 3749, 6322, 6361, 4242, 6325, 4524, 
          6864, 5709, 6938, 6086, 7045}],
         RowBox[{"-", "0.6`"}]],
        Annotation[#, -0.6, "Tooltip"]& ], 
       TagBox[
        TooltipBox[
         LineBox[{4416, 4158, 5133, 5137, 5129, 5147, 5144, 3958, 3837, 3181, 
          4120, 3415, 4312, 4313, 4123, 4121, 3182, 4314, 4315, 3775, 4319, 
          4317, 3183, 4321, 4322, 3777, 4325, 4324, 3186, 4327, 3550, 4545, 
          3551, 3848, 5542, 3844, 4338, 3559, 4378, 3962, 4377, 3964, 4374, 
          4371, 4128, 4132, 3850, 5781, 6153, 6162, 6333, 3190, 6314, 3222, 
          5692, 6944, 6173, 6983, 6988, 6158, 6881, 6166, 5779, 6038, 6075, 
          5805, 5785, 3418, 5068, 4127, 6712, 6669, 6672, 6671, 6571, 6572, 
          4348, 5925, 4347, 3556, 4546, 3553, 6596, 4330, 5644, 5643, 5645, 
          5650, 4302, 5646, 5634, 5637, 5636, 3774, 5635, 5479, 5480, 4295, 
          3162, 3311, 4798, 4795, 3493, 4959, 5468, 4793, 4792, 4789, 3492, 
          4958, 3150, 3297, 3910, 3479, 4069, 4598, 4599, 4071, 3800, 5396, 
          3802, 4785, 5732, 5734, 4892, 6046, 6048, 5856, 7005, 6221, 6217, 
          6098}],
         RowBox[{"-", "0.6`"}]],
        Annotation[#, -0.6, "Tooltip"]& ], 
       TagBox[
        TooltipBox[LineBox[{5712, 6013, 6004, 6021, 6058}],
         RowBox[{"-", "0.6`"}]],
        Annotation[#, -0.6, "Tooltip"]& ]}, 
      {GrayLevel[0], Opacity[0.4], 
       TagBox[
        TooltipBox[
         LineBox[{3229, 5673, 3205, 3340, 6309, 6307, 3973, 3611, 4153, 4152, 
          5495, 5494, 5493, 3585, 4118, 4117, 5127, 3584, 5126, 5125, 4802, 
          3541, 5053, 3833, 3330, 3956, 3782, 4116, 4115, 4355, 3329, 4673, 
          4672, 4361, 3781, 4357, 4356, 3198, 4352, 4354, 4550, 4549, 3577, 
          6603, 4351, 4675, 4669, 3602, 5157, 3969, 4559, 3424, 4148, 3858, 
          6346, 6420, 6891, 3968, 6192, 6821, 5666, 6953, 5670, 6839, 6088, 
          6091, 5810, 5841, 5836, 4135, 6271, 4558, 6258, 4553, 5797, 5802, 
          5796, 3859, 4655, 3193, 4140, 5108, 4145, 3576, 4670, 5491, 5492, 
          3328, 5607, 3568, 5093, 5102, 5101, 3412, 4308, 3414, 4111, 4671, 
          3179, 4114, 5050, 5051, 5038, 3540, 5052, 3943, 4311, 3539, 4091, 
          4649, 4095, 3405, 5010, 3515, 4630, 5477, 5478, 3316, 5584, 5585, 
          4999, 5002, 5001, 3401, 4986, 4987, 4620, 5473, 3161, 3310, 5576, 
          5577, 4977, 4980, 4979, 3396, 5568, 5569, 5465, 5466, 5467, 3303, 
          3919, 3491, 4078, 4609}],
         RowBox[{"-", "0.8`"}]],
        Annotation[#, -0.8, "Tooltip"]& ], 
       TagBox[
        TooltipBox[
         LineBox[{3478, 4280, 4068, 4254, 4052, 4053, 3457, 6587, 6588, 4255, 
          6589, 6590, 6113, 6123, 6114, 3131}],
         RowBox[{"-", "0.8`"}]],
        Annotation[#, -0.8, "Tooltip"]& ], 
       TagBox[
        TooltipBox[LineBox[{6057, 6020, 6003, 6012, 5711}],
         RowBox[{"-", "0.8`"}]],
        Annotation[#, -0.8, "Tooltip"]& ], 
       TagBox[
        TooltipBox[
         LineBox[{6097, 6224, 6102, 5859, 4896, 4895, 4898, 4897, 3458, 5398, 
          5399, 5395, 5631, 5630, 3292, 3140, 4581, 4070, 3387, 4281, 3909, 
          3805, 3804, 4286, 4287, 3767, 4289, 4288, 4533, 4290, 4291, 3503, 
          4293, 4292, 5633, 3770, 5423, 5425, 5424, 3504, 4539, 3936, 3937, 
          4632, 3168, 4097, 4652, 4651, 4332, 3780, 4547, 3555, 4350, 4334, 
          3562, 5066, 3563, 6670, 5067, 3417, 5784, 5786, 5778, 6165, 6167, 
          6157, 6987, 6982, 6172, 6943, 5691, 3221, 6313, 3189, 6332, 6161, 
          6152, 5780, 3849, 3419, 4131, 3592, 3963, 4376, 4375, 3558, 4548, 
          3557, 4335, 3187, 4328, 4329, 3779, 4326, 3778, 4544, 4096, 4320, 
          3323, 3947, 3776, 4542, 3517, 4301, 3544, 3946, 3945, 4540, 3516, 
          4300, 3832, 3322, 3944, 3543, 5054, 3542, 5055, 4119, 3180, 3836, 
          3957, 5143, 5146, 5128, 5136, 5132, 4157, 4415}],
         RowBox[{"-", "0.8`"}]],
        Annotation[#, -0.8, "Tooltip"]& ], 
       TagBox[
        TooltipBox[
         LineBox[{7044, 6085, 6937, 5708, 6863, 4523, 6321, 6320, 3748, 4048, 
          3379, 4522, 3746, 4247, 3456, 4530, 4049, 5375, 5376, 4768, 4780, 
          3286, 4248, 5369, 3740, 5360, 3741, 5370, 4040, 5368, 3739, 4759, 
          4770, 4771, 4231, 5345, 3724, 5332, 3725, 5346, 4032, 5344, 3723, 
          4742, 4761, 3272, 4224, 5311, 5312, 5297, 5314, 5313, 4023, 4504, 
          3445, 4495, 4220, 4725, 3254, 3358, 5611, 5613, 5266, 3693, 5270, 
          3442, 5251, 6624, 3675, 4711, 5514, 6619, 5515, 3354, 4002, 3673, 
          6373, 4707, 4710, 4201, 5212, 3646, 6446, 6447, 5214, 6093, 5213, 
          6696, 6689, 6682, 6686, 3638, 4683, 3345, 4688, 4687, 4209, 3439, 
          4476, 4003, 5436, 5438, 5435, 3793, 4481, 3678, 4496, 4497, 4483, 
          4482, 3887, 4505, 4746, 4745, 4744, 3794, 4024, 3363, 3261, 5319, 
          5320, 4844, 4846, 4847, 3273, 5371, 3742, 4854, 4856, 4857, 5529, 
          5530, 4249, 4250, 3799, 5449, 3798, 4531, 3754, 5381, 3755, 4868, 
          5531, 6229, 3287}],
         RowBox[{"-", "0.8`"}]],
        Annotation[#, -0.8, "Tooltip"]& ]}, {}, {}, {}}}], {{
   1.197220889778369, 0.}, {0.5986104448891845, 
   1.1751406146397712`}}]]], "Output",
 ImageSize->{152, 216},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->32759652]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->868782869],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["WeierstrassHalfPeriods",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/WeierstrassHalfPeriods"]], "InlineFormula"],
 " is effectively the inverse of ",
 Cell[BoxData["WeierstrassHalfInvariants"], "InlineFormula"],
 ":"
}], "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->390817238],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"WeierstrassInvariants", "[", 
   RowBox[{"WeierstrassHalfPeriods", "[", 
    RowBox[{"{", 
     RowBox[{"0.5", ",", 
      RowBox[{"1", "-", "I"}]}], "}"}], "]"}], "]"}], "//", " ", 
  "Chop"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->140465665],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.5`", ",", 
   RowBox[{"1.0000000000000033`", "\[InvisibleSpace]", "-", 
    RowBox[{"1.0000000000000038`", " ", "\[ImaginaryI]"}]}]}], 
  "}"}]], "Output",
 ImageSize->{102, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->121776132]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->774609305],

Cell["\<\
Assignment to half\[Hyphen]periods with symbolic or exact invariants is \
impossible as the right\[Hyphen]hand side is not a list:\
\>", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->561201323],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"\[Omega]1", ",", "\[Omega]3"}], "}"}], "=", 
  RowBox[{"WeierstrassHalfPeriods", "[", 
   RowBox[{"{", 
    RowBox[{"g2", ",", "g3"}], "}"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->294948832],

Cell[BoxData[
 RowBox[{
  RowBox[{"Set", "::", "\<\"shape\"\>"}], ":", 
  " ", "\<\"Lists \\!\\({\[Omega]1, \[Omega]3}\\) and \
\\!\\(WeierstrassHalfPeriods[\\(\\({g2, g3}\\)\\)]\\) are not the same shape. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/Set/shape\\\", \
ButtonNote -> \\\"Set::shape\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->415425625],

Cell[BoxData[
 RowBox[{"WeierstrassHalfPeriods", "[", 
  RowBox[{"{", 
   RowBox[{"g2", ",", "g3"}], "}"}], "]"}]], "Output",
 ImageSize->{226, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->298116258]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->360780481],

Cell["A doubly periodic function over the complex plane:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->75528798],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Module", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"g2", "=", "2."}], ",", 
     RowBox[{"g3", "=", 
      RowBox[{"1", "+", "\[ImaginaryI]"}]}], ",", "\[Omega]1", ",", 
     "\[Omega]3", ",", "f", ",", "\[WeierstrassP]"}], "}"}], ",", 
   RowBox[{
    RowBox[{"\[WeierstrassP]", "=", 
     RowBox[{
      RowBox[{"WeierstrassP", "[", 
       RowBox[{"#1", ",", 
        RowBox[{"{", 
         RowBox[{"g2", ",", "g3"}], "}"}]}], "]"}], "&"}]}], ";", 
    RowBox[{
     RowBox[{"f", "[", "z_", "]"}], "=", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", 
         RowBox[{"\[WeierstrassP]", "[", 
          RowBox[{
           RowBox[{"2", " ", "z"}], "+", "1"}], "]"}]}], "-", 
        RowBox[{"2", " ", 
         RowBox[{"\[WeierstrassP]", "[", 
          RowBox[{
           RowBox[{"2", " ", "z"}], "-", "1"}], "]"}]}]}], ")"}], "/", 
      RowBox[{"\[WeierstrassP]", "[", "z", "]"}]}]}], ";", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\[Omega]1", ",", "\[Omega]3"}], "}"}], "=", 
     RowBox[{"N", "[", 
      RowBox[{"WeierstrassHalfPeriods", "[", 
       RowBox[{"{", 
        RowBox[{"g2", ",", "g3"}], "}"}], "]"}], "]"}]}], ";", 
    RowBox[{"ParametricPlot3D", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Re", "[", 
         RowBox[{
          RowBox[{"x", " ", "\[Omega]1"}], "+", 
          RowBox[{"y", " ", "\[Omega]3"}]}], "]"}], ",", 
        RowBox[{"Im", "[", 
         RowBox[{
          RowBox[{"x", " ", "\[Omega]1"}], "+", 
          RowBox[{"y", " ", "\[Omega]3"}]}], "]"}], ",", 
        RowBox[{"Re", "[", 
         RowBox[{"f", "[", 
          RowBox[{
           RowBox[{"x", " ", "\[Omega]1"}], "+", 
           RowBox[{"y", " ", "\[Omega]3"}]}], "]"}], "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"y", ",", 
        RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
      RowBox[{"PlotRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "1"}], ",", "1"}], "}"}]}], ",", 
      RowBox[{"Mesh", "\[Rule]", "False"}]}], "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->640082573],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{206, 236},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->679902735]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->17411],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["WeierstrassP",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/WeierstrassP"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["InverseWeierstrassP",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/InverseWeierstrassP"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ModularLambda",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ModularLambda"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->31898]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->16979],

Cell[TextData[ButtonBox["Elliptic Integrals and Elliptic Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/EllipticIntegralsAndEllipticFunctions"]], "Tutorials",
 CellID->14140]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection",
 CellID->2007],

Cell[TextData[StyleBox[ButtonBox["MathWorld",
 BaseStyle->"MathWorldLink",
 ButtonData->{
   URL["http://mathworld.wolfram.com/WeierstrassEllipticFunction.html"], 
   None}], "IT"]], "RelatedLinks"],

Cell[TextData[ButtonBox["The Wolfram Functions Site",
 BaseStyle->"FunctionsSiteLink",
 ButtonData->{
   URL["http://functions.wolfram.com/EllipticFunctions/WeierstrassHalfPeriods/\
"], None}]], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->34668660],

Cell[TextData[ButtonBox["Elliptic Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/EllipticFunctions"]], "MoreAbout",
 CellID->7710282]
}, Open  ]],

Cell["New in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"WeierstrassHalfPeriods - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 29, 23.1334396}", "context" -> "System`", 
    "keywords" -> {
     "half-periods", "halfperiods", "Weierstrass elliptic function", 
      "Weierstrass half periods"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "WeierstrassHalfPeriods[{g_2, g_3}] gives the half-periods {\\[Omega], \
\\[Omega]^\\[Prime]} for Weierstrass elliptic functions corresponding to the \
invariants {g_2, g_3}.", "synonyms" -> {"weierstrass half periods"}, "title" -> 
    "WeierstrassHalfPeriods", "type" -> "Symbol", "uri" -> 
    "ref/WeierstrassHalfPeriods"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5642, 189, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->438256462]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 302512, 5475}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2087, 53, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2710, 80, 58, 1, 70, "ObjectName",
 CellID->824],
Cell[2771, 83, 1217, 38, 70, "Usage",
 CellID->16745]
}, Open  ]],
Cell[CellGroupData[{
Cell[4025, 126, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4503, 143, 120, 4, 70, "Notes",
 CellID->20640],
Cell[4626, 149, 362, 12, 70, "Notes",
 CellID->12549],
Cell[4991, 163, 365, 12, 70, "Notes",
 CellID->7724],
Cell[5359, 177, 246, 7, 70, "Notes",
 CellID->31226]
}, Closed]],
Cell[CellGroupData[{
Cell[5642, 189, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->438256462],
Cell[CellGroupData[{
Cell[6027, 203, 148, 5, 70, "ExampleSection",
 CellID->859779327],
Cell[6178, 210, 201, 5, 70, "ExampleText",
 CellID->285478447],
Cell[CellGroupData[{
Cell[6404, 219, 167, 5, 28, "Input",
 CellID->249957289],
Cell[6574, 226, 425, 12, 36, "Output",
 CellID->3529434]
}, Open  ]],
Cell[7014, 241, 125, 3, 70, "ExampleDelimiter",
 CellID->171968836],
Cell[CellGroupData[{
Cell[7164, 248, 366, 12, 28, "Input",
 CellID->97309377],
Cell[7533, 262, 2604, 47, 144, "Output",
 Evaluatable->False,
 CellID->341596932]
}, Open  ]],
Cell[10152, 312, 123, 3, 70, "ExampleDelimiter",
 CellID->2578970],
Cell[10278, 317, 354, 10, 70, "ExampleText",
 CellID->78801090],
Cell[CellGroupData[{
Cell[10657, 331, 261, 8, 70, "Input",
 CellID->67668500],
Cell[10921, 341, 274, 7, 36, "Output",
 CellID->343520363]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[11244, 354, 220, 7, 70, "ExampleSection",
 CellID->175383112],
Cell[11467, 363, 206, 5, 70, "ExampleText",
 CellID->47300755],
Cell[CellGroupData[{
Cell[11698, 372, 222, 7, 70, "Input",
 CellID->237003654],
Cell[11923, 381, 622, 17, 75, "Output",
 CellID->580451519]
}, Open  ]],
Cell[12560, 401, 125, 3, 70, "ExampleDelimiter",
 CellID->301702721],
Cell[12688, 406, 112, 3, 70, "ExampleText",
 CellID->204645271],
Cell[CellGroupData[{
Cell[12825, 413, 198, 6, 70, "Input",
 CellID->720882513],
Cell[13026, 421, 579, 17, 58, "Output",
 CellID->141010546]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[13654, 444, 226, 7, 70, "ExampleSection",
 CellID->87254061],
Cell[13883, 453, 234, 5, 70, "ExampleText",
 CellID->266998498],
Cell[CellGroupData[{
Cell[14142, 462, 1842, 53, 70, "Input",
 CellID->713111678],
Cell[15987, 517, 215105, 3603, 70, "Output",
 CellID->32759652]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[231141, 4126, 237, 7, 70, "ExampleSection",
 CellID->868782869],
Cell[231381, 4135, 441, 13, 70, "ExampleText",
 CellID->390817238],
Cell[CellGroupData[{
Cell[231847, 4152, 282, 9, 70, "Input",
 CellID->140465665],
Cell[232132, 4163, 328, 10, 36, "Output",
 CellID->121776132]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[232509, 4179, 230, 7, 70, "ExampleSection",
 CellID->774609305],
Cell[232742, 4188, 318, 8, 70, "ExampleText",
 CellID->561201323],
Cell[CellGroupData[{
Cell[233085, 4200, 255, 8, 70, "Input",
 CellID->294948832],
Cell[233343, 4210, 436, 8, 70, "Message",
 CellID->415425625],
Cell[233782, 4220, 256, 8, 36, "Output",
 CellID->298116258]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[234087, 4234, 228, 7, 70, "ExampleSection",
 CellID->360780481],
Cell[234318, 4243, 229, 5, 70, "ExampleText",
 CellID->75528798],
Cell[CellGroupData[{
Cell[234572, 4252, 2258, 66, 70, "Input",
 CellID->640082573],
Cell[236833, 4320, 61432, 1011, 70, "Output",
 Evaluatable->False,
 CellID->679902735]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[298326, 5338, 311, 9, 70, "SeeAlsoSection",
 CellID->17411],
Cell[298640, 5349, 736, 26, 70, "SeeAlso",
 CellID->31898]
}, Open  ]],
Cell[CellGroupData[{
Cell[299413, 5380, 314, 9, 70, "TutorialsSection",
 CellID->16979],
Cell[299730, 5391, 192, 4, 70, "Tutorials",
 CellID->14140]
}, Open  ]],
Cell[CellGroupData[{
Cell[299959, 5400, 320, 9, 70, "RelatedLinksSection",
 CellID->2007],
Cell[300282, 5411, 198, 4, 70, "RelatedLinks"],
Cell[300483, 5417, 210, 4, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[300730, 5426, 318, 9, 70, "MoreAboutSection",
 CellID->34668660],
Cell[301051, 5437, 145, 3, 70, "MoreAbout",
 CellID->7710282]
}, Open  ]],
Cell[301211, 5443, 27, 0, 70, "History"],
Cell[301241, 5445, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

