(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    143765,       3378]
NotebookOptionsPosition[    134784,       3068]
NotebookOutlinePosition[    136104,       3105]
CellTagsIndexPosition[    136017,       3100]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Elliptic Integrals and Elliptic Functions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/EllipticIntegralsAndEllipticFunctions"]}, #, 2]& ,
         Evaluator -> Automatic], {
       1->"\<\"Elliptic Integrals and Elliptic Functions\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"InverseWeierstrassP" :> 
          Documentation`HelpLookup["paclet:ref/InverseWeierstrassP"], 
          "WeierstrassPPrime" :> 
          Documentation`HelpLookup["paclet:ref/WeierstrassPPrime"], 
          "WeierstrassHalfPeriods" :> 
          Documentation`HelpLookup["paclet:ref/WeierstrassHalfPeriods"], 
          "WeierstrassInvariants" :> 
          Documentation`HelpLookup["paclet:ref/WeierstrassInvariants"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"InverseWeierstrassP\"\>", 
       2->"\<\"WeierstrassPPrime\"\>", 3->"\<\"WeierstrassHalfPeriods\"\>", 
       4->"\<\"WeierstrassInvariants\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Elliptic Functions" :> 
          Documentation`HelpLookup["paclet:guide/EllipticFunctions"], 
          "Mathematical Functions" :> 
          Documentation`HelpLookup["paclet:guide/MathematicalFunctions"], 
          "Special Functions" :> 
          Documentation`HelpLookup["paclet:guide/SpecialFunctions"]}, #, 2]& ,
         Evaluator -> Automatic], {1->"\<\"Elliptic Functions\"\>", 
       2->"\<\"Mathematical Functions\"\>", 
       3->"\<\"Special Functions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["WeierstrassP", "ObjectName",
 CellID->32533],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["WeierstrassP",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/WeierstrassP"], "[", 
       RowBox[{
        StyleBox["u", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["g", "TI"], 
           StyleBox["2", "TR"]], ",", 
          SubscriptBox[
           StyleBox["g", "TI"], 
           StyleBox["3", "TR"]]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the Weierstrass elliptic function ",
     Cell[BoxData[
      FormBox[
       RowBox[{"\[WeierstrassP]", "(", 
        RowBox[{
         RowBox[{"u", ";", 
          SubscriptBox["g", "2"]}], ",", 
         SubscriptBox["g", "3"]}], ")"}], TraditionalForm]], "InlineMath"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->6166]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
Mathematical function, suitable for both symbolic and numerical manipulation.\
\
\>", "Notes",
 CellID->20640],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{"\[WeierstrassP]", "(", 
    RowBox[{
     RowBox[{"u", ";", 
      SubscriptBox["g", "2"]}], ",", 
     SubscriptBox["g", "3"]}], ")"}], TraditionalForm]], "InlineMath"],
 " gives the value of ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " for which ",
 Cell[BoxData[
  FormBox[
   RowBox[{"u", "=", 
    RowBox[{
     SubsuperscriptBox["\[Integral]", "\[Infinity]", "x"], 
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"4", 
         SuperscriptBox["t", "3"], "-", 
         SubscriptBox["g", "2"], "t", "-", 
         SubscriptBox["g", "3"]}], ")"}], 
       RowBox[{
        RowBox[{"-", "1"}], "/", "2"}]], "d", "\[VeryThinSpace]", "t"}]}]}], 
   TraditionalForm]], "InlineMath"],
 ". "
}], "Notes",
 CellID->319],

Cell[TextData[{
 "For certain special arguments, ",
 Cell[BoxData[
  ButtonBox["WeierstrassP",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/WeierstrassP"]], "InlineFormula"],
 " automatically evaluates to exact values."
}], "Notes",
 CellID->218232416],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["WeierstrassP",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/WeierstrassP"]], "InlineFormula"],
 " can be evaluated to arbitrary numerical precision."
}], "Notes",
 CellID->31226]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->48409074],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->30179412],

Cell["Evaluate numerically:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->690379517],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"WeierstrassP", "[", 
  RowBox[{"2.", ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->831120123],

Cell[BoxData[
 RowBox[{"2.658541473896018`", "\[InvisibleSpace]", "+", 
  RowBox[{"0.`", " ", "\[ImaginaryI]"}]}]], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{91, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->134648889]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->399966931],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"WeierstrassP", "[", 
    RowBox[{"x", ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "4"}], ",", "4"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->103456368],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{223, 150},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->718077734]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->188570671],

Cell["Series expansion:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->741076968],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"WeierstrassP", "[", 
    RowBox[{"z", ",", 
     RowBox[{"{", 
      RowBox[{"g2", ",", "g3"}], "}"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", "0", ",", "12"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->111185513],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   FractionBox["1", 
    SuperscriptBox["z", "2"]], "+", 
   FractionBox[
    RowBox[{"g2", " ", 
     SuperscriptBox["z", "2"]}], "20"], "+", 
   FractionBox[
    RowBox[{"g3", " ", 
     SuperscriptBox["z", "4"]}], "28"], "+", 
   FractionBox[
    RowBox[{
     SuperscriptBox["g2", "2"], " ", 
     SuperscriptBox["z", "6"]}], "1200"], "+", 
   FractionBox[
    RowBox[{"3", " ", "g2", " ", "g3", " ", 
     SuperscriptBox["z", "8"]}], "6160"], "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      FractionBox[
       SuperscriptBox["g2", "3"], "156000"], "+", 
      FractionBox[
       SuperscriptBox["g3", "2"], "10192"]}], ")"}], " ", 
    SuperscriptBox["z", "10"]}], "+", 
   FractionBox[
    RowBox[{
     SuperscriptBox["g2", "2"], " ", "g3", " ", 
     SuperscriptBox["z", "12"]}], "184800"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "z", "]"}], "13"],
    SeriesData[$CellContext`z, 0, {}, -2, 13, 1],
    Editable->False]}],
  SeriesData[$CellContext`z, 0, {
   1, 0, 0, 0, Rational[1, 20] $CellContext`g2, 0, 
    Rational[1, 28] $CellContext`g3, 0, Rational[1, 1200] $CellContext`g2^2, 
    0, (Rational[3, 6160] $CellContext`g2) $CellContext`g3, 0, 
    Rational[1, 156000] $CellContext`g2^3 + 
    Rational[1, 10192] $CellContext`g3^2, 
    0, (Rational[1, 184800] $CellContext`g2^2) $CellContext`g3}, -2, 13, 1],
  Editable->False]], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{513, 34},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->93812166]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->41543798],

Cell["Evaluate for complex arguments and invariants:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->738927188],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"WeierstrassP", "[", 
  RowBox[{
   RowBox[{"2.5", "+", "I"}], ",", 
   RowBox[{"{", 
    RowBox[{"I", ",", 
     RowBox[{"1", "-", "I"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->6482658],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "0.5514815361240706`"}], "+", 
  RowBox[{"1.1916043397947733`", " ", "\[ImaginaryI]"}]}]], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{134, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->217223085]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->41881473],

Cell["Evaluate to high precision:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->1498658],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"WeierstrassP", "[", 
    RowBox[{"2", ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}]}], "]"}], ",", "50"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->841529584],

Cell[BoxData[
 RowBox[{"2.\
6585414738960103554553115128150995985060606092015311451902588400147`50.\
15051499783199", "+", 
  RowBox[{"0``49.725871558029006", " ", "\[ImaginaryI]"}]}]], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{440, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->138041190]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->563694966],

Cell["\<\
The precision of the output tracks the precision of the input:\
\>", "ExampleText",
 CellID->354628230],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"WeierstrassP", "[", 
  RowBox[{"2.000000000000000000000000", ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->70266597],

Cell[BoxData[
 RowBox[{"2.65854147389601035545531151281250423576`22.589098828708128", "+", 
  RowBox[{"0``22.88742532136116", " ", "\[ImaginaryI]"}]}]], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{251, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->344019120]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->15161106],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["WeierstrassP",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/WeierstrassP"]], "InlineFormula"],
 " threads element\[Hyphen]wise over lists in its first argument:"
}], "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->303104344],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"WeierstrassP", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"u1", ",", "u2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"g2", ",", "g3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->452701008],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"WeierstrassP", "[", 
    RowBox[{"u1", ",", 
     RowBox[{"{", 
      RowBox[{"g2", ",", "g3"}], "}"}]}], "]"}], ",", 
   RowBox[{"WeierstrassP", "[", 
    RowBox[{"u2", ",", 
     RowBox[{"{", 
      RowBox[{"g2", ",", "g3"}], "}"}]}], "]"}]}], "}"}]], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{382, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->69613093]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->193688075],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["WeierstrassP",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/WeierstrassP"]], "InlineFormula"],
 " automatically evaluates to simpler functions for certain parameters:"
}], "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->35018157],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"WeierstrassP", "[", 
  RowBox[{"1", ",", 
   RowBox[{"{", 
    RowBox[{"12", ",", 
     RowBox[{"-", "8"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->851710064],

Cell[BoxData[
 RowBox[{"1", "+", 
  RowBox[{"3", " ", 
   SuperscriptBox[
    RowBox[{"Csch", "[", 
     SqrtBox["3"], "]"}], "2"]}]}]], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{105, 23},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->313406118]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->17503446],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " formatting:"
}], "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->161143590],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"WeierstrassP", "[", 
   RowBox[{"z", ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox["g", "2"], ",", 
      SubscriptBox["g", "3"]}], "}"}]}], "]"}], " ", "//", " ", 
  "TraditionalForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->376293716],

Cell[BoxData[
 FormBox[
  RowBox[{"\[WeierstrassP]", "(", 
   RowBox[{
    RowBox[{"z", ";", 
     SubscriptBox["g", "2"]}], ",", 
    SubscriptBox["g", "3"]}], ")"}], TraditionalForm]], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{61, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TraditionalForm=",
 CellID->515734687]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->406357750],

Cell[TextData[{
 "Express roots of a cubic through ",
 Cell[BoxData[
  ButtonBox["WeierstrassP",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/WeierstrassP"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->80906754],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"With", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"g2", "=", "2"}], ",", 
     RowBox[{"g3", "=", "3"}]}], "}"}], ",", 
   RowBox[{"x", "/.", 
    RowBox[{"NSolve", "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"4", " ", 
         RowBox[{"x", "^", "3"}]}], "-", 
        RowBox[{"g2", " ", "x"}], "-", "g3"}], "==", "0"}], ",", "x"}], 
     "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->150902356],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "0.5449952680395393`"}], "-", 
    RowBox[{"0.6253475246264816`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{
    RowBox[{"-", "0.5449952680395393`"}], "+", 
    RowBox[{"0.6253475246264816`", " ", "\[ImaginaryI]"}]}], ",", 
   "1.0899905360790787`"}], "}"}]], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{376, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->45726356]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Module", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"g2", "=", "2"}], ",", 
     RowBox[{"g3", "=", "3"}], ",", "\[Omega]1", ",", "\[Omega]3"}], "}"}], 
   ",", 
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\[Omega]1", ",", "\[Omega]3"}], "}"}], "=", 
     RowBox[{"WeierstrassHalfPeriods", "[", 
      RowBox[{"N", "[", 
       RowBox[{"{", 
        RowBox[{"g2", ",", "g3"}], "}"}], "]"}], "]"}]}], ";", 
    RowBox[{
     RowBox[{"WeierstrassP", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"\[Omega]1", ",", 
         RowBox[{
          RowBox[{"-", "\[Omega]1"}], "-", "\[Omega]3"}], ",", "\[Omega]3"}], 
        "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"g2", ",", "g3"}], "}"}]}], "]"}], "//", "Sort"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->612941757],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "0.5449952680395393`"}], "-", 
    RowBox[{"0.6253475246264819`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{
    RowBox[{"-", "0.5449952680395393`"}], "+", 
    RowBox[{"0.6253475246264819`", " ", "\[ImaginaryI]"}]}], ",", 
   RowBox[{"1.0899905360790787`", "\[InvisibleSpace]", "+", 
    RowBox[{"0.`", " ", "\[ImaginaryI]"}]}]}], "}"}]], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{414, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->121037008]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->263420200],

Cell[TextData[{
 "Uniformization of a generic elliptic curve ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["y", "2"], "\[Equal]", 
    RowBox[{"f", "(", "x", ")"}], "\[Equal]", 
    RowBox[{
     RowBox[{
      SubscriptBox["a", "0"], 
      SuperscriptBox["x", "4"]}], "+", 
     RowBox[{"4", 
      SubscriptBox["a", "1"], 
      SuperscriptBox["x", "3"]}], "+", 
     RowBox[{"6", 
      SubscriptBox["a", "2"], 
      SuperscriptBox["x", "2"]}], "+", 
     RowBox[{"4", 
      SubscriptBox["a", "3"], "x"}], "+", 
     SubscriptBox["a", "4"]}]}], TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->205578304],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a0", ",", "a1", ",", "a2", ",", "a3", ",", "a4"}], "}"}], " ", 
   "=", " ", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3", ",", "2", ",", "1"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"f", "[", "x_", "]"}], ":=", 
  RowBox[{
   RowBox[{"a0", " ", 
    SuperscriptBox["x", "4"]}], "+", 
   RowBox[{"4", " ", "a1", " ", 
    SuperscriptBox["x", "3"]}], "+", 
   RowBox[{"6", " ", "a2", " ", 
    SuperscriptBox["x", "2"]}], "+", 
   RowBox[{"4", " ", "a3", " ", "x"}], "+", "a4"}]}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->81002440],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"z0", "=", 
  RowBox[{"First", "[", 
   RowBox[{"x", "/.", 
    RowBox[{"Solve", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"f", "[", "x", "]"}], "\[Equal]", "0"}], ",", "x"}], "]"}]}], 
   "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->677600863],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "2"}], "-", 
  SqrtBox["3"]}]], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{56, 17},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->960827480]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\[ScriptG]2", ",", "\[ScriptG]3"}], "}"}], "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"a0", " ", "a4"}], "-", 
      RowBox[{"4", " ", "a1", " ", "a3"}], "+", 
      RowBox[{"3", " ", 
       SuperscriptBox["a2", "2"]}]}], ",", 
     RowBox[{
      RowBox[{"a0", " ", "a2", " ", "a4"}], "+", 
      RowBox[{"2", " ", "a1", " ", "a2", " ", "a3"}], "-", 
      SuperscriptBox["a2", "3"], "-", 
      RowBox[{"a0", " ", 
       SuperscriptBox["a3", "2"]}], "-", 
      RowBox[{
       SuperscriptBox["a1", "2"], " ", "a4"}]}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->78118349],

Cell["The parametrized uniformization:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->244755694],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"x", "[", "z_", "]"}], "=", 
   RowBox[{"z0", "+", 
    RowBox[{
     RowBox[{
      RowBox[{"f", "'"}], "[", "z0", "]"}], "/", 
     RowBox[{"(", 
      RowBox[{"4", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"WeierstrassP", "[", 
          RowBox[{"z", ",", 
           RowBox[{"{", 
            RowBox[{"\[ScriptG]2", ",", "\[ScriptG]3"}], "}"}]}], "]"}], "-", 
         
         RowBox[{
          RowBox[{"1", "/", "24"}], 
          RowBox[{
           RowBox[{"f", "''"}], "[", "z0", "]"}]}]}], ")"}]}], ")"}]}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"y", "[", "z_", "]"}], "=", 
   RowBox[{
    RowBox[{"-", 
     RowBox[{
      RowBox[{"f", "'"}], "[", "z0", "]"}]}], 
    RowBox[{
     RowBox[{"WeierstrassPPrime", "[", 
      RowBox[{"z", ",", 
       RowBox[{"{", 
        RowBox[{"\[ScriptG]2", ",", "\[ScriptG]3"}], "}"}]}], "]"}], "/", 
     RowBox[{"(", 
      RowBox[{"4", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"WeierstrassP", "[", 
           RowBox[{"z", ",", 
            RowBox[{"{", 
             RowBox[{"\[ScriptG]2", ",", "\[ScriptG]3"}], "}"}]}], "]"}], "-",
           
          RowBox[{
           RowBox[{"1", "/", "24"}], 
           RowBox[{
            RowBox[{"f", "''"}], "[", "z0", "]"}]}]}], ")"}], "^", "2"}]}], 
      ")"}]}]}]}], ";"}]}], "Input",
 CellLabel->"In[4]:=",
 CellID->153294004],

Cell["Check the correctness of the uniformization:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->69100198],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"x", "[", 
     RowBox[{"1", "/", "2"}], "]"}], "]"}], "-", 
   RowBox[{
    RowBox[{"y", "[", 
     RowBox[{"1", "/", "2"}], "]"}], "^", "2"}]}], "//", 
  "Simplify"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->285936745],

Cell[BoxData["0"], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->127198134]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->254453165],

Cell["\<\
Special solution of the Korteweg\[Dash]de Vries equation:\
\>", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->2490882],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"w", "[", 
    RowBox[{"z_", ",", "t_", ",", 
     RowBox[{"{", 
      RowBox[{"c1_", ",", "c2_"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"g2_", "?", "InexactNumberQ"}], ",", "g3_"}], "}"}]}], "]"}], ":=",
    
   RowBox[{
    RowBox[{"2", " ", "c1", " ", 
     RowBox[{"WeierstrassP", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"c1", " ", 
         RowBox[{"(", 
          RowBox[{"z", "-", 
           RowBox[{"c2", " ", "t"}]}], ")"}]}], "+", 
        RowBox[{
         RowBox[{"WeierstrassHalfPeriods", "[", 
          RowBox[{"{", 
           RowBox[{"g2", ",", "g3"}], "}"}], "]"}], "[", 
         RowBox[{"[", "2", "]"}], "]"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"g2", ",", "g3"}], "}"}]}], "]"}]}], "-", 
    RowBox[{"c2", "/", "3"}]}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->585283177],

Cell["\<\
The Korteweg\[Dash]de Vries equation:\
\>", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->509837502],

Cell[BoxData[
 RowBox[{
  RowBox[{"kdVPDE", "[", 
   RowBox[{"w_", ",", 
    RowBox[{"{", 
     RowBox[{"z_", ",", "t_"}], "}"}]}], "]"}], ":=", 
  RowBox[{
   RowBox[{"D", "[", 
    RowBox[{"w", ",", "t"}], "]"}], "-", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"3", " ", "w", " ", 
      RowBox[{"D", "[", 
       RowBox[{"w", ",", "z"}], "]"}]}], " ", "-", " ", 
     RowBox[{
      RowBox[{"1", "/", "2"}], " ", 
      RowBox[{"D", "[", 
       RowBox[{"w", ",", 
        RowBox[{"{", 
         RowBox[{"z", ",", "3"}], "}"}]}], "]"}]}]}], ")"}], " "}]}]], "Input",\

 CellLabel->"In[2]:=",
 CellID->354674250],

Cell["\<\
A high\[Hyphen]precision check of the solution:\
\>", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->6079103],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"kdVPDE", "[", 
   RowBox[{
    RowBox[{"w", "[", 
     RowBox[{"z", ",", "t", ",", 
      RowBox[{"{", 
       RowBox[{"4", ",", "4"}], "}"}], ",", 
      RowBox[{"N", "[", 
       RowBox[{
        RowBox[{"WeierstrassInvariants", "[", 
         RowBox[{"{", 
          RowBox[{"2", ",", 
           RowBox[{"3", " ", "I"}]}], "}"}], "]"}], ",", "100"}], "]"}]}], 
     "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"z", ",", "t"}], "}"}]}], "]"}], "/.", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"z", "->", "3"}], ",", 
    RowBox[{"t", "->", "2"}]}], "}"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->388583467],

Cell[BoxData[
 RowBox[{"0``94.17960520322558", "+", 
  RowBox[{"0``92.84886617871574", " ", "\[ImaginaryI]"}]}]], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{138, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->105296763]
}, Open  ]],

Cell["Plot of the solution:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->101671412],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{"Evaluate", "@", 
    RowBox[{"Re", "[", 
     RowBox[{"w", "[", 
      RowBox[{"z", ",", "t", ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", "2"}], "}"}], ",", 
       RowBox[{"WeierstrassInvariants", "[", 
        RowBox[{"{", 
         RowBox[{"2.", ",", 
          RowBox[{"3.", "I"}]}], "}"}], "]"}]}], "]"}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->21849973],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{235, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->720782810]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->383153014],

Cell["Derivatives:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->321690607],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"D", "[", 
    RowBox[{
     RowBox[{"WeierstrassP", "[", 
      RowBox[{"z", ",", 
       RowBox[{"{", 
        RowBox[{"g2", ",", "g3"}], "}"}]}], "]"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"z", ",", "k"}], "}"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"k", ",", "3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->77223633],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"WeierstrassPPrime", "[", 
    RowBox[{"z", ",", 
     RowBox[{"{", 
      RowBox[{"g2", ",", "g3"}], "}"}]}], "]"}], ",", 
   RowBox[{
    RowBox[{"-", 
     FractionBox["g2", "2"]}], "+", 
    RowBox[{"6", " ", 
     SuperscriptBox[
      RowBox[{"WeierstrassP", "[", 
       RowBox[{"z", ",", 
        RowBox[{"{", 
         RowBox[{"g2", ",", "g3"}], "}"}]}], "]"}], "2"]}]}], ",", 
   RowBox[{"12", " ", 
    RowBox[{"WeierstrassP", "[", 
     RowBox[{"z", ",", 
      RowBox[{"{", 
       RowBox[{"g2", ",", "g3"}], "}"}]}], "]"}], " ", 
    RowBox[{"WeierstrassPPrime", "[", 
     RowBox[{"z", ",", 
      RowBox[{"{", 
       RowBox[{"g2", ",", "g3"}], "}"}]}], "]"}]}]}], "}"}]], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{457, 52},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->130786337]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->826593746],

Cell[TextData[{
 "Integrate expressions involving ",
 Cell[BoxData[
  ButtonBox["WeierstrassP",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/WeierstrassP"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->368350005],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"WeierstrassP", "[", 
     RowBox[{"z", ",", 
      RowBox[{"{", 
       RowBox[{"g2", ",", "g3"}], "}"}]}], "]"}], "^", "3"}], ",", " ", "z"}],
   "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->27625758],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{"g3", " ", "z"}], "10"], "+", 
  RowBox[{
   FractionBox["1", "10"], " ", 
   RowBox[{"WeierstrassP", "[", 
    RowBox[{"z", ",", 
     RowBox[{"{", 
      RowBox[{"g2", ",", "g3"}], "}"}]}], "]"}], " ", 
   RowBox[{"WeierstrassPPrime", "[", 
    RowBox[{"z", ",", 
     RowBox[{"{", 
      RowBox[{"g2", ",", "g3"}], "}"}]}], "]"}]}], "-", 
  RowBox[{
   FractionBox["3", "20"], " ", "g2", " ", 
   RowBox[{"WeierstrassZeta", "[", 
    RowBox[{"z", ",", 
     RowBox[{"{", 
      RowBox[{"g2", ",", "g3"}], "}"}]}], "]"}]}]}]], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{453, 60},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1217282]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->53943928],

Cell["\<\
Machine-precision input is insufficient to give a correct result:\
\>", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->3075580],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"WeierstrassP", "[", 
  RowBox[{
   RowBox[{"10.", "^", "16"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->86326626],

Cell[BoxData["ComplexInfinity"], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{109, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->143859908]
}, Open  ]],

Cell["\<\
Use arbitrary\[Hyphen]precision arithmetic to obtain a correct result:\
\>", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->17676679],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"WeierstrassP", "[", 
    RowBox[{
     RowBox[{"10", "^", "16"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "3"}], "}"}]}], "]"}], ",", "20"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->468899453],

Cell[BoxData[
 RowBox[{"4.91889590192377688751393521232`20.15051499783199", "+", 
  RowBox[{"0``19.45864736610382", " ", "\[ImaginaryI]"}]}]], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{230, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->70292561]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->2715856],

Cell["Plot a doubly periodic function over the complex plane:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->482004848],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Module", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"g2", "=", "3"}], ",", 
     RowBox[{"g3", "=", 
      RowBox[{"1", "+", "I"}]}], ",", "\[Omega]1", ",", "\[Omega]3"}], "}"}], 
   ",", 
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\[Omega]1", ",", "\[Omega]3"}], "}"}], "=", 
     RowBox[{
      RowBox[{"WeierstrassHalfPeriods", "[", 
       RowBox[{"{", 
        RowBox[{"g2", ",", "g3"}], "}"}], "]"}], "//", "N"}]}], ";", 
    RowBox[{"ParametricPlot3D", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Re", "[", 
         RowBox[{
          RowBox[{"x", " ", "\[Omega]1"}], "+", 
          RowBox[{"y", " ", "\[Omega]3"}]}], "]"}], ",", 
        RowBox[{"Im", "[", 
         RowBox[{
          RowBox[{"x", " ", "\[Omega]1"}], "+", 
          RowBox[{"y", " ", "\[Omega]3"}]}], "]"}], ",", 
        RowBox[{"Re", "[", 
         RowBox[{"WeierstrassP", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"x", " ", "\[Omega]1"}], "+", 
            RowBox[{"y", " ", "\[Omega]3"}]}], ",", 
           RowBox[{"{", 
            RowBox[{"g2", ",", "g3"}], "}"}]}], "]"}], "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"y", ",", 
        RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
      RowBox[{"Mesh", "->", "False"}], ",", 
      RowBox[{"PlotRange", "->", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "3"}], ",", "3"}], "}"}]}]}], "]"}]}]}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->14726398],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 205},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->250911103]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->26750],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["InverseWeierstrassP",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/InverseWeierstrassP"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["WeierstrassPPrime",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/WeierstrassPPrime"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["WeierstrassHalfPeriods",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/WeierstrassHalfPeriods"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["WeierstrassInvariants",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/WeierstrassInvariants"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->22919]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->13828],

Cell[TextData[ButtonBox["Elliptic Integrals and Elliptic Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/EllipticIntegralsAndEllipticFunctions"]], "Tutorials",
 CellID->951]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection",
 CellID->6261],

Cell[TextData[StyleBox[ButtonBox["MathWorld",
 BaseStyle->"MathWorldLink",
 ButtonData->{
   URL["http://mathworld.wolfram.com/WeierstrassEllipticFunction.html"], 
   None}], "IT"]], "RelatedLinks"],

Cell[TextData[ButtonBox["The Wolfram Functions Site",
 BaseStyle->"FunctionsSiteLink",
 ButtonData->{
   URL["http://functions.wolfram.com/EllipticFunctions/WeierstrassP/"], 
   None}]], "RelatedLinks"],

Cell[TextData[{
 ButtonBox["NKS|Online",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/index/search.cgi?SearchIndex=\
WeierstrassP"], None}],
 " (",
 StyleBox[ButtonBox["A New Kind of Science",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/"], None}],
  FontSlant->"Italic"],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->371399812],

Cell[TextData[ButtonBox["Elliptic Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/EllipticFunctions"]], "MoreAbout",
 CellID->469869400],

Cell[TextData[ButtonBox["Mathematical Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MathematicalFunctions"]], "MoreAbout",
 CellID->301989443],

Cell[TextData[ButtonBox["Special Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SpecialFunctions"]], "MoreAbout",
 CellID->508593761]
}, Open  ]],

Cell["New in 1  |  Last modified in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"WeierstrassP - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 29, 27.6491802}", "context" -> "System`", 
    "keywords" -> {
     "half\\[Hyphen]period values", "Weierstrass elliptic function"}, "index" -> 
    True, "label" -> "Built-in Mathematica Symbol", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "WeierstrassP[u, {g_2, g_3}] gives the Weierstrass elliptic function \
\\[WeierstrassP](u; g_2, g_3). ", "synonyms" -> {"Weierstrass P"}, "title" -> 
    "WeierstrassP", "type" -> "Symbol", "uri" -> "ref/WeierstrassP"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6221, 203, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->48409074]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 135875, 3093}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2571, 60, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3194, 87, 50, 1, 70, "ObjectName",
 CellID->32533],
Cell[3247, 90, 997, 32, 70, "Usage",
 CellID->6166]
}, Open  ]],
Cell[CellGroupData[{
Cell[4281, 127, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4759, 144, 120, 4, 70, "Notes",
 CellID->20640],
Cell[4882, 150, 814, 29, 70, "Notes",
 CellID->319],
Cell[5699, 181, 256, 8, 70, "Notes",
 CellID->218232416],
Cell[5958, 191, 226, 7, 70, "Notes",
 CellID->31226]
}, Closed]],
Cell[CellGroupData[{
Cell[6221, 203, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->48409074],
Cell[CellGroupData[{
Cell[6605, 217, 147, 5, 70, "ExampleSection",
 CellID->30179412],
Cell[6755, 224, 201, 5, 70, "ExampleText",
 CellID->690379517],
Cell[CellGroupData[{
Cell[6981, 233, 181, 6, 28, "Input",
 CellID->831120123],
Cell[7165, 241, 303, 9, 36, "Output",
 CellID->134648889]
}, Open  ]],
Cell[7483, 253, 125, 3, 70, "ExampleDelimiter",
 CellID->399966931],
Cell[CellGroupData[{
Cell[7633, 260, 321, 11, 28, "Input",
 CellID->103456368],
Cell[7957, 273, 4144, 73, 171, "Output",
 Evaluatable->False,
 CellID->718077734]
}, Open  ]],
Cell[12116, 349, 125, 3, 70, "ExampleDelimiter",
 CellID->188570671],
Cell[12244, 354, 197, 5, 70, "ExampleText",
 CellID->741076968],
Cell[CellGroupData[{
Cell[12466, 363, 305, 10, 70, "Input",
 CellID->111185513],
Cell[12774, 375, 1618, 49, 55, "Output",
 CellID->93812166]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[14441, 430, 219, 7, 70, "ExampleSection",
 CellID->41543798],
Cell[14663, 439, 226, 5, 70, "ExampleText",
 CellID->738927188],
Cell[CellGroupData[{
Cell[14914, 448, 230, 8, 70, "Input",
 CellID->6482658],
Cell[15147, 458, 318, 10, 36, "Output",
 CellID->217223085]
}, Open  ]],
Cell[15480, 471, 124, 3, 70, "ExampleDelimiter",
 CellID->41881473],
Cell[15607, 476, 205, 5, 70, "ExampleText",
 CellID->1498658],
Cell[CellGroupData[{
Cell[15837, 485, 239, 8, 70, "Input",
 CellID->841529584],
Cell[16079, 495, 374, 11, 36, "Output",
 CellID->138041190]
}, Open  ]],
Cell[16468, 509, 125, 3, 70, "ExampleDelimiter",
 CellID->563694966],
Cell[16596, 514, 113, 3, 70, "ExampleText",
 CellID->354628230],
Cell[CellGroupData[{
Cell[16734, 521, 204, 6, 70, "Input",
 CellID->70266597],
Cell[16941, 529, 341, 9, 36, "Output",
 CellID->344019120]
}, Open  ]],
Cell[17297, 541, 124, 3, 70, "ExampleDelimiter",
 CellID->15161106],
Cell[17424, 546, 385, 11, 70, "ExampleText",
 CellID->303104344],
Cell[CellGroupData[{
Cell[17834, 561, 233, 8, 70, "Input",
 CellID->452701008],
Cell[18070, 571, 493, 17, 36, "Output",
 CellID->69613093]
}, Open  ]],
Cell[18578, 591, 125, 3, 70, "ExampleDelimiter",
 CellID->193688075],
Cell[18706, 596, 390, 11, 70, "ExampleText",
 CellID->35018157],
Cell[CellGroupData[{
Cell[19121, 611, 202, 7, 70, "Input",
 CellID->851710064],
Cell[19326, 620, 325, 12, 44, "Output",
 CellID->313406118]
}, Open  ]],
Cell[19666, 635, 124, 3, 70, "ExampleDelimiter",
 CellID->17503446],
Cell[19793, 640, 340, 11, 70, "ExampleText",
 CellID->161143590],
Cell[CellGroupData[{
Cell[20158, 655, 286, 10, 70, "Input",
 CellID->376293716],
Cell[20447, 667, 391, 13, 50, "Output",
 CellID->515734687]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[20887, 686, 227, 7, 70, "ExampleSection",
 CellID->406357750],
Cell[21117, 695, 360, 12, 70, "ExampleText",
 CellID->80906754],
Cell[CellGroupData[{
Cell[21502, 711, 474, 17, 70, "Input",
 CellID->150902356],
Cell[21979, 730, 517, 16, 36, "Output",
 CellID->45726356]
}, Open  ]],
Cell[CellGroupData[{
Cell[22533, 751, 853, 28, 70, "Input",
 CellID->612941757],
Cell[23389, 781, 598, 17, 36, "Output",
 CellID->121037008]
}, Open  ]],
Cell[24002, 801, 125, 3, 70, "ExampleDelimiter",
 CellID->263420200],
Cell[24130, 806, 779, 26, 70, "ExampleText",
 CellID->205578304],
Cell[24912, 834, 633, 20, 70, "Input",
 CellID->81002440],
Cell[CellGroupData[{
Cell[25570, 858, 281, 10, 70, "Input",
 CellID->677600863],
Cell[25854, 870, 258, 10, 38, "Output",
 CellID->960827480]
}, Open  ]],
Cell[26127, 883, 679, 21, 70, "Input",
 CellID->78118349],
Cell[26809, 906, 212, 5, 70, "ExampleText",
 CellID->244755694],
Cell[27024, 913, 1460, 50, 70, "Input",
 CellID->153294004],
Cell[28487, 965, 223, 5, 70, "ExampleText",
 CellID->69100198],
Cell[CellGroupData[{
Cell[28735, 974, 291, 11, 70, "Input",
 CellID->285936745],
Cell[29029, 987, 206, 7, 36, "Output",
 CellID->127198134]
}, Open  ]],
Cell[29250, 997, 125, 3, 70, "ExampleDelimiter",
 CellID->254453165],
Cell[29378, 1002, 243, 7, 70, "ExampleText",
 CellID->2490882],
Cell[29624, 1011, 897, 29, 70, "Input",
 CellID->585283177],
Cell[30524, 1042, 225, 7, 70, "ExampleText",
 CellID->509837502],
Cell[30752, 1051, 615, 22, 70, "Input",
 CellID->354674250],
Cell[31370, 1075, 233, 7, 70, "ExampleText",
 CellID->6079103],
Cell[CellGroupData[{
Cell[31628, 1086, 646, 22, 70, "Input",
 CellID->388583467],
Cell[32277, 1110, 302, 9, 36, "Output",
 CellID->105296763]
}, Open  ]],
Cell[32594, 1122, 201, 5, 70, "ExampleText",
 CellID->101671412],
Cell[CellGroupData[{
Cell[32820, 1131, 631, 20, 70, "Input",
 CellID->21849973],
Cell[33454, 1153, 32981, 546, 70, "Output",
 Evaluatable->False,
 CellID->720782810]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[66484, 1705, 237, 7, 70, "ExampleSection",
 CellID->383153014],
Cell[66724, 1714, 192, 5, 70, "ExampleText",
 CellID->321690607],
Cell[CellGroupData[{
Cell[66941, 1723, 412, 14, 70, "Input",
 CellID->77223633],
Cell[67356, 1739, 928, 31, 73, "Output",
 CellID->130786337]
}, Open  ]],
Cell[68299, 1773, 125, 3, 70, "ExampleDelimiter",
 CellID->826593746],
Cell[68427, 1778, 223, 8, 70, "ExampleText",
 CellID->368350005],
Cell[CellGroupData[{
Cell[68675, 1790, 283, 10, 70, "Input",
 CellID->27625758],
Cell[68961, 1802, 765, 26, 81, "Output",
 CellID->1217282]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[69775, 1834, 229, 7, 70, "ExampleSection",
 CellID->53943928],
Cell[70007, 1843, 251, 7, 70, "ExampleText",
 CellID->3075580],
Cell[CellGroupData[{
Cell[70283, 1854, 206, 7, 70, "Input",
 CellID->86326626],
Cell[70492, 1863, 221, 7, 36, "Output",
 CellID->143859908]
}, Open  ]],
Cell[70728, 1873, 257, 7, 70, "ExampleText",
 CellID->17676679],
Cell[CellGroupData[{
Cell[71010, 1884, 267, 9, 70, "Input",
 CellID->468899453],
Cell[71280, 1895, 330, 9, 36, "Output",
 CellID->70292561]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[71659, 1910, 226, 7, 70, "ExampleSection",
 CellID->2715856],
Cell[71888, 1919, 235, 5, 70, "ExampleText",
 CellID->482004848],
Cell[CellGroupData[{
Cell[72148, 1928, 1629, 50, 70, "Input",
 CellID->14726398],
Cell[73780, 1980, 56987, 938, 70, "Output",
 Evaluatable->False,
 CellID->250911103]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[130828, 2925, 311, 9, 70, "SeeAlsoSection",
 CellID->26750],
Cell[131142, 2936, 1035, 35, 70, "SeeAlso",
 CellID->22919]
}, Open  ]],
Cell[CellGroupData[{
Cell[132214, 2976, 314, 9, 70, "TutorialsSection",
 CellID->13828],
Cell[132531, 2987, 190, 4, 70, "Tutorials",
 CellID->951]
}, Open  ]],
Cell[CellGroupData[{
Cell[132758, 2996, 320, 9, 70, "RelatedLinksSection",
 CellID->6261],
Cell[133081, 3007, 198, 4, 70, "RelatedLinks"],
Cell[133282, 3013, 202, 4, 70, "RelatedLinks"],
Cell[133487, 3019, 390, 13, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[133914, 3037, 319, 9, 70, "MoreAboutSection",
 CellID->371399812],
Cell[134236, 3048, 147, 3, 70, "MoreAbout",
 CellID->469869400],
Cell[134386, 3053, 155, 3, 70, "MoreAbout",
 CellID->301989443],
Cell[134544, 3058, 145, 3, 70, "MoreAbout",
 CellID->508593761]
}, Open  ]],
Cell[134704, 3064, 50, 0, 70, "History"],
Cell[134757, 3066, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

