(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    147464,       3483]
NotebookOptionsPosition[    140155,       3232]
NotebookOutlinePosition[    141518,       3271]
CellTagsIndexPosition[    141431,       3266]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Elliptic Integrals and Elliptic Functions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/EllipticIntegralsAndEllipticFunctions"]}, #, 2]& ,
         Evaluator -> Automatic], {
       1->"\<\"Elliptic Integrals and Elliptic Functions\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"WeierstrassZeta" :> 
          Documentation`HelpLookup["paclet:ref/WeierstrassZeta"], 
          "WeierstrassP" :> 
          Documentation`HelpLookup["paclet:ref/WeierstrassP"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"WeierstrassZeta\"\>", 
       2->"\<\"WeierstrassP\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Elliptic Functions" :> 
          Documentation`HelpLookup["paclet:guide/EllipticFunctions"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Elliptic Functions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["WeierstrassSigma", "ObjectName",
 CellID->8468],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["WeierstrassSigma",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/WeierstrassSigma"], "[", 
       RowBox[{
        StyleBox["u", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["g", "TI"], 
           StyleBox["2", "TR"]], ",", 
          SubscriptBox[
           StyleBox["g", "TI"], 
           StyleBox["3", "TR"]]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the Weierstrass sigma function ",
     Cell[BoxData[
      FormBox[
       RowBox[{"\[Sigma]", "(", 
        RowBox[{
         RowBox[{"u", ";", 
          SubscriptBox["g", "2"]}], ",", 
         SubscriptBox["g", "3"]}], ")"}], TraditionalForm]], "InlineMath"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->19711]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
Mathematical function, suitable for both symbolic and numerical manipulation.\
\
\>", "Notes",
 CellID->20640],

Cell[TextData[{
 "Related to ",
 Cell[BoxData[
  ButtonBox["WeierstrassZeta",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/WeierstrassZeta"]], "InlineFormula"],
 " by the differential equation ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     RowBox[{
      SuperscriptBox["\[Sigma]", "\[Prime]"], "(", 
      RowBox[{
       RowBox[{"z", ";", 
        SubscriptBox["g", "2"]}], ",", 
       SubscriptBox["g", "3"]}], ")"}], "/", 
     RowBox[{"\[Sigma]", "(", 
      RowBox[{"z", ";", 
       SubscriptBox["g", "2"], ",", 
       SubscriptBox["g", "3"]}], ")"}]}], "=", 
    RowBox[{"\[Zeta]", "(", 
     RowBox[{"z", ";", 
      SubscriptBox["g", "2"], ",", 
      SubscriptBox["g", "3"]}], ")"}]}], TraditionalForm]], "InlineMath"],
 ". "
}], "Notes",
 CellID->3520],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["WeierstrassSigma",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/WeierstrassSigma"]], "InlineFormula"],
 " is not periodic and is therefore not strictly an elliptic function. "
}], "Notes",
 CellID->22056],

Cell[TextData[{
 "For certain special arguments, ",
 Cell[BoxData[
  ButtonBox["WeierstrassSigma",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/WeierstrassSigma"]], "InlineFormula"],
 " automatically evaluates to exact values."
}], "Notes",
 CellID->44466994],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["WeierstrassSigma",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/WeierstrassSigma"]], "InlineFormula"],
 " can be evaluated to arbitrary numerical precision."
}], "Notes",
 CellID->31226]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->258787324],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->568100559],

Cell["Evaluate numerically:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->772298828],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"WeierstrassSigma", "[", 
  RowBox[{"2.2", ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->548260515],

Cell[BoxData[
 RowBox[{"1.3748841238802936`", "\[InvisibleSpace]", "-", 
  RowBox[{"1.6842170955224722`*^-17", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{167, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->77760074]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->161608432],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"WeierstrassSigma", "[", 
    RowBox[{"x", ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "6"}], ",", "6"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->304203568],

Cell[GraphicsData["CompressedBitmap", "\<\
eJy9WkuIHFUUrXR193w7kzHGTPxAQFE04y+ZfGYmkyGImUQRcaEugosxCMnC
RGLc6EY3ukk2ujEgZuEH/CwmKhEhghgQA2JAHBAVJILEhUEwuAgI5bnvvurz
+vbrmqpJtOnprldd99z/ee9VzUPzR/Y/9fT8kQP75tfPHZ5/Zv+Bfc+u33Xo
ME6lK5Ik+QR/B8cSHGc4cn97syxLUjlyr+Qx+UjiZ0fc2Q/e/+7TUz/I4R5z
1ax8NF968fT583/qqQP7Fy5f/me0LV078eY3D8g3hNzV6cWLfz/y8FtyWHPj
fU9++NOPf8jhqi6pUNcONz65sHjs6BlKQ/fnp38uK/3C85+d+fIXSr/z9rnj
r5/tlHb+vvbqVzF/FeXBPScuXbpMFEAC2KIgZK+8/EWOIv6r9Llvfzt08GN3
6D7gPEJQLB3aMOPGMBvGEwUGwayqKIx93Xg2Ugplu9HdcOPHH333woW/LMrZ
r3997sip3ij8XVEQJITKojB6cRQkDukjCjNeBYVxURSUHAqvGEUybOPRNFUW
l96KDzGh5lFS/900tk2bamua7ITorKptLr1ESXzV6pnEjFlRVi8j2zR2hHqR
eKRfDu/Bh6itXyX9zEnTxC+uf3l+y3DKDchTfQb5auoLx1Mmn/+vXij1LK96
QeP33/dGb71StWG19qpaRScn9LsxoKFADlcG6OycvKOmjNYBg6bSjvPS2Znj
XuduY8OkieyVoJBRFAUz3uL3vxejiCeTeVRRVfAzGXRjslw5G1y2g9ofNLkL
UehfHIUdfSUo/F1QZO4d6SktcVAp8tPQklKhzq3+6mF3njN1aPETe9/T9UhU
OszYkKmLEIWZsShbTE2qLViGYDFSjCL+qw2cE4ZNRuPS0gdpQZdtMZ6VQ50J
UMowxWaTu5YbQyUUWy1cmU1kOhM0SmgT37aY6myZeIdaWLNVfZnIfD8CFVyv
qEtqmfY2OvQO1m1E8c0sGXR2qyd+0mijVPKFM2Q5XdsDX/Kaku8Jk1XLSXE0
2yWb3JhsqddzhRmicDVrUTaainM7i4AfFKXPW+6+wQ7XGJS1vgLXmfPX+fNj
Qfwk3lZLHhmXY+29jtw3e+gdC8aJ119r6+P5tQ6RDJJbwE5tdOms61fqISSP
SdtEXuaZgkw56H22kqv9eVtbY0uM17gxkgradbBJN8/0sj4eya41bRCpGyOZ
Dcc2w9c69VqFRCkbXbEm9XUVWrXK57GqNaudnjaOR1Fr2CkNr1VT2WcwbIRy
W9Z1+RCr9s4rXHSk0xEKMGGbCdQi9radbTQ6/Vk4F9Gi0UjFyHXXR6JVa1uB
1oMVsjKqm+tGjDV5t6sVWmuc6SyDjLsxQuvR1xq0Vk8U0bHBuYvYgKKQIQA4
b9DrK0tpv92N0dkgF1Cci4GVJrtZ6VtdOWB2gijYSG+0JDdEMDhv3Zxjwigp
+jquTFJsrWEh3klDPoRxcV5+6ne/QwGuxztpykfqiQ+vW1zIoRdOgEIwJ2AB
C3FckdyUdXKLxlKq6KOE3GPqhrObLve7Zjeb/6XGjrGaYk+SAA+uwiJ4URXX
zuCl7YAfErS6+8BYI4l36mKLMz7WLheN9hhvBDWpuYgv3//omFHWxlwyyu73
rozpbo1z/8rY71Khx46eQQFCl/TYsLnKdr5lJjtWLZwP+6O2jhrbxnIpzEQn
FxZ951NqV9bZq60oivIDChy6xZc7M2WCuQJprhQcxwq7+PXMXRVsIMqaHMVz
1N1RFPQkPO2NIrwqPHFvVJqMEUpz7+TmqmD9WgWFM6uuiFAfAJZoboyi8F5L
EQp3FBZlzuRwOECh1KjxaJPP7O4CaeZAeRYzAbhaWHiigg0WhYwZR+EqOY4y
ktvi9y6boyisBKJIPagNnK83d8ShWIp7jNuy4h1pbxvCu/ja6eyHDQGKW5ka
VLs6LdJi9vVB/Janhb0R16L7VCQOtSyrqfESWhh3VnuITg5smcjdkZXdic4V
4BsmCq4S/Oo70SJd3FHq/EDuGM/iO9GiyNj7L7yjsi1qE9fXRSis7zgKayhE
4X1LvaNEPpsshaL8Ru4YNLme7IhHXJp3VO2dxbgNfKYRorCTBoxnUxEU4YVW
gTSrt4w0Yz9g/JwK/LdS9NPe1S2jkzp0jcE5dbqENGOo0uT1mHTIFYy5YA6Y
Cq0mrbqRfGRKeEc6Nw26qZihY6jdTyEMQ1/R84YivayY/F7O+LL0pe0VW1wP
/ekzVfTf+se9XtNkbXl+duvlc9RQLxnJPj27WnqJqHp1/UhOawT57PXciBwX
R2Nv22fEMxVssk+9yXE7KqAgyAg1URj3OAqZJUQh/ygK73rHUcx85VF4/7Ru
PKyCQvay/1MwWwGF6+vUjGc7MhyXZpRSE5+4DXxKqSh6L4lzYc3UjUWxa/8h
ojTb6z28tG93VpCG37qGxwvKUUQ7vf/6PwfqFqWq/F9OsuJfjLi9Ig==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 110},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->385211865]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->310825831],

Cell["Series expansion:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->246979837],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"WeierstrassSigma", "[", 
    RowBox[{"z", ",", 
     RowBox[{"{", 
      RowBox[{"g2", ",", "g3"}], "}"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", "0", ",", "12"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->328803886],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"z", "-", 
   FractionBox[
    RowBox[{"g2", " ", 
     SuperscriptBox["z", "5"]}], "240"], "-", 
   FractionBox[
    RowBox[{"g3", " ", 
     SuperscriptBox["z", "7"]}], "840"], "-", 
   FractionBox[
    RowBox[{
     SuperscriptBox["g2", "2"], " ", 
     SuperscriptBox["z", "9"]}], "161280"], "-", 
   FractionBox[
    RowBox[{
     RowBox[{"(", 
      RowBox[{"g2", " ", "g3"}], ")"}], " ", 
     SuperscriptBox["z", "11"]}], "2217600"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "z", "]"}], "13"],
    SeriesData[$CellContext`z, 0, {}, 1, 13, 1],
    Editable->False]}],
  SeriesData[$CellContext`z, 0, {
   1, 0, 0, 0, Rational[-1, 240] $CellContext`g2, 0, 
    Rational[-1, 840] $CellContext`g3, 0, 
    Rational[-1, 161280] $CellContext`g2^2, 
    0, (Rational[-1, 2217600] $CellContext`g2) $CellContext`g3}, 1, 13, 1],
  Editable->False]], "Output",
 ImageSize->{298, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->82285678]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->502793374],

Cell["Evaluate for complex arguments and invariants:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->8214725],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"WeierstrassSigma", "[", 
  RowBox[{
   RowBox[{"2.5", "+", "I"}], ",", 
   RowBox[{"{", 
    RowBox[{"I", ",", 
     RowBox[{"1", "-", "I"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->124066460],

Cell[BoxData[
 RowBox[{"3.553977768402987`", "\[InvisibleSpace]", "-", 
  RowBox[{"0.42739074015628736`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{133, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->76241003]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->124482237],

Cell["Evaluate to high precision:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->1002736],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"WeierstrassSigma", "[", 
    RowBox[{"2", ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}]}], "]"}], ",", "50"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->364415436],

Cell[BoxData[
 RowBox[{"1.\
5557895628666938868524897069596142906945587571410509878132959629538`50.\
15051499783199", "+", 
  RowBox[{"0``49.95856414416697", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{440, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->184735228]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->16168967],

Cell["\<\
The precision of the output tracks the precision of the input:\
\>", "ExampleText",
 CellID->241965547],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"WeierstrassSigma", "[", 
  RowBox[{"2.0000000000000000000000000000", ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->136721483],

Cell[BoxData[
 RowBox[{"1.55578956286669388685248970692768728265`26.83280177594408", "+", 
  RowBox[{"0``26.685729549842243", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{279, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->7367880]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->528196800],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["WeierstrassSigma",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/WeierstrassSigma"]], "InlineFormula"],
 " threads element-wise over lists in its first argument:"
}], "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->251047861],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"WeierstrassSigma", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"u1", ",", "u2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"g2", ",", "g3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->89572229],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"WeierstrassSigma", "[", 
    RowBox[{"u1", ",", 
     RowBox[{"{", 
      RowBox[{"g2", ",", "g3"}], "}"}]}], "]"}], ",", 
   RowBox[{"WeierstrassSigma", "[", 
    RowBox[{"u2", ",", 
     RowBox[{"{", 
      RowBox[{"g2", ",", "g3"}], "}"}]}], "]"}]}], "}"}]], "Output",
 ImageSize->{438, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->162638095]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->454032652],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["WeierstrassSigma",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/WeierstrassSigma"]], "InlineFormula"],
 " automatically evaluates to simpler functions for certain parameters:"
}], "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->702271329],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"WeierstrassSigma", "[", 
  RowBox[{"1", ",", 
   RowBox[{"{", 
    RowBox[{"12", ",", 
     RowBox[{"-", "8"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->361100803],

Cell[BoxData[
 FractionBox[
  RowBox[{"Sinh", "[", 
   SqrtBox["3"], "]"}], 
  SqrtBox[
   RowBox[{"3", " ", "\[ExponentialE]"}]]]], "Output",
 ImageSize->{74, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->67436584]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->659802738],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " formatting:"
}], "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->257722874],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"WeierstrassSigma", "[", 
   RowBox[{"z", ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox["g", "2"], ",", 
      SubscriptBox["g", "3"]}], "}"}]}], "]"}], "//", 
  "TraditionalForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->33942163],

Cell[GraphicsData["CompressedBitmap", "\<\
eJyVVDEOwjAMdEkIBQSMMHZDiB/wAJh4RFUhlQGBoP8vcXBKuRghKjW2U/vO
vhCOZVOfLmVzrsricC9v9bl6FPvr3W+ZjIh2/l2syPut98K7bNvWemcuduYt
0ZRXw9/DQxbiAS+ui0MNCQKZLqThlzwT0xCTJrDrAgwghNyB2JhNEAcXObxr
VURp2koYniGq0GO2YjGH95x8c8qEfAwZ2xdR0oeNRN0WzoSo2MFI0SB2Cuyo
vq5KLyuXs9M4TeweuP/lRIwwj+srousySpTTfrXYzRvxtwIc5+r5sL6Tz3op
iWp98nKNo5TfKHPxFP0bmidoY6jYJhl4qzYQv7Lw1q8V/fyfSLJS9gTPBTP/
\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{58, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TraditionalForm=",
 CellID->406744084]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->553150447],

Cell["\<\
The system of coupled nonlinear differential equations for a heavy symmetric \
top:\
\>", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->788945576],

Cell[BoxData[
 RowBox[{
  RowBox[{"topODEs", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"\[Omega]1", "'"}], "[", "t", "]"}], "\[Equal]", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "m"}], " ", 
        RowBox[{"\[Omega]2", "[", "t", "]"}], " ", 
        RowBox[{"\[Omega]3", "[", "t", "]"}]}], "-", 
       RowBox[{"x2", "[", "t", "]"}]}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"\[Omega]2", "'"}], "[", "t", "]"}], "\[Equal]", 
      RowBox[{
       RowBox[{"m", " ", 
        RowBox[{"\[Omega]3", "[", "t", "]"}], " ", 
        RowBox[{"\[Omega]1", "[", "t", "]"}]}], "+", 
       RowBox[{"x1", "[", "t", "]"}]}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"\[Omega]3", "'"}], "[", "t", "]"}], "\[Equal]", "0"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"x1", "'"}], "[", "t", "]"}], "\[Equal]", 
      RowBox[{
       RowBox[{
        RowBox[{"x2", "[", "t", "]"}], " ", 
        RowBox[{"\[Omega]3", "[", "t", "]"}]}], "-", 
       RowBox[{
        RowBox[{"x3", "[", "t", "]"}], " ", 
        RowBox[{"\[Omega]2", "[", "t", "]"}]}]}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"x2", "'"}], "[", "t", "]"}], "\[Equal]", 
      RowBox[{
       RowBox[{
        RowBox[{"x3", "[", "t", "]"}], " ", 
        RowBox[{"\[Omega]1", "[", "t", "]"}]}], "-", 
       RowBox[{
        RowBox[{"x1", "[", "t", "]"}], " ", 
        RowBox[{"\[Omega]3", "[", "t", "]"}]}]}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"x3", "'"}], "[", "t", "]"}], "\[Equal]", 
      RowBox[{
       RowBox[{
        RowBox[{"x1", "[", "t", "]"}], " ", 
        RowBox[{"\[Omega]2", "[", "t", "]"}]}], "-", 
       RowBox[{
        RowBox[{"x2", "[", "t", "]"}], " ", 
        RowBox[{"\[Omega]1", "[", "t", "]"}]}]}]}]}], "}"}]}], ";"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->70622781],

Cell["\<\
The solutions can be expressed through Weierstrass sigma and zeta functions:\
\>", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->262577394],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"\[Omega]1", "[", "t_", "]"}], ",", 
     RowBox[{"\[Omega]2", "[", "t_", "]"}], ",", 
     RowBox[{"\[Omega]3", "[", "t_", "]"}], ",", 
     RowBox[{"x1", "[", "t_", "]"}], ",", 
     RowBox[{"x2", "[", "t_", "]"}], ",", 
     RowBox[{"x3", "[", "t_", "]"}]}], "}"}], "=", 
   RowBox[{"With", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\[Sigma]", "=", 
        RowBox[{
         RowBox[{"WeierstrassSigma", "[", 
          RowBox[{"#", ",", 
           RowBox[{"{", 
            RowBox[{"g2", ",", "g3"}], "}"}]}], "]"}], "&"}]}], ",", 
       RowBox[{"\[Zeta]", "=", 
        RowBox[{
         RowBox[{"WeierstrassZeta", "[", 
          RowBox[{"#", ",", 
           RowBox[{"{", 
            RowBox[{"g2", ",", "g3"}], "}"}]}], "]"}], "&"}]}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"\[Alpha]", "=", 
         FractionBox[
          RowBox[{
           RowBox[{
            RowBox[{"-", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1"}], "+", "m"}], ")"}]}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"\[Zeta]", "[", "c1", "]"}], "+", 
              RowBox[{"\[Zeta]", "[", "c2", "]"}]}], ")"}]}], "+", 
           RowBox[{"2", " ", "m", " ", 
            RowBox[{"\[Zeta]", "[", 
             RowBox[{"c1", "+", "c2"}], "]"}]}]}], 
          RowBox[{"1", "+", "m"}]]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         FractionBox[
          RowBox[{
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"-", "1"}], ")"}], 
            RowBox[{"3", "/", "4"}]], " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{
              RowBox[{"-", "t"}], " ", "\[Alpha]"}], "-", "\[Beta]"}]], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              SuperscriptBox["\[ExponentialE]", 
               RowBox[{"2", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"t", " ", "\[Alpha]"}], "+", "\[Beta]"}], ")"}]}]], 
              " ", 
              RowBox[{"\[Sigma]", "[", 
               RowBox[{
                RowBox[{"-", "c1"}], "-", "c2", "+", "t"}], "]"}]}], "+", 
             RowBox[{"\[ImaginaryI]", " ", 
              RowBox[{"\[Sigma]", "[", 
               RowBox[{"c1", "+", "c2", "+", "t"}], "]"}]}]}], ")"}]}], 
          RowBox[{
           RowBox[{"\[Sigma]", "[", 
            RowBox[{"c1", "+", "c2"}], "]"}], " ", 
           RowBox[{"\[Sigma]", "[", "t", "]"}]}]], ",", 
         FractionBox[
          RowBox[{
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"-", "1"}], ")"}], 
            RowBox[{"1", "/", "4"}]], " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{
              RowBox[{"-", "t"}], " ", "\[Alpha]"}], "-", "\[Beta]"}]], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"-", 
               SuperscriptBox["\[ExponentialE]", 
                RowBox[{"2", " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"t", " ", "\[Alpha]"}], "+", "\[Beta]"}], 
                  ")"}]}]]}], " ", 
              RowBox[{"\[Sigma]", "[", 
               RowBox[{
                RowBox[{"-", "c1"}], "-", "c2", "+", "t"}], "]"}]}], "+", 
             RowBox[{"\[ImaginaryI]", " ", 
              RowBox[{"\[Sigma]", "[", 
               RowBox[{"c1", "+", "c2", "+", "t"}], "]"}]}]}], ")"}]}], 
          RowBox[{
           RowBox[{"\[Sigma]", "[", 
            RowBox[{"c1", "+", "c2"}], "]"}], " ", 
           RowBox[{"\[Sigma]", "[", "t", "]"}]}]], ",", 
         RowBox[{
          RowBox[{"-", "\[ImaginaryI]"}], " ", 
          RowBox[{"(", 
           RowBox[{"\[Alpha]", "+", 
            RowBox[{"\[Zeta]", "[", "c1", "]"}], "+", 
            RowBox[{"\[Zeta]", "[", "c2", "]"}], "-", 
            RowBox[{"2", " ", 
             RowBox[{"\[Zeta]", "[", 
              RowBox[{"c1", "+", "c2"}], "]"}]}]}], ")"}]}], ",", 
         RowBox[{"-", 
          FractionBox[
           RowBox[{
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"-", "1"}], ")"}], 
             RowBox[{"1", "/", "4"}]], " ", 
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{
              RowBox[{
               RowBox[{"-", "t"}], " ", "\[Alpha]"}], "-", "\[Beta]"}]], " ", 
            
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["\[ExponentialE]", 
                RowBox[{"2", " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"t", " ", "\[Alpha]"}], "+", "\[Beta]"}], ")"}]}]],
                " ", 
               RowBox[{"\[Sigma]", "[", 
                RowBox[{
                 RowBox[{"-", "c1"}], "+", "t"}], "]"}], " ", 
               RowBox[{"\[Sigma]", "[", 
                RowBox[{
                 RowBox[{"-", "c2"}], "+", "t"}], "]"}]}], "+", 
              RowBox[{"\[ImaginaryI]", " ", 
               RowBox[{"\[Sigma]", "[", 
                RowBox[{"c1", "+", "t"}], "]"}], " ", 
               RowBox[{"\[Sigma]", "[", 
                RowBox[{"c2", "+", "t"}], "]"}]}]}], ")"}]}], 
           RowBox[{
            RowBox[{"\[Sigma]", "[", "c1", "]"}], " ", 
            RowBox[{"\[Sigma]", "[", "c2", "]"}], " ", 
            SuperscriptBox[
             RowBox[{"\[Sigma]", "[", "t", "]"}], "2"]}]]}], ",", 
         FractionBox[
          RowBox[{
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"-", "1"}], ")"}], 
            RowBox[{"3", "/", "4"}]], " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{
              RowBox[{"-", "t"}], " ", "\[Alpha]"}], "-", "\[Beta]"}]], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"-", 
               SuperscriptBox["\[ExponentialE]", 
                RowBox[{"2", " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"t", " ", "\[Alpha]"}], "+", "\[Beta]"}], 
                  ")"}]}]]}], " ", 
              RowBox[{"\[Sigma]", "[", 
               RowBox[{
                RowBox[{"-", "c1"}], "+", "t"}], "]"}], " ", 
              RowBox[{"\[Sigma]", "[", 
               RowBox[{
                RowBox[{"-", "c2"}], "+", "t"}], "]"}]}], "+", 
             RowBox[{"\[ImaginaryI]", " ", 
              RowBox[{"\[Sigma]", "[", 
               RowBox[{"c1", "+", "t"}], "]"}], " ", 
              RowBox[{"\[Sigma]", "[", 
               RowBox[{"c2", "+", "t"}], "]"}]}]}], ")"}]}], 
          RowBox[{
           RowBox[{"\[Sigma]", "[", "c1", "]"}], " ", 
           RowBox[{"\[Sigma]", "[", "c2", "]"}], " ", 
           SuperscriptBox[
            RowBox[{"\[Sigma]", "[", "t", "]"}], "2"]}]], ",", 
         FractionBox[
          RowBox[{
           RowBox[{
            SuperscriptBox[
             RowBox[{"\[Sigma]", "[", "c2", "]"}], "2"], " ", 
            RowBox[{"\[Sigma]", "[", 
             RowBox[{
              RowBox[{"-", "c1"}], "+", "t"}], "]"}], " ", 
            RowBox[{"\[Sigma]", "[", 
             RowBox[{"c1", "+", "t"}], "]"}]}], "+", 
           RowBox[{
            SuperscriptBox[
             RowBox[{"\[Sigma]", "[", "c1", "]"}], "2"], " ", 
            RowBox[{"\[Sigma]", "[", 
             RowBox[{
              RowBox[{"-", "c2"}], "+", "t"}], "]"}], " ", 
            RowBox[{"\[Sigma]", "[", 
             RowBox[{"c2", "+", "t"}], "]"}]}]}], 
          RowBox[{
           SuperscriptBox[
            RowBox[{"\[Sigma]", "[", "c1", "]"}], "2"], " ", 
           SuperscriptBox[
            RowBox[{"\[Sigma]", "[", "c2", "]"}], "2"], " ", 
           SuperscriptBox[
            RowBox[{"\[Sigma]", "[", "t", "]"}], "2"]}]]}], "}"}]}], "]"}]}], 
    "]"}]}], ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->254960058],

Cell["Numerically check the correctness of the solutions:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->411413392],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"topODEs", "/.", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{"#", "->", 
      RowBox[{"RandomReal", "[", 
       RowBox[{"WorkingPrecision", "->", "50"}], "]"}]}], "&"}], "/@", 
    RowBox[{"{", 
     RowBox[{
     "c1", ",", "c2", ",", "\[Beta]", ",", "g2", ",", "g3", ",", "t", ",", 
      "m"}], "}"}]}], ")"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->427515487],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "True", ",", "True", ",", "True", ",", "True", ",", "True", ",", "True"}], 
  "}"}]], "Output",
 ImageSize->{242, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->390466800]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->220655272],

Cell[TextData[{
 "Form any elliptic function with given periods, poles, and zeros as a \
rational function of ",
 Cell[BoxData[
  ButtonBox["WeierstrassSigma",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/WeierstrassSigma"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->999881419],

Cell[BoxData[
 RowBox[{
  RowBox[{"makeEllipticFunction", "[", 
   RowBox[{"z_", ",", " ", 
    RowBox[{"{", 
     RowBox[{"\[Omega]1_", ",", " ", "\[Omega]3_"}], "}"}], ",", " ", 
    "zeros_List", ",", "poles_List"}], "]"}], ":=", 
  RowBox[{
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"g2", ",", "g3", ",", "\[Sigma]"}], "}"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{"g2", ",", "g3"}], "}"}], "=", 
       RowBox[{"WeierstrassInvariants", "[", 
        RowBox[{"N", "[", 
         RowBox[{"{", 
          RowBox[{"\[Omega]1", ",", "\[Omega]3"}], "}"}], "]"}], "]"}]}], ";",
       
      RowBox[{"\[Sigma]", "=", 
       RowBox[{
        RowBox[{"WeierstrassSigma", "[", 
         RowBox[{"#", ",", 
          RowBox[{"{", 
           RowBox[{"g2", ",", "g3"}], "}"}]}], "]"}], "&"}]}], ";", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"Times", " ", "@@", 
          RowBox[{"\[Sigma]", "[", 
           RowBox[{"z", "-", "zeros"}], "]"}]}], ")"}], "/", 
        RowBox[{"(", 
         RowBox[{"Times", " ", "@@", 
          RowBox[{"\[Sigma]", "[", 
           RowBox[{"z", "-", "poles"}], "]"}]}], ")"}]}], 
       RowBox[{
        RowBox[{"\[Sigma]", "[", 
         RowBox[{"z", "-", 
          RowBox[{"Last", "[", "poles", "]"}]}], "]"}], "/", 
        RowBox[{"\[Sigma]", "[", 
         RowBox[{"z", "-", 
          RowBox[{"Last", "[", "poles", "]"}], "-", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"Total", "[", "zeros", "]"}], "-", 
            RowBox[{"Total", "[", "poles", "]"}]}], ")"}]}], "]"}]}]}]}]}], 
    "]"}], "/;", 
   RowBox[{
    RowBox[{
     RowBox[{"Length", "[", "zeros", "]"}], "==", 
     RowBox[{"Length", "[", "poles", "]"}]}], "&&", 
    RowBox[{"Resolve", "[", 
     RowBox[{"Exists", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"\[Mu]", ",", "\[Nu]"}], "}"}], ",", 
       RowBox[{"Element", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"\[Mu]", ",", "\[Nu]"}], "}"}], ",", "Integers"}], "]"}], 
       ",", 
       RowBox[{
        RowBox[{
         RowBox[{"Total", "[", "zeros", "]"}], "-", 
         RowBox[{"Total", "[", "poles", "]"}]}], "==", 
        RowBox[{
         RowBox[{"\[Mu]", " ", "\[Omega]1"}], "+", 
         RowBox[{"\[Nu]", " ", "\[Omega]3"}]}]}]}], "]"}], 
     "]"}]}]}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->202578469],

Cell["\<\
Form an elliptic function with a single and a double zero and a triple pole:\
\>", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->109309615],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", "z_", "]"}], "=", 
  RowBox[{
   RowBox[{"makeEllipticFunction", "[", 
    RowBox[{"z", ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "I"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"1", "/", "3"}], "+", 
        RowBox[{
         RowBox[{"1", "/", "3"}], " ", "I"}]}], ",", 
       RowBox[{
        RowBox[{"1", "/", "3"}], "+", 
        RowBox[{
         RowBox[{"1", "/", "3"}], " ", "I"}]}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "2"}], "/", "3"}], "-", 
        RowBox[{
         RowBox[{"2", "/", "3"}], " ", "I"}]}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "]"}], " ", "//", " ", 
   "Chop"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->180708075],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"WeierstrassSigma", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          FractionBox["1", "3"], "+", 
          FractionBox["\[ImaginaryI]", "3"]}], ")"}], "-", "z"}], ",", 
       RowBox[{"{", 
        RowBox[{"11.817045008077123`", ",", "0"}], "}"}]}], "]"}], "2"], " ", 
    
    RowBox[{"WeierstrassSigma", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         FractionBox["2", "3"], "+", 
         FractionBox[
          RowBox[{"2", " ", "\[ImaginaryI]"}], "3"]}], ")"}], "+", "z"}], ",",
       
      RowBox[{"{", 
       RowBox[{"11.817045008077123`", ",", "0"}], "}"}]}], "]"}]}], ")"}], 
  "/", 
  SuperscriptBox[
   RowBox[{"WeierstrassSigma", "[", 
    RowBox[{"z", ",", 
     RowBox[{"{", 
      RowBox[{"11.817045008077123`", ",", "0"}], "}"}]}], "]"}], 
   "3"]}]], "Output",
 ImageSize->{563, 61},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->320275093]
}, Open  ]],

Cell["Plot the resulting elliptic function:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->108945256],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ContourPlot", "[", 
   RowBox[{
    RowBox[{"Evaluate", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"Re", "[", 
         RowBox[{"f", "[", 
          RowBox[{"x", "+", 
           RowBox[{"I", " ", "y"}]}], "]"}], "]"}], "==", "0"}], ",", 
       RowBox[{
        RowBox[{"Im", "[", 
         RowBox[{"f", "[", 
          RowBox[{"x", "+", 
           RowBox[{"I", " ", "y"}]}], "]"}], "]"}], "==", "0"}]}], "}"}], 
     "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", 
      RowBox[{"-", "1.5"}], ",", "1.5"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"y", ",", 
      RowBox[{"-", "1.5"}], ",", "1.5"}], "}"}]}], "]"}], " "}]], "Input",
 CellLabel->"In[3]:=",
 CellID->628277553],

Cell[BoxData[
 GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJyMfQVUVV/TPqJYoCIWtiIKKoqBGKhjoaJY2K0YWIiKhV0YWISUqIiiAoLS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   "], {{}, {}, 
    {Hue[0.67, 0.6, 0.6], 
     TagBox[
      TooltipBox[
       LineBox[{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18,
         19, 20, 21, 22, 23, 24, 25, 26, 27, 28}],
       RowBox[{
         RowBox[{"Re", "[", 
           FractionBox[
            RowBox[{
              SuperscriptBox[
               RowBox[{"WeierstrassSigma", "[", 
                 RowBox[{
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    FractionBox["1", "3"], "+", 
                    FractionBox["\[ImaginaryI]", "3"]}], ")"}], "-", "x", "-",
                     
                    RowBox[{"\[ImaginaryI]", " ", "y"}]}], ",", 
                   RowBox[{"{", 
                    RowBox[{"11.817045008077123`", ",", "0"}], "}"}]}], "]"}],
                "2"], " ", 
              RowBox[{"WeierstrassSigma", "[", 
                RowBox[{
                  RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    FractionBox["2", "3"], "+", 
                    FractionBox[
                    RowBox[{"2", " ", "\[ImaginaryI]"}], "3"]}], ")"}], "+", 
                    "x", "+", 
                    RowBox[{"\[ImaginaryI]", " ", "y"}]}], ",", 
                  RowBox[{"{", 
                    RowBox[{"11.817045008077123`", ",", "0"}], "}"}]}], 
                "]"}]}], 
            SuperscriptBox[
             RowBox[{"WeierstrassSigma", "[", 
               RowBox[{
                 RowBox[{"x", "+", 
                   RowBox[{"\[ImaginaryI]", " ", "y"}]}], ",", 
                 RowBox[{"{", 
                   RowBox[{"11.817045008077123`", ",", "0"}], "}"}]}], "]"}], 
             "3"]], "]"}], "\[Equal]", "0"}]],
      Annotation[#, Re[(WeierstrassSigma[Complex[
               Rational[1, 3], 
               Rational[1, 3]] - $CellContext`x + 
             Complex[0, -1] $CellContext`y, {11.817045008077123`, 0}]^2 
          WeierstrassSigma[$CellContext`x + Complex[0, 1] $CellContext`y, {
             11.817045008077123`, 0}]^(-3)) WeierstrassSigma[Complex[
             Rational[2, 3], 
             Rational[2, 3]] + $CellContext`x + 
           Complex[0, 1] $CellContext`y, {11.817045008077123`, 0}]] == 0, 
       "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       LineBox[{29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 
        44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 
        61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 
        78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 
        95, 96, 97, 98, 99, 100, 101, 102, 103, 104, 105}],
       RowBox[{
         RowBox[{"Re", "[", 
           FractionBox[
            RowBox[{
              SuperscriptBox[
               RowBox[{"WeierstrassSigma", "[", 
                 RowBox[{
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    FractionBox["1", "3"], "+", 
                    FractionBox["\[ImaginaryI]", "3"]}], ")"}], "-", "x", "-",
                     
                    RowBox[{"\[ImaginaryI]", " ", "y"}]}], ",", 
                   RowBox[{"{", 
                    RowBox[{"11.817045008077123`", ",", "0"}], "}"}]}], "]"}],
                "2"], " ", 
              RowBox[{"WeierstrassSigma", "[", 
                RowBox[{
                  RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    FractionBox["2", "3"], "+", 
                    FractionBox[
                    RowBox[{"2", " ", "\[ImaginaryI]"}], "3"]}], ")"}], "+", 
                    "x", "+", 
                    RowBox[{"\[ImaginaryI]", " ", "y"}]}], ",", 
                  RowBox[{"{", 
                    RowBox[{"11.817045008077123`", ",", "0"}], "}"}]}], 
                "]"}]}], 
            SuperscriptBox[
             RowBox[{"WeierstrassSigma", "[", 
               RowBox[{
                 RowBox[{"x", "+", 
                   RowBox[{"\[ImaginaryI]", " ", "y"}]}], ",", 
                 RowBox[{"{", 
                   RowBox[{"11.817045008077123`", ",", "0"}], "}"}]}], "]"}], 
             "3"]], "]"}], "\[Equal]", "0"}]],
      Annotation[#, Re[(WeierstrassSigma[Complex[
               Rational[1, 3], 
               Rational[1, 3]] - $CellContext`x + 
             Complex[0, -1] $CellContext`y, {11.817045008077123`, 0}]^2 
          WeierstrassSigma[$CellContext`x + Complex[0, 1] $CellContext`y, {
             11.817045008077123`, 0}]^(-3)) WeierstrassSigma[Complex[
             Rational[2, 3], 
             Rational[2, 3]] + $CellContext`x + 
           Complex[0, 1] $CellContext`y, {11.817045008077123`, 0}]] == 0, 
       "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       LineBox[{106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 
        118, 119, 120, 121, 122, 123, 124, 125, 126, 127, 128, 129, 130, 131, 
        132, 133, 134, 135, 136, 137, 138, 139, 140, 141, 142, 143, 144, 145, 
        146, 147, 148}],
       RowBox[{
         RowBox[{"Re", "[", 
           FractionBox[
            RowBox[{
              SuperscriptBox[
               RowBox[{"WeierstrassSigma", "[", 
                 RowBox[{
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    FractionBox["1", "3"], "+", 
                    FractionBox["\[ImaginaryI]", "3"]}], ")"}], "-", "x", "-",
                     
                    RowBox[{"\[ImaginaryI]", " ", "y"}]}], ",", 
                   RowBox[{"{", 
                    RowBox[{"11.817045008077123`", ",", "0"}], "}"}]}], "]"}],
                "2"], " ", 
              RowBox[{"WeierstrassSigma", "[", 
                RowBox[{
                  RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    FractionBox["2", "3"], "+", 
                    FractionBox[
                    RowBox[{"2", " ", "\[ImaginaryI]"}], "3"]}], ")"}], "+", 
                    "x", "+", 
                    RowBox[{"\[ImaginaryI]", " ", "y"}]}], ",", 
                  RowBox[{"{", 
                    RowBox[{"11.817045008077123`", ",", "0"}], "}"}]}], 
                "]"}]}], 
            SuperscriptBox[
             RowBox[{"WeierstrassSigma", "[", 
               RowBox[{
                 RowBox[{"x", "+", 
                   RowBox[{"\[ImaginaryI]", " ", "y"}]}], ",", 
                 RowBox[{"{", 
                   RowBox[{"11.817045008077123`", ",", "0"}], "}"}]}], "]"}], 
             "3"]], "]"}], "\[Equal]", "0"}]],
      Annotation[#, Re[(WeierstrassSigma[Complex[
               Rational[1, 3], 
               Rational[1, 3]] - $CellContext`x + 
             Complex[0, -1] $CellContext`y, {11.817045008077123`, 0}]^2 
          WeierstrassSigma[$CellContext`x + Complex[0, 1] $CellContext`y, {
             11.817045008077123`, 0}]^(-3)) WeierstrassSigma[Complex[
             Rational[2, 3], 
             Rational[2, 3]] + $CellContext`x + 
           Complex[0, 1] $CellContext`y, {11.817045008077123`, 0}]] == 0, 
       "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       LineBox[{149, 150, 151, 152, 153, 154, 155, 156, 157, 158, 159, 160, 
        161, 162, 163, 164, 165, 166, 167, 168, 169, 170, 171, 172, 173, 174, 
        175, 176, 177, 178, 179, 180, 181, 182, 183, 184, 185, 186, 187, 188, 
        189, 190, 191, 192, 193, 194, 195, 196, 197, 198, 199, 200, 201, 202, 
        203, 204, 205, 206, 207, 208, 209, 210, 211, 212, 213, 214, 215, 216, 
        217, 218, 219, 220, 221, 222, 223, 224, 225, 226, 227, 228, 229, 230, 
        231, 232}],
       RowBox[{
         RowBox[{"Re", "[", 
           FractionBox[
            RowBox[{
              SuperscriptBox[
               RowBox[{"WeierstrassSigma", "[", 
                 RowBox[{
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    FractionBox["1", "3"], "+", 
                    FractionBox["\[ImaginaryI]", "3"]}], ")"}], "-", "x", "-",
                     
                    RowBox[{"\[ImaginaryI]", " ", "y"}]}], ",", 
                   RowBox[{"{", 
                    RowBox[{"11.817045008077123`", ",", "0"}], "}"}]}], "]"}],
                "2"], " ", 
              RowBox[{"WeierstrassSigma", "[", 
                RowBox[{
                  RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    FractionBox["2", "3"], "+", 
                    FractionBox[
                    RowBox[{"2", " ", "\[ImaginaryI]"}], "3"]}], ")"}], "+", 
                    "x", "+", 
                    RowBox[{"\[ImaginaryI]", " ", "y"}]}], ",", 
                  RowBox[{"{", 
                    RowBox[{"11.817045008077123`", ",", "0"}], "}"}]}], 
                "]"}]}], 
            SuperscriptBox[
             RowBox[{"WeierstrassSigma", "[", 
               RowBox[{
                 RowBox[{"x", "+", 
                   RowBox[{"\[ImaginaryI]", " ", "y"}]}], ",", 
                 RowBox[{"{", 
                   RowBox[{"11.817045008077123`", ",", "0"}], "}"}]}], "]"}], 
             "3"]], "]"}], "\[Equal]", "0"}]],
      Annotation[#, Re[(WeierstrassSigma[Complex[
               Rational[1, 3], 
               Rational[1, 3]] - $CellContext`x + 
             Complex[0, -1] $CellContext`y, {11.817045008077123`, 0}]^2 
          WeierstrassSigma[$CellContext`x + Complex[0, 1] $CellContext`y, {
             11.817045008077123`, 0}]^(-3)) WeierstrassSigma[Complex[
             Rational[2, 3], 
             Rational[2, 3]] + $CellContext`x + 
           Complex[0, 1] $CellContext`y, {11.817045008077123`, 0}]] == 0, 
       "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       LineBox[{233, 234, 235, 236, 237, 238, 239, 240, 241, 242, 243, 244, 
        245, 246, 247, 248, 249, 250, 251, 252, 253, 254, 255, 256, 257, 258, 
        259, 260, 261, 262, 263, 264, 265, 266, 267, 268, 269, 270, 271, 272, 
        273, 274, 275, 276}],
       RowBox[{
         RowBox[{"Re", "[", 
           FractionBox[
            RowBox[{
              SuperscriptBox[
               RowBox[{"WeierstrassSigma", "[", 
                 RowBox[{
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    FractionBox["1", "3"], "+", 
                    FractionBox["\[ImaginaryI]", "3"]}], ")"}], "-", "x", "-",
                     
                    RowBox[{"\[ImaginaryI]", " ", "y"}]}], ",", 
                   RowBox[{"{", 
                    RowBox[{"11.817045008077123`", ",", "0"}], "}"}]}], "]"}],
                "2"], " ", 
              RowBox[{"WeierstrassSigma", "[", 
                RowBox[{
                  RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    FractionBox["2", "3"], "+", 
                    FractionBox[
                    RowBox[{"2", " ", "\[ImaginaryI]"}], "3"]}], ")"}], "+", 
                    "x", "+", 
                    RowBox[{"\[ImaginaryI]", " ", "y"}]}], ",", 
                  RowBox[{"{", 
                    RowBox[{"11.817045008077123`", ",", "0"}], "}"}]}], 
                "]"}]}], 
            SuperscriptBox[
             RowBox[{"WeierstrassSigma", "[", 
               RowBox[{
                 RowBox[{"x", "+", 
                   RowBox[{"\[ImaginaryI]", " ", "y"}]}], ",", 
                 RowBox[{"{", 
                   RowBox[{"11.817045008077123`", ",", "0"}], "}"}]}], "]"}], 
             "3"]], "]"}], "\[Equal]", "0"}]],
      Annotation[#, Re[(WeierstrassSigma[Complex[
               Rational[1, 3], 
               Rational[1, 3]] - $CellContext`x + 
             Complex[0, -1] $CellContext`y, {11.817045008077123`, 0}]^2 
          WeierstrassSigma[$CellContext`x + Complex[0, 1] $CellContext`y, {
             11.817045008077123`, 0}]^(-3)) WeierstrassSigma[Complex[
             Rational[2, 3], 
             Rational[2, 3]] + $CellContext`x + 
           Complex[0, 1] $CellContext`y, {11.817045008077123`, 0}]] == 0, 
       "Tooltip"]& ], 
     TagBox[
      TooltipBox[LineBox[CompressedData["
1:eJwl1GO0EAYYx+HbbQvLNm62bZs3u27mzbZt2+aWbW3Vlr3clrbMrT2dfXjO
+X9+z/m9QSGhwZ3CBAQEdAwMCIhjxCUe8UlAQhKRmCQkJRnJCSIFKUlFatKQ
lnSkJwMZyURmspCVbGQnBznJRW7ykJd85KcABSlEYYpQlGIUpwQlKUVpylCW
cpSnAhWpRGWqUJVqVCeYGtSkFrWpQ13qUZ8GNKQRjWlCU5oRQnNa0JJWtKYN
bWlHezrQkW/HDqUzXehKN7rTg570ojd96Es/+jOAgQxiMEMYyjCGM4KRjGI0
YxjLOMYzgYlMYjJTmMo0pjODmcxiNnOYyzzms4CFLGIxS1jKMpazgpWsYjVr
WMs61rOBjWxiM1v4kZ/Yyja2s4Od7GI3e9jLPvZzgIMc4jBHOMoxjnOCk5zi
ND/zC2c4yzl+5TfOc4GLXOIyV7jKNa5zg5vc4ja/c4e73OM+D3jIIx7zB3/y
hKc84zkv+Iu/eckrXvOGt7zjPR/4yCc+84V/+JevBOg1DIGE5Tu+JxzhiUBE
fiASkYlCVKIRnRjEJBaxv/VPXOIRnwQkJBGJSUJSkpGcIFKQklSkJg1pSUd6
MpCRTGQmC1nJRnZykJNc5CYPeclHfgpQkEIUpghFKUZxSlCSUpSmDGUpR3kq
UJFKVKYKValGdYKpQU1qUZs61KUe9WlAQxrRmCY0pRkhNKcFLWlFa9rQlna0
p0Pg/z+2E6F0pgtd6UZ3etCTXvSmD33pR38GMJBBDGYIQxnGcEYwklGMZgxj
Gcd4JjCRSUxmClOZxnRmMJNZzGYOc5nHfBawkEUsZglLWcZyVrCSVaxmDWtZ
x3o2sJFNbGYLP/ITW9nGdnawk13sZg972cd+DnCQQxzmCEc5xnFOcJJTnOZn
fuEMZznHr/zGeS5wkUtc5gpXucZ1bnCTW9zmd+5wl3vc5wEPecRj/uBPnvCU
ZzznBX/xNy95xWve8JZ3vOcDH/nEZ77wD//ylYCw+ieQsHzH94QjPBGIyA9E
IjJRiEo0ohODmMQiNnGISzzik4CEJCIxSUhKMpITRApSkorUpCEt6UhPBjKS
icxkISvZyE4OcpKL3OQhL/nITwEKUojCFKEoxShOCUpSitKUoSzlKE8FKlKJ
ylShKtWoTjA1qEktalOHutSjPg1oSCMa04SmNCOE5rSgJa1oTRva0o72dKAj
nQilM13oSje604Oe9KI3fehLP/ozgIEMYjBD+A+TaSWS
        "]],
       RowBox[{
         RowBox[{"Re", "[", 
           FractionBox[
            RowBox[{
              SuperscriptBox[
               RowBox[{"WeierstrassSigma", "[", 
                 RowBox[{
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    FractionBox["1", "3"], "+", 
                    FractionBox["\[ImaginaryI]", "3"]}], ")"}], "-", "x", "-",
                     
                    RowBox[{"\[ImaginaryI]", " ", "y"}]}], ",", 
                   RowBox[{"{", 
                    RowBox[{"11.817045008077123`", ",", "0"}], "}"}]}], "]"}],
                "2"], " ", 
              RowBox[{"WeierstrassSigma", "[", 
                RowBox[{
                  RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    FractionBox["2", "3"], "+", 
                    FractionBox[
                    RowBox[{"2", " ", "\[ImaginaryI]"}], "3"]}], ")"}], "+", 
                    "x", "+", 
                    RowBox[{"\[ImaginaryI]", " ", "y"}]}], ",", 
                  RowBox[{"{", 
                    RowBox[{"11.817045008077123`", ",", "0"}], "}"}]}], 
                "]"}]}], 
            SuperscriptBox[
             RowBox[{"WeierstrassSigma", "[", 
               RowBox[{
                 RowBox[{"x", "+", 
                   RowBox[{"\[ImaginaryI]", " ", "y"}]}], ",", 
                 RowBox[{"{", 
                   RowBox[{"11.817045008077123`", ",", "0"}], "}"}]}], "]"}], 
             "3"]], "]"}], "\[Equal]", "0"}]],
      Annotation[#, Re[(WeierstrassSigma[Complex[
               Rational[1, 3], 
               Rational[1, 3]] - $CellContext`x + 
             Complex[0, -1] $CellContext`y, {11.817045008077123`, 0}]^2 
          WeierstrassSigma[$CellContext`x + Complex[0, 1] $CellContext`y, {
             11.817045008077123`, 0}]^(-3)) WeierstrassSigma[Complex[
             Rational[2, 3], 
             Rational[2, 3]] + $CellContext`x + 
           Complex[0, 1] $CellContext`y, {11.817045008077123`, 0}]] == 0, 
       "Tooltip"]& ]}, 
    {Hue[0.9060679774997897, 0.6, 0.6], 
     TagBox[
      TooltipBox[
       LineBox[{898, 899, 900, 901, 902, 903, 904, 905, 906, 907, 908, 909, 
        910, 911, 912, 913, 914, 915, 916, 917, 918, 919, 920, 921, 922, 923, 
        924, 925, 926, 927, 928, 929, 930, 931, 932, 933, 934, 935, 936, 937, 
        938, 939, 940, 941, 942, 943, 944, 945, 946, 947, 948, 949, 950, 951, 
        952, 953, 954, 955, 956, 957, 958, 959, 960, 961, 962, 963, 964, 965, 
        966, 967, 968, 969, 970, 971, 972, 973, 974, 975, 976, 977, 978, 979, 
        980, 981, 982, 983, 984, 985, 986, 987, 988, 989, 990, 991, 992, 993, 
        994, 995, 996, 997, 998, 999, 1000, 1001, 1002, 1003, 1004, 1005, 
        1006, 1007, 1008, 1009, 1010, 1011, 1012, 1013, 1014, 1015, 1016, 
        1017, 1018, 1019, 1020, 1021, 1022, 1023, 1024, 1025, 1026, 1027, 
        1028, 1029, 1030, 1031}],
       RowBox[{
         RowBox[{"Im", "[", 
           FractionBox[
            RowBox[{
              SuperscriptBox[
               RowBox[{"WeierstrassSigma", "[", 
                 RowBox[{
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    FractionBox["1", "3"], "+", 
                    FractionBox["\[ImaginaryI]", "3"]}], ")"}], "-", "x", "-",
                     
                    RowBox[{"\[ImaginaryI]", " ", "y"}]}], ",", 
                   RowBox[{"{", 
                    RowBox[{"11.817045008077123`", ",", "0"}], "}"}]}], "]"}],
                "2"], " ", 
              RowBox[{"WeierstrassSigma", "[", 
                RowBox[{
                  RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    FractionBox["2", "3"], "+", 
                    FractionBox[
                    RowBox[{"2", " ", "\[ImaginaryI]"}], "3"]}], ")"}], "+", 
                    "x", "+", 
                    RowBox[{"\[ImaginaryI]", " ", "y"}]}], ",", 
                  RowBox[{"{", 
                    RowBox[{"11.817045008077123`", ",", "0"}], "}"}]}], 
                "]"}]}], 
            SuperscriptBox[
             RowBox[{"WeierstrassSigma", "[", 
               RowBox[{
                 RowBox[{"x", "+", 
                   RowBox[{"\[ImaginaryI]", " ", "y"}]}], ",", 
                 RowBox[{"{", 
                   RowBox[{"11.817045008077123`", ",", "0"}], "}"}]}], "]"}], 
             "3"]], "]"}], "\[Equal]", "0"}]],
      Annotation[#, Im[(WeierstrassSigma[Complex[
               Rational[1, 3], 
               Rational[1, 3]] - $CellContext`x + 
             Complex[0, -1] $CellContext`y, {11.817045008077123`, 0}]^2 
          WeierstrassSigma[$CellContext`x + Complex[0, 1] $CellContext`y, {
             11.817045008077123`, 0}]^(-3)) WeierstrassSigma[Complex[
             Rational[2, 3], 
             Rational[2, 3]] + $CellContext`x + 
           Complex[0, 1] $CellContext`y, {11.817045008077123`, 0}]] == 0, 
       "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       LineBox[{1032, 1033, 1034, 1035, 1036, 1037, 1038, 1039, 1040, 1041, 
        1042, 1043, 1044, 1045, 1046, 1047, 1048, 1049, 1050, 1051, 1052, 
        1053, 1054, 1055, 1056, 1057, 1058, 1059, 1060, 1061, 1062, 1063, 
        1064, 1065, 1066, 1067, 1068, 1069, 1070, 1071, 1072, 1073, 1074, 
        1075, 1076, 1077, 1078, 1079, 1080, 1081, 1082, 1083, 1084, 1085, 
        1086, 1087, 1088, 1089, 1090, 1091, 1092, 1093, 1094, 1095, 1096, 
        1097, 1098, 1099, 1100, 1101, 1102, 1103, 1104, 1105, 1106, 1107, 
        1108, 1109, 1110, 1111, 1112, 1113, 1114, 1115, 1116, 1117, 1118, 
        1119, 1120, 1121, 1122, 1123, 1124, 1125, 1126, 1127, 1128, 1129, 
        1130, 1131, 1132, 1133, 1134, 1135, 1136, 1137, 1138, 1139, 1140, 
        1141, 1142, 1143, 1144, 1145, 1146, 1147, 1148, 1149, 1150, 1151, 
        1152, 1153, 1154, 1155, 1156, 1157, 1158, 1159, 1160, 1161, 1162, 
        1163, 1164, 1165, 1166, 1167, 1168, 1169, 1170, 1171, 1172, 1173, 
        1174, 1175, 1176, 1177, 1178, 1179, 1180, 1181, 1182, 1183, 1184, 
        1185, 1186, 1187, 1188, 1189, 1190, 1191, 1192, 1193, 1194}],
       RowBox[{
         RowBox[{"Im", "[", 
           FractionBox[
            RowBox[{
              SuperscriptBox[
               RowBox[{"WeierstrassSigma", "[", 
                 RowBox[{
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    FractionBox["1", "3"], "+", 
                    FractionBox["\[ImaginaryI]", "3"]}], ")"}], "-", "x", "-",
                     
                    RowBox[{"\[ImaginaryI]", " ", "y"}]}], ",", 
                   RowBox[{"{", 
                    RowBox[{"11.817045008077123`", ",", "0"}], "}"}]}], "]"}],
                "2"], " ", 
              RowBox[{"WeierstrassSigma", "[", 
                RowBox[{
                  RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    FractionBox["2", "3"], "+", 
                    FractionBox[
                    RowBox[{"2", " ", "\[ImaginaryI]"}], "3"]}], ")"}], "+", 
                    "x", "+", 
                    RowBox[{"\[ImaginaryI]", " ", "y"}]}], ",", 
                  RowBox[{"{", 
                    RowBox[{"11.817045008077123`", ",", "0"}], "}"}]}], 
                "]"}]}], 
            SuperscriptBox[
             RowBox[{"WeierstrassSigma", "[", 
               RowBox[{
                 RowBox[{"x", "+", 
                   RowBox[{"\[ImaginaryI]", " ", "y"}]}], ",", 
                 RowBox[{"{", 
                   RowBox[{"11.817045008077123`", ",", "0"}], "}"}]}], "]"}], 
             "3"]], "]"}], "\[Equal]", "0"}]],
      Annotation[#, Im[(WeierstrassSigma[Complex[
               Rational[1, 3], 
               Rational[1, 3]] - $CellContext`x + 
             Complex[0, -1] $CellContext`y, {11.817045008077123`, 0}]^2 
          WeierstrassSigma[$CellContext`x + Complex[0, 1] $CellContext`y, {
             11.817045008077123`, 0}]^(-3)) WeierstrassSigma[Complex[
             Rational[2, 3], 
             Rational[2, 3]] + $CellContext`x + 
           Complex[0, 1] $CellContext`y, {11.817045008077123`, 0}]] == 0, 
       "Tooltip"]& ], 
     TagBox[
      TooltipBox[LineBox[CompressedData["
1:eJwN02MDFQYAAMCXvZatZduuxWXbtm237JZt27Zt2zZ3H+4nXKIGbSu0CRII
BKIEDQSWBw8EVrCSVaxmDWtZx3o2sJFNbGYLW9nGdnawk13sZg972cd+DnCQ
QxzmCEc5xnFOcJJTnOYMZznHeS5wkUtc5gpXucZ1bnCTW9zmDne5x30e8JBH
POYJT3nGc17wkle85g1vecd7PvCRT3zmC1/5xnd+8JNf/CYQIhAIQlCCEZwQ
hCQUoQlDWMIRngj8QUT+JBKRiUJUohGdGMQkFrGJQ1ziEZ8EJCQRf5GYJCQl
GclJQUpSkZo0pCUd6clARjKRmSxkJRvZyUFOcpGbPOQlH/kpQEEKUZi/KUJR
ilGcEpTkH0pRmjKUpRzlqUBFKlGZKlSlGtWpQU1qUZs61KUe9WlAQxrRmCY0
pRnNaUFLWtGaNrSlHe3pQEc60ZkudKUb3elBT3rRmz70pR/9GcBABjGYIQxl
GMP5lxGMZBSjGcNYxjGeCUxkEpOZwlT+YxrTmcFMZjGbOcxlHvNZwEIWsZgl
LGUZy1nBSlaxmjWsZR3r2cBGNrGZLWxlG9vZwU52sZs97GUf+znAQQ5xmCMc
5RjHOcFJTnGaM5zlHOe5wEUucZkrXOUa17nBTW5xmzvc5R73ecBDHvGYJzzl
Gc95wUte8Zo3vOUd7/nARz7xmS985Rvf+cFPfvGbQEj/CUowghOCkIQiNGEI
SzjCE4E/iMifRCIyUYhKNKITg5jEIjZxiEs84pOAhCTiLxKThKQkIzkpSEkq
UpOGtKQjPRnISCYyk4WsZCM7OchJLnKTh7zkIz8FKEghCvM3RShKMYpTgpL8
QylKU4aylKM8FahIJSpThapUozo1qEktalOHutSjPg1oSCMa04SmNKM5LWhJ
K1rThra0oz0d6EgnOtOFrnSjOz3oSS9604e+9KM/AxjIIAYzhKEMYzj/MoKR
jGI0YxjLOMYzgYlMYjJTmMp/TGM6M5jJLGYzh7nMYz4LWMgiFrOEpSxjOStY
ySpWs4a1rGM9G9jIJjazha1sYzs72Mn//MsY/A==
        "]],
       RowBox[{
         RowBox[{"Im", "[", 
           FractionBox[
            RowBox[{
              SuperscriptBox[
               RowBox[{"WeierstrassSigma", "[", 
                 RowBox[{
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    FractionBox["1", "3"], "+", 
                    FractionBox["\[ImaginaryI]", "3"]}], ")"}], "-", "x", "-",
                     
                    RowBox[{"\[ImaginaryI]", " ", "y"}]}], ",", 
                   RowBox[{"{", 
                    RowBox[{"11.817045008077123`", ",", "0"}], "}"}]}], "]"}],
                "2"], " ", 
              RowBox[{"WeierstrassSigma", "[", 
                RowBox[{
                  RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    FractionBox["2", "3"], "+", 
                    FractionBox[
                    RowBox[{"2", " ", "\[ImaginaryI]"}], "3"]}], ")"}], "+", 
                    "x", "+", 
                    RowBox[{"\[ImaginaryI]", " ", "y"}]}], ",", 
                  RowBox[{"{", 
                    RowBox[{"11.817045008077123`", ",", "0"}], "}"}]}], 
                "]"}]}], 
            SuperscriptBox[
             RowBox[{"WeierstrassSigma", "[", 
               RowBox[{
                 RowBox[{"x", "+", 
                   RowBox[{"\[ImaginaryI]", " ", "y"}]}], ",", 
                 RowBox[{"{", 
                   RowBox[{"11.817045008077123`", ",", "0"}], "}"}]}], "]"}], 
             "3"]], "]"}], "\[Equal]", "0"}]],
      Annotation[#, Im[(WeierstrassSigma[Complex[
               Rational[1, 3], 
               Rational[1, 3]] - $CellContext`x + 
             Complex[0, -1] $CellContext`y, {11.817045008077123`, 0}]^2 
          WeierstrassSigma[$CellContext`x + Complex[0, 1] $CellContext`y, {
             11.817045008077123`, 0}]^(-3)) WeierstrassSigma[Complex[
             Rational[2, 3], 
             Rational[2, 3]] + $CellContext`x + 
           Complex[0, 1] $CellContext`y, {11.817045008077123`, 0}]] == 0, 
       "Tooltip"]& ], 
     TagBox[
      TooltipBox[LineBox[CompressedData["
1:eJwN0+OD0AcAgOFfurts87JtXTYvuy7rLhtbbTXUjBrCVltuqKFWXbZt23bt
+fC8/8EbHhUTGR0nCIJYWRsSBOuIZT0b2MgmNrOFrWxjOzvYyS52s4e97GM/
BzjIIQ5zhKMc4zgnOMkpTnOGs5zjPBe4yCUuc4WrXOM6N7jJLW5zh7vc4z4P
eMgjHvOEpzzjOS94ySte84a3BKFBEIe4xCM+CQghlDASkojEJCEpyUhOClKS
itSkIS3pSE8GMpKJzGQhK9nITg7CyUkucpOHvOQjPwUoSCEKU4SiFKM4JShJ
KUpThrKUozwVqEglKlOFqkRQjerUoCa1qE0d6lKP+jSgIY1oTBOa0ozmRNKC
lrSiNW1oSzva04GOdKIzXehKN6LoTg960ove9KEv/ejPAAYSTQyDGMwQhjKM
4YxgJKMYzRjGMo7xTGAi7/Auk5jMe7zPFKbyAR/yER8zjel8wqd8xud8wZd8
xdd8w7fMYCbf8T0/8COzmM0c5vITPzOP+fzCryxgIYtYzBKWsozl/Mbv/MGf
rGAlf/E3//Avq1jNf6xhLeuIZT0b2MgmNrOFrWxjOzvYyS52s4e97GM/BzjI
IQ5zhKMc4zgnOMkpTnOGs5zjPBe4yCUuc4WrXOM6N7jJLW5zh7vc4z4PeMgj
HvOEpzzjOS94ySte84a3BGH+Jy7xiE8CQggljIQkIjFJSEoykpOClKQiNWlI
SzrSk4GMZCIzWchKNrKTg3Bykovc5CEv+chPAQpSiMIUoSjFKE4JSlKK0pSh
LOUoTwUqUonKVKEqEVSjOjWoSS1qU4e61KM+DWhIIxrThKY0ozmRtKAlrWhN
G9rSjvZ0oCOd6EwXutKNKLrTg570ojd96Es/+jOAgUQTwyAGM4ShDGM4IxjJ
KEYzhrGMYzz/AzJY5pE=
        "]],
       RowBox[{
         RowBox[{"Im", "[", 
           FractionBox[
            RowBox[{
              SuperscriptBox[
               RowBox[{"WeierstrassSigma", "[", 
                 RowBox[{
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    FractionBox["1", "3"], "+", 
                    FractionBox["\[ImaginaryI]", "3"]}], ")"}], "-", "x", "-",
                     
                    RowBox[{"\[ImaginaryI]", " ", "y"}]}], ",", 
                   RowBox[{"{", 
                    RowBox[{"11.817045008077123`", ",", "0"}], "}"}]}], "]"}],
                "2"], " ", 
              RowBox[{"WeierstrassSigma", "[", 
                RowBox[{
                  RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    FractionBox["2", "3"], "+", 
                    FractionBox[
                    RowBox[{"2", " ", "\[ImaginaryI]"}], "3"]}], ")"}], "+", 
                    "x", "+", 
                    RowBox[{"\[ImaginaryI]", " ", "y"}]}], ",", 
                  RowBox[{"{", 
                    RowBox[{"11.817045008077123`", ",", "0"}], "}"}]}], 
                "]"}]}], 
            SuperscriptBox[
             RowBox[{"WeierstrassSigma", "[", 
               RowBox[{
                 RowBox[{"x", "+", 
                   RowBox[{"\[ImaginaryI]", " ", "y"}]}], ",", 
                 RowBox[{"{", 
                   RowBox[{"11.817045008077123`", ",", "0"}], "}"}]}], "]"}], 
             "3"]], "]"}], "\[Equal]", "0"}]],
      Annotation[#, Im[(WeierstrassSigma[Complex[
               Rational[1, 3], 
               Rational[1, 3]] - $CellContext`x + 
             Complex[0, -1] $CellContext`y, {11.817045008077123`, 0}]^2 
          WeierstrassSigma[$CellContext`x + Complex[0, 1] $CellContext`y, {
             11.817045008077123`, 0}]^(-3)) WeierstrassSigma[Complex[
             Rational[2, 3], 
             Rational[2, 3]] + $CellContext`x + 
           Complex[0, 1] $CellContext`y, {11.817045008077123`, 0}]] == 0, 
       "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       LineBox[{2174, 2175, 2176, 2177, 2178, 2179, 2180, 2181, 2182, 2183, 
        2184, 2185, 2186, 2187, 2188, 2189, 2190, 2191, 2192, 2193, 2194, 
        2195, 2196, 2197, 2198, 2199, 2200, 2201, 2202, 2203, 2204, 2205, 
        2206, 2207, 2208, 2209, 2210, 2211, 2212, 2213, 2214, 2215, 2216, 
        2217, 2218, 2219, 2220, 2221, 2222, 2223, 2224, 2225, 2226, 2227, 
        2228, 2229, 2230, 2231, 2232, 2233, 2234, 2235, 2236, 2237, 2238, 
        2239, 2240, 2241, 2242, 2243, 2244, 2245, 2246, 2247, 2248, 2249, 
        2250, 2251, 2252, 2253, 2254, 2255, 2256, 2257, 2258, 2259, 2260, 
        2261, 2262, 2263, 2264, 2265, 2266, 2267, 2268, 2269, 2270, 2271, 
        2272, 2273, 2274, 2275, 2276, 2277, 2278, 2279, 2280, 2281, 2282, 
        2283, 2284, 2285, 2286, 2287, 2288, 2289, 2290, 2291, 2292, 2293, 
        2294, 2295, 2296, 2297, 2298, 2299, 2300, 2301, 2302, 2303, 2304, 
        2305, 2306, 2307, 2308}],
       RowBox[{
         RowBox[{"Im", "[", 
           FractionBox[
            RowBox[{
              SuperscriptBox[
               RowBox[{"WeierstrassSigma", "[", 
                 RowBox[{
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    FractionBox["1", "3"], "+", 
                    FractionBox["\[ImaginaryI]", "3"]}], ")"}], "-", "x", "-",
                     
                    RowBox[{"\[ImaginaryI]", " ", "y"}]}], ",", 
                   RowBox[{"{", 
                    RowBox[{"11.817045008077123`", ",", "0"}], "}"}]}], "]"}],
                "2"], " ", 
              RowBox[{"WeierstrassSigma", "[", 
                RowBox[{
                  RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    FractionBox["2", "3"], "+", 
                    FractionBox[
                    RowBox[{"2", " ", "\[ImaginaryI]"}], "3"]}], ")"}], "+", 
                    "x", "+", 
                    RowBox[{"\[ImaginaryI]", " ", "y"}]}], ",", 
                  RowBox[{"{", 
                    RowBox[{"11.817045008077123`", ",", "0"}], "}"}]}], 
                "]"}]}], 
            SuperscriptBox[
             RowBox[{"WeierstrassSigma", "[", 
               RowBox[{
                 RowBox[{"x", "+", 
                   RowBox[{"\[ImaginaryI]", " ", "y"}]}], ",", 
                 RowBox[{"{", 
                   RowBox[{"11.817045008077123`", ",", "0"}], "}"}]}], "]"}], 
             "3"]], "]"}], "\[Equal]", "0"}]],
      Annotation[#, Im[(WeierstrassSigma[Complex[
               Rational[1, 3], 
               Rational[1, 3]] - $CellContext`x + 
             Complex[0, -1] $CellContext`y, {11.817045008077123`, 0}]^2 
          WeierstrassSigma[$CellContext`x + Complex[0, 1] $CellContext`y, {
             11.817045008077123`, 0}]^(-3)) WeierstrassSigma[Complex[
             Rational[2, 3], 
             Rational[2, 3]] + $CellContext`x + 
           Complex[0, 1] $CellContext`y, {11.817045008077123`, 0}]] == 0, 
       "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       LineBox[{2309, 2310, 2311, 2312, 2313, 2314, 2315, 2316, 2317, 2318, 
        2319, 2320, 2321, 2322, 2323, 2324, 2325, 2326, 2327, 2328, 2329, 
        2330, 2331, 2332, 2333, 2334, 2335, 2336, 2337, 2338, 2339, 2340, 
        2341, 2342, 2343, 2344, 2345, 2346, 2347, 2348, 2349, 2350, 2351, 
        2352, 2353, 2354, 2355, 2356, 2357, 2358, 2359, 2360, 2361, 2362, 
        2363, 2364, 2365, 2366, 2367, 2368, 2369, 2370, 2371, 2372, 2373, 
        2374, 2375, 2376, 2377, 2378, 2379, 2380, 2381, 2382, 2383, 2384, 
        2385, 2386, 2387, 2388, 2389, 2390, 2391, 2392, 2393, 2394, 2395, 
        2396, 2397, 2398, 2399, 2400, 2401, 2402, 2403, 2404, 2405, 2406, 
        2407, 2408, 2409, 2410, 2411, 2412, 2413, 2414, 2415, 2416, 2417, 
        2418, 2419, 2420, 2421, 2422, 2423, 2424, 2425, 2426, 2427, 2428, 
        2429, 2430, 2431, 2432}],
       RowBox[{
         RowBox[{"Im", "[", 
           FractionBox[
            RowBox[{
              SuperscriptBox[
               RowBox[{"WeierstrassSigma", "[", 
                 RowBox[{
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    FractionBox["1", "3"], "+", 
                    FractionBox["\[ImaginaryI]", "3"]}], ")"}], "-", "x", "-",
                     
                    RowBox[{"\[ImaginaryI]", " ", "y"}]}], ",", 
                   RowBox[{"{", 
                    RowBox[{"11.817045008077123`", ",", "0"}], "}"}]}], "]"}],
                "2"], " ", 
              RowBox[{"WeierstrassSigma", "[", 
                RowBox[{
                  RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    FractionBox["2", "3"], "+", 
                    FractionBox[
                    RowBox[{"2", " ", "\[ImaginaryI]"}], "3"]}], ")"}], "+", 
                    "x", "+", 
                    RowBox[{"\[ImaginaryI]", " ", "y"}]}], ",", 
                  RowBox[{"{", 
                    RowBox[{"11.817045008077123`", ",", "0"}], "}"}]}], 
                "]"}]}], 
            SuperscriptBox[
             RowBox[{"WeierstrassSigma", "[", 
               RowBox[{
                 RowBox[{"x", "+", 
                   RowBox[{"\[ImaginaryI]", " ", "y"}]}], ",", 
                 RowBox[{"{", 
                   RowBox[{"11.817045008077123`", ",", "0"}], "}"}]}], "]"}], 
             "3"]], "]"}], "\[Equal]", "0"}]],
      Annotation[#, Im[(WeierstrassSigma[Complex[
               Rational[1, 3], 
               Rational[1, 3]] - $CellContext`x + 
             Complex[0, -1] $CellContext`y, {11.817045008077123`, 0}]^2 
          WeierstrassSigma[$CellContext`x + Complex[0, 1] $CellContext`y, {
             11.817045008077123`, 0}]^(-3)) WeierstrassSigma[Complex[
             Rational[2, 3], 
             Rational[2, 3]] + $CellContext`x + 
           Complex[0, 1] $CellContext`y, {11.817045008077123`, 0}]] == 0, 
       "Tooltip"]& ]}}],
  AspectRatio->1,
  Frame->True,
  FrameTicks->True,
  Method->{},
  PlotRange->{{-1.5, 1.5}, {-1.5, 1.5}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 172},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->804139761]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->141084128],

Cell["Derivatives:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->263260177],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"D", "[", 
  RowBox[{
   RowBox[{"WeierstrassSigma", "[", 
    RowBox[{"z", ",", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["g", "2"], ",", 
       SubscriptBox["g", "3"]}], "}"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", "3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->763547174],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", 
    RowBox[{"WeierstrassPPrime", "[", 
     RowBox[{"z", ",", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox["g", "2"], ",", 
        SubscriptBox["g", "3"]}], "}"}]}], "]"}]}], " ", 
   RowBox[{"WeierstrassSigma", "[", 
    RowBox[{"z", ",", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["g", "2"], ",", 
       SubscriptBox["g", "3"]}], "}"}]}], "]"}]}], "-", 
  RowBox[{"3", " ", 
   RowBox[{"WeierstrassP", "[", 
    RowBox[{"z", ",", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["g", "2"], ",", 
       SubscriptBox["g", "3"]}], "}"}]}], "]"}], " ", 
   RowBox[{"WeierstrassSigma", "[", 
    RowBox[{"z", ",", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["g", "2"], ",", 
       SubscriptBox["g", "3"]}], "}"}]}], "]"}], " ", 
   RowBox[{"WeierstrassZeta", "[", 
    RowBox[{"z", ",", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["g", "2"], ",", 
       SubscriptBox["g", "3"]}], "}"}]}], "]"}]}], "+", 
  RowBox[{
   RowBox[{"WeierstrassSigma", "[", 
    RowBox[{"z", ",", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["g", "2"], ",", 
       SubscriptBox["g", "3"]}], "}"}]}], "]"}], " ", 
   SuperscriptBox[
    RowBox[{"WeierstrassZeta", "[", 
     RowBox[{"z", ",", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox["g", "2"], ",", 
        SubscriptBox["g", "3"]}], "}"}]}], "]"}], "3"]}]}]], "Output",
 ImageSize->{585, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->747755323]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->906698],

Cell[TextData[{
 "Plot ",
 Cell[BoxData[
  ButtonBox["WeierstrassSigma",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/WeierstrassSigma"]], "InlineFormula"],
 " over the complex plane:"
}], "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->777146007],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Module", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"g2", "=", "2"}], ",", 
     RowBox[{"g3", "=", 
      RowBox[{"1", "+", "I"}]}], ",", "\[Omega]1", ",", "\[Omega]3"}], "}"}], 
   ",", 
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\[Omega]1", ",", "\[Omega]3"}], "}"}], "=", 
     RowBox[{
      RowBox[{"WeierstrassHalfPeriods", "[", 
       RowBox[{"{", 
        RowBox[{"g2", ",", "g3"}], "}"}], "]"}], "//", "N"}]}], ";", 
    RowBox[{"ParametricPlot3D", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Re", "[", 
         RowBox[{
          RowBox[{"x", " ", "\[Omega]1"}], "+", 
          RowBox[{"y", " ", "\[Omega]3"}]}], "]"}], ",", " ", 
        RowBox[{"Im", "[", 
         RowBox[{
          RowBox[{"x", " ", "\[Omega]1"}], "+", 
          RowBox[{"y", " ", "\[Omega]3"}]}], "]"}], ",", 
        RowBox[{"Re", "[", 
         RowBox[{"WeierstrassSigma", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"x", " ", "\[Omega]1"}], "+", 
            RowBox[{"y", " ", "\[Omega]3"}]}], ",", " ", 
           RowBox[{"{", 
            RowBox[{"g2", ",", " ", "g3"}], "}"}]}], "]"}], "]"}]}], "}"}], 
      ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"y", ",", 
        RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", " ", 
      RowBox[{"PlotRange", " ", "->", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "3"}], ",", " ", "3"}], "}"}]}], ",", 
      RowBox[{"BoxRatios", "->", 
       RowBox[{"{", 
        RowBox[{"1", ",", "1", ",", 
         RowBox[{"1", "/", "2"}]}], "}"}]}], ",", 
      RowBox[{"Mesh", "->", "False"}]}], "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->191741089],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 154},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->968303617]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->3004],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["WeierstrassZeta",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/WeierstrassZeta"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["WeierstrassP",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/WeierstrassP"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->4324]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->13861],

Cell[TextData[ButtonBox["Elliptic Integrals and Elliptic Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/EllipticIntegralsAndEllipticFunctions"]], "Tutorials",
 CellID->13693]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection",
 CellID->14522],

Cell[TextData[StyleBox[ButtonBox["MathWorld",
 BaseStyle->"MathWorldLink",
 ButtonData->{
   URL["http://mathworld.wolfram.com/WeierstrassSigmaFunction.html"], 
   None}], "IT"]], "RelatedLinks"],

Cell[TextData[ButtonBox["The Wolfram Functions Site",
 BaseStyle->"FunctionsSiteLink",
 ButtonData->{
   URL["http://functions.wolfram.com/EllipticFunctions/WeierstrassSigma/"], 
   None}]], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->240978403],

Cell[TextData[ButtonBox["Elliptic Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/EllipticFunctions"]], "MoreAbout",
 CellID->299502848]
}, Open  ]],

Cell["New in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"WeierstrassSigma - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 29, 31.6024064}", "context" -> "System`", 
    "keywords" -> {
     "Weierstrass elliptic function", "Weierstrass sigma", 
      "Weierstrass sigma function"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "WeierstrassSigma[u, {g_2, g_3}] gives the Weierstrass sigma function \
\\[Sigma](u; g_2, g_3). ", "synonyms" -> {"weierstrass sigma"}, "title" -> 
    "WeierstrassSigma", "type" -> "Symbol", "uri" -> 
    "ref/WeierstrassSigma"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5834, 200, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->258787324]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 141288, 3259}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1944, 50, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2567, 77, 53, 1, 70, "ObjectName",
 CellID->8468],
Cell[2623, 80, 996, 32, 70, "Usage",
 CellID->19711]
}, Open  ]],
Cell[CellGroupData[{
Cell[3656, 117, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4134, 134, 120, 4, 70, "Notes",
 CellID->20640],
Cell[4257, 140, 782, 27, 70, "Notes",
 CellID->3520],
Cell[5042, 169, 252, 7, 70, "Notes",
 CellID->22056],
Cell[5297, 178, 263, 8, 70, "Notes",
 CellID->44466994],
Cell[5563, 188, 234, 7, 70, "Notes",
 CellID->31226]
}, Closed]],
Cell[CellGroupData[{
Cell[5834, 200, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->258787324],
Cell[CellGroupData[{
Cell[6219, 214, 148, 5, 70, "ExampleSection",
 CellID->568100559],
Cell[6370, 221, 201, 5, 70, "ExampleText",
 CellID->772298828],
Cell[CellGroupData[{
Cell[6596, 230, 186, 6, 28, "Input",
 CellID->548260515],
Cell[6785, 238, 277, 7, 36, "Output",
 CellID->77760074]
}, Open  ]],
Cell[7077, 248, 125, 3, 70, "ExampleDelimiter",
 CellID->161608432],
Cell[CellGroupData[{
Cell[7227, 255, 325, 11, 28, "Input",
 CellID->304203568],
Cell[7555, 268, 2709, 48, 131, "Output",
 Evaluatable->False,
 CellID->385211865]
}, Open  ]],
Cell[10279, 319, 125, 3, 70, "ExampleDelimiter",
 CellID->310825831],
Cell[10407, 324, 197, 5, 70, "ExampleText",
 CellID->246979837],
Cell[CellGroupData[{
Cell[10629, 333, 309, 10, 70, "Input",
 CellID->328803886],
Cell[10941, 345, 1061, 33, 54, "Output",
 CellID->82285678]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[12051, 384, 220, 7, 70, "ExampleSection",
 CellID->502793374],
Cell[12274, 393, 224, 5, 70, "ExampleText",
 CellID->8214725],
Cell[CellGroupData[{
Cell[12523, 402, 236, 8, 70, "Input",
 CellID->124066460],
Cell[12762, 412, 272, 7, 36, "Output",
 CellID->76241003]
}, Open  ]],
Cell[13049, 422, 125, 3, 70, "ExampleDelimiter",
 CellID->124482237],
Cell[13177, 427, 205, 5, 70, "ExampleText",
 CellID->1002736],
Cell[CellGroupData[{
Cell[13407, 436, 243, 8, 70, "Input",
 CellID->364415436],
Cell[13653, 446, 325, 9, 36, "Output",
 CellID->184735228]
}, Open  ]],
Cell[13993, 458, 124, 3, 70, "ExampleDelimiter",
 CellID->16168967],
Cell[14120, 463, 113, 3, 70, "ExampleText",
 CellID->241965547],
Cell[CellGroupData[{
Cell[14258, 470, 213, 6, 70, "Input",
 CellID->136721483],
Cell[14474, 478, 291, 7, 36, "Output",
 CellID->7367880]
}, Open  ]],
Cell[14780, 488, 125, 3, 70, "ExampleDelimiter",
 CellID->528196800],
Cell[14908, 493, 385, 11, 70, "ExampleText",
 CellID->251047861],
Cell[CellGroupData[{
Cell[15318, 508, 236, 8, 70, "Input",
 CellID->89572229],
Cell[15557, 518, 454, 15, 36, "Output",
 CellID->162638095]
}, Open  ]],
Cell[16026, 536, 125, 3, 70, "ExampleDelimiter",
 CellID->454032652],
Cell[16154, 541, 399, 11, 70, "ExampleText",
 CellID->702271329],
Cell[CellGroupData[{
Cell[16578, 556, 206, 7, 70, "Input",
 CellID->361100803],
Cell[16787, 565, 271, 10, 64, "Output",
 CellID->67436584]
}, Open  ]],
Cell[17073, 578, 125, 3, 70, "ExampleDelimiter",
 CellID->659802738],
Cell[17201, 583, 340, 11, 70, "ExampleText",
 CellID->257722874],
Cell[CellGroupData[{
Cell[17566, 598, 279, 10, 70, "Input",
 CellID->33942163],
Cell[17848, 610, 594, 14, 70, "Output",
 Evaluatable->False,
 CellID->406744084]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[18491, 630, 227, 7, 70, "ExampleSection",
 CellID->553150447],
Cell[18721, 639, 271, 8, 70, "ExampleText",
 CellID->788945576],
Cell[18995, 649, 1862, 57, 70, "Input",
 CellID->70622781],
Cell[20860, 708, 264, 7, 70, "ExampleText",
 CellID->262577394],
Cell[21127, 717, 8125, 217, 70, "Input",
 CellID->254960058],
Cell[29255, 936, 231, 5, 70, "ExampleText",
 CellID->411413392],
Cell[CellGroupData[{
Cell[29511, 945, 404, 13, 70, "Input",
 CellID->427515487],
Cell[29918, 960, 268, 9, 36, "Output",
 CellID->390466800]
}, Open  ]],
Cell[30201, 972, 125, 3, 70, "ExampleDelimiter",
 CellID->220655272],
Cell[30329, 977, 428, 13, 70, "ExampleText",
 CellID->999881419],
Cell[30760, 992, 2433, 72, 70, "Input",
 CellID->202578469],
Cell[33196, 1066, 264, 7, 70, "ExampleText",
 CellID->109309615],
Cell[CellGroupData[{
Cell[33485, 1077, 807, 27, 70, "Input",
 CellID->180708075],
Cell[34295, 1106, 1069, 37, 82, "Output",
 CellID->320275093]
}, Open  ]],
Cell[35379, 1146, 217, 5, 70, "ExampleText",
 CellID->108945256],
Cell[CellGroupData[{
Cell[35621, 1155, 753, 25, 70, "Input",
 CellID->628277553],
Cell[36377, 1182, 63325, 1223, 70, "Output",
 CellID->804139761]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[99751, 2411, 237, 7, 70, "ExampleSection",
 CellID->141084128],
Cell[99991, 2420, 192, 5, 70, "ExampleText",
 CellID->263260177],
Cell[CellGroupData[{
Cell[100208, 2429, 345, 12, 70, "Input",
 CellID->763547174],
Cell[100556, 2443, 1563, 53, 71, "Output",
 CellID->747755323]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[102168, 2502, 225, 7, 70, "ExampleSection",
 CellID->906698],
Cell[102396, 2511, 364, 12, 70, "ExampleText",
 CellID->777146007],
Cell[CellGroupData[{
Cell[102785, 2527, 1817, 54, 70, "Input",
 CellID->191741089],
Cell[104605, 2583, 32815, 542, 70, "Output",
 Evaluatable->False,
 CellID->968303617]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[137481, 3132, 310, 9, 70, "SeeAlsoSection",
 CellID->3004],
Cell[137794, 3143, 472, 17, 70, "SeeAlso",
 CellID->4324]
}, Open  ]],
Cell[CellGroupData[{
Cell[138303, 3165, 314, 9, 70, "TutorialsSection",
 CellID->13861],
Cell[138620, 3176, 192, 4, 70, "Tutorials",
 CellID->13693]
}, Open  ]],
Cell[CellGroupData[{
Cell[138849, 3185, 321, 9, 70, "RelatedLinksSection",
 CellID->14522],
Cell[139173, 3196, 195, 4, 70, "RelatedLinks"],
Cell[139371, 3202, 206, 4, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[139614, 3211, 319, 9, 70, "MoreAboutSection",
 CellID->240978403],
Cell[139936, 3222, 147, 3, 70, "MoreAbout",
 CellID->299502848]
}, Open  ]],
Cell[140098, 3228, 27, 0, 70, "History"],
Cell[140128, 3230, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

