(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     81538,       2156]
NotebookOptionsPosition[     73960,       1893]
NotebookOutlinePosition[     75308,       1931]
CellTagsIndexPosition[     75222,       1926]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Elliptic Integrals and Elliptic Functions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/EllipticIntegralsAndEllipticFunctions"]}, #, 2]& ,
         Evaluator -> Automatic], {
       1->"\<\"Elliptic Integrals and Elliptic Functions\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"WeierstrassSigma" :> 
          Documentation`HelpLookup["paclet:ref/WeierstrassSigma"], 
          "WeierstrassP" :> 
          Documentation`HelpLookup["paclet:ref/WeierstrassP"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"WeierstrassSigma\"\>", 
       2->"\<\"WeierstrassP\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Elliptic Functions" :> 
          Documentation`HelpLookup["paclet:guide/EllipticFunctions"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Elliptic Functions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["WeierstrassZeta", "ObjectName",
 CellID->7030],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["WeierstrassZeta",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/WeierstrassZeta"], "[", 
       RowBox[{
        StyleBox["u", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["g", "TI"], 
           StyleBox["2", "TR"]], ",", 
          SubscriptBox[
           StyleBox["g", "TI"], 
           StyleBox["3", "TR"]]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the Weierstrass zeta function ",
     Cell[BoxData[
      FormBox[
       RowBox[{"\[Zeta]", "(", 
        RowBox[{"u", ";", 
         SubscriptBox["g", "2"], ",", 
         SubscriptBox["g", "3"]}], ")"}], TraditionalForm]], "InlineMath"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->1413]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
Mathematical function, suitable for both symbolic and numerical manipulation.\
\
\>", "Notes",
 CellID->20640],

Cell[TextData[{
 "Related to ",
 Cell[BoxData[
  ButtonBox["WeierstrassP",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/WeierstrassP"]], "InlineFormula"],
 " by the differential equation ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SuperscriptBox["\[Zeta]", "\[Prime]"], "(", 
     RowBox[{"z", ";", 
      SubscriptBox["g", "2"], ",", 
      SubscriptBox["g", "3"]}], ")"}], "=", 
    RowBox[{"-", 
     RowBox[{"\[WeierstrassP]", "(", 
      RowBox[{"z", ";", 
       SubscriptBox["g", "2"], ",", 
       SubscriptBox["g", "3"]}], ")"}]}]}], TraditionalForm]], "InlineMath"],
 ". "
}], "Notes",
 CellID->19603],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["WeierstrassZeta",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/WeierstrassZeta"]], "InlineFormula"],
 " is not periodic and is therefore not strictly an elliptic function. "
}], "Notes",
 CellID->591],

Cell[TextData[{
 "For certain special arguments, ",
 Cell[BoxData[
  ButtonBox["WeierstrassZeta",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/WeierstrassZeta"]], "InlineFormula"],
 " automatically evaluates to exact values."
}], "Notes",
 CellID->18643507],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["WeierstrassZeta",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/WeierstrassZeta"]], "InlineFormula"],
 " can be evaluated to arbitrary numerical precision."
}], "Notes",
 CellID->31226]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->565605243],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->5550521],

Cell["Evaluate numerically:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->374491566],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"WeierstrassZeta", "[", 
  RowBox[{"2.", ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->104059583],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "0.2773496115055628`"}], "+", 
  RowBox[{"3.01410231999191`*^-17", " ", "\[ImaginaryI]"}]}]], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{168, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->211723420]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->11832087],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"WeierstrassZeta", "[", 
    RowBox[{"x", ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "4"}], ",", "4"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->194470250],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{223, 138},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->341104323]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->374596788],

Cell["Series expansion:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->339163725],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"WeierstrassZeta", "[", 
    RowBox[{"z", ",", 
     RowBox[{"{", 
      RowBox[{"g2", ",", "g3"}], "}"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", "0", ",", "12"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->123259869],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   FractionBox["1", "z"], "-", 
   FractionBox[
    RowBox[{"g2", " ", 
     SuperscriptBox["z", "3"]}], "60"], "-", 
   FractionBox[
    RowBox[{"g3", " ", 
     SuperscriptBox["z", "5"]}], "140"], "-", 
   FractionBox[
    RowBox[{
     SuperscriptBox["g2", "2"], " ", 
     SuperscriptBox["z", "7"]}], "8400"], "-", 
   FractionBox[
    RowBox[{
     RowBox[{"(", 
      RowBox[{"g2", " ", "g3"}], ")"}], " ", 
     SuperscriptBox["z", "9"]}], "18480"], "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", 
       FractionBox[
        SuperscriptBox["g2", "3"], "1716000"]}], "-", 
      FractionBox[
       SuperscriptBox["g3", "2"], "112112"]}], ")"}], " ", 
    SuperscriptBox["z", "11"]}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "z", "]"}], "13"],
    SeriesData[$CellContext`z, 0, {}, -1, 13, 1],
    Editable->False]}],
  SeriesData[$CellContext`z, 0, {
   1, 0, 0, 0, Rational[-1, 60] $CellContext`g2, 0, 
    Rational[-1, 140] $CellContext`g3, 0, 
    Rational[-1, 8400] $CellContext`g2^2, 0, 
    Rational[-1, 18480] $CellContext`g2 $CellContext`g3, 0, 
    Rational[-1, 1716000] $CellContext`g2^3 + 
    Rational[-1, 112112] $CellContext`g3^2}, -1, 13, 1],
  Editable->False]], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{461, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->74420316]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->183757428],

Cell["Evaluate for complex arguments and invariants:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->186732667],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"WeierstrassZeta", "[", 
  RowBox[{
   RowBox[{"2.5", "+", "I"}], ",", 
   RowBox[{"{", 
    RowBox[{"I", ",", 
     RowBox[{"1", "-", "I"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->244968326],

Cell[BoxData[
 RowBox[{"0.6357138390790668`", "\[InvisibleSpace]", "-", 
  RowBox[{"1.1606581083135525`", " ", "\[ImaginaryI]"}]}]], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{133, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->102340803]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->427503101],

Cell["Evaluate to high precision:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->379452757],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"WeierstrassZeta", "[", 
    RowBox[{"2", ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}]}], "]"}], ",", "50"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->411698906],

Cell[BoxData[
 RowBox[{
  RowBox[{
  "-", "0.2773496115055605959174992232029743904374918477861582504081992503085`\
50.150514997831976"}], "+", 
  RowBox[{"0``50.707487435949965", " ", "\[ImaginaryI]"}]}]], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{455, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->319806716]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->281867209],

Cell["\<\
The precision of the output tracks the precision of the input:\
\>", "ExampleText",
 CellID->264203888],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"WeierstrassZeta", "[", 
  RowBox[{"2.00000000000000000000000000000000000", ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->128100604],

Cell[BoxData[
 RowBox[{
  RowBox[{
  "-", "0.277349611505560595917499223202974390442495813058`32.83222552765069"}\
], "+", 
  RowBox[{"0``33.4828859808319", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{336, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->233771653]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->211029729],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["WeierstrassZeta",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/WeierstrassZeta"]], "InlineFormula"],
 " threads element-wise over lists in its first argument:"
}], "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->602472608],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"WeierstrassZeta", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"u1", ",", "u2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"g2", ",", "g3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->382880497],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"WeierstrassZeta", "[", 
    RowBox[{"u1", ",", 
     RowBox[{"{", 
      RowBox[{"g2", ",", "g3"}], "}"}]}], "]"}], ",", 
   RowBox[{"WeierstrassZeta", "[", 
    RowBox[{"u2", ",", 
     RowBox[{"{", 
      RowBox[{"g2", ",", "g3"}], "}"}]}], "]"}]}], "}"}]], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{424, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->471815843]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->296092],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["WeierstrassZeta",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/WeierstrassZeta"]], "InlineFormula"],
 " automatically evaluates to simpler functions for certain parameters:"
}], "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->125662025],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"WeierstrassZeta", "[", 
  RowBox[{"1", ",", 
   RowBox[{"{", 
    RowBox[{"12", ",", 
     RowBox[{"-", "8"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->324349081],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "1"}], "+", 
  RowBox[{
   SqrtBox["3"], " ", 
   RowBox[{"Coth", "[", 
    SqrtBox["3"], "]"}]}]}]], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{125, 22},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->367676229]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->491960411],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " formatting:"
}], "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->481883148],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"WeierstrassZeta", "[", 
   RowBox[{"z", ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox["g", "2"], ",", 
      SubscriptBox["g", "3"]}], "}"}]}], "]"}], " ", "//", " ", 
  "TraditionalForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->438005935],

Cell[GraphicsData["CompressedBitmap", "\<\
eJyFU8EOwiAM7QZj00Q9mXjczRh/YF+gJz+CGJPtYDRz/z9hFGSlKglrC7Sv
fe0uemhvdz10V12fe/1su+urPj16cyQyAGjM3uzA6KPRpr0dx1EaZY1yZaQR
0gm3CmsI+3pa7jKyc/tRwXauGA9EMF0c5p3wz2hMh1QQD6jYU+uRo/SRgNiT
SpHgG45guKDeMkKWKClf9kzhnWLqtK3JrHRAlGn5sdNqaDyKXTLV+xz/4CZ8
LLFXHIbwRBEsihGazk8RzVzFtfMMlAlHXOR5HjTGZJfpZIZpS3qQIx8RS+ji
GZojCpZRgczRfGwF8V9ZsRVwnke+1p8zdCC281uQ0z3HGTTJF7I3Xc452Q==
\
\>"], "Output",
 Evaluatable->False,
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{56, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TraditionalForm=",
 CellID->163627094]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->286390450],

Cell["\<\
The 2D equations of motion of two point-like vertices having closed \
trajectories:\
\>", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->315697352],

Cell[BoxData[
 RowBox[{
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"\[Omega]1", "=", "1."}], ",", 
      RowBox[{"\[Omega]2", "=", 
       RowBox[{"1", "+", "\[ImaginaryI]"}]}], ",", "g2", ",", "g3", ",", 
      "\[CapitalDelta]", ",", "\[Phi]"}], "}"}], ",", 
    RowBox[{
     RowBox[{
      RowBox[{"{", 
       RowBox[{"g2", ",", "g3"}], "}"}], "=", 
      RowBox[{"WeierstrassInvariants", "[", 
       RowBox[{"{", 
        RowBox[{"\[Omega]1", ",", "\[Omega]2"}], "}"}], "]"}]}], ";", 
     RowBox[{"\[CapitalDelta]", "=", 
      RowBox[{"4", " ", 
       RowBox[{"Abs", "[", 
        RowBox[{"Im", "[", 
         RowBox[{"\[Omega]1", " ", 
          RowBox[{"Conjugate", "[", "\[Omega]2", "]"}]}], "]"}], "]"}]}]}], 
     ";", 
     RowBox[{
      RowBox[{"\[Phi]", "[", "z_", "]"}], "=", 
      RowBox[{
       RowBox[{"WeierstrassZeta", "[", 
        RowBox[{"z", ",", 
         RowBox[{"{", 
          RowBox[{"g2", ",", "g3"}], "}"}]}], "]"}], "-", 
       FractionBox[
        RowBox[{"\[Pi]", " ", 
         RowBox[{"Conjugate", "[", "z", "]"}]}], "\[CapitalDelta]"], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          FractionBox["\[Pi]", "\[CapitalDelta]"], "-", 
          FractionBox[
           RowBox[{"WeierstrassZeta", "[", 
            RowBox[{"\[Omega]1", ",", 
             RowBox[{"{", 
              RowBox[{"g2", ",", "g3"}], "}"}]}], "]"}], "\[Omega]1"]}], 
         ")"}], " ", "z"}]}]}], ";", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{
          SuperscriptBox[
           RowBox[{"z", "[", "1", "]"}], "\[Prime]",
           MultilineFunction->None], "[", "t", "]"}], "\[Equal]", 
         RowBox[{"\[ImaginaryI]", " ", 
          RowBox[{
           RowBox[{"Conjugate", "[", " ", 
            RowBox[{"\[Phi]", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"z", "[", "1", "]"}], "[", "t", "]"}], "-", 
              RowBox[{
               RowBox[{"z", "[", "2", "]"}], "[", "t", "]"}]}], "]"}], "]"}], 
           "/", 
           RowBox[{"(", 
            RowBox[{"2", "\[Pi]"}], ")"}]}]}]}], ",", 
        RowBox[{
         RowBox[{
          SuperscriptBox[
           RowBox[{"z", "[", "2", "]"}], "\[Prime]",
           MultilineFunction->None], "[", "t", "]"}], "\[Equal]", 
         RowBox[{"\[ImaginaryI]", " ", 
          RowBox[{
           RowBox[{"Conjugate", "[", 
            RowBox[{
             RowBox[{"-", "3"}], 
             RowBox[{"\[Phi]", "[", 
              RowBox[{
               RowBox[{"-", 
                RowBox[{
                 RowBox[{"z", "[", "1", "]"}], "[", "t", "]"}]}], "+", 
               RowBox[{
                RowBox[{"z", "[", "2", "]"}], "[", "t", "]"}]}], "]"}]}], 
            "]"}], "/", 
           RowBox[{"(", 
            RowBox[{"2", "\[Pi]"}], ")"}]}]}]}]}], "}"}], "//", "Chop"}]}]}], 
   "]"}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->482459562],

Cell["Solve the equations numerically:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->430337948],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NDSolve", "[", 
  RowBox[{
   RowBox[{"Join", "[", 
    RowBox[{"%", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"z", "[", "1", "]"}], "[", "0", "]"}], "\[Equal]", 
        RowBox[{
         RowBox[{"-", "0.2"}], "+", 
         RowBox[{"0.5", "I"}]}]}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{"z", "[", "2", "]"}], "[", "0", "]"}], "==", 
        RowBox[{"0.3", "-", 
         RowBox[{"0.5", "I"}]}]}]}], "}"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"z", "[", "1", "]"}], ",", 
     RowBox[{"z", "[", "2", "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "50"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->16243434],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{"z", "[", "1", "]"}], "\[Rule]", 
     TagBox[
      RowBox[{"InterpolatingFunction", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"{", 
          RowBox[{"0.`", ",", "50.`"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], 
       "]"}],
      False,
      Editable->False]}], ",", 
    RowBox[{
     RowBox[{"z", "[", "2", "]"}], "\[Rule]", 
     TagBox[
      RowBox[{"InterpolatingFunction", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"{", 
          RowBox[{"0.`", ",", "50.`"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], 
       "]"}],
      False,
      Editable->False]}]}], "}"}], "}"}]], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{337, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->26289873]
}, Open  ]],

Cell["Plot the vortex trajectories:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->747004527],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParametricPlot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Re", "[", 
         RowBox[{
          RowBox[{"z", "[", "1", "]"}], "[", "t", "]"}], "]"}], ",", 
        RowBox[{"Im", "[", 
         RowBox[{
          RowBox[{"z", "[", "1", "]"}], "[", "t", "]"}], "]"}]}], "}"}], ",", 
      
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Re", "[", 
         RowBox[{
          RowBox[{"z", "[", "2", "]"}], "[", "t", "]"}], "]"}], ",", 
        RowBox[{"Im", "[", 
         RowBox[{
          RowBox[{"z", "[", "2", "]"}], "[", "t", "]"}], "]"}]}], "}"}]}], 
     "}"}], "/.", "%"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "50"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->243941817],

Cell[GraphicsData["CompressedBitmap", "\<\
eJy1W3usnUURX+459x7a23d5tKWlD9rScmuhDy20lJt6rbVWLI00RbAppWls
Y7BYS4g2KGqkNkBA8EG1tn8ARakP8AFqajRijCRGEiOJURNTE4N/SEwk/tHE
5Pib17d7pnO++5DewGG/79vfzOzs7Mzs7HLz7kP79t69+9D+PbvnbTq4+559
+/d8fN67DxzEq8ZFKaWz9O+MhHYbLf53VrvdTg1q8V/6Ff2kt/7tfn4+e/Zf
r/7u7y88/1rqPXnit6nx0ot/xPMbb/wn3RKi9tJP67U//AO9D3z0B4Prj+3Y
fgqNRx5+WSi0PvPAGTxv2XwS/9x76MXTz/0ePNL7Qmp3MbU//+mfTzz+a9DZ
c9e3jz35CvifO/ff1M/f3nzz3Cu/+Zt83nnHt8Dh9df/nTaH1O6kn16MYP++
59H3madfpb7T+S1kAOltW5+CSGCQNoUUdnJfcAcRMDzy4C8w0jST3jZ/duYv
GBdEfPmXf90Yoj9k/QQK5nP4DcYHrkCC8VCFJODt/B088PHwJ38CxHxDgBdA
EHtDyOs27gftQDUYLigv4jcQDtwxdAxiMETu4Gf0g4owOWkJ49Ad+sErsL4p
xG03jhgaJIOJDHAPkR4c0/oQd6v1gphQa1pe8MMrjHBdiPsAP4OudEorCm7Q
cVoborbxM4QDCgzSapMaZgkbBdvrQ9wtRh0qgMGlNfyMdQE6ZEVrQtRW64XZ
ojVzQ0GFrOwdIer9+OmhBdOAOPruBpMbo6PV+PYQyauogdHIwko8U0RFRiej
raxrS1tXOMZAY9pgGoW0oJFWhjzeW+iZ9D5U2AtpYkWI4hXZkDVCtHmFNGBM
oEJr6LoQ9R6TCMZPa36TjQ9USOJrQ5T0wnhh+5k38NBKZWHnoTYWuiIN38zP
MGawp+ayEPUuR1tmHJalvAdC1JChMC6y1W02TrCj5jWMGq/z1OPQPWj2uXfv
dJqR1QGJQJE0t5Qp9jtUg60/P6fU63psKOiSxW43ujoj7B1SE79EpjEi+vRi
kD/DXkAXVqBeB5Ir3avHKK+n+0FHd/EY6d5U0CUrv8PoYu2QPS8aI931Rhfr
gOjudHQXVpZgsx7N/o1Oul1GRVfbVaEVsl+lNag+bLc9K2pBiFprvVTiPQ41
P0SJ/4K/UNReh5oXoq534/pwITGh5oaoNYbSce0vtEE2cGWIYl9Mlg4JyXI+
4ixnToUiEPtfWsESXNPdbfVv8APUe3bIY7Wh0ItW6YF2XqXUvKIGhS7oSM17
2uot4GaoOStEreJnuCH1Xwfb6pmQI1FzZoha6WgfMt5widScEaJWuHHc68YZ
o9jnU+RAL2reV+iUZuDyEMU+X/MF0vQn+FkiOs32ZSFqudkEZpci8WFnSZeG
qLeZTWiOcb/ZhM7yJTUoccTU/BQ/Q4GqnekdlrTM5gkBm5oPuOdpIY8Bo4kw
R83PGk8YIzWnhiiOKw100ZXwucLmSXcxaqlpWHX3eZsBpTKlBpUlepCfMSiV
eHKIonjSAws9yu8RitXmJ4W9r7bxqC0ctfFoLhKjFlsvZMI0qw8VWqHmxBqU
JAfUfNjN04QQxXFB/QI1HzEb1+wpRi00jWMcpPFHC5unZn+HBUnv7B8e42eo
WSUdH/K4ytH8YqEV4lmHEhdJzcfb7SofoOa4ELXAWeuXHJWLQ9R805VK9OW2
+guVuA6FSdEM7CvGC0BqtkLUPMfrq8YLwOFQ2aafdOPqq0HJXiqjwEt1GKPm
8rNEMWoecxJnFIHmmk2oDXzNWWtvyONKo4mNMHnFr7fz+hoOlSU7zs8gAbGo
2axBZYmOm8T6XIfKGj5u9qe+NUZx7Cbb3rL5JDW/wc9Yf5iE4VB5hZzg541D
x0GImzUoqB2uIqNkm1OPIr/H4jVgCGqt0tvyvzK/TrQzCHLBOaZH9QYn3LNQ
5HXakZm2HB2fy8d0c34hdG0noKaSyYf0qefsgC5ponlB5Tyfbm87zq3Hqk+f
6ftnoYs0S+U6UTvzLf1vTCV71pFbWxnxRmPZfhUhzmKpt0e/YtXbjdI7qNbr
UHlclSeCkMOh4PUwLsoixOvldZ+9XodnVUkqz6rzGPtIQUnmSM3Ke4ubHC5S
wFVRUyIFsonaSFFFJY2AgpKNynAoHwFln0fNOALG0TZbcR3KR/bMK47sCxyv
KovQcdWhcsb1BD/naBtnLHF2lCWOsyPJxOD4MUXUlEwsr/GMynmbZHkUbR81
LWg22x/ykIwyR7wyo6RKWpxRLnbzItkr3Kzu8+pQkk/TqB8qtEISxplylZXr
KjxqEoohd8nKlzhdfaHduc7qUKANXjT6I6Ydjb7xLkP2JlIhyDsaqU5039GU
uydqjmz3NOCsVnZqsjGmZkbl3WAe9ch2g8tMC3p68Wl+zjnI9BBV7W5V/vuL
8XXf3S43XenO+XChu+47adm152pKtWtX3vGu/Tobh0a3+0zi2grBCmdJVTUC
vLtXI1Y6zR9yzzFKqix5XR20+aqtsqxyEn2MnyGujjOu6NB8dcsCl7W714oH
gm+G44hYrJdcgaqsMchqZAZSZa8uG+tADLgeHH36queqmBJXzM6XQPIzspmU
6NfTH6EEvfIc1ffq+Vf5p9Ykrxkbf+pRlT/jimSsfZo1nraqLLp01BI0jU5R
gZ07ChlSq3qDv1wLXjImSTp1MS+Uw2zf8uAeswKdhcXtzgr5QLvM5slXyF9c
nV7nqI2sEl5V3XX0uxwqrrqvL3rlin9GLQxRXc8fFLUoRA0WKIq81WmI+m45
DTnLmvE7C7/PuniUz6PFt86zK9EszV3zAvMeDi8eN596eS87JnqSm4yCyrRR
9uecTrMcyo38TvlCa3GC09po+cfZ5aqol0YkiqUL3HeJULn67m0pXqXVuS5k
z+e6COpKJT7Xrc6Q9fxdzpAR1DUbiM+Qq/NqzcWr82o9iY7Pq6uz8SNywlue
jdOZcnw2vtnmpOMcXrK37ufwcuYvfiOf+UtdsPuZ/5aCNtIjPUuW2xCd9wsI
VN1dAE3S3SA/I5OCFmh8q0IerGG6LQL1Scd1RgdzQBeO4psS1c0M3QHI+aRE
MpI1vplR3gKhPLu6BaJ7y/gWSHnnhCRabTJj5kTm+M6JnOHDKPT2SHnDhexi
bYi61eYGMpLlXmt2onMX36aR2zvgAq0Vt3eakudDBkh5Y4jcYRaFnTHxq+4L
gaUYVXxf6DbjCC3IYb3cUIKVgZJwHOywkNv5O0YGstAboNVtKJG6620ouXkF
nYEyLArI6uYV1rdM+VCIrG58wSTl2hbFI7nxJSeXct0ovvG1i376gAZrTAc0
iQa4y50zrBzoCFRBhWwuvnPGd+D6oEZY+JbNJ0EDIDyyd22Bttx/gxiiNnf/
bVxFCXyhO0wRxEWjylj68CB3rQbXH5OLZi0y0z65zoaXaIAnBl7c0qP8WUa1
betT6JB6MCWpV672yVUuWrV3ms2CKRPlW4QQWauBvA5Vn2Q9KWGY6N5ncw2N
gwE+/ZR78o6vKTENn5JUSPmNXCxE48fck3eUvWCbi6H4k5gE/hCcvORL/J73
rOpryDP5+C73OsSnoFfiEp7sqgtv31Q7nWjrVuPeD7m3RG+RnGbb51tc36Da
nuZmXGKQ6kAjZ0K+Oi05RM7Av8+oKQUvQvlIPsVQmk2+wKjJ7q2Px5Us+p0L
Yyp3lmCcQ01zqO8xaqJDjXeo6Q71XUaVGQ299fdtLnHfv8OoavZUGxMc6lKT
RTXPJUiVKFeWJjoU21dx9ny6QOXqjkddbrOsdeDnGDXO7E8rFpPUkrjmUFTp
+LBK5yVXMH0eOdNk0JrENxnVMt1oLW9KiMpnziUq32XwqFkmi47nWUaJleaq
wlSH4ipDQy6/UfMUo3pN41pj9fnuFTYCfCeNl6h8ButRs42XauOZApVr4jEq
n2kKqmmWpCcgto+OKjJ+fc+20ekpQ0kxnwucv2P2a9f7pjk2EnVyTxd0c5V4
rHSz3v4fuvmcL6+Mkl7d+K3mEZ985XOlkh5mCEGj2nPUnsv5/UA8T4LKt1ka
7c56REwln9SUVPLKHZmt9rmRxqspn56cKlCZV4zKK1tQLSdBvN7z/D9boPI5
QZ1vIQ8rvkX8WK6nez82w2ZC79iJ9xNfmevpnb4yV8qlt/jjfBcm9sfZe4g/
7ne26iPGZU63pwuU7MC6x5l8e0zizASHimNarg9JTJNx5Agfx8+Mkvg5yeZB
s4k4VmeUxOrJhlIJ47wgoyQvmFKMi2YvzkFyBUtykKmG0iwpznckfhJK8p1p
htJMLM6tEFx1Lym5FetI945y97+htjTBLA9WTvnej7i/zF++zR9nidiE4Dvt
zyRLlDy02o/xu5RrI7rvljxUslv5vxEwlCq7RQ88Qhh8kuyWV1Qv1TtSktVK
42IvRLsVUZBWRCRz5pVLnlDMFmk9Lf7URKeNQ8fBEO/PdPZs2x8l4j/P34ox
v1X/91G66H8CFj40\
\>"], "Output",
 Evaluatable->False,
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{225, 225},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->515639517]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->173445544],

Cell[TextData[{
 "Derivatives of ",
 Cell[BoxData[
  ButtonBox["WeierstrassZeta",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/WeierstrassZeta"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->391325275],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"D", "[", 
    RowBox[{
     RowBox[{"WeierstrassZeta", "[", 
      RowBox[{"z", ",", 
       RowBox[{"{", 
        RowBox[{"g2", ",", "g3"}], "}"}]}], "]"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"z", ",", "k"}], "}"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"k", ",", "3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->272974558],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", 
    RowBox[{"WeierstrassP", "[", 
     RowBox[{"z", ",", 
      RowBox[{"{", 
       RowBox[{"g2", ",", "g3"}], "}"}]}], "]"}]}], ",", 
   RowBox[{"-", 
    RowBox[{"WeierstrassPPrime", "[", 
     RowBox[{"z", ",", 
      RowBox[{"{", 
       RowBox[{"g2", ",", "g3"}], "}"}]}], "]"}]}], ",", 
   RowBox[{
    FractionBox["g2", "2"], "-", 
    RowBox[{"6", " ", 
     SuperscriptBox[
      RowBox[{"WeierstrassP", "[", 
       RowBox[{"z", ",", 
        RowBox[{"{", 
         RowBox[{"g2", ",", "g3"}], "}"}]}], "]"}], "2"]}]}]}], 
  "}"}]], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{457, 52},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->605533184]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->639748817],

Cell["Antiderivative:", "ExampleText",
 CellID->617156075],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"WeierstrassZeta", "[", 
    RowBox[{"z", ",", 
     RowBox[{"{", 
      RowBox[{"g2", ",", "g3"}], "}"}]}], "]"}], ",", "z"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->112808440],

Cell[BoxData[
 RowBox[{"Log", "[", 
  RowBox[{"WeierstrassSigma", "[", 
   RowBox[{"z", ",", 
    RowBox[{"{", 
     RowBox[{"g2", ",", "g3"}], "}"}]}], "]"}], "]"}]], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{237, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->3066834]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->825729371],

Cell["\<\
Machine-precision input is insufficient to give a correct result:\
\>", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->301475452],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"WeierstrassZeta", "[", 
  RowBox[{
   RowBox[{"10.", "^", "40"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->42924944],

Cell[BoxData[
 RowBox[{"6.025084216776723`*^39", "-", 
  RowBox[{"3.492011352434946`*^22", " ", "\[ImaginaryI]"}]}]], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{198, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->4334512]
}, Open  ]],

Cell["\<\
Use arbitrary\[Hyphen]precision arithmetic to obtain a correct result:\
\>", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->12313600],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"WeierstrassZeta", "[", 
    RowBox[{
     RowBox[{"10", "^", "40"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "3"}], "}"}]}], "]"}], ",", "20"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->542045111],

Cell[BoxData[
 RowBox[{"6.02508421677672740867179787873`20.15051499783199*^39", "+", 
  RowBox[{"0``-19.629448123892228", " ", "\[ImaginaryI]"}]}]], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{261, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->333942105]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->816245241],

Cell[TextData[{
 "Plot the quasi\[Hyphen]doubly periodic ",
 Cell[BoxData["WeiersrassZeta"], "InlineFormula"],
 " over the complex plane:"
}], "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->33645312],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Module", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"g2", "=", "2"}], ",", 
     RowBox[{"g3", "=", 
      RowBox[{"1", "+", "I"}]}], ",", "\[Omega]1", ",", "\[Omega]3"}], "}"}], 
   ",", 
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\[Omega]1", ",", "\[Omega]3"}], "}"}], "=", 
     RowBox[{
      RowBox[{"WeierstrassHalfPeriods", "[", 
       RowBox[{"{", 
        RowBox[{"g2", ",", "g3"}], "}"}], "]"}], "//", "N"}]}], ";", 
    RowBox[{"ParametricPlot3D", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Re", "[", 
         RowBox[{
          RowBox[{"x", " ", "\[Omega]1"}], "+", 
          RowBox[{"y", " ", "\[Omega]3"}]}], "]"}], ",", " ", 
        RowBox[{"Im", "[", 
         RowBox[{
          RowBox[{"x", " ", "\[Omega]1"}], "+", 
          RowBox[{"y", " ", "\[Omega]3"}]}], "]"}], ",", 
        RowBox[{"Re", "[", 
         RowBox[{"WeierstrassZeta", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"x", " ", "\[Omega]1"}], "+", 
            RowBox[{"y", " ", "\[Omega]3"}]}], ",", 
           RowBox[{"{", 
            RowBox[{"g2", ",", "g3"}], "}"}]}], "]"}], "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"y", ",", 
        RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
      RowBox[{"PlotRange", "->", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "3"}], ",", "3"}], "}"}]}], ",", 
      RowBox[{"BoxRatios", "->", 
       RowBox[{"{", 
        RowBox[{"1", ",", "1", ",", 
         RowBox[{"1", "/", "2"}]}], "}"}]}], ",", 
      RowBox[{"Mesh", "->", "False"}]}], "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->704471262],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 154},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->28720516]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->31227],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["WeierstrassSigma",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/WeierstrassSigma"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["WeierstrassP",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/WeierstrassP"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->16133]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->24629],

Cell[TextData[ButtonBox["Elliptic Integrals and Elliptic Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/EllipticIntegralsAndEllipticFunctions"]], "Tutorials",
 CellID->29344]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection",
 CellID->31416],

Cell[TextData[StyleBox[ButtonBox["MathWorld",
 BaseStyle->"MathWorldLink",
 ButtonData->{
   URL["http://mathworld.wolfram.com/WeierstrassZetaFunction.html"], 
   None}], "IT"]], "RelatedLinks"],

Cell[TextData[ButtonBox["The Wolfram Functions Site",
 BaseStyle->"FunctionsSiteLink",
 ButtonData->{
   URL["http://functions.wolfram.com/EllipticFunctions/WeierstrassZeta/"], 
   None}]], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->136656763],

Cell[TextData[ButtonBox["Elliptic Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/EllipticFunctions"]], "MoreAbout",
 CellID->677563178]
}, Open  ]],

Cell["New in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"WeierstrassZeta - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 29, 34.1180958}", "context" -> "System`", 
    "keywords" -> {
     "Weierstrass elliptic function", "Weierstrass zeta", 
      "Weierstrass zeta function"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "WeierstrassZeta[u, {g_2, g_3}] gives the Weierstrass zeta function \
\\[Zeta](u; g_2, g_3). ", "synonyms" -> {"weierstrass zeta"}, "title" -> 
    "WeierstrassZeta", "type" -> "Symbol", "uri" -> "ref/WeierstrassZeta"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5650, 194, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->565605243]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 75079, 1919}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1947, 50, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2570, 77, 52, 1, 70, "ObjectName",
 CellID->7030],
Cell[2625, 80, 970, 31, 70, "Usage",
 CellID->1413]
}, Open  ]],
Cell[CellGroupData[{
Cell[3632, 116, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4110, 133, 120, 4, 70, "Notes",
 CellID->20640],
Cell[4233, 139, 630, 22, 70, "Notes",
 CellID->19603],
Cell[4866, 163, 248, 7, 70, "Notes",
 CellID->591],
Cell[5117, 172, 261, 8, 70, "Notes",
 CellID->18643507],
Cell[5381, 182, 232, 7, 70, "Notes",
 CellID->31226]
}, Closed]],
Cell[CellGroupData[{
Cell[5650, 194, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->565605243],
Cell[CellGroupData[{
Cell[6035, 208, 146, 5, 70, "ExampleSection",
 CellID->5550521],
Cell[6184, 215, 201, 5, 70, "ExampleText",
 CellID->374491566],
Cell[CellGroupData[{
Cell[6410, 224, 184, 6, 28, "Input",
 CellID->104059583],
Cell[6597, 232, 321, 10, 36, "Output",
 CellID->211723420]
}, Open  ]],
Cell[6933, 245, 124, 3, 70, "ExampleDelimiter",
 CellID->11832087],
Cell[CellGroupData[{
Cell[7082, 252, 324, 11, 28, "Input",
 CellID->194470250],
Cell[7409, 265, 3933, 70, 159, "Output",
 Evaluatable->False,
 CellID->341104323]
}, Open  ]],
Cell[11357, 338, 125, 3, 70, "ExampleDelimiter",
 CellID->374596788],
Cell[11485, 343, 197, 5, 70, "ExampleText",
 CellID->339163725],
Cell[CellGroupData[{
Cell[11707, 352, 308, 10, 70, "Input",
 CellID->123259869],
Cell[12018, 364, 1472, 47, 54, "Output",
 CellID->74420316]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[13539, 417, 220, 7, 70, "ExampleSection",
 CellID->183757428],
Cell[13762, 426, 226, 5, 70, "ExampleText",
 CellID->186732667],
Cell[CellGroupData[{
Cell[14013, 435, 235, 8, 70, "Input",
 CellID->244968326],
Cell[14251, 445, 321, 9, 36, "Output",
 CellID->102340803]
}, Open  ]],
Cell[14587, 457, 125, 3, 70, "ExampleDelimiter",
 CellID->427503101],
Cell[14715, 462, 207, 5, 70, "ExampleText",
 CellID->379452757],
Cell[CellGroupData[{
Cell[14947, 471, 242, 8, 70, "Input",
 CellID->411698906],
Cell[15192, 481, 394, 12, 36, "Output",
 CellID->319806716]
}, Open  ]],
Cell[15601, 496, 125, 3, 70, "ExampleDelimiter",
 CellID->281867209],
Cell[15729, 501, 113, 3, 70, "ExampleText",
 CellID->264203888],
Cell[CellGroupData[{
Cell[15867, 508, 219, 6, 70, "Input",
 CellID->128100604],
Cell[16089, 516, 324, 10, 36, "Output",
 CellID->233771653]
}, Open  ]],
Cell[16428, 529, 125, 3, 70, "ExampleDelimiter",
 CellID->211029729],
Cell[16556, 534, 383, 11, 70, "ExampleText",
 CellID->602472608],
Cell[CellGroupData[{
Cell[16964, 549, 236, 8, 70, "Input",
 CellID->382880497],
Cell[17203, 559, 500, 17, 36, "Output",
 CellID->471815843]
}, Open  ]],
Cell[17718, 579, 122, 3, 70, "ExampleDelimiter",
 CellID->296092],
Cell[17843, 584, 397, 11, 70, "ExampleText",
 CellID->125662025],
Cell[CellGroupData[{
Cell[18265, 599, 205, 7, 70, "Input",
 CellID->324349081],
Cell[18473, 608, 329, 13, 43, "Output",
 CellID->367676229]
}, Open  ]],
Cell[18817, 624, 125, 3, 70, "ExampleDelimiter",
 CellID->491960411],
Cell[18945, 629, 340, 11, 70, "ExampleText",
 CellID->481883148],
Cell[CellGroupData[{
Cell[19310, 644, 289, 10, 70, "Input",
 CellID->438005935],
Cell[19602, 656, 642, 16, 70, "Output",
 Evaluatable->False,
 CellID->163627094]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[20293, 678, 227, 7, 70, "ExampleSection",
 CellID->286390450],
Cell[20523, 687, 271, 8, 70, "ExampleText",
 CellID->315697352],
Cell[20797, 697, 2983, 86, 70, "Input",
 CellID->482459562],
Cell[23783, 785, 212, 5, 70, "ExampleText",
 CellID->430337948],
Cell[CellGroupData[{
Cell[24020, 794, 759, 25, 70, "Input",
 CellID->16243434],
Cell[24782, 821, 883, 32, 54, "Output",
 CellID->26289873]
}, Open  ]],
Cell[25680, 856, 209, 5, 70, "ExampleText",
 CellID->747004527],
Cell[CellGroupData[{
Cell[25914, 865, 816, 27, 70, "Input",
 CellID->243941817],
Cell[26733, 894, 4791, 84, 70, "Output",
 Evaluatable->False,
 CellID->515639517]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[31573, 984, 237, 7, 70, "ExampleSection",
 CellID->173445544],
Cell[31813, 993, 212, 8, 70, "ExampleText",
 CellID->391325275],
Cell[CellGroupData[{
Cell[32050, 1005, 416, 14, 70, "Input",
 CellID->272974558],
Cell[32469, 1021, 788, 28, 73, "Output",
 CellID->605533184]
}, Open  ]],
Cell[33272, 1052, 125, 3, 70, "ExampleDelimiter",
 CellID->639748817],
Cell[33400, 1057, 58, 1, 70, "ExampleText",
 CellID->617156075],
Cell[CellGroupData[{
Cell[33483, 1062, 251, 8, 70, "Input",
 CellID->112808440],
Cell[33737, 1072, 354, 12, 36, "Output",
 CellID->3066834]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[34140, 1090, 230, 7, 70, "ExampleSection",
 CellID->825729371],
Cell[34373, 1099, 253, 7, 70, "ExampleText",
 CellID->301475452],
Cell[CellGroupData[{
Cell[34651, 1110, 209, 7, 70, "Input",
 CellID->42924944],
Cell[34863, 1119, 304, 9, 36, "Output",
 CellID->4334512]
}, Open  ]],
Cell[35182, 1131, 257, 7, 70, "ExampleText",
 CellID->12313600],
Cell[CellGroupData[{
Cell[35464, 1142, 270, 9, 70, "Input",
 CellID->542045111],
Cell[35737, 1153, 337, 9, 36, "Output",
 CellID->333942105]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[36123, 1168, 228, 7, 70, "ExampleSection",
 CellID->816245241],
Cell[36354, 1177, 313, 9, 70, "ExampleText",
 CellID->33645312],
Cell[CellGroupData[{
Cell[36692, 1190, 1779, 53, 70, "Input",
 CellID->704471262],
Cell[38474, 1245, 32749, 541, 70, "Output",
 Evaluatable->False,
 CellID->28720516]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[71284, 1793, 311, 9, 70, "SeeAlsoSection",
 CellID->31227],
Cell[71598, 1804, 475, 17, 70, "SeeAlso",
 CellID->16133]
}, Open  ]],
Cell[CellGroupData[{
Cell[72110, 1826, 314, 9, 70, "TutorialsSection",
 CellID->24629],
Cell[72427, 1837, 192, 4, 70, "Tutorials",
 CellID->29344]
}, Open  ]],
Cell[CellGroupData[{
Cell[72656, 1846, 321, 9, 70, "RelatedLinksSection",
 CellID->31416],
Cell[72980, 1857, 194, 4, 70, "RelatedLinks"],
Cell[73177, 1863, 205, 4, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[73419, 1872, 319, 9, 70, "MoreAboutSection",
 CellID->136656763],
Cell[73741, 1883, 147, 3, 70, "MoreAbout",
 CellID->677563178]
}, Open  ]],
Cell[73903, 1889, 27, 0, 70, "History"],
Cell[73933, 1891, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

