(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     24541,        873]
NotebookOptionsPosition[     19538,        700]
NotebookOutlinePosition[     21002,        740]
CellTagsIndexPosition[     20917,        735]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Conditionals" :> 
          Documentation`HelpLookup["paclet:tutorial/Conditionals"], 
          "Piecewise Functions" :> 
          Documentation`HelpLookup["paclet:tutorial/PiecewiseFunctions"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Conditionals\"\>", 
       2->"\<\"Piecewise Functions\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Switch" :> Documentation`HelpLookup["paclet:ref/Switch"], "If" :> 
          Documentation`HelpLookup["paclet:ref/If"], "Piecewise" :> 
          Documentation`HelpLookup["paclet:ref/Piecewise"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Switch\"\>", 2->"\<\"If\"\>", 
       3->"\<\"Piecewise\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Conditionals" :> 
          Documentation`HelpLookup["paclet:guide/Conditionals"], 
          "Logic & Boolean Algebra" :> 
          Documentation`HelpLookup["paclet:guide/LogicAndBooleanAlgebra"], 
          "Procedural Programming" :> 
          Documentation`HelpLookup["paclet:guide/ProceduralProgramming"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Conditionals\"\>", 
       2->"\<\"Logic & Boolean Algebra\"\>", 
       3->"\<\"Procedural Programming\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Which", "ObjectName",
 CellID->28668],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Which",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Which"], "[", 
       RowBox[{
        SubscriptBox[
         StyleBox["test", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["value", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["test", "TI"], 
         StyleBox["2", "TR"]], ",", 
        SubscriptBox[
         StyleBox["value", "TI"], 
         StyleBox["2", "TR"]], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]evaluates each of the ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["test", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     " in turn, returning the value of the ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["value", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     " corresponding to the first one that yields ",
     Cell[BoxData[
      ButtonBox["True",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/True"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->2040]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Which",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Which"]], "InlineFormula"],
 " has attribute ",
 Cell[BoxData[
  ButtonBox["HoldAll",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HoldAll"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->20301],

Cell[TextData[{
 "If any of the ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["test", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " evaluated by ",
 Cell[BoxData[
  ButtonBox["Which",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Which"]], "InlineFormula"],
 " give neither ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 " nor ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 ", then a ",
 Cell[BoxData[
  ButtonBox["Which",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Which"]], "InlineFormula"],
 " object containing these remaining elements is returned unevaluated. ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->1765718469]
}], "Notes",
 CellID->13426],

Cell[TextData[{
 "You can make ",
 Cell[BoxData[
  ButtonBox["Which",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Which"]], "InlineFormula"],
 " return a \"default value\" by taking the last ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["test", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " to be ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->24618],

Cell[TextData[{
 "If all the ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["test", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " evaluate to ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Which",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Which"]], "InlineFormula"],
 " returns ",
 Cell[BoxData[
  ButtonBox["Null",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Null"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->8124]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->810358051],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->485975251],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"a", "=", "2"}], ";", 
  RowBox[{"Which", "[", 
   RowBox[{
    RowBox[{"a", "\[Equal]", "1"}], ",", "x", ",", 
    RowBox[{"a", "\[Equal]", "2"}], ",", "b"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->87391421],

Cell[BoxData["b"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->134345544]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->18067],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Programming Behavior",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->52944875],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Which",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Which"]], "InlineFormula"],
 " can be maintained in symbolic form:"
}], "ExampleText",
 CellID->616272914],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Which", "[", 
  RowBox[{
   RowBox[{"a", "\[Equal]", "1"}], ",", "x", ",", 
   RowBox[{"a", "\[Equal]", "2"}], ",", "b"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->193714535],

Cell[BoxData[
 RowBox[{"Which", "[", 
  RowBox[{
   RowBox[{"a", "\[Equal]", "1"}], ",", "x", ",", 
   RowBox[{"a", "\[Equal]", "2"}], ",", "b"}], "]"}]], "Output",
 ImageSize->{163, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->283026346]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "/.", 
  RowBox[{"a", "\[Rule]", "2"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->20029986],

Cell[BoxData["b"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->156495539]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Symbolic Transformations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->643513361],

Cell["Define a piecewise function:", "ExampleText",
 CellID->166962445],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "=", 
  RowBox[{"Which", "[", 
   RowBox[{
    RowBox[{"x", "<", 
     RowBox[{
      RowBox[{"-", "Pi"}], "/", "2"}]}], ",", 
    RowBox[{"-", "1"}], ",", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "Pi"}], "/", "2"}], "\[LessEqual]", "x", "\[LessEqual]", 
     RowBox[{"Pi", "/", "2"}]}], ",", 
    RowBox[{"Sin", "[", "x", "]"}], ",", "True", ",", "1"}], "]"}]}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->653765944],

Cell[BoxData[
 RowBox[{"Which", "[", 
  RowBox[{
   RowBox[{"x", "<", 
    RowBox[{"-", 
     FractionBox["\[Pi]", "2"]}]}], ",", 
   RowBox[{"-", "1"}], ",", 
   RowBox[{
    RowBox[{"-", 
     FractionBox["\[Pi]", "2"]}], "\[LessEqual]", "x", "\[LessEqual]", 
    FractionBox["\[Pi]", "2"]}], ",", 
   RowBox[{"Sin", "[", "x", "]"}], ",", "True", ",", "1"}], "]"}]], "Output",
 ImageSize->{309, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->477715421]
}, Open  ]],

Cell[TextData[{
 "Expand it to use ",
 Cell[BoxData[
  ButtonBox["Piecewise",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Piecewise"]], "InlineFormula"],
 ": "
}], "ExampleText",
 CellID->143080411],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PiecewiseExpand", "[", "f", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->55665065],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzVV71OAkEQXtg7ERSIFgaJiRoLpVETY2WvsbDATgvNxRi0MBK1oLtHoOQR
KHkEH4HHoOQR1v2FublZOdFE3YTb29lvv52Z/ebuuIjeHu6forfHu2jr7CVq
PzzevW6dPr9IE88xxlryd1Jj8l7IO/1rCSF7c92R17w0Ltn+WFu5ugadTudd
t9FotKEsXK3WTePh+Gi6jsdxbK0LmsegmG4KEaqbcGKy05y5fSes1qe87QO0
Z1leOODkFmdoTFNrFWHZ65/bATKT4xD6xQh/8knvXZAAUUFjPmNM+VYlIyn9
SAQugwvz+J1i/9+eh17VFITRHT5dp9NMavqyTiYVQOc5ZfUrHjIHYlpDuHbC
pJ/i82rEPjucAboyhwzc7l3J5KlasYps+Cm0lMoszv2m90Rh9C7nmBs+KVV+
C7LfJhmjP2Bt2vzSSmii+GjUJUItfwMFd/QrNBsXHbHSjCqEfZFUGq6vOrl6
EaEOBFaT00lRI4fDYaybJtFjyDST/9CylWxf0PPj8TjBKscJVqPoXq/X7/fV
bdHDumj7Olg19QWvSseK6w/ytNvtbrdL8eDMr6B5XI/FTJk6TXlHq8KdzzlY
z7zoy0wopdrQ1v1vVzRtvRLgfUTOwlzSqGuECr6Bgjsyr1/ZuOiIy/ZMdkVS
bViNa+TqKkLtCawuVzsG6a/zHMnvnkL4DdkQ0zp33rrv1s/qnt4FR9EArKpf
nzN2/D2WLYf4JGponvwGmsmarnugpWAwGJiMyQMpC7ryDf6WtN7Ac7L/h1ju
AyYtLQs=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{103, 59},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->2454346]
}, Open  ]],

Cell["Do symbolic operations: ", "ExampleText",
 CellID->796318],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{"f", "\[Equal]", 
    RowBox[{"1", "/", "2"}]}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->404681581],

Cell[BoxData[
 RowBox[{"x", "\[Equal]", 
  FractionBox["\[Pi]", "6"]}]], "Output",
 ImageSize->{41, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->15701563]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{"f", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->89464870],

Cell[BoxData[
 FractionBox[
  RowBox[{"8", "-", "\[Pi]"}], "2"]], "Output",
 ImageSize->{36, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->23343328]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"D", "[", 
  RowBox[{"f", ",", "x"}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->360945747],

Cell[BoxData[
 RowBox[{"Which", "[", 
  RowBox[{
   RowBox[{"x", "<", 
    RowBox[{"-", 
     FractionBox["\[Pi]", "2"]}]}], ",", "0", ",", 
   RowBox[{
    RowBox[{"-", 
     FractionBox["\[Pi]", "2"]}], "\[LessEqual]", "x", "\[LessEqual]", 
    FractionBox["\[Pi]", "2"]}], ",", 
   RowBox[{"Cos", "[", "x", "]"}], ",", "True", ",", "0"}], "]"}]], "Output",
 ImageSize->{301, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->765897777]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{"f", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "Pi"}], ",", "Pi"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->172580730],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzNWE1oXUUUnuS+1/xoTdLWpKlGIm4KLgTxt20aa5qkiab5kTatIiRGJVlo
pUYE3ejGbtqNbhoQXdgKapEUQ0WoIAbEqBgQA6KCVJG6sAgWFwHh+p1zZu7c
O++8+/IegoaXe+ee+ebMmfM3Z2Zken72iaem5+dmprsHj08/Mzs382z3wLHj
IEV1xpgl/D+/3aAdo8X/S3GMd/o5jGeErnr6okbMf6YezSlGPBD0RPQo+G9j
CgHiCJOFuvbtb6tf/4qf2UmP6Msvfrly5S/qasOjoIzeKH/GRWB27OkP8DM7
6dHw5OPvT0+dGx99q7dnYW52ceH0yqVLf5j2Dc1BhEn+vJ2eRch+9szqo4+8
A0bLn/5kttUo6Z2MA7cXX/gIQkKgLTVyupupUOTMY+cgmmnFN1lqk30X1VH3
MPf19b+hDYhw9ep6l4rbxVSsFEJevvynudFyPcq9u7n3h+9/t703qDz2MBX9
FrVDRfUEqE4VtTdAbVdRvUyFUmElLM10qKj7nObAi5rtmbXt49733v3mtVc/
o+b1Ko/7mXrilU8+vPAdNUN/SKOgbdiIfE9H9TmpgQLWbFVR+5mK6TApNclv
CCS9/dwLi8JksY2oUh6CQpxgJjzLoAaY+vHFH19+6SI1W1XUIFMBAZCaLTko
zIXQIYu0ZKQ+wL3nF9dOnVym5nUqjyGmwqQIG2puzkGRluUvSqHou3xM8EiK
uDff+Ao/NBoCXJgRvd0KLl9SA8abPPR2mfF+1cl8eFMu2eh8PK6Yzgwrn//M
2aHC2jalx0CPkDMK0HqOGba8WZmIB0RFMp8+YiTwsCYVdTDOxlhjnI5A6YWQ
8BmK9UaVx2hsMxScnpqhDgU1xlQIg2TFqshB+Yygo8bjbIwVM1aVXkyDyVxv
KY+JgIeuxQmnRbgTZQQd1Wjnp1xYsG/6lqgWc3EzGN1hcR12nPtmW5lrAnR6
vyRXCPNzayBrZG0Z4joCPuFuwDpnzy8o3twS6xWCqxzCNYY6CCMq3D/C71B6
ka7Jri3c78J9pi3QSaXZw9ncjiQWaa6ADmfniqKYRFcZfVfiwvFU4g28G2aq
k5CPzC6p0JZ3yuztJXx0f3A+3hl7r6K3yOEzSCnCRYPo8HBsc4pIZXy24SrP
5iKS9OEUNUnolnrEYa0bH01Ryc7GEG+hLvEuFFo+9NOSWrtK/P+9P/mWFPyf
y/OvracKfnQAq6N37Dy6mkyUfMtWVxJvlcZLHLFP2ngTU0yW0GUCT092fmu7
w36Er0KsVKk+X23gT3a6Q2V6ZbdM9ZZo0u+UD+Wg/K7rUb5G8TwmVB5RwENH
CS+/o4znoHzm11HFgNdYgoqSvQ/VMuofyidjKg+pUXwGHM1B+VpKR0nt5Gup
gypKPNfXUiMZqaUXJToKzGxvmkdTYJEHc1CQF1KTFgXlqtGNVPbNgYb55iJT
ecvgSpV3s9Of3Tdq5SP7qD9TDVfBhz6vZTrKUxSp1BwqM74Y66cBGe/PmHnj
884FdPaqxyFpKGORhlg/E2x22rPed0C1tpz6fPU9mPErOVeeSE7aAyoPQfmY
0VFSq+LU9Nz8BWr2q6i2YMb9OSg/o0cRaEuwpj6Vx1arTb13W2DzfTkoSIC4
Ix3rKLnFQODK8U/uQJI8KbWfj/9elYegzp5ZXTi9Qs29Kkr2Hx95PSqqM9Dx
HhW1w6GgI2ruVlFSjQNi5dqVWVuXkxqKpBuIe1UeXc5esCadqvmeLPdGNIyU
m+hRgB3gWwhymOIu5lH9nWk3I5ArIMupk8vgdEeNnG6mRyPsfX5xDQkM/KAi
mBnrBPG2KrgS4RbuQQ6BMuX68tbengUT9fe9DmJss1Xtt8S1jnNZyN18TjG1
9H7b1P0DxUnk4g==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 119},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->40029581]
}, Open  ]]
}, Closed]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->2744],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Switch",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Switch"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["If",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/If"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Piecewise",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Piecewise"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->9648]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->23622],

Cell[TextData[ButtonBox["Conditionals",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Conditionals"]], "Tutorials",
 CellID->10900],

Cell[TextData[ButtonBox["Piecewise Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/PiecewiseFunctions"]], "Tutorials",
 CellID->21875]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["Demonstrations with Which",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=Which"], 
    None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->243533952],

Cell[TextData[ButtonBox["Conditionals",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Conditionals"]], "MoreAbout",
 CellID->463488232],

Cell[TextData[ButtonBox["Logic & Boolean Algebra",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/LogicAndBooleanAlgebra"]], "MoreAbout",
 CellID->135528580],

Cell[TextData[ButtonBox["Procedural Programming",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ProceduralProgramming"]], "MoreAbout",
 CellID->240392483]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Which - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 29, 34.6806102}", "context" -> "System`", 
    "keywords" -> {
     "choose", "conditional ", "multiple conditional", "multiple cases", 
      "control flow", "piecewise functions", "execution flow", "jump table", 
      "fall-through"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Which[test_1, value_1, test_2, value_2, ...] evaluates each of the \
test_i in turn, returning the value of the value_i corresponding to the first \
one that yields True. ", "synonyms" -> {"cond"}, "title" -> "Which", "type" -> 
    "Symbol", "uri" -> "ref/Which"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[7018, 244, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->810358051]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 20774, 728}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2310, 54, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2933, 81, 43, 1, 70, "ObjectName",
 CellID->28668],
Cell[2979, 84, 1336, 43, 70, "Usage",
 CellID->2040]
}, Open  ]],
Cell[CellGroupData[{
Cell[4352, 132, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4830, 149, 300, 12, 70, "Notes",
 CellID->20301],
Cell[5133, 163, 839, 31, 70, "Notes",
 CellID->13426],
Cell[5975, 196, 459, 18, 70, "Notes",
 CellID->24618],
Cell[6437, 216, 544, 23, 70, "Notes",
 CellID->8124]
}, Closed]],
Cell[CellGroupData[{
Cell[7018, 244, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->810358051],
Cell[CellGroupData[{
Cell[7403, 258, 148, 5, 70, "ExampleSection",
 CellID->485975251],
Cell[CellGroupData[{
Cell[7576, 267, 254, 8, 28, "Input",
 CellID->87391421],
Cell[7833, 277, 158, 5, 36, "Output",
 CellID->134345544]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8040, 288, 216, 7, 70, "ExampleSection",
 CellID->18067],
Cell[CellGroupData[{
Cell[8281, 299, 240, 7, 70, "ExampleSubsection",
 CellID->52944875],
Cell[8524, 308, 207, 7, 70, "ExampleText",
 CellID->616272914],
Cell[CellGroupData[{
Cell[8756, 319, 206, 6, 70, "Input",
 CellID->193714535],
Cell[8965, 327, 295, 9, 36, "Output",
 CellID->283026346]
}, Open  ]],
Cell[CellGroupData[{
Cell[9297, 341, 121, 4, 70, "Input",
 CellID->20029986],
Cell[9421, 347, 158, 5, 36, "Output",
 CellID->156495539]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[9628, 358, 245, 7, 70, "ExampleSubsection",
 CellID->643513361],
Cell[9876, 367, 71, 1, 70, "ExampleText",
 CellID->166962445],
Cell[CellGroupData[{
Cell[9972, 372, 452, 15, 70, "Input",
 CellID->653765944],
Cell[10427, 389, 509, 16, 49, "Output",
 CellID->477715421]
}, Open  ]],
Cell[10951, 408, 203, 8, 70, "ExampleText",
 CellID->143080411],
Cell[CellGroupData[{
Cell[11179, 420, 110, 3, 70, "Input",
 CellID->55665065],
Cell[11292, 425, 1011, 21, 70, "Output",
 Evaluatable->False,
 CellID->2454346]
}, Open  ]],
Cell[12318, 449, 64, 1, 70, "ExampleText",
 CellID->796318],
Cell[CellGroupData[{
Cell[12407, 454, 181, 6, 70, "Input",
 CellID->404681581],
Cell[12591, 462, 211, 7, 49, "Output",
 CellID->15701563]
}, Open  ]],
Cell[CellGroupData[{
Cell[12839, 474, 186, 6, 70, "Input",
 CellID->89464870],
Cell[13028, 482, 204, 7, 51, "Output",
 CellID->23343328]
}, Open  ]],
Cell[CellGroupData[{
Cell[13269, 494, 120, 4, 70, "Input",
 CellID->360945747],
Cell[13392, 500, 490, 15, 49, "Output",
 CellID->765897777]
}, Open  ]],
Cell[CellGroupData[{
Cell[13919, 520, 205, 7, 70, "Input",
 CellID->172580730],
Cell[14127, 529, 2119, 39, 70, "Output",
 Evaluatable->False,
 CellID->40029581]
}, Open  ]]
}, Closed]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[16319, 576, 310, 9, 70, "SeeAlsoSection",
 CellID->2744],
Cell[16632, 587, 681, 26, 70, "SeeAlso",
 CellID->9648]
}, Open  ]],
Cell[CellGroupData[{
Cell[17350, 618, 314, 9, 70, "TutorialsSection",
 CellID->23622],
Cell[17667, 629, 135, 3, 70, "Tutorials",
 CellID->10900],
Cell[17805, 634, 148, 3, 70, "Tutorials",
 CellID->21875]
}, Open  ]],
Cell[CellGroupData[{
Cell[17990, 642, 305, 8, 70, "RelatedLinksSection"],
Cell[18298, 652, 355, 12, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[18690, 669, 319, 9, 70, "MoreAboutSection",
 CellID->243533952],
Cell[19012, 680, 136, 3, 70, "MoreAbout",
 CellID->463488232],
Cell[19151, 685, 157, 3, 70, "MoreAbout",
 CellID->135528580],
Cell[19311, 690, 155, 3, 70, "MoreAbout",
 CellID->240392483]
}, Open  ]],
Cell[19481, 696, 27, 0, 70, "History"],
Cell[19511, 698, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

