(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     31013,       1190]
NotebookOptionsPosition[     24177,        951]
NotebookOutlinePosition[     25670,        991]
CellTagsIndexPosition[     25585,        986]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Loops and Control Structures" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/LoopsAndControlStructures"], 
          "Repetitive Operations" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/RepetitiveOperations"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Loops and Control Structures\"\>", 
       2->"\<\"Repetitive Operations\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Do" :> Documentation`HelpLookup["paclet:ref/Do"], "For" :> 
          Documentation`HelpLookup["paclet:ref/For"], "NestWhile" :> 
          Documentation`HelpLookup["paclet:ref/NestWhile"], "TakeWhile" :> 
          Documentation`HelpLookup["paclet:ref/TakeWhile"], "LengthWhile" :> 
          Documentation`HelpLookup["paclet:ref/LengthWhile"], "Nest" :> 
          Documentation`HelpLookup["paclet:ref/Nest"], "Fold" :> 
          Documentation`HelpLookup["paclet:ref/Fold"], "Select" :> 
          Documentation`HelpLookup["paclet:ref/Select"], "Throw" :> 
          Documentation`HelpLookup["paclet:ref/Throw"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Do\"\>", 2->"\<\"For\"\>", 
       3->"\<\"NestWhile\"\>", 4->"\<\"TakeWhile\"\>", 
       5->"\<\"LengthWhile\"\>", 6->"\<\"Nest\"\>", 7->"\<\"Fold\"\>", 
       8->"\<\"Select\"\>", 9->"\<\"Throw\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Language Overview" :> 
          Documentation`HelpLookup["paclet:guide/LanguageOverview"], 
          "Looping Constructs" :> 
          Documentation`HelpLookup["paclet:guide/LoopingConstructs"], 
          "Procedural Programming" :> 
          Documentation`HelpLookup["paclet:guide/ProceduralProgramming"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Language Overview\"\>", 
       2->"\<\"Looping Constructs\"\>", 
       3->"\<\"Procedural Programming\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["While", "ObjectName",
 CellID->11575],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["While",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/While"], "[", 
       RowBox[{
        StyleBox["test", "TI"], ",", 
        StyleBox["body", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]evaluates ",
     Cell[BoxData[
      StyleBox["test", "TI"]], "InlineFormula"],
     ", then ",
     Cell[BoxData[
      StyleBox["body", "TI"]], "InlineFormula"],
     ", repetitively, until ",
     Cell[BoxData[
      StyleBox["test", "TI"]], "InlineFormula"],
     " first fails to give ",
     Cell[BoxData[
      ButtonBox["True",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/True"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->26557]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["While",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/While"], "[", 
   StyleBox["test", "TI"], "]"}]], "InlineFormula", "TemplateInclusion"],
 " does the loop with a null body. "
}], "Notes",
 CellID->13182],

Cell[TextData[{
 "If ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Break",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Break"], "[", "]"}]], "InlineFormula"],
 " is generated in the evaluation of ",
 Cell[BoxData[
  StyleBox["body", "TI"]], "InlineFormula"],
 ", the ",
 Cell[BoxData[
  ButtonBox["While",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/While"]], "InlineFormula"],
 " loop exits. "
}], "Notes",
 CellID->8496],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Continue",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Continue"], "[", "]"}]], "InlineFormula"],
 " exits the evaluation of ",
 Cell[BoxData[
  StyleBox["body", "TI"]], "InlineFormula"],
 ", and continues the loop. "
}], "Notes",
 CellID->23662],

Cell[TextData[{
 "Unless an explicit ",
 Cell[BoxData[
  ButtonBox["Return",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Return"]], "InlineFormula"],
 " is used, the value returned by ",
 Cell[BoxData[
  ButtonBox["While",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/While"]], "InlineFormula"],
 " is ",
 Cell[BoxData[
  ButtonBox["Null",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Null"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->30760],

Cell[TextData[{
 "Note that in an example like ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"i", "=", "0"}], ";", 
   RowBox[{"While", "[", 
    RowBox[{
     RowBox[{"i", "<", "0"}], ",", 
     RowBox[{
      RowBox[{"tot", "+=", 
       RowBox[{"f", "[", "i", "]"}]}], ";", 
      RowBox[{"i", "++"}]}]}], "]"}]}]], "InlineFormula"],
 " the roles of ",
 Cell[BoxData[";"], "InlineFormula"],
 " and ",
 Cell[BoxData[","], "InlineFormula"],
 " are ",
 Cell[BoxData[
  StyleBox["reversed", "TI"]], "InlineFormula"],
 " relative to C-like programming languages. "
}], "Notes",
 CellID->27980]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->14607702],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->781556095],

Cell[TextData[{
 "Print and increment ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " while the condition ",
 Cell[BoxData[
  RowBox[{
   StyleBox["n", "TI"], "<", "4"}]], "InlineFormula"],
 " is satisfied:"
}], "ExampleText",
 CellID->26698],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"n", "=", "1"}], ";", 
  RowBox[{"While", "[", 
   RowBox[{
    RowBox[{"n", "<", "4"}], ",", 
    RowBox[{
     RowBox[{"Print", "[", "n", "]"}], ";", 
     RowBox[{"n", "++"}]}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->5017],

Cell[CellGroupData[{

Cell[BoxData["1"], "Print",
 CellLabel->"During evaluation of In[4]:=",
 CellID->1445],

Cell[BoxData["2"], "Print",
 CellLabel->"During evaluation of In[4]:=",
 CellID->25227],

Cell[BoxData["3"], "Print",
 CellLabel->"During evaluation of In[4]:=",
 CellID->17896]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->19826],

Cell["The body can be included as part of the test:", "ExampleText",
 CellID->3996],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"n", "=", "1"}], ";", 
  RowBox[{"While", "[", 
   RowBox[{
    RowBox[{"++", "n"}], "<", "4"}], "]"}], ";", "n"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->12432],

Cell[BoxData["4"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->35491085]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"n", "=", "1"}], ";", 
  RowBox[{"While", "[", 
   RowBox[{
    RowBox[{"n", "<", "4"}], ",", 
    RowBox[{"n", "++"}]}], "]"}], ";", "n"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->31371],

Cell[BoxData["4"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->877460093]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->10792],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Break",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Break"]], "InlineFormula"],
 " breaks out of the ",
 Cell[BoxData[
  ButtonBox["While",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/While"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->12249],

Cell[BoxData[
 RowBox[{
  RowBox[{"n", "=", "1"}], ";", 
  RowBox[{"While", "[", 
   RowBox[{"True", ",", 
    RowBox[{
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"n", ">", "10"}], ",", 
       RowBox[{"Break", "[", "]"}]}], "]"}], ";", 
     RowBox[{"n", "++"}]}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->14108],

Cell[CellGroupData[{

Cell[BoxData["n"], "Input",
 CellLabel->"In[2]:=",
 CellID->14397],

Cell[BoxData["11"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->4172]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->31236],

Cell["Test the condition during or at the end of the loop:", "ExampleText",
 CellID->417701320],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"While", "[", 
  RowBox[{"True", ",", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"n", "=", 
     RowBox[{"Input", "[", "\"\<enter an integer\>\"", "]"}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"!", 
        RowBox[{"IntegerQ", "[", "n", "]"}]}], "||", 
       RowBox[{"n", "\[LessEqual]", "0"}]}], ",", 
      RowBox[{"Break", "[", "]"}]}], "]"}], ";", "\[IndentingNewLine]", 
    RowBox[{"Print", "[", 
     RowBox[{"n", ",", "\"\<=\>\"", ",", 
      RowBox[{"FactorInteger", "[", "n", "]"}]}], "]"}]}]}], 
  "\[IndentingNewLine]", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->79845605],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"33", "\[InvisibleSpace]", "\<\"=\"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"3", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"11", ",", "1"}], "}"}]}], "}"}]}],
  SequenceForm[33, "=", {{3, 1}, {11, 1}}],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[1]:=",
 CellID->417329292]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->647],

Cell["Compute the GCD of two numbers:", "ExampleText",
 CellID->102782179],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b"}], "}"}], "=", 
   RowBox[{"{", 
    RowBox[{"27", ",", "6"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"While", "[", 
   RowBox[{
    RowBox[{"b", "\[NotEqual]", "0"}], ",", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b"}], "}"}], "=", 
     RowBox[{"{", 
      RowBox[{"b", ",", 
       RowBox[{"Mod", "[", 
        RowBox[{"a", ",", "b"}], "]"}]}], "}"}]}]}], "]"}], 
  ";"}], "\n", "a"}], "Input",
 CellLabel->"In[1]:=",
 CellID->432169089],

Cell[BoxData["3"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->366766245]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->3158640],

Cell["Count the number of iterations in a fixed-point calculation:", \
"ExampleText",
 CellID->282837946],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"x", "=", "1.0"}], ";", 
  RowBox[{"i", "=", "0"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"While", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Cos", "[", "x", "]"}], "\[NotEqual]", "x"}], ",", 
    RowBox[{
     RowBox[{"x", "=", 
      RowBox[{"Cos", "[", "x", "]"}]}], ";", 
     RowBox[{"i", "++"}]}]}], "]"}], ";", 
  RowBox[{"{", 
   RowBox[{"x", ",", "i"}], "}"}]}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->750827712],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.7390851332151657`", ",", "80"}], "}"}]], "Output",
 ImageSize->{100, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->244986715]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->22760],

Cell[TextData[{
 "If the test is ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 ", the body is never evaluated:"
}], "ExampleText",
 CellID->16613],

Cell[BoxData[
 RowBox[{"While", "[", 
  RowBox[{"False", ",", 
   RowBox[{"Print", "[", "x", "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->15555],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->2775],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["While",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/While"]], "InlineFormula"],
 " returns ",
 Cell[BoxData[
  ButtonBox["Null",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Null"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->1022],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullForm", "[", 
  RowBox[{
   RowBox[{"n", "=", "1"}], ";", 
   RowBox[{"While", "[", 
    RowBox[{
     RowBox[{"n", "<", "5"}], ",", 
     RowBox[{"n", "++"}]}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->13588],

Cell[BoxData[
 TagBox[
  StyleBox["Null",
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//FullForm=",
 CellID->14371]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Print",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Print"]], "InlineFormula"],
 " to see the iterations:"
}], "ExampleText",
 CellID->212265211],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"n", "=", "17"}], ";", 
  RowBox[{"While", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"n", "=", 
       RowBox[{"Floor", "[", 
        RowBox[{"n", "/", "2"}], "]"}]}], ")"}], "!=", "0"}], ",", 
    RowBox[{"Print", "[", "n", "]"}]}], "]"}], ";", "n"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->21248],

Cell[CellGroupData[{

Cell[BoxData["8"], "Print",
 CellLabel->"During evaluation of In[2]:=",
 CellID->204187546],

Cell[BoxData["4"], "Print",
 CellLabel->"During evaluation of In[2]:=",
 CellID->126524697],

Cell[BoxData["2"], "Print",
 CellLabel->"During evaluation of In[2]:=",
 CellID->22158443],

Cell[BoxData["1"], "Print",
 CellLabel->"During evaluation of In[2]:=",
 CellID->45062187]
}, Open  ]],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->252380336]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->280763512],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Do",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Do"]], "InlineFormula"],
 " iterates a fixed number of times:"
}], "ExampleText",
 CellID->28559032],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"x", "=", "1.0"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"Do", "[", 
   RowBox[{
    RowBox[{"x", "=", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"x", "+", 
        RowBox[{"2", "/", "x"}]}], ")"}], "/", "2"}]}], ",", 
    RowBox[{"{", "5", "}"}]}], "]"}], ";", "x"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->78403115],

Cell[BoxData["1.414213562373095`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->344405188]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->135042010],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["NestWhile",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NestWhile"]], "InlineFormula"],
 " is a functional form of ",
 Cell[BoxData[
  ButtonBox["While",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/While"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->182259157],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NestWhile", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Floor", "[", 
     RowBox[{"#", "/", "2"}], "]"}], "&"}], ",", "10", ",", 
   RowBox[{
    RowBox[{"#", ">", "0"}], "&"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->324066301],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->295707631]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "=", "10"}], ";", 
  RowBox[{"While", "[", 
   RowBox[{
    RowBox[{"x", ">", "0"}], ",", 
    RowBox[{"x", "=", 
     RowBox[{"Floor", "[", 
      RowBox[{"x", "/", "2"}], "]"}]}]}], "]"}], ";", "x"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->903825132],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->66898306]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->26384],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Do",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Do"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["For",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/For"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NestWhile",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NestWhile"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["TakeWhile",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TakeWhile"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["LengthWhile",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LengthWhile"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Nest",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Nest"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Fold",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Fold"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Select",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Select"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Throw",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Throw"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->15928]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->25303],

Cell[TextData[ButtonBox["Loops and Control Structures",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/LoopsAndControlStructures"]], "Tutorials",
 CellID->14720],

Cell[TextData[ButtonBox["Repetitive Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/RepetitiveOperations"]], "Tutorials",
 CellID->2986]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->655697871],

Cell[TextData[ButtonBox["Language Overview",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/LanguageOverview"]], "MoreAbout",
 CellID->7379475],

Cell[TextData[ButtonBox["Looping Constructs",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/LoopingConstructs"]], "MoreAbout",
 CellID->906482226],

Cell[TextData[ButtonBox["Procedural Programming",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ProceduralProgramming"]], "MoreAbout",
 CellID->351363166]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["NKS|Online",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/index/search.cgi?SearchIndex=\
While"], None}],
 " (",
 StyleBox[ButtonBox["A New Kind of Science",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/"], None}],
  FontSlant->"Italic"],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"While - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 29, 35.1181214}", "context" -> "System`", 
    "keywords" -> {
     "until", "repetitive evaluation", "repeat evaluation", "evaluation loop",
       "evaluation flow", "iteration", "iterative evaluation", "loop", 
      "repeat", "repeated calculation", "repeating evaluation", 
      "data dependent control flow", "data dependent loop counts"}, "index" -> 
    True, "label" -> "Built-in Mathematica Symbol", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "While[test, body] evaluates test, then body, repetitively, until test \
first fails to give True. ", "synonyms" -> {}, "title" -> "While", "type" -> 
    "Symbol", "uri" -> "ref/While"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[7156, 236, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->14607702]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 25443, 979}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2945, 64, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3568, 91, 43, 1, 70, "ObjectName",
 CellID->11575],
Cell[3614, 94, 925, 31, 70, "Usage",
 CellID->26557]
}, Open  ]],
Cell[CellGroupData[{
Cell[4576, 130, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5054, 147, 269, 9, 70, "Notes",
 CellID->13182],
Cell[5326, 158, 431, 17, 70, "Notes",
 CellID->8496],
Cell[5760, 177, 309, 11, 70, "Notes",
 CellID->23662],
Cell[6072, 190, 459, 18, 70, "Notes",
 CellID->30760],
Cell[6534, 210, 585, 21, 70, "Notes",
 CellID->27980]
}, Closed]],
Cell[CellGroupData[{
Cell[7156, 236, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->14607702],
Cell[CellGroupData[{
Cell[7540, 250, 148, 5, 70, "ExampleSection",
 CellID->781556095],
Cell[7691, 257, 257, 10, 70, "ExampleText",
 CellID->26698],
Cell[CellGroupData[{
Cell[7973, 271, 273, 10, 70, "Input",
 CellID->5017],
Cell[CellGroupData[{
Cell[8271, 285, 86, 2, 70, "Print",
 CellID->1445],
Cell[8360, 289, 87, 2, 70, "Print",
 CellID->25227],
Cell[8450, 293, 87, 2, 70, "Print",
 CellID->17896]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8598, 302, 216, 7, 70, "ExampleSection",
 CellID->19826],
Cell[8817, 311, 83, 1, 70, "ExampleText",
 CellID->3996],
Cell[CellGroupData[{
Cell[8925, 316, 198, 7, 70, "Input",
 CellID->12432],
Cell[9126, 325, 157, 5, 36, "Output",
 CellID->35491085]
}, Open  ]],
Cell[CellGroupData[{
Cell[9320, 335, 223, 8, 70, "Input",
 CellID->31371],
Cell[9546, 345, 158, 5, 36, "Output",
 CellID->877460093]
}, Open  ]],
Cell[9719, 353, 121, 3, 70, "ExampleDelimiter",
 CellID->10792],
Cell[9843, 358, 305, 12, 70, "ExampleText",
 CellID->12249],
Cell[10151, 372, 337, 12, 70, "Input",
 CellID->14108],
Cell[CellGroupData[{
Cell[10513, 388, 66, 2, 70, "Input",
 CellID->14397],
Cell[10582, 392, 154, 5, 36, "Output",
 CellID->4172]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[10785, 403, 239, 7, 70, "ExampleSection",
 CellID->31236],
Cell[11027, 412, 95, 1, 70, "ExampleText",
 CellID->417701320],
Cell[CellGroupData[{
Cell[11147, 417, 684, 19, 70, "Input",
 CellID->79845605],
Cell[11834, 438, 405, 12, 70, "Print",
 CellID->417329292]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[12288, 456, 221, 7, 70, "ExampleSection",
 CellID->647],
Cell[12512, 465, 74, 1, 70, "ExampleText",
 CellID->102782179],
Cell[CellGroupData[{
Cell[12611, 470, 539, 20, 70, "Input",
 CellID->432169089],
Cell[13153, 492, 158, 5, 36, "Output",
 CellID->366766245]
}, Open  ]],
Cell[13326, 500, 123, 3, 70, "ExampleDelimiter",
 CellID->3158640],
Cell[13452, 505, 105, 2, 70, "ExampleText",
 CellID->282837946],
Cell[CellGroupData[{
Cell[13582, 511, 458, 16, 70, "Input",
 CellID->750827712],
Cell[14043, 529, 223, 7, 36, "Output",
 CellID->244986715]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[14315, 542, 233, 7, 70, "ExampleSection",
 CellID->22760],
Cell[14551, 551, 217, 8, 70, "ExampleText",
 CellID->16613],
Cell[14771, 561, 157, 5, 70, "Input",
 CellID->15555],
Cell[14931, 568, 120, 3, 70, "ExampleDelimiter",
 CellID->2775],
Cell[15054, 573, 292, 12, 70, "ExampleText",
 CellID->1022],
Cell[CellGroupData[{
Cell[15371, 589, 253, 9, 70, "Input",
 CellID->13588],
Cell[15627, 600, 288, 11, 50, "Output",
 CellID->14371]
}, Open  ]],
Cell[15930, 614, 203, 8, 70, "ExampleText",
 CellID->212265211],
Cell[CellGroupData[{
Cell[16158, 626, 357, 12, 70, "Input",
 CellID->21248],
Cell[CellGroupData[{
Cell[16540, 642, 91, 2, 70, "Print",
 CellID->204187546],
Cell[16634, 646, 91, 2, 70, "Print",
 CellID->126524697],
Cell[16728, 650, 90, 2, 70, "Print",
 CellID->22158443],
Cell[16821, 654, 90, 2, 70, "Print",
 CellID->45062187]
}, Open  ]],
Cell[16926, 659, 158, 5, 36, "Output",
 CellID->252380336]
}, Open  ]],
Cell[17099, 667, 125, 3, 70, "ExampleDelimiter",
 CellID->280763512],
Cell[17227, 672, 198, 7, 70, "ExampleText",
 CellID->28559032],
Cell[CellGroupData[{
Cell[17450, 683, 359, 13, 70, "Input",
 CellID->78403115],
Cell[17812, 698, 175, 5, 36, "Output",
 CellID->344405188]
}, Open  ]],
Cell[18002, 706, 125, 3, 70, "ExampleDelimiter",
 CellID->135042010],
Cell[18130, 711, 323, 12, 70, "ExampleText",
 CellID->182259157],
Cell[CellGroupData[{
Cell[18478, 727, 262, 9, 70, "Input",
 CellID->324066301],
Cell[18743, 738, 158, 5, 36, "Output",
 CellID->295707631]
}, Open  ]],
Cell[CellGroupData[{
Cell[18938, 748, 294, 10, 70, "Input",
 CellID->903825132],
Cell[19235, 760, 157, 5, 36, "Output",
 CellID->66898306]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[19453, 772, 311, 9, 70, "SeeAlsoSection",
 CellID->26384],
Cell[19767, 783, 2128, 80, 70, "SeeAlso",
 CellID->15928]
}, Open  ]],
Cell[CellGroupData[{
Cell[21932, 868, 314, 9, 70, "TutorialsSection",
 CellID->25303],
Cell[22249, 879, 164, 3, 70, "Tutorials",
 CellID->14720],
Cell[22416, 884, 151, 3, 70, "Tutorials",
 CellID->2986]
}, Open  ]],
Cell[CellGroupData[{
Cell[22604, 892, 319, 9, 70, "MoreAboutSection",
 CellID->655697871],
Cell[22926, 903, 143, 3, 70, "MoreAbout",
 CellID->7379475],
Cell[23072, 908, 147, 3, 70, "MoreAbout",
 CellID->906482226],
Cell[23222, 913, 155, 3, 70, "MoreAbout",
 CellID->351363166]
}, Open  ]],
Cell[CellGroupData[{
Cell[23414, 921, 305, 8, 70, "RelatedLinksSection"],
Cell[23722, 931, 383, 13, 70, "RelatedLinks"]
}, Open  ]],
Cell[24120, 947, 27, 0, 70, "History"],
Cell[24150, 949, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

