(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     12453,        440]
NotebookOptionsPosition[      9315,        335]
NotebookOutlinePosition[     10610,        373]
CellTagsIndexPosition[     10525,        368]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"String Patterns" :> 
          Documentation`HelpLookup["paclet:tutorial/StringPatterns"], 
          "Working with String Patterns" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/WorkingWithStringPatternsOverview"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"String Patterns\"\>", 
       2->"\<\"Working with String Patterns\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"WhitespaceCharacter" :> 
          Documentation`HelpLookup["paclet:ref/WhitespaceCharacter"], 
          "WordBoundary" :> 
          Documentation`HelpLookup["paclet:ref/WordBoundary"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"WhitespaceCharacter\"\>", 
       2->"\<\"WordBoundary\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"String Manipulation" :> 
          Documentation`HelpLookup["paclet:guide/StringManipulation"], 
          "String Patterns" :> 
          Documentation`HelpLookup["paclet:guide/StringPatterns"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"String Manipulation\"\>", 
       2->"\<\"String Patterns\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Whitespace", "ObjectName",
 CellID->12926],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["Whitespace",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Whitespace"]], "InlineFormula"],
     " \[LineSeparator]represents a sequence of whitespace characters in ",
     Cell[BoxData[
      ButtonBox["StringExpression",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/StringExpression"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->5075]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["Whitespace is taken to include spaces, tabs and newlines.", "Notes",
 CellID->24504]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->560027435],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->13014721],

Cell[TextData[{
 "Split a string at all ",
 Cell[BoxData[
  ButtonBox["Whitespace",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Whitespace"]], "InlineFormula"],
 " characters:"
}], "ExampleText",
 CellID->1108533178],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringSplit", "[", 
  RowBox[{"\"\<1   \\t 2 \\n3 \\r  4\>\"", ",", "Whitespace"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->69114228],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"1\"\>", ",", "\<\"2\"\>", ",", "\<\"3\"\>", ",", "\<\"4\"\>"}],
   "}"}]], "Output",
 ImageSize->{80, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->33067386]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1696484921],

Cell["Remove all leading and trailing spaces: ", "ExampleText",
 CellID->271815851],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"StringReplace", "[", 
   RowBox[{"\"\<  this is a test.  \>\"", ",", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"StartOfString", " ", "~~", "Whitespace"}], ")"}], " ", "|", 
      " ", 
      RowBox[{"(", 
       RowBox[{"Whitespace", " ", "~~", " ", "EndOfString"}], ")"}]}], " ", 
     "\[RuleDelayed]", " ", "\"\<\>\""}]}], "]"}], "//", 
  "FullForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1766933314],

Cell[BoxData[
 TagBox[
  StyleBox["\"\<this is a test.\>\"",
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Output",
 ImageSize->{123, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//FullForm=",
 CellID->878232830]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->26756],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["WhitespaceCharacter",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/WhitespaceCharacter"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["WordBoundary",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/WordBoundary"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->5771]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->24141],

Cell[TextData[ButtonBox["String Patterns",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/StringPatterns"]], "Tutorials",
 CellID->8153],

Cell[TextData[ButtonBox["Working with String Patterns",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/WorkingWithStringPatternsOverview"]], "Tutorials",
 CellID->22514736]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["Demonstrations with Whitespace",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=Whitespace"], 
    None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->379419464],

Cell[TextData[ButtonBox["String Manipulation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/StringManipulation"]], "MoreAbout",
 CellID->373995023],

Cell[TextData[ButtonBox["String Patterns",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/StringPatterns"]], "MoreAbout",
 CellID->445259841]
}, Open  ]],

Cell["New in 5.1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Whitespace - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 29, 36.0556454}", "context" -> "System`", 
    "keywords" -> {
     "newline", "return", "space", "tab", "whitespace", 
      "whitespace character"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Whitespace represents a sequence of whitespace characters in \
StringExpression.", "synonyms" -> {}, "title" -> "Whitespace", "type" -> 
    "Symbol", "uri" -> "ref/Whitespace"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4103, 129, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->560027435]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 10382, 361}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2189, 53, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2812, 80, 48, 1, 70, "ObjectName",
 CellID->12926],
Cell[2863, 83, 598, 18, 70, "Usage",
 CellID->5075]
}, Open  ]],
Cell[CellGroupData[{
Cell[3498, 106, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3976, 123, 90, 1, 70, "Notes",
 CellID->24504]
}, Closed]],
Cell[CellGroupData[{
Cell[4103, 129, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->560027435],
Cell[CellGroupData[{
Cell[4488, 143, 147, 5, 70, "ExampleSection",
 CellID->13014721],
Cell[4638, 150, 221, 8, 70, "ExampleText",
 CellID->1108533178],
Cell[CellGroupData[{
Cell[4884, 162, 169, 5, 28, "Input",
 CellID->69114228],
Cell[5056, 169, 257, 8, 36, "Output",
 CellID->33067386]
}, Open  ]],
Cell[5328, 180, 126, 3, 70, "ExampleDelimiter",
 CellID->1696484921],
Cell[5457, 185, 83, 1, 70, "ExampleText",
 CellID->271815851],
Cell[CellGroupData[{
Cell[5565, 190, 470, 14, 70, "Input",
 CellID->1766933314],
Cell[6038, 206, 312, 11, 50, "Output",
 CellID->878232830]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6411, 224, 311, 9, 70, "SeeAlsoSection",
 CellID->26756],
Cell[6725, 235, 480, 17, 70, "SeeAlso",
 CellID->5771]
}, Open  ]],
Cell[CellGroupData[{
Cell[7242, 257, 314, 9, 70, "TutorialsSection",
 CellID->24141],
Cell[7559, 268, 139, 3, 70, "Tutorials",
 CellID->8153],
Cell[7701, 273, 178, 4, 70, "Tutorials",
 CellID->22514736]
}, Open  ]],
Cell[CellGroupData[{
Cell[7916, 282, 305, 8, 70, "RelatedLinksSection"],
Cell[8224, 292, 365, 12, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[8626, 309, 319, 9, 70, "MoreAboutSection",
 CellID->379419464],
Cell[8948, 320, 149, 3, 70, "MoreAbout",
 CellID->373995023],
Cell[9100, 325, 141, 3, 70, "MoreAbout",
 CellID->445259841]
}, Open  ]],
Cell[9256, 331, 29, 0, 70, "History"],
Cell[9288, 333, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

