(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     34162,        779]
NotebookOptionsPosition[     30968,        675]
NotebookOutlinePosition[     32512,        719]
CellTagsIndexPosition[     32394,        713]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Options for Notebooks" :> 
          Documentation`HelpLookup["paclet:tutorial/OptionsForNotebooks"]}, #,
          2]& , Evaluator -> Automatic], {
       1->"\<\"Options for Notebooks\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"WindowTitle" :> 
          Documentation`HelpLookup["paclet:ref/WindowTitle"], 
          "WindowElements" :> 
          Documentation`HelpLookup["paclet:ref/WindowElements"], 
          "WindowToolbars" :> 
          Documentation`HelpLookup["paclet:ref/WindowToolbars"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"WindowTitle\"\>", 
       2->"\<\"WindowElements\"\>", 
       3->"\<\"WindowToolbars\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Stand-Alone Interfaces" :> 
          Documentation`HelpLookup["paclet:guide/StandAloneInterfaces"], 
          "Stylesheets" :> 
          Documentation`HelpLookup["paclet:guide/Stylesheets"], 
          "Window Properties" :> 
          Documentation`HelpLookup["paclet:guide/WindowProperties"]}, #, 2]& ,
         Evaluator -> Automatic], {1->"\<\"Stand-Alone Interfaces\"\>", 
       2->"\<\"Stylesheets\"\>", 
       3->"\<\"Window Properties\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["WindowFrame", "ObjectName",
 CellID->9227],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["WindowFrame",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/WindowFrame"]], "InlineFormula"],
     "\[LineSeparator]is a notebook option which specifies the type of frame \
to draw around the window in which the notebook is displayed on the screen. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->14312]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["Typical possible settings are: ", "Notes",
 CellID->24330],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Frameless\>\"", Cell[
    "an ordinary window with no frame ", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Generic\>\"", Cell[
    "a window with a generic border ", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<ModalDialog\>\"", Cell[
    "a modal dialog box window ", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<ModelessDialog\>\"", Cell[
    "a modeless dialog box window ", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<MovableModalDialog\>\"", Cell[
    "a movable modal dialog box window ", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Normal\>\"", Cell[
    "an ordinary window ", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Palette\>\"", Cell[
    "a palette window ", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<ThinFrame\>\"", Cell[
    "an ordinary window with a thin frame ", "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, None, None, None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{True, True, True, True, True, True, True, True, True}}}},
 CellID->7268],

Cell["\<\
The details of how particular types of frames are rendered may differ from \
one computer system to another. \
\>", "Notes",
 CellID->31553],

Cell[TextData[{
 "Settings for ",
 Cell[BoxData[
  ButtonBox["WindowFrame",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/WindowFrame"]], "InlineFormula"],
 " affect only the appearance of a window, and not any of its other \
characteristics. "
}], "Notes",
 CellID->19548]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->37413651],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->19249197],

Cell["Create windows with various frames:", "ExampleText",
 CellID->255704491],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"n", "=", "1"}], ";", 
  RowBox[{"Do", "[", 
   RowBox[{
    RowBox[{"CreateDocument", "[", 
     RowBox[{
      RowBox[{"TextCell", "[", 
       RowBox[{"\"\<abcd\>\"", ",", "\"\<Text\>\""}], "]"}], ",", 
      RowBox[{"WindowFrame", "\[Rule]", "wf"}], ",", 
      RowBox[{"WindowSize", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"200", ",", "200"}], "}"}]}], ",", 
      RowBox[{"WindowTitle", "\[Rule]", "wf"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"wf", ",", 
      RowBox[{"{", 
       RowBox[{
       "\"\<Normal\>\"", ",", "\"\<Palette\>\"", ",", 
        "\"\<ModelessDialog\>\"", ",", "\"\<Frameless\>\""}], "}"}]}], 
     "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->34128726],

Cell[BoxData[Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Graphics",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  ImageSize->{335, 293},
  ImageMargins->0]], "NotebookImage",
 CellTags->"Notebook Image",
 CellID->167733533]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->32570],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["WindowTitle",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/WindowTitle"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["WindowElements",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/WindowElements"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["WindowToolbars",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/WindowToolbars"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->28651]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->14499],

Cell[TextData[ButtonBox["Options for Notebooks",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/OptionsForNotebooks"]], "Tutorials",
 CellID->6900]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->214097793],

Cell[TextData[ButtonBox["Stand-Alone Interfaces",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/StandAloneInterfaces"]], "MoreAbout",
 CellID->658265589],

Cell[TextData[ButtonBox["Stylesheets",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Stylesheets"]], "MoreAbout",
 CellID->321602181],

Cell[TextData[ButtonBox["Window Properties",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/WindowProperties"]], "MoreAbout",
 CellID->105739034]
}, Open  ]],

Cell["New in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"WindowFrame - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 29, 43.5402120}", "context" -> "System`", 
    "keywords" -> {
     "Frame", "frame style", "window frame style", "window border", 
      "window edge"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "WindowFrame is a notebook option which specifies the type of frame to \
draw around the window in which the notebook is displayed on the screen. ", 
    "synonyms" -> {"window frame"}, "title" -> "WindowFrame", "type" -> 
    "Symbol", "uri" -> "ref/WindowFrame"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5909, 175, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->37413651]},
 "Notebook Image"->{
  Cell[7299, 225, 21194, 351, 70, "NotebookImage",
   CellTags->"Notebook Image",
   CellID->167733533]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 32125, 702},
 {"Notebook Image", 32265, 706}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2274, 56, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2897, 83, 48, 1, 70, "ObjectName",
 CellID->9227],
Cell[2948, 86, 522, 14, 70, "Usage",
 CellID->14312]
}, Open  ]],
Cell[CellGroupData[{
Cell[3507, 105, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3985, 122, 64, 1, 70, "Notes",
 CellID->24330],
Cell[4052, 125, 1388, 28, 70, "2ColumnTableMod",
 CellID->7268],
Cell[5443, 155, 150, 4, 70, "Notes",
 CellID->31553],
Cell[5596, 161, 276, 9, 70, "Notes",
 CellID->19548]
}, Closed]],
Cell[CellGroupData[{
Cell[5909, 175, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->37413651],
Cell[CellGroupData[{
Cell[6293, 189, 147, 5, 70, "ExampleSection",
 CellID->19249197],
Cell[6443, 196, 78, 1, 70, "ExampleText",
 CellID->255704491],
Cell[CellGroupData[{
Cell[6546, 201, 750, 22, 70, "Input",
 CellID->34128726],
Cell[7299, 225, 21194, 351, 70, "NotebookImage",
 CellTags->"Notebook Image",
 CellID->167733533]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[28554, 583, 311, 9, 70, "SeeAlsoSection",
 CellID->32570],
Cell[28868, 594, 726, 26, 70, "SeeAlso",
 CellID->28651]
}, Open  ]],
Cell[CellGroupData[{
Cell[29631, 625, 314, 9, 70, "TutorialsSection",
 CellID->14499],
Cell[29948, 636, 150, 3, 70, "Tutorials",
 CellID->6900]
}, Open  ]],
Cell[CellGroupData[{
Cell[30135, 644, 319, 9, 70, "MoreAboutSection",
 CellID->214097793],
Cell[30457, 655, 154, 3, 70, "MoreAbout",
 CellID->658265589],
Cell[30614, 660, 134, 3, 70, "MoreAbout",
 CellID->321602181],
Cell[30751, 665, 145, 3, 70, "MoreAbout",
 CellID->105739034]
}, Open  ]],
Cell[30911, 671, 27, 0, 70, "History"],
Cell[30941, 673, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

