(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     19206,        529]
NotebookOptionsPosition[     15846,        421]
NotebookOutlinePosition[     17550,        468]
CellTagsIndexPosition[     17432,        462]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Options for Notebooks" :> 
          Documentation`HelpLookup["paclet:tutorial/OptionsForNotebooks"]}, #,
          2]& , Evaluator -> Automatic], {
       1->"\<\"Options for Notebooks\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"WindowMargins" :> 
          Documentation`HelpLookup["paclet:ref/WindowMargins"], "Selectable" :> 
          Documentation`HelpLookup["paclet:ref/Selectable"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"WindowMargins\"\>", 
       2->"\<\"Selectable\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Window Properties" :> 
          Documentation`HelpLookup["paclet:guide/WindowProperties"]}, #, 2]& ,
         Evaluator -> Automatic], {
       1->"\<\"Window Properties\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["WindowMovable", "ObjectName",
 CellID->24698],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["WindowMovable",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/WindowMovable"]], "InlineFormula"],
     "\[LineSeparator]is a notebook option which specifies whether to allow \
the window for the notebook to be moved around interactively on the screen. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->29911]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["WindowMovable",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/WindowMovable"]], "InlineFormula"],
 " affects only interactive operations in the front end. "
}], "Notes",
 CellID->18132],

Cell[TextData[{
 "Even with ",
 Cell[BoxData[
  RowBox[{"WindowMovable", "->", 
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"]}]], "InlineFormula"],
 ", the ",
 Cell[BoxData[
  ButtonBox["WindowMargins",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/WindowMargins"]], "InlineFormula"],
 " option can still be reset from the kernel or Option Inspector menu. "
}], "Notes",
 CellID->26956]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->48853416],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->429045195],

Cell["Create a notebook window that cannot be moved interactively:", \
"ExampleText",
 CellID->62088482],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"nb", "=", 
   RowBox[{"CreateDocument", "[", 
    RowBox[{
     RowBox[{"TextCell", "[", 
      RowBox[{"\"\<abcd\>\"", ",", "\"\<Text\>\""}], "]"}], ",", 
     RowBox[{"WindowMovable", "\[Rule]", "False"}], ",", 
     RowBox[{"WindowSize", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"200", ",", "150"}], "}"}]}]}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->46190596],

Cell[BoxData[Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Graphics",
  ImageSize->{301, 241},
  ImageMargins->0]], "NotebookImage",
 CellTags->"Notebook Image",
 CellID->312075616]
}, Open  ]],

Cell["The window can be moved by using kernel commands:", "ExampleText",
 CellID->16947543],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SetOptions", "[", 
  RowBox[{"nb", ",", 
   RowBox[{"WindowMargins", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "Automatic"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "Automatic"}], "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->335746445],

Cell[BoxData[Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Graphics",
  ImageSize->{301, 241},
  ImageMargins->0]], "NotebookImage",
 CellTags->"Notebook Image",
 CellID->892894344]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->8609],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["WindowMargins",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/WindowMargins"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Selectable",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Selectable"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->8139]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->10119],

Cell[TextData[ButtonBox["Options for Notebooks",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/OptionsForNotebooks"]], "Tutorials",
 CellID->28446]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->205452003],

Cell[TextData[ButtonBox["Window Properties",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/WindowProperties"]], "MoreAbout",
 CellID->228705832]
}, Open  ]],

Cell["New in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"WindowMovable - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 29, 44.4933614}", "context" -> "System`", 
    "keywords" -> {
     "locking", "moving", "fixed window", "interactively moving a window", 
      "window position", "window location", "window placement"}, "index" -> 
    True, "label" -> "Built-in Mathematica Symbol", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "WindowMovable is a notebook option which specifies whether to allow the \
window for the notebook to be moved around interactively on the screen. ", 
    "synonyms" -> {"window movable"}, "title" -> "WindowMovable", "type" -> 
    "Symbol", "uri" -> "ref/WindowMovable"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4259, 141, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->48853416]},
 "Notebook Image"->{
  Cell[5348, 182, 3969, 68, 70, "NotebookImage",
   CellTags->"Notebook Image",
   CellID->312075616],
  Cell[9800, 271, 4127, 70, 70, "NotebookImage",
   CellTags->"Notebook Image",
   CellID->892894344]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 17062, 448},
 {"Notebook Image", 17202, 452}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1846, 47, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2469, 74, 51, 1, 70, "ObjectName",
 CellID->24698],
Cell[2523, 77, 525, 14, 70, "Usage",
 CellID->29911]
}, Open  ]],
Cell[CellGroupData[{
Cell[3085, 96, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3563, 113, 232, 7, 70, "Notes",
 CellID->18132],
Cell[3798, 122, 424, 14, 70, "Notes",
 CellID->26956]
}, Closed]],
Cell[CellGroupData[{
Cell[4259, 141, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->48853416],
Cell[CellGroupData[{
Cell[4643, 155, 148, 5, 70, "ExampleSection",
 CellID->429045195],
Cell[4794, 162, 104, 2, 70, "ExampleText",
 CellID->62088482],
Cell[CellGroupData[{
Cell[4923, 168, 422, 12, 70, "Input",
 CellID->46190596],
Cell[5348, 182, 3969, 68, 70, "NotebookImage",
 CellTags->"Notebook Image",
 CellID->312075616]
}, Open  ]],
Cell[9332, 253, 91, 1, 70, "ExampleText",
 CellID->16947543],
Cell[CellGroupData[{
Cell[9448, 258, 349, 11, 70, "Input",
 CellID->335746445],
Cell[9800, 271, 4127, 70, 70, "NotebookImage",
 CellTags->"Notebook Image",
 CellID->892894344]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[13988, 348, 310, 9, 70, "SeeAlsoSection",
 CellID->8609],
Cell[14301, 359, 464, 17, 70, "SeeAlso",
 CellID->8139]
}, Open  ]],
Cell[CellGroupData[{
Cell[14802, 381, 314, 9, 70, "TutorialsSection",
 CellID->10119],
Cell[15119, 392, 151, 3, 70, "Tutorials",
 CellID->28446]
}, Open  ]],
Cell[CellGroupData[{
Cell[15307, 400, 319, 9, 70, "MoreAboutSection",
 CellID->205452003],
Cell[15629, 411, 145, 3, 70, "MoreAbout",
 CellID->228705832]
}, Open  ]],
Cell[15789, 417, 27, 0, 70, "History"],
Cell[15819, 419, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

