(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      9678,        343]
NotebookOptionsPosition[      7252,        260]
NotebookOutlinePosition[      8427,        296]
CellTagsIndexPosition[      8343,        291]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Manipulating Notebooks from the Kernel" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ManipulatingNotebooksFromTheKernel"], 
          "Reading Textual Data" :> 
          Documentation`HelpLookup["paclet:tutorial/ReadingTextualData"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Manipulating Notebooks from the Kernel\"\>", 
       2->"\<\"Reading Textual Data\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Record" :> Documentation`HelpLookup["paclet:ref/Record"], 
          "Import" :> Documentation`HelpLookup["paclet:ref/Import"], 
          "StringExpression" :> 
          Documentation`HelpLookup["paclet:ref/StringExpression"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Record\"\>", 2->"\<\"Import\"\>", 
       3->"\<\"StringExpression\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Word", "ObjectName",
 CellID->3297],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["Word",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Word"]], "InlineFormula"],
     "\[LineSeparator]represents a word in ",
     Cell[BoxData[
      ButtonBox["Read",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Read"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      ButtonBox["Find",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Find"]], "InlineFormula"],
     " and related functions. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->5425]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "Words are defined to be sequences of characters that lie between \
separators. The separators are strings given as the settings for ",
 Cell[BoxData[
  ButtonBox["WordSeparators",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/WordSeparators"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["RecordSeparators",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RecordSeparators"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->18962],

Cell[TextData[{
 "With the default setting for ",
 Cell[BoxData[
  ButtonBox["WordSeparators",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/WordSeparators"]], "InlineFormula"],
 ", words are taken to be delimited by whitespace consisting of spaces, tabs \
and newlines. "
}], "Notes",
 CellID->13230]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->563468905],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->61399451],

Cell["Separate into \"words\" delimited by whitespace:", "ExampleText",
 CellID->192792084],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ReadList", "[", 
  RowBox[{
   RowBox[{"StringToStream", "[", "\"\<the cat on the mat.\>\"", "]"}], ",", 
   "Word"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->81051671],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"the\"\>", ",", "\<\"cat\"\>", ",", "\<\"on\"\>", 
   ",", "\<\"the\"\>", ",", "\<\"mat.\"\>"}], "}"}]], "Output",
 ImageSize->{168, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->283468970]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->18175],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Record",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Record"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Import",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Import"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["StringExpression",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/StringExpression"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->17363]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->18704],

Cell[TextData[ButtonBox["Manipulating Notebooks from the Kernel",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ManipulatingNotebooksFromTheKernel"]], "Tutorials",
 CellID->4473],

Cell[TextData[ButtonBox["Reading Textual Data",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ReadingTextualData"]], "Tutorials",
 CellID->24837]
}, Open  ]],

Cell["New in 2", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Word - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 29, 57.6343228}", "context" -> "System`", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Word represents a word in Read, Find and related functions. ", 
    "synonyms" -> {}, "title" -> "Word", "type" -> "Symbol", "uri" -> 
    "ref/Word"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4267, 142, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->563468905]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 8200, 284}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1585, 37, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2208, 64, 41, 1, 70, "ObjectName",
 CellID->3297],
Cell[2252, 67, 693, 23, 70, "Usage",
 CellID->5425]
}, Open  ]],
Cell[CellGroupData[{
Cell[2982, 95, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3460, 112, 463, 14, 70, "Notes",
 CellID->18962],
Cell[3926, 128, 304, 9, 70, "Notes",
 CellID->13230]
}, Closed]],
Cell[CellGroupData[{
Cell[4267, 142, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->563468905],
Cell[CellGroupData[{
Cell[4652, 156, 147, 5, 70, "ExampleSection",
 CellID->61399451],
Cell[4802, 163, 91, 1, 70, "ExampleText",
 CellID->192792084],
Cell[CellGroupData[{
Cell[4918, 168, 201, 6, 28, "Input",
 CellID->81051671],
Cell[5122, 176, 288, 8, 36, "Output",
 CellID->283468970]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[5471, 191, 311, 9, 70, "SeeAlsoSection",
 CellID->18175],
Cell[5785, 202, 704, 26, 70, "SeeAlso",
 CellID->17363]
}, Open  ]],
Cell[CellGroupData[{
Cell[6526, 233, 314, 9, 70, "TutorialsSection",
 CellID->18704],
Cell[6843, 244, 185, 4, 70, "Tutorials",
 CellID->4473],
Cell[7031, 250, 149, 3, 70, "Tutorials",
 CellID->24837]
}, Open  ]],
Cell[7195, 256, 27, 0, 70, "History"],
Cell[7225, 258, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

