(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     16686,        609]
NotebookOptionsPosition[     12924,        480]
NotebookOutlinePosition[     14190,        516]
CellTagsIndexPosition[     14105,        511]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"String Patterns" :> 
          Documentation`HelpLookup["paclet:tutorial/StringPatterns"], 
          "Working with String Patterns" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/WorkingWithStringPatternsOverview"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"String Patterns\"\>", 
       2->"\<\"Working with String Patterns\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"LetterCharacter" :> 
          Documentation`HelpLookup["paclet:ref/LetterCharacter"], 
          "DigitCharacter" :> 
          Documentation`HelpLookup["paclet:ref/DigitCharacter"], 
          "WordBoundary" :> 
          Documentation`HelpLookup["paclet:ref/WordBoundary"], 
          "WhitespaceCharacter" :> 
          Documentation`HelpLookup["paclet:ref/WhitespaceCharacter"], 
          "Except" :> Documentation`HelpLookup["paclet:ref/Except"], 
          "StringExpression" :> 
          Documentation`HelpLookup["paclet:ref/StringExpression"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"LetterCharacter\"\>", 
       2->"\<\"DigitCharacter\"\>", 3->"\<\"WordBoundary\"\>", 
       4->"\<\"WhitespaceCharacter\"\>", 5->"\<\"Except\"\>", 
       6->"\<\"StringExpression\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{
         "String Patterns" :> 
          Documentation`HelpLookup["paclet:guide/StringPatterns"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"String Patterns\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["WordCharacter", "ObjectName",
 CellID->24105],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["WordCharacter",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/WordCharacter"]], "InlineFormula"],
     " \[LineSeparator]represents a letter or digit character in ",
     Cell[BoxData[
      ButtonBox["StringExpression",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/StringExpression"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->6423]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["WordCharacter",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/WordCharacter"]], "InlineFormula"],
 " matches any character for which either ",
 Cell[BoxData[
  ButtonBox["LetterQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LetterQ"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["DigitQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DigitQ"]], "InlineFormula"],
 " yields ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 ".",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->387463941]
}], "Notes",
 CellID->18919]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->668247421],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->560491438],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"StringMatchQ", "[", 
    RowBox[{"#", ",", "WordCharacter"}], "]"}], "&"}], "/@", 
  RowBox[{"{", 
   RowBox[{
   "\"\<a\>\"", ",", "\"\<1\>\"", ",", "\"\<.\>\"", ",", "\"\< \>\""}], 
   "}"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->91217813],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"True", ",", "True", ",", "False", ",", "False"}], "}"}]], "Output",\

 ImageSize->{178, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->776784115]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->222581477],

Cell["Test whether a string ends with a letter or digit character:", \
"ExampleText",
 CellID->241028784],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringMatchQ", "[", 
  RowBox[{"\"\<12343;\>\"", ",", " ", 
   RowBox[{"__", "~~", "WordCharacter"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2131585975],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1633693097]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringMatchQ", "[", 
  RowBox[{"\"\<12343a\>\"", ",", " ", 
   RowBox[{"__", "~~", "WordCharacter"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1448196690],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1599085319]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->497572522],

Cell["Reverse words in a string:", "ExampleText",
 CellID->1374226914],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringReplace", "[", 
  RowBox[{"\"\<1a 2b 3c 4d\>\"", ",", 
   RowBox[{
    RowBox[{"x", ":", 
     RowBox[{"WordCharacter", ".."}]}], "\[RuleDelayed]", 
    RowBox[{"StringReverse", "[", "x", "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1332397295],

Cell[BoxData["\<\"a1 b2 c3 d4\"\>"], "Output",
 ImageSize->{81, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->816614446]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->5037],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["WordCharacter",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/WordCharacter"]], "InlineFormula"],
 " is either ",
 Cell[BoxData[
  ButtonBox["LetterQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LetterQ"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["DigitQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DigitQ"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->387463941],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"StringMatchQ", "[", 
    RowBox[{"#", ",", "WordCharacter"}], "]"}], "&"}], "/@", 
  RowBox[{"{", 
   RowBox[{
   "\"\<a\>\"", ",", "\"\<1\>\"", ",", "\"\<.\>\"", ",", "\"\< \>\""}], 
   "}"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->210338754],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"True", ",", "True", ",", "False", ",", "False"}], "}"}]], "Output",\

 ImageSize->{178, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->225917555]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"LetterQ", "[", "#", "]"}], "||", 
    RowBox[{"DigitQ", "[", "#", "]"}]}], "&"}], "/@", 
  RowBox[{"{", 
   RowBox[{
   "\"\<a\>\"", ",", "\"\<1\>\"", ",", "\"\<.\>\"", ",", "\"\< \>\""}], 
   "}"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->333872666],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"True", ",", "True", ",", "False", ",", "False"}], "}"}]], "Output",\

 ImageSize->{178, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->143488577]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->3062],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["LetterCharacter",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LetterCharacter"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["DigitCharacter",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DigitCharacter"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["WordBoundary",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/WordBoundary"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["WhitespaceCharacter",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/WhitespaceCharacter"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Except",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Except"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["StringExpression",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/StringExpression"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->14981]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->14681],

Cell[TextData[ButtonBox["String Patterns",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/StringPatterns"]], "Tutorials",
 CellID->8153],

Cell[TextData[ButtonBox["Working with String Patterns",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/WorkingWithStringPatternsOverview"]], "Tutorials",
 CellID->22514736]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->549475781],

Cell[TextData[ButtonBox["String Patterns",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/StringPatterns"]], "MoreAbout",
 CellID->227689552]
}, Open  ]],

Cell["New in 5.1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"WordCharacter - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 29, 53.8686014}", "context" -> "System`", 
    "keywords" -> {"digit character", "letter character"}, "index" -> True, 
    "label" -> "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "WordCharacter represents a letter or digit character in \
StringExpression.", "synonyms" -> {"word character"}, "title" -> 
    "WordCharacter", "type" -> "Symbol", "uri" -> "ref/WordCharacter"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5051, 161, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->668247421]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 13962, 504}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2551, 61, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3174, 88, 51, 1, 70, "ObjectName",
 CellID->24105],
Cell[3228, 91, 596, 18, 70, "Usage",
 CellID->6423]
}, Open  ]],
Cell[CellGroupData[{
Cell[3861, 114, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4339, 131, 675, 25, 70, "Notes",
 CellID->18919]
}, Closed]],
Cell[CellGroupData[{
Cell[5051, 161, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->668247421],
Cell[CellGroupData[{
Cell[5436, 175, 148, 5, 70, "ExampleSection",
 CellID->560491438],
Cell[CellGroupData[{
Cell[5609, 184, 294, 10, 28, "Input",
 CellID->91217813],
Cell[5906, 196, 240, 8, 36, "Output",
 CellID->776784115]
}, Open  ]],
Cell[6161, 207, 125, 3, 70, "ExampleDelimiter",
 CellID->222581477],
Cell[6289, 212, 105, 2, 70, "ExampleText",
 CellID->241028784],
Cell[CellGroupData[{
Cell[6419, 218, 188, 5, 28, "Input",
 CellID->2131585975],
Cell[6610, 225, 163, 5, 36, "Output",
 CellID->1633693097]
}, Open  ]],
Cell[CellGroupData[{
Cell[6810, 235, 188, 5, 70, "Input",
 CellID->1448196690],
Cell[7001, 242, 162, 5, 36, "Output",
 CellID->1599085319]
}, Open  ]],
Cell[7178, 250, 125, 3, 70, "ExampleDelimiter",
 CellID->497572522],
Cell[7306, 255, 70, 1, 70, "ExampleText",
 CellID->1374226914],
Cell[CellGroupData[{
Cell[7401, 260, 289, 8, 70, "Input",
 CellID->1332397295],
Cell[7693, 270, 176, 5, 36, "Output",
 CellID->816614446]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7918, 281, 232, 7, 70, "ExampleSection",
 CellID->5037],
Cell[8153, 290, 493, 18, 70, "ExampleText",
 CellID->387463941],
Cell[CellGroupData[{
Cell[8671, 312, 295, 10, 70, "Input",
 CellID->210338754],
Cell[8969, 324, 240, 8, 36, "Output",
 CellID->225917555]
}, Open  ]],
Cell[CellGroupData[{
Cell[9246, 337, 314, 11, 70, "Input",
 CellID->333872666],
Cell[9563, 350, 240, 8, 36, "Output",
 CellID->143488577]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9864, 365, 310, 9, 70, "SeeAlsoSection",
 CellID->3062],
Cell[10177, 376, 1499, 53, 70, "SeeAlso",
 CellID->14981]
}, Open  ]],
Cell[CellGroupData[{
Cell[11713, 434, 314, 9, 70, "TutorialsSection",
 CellID->14681],
Cell[12030, 445, 139, 3, 70, "Tutorials",
 CellID->8153],
Cell[12172, 450, 178, 4, 70, "Tutorials",
 CellID->22514736]
}, Open  ]],
Cell[CellGroupData[{
Cell[12387, 459, 319, 9, 70, "MoreAboutSection",
 CellID->549475781],
Cell[12709, 470, 141, 3, 70, "MoreAbout",
 CellID->227689552]
}, Open  ]],
Cell[12865, 476, 29, 0, 70, "History"],
Cell[12897, 478, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

