(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     10253,        370]
NotebookOptionsPosition[      7435,        278]
NotebookOutlinePosition[      8826,        317]
CellTagsIndexPosition[      8742,        312]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Searching Files" :> 
          Documentation`HelpLookup["paclet:tutorial/SearchingFiles"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Searching Files\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"AnchoredSearch" :> 
          Documentation`HelpLookup["paclet:ref/AnchoredSearch"], "Word" :> 
          Documentation`HelpLookup["paclet:ref/Word"], "WordSeparators" :> 
          Documentation`HelpLookup["paclet:ref/WordSeparators"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"AnchoredSearch\"\>", 
       2->"\<\"Word\"\>", 3->"\<\"WordSeparators\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["WordSearch", "ObjectName",
 CellID->22136],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["WordSearch",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/WordSearch"]], "InlineFormula"],
     "\[LineSeparator]is an option for ",
     Cell[BoxData[
      ButtonBox["Find",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Find"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      ButtonBox["FindList",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/FindList"]], "InlineFormula"],
     " which specifies whether the text searched for must appear as a word. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->28277]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "With the setting ",
 Cell[BoxData[
  RowBox[{"WordSearch", "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 ", the text must appear as a word, delimited by word or record separators, \
as specified by ",
 Cell[BoxData[
  ButtonBox["WordSeparators",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/WordSeparators"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["RecordSeparators",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RecordSeparators"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->32115]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->749162927],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->8079917],

Cell[TextData[{
 "Give all words ",
 Cell[BoxData["\"\<\!\(\*
StyleBox[\"th\", \"TI\"]\)\>\""], "InlineFormula"],
 " in a file:"
}], "ExampleText",
 CellID->81241212],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindList", "[", 
  RowBox[{"\"\<ExampleData/USConstitution.txt\>\"", ",", "\"\<th\>\"", ",", 
   RowBox[{"WordSearch", "->", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1435894292],

Cell[BoxData[
 RowBox[{"{", "}"}]], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->560653456]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->512496298],

Cell[TextData[{
 "Number of words containing ",
 Cell[BoxData["\"\<\!\(\*
StyleBox[\"th\", \"TI\"]\)\>\""], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->1768934239],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"FindList", "[", 
   RowBox[{"\"\<ExampleData/USConstitution.txt\>\"", ",", "\"\<th\>\""}], 
   "]"}], " ", "//", " ", "Length"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->380271435],

Cell[BoxData["515"], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->489636605]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->14109],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["AnchoredSearch",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/AnchoredSearch"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Word",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Word"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["WordSeparators",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/WordSeparators"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->17300]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->14414],

Cell[TextData[ButtonBox["Searching Files",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/SearchingFiles"]], "Tutorials",
 CellID->18987]
}, Open  ]],

Cell["New in 2", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"WordSearch - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 29, 57.8687038}", "context" -> "System`", 
    "keywords" -> {
     "file content search", "finding whole words ", 
      "finding records in files", "finding fields in files"}, "index" -> True,
     "label" -> "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "WordSearch is an option for Find and FindList which specifies whether \
the text searched for must appear as a word. ", 
    "synonyms" -> {"word search", "grep", "sed"}, "title" -> "WordSearch", 
    "type" -> "Symbol", "uri" -> "ref/WordSearch"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[3940, 133, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->749162927]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 8599, 305}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1364, 33, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1987, 60, 48, 1, 70, "ObjectName",
 CellID->22136],
Cell[2038, 63, 759, 23, 70, "Usage",
 CellID->28277]
}, Open  ]],
Cell[CellGroupData[{
Cell[2834, 91, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3312, 108, 591, 20, 70, "Notes",
 CellID->32115]
}, Closed]],
Cell[CellGroupData[{
Cell[3940, 133, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->749162927],
Cell[CellGroupData[{
Cell[4325, 147, 146, 5, 70, "ExampleSection",
 CellID->8079917],
Cell[4474, 154, 166, 6, 70, "ExampleText",
 CellID->81241212],
Cell[CellGroupData[{
Cell[4665, 164, 221, 5, 28, "Input",
 CellID->1435894292],
Cell[4889, 171, 175, 6, 36, "Output",
 CellID->560653456]
}, Open  ]],
Cell[5079, 180, 125, 3, 70, "ExampleDelimiter",
 CellID->512496298],
Cell[5207, 185, 170, 6, 70, "ExampleText",
 CellID->1768934239],
Cell[CellGroupData[{
Cell[5402, 195, 217, 6, 70, "Input",
 CellID->380271435],
Cell[5622, 203, 160, 5, 36, "Output",
 CellID->489636605]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[5843, 215, 311, 9, 70, "SeeAlsoSection",
 CellID->14109],
Cell[6157, 226, 712, 26, 70, "SeeAlso",
 CellID->17300]
}, Open  ]],
Cell[CellGroupData[{
Cell[6906, 257, 314, 9, 70, "TutorialsSection",
 CellID->14414],
Cell[7223, 268, 140, 3, 70, "Tutorials",
 CellID->18987]
}, Open  ]],
Cell[7378, 274, 27, 0, 70, "History"],
Cell[7408, 276, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

