(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8963,        311]
NotebookOptionsPosition[      6884,        246]
NotebookOutlinePosition[      8067,        277]
CellTagsIndexPosition[      8024,        274]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Reading Textual Data" :> 
          Documentation`HelpLookup["paclet:tutorial/ReadingTextualData"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Reading Textual Data\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"RecordSeparators" :> 
          Documentation`HelpLookup["paclet:ref/RecordSeparators"], 
          "TokenWords" :> Documentation`HelpLookup["paclet:ref/TokenWords"], 
          "NullRecords" :> Documentation`HelpLookup["paclet:ref/NullRecords"],
           "Word" :> Documentation`HelpLookup["paclet:ref/Word"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"RecordSeparators\"\>", 
       2->"\<\"TokenWords\"\>", 3->"\<\"NullRecords\"\>", 
       4->"\<\"Word\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["WordSeparators", "ObjectName",
 CellID->822],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["WordSeparators",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/WordSeparators"]], "InlineFormula"],
     "\[LineSeparator]is an option for ",
     Cell[BoxData[
      ButtonBox["Read",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Read"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      ButtonBox["Find",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Find"]], "InlineFormula"],
     " and related functions which specifies the list of strings to be taken \
as delimiters for words. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->431]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The default setting is ",
 Cell[BoxData[
  RowBox[{"WordSeparators", "->", 
   RowBox[{"{", 
    RowBox[{"\"\< \>\"", ",", "\"\<\[Backslash]t\>\""}], "}"}]}]], 
  "InlineFormula"],
 ". "
}], "Notes",
 CellID->30983],

Cell["\<\
Strings used as word separators may contain several characters. \
\>", "Notes",
 CellID->8421],

Cell[TextData[{
 "With the option setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["NullWords",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NullWords"], "->", 
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"]}]], "InlineFormula"],
 ", any number of word separators may appear between any two successive \
words. "
}], "Notes",
 CellID->3341],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"WordSeparators", "->", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["lsep", "TI"], 
        StyleBox["1", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["rsep", "TI"], 
        StyleBox["1", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "}"}]}]], "InlineFormula"],
 " specifies different left and right separators for words. Words must have a \
left separator at the beginning, and a right separator at the end, and cannot \
contain any separators. "
}], "Notes",
 CellID->13565],

Cell["\<\
Strings given as record separators are automatically taken as word \
separators. \
\>", "Notes",
 CellID->28898]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->24190],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["RecordSeparators",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RecordSeparators"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["TokenWords",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TokenWords"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NullRecords",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NullRecords"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Word",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Word"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->29886]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->30535],

Cell[TextData[ButtonBox["Reading Textual Data",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ReadingTextualData"]], "Tutorials",
 CellID->30280]
}, Open  ]],

Cell["New in 2", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"WordSeparators - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 29, 58.2437134}", "context" -> "System`", 
    "keywords" -> {
     "delimiters", "punctuation", "separators", "spaces", "white space"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "WordSeparators is an option for Read, Find and related functions which \
specifies the list of strings to be taken as delimiters for words. ", 
    "synonyms" -> {"word separators"}, "title" -> "WordSeparators", "type" -> 
    "Symbol", "uri" -> "ref/WordSeparators"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1486, 35, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2109, 62, 50, 1, 70, "ObjectName",
 CellID->822],
Cell[2162, 65, 782, 24, 70, "Usage",
 CellID->431]
}, Open  ]],
Cell[CellGroupData[{
Cell[2981, 94, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3459, 111, 233, 9, 70, "Notes",
 CellID->30983],
Cell[3695, 122, 104, 3, 70, "Notes",
 CellID->8421],
Cell[3802, 127, 381, 13, 70, "Notes",
 CellID->3341],
Cell[4186, 142, 688, 21, 70, "Notes",
 CellID->13565],
Cell[4877, 165, 122, 4, 70, "Notes",
 CellID->28898]
}, Closed]],
Cell[CellGroupData[{
Cell[5036, 174, 311, 9, 70, "SeeAlsoSection",
 CellID->24190],
Cell[5350, 185, 959, 35, 70, "SeeAlso",
 CellID->29886]
}, Open  ]],
Cell[CellGroupData[{
Cell[6346, 225, 314, 9, 70, "TutorialsSection",
 CellID->30535],
Cell[6663, 236, 149, 3, 70, "Tutorials",
 CellID->30280]
}, Open  ]],
Cell[6827, 242, 27, 0, 70, "History"],
Cell[6857, 244, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

