(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     23550,        608]
NotebookOptionsPosition[     20900,        518]
NotebookOutlinePosition[     22097,        554]
CellTagsIndexPosition[     22012,        549]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"LightYellow" :> 
          Documentation`HelpLookup["paclet:ref/LightYellow"], "ColorData" :> 
          Documentation`HelpLookup["paclet:ref/ColorData"], "Lighter" :> 
          Documentation`HelpLookup["paclet:ref/Lighter"], "Darker" :> 
          Documentation`HelpLookup["paclet:ref/Darker"], "Hue" :> 
          Documentation`HelpLookup["paclet:ref/Hue"], "RGBColor" :> 
          Documentation`HelpLookup["paclet:ref/RGBColor"], "Style" :> 
          Documentation`HelpLookup["paclet:ref/Style"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"LightYellow\"\>", 2->"\<\"ColorData\"\>", 
       3->"\<\"Lighter\"\>", 4->"\<\"Darker\"\>", 5->"\<\"Hue\"\>", 
       6->"\<\"RGBColor\"\>", 7->"\<\"Style\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Colors" :> Documentation`HelpLookup["paclet:guide/Colors"]}, #,
          2]& , Evaluator -> Automatic], {
       1->"\<\"Colors\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Yellow", "ObjectName",
 CellID->6361],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["Yellow",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Yellow"]], "InlineFormula"],
     "\[LineSeparator]represents the color yellow in graphics or style \
specifications. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->32421]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Yellow",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Yellow"]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["RGBColor",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RGBColor"], "[", 
   RowBox[{"1", ",", "1", ",", "0"}], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->5162]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->106089371],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->96565542],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"{", 
   RowBox[{"Yellow", ",", 
    RowBox[{"Disk", "[", "]"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->511908593],

Cell[BoxData[
 GraphicsBox[
  {RGBColor[1, 1, 0], DiskBox[{0, 0}]}]], "Output",
 ImageSize->{104, 100},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->212482890]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", "Yellow"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->245967023],

Cell[GraphicsData["CompressedBitmap", "\<\
eJylWT1sFEcUHt/ZZx/YQHzn88UE44CTXBJiHAslJjjECCnQRHLpMhZCMkUU
i1C4QKFJlDIdlFdSunTpkpIyJSXllVe+7Hv7vp2Ztz+nOyz5dt/OvO/9v52Z
/eXg2eHj3w6ePXl0sPbg6cHR4ZNHf6z9/PvT5FF9yjn3Mvnf77rknpI7+X9J
lFzzv7PJbz2ZUGOKb0j+XC25/VtmzJmROv9Me9q5GTPjefq4nl74rwZyJA5P
uMVkQrwmeki0TbRL9Mrdn1CbLf5pEg2J9oj2iU6J3hCdER0K+MDdmxD5W502
EJwTHRf0Xcbd/UDch6IruYbSbxX3pyxy7NeGuTJ3Es0XTeU6EbvJ3RWuZSPr
psfe5NtzSu+L+8n9WMm1KYye6z3RWuLpEq4NnfVKXE9uXul/iI75difjYjsw
eyiY792CoXcKZXyjs/4lOuLbC4a+U8h1w2BfNPSdSDMr45Khf6iUkQC+C7kg
o5jra511KulAblHpIxFH7nYl156E33P9R9SLudgezE6i1+Xbtsm/7SjfwjpG
bTeM/K8U4ViC6xGRiyliI1cJswbH9gzgdkVZjwsfbnnveP5cJ0oLLhA7Uu6X
Rv+OsW9T6TOp0MSoMexjEvioOuCjKoH/K1G/Cn+GfC8I5fS8ny5xfXaV7klK
UFhrMj5TgR/iWhpy+qIqZXJQ4RtmfCbKLFzLUJGPQH0nUfeoGE9Rkd3gRm9a
UXpXwuXrEtnfyLhDHb7QWehdK4YGCiytRtmWl4RHGYjsYYaCuDQiS1rJlcOB
zgH7bbYu6XztG/Kspc/a5N/3WTXn9GwFtAskwjorsR1lSl/lxLnT0tC8iCqP
9eAlyxRfC3VpG1p683TmQ/XJkqBj1kBuhqnMQi16Y2qxZGi8jRCDcP3EiJ1I
n7TbnIotiCT6MeTHetaiyHdKpIfxwLy6Rr6vNbaYw+YnvELIS6z2QR4J70nk
M/RYjqOh2V2sCfJ9lB9sftYC+YiC7Rwd8pWA7rCozxY1j5g3fTdA++KaWFev
fUpxD/vcxKIZRe4z4yEU7EA6refGeLNQ9nVj5zWKe9g6xT3sXCUK1ilAQQ9b
N3Q1CmRfM7KBAn+nKFw/fxb59hB5U/X+HZeeNpbYNbipztQlWlVjSp0NUCjN
imyJYeeGdndD38FX8J2NM9YF5ajIcm2J7ipleSa1Z/MMeYg3/rzVj9PZjcp1
oLwWFSmPwoZkKLASKLASKLAyQMl6AettbeoZm1aNTQs570DvVWNXz9i1auxa
KNCItYdGsAw4sAw4sCzACbOPDXBXjHVY66LOPjHWXSjGkrgBC/YBC/UALNjn
seApNTBDghZAQrUDCTuNQKtGXBls5GXDfcOg2/XQxVI0NhNo6GdAs2s0eKEc
jU0FGrLJrguBhlh7NL8r8pZgjYod10bJOCyVl4H0qbI9lq39mrGOEfn9dLPg
eeilVJLsRCr3JrkTIZN/o/YQGMcZwThy64FHsefBnuiNhMjviQ4l4Pk900cT
2gm5Z7qX6xg9No0eHaNHmVzszWwc8a5a03MB7GmRGdjTws/BnrfLK93FCnl5
OXm5do+OPNkyNMb74boyy1js3aYjK30nBDeyAej2zAH1kaLbtQdQ7bkGYn5r
xHirEtWesSCiQMXu357BFKPi1C7K/7rfh35XMo64tzPUWpa15WdOQEN07Hi7
Useyc6/vR4wvFaJaXe0Z3PaI8WrUsvPA2yPGO5E/cTpqzyKjM7yK8U6hjkAt
OxfdURrvGDu+XIn6VhiHGReyfMePR2e4x7rq8Khs+XmKz4eRMXeNhXNKY40g
ZSpPy74X2I5zXhEKzrHFjl0/flI0/rFIbBpU6c9Rp7OdDXIH0k78ufyZnp/f
85mxVzS+MqHceQ3WIPjSMMSXBkG+rzNSyXvxDPkWcXkM2TxBaif7VjKn30oe
6NOT6OmVCe16/kF8eEPg+8Rf8jT/JcpN/Q+6G0J7\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{150, 88},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[2]=",
 CellID->72009867]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{"{", 
   RowBox[{"Yellow", ",", 
    RowBox[{"Sphere", "[", "]"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->82364862],

Cell[BoxData[
 Graphics3DBox[
  {RGBColor[1, 1, 0], SphereBox[{0, 0, 0}]}]], "Output",
 ImageSize->{104, 108},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[3]=",
 CellID->5810565,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->27445],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["LightYellow",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LightYellow"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ColorData",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ColorData"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Lighter",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Lighter"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Darker",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Darker"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Hue",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Hue"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["RGBColor",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RGBColor"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Style",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Style"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->2524]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->413328406],

Cell[TextData[ButtonBox["Colors",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Colors"]], "MoreAbout",
 CellID->302721334]
}, Open  ]],

Cell["New in 5.1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Yellow - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 30, 3.0094604}", "context" -> "System`", 
    "keywords" -> {"color"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Yellow represents the color yellow in graphics or style specifications. \
", "synonyms" -> {}, "title" -> "Yellow", "type" -> "Symbol", "uri" -> 
    "ref/Yellow"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[3715, 122, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->106089371]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 21869, 542}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1677, 37, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2300, 64, 43, 1, 70, "ObjectName",
 CellID->6361],
Cell[2346, 67, 446, 14, 70, "Usage",
 CellID->32421]
}, Open  ]],
Cell[CellGroupData[{
Cell[2829, 86, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3307, 103, 371, 14, 70, "Notes",
 CellID->5162]
}, Closed]],
Cell[CellGroupData[{
Cell[3715, 122, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->106089371],
Cell[CellGroupData[{
Cell[4100, 136, 147, 5, 70, "ExampleSection",
 CellID->96565542],
Cell[CellGroupData[{
Cell[4272, 145, 184, 6, 28, "Input",
 CellID->511908593],
Cell[4459, 153, 263, 8, 121, "Output",
 CellID->212482890]
}, Open  ]],
Cell[CellGroupData[{
Cell[4759, 166, 267, 8, 28, "Input",
 CellID->245967023],
Cell[5029, 176, 2255, 41, 109, "Output",
 Evaluatable->False,
 CellID->72009867]
}, Open  ]],
Cell[CellGroupData[{
Cell[7321, 222, 187, 6, 70, "Input",
 CellID->82364862],
Cell[7511, 230, 10796, 182, 129, 86, 2, "CachedBoxData", "BoxData", "Output",
 CellID->5810565]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[18368, 419, 311, 9, 70, "SeeAlsoSection",
 CellID->27445],
Cell[18682, 430, 1661, 62, 70, "SeeAlso",
 CellID->2524]
}, Open  ]],
Cell[CellGroupData[{
Cell[20380, 497, 319, 9, 70, "MoreAboutSection",
 CellID->413328406],
Cell[20702, 508, 124, 3, 70, "MoreAbout",
 CellID->302721334]
}, Open  ]],
Cell[20841, 514, 29, 0, 70, "History"],
Cell[20873, 516, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

