(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     13206,        463]
NotebookOptionsPosition[     10395,        371]
NotebookOutlinePosition[     11783,        410]
CellTagsIndexPosition[     11698,        405]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"PossibleZeroQ" :> 
         Documentation`HelpLookup["paclet:ref/PossibleZeroQ"], "Eigenvectors" :> 
         Documentation`HelpLookup["paclet:ref/Eigenvectors"], "Inverse" :> 
         Documentation`HelpLookup["paclet:ref/Inverse"], "LinearSolve" :> 
         Documentation`HelpLookup["paclet:ref/LinearSolve"], "MatrixRank" :> 
         Documentation`HelpLookup["paclet:ref/MatrixRank"], "NullSpace" :> 
         Documentation`HelpLookup["paclet:ref/NullSpace"], "RowReduce" :> 
         Documentation`HelpLookup["paclet:ref/RowReduce"]}, #, 2]& , 
       Evaluator -> Automatic], {1->"\<\"PossibleZeroQ\"\>", 
      2->"\<\"Eigenvectors\"\>", 3->"\<\"Inverse\"\>", 
      4->"\<\"LinearSolve\"\>", 5->"\<\"MatrixRank\"\>", 
      6->"\<\"NullSpace\"\>", 7->"\<\"RowReduce\"\>"}, "\<\"see also\"\>", 
      StyleBox["\<\"see also\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["ZeroTest", "ObjectName",
 CellID->30297],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["ZeroTest",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/ZeroTest"]], "InlineFormula"],
     " \[LineSeparator]is an option to various linear algebra functions that \
gives a function to use in testing whether symbolic expressions should be \
treated as zero."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->15962]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"ZeroTest", "->", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 " effectively tests for zeros using a version of ",
 Cell[BoxData[
  ButtonBox["PossibleZeroQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PossibleZeroQ"]], "InlineFormula"],
 "."
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->685266271]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->101171036],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->39281692],

Cell[TextData[{
 "The automatic ",
 Cell[BoxData[
  ButtonBox["ZeroTest",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ZeroTest"]], "InlineFormula"],
 " used by ",
 Cell[BoxData[
  ButtonBox["LinearSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LinearSolve"]], "InlineFormula"],
 " does not detect that ",
 Cell[BoxData[
  StyleBox["mat", "TI"]], "InlineFormula"],
 " is nonsingular:"
}], "ExampleText",
 CellID->408956694],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"mat", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", 
       RowBox[{
        RowBox[{"Sin", "[", 
         RowBox[{"Log", "[", "4", "]"}], "]"}], "-", 
        RowBox[{"Sin", "[", 
         RowBox[{"2", 
          RowBox[{"Log", "[", "2", "]"}]}], "]"}], "+", 
        RowBox[{"10", "^", 
         RowBox[{"-", "100"}]}]}]}], "}"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"LinearSolve", "[", 
  RowBox[{"mat", ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2"}], "}"}]}], "]"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->492241436],

Cell[BoxData[
 RowBox[{
  RowBox[{"LinearSolve", "::", "\<\"nosol\"\>"}], ":", 
  " ", "\<\"Linear equation encountered that has no solution. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/LinearSolve/nosol\\\", \
ButtonNote -> \\\"LinearSolve::nosol\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->568922814],

Cell[BoxData[
 RowBox[{"LinearSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", 
       RowBox[{
        RowBox[{
        "1", "/", 
         "10000000000000000000000000000000000000000000000000000000000000000000\
000000000000000000000000000000000"}], "-", 
        RowBox[{"Sin", "[", 
         RowBox[{"2", " ", 
          RowBox[{"Log", "[", "2", "]"}]}], "]"}], "+", 
        RowBox[{"Sin", "[", 
         RowBox[{"Log", "[", "4", "]"}], "]"}]}]}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2"}], "}"}]}], "]"}]], "Output",
 ImageSize->{571, 67},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->20887141]
}, Open  ]],

Cell[TextData[{
 "With a stronger zero test ",
 Cell[BoxData[
  ButtonBox["LinearSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LinearSolve"]], "InlineFormula"],
 " gives the correct answer:"
}], "ExampleText",
 CellID->458870692],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LinearSolve", "[", 
  RowBox[{"mat", ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2"}], "}"}], ",", 
   RowBox[{"ZeroTest", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"PossibleZeroQ", "[", 
       RowBox[{"Simplify", "[", "#", "]"}], "]"}], "&"}], ")"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->663889172],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", 
   RowBox[{"-", 
    RowBox[{
    "1000000000000000000000000000000000000000000000000000000000000000000000000\
0000000000000000000000000000", "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       RowBox[{
       "1000000000000000000000000000000000000000000000000000000000000000000000\
0000000000000000000000000000000", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"2", " ", 
          RowBox[{"Log", "[", "2", "]"}]}], "]"}]}], "-", 
       RowBox[{
       "1000000000000000000000000000000000000000000000000000000000000000000000\
0000000000000000000000000000000", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"Log", "[", "4", "]"}], "]"}]}]}], ")"}]}]}]}], 
  "}"}]], "Output",
 ImageSize->{574, 118},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->339168292]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"mat", ".", "%"}], "//", "Simplify"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->259108979],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "2"}], "}"}]], "Output",
 ImageSize->{44, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->426295582]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->14332],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["PossibleZeroQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PossibleZeroQ"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Eigenvectors",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Eigenvectors"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Inverse",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Inverse"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["LinearSolve",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LinearSolve"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MatrixRank",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MatrixRank"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NullSpace",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NullSpace"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["RowReduce",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RowReduce"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->24278]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ZeroTest - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 30, 7.6189534}", "context" -> "System`", 
    "keywords" -> {
     "zero recognition", "zero testing", "symbolic linear algebra", 
      "exact linear algebra"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "ZeroTest is an option to various linear algebra functions that gives a \
function to use in testing whether symbolic expressions should be treated as \
zero.", "synonyms" -> {"zero test"}, "title" -> "ZeroTest", "type" -> 
    "Symbol", "uri" -> "ref/ZeroTest"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[3476, 111, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->101171036]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 11555, 398}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1200, 23, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1823, 50, 46, 1, 70, "ObjectName",
 CellID->30297],
Cell[1872, 53, 532, 15, 70, "Usage",
 CellID->15962]
}, Open  ]],
Cell[CellGroupData[{
Cell[2441, 73, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[2919, 90, 520, 16, 70, "Notes",
 CellID->685266271]
}, Closed]],
Cell[CellGroupData[{
Cell[3476, 111, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->101171036],
Cell[CellGroupData[{
Cell[3861, 125, 147, 5, 70, "ExampleSection",
 CellID->39281692],
Cell[4011, 132, 437, 16, 70, "ExampleText",
 CellID->408956694],
Cell[CellGroupData[{
Cell[4473, 152, 678, 23, 70, "Input",
 CellID->492241436],
Cell[5154, 177, 388, 7, 19, "Message",
 CellID->568922814],
Cell[5545, 186, 787, 25, 88, "Output",
 CellID->20887141]
}, Open  ]],
Cell[6347, 214, 240, 8, 70, "ExampleText",
 CellID->458870692],
Cell[CellGroupData[{
Cell[6612, 226, 361, 12, 70, "Input",
 CellID->663889172],
Cell[6976, 240, 898, 26, 139, "Output",
 CellID->339168292]
}, Open  ]],
Cell[CellGroupData[{
Cell[7911, 271, 125, 4, 70, "Input",
 CellID->259108979],
Cell[8039, 277, 203, 7, 36, "Output",
 CellID->426295582]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8303, 291, 311, 9, 70, "SeeAlsoSection",
 CellID->14332],
Cell[8617, 302, 1706, 62, 70, "SeeAlso",
 CellID->24278]
}, Open  ]],
Cell[10338, 367, 27, 0, 70, "History"],
Cell[10368, 369, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

