(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     39444,       1335]
NotebookOptionsPosition[     32015,       1069]
NotebookOutlinePosition[     33420,       1108]
CellTagsIndexPosition[     33334,       1103]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Discrete Distributions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/DiscreteDistributions"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Discrete Distributions\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Zeta" :> Documentation`HelpLookup["paclet:ref/Zeta"], 
          "HarmonicNumber" :> 
          Documentation`HelpLookup["paclet:ref/HarmonicNumber"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Zeta\"\>", 
       2->"\<\"HarmonicNumber\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Discrete Statistical Distributions" :> 
          Documentation`HelpLookup[
           "paclet:guide/DiscreteStatisticalDistributions"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Discrete Statistical Distributions\"\>"}, "\<\"more about\"\>",
        
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["ZipfDistribution", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["ZipfDistribution",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/ZipfDistribution"], "[", 
       StyleBox["\[Rho]", "TR"], "]"}]], "InlineFormula"],
     " \[LineSeparator]represents a Zipf distribution with parameter ",
     Cell[BoxData[
      StyleBox["\[Rho]", "TR"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->27633]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The probability for value ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " in a Zipf distribution is proportional to ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["x", 
    RowBox[{
     RowBox[{"-", "\[Rho]"}], "-", "1"}]], TraditionalForm]], "InlineMath"],
 " if ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " is a positive integer, and is zero otherwise.",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->9425,
  ButtonNote->"9425"]
}], "Notes",
 CellID->272931153],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ZipfDistribution",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ZipfDistribution"]], "InlineFormula"],
 " allows ",
 Cell[BoxData[
  StyleBox["\[Rho]", "TR"]], "InlineFormula"],
 " to be any positive real number."
}], "Notes",
 CellID->10777],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ZipfDistribution",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ZipfDistribution"]], "InlineFormula"],
 " can be used with such functions as ",
 Cell[BoxData[
  ButtonBox["Mean",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Mean"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["CDF",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CDF"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["RandomInteger",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RandomInteger"]], "InlineFormula"],
 ".",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->15726,
  ButtonNote->"15726"]
}], "Notes",
 CellID->33143606]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->297277909],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->778366690],

Cell["Mean and variance of a Zipf distribution:", "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->15726],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Mean", "[", 
  RowBox[{"ZipfDistribution", "[", "\[Rho]", "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2922],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzFVs1KAzEQTptsW+sf4g8iCMWLUAXxInisip58BIWlFdqDuNQeettH6LGP
0GMfwUfoY+xjxPx202TSjdafwG4mk5n5JjOT2X2MB92X13jQa8eNh36cdHvt
98b9W5+xcAkh1GHP6SFiNGWUeDqUslm+MX+T4XD4IUaWZU85H6dpSsVAt+yF
keRHai4jRSA5yowkanYtVACNayHDfZIyuGBd1tYNHgHRIrGVS7l6VyHY0Xyt
nP5/9GjlCHMZ4j8dzHXQ7uzcaHQyR1ccvcMt4Ll7tr1WYcz2vHpVJnQA7j7/
KfdYnXRHzedeKfNcVefkFUuiKdgyHuPxeDKZcHKN5vdNx1fHmwDxi9wMSwJp
bR9m7jvHRBVb36knxceAXcgreWEMZUfK9CZJktFoxMn6YuSorC/wjjpVTSC/
4NpfyA2c07plDdu90chPUURW86TmyNnVVCvAr3r8bHrxiFHzuho36bI70LJs
H/2QlI41dGZ/57wBI677qZ1b2Ia4xZh9Q1XGm6IC2Frtr4MYNYUB5uRX/DxR
0jrL+6DNyLIVbnt57fEezpe7QfZ4DRV2uPBuFoT3je4WcFfPqPHddXC3FuXp
V/oYdrBsvQsQc9uSKuxYAae8zJHIdDpNxZjNZhuOZEhPgvIoz8Krx+w5upYl
vvyzRaVP3N3LXg==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{100, 39},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->605748012]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Variance", "[", 
  RowBox[{"ZipfDistribution", "[", "\[Rho]", "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->23529],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzNWL1uE0EQXnv3zoYESFBsIidAJNKAiCxRIAqgI4iChjewokhJEcVKjOTO
HRKVhUDyI7gCN+l5BD+GSz/Csr++9ezs3R4JMid5f7/53Z2dST52eifHZ53e
6VFn7/1Fp3tyenS5d3h+IZZohRByJX4H20SMuRip3xXnondbKlvW7/d/q282
m/3M1ulgMODqI99FQ4leT0xfJWZA9FcVQ2Z6n0OKUHxVGKmZxtCCedVyd9YY
Ki1RWxnKp/sSIztZzI3Sq5eeXNvDEsPC1uGrnrQf8GysdLaQblbsjuRAF+pB
ft8KfbYVpKsJUBPd/fUfrO4b+zdN/zmIcq2tef5IAaIN+LZRvvd4FpX2FOyp
MMTLiX8P9IBYaqhDOa0P1LKWOhqNxuOxHG7IJoUSvXtq1imiCWaHDkSH2EO1
/ql3XFuzE9lc9hHXUYG+LF4sMsxqPGKXTmF3Rf51PdDtdofDoRzeBygKXi33
JIr0iPWAfX0erMD74cjMj5V6ge0110eeHq0VeDn/DbIvlY22O9zJRo60xs16
xruPUL83iPw8feH9baFcXzso6a1PUVRQl1tg/g5wrQa8E64T7qr5dDodqI+0
ZUN1aMotyC1F8WJu9tc4djdsNVJHd8MVTLI4tfl8viRxMpkYHDO4FMWJea5m
daNZDdiJ1yUfAOow19rbAI3b+dTRQPYNQLVr1pum30BlJoBqDcwrQdn5sfUC
zNcLKWR8U2OH/NNDSsalyxquMN9G5daHMZzcfMWdmIiS8AT1On6iqjYtn18j
XtTHf8d5KcOFKpni/L3P82r2hicpPpcCLRG6R9fgDl/N2Pz1HLWzCbgVZtIS
9chOWd6w2r4xK7c8XEzWDdu8U5oftCeUxZ8F9XeztqWG1cV2AGezO+6dV4DL
ZYZiIjPpDCSS4ksHJ73QU/1blNr9Twyp/AFP4UHU\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 45},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->552208074]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->23627],

Cell["Probability density function:", "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->9425],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PDF", "[", 
  RowBox[{
   RowBox[{"ZipfDistribution", "[", "\[Rho]", "]"}], ",", "k"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->19900],

Cell[BoxData[
 FractionBox[
  SuperscriptBox["k", 
   RowBox[{
    RowBox[{"-", "1"}], "-", "\[Rho]"}]], 
  RowBox[{"Zeta", "[", 
   RowBox[{"1", "+", "\[Rho]"}], "]"}]]], "Output",
 ImageSize->{77, 35},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->679958081]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"PDF", "[", 
      RowBox[{
       RowBox[{"ZipfDistribution", "[", "1.05", "]"}], ",", "k"}], "]"}], ",",
      
     RowBox[{"{", 
      RowBox[{"k", ",", "10"}], "}"}]}], "]"}], ",", 
   RowBox[{"Filling", "\[Rule]", "Axis"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->7975],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWr1v00AUv8RxypgMSB1LW/gjWqoOCJiYqoo5qhDtkBSVTmXnQ6IwIwFD
ofwBRQ0riIEWJBgpQ0EpQwcEokiVEFUId+fn3PP5HPvOH0lJLMX2u/P93u+9
e+/5fMqlyvL8lWpleWGuMnJxqXJtfmHu+siFxSXaZOUIIQ36Wx0m9L5F7/iv
0WrRKz5P0HOBdp1mksWe4QcZp6c8tLMrk1l3HmSLj55Eo4gCZYydCkImipZx
XwvTwQzIsStvOivhjgJr/1gz/CkJ/5TKLh9qXtkTjj6KxlpKhlE4TwRyOhM6
C1HwJwPQcETgq+WJDBxjJyWEbe3WMj1/AHb+Z4Ykucjlo6MmTOAJZf/BwW/o
l8e3ZfpIx/7Dwz8d+3uUn4O//pR5dPXua1JQerXkstzd/c5uyxIrR97f/wUs
ypJWR/60803G84yngymE6HdY3br5EvqpPD314M7tVyBfnn1G+8+fe6jLGrSo
WX/d+xnG2oP3+NE7yor5ruSyojJjVVbK21t7i7XnL+o7iDXLlXImbGdn1oFN
yWVTq3I2MrvhDH36ZO09+NDp33rTqFU3GIvpDFmImZrJUKvwuNCaRDy0cwg8
ezUVm2TPpalFeCodLSuJ+n8lEY54Flnlu5Egqpi1JFHFLAlUE3/e46NhCcEP
S+KXh7UKa7JjcgdtnnUQr8/+Fsyga1qZ+D/Z6H5LZDOPsk2yzYZaUawWwZ6C
dDXLAt3MxFWDrZ/ux0ARVSIOCl9nbNQ3PyKUKP5YM9LZnVH9a0+nKo13CnSz
G9A9ucu/WDpms27F6nUtUWp9r9tgoEVRTd19BbM46u8cHTDrbXvCaihsF8CR
WCXFWiQ5seoQoiO4vom9lfT4i/VNhOrW0qk/4ksoENnGyERhk4xc98VK1JWm
MzIsNtN5asDHlE9QVeAyib6yqisi0EYRKFB1394q5PhrAhUq3rsOYqqqJaZY
uvx4gS7illi2x1j/dCPSj09OHU8+YZVAb30QWA8Qqu5OUGAlMHj/h+Wsik/c
msIxDH0Xf49p8GbvLz6d8lm/1qf/dksD0wYb+VhfPkWtC91bbejlsw024ZlN
LV6/fP4R/JSjsdn8C/Jm+ynG561yjPPvC5L7B4DpkYg=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{225, 141},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->487140022]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->21413],

Cell["\<\
Generate a set of pseudorandom numbers that have a Zipf distribution:\
\>", "ExampleText",
 CellID->19096],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RandomInteger", "[", 
  RowBox[{
   RowBox[{"ZipfDistribution", "[", "1.1", "]"}], ",", "10"}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->17016],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "2", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", 
   ",", "1", ",", "1"}], "}"}]], "Output",
 ImageSize->{189, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->11668315]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->26905],

Cell["Properties based on higher-order moments:", "ExampleText",
 CellID->20699375],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Skewness", "[", 
  RowBox[{"ZipfDistribution", "[", "\[Rho]", "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->7251],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzFGj1vFEd07nbvw/Y5BmQsByTimJCAgn2QD4ICkSKRhCLCNCksASEWQoEC
xQIiOWn8E1y6dBPJRYorXeYPJLFE4y4WlQVEculymM/d2Tdvdnbn9u5W8u58
vO95b97MO99aef7o4ZOV548frMzdfLqy+ujxg2dz3/3ylA1FNUJqHULI97OE
tSlriT/+TLI/2YStiL/jtbW1v8RzcHDA55rpXLS+vi5oUPKGvSIixxvqWyeq
QeRTZ81YfW0KTQTjpYDRklKF4+7XNXVjLEa5NcRUCmXj/VeEdyPpK6FHz73R
t4U5TOzWDh+1uP0P10ZzjxPuakTPcApRIh6k98prs2knXosBzaCz/NUawkxX
9Hd3d1X/GdeZRdR9FHpR9Pf39yUC+VX0d3Z21Py9HKytrS3VP63selx9vxXz
29vbR0dH5aiYVm5Z69AEEDdEnzFhm4abz4LoMxNItQTdGHiD9o4YWe2G7Y+y
QTS2Cf0N0OpujkxMbGb6RNcmpG9FhxqPEL6Y1DL8DWQL6kOwcmNB0rezK0Vl
dKE7lBXTMaYHHvkZXzgP8Pze0grSbQxQiWCuMTzItyZFddP7E8+Og/PUMHv4
7dz2WKFlWsuyxhQdTSSEWyM24kev1CQ1spvBZTJrPTqMSAmL6c8Bt3dAfxhx
ECb5ZwY3otaiQo/t22egZeG6clfN86kwq0idWZpfFw/p8ldjY2MjswYxCpWc
JtjD+JIf3RzjhKPSQoAdHh5yQpf4K+r1eppb4vsSIOXI+kU5GjpeB5a8GmSp
95Wd9aofA1Rn1fiM+jaDueR75QXQ73gx4iBJOrRAlimUUaaLUAKeXi5nhWsY
kFMK7FAzYZQzGcCVyf05C7eGhNrc3GQHcN5cBNboJwcB6RG8k31Qh2etonlC
xoFUF9oB3jfSe0DpjFbi5HaiLG0rq/RvhQag84NhldXVVbn1q/ti6kMTDrrp
CJYt3TY6UZoe1N+VfaUvJrc/B1Rdrchtiu0U8A7KtTdzr+YNc/SUA07naGl7
mekSWfFoMqjmyZje0bsAS96CEyPgp62c/hLKtQuoLhhYXHbJlYkkq3UFz6w4
r58A1E3AS1BBdtlPAN4plPqfAApfi08L0XoFJEvzf4rJdzF3daml7abOOy/E
mSg5h8n4s6TTFbU2OovXxSSn9GT1wjh9uTm1Fadx9q2xb41/UfqvcyXtBOLD
XWucGnFt0ThDs/WL66D/s1qLk15pzgC+/nvul6UxfiuxetyLBnf3PzdQ6r/T
vAgQWX4EN/xzI+J7jWZ98hJqFe7nI6mhDZnnVwDPHzWLqL0mANSw6nKc3gcj
4s3R5ukgIxe39Zh3jUIrKLD/XrWcLLuKlRvBHuC2a5nq4VxJ+PmsNekw4hvf
3a4CardA/yzoDyOicEmvGNQ43hLoz1t0qooF3Ee+AFBLoP8u6Puqh7jWUmZ2
Kv1aPKTLX9Hy8rKab4L5O/wVp78TGpXDDIUU4jzKl0fAZXbJINHe3p4ai5Vt
7olxdr9TPqCj8bIez6X8B7DLfRTqI5q9vy3SbG3vFJiHp1NYC1xwcsn3mYug
76/1zXoh4InWT/NjVHqeaSO1wtXUCY8Z1hxsvTCqTOay5/EmNc7AhTi4rW/t
1gOpZU4DTvUwThXVNqOB6TlRkV46P2lbFdMLX+UOgIotjsUzt79Ge7xCbn3V
bAemYT+3qVCN8L0frizMIN6TTol7yRSmX+CpKrQKDfGq0G9yBHrgq2nuxkTv
GeHV8pyb0HjfnMrV0avQofw90ZznWrYdlIvtmjrb+6r3RfHMaj42D38tgNpN
UOtUGPd6PVmPZUflKwD+bwF3DdjkX/GFv23/I0Z5U/4PLam9Bbt4Emk=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{268, 75},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->742421088]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Kurtosis", "[", 
  RowBox[{"ZipfDistribution", "[", "\[Rho]", "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->27703],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzVWktvEzEQdrKPbF+gClSqSoiqFKS2SKgXLkhwgxM/IqoKDRIiKj30ln9A
ufVckMixP4FDEY8DyhmJI5Bjf8Ky9tqJMx6vH5tNwkrZXdsz3zz8WM84z5pH
B/uvmketveb608Nm+6C192b9yevDrCqoEVKPCSG7qyR7T7M39hNXkv2GRawU
0Ht4fHz8iV39fl+014btQafTySsZ99/sF5C8LeLPOuEvJL/q2WvInypKjHDQ
hl+MbmAB59OX60KCVBeiEiPWNKRS+ejtp438SPYwmRkNorF4m9KFeivxWnSU
9AF6XWgRDrTgNaKFogQDNTHM30YfXi/kbWSEK1oKeuntmUbrB2DdW1D+jnK9
B1TvQPnbGLnOANWNNO/LBn9u8OcKf67x5zJ/RoD/q7WU0XEQA4p1UF40cqyC
csPIAeemne7yyihGvZgFgxUzkuUyLjEvJKQFGySJnvo6cpIQuEpwRlf9l2Oe
np52u90UGZesPYb4yqrF6wfrCb5yjfRvwq3Ku14RYJIQyhJ03skHvAShUAV+
9kEP+cnV9IZ+lVAtDxBs/IsCeBG+xRLoc5hXLEZBXEJm6CkTXwVzme12++Tk
BPM9lBYMnJpf8oy1nQPiGwy9Z8SGK6eHFyCfi0zYP+U8b7OGF38bEoRD3w9z
znjQV40U94s6x2w0tUb2/vqJ779Ah2M51tAtpcN9g9xeR9rhWPpspeFdUG4p
HvyC4sDZuSmVaR+3DH6+sEK9A8oHBtSPoLyGSjHtM2VUakvXCpXeHhboI+Y0
HJF0X0OLeASaj/xer9dhF0mz2w/6QuskBHWWiTiIflVqHL9IxuXlpSIjqyuU
kXAZVFastYHe/hTqmKCt+hgCR4OzQF1ncMStdHTWbaf4Ll6030pHd/WbBnoY
BdzW0C9L9dSMa5I9en9sKVaa1ryboGwZLRRSQExzPLFRgRbuUQ30zYqfVk4y
t6Wyvl/h2l8+gkpGNXPBrz6usragugiN9pyIMFykxBLfpD1SbcyqjhhXvyAZ
tqlZsyOhqfNNjC10r11ZBM6i1VDBdZc33Xjcwtp5P2S/SF/xxph6VcEVEZvA
nLaXo0l6Gcx1RjmmbJKsFeOv0q+lrb+fYivKFUAVKpaOM3vE1uoG4OPc4DTG
SfI0Mktma+dKoPvmrcQXokw/zqY3y1jk6815jO8/8qqv3bsptlZcxWSCjE7Z
bGeYSvtUJQ4ok4+cWA7UIaernF852OObX5WjSVJSh1ny6TRy1aIflZlQQhc8
z2ReH7H86iTsp3j3Umy9WJJQCVG+ScjYK8zRF/gX4rhLqjZ7rx/HsReejaYj
eXwnCXI71THRSCjpi9JIWi8oXp6fMR9YjzSpzHKoxv27yE7AUxpRL+wINXS6
0xzdqRCUB099sB2UTA+9s2CQbzplgvo1POWZcLeHvRGen5/npxK9Xu8BGDcv
AN8FKL9Ee/kRl/ocoF2AcguUd9jzMcDcN+gAz8Fy21J+5f9KJLV/Eu8N0Q==
\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{518, 49},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->86244654]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->4452],

Cell["Second moment of a Zipf distribution:", "ExampleText",
 CellID->22255],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExpectedValue", "[", 
  RowBox[{
   RowBox[{"k", "^", "2"}], ",", 
   RowBox[{"ZipfDistribution", "[", "\[Rho]", "]"}], ",", "k"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->14684],

Cell[BoxData[
 FractionBox[
  RowBox[{"Zeta", "[", 
   RowBox[{
    RowBox[{"-", "1"}], "+", "\[Rho]"}], "]"}], 
  RowBox[{"Zeta", "[", 
   RowBox[{"1", "+", "\[Rho]"}], "]"}]]], "Output",
 ImageSize->{85, 32},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->31066785]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->14668],

Cell["\<\
Plot the cumulative distribution function of a Zipf distribution:\
\>", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->13370],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"CDF", "[", 
    RowBox[{
     RowBox[{"ZipfDistribution", "[", "1.5", "]"}], ",", "k"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"k", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->26124],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzzTSzJSM1NLMlMTlRwL0osyMhMLlZwyy8CCjEzMjAwPATiyRIMQPZ/IAuM
H/7/D6QxSTMgyQJUoAbiMYNUggGDKpBggoqDaBAfJM0E5TODdZsj6WLAYooK
iGBB8BmwiKhiiIDsAHmDEUSDhSzQzFWGuhpTL3nmW6KZr4TNXximMmGVIWy6
MpJeZqwuJMbNZjjdpE4wFogx3xyHacgpAplmRkkZAmi6zlFJlAdIXoG6E0nN
+XNPgYiBHURg40PNYEczkwONjy5PbT6t7aPUfOxxh65KhsquRi81KDWPkPuw
+9KPgKvQ5amZzkH55jwVzRuJdkMjBAyYkVSA+UDMgl0XSinIiqaPGD1saGpA
doO42NSip0QmIswnRw/Y3ZgieMOMDRofrFhVjtRUNahSNCtcBVQCe1wRTp/E
pB8WKI0rLSOnKGLdwvofXxojSS1S2GAt34dIehl8LqJHmQxiEpsOiC7LiNCF
Ny2TZQczCakZWQ3h8pgdGhfYVQ7OtDNYXCQI5u/dcyc/bzMQMQiBCBAfKr8U
xW1CYNU/f/6B9hqEwL0GIB9D9cjIDaSU0tR0D23aJ9RJfeAeMyhNLF1yfv68
MwxCIIIZmFCg8hPx6Pr8+SdQNULX4UP38eqito+swPzt225AXSEIdsXqVZeg
8rVU1IXdBZC+EzC0UMLh+fNPUPkMFL/5g1XfvvUGRTUwFDFUI9uRBOY/fPge
Jc8j3BuCVVcymH/1ygto3hcA5/3Tpx6Xl21HmFJdtRNSHDA4/EckVxhAb5Fj
S6XlMNdB7REE2zOh/4i97UwgYhAEEcwujnOAQgg/b1h3BUU9UD/UPEjGQLcZ
LIo3X81HS5GQWJ0542Re7iaEf3t7DlNozzkS9CHKIdraQ1z5cg0shDlSysAI
ACWEie4=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{225, 147},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->492404]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->96317017],

Cell["\<\
The density functions of Zipf variables are highest for small positive \
integers:\
\>", "ExampleText",
 CellID->24052],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"PDF", "[", 
     RowBox[{
      RowBox[{"ZipfDistribution", "[", "\[Rho]", "]"}], ",", "k"}], "]"}], 
    ",", 
    RowBox[{"{", 
     RowBox[{"k", ",", "1", ",", "12"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"\[Rho]", ",", "1", ",", "2", ",", 
      RowBox[{"1", "/", "12"}]}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->28041],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztmrtOAkEUhhfXhILmnILEUO0UbkchoaQiRCsbLaw3xAQKo0EKH8FX8RV8
CrkENksWQs39fkcPSGWsjDfgn2QmJ/N//1dONedWOnF9Y6WTccs4S1l3iWT8
3ji9TcmV7tE0rSr75UiT+VWm9V5dydJX83pprhyeH7g9kEMtl8tnpDubhiR9
Qrqn6aWkj0h3NlWLxSIqxAMIEF8iQkJcCHEFAsRnxHw+PxFq9Q4dgwL1JxRP
p1M1m82U0NHNm3YIGvR+0uPxWE0mE/WhhQYaaEij3++rwWBAw+GQR6OREgNt
DCExoIkmmlvZrNVqVK/XudFoULPZ5FarRe12mzudDnW7Xe71ekrsJHYWO0ww
wQTTb5lUJpPhbDZLuVyO8/k8FQoFLhaLZNs2O45DpVKJXdelcrnMlUoFJphg
gmn7TByLxSgSiXA4HKZgMMimaZJhGBwIBMjv9zPJ8vl87PV6Sdd1ljpssMEG
23+3fed/q+p75nkDjnhCBg==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{225, 208},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->101513381]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->3526],

Cell["\<\
The probability of getting any real number except a positive integer is zero:\
\
\>", "ExampleText",
 CellID->1627],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PDF", "[", 
  RowBox[{
   RowBox[{"ZipfDistribution", "[", "\[Rho]", "]"}], ",", "\[Pi]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->17831],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->73967350]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->332729216],

Cell["\<\
The probability mass and random variable have a power law relationship:\
\>", "ExampleText",
 CellID->63892748],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PDF", "[", 
  RowBox[{
   RowBox[{"ZipfDistribution", "[", "\[Rho]", "]"}], ",", "k"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->419416617],

Cell[BoxData[
 FractionBox[
  SuperscriptBox["k", 
   RowBox[{
    RowBox[{"-", "1"}], "-", "\[Rho]"}]], 
  RowBox[{"Zeta", "[", 
   RowBox[{"1", "+", "\[Rho]"}], "]"}]]], "Output",
 ImageSize->{77, 35},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->492016872]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"constant", "=", 
   RowBox[{"1", "/", 
    RowBox[{"Zeta", "[", 
     RowBox[{"1", "+", "\[Rho]"}], "]"}]}]}], ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->506624372],

Cell[BoxData[
 RowBox[{
  RowBox[{"power", "=", 
   RowBox[{
    RowBox[{"-", "1"}], "-", "\[Rho]"}]}], ";"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->245467550],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"constant", " ", 
  RowBox[{"k", "^", "power"}]}]], "Input",
 CellLabel->"In[4]:=",
 CellID->77871665],

Cell[BoxData[
 FractionBox[
  SuperscriptBox["k", 
   RowBox[{
    RowBox[{"-", "1"}], "-", "\[Rho]"}]], 
  RowBox[{"Zeta", "[", 
   RowBox[{"1", "+", "\[Rho]"}], "]"}]]], "Output",
 ImageSize->{77, 35},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->74788448]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->32679],

Cell["Moments can be obtained from the characteristic function:", \
"ExampleText",
 CellID->3912],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ev", "=", 
  RowBox[{"ExpectedValue", "[", 
   RowBox[{
    RowBox[{"k", "^", "4"}], ",", 
    RowBox[{"ZipfDistribution", "[", "\[Rho]", "]"}], ",", "k"}], 
   "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->21100],

Cell[BoxData[
 FractionBox[
  RowBox[{"Zeta", "[", 
   RowBox[{
    RowBox[{"-", "3"}], "+", "\[Rho]"}], "]"}], 
  RowBox[{"Zeta", "[", 
   RowBox[{"1", "+", "\[Rho]"}], "]"}]]], "Output",
 ImageSize->{85, 32},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->577174354]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"cf", "=", 
  RowBox[{"CharacteristicFunction", "[", 
   RowBox[{
    RowBox[{"ZipfDistribution", "[", "\[Rho]", "]"}], ",", "t"}], 
   "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->37408578],

Cell[BoxData[
 FractionBox[
  RowBox[{"PolyLog", "[", 
   RowBox[{
    RowBox[{"1", "+", "\[Rho]"}], ",", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"\[ImaginaryI]", " ", "t"}]]}], "]"}], 
  RowBox[{"Zeta", "[", 
   RowBox[{"1", "+", "\[Rho]"}], "]"}]]], "Output",
 ImageSize->{129, 38},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->20432383]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{
   RowBox[{"D", "[", 
    RowBox[{"cf", ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "4"}], "}"}]}], "]"}], ",", 
   RowBox[{"t", "->", "0"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->10909],

Cell[BoxData[
 FractionBox[
  RowBox[{"Conjugate", "[", 
   RowBox[{"PolyLog", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "3"}], "+", "\[Rho]"}], ",", "1"}], "]"}], "]"}], 
  RowBox[{"Zeta", "[", 
   RowBox[{"1", "+", "\[Rho]"}], "]"}]]], "Output",
 ImageSize->{201, 32},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->287995337]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{
   RowBox[{"%", "\[Equal]", "ev"}], ",", 
   RowBox[{"Assumptions", "\[Rule]", 
    RowBox[{"\[Rho]", ">", "4"}]}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->332411454],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->592693293]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->23386],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ZipfDistribution",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ZipfDistribution"]], "InlineFormula"],
 " is not defined when ",
 Cell[BoxData[
  StyleBox["\[Rho]", "TR"]], "InlineFormula"],
 " is non-positive:"
}], "ExampleText",
 CellID->28540],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Mean", "[", 
  RowBox[{"ZipfDistribution", "[", "0", "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->31597],

Cell[BoxData[
 RowBox[{
  RowBox[{"ZipfDistribution", "::", "\<\"posparm\"\>"}], ":", 
  " ", "\<\"Parameter \\!\\(0\\) is expected to be positive.\"\>"}]], \
"Message", "MSG",
 CellID->679862979],

Cell[BoxData[
 RowBox[{"Mean", "[", 
  RowBox[{"ZipfDistribution", "[", "0", "]"}], "]"}]], "Output",
 ImageSize->{179, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->2226748]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->19046],

Cell["\<\
Substitution of invalid parameters into symbolic outputs gives results that \
are not meaningful:\
\>", "ExampleText",
 CellID->16727],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Mean", "[", 
   RowBox[{"ZipfDistribution", "[", "\[Rho]", "]"}], "]"}], "/.", 
  RowBox[{"{", 
   RowBox[{"\[Rho]", "\[Rule]", 
    RowBox[{"3", "+", "I"}]}], "}"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->25838],

Cell[BoxData[
 RowBox[{
  RowBox[{"Greater", "::", "\<\"nord\"\>"}], ":", 
  " ", "\<\"Invalid comparison with \\!\\(3 + \[ImaginaryI]\\) attempted. \\!\
\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/General/nord\\\", \
ButtonNote -> \\\"Greater::nord\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->170162469],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzFV81OAjEQLvvDAhIJeBAPJiQkJurdxJNBDZ58CEJM4GAkwAFO+wgceQSO
PIKPwGPwGLXTdtkyO0srJtJk+zNtZ7756Qy896aDj8/edNjvtd7GvdFg2J+0
ul9jQfILjLG5+O6bTMy5mMlvzrkYzd6HPpjNZt+ybbfbZ0HxmdoJ9egxPWGq
eWIaiPEy5eHHccxlY0XixqM8AxjUGd+y9rQUk3ZFSgulBump7L0HF9nhbq1B
n156+GcLw5kgX7sMlZb2in2TSA920jUl2QEOcKFJ8utYbXabey+CoCZ3J/9K
vdaa1vXYyT1l6lVH6yenW5FlTXMpcfVGTZ8kPgoIm3vaZ96+d3iaDbIyFY/l
crlarWBahq5oelb1KAY1neJrrmWI5SDNw5LqXyH1wHfp1+EfsJErktFotFgs
YHqGdcTZ1PCOJEcIj4Hq92iouNh/fUV0r0TwBWwRNzKKc/zhmMdaYOvQ3PCb
qB6lu9urfeEqVrAdQG9wTYjoYJekUma5QT3NRhh+w6YPmJYNCMuU9TIyFDdR
v3VE3clwEWu9XyO4hMjzcKXCU0/bpXbRKWyXv+mEfdXQI/YKloKxu0s7lKkb
aF3VFrw4irsto59zKmZunGQ55f29vLh709asX9N0bI3ER2EuolNVBYylTOrp
VhVw3juuOmBEFayrrTpYfzvacNI4HOtCTm1yqA3Ber2OZdtsNnCeqg4YK87z
il/bcorWuM2p7K/+B7HCD0CyBHQ=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{121, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->925649893]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->20017],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Zeta",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Zeta"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["HarmonicNumber",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/HarmonicNumber"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->30402]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->20278],

Cell[TextData[ButtonBox["Discrete Distributions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/DiscreteDistributions"]], "Tutorials",
 CellID->4738]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Discrete Statistical Distributions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DiscreteStatisticalDistributions"]], "MoreAbout",
 CellID->96426050]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ZipfDistribution - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 30, 10.3846492}", "context" -> "System`", 
    "keywords" -> {
     "power law", "power-law distribution", "power law distribution", 
      "zeta distribution", "Zipf-Estoup law", "Zipf Estoup law", 
      "Zipf's law"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "ZipfDistribution[\\[Rho]] represents a Zipf distribution with parameter \
\\[Rho].", "synonyms" -> {"zipf distribution"}, "title" -> "ZipfDistribution",
     "type" -> "Symbol", "uri" -> "ref/ZipfDistribution"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6805, 220, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->297277909]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 33191, 1096}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1916, 50, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2539, 77, 1581, 37, 70, "ObjectNameGrid"],
Cell[4123, 116, 590, 18, 70, "Usage",
 CellID->27633]
}, Open  ]],
Cell[CellGroupData[{
Cell[4750, 139, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5228, 156, 544, 19, 70, "Notes",
 CellID->272931153],
Cell[5775, 177, 290, 10, 70, "Notes",
 CellID->10777],
Cell[6068, 189, 700, 26, 70, "Notes",
 CellID->33143606]
}, Closed]],
Cell[CellGroupData[{
Cell[6805, 220, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->297277909],
Cell[CellGroupData[{
Cell[7190, 234, 148, 5, 70, "ExampleSection",
 CellID->778366690],
Cell[7341, 241, 128, 2, 70, "ExampleText",
 CellID->15726],
Cell[CellGroupData[{
Cell[7494, 247, 143, 4, 28, "Input",
 CellID->2922],
Cell[7640, 253, 899, 19, 60, "Output",
 Evaluatable->False,
 CellID->605748012]
}, Open  ]],
Cell[CellGroupData[{
Cell[8576, 277, 148, 4, 28, "Input",
 CellID->23529],
Cell[8727, 283, 1167, 23, 66, "Output",
 Evaluatable->False,
 CellID->552208074]
}, Open  ]],
Cell[9909, 309, 121, 3, 70, "ExampleDelimiter",
 CellID->23627],
Cell[10033, 314, 115, 2, 70, "ExampleText",
 CellID->9425],
Cell[CellGroupData[{
Cell[10173, 320, 170, 6, 70, "Input",
 CellID->19900],
Cell[10346, 328, 311, 11, 56, "Output",
 CellID->679958081]
}, Open  ]],
Cell[CellGroupData[{
Cell[10694, 344, 390, 13, 28, "Input",
 CellID->7975],
Cell[11087, 359, 1355, 26, 162, "Output",
 Evaluatable->False,
 CellID->487140022]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[12491, 391, 216, 7, 70, "ExampleSection",
 CellID->21413],
Cell[12710, 400, 116, 3, 70, "ExampleText",
 CellID->19096],
Cell[CellGroupData[{
Cell[12851, 407, 177, 6, 70, "Input",
 CellID->17016],
Cell[13031, 415, 290, 9, 36, "Output",
 CellID->11668315]
}, Open  ]],
Cell[13336, 427, 121, 3, 70, "ExampleDelimiter",
 CellID->26905],
Cell[13460, 432, 83, 1, 70, "ExampleText",
 CellID->20699375],
Cell[CellGroupData[{
Cell[13568, 437, 147, 4, 70, "Input",
 CellID->7251],
Cell[13718, 443, 2098, 38, 70, "Output",
 Evaluatable->False,
 CellID->742421088]
}, Open  ]],
Cell[CellGroupData[{
Cell[15853, 486, 148, 4, 70, "Input",
 CellID->27703],
Cell[16004, 492, 1736, 33, 70, "Output",
 Evaluatable->False,
 CellID->86244654]
}, Open  ]],
Cell[17755, 528, 120, 3, 70, "ExampleDelimiter",
 CellID->4452],
Cell[17878, 533, 76, 1, 70, "ExampleText",
 CellID->22255],
Cell[CellGroupData[{
Cell[17979, 538, 214, 7, 70, "Input",
 CellID->14684],
Cell[18196, 547, 317, 11, 53, "Output",
 CellID->31066785]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[18562, 564, 223, 7, 70, "ExampleSection",
 CellID->14668],
Cell[18788, 573, 249, 7, 70, "ExampleText",
 CellID->13370],
Cell[CellGroupData[{
Cell[19062, 584, 333, 10, 70, "Input",
 CellID->26124],
Cell[19398, 596, 1133, 23, 70, "Output",
 Evaluatable->False,
 CellID->492404]
}, Open  ]],
Cell[20546, 622, 124, 3, 70, "ExampleDelimiter",
 CellID->96317017],
Cell[20673, 627, 129, 4, 70, "ExampleText",
 CellID->24052],
Cell[CellGroupData[{
Cell[20827, 635, 448, 14, 70, "Input",
 CellID->28041],
Cell[21278, 651, 725, 16, 70, "Output",
 Evaluatable->False,
 CellID->101513381]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[22052, 673, 232, 7, 70, "ExampleSection",
 CellID->3526],
Cell[22287, 682, 125, 4, 70, "ExampleText",
 CellID->1627],
Cell[CellGroupData[{
Cell[22437, 690, 174, 6, 70, "Input",
 CellID->17831],
Cell[22614, 698, 157, 5, 36, "Output",
 CellID->73967350]
}, Open  ]],
Cell[22786, 706, 125, 3, 70, "ExampleDelimiter",
 CellID->332729216],
Cell[22914, 711, 121, 3, 70, "ExampleText",
 CellID->63892748],
Cell[CellGroupData[{
Cell[23060, 718, 174, 6, 70, "Input",
 CellID->419416617],
Cell[23237, 726, 311, 11, 56, "Output",
 CellID->492016872]
}, Open  ]],
Cell[23563, 740, 205, 7, 70, "Input",
 CellID->506624372],
Cell[23771, 749, 163, 6, 70, "Input",
 CellID->245467550],
Cell[CellGroupData[{
Cell[23959, 759, 125, 4, 70, "Input",
 CellID->77871665],
Cell[24087, 765, 310, 11, 56, "Output",
 CellID->74788448]
}, Open  ]],
Cell[24412, 779, 121, 3, 70, "ExampleDelimiter",
 CellID->32679],
Cell[24536, 784, 97, 2, 70, "ExampleText",
 CellID->3912],
Cell[CellGroupData[{
Cell[24658, 790, 242, 8, 70, "Input",
 CellID->21100],
Cell[24903, 800, 318, 11, 53, "Output",
 CellID->577174354]
}, Open  ]],
Cell[CellGroupData[{
Cell[25258, 816, 219, 7, 70, "Input",
 CellID->37408578],
Cell[25480, 825, 404, 13, 59, "Output",
 CellID->20432383]
}, Open  ]],
Cell[CellGroupData[{
Cell[25921, 843, 253, 9, 70, "Input",
 CellID->10909],
Cell[26177, 854, 388, 13, 53, "Output",
 CellID->287995337]
}, Open  ]],
Cell[CellGroupData[{
Cell[26602, 872, 233, 7, 70, "Input",
 CellID->332411454],
Cell[26838, 881, 161, 5, 36, "Output",
 CellID->592693293]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[27048, 892, 226, 7, 70, "ExampleSection",
 CellID->23386],
Cell[27277, 901, 294, 10, 70, "ExampleText",
 CellID->28540],
Cell[CellGroupData[{
Cell[27596, 915, 139, 4, 70, "Input",
 CellID->31597],
Cell[27738, 921, 196, 5, 70, "Message",
 CellID->679862979],
Cell[27937, 928, 230, 7, 36, "Output",
 CellID->2226748]
}, Open  ]],
Cell[28182, 938, 121, 3, 70, "ExampleDelimiter",
 CellID->19046],
Cell[28306, 943, 144, 4, 70, "ExampleText",
 CellID->16727],
Cell[CellGroupData[{
Cell[28475, 951, 252, 8, 70, "Input",
 CellID->25838],
Cell[28730, 961, 385, 7, 70, "Message",
 CellID->170162469],
Cell[29118, 970, 972, 20, 70, "Output",
 Evaluatable->False,
 CellID->925649893]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[30151, 997, 311, 9, 70, "SeeAlsoSection",
 CellID->20017],
Cell[30465, 1008, 455, 17, 70, "SeeAlso",
 CellID->30402]
}, Open  ]],
Cell[CellGroupData[{
Cell[30957, 1030, 314, 9, 70, "TutorialsSection",
 CellID->20278],
Cell[31274, 1041, 153, 3, 70, "Tutorials",
 CellID->4738]
}, Open  ]],
Cell[CellGroupData[{
Cell[31464, 1049, 299, 8, 70, "MoreAboutSection"],
Cell[31766, 1059, 177, 3, 70, "MoreAbout",
 CellID->96426050]
}, Open  ]],
Cell[31958, 1065, 27, 0, 70, "History"],
Cell[31988, 1067, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

