(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    141430,       4500]
NotebookOptionsPosition[    123326,       3891]
NotebookOutlinePosition[    125265,       3936]
CellTagsIndexPosition[    125222,       3933]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Introduction to Dynamic" :> 
          Documentation`HelpLookup["paclet:tutorial/IntroductionToDynamic"], 
          "Introduction to Manipulate" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/IntroductionToManipulate"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Introduction to Dynamic\"\>", 
       2->"\<\"Introduction to Manipulate\"\>"}, "\<\"related tutorials\"\>", 
       
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Dynamic Interactivity Language" :> 
          Documentation`HelpLookup[
           "paclet:guide/DynamicInteractivityLanguage"], 
          "Dynamic Visualization" :> 
          Documentation`HelpLookup["paclet:guide/DynamicVisualization"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Dynamic Interactivity Language\"\>", 
       2->"\<\"Dynamic Visualization\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Advanced Dynamic Functionality", "Title",
 CellID->1545190458],

Cell[TextData[{
 ButtonBox["Introduction to Manipulate",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/IntroductionToManipulate"],
 " and ",
 ButtonBox["Introduction to Dynamic",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/IntroductionToDynamic"],
 " provide most information you need to use ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " interactive features accessible through the functions ",
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Dynamic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dynamic"]], "InlineFormula"],
 ", and ",
 Cell[BoxData[
  ButtonBox["DynamicModule",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DynamicModule"]], "InlineFormula"],
 ". This tutorial gives further details on the workings of ",
 Cell[BoxData[
  ButtonBox["Dynamic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dynamic"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["DynamicModule",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DynamicModule"]], "InlineFormula"],
 " and describes advanced features and techniques for achieving maximum \
performance for complex interactive examples."
}], "Text",
 CellID->1665666328],

Cell[TextData[{
 "Many examples in this tutorial display a single output value and use ",
 Cell[BoxData[
  ButtonBox["Pause",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Pause"]], "InlineFormula"],
 " to simulate slow calculations. In real life, you will be instead doing \
useful computations and displaying sophisticated graphics or large tables of \
values."
}], "Text",
 CellID->1867840383],

Cell[TextData[{
 "Please note that this is a ",
 StyleBox["hands-on",
  FontSlant->"Italic"],
 " tutorial. You are expected to actually evaluate each of the input lines as \
you reach them in your reading, and watch what happens. The accompanying text \
will not make sense without evaluating as you read."
}], "TextEmphasisNote",
 CellID->244159640],

Cell[CellGroupData[{

Cell["Module versus DynamicModule", "Section",
 CellID->877365235],

Cell["", "Text",
 CellID->971583106],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Module",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Module"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["DynamicModule",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DynamicModule"]], "InlineFormula"],
 " have similar syntax and in many respects behave similarly, at least at \
first glance. They are, however, fundamentally different in when their \
variables are localized, where the local values are stored, and in what \
universe the variables are unique."
}], "Text",
 CellID->1223356264],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Module",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Module"]], "InlineFormula"],
 " works by replacing all occurrences of its local variables with new, \
uniquely named variables, constructed so that they do not conflict with any \
variables in the current session of the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " kernel."
}], "Text",
 CellID->257152404],

Cell["\<\
You can see the names of these localized variables by allowing them to \
\"escape\" the context of the module without having been assigned a value.\
\>", "MathCaption",
 CellID->302730972],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Module", "[", 
  RowBox[{
   RowBox[{"{", "x", "}"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->2079094401],

Cell[BoxData["x$651"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->179293073]
}, Open  ]],

Cell["\<\
The local variables can be updated dynamically just like any other variables.\
\
\>", "MathCaption",
 CellID->1633177270],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Module", "[", 
  RowBox[{
   RowBox[{"{", "x", "}"}], ",", 
   RowBox[{"Dynamic", "[", "x", "]"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->1821884583],

Cell[BoxData[
 DynamicBox[ToBoxes[$CellContext`x$653, StandardForm],
  ImageSizeCache->{35., {1., 8.}}]], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->459121170]
}, Open  ]],

Cell[TextData[{
 "That is why sliders inside ",
 Cell[BoxData[
  ButtonBox["Module",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Module"]], "InlineFormula"],
 " seem to work just as well as sliders inside ",
 Cell[BoxData[
  ButtonBox["DynamicModule",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DynamicModule"]], "InlineFormula"],
 "."
}], "MathCaption",
 CellID->1254784343],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x", "=", ".5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Slider", "[", 
        RowBox[{"Dynamic", "[", "x", "]"}], "]"}], ",", 
       RowBox[{"Dynamic", "[", "x", "]"}]}], "}"}]}], "]"}], ",", 
   RowBox[{"{", "2", "}"}]}], "]"}]], "Input",
 CellLabel->"In[9]:=",
 CellID->871039261],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     SliderBox[Dynamic[$CellContext`x$255]], ",", 
     DynamicBox[ToBoxes[$CellContext`x$255, StandardForm],
      ImageSizeCache->{14., {0., 8.}}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     SliderBox[Dynamic[$CellContext`x$256]], ",", 
     DynamicBox[ToBoxes[$CellContext`x$256, StandardForm],
      ImageSizeCache->{14., {0., 8.}}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{508, 25},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[9]=",
 CellID->940292670]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"DynamicModule", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x", "=", ".5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Slider", "[", 
        RowBox[{"Dynamic", "[", "x", "]"}], "]"}], ",", 
       RowBox[{"Dynamic", "[", "x", "]"}]}], "}"}]}], "]"}], ",", 
   RowBox[{"{", "2", "}"}]}], "]"}]], "Input",
 CellLabel->"In[10]:=",
 CellID->160838028],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   DynamicModuleBox[{$CellContext`x$$ = 0.5}, 
    RowBox[{"{", 
     RowBox[{
      SliderBox[Dynamic[$CellContext`x$$]], ",", 
      DynamicBox[ToBoxes[$CellContext`x$$, StandardForm],
       ImageSizeCache->{21., {0., 8.}}]}], "}"}],
    DynamicModuleValues:>{}], ",", 
   DynamicModuleBox[{$CellContext`x$$ = 0.5}, 
    RowBox[{"{", 
     RowBox[{
      SliderBox[Dynamic[$CellContext`x$$]], ",", 
      DynamicBox[ToBoxes[$CellContext`x$$, StandardForm],
       ImageSizeCache->{21., {0., 8.}}]}], "}"}],
    DynamicModuleValues:>{}]}], "}"}]], "Output",
 ImageSize->{522, 25},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[10]=",
 CellID->166746417]
}, Open  ]],

Cell[TextData[{
 "Both examples produce seemingly independent sliders that allow separate \
settings of separate copies of the variable ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 ". The problem with sliders inside ",
 Cell[BoxData[
  ButtonBox["Module",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Module"]], "InlineFormula"],
 " is that a different kernel session may coincidentally share the same \
localized variable names. So if this notebook is saved and then re-opened \
sometime later, the sliders may \"connect\" to variables in some other ",
 Cell[BoxData[
  ButtonBox["Module",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Module"]], "InlineFormula"],
 " that happen to have the same local variables at that time."
}], "Reference",
 CellID->40871184],

Cell[TextData[{
 "This will not happen with the sliders inside ",
 Cell[BoxData[
  ButtonBox["DynamicModule",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DynamicModule"]], "InlineFormula"],
 " because ",
 Cell[BoxData[
  ButtonBox["DynamicModule",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DynamicModule"]], "InlineFormula"],
 " waits to localize the variables until the object is displayed in the front \
end and generates local names that are unique to the current session of the \
front end. Localization happens when ",
 Cell[BoxData[
  ButtonBox["DynamicModule",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DynamicModule"]], "InlineFormula"],
 " is first created as output and then repeats anew each time the file that \
contains ",
 Cell[BoxData[
  ButtonBox["DynamicModule",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DynamicModule"]], "InlineFormula"],
 " is opened, so there can never be a name conflict among examples generated \
in different sessions. "
}], "Reference",
 CellID->1874706095],

Cell[TextData[{
 "Variables generated by ",
 Cell[BoxData[
  ButtonBox["Module",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Module"]], "InlineFormula"],
 " are purely kernel session variables; when the kernel session ends, the \
values are irretrievably lost. ",
 Cell[BoxData[
  ButtonBox["DynamicModule",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DynamicModule"]], "InlineFormula"],
 ", on the other hand, generates a structure in the output cell that is \
responsible for maintaining the values of the variables, allowing them to be \
saved in files. This is a somewhat subtle concept, best explained by way of \
two analogies. First, you can think of ",
 Cell[BoxData[
  ButtonBox["DynamicModule",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DynamicModule"]], "InlineFormula"],
 " as a sort of persistent version of ",
 Cell[BoxData[
  ButtonBox["Module",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Module"]], "InlineFormula"],
 "."
}], "Text",
 CellID->729884070],

Cell["Consider this command.", "MathCaption",
 CellID->1366820905],

Cell[BoxData[
 RowBox[{"Module", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "=", "2"}], ",", " ", "y", ",", " ", "z"}], "}"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"x", "=", "4"}], ";", "\[IndentingNewLine]", 
    RowBox[{"y", "=", 
     SuperscriptBox["x", "2"]}], ";", "\[IndentingNewLine]", 
    RowBox[{"x", "=", "8"}], ";", "\[IndentingNewLine]", 
    RowBox[{"z", "=", 
     SuperscriptBox["x", "3"]}], ";"}]}], "\[IndentingNewLine]", 
  "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->362349038],

Cell[TextData[{
 "The module in this example evaluates a series of expressions in order, and \
from one line to the next the values of all the local module variables are \
preserved (obviously). You can have as many lines as you like in the compound \
expression, but they all have to be there at the start; once the ",
 Cell[BoxData[
  ButtonBox["Module",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Module"]], "InlineFormula"],
 " has finished execution, it evaporates along with all its local variables."
}], "Text",
 CellID->1884142421],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["DynamicModule",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DynamicModule"]], "InlineFormula"],
 ", on the other hand, creates an environment in which evaluations of \
expressions in ",
 Cell[BoxData[
  ButtonBox["Dynamic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dynamic"]], "InlineFormula"],
 " that appear within the body of the ",
 Cell[BoxData[
  ButtonBox["DynamicModule",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DynamicModule"]], "InlineFormula"],
 " are like additional lines in the compound expression in the previous \
example. From one dynamic update to the next the values of all the variables \
are preserved, just as if the separate evaluations were separate lines in a \
compound expression, all within the local variable context created by ",
 Cell[BoxData[
  ButtonBox["DynamicModule",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DynamicModule"]], "InlineFormula"],
 "."
}], "Text",
 CellID->2135294732],

Cell[TextData[{
 "This preservation of variable values extends not just to subsequent dynamic \
evaluations within the same session, but to all future sessions. Because all \
the local variable values are stored and preserved in the notebook file, if \
the notebook is opened in an entirely new session of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", the values will still be there, and dynamic updates will resume just \
where they left off",
 ". ",
 Cell[BoxData[
  ButtonBox["DynamicModule",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DynamicModule"]], "InlineFormula"],
 " is like an indefinitely extendable ",
 Cell[BoxData[
  ButtonBox["Module",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Module"]], "InlineFormula"],
 "."
}], "Text",
 CellID->1299335707],

Cell[TextData[{
 "Another way to think about the difference between ",
 Cell[BoxData[
  ButtonBox["Module",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Module"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["DynamicModule",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DynamicModule"]], "InlineFormula"],
 " is that while ",
 Cell[BoxData[
  ButtonBox["Module",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Module"]], "InlineFormula"],
 " localizes its variables for a certain duration of ",
 StyleBox["time",
  FontSlant->"Italic"],
 " (while the body of the module is being evaluated), ",
 Cell[BoxData[
  ButtonBox["DynamicModule",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DynamicModule"]], "InlineFormula"],
 " localizes its variables for a certain area of ",
 StyleBox["space",
  FontSlant->"Italic"],
 " in the output."
}], "Text",
 CellID->174021206],

Cell[TextData[{
 "As long as that space of the output remains in existence, the values of the \
variables defined for it will be preserved, allowing them to be used in \
subsequent evaluations of ",
 Cell[BoxData[
  ButtonBox["Dynamic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dynamic"]], "InlineFormula"],
 " expressions within the scope (area) of the ",
 Cell[BoxData[
  ButtonBox["DynamicModule",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DynamicModule"]], "InlineFormula"],
 ". Saving the output into a file puts that bit of real estate into \
hibernation, waiting for the moment when the file is opened again. (In \
computer science terms, this is sometimes referred to as a \
freeze\[Hyphen]dried or serialized object.)"
}], "Text",
 CellID->2049165675],

Cell[TextData[{
 "The ability of ",
 Cell[BoxData[
  ButtonBox["DynamicModule",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DynamicModule"]], "InlineFormula"],
 " to preserve state across sessions is also a way of extending the notion of \
editing in a file. Normally when you edit text or expressions in a file, save \
the file, and reopen it, you expect it to open the way you left it. Editing \
means changing the contents of a file",
 ". "
}], "Text",
 CellID->1132252786],

Cell[TextData[{
 "Ordinary kernel variables do not have this property; if you make an \
assignment to ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 ", then quit and restart ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " does not have that value anymore. There are several reasons for this, not \
least of which is the question of ",
 StyleBox["where",
  FontSlant->"Italic"],
 " the value of ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " should be saved."
}], "Text",
 CellID->919978235],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["DynamicModule",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DynamicModule"]], "InlineFormula"],
 " answers this question by defining a specific location (the output cell) \
where values of specific variables (the local variables) should be preserved. \
Arbitrary editing operations, like moving a slider, typing in an input field, \
or dragging a dynamic graphics object, change the values of the local \
variables. And since these values are automatically preserved when the file \
is saved, the sliders, and other objects, open exactly where they were left. \
Thus ",
 Cell[BoxData[
  ButtonBox["DynamicModule",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DynamicModule"]], "InlineFormula"],
 " lets you make any quantity editable in the same way that text and \
expressions can be edited and saved in notebook files."
}], "Text",
 CellID->191937245]
}, Open  ]],

Cell[CellGroupData[{

Cell["Front End Ownership of DynamicModule Variable Values", "Section",
 CellID->368838921],

Cell[TextData[{
 "Ordinary variables in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " are owned by the kernel. Their values reside in the kernel, and when you \
ask ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " to display the value in the front end, a transaction is initiated with the \
kernel to retrieve the value. The same is true of dynamic output that refers \
to the values of ordinary variables."
}], "Text",
 CellID->1437940005],

Cell["Consider this example.", "MathCaption",
 CellID->526378376],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "=", "0"}], ";"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->1589725036],

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Slider", "[", 
    RowBox[{"Dynamic", "[", "x", "]"}], "]"}], ",", 
   RowBox[{"{", "500", "}"}]}], "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->305269881],

Cell[TextData[{
 "When one slider is moved, the other 499 move in sync with it. This requires \
500 separate transactions with the kernel to retrieve the value of ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 ". (The semantics of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " are complex enough that there is no guarantee that evaluating ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " several times in a row will actually return the same value each time: it \
would not be possible for the front end to improve efficiency by somehow \
sharing a single value retrieved from the kernel with all the sliders.)"
}], "Text",
 CellID->1664627725],

Cell[TextData[{
 "Variables declared with ",
 Cell[BoxData[
  ButtonBox["DynamicModule",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DynamicModule"]], "InlineFormula"],
 " on the other hand are owned by the front end. Their values reside in the \
front end, and when the front end needs a value, it can be retrieved locally \
with very little overhead."
}], "Text",
 CellID->2128704606],

Cell["The following example thus runs noticeably faster.", "MathCaption",
 CellID->655910015],

Cell[BoxData[
 RowBox[{"DynamicModule", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "=", "0"}], "}"}], ",", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Slider", "[", 
      RowBox[{"Dynamic", "[", "x", "]"}], "]"}], ",", 
     RowBox[{"{", "500", "}"}]}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[8]:=",
 CellID->60754022],

Cell["\<\
If a complex function is applied to such a variable, its value must of course \
be sent to the kernel. This happens transparently, with each side of the \
system being kept informed on a just\[Hyphen]in\[Hyphen]time basis of any \
changes to variable values.\
\>", "Text",
 CellID->1038115429],

Cell[TextData[{
 "Whether it is better to use a normal kernel variable or a ",
 Cell[BoxData[
  ButtonBox["DynamicModule",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DynamicModule"]], "InlineFormula"],
 " variable in a given situation depends on a number of factors. The most \
important is the fact that values of all ",
 Cell[BoxData[
  ButtonBox["DynamicModule",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DynamicModule"]], "InlineFormula"],
 " variables are saved in the file when the notebook is saved. If you need a \
value preserved between sessions, it must be declared in a ",
 Cell[BoxData[
  ButtonBox["DynamicModule",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DynamicModule"]], "InlineFormula"],
 ". On the other hand, a temporary variable holding a large table of numbers, \
for example, might be a poor choice for a ",
 Cell[BoxData[
  ButtonBox["DynamicModule",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DynamicModule"]], "InlineFormula"],
 " variable as it could greatly increase the size of the file. It is quite \
reasonable to nest a ",
 Cell[BoxData[
  ButtonBox["Module",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Module"]], "InlineFormula"],
 " inside a ",
 Cell[BoxData[
  ButtonBox["DynamicModule",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DynamicModule"]], "InlineFormula"],
 " and vice versa, or to partition variables between the front end and \
kernel."
}], "Text",
 CellID->1448866975],

Cell["\<\
In many situations the limiting factor in performance is the time needed to \
retrieve information from the kernel; and by making variables local to the \
front end, speed can sometimes be increased dramatically.\
\>", "Text",
 CellID->790175492]
}, Open  ]],

Cell[CellGroupData[{

Cell["Automatic Updates of Dynamic Objects", "Section",
 CellID->440620996],

Cell[TextData[{
 "The specification for dynamic output is simple: ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Dynamic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Dynamic"], "[", 
   StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
 " should always display the value you would get if you evaluated ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " now. If a variable value, or some other state of the system, changes, the \
dynamic output should be updated immediately. Of course, for efficiency, not \
every dynamic output should be re-evaluated every time any variable changes. \
It is critical that dependencies be tracked so that dynamic outputs are \
evaluated only when necessary."
}], "Text",
 CellID->993464916],

Cell["Consider these two expressions.", "MathCaption",
 CellID->479487787],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Dynamic", "[", 
  RowBox[{"a", "+", "b", "+", "c"}], "]"}]], "Input",
 CellLabel->"In[9]:=",
 CellID->1392592565],

Cell[BoxData[
 DynamicBox[
  ToBoxes[$CellContext`a + $CellContext`b + $CellContext`c, StandardForm],
  ImageSizeCache->{46.25, {0., 8.}}]], "Output",
 ImageSize->{51, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[9]=",
 CellID->1255012257]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Dynamic", "[", 
  RowBox[{"If", "[", 
   RowBox[{"a", ",", " ", "b", ",", " ", "c"}], "]"}], "]"}]], "Input",
 CellLabel->"In[10]:=",
 CellID->1685170070],

Cell[BoxData[
 DynamicBox[ToBoxes[
   If[$CellContext`a, $CellContext`b, $CellContext`c], StandardForm],
  ImageSizeCache->{71.375, {2., 8.}}]], "Output",
 ImageSize->{76, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[10]=",
 CellID->406622565]
}, Open  ]],

Cell[TextData[{
 "The first expression might change its value any time the value of ",
 Cell[BoxData[
  StyleBox["a", "TI"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  StyleBox["b", "TI"]], "InlineFormula"],
 ", or ",
 Cell[BoxData[
  StyleBox["c", "TI"]], "InlineFormula"],
 " changes, or if any patterns associated with ",
 Cell[BoxData[
  StyleBox["a", "TI"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  StyleBox["b", "TI"]], "InlineFormula"],
 ", or ",
 Cell[BoxData[
  StyleBox["c", "TI"]], "InlineFormula"],
 " are changed. The second expression depends on ",
 Cell[BoxData[
  StyleBox["a", "TI"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  StyleBox["b", "TI"]], "InlineFormula"],
 " (but not ",
 Cell[BoxData[
  StyleBox["c", "TI"]], "InlineFormula"],
 ") while ",
 Cell[BoxData[
  StyleBox["a", "TI"]], "InlineFormula"],
 " is ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 " and on ",
 Cell[BoxData[
  StyleBox["a", "TI"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  StyleBox["c", "TI"]], "InlineFormula"],
 " (but not ",
 Cell[BoxData[
  StyleBox["b", "TI"]], "InlineFormula"],
 ") while ",
 Cell[BoxData[
  StyleBox["a", "TI"]], "InlineFormula"],
 " is ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 ". If ",
 Cell[BoxData[
  StyleBox["a", "TI"]], "InlineFormula"],
 " is neither ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 " nor ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 ", then it depends only on ",
 Cell[BoxData[
  StyleBox["a", "TI"]], "InlineFormula"],
 " (because the ",
 Cell[BoxData[
  ButtonBox["If",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/If"]], "InlineFormula"],
 " statement returns unevaluated). "
}], "Text",
 CellID->2026454949],

Cell["\<\
Figuring out these dependencies a priori is impossible (there are theorems to \
this effect), so instead the system keeps track of which variables or other \
trackable entities are actually encountered during the process of evaluating \
a given expression. Data is then associated with those variable(s) \
identifying which dynamic expressions need to be notified if the given \
variable receives a new value.\
\>", "Text",
 CellID->1402016109],

Cell["\<\
An important design goal of the system is to allow monitoring of variable \
values by way of dynamic output referencing them, without imposing any more \
load than absolutely necessary on the system, especially if the value of the \
variable is being changed rapidly.\
\>", "Text",
 CellID->1494169079],

Cell["Consider this simple example.", "MathCaption",
 CellID->1973426382],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Dynamic", "[", "x", "]"}]], "Input",
 CellLabel->"In[11]:=",
 CellID->1639758006],

Cell[BoxData[
 DynamicBox[ToBoxes[$CellContext`x, StandardForm],
  ImageSizeCache->{7., {0., 6.}}]], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[11]=",
 CellID->812485201]
}, Open  ]],

Cell[BoxData[
 RowBox[{"Do", "[", 
  RowBox[{"x", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "1", ",", "5000000"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[13]:=",
 CellID->755164891],

Cell[TextData[{
 "When the dynamic output is created, it is evaluated, and the symbol ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " is tagged with information identifying the output that needs to be updated \
if its value should be changed."
}], "Text",
 CellID->427969267],

Cell[TextData[{
 "When the loop is started and ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " is first given a new value, the data associated with it is consulted, and \
the front end is notified that the dynamic output needs to be updated. The \
data associated with ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " is then deleted. Essentially the system forgets all about the dynamic \
output, and subsequent assignments in the loop incur absolutely no speed \
penalty because of the existence of a dynamic output monitoring the value of \
",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 "."
}], "Text",
 CellID->956736666],

Cell[TextData[{
 "Much later (on a computer time scale; only a fraction of a second on a \
human time scale) when the screen is next redrawn and the dynamic output \
containing the reference to ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " is re-evaluated, the connection between the dynamic output and the \
variable ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " is noticed again, and the association is reestablished."
}], "Text",
 CellID->1663080373],

Cell["\<\
Meanwhile the loop has continued to run. The next time the assignment is done \
after the screen is updated, another notification will be sent to the front \
end, and the process repeats. \
\>", "Text",
 CellID->1892163306],

Cell[TextData[{
 "By default, dynamic outputs triggered by changes in variable values are \
updated no faster than twenty times per second (this rate can be changed with \
the ",
 Cell[BoxData["SystemOption"], "InlineFormula"],
 " ",
 Cell[BoxData["\"\<DynamicUpdateInterval\>\""], "InlineFormula"],
 "). In the previous example you will typically see the value jump by tens or \
hundreds of thousands with each update (more the faster your computer is), \
and the overall speed of the computation is slowed down by only a percent or \
two, nearly zero if you have a multiprocessor system."
}], "Text",
 CellID->1650839166],

Cell["\<\
You might expect that having a dynamic output monitoring the value of a \
symbol that is being changed rapidly in a tight loop would slow that loop \
down significantly. But the overhead is in fact zero\[Hyphen]order in the \
rate at which the variable is changed, and in practice is usually minimal.\
\>", "Text",
 CellID->165143722],

Cell["\<\
Dynamic outputs are only updated when they are visible on screen. This \
optimization allows you to have an open\[Hyphen]ended number of dynamic \
outputs, all changing constantly, without incurring an open\[Hyphen]ended \
amount of processor load. Outputs that are scrolled off-screen, above or \
below the current document position, will be left unexamined until the next \
time they are scrolled on\[Hyphen]screen, at which point they are updated \
before being displayed. (Thus the fact that they stopped updating is not \
normally apparent, unless they have side effects, which is discouraged in \
general.)\
\>", "Text",
 CellID->1021663730],

Cell["\<\
Dynamic output can depend on things other than variables, and in these cases \
tracking is also done carefully and selectively.\
\>", "Text",
 CellID->1970552345],

Cell["\<\
This gives a rapidly updated display of the current mouse position in screen \
coordinates. \
\>", "MathCaption",
 CellID->1340179768],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Dynamic", "[", 
  RowBox[{"MousePosition", "[", "]"}], "]"}]], "Input",
 CellLabel->"In[14]:=",
 CellID->580458381],

Cell[BoxData[
 DynamicBox[ToBoxes[
   MousePosition[], StandardForm],
  ImageSizeCache->{39.1875, {2., 8.}}]], "Output",
 ImageSize->{44, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[14]=",
 CellID->512380667]
}, Open  ]],

Cell["\<\
As long as the output is visible on screen, there will be a certain amount of \
CPU activity any time the mouse is moved, because this particular dynamic \
output is being redrawn immediately with every movement of the mouse. But if \
it is scrolled off-screen, the CPU usage will vanish. \
\>", "Text",
 CellID->1893284793]
}, Open  ]],

Cell[CellGroupData[{

Cell["Refresh", "Section",
 CellID->1172318352],

Cell[TextData[{
 "Normally, dynamic output is updated whenever the system detects any reason \
to believe it might need to be (see ",
 ButtonBox["Automatic Updates of Dynamic Objects",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/AdvancedDynamicFunctionality#440620996"],
 " for details about what this means). ",
 Cell[BoxData[
  ButtonBox["Refresh",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Refresh"]], "InlineFormula"],
 " can be used to modify this behavior by specifying explicitly what should \
or should not trigger updates."
}], "Text",
 CellID->2139564486],

Cell["This updates when either slider is moved.", "MathCaption",
 CellID->46647187],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DynamicModule", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", 
   RowBox[{"Column", "[", 
    RowBox[{"{", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"Slider", "[", 
       RowBox[{"Dynamic", "[", "x", "]"}], "]"}], ",", "\[IndentingNewLine]", 
      
      RowBox[{"Slider", "[", 
       RowBox[{"Dynamic", "[", "y", "]"}], "]"}], ",", "\[IndentingNewLine]", 
      
      RowBox[{"Dynamic", "[", 
       RowBox[{"{", 
        RowBox[{"x", ",", "y"}], "}"}], "]"}]}], "}"}], "]"}]}], 
  "]"}]], "Input",
 CellLabel->"In[15]:=",
 CellID->167740754],

Cell[BoxData[
 DynamicModuleBox[{$CellContext`x$$ = 0.24500000000000002`, $CellContext`y$$ =
   0.11}, 
  TagBox[GridBox[{
     {
      SliderBox[Dynamic[$CellContext`x$$]]},
     {
      SliderBox[Dynamic[$CellContext`y$$]]},
     {
      DynamicBox[ToBoxes[{$CellContext`x$$, $CellContext`y$$}, StandardForm],
       ImageSizeCache->{88.1875, {2., 8.}}]}
    },
    GridBoxAlignment->{"Columns" -> {{Left}}}],
   "Column"],
  DynamicModuleValues:>{}]], "Output",
 ImageSize->{204, 69},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[15]=",
 CellID->172445799]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Refresh",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Refresh"]], "InlineFormula"],
 " with a ",
 Cell[BoxData[
  ButtonBox["TrackedSymbols",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TrackedSymbols"]], "InlineFormula"],
 " option can be used to specify a list of those symbols that should be \
tracked, with all other reasons for updating being ignored."
}], "Text",
 CellID->1720307614],

Cell[TextData[{
 "This updates only when ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " changes, ignoring changes in ",
 Cell[BoxData[
  StyleBox["y", "TI"]], "InlineFormula"],
 "."
}], "MathCaption",
 CellID->856641709],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DynamicModule", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", 
   RowBox[{"Column", "[", 
    RowBox[{"{", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"Slider", "[", 
       RowBox[{"Dynamic", "[", "x", "]"}], "]"}], ",", "\[IndentingNewLine]", 
      
      RowBox[{"Slider", "[", 
       RowBox[{"Dynamic", "[", "y", "]"}], "]"}], ",", "\[IndentingNewLine]", 
      
      RowBox[{"Dynamic", "[", 
       RowBox[{"Refresh", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"x", ",", "y"}], "}"}], ",", 
         RowBox[{"TrackedSymbols", "\[Rule]", 
          RowBox[{"{", "x", "}"}]}]}], "]"}], "]"}]}], "}"}], "]"}]}], 
  "]"}]], "Input",
 CellLabel->"In[16]:=",
 CellID->1637728937],

Cell[BoxData[
 DynamicModuleBox[{$CellContext`x$$ = 0.065, $CellContext`y$$ = 0.}, 
  TagBox[GridBox[{
     {
      SliderBox[Dynamic[$CellContext`x$$]]},
     {
      SliderBox[Dynamic[$CellContext`y$$]]},
     {
      DynamicBox[ToBoxes[
        Refresh[{$CellContext`x$$, $CellContext`y$$}, 
         TrackedSymbols -> {$CellContext`x$$}], StandardForm],
       ImageSizeCache->{74.1875, {2., 8.}}]}
    },
    GridBoxAlignment->{"Columns" -> {{Left}}}],
   "Column"],
  DynamicModuleValues:>{}]], "Output",
 ImageSize->{204, 69},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[16]=",
 CellID->1341103990]
}, Open  ]],

Cell[TextData[{
 "When you move the second (",
 Cell[BoxData[
  StyleBox["y", "TI"]], "InlineFormula"],
 ") slider, nothing happens, but when you move the first slider, the \
expression is updated to reflect the current value of both variables. You \
might say that after moving the second slider, the dynamic output is wrong, \
since it does not reflect the current state of the system. But that is \
essentially the whole reason for the existence of the ",
 Cell[BoxData[
  ButtonBox["Refresh",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Refresh"]], "InlineFormula"],
 " command. It allows you to override the system's mandate to always update \
dynamic output any time it is potentially out of date."
}], "Text",
 CellID->1012340560],

Cell[TextData[{
 "The setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["TrackedSymbols",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TrackedSymbols"], "->", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 " can be used to track only those symbols that occur explicitly (lexically) \
in the expression given in the first argument to ",
 Cell[BoxData[
  ButtonBox["Refresh",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Refresh"]], "InlineFormula"],
 ". For example, if you use a function that depends on a global variable that \
does not occur lexically inside ",
 Cell[BoxData[
  ButtonBox["Refresh",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Refresh"]], "InlineFormula"],
 ", changes to the value of the global variable will not cause updating, when \
normally they would."
}], "Text",
 CellID->2042340386],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Refresh",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Refresh"]], "InlineFormula"],
 " can also be used to cause updates at regular time intervals. It is \
important to understand that this is ",
 StyleBox["not",
  FontSlant->"Italic"],
 " a feature that should be used lightly. It is fundamental to the design of \
",
 Cell[BoxData[
  ButtonBox["Dynamic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dynamic"]], "InlineFormula"],
 " that it does not need to update on any fixed schedule, because it simply \
always updates immediately whenever doing so would be useful. But there are \
some situations where this either cannot, or just unfortunately does not, \
happen."
}], "Text",
 CellID->236253854],

Cell[TextData[{
 "One potentially vexing case is ",
 Cell[BoxData[
  ButtonBox["RandomReal",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RandomReal"]], "InlineFormula"],
 ". Every time you evaluate ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["RandomReal",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RandomReal"], "[", "]"}]], "InlineFormula"],
 ", you get a different answer, and you might think that ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Dynamic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Dynamic"], "[", 
   RowBox[{
    ButtonBox["RandomReal",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/RandomReal"], "[", "]"}], "]"}]], 
  "InlineFormula"],
 " should therefore constantly update itself as fast as possible. But this \
would normally not be useful, and would in fact have negative consequences \
for a number of algorithms that use randomness internally (e.g., a Monte \
Carlo integration inside ",
 Cell[BoxData[
  ButtonBox["Dynamic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dynamic"]], "InlineFormula"],
 " should probably not update constantly simply because it will, in fact, \
give a slightly different answer each time)."
}], "Text",
 CellID->21260875],

Cell[TextData[{
 "For this reason, ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["RandomReal",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RandomReal"], "[", "]"}]], "InlineFormula"],
 " is not \"ticklish,\" in the sense that it does not trigger updates. If you \
want to see new random numbers, you have to use ",
 Cell[BoxData[
  ButtonBox["Refresh",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Refresh"]], "InlineFormula"],
 " to specify how frequently you want the output updated. Another example of \
non\[Hyphen]ticklish functions are file system operations."
}], "Text",
 CellID->849240723],

Cell["This gives you a new number every second.", "MathCaption",
 CellID->1359447056],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Dynamic", "[", 
  RowBox[{"Refresh", "[", 
   RowBox[{
    RowBox[{"RandomReal", "[", "]"}], ",", 
    RowBox[{"UpdateInterval", "\[Rule]", "1"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[17]:=",
 CellID->1012513499],

Cell[BoxData[
 DynamicBox[ToBoxes[
   Refresh[
    Random[], UpdateInterval -> 1], StandardForm],
  ImageSizeCache->{56., {0., 8.}}]], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[17]=",
 CellID->1105041266]
}, Open  ]],

Cell["This is not updated automatically.", "MathCaption",
 CellID->1812431218],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Dynamic", "[", 
  RowBox[{"FileByteCount", "[", 
   RowBox[{"ToFileName", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "$TopDirectory", ",", "\"\<SystemFiles\>\"", ",", "\"\<FrontEnd\>\"", 
       ",", "\"\<Palettes\>\""}], "}"}], ",", "\"\<BasicMathInput.nb\>\""}], 
    "]"}], "]"}], "]"}]], "Input",
 CellLabel->"In[18]:=",
 CellID->265338709],

Cell[BoxData[
 DynamicBox[ToBoxes[
   FileByteCount[
    ToFileName[{$TopDirectory, "SystemFiles", "FrontEnd", "Palettes"}, 
     "BasicMathInput.nb"]], StandardForm],
  ImageSizeCache->{28., {0., 8.}}]], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[18]=",
 CellID->927187694]
}, Open  ]],

Cell[TextData[{
 "In the unlikely event that the file containing the ",
 StyleBox["BasicMathInput", "DialogElementName"],
 " palette changes size, this ",
 Cell[BoxData[
  ButtonBox["Dynamic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dynamic"]], "InlineFormula"],
 " will not be updated. If you want to monitor the size of a file, you need \
to use ",
 Cell[BoxData[
  ButtonBox["Refresh",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Refresh"]], "InlineFormula"],
 " to specify a polling interval. (On sufficiently advanced operating systems \
it would theoretically be possible for ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " to efficiently receive notifications of file system activity, and future \
versions of ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " might in fact update such expressions automatically. As with other ",
 Cell[BoxData[
  ButtonBox["Dynamic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dynamic"]], "InlineFormula"],
 " expressions, automatic correctness is always the goal.)"
}], "Text",
 CellID->1371630991],

Cell[TextData[{
 "Finally, several functions you might think would trigger dynamic updates in \
fact do not: for example, ",
 Cell[BoxData[
  ButtonBox["DateList",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DateList"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["AbsoluteTime",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AbsoluteTime"]], "InlineFormula"],
 ". As with ",
 Cell[BoxData[
  ButtonBox["RandomReal",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RandomReal"]], "InlineFormula"],
 ", it would cause more trouble than it is worth for these functions to \
automatically trigger updates, and ",
 Cell[BoxData[
  ButtonBox["Refresh",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Refresh"]], "InlineFormula"],
 " can trivially be used to create clock\[Hyphen]like objects. The function \
",
 Cell[BoxData[
  ButtonBox["Clock",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Clock"]], "InlineFormula"],
 " is intended specifically as a time\[Hyphen]based function that ",
 StyleBox["is",
  FontSlant->"Italic"],
 " ticklish."
}], "Text",
 CellID->1912598839],

Cell["This updates approximately every second.", "MathCaption",
 CellID->1239838411],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Dynamic", "[", 
  RowBox[{"Refresh", "[", 
   RowBox[{
    RowBox[{"DateList", "[", "]"}], ",", 
    RowBox[{"UpdateInterval", "\[Rule]", "1"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[19]:=",
 CellID->1513458777],

Cell[BoxData[
 DynamicBox[ToBoxes[
   Refresh[
    Date[], UpdateInterval -> 1], StandardForm],
  ImageSizeCache->{216.9375, {2., 8.}}]], "Output",
 ImageSize->{221, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[19]=",
 CellID->1102230426]
}, Open  ]],

Cell[TextData[{
 "This updates without an explicit ",
 Cell[BoxData[
  ButtonBox["Refresh",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Refresh"]], "InlineFormula"],
 "."
}], "MathCaption",
 CellID->510838845],

Cell[BoxData[
 RowBox[{"Dynamic", "[", 
  RowBox[{"Clock", "[", 
   RowBox[{"{", 
    RowBox[{"1", ",", "10"}], "}"}], "]"}], "]"}]], "Input",
 CellLabel->"In[26]:=",
 CellID->2088302180]
}, Open  ]],

Cell[CellGroupData[{

Cell["Nesting Refresh", "Section",
 CellID->1769496339],

Cell[TextData[{
 "In the examples above, ",
 Cell[BoxData[
  ButtonBox["Refresh",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Refresh"]], "InlineFormula"],
 " is always the outermost function inside ",
 Cell[BoxData[
  ButtonBox["Dynamic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dynamic"]], "InlineFormula"],
 ". You might almost wonder why its options are not simply options to ",
 Cell[BoxData[
  ButtonBox["Dynamic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dynamic"]], "InlineFormula"],
 ". But in fact it is often important to place ",
 Cell[BoxData[
  ButtonBox["Refresh",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Refresh"]], "InlineFormula"],
 " as deeply in the expression as possible, especially if it specifies a time\
\[Hyphen]based updating interval."
}], "Text",
 CellID->1571425917],

Cell["Consider this example.", "MathCaption",
 CellID->1201496213],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DynamicModule", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"showclock", "=", "True"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Checkbox", "[", 
      RowBox[{"Dynamic", "[", "showclock", "]"}], "]"}], ",", 
     RowBox[{"Dynamic", "[", 
      RowBox[{"If", "[", 
       RowBox[{"showclock", ",", 
        RowBox[{"Refresh", "[", 
         RowBox[{
          RowBox[{"DateList", "[", "]"}], ",", 
          RowBox[{"UpdateInterval", "\[Rule]", "0.05"}]}], "]"}], ",", 
        "\"\<No clock\>\""}], "]"}], "]"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[20]:=",
 CellID->758119150],

Cell[BoxData[
 DynamicModuleBox[{$CellContext`showclock$$ = False}, 
  RowBox[{"{", 
   RowBox[{
    CheckboxBox[Dynamic[$CellContext`showclock$$]], ",", 
    DynamicBox[ToBoxes[
      If[$CellContext`showclock$$, 
       Refresh[
        Date[], UpdateInterval -> 0.05], "No clock"], StandardForm],
     ImageSizeCache->{56., {1., 8.}}]}], "}"}],
  DynamicModuleValues:>{}]], "Output",
 ImageSize->{99, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[20]=",
 CellID->992830760]
}, Open  ]],

Cell[TextData[{
 "When the checkbox is checked, ",
 Cell[BoxData[
  ButtonBox["Refresh",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Refresh"]], "InlineFormula"],
 " is causing frequent updating of the clock, and CPU time is being consumed \
to keep things up-to-date. When the checkbox is unchecked, however, the ",
 Cell[BoxData[
  ButtonBox["Refresh",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Refresh"]], "InlineFormula"],
 " expression is no longer reached by evaluation, the output remains static, \
and no CPU time is consumed. If ",
 Cell[BoxData[
  ButtonBox["Refresh",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Refresh"]], "InlineFormula"],
 " were wrapped around the whole expression inside ",
 Cell[BoxData[
  ButtonBox["Dynamic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dynamic"]], "InlineFormula"],
 ", CPU time would be consumed constantly, even if the clock was not being \
displayed. The words \"No clock\" would be constantly refreshed, pointlessly. \
(This refreshing is not visible; there is no flicker of the screen, but CPU \
time is being consumed nevertheless.)"
}], "Text",
 CellID->688076399]
}, Open  ]],

Cell[CellGroupData[{

Cell["Nesting Dynamic", "Section",
 CellID->300598898],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Dynamic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dynamic"]], "InlineFormula"],
 " expressions can be nested, and the system takes great care to update them \
only when necessary. Particularly when the contents of a ",
 Cell[BoxData[
  ButtonBox["Dynamic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dynamic"]], "InlineFormula"],
 " contain further interactive elements, it is important to keep track of \
what will stay static and what will update, when a given variable is \
changed."
}], "Text",
 CellID->1284140942],

Cell["Consider this example.", "MathCaption",
 CellID->346159844],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DynamicModule", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"n", "=", "5"}], ",", 
     RowBox[{"data", "=", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"RandomReal", "[", "]"}], ",", 
        RowBox[{"{", "20", "}"}]}], "]"}]}]}], "}"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"Column", "[", 
    RowBox[{"{", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"Slider", "[", 
       RowBox[{
        RowBox[{"Dynamic", "[", "n", "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", "20", ",", "1"}], "}"}]}], "]"}], ",", 
      RowBox[{"Dynamic", "[", 
       RowBox[{"Column", "[", 
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{"With", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"i", "=", "i"}], "}"}], ",", 
            RowBox[{"Slider", "[", 
             RowBox[{"Dynamic", "[", 
              RowBox[{"data", "[", 
               RowBox[{"[", "i", "]"}], "]"}], "]"}], "]"}]}], "]"}], ",", 
          RowBox[{"{", 
           RowBox[{"i", ",", "n"}], "}"}]}], "]"}], "]"}], "]"}]}], "}"}], 
    "]"}]}], "]"}]], "Input",
 CellLabel->"In[21]:=",
 CellID->375298385],

Cell[BoxData[
 DynamicModuleBox[{$CellContext`n$$ = 5, $CellContext`data$$ = {
  0.229862106376641, 0.635984585112536, 0.6782961266018591, 
  0.11805533452534597`, 0.38536302062501404`, 0.24489960037192204`, 
  0.07469676154855803, 0.890697339074058, 0.081086949018757, 
  0.530009668452158, 0.30091405831096507`, 0.14511879415645504`, 
  0.13527357802524498`, 0.5507184793485571, 0.8050320334604001, 
  0.135547327918458, 0.813183241383045, 0.45724968503780505`, 
  0.36159851977251506`, 0.6089299777717742}}, 
  TagBox[GridBox[{
     {
      SliderBox[Dynamic[$CellContext`n$$], {1, 20, 1}]},
     {
      DynamicBox[ToBoxes[
        Column[
         Table[
          With[{$CellContext`i$ = $CellContext`i}, 
           Slider[
            Dynamic[
             
             Part[$CellContext`data$$, $CellContext`i$]]]], {$CellContext`i, \
$CellContext`n$$}]], StandardForm],
       ImageSizeCache->{200., {65., 70.}}]}
    },
    GridBoxAlignment->{"Columns" -> {{Left}}}],
   "Column"],
  DynamicModuleValues:>{}]], "Output",
 ImageSize->{204, 165},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[21]=",
 CellID->558646130]
}, Open  ]],

Cell[TextData[{
 "The position of the first slider determines the number of sliders \
underneath it, and each of those sliders in turn is connected to the value of \
one element of a list of data. Because the number of sliders is variable, and \
changes dynamically in response to the position of the first slider, the \
table that generates them needs to be inside ",
 Cell[BoxData[
  ButtonBox["Dynamic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dynamic"]], "InlineFormula"],
 "."
}], "Text",
 CellID->480485456],

Cell["\<\
The example above works, but now suppose you want to display the value of \
each number in the list next to its slider.\
\>", "Text",
 CellID->980546272],

Cell["You might at first try this.", "MathCaption",
 CellID->1816731361],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DynamicModule", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"n", "=", "5"}], ",", 
     RowBox[{"data", "=", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"RandomReal", "[", "]"}], ",", 
        RowBox[{"{", "20", "}"}]}], "]"}]}]}], "}"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"Column", "[", 
    RowBox[{"{", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"Slider", "[", 
       RowBox[{
        RowBox[{"Dynamic", "[", "n", "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", "20", ",", "1"}], "}"}]}], "]"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"Dynamic", "[", 
       RowBox[{"Grid", "[", 
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{"With", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"i", "=", "i"}], "}"}], ",", "\[IndentingNewLine]", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"Slider", "[", 
               RowBox[{"Dynamic", "[", 
                RowBox[{"data", "[", 
                 RowBox[{"[", "i", "]"}], "]"}], "]"}], "]"}], ",", 
              RowBox[{"data", "[", 
               RowBox[{"[", "i", "]"}], "]"}]}], "}"}]}], "]"}], ",", 
          RowBox[{"{", 
           RowBox[{"i", ",", "n"}], "}"}]}], "]"}], "\[IndentingNewLine]", 
        "]"}], "]"}]}], "}"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[22]:=",
 CellID->251686426],

Cell[BoxData[
 DynamicModuleBox[{$CellContext`n$$ = 5, $CellContext`data$$ = {
  0.07725125675576983, 0.07880800158311271, 0.627452657903644, 
  0.16551518547895502`, 0.441266671643234, 0.40051187498125407`, 
  0.509397323378298, 0.7801521648539408, 0.196367071271312, 
  0.3258151134326961, 0.6186999843042401, 0.6990652158351841, 
  0.6663574028191541, 0.024901055121731606`, 0.47358119014778505`, 
  0.5637916378099401, 0.11563892347059701`, 0.21986902166133104`, 
  0.3380338622293271, 0.7506083964268943}}, 
  TagBox[GridBox[{
     {
      SliderBox[Dynamic[$CellContext`n$$], {1, 20, 1}]},
     {
      DynamicBox[ToBoxes[
        Grid[
         Table[
          With[{$CellContext`i$ = $CellContext`i}, {
            Slider[
             Dynamic[
              Part[$CellContext`data$$, $CellContext`i$]]], 
            
            Part[$CellContext`data$$, $CellContext`i$]}], {$CellContext`i, \
$CellContext`n$$}]], StandardForm],
       ImageSizeCache->{271., {65., 70.}}]}
    },
    GridBoxAlignment->{"Columns" -> {{Left}}}],
   "Column"],
  DynamicModuleValues:>{}]], "Output",
 ImageSize->{275, 165},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[22]=",
 CellID->367002226]
}, Open  ]],

Cell[TextData[{
 "Now any time you click on one of the lower sliders, it moves only one step, \
then stops. The problem is that the ",
 Cell[BoxData[
  RowBox[{
   StyleBox["data", "TI"], "[", 
   RowBox[{"[", 
    StyleBox["i", "TI"], "]"}], "]"}]], "InlineFormula"],
 " expressions in the second column of the grid are creating a dependency in \
the outer ",
 Cell[BoxData[
  ButtonBox["Dynamic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dynamic"]], "InlineFormula"],
 " on the values in ",
 Cell[BoxData[
  StyleBox["data", "TI"]], "InlineFormula"],
 "."
}], "Text",
 CellID->1698460839],

Cell[TextData[{
 "As soon as ",
 Cell[BoxData[
  StyleBox["data", "TI"]], "InlineFormula"],
 " changes, the contents of the outer ",
 Cell[BoxData[
  ButtonBox["Dynamic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dynamic"]], "InlineFormula"],
 ", including the slider you are trying to drag, are destroyed and replaced \
with a nearly identical copy (in which the displayed value of one of the ",
 Cell[BoxData[
  RowBox[{
   StyleBox["data", "TI"], "[", 
   RowBox[{"[", 
    StyleBox["i", "TI"], "]"}], "]"}]], "InlineFormula"],
 " has been changed). In other words, the act of dragging the slider destroys \
it, preventing any further activity."
}], "Text",
 CellID->1678685149],

Cell[TextData[{
 "The solution to this is to prevent the outer ",
 Cell[BoxData[
  ButtonBox["Dynamic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dynamic"]], "InlineFormula"],
 " from depending on the value of data, by making sure that all occurrences \
of data in the expression are wrapped in ",
 Cell[BoxData[
  ButtonBox["Dynamic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dynamic"]], "InlineFormula"],
 "."
}], "MathCaption",
 CellID->21144957],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DynamicModule", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"n", "=", "5"}], ",", 
     RowBox[{"data", "=", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"RandomReal", "[", "]"}], ",", 
        RowBox[{"{", "20", "}"}]}], "]"}]}]}], "}"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"Column", "[", 
    RowBox[{"{", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"Slider", "[", 
       RowBox[{
        RowBox[{"Dynamic", "[", "n", "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", "20", ",", "1"}], "}"}]}], "]"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"Dynamic", "[", 
       RowBox[{"Grid", "[", 
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{"With", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"i", "=", "i"}], "}"}], ",", "\[IndentingNewLine]", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"Slider", "[", 
               RowBox[{"Dynamic", "[", 
                RowBox[{"data", "[", 
                 RowBox[{"[", "i", "]"}], "]"}], "]"}], "]"}], ",", 
              RowBox[{"Dynamic", "[", 
               RowBox[{"data", "[", 
                RowBox[{"[", "i", "]"}], "]"}], "]"}]}], "}"}]}], "]"}], ",", 
          
          RowBox[{"{", 
           RowBox[{"i", ",", "n"}], "}"}]}], "]"}], "\[IndentingNewLine]", 
        "]"}], "]"}]}], "}"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[23]:=",
 CellID->1048490544],

Cell[BoxData[
 DynamicModuleBox[{$CellContext`n$$ = 5, $CellContext`data$$ = {
  0.858270501888816, 0.729103884457553, 0.355231104571298, 0.581137981677022, 
  0.779462500305704, 0.101651226553909, 0.189715919092343, 0.139871310033788, 
  0.37895062532445, 0.59225390317561, 0.409563754238401, 0.943504238762476, 
  0.0531355118917535, 0.973553918871371, 0.710498538403217, 0.277146835943323,
   0.0282344567700218, 0.499972728723586, 0.146706900593277, 
  0.161507912472726}}, 
  TagBox[GridBox[{
     {
      SliderBox[Dynamic[$CellContext`n$$], {1, 20, 1}]},
     {
      DynamicBox[ToBoxes[
        Grid[
         Table[
          With[{$CellContext`i$ = $CellContext`i}, {
            Slider[
             Dynamic[
              Part[$CellContext`data$$, $CellContext`i$]]], 
            Dynamic[
             
             Part[$CellContext`data$$, $CellContext`i$]]}], {$CellContext`i, \
$CellContext`n$$}]], StandardForm],
       ImageSizeCache->{264., {65., 70.}}]}
    },
    GridBoxAlignment->{"Columns" -> {{Left}}}],
   "Column"],
  DynamicModuleValues:>{}]], "Output",
 ImageSize->{268, 165},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[23]=",
 CellID->633378198]
}, Open  ]],

Cell[TextData[{
 "Now you can drag any of the sliders and see dynamically updated values. \
This works because the outer ",
 Cell[BoxData[
  ButtonBox["Dynamic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dynamic"]], "InlineFormula"],
 " now depends only on the value of ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 ", the number of sliders, not on the value of ",
 Cell[BoxData[
  StyleBox["data", "TI"]], "InlineFormula"],
 ". (Technically this is because ",
 Cell[BoxData[
  ButtonBox["Dynamic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dynamic"]], "InlineFormula"],
 " is ",
 Cell[BoxData[
  ButtonBox["HoldFirst",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HoldFirst"]], "InlineFormula"],
 ": when it is evaluated, the expression in its first argument is never \
touched by evaluation, and therefore no dependencies are registered.)"
}], "Text",
 CellID->1877249373],

Cell[TextData[{
 "When building large, complex interfaces using multiple levels of nested ",
 Cell[BoxData[
  ButtonBox["Dynamic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dynamic"]], "InlineFormula"],
 " expressions, these are important issues to keep in mind. ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " works hard to do exactly the right thing even in the most complex cases. \
For example, the output of ",
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 " consists of a highly complex set of interrelated and nested ",
 Cell[BoxData[
  ButtonBox["Dynamic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dynamic"]], "InlineFormula"],
 " expressions: if the dependency tracking system did not work correctly, ",
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 " would not work right."
}], "Text",
 CellID->100470287]
}, Open  ]],

Cell[CellGroupData[{

Cell["Synchronous Versus Asynchronous Dynamic Evaluations", "Section",
 CellID->681967067],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " consists of two separate processes, the front end and the kernel. These \
really are separate processes in the computer science sense of the word: two \
independent threads of execution with separate memory spaces that show up \
separately in a CPU task monitor."
}], "Text",
 CellID->700271030],

Cell[TextData[{
 "The front end and kernel communicate with each other through several ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " connections, known as the main link, the preemptive link, and the service \
link. The main and preemptive links are pathways by which the front end can \
send evaluation requests to the kernel, and the kernel can respond with \
results. The service link works in reverse, with the kernel sending requests \
to the front end."
}], "Text",
 CellID->1244815650],

Cell[TextData[{
 "The main link is used for ",
 StyleBox["Shift", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["Return", "KeyEvent"],
 " evaluations. The front end maintains a queue of pending evaluation \
requests to send down this link. When you use ",
 StyleBox["Shift", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["Return", "KeyEvent"],
 " on one or more input cells, they are all added to the queue, and then \
processed one by one. At any one time, the kernel is only aware of a single \
main link evaluation, the one it is currently working on (if any). In the \
meantime, the front end remains fully functional; you can type, open and save \
files, and so on. There is no arbitrary limit on how long a main link \
evaluation can reasonably take. People routinely do evaluations that take \
days to complete."
}], "Text",
 CellID->830940476],

Cell[TextData[{
 "The preemptive link works the same way as the main link in the sense that \
the front end can send an evaluation to it and get an answer, but it is \
administered quite differently on both ends. On the front end side, the \
preemptive link is used to handle normal ",
 Cell[BoxData[
  ButtonBox["Dynamic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dynamic"]], "InlineFormula"],
 " updates. There is no queue; instead, the front end sends one evaluation at \
a time and waits for the result before continuing with its other work. It is \
thus important to limit preemptive link evaluations to a couple of seconds at \
most. During any ",
 "preemptive",
 " link evaluation, the front end is completely locked up, and no typing or \
other actions are possible."
}], "Text",
 CellID->626355940],

Cell["\<\
On the kernel side, evaluation requests coming from the preemptive link are \
given priority over evaluations from the main link, including the current \
running main link evaluation (if any). If an evaluation request comes from \
the preemptive link while the kernel is processing a main link evaluation, \
the main link evaluation is halted at a safe point (usually within \
microseconds). The preemptive link evaluation is then run to completion, \
after which the main link evaluation is restarted and allowed to continue as \
before. The net effect is similar to, though not the same as, a threading \
mechanism. Multiple fast preemptive link evaluations can be executed during a \
single long, slow main link evaluation, giving the impression that the kernel \
is working on more than one problem at a time.\
\>", "Text",
 CellID->199445986],

Cell["\<\
Preemptive link evaluations can change the values of variables, including \
those being used by a main link evaluation running at the same time. There is \
no paradox here, and the interleaving is done in a way that is entirely safe, \
though it can result in some fairly peculiar behavior until you understand \
what is going on.\
\>", "Text",
 CellID->1099589122],

Cell["For example, evaluate this to get a slider.", "MathCaption",
 CellID->1697591019],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Slider", "[", 
  RowBox[{"Dynamic", "[", "x", "]"}], "]"}]], "Input",
 CellLabel->"In[24]:=",
 CellID->2092005938],

Cell[BoxData[
 SliderBox[Dynamic[$CellContext`x]]], "Output",
 ImageSize->{204, 25},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[24]=",
 CellID->110935607]
}, Open  ]],

Cell["\<\
Then evaluate this command, and during the ten seconds it takes to finish, \
drag the slider around randomly.\
\>", "MathCaption",
 CellID->1741531282],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Pause", "[", "1", "]"}], ";", "x"}], ",", 
   RowBox[{"{", "10", "}"}]}], "]"}]], "Input",
 CellLabel->"In[25]:=",
 CellID->1861631611],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0", ",", "0.2`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.5`", ",", 
   "0.675`", ",", "0.`", ",", "0.`", ",", "0.`"}], "}"}]], "Output",
 ImageSize->{287, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[25]=",
 CellID->150617166]
}, Open  ]],

Cell[TextData[{
 "You will not see anything happening (other than the slider moving) but when \
the second evaluation finishes, you will see that it has recorded ten \
different values of ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 ", representing the positions the slider happened to be at during the ten \
points at which ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " was evaluated to build the list."
}], "Text",
 CellID->1753232934],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Dynamic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dynamic"]], "InlineFormula"],
 " normally uses the preemptive link for its evaluations. Evaluation is \
synchronous, and the front end locks up until it is finished. This is \
unavoidable in some cases, but can be suboptimal in others. By setting the \
option ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["SynchronousUpdating",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SynchronousUpdating"], "->", 
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"]}]], "InlineFormula"],
 ", you can tell the front end to use the main link queue, rather than the \
preemptive link. The front end then displays a gray box placeholder until it \
receives the response from the kernel."
}], "Text",
 CellID->511345412],

Cell[TextData[{
 "In this case, the default (synchronous) update is appropriate because the \
front end needs to know the result of evaluating the ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Dynamic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Dynamic"], "[", 
   StyleBox["x", "TI"], "]"}]], "InlineFormula"],
 " for drawing with the correct font size."
}], "MathCaption",
 CellID->687238374],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DynamicModule", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "=", "12"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Slider", "[", 
      RowBox[{
       RowBox[{"Dynamic", "[", "x", "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"10", ",", "100"}], "}"}]}], "]"}], ",", 
     RowBox[{"Style", "[", 
      RowBox[{"\"\<Hello\>\"", ",", 
       RowBox[{"FontSize", "\[Rule]", 
        RowBox[{"Dynamic", "[", "x", "]"}]}]}], "]"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[26]:=",
 CellID->2100267837],

Cell[BoxData[
 DynamicModuleBox[{$CellContext`x$$ = 12}, 
  RowBox[{"{", 
   RowBox[{
    SliderBox[Dynamic[$CellContext`x$$], {10, 100}], ",", 
    StyleBox["\<\"Hello\"\>",
     StripOnInput->False,
     FontSize->Dynamic[$CellContext`x$$]]}], "}"}],
  DynamicModuleValues:>{}]], "Output",
 ImageSize->{265, 25},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[26]=",
 CellID->1686972796]
}, Open  ]],

Cell["\<\
Here, the output cell is drawn before the second dynamic expression finishes. \
A gray box placeholder persists for one second until the result is known. \
Reevaluate the example to see the gray box again.\
\>", "MathCaption",
 CellID->1105154106],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DynamicModule", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"n", "=", "1"}], "}"}], ",", 
   RowBox[{"Column", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Slider", "[", 
       RowBox[{
        RowBox[{"Dynamic", "[", "n", "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", "10"}], "}"}]}], "]"}], ",", 
      RowBox[{"Dynamic", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Pause", "[", "n", "]"}], ";", "n"}], ",", 
        RowBox[{"SynchronousUpdating", "\[Rule]", "False"}]}], "]"}]}], "}"}],
     "]"}]}], "]"}]], "Input",
 CellLabel->"In[27]:=",
 CellID->738996639],

Cell[BoxData[
 DynamicModuleBox[{$CellContext`n$$ = 1}, 
  TagBox[GridBox[{
     {
      SliderBox[Dynamic[$CellContext`n$$], {1, 10}]},
     {
      DynamicBox[ToBoxes[
       Pause[$CellContext`n$$]; $CellContext`n$$, StandardForm],
       ImageSizeCache->{7., {0., 8.}},
       SynchronousUpdating->False]}
    },
    GridBoxAlignment->{"Columns" -> {{Left}}}],
   "Column"],
  DynamicModuleValues:>{}]], "Output",
 ImageSize->{204, 41},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[27]=",
 CellID->1872674678]
}, Open  ]],

Cell[TextData[{
 "Clicking the slider will update the display with a delay of between one and \
ten seconds. Notice that the cell bracket is outlined, just as if the cell \
were being ",
 StyleBox["Shift", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["Return", "KeyEvent"],
 " evaluated. This is an indication that the evaluation is queued, and that \
you can continue with other work in the front end while the evaluation is \
progressing."
}], "Text",
 CellID->1418581072],

Cell[TextData[{
 "Asynchronous updating is useful for displaying full ",
 Cell[BoxData[
  ButtonBox["Dynamic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dynamic"]], "InlineFormula"],
 " subexpressions when it is possible to draw a screen around them and fill \
in their value later, in much the same way a web browser draws text around an \
image that is inserted later when it finishes downloading. "
}], "Reference",
 CellID->1199546089],

Cell[TextData[{
 "Why not always use asynchronous ",
 Cell[BoxData[
  ButtonBox["Dynamic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dynamic"]], "InlineFormula"],
 " expressions? There are several reasons. First, they are queued so that, by \
definition, they do not operate while another ",
 StyleBox["Shift", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["Return", "KeyEvent"],
 " evaluation is underway. This is not the case for normal (synchronous) \
updates. "
}], "Text",
 CellID->728628110],

Cell[TextData[{
 "A synchronous ",
 Cell[BoxData[
  ButtonBox["Dynamic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dynamic"]], "InlineFormula"],
 " updates smoothly even if the ",
 Cell[BoxData[
  ButtonBox["Pause",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Pause"]], "InlineFormula"],
 " command above is running. "
}], "MathCaption",
 CellID->1754296811],

Cell[BoxData[
 RowBox[{"Pause", "[", "20", "]"}]], "Input",
 CellLabel->"In[28]:=",
 CellID->1100889576],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DynamicModule", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"n", "=", "1"}], "}"}], ",", 
   RowBox[{"Column", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Slider", "[", 
       RowBox[{
        RowBox[{"Dynamic", "[", "n", "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", "10"}], "}"}]}], "]"}], ",", 
      RowBox[{"Dynamic", "[", "n", "]"}]}], "}"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[29]:=",
 CellID->1663512814],

Cell[BoxData[
 DynamicModuleBox[{$CellContext`n$$ = 1}, 
  TagBox[GridBox[{
     {
      SliderBox[Dynamic[$CellContext`n$$], {1, 10}]},
     {
      DynamicBox[ToBoxes[$CellContext`n$$, StandardForm],
       ImageSizeCache->{7., {0., 8.}}]}
    },
    GridBoxAlignment->{"Columns" -> {{Left}}}],
   "Column"],
  DynamicModuleValues:>{}]], "Output",
 ImageSize->{204, 41},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[29]=",
 CellID->522982714]
}, Open  ]],

Cell["\<\
Also, many controls need to be synchronous in order to be responsive to mouse \
actions. Making them asynchronous may cause potentially strange interactions \
with other controls.\
\>", "Text",
 CellID->217699674],

Cell["Here is a problematic example.", "MathCaption",
 CellID->2060749237],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"n", "=", "1"}], ";"}], "\n", 
 RowBox[{"Column", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Slider", "[", 
     RowBox[{
      RowBox[{"Dynamic", "[", "n", "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "10"}], "}"}]}], "]"}], ",", 
    RowBox[{"Dynamic", "[", 
     RowBox[{
      RowBox[{"Graphics", "[", 
       RowBox[{"Line", "[", 
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"x", ",", 
            RowBox[{"Sin", "[", 
             RowBox[{"n", " ", "x"}], "]"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"x", ",", "0", ",", 
            RowBox[{"2", "Pi"}], ",", "0.0001"}], "}"}]}], "]"}], "]"}], 
       "]"}], ",", 
      RowBox[{"SynchronousUpdating", "\[Rule]", "False"}]}], "]"}]}], "}"}], 
  "]"}]}], "Input",
 CellLabel->"In[30]:=",
 CellID->1713770077],

Cell[BoxData[
 TagBox[GridBox[{
    {
     SliderBox[Dynamic[$CellContext`n], {1, 10}]},
    {
     DynamicBox[ToBoxes[
       Graphics[
        Line[
         Table[{$CellContext`x, 
           Sin[$CellContext`n $CellContext`x]}, {$CellContext`x, 0, 2 Pi, 
           0.0001}]]], StandardForm],
      ImageSizeCache->{360., {60., 65.}},
      SynchronousUpdating->False]}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}}],
  "Column"]], "Output",
 ImageSize->{364, 155},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[31]=",
 CellID->119907027]
}, Open  ]],

Cell[TextData[{
 "Move the slider around rapidly, and you will end up with a choppy, \
distorted sine wave, because the value of ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " changed ",
 StyleBox["during",
  FontSlant->"Italic"],
 " the evaluation of the ",
 Cell[BoxData[
  ButtonBox["Table",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Table"]], "InlineFormula"],
 " command. This is the correct, expected behavior, but ",
 "it is",
 " probably not what you wanted."
}], "Text",
 CellID->1283010575],

Cell[TextData[{
 "This problem does not occur if you use synchronous ",
 Cell[BoxData[
  ButtonBox["Dynamic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dynamic"]], "InlineFormula"],
 " expressions, generally does not happen with ",
 Cell[BoxData[
  ButtonBox["DynamicModule",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DynamicModule"]], "InlineFormula"],
 " local variables, and can be avoided by storing the value of any \
potentially changing variables into a second variable before starting the \
asynchronous evaluations. "
}], "Text",
 CellID->675434498],

Cell["This fixes the problem.", "MathCaption",
 CellID->400621424],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"n", "=", "1"}], ";"}], "\n", 
 RowBox[{"Column", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Slider", "[", 
     RowBox[{
      RowBox[{"Dynamic", "[", "n", "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "10"}], "}"}]}], "]"}], ",", 
    RowBox[{"Dynamic", "[", 
     RowBox[{
      RowBox[{"Module", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"n1", "=", "n"}], "}"}], ",", 
        RowBox[{"Graphics", "[", 
         RowBox[{"Line", "[", 
          RowBox[{"Table", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"x", ",", 
              RowBox[{"Sin", "[", 
               RowBox[{"n1", " ", "x"}], "]"}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"x", ",", "0", ",", 
              RowBox[{"2", "Pi"}], ",", "0.0001"}], "}"}]}], "]"}], "]"}], 
         "]"}]}], "]"}], ",", 
      RowBox[{"SynchronousUpdating", "\[Rule]", "False"}]}], "]"}]}], "}"}], 
  "]"}]}], "Input",
 CellLabel->"In[32]:=",
 CellID->429049844],

Cell[BoxData[
 TagBox[GridBox[{
    {
     SliderBox[Dynamic[$CellContext`n], {1, 10}]},
    {
     DynamicBox[ToBoxes[
       Module[{$CellContext`n1 = $CellContext`n}, 
        Graphics[
         Line[
          Table[{$CellContext`x, 
            Sin[$CellContext`n1 $CellContext`x]}, {$CellContext`x, 0, 2 Pi, 
            0.0001}]]]], StandardForm],
      ImageSizeCache->{360., {60., 65.}},
      SynchronousUpdating->False]}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}}],
  "Column"]], "Output",
 ImageSize->{364, 155},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[33]=",
 CellID->937741903]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
ControlActive and SynchronousUpdating\[Rule]Automatic\
\>", "Section",
 CellID->1938125129],

Cell[TextData[{
 "As a general rule, if you have a ",
 Cell[BoxData[
  ButtonBox["Dynamic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dynamic"]], "InlineFormula"],
 " that is meant to respond interactively to the movements of a slider or \
other continuous\[Hyphen]action control, it should be able to evaluate in \
under a second, preferably well under",
 ". ",
 "If the evaluation takes longer than that, you are not going to get \
satisfactory interactive performance, whether the ",
 Cell[BoxData[
  ButtonBox["Dynamic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dynamic"]], "InlineFormula"],
 " is updating synchronously or asynchronously."
}], "Text",
 CellID->1037085407],

Cell[TextData[{
 "But what if you have an example that simply cannot finish evaluating fast \
enough, yet you want to be able to make it respond to a slider? One option is \
to use asynchronous updating and simply accept that you will not get real\
\[Hyphen]time interactive performance. If that is what you want to do, \
setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ContinuousAction",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ContinuousAction"], "->", 
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"]}]], "InlineFormula"],
 " in the slider or other control is a good idea; that way you get only one \
update after the control is released, avoiding the starting up of potentially \
lengthy evaluations in the middle of a drag, before you have arrived at the \
value you want to stop at."
}], "Text",
 CellID->1317156397],

Cell["\<\
The cell bracket becomes outlined, indicating evaluation activity, only after \
you release the slider.\
\>", "MathCaption",
 CellID->1186131103],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DynamicModule", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"n", "=", "1"}], "}"}], ",", 
   RowBox[{"Column", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Slider", "[", 
       RowBox[{
        RowBox[{"Dynamic", "[", "n", "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", "10"}], "}"}], ",", 
        RowBox[{"ContinuousAction", "\[Rule]", "False"}]}], "]"}], ",", 
      RowBox[{"Dynamic", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Pause", "[", "n", "]"}], ";", "n"}], ",", 
        RowBox[{"SynchronousUpdating", "\[Rule]", "False"}]}], "]"}]}], "}"}],
     "]"}]}], "]"}]], "Input",
 CellLabel->"In[34]:=",
 CellID->214753020],

Cell[BoxData[
 DynamicModuleBox[{$CellContext`n$$ = 1}, 
  TagBox[GridBox[{
     {
      SliderBox[Dynamic[$CellContext`n$$], {1, 10},
       ContinuousAction->False]},
     {
      DynamicBox[ToBoxes[
       Pause[$CellContext`n$$]; $CellContext`n$$, StandardForm],
       ImageSizeCache->{7., {0., 8.}},
       SynchronousUpdating->False]}
    },
    GridBoxAlignment->{"Columns" -> {{Left}}}],
   "Column"],
  DynamicModuleValues:>{}]], "Output",
 ImageSize->{204, 41},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[34]=",
 CellID->245678388]
}, Open  ]],

Cell["\<\
Another, much better solution is to provide a fast\[Hyphen]to\[Hyphen]compute \
preview of some sort during the interactive control dragging operation, then \
compute the full, slow output when the control is released. Several features \
exist specifically to support this.\
\>", "Text",
 CellID->1581480180],

Cell[TextData[{
 "The first is the function ",
 Cell[BoxData[
  ButtonBox["ControlActive",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ControlActive"]], "InlineFormula"],
 ", which returns its first argument if a control is currently being dragged, \
and its second argument if not. Unlike ",
 Cell[BoxData[
  ButtonBox["Dynamic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dynamic"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["ControlActive",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ControlActive"]], "InlineFormula"],
 " is an ordinary function that evaluates in the kernel, returning one or the \
other of its arguments immediately. It can be embedded inside functions or \
option values."
}], "Reference",
 CellID->194639787],

Cell[TextData[{
 "The second feature is an option setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["SynchronousUpdating",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SynchronousUpdating"], "->", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 " for ",
 Cell[BoxData[
  ButtonBox["Dynamic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dynamic"]], "InlineFormula"],
 ", which makes the ",
 Cell[BoxData[
  ButtonBox["Dynamic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dynamic"]], "InlineFormula"],
 " synchronous when a control is being dragged, and asynchronous when the \
control is released. Together, these two features can be used to implement a \
fast, synchronously updated display to be used while a control is being \
dragged, together with a slower, asynchronously updated display when it is \
released."
}], "Text",
 CellID->693305728],

Cell["\<\
The displayed text changes depending on whether or not the slider is being \
dragged.\
\>", "MathCaption",
 CellID->343066992],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DynamicModule", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"n", "=", "1"}], "}"}], ",", 
   RowBox[{"Column", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Slider", "[", 
       RowBox[{
        RowBox[{"Dynamic", "[", "n", "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", "10"}], "}"}]}], "]"}], ",", 
      RowBox[{"Dynamic", "[", 
       RowBox[{"{", 
        RowBox[{"n", ",", 
         RowBox[{"ControlActive", "[", 
          RowBox[{"\"\<Active\>\"", ",", "\"\<Not Active\>\""}], "]"}]}], 
        "}"}], "]"}]}], "}"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[35]:=",
 CellID->1867143432],

Cell[BoxData[
 DynamicModuleBox[{$CellContext`n$$ = 1}, 
  TagBox[GridBox[{
     {
      SliderBox[Dynamic[$CellContext`n$$], {1, 10}]},
     {
      DynamicBox[ToBoxes[{$CellContext`n$$, 
         ControlActive["Active", "Not Active"]}, StandardForm],
       ImageSizeCache->{74.1875, {2., 8.}}]}
    },
    GridBoxAlignment->{"Columns" -> {{Left}}}],
   "Column"],
  DynamicModuleValues:>{}]], "Output",
 ImageSize->{204, 41},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[35]=",
 CellID->1653097582]
}, Open  ]],

Cell["\<\
A simple number is displayed, synchronously, while the slider is being \
dragged, and when it is released, a graphic is generated asynchronously.\
\>", "MathCaption",
 CellID->671323377],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DynamicModule", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"n", "=", "3"}], "}"}], ",", 
   RowBox[{"Column", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Slider", "[", 
       RowBox[{
        RowBox[{"Dynamic", "[", "n", "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"3", ",", "1000", ",", "1"}], "}"}]}], "]"}], ",", 
      RowBox[{"Dynamic", "[", 
       RowBox[{
        RowBox[{"Graphics", "[", 
         RowBox[{
          RowBox[{"ControlActive", "[", 
           RowBox[{
            RowBox[{"Inset", "[", 
             RowBox[{"n", ",", 
              RowBox[{"{", 
               RowBox[{"0", ",", "0"}], "}"}]}], "]"}], ",", 
            RowBox[{"Line", "[", 
             RowBox[{"Table", "[", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{"0", ",", "0"}], "}"}], ",", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"Cos", "[", "t", "]"}], ",", 
                   RowBox[{"Sin", "[", "t", "]"}]}], "}"}]}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"t", ",", "0.", ",", 
                 RowBox[{"2", "Pi"}], ",", 
                 RowBox[{"2", 
                  RowBox[{"Pi", "/", "n"}]}]}], "}"}]}], "]"}], "]"}]}], 
           "]"}], ",", 
          RowBox[{"ImageSize", "\[Rule]", "300"}], ",", 
          RowBox[{"PlotRange", "\[Rule]", "1"}]}], "]"}], ",", 
        RowBox[{"SynchronousUpdating", "\[Rule]", "Automatic"}]}], "]"}]}], 
     "}"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[36]:=",
 CellID->1118194978],

Cell[BoxData[
 DynamicModuleBox[{$CellContext`n$$ = 192}, 
  TagBox[GridBox[{
     {
      SliderBox[Dynamic[$CellContext`n$$], {3, 1000, 1}]},
     {
      DynamicBox[ToBoxes[
        Graphics[
         ControlActive[
          Inset[$CellContext`n$$, {0, 0}], 
          Line[
           Table[{{0, 0}, {
              Cos[$CellContext`t], 
              Sin[$CellContext`t]}}, {$CellContext`t, 0., 2 Pi, 
             2 (Pi/$CellContext`n$$)}]]], ImageSize -> 300, PlotRange -> 1], 
        StandardForm],
       ImageSizeCache->{300., {148., 152.}},
       SynchronousUpdating->Automatic]}
    },
    GridBoxAlignment->{"Columns" -> {{Left}}}],
   "Column"],
  DynamicModuleValues:>{}]], "Output",
 ImageSize->{304, 331},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[36]=",
 CellID->1615119435]
}, Open  ]],

Cell["\<\
This example shows that the front end can remain responsive no matter how \
long the final display takes to compute and that the preview and the final \
display can be completely different.\
\>", "Reference",
 CellID->143101874],

Cell[TextData[{
 "Of course, in most cases, you will want a preview that is some kind of \
reduced, thinned out, skeletal, or other elided form of the final display. \
Then the crude form can be fast enough to give a smooth preview, and the \
computation of the final version, even if it takes awhile, does not block the \
front end. In fact, this behavior is so useful that it is the default in ",
 Cell[BoxData[
  ButtonBox["Plot3D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Plot3D"]], "InlineFormula"],
 " and other plotting functions."
}], "Reference",
 CellID->2078995325],

Cell["\<\
This displays a 3D plot with a very small number of plot points while the \
control is being dragged and then refines the image with a large number of \
plot points when the control is released.\
\>", "MathCaption",
 CellID->1349818222],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DynamicModule", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"n", "=", "1"}], "}"}], ",", 
   RowBox[{"Column", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Slider", "[", 
       RowBox[{
        RowBox[{"Dynamic", "[", "n", "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", "5"}], "}"}]}], "]"}], ",", 
      RowBox[{"Dynamic", "[", 
       RowBox[{
        RowBox[{"Plot3D", "[", 
         RowBox[{
          RowBox[{"Sin", "[", 
           RowBox[{"n", " ", "x", " ", "y"}], "]"}], ",", 
          RowBox[{"{", 
           RowBox[{"x", ",", "0", ",", "3"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"y", ",", "0", ",", "3"}], "}"}], ",", 
          RowBox[{"PlotPoints", "\[Rule]", 
           RowBox[{"ControlActive", "[", 
            RowBox[{"10", ",", "100"}], "]"}]}], ",", 
          RowBox[{"MaxRecursion", "\[Rule]", "0"}]}], "]"}], ",", 
        RowBox[{"SynchronousUpdating", "\[Rule]", "Automatic"}]}], "]"}]}], 
     "}"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[37]:=",
 CellID->377610246],

Cell[BoxData[
 DynamicModuleBox[{$CellContext`n$$ = 1.37}, 
  TagBox[GridBox[{
     {
      SliderBox[Dynamic[$CellContext`n$$], {1, 5}]},
     {
      DynamicBox[ToBoxes[
        Plot3D[
         Sin[($CellContext`n$$ $CellContext`x) $CellContext`y], \
{$CellContext`x, 0, 3}, {$CellContext`y, 0, 3}, PlotPoints -> 
         ControlActive[10, 100], MaxRecursion -> 0], StandardForm],
       ImageSizeCache->{180., {70., 74.}},
       SynchronousUpdating->Automatic]}
    },
    GridBoxAlignment->{"Columns" -> {{Left}}}],
   "Column"],
  DynamicModuleValues:>{}]], "Output",
 ImageSize->{204, 175},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[37]=",
 CellID->1119045965]
}, Open  ]],

Cell[TextData[{
 "By default, ",
 Cell[BoxData[
  ButtonBox["Plot3D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Plot3D"]], "InlineFormula"],
 " produces a similar preview, though with a somewhat less extreme spread of \
quality."
}], "MathCaption",
 CellID->1235109669],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DynamicModule", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"n", "=", "1"}], "}"}], ",", 
   RowBox[{"Column", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Slider", "[", 
       RowBox[{
        RowBox[{"Dynamic", "[", "n", "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", "5"}], "}"}]}], "]"}], ",", 
      RowBox[{"Dynamic", "[", 
       RowBox[{
        RowBox[{"Plot3D", "[", 
         RowBox[{
          RowBox[{"Sin", "[", 
           RowBox[{"n", " ", "x", " ", "y"}], "]"}], ",", 
          RowBox[{"{", 
           RowBox[{"x", ",", "0", ",", "3"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"y", ",", "0", ",", "3"}], "}"}]}], "]"}], ",", 
        RowBox[{"SynchronousUpdating", "\[Rule]", "Automatic"}]}], "]"}]}], 
     "}"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[38]:=",
 CellID->1273405741],

Cell[BoxData[
 DynamicModuleBox[{$CellContext`n$$ = 1.44}, 
  TagBox[GridBox[{
     {
      SliderBox[Dynamic[$CellContext`n$$], {1, 5}]},
     {
      DynamicBox[ToBoxes[
        Plot3D[
         Sin[($CellContext`n$$ $CellContext`x) $CellContext`y], \
{$CellContext`x, 0, 3}, {$CellContext`y, 0, 3}], StandardForm],
       ImageSizeCache->{180., {70., 74.}},
       SynchronousUpdating->Automatic]}
    },
    GridBoxAlignment->{"Columns" -> {{Left}}}],
   "Column"],
  DynamicModuleValues:>{}]], "Output",
 ImageSize->{204, 175},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[38]=",
 CellID->143753329]
}, Open  ]],

Cell[TextData[{
 "In addition, ",
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 " uses ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["SynchronousUpdating",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SynchronousUpdating"], "->", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 " in ",
 Cell[BoxData[
  ButtonBox["Dynamic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dynamic"]], "InlineFormula"],
 " by default so the example becomes as simple as it can be."
}], "MathCaption",
 CellID->308262985],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"Plot3D", "[", 
    RowBox[{
     RowBox[{"Sin", "[", 
      RowBox[{"n", " ", "x", " ", "y"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", "0", ",", "3"}], "}"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "1", ",", "5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[39]:=",
 CellID->1245432331],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`n$$ = 1.415, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`n$$], 1, 5}}, Typeset`size$$ = {180., {70., 74.}}, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`n$1642$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`n$$ = 1}, 
      "ControllerVariables" :> {
        Hold[$CellContext`n$$, $CellContext`n$1642$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Plot3D[
        Sin[($CellContext`n$$ $CellContext`x) $CellContext`y], \
{$CellContext`x, 0, 3}, {$CellContext`y, 0, 3}], 
      "Specifications" :> {{$CellContext`n$$, 1, 5}}, "Options" :> {}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{250., {113., 118.}}],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{254, 233},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[39]=",
 CellID->143097628]
}, Open  ]],

Cell["\<\
You may have noticed one subtlety. When the output of either of the above \
three examples is first placed in the notebook, you see a crudely drawn \
(control\[Hyphen]active state) version, followed shortly thereafter by a \
refined (control\[Hyphen]inactive) version. This is intentional: the system \
is providing a fast preview so you see something rather than just a gray \
rectangle. The first update is done synchronously, just as if a control were \
being dragged.\
\>", "Text",
 CellID->458079808],

Cell["\<\
This preview\[Hyphen]evaluation behavior is examined in more detail in the \
next section.\
\>", "Text",
 CellID->218458561]
}, Open  ]],

Cell[CellGroupData[{

Cell["ImageSizeCache in Dynamic", "Section",
 CellID->1583482004],

Cell[TextData[{
 Cell[BoxData["ImageSizeCache"], "InlineFormula"],
 " is an option to ",
 Cell[BoxData[
  ButtonBox["Dynamic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dynamic"]], "InlineFormula"],
 " that specifies a rectangular size to be used in displaying a ",
 Cell[BoxData[
  ButtonBox["Dynamic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dynamic"]], "InlineFormula"],
 " whose value has not yet been computed. It is normally not specified in \
input, but is instead generated automatically by the front end and saved in \
files along with the ",
 Cell[BoxData[
  ButtonBox["Dynamic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dynamic"]], "InlineFormula"],
 " expression."
}], "Reference",
 CellID->2115490585],

Cell[TextData[{
 "The interaction of ",
 Cell[BoxData[
  ButtonBox["ControlActive",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ControlActive"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["SynchronousUpdating",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SynchronousUpdating"]], "InlineFormula"],
 ", and ",
 Cell[BoxData["ImageSizeCache"], "InlineFormula"],
 " is subtle, complex, and very useful. The first two constructs are \
explained in ",
 ButtonBox["ControlActive and SynchronousUpdating\[Rule]Automatic",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/AdvancedDynamicFunctionality#1938125129"],
 ". The remaining part is explained here."
}], "Text",
 CellID->1964687604],

Cell[TextData[{
 "Note first that ",
 Cell[BoxData[
  ButtonBox["Dynamic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dynamic"]], "InlineFormula"],
 " expressions with the default value of ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["SynchronousUpdating",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SynchronousUpdating"], "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 " will never have a chance to use the value of their ",
 Cell[BoxData["ImageSizeCache"], "InlineFormula"],
 " option, because they are always computed before being displayed, and, once \
computed, the actual image size will be used."
}], "Reference",
 CellID->1311002363],

Cell[TextData[{
 "On the other hand, ",
 Cell[BoxData[
  ButtonBox["Dynamic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dynamic"]], "InlineFormula"],
 " expressions with ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["SynchronousUpdating",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SynchronousUpdating"], "\[Rule]", 
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"]}]], "InlineFormula"],
 " will be displayed as a gray rectangle while they are being computed for \
the first time. In that case, the size of the rectangle is determined by the \
value of the ",
 Cell[BoxData["ImageSizeCache"], "InlineFormula"],
 " option. This allows the surrounding contents of the notebook to be drawn \
in the right place, so that when the ",
 Cell[BoxData[
  ButtonBox["Dynamic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dynamic"]], "InlineFormula"],
 " finishes updating, there is no unnecessary flicker and shifting around of \
the contents of the notebook. (Users of HTML will recognize this as the \
analog of the width and height parameters of the ",
 Cell[BoxData["img"], "InlineFormula"],
 " tag.)"
}], "Text",
 CellID->1766212729],

Cell[TextData[{
 "It is generally not necessary to specify the ",
 Cell[BoxData["ImageSizeCache"], "InlineFormula"],
 " option explicitly, because the system will set it automatically as soon as \
the value of the ",
 Cell[BoxData[
  ButtonBox["Dynamic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dynamic"]], "InlineFormula"],
 " is computed successfully. (The computed result is measured, and the actual \
size copied into the ",
 Cell[BoxData["ImageSizeCache"], "InlineFormula"],
 " option.)  This automatically computed value is preserved if the ",
 Cell[BoxData[
  ButtonBox["Dynamic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dynamic"]], "InlineFormula"],
 " output is saved in a file."
}], "Text",
 CellID->70883822],

Cell["Consider the following input.", "MathCaption",
 CellID->1638455916],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Dynamic", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Pause", "[", "3", "]"}], ";", 
    RowBox[{"Style", "[", 
     RowBox[{"\"\<Hello\>\"", ",", "100"}], "]"}]}], ",", 
   RowBox[{"SynchronousUpdating", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[40]:=",
 CellID->345774731],

Cell[BoxData[
 DynamicBox[ToBoxes[Pause[3]; Style["Hello", 100], StandardForm],
  ImageSizeCache->{300., {1., 62.}},
  SynchronousUpdating->False]], "Output",
 ImageSize->{304, 66},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[40]=",
 CellID->2007632803]
}, Open  ]],

Cell[TextData[{
 "When the input expression is evaluated, a small gray rectangle appears; \
because this ",
 Cell[BoxData[
  ButtonBox["Dynamic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dynamic"]], "InlineFormula"],
 " has never been evaluated, there is no cache of its proper image size, and \
a default small size is used."
}], "Text",
 CellID->345155135],

Cell[TextData[{
 "Three seconds later, the result arrives, and the dynamic output is \
displayed. At this point an actual size is known, and is copied to the ",
 Cell[BoxData["ImageSizeCache"], "InlineFormula"],
 " option. You can see the value by clicking anywhere in the output cell and \
choosing ",
 StyleBox[ButtonBox["Show Expression",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/menuitem/ShowExpression"], "MenuName"],
 " from the ",
 StyleBox[ButtonBox["Cell",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/CellMenu"], "MenuName"],
 " menu. (This shows you the underlying expression representing the cell, \
exactly as it would appear in the notebook file if you were to save this \
cell.) Note the presence of an ",
 Cell[BoxData["ImageSizeCache"], "InlineFormula"],
 " option."
}], "Text",
 CellID->669023398],

Cell[TextData[{
 "Now type a space in some innocuous place in the raw cell expression (to \
force a reparsing of the cell contents), and choose ",
 StyleBox[ButtonBox["Show Expression",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/menuitem/ShowExpression"], "MenuName"],
 " again to reformat the cell. This time you will see a gray rectangle the \
size of the final output for three seconds, followed by the proper output. \
This is also what you would see if you opened a notebook containing \
previously saved, asynchronous dynamic output."
}], "Text",
 CellID->51874494],

Cell[TextData[{
 "The behavior of the setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["SynchronousUpdating",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SynchronousUpdating"], "->", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 " is similar, but subtly different. As we saw in the examples in ",
 ButtonBox["ControlActive and SynchronousUpdating\[Rule]Automatic",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/AdvancedDynamicFunctionality#1938125129"],
 ", with the ",
 Cell[BoxData[
  ButtonBox["Automatic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Automatic"]], "InlineFormula"],
 " setting, a synchronous preview\[Hyphen]evaluation is done when the output \
is first placed, to provide a (hopefully) rapid display of the contents of \
the ",
 Cell[BoxData[
  ButtonBox["Dynamic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dynamic"]], "InlineFormula"],
 " expression before the slower, asynchronous value is computed. Because the \
first evaluation is synchronous, no gray rectangle is ever displayed."
}], "Text",
 CellID->2123743623],

Cell[TextData[{
 "But this preview evaluation is done ",
 StyleBox["only if the ",
  FontSlant->"Italic"],
 Cell[BoxData["ImageSizeCache"], "InlineFormula"],
 StyleBox[" option is not present",
  FontSlant->"Italic"],
 ". A ",
 Cell[BoxData[
  ButtonBox["Dynamic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dynamic"]], "InlineFormula"],
 " with ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["SynchronousUpdating",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SynchronousUpdating"], "->", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 " and an ",
 Cell[BoxData["ImageSizeCache"], "InlineFormula"],
 " option specifying explicit dimensions will not do a synchronous preview \
evaluation, and will instead display a gray rectangle (of the correct size) \
pending the result of the first asynchronous evaluation."
}], "Text",
 CellID->433374974],

Cell[TextData[{
 "This may seem like baffling behavior at first, until you consider the \
practical effect of it. Generally speaking, ",
 Cell[BoxData[
  ButtonBox["Dynamic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dynamic"]], "InlineFormula"],
 " expressions will always have an ",
 Cell[BoxData["ImageSizeCache"], "InlineFormula"],
 " option (created automatically by the front end) except for the very first \
time they appear, when they are originally placed as output from an \
evaluation. Any time they are opened from a file they will have a known, \
cached size."
}], "Text",
 CellID->1616141041],

Cell[TextData[{
 "In ",
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 ", which accounts for the vast majority of dynamic outputs, the default \
setting is ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["SynchronousUpdating",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SynchronousUpdating"], "->", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 " and the described behavior lets the output show up cleanly with a preview \
image in place when it is first generated. When a file containing dozens of \
",
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 " outputs is opened, you will get a useful behavior that is familiar from \
web browsers: the text displays immediately, and graphics (and other dynamic \
content) fill in later as fast as they are able. So you can scroll through a \
file rapidly, without any delay associated with precomputing potentially many \
preview images before the first page of the file can be displayed."
}], "Text",
 CellID->834496721],

Cell[TextData[{
 "If the initial evaluations when the ",
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 " output was first placed were not synchronous, there would be flicker and \
resizing/shifting of the surroundings, because the size would not be known. \
But when the ",
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 " output is opened from a file, the size is known, and the final output can \
be placed smoothly without flicker",
 ". "
}], "Text",
 CellID->1847983010]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
One\[Hyphen]Sided Updating of ControlActive\
\>", "Section",
 CellID->2141946156],

Cell[TextData[{
 "After evaluating in the kernel, ",
 Cell[BoxData[
  ButtonBox["ControlActive",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ControlActive"]], "InlineFormula"],
 " can trigger an update of the ",
 Cell[BoxData[
  ButtonBox["Dynamic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dynamic"]], "InlineFormula"],
 " containing it, but in a highly asymmetric fashion, only when it is going \
from the active to the inactive state. When making a transition in the other \
direction, from inactive to active, ",
 Cell[BoxData[
  ButtonBox["ControlActive",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ControlActive"]], "InlineFormula"],
 " does not trigger any update on its own."
}], "Reference",
 CellID->170691290],

Cell[TextData[{
 "The reason for this somewhat unusual behavior is that ",
 Cell[BoxData[
  ButtonBox["ControlActive",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ControlActive"]], "InlineFormula"],
 " is a completely global concept. It returns the active state if any control \
anywhere in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " is currently being dragged\[LongDash]even controls that have nothing to do \
with a particular ",
 Cell[BoxData[
  ButtonBox["Dynamic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dynamic"]], "InlineFormula"],
 " that happen to contain a reference to ",
 Cell[BoxData[
  ButtonBox["ControlActive",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ControlActive"]], "InlineFormula"],
 ". If ",
 Cell[BoxData[
  ButtonBox["ControlActive",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ControlActive"]], "InlineFormula"],
 " caused updates on its own, then as soon as you clicked any control, all ",
 Cell[BoxData[
  ButtonBox["Dynamic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dynamic"]], "InlineFormula"],
 " expressions containing references to ",
 Cell[BoxData[
  ButtonBox["ControlActive",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ControlActive"]], "InlineFormula"],
 " (e.g., a default dynamic ",
 Cell[BoxData[
  ButtonBox["Plot3D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Plot3D"]], "InlineFormula"],
 " output) would immediately update, which would be entirely pointless. \
Instead, only those outputs that have some other reason for updating will \
pick up the current value of ",
 Cell[BoxData[
  ButtonBox["ControlActive",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ControlActive"]], "InlineFormula"],
 "."
}], "Reference",
 CellID->1917842285],

Cell[TextData[{
 "On the other hand, when the control is released, it is desirable to fix up \
any outputs that were drawn in control-active form, to give them their final \
polished appearance. Thus, when ",
 Cell[BoxData[
  ButtonBox["ControlActive",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ControlActive"]], "InlineFormula"],
 " is going into its inactive state, it needs to, on its own, issue updates \
to any ",
 Cell[BoxData[
  ButtonBox["Dynamic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dynamic"]], "InlineFormula"],
 " expression that may have been drawn in the active state."
}], "Reference",
 CellID->1593226172],

Cell[TextData[{
 "Dragging the slider does change the Active/Inactive display because ",
 Cell[BoxData[
  ButtonBox["ControlActive",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ControlActive"]], "InlineFormula"],
 " does not trigger updates on its own."
}], "MathCaption",
 CellID->1420669231],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DynamicModule", "[", 
  RowBox[{
   RowBox[{"{", "x", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Slider", "[", 
      RowBox[{"Dynamic", "[", "x", "]"}], "]"}], ",", 
     RowBox[{"Dynamic", "[", 
      RowBox[{"ControlActive", "[", 
       RowBox[{"\"\<Active\>\"", ",", "\"\<Inactive\>\""}], "]"}], "]"}]}], 
    "}"}]}], "]"}]], "Input",
 CellLabel->"In[49]:=",
 CellID->1464578071],

Cell[BoxData[
 DynamicModuleBox[{$CellContext`x$$ = 0.}, 
  RowBox[{"{", 
   RowBox[{
    SliderBox[Dynamic[$CellContext`x$$]], ",", 
    DynamicBox[ToBoxes[
      ControlActive["Active", "Inactive"], StandardForm],
     ImageSizeCache->{42., {0., 8.}}]}], "}"}],
  DynamicModuleValues:>{}]], "Output",
 ImageSize->{272, 25},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[49]=",
 CellID->1345995038]
}, Open  ]],

Cell[TextData[{
 "This Active/Inactive display updates because ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " in the dynamic output changes."
}], "MathCaption",
 CellID->545866168],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DynamicModule", "[", 
  RowBox[{
   RowBox[{"{", "x", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Slider", "[", 
      RowBox[{"Dynamic", "[", "x", "]"}], "]"}], ",", 
     RowBox[{"Dynamic", "[", 
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{"ControlActive", "[", 
         RowBox[{"\"\<Active\>\"", ",", "\"\<Inactive\>\""}], "]"}]}], "}"}], 
      "]"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[41]:=",
 CellID->467582888],

Cell[BoxData[
 DynamicModuleBox[{$CellContext`x$$ = 0.}, 
  RowBox[{"{", 
   RowBox[{
    SliderBox[Dynamic[$CellContext`x$$]], ",", 
    DynamicBox[ToBoxes[{$CellContext`x$$, 
       ControlActive["Active", "Inactive"]}, StandardForm],
     ImageSizeCache->{81.1875, {2., 8.}}]}], "}"}],
  DynamicModuleValues:>{}]], "Output",
 ImageSize->{311, 25},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[41]=",
 CellID->1021458357]
}, Open  ]],

Cell[TextData[{
 "Watch carefully what happens when you click the slider. If you click and \
hold the mouse without moving it, the display will remain ",
 Cell[BoxData["Inactive"], "InlineFormula"],
 ". But as soon as you move it, the display updates to ",
 Cell[BoxData["Active"], "InlineFormula"],
 ". This is happening because ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " changed, causing the ",
 Cell[BoxData[
  ButtonBox["Dynamic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dynamic"]], "InlineFormula"],
 " as a whole to update, thus picking up the current state of ",
 Cell[BoxData[
  ButtonBox["ControlActive",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ControlActive"]], "InlineFormula"],
 "."
}], "Text",
 CellID->1022934243],

Cell[TextData[{
 "Now carefully release the mouse button without moving it. Note that the \
display ",
 StyleBox["does",
  FontSlant->"Italic"],
 " revert to ",
 Cell[BoxData["Inactive"], "InlineFormula"],
 " even though ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " has changed."
}], "Text",
 CellID->1849227866]
}, Open  ]],

Cell[CellGroupData[{

Cell["DynamicModule Wormholes", "Section",
 CellID->1497695040],

Cell[TextData[{
 "The variables declared in a ",
 Cell[BoxData[
  ButtonBox["DynamicModule",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DynamicModule"]], "InlineFormula"],
 " are localized to a particular rectangular area within one cell in a \
notebook. There are situations in which it is desirable to extend the scope \
of such a local variable to other cells or even other windows. For example, \
you might want to have a button in one cell that opens a dialog box that \
allows you to modify the value of a variable declared in the same scope as \
the button that opened the dialog."
}], "Text",
 CellID->1104710793],

Cell[TextData[{
 "This can be done with one of the more surreal constructs in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", a ",
 Cell[BoxData[
  ButtonBox["DynamicModule",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DynamicModule"]], "InlineFormula"],
 " wormhole. ",
 Cell[BoxData[
  ButtonBox["DynamicModule",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DynamicModule"]], "InlineFormula"],
 " accepts the option ",
 Cell[BoxData["DynamicModuleParent"], "InlineFormula"],
 ", whose value is a ",
 Cell[BoxData["NotebookInterfaceObject"], "InlineFormula"],
 " that refers to another ",
 Cell[BoxData[
  ButtonBox["DynamicModule",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DynamicModule"]], "InlineFormula"],
 " anywhere in the front end. For purposes of variable localization, the ",
 Cell[BoxData[
  ButtonBox["DynamicModule",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DynamicModule"]], "InlineFormula"],
 " with this option will be treated as if it resided inside the one referred \
to, regardless of where the two actually are (even if they are in separate \
windows)."
}], "Text",
 CellID->1878169636],

Cell[TextData[{
 "The tricky part in setting up such a wormhole is getting the ",
 Cell[BoxData["NotebookInterfaceObject"], "InlineFormula"],
 " necessary to refer to the parent ",
 Cell[BoxData[
  ButtonBox["DynamicModule",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DynamicModule"]], "InlineFormula"],
 ". This reference can be created only after the ",
 Cell[BoxData[
  ButtonBox["DynamicModule",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DynamicModule"]], "InlineFormula"],
 " has been created and placed as output, and it is valid only for the \
current session."
}], "Text",
 CellID->534944999],

Cell[TextData[{
 "To make the process easier, and in fact avoid all reference to explicit ",
 Cell[BoxData["NotebookInterfaceObject"], "InlineFormula"],
 "s, ",
 Cell[BoxData[
  ButtonBox["DynamicModule",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DynamicModule"]], "InlineFormula"],
 " also accepts the option ",
 Cell[BoxData["InheritScope"], "InlineFormula"],
 ", which automatically generates the correct value of the ",
 Cell[BoxData["DynamicModuleParent"], "InlineFormula"],
 " option to make the new ",
 Cell[BoxData[
  ButtonBox["DynamicModule",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DynamicModule"]], "InlineFormula"],
 " function as if it were inside the scope of the ",
 Cell[BoxData[
  ButtonBox["DynamicModule",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DynamicModule"]], "InlineFormula"],
 " from which it was created. This is confusing, so an example is in order."
}], "Text",
 CellID->1454051851],

Cell[TextData[{
 "Evaluate this to create an output with a ",
 StyleBox["+", "DialogElementName"],
 " button and a number. "
}], "MathCaption",
 CellID->2073927461],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DynamicModule", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "=", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Button", "[", 
      RowBox[{"\"\<+\>\"", ",", 
       RowBox[{"++", "x"}]}], "]"}], ",", 
     RowBox[{"Button", "[", 
      RowBox[{"\"\<Make - Palette\>\"", ",", 
       RowBox[{"CreatePalette", "[", 
        RowBox[{"DynamicModule", "[", 
         RowBox[{
          RowBox[{"{", "}"}], ",", 
          RowBox[{"Button", "[", 
           RowBox[{"\"\<-\>\"", ",", 
            RowBox[{"--", "x"}]}], "]"}], ",", 
          RowBox[{"InheritScope", "\[Rule]", "True"}]}], "]"}], "]"}]}], 
      "]"}], ",", 
     RowBox[{"Dynamic", "[", "x", "]"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[42]:=",
 CellID->700115591],

Cell[BoxData[
 DynamicModuleBox[{$CellContext`x$$ = 1}, 
  RowBox[{"{", 
   RowBox[{
    ButtonBox["\<\"+\"\>",
     Appearance->Automatic,
     ButtonData->"paclet:ref/+",
     ButtonFrame->"DialogBox",
     ButtonFunction:>PreIncrement[$CellContext`x$$],
     Evaluator->Automatic,
     Method->"Preemptive"], ",", 
    ButtonBox["\<\"Make - Palette\"\>",
     Appearance->Automatic,
     ButtonData->"paclet:ref/Make - Palette",
     ButtonFrame->"DialogBox",
     ButtonFunction:>CreatePalette[
       DynamicModule[{}, 
        Button["-", 
         PreDecrement[$CellContext`x$$]], InheritScope -> True]],
     Evaluator->Automatic,
     Method->"Preemptive"], ",", 
    DynamicBox[ToBoxes[$CellContext`x$$, StandardForm],
     ImageSizeCache->{7., {0., 8.}}]}], "}"}],
  DynamicModuleValues:>{}]], "Output",
 ImageSize->{147, 25},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[42]=",
 CellID->666331981]
}, Open  ]],

Cell[TextData[{
 "Clicking the ",
 StyleBox["+", "DialogElementName"],
 " button increments the value of a ",
 Cell[BoxData[
  ButtonBox["DynamicModule",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DynamicModule"]], "InlineFormula"],
 " local variable, which is displayed at the end of the output. To decrement \
the number you have to click the ",
 StyleBox["Make - Palette", "DialogElementName"],
 " button, which creates a new (very small) floating palette window \
containing a ",
 StyleBox["-", "DialogElementName"],
 " button."
}], "Reference",
 CellID->378678361],

Cell[TextData[{
 "This ",
 StyleBox["-", "DialogElementName"],
 " button is living in a wormhole created by the ",
 Cell[BoxData["InheritScope"], "InlineFormula"],
 " option of the ",
 Cell[BoxData[
  ButtonBox["DynamicModule",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DynamicModule"]], "InlineFormula"],
 " containing it. Clicking the button decrements the value of a local, \
private variable in the scope of a distant ",
 Cell[BoxData[
  ButtonBox["DynamicModule",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DynamicModule"]], "InlineFormula"],
 " in another window."
}], "Text",
 CellID->611357727],

Cell[TextData[{
 Cell[BoxData["InheritScope"], "InlineFormula"],
 " can be used only when the code creating the second ",
 Cell[BoxData[
  ButtonBox["DynamicModule",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DynamicModule"]], "InlineFormula"],
 " is executed from inside a button or other dynamic object located within \
the first ",
 Cell[BoxData[
  ButtonBox["DynamicModule",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DynamicModule"]], "InlineFormula"],
 ". By using ",
 Cell[BoxData["DynamicModuleParent"], "InlineFormula"],
 " explicitly, it is possible to link up arbitrary existing ",
 Cell[BoxData[
  ButtonBox["DynamicModule",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DynamicModule"]], "InlineFormula"],
 "s, but doing so is tricky, and beyond the scope of this document."
}], "Text",
 CellID->1527550441],

Cell[CellGroupData[{

Cell["MORE ABOUT", "TutorialMoreAboutSection",
 CellID->406028304],

Cell[TextData[ButtonBox["Dynamic Interactivity Language",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/DynamicInteractivityLanguage"]], "TutorialMoreAbout",
 CellID->346793833],

Cell[TextData[ButtonBox["Dynamic Visualization",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DynamicVisualization"]], "TutorialMoreAbout",
 CellID->116159589]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->816272032],

Cell[TextData[ButtonBox["Introduction to Dynamic",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/IntroductionToDynamic"]], "RelatedTutorials",
 CellID->202479463],

Cell[TextData[ButtonBox["Introduction to Manipulate",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/IntroductionToManipulate"]], "RelatedTutorials",\

 CellID->894362159]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED WOLFRAM EDUCATION GROUP COURSES", "TutorialRelatedLinksSection",
 CellID->645287401],

Cell[TextData[ButtonBox["M205: Visualization and Dynamic Interactivity",
 BaseStyle->"Hyperlink",
 ButtonData->{
   URL["http://www.wolfram.com/services/education/minicourses/m205.html"], 
   None}]], "TutorialRelatedLinks",
 CellID->360440367]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Advanced Dynamic Functionality - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 32, 25.7474894}", "context" -> "", 
    "keywords" -> {"reactive programming"}, "index" -> True, "label" -> 
    "Mathematica Tutorial", "language" -> "en", "paclet" -> "Mathematica", 
    "status" -> "None", "summary" -> 
    "Introduction to Manipulate and Introduction to Dynamic provide most \
information you need to use Mathematica interactive features accessible \
through the functions Manipulate, Dynamic, and DynamicModule. This tutorial \
gives further details on the workings of Dynamic and DynamicModule and \
describes advanced features and techniques for achieving maximum performance \
for complex interactive examples. Many examples in this tutorial display a \
single output value and use Pause to simulate slow calculations. In real \
life, you will be instead doing useful computations and displaying \
sophisticated graphics or large tables of values. ", "synonyms" -> {}, 
    "title" -> "Advanced Dynamic Functionality", "type" -> "Tutorial", "uri" -> 
    "tutorial/AdvancedDynamicFunctionality"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1601, 39, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2226, 66, 68, 1, 70, "Title",
 CellID->1545190458],
Cell[2297, 69, 1276, 39, 70, "Text",
 CellID->1665666328],
Cell[3576, 110, 399, 10, 70, "Text",
 CellID->1867840383],
Cell[3978, 122, 350, 8, 70, "TextEmphasisNote",
 CellID->244159640],
Cell[CellGroupData[{
Cell[4353, 134, 66, 1, 70, "Section",
 CellID->877365235],
Cell[4422, 137, 36, 1, 70, "Text",
 CellID->971583106],
Cell[4461, 140, 561, 15, 70, "Text",
 CellID->1223356264],
Cell[5025, 157, 417, 12, 70, "Text",
 CellID->257152404],
Cell[5445, 171, 198, 4, 70, "MathCaption",
 CellID->302730972],
Cell[CellGroupData[{
Cell[5668, 179, 150, 5, 70, "Input",
 CellID->2079094401],
Cell[5821, 186, 162, 5, 36, "Output",
 CellID->179293073]
}, Open  ]],
Cell[5998, 194, 131, 4, 70, "MathCaption",
 CellID->1633177270],
Cell[CellGroupData[{
Cell[6154, 202, 185, 6, 70, "Input",
 CellID->1821884583],
Cell[6342, 210, 245, 7, 70, "Output",
 CellID->459121170]
}, Open  ]],
Cell[6602, 220, 386, 13, 70, "MathCaption",
 CellID->1254784343],
Cell[CellGroupData[{
Cell[7013, 237, 431, 14, 70, "Input",
 CellID->871039261],
Cell[7447, 253, 574, 17, 70, "Output",
 CellID->940292670]
}, Open  ]],
Cell[CellGroupData[{
Cell[8058, 275, 439, 14, 70, "Input",
 CellID->160838028],
Cell[8500, 291, 731, 21, 70, "Output",
 CellID->166746417]
}, Open  ]],
Cell[9246, 315, 787, 19, 70, "Reference",
 CellID->40871184],
Cell[10036, 336, 1025, 27, 70, "Reference",
 CellID->1874706095],
Cell[11064, 365, 992, 27, 70, "Text",
 CellID->729884070],
Cell[12059, 394, 66, 1, 70, "MathCaption",
 CellID->1366820905],
Cell[12128, 397, 545, 16, 70, "Input",
 CellID->362349038],
Cell[12676, 415, 545, 11, 70, "Text",
 CellID->1884142421],
Cell[13224, 428, 992, 26, 70, "Text",
 CellID->2135294732],
Cell[14219, 456, 784, 21, 70, "Text",
 CellID->1299335707],
Cell[15006, 479, 889, 29, 70, "Text",
 CellID->174021206],
Cell[15898, 510, 775, 18, 70, "Text",
 CellID->2049165675],
Cell[16676, 530, 481, 12, 70, "Text",
 CellID->1132252786],
Cell[17160, 544, 591, 20, 70, "Text",
 CellID->919978235],
Cell[17754, 566, 906, 19, 70, "Text",
 CellID->191937245]
}, Open  ]],
Cell[CellGroupData[{
Cell[18697, 590, 91, 1, 70, "Section",
 CellID->368838921],
Cell[18791, 593, 455, 12, 70, "Text",
 CellID->1437940005],
Cell[19249, 607, 65, 1, 70, "MathCaption",
 CellID->526378376],
Cell[19317, 610, 111, 4, 70, "Input",
 CellID->1589725036],
Cell[19431, 616, 220, 7, 70, "Input",
 CellID->305269881],
Cell[19654, 625, 680, 15, 70, "Text",
 CellID->1664627725],
Cell[20337, 642, 391, 10, 70, "Text",
 CellID->2128704606],
Cell[20731, 654, 93, 1, 70, "MathCaption",
 CellID->655910015],
Cell[20827, 657, 340, 11, 70, "Input",
 CellID->60754022],
Cell[21170, 670, 303, 6, 70, "Text",
 CellID->1038115429],
Cell[21476, 678, 1455, 38, 70, "Text",
 CellID->1448866975],
Cell[22934, 718, 256, 5, 70, "Text",
 CellID->790175492]
}, Open  ]],
Cell[CellGroupData[{
Cell[23227, 728, 75, 1, 70, "Section",
 CellID->440620996],
Cell[23305, 731, 743, 17, 70, "Text",
 CellID->993464916],
Cell[24051, 750, 74, 1, 70, "MathCaption",
 CellID->479487787],
Cell[CellGroupData[{
Cell[24150, 755, 137, 4, 70, "Input",
 CellID->1392592565],
Cell[24290, 761, 281, 8, 70, "Output",
 CellID->1255012257]
}, Open  ]],
Cell[CellGroupData[{
Cell[24608, 774, 178, 5, 70, "Input",
 CellID->1685170070],
Cell[24789, 781, 285, 8, 70, "Output",
 CellID->406622565]
}, Open  ]],
Cell[25089, 792, 1953, 76, 70, "Text",
 CellID->2026454949],
Cell[27045, 870, 454, 8, 70, "Text",
 CellID->1402016109],
Cell[27502, 880, 312, 6, 70, "Text",
 CellID->1494169079],
Cell[27817, 888, 73, 1, 70, "MathCaption",
 CellID->1973426382],
Cell[CellGroupData[{
Cell[27915, 893, 105, 3, 70, "Input",
 CellID->1639758006],
Cell[28023, 898, 241, 7, 70, "Output",
 CellID->812485201]
}, Open  ]],
Cell[28279, 908, 187, 6, 70, "Input",
 CellID->755164891],
Cell[28469, 916, 290, 7, 70, "Text",
 CellID->427969267],
Cell[28762, 925, 669, 17, 70, "Text",
 CellID->956736666],
Cell[29434, 944, 487, 12, 70, "Text",
 CellID->1663080373],
Cell[29924, 958, 233, 5, 70, "Text",
 CellID->1892163306],
Cell[30160, 965, 623, 12, 70, "Text",
 CellID->1650839166],
Cell[30786, 979, 344, 6, 70, "Text",
 CellID->165143722],
Cell[31133, 987, 657, 11, 70, "Text",
 CellID->1021663730],
Cell[31793, 1000, 172, 4, 70, "Text",
 CellID->1970552345],
Cell[31968, 1006, 144, 4, 70, "MathCaption",
 CellID->1340179768],
Cell[CellGroupData[{
Cell[32137, 1014, 139, 4, 70, "Input",
 CellID->580458381],
Cell[32279, 1020, 251, 8, 70, "Output",
 CellID->512380667]
}, Open  ]],
Cell[32545, 1031, 334, 6, 70, "Text",
 CellID->1893284793]
}, Open  ]],
Cell[CellGroupData[{
Cell[32916, 1042, 47, 1, 70, "Section",
 CellID->1172318352],
Cell[32966, 1045, 580, 14, 70, "Text",
 CellID->2139564486],
Cell[33549, 1061, 83, 1, 70, "MathCaption",
 CellID->46647187],
Cell[CellGroupData[{
Cell[33657, 1066, 610, 19, 70, "Input",
 CellID->167740754],
Cell[34270, 1087, 596, 19, 70, "Output",
 CellID->172445799]
}, Open  ]],
Cell[34881, 1109, 444, 13, 70, "Text",
 CellID->1720307614],
Cell[35328, 1124, 236, 9, 70, "MathCaption",
 CellID->856641709],
Cell[CellGroupData[{
Cell[35589, 1137, 763, 23, 70, "Input",
 CellID->1637728937],
Cell[36355, 1162, 643, 20, 70, "Output",
 CellID->1341103990]
}, Open  ]],
Cell[37013, 1185, 742, 16, 70, "Text",
 CellID->1012340560],
Cell[37758, 1203, 891, 25, 70, "Text",
 CellID->2042340386],
Cell[38652, 1230, 757, 20, 70, "Text",
 CellID->236253854],
Cell[39412, 1252, 1207, 34, 70, "Text",
 CellID->21260875],
Cell[40622, 1288, 605, 16, 70, "Text",
 CellID->849240723],
Cell[41230, 1306, 85, 1, 70, "MathCaption",
 CellID->1359447056],
Cell[CellGroupData[{
Cell[41340, 1311, 241, 7, 70, "Input",
 CellID->1012513499],
Cell[41584, 1320, 276, 9, 70, "Output",
 CellID->1105041266]
}, Open  ]],
Cell[41875, 1332, 78, 1, 70, "MathCaption",
 CellID->1812431218],
Cell[CellGroupData[{
Cell[41978, 1337, 384, 11, 70, "Input",
 CellID->265338709],
Cell[42365, 1350, 345, 10, 70, "Output",
 CellID->927187694]
}, Open  ]],
Cell[42725, 1363, 1072, 29, 70, "Text",
 CellID->1371630991],
Cell[43800, 1394, 1097, 34, 70, "Text",
 CellID->1912598839],
Cell[44900, 1430, 84, 1, 70, "MathCaption",
 CellID->1239838411],
Cell[CellGroupData[{
Cell[45009, 1435, 239, 7, 70, "Input",
 CellID->1513458777],
Cell[45251, 1444, 280, 9, 70, "Output",
 CellID->1102230426]
}, Open  ]],
Cell[45546, 1456, 214, 8, 70, "MathCaption",
 CellID->510838845],
Cell[45763, 1466, 187, 6, 70, "Input",
 CellID->2088302180]
}, Open  ]],
Cell[CellGroupData[{
Cell[45987, 1477, 55, 1, 70, "Section",
 CellID->1769496339],
Cell[46045, 1480, 827, 24, 70, "Text",
 CellID->1571425917],
Cell[46875, 1506, 66, 1, 70, "MathCaption",
 CellID->1201496213],
Cell[CellGroupData[{
Cell[46966, 1511, 627, 18, 70, "Input",
 CellID->758119150],
Cell[47596, 1531, 517, 15, 70, "Output",
 CellID->992830760]
}, Open  ]],
Cell[48128, 1549, 1146, 28, 70, "Text",
 CellID->688076399]
}, Open  ]],
Cell[CellGroupData[{
Cell[49311, 1582, 54, 1, 70, "Section",
 CellID->300598898],
Cell[49368, 1585, 578, 15, 70, "Text",
 CellID->1284140942],
Cell[49949, 1602, 65, 1, 70, "MathCaption",
 CellID->346159844],
Cell[CellGroupData[{
Cell[50039, 1607, 1196, 36, 70, "Input",
 CellID->375298385],
Cell[51238, 1645, 1165, 31, 70, "Output",
 CellID->558646130]
}, Open  ]],
Cell[52418, 1679, 522, 12, 70, "Text",
 CellID->480485456],
Cell[52943, 1693, 163, 4, 70, "Text",
 CellID->980546272],
Cell[53109, 1699, 72, 1, 70, "MathCaption",
 CellID->1816731361],
Cell[CellGroupData[{
Cell[53206, 1704, 1428, 41, 70, "Input",
 CellID->251686426],
Cell[54637, 1747, 1225, 32, 70, "Output",
 CellID->367002226]
}, Open  ]],
Cell[55877, 1782, 598, 19, 70, "Text",
 CellID->1698460839],
Cell[56478, 1803, 688, 19, 70, "Text",
 CellID->1678685149],
Cell[57169, 1824, 464, 14, 70, "MathCaption",
 CellID->21144957],
Cell[CellGroupData[{
Cell[57658, 1842, 1488, 43, 70, "Input",
 CellID->1048490544],
Cell[59149, 1887, 1215, 32, 70, "Output",
 CellID->633378198]
}, Open  ]],
Cell[60379, 1922, 907, 26, 70, "Text",
 CellID->1877249373],
Cell[61289, 1950, 993, 27, 70, "Text",
 CellID->100470287]
}, Open  ]],
Cell[CellGroupData[{
Cell[62319, 1982, 90, 1, 70, "Section",
 CellID->681967067],
Cell[62412, 1985, 363, 8, 70, "Text",
 CellID->700271030],
Cell[62778, 1995, 497, 10, 70, "Text",
 CellID->1244815650],
Cell[63278, 2007, 879, 18, 70, "Text",
 CellID->830940476],
Cell[64160, 2027, 815, 17, 70, "Text",
 CellID->626355940],
Cell[64978, 2046, 857, 13, 70, "Text",
 CellID->199445986],
Cell[65838, 2061, 375, 7, 70, "Text",
 CellID->1099589122],
Cell[66216, 2070, 87, 1, 70, "MathCaption",
 CellID->1697591019],
Cell[CellGroupData[{
Cell[66328, 2075, 138, 4, 70, "Input",
 CellID->2092005938],
Cell[66469, 2081, 193, 6, 70, "Output",
 CellID->110935607]
}, Open  ]],
Cell[66677, 2090, 161, 4, 70, "MathCaption",
 CellID->1741531282],
Cell[CellGroupData[{
Cell[66863, 2098, 209, 7, 70, "Input",
 CellID->1861631611],
Cell[67075, 2107, 315, 9, 36, "Output",
 CellID->150617166]
}, Open  ]],
Cell[67405, 2119, 470, 12, 70, "Text",
 CellID->1753232934],
Cell[67878, 2133, 839, 21, 70, "Text",
 CellID->511345412],
Cell[68720, 2156, 400, 11, 70, "MathCaption",
 CellID->687238374],
Cell[CellGroupData[{
Cell[69145, 2171, 553, 18, 70, "Input",
 CellID->2100267837],
Cell[69701, 2191, 424, 13, 70, "Output",
 CellID->1686972796]
}, Open  ]],
Cell[70140, 2207, 257, 5, 70, "MathCaption",
 CellID->1105154106],
Cell[CellGroupData[{
Cell[70422, 2216, 628, 20, 70, "Input",
 CellID->738996639],
Cell[71053, 2238, 550, 18, 70, "Output",
 CellID->1872674678]
}, Open  ]],
Cell[71618, 2259, 489, 11, 70, "Text",
 CellID->1418581072],
Cell[72110, 2272, 446, 10, 70, "Reference",
 CellID->1199546089],
Cell[72559, 2284, 518, 14, 70, "Text",
 CellID->728628110],
Cell[73080, 2300, 370, 13, 70, "MathCaption",
 CellID->1754296811],
Cell[73453, 2315, 104, 3, 70, "Input",
 CellID->1100889576],
Cell[CellGroupData[{
Cell[73582, 2322, 471, 15, 70, "Input",
 CellID->1663512814],
Cell[74056, 2339, 481, 16, 70, "Output",
 CellID->522982714]
}, Open  ]],
Cell[74552, 2358, 223, 5, 70, "Text",
 CellID->217699674],
Cell[74778, 2365, 74, 1, 70, "MathCaption",
 CellID->2060749237],
Cell[CellGroupData[{
Cell[74877, 2370, 884, 28, 70, "Input",
 CellID->1713770077],
Cell[75764, 2400, 583, 20, 70, "Output",
 CellID->119907027]
}, Open  ]],
Cell[76362, 2423, 523, 17, 70, "Text",
 CellID->1283010575],
Cell[76888, 2442, 572, 15, 70, "Text",
 CellID->675434498],
Cell[77463, 2459, 66, 1, 70, "MathCaption",
 CellID->400621424],
Cell[CellGroupData[{
Cell[77554, 2464, 1033, 32, 70, "Input",
 CellID->429049844],
Cell[78590, 2498, 641, 21, 70, "Output",
 CellID->937741903]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[79280, 2525, 101, 3, 70, "Section",
 CellID->1938125129],
Cell[79384, 2530, 692, 18, 70, "Text",
 CellID->1037085407],
Cell[80079, 2550, 869, 19, 70, "Text",
 CellID->1317156397],
Cell[80951, 2571, 155, 4, 70, "MathCaption",
 CellID->1186131103],
Cell[CellGroupData[{
Cell[81131, 2579, 692, 21, 70, "Input",
 CellID->214753020],
Cell[81826, 2602, 581, 19, 70, "Output",
 CellID->245678388]
}, Open  ]],
Cell[82422, 2624, 318, 6, 70, "Text",
 CellID->1581480180],
Cell[82743, 2632, 760, 21, 70, "Reference",
 CellID->194639787],
Cell[83506, 2655, 930, 26, 70, "Text",
 CellID->693305728],
Cell[84439, 2683, 136, 4, 70, "MathCaption",
 CellID->343066992],
Cell[CellGroupData[{
Cell[84600, 2691, 645, 20, 70, "Input",
 CellID->1867143432],
Cell[85248, 2713, 538, 17, 70, "Output",
 CellID->1653097582]
}, Open  ]],
Cell[85801, 2733, 196, 4, 70, "MathCaption",
 CellID->671323377],
Cell[CellGroupData[{
Cell[86022, 2741, 1631, 45, 70, "Input",
 CellID->1118194978],
Cell[87656, 2788, 835, 26, 70, "Output",
 CellID->1615119435]
}, Open  ]],
Cell[88506, 2817, 238, 5, 70, "Reference",
 CellID->143101874],
Cell[88747, 2824, 585, 12, 70, "Reference",
 CellID->2078995325],
Cell[89335, 2838, 246, 5, 70, "MathCaption",
 CellID->1349818222],
Cell[CellGroupData[{
Cell[89606, 2847, 1068, 30, 70, "Input",
 CellID->377610246],
Cell[90677, 2879, 709, 21, 70, "Output",
 CellID->1119045965]
}, Open  ]],
Cell[91401, 2903, 276, 9, 70, "MathCaption",
 CellID->1235109669],
Cell[CellGroupData[{
Cell[91702, 2916, 870, 26, 70, "Input",
 CellID->1273405741],
Cell[92575, 2944, 641, 20, 70, "Output",
 CellID->143753329]
}, Open  ]],
Cell[93231, 2967, 648, 22, 70, "MathCaption",
 CellID->308262985],
Cell[CellGroupData[{
Cell[93904, 2993, 455, 14, 70, "Input",
 CellID->1245432331],
Cell[94362, 3009, 1641, 36, 70, "Output",
 CellID->143097628]
}, Open  ]],
Cell[96018, 3048, 515, 9, 70, "Text",
 CellID->458079808],
Cell[96536, 3059, 134, 4, 70, "Text",
 CellID->218458561]
}, Open  ]],
Cell[CellGroupData[{
Cell[96707, 3068, 65, 1, 70, "Section",
 CellID->1583482004],
Cell[96775, 3071, 738, 21, 70, "Reference",
 CellID->2115490585],
Cell[97516, 3094, 704, 20, 70, "Text",
 CellID->1964687604],
Cell[98223, 3116, 714, 20, 70, "Reference",
 CellID->1311002363],
Cell[98940, 3138, 1176, 31, 70, "Text",
 CellID->1766212729],
Cell[100119, 3171, 737, 19, 70, "Text",
 CellID->70883822],
Cell[100859, 3192, 73, 1, 70, "MathCaption",
 CellID->1638455916],
Cell[CellGroupData[{
Cell[100957, 3197, 311, 9, 70, "Input",
 CellID->345774731],
Cell[101271, 3208, 291, 8, 70, "Output",
 CellID->2007632803]
}, Open  ]],
Cell[101577, 3219, 366, 10, 70, "Text",
 CellID->345155135],
Cell[101946, 3231, 825, 19, 70, "Text",
 CellID->669023398],
Cell[102774, 3252, 575, 11, 70, "Text",
 CellID->51874494],
Cell[103352, 3265, 1134, 29, 70, "Text",
 CellID->2123743623],
Cell[104489, 3296, 917, 27, 70, "Text",
 CellID->433374974],
Cell[105409, 3325, 613, 14, 70, "Text",
 CellID->1616141041],
Cell[106025, 3341, 1187, 29, 70, "Text",
 CellID->834496721],
Cell[107215, 3372, 629, 17, 70, "Text",
 CellID->1847983010]
}, Open  ]],
Cell[CellGroupData[{
Cell[107881, 3394, 91, 3, 70, "Section",
 CellID->2141946156],
Cell[107975, 3399, 739, 20, 70, "Reference",
 CellID->170691290],
Cell[108717, 3421, 1744, 50, 70, "Reference",
 CellID->1917842285],
Cell[110464, 3473, 641, 16, 70, "Reference",
 CellID->1593226172],
Cell[111108, 3491, 298, 8, 70, "MathCaption",
 CellID->1420669231],
Cell[CellGroupData[{
Cell[111431, 3503, 423, 13, 70, "Input",
 CellID->1464578071],
Cell[111857, 3518, 435, 13, 70, "Output",
 CellID->1345995038]
}, Open  ]],
Cell[112307, 3534, 196, 6, 70, "MathCaption",
 CellID->545866168],
Cell[CellGroupData[{
Cell[112528, 3544, 483, 15, 70, "Input",
 CellID->467582888],
Cell[113014, 3561, 460, 13, 70, "Output",
 CellID->1021458357]
}, Open  ]],
Cell[113489, 3577, 765, 21, 70, "Text",
 CellID->1022934243],
Cell[114257, 3600, 330, 12, 70, "Text",
 CellID->1849227866]
}, Open  ]],
Cell[CellGroupData[{
Cell[114624, 3617, 63, 1, 70, "Section",
 CellID->1497695040],
Cell[114690, 3620, 627, 13, 70, "Text",
 CellID->1104710793],
Cell[115320, 3635, 1140, 32, 70, "Text",
 CellID->1878169636],
Cell[116463, 3669, 613, 16, 70, "Text",
 CellID->534944999],
Cell[117079, 3687, 936, 24, 70, "Text",
 CellID->1454051851],
Cell[118018, 3713, 164, 5, 70, "MathCaption",
 CellID->2073927461],
Cell[CellGroupData[{
Cell[118207, 3722, 782, 23, 70, "Input",
 CellID->700115591],
Cell[118992, 3747, 946, 28, 70, "Output",
 CellID->666331981]
}, Open  ]],
Cell[119953, 3778, 575, 16, 70, "Reference",
 CellID->378678361],
Cell[120531, 3796, 615, 18, 70, "Text",
 CellID->611357727],
Cell[121149, 3816, 835, 22, 70, "Text",
 CellID->1527550441],
Cell[CellGroupData[{
Cell[122009, 3842, 66, 1, 70, "TutorialMoreAboutSection",
 CellID->406028304],
Cell[122078, 3845, 181, 4, 70, "TutorialMoreAbout",
 CellID->346793833],
Cell[122262, 3851, 161, 3, 70, "TutorialMoreAbout",
 CellID->116159589]
}, Open  ]],
Cell[CellGroupData[{
Cell[122460, 3859, 72, 1, 70, "RelatedTutorialsSection",
 CellID->816272032],
Cell[122535, 3862, 166, 3, 70, "RelatedTutorials",
 CellID->202479463],
Cell[122704, 3867, 174, 4, 70, "RelatedTutorials",
 CellID->894362159]
}, Open  ]],
Cell[CellGroupData[{
Cell[122915, 3876, 98, 1, 70, "TutorialRelatedLinksSection",
 CellID->645287401],
Cell[123016, 3879, 244, 5, 70, "TutorialRelatedLinks",
 CellID->360440367]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[123299, 3889, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

