(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     24032,        766]
NotebookOptionsPosition[     19830,        653]
NotebookOutlinePosition[     22829,        723]
CellTagsIndexPosition[     22736,        717]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"CholeskyDecomposition" :> 
         Documentation`HelpLookup["paclet:ref/CholeskyDecomposition"], 
         "HessenbergDecomposition" :> 
         Documentation`HelpLookup["paclet:ref/HessenbergDecomposition"], 
         "JordanDecomposition" :> 
         Documentation`HelpLookup["paclet:ref/JordanDecomposition"], 
         "LUDecomposition" :> 
         Documentation`HelpLookup["paclet:ref/LUDecomposition"], "Norm" :> 
         Documentation`HelpLookup["paclet:ref/Norm"], "PseudoInverse" :> 
         Documentation`HelpLookup["paclet:ref/PseudoInverse"], 
         "QRDecomposition" :> 
         Documentation`HelpLookup["paclet:ref/QRDecomposition"], 
         "SchurDecomposition" :> 
         Documentation`HelpLookup["paclet:ref/SchurDecomposition"], 
         "SingularValueDecomposition" :> 
         Documentation`HelpLookup["paclet:ref/SingularValueDecomposition"], 
         "SingularValueList" :> 
         Documentation`HelpLookup["paclet:ref/SingularValueList"]}, #, 2]& , 
       Evaluator -> Automatic], {1->"\<\"CholeskyDecomposition\"\>", 
      2->"\<\"HessenbergDecomposition\"\>", 3->"\<\"JordanDecomposition\"\>", 
      4->"\<\"LUDecomposition\"\>", 5->"\<\"Norm\"\>", 
      6->"\<\"PseudoInverse\"\>", 7->"\<\"QRDecomposition\"\>", 
      8->"\<\"SchurDecomposition\"\>", 
      9->"\<\"SingularValueDecomposition\"\>", 
      10->"\<\"SingularValueList\"\>"}, "\<\"functions\"\>", 
      StyleBox["\<\"functions\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Advanced Matrix Operations", "Title",
 CellTags->{"S3.7.10", "10.1"},
 CellID->24182],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["SingularValueList",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/SingularValueList"], "[", 
     StyleBox["m", "TI"], "]"}], Cell[TextData[{
     "the list of nonzero singular values of ",
     Cell[BoxData[
      StyleBox["m", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["SingularValueList",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/SingularValueList"], "[", 
     StyleBox["m", "TI"], ",", 
     StyleBox["k", "TI"], "]"}], Cell[TextData[{
     "the ",
     Cell[BoxData[
      StyleBox["k", "TI"]], "InlineFormula"],
     " largest singular values of ",
     Cell[BoxData[
      StyleBox["m", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["SingularValueList",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/SingularValueList"], "[", "{", 
     StyleBox["m", "TI"], ",", 
     StyleBox["a", "TI"], "}", "]"}], Cell[TextData[{
     "the generalized singular values of ",
     Cell[BoxData[
      StyleBox["m", "TI"]], "InlineFormula"],
     " with respect to ",
     Cell[BoxData[
      StyleBox["a", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Norm",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Norm"], "[", 
     StyleBox["m", "TI"], ",", 
     StyleBox["p", "TI"], "]"}], Cell[TextData[{
     "the ",
     Cell[BoxData[
      StyleBox["p", "TI"]], "InlineFormula"],
     "\[Hyphen]norm of ",
     Cell[BoxData[
      StyleBox["m", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Norm",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Norm"], "[", 
     RowBox[{
      StyleBox["m", "TI"], ",", "\"\<Frobenius\>\""}], "]"}], Cell[TextData[{
     "the Frobenius norm of ",
     Cell[BoxData[
      StyleBox["m", "TI"]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->10285],

Cell["Finding singular values and norms of matrices. ", "Caption",
 CellID->27088],

Cell[TextData[{
 "The ",
 StyleBox["singular values",
  FontSlant->"Italic"],
 " of a matrix ",
 Cell[BoxData[
  FormBox[
   StyleBox["m", "TB"], TraditionalForm]], "InlineMath",
  SingleLetterItalics->False],
 " are the square roots of the eigenvalues of ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["m", "TB"], ".", 
    SuperscriptBox[
     StyleBox["m", "TB"], "*"]}], TraditionalForm]], "InlineMath",
  SingleLetterItalics->False],
 ", where ",
 Cell[BoxData[
  FormBox["*", TraditionalForm]], "InlineMath"],
 " denotes Hermitian transpose. The number of such singular values is the \
smaller dimension of the matrix. ",
 Cell[BoxData[
  ButtonBox["SingularValueList",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SingularValueList"]], "InlineFormula"],
 " sorts the singular values from largest to smallest. Very small singular \
values are usually numerically meaningless. With the option setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Tolerance",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Tolerance"], "->", 
   StyleBox["t", "TI"]}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["SingularValueList",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SingularValueList"]], "InlineFormula"],
 " drops singular values that are less than a fraction ",
 Cell[BoxData[
  StyleBox["t", "TI"]], "InlineFormula"],
 " of the largest singular value. For approximate numerical matrices, the \
tolerance is by default slightly greater than zero."
}], "Text",
 CellID->31426],

Cell[TextData[{
 "If you multiply the vector for each point in a unit sphere in ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 "\[Hyphen]dimensional space by an ",
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"],
 "\[Times]",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " matrix ",
 Cell[BoxData[
  FormBox[
   StyleBox["m", "TB"], TraditionalForm]], "InlineMath",
  SingleLetterItalics->False],
 ", then you get an ",
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"],
 "\[Hyphen]dimensional ellipsoid, whose principal axes have lengths given by \
the singular values of ",
 Cell[BoxData[
  FormBox[
   StyleBox["m", "TB"], TraditionalForm]], "InlineMath",
  SingleLetterItalics->False],
 ". "
}], "Text",
 CellID->28617],

Cell[TextData[{
 "The ",
 StyleBox["2\[Hyphen]norm",
  FontSlant->"Italic"],
 " of a matrix ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Norm",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Norm"], "[", 
   RowBox[{
    StyleBox["m", "TI"], ",", "2"}], "]"}]], "InlineFormula"],
 " is the largest principal axis of the ellipsoid, equal to the largest \
singular value of the matrix. This is also the maximum 2\[Hyphen]norm length \
of ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["m", "TB"], ".", 
    StyleBox["v",
     FontSlant->"Italic"]}], TraditionalForm]], "InlineMath",
  SingleLetterItalics->False],
 " for any possible unit vector ",
 Cell[BoxData[
  StyleBox["v", "TI"]], "InlineFormula"],
 "."
}], "Text",
 CellID->23757],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  StyleBox["p", "TI"]], "InlineFormula"],
 StyleBox["\[Hyphen]norm",
  FontSlant->"Italic"],
 " of a matrix ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Norm",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Norm"], "[", 
   RowBox[{
    StyleBox["m", "TI"], ",", 
    StyleBox["p", "TI"]}], "]"}]], "InlineFormula"],
 " is in general the maximum ",
 Cell[BoxData[
  FormBox["p", TraditionalForm]], "InlineMath"],
 "\[Hyphen]norm length of ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["m", "TB"], ".", 
    StyleBox["v",
     FontSlant->"Italic"]}], TraditionalForm]], "InlineMath",
  SingleLetterItalics->False],
 " that can be attained. The cases most often considered are ",
 Cell[BoxData[
  FormBox[
   RowBox[{"p", "=", "1"}], TraditionalForm]], "InlineMath"],
 ", ",
 Cell[BoxData[
  FormBox[
   RowBox[{"p", "=", "2"}], TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"p", "=", "\[Infinity]"}], TraditionalForm]], "InlineMath"],
 ". Also sometimes considered is the Frobenius norm ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Norm",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Norm"], "[", 
   RowBox[{
    StyleBox["m", "TI"], ",", "\"\<Frobenius\>\""}], "]"}]], 
  "InlineFormula"],
 ", which is the square root of the trace of ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["m", "TB"], ".", 
    SuperscriptBox[
     StyleBox["m", "TB"], "*"]}], TraditionalForm]], "InlineMath",
  SingleLetterItalics->False],
 "."
}], "Text",
 CellID->9832],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["LUDecomposition",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/LUDecomposition"], "[", 
     StyleBox["m", "TI"], "]"}], Cell["the LU decomposition", "TableText"]},
   {
    RowBox[{
     ButtonBox["CholeskyDecomposition",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/CholeskyDecomposition"], "[", 
     StyleBox["m", "TI"], "]"}], Cell[
    "the Cholesky decomposition", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->30932],

Cell["Decomposing square matrices into triangular forms. ", "Caption",
 CellID->4169],

Cell[TextData[{
 "When you create a ",
 Cell[BoxData[
  ButtonBox["LinearSolveFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LinearSolveFunction"]], "InlineFormula"],
 " using ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["LinearSolve",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LinearSolve"], "[", 
   StyleBox["m", "TI"], "]"}]], "InlineFormula"],
 ", this often works by decomposing the matrix ",
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"],
 " into triangular forms, and sometimes it is useful to be able to get such \
forms explicitly. "
}], "Text",
 CellID->2154],

Cell[TextData[{
 StyleBox["LU decomposition",
  FontSlant->"Italic"],
 " effectively factors any square matrix into a product of lower\[Hyphen] and \
upper\[Hyphen]triangular matrices. ",
 StyleBox["Cholesky decomposition",
  FontSlant->"Italic"],
 " effectively factors any Hermitian positive\[Hyphen]definite matrix into a \
product of a lower\[Hyphen]triangular matrix and its Hermitian conjugate, \
which can be viewed as the analog of finding a square root of a matrix. "
}], "Text",
 CellID->25721],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["PseudoInverse",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/PseudoInverse"], "[", 
     StyleBox["m", "TI"], "]"}], Cell["the pseudoinverse", "TableText"]},
   {
    RowBox[{
     ButtonBox["QRDecomposition",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/QRDecomposition"], "[", 
     StyleBox["m", "TI"], "]"}], Cell["the QR decomposition", "TableText"]},
   {
    RowBox[{
     ButtonBox["SingularValueDecomposition",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/SingularValueDecomposition"], "[", 
     StyleBox["m", "TI"], "]"}], Cell[
    "the singular value decomposition", "TableText"]},
   {
    RowBox[{
     ButtonBox["SingularValueDecomposition",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/SingularValueDecomposition"], "[", "{", 
     StyleBox["m", "TI"], ",", 
     StyleBox["a", "TI"], "}", "]"}], Cell[
    "the generalized singular value decomposition", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{GridBoxItemSize->{"Columns" -> {
     Scaled[0.45], {
      Scaled[0.55]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}}},
 CellID->17189],

Cell["Orthogonal decompositions of matrices. ", "Caption",
 CellID->19976],

Cell[TextData[{
 "The standard definition for the inverse of a matrix fails if the matrix is \
not square or is singular. The ",
 StyleBox["pseudoinverse",
  FontSlant->"Italic"],
 " ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox[
    StyleBox["m", "TB"], 
    RowBox[{"(", 
     RowBox[{"-", "1"}], ")"}]], TraditionalForm]], "InlineMath",
  SingleLetterItalics->False],
 " of a matrix ",
 Cell[BoxData[
  FormBox[
   StyleBox["m", "TB"], TraditionalForm]], "InlineMath",
  SingleLetterItalics->False],
 " can however still be defined. It is set up to minimize the sum of the \
squares of all entries in ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["m", "TB"], ".", 
    SuperscriptBox[
     StyleBox["m", "TB"], 
     RowBox[{"(", 
      RowBox[{"-", "1"}], ")"}]], "-", 
    StyleBox["I", "TB"]}], TraditionalForm]], "InlineMath",
  SingleLetterItalics->False],
 ", where ",
 Cell[BoxData[
  FormBox[
   StyleBox["I", "TB"], TraditionalForm]], "InlineMath",
  SingleLetterItalics->False],
 " is the identity matrix. The pseudoinverse is sometimes known as the \
generalized inverse, or the Moore\[Dash]Penrose inverse. It is particularly \
used for problems related to least\[Hyphen]squares fitting."
}], "Text",
 CellID->31329],

Cell[TextData[{
 StyleBox["QR decomposition",
  FontSlant->"Italic"],
 " writes any matrix ",
 Cell[BoxData[
  FormBox[
   StyleBox["m", "TB"], TraditionalForm]], "InlineMath",
  SingleLetterItalics->False],
 " as a product ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox[
     StyleBox["q", "TB"], "*"], 
    StyleBox["r", "TB"]}], TraditionalForm]], "InlineMath",
  SingleLetterItalics->False],
 ", where ",
 Cell[BoxData[
  FormBox[
   StyleBox["q", "TB"], TraditionalForm]], "InlineMath",
  SingleLetterItalics->False],
 " is an orthonormal matrix, ",
 Cell[BoxData[
  FormBox["*", TraditionalForm]], "InlineMath"],
 " denotes Hermitian transpose, and ",
 Cell[BoxData[
  FormBox[
   StyleBox["r", "TB"], TraditionalForm]], "InlineMath",
  SingleLetterItalics->False],
 " is a triangular matrix, in which all entries below the leading diagonal \
are zero. "
}], "Text",
 CellID->2368],

Cell[TextData[{
 StyleBox["Singular value decomposition",
  FontSlant->"Italic"],
 ", or ",
 StyleBox["SVD",
  FontSlant->"Italic"],
 ", is an underlying element in many numerical matrix algorithms. The basic \
idea is to write any matrix ",
 Cell[BoxData[
  FormBox[
   StyleBox["m", "TB"], TraditionalForm]], "InlineMath",
  SingleLetterItalics->False],
 " in the form ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox[
    StyleBox["usv", "TB"], "*"], TraditionalForm]], "InlineMath",
  SingleLetterItalics->False],
 ", where ",
 Cell[BoxData[
  FormBox[
   StyleBox["s", "TB"], TraditionalForm]], "InlineMath",
  SingleLetterItalics->False],
 " is a matrix with the singular values of ",
 Cell[BoxData[
  FormBox[
   StyleBox["m", "TB"], TraditionalForm]], "InlineMath",
  SingleLetterItalics->False],
 " on its diagonal, ",
 Cell[BoxData[
  FormBox[
   StyleBox["u", "TB"], TraditionalForm]], "InlineMath",
  SingleLetterItalics->False],
 " and ",
 Cell[BoxData[
  FormBox[
   StyleBox["v", "TB"], TraditionalForm]], "InlineMath",
  SingleLetterItalics->False],
 " are orthonormal matrices, and ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox[
    StyleBox["v", "TB"], "*"], TraditionalForm]], "InlineMath",
  SingleLetterItalics->False],
 " is the Hermitian transpose of ",
 Cell[BoxData[
  FormBox[
   StyleBox["v", "TB"], TraditionalForm]], "InlineMath",
  SingleLetterItalics->False],
 ". "
}], "Text",
 CellID->28692],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["JordanDecomposition",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/JordanDecomposition"], "[", 
     StyleBox["m", "TI"], "]"}], Cell[
    "the Jordan decomposition", "TableText"]},
   {
    RowBox[{
     ButtonBox["SchurDecomposition",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/SchurDecomposition"], "[", 
     StyleBox["m", "TI"], "]"}], Cell[
    "the Schur decomposition", "TableText"]},
   {
    RowBox[{
     ButtonBox["SchurDecomposition",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/SchurDecomposition"], "[", "{", 
     StyleBox["m", "TI"], ",", 
     StyleBox["a", "TI"], "}", "]"}], Cell[
    "the generalized Schur decomposition", "TableText"]},
   {
    RowBox[{
     ButtonBox["HessenbergDecomposition",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/HessenbergDecomposition"], "[", 
     StyleBox["m", "TI"], "]"}], Cell[
    "the Hessenberg decomposition", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->21425],

Cell["Functions related to eigenvalue problems. ", "Caption",
 CellID->10555],

Cell[TextData[{
 "Most square matrices can be reduced to a diagonal matrix of eigenvalues by \
applying a matrix of their eigenvectors as a similarity transformation. But \
even when there are not enough eigenvectors to do this, one can still reduce \
a matrix to a ",
 StyleBox["Jordan form",
  FontSlant->"Italic"],
 " in which there are both eigenvalues and Jordan blocks on the diagonal. ",
 StyleBox["Jordan decomposition",
  FontSlant->"Italic"],
 " in general writes any matrix in the form as ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox[
    StyleBox["sjs", "TB"], 
    RowBox[{"-", "1"}]], TraditionalForm]], "InlineMath"],
 ". "
}], "Text",
 CellID->3434],

Cell[TextData[{
 "Numerically more stable is the ",
 StyleBox["Schur decomposition",
  FontSlant->"Italic"],
 ", which writes any square matrix ",
 Cell[BoxData[
  FormBox[
   StyleBox["m", "TB"], TraditionalForm]], "InlineMath",
  SingleLetterItalics->False],
 " in the form ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox[
    StyleBox["qtq", "TB"], "*"], TraditionalForm]], "InlineMath"],
 ", where",
 " ",
 Cell[BoxData[
  FormBox[
   StyleBox["q", "TB"], TraditionalForm]], "InlineMath",
  SingleLetterItalics->False],
 " is an orthonormal matrix, and ",
 Cell[BoxData[
  FormBox[
   StyleBox["t", "TB"], TraditionalForm]], "InlineMath",
  SingleLetterItalics->False],
 " is block upper\[Hyphen]triangular. Also related is the ",
 StyleBox["Hessenberg decomposition",
  FontSlant->"Italic"],
 ", which writes a square matrix ",
 Cell[BoxData[
  FormBox[
   StyleBox["m", "TB"], TraditionalForm]], "InlineMath",
  SingleLetterItalics->False],
 " in the form ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox[
    StyleBox["php", "TB"], "*"], TraditionalForm]], "InlineMath"],
 ", where ",
 Cell[BoxData[
  FormBox[
   StyleBox["p", "TB"], TraditionalForm]], "InlineMath",
  SingleLetterItalics->False],
 " is an orthonormal matrix, and ",
 Cell[BoxData[
  FormBox[
   StyleBox["h", "TB"], TraditionalForm]], "InlineMath",
  SingleLetterItalics->False],
 " can have nonzero elements down to the diagonal below the leading diagonal. \
"
}], "Text",
 CellID->16549]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Advanced Matrix Operations - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 32, 30.5757380}", "context" -> "", 
    "keywords" -> {
     "canonical form", "CholeskyDecomposition", 
      "condition number of matrices", "cyclic vectors", "echelon form", 
      "elimination", "factoring", "Frobenius norm", "functions", 
      "Gaussian elimination", "HessenbergDecomposition", 
      "invariant subspaces", "JordanDecomposition", "linear systems", 
      "LINPACK", "LUDecomposition", "matrices", "Moore-Penrose inverse", 
      "normal form", "PseudoInverse", "QRDecomposition", "SchurDecomposition",
       "semi-inverse", "similarity transformation", 
      "SingularValueDecomposition", "SingularValueList", "SVD", "Tolerance", 
      "triangular matrices"}, "index" -> True, "label" -> 
    "Mathematica Tutorial", "language" -> "en", "paclet" -> "Mathematica", 
    "status" -> "None", "summary" -> 
    "Finding singular values and norms of matrices. The singular values of a \
matrix m are the square roots of the eigenvalues of m.m^*, where * denotes \
Hermitian transpose. The number of such singular values is the smaller \
dimension of the matrix. SingularValueList sorts the singular values from \
largest to smallest. Very small singular values are usually numerically \
meaningless. With the option setting Tolerance->t, SingularValueList drops \
singular values that are less than a fraction t of the largest singular \
value. For approximate numerical matrices, the tolerance is by default \
slightly greater than zero. If you multiply the vector for each point in a \
unit sphere in n-dimensional space by an mxn matrix m, then you get an \
m-dimensional ellipsoid, whose principal axes have lengths given by the \
singular values of m. ", "synonyms" -> {"3.7.10"}, "title" -> 
    "Advanced Matrix Operations", "type" -> "Tutorial", "uri" -> 
    "tutorial/AdvancedMatrixOperations"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S3.7.10"->{
  Cell[2428, 63, 91, 2, 70, "Title",
   CellTags->{"S3.7.10", "10.1"},
   CellID->24182]},
 "10.1"->{
  Cell[2428, 63, 91, 2, 70, "Title",
   CellTags->{"S3.7.10", "10.1"},
   CellID->24182]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S3.7.10", 22520, 706},
 {"10.1", 22622, 710}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1803, 36, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2428, 63, 91, 2, 70, "Title",
 CellTags->{"S3.7.10", "10.1"},
 CellID->24182],
Cell[2522, 67, 2253, 72, 70, "DefinitionBox",
 CellID->10285],
Cell[4778, 141, 82, 1, 70, "Caption",
 CellID->27088],
Cell[4863, 144, 1503, 45, 70, "Text",
 CellID->31426],
Cell[6369, 191, 764, 26, 70, "Text",
 CellID->28617],
Cell[7136, 219, 745, 27, 70, "Text",
 CellID->23757],
Cell[7884, 248, 1546, 57, 70, "Text",
 CellID->9832],
Cell[9433, 307, 776, 22, 70, "DefinitionBox",
 CellID->30932],
Cell[10212, 331, 85, 1, 70, "Caption",
 CellID->4169],
Cell[10300, 334, 599, 19, 70, "Text",
 CellID->2154],
Cell[10902, 355, 504, 11, 70, "Text",
 CellID->25721],
Cell[11409, 368, 1185, 33, 70, "DefinitionBox",
 CellID->17189],
Cell[12597, 403, 74, 1, 70, "Caption",
 CellID->19976],
Cell[12674, 406, 1240, 39, 70, "Text",
 CellID->31329],
Cell[13917, 447, 900, 32, 70, "Text",
 CellID->2368],
Cell[14820, 481, 1423, 51, 70, "Text",
 CellID->28692],
Cell[16246, 534, 1327, 38, 70, "DefinitionBox",
 CellID->21425],
Cell[17576, 574, 77, 1, 70, "Caption",
 CellID->10555],
Cell[17656, 577, 667, 18, 70, "Text",
 CellID->3434],
Cell[18326, 597, 1462, 51, 70, "Text",
 CellID->16549]
}, Open  ]],
Cell[19803, 651, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

