(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    128025,       4513]
NotebookOptionsPosition[    113867,       4029]
NotebookOutlinePosition[    116350,       4086]
CellTagsIndexPosition[    116266,       4081]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"AlgebraicIntegerQ" :> 
         Documentation`HelpLookup["paclet:ref/AlgebraicIntegerQ"], 
         "AlgebraicNumber" :> 
         Documentation`HelpLookup["paclet:ref/AlgebraicNumber"], 
         "AlgebraicNumberDenominator" :> 
         Documentation`HelpLookup["paclet:ref/AlgebraicNumberDenominator"], 
         "AlgebraicNumberNorm" :> 
         Documentation`HelpLookup["paclet:ref/AlgebraicNumberNorm"], 
         "AlgebraicNumberTrace" :> 
         Documentation`HelpLookup["paclet:ref/AlgebraicNumberTrace"], 
         "AlgebraicUnitQ" :> 
         Documentation`HelpLookup["paclet:ref/AlgebraicUnitQ"], "Automatic" :> 
         Documentation`HelpLookup["paclet:ref/Automatic"], "Extension" :> 
         Documentation`HelpLookup["paclet:ref/Extension"], "False" :> 
         Documentation`HelpLookup["paclet:ref/False"], "MinimalPolynomial" :> 
         Documentation`HelpLookup["paclet:ref/MinimalPolynomial"], 
         "NumberFieldClassNumber" :> 
         Documentation`HelpLookup["paclet:ref/NumberFieldClassNumber"], 
         "NumberFieldDiscriminant" :> 
         Documentation`HelpLookup["paclet:ref/NumberFieldDiscriminant"], 
         "NumberFieldFundamentalUnits" :> 
         Documentation`HelpLookup["paclet:ref/NumberFieldFundamentalUnits"], 
         "NumberFieldIntegralBasis" :> 
         Documentation`HelpLookup["paclet:ref/NumberFieldIntegralBasis"], 
         "NumberFieldNormRepresentatives" :> 
         Documentation`HelpLookup[
          "paclet:ref/NumberFieldNormRepresentatives"], 
         "NumberFieldRegulator" :> 
         Documentation`HelpLookup["paclet:ref/NumberFieldRegulator"], 
         "NumberFieldRootsOfUnity" :> 
         Documentation`HelpLookup["paclet:ref/NumberFieldRootsOfUnity"], 
         "NumberFieldSignature" :> 
         Documentation`HelpLookup["paclet:ref/NumberFieldSignature"], 
         "RootOfUnityQ" :> 
         Documentation`HelpLookup["paclet:ref/RootOfUnityQ"], "ToNumberField" :> 
         Documentation`HelpLookup["paclet:ref/ToNumberField"], "True" :> 
         Documentation`HelpLookup["paclet:ref/True"]}, #, 2]& , Evaluator -> 
       Automatic], {1->"\<\"AlgebraicIntegerQ\"\>", 
      2->"\<\"AlgebraicNumber\"\>", 3->"\<\"AlgebraicNumberDenominator\"\>", 
      4->"\<\"AlgebraicNumberNorm\"\>", 5->"\<\"AlgebraicNumberTrace\"\>", 
      6->"\<\"AlgebraicUnitQ\"\>", 7->"\<\"Automatic\"\>", 
      8->"\<\"Extension\"\>", 9->"\<\"False\"\>", 
      10->"\<\"MinimalPolynomial\"\>", 11->"\<\"NumberFieldClassNumber\"\>", 
      12->"\<\"NumberFieldDiscriminant\"\>", 
      13->"\<\"NumberFieldFundamentalUnits\"\>", 
      14->"\<\"NumberFieldIntegralBasis\"\>", 
      15->"\<\"NumberFieldNormRepresentatives\"\>", 
      16->"\<\"NumberFieldRegulator\"\>", 
      17->"\<\"NumberFieldRootsOfUnity\"\>", 
      18->"\<\"NumberFieldSignature\"\>", 19->"\<\"RootOfUnityQ\"\>", 
      20->"\<\"ToNumberField\"\>", 21->"\<\"True\"\>"}, "\<\"functions\"\>", 
      StyleBox["\<\"functions\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Algebraic Number Fields", "Title",
 CellID->16218],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " provides representation of algebraic numbers as ",
 Cell[BoxData[
  ButtonBox["Root",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Root"]], "InlineFormula"],
 " objects. A ",
 Cell[BoxData[
  ButtonBox["Root",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Root"]], "InlineFormula"],
 " object contains the minimal polynomial of the algebraic number and the \
root number\[LongDash]an integer indicating which of the roots of the minimal \
polynomial the ",
 Cell[BoxData[
  ButtonBox["Root",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Root"]], "InlineFormula"],
 " object represents. This allows for unique representation of arbitrary \
complex algebraic numbers. A disadvantage is that performing arithmetic \
operations in this representation is quite costly. That is why ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " requires the use of an additional function, ",
 Cell[BoxData[
  ButtonBox["RootReduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RootReduce"]], "InlineFormula"],
 ", in order to simplify arithmetic expressions. Restricting computations to \
be within a fixed finite algebraic extension of the rationals, ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[DoubleStruckCapitalQ]", "[", "\[Theta]", "]"}], 
   TraditionalForm]], "InlineMath"],
 ", allows a more convenient representation of its elements as polynomials in \
",
 Cell[BoxData[
  StyleBox["\[Theta]", "TR"]], "InlineFormula"],
 ". "
}], "Text",
 CellID->20604],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["AlgebraicNumber",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/AlgebraicNumber"], "[", 
     RowBox[{
      StyleBox["\[Theta]", "TR"], ",", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["c", "TI"], 
         StyleBox["0", "TR"]], ",", 
        SubscriptBox[
         StyleBox["c", "TI"], 
         StyleBox["1", "TR"]], ",", 
        StyleBox["\[Ellipsis]", "TR"], ",", 
        SubscriptBox[
         StyleBox["c", "TI"], 
         StyleBox["n", "TI"]]}], "}"}]}], "]"}], Cell[TextData[{
     "represent the algebraic number ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        SubscriptBox["c", "0"], "+", 
        RowBox[{
         SubscriptBox["c", "1"], "\[Theta]"}], " ", "+", "\[Ellipsis]", "+", 
        RowBox[{
         SubscriptBox["c", "n"], " ", 
         SuperscriptBox["\[Theta]", "n"]}]}], TraditionalForm]], 
      "InlineMath"],
     " in ",
     Cell[BoxData[
      FormBox[
       RowBox[{"\[DoubleStruckCapitalQ]", "[", "\[Theta]", "]"}], 
       TraditionalForm]], "InlineMath"]
    }], "TableText"]}
  }]], "DefinitionBox",
 CellID->152850453],

Cell["\<\
Representation of algebraic numbers as elements of a finite extension of \
rationals.\
\>", "Caption",
 CellID->2693506],

Cell[TextData[{
 "If ",
 Cell[BoxData[
  FormBox["\[Theta]", TraditionalForm]], "InlineMath"],
 " is an ",
 ButtonBox["algebraic integer",
  BaseStyle->"Hyperlink",
  ButtonData->"AlgebraicIntegerDef"],
 " with a ",
 Cell[BoxData[
  ButtonBox["MinimalPolynomial",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MinimalPolynomial"]], "InlineFormula"],
 " of degree ",
 Cell[BoxData[
  FormBox["l", TraditionalForm]], "InlineMath"],
 ", and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["c", "0"], ",", "\[Ellipsis]", ",", 
     SubscriptBox["c", "l"]}], "}"}], TraditionalForm]], "InlineMath"],
 " are rational numbers, then ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["AlgebraicNumber",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/AlgebraicNumber"], "[", 
   RowBox[{
    StyleBox["\[Theta]", "TR"], ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["c", "TI"], "0"], ",", 
      StyleBox["\[Ellipsis]", "TR"], ",", 
      SubscriptBox[
       StyleBox["c", "TI"], 
       StyleBox["l", "TI"]]}], "}"}]}], "]"}]], "InlineFormula"],
 " is an inert numeric object. "
}], "MathCaption",
 CellID->26843],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"a", "=", 
  RowBox[{"AlgebraicNumber", "[", 
   RowBox[{
    RowBox[{"Root", "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        SuperscriptBox["#", "3"], "-", "#", "+", "1"}], "&"}], ",", "1"}], 
     "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "3"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->8807],

Cell[BoxData[
 RowBox[{"AlgebraicNumber", "[", 
  RowBox[{
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"1", "-", "#1", "+", 
       SuperscriptBox["#1", "3"]}], "&"}], ",", "1"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}]}], "]"}]], "Output",
 ImageSize->{328, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1792923224]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["N",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/N"]], "InlineFormula"],
 " can be used to find a numeric approximation of an ",
 Cell[BoxData[
  ButtonBox["AlgebraicNumber",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AlgebraicNumber"]], "InlineFormula"],
 " object."
}], "MathCaption",
 CellID->7326],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{"a", ",", "20"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->14017],

Cell[BoxData["3.6151970842505862282267089801193856096`20."], "Output",
 ImageSize->{151, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->542195198]
}, Open  ]],

Cell[TextData[{
 "For any algebraic number ",
 Cell[BoxData[
  FormBox["\[Theta]", TraditionalForm]], "InlineMath"],
 " and any list of rational numbers ",
 Cell[BoxData[
  FormBox[
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["c", "0"], ",", "\[Ellipsis]", ",", 
     SubscriptBox["c", "l"]}], "}"}], TraditionalForm]], "InlineMath"],
 " , ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["AlgebraicNumber",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/AlgebraicNumber"], "[", 
   RowBox[{
    StyleBox["\[Theta]", "TR"], ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["c", "TI"], 
       StyleBox["0", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"], ",", 
      SubscriptBox[
       StyleBox["c", "TI"], 
       StyleBox["l", "TI"]]}], "}"}]}], "]"}]], "InlineFormula"],
 StyleBox[" ", "TR"],
 "evaluates to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["AlgebraicNumber",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/AlgebraicNumber"], "[", 
   RowBox[{
    StyleBox["\[Xi]", "TR"], ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["d", "TI"], 
       StyleBox["0", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"], ",", 
      SubscriptBox[
       StyleBox["d", "TI"], 
       StyleBox["m", "TI"]]}], "}"}]}], "]"}]], "InlineFormula"],
 ", such that ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Xi]", "=", 
    RowBox[{"d", "\[InvisibleSpace]", "\[Theta]"}]}], TraditionalForm]], 
  "InlineMath"],
 ", ",
 Cell[BoxData[
  FormBox["d", TraditionalForm]], "InlineMath"],
 " is a factor of the leading coefficient of ",
 Cell[BoxData[
  ButtonBox["MinimalPolynomial",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MinimalPolynomial"]], "InlineFormula"],
 " of ",
 Cell[BoxData[
  FormBox["\[Theta]", TraditionalForm]], "InlineMath"],
 ", such that ",
 Cell[BoxData[
  FormBox["\[Xi]", TraditionalForm]], "InlineMath"],
 " is an ",
 ButtonBox["algebraic integer",
  BaseStyle->"Hyperlink",
  ButtonData->"AlgebraicIntegerDef"],
 ", ",
 Cell[BoxData[
  FormBox["m", TraditionalForm]], "InlineMath"],
 " is the degree of",
 " ",
 Cell[BoxData[
  ButtonBox["MinimalPolynomial",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MinimalPolynomial"]], "InlineFormula"],
 " of ",
 Cell[BoxData[
  FormBox["\[Theta]", TraditionalForm]], "InlineMath"],
 ", and"
}], "Text",
 CellID->7340356],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    SubscriptBox["c", "0"], "+", 
    RowBox[{
     SubscriptBox["c", "1"], "\[Theta]"}], "+", "\[Ellipsis]", "+", 
    RowBox[{
     SubscriptBox["c", "l"], 
     SuperscriptBox["\[Theta]", "l"]}]}], "\[Equal]", 
   RowBox[{
    SubscriptBox["d", "0"], "+", 
    RowBox[{
     SubscriptBox["d", "1"], "\[Xi]"}], "+", "\[Ellipsis]", "+", 
    RowBox[{
     SubscriptBox["d", "m"], 
     RowBox[{
      SuperscriptBox["\[Xi]", "m"], "."}]}]}]}], 
  TraditionalForm]], "DisplayMath",
 UnderoverscriptBoxOptions->{LimitsPositioning->True},
 GridBoxOptions->{
 GridBoxItemSize->{
  "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}}},
 CellID->19869],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["AlgebraicNumber",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AlgebraicNumber"]], "InlineFormula"],
 " automatically makes the generator of the extension an algebraic integer \
and the coefficient list equal in length to the degree of the extension."
}], "MathCaption",
 CellID->22536],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AlgebraicNumber", "[", 
  RowBox[{
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"2", " ", 
        SuperscriptBox["#", "4"]}], "-", 
       RowBox[{"3", " ", "#"}], "+", "2"}], "&"}], ",", "1"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3", ",", "4", ",", "5", ",", "6"}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->15458],

Cell[BoxData[
 RowBox[{"AlgebraicNumber", "[", 
  RowBox[{
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"16", "-", 
       RowBox[{"12", " ", "#1"}], "+", 
       SuperscriptBox["#1", "4"]}], "&"}], ",", "1"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "4"}], ",", 
     FractionBox["7", "4"], ",", "3", ",", 
     FractionBox["1", "2"]}], "}"}]}], "]"}]], "Output",
 ImageSize->{387, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->188852885]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["AlgebraicNumber",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AlgebraicNumber"]], "InlineFormula"],
 " objects representing rational numbers reduce automatically to numbers."
}], "MathCaption",
 CellID->16828],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AlgebraicNumber", "[", 
  RowBox[{
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       SuperscriptBox["#", "5"], "-", 
       RowBox[{"7", " ", "#"}], "+", "1"}], "&"}], ",", "1"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "7", ",", "0", ",", "0", ",", "0", ",", 
     RowBox[{"-", "1"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->13914],

Cell[BoxData["1"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->1624782509]
}, Open  ]],

Cell[TextData[{
 "Adding or multiplying ",
 Cell[BoxData[
  ButtonBox["AlgebraicNumber",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AlgebraicNumber"]], "InlineFormula"],
 " objects that explicitly belong to the same field (i.e., have the same \
first elements), adding or multiplying a rational number and an ",
 Cell[BoxData[
  ButtonBox["AlgebraicNumber",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AlgebraicNumber"]], "InlineFormula"],
 " object, or raising an ",
 Cell[BoxData[
  ButtonBox["AlgebraicNumber",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AlgebraicNumber"]], "InlineFormula"],
 " object to an integer power yields an ",
 Cell[BoxData[
  ButtonBox["AlgebraicNumber",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AlgebraicNumber"]], "InlineFormula"],
 " object."
}], "MathCaption",
 CellID->25899],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"a", "=", 
   RowBox[{"AlgebraicNumber", "[", 
    RowBox[{
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         SuperscriptBox["#", "4"], "+", 
         RowBox[{"7", " ", "#"}], "-", "21"}], "&"}], ",", "1"}], "]"}], ",", 
     
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3", ",", "4"}], "}"}]}], "]"}]}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{"b", "=", 
   RowBox[{"AlgebraicNumber", "[", 
    RowBox[{
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         SuperscriptBox["#", "4"], "+", 
         RowBox[{"7", " ", "#"}], "-", "21"}], "&"}], ",", "1"}], "]"}], ",", 
     
     RowBox[{"{", 
      RowBox[{"9", ",", "8", ",", "7", ",", "5"}], "}"}]}], "]"}]}], 
  ";"}], "\n", 
 RowBox[{
  FractionBox[
   RowBox[{
    RowBox[{"2", " ", 
     SuperscriptBox["a", "2"]}], "-", 
    RowBox[{"3", " ", "a", " ", "b"}], "+", 
    RowBox[{"5", " ", 
     SuperscriptBox["b", "5"]}], "-", "3"}], 
   RowBox[{
    SuperscriptBox["a", "8"], "-", 
    SuperscriptBox["b", "4"], "+", 
    FractionBox["1", "2"]}]], "+", "9"}]}], "Input",
 CellLabel->"In[5]:=",
 CellID->22427],

Cell[BoxData[
 RowBox[{"AlgebraicNumber", "[", 
  RowBox[{
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"-", "21"}], "+", 
       RowBox[{"7", " ", "#1"}], "+", 
       SuperscriptBox["#1", "4"]}], "&"}], ",", "1"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["41286695899369558776723710439212189982056327290172063", 
      "4586375026009762651263976115838375027468985058462049"], ",", 
     FractionBox["6520802026300441952691134470541521717177617572114", 
      "13759125078029287953791928347515125082406955175386147"], ",", 
     FractionBox["3688721281596550115065494536738395724701865336152", 
      "13759125078029287953791928347515125082406955175386147"], ",", 
     FractionBox["2274021184276897634212701763901059483341282983762", 
      "13759125078029287953791928347515125082406955175386147"]}], "}"}]}], 
  "]"}]], "Output",
 ImageSize->{444, 142},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->1517609016]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["RootReduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RootReduce"]], "InlineFormula"],
 " transforms ",
 Cell[BoxData[
  ButtonBox["AlgebraicNumber",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AlgebraicNumber"]], "InlineFormula"],
 " objects to ",
 Cell[BoxData[
  ButtonBox["Root",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Root"]], "InlineFormula"],
 " objects."
}], "MathCaption",
 CellID->3921],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RootReduce", "[", "a", "]"}]], "Input",
 CellLabel->"In[8]:=",
 CellID->5340],

Cell[BoxData[
 RowBox[{"Root", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "3062597"}], "-", 
     RowBox[{"82303", " ", "#1"}], "+", 
     RowBox[{"1182", " ", 
      SuperscriptBox["#1", "2"]}], "+", 
     RowBox[{"80", " ", 
      SuperscriptBox["#1", "3"]}], "+", 
     SuperscriptBox["#1", "4"]}], "&"}], ",", "1"}], "]"}]], "Output",
 ImageSize->{347, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]=",
 CellID->62555239]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["ToNumberField",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ToNumberField"], "[", 
     RowBox[{
      StyleBox["a", "TI"], ",", 
      StyleBox["\[Theta]", "TR"]}], "]"}], Cell[TextData[{
     "express the algebraic number ",
     Cell[BoxData[
      StyleBox["a", "TI"]], "InlineFormula"],
     " in the number field generated by ",
     Cell[BoxData[
      StyleBox["\[Theta]", "TR"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["ToNumberField",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ToNumberField"], "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["a", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["a", "TI"], 
         StyleBox["2", "TR"]], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
      StyleBox["\[Theta]", "TR"]}], "]"}], Cell[TextData[{
     "express the ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["a", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     " in the field generated by ",
     Cell[BoxData[
      StyleBox["\[Theta]", "TR"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["ToNumberField",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ToNumberField"], "[", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["a", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["a", "TI"], 
        StyleBox["2", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}], Cell[TextData[{
     "express the ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["a", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     " in a common extension field generated by a single algebraic number"
    }], "TableText"]}
  }]], "DefinitionBox",
 CellID->877785135],

Cell["\<\
Representing arbitrary algebraic numbers as elements of algebraic number \
fields.\
\>", "Caption",
 CellID->772929199],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ToNumberField",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ToNumberField"]], "InlineFormula"],
 " can be used to find a common finite extension of rationals containing the \
given algebraic numbers."
}], "MathCaption",
 CellID->31493],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToNumberField", "[", 
  RowBox[{"{", 
   RowBox[{
    SqrtBox["2"], ",", 
    SqrtBox["3"]}], "}"}], "]"}]], "Input",
 CellLabel->"In[9]:=",
 CellID->32146],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"AlgebraicNumber", "[", 
    RowBox[{
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"1", "-", 
         RowBox[{"10", " ", 
          SuperscriptBox["#1", "2"]}], "+", 
         SuperscriptBox["#1", "4"]}], "&"}], ",", "4"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", 
        FractionBox["9", "2"]}], ",", "0", ",", 
       FractionBox["1", "2"]}], "}"}]}], "]"}], ",", 
   RowBox[{"AlgebraicNumber", "[", 
    RowBox[{
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"1", "-", 
         RowBox[{"10", " ", 
          SuperscriptBox["#1", "2"]}], "+", 
         SuperscriptBox["#1", "4"]}], "&"}], ",", "4"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       FractionBox["11", "2"], ",", "0", ",", 
       RowBox[{"-", 
        FractionBox["1", "2"]}]}], "}"}]}], "]"}]}], "}"}]], "Output",
 ImageSize->{406, 60},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[9]=",
 CellID->327091342]
}, Open  ]],

Cell[TextData[{
 "This represents ",
 Cell[BoxData[
  FormBox[
   SqrtBox["6"], TraditionalForm]], "InlineMath"],
 "as an element of the field generated by ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Root",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Root"], "[", 
   RowBox[{
    RowBox[{
     RowBox[{"1", "-", 
      RowBox[{"10", " ", 
       SuperscriptBox["#1", "2"]}], "+", 
      SuperscriptBox["#1", "4"]}], "&"}], ",", "4"}], "]"}]], 
  "InlineFormula"],
 "."
}], "MathCaption",
 CellID->15828],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToNumberField", "[", 
  RowBox[{
   SqrtBox["6"], ",", 
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"1", "-", 
       RowBox[{"10", " ", 
        SuperscriptBox["#", "2"]}], "+", 
       SuperscriptBox["#", "4"]}], "&"}], ",", "4"}], "]"}]}], "]"}]], "Input",\

 CellLabel->"In[10]:=",
 CellID->27094],

Cell[BoxData[
 RowBox[{"AlgebraicNumber", "[", 
  RowBox[{
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"1", "-", 
       RowBox[{"10", " ", 
        SuperscriptBox["#1", "2"]}], "+", 
       SuperscriptBox["#1", "4"]}], "&"}], ",", "4"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", 
      FractionBox["5", "2"]}], ",", "0", ",", 
     FractionBox["1", "2"], ",", "0"}], "}"}]}], "]"}]], "Output",
 ImageSize->{385, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[10]=",
 CellID->1561272400]
}, Open  ]],

Cell["\<\
Arithmetic within a fixed finite extension of rationals is much faster than \
arithmetic within the field of all complex algebraic numbers. \
\>", "Text",
 CellID->10802],

Cell[TextData[{
 "Suppose you need to find the value of rational function ",
 Cell[BoxData[
  FormBox["f", TraditionalForm]], "InlineMath"],
 " with ",
 Cell[BoxData[
  FormBox[
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}], TraditionalForm]], 
  "InlineMath"],
 " replaced by algebraic numbers ",
 Cell[BoxData[
  FormBox[
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}], TraditionalForm]], 
  "InlineMath"],
 "."
}], "MathCaption",
 CellID->22943],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}], "=", 
   RowBox[{"{", 
    RowBox[{"\[ImaginaryI]", ",", 
     SqrtBox["2"], ",", 
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         SuperscriptBox["#", "3"], "-", 
         RowBox[{"2", " ", "#"}], "+", "3"}], "&"}], ",", "1"}], "]"}]}], 
    "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"f", "=", 
   FractionBox[
    RowBox[{
     RowBox[{
      RowBox[{"-", "2"}], " ", "y", " ", "z", " ", 
      RowBox[{"(", 
       RowBox[{"7", "+", "x", "-", "y", "+", 
        SuperscriptBox["z", "2"]}], ")"}]}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"6", "+", 
        SuperscriptBox["x", "2"], "+", 
        RowBox[{"2", " ", "y"}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "11"}], "+", 
        RowBox[{"x", " ", "y"}], "+", 
        SuperscriptBox["z", "2"]}], ")"}]}]}], 
    RowBox[{
     RowBox[{"2", " ", "y", " ", "z", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "4"}], "-", "x", "+", 
        RowBox[{"3", " ", "y", " ", "z"}]}], ")"}]}], "-", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"6", "+", 
        SuperscriptBox["x", "2"], "+", 
        RowBox[{"2", " ", "y"}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"2", "-", 
        RowBox[{"2", " ", "x"}], "+", 
        SuperscriptBox["z", "3"]}], ")"}]}]}]]}], ";"}]}], "Input",
 CellLabel->"In[11]:=",
 CellID->9496],

Cell[TextData[{
 "A direct computation of the value of ",
 Cell[BoxData[
  FormBox["f", TraditionalForm]], "InlineMath"],
 " at ",
 Cell[BoxData[
  FormBox[
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}], TraditionalForm]], 
  "InlineMath"],
 " using ",
 Cell[BoxData[
  ButtonBox["RootReduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RootReduce"]], "InlineFormula"],
 " takes a rather long time."
}], "MathCaption",
 CellID->29027],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"RootReduce", "[", 
   RowBox[{"f", "/.", "\[InvisibleSpace]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"x", "\[Rule]", "a"}], ",", 
      RowBox[{"y", "\[Rule]", "b"}], ",", 
      RowBox[{"z", "\[Rule]", "c"}]}], "}"}]}], "]"}], "//", 
  "Timing"}]], "Input",
 CellLabel->"In[13]:=",
 CellID->3217],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"34.330145`", ",", 
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"127463137729603858692", "+", 
       RowBox[{"15069520316552576640", " ", "#1"}], "+", 
       RowBox[{"3151085417830482145156", " ", 
        SuperscriptBox["#1", "2"]}], "-", 
       RowBox[{"10938243534840099267928", " ", 
        SuperscriptBox["#1", "3"]}], "+", 
       RowBox[{"14492589303525156688533", " ", 
        SuperscriptBox["#1", "4"]}], "-", 
       RowBox[{"7171605298335082808820", " ", 
        SuperscriptBox["#1", "5"]}], "-", 
       RowBox[{"947445370794828405814", " ", 
        SuperscriptBox["#1", "6"]}], "+", 
       RowBox[{"2510661531113587622448", " ", 
        SuperscriptBox["#1", "7"]}], "-", 
       RowBox[{"606316032776880635517", " ", 
        SuperscriptBox["#1", "8"]}], "-", 
       RowBox[{"100899537810316084288", " ", 
        SuperscriptBox["#1", "9"]}], "+", 
       RowBox[{"74049398920051042942", " ", 
        SuperscriptBox["#1", "10"]}], "-", 
       RowBox[{"12985018306589245140", " ", 
        SuperscriptBox["#1", "11"]}], "+", 
       RowBox[{"879298673075259913", " ", 
        SuperscriptBox["#1", "12"]}]}], "&"}], ",", "4"}], "]"}]}], 
  "}"}]], "Output",
 ImageSize->{574, 122},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[13]=",
 CellID->1127742447]
}, Open  ]],

Cell[TextData[{
 "A faster alternative is to do the computation in a common algebraic number \
field containing ",
 Cell[BoxData[
  FormBox[
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}], TraditionalForm]], 
  "InlineMath"],
 "."
}], "MathCaption",
 CellID->5403],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"aa", ",", "bb", ",", "cc"}], "}"}], "=", 
    RowBox[{"ToNumberField", "[", 
     RowBox[{"{", 
      RowBox[{"a", ",", "b", ",", "c"}], "}"}], "]"}]}], ")"}], "//", 
  "Timing"}]], "Input",
 CellLabel->"In[14]:=",
 CellID->31672],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.048003000000001426`", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"AlgebraicNumber", "[", 
      RowBox[{
       RowBox[{"Root", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"648", "+", 
           RowBox[{"2592", " ", "#1"}], "+", 
           RowBox[{"3492", " ", 
            SuperscriptBox["#1", "2"]}], "+", 
           RowBox[{"1524", " ", 
            SuperscriptBox["#1", "3"]}], "+", 
           RowBox[{"217", " ", 
            SuperscriptBox["#1", "4"]}], "-", 
           RowBox[{"1152", " ", 
            SuperscriptBox["#1", "5"]}], "-", 
           RowBox[{"14", " ", 
            SuperscriptBox["#1", "6"]}], "-", 
           RowBox[{"72", " ", 
            SuperscriptBox["#1", "7"]}], "+", 
           RowBox[{"87", " ", 
            SuperscriptBox["#1", "8"]}], "+", 
           RowBox[{"12", " ", 
            SuperscriptBox["#1", "9"]}], "-", 
           RowBox[{"14", " ", 
            SuperscriptBox["#1", "10"]}], "+", 
           SuperscriptBox["#1", "12"]}], "&"}], ",", "4"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{
         FractionBox["244141", "94827"], ",", 
         FractionBox["12086198", "1991367"], ",", 
         FractionBox["7515071", "3982734"], ",", 
         FractionBox["42845617", "35844606"], ",", 
         RowBox[{"-", 
          FractionBox["26501665", "11948202"]}], ",", 
         FractionBox["1373087", "17922303"], ",", 
         RowBox[{"-", 
          FractionBox["718309", "3982734"]}], ",", 
         FractionBox["890062", "5974101"], ",", 
         FractionBox["8969", "284481"], ",", 
         RowBox[{"-", 
          FractionBox["926321", "35844606"]}], ",", 
         RowBox[{"-", 
          FractionBox["3503", "5974101"]}], ",", 
         FractionBox["34196", "17922303"]}], "}"}]}], "]"}], ",", 
     RowBox[{"AlgebraicNumber", "[", 
      RowBox[{
       RowBox[{"Root", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"648", "+", 
           RowBox[{"2592", " ", "#1"}], "+", 
           RowBox[{"3492", " ", 
            SuperscriptBox["#1", "2"]}], "+", 
           RowBox[{"1524", " ", 
            SuperscriptBox["#1", "3"]}], "+", 
           RowBox[{"217", " ", 
            SuperscriptBox["#1", "4"]}], "-", 
           RowBox[{"1152", " ", 
            SuperscriptBox["#1", "5"]}], "-", 
           RowBox[{"14", " ", 
            SuperscriptBox["#1", "6"]}], "-", 
           RowBox[{"72", " ", 
            SuperscriptBox["#1", "7"]}], "+", 
           RowBox[{"87", " ", 
            SuperscriptBox["#1", "8"]}], "+", 
           RowBox[{"12", " ", 
            SuperscriptBox["#1", "9"]}], "-", 
           RowBox[{"14", " ", 
            SuperscriptBox["#1", "10"]}], "+", 
           SuperscriptBox["#1", "12"]}], "&"}], ",", "4"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", 
          FractionBox["196718", "94827"]}], ",", 
         RowBox[{"-", 
          FractionBox["688153", "284481"]}], ",", 
         RowBox[{"-", 
          FractionBox["1293697", "568962"]}], ",", 
         FractionBox["3857569", "5120658"], ",", 
         FractionBox["3032287", "5120658"], ",", 
         FractionBox["1444985", "7680987"], ",", 
         FractionBox["4897", "1706886"], ",", 
         RowBox[{"-", 
          FractionBox["224722", "2560329"]}], ",", 
         FractionBox["2477", "853443"], ",", 
         FractionBox["55031", "5120658"], ",", 
         RowBox[{"-", 
          FractionBox["2143", "2560329"]}], ",", 
         RowBox[{"-", 
          FractionBox["5212", "7680987"]}]}], "}"}]}], "]"}], ",", 
     RowBox[{"AlgebraicNumber", "[", 
      RowBox[{
       RowBox[{"Root", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"648", "+", 
           RowBox[{"2592", " ", "#1"}], "+", 
           RowBox[{"3492", " ", 
            SuperscriptBox["#1", "2"]}], "+", 
           RowBox[{"1524", " ", 
            SuperscriptBox["#1", "3"]}], "+", 
           RowBox[{"217", " ", 
            SuperscriptBox["#1", "4"]}], "-", 
           RowBox[{"1152", " ", 
            SuperscriptBox["#1", "5"]}], "-", 
           RowBox[{"14", " ", 
            SuperscriptBox["#1", "6"]}], "-", 
           RowBox[{"72", " ", 
            SuperscriptBox["#1", "7"]}], "+", 
           RowBox[{"87", " ", 
            SuperscriptBox["#1", "8"]}], "+", 
           RowBox[{"12", " ", 
            SuperscriptBox["#1", "9"]}], "-", 
           RowBox[{"14", " ", 
            SuperscriptBox["#1", "10"]}], "+", 
           SuperscriptBox["#1", "12"]}], "&"}], ",", "4"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", 
          FractionBox["47423", "94827"]}], ",", 
         RowBox[{"-", 
          FractionBox["5277760", "1991367"]}], ",", 
         FractionBox["770404", "1991367"], ",", 
         RowBox[{"-", 
          FractionBox["34924300", "17922303"]}], ",", 
         FractionBox["29139493", "17922303"], ",", 
         RowBox[{"-", 
          FractionBox["14234156", "53766909"]}], ",", 
         FractionBox["1060324", "5974101"], ",", 
         RowBox[{"-", 
          FractionBox["1097132", "17922303"]}], ",", 
         RowBox[{"-", 
          FractionBox["29384", "853443"]}], ",", 
         FractionBox["90184", "5974101"], ",", 
         FractionBox["25510", "17922303"], ",", 
         RowBox[{"-", 
          FractionBox["66104", "53766909"]}]}], "}"}]}], "]"}]}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{549, 325},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[14]=",
 CellID->783265774]
}, Open  ]],

Cell["Arithmetic within the common number field is much faster.", \
"MathCaption",
 CellID->22685],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"d", "=", 
    RowBox[{
     FractionBox[
      RowBox[{
       RowBox[{
        RowBox[{"-", "2"}], " ", "y", " ", "z", " ", 
        RowBox[{"(", 
         RowBox[{"7", "+", "x", "-", "y", "+", 
          SuperscriptBox["z", "2"]}], ")"}]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"6", "+", 
          SuperscriptBox["x", "2"], "+", 
          RowBox[{"2", " ", "y"}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "11"}], "+", 
          RowBox[{"x", " ", "y"}], "+", 
          SuperscriptBox["z", "2"]}], ")"}]}]}], 
      RowBox[{
       RowBox[{"2", " ", "y", " ", "z", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "4"}], "-", "x", "+", 
          RowBox[{"3", " ", "y", " ", "z"}]}], ")"}]}], "-", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"6", "+", 
          SuperscriptBox["x", "2"], "+", 
          RowBox[{"2", " ", "y"}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"2", "-", 
          RowBox[{"2", " ", "x"}], "+", 
          SuperscriptBox["z", "3"]}], ")"}]}]}]], "/.", "\[InvisibleSpace]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"x", "\[Rule]", "aa"}], ",", 
       RowBox[{"y", "\[Rule]", "bb"}], ",", 
       RowBox[{"z", "\[Rule]", "cc"}]}], "}"}]}]}], ")"}], "//", 
  "Timing"}]], "Input",
 CellLabel->"In[15]:=",
 CellID->9711],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.036002000000000076`", ",", 
   RowBox[{"AlgebraicNumber", "[", 
    RowBox[{
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"648", "+", 
         RowBox[{"2592", " ", "#1"}], "+", 
         RowBox[{"3492", " ", 
          SuperscriptBox["#1", "2"]}], "+", 
         RowBox[{"1524", " ", 
          SuperscriptBox["#1", "3"]}], "+", 
         RowBox[{"217", " ", 
          SuperscriptBox["#1", "4"]}], "-", 
         RowBox[{"1152", " ", 
          SuperscriptBox["#1", "5"]}], "-", 
         RowBox[{"14", " ", 
          SuperscriptBox["#1", "6"]}], "-", 
         RowBox[{"72", " ", 
          SuperscriptBox["#1", "7"]}], "+", 
         RowBox[{"87", " ", 
          SuperscriptBox["#1", "8"]}], "+", 
         RowBox[{"12", " ", 
          SuperscriptBox["#1", "9"]}], "-", 
         RowBox[{"14", " ", 
          SuperscriptBox["#1", "10"]}], "+", 
         SuperscriptBox["#1", "12"]}], "&"}], ",", "4"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", 
        FractionBox["3860776239867194137278", "3970535965319412941431"]}], 
       ",", 
       RowBox[{"-", 
        FractionBox["53260812035714120989033", "11911607895958238824293"]}], 
       ",", 
       RowBox[{"-", 
        FractionBox["109038458622656664030115", "71469647375749432945758"]}], 
       ",", 
       RowBox[{"-", 
        FractionBox["192381933793750243587991", "107204471063624149418637"]}],
        ",", 
       FractionBox["70556676211663475835676", "35734823687874716472879"], ",",
        
       RowBox[{"-", 
        FractionBox["106803727028468004471691", "964840239572617344767733"]}],
        ",", 
       FractionBox["7665080170226573969564", "35734823687874716472879"], ",", 
       
       RowBox[{"-", 
        FractionBox["36535823424460554318055", "321613413190872448255911"]}], 
       ",", 
       RowBox[{"-", 
        FractionBox["124880404825784359957", "3403316541702353949798"]}], ",",
        
       FractionBox["7067040798332263363508", "321613413190872448255911"], ",",
        
       FractionBox["7357016108927986451", "5104974812553530924697"], ",", 
       RowBox[{"-", 
        FractionBox["1522619721558874444783", "964840239572617344767733"]}]}],
       "}"}]}], "]"}]}], "}"}]], "Output",
 ImageSize->{542, 243},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[15]=",
 CellID->1158559922]
}, Open  ]],

Cell[TextData[{
 "Converting the resulting ",
 Cell[BoxData[
  ButtonBox["AlgebraicNumber",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AlgebraicNumber"]], "InlineFormula"],
 " object to a ",
 Cell[BoxData[
  ButtonBox["Root",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Root"]], "InlineFormula"],
 " object is fast as well."
}], "MathCaption",
 CellID->7254],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"RootReduce", "[", "d", "]"}], "//", "Timing"}]], "Input",
 CellLabel->"In[16]:=",
 CellID->21354],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.044002999999998876`", ",", 
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"127463137729603858692", "+", 
       RowBox[{"15069520316552576640", " ", "#1"}], "+", 
       RowBox[{"3151085417830482145156", " ", 
        SuperscriptBox["#1", "2"]}], "-", 
       RowBox[{"10938243534840099267928", " ", 
        SuperscriptBox["#1", "3"]}], "+", 
       RowBox[{"14492589303525156688533", " ", 
        SuperscriptBox["#1", "4"]}], "-", 
       RowBox[{"7171605298335082808820", " ", 
        SuperscriptBox["#1", "5"]}], "-", 
       RowBox[{"947445370794828405814", " ", 
        SuperscriptBox["#1", "6"]}], "+", 
       RowBox[{"2510661531113587622448", " ", 
        SuperscriptBox["#1", "7"]}], "-", 
       RowBox[{"606316032776880635517", " ", 
        SuperscriptBox["#1", "8"]}], "-", 
       RowBox[{"100899537810316084288", " ", 
        SuperscriptBox["#1", "9"]}], "+", 
       RowBox[{"74049398920051042942", " ", 
        SuperscriptBox["#1", "10"]}], "-", 
       RowBox[{"12985018306589245140", " ", 
        SuperscriptBox["#1", "11"]}], "+", 
       RowBox[{"879298673075259913", " ", 
        SuperscriptBox["#1", "12"]}]}], "&"}], ",", "4"}], "]"}]}], 
  "}"}]], "Output",
 ImageSize->{574, 122},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[16]=",
 CellID->647584243]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["ToNumberField",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ToNumberField"], "[", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox[
      StyleBox["a", "TI"], 
      StyleBox["1", "TR"]], ",", 
     SubscriptBox[
      StyleBox["a", "TI"], 
      StyleBox["2", "TR"]], ",", 
     StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ToNumberField",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ToNumberField"], "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["a", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["a", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"]}], "]"}]], "InlineFormula"],
 ", and does not necessarily use the smallest common field extension. ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ToNumberField",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ToNumberField"], "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["a", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["a", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
    ButtonBox["All",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/All"]}], "]"}]], "InlineFormula"],
 " always uses the smallest common field extension."
}], "Text",
 CellID->230163894],

Cell[TextData[{
 "Here the first ",
 Cell[BoxData[
  ButtonBox["AlgebraicNumber",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AlgebraicNumber"]], "InlineFormula"],
 " object is equal to",
 " ",
 Cell[BoxData[
  FormBox[
   SqrtBox["2"], TraditionalForm]], "InlineMath"],
 " so it does not generate the 4",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
 "-degree field ",
 Cell[BoxData[
  StyleBox["\[DoubleStruckCapitalQ]", "TR"]], "InlineFormula"],
 " (",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Root",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Root"], "[", 
   RowBox[{
    RowBox[{
     RowBox[{"1", "-", 
      RowBox[{"10", " ", 
       SuperscriptBox["#1", "2"]}], "+", 
      SuperscriptBox["#1", "4"]}], "&"}], ",", "4"}], "]"}]], 
  "InlineFormula"],
 ") it is represented in. However, the common field found by ",
 Cell[BoxData[
  ButtonBox["ToNumberField",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ToNumberField"]], "InlineFormula"],
 " contains the whole field ",
 Cell[BoxData[
  StyleBox["\[DoubleStruckCapitalQ]", "TR"]], "InlineFormula"],
 " (",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Root",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Root"], "[", 
   RowBox[{
    RowBox[{
     RowBox[{"1", "-", 
      RowBox[{"10", " ", 
       SuperscriptBox["#1", "2"]}], "+", 
      SuperscriptBox["#1", "4"]}], "&"}], ",", "4"}], "]"}]], 
  "InlineFormula"],
 ")."
}], "MathCaption",
 CellID->15866],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToNumberField", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"AlgebraicNumber", "[", 
     RowBox[{
      RowBox[{"Root", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"1", "-", 
          RowBox[{"10", " ", 
           SuperscriptBox["#", "2"]}], "+", 
          SuperscriptBox["#", "4"]}], "&"}], ",", "4"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", 
        RowBox[{"-", 
         FractionBox["9", "2"]}], ",", "0", ",", 
        FractionBox["1", "2"]}], "}"}]}], "]"}], ",", 
    SqrtBox["5"]}], "}"}], "]"}]], "Input",
 CellLabel->"In[17]:=",
 CellID->5209],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"AlgebraicNumber", "[", 
    RowBox[{
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"576", "-", 
         RowBox[{"960", " ", 
          SuperscriptBox["#1", "2"]}], "+", 
         RowBox[{"352", " ", 
          SuperscriptBox["#1", "4"]}], "-", 
         RowBox[{"40", " ", 
          SuperscriptBox["#1", "6"]}], "+", 
         SuperscriptBox["#1", "8"]}], "&"}], ",", "8"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       FractionBox["5", "3"], ",", "0", ",", 
       RowBox[{"-", 
        FractionBox["7", "72"]}], ",", "0", ",", 
       RowBox[{"-", 
        FractionBox["7", "144"]}], ",", "0", ",", 
       FractionBox["1", "576"]}], "}"}]}], "]"}], ",", 
   RowBox[{"AlgebraicNumber", "[", 
    RowBox[{
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"576", "-", 
         RowBox[{"960", " ", 
          SuperscriptBox["#1", "2"]}], "+", 
         RowBox[{"352", " ", 
          SuperscriptBox["#1", "4"]}], "-", 
         RowBox[{"40", " ", 
          SuperscriptBox["#1", "6"]}], "+", 
         SuperscriptBox["#1", "8"]}], "&"}], ",", "8"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", 
        FractionBox["53", "12"]}], ",", "0", ",", 
       FractionBox["95", "36"], ",", "0", ",", 
       RowBox[{"-", 
        FractionBox["97", "288"]}], ",", "0", ",", 
       FractionBox["5", "576"]}], "}"}]}], "]"}]}], "}"}]], "Output",
 ImageSize->{551, 82},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[17]=",
 CellID->1531442682]
}, Open  ]],

Cell[TextData[{
 "Specifying the second argument ",
 Cell[BoxData[
  ButtonBox["All",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/All"]], "InlineFormula"],
 " makes ",
 Cell[BoxData[
  ButtonBox["ToNumberField",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ToNumberField"]], "InlineFormula"],
 " find the smallest field possible."
}], "MathCaption",
 CellID->6398],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToNumberField", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"AlgebraicNumber", "[", 
      RowBox[{
       RowBox[{"Root", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"1", "-", 
           RowBox[{"10", " ", 
            SuperscriptBox["#", "2"]}], "+", 
           SuperscriptBox["#", "4"]}], "&"}], ",", "4"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", 
         RowBox[{"-", 
          FractionBox["9", "2"]}], ",", "0", ",", 
         FractionBox["1", "2"]}], "}"}]}], "]"}], ",", 
     SqrtBox["5"]}], "}"}], ",", "All"}], "]"}]], "Input",
 CellLabel->"In[18]:=",
 CellID->253331846],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"AlgebraicNumber", "[", 
    RowBox[{
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"9", "-", 
         RowBox[{"14", " ", 
          SuperscriptBox["#1", "2"]}], "+", 
         SuperscriptBox["#1", "4"]}], "&"}], ",", "4"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", 
        FractionBox["11", "6"]}], ",", "0", ",", 
       FractionBox["1", "6"]}], "}"}]}], "]"}], ",", 
   RowBox[{"AlgebraicNumber", "[", 
    RowBox[{
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"9", "-", 
         RowBox[{"14", " ", 
          SuperscriptBox["#1", "2"]}], "+", 
         SuperscriptBox["#1", "4"]}], "&"}], ",", "4"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       FractionBox["17", "6"], ",", "0", ",", 
       RowBox[{"-", 
        FractionBox["1", "6"]}]}], "}"}]}], "]"}]}], "}"}]], "Output",
 ImageSize->{406, 60},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[18]=",
 CellID->415220632]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["MinimalPolynomial",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/MinimalPolynomial"], "[", 
     StyleBox["a", "TI"], "]"}], Cell[TextData[{
     "give a pure function representation of the minimal polynomial over the \
integers of the algebraic number ",
     Cell[BoxData[
      StyleBox["a", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["MinimalPolynomial",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/MinimalPolynomial"], "[", 
     RowBox[{
      StyleBox["a", "TI"], ",", 
      StyleBox["x", "TI"]}], "]"}], Cell[TextData[{
     "give the minimal polynomial of the algebraic number ",
     Cell[BoxData[
      StyleBox["a", "TI"]], "InlineFormula"],
     " as a polynomial in ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["AlgebraicIntegerQ",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/AlgebraicIntegerQ"], "[", 
     StyleBox["a", "TI"], "]"}], Cell[TextData[{
     "give ",
     Cell[BoxData[
      ButtonBox["True",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/True"]], "InlineFormula"],
     " if the algebraic number ",
     Cell[BoxData[
      StyleBox["a", "TI"]], "InlineFormula"],
     " is an algebraic integer and ",
     Cell[BoxData[
      ButtonBox["False",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/False"]], "InlineFormula"],
     " otherwise"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["AlgebraicNumberDenominator",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/AlgebraicNumberDenominator"], "[", 
     StyleBox["a", "TI"], "]"}], Cell[TextData[{
     "give the smallest positive integer ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " such that ",
     Cell[BoxData[
      StyleBox["na", "TI"]], "InlineFormula"],
     " is an algebraic integer"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["AlgebraicNumberTrace",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/AlgebraicNumberTrace"], "[", 
     StyleBox["a", "TI"], "]"}], Cell[TextData[{
     "give the trace of the algebraic number ",
     Cell[BoxData[
      StyleBox["a", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["AlgebraicNumberNorm",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/AlgebraicNumberNorm"], "[", 
     StyleBox["a", "TI"], "]"}], Cell[TextData[{
     "give the norm of the algebraic number ",
     Cell[BoxData[
      StyleBox["a", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["AlgebraicUnitQ",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/AlgebraicUnitQ"], "[", 
     StyleBox["a", "TI"], "]"}], Cell[TextData[{
     "give ",
     Cell[BoxData[
      ButtonBox["True",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/True"]], "InlineFormula"],
     " if the algebraic number ",
     Cell[BoxData[
      StyleBox["a", "TI"]], "InlineFormula"],
     " is an algebraic unit and ",
     Cell[BoxData[
      ButtonBox["False",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/False"]], "InlineFormula"],
     " otherwise"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["RootOfUnityQ",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/RootOfUnityQ"], "[", 
     StyleBox["a", "TI"], "]"}], Cell[TextData[{
     "give ",
     Cell[BoxData[
      ButtonBox["True",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/True"]], "InlineFormula"],
     " if the algebraic number ",
     Cell[BoxData[
      StyleBox["a", "TI"]], "InlineFormula"],
     " is a root of unity and ",
     Cell[BoxData[
      ButtonBox["False",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/False"]], "InlineFormula"],
     " otherwise"
    }], "TableText"]}
  }]], "DefinitionBox",
 CellID->957716660],

Cell["Functions for computing algebraic number properties.", "Caption",
 CellID->20781152],

Cell[TextData[{
 "The minimal polynomial of an algebraic number ",
 Cell[BoxData[
  StyleBox["a", "TI"]], "InlineFormula"],
 " is the lowest-degree polynomial ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 " with integer coefficients and the smallest positive leading coefficient, \
such that",
 " ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"f", "(", "a", ")"}], "\[Equal]", "0"}], TraditionalForm]], 
  "InlineMath"],
 "."
}], "Text",
 CellID->7693],

Cell[TextData[{
 "This gives the minimal polynomial of ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SqrtBox["2"], "+", 
    SqrtBox["3"]}], TraditionalForm]], "InlineMath"],
 " expressed as a pure function."
}], "MathCaption",
 CellID->3253],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MinimalPolynomial", "[", 
  RowBox[{
   SqrtBox["2"], "+", 
   SqrtBox["3"]}], "]"}]], "Input",
 CellLabel->"In[19]:=",
 CellID->1924],

Cell[BoxData[
 RowBox[{
  RowBox[{"1", "-", 
   RowBox[{"10", " ", 
    SuperscriptBox["#1", "2"]}], "+", 
   SuperscriptBox["#1", "4"]}], "&"}]], "Output",
 ImageSize->{103, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[19]=",
 CellID->415715460]
}, Open  ]],

Cell[TextData[{
 "This gives the minimal polynomial of ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox[
    RowBox[{
     ButtonBox["Root",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Root"], "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        SuperscriptBox["#1", "5"], "-", 
        RowBox[{"2", " ", "#1"}], "+", "7"}], "&"}], ",", "1"}], "]"}], "2"], 
   "+", "1"}]], "InlineFormula"],
 " expressed as a polynomial in ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 "."
}], "MathCaption",
 CellID->25248],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MinimalPolynomial", "[", 
  RowBox[{
   RowBox[{
    SuperscriptBox[
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         SuperscriptBox["#", "5"], "-", 
         RowBox[{"2", " ", "#"}], "+", "7"}], "&"}], ",", "1"}], "]"}], "2"], 
    "+", "1"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[20]:=",
 CellID->16111],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "50"}], "-", 
  RowBox[{"3", " ", "x"}], "+", 
  RowBox[{"2", " ", 
   SuperscriptBox["x", "2"]}], "+", 
  RowBox[{"6", " ", 
   SuperscriptBox["x", "3"]}], "-", 
  RowBox[{"5", " ", 
   SuperscriptBox["x", "4"]}], "+", 
  SuperscriptBox["x", "5"]}]], "Output",
 ImageSize->{186, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[20]=",
 CellID->1882796525]
}, Open  ]],

Cell[TextData[{
 "An algebraic number is an algebraic integer iff its ",
 Cell[BoxData[
  ButtonBox["MinimalPolynomial",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MinimalPolynomial"]], "InlineFormula"],
 " is monic."
}], "Text",
 CellTags->"AlgebraicIntegerDef",
 CellID->22043],

Cell[TextData[{
 "This shows that ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    FractionBox["1", "2"], 
    RowBox[{"(", 
     RowBox[{"1", "+", 
      SqrtBox["5"]}], ")"}]}], TraditionalForm]], "InlineMath"],
 " is an algebraic integer."
}], "MathCaption",
 CellID->27103],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AlgebraicIntegerQ", "[", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   RowBox[{"(", 
    RowBox[{"1", "+", 
     SqrtBox["5"]}], ")"}]}], "]"}]], "Input",
 CellLabel->"In[21]:=",
 CellID->1623],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[21]=",
 CellID->276044526]
}, Open  ]],

Cell[TextData[{
 "This shows that ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    FractionBox["1", "4"], 
    RowBox[{"(", 
     RowBox[{"1", "+", 
      SqrtBox["5"]}], ")"}]}], TraditionalForm]], "InlineMath"],
 " is not an algebraic integer."
}], "MathCaption",
 CellID->29723],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AlgebraicIntegerQ", "[", 
  RowBox[{
   FractionBox["1", "4"], " ", 
   RowBox[{"(", 
    RowBox[{"1", "+", 
     SqrtBox["5"]}], ")"}]}], "]"}]], "Input",
 CellLabel->"In[22]:=",
 CellID->4285],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[22]=",
 CellID->2033370407]
}, Open  ]],

Cell[TextData[{
 "This gives the smallest positive integer ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 " for which ",
 Cell[BoxData[
  FormBox[
   RowBox[{"n", " ", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "+", 
       SqrtBox["5"]}], ")"}], "/", "4"}]}], TraditionalForm]], "InlineMath"],
 " is an algebraic integer."
}], "MathCaption",
 CellID->19712],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AlgebraicNumberDenominator", "[", 
  RowBox[{
   FractionBox["1", "4"], " ", 
   RowBox[{"(", 
    RowBox[{"1", "+", 
     SqrtBox["5"]}], ")"}]}], "]"}]], "Input",
 CellLabel->"In[23]:=",
 CellID->27117],

Cell[BoxData["2"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[23]=",
 CellID->1528236102]
}, Open  ]],

Cell[TextData[{
 "The trace of an algebraic number ",
 StyleBox["a",
  FontSlant->"Italic"],
 " is the sum of all roots of ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["MinimalPolynomial",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MinimalPolynomial"], "[", 
   StyleBox["a", "TI"], "]"}]], "InlineFormula"],
 "."
}], "Text",
 CellID->15469],

Cell[TextData[{
 "This gives the trace of ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"-", "1"}], ")"}], 
    RowBox[{"1", "/", "7"}]], TraditionalForm]], "InlineMath"],
 "."
}], "MathCaption",
 CellID->15807],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AlgebraicNumberTrace", "[", 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{"-", "1"}], ")"}], 
   RowBox[{"1", "/", "7"}]], "]"}]], "Input",
 CellLabel->"In[24]:=",
 CellID->15966],

Cell[BoxData["1"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[24]=",
 CellID->818239724]
}, Open  ]],

Cell[TextData[{
 "The norm of an algebraic number ",
 Cell[BoxData[
  FormBox["a", TraditionalForm]], "InlineMath"],
 " is the product of all roots of ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["MinimalPolynomial",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MinimalPolynomial"], "[", 
   StyleBox["a", "TI"], "]"}]], "InlineFormula"],
 "."
}], "Text",
 CellID->10584],

Cell[TextData[{
 "This gives the norm of ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SqrtBox["3"], "+", 
    SqrtBox["5"]}], TraditionalForm]], "InlineMath"],
 "."
}], "MathCaption",
 CellID->11381],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AlgebraicNumberNorm", "[", 
  RowBox[{
   SqrtBox["3"], "+", 
   SqrtBox["5"]}], "]"}]], "Input",
 CellLabel->"In[25]:=",
 CellID->2065],

Cell[BoxData["4"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[25]=",
 CellID->74739644]
}, Open  ]],

Cell[TextData[{
 "An algebraic number ",
 Cell[BoxData[
  FormBox["a", TraditionalForm]], "InlineMath"],
 " is an algebraic unit iff both ",
 Cell[BoxData[
  FormBox["a", TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"1", "/", "a"}], TraditionalForm]], "InlineMath"],
 " are algebraic integers, or equivalently, iff ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["AlgebraicNumberNorm",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/AlgebraicNumberNorm"], "[", 
   StyleBox["a", "TI"], "]"}]], "InlineFormula"],
 " is ",
 Cell[BoxData[
  FormBox["1", TraditionalForm]], "InlineMath"],
 " or ",
 Cell[BoxData[
  FormBox[
   RowBox[{"-", "1"}], TraditionalForm]], "InlineMath"],
 "."
}], "Text",
 CellID->630],

Cell[TextData[{
 "This shows that ",
 Cell[BoxData[
  ButtonBox["GoldenRatio",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GoldenRatio"]], "InlineFormula"],
 " is an algebraic unit."
}], "MathCaption",
 CellID->10560],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AlgebraicUnitQ", "[", "GoldenRatio", "]"}]], "Input",
 CellLabel->"In[26]:=",
 CellID->9087],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[26]=",
 CellID->188365092]
}, Open  ]],

Cell[TextData[{
 "This shows that ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["AlgebraicNumber",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/AlgebraicNumber"], "[", 
   RowBox[{
    RowBox[{
     ButtonBox["Root",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Root"], "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        SuperscriptBox["#1", "3"], "-", 
        RowBox[{"4", "#1"}], "+", "17"}], "&"}], ",", "1"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "3"}], "}"}]}], "]"}]], "InlineFormula"],
 " is not an algebraic unit."
}], "MathCaption",
 CellID->11945],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AlgebraicUnitQ", "[", 
  RowBox[{"AlgebraicNumber", "[", 
   RowBox[{
    RowBox[{"Root", "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        SuperscriptBox["#", "3"], "-", 
        RowBox[{"4", " ", "#"}], "+", "17"}], "&"}], ",", "1"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "3"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[27]:=",
 CellID->25993],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[27]=",
 CellID->137294883]
}, Open  ]],

Cell[TextData[{
 "An algebraic number ",
 StyleBox["a",
  FontSlant->"Italic"],
 " is a root of unity iff ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["a", "n"], "\[Equal]", "1"}], TraditionalForm]], 
  "InlineMath"],
 " for some integer ",
 StyleBox["n",
  FontSlant->"Italic"],
 "."
}], "Text",
 CellID->26842],

Cell[TextData[{
 "This shows that ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      SqrtBox[
       RowBox[{"2", "+", 
        SqrtBox["2"]}]], "+", 
      RowBox[{"\[ImaginaryI]", " ", 
       SqrtBox[
        RowBox[{"2", "-", 
         SqrtBox["2"]}]]}]}], ")"}], "/", "2"}], TraditionalForm]], 
  "InlineMath"],
 " is a root of unity."
}], "MathCaption",
 CellID->11465],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RootOfUnityQ", "[", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   RowBox[{"(", 
    RowBox[{
     SqrtBox[
      RowBox[{"2", "+", 
       SqrtBox["2"]}]], "+", 
     RowBox[{"\[ImaginaryI]", " ", 
      SqrtBox[
       RowBox[{"2", "-", 
        SqrtBox["2"]}]]}]}], ")"}]}], "]"}]], "Input",
 CellLabel->"In[28]:=",
 CellID->12249],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[28]=",
 CellID->1332626305]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["MinimalPolynomial",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/MinimalPolynomial"], "[", 
     RowBox[{
      StyleBox["s", "TI"], ",", 
      StyleBox["x", "TI"], ",", 
      RowBox[{
       ButtonBox["Extension",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Extension"], "->", 
       StyleBox["a", "TI"]}]}], "]"}], "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "give the characteristic polynomial of the algebraic number ",
     Cell[BoxData[
      FormBox["s", TraditionalForm]], "InlineMath"],
     " over the field ",
     Cell[BoxData[
      FormBox[
       RowBox[{"\[DoubleStruckCapitalQ]", "[", "a", "]"}], TraditionalForm]], 
      "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["MinimalPolynomial",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/MinimalPolynomial"], "[", 
     RowBox[{
      StyleBox["s", "TI"], ",", 
      StyleBox["x", "TI"], ",", 
      RowBox[{
       ButtonBox["Extension",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Extension"], "->", 
       ButtonBox["Automatic",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Automatic"]}]}], "]"}], "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "give the characteristic polynomial of the ",
     Cell[BoxData[
      ButtonBox["AlgebraicNumber",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/AlgebraicNumber"]], "InlineFormula"],
     " object ",
     Cell[BoxData[
      FormBox["s", TraditionalForm]], "InlineMath"],
     " over the number field generated by its first argument"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["AlgebraicNumberTrace",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/AlgebraicNumberTrace"], "[", 
     RowBox[{
      StyleBox["a", "TI"], ",", 
      RowBox[{
       ButtonBox["Extension",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Extension"], "->", 
       StyleBox["\[Theta]", "TR"]}]}], "]"}], "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "give the trace of the algebraic number ",
     Cell[BoxData[
      FormBox["a", TraditionalForm]], "InlineMath"],
     " over the field ",
     Cell[BoxData[
      FormBox[
       RowBox[{"\[DoubleStruckCapitalQ]", "[", "\[Theta]", "]"}], 
       TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["AlgebraicNumberTrace",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/AlgebraicNumberTrace"], "[", 
     RowBox[{
      StyleBox["a", "TI"], ",", 
      RowBox[{
       ButtonBox["Extension",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Extension"], "->", 
       ButtonBox["Automatic",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Automatic"]}]}], "]"}], "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "give the trace of the ",
     Cell[BoxData[
      ButtonBox["AlgebraicNumber",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/AlgebraicNumber"]], "InlineFormula"],
     " object ",
     Cell[BoxData[
      FormBox["a", TraditionalForm]], "InlineMath"],
     " over the number field generated by its first argument"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["AlgebraicNumberNorm",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/AlgebraicNumberNorm"], "[", 
     RowBox[{
      StyleBox["a", "TI"], ",", 
      RowBox[{
       ButtonBox["Extension",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Extension"], "->", 
       StyleBox["\[Theta]", "TR"]}]}], "]"}], "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "give the norm of the algebraic number ",
     Cell[BoxData[
      FormBox["a", TraditionalForm]], "InlineMath"],
     " over the field ",
     Cell[BoxData[
      FormBox[
       RowBox[{"\[DoubleStruckCapitalQ]", "[", "\[Theta]", "]"}], 
       TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["AlgebraicNumberNorm",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/AlgebraicNumberNorm"], "[", 
     RowBox[{
      StyleBox["a", "TI"], ",", 
      RowBox[{
       ButtonBox["Extension",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Extension"], "->", 
       ButtonBox["Automatic",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Automatic"]}]}], "]"}], "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "give the norm of the ",
     Cell[BoxData[
      ButtonBox["AlgebraicNumber",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/AlgebraicNumber"]], "InlineFormula"],
     " object ",
     Cell[BoxData[
      FormBox["a", TraditionalForm]], "InlineMath"],
     " over the number field generated by its first argument"
    }], "TableText"]}
  }]], "DefinitionBox",
 CellID->878101067],

Cell["\<\
Functions for computing properties of elements of algebraic number fields. \
\>", "Caption",
 CellID->413290897],

Cell[TextData[{
 "If ",
 Cell[BoxData[
  StyleBox["a", "TI"]], "InlineFormula"],
 " is ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["AlgebraicNumber",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/AlgebraicNumber"], "[", 
   RowBox[{
    StyleBox["\[Theta]", "TR"], ",", 
    StyleBox["coeffs", "TI"]}], "]"}]], "InlineFormula"],
 ", then ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["MinimalPolynomial",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MinimalPolynomial"], "[", 
   RowBox[{
    StyleBox["a", "TI"], ",", 
    StyleBox["x", "TI"], ",", 
    RowBox[{
     ButtonBox["Extension",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Extension"], "->", 
     ButtonBox["Automatic",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Automatic"]}]}], "]"}]], "InlineFormula"],
 " is equal to ",
 Cell[BoxData[
  SuperscriptBox[
   RowBox[{
    ButtonBox["MinimalPolynomial",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/MinimalPolynomial"], "[", 
    RowBox[{
     StyleBox["a", "TI"], ",", 
     StyleBox["x", "TI"]}], "]"}], 
   StyleBox["d", "TI"]]], "InlineFormula"],
 ", where ",
 Cell[BoxData[
  StyleBox["d", "TI"]], "InlineFormula"],
 " is the extension degree of ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"\[DoubleStruckCapitalQ]", "(", "\[Theta]", ")"}], "/", 
    RowBox[{"\[DoubleStruckCapitalQ]", "(", "a", ")"}]}], TraditionalForm]], 
  "InlineMath"],
 "."
}], "Text",
 CellID->25070],

Cell[TextData[{
 "The characteristic polynomial of ",
 Cell[BoxData[
  FormBox[
   SqrtBox["2"], TraditionalForm]], "InlineMath"],
 ", represented as an element of an extension of rationals of degree ",
 Cell[BoxData[
  FormBox["4", TraditionalForm]], "InlineMath"],
 ", is the square of ",
 Cell[BoxData[
  ButtonBox["MinimalPolynomial",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MinimalPolynomial"]], "InlineFormula"],
 " of ",
 Cell[BoxData[
  FormBox[
   SqrtBox["2"], TraditionalForm]], "InlineMath"],
 "."
}], "MathCaption",
 CellID->1496],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"a", "=", 
   RowBox[{"AlgebraicNumber", "[", 
    RowBox[{
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"1", "-", 
         RowBox[{"10", " ", 
          SuperscriptBox["#", "2"]}], "+", 
         SuperscriptBox["#", "4"]}], "&"}], ",", "4"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", 
        FractionBox["9", "2"]}], ",", "0", ",", 
       FractionBox["1", "2"]}], "}"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{"MinimalPolynomial", "[", 
  RowBox[{"a", ",", "x"}], "]"}], "\n", 
 RowBox[{
  RowBox[{"MinimalPolynomial", "[", 
   RowBox[{"a", ",", "x", ",", 
    RowBox[{"Extension", "\[Rule]", "Automatic"}]}], "]"}], "//", 
  "Factor"}]}], "Input",
 CellLabel->"In[29]:=",
 CellID->64447948],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "2"}], "+", 
  SuperscriptBox["x", "2"]}]], "Output",
 ImageSize->{44, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[30]=",
 CellID->1749637492],

Cell[BoxData[
 SuperscriptBox[
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", "2"}], "+", 
    SuperscriptBox["x", "2"]}], ")"}], "2"]], "Output",
 ImageSize->{64, 20},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[31]=",
 CellID->1420150567]
}, Open  ]],

Cell[TextData[{
 "The trace of an algebraic number is the sum of all roots of its \
characteristic polynomial. If ",
 Cell[BoxData[
  StyleBox["a", "TI"]], "InlineFormula"],
 " is ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["AlgebraicNumber",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/AlgebraicNumber"], "[", 
   RowBox[{
    StyleBox["\[Theta]", "TR"], ",", 
    StyleBox["coeffs", "TI"]}], "]"}]], "InlineFormula"],
 StyleBox[",", "MR"],
 " then ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["AlgebraicNumberTrace",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/AlgebraicNumberTrace"], "[", 
   RowBox[{
    StyleBox["a", "TI"], ",", 
    RowBox[{
     ButtonBox["Extension",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Extension"], "->", 
     ButtonBox["Automatic",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Automatic"]}]}], "]"}]], "InlineFormula"],
 " is equal to ",
 Cell[BoxData[
  RowBox[{
   StyleBox["d", "TI"], " ", 
   RowBox[{
    ButtonBox["AlgebraicNumberTrace",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/AlgebraicNumberTrace"], "[", 
    StyleBox["a", "TI"], "]"}]}]], "InlineFormula"],
 ", where ",
 Cell[BoxData[
  StyleBox["d", "TI"]], "InlineFormula"],
 " is the extension degree of ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[DoubleStruckCapitalQ]", 
    RowBox[{
     RowBox[{"(", "\[Theta]", ")"}], "/", "\[DoubleStruckCapitalQ]"}], 
    RowBox[{"(", "a", ")"}]}], TraditionalForm]], "InlineMath"],
 "."
}], "Text",
 CellID->29967],

Cell[TextData[{
 "The trace of ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SqrtBox["2"], "+", "1"}], TraditionalForm]], "InlineMath"],
 ", represented as an element of an extension of rationals of degree ",
 Cell[BoxData[
  FormBox["4", TraditionalForm]], "InlineMath"],
 ", is twice the ",
 Cell[BoxData[
  ButtonBox["AlgebraicNumberTrace",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AlgebraicNumberTrace"]], "InlineFormula"],
 " of ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SqrtBox["2"], "+", "1"}], TraditionalForm]], "InlineMath"],
 "."
}], "MathCaption",
 CellID->4683],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"a", "=", 
   RowBox[{"AlgebraicNumber", "[", 
    RowBox[{
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"1", "-", 
         RowBox[{"10", " ", 
          SuperscriptBox["#", "2"]}], "+", 
         SuperscriptBox["#", "4"]}], "&"}], ",", "4"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", 
       RowBox[{"-", 
        FractionBox["9", "2"]}], ",", "0", ",", 
       FractionBox["1", "2"]}], "}"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{"AlgebraicNumberTrace", "[", "a", "]"}], "\n", 
 RowBox[{"AlgebraicNumberTrace", "[", 
  RowBox[{"a", ",", 
   RowBox[{"Extension", "\[Rule]", "Automatic"}]}], "]"}]}], "Input",
 CellLabel->"In[32]:=",
 CellID->13460],

Cell[BoxData["2"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[33]=",
 CellID->312885105],

Cell[BoxData["4"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[34]=",
 CellID->711846467]
}, Open  ]],

Cell[TextData[{
 "The norm of an algebraic number is the product of all roots of its \
characteristic polynomial. If ",
 Cell[BoxData[
  StyleBox["a", "TI"]], "InlineFormula"],
 " is ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["AlgebraicNumber",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/AlgebraicNumber"], "[", 
   RowBox[{
    StyleBox["\[Theta]", "TR"], ",", 
    StyleBox["coeffs", "TI"]}], "]"}]], "InlineFormula"],
 StyleBox[",", "MR"],
 " then ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["AlgebraicNumberNorm",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/AlgebraicNumberNorm"], "[", 
   RowBox[{
    StyleBox["a", "TI"], ",", 
    RowBox[{
     ButtonBox["Extension",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Extension"], "->", 
     ButtonBox["Automatic",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Automatic"]}]}], "]"}]], "InlineFormula"],
 " is equal to ",
 Cell[BoxData[
  SuperscriptBox[
   RowBox[{
    ButtonBox["AlgebraicNumberNorm",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/AlgebraicNumberNorm"], "[", 
    StyleBox["a", "TI"], "]"}], 
   StyleBox["d", "TI"]]], "InlineFormula"],
 ", where ",
 Cell[BoxData[
  StyleBox["d", "TI"]], "InlineFormula"],
 " is the extension degree of ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[DoubleStruckCapitalQ]", 
    RowBox[{
     RowBox[{"(", "\[Theta]", ")"}], "/", "\[DoubleStruckCapitalQ]"}], 
    RowBox[{"(", "a", ")"}]}], TraditionalForm]], "InlineMath"],
 "."
}], "Text",
 CellID->432721251],

Cell[TextData[{
 "The norm of ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SqrtBox["2"], "+", "5"}], TraditionalForm]], "InlineMath"],
 ", represented as an element of an extension of rationals of degree ",
 Cell[BoxData[
  FormBox["4", TraditionalForm]], "InlineMath"],
 ", is the square of ",
 Cell[BoxData[
  ButtonBox["AlgebraicNumberNorm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AlgebraicNumberNorm"]], "InlineFormula"],
 " of ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SqrtBox["2"], "+", "5"}], TraditionalForm]], "InlineMath"],
 "."
}], "MathCaption",
 CellID->9924],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"a", "=", 
   RowBox[{"AlgebraicNumber", "[", 
    RowBox[{
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"1", "-", 
         RowBox[{"10", " ", 
          SuperscriptBox["#", "2"]}], "+", 
         SuperscriptBox["#", "4"]}], "&"}], ",", "4"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"5", ",", 
       RowBox[{"-", 
        FractionBox["9", "2"]}], ",", "0", ",", 
       FractionBox["1", "2"]}], "}"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{"AlgebraicNumberNorm", "[", "a", "]"}], "\n", 
 RowBox[{"AlgebraicNumberNorm", "[", 
  RowBox[{"a", ",", 
   RowBox[{"Extension", "\[Rule]", "Automatic"}]}], "]"}]}], "Input",
 CellLabel->"In[35]:=",
 CellID->74939172],

Cell[BoxData["23"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[36]=",
 CellID->1276297952],

Cell[BoxData["529"], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[37]=",
 CellID->652452184]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["NumberFieldIntegralBasis",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/NumberFieldIntegralBasis"], "[", 
     StyleBox["a", "TI"], "]"}], Cell[TextData[{
     "give an integral basis for the field ",
     Cell[BoxData[
      RowBox[{
       StyleBox["\[DoubleStruckCapitalQ]", "TR"], "[", 
       StyleBox["a", "TI"], "]"}]], "InlineFormula"],
     " generated by the algebraic number ",
     Cell[BoxData[
      StyleBox["a", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["NumberFieldRootsOfUnity",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/NumberFieldRootsOfUnity"], "[", 
     StyleBox["a", "TI"], "]"}], Cell[TextData[{
     "give the roots of unity for the field ",
     Cell[BoxData[
      RowBox[{
       StyleBox["\[DoubleStruckCapitalQ]", "TR"], "[", 
       StyleBox["a", "TI"], "]"}]], "InlineFormula"],
     " generated by the algebraic number ",
     Cell[BoxData[
      StyleBox["a", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["NumberFieldFundamentalUnits",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/NumberFieldFundamentalUnits"], "[", 
     StyleBox["a", "TI"], "]"}], Cell[TextData[{
     "give a list of fundamental units for the field ",
     Cell[BoxData[
      RowBox[{
       StyleBox["\[DoubleStruckCapitalQ]", "TR"], "[", 
       StyleBox["a", "TI"], "]"}]], "InlineFormula"],
     " generated by the algebraic number ",
     Cell[BoxData[
      StyleBox["a", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["NumberFieldNormRepresentatives",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/NumberFieldNormRepresentatives"], "[", 
     RowBox[{
      StyleBox["a", "TI"], ",", 
      StyleBox["m", "TI"]}], "]"}], "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "give a list of representatives of classes of algebraic integers of norm \
",
     Cell[BoxData[
      RowBox[{"\[PlusMinus]", 
       StyleBox["m", "TI"]}]], "InlineFormula"],
     " in the field ",
     Cell[BoxData[
      RowBox[{
       StyleBox["\[DoubleStruckCapitalQ]", "TR"], "[", 
       StyleBox["a", "TI"], "]"}]], "InlineFormula"],
     " generated by the algebraic number ",
     Cell[BoxData[
      StyleBox["a", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["NumberFieldSignature",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/NumberFieldSignature"], "[", 
     StyleBox["a", "TI"], "]"}], Cell[TextData[{
     "give the signature of the field ",
     Cell[BoxData[
      RowBox[{
       StyleBox["\[DoubleStruckCapitalQ]", "TR"], "[", 
       StyleBox["a", "TI"], "]"}]], "InlineFormula"],
     " generated by the algebraic number ",
     Cell[BoxData[
      StyleBox["a", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["NumberFieldDiscriminant",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/NumberFieldDiscriminant"], "[", 
     StyleBox["a", "TI"], "]"}], Cell[TextData[{
     "give the discriminant of the field ",
     Cell[BoxData[
      RowBox[{
       StyleBox["\[DoubleStruckCapitalQ]", "TR"], "[", 
       StyleBox["a", "TI"], "]"}]], "InlineFormula"],
     " generated by the algebraic number ",
     Cell[BoxData[
      StyleBox["a", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["NumberFieldRegulator",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/NumberFieldRegulator"], "[", 
     StyleBox["a", "TI"], "]"}], Cell[TextData[{
     "give the regulator of the field ",
     Cell[BoxData[
      RowBox[{
       StyleBox["\[DoubleStruckCapitalQ]", "TR"], "[", 
       StyleBox["a", "TI"], "]"}]], "InlineFormula"],
     " generated by the algebraic number ",
     Cell[BoxData[
      StyleBox["a", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["NumberFieldClassNumber",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/NumberFieldClassNumber"], "[", 
     StyleBox["a", "TI"], "]"}], Cell[TextData[{
     "gives the class number of a number field ",
     Cell[BoxData[
      RowBox[{
       StyleBox["\[DoubleStruckCapitalQ]", "TR"], "[", 
       StyleBox["a", "TI"], "]"}]], "InlineFormula"],
     " generated by an algebraic number ",
     Cell[BoxData[
      StyleBox["a", "TI"]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 CellID->42335306],

Cell["\<\
Functions of computing properties of algebraic number fields. \
\>", "Caption",
 CellID->153247904],

Cell[TextData[{
 "An integral basis of an algebraic number field ",
 Cell[BoxData[
  FormBox["K", TraditionalForm]], "InlineMath"],
 " is a list of algebraic numbers forming a basis of the ",
 Cell[BoxData[
  FormBox["\[DoubleStruckCapitalZ]", TraditionalForm]], "InlineMath"],
 "\[Hyphen]module of the algebraic integers of ",
 Cell[BoxData[
  FormBox["K", TraditionalForm]], "InlineMath"],
 ". The set ",
 Cell[BoxData[
  FormBox[
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["a", "1"], ",", "\[Ellipsis]", ",", 
     SubscriptBox["a", "n"]}], "}"}], TraditionalForm]], "InlineMath"],
 " is an integral basis of an algebraic number field ",
 Cell[BoxData[
  FormBox["K", TraditionalForm]], "InlineMath"],
 " iff",
 " ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["a", "i"], 
    RowBox[{"\[Epsilon]", "K"}]}], TraditionalForm]], "InlineMath"],
 " are algebraic integers, and every algebraic integer ",
 Cell[BoxData[
  FormBox[
   RowBox[{"z", "\[Epsilon]", "K"}], TraditionalForm]], "InlineMath"],
 " can be uniquely represented as"
}], "Text",
 CellID->14817],

Cell[BoxData[
 FormBox[
  RowBox[{"z", "=", 
   RowBox[{
    RowBox[{
     SubscriptBox["k", "1"], " ", 
     SubscriptBox["a", "1"]}], "+", "\[Ellipsis]", "+", 
    RowBox[{
     SubscriptBox["k", "n"], 
     SubscriptBox["a", "n"]}]}]}], TraditionalForm]], "DisplayMath",
 UnderoverscriptBoxOptions->{LimitsPositioning->True},
 GridBoxOptions->{
 GridBoxItemSize->{
  "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}}},
 CellID->12218],

Cell[TextData[{
 "with integer coefficients ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["k", "i"], TraditionalForm]], "InlineMath"],
 "."
}], "Text",
 CellID->29813],

Cell[TextData[{
 "Here is an integral basis of ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[DoubleStruckCapitalQ]", "(", 
    SuperscriptBox["18", 
     RowBox[{"1", "/", "3"}]], ")"}], TraditionalForm]], "InlineMath"],
 "."
}], "MathCaption",
 CellID->25086],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NumberFieldIntegralBasis", "[", 
  SuperscriptBox["18", 
   RowBox[{"1", "/", "3"}]], "]"}]], "Input",
 CellLabel->"In[38]:=",
 CellID->5475],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", 
   RowBox[{"AlgebraicNumber", "[", 
    RowBox[{
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"-", "18"}], "+", 
         SuperscriptBox["#1", "3"]}], "&"}], ",", "1"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1", ",", "0"}], "}"}]}], "]"}], ",", 
   RowBox[{"AlgebraicNumber", "[", 
    RowBox[{
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"-", "18"}], "+", 
         SuperscriptBox["#1", "3"]}], "&"}], ",", "1"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", 
       FractionBox["1", "3"]}], "}"}]}], "]"}]}], "}"}]], "Output",
 ImageSize->{349, 52},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[38]=",
 CellID->2059563726]
}, Open  ]],

Cell[TextData[{
 "This gives an integral basis of the field generated by the first root of ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"533", "+", 
    RowBox[{"429", " ", "#1"}], "+", 
    RowBox[{"18", " ", 
     SuperscriptBox["#1", "2"]}], "+", 
    SuperscriptBox["#1", "3"]}], "&"}]], "InlineFormula"],
 "."
}], "MathCaption",
 CellID->109452394],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NumberFieldIntegralBasis", "[", 
  RowBox[{"Root", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"533", "+", 
      RowBox[{"429", " ", "#"}], "+", 
      RowBox[{"18", " ", 
       SuperscriptBox["#", "2"]}], "+", 
      SuperscriptBox["#", "3"]}], "&"}], ",", "1"}], "]"}], "]"}]], "Input",
 CellLabel->"In[39]:=",
 CellID->66003678],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", 
   RowBox[{"AlgebraicNumber", "[", 
    RowBox[{
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"533", "+", 
         RowBox[{"429", " ", "#1"}], "+", 
         RowBox[{"18", " ", 
          SuperscriptBox["#1", "2"]}], "+", 
         SuperscriptBox["#1", "3"]}], "&"}], ",", "1"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1", ",", "0"}], "}"}]}], "]"}], ",", 
   RowBox[{"AlgebraicNumber", "[", 
    RowBox[{
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"533", "+", 
         RowBox[{"429", " ", "#1"}], "+", 
         RowBox[{"18", " ", 
          SuperscriptBox["#1", "2"]}], "+", 
         SuperscriptBox["#1", "3"]}], "&"}], ",", "1"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["742", "759"], ",", 
       FractionBox["94", "759"], ",", 
       FractionBox["1", "759"]}], "}"}]}], "]"}]}], "}"}]], "Output",
 ImageSize->{484, 52},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[39]=",
 CellID->178861257]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["NumberFieldIntegralBasis",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NumberFieldIntegralBasis"]], "InlineFormula"],
 " allows specifying the number field by giving a polynomial and a root \
number."
}], "MathCaption",
 CellID->27358],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NumberFieldIntegralBasis", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"533", "+", 
     RowBox[{"429", " ", "#"}], "+", 
     RowBox[{"18", " ", 
      SuperscriptBox["#", "2"]}], "+", 
     SuperscriptBox["#", "3"]}], "&"}], ",", "1"}], "]"}]], "Input",
 CellLabel->"In[40]:=",
 CellID->21379],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", 
   RowBox[{"AlgebraicNumber", "[", 
    RowBox[{
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"533", "+", 
         RowBox[{"429", " ", "#1"}], "+", 
         RowBox[{"18", " ", 
          SuperscriptBox["#1", "2"]}], "+", 
         SuperscriptBox["#1", "3"]}], "&"}], ",", "1"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1", ",", "0"}], "}"}]}], "]"}], ",", 
   RowBox[{"AlgebraicNumber", "[", 
    RowBox[{
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"533", "+", 
         RowBox[{"429", " ", "#1"}], "+", 
         RowBox[{"18", " ", 
          SuperscriptBox["#1", "2"]}], "+", 
         SuperscriptBox["#1", "3"]}], "&"}], ",", "1"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["742", "759"], ",", 
       FractionBox["94", "759"], ",", 
       FractionBox["1", "759"]}], "}"}]}], "]"}]}], "}"}]], "Output",
 ImageSize->{484, 52},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[40]=",
 CellID->2067856664]
}, Open  ]],

Cell[TextData[{
 "This gives the roots of unity in the field generated by ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Root",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Root"], "[", 
   RowBox[{
    RowBox[{
     RowBox[{"9", "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["#", "2"]}], "+", 
      SuperscriptBox["#", "4"]}], "&"}], ",", "4"}], "]"}]]],
 "."
}], "MathCaption",
 CellID->4246],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NumberFieldRootsOfUnity", "[", 
  RowBox[{"Root", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"9", "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["#", "2"]}], "+", 
      SuperscriptBox["#", "4"]}], "&"}], ",", "4"}], "]"}], "]"}]], "Input",
 CellLabel->"In[41]:=",
 CellID->5187],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "1"}], ",", "1", ",", 
   RowBox[{"AlgebraicNumber", "[", 
    RowBox[{
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"9", "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["#1", "2"]}], "+", 
         SuperscriptBox["#1", "4"]}], "&"}], ",", "4"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", 
        FractionBox["1", "4"]}], ",", 
       RowBox[{"-", 
        FractionBox["5", "12"]}], ",", 
       FractionBox["1", "4"], ",", 
       FractionBox["1", "12"]}], "}"}]}], "]"}], ",", 
   RowBox[{"AlgebraicNumber", "[", 
    RowBox[{
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"9", "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["#1", "2"]}], "+", 
         SuperscriptBox["#1", "4"]}], "&"}], ",", "4"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", 
        FractionBox["1", "4"]}], ",", 
       FractionBox["5", "12"], ",", 
       FractionBox["1", "4"], ",", 
       RowBox[{"-", 
        FractionBox["1", "12"]}]}], "}"}]}], "]"}], ",", 
   RowBox[{"AlgebraicNumber", "[", 
    RowBox[{
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"9", "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["#1", "2"]}], "+", 
         SuperscriptBox["#1", "4"]}], "&"}], ",", "4"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", 
        FractionBox["1", "6"]}], ",", "0", ",", 
       RowBox[{"-", 
        FractionBox["1", "6"]}]}], "}"}]}], "]"}], ",", 
   RowBox[{"AlgebraicNumber", "[", 
    RowBox[{
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"9", "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["#1", "2"]}], "+", 
         SuperscriptBox["#1", "4"]}], "&"}], ",", "4"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       FractionBox["1", "6"], ",", "0", ",", 
       FractionBox["1", "6"]}], "}"}]}], "]"}], ",", 
   RowBox[{"AlgebraicNumber", "[", 
    RowBox[{
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"9", "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["#1", "2"]}], "+", 
         SuperscriptBox["#1", "4"]}], "&"}], ",", "4"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["1", "4"], ",", 
       RowBox[{"-", 
        FractionBox["5", "12"]}], ",", 
       RowBox[{"-", 
        FractionBox["1", "4"]}], ",", 
       FractionBox["1", "12"]}], "}"}]}], "]"}], ",", 
   RowBox[{"AlgebraicNumber", "[", 
    RowBox[{
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"9", "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["#1", "2"]}], "+", 
         SuperscriptBox["#1", "4"]}], "&"}], ",", "4"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["1", "4"], ",", 
       FractionBox["5", "12"], ",", 
       RowBox[{"-", 
        FractionBox["1", "4"]}], ",", 
       RowBox[{"-", 
        FractionBox["1", "12"]}]}], "}"}]}], "]"}]}], "}"}]], "Output",
 ImageSize->{466, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[41]=",
 CellID->43033713]
}, Open  ]],

Cell[TextData[{
 "Here are all roots of unity in the field ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[DoubleStruckCapitalQ]", "(", 
    RowBox[{"1", "+", " ", 
     RowBox[{"\[ImaginaryI]", 
      SqrtBox["3"]}]}], ")"}], TraditionalForm]], "InlineMath"],
 "."
}], "MathCaption",
 CellID->10282],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NumberFieldRootsOfUnity", "[", 
  RowBox[{"1", "+", 
   RowBox[{"\[ImaginaryI]", " ", 
    SqrtBox["3"]}]}], "]"}]], "Input",
 CellLabel->"In[42]:=",
 CellID->2071],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "1"}], ",", "1", ",", 
   RowBox[{"AlgebraicNumber", "[", 
    RowBox[{
     RowBox[{"1", "+", 
      RowBox[{"\[ImaginaryI]", " ", 
       SqrtBox["3"]}]}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", 
       FractionBox["1", "2"]}], "}"}]}], "]"}], ",", 
   RowBox[{"AlgebraicNumber", "[", 
    RowBox[{
     RowBox[{"1", "+", 
      RowBox[{"\[ImaginaryI]", " ", 
       SqrtBox["3"]}]}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", 
        FractionBox["1", "2"]}]}], "}"}]}], "]"}], ",", 
   RowBox[{"AlgebraicNumber", "[", 
    RowBox[{
     RowBox[{"1", "+", 
      RowBox[{"\[ImaginaryI]", " ", 
       SqrtBox["3"]}]}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       FractionBox["1", "2"]}], "}"}]}], "]"}], ",", 
   RowBox[{"AlgebraicNumber", "[", 
    RowBox[{
     RowBox[{"1", "+", 
      RowBox[{"\[ImaginaryI]", " ", 
       SqrtBox["3"]}]}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", 
       RowBox[{"-", 
        FractionBox["1", "2"]}]}], "}"}]}], "]"}]}], "}"}]], "Output",
 ImageSize->{545, 60},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[42]=",
 CellID->768417960]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["u", "1"], ",", "\[Ellipsis]", ",", " ", 
     SubscriptBox["u", "n"]}], "}"}], TraditionalForm]], "InlineMath"],
 " is a list of fundamental units of an algebraic number field ",
 Cell[BoxData[
  FormBox["K", TraditionalForm]], "InlineMath"],
 " iff ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["u", "i"], "\[Epsilon]", "K"}], TraditionalForm]], 
  "InlineMath"],
 " are algebraic units, and every algebraic unit ",
 Cell[BoxData[
  FormBox[
   RowBox[{"u", "\[Epsilon]", "K"}], TraditionalForm]], "InlineMath"],
 " can be uniquely represented as"
}], "Text",
 CellID->17501],

Cell[BoxData[
 FormBox[
  RowBox[{"u", "=", 
   RowBox[{"\[Xi]", " ", 
    SuperscriptBox[
     SubscriptBox["u", "1"], 
     SubscriptBox["n", "1"]], "\[CenterEllipsis]", " ", 
    SuperscriptBox[
     SubscriptBox["u", "t"], 
     SubscriptBox["n", "t"]]}]}], TraditionalForm]], "DisplayMath",
 UnderoverscriptBoxOptions->{LimitsPositioning->True},
 GridBoxOptions->{
 GridBoxItemSize->{
  "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}}},
 CellID->17235],

Cell[TextData[{
 "with a root of unity ",
 Cell[BoxData[
  FormBox["\[Xi]", TraditionalForm]], "InlineMath"],
 " and integer exponents ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["n", "i"], TraditionalForm]], "InlineMath"],
 "."
}], "Text",
 CellID->12625],

Cell[TextData[{
 "Here is a set of fundamental units of the field generated by the third root \
of ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["#1", "4"], "-", 
    RowBox[{"10", " ", 
     SuperscriptBox["#1", "2"]}], "+", "1"}], "&"}]], "InlineFormula"],
 "."
}], "MathCaption",
 CellID->23273],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NumberFieldFundamentalUnits", "[", 
  RowBox[{"Root", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      SuperscriptBox["#", "4"], "-", 
      RowBox[{"10", " ", 
       SuperscriptBox["#", "2"]}], "+", "1"}], "&"}], ",", "3"}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[43]:=",
 CellID->9947],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"AlgebraicNumber", "[", 
    RowBox[{
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"1", "-", 
         RowBox[{"10", " ", 
          SuperscriptBox["#1", "2"]}], "+", 
         SuperscriptBox["#1", "4"]}], "&"}], ",", "3"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{
       FractionBox["5", "4"], ",", 
       FractionBox["9", "4"], ",", 
       RowBox[{"-", 
        FractionBox["1", "4"]}], ",", 
       RowBox[{"-", 
        FractionBox["1", "4"]}]}], "}"}]}], "]"}], ",", 
   RowBox[{"AlgebraicNumber", "[", 
    RowBox[{
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"1", "-", 
         RowBox[{"10", " ", 
          SuperscriptBox["#1", "2"]}], "+", 
         SuperscriptBox["#1", "4"]}], "&"}], ",", "3"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", 
       FractionBox["9", "2"], ",", "0", ",", 
       RowBox[{"-", 
        FractionBox["1", "2"]}]}], "}"}]}], "]"}], ",", 
   RowBox[{"AlgebraicNumber", "[", 
    RowBox[{
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"1", "-", 
         RowBox[{"10", " ", 
          SuperscriptBox["#1", "2"]}], "+", 
         SuperscriptBox["#1", "4"]}], "&"}], ",", "3"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1", ",", "0", ",", "0"}], "}"}]}], "]"}]}], 
  "}"}]], "Output",
 ImageSize->{415, 82},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[43]=",
 CellID->382461476]
}, Open  ]],

Cell[TextData[{
 "This gives a fundamental unit of the quadratic field ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[DoubleStruckCapitalQ]", "(", 
    SqrtBox["21"], ")"}], TraditionalForm]], "InlineMath"],
 "."
}], "MathCaption",
 CellID->17388],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NumberFieldFundamentalUnits", "[", 
  SqrtBox["21"], "]"}]], "Input",
 CellLabel->"In[44]:=",
 CellID->20917],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"AlgebraicNumber", "[", 
   RowBox[{
    SqrtBox["21"], ",", 
    RowBox[{"{", 
     RowBox[{
      FractionBox["5", "2"], ",", 
      FractionBox["1", "2"]}], "}"}]}], "]"}], "}"}]], "Output",
 ImageSize->{227, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[44]=",
 CellID->1368964457]
}, Open  ]],

Cell[TextData[{
 "This gives a set of representatives of classes of elements of norm 9 in the \
field generated by the first root of ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["#1", "2"], "-", "7"}], "&"}]], "InlineFormula"],
 "."
}], "MathCaption",
 CellID->29338],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NumberFieldNormRepresentatives", "[", 
  RowBox[{
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       SuperscriptBox["#", "2"], "-", "7"}], "&"}], ",", "1"}], "]"}], ",", 
   "9"}], "]"}]], "Input",
 CellLabel->"In[45]:=",
 CellID->32184],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"3", ",", 
   RowBox[{"AlgebraicNumber", "[", 
    RowBox[{
     RowBox[{"-", 
      SqrtBox["7"]}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "4"}], ",", 
       RowBox[{"-", "1"}]}], "}"}]}], "]"}], ",", 
   RowBox[{"AlgebraicNumber", "[", 
    RowBox[{
     RowBox[{"-", 
      SqrtBox["7"]}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "4"}], ",", "1"}], "}"}]}], "]"}]}], "}"}]], "Output",
 ImageSize->{473, 22},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[45]=",
 CellID->666639300]
}, Open  ]],

Cell[TextData[{
 "Here is a set of representatives of classes of elements of norm ",
 Cell[BoxData[
  FormBox["2", TraditionalForm]], "InlineMath"],
 " in the field",
 " ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[DoubleStruckCapitalQ]", "(", 
    RowBox[{
     SqrtBox["2"], "+", " ", 
     SqrtBox["3"]}], ")"}], TraditionalForm]], "InlineMath"],
 "."
}], "MathCaption",
 CellID->24639],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NumberFieldNormRepresentatives", "[", 
  RowBox[{
   RowBox[{
    SqrtBox["2"], "+", 
    SqrtBox["3"]}], ",", "2"}], "]"}]], "Input",
 CellLabel->"In[46]:=",
 CellID->31094],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"AlgebraicNumber", "[", 
   RowBox[{
    RowBox[{"Root", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"1", "-", 
        RowBox[{"10", " ", 
         SuperscriptBox["#1", "2"]}], "+", 
        SuperscriptBox["#1", "4"]}], "&"}], ",", "4"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", 
       FractionBox["9", "4"]}], ",", 
      FractionBox["9", "4"], ",", 
      FractionBox["1", "4"], ",", 
      RowBox[{"-", 
       FractionBox["1", "4"]}]}], "}"}]}], "]"}], "}"}]], "Output",
 ImageSize->{415, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[46]=",
 CellID->532994986]
}, Open  ]],

Cell[TextData[{
 "This shows that the polynomial ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["#", "5"], "+", 
    SuperscriptBox["#", "4"], "+", 
    SuperscriptBox["#", "3"], "+", 
    SuperscriptBox["#", "2"], "+", "1"}], "&"}]], "InlineFormula"],
 " has 1 real root and 2 conjugate pairs of complex roots."
}], "MathCaption",
 CellID->27531],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NumberFieldSignature", "[", 
  RowBox[{"Root", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      SuperscriptBox["#", "5"], "+", 
      SuperscriptBox["#", "4"], "+", 
      SuperscriptBox["#", "3"], "+", 
      SuperscriptBox["#", "2"], "+", "1"}], "&"}], ",", "1"}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[47]:=",
 CellID->253],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "2"}], "}"}]], "Output",
 ImageSize->{44, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[47]=",
 CellID->2061231088]
}, Open  ]],

Cell[TextData[{
 "This shows that the field ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[DoubleStruckCapitalQ]", "[", "a", "]"}], TraditionalForm]], 
  "InlineMath"],
 " has 12 real embeddings and 6 conjugate pairs of complex embeddings."
}], "MathCaption",
 CellID->32237],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"a", "=", 
   RowBox[{
    SqrtBox["2"], "+", 
    RowBox[{"Root", "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        SuperscriptBox["#", "3"], "-", 
        RowBox[{"11", " ", "#"}], "-", "2"}], "&"}], ",", "1"}], "]"}], "+", 
    RowBox[{"AlgebraicNumber", "[", 
     RowBox[{
      RowBox[{"Root", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          SuperscriptBox["#", "4"], "-", 
          RowBox[{"3", " ", "#"}], "+", "1"}], "&"}], ",", "2"}], "]"}], ",", 
      
      RowBox[{"{", 
       RowBox[{"1", ",", "2", ",", "3"}], "}"}]}], "]"}]}]}], ";"}], "\n", 
 RowBox[{"NumberFieldSignature", "[", "a", "]"}]}], "Input",
 CellLabel->"In[48]:=",
 CellID->15390],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"12", ",", "6"}], "}"}]], "Output",
 ImageSize->{51, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[49]=",
 CellID->1745306320]
}, Open  ]],

Cell[TextData[{
 "The discriminant of a number field ",
 Cell[BoxData[
  FormBox["K", TraditionalForm]], "InlineMath"],
 " is the discriminant of an integral basis ",
 Cell[BoxData[
  FormBox[
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["a", "1"], ",", "\[Ellipsis]", ",", " ", 
     SubscriptBox["a", "n"]}], "}"}], TraditionalForm]], "InlineMath"],
 " of ",
 Cell[BoxData[
  FormBox["K", TraditionalForm]], "InlineMath"],
 " (i.e., the determinant of the matrix with elements ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["AlgebraicNumberTrace",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/AlgebraicNumberTrace"], "[", 
   RowBox[{
    RowBox[{
     SubscriptBox[
      StyleBox["a", "TI"], 
      StyleBox["i", "TI"]], " ", 
     SubscriptBox[
      StyleBox["a", "TI"], 
      StyleBox["j", "TI"]]}], ",", 
    RowBox[{
     ButtonBox["Extension",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Extension"], "->", 
     ButtonBox["Automatic",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Automatic"]}]}], "]"}]], "InlineFormula"],
 "). The value of the determinant does not depend on the choice of integral \
basis."
}], "Text",
 CellID->12027],

Cell[TextData[{
 "Here is the discriminant of ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[DoubleStruckCapitalQ]", "(", 
    RowBox[{"2", "-", 
     SqrtBox["3"], "+", 
     SuperscriptBox["5", 
      RowBox[{"1", "/", "4"}]]}], ")"}], TraditionalForm]], "InlineMath"],
 "."
}], "MathCaption",
 CellID->24497],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NumberFieldDiscriminant", "[", 
  RowBox[{"2", "-", 
   SqrtBox["3"], "+", 
   SuperscriptBox["5", 
    RowBox[{"1", "/", "4"}]]}], "]"}]], "Input",
 CellLabel->"In[50]:=",
 CellID->19460],

Cell[BoxData["5184000000"], "Output",
 ImageSize->{81, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[50]=",
 CellID->1949288642]
}, Open  ]],

Cell[TextData[{
 "This gives the discriminant of the field generated by a root of the \
polynomial ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["#", "5"], "+", 
    SuperscriptBox["#", "4"], "+", 
    SuperscriptBox["#", "3"], "+", 
    SuperscriptBox["#", "2"], "+", "1"}], "&"}]], "InlineFormula"],
 ". The value of the discriminant does not depend on the choice of the root; \
hence, ",
 Cell[BoxData[
  ButtonBox["NumberFieldDiscriminant",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NumberFieldDiscriminant"]], "InlineFormula"],
 " allows specifying just the polynomial."
}], "MathCaption",
 CellID->27491],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NumberFieldDiscriminant", "[", 
  RowBox[{
   RowBox[{
    SuperscriptBox["#", "5"], "+", 
    SuperscriptBox["#", "4"], "+", 
    SuperscriptBox["#", "3"], "+", 
    SuperscriptBox["#", "2"], "+", "1"}], "&"}], "]"}]], "Input",
 CellLabel->"In[51]:=",
 CellID->16099],

Cell[BoxData["2297"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[51]=",
 CellID->1882601203]
}, Open  ]],

Cell[TextData[{
 "The regulator of a number field ",
 Cell[BoxData[
  FormBox["K", TraditionalForm]], "InlineMath"],
 " is the lattice volume of the image of the group of units of ",
 Cell[BoxData[
  FormBox["K", TraditionalForm]], "InlineMath"],
 " under the logarithmic embedding"
}], "Text",
 CellID->27940],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    RowBox[{"K", "\\", " ", 
     RowBox[{"{", "0", "}"}]}], "\[ReverseElement]", 
    RowBox[{"x", "\[LongRightArrow]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        StyleBox["Log",
         FontFamily->"Courier"], "[", 
        RowBox[{
         StyleBox["Abs",
          FontFamily->"Courier"], "[", 
         RowBox[{
          SubscriptBox["\[Sigma]", "1"], "(", "x", ")"}], "]"}], "]"}], ",", 
       "\[Ellipsis]", ",", 
       RowBox[{
        StyleBox["Log",
         FontFamily->"Courier"], "[", 
        RowBox[{
         StyleBox["Abs",
          FontFamily->"Courier"], "[", 
         RowBox[{
          SubscriptBox["\[Sigma]", "s"], "(", "x", ")"}], "]"}], "]"}], ",", 
       RowBox[{"2", 
        RowBox[{
         StyleBox["Log",
          FontFamily->"Courier"], "[", 
         RowBox[{
          StyleBox["Abs",
           FontFamily->"Courier"], "[", 
          RowBox[{
           SubscriptBox["\[Sigma]", 
            RowBox[{"s", "+", "1"}]], "(", "x", ")"}], "]"}], "]"}]}], ",", 
       "\[Ellipsis]", ",", 
       RowBox[{"2", 
        RowBox[{
         StyleBox["Log",
          FontFamily->"Courier"], "[", 
         RowBox[{
          StyleBox["Abs",
           FontFamily->"Courier"], "[", 
          RowBox[{
           SubscriptBox["\[Sigma]", 
            RowBox[{"s", "+", "t"}]], "(", "x", ")"}], "]"}], "]"}]}]}], 
      "}"}]}], "\[Element]", 
    SuperscriptBox["\[DoubleStruckCapitalR]", 
     RowBox[{"s", "+", "t"}]]}], ","}], TraditionalForm]], "DisplayMath",
 UnderoverscriptBoxOptions->{LimitsPositioning->True},
 GridBoxOptions->{
 GridBoxItemSize->{
  "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}}},
 CellID->8890],

Cell[TextData[{
 "where ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["\[Sigma]", "1"], ",", "\[Ellipsis]", ",", 
    SubscriptBox["\[Sigma]", "s"]}], TraditionalForm]], "InlineMath"],
 " are the real embeddings of ",
 Cell[BoxData[
  FormBox["K", TraditionalForm]], "InlineMath"],
 " in ",
 Cell[BoxData[
  FormBox["\[DoubleStruckCapitalC]", TraditionalForm]], "InlineMath"],
 ", and ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["\[Sigma]", 
     RowBox[{"s", "+", "1"}]], ",", "\[Ellipsis]", ",", 
    SubscriptBox["\[Sigma]", 
     RowBox[{"s", "+", "t"}]]}], TraditionalForm]], "InlineMath"],
 " are one of each conjugate pair of the complex embeddings of ",
 Cell[BoxData[
  FormBox["K", TraditionalForm]], "InlineMath"],
 " in ",
 Cell[BoxData[
  FormBox["\[DoubleStruckCapitalC]", TraditionalForm]], "InlineMath"],
 "."
}], "Text",
 CellID->8106],

Cell[TextData[{
 "Here is the regulator of ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[DoubleStruckCapitalQ]", "(", 
    SqrtBox["61"], ")"}], TraditionalForm]], "InlineMath"],
 "."
}], "MathCaption",
 CellID->7413],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NumberFieldRegulator", "[", 
  SqrtBox["61"], "]"}]], "Input",
 CellLabel->"In[52]:=",
 CellID->8498],

Cell[BoxData[
 RowBox[{"Log", "[", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   RowBox[{"(", 
    RowBox[{"39", "+", 
     RowBox[{"5", " ", 
      SqrtBox["61"]}]}], ")"}]}], "]"}]], "Output",
 ImageSize->{135, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[52]=",
 CellID->1551442486]
}, Open  ]],

Cell[TextData[{
 "This gives the regulator of the field generated by a root of the polynomial \
",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["#1", "3"], "-", 
    RowBox[{"3", " ", 
     SuperscriptBox["#1", "2"]}], "+", "1"}], "&"}]], "InlineFormula"],
 ". The value of the regulator does not depend on the choice of the root; \
hence, ",
 Cell[BoxData[
  ButtonBox["NumberFieldRegulator",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NumberFieldRegulator"]], "InlineFormula"],
 " allows specifying just the polynomial."
}], "MathCaption",
 CellID->2790],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NumberFieldRegulator", "[", 
  RowBox[{
   RowBox[{
    SuperscriptBox["#", "3"], "-", 
    RowBox[{"3", " ", 
     SuperscriptBox["#", "2"]}], "+", "1"}], "&"}], "]"}]], "Input",
 CellLabel->"In[53]:=",
 CellID->23562],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", 
    RowBox[{"Log", "[", 
     RowBox[{"AlgebraicNumber", "[", 
      RowBox[{
       RowBox[{"Root", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"1", "-", 
           RowBox[{"3", " ", 
            SuperscriptBox["#1", "2"]}], "+", 
           SuperscriptBox["#1", "3"]}], "&"}], ",", "1"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "1"}], ",", 
         RowBox[{"-", "2"}], ",", "1"}], "}"}]}], "]"}], "]"}]}], " ", 
   RowBox[{"Log", "[", 
    RowBox[{"AlgebraicNumber", "[", 
     RowBox[{
      RowBox[{"Root", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"1", "-", 
          RowBox[{"3", " ", 
           SuperscriptBox["#1", "2"]}], "+", 
          SuperscriptBox["#1", "3"]}], "&"}], ",", "2"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "3", ",", 
        RowBox[{"-", "1"}]}], "}"}]}], "]"}], "]"}]}], "+", 
  RowBox[{
   RowBox[{"Log", "[", 
    RowBox[{"AlgebraicNumber", "[", 
     RowBox[{
      RowBox[{"Root", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"1", "-", 
          RowBox[{"3", " ", 
           SuperscriptBox["#1", "2"]}], "+", 
          SuperscriptBox["#1", "3"]}], "&"}], ",", "1"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", 
        RowBox[{"-", "3"}], ",", "1"}], "}"}]}], "]"}], "]"}], " ", 
   RowBox[{"Log", "[", 
    RowBox[{"AlgebraicNumber", "[", 
     RowBox[{
      RowBox[{"Root", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"1", "-", 
          RowBox[{"3", " ", 
           SuperscriptBox["#1", "2"]}], "+", 
          SuperscriptBox["#1", "3"]}], "&"}], ",", "2"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "2", ",", 
        RowBox[{"-", "1"}]}], "}"}]}], "]"}], "]"}]}]}]], "Output",
 ImageSize->{410, 75},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[53]=",
 CellID->417310166]
}, Open  ]],

Cell[TextData[{
 "This gives the class number of ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[DoubleStruckCapitalQ]", 
    RowBox[{
     RowBox[{"(", 
      SqrtBox[
       RowBox[{"-", "71"}]], ")"}], "."}]}], TraditionalForm]], "InlineMath"]
}], "MathCaption",
 CellID->6700],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NumberFieldClassNumber", "[", 
  RowBox[{"Sqrt", "[", 
   RowBox[{"-", "71"}], "]"}], "]"}]], "Input",
 CellLabel->"In[27]:=",
 CellID->21610],

Cell[BoxData["7"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[27]=",
 CellID->432151382]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Algebraic Number Fields - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 32, 32.9039226}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Tutorial", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "Mathematica provides representation of algebraic numbers as Root \
objects. A Root object contains the minimal polynomial of the algebraic \
number and the root number--an integer indicating which of the roots of the \
minimal polynomial the Root object represents. This allows for unique \
representation of arbitrary complex algebraic numbers. A disadvantage is that \
performing arithmetic operations in this representation is quite costly. That \
is why Mathematica requires the use of an additional function, RootReduce, in \
order to simplify arithmetic expressions. Restricting computations to be \
within a fixed finite algebraic extension of the rationals, \
\\[DoubleStruckCapitalQ][\\[Theta]], allows a more convenient representation \
of its elements as polynomials in \\[Theta]. Representation of algebraic \
numbers as elements of a finite extension of rationals. If \\[Theta] is an \
algebraic integer with a MinimalPolynomial of degree l, and {c_0,...,c_l} are \
rational numbers, then AlgebraicNumber[\\[Theta],{c_0,...,c_l}] is an inert \
numeric object. ", "synonyms" -> {}, "title" -> "Algebraic Number Fields", 
    "type" -> "Tutorial", "uri" -> "tutorial/AlgebraicNumberFields"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "AlgebraicIntegerDef"->{
  Cell[54743, 1836, 285, 9, 70, "Text",
   CellTags->"AlgebraicIntegerDef",
   CellID->22043]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"AlgebraicIntegerDef", 116147, 4074}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 3330, 62, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3955, 89, 56, 1, 70, "Title",
 CellID->16218],
Cell[4014, 92, 1531, 42, 70, "Text",
 CellID->20604],
Cell[5548, 136, 1173, 38, 70, "DefinitionBox",
 CellID->152850453],
Cell[6724, 176, 130, 4, 70, "Caption",
 CellID->2693506],
Cell[6857, 182, 1161, 41, 70, "MathCaption",
 CellID->26843],
Cell[CellGroupData[{
Cell[8043, 227, 369, 13, 30, "Input",
 CellID->8807],
Cell[8415, 242, 429, 14, 39, "Output",
 CellID->1792923224]
}, Open  ]],
Cell[8859, 259, 355, 12, 70, "MathCaption",
 CellID->7326],
Cell[CellGroupData[{
Cell[9239, 275, 117, 4, 28, "Input",
 CellID->14017],
Cell[9359, 281, 201, 5, 36, "Output",
 CellID->542195198]
}, Open  ]],
Cell[9575, 289, 2343, 84, 70, "Text",
 CellID->7340356],
Cell[11921, 375, 737, 24, 70, "DisplayMath",
 CellID->19869],
Cell[12661, 401, 334, 8, 70, "MathCaption",
 CellID->22536],
Cell[CellGroupData[{
Cell[13020, 413, 423, 14, 70, "Input",
 CellID->15458],
Cell[13446, 429, 537, 18, 51, "Output",
 CellID->188852885]
}, Open  ]],
Cell[13998, 450, 258, 7, 70, "MathCaption",
 CellID->16828],
Cell[CellGroupData[{
Cell[14281, 461, 412, 13, 70, "Input",
 CellID->13914],
Cell[14696, 476, 159, 5, 36, "Output",
 CellID->1624782509]
}, Open  ]],
Cell[14870, 484, 834, 24, 70, "MathCaption",
 CellID->25899],
Cell[CellGroupData[{
Cell[15729, 512, 1175, 42, 70, "Input",
 CellID->22427],
Cell[16907, 556, 1022, 25, 163, "Output",
 CellID->1517609016]
}, Open  ]],
Cell[17944, 584, 463, 17, 70, "MathCaption",
 CellID->3921],
Cell[CellGroupData[{
Cell[18432, 605, 101, 3, 70, "Input",
 CellID->5340],
Cell[18536, 610, 485, 16, 39, "Output",
 CellID->62555239]
}, Open  ]],
Cell[19036, 629, 1918, 63, 70, "DefinitionBox",
 CellID->877785135],
Cell[20957, 694, 129, 4, 70, "Caption",
 CellID->772929199],
Cell[21089, 700, 284, 8, 70, "MathCaption",
 CellID->31493],
Cell[CellGroupData[{
Cell[21398, 712, 180, 7, 70, "Input",
 CellID->32146],
Cell[21581, 721, 1077, 35, 81, "Output",
 CellID->327091342]
}, Open  ]],
Cell[22673, 759, 510, 20, 70, "MathCaption",
 CellID->15828],
Cell[CellGroupData[{
Cell[23208, 783, 347, 13, 70, "Input",
 CellID->27094],
Cell[23558, 798, 569, 19, 51, "Output",
 CellID->1561272400]
}, Open  ]],
Cell[24142, 820, 180, 4, 70, "Text",
 CellID->10802],
Cell[24325, 826, 479, 18, 70, "MathCaption",
 CellID->22943],
Cell[24807, 846, 1485, 50, 70, "Input",
 CellID->9496],
Cell[26295, 898, 456, 17, 70, "MathCaption",
 CellID->29027],
Cell[CellGroupData[{
Cell[26776, 919, 340, 11, 70, "Input",
 CellID->3217],
Cell[27119, 932, 1376, 35, 143, "Output",
 CellID->1127742447]
}, Open  ]],
Cell[28510, 970, 279, 10, 70, "MathCaption",
 CellID->5403],
Cell[CellGroupData[{
Cell[28814, 984, 314, 11, 70, "Input",
 CellID->31672],
Cell[29131, 997, 5565, 147, 346, "Output",
 CellID->783265774]
}, Open  ]],
Cell[34711, 1147, 98, 2, 70, "MathCaption",
 CellID->22685],
Cell[CellGroupData[{
Cell[34834, 1153, 1415, 44, 70, "Input",
 CellID->9711],
Cell[36252, 1199, 2428, 66, 264, "Output",
 CellID->1158559922]
}, Open  ]],
Cell[38695, 1268, 369, 13, 70, "MathCaption",
 CellID->7254],
Cell[CellGroupData[{
Cell[39089, 1285, 132, 4, 70, "Input",
 CellID->21354],
Cell[39224, 1291, 1386, 35, 143, "Output",
 CellID->647584243]
}, Open  ]],
Cell[40625, 1329, 1607, 55, 70, "Text",
 CellID->230163894],
Cell[42235, 1386, 1472, 54, 70, "MathCaption",
 CellID->15866],
Cell[CellGroupData[{
Cell[43732, 1444, 614, 20, 70, "Input",
 CellID->5209],
Cell[44349, 1466, 1628, 49, 103, "Output",
 CellID->1531442682]
}, Open  ]],
Cell[45992, 1518, 373, 13, 70, "MathCaption",
 CellID->6398],
Cell[CellGroupData[{
Cell[46390, 1535, 661, 21, 70, "Input",
 CellID->253331846],
Cell[47054, 1558, 1079, 35, 81, "Output",
 CellID->415220632]
}, Open  ]],
Cell[48148, 1596, 3906, 125, 70, "DefinitionBox",
 CellID->957716660],
Cell[52057, 1723, 90, 1, 70, "Caption",
 CellID->20781152],
Cell[52150, 1726, 474, 17, 70, "Text",
 CellID->7693],
Cell[52627, 1745, 241, 9, 70, "MathCaption",
 CellID->3253],
Cell[CellGroupData[{
Cell[52893, 1758, 158, 6, 70, "Input",
 CellID->1924],
Cell[53054, 1766, 288, 10, 36, "Output",
 CellID->415715460]
}, Open  ]],
Cell[53357, 1779, 538, 20, 70, "MathCaption",
 CellID->25248],
Cell[CellGroupData[{
Cell[53920, 1803, 372, 13, 70, "Input",
 CellID->16111],
Cell[54295, 1818, 433, 15, 36, "Output",
 CellID->1882796525]
}, Open  ]],
Cell[54743, 1836, 285, 9, 70, "Text",
 CellTags->"AlgebraicIntegerDef",
 CellID->22043],
Cell[55031, 1847, 273, 11, 70, "MathCaption",
 CellID->27103],
Cell[CellGroupData[{
Cell[55329, 1862, 218, 8, 70, "Input",
 CellID->1623],
Cell[55550, 1872, 162, 5, 36, "Output",
 CellID->276044526]
}, Open  ]],
Cell[55727, 1880, 277, 11, 70, "MathCaption",
 CellID->29723],
Cell[CellGroupData[{
Cell[56029, 1895, 218, 8, 70, "Input",
 CellID->4285],
Cell[56250, 1905, 164, 5, 36, "Output",
 CellID->2033370407]
}, Open  ]],
Cell[56429, 1913, 388, 14, 70, "MathCaption",
 CellID->19712],
Cell[CellGroupData[{
Cell[56842, 1931, 228, 8, 70, "Input",
 CellID->27117],
Cell[57073, 1941, 160, 5, 36, "Output",
 CellID->1528236102]
}, Open  ]],
Cell[57248, 1949, 346, 13, 70, "Text",
 CellID->15469],
Cell[57597, 1964, 244, 10, 70, "MathCaption",
 CellID->15807],
Cell[CellGroupData[{
Cell[57866, 1978, 205, 7, 70, "Input",
 CellID->15966],
Cell[58074, 1987, 159, 5, 36, "Output",
 CellID->818239724]
}, Open  ]],
Cell[58248, 1995, 374, 13, 70, "Text",
 CellID->10584],
Cell[58625, 2010, 199, 9, 70, "MathCaption",
 CellID->11381],
Cell[CellGroupData[{
Cell[58849, 2023, 160, 6, 70, "Input",
 CellID->2065],
Cell[59012, 2031, 158, 5, 36, "Output",
 CellID->74739644]
}, Open  ]],
Cell[59185, 2039, 741, 27, 70, "Text",
 CellID->630],
Cell[59929, 2068, 222, 8, 70, "MathCaption",
 CellID->10560],
Cell[CellGroupData[{
Cell[60176, 2080, 116, 3, 70, "Input",
 CellID->9087],
Cell[60295, 2085, 162, 5, 36, "Output",
 CellID->188365092]
}, Open  ]],
Cell[60472, 2093, 605, 21, 70, "MathCaption",
 CellID->11945],
Cell[CellGroupData[{
Cell[61102, 2118, 413, 13, 70, "Input",
 CellID->25993],
Cell[61518, 2133, 163, 5, 36, "Output",
 CellID->137294883]
}, Open  ]],
Cell[61696, 2141, 327, 15, 70, "Text",
 CellID->26842],
Cell[62026, 2158, 403, 17, 70, "MathCaption",
 CellID->11465],
Cell[CellGroupData[{
Cell[62454, 2179, 358, 14, 70, "Input",
 CellID->12249],
Cell[62815, 2195, 163, 5, 36, "Output",
 CellID->1332626305]
}, Open  ]],
Cell[62993, 2203, 4746, 145, 70, "DefinitionBox",
 CellID->878101067],
Cell[67742, 2350, 122, 3, 70, "Caption",
 CellID->413290897],
Cell[67867, 2355, 1438, 52, 70, "Text",
 CellID->25070],
Cell[69308, 2409, 552, 19, 70, "MathCaption",
 CellID->1496],
Cell[CellGroupData[{
Cell[69885, 2432, 790, 25, 70, "Input",
 CellID->64447948],
Cell[70678, 2459, 224, 8, 36, "Output",
 CellID->1749637492],
Cell[70905, 2469, 276, 10, 41, "Output",
 CellID->1420150567]
}, Open  ]],
Cell[71196, 2482, 1497, 51, 70, "Text",
 CellID->29967],
Cell[72696, 2535, 584, 21, 70, "MathCaption",
 CellID->4683],
Cell[CellGroupData[{
Cell[73305, 2560, 726, 22, 70, "Input",
 CellID->13460],
Cell[74034, 2584, 159, 5, 36, "Output",
 CellID->312885105],
Cell[74196, 2591, 159, 5, 36, "Output",
 CellID->711846467]
}, Open  ]],
Cell[74370, 2599, 1501, 51, 70, "Text",
 CellID->432721251],
Cell[75874, 2652, 585, 21, 70, "MathCaption",
 CellID->9924],
Cell[CellGroupData[{
Cell[76484, 2677, 727, 22, 70, "Input",
 CellID->74939172],
Cell[77214, 2701, 161, 5, 36, "Output",
 CellID->1276297952],
Cell[77378, 2708, 161, 5, 36, "Output",
 CellID->652452184]
}, Open  ]],
Cell[77554, 2716, 4457, 130, 70, "DefinitionBox",
 CellID->42335306],
Cell[82014, 2848, 109, 3, 70, "Caption",
 CellID->153247904],
Cell[82126, 2853, 1078, 33, 70, "Text",
 CellID->14817],
Cell[83207, 2888, 482, 15, 70, "DisplayMath",
 CellID->12218],
Cell[83692, 2905, 166, 7, 70, "Text",
 CellID->29813],
Cell[83861, 2914, 257, 9, 70, "MathCaption",
 CellID->25086],
Cell[CellGroupData[{
Cell[84143, 2927, 165, 5, 70, "Input",
 CellID->5475],
Cell[84311, 2934, 846, 28, 73, "Output",
 CellID->2059563726]
}, Open  ]],
Cell[85172, 2965, 348, 11, 70, "MathCaption",
 CellID->109452394],
Cell[CellGroupData[{
Cell[85545, 2980, 357, 11, 70, "Input",
 CellID->66003678],
Cell[85905, 2993, 1092, 34, 73, "Output",
 CellID->178861257]
}, Open  ]],
Cell[87012, 3030, 284, 8, 70, "MathCaption",
 CellID->27358],
Cell[CellGroupData[{
Cell[87321, 3042, 316, 10, 70, "Input",
 CellID->21379],
Cell[87640, 3054, 1093, 34, 73, "Output",
 CellID->2067856664]
}, Open  ]],
Cell[88748, 3091, 404, 15, 70, "MathCaption",
 CellID->4246],
Cell[CellGroupData[{
Cell[89177, 3110, 310, 10, 70, "Input",
 CellID->5187],
Cell[89490, 3122, 3206, 104, 201, "Output",
 CellID->43033713]
}, Open  ]],
Cell[92711, 3229, 295, 10, 70, "MathCaption",
 CellID->10282],
Cell[CellGroupData[{
Cell[93031, 3243, 188, 6, 70, "Input",
 CellID->2071],
Cell[93222, 3251, 1251, 43, 81, "Output",
 CellID->768417960]
}, Open  ]],
Cell[94488, 3297, 679, 22, 70, "Text",
 CellID->17501],
Cell[95170, 3321, 504, 15, 70, "DisplayMath",
 CellID->17235],
Cell[95677, 3338, 257, 10, 70, "Text",
 CellID->12625],
Cell[95937, 3350, 312, 11, 70, "MathCaption",
 CellID->23273],
Cell[CellGroupData[{
Cell[96274, 3365, 318, 11, 70, "Input",
 CellID->9947],
Cell[96595, 3378, 1549, 51, 103, "Output",
 CellID->382461476]
}, Open  ]],
Cell[98159, 3432, 243, 8, 70, "MathCaption",
 CellID->17388],
Cell[CellGroupData[{
Cell[98427, 3444, 133, 4, 70, "Input",
 CellID->20917],
Cell[98563, 3450, 365, 13, 51, "Output",
 CellID->1368964457]
}, Open  ]],
Cell[98943, 3466, 282, 9, 70, "MathCaption",
 CellID->29338],
Cell[CellGroupData[{
Cell[99250, 3479, 284, 10, 70, "Input",
 CellID->32184],
Cell[99537, 3491, 600, 22, 43, "Output",
 CellID->666639300]
}, Open  ]],
Cell[100152, 3516, 387, 14, 70, "MathCaption",
 CellID->24639],
Cell[CellGroupData[{
Cell[100564, 3534, 198, 7, 70, "Input",
 CellID->31094],
Cell[100765, 3543, 677, 23, 51, "Output",
 CellID->532994986]
}, Open  ]],
Cell[101457, 3569, 360, 11, 70, "MathCaption",
 CellID->27531],
Cell[CellGroupData[{
Cell[101842, 3584, 357, 12, 70, "Input",
 CellID->253],
Cell[102202, 3598, 205, 7, 36, "Output",
 CellID->2061231088]
}, Open  ]],
Cell[102422, 3608, 271, 8, 70, "MathCaption",
 CellID->32237],
Cell[CellGroupData[{
Cell[102718, 3620, 725, 24, 70, "Input",
 CellID->15390],
Cell[103446, 3646, 206, 7, 36, "Output",
 CellID->1745306320]
}, Open  ]],
Cell[103667, 3656, 1173, 38, 70, "Text",
 CellID->12027],
Cell[104843, 3696, 307, 11, 70, "MathCaption",
 CellID->24497],
Cell[CellGroupData[{
Cell[105175, 3711, 212, 7, 70, "Input",
 CellID->19460],
Cell[105390, 3720, 169, 5, 36, "Output",
 CellID->1949288642]
}, Open  ]],
Cell[105574, 3728, 631, 18, 70, "MathCaption",
 CellID->27491],
Cell[CellGroupData[{
Cell[106230, 3750, 292, 9, 70, "Input",
 CellID->16099],
Cell[106525, 3761, 163, 5, 36, "Output",
 CellID->1882601203]
}, Open  ]],
Cell[106703, 3769, 310, 9, 70, "Text",
 CellID->27940],
Cell[107016, 3780, 1770, 55, 70, "DisplayMath",
 CellID->8890],
Cell[108789, 3837, 878, 29, 70, "Text",
 CellID->8106],
Cell[109670, 3868, 214, 8, 70, "MathCaption",
 CellID->7413],
Cell[CellGroupData[{
Cell[109909, 3880, 125, 4, 70, "Input",
 CellID->8498],
Cell[110037, 3886, 328, 12, 51, "Output",
 CellID->1551442486]
}, Open  ]],
Cell[110380, 3901, 574, 17, 70, "MathCaption",
 CellID->2790],
Cell[CellGroupData[{
Cell[110979, 3922, 243, 8, 70, "Input",
 CellID->23562],
Cell[111225, 3932, 1945, 62, 96, "Output",
 CellID->417310166]
}, Open  ]],
Cell[113185, 3997, 275, 10, 70, "MathCaption",
 CellID->6700],
Cell[CellGroupData[{
Cell[113485, 4011, 166, 5, 70, "Input",
 CellID->21610],
Cell[113654, 4018, 159, 5, 36, "Output",
 CellID->432151382]
}, Open  ]]
}, Open  ]],
Cell[113840, 4027, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

