(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     78608,       2820]
NotebookOptionsPosition[     65803,       2405]
NotebookOutlinePosition[     69932,       2495]
CellTagsIndexPosition[     69839,       2489]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Algebraic Manipulation" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/AlgebraicManipulationOverview"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Algebraic Manipulation\"\>"}, "\<\"related tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Cyclotomic" :> 
          Documentation`HelpLookup["paclet:ref/Cyclotomic"], "Decompose" :> 
          Documentation`HelpLookup["paclet:ref/Decompose"], "Discriminant" :> 
          Documentation`HelpLookup["paclet:ref/Discriminant"], "Factor" :> 
          Documentation`HelpLookup["paclet:ref/Factor"], "FactorList" :> 
          Documentation`HelpLookup["paclet:ref/FactorList"], 
          "FactorSquareFree" :> 
          Documentation`HelpLookup["paclet:ref/FactorSquareFree"], 
          "FactorSquareFreeList" :> 
          Documentation`HelpLookup["paclet:ref/FactorSquareFreeList"], 
          "FactorTerms" :> Documentation`HelpLookup["paclet:ref/FactorTerms"],
           "FactorTermsList" :> 
          Documentation`HelpLookup["paclet:ref/FactorTermsList"], 
          "GaussianIntegers" :> 
          Documentation`HelpLookup["paclet:ref/GaussianIntegers"], 
          "GroebnerBasis" :> 
          Documentation`HelpLookup["paclet:ref/GroebnerBasis"], 
          "InterpolatingPolynomial" :> 
          Documentation`HelpLookup["paclet:ref/InterpolatingPolynomial"], 
          "PolynomialExtendedGCD" :> 
          Documentation`HelpLookup["paclet:ref/PolynomialExtendedGCD"], 
          "PolynomialGCD" :> 
          Documentation`HelpLookup["paclet:ref/PolynomialGCD"], 
          "PolynomialLCM" :> 
          Documentation`HelpLookup["paclet:ref/PolynomialLCM"], 
          "PolynomialMod" :> 
          Documentation`HelpLookup["paclet:ref/PolynomialMod"], 
          "PolynomialQuotient" :> 
          Documentation`HelpLookup["paclet:ref/PolynomialQuotient"], 
          "PolynomialQuotientRemainder" :> 
          Documentation`HelpLookup["paclet:ref/PolynomialQuotientRemainder"], 
          "PolynomialReduce" :> 
          Documentation`HelpLookup["paclet:ref/PolynomialReduce"], 
          "PolynomialRemainder" :> 
          Documentation`HelpLookup["paclet:ref/PolynomialRemainder"], 
          "Resultant" :> Documentation`HelpLookup["paclet:ref/Resultant"], 
          "Subresultants" :> 
          Documentation`HelpLookup["paclet:ref/Subresultants"], "True" :> 
          Documentation`HelpLookup["paclet:ref/True"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Cyclotomic\"\>", 2->"\<\"Decompose\"\>", 
       3->"\<\"Discriminant\"\>", 4->"\<\"Factor\"\>", 
       5->"\<\"FactorList\"\>", 6->"\<\"FactorSquareFree\"\>", 
       7->"\<\"FactorSquareFreeList\"\>", 8->"\<\"FactorTerms\"\>", 
       9->"\<\"FactorTermsList\"\>", 10->"\<\"GaussianIntegers\"\>", 
       11->"\<\"GroebnerBasis\"\>", 12->"\<\"InterpolatingPolynomial\"\>", 
       13->"\<\"PolynomialExtendedGCD\"\>", 14->"\<\"PolynomialGCD\"\>", 
       15->"\<\"PolynomialLCM\"\>", 16->"\<\"PolynomialMod\"\>", 
       17->"\<\"PolynomialQuotient\"\>", 
       18->"\<\"PolynomialQuotientRemainder\"\>", 
       19->"\<\"PolynomialReduce\"\>", 20->"\<\"PolynomialRemainder\"\>", 
       21->"\<\"Resultant\"\>", 22->"\<\"Subresultants\"\>", 
       23->"\<\"True\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Algebraic Operations on Polynomials", "Title",
 CellTags->{"S3.3.4", "4.1"},
 CellID->13694],

Cell["\<\
For many kinds of practical calculations, the only operations you will need \
to perform on polynomials are essentially the structural ones discussed in \
the preceding sections. \
\>", "Text",
 CellID->2695],

Cell["\<\
If you do more advanced algebra with polynomials, however, you will have to \
use the algebraic operations discussed in this section.\
\>", "Text",
 CellID->21624],

Cell["\<\
You should realize that most of the operations discussed in this section work \
only on ordinary polynomials, with integer exponents and \
rational\[Hyphen]number coefficients for each term.\
\>", "Text",
 CellID->28019],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["PolynomialQuotient",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/PolynomialQuotient"], "[", 
     SubscriptBox[
      StyleBox["poly", "TI"], 
      StyleBox["1", "TR"]], ",", 
     SubscriptBox[
      StyleBox["poly", "TI"], 
      StyleBox["2", "TR"]], ",", 
     StyleBox["x", "TI"], "]"}], Cell[TextData[{
     "find the result of dividing the polynomial ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["poly", "TI"], 
       StyleBox["1", "TR"]]], "InlineFormula"],
     " in ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " by ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["poly", "TI"], 
       StyleBox["2", "TR"]]], "InlineFormula"],
     ", dropping any remainder term"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["PolynomialRemainder",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/PolynomialRemainder"], "[", 
     SubscriptBox[
      StyleBox["poly", "TI"], 
      StyleBox["1", "TR"]], ",", 
     SubscriptBox[
      StyleBox["poly", "TI"], 
      StyleBox["2", "TR"]], ",", 
     StyleBox["x", "TI"], "]"}], Cell[TextData[{
     "find the remainder from dividing the polynomial ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["poly", "TI"], 
       StyleBox["1", "TR"]]], "InlineFormula"],
     " in ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " by ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["poly", "TI"], 
       StyleBox["2", "TR"]]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["PolynomialQuotientRemainder",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/PolynomialQuotientRemainder"], "[", 
     RowBox[{
      SubscriptBox[
       StyleBox["poly", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["poly", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["x", "TI"]}], "]"}], "\[SpanFromLeft]"},
   {"", Cell["give the quotient and remainder in a list", "TableText"]},
   {
    RowBox[{
     ButtonBox["PolynomialMod",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/PolynomialMod"], "[", 
     StyleBox["poly", "TI"], ",", 
     StyleBox["m", "TI"], "]"}], Cell[TextData[{
     "reduce the polynomial ",
     Cell[BoxData[
      StyleBox["poly", "TI"]], "InlineFormula"],
     " modulo ",
     Cell[BoxData[
      StyleBox["m", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["PolynomialGCD",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/PolynomialGCD"], "[", 
     SubscriptBox[
      StyleBox["poly", "TI"], 
      StyleBox["1", "TR"]], ",", 
     SubscriptBox[
      StyleBox["poly", "TI"], 
      StyleBox["2", "TR"]], "]"}], Cell[
    "find the greatest common divisor of two polynomials", "TableText"]},
   {
    RowBox[{
     ButtonBox["PolynomialLCM",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/PolynomialLCM"], "[", 
     RowBox[{
      SubscriptBox[
       StyleBox["poly", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["poly", "TI"], 
       StyleBox["2", "TR"]]}], "]"}], Cell[
    "find the least common multiple of two polynomials", "TableText"]},
   {
    RowBox[{
     ButtonBox["PolynomialExtendedGCD",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/PolynomialExtendedGCD"], "[", 
     RowBox[{
      SubscriptBox[
       StyleBox["poly", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["poly", "TI"], 
       StyleBox["2", "TR"]]}], "]"}], Cell[
    "find the extended greatest common divisor of two polynomials", 
     "TableText"]},
   {
    RowBox[{
     ButtonBox["Resultant",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Resultant"], "[", 
     RowBox[{
      SubscriptBox[
       StyleBox["poly", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["poly", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["x", "TI"]}], "]"}], Cell[
    "find the resultant of two polynomials", "TableText"]},
   {
    RowBox[{
     ButtonBox["Subresultants",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Subresultants"], "[", 
     RowBox[{
      SubscriptBox[
       StyleBox["poly", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["poly", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["x", "TI"]}], "]"}], Cell["\<\
find the principal subresultant coefficients of two polynomials\
\>", "TableText"]},
   {
    RowBox[{
     ButtonBox["Discriminant",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Discriminant"], "[", 
     RowBox[{
      StyleBox["poly", "TI"], ",", 
      StyleBox["x", "TI"]}], "]"}], Cell[TextData[{
     "find the discriminant of the polynomial ",
     Cell[BoxData[
      StyleBox["poly", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["GroebnerBasis",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/GroebnerBasis"], "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["poly", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["poly", "TI"], 
         StyleBox["2", "TR"]], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["x", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["x", "TI"], 
         StyleBox["2", "TR"]], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}], "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "find the Gr\[ODoubleDot]bner basis for the polynomials ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["poly", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["GroebnerBasis",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/GroebnerBasis"], "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["poly", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["poly", "TI"], 
         StyleBox["2", "TR"]], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["x", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["x", "TI"], 
         StyleBox["2", "TR"]], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["y", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["y", "TI"], 
         StyleBox["2", "TR"]], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}], "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "find the Gr\[ODoubleDot]bner basis eliminating the ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["y", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["PolynomialReduce",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/PolynomialReduce"], "[", 
     RowBox[{
      StyleBox["poly", "TI"], ",", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["poly", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["poly", "TI"], 
         StyleBox["2", "TR"]], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["x", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["x", "TI"], 
         StyleBox["2", "TR"]], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}], "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "find a minimal representation of ",
     Cell[BoxData[
      StyleBox["poly", "TI"]], "InlineFormula"],
     " in terms of the ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["poly", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {
    False, False, False, False, False, False, False, False, False, False, 
     False, False, False, False, {False}, False}, "RowsIndexed" -> {}}},
 CellID->2125],

Cell["Reduction of polynomials. ", "Caption",
 CellID->26576],

Cell[TextData[{
 "Given two polynomials ",
 Cell[BoxData[
  FormBox[
   RowBox[{"p", "(", "x", ")"}], TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"q", "(", "x", ")"}], TraditionalForm]], "InlineMath"],
 ", one can always uniquely write ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    FractionBox[
     RowBox[{"p", "(", "x", ")"}], 
     RowBox[{"q", "(", "x", ")"}]], "=", 
    RowBox[{
     RowBox[{"a", "(", "x", ")"}], "+", 
     FractionBox[
      RowBox[{"b", "(", "x", ")"}], 
      RowBox[{"q", "(", "x", ")"}]]}]}], TraditionalForm]], "InlineMath"],
 ", where the degree of ",
 Cell[BoxData[
  FormBox[
   RowBox[{"b", "(", "x", ")"}], TraditionalForm]], "InlineMath"],
 " is less than the degree of ",
 Cell[BoxData[
  FormBox[
   RowBox[{"q", "(", "x", ")"}], TraditionalForm]], "InlineMath"],
 ". ",
 Cell[BoxData[
  ButtonBox["PolynomialQuotient",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PolynomialQuotient"]], "InlineFormula"],
 " gives the quotient ",
 Cell[BoxData[
  FormBox[
   RowBox[{"a", "(", "x", ")"}], TraditionalForm]], "InlineMath"],
 ", and ",
 Cell[BoxData[
  ButtonBox["PolynomialRemainder",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PolynomialRemainder"]], "InlineFormula"],
 " gives the remainder ",
 Cell[BoxData[
  FormBox[
   RowBox[{"b", "(", "x", ")"}], TraditionalForm]], "InlineMath"],
 ". "
}], "Text",
 CellID->21694],

Cell[TextData[{
 "This gives the remainder from dividing ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["x", "2"], TraditionalForm]], "InlineMath"],
 " by ",
 Cell[BoxData[
  FormBox[
   RowBox[{"1", "+", "x"}], TraditionalForm]], "InlineMath"],
 ". "
}], "MathCaption",
 CellID->22658],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolynomialRemainder", "[", 
  RowBox[{
   RowBox[{"x", "^", "2"}], ",", 
   RowBox[{"x", "+", "1"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:= ",
 CellID->26302],

Cell[BoxData["1"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]= ",
 CellID->17371]
}, Open  ]],

Cell[TextData[{
 "Here is the quotient of ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["x", "2"], TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"x", "+", "1"}], TraditionalForm]], "InlineMath"],
 ", with the remainder dropped. "
}], "MathCaption",
 CellID->22466],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolynomialQuotient", "[", 
  RowBox[{
   RowBox[{"x", "^", "2"}], ",", 
   RowBox[{"x", "+", "1"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[2]:= ",
 CellID->4678],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "1"}], "+", "x"}]], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]= ",
 CellID->22593]
}, Open  ]],

Cell["This gives back the original expression. ", "MathCaption",
 CellID->23851],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"x", "+", "1"}], ")"}], "%"}], "+", "%%"}], "]"}]], "Input",
 CellLabel->"In[3]:= ",
 CellID->25484],

Cell[BoxData[
 SuperscriptBox["x", "2"]], "Output",
 ImageSize->{17, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]= ",
 CellID->1018]
}, Open  ]],

Cell[TextData[{
 "Here the result depends on whether the polynomials are considered to be in \
",
 Cell[BoxData["x"], "InlineFormula"],
 " or ",
 Cell[BoxData["y"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->28464],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"PolynomialRemainder", "[", 
    RowBox[{
     RowBox[{"x", "+", "y"}], ",", 
     RowBox[{"x", "-", "y"}], ",", "x"}], "]"}], ",", 
   RowBox[{"PolynomialRemainder", "[", 
    RowBox[{
     RowBox[{"x", "+", "y"}], ",", 
     RowBox[{"x", "-", "y"}], ",", "y"}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[4]:= ",
 CellID->21119],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"2", " ", "y"}], ",", 
   RowBox[{"2", " ", "x"}]}], "}"}]], "Output",
 ImageSize->{64, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]= ",
 CellID->23152]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["PolynomialMod",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PolynomialMod"]], "InlineFormula"],
 " is essentially the analog for polynomials of the function ",
 Cell[BoxData[
  ButtonBox["Mod",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Mod"]], "InlineFormula"],
 " for integers. When the modulus ",
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"],
 " is an integer, ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["PolynomialMod",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PolynomialMod"], "[", 
   RowBox[{
    StyleBox["poly", "TI"], ",", 
    StyleBox["m", "TI"]}], "]"}]], "InlineFormula"],
 " simply reduces each coefficient in ",
 Cell[BoxData[
  StyleBox["poly", "TI"]], "InlineFormula"],
 " modulo the integer ",
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"],
 ". If ",
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"],
 " is a polynomial, then ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["PolynomialMod",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PolynomialMod"], "[", 
   RowBox[{
    StyleBox["poly", "TI"], ",", 
    StyleBox["m", "TI"]}], "]"}]], "InlineFormula"],
 " effectively tries to get as low degree a polynomial as possible by \
subtracting from ",
 Cell[BoxData[
  StyleBox["poly", "TI"]], "InlineFormula"],
 " appropriate multiples ",
 Cell[BoxData[
  RowBox[{
   StyleBox["q", "TI"], " ", 
   StyleBox["m", "TI"]}]], "InlineFormula"],
 " of ",
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"],
 ". The multiplier ",
 Cell[BoxData[
  StyleBox["q", "TI"]], "InlineFormula"],
 " can itself be a polynomial, but its degree is always less than the degree \
of ",
 Cell[BoxData[
  StyleBox["poly", "TI"]], "InlineFormula"],
 ". ",
 Cell[BoxData[
  ButtonBox["PolynomialMod",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PolynomialMod"]], "InlineFormula"],
 " yields a final polynomial whose degree and leading coefficient are both as \
small as possible. "
}], "Text",
 CellID->9010],

Cell[TextData[{
 "This reduces ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["x", "2"], TraditionalForm]], "InlineMath"],
 " modulo ",
 Cell[BoxData[
  FormBox[
   RowBox[{"x", "+", "1"}], TraditionalForm]], "InlineMath"],
 ". The result is simply the remainder from dividing the polynomials. "
}], "MathCaption",
 CellID->4757],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolynomialMod", "[", 
  RowBox[{
   RowBox[{"x", "^", "2"}], ",", 
   RowBox[{"x", "+", "1"}]}], "]"}]], "Input",
 CellLabel->"In[6]:= ",
 CellID->32170],

Cell[BoxData["1"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]= ",
 CellID->20315]
}, Open  ]],

Cell[TextData[{
 "In this case, ",
 Cell[BoxData[
  ButtonBox["PolynomialMod",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PolynomialMod"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["PolynomialRemainder",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PolynomialRemainder"]], "InlineFormula"],
 " do not give the same result. "
}], "MathCaption",
 CellID->9576],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"PolynomialMod", "[", 
    RowBox[{
     RowBox[{"x", "^", "2"}], ",", 
     RowBox[{
      RowBox[{"a", " ", "x"}], "+", "1"}]}], "]"}], ",", 
   RowBox[{"PolynomialRemainder", "[", 
    RowBox[{
     RowBox[{"x", "^", "2"}], ",", 
     RowBox[{
      RowBox[{"a", " ", "x"}], "+", "1"}], ",", "x"}], "]"}]}], 
  "}"}]], "Input",
 CellLabel->"In[7]:= ",
 CellID->30227],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SuperscriptBox["x", "2"], ",", 
   FractionBox["1", 
    SuperscriptBox["a", "2"]]}], "}"}]], "Output",
 ImageSize->{59, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]= ",
 CellID->12043]
}, Open  ]],

Cell[TextData[{
 "The main difference between ",
 Cell[BoxData[
  ButtonBox["PolynomialMod",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PolynomialMod"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["PolynomialRemainder",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PolynomialRemainder"]], "InlineFormula"],
 " is that while the former works simply by multiplying and subtracting \
polynomials, the latter uses division in getting its results. In addition, ",
 Cell[BoxData[
  ButtonBox["PolynomialMod",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PolynomialMod"]], "InlineFormula"],
 " allows reduction by several moduli at the same time. A typical case is \
reduction modulo both a polynomial and an integer. "
}], "Text",
 CellID->22758],

Cell[TextData[{
 "This reduces the polynomial ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["x", "2"], "+", "1"}], TraditionalForm]], "InlineMath"],
 " modulo both ",
 Cell[BoxData[
  FormBox[
   RowBox[{"x", "+", "1"}], TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox["2", TraditionalForm]], "InlineMath"],
 ". "
}], "MathCaption",
 CellID->7164],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolynomialMod", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "2"}], "+", "1"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "+", "1"}], ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[8]:= ",
 CellID->5109],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]= ",
 CellID->7882]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["PolynomialGCD",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PolynomialGCD"], "[", 
   RowBox[{
    SubscriptBox[
     StyleBox["poly", "TI"], 
     StyleBox["1", "TR"]], ",", 
    SubscriptBox[
     StyleBox["poly", "TI"], 
     StyleBox["2", "TR"]]}], "]"}]], "InlineFormula"],
 " finds the highest degree polynomial that divides the ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["poly", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " exactly. It gives the analog for polynomials of the integer function ",
 Cell[BoxData[
  ButtonBox["GCD",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GCD"]], "InlineFormula"],
 "."
}], "Text",
 CellID->2800],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["PolynomialGCD",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PolynomialGCD"]], "InlineFormula"],
 " gives the greatest common divisor of the two polynomials. "
}], "MathCaption",
 CellID->18087],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolynomialGCD", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "-", "x"}], ")"}], "^", "2"}], " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", "x"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"2", "+", "x"}], ")"}]}], ",", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"1", "-", "x"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"2", "+", "x"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"3", "+", "x"}], ")"}]}]}], "]"}]], "Input",
 CellLabel->"In[5]:= ",
 CellID->31060],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", "1"}], "+", "x"}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{"2", "+", "x"}], ")"}]}]], "Output",
 ImageSize->{96, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]= ",
 CellID->1926]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["PolynomialExtendedGCD",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PolynomialExtendedGCD"]], "InlineFormula"],
 " gives the extended greatest common divisor of the two polynomials. "
}], "MathCaption",
 CellID->226769783],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"g", ",", 
    RowBox[{"{", 
     RowBox[{"r", ",", "s"}], "}"}]}], "}"}], "=", 
  RowBox[{"PolynomialExtendedGCD", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "3"}], "+", 
     RowBox[{"2", 
      RowBox[{"x", "^", "2"}]}], "-", "x", "+", "1"}], ",", 
    RowBox[{
     RowBox[{"x", "^", "4"}], "+", "x", "+", "2"}], ",", "x"}], 
   "]"}]}]], "Input",
 CellLabel->"In[27]:=",
 CellID->687794337],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      FractionBox["29", "215"], "-", 
      FractionBox[
       RowBox[{"26", " ", "x"}], "215"], "-", 
      FractionBox[
       RowBox[{"23", " ", 
        SuperscriptBox["x", "2"]}], "215"], "+", 
      FractionBox[
       RowBox[{"21", " ", 
        SuperscriptBox["x", "3"]}], "215"]}], ",", 
     RowBox[{
      FractionBox["93", "215"], "-", 
      FractionBox[
       RowBox[{"19", " ", "x"}], "215"], "-", 
      FractionBox[
       RowBox[{"21", " ", 
        SuperscriptBox["x", "2"]}], "215"]}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{332, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[27]=",
 CellID->521901330]
}, Open  ]],

Cell[TextData[{
 "The returned polynomials ",
 Cell[BoxData[
  FormBox["r", TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox["s", TraditionalForm]], "InlineMath"],
 " can be used to represent the GCD in terms of the original polynomials."
}], "MathCaption",
 CellID->35644959],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"r", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"x", "^", "3"}], "+", 
      RowBox[{"2", 
       RowBox[{"x", "^", "2"}]}], "-", "x", "+", "1"}], ")"}]}], "+", 
   RowBox[{"s", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"x", "^", "4"}], "+", "x", "+", "2"}], ")"}]}]}], " ", "//", 
  "Expand"}]], "Input",
 CellLabel->"In[28]:=",
 CellID->418777746],

Cell[BoxData["1"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[28]=",
 CellID->316231284]
}, Open  ]],

Cell[TextData[{
 "The function ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Resultant",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Resultant"], "[", 
   RowBox[{
    SubscriptBox[
     StyleBox["poly", "TI"], 
     StyleBox["1", "TR"]], ",", 
    SubscriptBox[
     StyleBox["poly", "TI"], 
     StyleBox["2", "TR"]], ",", 
    StyleBox["x", "TI"]}], "]"}]], "InlineFormula"],
 " is used in a number of classical algebraic algorithms. The resultant of \
two polynomials ",
 Cell[BoxData[
  StyleBox["a", "TI"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  StyleBox["b", "TI"]], "InlineFormula"],
 ", both with leading coefficient one, is given by the product of all the \
differences ",
 Cell[BoxData[
  RowBox[{
   SubscriptBox[
    StyleBox["a", "TI"], 
    StyleBox["i", "TI"]], "-", 
   SubscriptBox[
    StyleBox["b", "TI"], 
    StyleBox["j", "TI"]]}]], "InlineFormula"],
 " between the roots of the polynomials. It turns out that for any pair of \
polynomials, the resultant is always a polynomial in their coefficients. By \
looking at when the resultant is zero, one can tell for what values of their \
parameters two polynomials have a common root. Two polynomials with leading \
coefficient one have ",
 Cell[BoxData[
  StyleBox["k", "TI"]], "InlineFormula"],
 " common roots if exactly the first ",
 Cell[BoxData[
  StyleBox["k", "TI"]], "InlineFormula"],
 " elements in the list ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Subresultants",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Subresultants"], "[", 
   RowBox[{
    SubscriptBox[
     StyleBox["poly", "TI"], 
     StyleBox["1", "TR"]], ",", 
    SubscriptBox[
     StyleBox["poly", "TI"], 
     StyleBox["2", "TR"]], ",", 
    StyleBox["x", "TI"]}], "]"}]], "InlineFormula"],
 " are zero. "
}], "Text",
 CellID->17086],

Cell[TextData[{
 "Here is the resultant with respect to ",
 Cell[BoxData[
  StyleBox["y", "TI"]], "InlineFormula"],
 " of two polynomials in ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  StyleBox["y", "TI"]], "InlineFormula"],
 ". The original polynomials have a common root in ",
 Cell[BoxData[
  StyleBox["y", "TI"]], "InlineFormula"],
 " only for values of ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " at which the resultant vanishes. "
}], "MathCaption",
 CellID->29565],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Resultant", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"x", "-", "y"}], ")"}], "^", "2"}], "-", "2"}], ",", 
   RowBox[{
    RowBox[{"y", "^", "2"}], "-", "3"}], ",", "y"}], "]"}]], "Input",
 CellLabel->"In[9]:= ",
 CellID->3487],

Cell[BoxData[
 RowBox[{"1", "-", 
  RowBox[{"10", " ", 
   SuperscriptBox["x", "2"]}], "+", 
  SuperscriptBox["x", "4"]}]], "Output",
 ImageSize->{79, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[9]= ",
 CellID->29577]
}, Open  ]],

Cell[TextData[{
 "The function ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Discriminant",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Discriminant"], "[", 
   RowBox[{
    StyleBox["poly", "TI"], ",", 
    StyleBox["x", "TI"]}], "]"}]], "InlineFormula"],
 " is the product of the squares of the differences of its roots. It can be \
used to determine whether the polynomial has any repeated roots. The \
discriminant is equal to the resultant of the polynomial and its derivative, \
up to a factor independent of the variable. "
}], "Text",
 CellID->189076444],

Cell["\<\
This polynomial has a repeated root, so its discriminant vanishes. \
\>", "MathCaption",
 CellID->86627586],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Discriminant", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"x", "-", "1"}], ")"}], "^", "2"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[11]:=",
 CellID->7114228],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[11]=",
 CellID->120689252]
}, Open  ]],

Cell["\<\
This polynomial has distinct roots, so its discriminant is nonzero. \
\>", "MathCaption",
 CellID->483933529],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Discriminant", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "4"}], "-", "1"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[12]:=",
 CellID->16999555],

Cell[BoxData[
 RowBox[{"-", "256"}]], "Output",
 ImageSize->{33, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[12]=",
 CellID->424088690]
}, Open  ]],

Cell[TextData[{
 "Gr\[ODoubleDot]bner bases appear in many modern algebraic algorithms and \
applications. The function ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["GroebnerBasis",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/GroebnerBasis"], "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["poly", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["poly", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
 " takes a set of polynomials, and reduces this set to a canonical form from \
which many properties can conveniently be deduced. An important feature is \
that the set of polynomials obtained from ",
 Cell[BoxData[
  ButtonBox["GroebnerBasis",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GroebnerBasis"]], "InlineFormula"],
 " always has exactly the same collection of common roots as the original \
set."
}], "Text",
 CellID->14474],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"x", "+", "y"}], ")"}], "2"], TraditionalForm]], "InlineMath"],
 " is effectively redundant, and so does not appear in the \
Gr\[ODoubleDot]bner basis. "
}], "MathCaption",
 CellID->2625],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GroebnerBasis", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"x", "+", "y"}], ")"}], ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"x", "+", "y"}], ")"}], "^", "2"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[10]:= ",
 CellID->25627],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", "+", "y"}], "}"}]], "Output",
 ImageSize->{45, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[10]= ",
 CellID->5629]
}, Open  ]],

Cell[TextData[{
 "The polynomial ",
 Cell[BoxData["1"], "InlineFormula"],
 " has no roots, showing that the original polynomials have no common roots. \
"
}], "MathCaption",
 CellID->31928],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GroebnerBasis", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "+", "y"}], ",", 
     RowBox[{
      RowBox[{"x", "^", "2"}], "-", "1"}], ",", 
     RowBox[{
      RowBox[{"y", "^", "2"}], "-", 
      RowBox[{"2", "x"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[11]:= ",
 CellID->25423],

Cell[BoxData[
 RowBox[{"{", "1", "}"}]], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[11]= ",
 CellID->28520]
}, Open  ]],

Cell["\<\
The polynomials are effectively unwound here, and can now be seen to have \
exactly five common roots. \
\>", "MathCaption",
 CellID->6902],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GroebnerBasis", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"x", " ", 
       RowBox[{"y", "^", "2"}]}], "+", 
      RowBox[{"2", " ", "x", " ", "y"}], "+", 
      RowBox[{"x", "^", "2"}], "+", "1"}], ",", 
     RowBox[{
      RowBox[{"x", " ", "y"}], "+", 
      RowBox[{"y", "^", "2"}], "+", "1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[12]:= ",
 CellID->14962],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "1"}], "-", 
    SuperscriptBox["y", "2"], "+", 
    SuperscriptBox["y", "3"], "+", 
    SuperscriptBox["y", "4"], "+", 
    SuperscriptBox["y", "5"]}], ",", 
   RowBox[{"x", "+", 
    SuperscriptBox["y", "2"], "+", 
    SuperscriptBox["y", "3"], "+", 
    SuperscriptBox["y", "4"]}]}], "}"}]], "Output",
 ImageSize->{227, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[12]= ",
 CellID->123]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["PolynomialReduce",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PolynomialReduce"], "[", 
   RowBox[{
    StyleBox["poly", "TI"], ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["p", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["p", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
 " yields a list ",
 Cell[BoxData[
  FormBox[
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["a", "1"], ",", 
       SubscriptBox["a", "2"], ",", "\[Ellipsis]"}], "}"}], ",", "b"}], "}"}],
    TraditionalForm]], "InlineMath"],
 " of polynomials with the property that ",
 Cell[BoxData[
  FormBox["b", TraditionalForm]], "InlineMath"],
 " is minimal and ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubscriptBox["a", "1"], 
     SubscriptBox["p", "1"]}], "+", 
    RowBox[{
     SubscriptBox["a", "2"], 
     SubscriptBox["p", "2"]}], "+", "\[Ellipsis]", "+", "b"}], 
   TraditionalForm]], "InlineMath"],
 " is exactly ",
 Cell[BoxData[
  StyleBox["poly", "TI"]], "InlineFormula"],
 "."
}], "Text",
 CellID->24596],

Cell[TextData[{
 "This writes ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["x", "2"], "+", 
    SuperscriptBox["y", "2"]}], TraditionalForm]], "InlineMath"],
 " in terms of ",
 Cell[BoxData[
  FormBox[
   RowBox[{"x", "-", "y"}], TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{"y", "+", "a"}], TraditionalForm]], "InlineMath"],
 ", leaving a remainder that depends only on ",
 Cell[BoxData[
  FormBox["a", TraditionalForm]], "InlineMath"],
 ". "
}], "MathCaption",
 CellID->3737],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolynomialReduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "2"}], "+", 
    RowBox[{"y", "^", "2"}]}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "-", "y"}], ",", 
     RowBox[{"y", "+", "a"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[13]:= ",
 CellID->13261],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "+", "y"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], " ", "a"}], "+", 
      RowBox[{"2", " ", "y"}]}]}], "}"}], ",", 
   RowBox[{"2", " ", 
    SuperscriptBox["a", "2"]}]}], "}"}]], "Output",
 ImageSize->{158, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[13]= ",
 CellID->10195]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Factor",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Factor"], "[", 
     StyleBox["poly", "TI"], "]"}], Cell[
    "factor a polynomial", "TableText"]},
   {
    RowBox[{
     ButtonBox["FactorSquareFree",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/FactorSquareFree"], "[", 
     StyleBox["poly", "TI"], "]"}], Cell["\<\
write a polynomial as a product of powers of square\[Hyphen]free factors\
\>", "TableText"]},
   {
    RowBox[{
     ButtonBox["FactorTerms",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/FactorTerms"], "[", 
     StyleBox["poly", "TI"], ",", 
     StyleBox["x", "TI"], "]"}], Cell[TextData[{
     "factor out terms that do not depend on ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["FactorList",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/FactorList"], "[", 
     StyleBox["poly", "TI"], "]", Cell[", ", "TableText"], 
     ButtonBox["FactorSquareFreeList",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/FactorSquareFreeList"], "[", 
     StyleBox["poly", "TI"], "]", Cell[", ", "TableText"], 
     ButtonBox["FactorTermsList",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/FactorTermsList"], "[", 
     StyleBox["poly", "TI"], "]"}], "\[SpanFromLeft]"},
   {"", Cell["give results as lists of factors", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, False, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {18, {
      Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->32525],

Cell["Functions for factoring polynomials. ", "Caption",
 CellID->1264],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Factor",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Factor"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["FactorTerms",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FactorTerms"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["FactorSquareFree",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FactorSquareFree"]], "InlineFormula"],
 " perform various degrees of factoring on polynomials. ",
 Cell[BoxData[
  ButtonBox["Factor",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Factor"]], "InlineFormula"],
 " does full factoring over the integers. ",
 Cell[BoxData[
  ButtonBox["FactorTerms",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FactorTerms"]], "InlineFormula"],
 " extracts the \[OpenCurlyDoubleQuote]content\[CloseCurlyDoubleQuote] of the \
polynomial. ",
 Cell[BoxData[
  ButtonBox["FactorSquareFree",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FactorSquareFree"]], "InlineFormula"],
 " pulls out any multiple factors that appear. "
}], "Text",
 CellID->8260],

Cell["Here is a polynomial, in expanded form. ", "MathCaption",
 CellID->6202],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"t", "=", 
  RowBox[{"Expand", "[", 
   RowBox[{"2", " ", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "+", "x"}], ")"}], "^", "2"}], " ", 
    RowBox[{"(", 
     RowBox[{"2", "+", "x"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"3", "+", "x"}], ")"}]}], "]"}]}]], "Input",
 CellLabel->"In[14]:= ",
 CellID->8116],

Cell[BoxData[
 RowBox[{"12", "+", 
  RowBox[{"34", " ", "x"}], "+", 
  RowBox[{"34", " ", 
   SuperscriptBox["x", "2"]}], "+", 
  RowBox[{"14", " ", 
   SuperscriptBox["x", "3"]}], "+", 
  RowBox[{"2", " ", 
   SuperscriptBox["x", "4"]}]}]], "Output",
 ImageSize->{174, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[14]= ",
 CellID->5030]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["FactorTerms",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FactorTerms"]], "InlineFormula"],
 " pulls out only the factor of 2 that does not depend on ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 ". "
}], "MathCaption",
 CellID->20326],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FactorTerms", "[", 
  RowBox[{"t", ",", "x"}], "]"}]], "Input",
 CellLabel->"In[15]:= ",
 CellID->29011],

Cell[BoxData[
 RowBox[{"2", " ", 
  RowBox[{"(", 
   RowBox[{"6", "+", 
    RowBox[{"17", " ", "x"}], "+", 
    RowBox[{"17", " ", 
     SuperscriptBox["x", "2"]}], "+", 
    RowBox[{"7", " ", 
     SuperscriptBox["x", "3"]}], "+", 
    SuperscriptBox["x", "4"]}], ")"}]}]], "Output",
 ImageSize->{174, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[15]= ",
 CellID->30771]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["FactorSquareFree",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FactorSquareFree"]], "InlineFormula"],
 " factors out the 2 and the term ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{"1", "+", "x"}], ")"}], "^", "2"}], TraditionalForm]], 
  "InlineMath"],
 ", but leaves the rest unfactored. "
}], "MathCaption",
 CellID->6411],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FactorSquareFree", "[", "t", "]"}]], "Input",
 CellLabel->"In[16]:= ",
 CellID->25547],

Cell[BoxData[
 RowBox[{"2", " ", 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{"1", "+", "x"}], ")"}], "2"], " ", 
  RowBox[{"(", 
   RowBox[{"6", "+", 
    RowBox[{"5", " ", "x"}], "+", 
    SuperscriptBox["x", "2"]}], ")"}]}]], "Output",
 ImageSize->{139, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[16]= ",
 CellID->21153]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Factor",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Factor"]], "InlineFormula"],
 " does full factoring, recovering the original form. "
}], "MathCaption",
 CellID->21520],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Factor", "[", "t", "]"}]], "Input",
 CellLabel->"In[17]:= ",
 CellID->29790],

Cell[BoxData[
 RowBox[{"2", " ", 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{"1", "+", "x"}], ")"}], "2"], " ", 
  RowBox[{"(", 
   RowBox[{"2", "+", "x"}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{"3", "+", "x"}], ")"}]}]], "Output",
 ImageSize->{148, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[17]= ",
 CellID->14924]
}, Open  ]],

Cell[TextData[{
 "Particularly when you write programs that work with polynomials, you will \
often find it convenient to pick out pieces of polynomials in a standard \
form. The function ",
 Cell[BoxData[
  ButtonBox["FactorList",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FactorList"]], "InlineFormula"],
 " gives a list of all the factors of a polynomial, together with their \
exponents. The first element of the list is always the overall numerical \
factor for the polynomial."
}], "Text",
 CellID->30188],

Cell[TextData[{
 "The form that ",
 Cell[BoxData[
  ButtonBox["FactorList",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FactorList"]], "InlineFormula"],
 " returns is the analog for polynomials of the form produced by ",
 Cell[BoxData[
  ButtonBox["FactorInteger",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FactorInteger"]], "InlineFormula"],
 " for integers. "
}], "Text",
 CellID->21763],

Cell["\<\
Here is a list of the factors of the polynomial in the previous set of \
examples. Each element of the list gives the factor, together with its \
exponent. \
\>", "MathCaption",
 CellID->4940],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FactorList", "[", "t", "]"}]], "Input",
 CellLabel->"In[18]:= ",
 CellID->20851],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "+", "x"}], ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"2", "+", "x"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"3", "+", "x"}], ",", "1"}], "}"}]}], "}"}]], "Output",
 ImageSize->{268, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[18]= ",
 CellID->18662]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Factor",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Factor"], "[", 
     StyleBox["poly", "TI"], ",", 
     ButtonBox["GaussianIntegers",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/GaussianIntegers"], "->", 
     ButtonBox["True",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/True"], "]"}], "\[SpanFromLeft]"},
   {"", Cell["\<\
factor a polynomial, allowing coefficients that are Gaussian integers\
\>", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {18, {
      Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->13829],

Cell["Factoring polynomials with complex coefficients. ", "Caption",
 CellID->30900],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Factor",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Factor"]], "InlineFormula"],
 " and related functions usually handle only polynomials with ordinary \
integer or rational\[Hyphen]number coefficients. If you set the option ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["GaussianIntegers",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/GaussianIntegers"], "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 ", however, then ",
 Cell[BoxData[
  ButtonBox["Factor",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Factor"]], "InlineFormula"],
 " will allow polynomials with coefficients that are complex numbers with \
rational real and imaginary parts. This often allows more extensive \
factorization to be performed. "
}], "Text",
 CellID->17713],

Cell["\<\
This polynomial is irreducible when only ordinary integers are allowed. \
\>", "MathCaption",
 CellID->18958],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Factor", "[", 
  RowBox[{"1", "+", 
   RowBox[{"x", "^", "2"}]}], "]"}]], "Input",
 CellLabel->"In[19]:= ",
 CellID->17578],

Cell[BoxData[
 RowBox[{"1", "+", 
  SuperscriptBox["x", "2"]}]], "Output",
 ImageSize->{37, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[19]= ",
 CellID->8365]
}, Open  ]],

Cell["\<\
When Gaussian integer coefficients are allowed, the polynomial factors. \
\>", "MathCaption",
 CellID->13007],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Factor", "[", 
  RowBox[{
   RowBox[{"1", "+", 
    RowBox[{"x", "^", "2"}]}], ",", 
   RowBox[{"GaussianIntegers", "->", "True"}]}], "]"}]], "Input",
 CellLabel->"In[20]:= ",
 CellID->11477],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", "\[ImaginaryI]"}], "+", "x"}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{"\[ImaginaryI]", "+", "x"}], ")"}]}]], "Output",
 ImageSize->{98, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[20]= ",
 CellID->1200]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Cyclotomic",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Cyclotomic"], "[", 
     StyleBox["n", "TI"], ",", 
     StyleBox["x", "TI"], "]"}], Cell[TextData[{
     "give the cyclotomic polynomial of order ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " in ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {False, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->26058],

Cell["Cyclotomic polynomials. ", "Caption",
 CellID->6439],

Cell[TextData[{
 "Cyclotomic polynomials arise as \[OpenCurlyDoubleQuote]elementary \
polynomials\[CloseCurlyDoubleQuote] in various algebraic algorithms. The \
cyclotomic polynomials are defined by ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubscriptBox["C", "n"], "(", "x", ")"}], "=", 
    RowBox[{
     UnderscriptBox["\[Product]", "k",
      LimitsPositioning->True], 
     RowBox[{"(", 
      RowBox[{"x", "-", 
       SuperscriptBox["e", 
        RowBox[{"2", "\[Pi]", "i", "k", "/", "n"}]]}], ")"}]}]}], 
   TraditionalForm]], "InlineMath"],
 ", where ",
 Cell[BoxData[
  FormBox["k", TraditionalForm]], "InlineMath"],
 " runs over all positive integers less than ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 " that are relatively prime to ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 "."
}], "Text",
 CellID->2303],

Cell[TextData[{
 "This is the cyclotomic polynomial ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["C", "6"], 
    RowBox[{"(", "x", ")"}]}], TraditionalForm]], "InlineMath"],
 ". "
}], "MathCaption",
 CellID->12760],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Cyclotomic", "[", 
  RowBox[{"6", ",", "x"}], "]"}]], "Input",
 CellLabel->"In[21]:= ",
 CellID->19357],

Cell[BoxData[
 RowBox[{"1", "-", "x", "+", 
  SuperscriptBox["x", "2"]}]], "Output",
 ImageSize->{56, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[21]= ",
 CellID->2324]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["C", "6"], "(", "x", ")"}], TraditionalForm]], 
  "InlineMath"],
 " appears in the factors of ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["x", "6"], "-", "1"}], TraditionalForm]], "InlineMath"],
 ". "
}], "MathCaption",
 CellID->6477],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Factor", "[", 
  RowBox[{
   RowBox[{"x", "^", "6"}], "-", "1"}], "]"}]], "Input",
 CellLabel->"In[22]:= ",
 CellID->5108],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", "1"}], "+", "x"}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{"1", "+", "x"}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{"1", "-", "x", "+", 
    SuperscriptBox["x", "2"]}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{"1", "+", "x", "+", 
    SuperscriptBox["x", "2"]}], ")"}]}]], "Output",
 ImageSize->{234, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[22]= ",
 CellID->21113]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Decompose",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Decompose"], "[", 
     StyleBox["poly", "TI"], ",", 
     StyleBox["x", "TI"], "]"}], Cell[TextData[{
     "decompose ",
     Cell[BoxData[
      StyleBox["poly", "TI"]], "InlineFormula"],
     ", if possible, into a composition of a list of simpler polynomials"
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {False, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->14887],

Cell["Decomposing polynomials. ", "Caption",
 CellID->19801],

Cell[TextData[{
 "Factorization is one important way of breaking down polynomials into \
simpler parts. Another, quite different, way is ",
 StyleBox["decomposition",
  FontSlant->"Italic"],
 ". When one factors a polynomial ",
 Cell[BoxData[
  FormBox[
   RowBox[{"P", "(", "x", ")"}], TraditionalForm]], "InlineMath"],
 ", one writes it as a product ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     RowBox[{
      SubscriptBox["p", "1"], "(", "x", ")"}], 
     RowBox[{
      SubscriptBox["p", "2"], "(", "x", ")"}]}], "..."}], TraditionalForm]], 
  "InlineMath"],
 " of polynomials ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["p", "i"], "(", "x", ")"}], TraditionalForm]], 
  "InlineMath"],
 ". Decomposing a polynomial ",
 Cell[BoxData[
  FormBox[
   RowBox[{"Q", "(", "x", ")"}], TraditionalForm]], "InlineMath"],
 " consists of writing it as a ",
 StyleBox["composition",
  FontSlant->"Italic"],
 " of polynomials of the form ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["q", "1"], "(", 
    RowBox[{
     SubscriptBox["q", "2"], "(", 
     RowBox[{"...", 
      RowBox[{"(", "x", ")"}], "..."}], ")"}], ")"}], TraditionalForm]], 
  "InlineMath"],
 "."
}], "Text",
 CellID->22850],

Cell[TextData[{
 "Here is a simple example of ",
 Cell[BoxData[
  ButtonBox["Decompose",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Decompose"]], "InlineFormula"],
 ". The original polynomial ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["x", "4"], "+", 
    SuperscriptBox["x", "2"], "+", "1"}], TraditionalForm]], "InlineMath"],
 " can be written as the polynomial ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox[
     OverscriptBox["x", "_"], "2"], "+", 
    OverscriptBox["x", "_"], "+", "1"}], TraditionalForm]], "InlineMath"],
 ", where ",
 Cell[BoxData[
  FormBox[
   OverscriptBox["x", "_"], TraditionalForm]], "InlineMath"],
 " is the polynomial ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["x", "2"], TraditionalForm]], "InlineMath"],
 ". "
}], "MathCaption",
 CellID->14460],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Decompose", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "4"}], "+", 
    RowBox[{"x", "^", "2"}], "+", "1"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[23]:= ",
 CellID->22428],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"1", "+", "x", "+", 
    SuperscriptBox["x", "2"]}], ",", 
   SuperscriptBox["x", "2"]}], "}"}]], "Output",
 ImageSize->{94, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[23]= ",
 CellID->12993]
}, Open  ]],

Cell["Here are two polynomial functions. ", "MathCaption",
 CellID->27384],

Cell[BoxData[
 RowBox[{"(", 
  RowBox[{
   RowBox[{
    RowBox[{"q1", "[", "x_", "]"}], "=", 
    RowBox[{"1", "-", 
     RowBox[{"2", "x"}], "+", 
     RowBox[{"x", "^", "4"}]}]}], ";", 
   RowBox[{
    RowBox[{"q2", "[", "x_", "]"}], "=", 
    RowBox[{
     RowBox[{"5", "x"}], "+", 
     RowBox[{"x", "^", "3"}]}]}], ";"}], ")"}]], "Input",
 CellLabel->"In[24]:= ",
 CellID->19405],

Cell["This gives the composition of the two functions. ", "MathCaption",
 CellID->6540],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Expand", "[", 
  RowBox[{"q1", "[", 
   RowBox[{"q2", "[", "x", "]"}], "]"}], "]"}]], "Input",
 CellLabel->"In[25]:= ",
 CellID->31111],

Cell[BoxData[
 RowBox[{"1", "-", 
  RowBox[{"10", " ", "x"}], "-", 
  RowBox[{"2", " ", 
   SuperscriptBox["x", "3"]}], "+", 
  RowBox[{"625", " ", 
   SuperscriptBox["x", "4"]}], "+", 
  RowBox[{"500", " ", 
   SuperscriptBox["x", "6"]}], "+", 
  RowBox[{"150", " ", 
   SuperscriptBox["x", "8"]}], "+", 
  RowBox[{"20", " ", 
   SuperscriptBox["x", "10"]}], "+", 
  SuperscriptBox["x", "12"]}]], "Output",
 ImageSize->{308, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[25]= ",
 CellID->28704]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Decompose",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Decompose"]], "InlineFormula"],
 " recovers the original functions. "
}], "MathCaption",
 CellID->12835],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Decompose", "[", 
  RowBox[{"%", ",", "x"}], "]"}]], "Input",
 CellLabel->"In[26]:= ",
 CellID->32356],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"1", "-", 
    RowBox[{"2", " ", "x"}], "+", 
    SuperscriptBox["x", "4"]}], ",", 
   RowBox[{
    RowBox[{"5", " ", "x"}], "+", 
    SuperscriptBox["x", "3"]}]}], "}"}]], "Output",
 ImageSize->{134, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[26]= ",
 CellID->6072]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Decompose",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Decompose"], "[", 
   RowBox[{
    StyleBox["poly", "TI"], ",", 
    StyleBox["x", "TI"]}], "]"}]], "InlineFormula"],
 " is set up to give a list of polynomials in ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 ", which, if composed, reproduce the original polynomial. The original \
polynomial can contain variables other than ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 ", but the sequence of polynomials that ",
 Cell[BoxData[
  ButtonBox["Decompose",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Decompose"]], "InlineFormula"],
 " produces are all intended to be considered as functions of ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 ". "
}], "Text",
 CellID->29350],

Cell[TextData[{
 "Unlike factoring, the decomposition of polynomials is not completely \
unique. For example, the two sets of polynomials ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["p", "i"], TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["q", "i"], TraditionalForm]], "InlineMath"],
 ", related by ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubscriptBox["q", "1"], "(", "x", ")"}], "=", 
    RowBox[{
     SubscriptBox["p", "1"], "(", 
     RowBox[{"x", "-", "a"}], ")"}]}], TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubscriptBox["q", "2"], "(", "x", ")"}], "=", 
    RowBox[{
     RowBox[{
      SubscriptBox["p", "2"], "(", "x", ")"}], "+", "a"}]}], 
   TraditionalForm]], "InlineMath"],
 " give the same result on composition, so that ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubscriptBox["p", "1"], "(", 
     RowBox[{
      SubscriptBox["p", "2"], "(", "x", ")"}], ")"}], "=", 
    RowBox[{
     SubscriptBox["q", "1"], "(", 
     RowBox[{
      SubscriptBox["q", "2"], "(", "x", ")"}], ")"}]}], TraditionalForm]], 
  "InlineMath"],
 ". ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " follows the convention of absorbing any constant terms into the first \
polynomial in the list produced by ",
 Cell[BoxData[
  ButtonBox["Decompose",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Decompose"]], "InlineFormula"],
 ". "
}], "Text",
 CellID->18823],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["InterpolatingPolynomial",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/InterpolatingPolynomial"], "[", "{", 
     SubscriptBox[
      StyleBox["f", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["f", "TI"], "2"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "}", ",", 
     StyleBox["x", "TI"], "]"}], "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "give a polynomial in ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " which is equal to ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["f", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     " when ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " is the integer ",
     Cell[BoxData[
      StyleBox["i", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["InterpolatingPolynomial",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/InterpolatingPolynomial"], "[", "{", "{", 
     SubscriptBox[
      StyleBox["x", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["f", "TI"], "1"], "}", ",", "{", 
     SubscriptBox[
      StyleBox["x", "TI"], "2"], ",", 
     SubscriptBox[
      StyleBox["f", "TI"], "2"], "}", ",", 
     StyleBox["\[Ellipsis]", "TR"], "}", ",", 
     StyleBox["x", "TI"], "]"}], "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "give a polynomial in ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " which is equal to ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["f", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     " when ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " is ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {18, {
      Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->14485],

Cell["Generating interpolating polynomials. ", "Caption",
 CellID->20556],

Cell["\<\
This yields a quadratic polynomial which goes through the specified three \
points. \
\>", "MathCaption",
 CellID->23216],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InterpolatingPolynomial", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "6"}], "}"}]}], "}"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[27]:= ",
 CellID->1626],

Cell[BoxData[
 RowBox[{"4", "+", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"1", "+", "x"}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "2"}], "+", 
     RowBox[{"3", " ", "x"}]}], ")"}]}]}]], "Output",
 ImageSize->{126, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[27]= ",
 CellID->9357]
}, Open  ]],

Cell[TextData[{
 "When ",
 Cell[BoxData["x"], "InlineFormula"],
 " is ",
 Cell[BoxData["0"], "InlineFormula"],
 ", the polynomial has value\[NonBreakingSpace]",
 Cell[BoxData["2"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->8526],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "/.", 
  RowBox[{"x", "->", "0"}]}]], "Input",
 CellLabel->"In[28]:= ",
 CellID->13357],

Cell[BoxData["2"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[28]= ",
 CellID->29337]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->122719223],

Cell[TextData[ButtonBox["Algebraic Manipulation",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/AlgebraicManipulationOverview"]], "RelatedTutorials",
 CellID->91103315]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Algebraic Operations on Polynomials - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Algebraic Manipulation", "OverviewNavText"], BaseStyle -> 
        "Link", ButtonData -> 
        "paclet:tutorial/AlgebraicManipulationOverview"]], "Text", FontFamily -> 
      "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/StructuralOperationsOnRationalExpressions"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/PolynomialsModuloPrimes"]}], 
      "Text", FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 32, 34.3727102}", "context" -> "", 
    "keywords" -> {
     "algebraic algorithms", "algebraic operations on polynomials", 
      "algebraic varieties", "algorithms", "basis", "catastrophe theory", 
      "common roots in polynomials", "complex numbers", "content", 
      "cyclotomic", "cyclotomic polynomials", "Decompose", "decomposition", 
      "decomposition of polynomials", "Discriminant", "division", 
      "elimination basis", "Factor", "FactorList", "FactorSquareFree", 
      "FactorSquareFreeList", "FactorTerms", "FactorTermsList", 
      "Gaussian integers", "GaussianIntegers", "GCD", "generalized division", 
      "geometry", "greatest common divisor of polynomials", "GroebnerBasis", 
      "ideals", "InterpolatingPolynomial", "moduli", "Newton interpolation", 
      "normal form", "PolynomialExtendedGCD", "PolynomialGCD", 
      "PolynomialLCM", "PolynomialMod", "PolynomialPowerMod", 
      "PolynomialQuotient", "PolynomialQuotientRemainder", "PolynomialReduce",
       "PolynomialRemainder", "polynomials", "primary decomposition", 
      "principal subresultant coefficients", "quotient", "QuotientRemainder", 
      "reduction", "remainder", "Resultant", "singularities", 
      "square-free factoring", "standard basis", "Subresultants", 
      "SymmetricPolynomial", "syzygies", "varieties"}, "index" -> True, 
    "label" -> "Mathematica Tutorial", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "For many kinds of practical calculations, the only operations you will \
need to perform on polynomials are essentially the structural ones discussed \
in the preceding sections. If you do more advanced algebra with polynomials, \
however, you will have to use the algebraic operations discussed in this \
section. You should realize that most of the operations discussed in this \
section work only on ordinary polynomials, with integer exponents and \
rational-number coefficients for each term.", "synonyms" -> {"3.3.4"}, 
    "title" -> "Algebraic Operations on Polynomials", "type" -> "Tutorial", 
    "uri" -> "tutorial/AlgebraicOperationsOnPolynomials"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S3.3.4"->{
  Cell[4652, 107, 98, 2, 70, "Title",
   CellTags->{"S3.3.4", "4.1"},
   CellID->13694]},
 "4.1"->{
  Cell[4652, 107, 98, 2, 70, "Title",
   CellTags->{"S3.3.4", "4.1"},
   CellID->13694]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S3.3.4", 69626, 2478},
 {"4.1", 69726, 2482}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 4027, 80, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[4652, 107, 98, 2, 70, "Title",
 CellTags->{"S3.3.4", "4.1"},
 CellID->13694],
Cell[4753, 111, 218, 5, 70, "Text",
 CellID->2695],
Cell[4974, 118, 173, 4, 70, "Text",
 CellID->21624],
Cell[5150, 124, 230, 5, 70, "Text",
 CellID->28019],
Cell[5383, 131, 8387, 275, 70, "DefinitionBox",
 CellID->2125],
Cell[13773, 408, 61, 1, 70, "Caption",
 CellID->26576],
Cell[13837, 411, 1407, 49, 70, "Text",
 CellID->21694],
Cell[15247, 462, 286, 11, 70, "MathCaption",
 CellID->22658],
Cell[CellGroupData[{
Cell[15558, 477, 193, 6, 28, "Input",
 CellID->26302],
Cell[15754, 485, 155, 5, 36, "Output",
 CellID->17371]
}, Open  ]],
Cell[15924, 493, 300, 11, 70, "MathCaption",
 CellID->22466],
Cell[CellGroupData[{
Cell[16249, 508, 191, 6, 70, "Input",
 CellID->4678],
Cell[16443, 516, 195, 7, 36, "Output",
 CellID->22593]
}, Open  ]],
Cell[16653, 526, 80, 1, 70, "MathCaption",
 CellID->23851],
Cell[CellGroupData[{
Cell[16758, 531, 195, 7, 70, "Input",
 CellID->25484],
Cell[16956, 540, 177, 6, 36, "Output",
 CellID->1018]
}, Open  ]],
Cell[17148, 549, 223, 8, 70, "MathCaption",
 CellID->28464],
Cell[CellGroupData[{
Cell[17396, 561, 380, 12, 70, "Input",
 CellID->21119],
Cell[17779, 575, 248, 9, 36, "Output",
 CellID->23152]
}, Open  ]],
Cell[18042, 587, 2003, 67, 70, "Text",
 CellID->9010],
Cell[20048, 656, 329, 11, 70, "MathCaption",
 CellID->4757],
Cell[CellGroupData[{
Cell[20402, 671, 177, 6, 70, "Input",
 CellID->32170],
Cell[20582, 679, 155, 5, 36, "Output",
 CellID->20315]
}, Open  ]],
Cell[20752, 687, 382, 13, 70, "MathCaption",
 CellID->9576],
Cell[CellGroupData[{
Cell[21159, 704, 421, 15, 70, "Input",
 CellID->30227],
Cell[21583, 721, 273, 10, 52, "Output",
 CellID->12043]
}, Open  ]],
Cell[21871, 734, 766, 20, 70, "Text",
 CellID->22758],
Cell[22640, 756, 382, 15, 70, "MathCaption",
 CellID->7164],
Cell[CellGroupData[{
Cell[23047, 775, 252, 9, 70, "Input",
 CellID->5109],
Cell[23302, 786, 154, 5, 36, "Output",
 CellID->7882]
}, Open  ]],
Cell[23471, 794, 719, 25, 70, "Text",
 CellID->2800],
Cell[24193, 821, 242, 7, 70, "MathCaption",
 CellID->18087],
Cell[CellGroupData[{
Cell[24460, 832, 530, 19, 70, "Input",
 CellID->31060],
Cell[24993, 853, 290, 11, 36, "Output",
 CellID->1926]
}, Open  ]],
Cell[25298, 867, 271, 7, 70, "MathCaption",
 CellID->226769783],
Cell[CellGroupData[{
Cell[25594, 878, 457, 16, 70, "Input",
 CellID->687794337],
Cell[26054, 896, 762, 26, 54, "Output",
 CellID->521901330]
}, Open  ]],
Cell[26831, 925, 296, 9, 70, "MathCaption",
 CellID->35644959],
Cell[CellGroupData[{
Cell[27152, 938, 404, 15, 70, "Input",
 CellID->418777746],
Cell[27559, 955, 159, 5, 36, "Output",
 CellID->316231284]
}, Open  ]],
Cell[27733, 963, 1801, 58, 70, "Text",
 CellID->17086],
Cell[29537, 1023, 533, 18, 70, "MathCaption",
 CellID->29565],
Cell[CellGroupData[{
Cell[30095, 1045, 285, 10, 70, "Input",
 CellID->3487],
Cell[30383, 1057, 260, 9, 36, "Output",
 CellID->29577]
}, Open  ]],
Cell[30658, 1069, 566, 15, 70, "Text",
 CellID->189076444],
Cell[31227, 1086, 117, 3, 70, "MathCaption",
 CellID->86627586],
Cell[CellGroupData[{
Cell[31369, 1093, 205, 7, 70, "Input",
 CellID->7114228],
Cell[31577, 1102, 159, 5, 36, "Output",
 CellID->120689252]
}, Open  ]],
Cell[31751, 1110, 119, 3, 70, "MathCaption",
 CellID->483933529],
Cell[CellGroupData[{
Cell[31895, 1117, 180, 6, 70, "Input",
 CellID->16999555],
Cell[32078, 1125, 178, 6, 36, "Output",
 CellID->424088690]
}, Open  ]],
Cell[32271, 1134, 1236, 37, 70, "Text",
 CellID->14474],
Cell[33510, 1173, 288, 10, 70, "MathCaption",
 CellID->2625],
Cell[CellGroupData[{
Cell[33823, 1187, 362, 13, 70, "Input",
 CellID->25627],
Cell[34188, 1202, 200, 7, 36, "Output",
 CellID->5629]
}, Open  ]],
Cell[34403, 1212, 189, 6, 70, "MathCaption",
 CellID->31928],
Cell[CellGroupData[{
Cell[34617, 1222, 392, 14, 70, "Input",
 CellID->25423],
Cell[35012, 1238, 178, 6, 36, "Output",
 CellID->28520]
}, Open  ]],
Cell[35205, 1247, 149, 4, 70, "MathCaption",
 CellID->6902],
Cell[CellGroupData[{
Cell[35379, 1255, 483, 16, 70, "Input",
 CellID->14962],
Cell[35865, 1273, 500, 17, 39, "Output",
 CellID->123]
}, Open  ]],
Cell[36380, 1293, 1488, 55, 70, "Text",
 CellID->24596],
Cell[37871, 1350, 528, 20, 70, "MathCaption",
 CellID->3737],
Cell[CellGroupData[{
Cell[38424, 1374, 367, 13, 70, "Input",
 CellID->13261],
Cell[38794, 1389, 430, 16, 39, "Output",
 CellID->10195]
}, Open  ]],
Cell[39239, 1408, 1917, 54, 70, "DefinitionBox",
 CellID->32525],
Cell[41159, 1464, 71, 1, 70, "Caption",
 CellID->1264],
Cell[41233, 1467, 1057, 33, 70, "Text",
 CellID->8260],
Cell[42293, 1502, 78, 1, 70, "MathCaption",
 CellID->6202],
Cell[CellGroupData[{
Cell[42396, 1507, 346, 12, 70, "Input",
 CellID->8116],
Cell[42745, 1521, 379, 13, 36, "Output",
 CellID->5030]
}, Open  ]],
Cell[43139, 1537, 306, 10, 70, "MathCaption",
 CellID->20326],
Cell[CellGroupData[{
Cell[43470, 1551, 128, 4, 70, "Input",
 CellID->29011],
Cell[43601, 1557, 413, 14, 39, "Output",
 CellID->30771]
}, Open  ]],
Cell[44029, 1574, 401, 14, 70, "MathCaption",
 CellID->6411],
Cell[CellGroupData[{
Cell[44455, 1592, 110, 3, 70, "Input",
 CellID->25547],
Cell[44568, 1597, 370, 13, 39, "Output",
 CellID->21153]
}, Open  ]],
Cell[44953, 1613, 221, 7, 70, "MathCaption",
 CellID->21520],
Cell[CellGroupData[{
Cell[45199, 1624, 100, 3, 70, "Input",
 CellID->29790],
Cell[45302, 1629, 366, 13, 36, "Output",
 CellID->14924]
}, Open  ]],
Cell[45683, 1645, 518, 12, 70, "Text",
 CellID->30188],
Cell[46204, 1659, 401, 13, 70, "Text",
 CellID->21763],
Cell[46608, 1674, 202, 5, 70, "MathCaption",
 CellID->4940],
Cell[CellGroupData[{
Cell[46835, 1683, 104, 3, 70, "Input",
 CellID->20851],
Cell[46942, 1688, 496, 18, 36, "Output",
 CellID->18662]
}, Open  ]],
Cell[47453, 1709, 951, 27, 70, "DefinitionBox",
 CellID->13829],
Cell[48407, 1738, 84, 1, 70, "Caption",
 CellID->30900],
Cell[48494, 1741, 858, 24, 70, "Text",
 CellID->17713],
Cell[49355, 1767, 119, 3, 70, "MathCaption",
 CellID->18958],
Cell[CellGroupData[{
Cell[49499, 1774, 147, 5, 70, "Input",
 CellID->17578],
Cell[49649, 1781, 201, 7, 36, "Output",
 CellID->8365]
}, Open  ]],
Cell[49865, 1791, 119, 3, 70, "MathCaption",
 CellID->13007],
Cell[CellGroupData[{
Cell[50009, 1798, 215, 7, 70, "Input",
 CellID->11477],
Cell[50227, 1807, 315, 11, 36, "Output",
 CellID->1200]
}, Open  ]],
Cell[50557, 1821, 757, 23, 70, "DefinitionBox",
 CellID->26058],
Cell[51317, 1846, 58, 1, 70, "Caption",
 CellID->6439],
Cell[51378, 1849, 885, 28, 70, "Text",
 CellID->2303],
Cell[52266, 1879, 227, 9, 70, "MathCaption",
 CellID->12760],
Cell[CellGroupData[{
Cell[52518, 1892, 127, 4, 70, "Input",
 CellID->19357],
Cell[52648, 1898, 211, 7, 36, "Output",
 CellID->2324]
}, Open  ]],
Cell[52874, 1908, 321, 13, 70, "MathCaption",
 CellID->6477],
Cell[CellGroupData[{
Cell[53220, 1925, 146, 5, 70, "Input",
 CellID->5108],
Cell[53369, 1932, 479, 17, 39, "Output",
 CellID->21113]
}, Open  ]],
Cell[53863, 1952, 728, 21, 70, "DefinitionBox",
 CellID->14887],
Cell[54594, 1975, 60, 1, 70, "Caption",
 CellID->19801],
Cell[54657, 1978, 1223, 44, 70, "Text",
 CellID->22850],
Cell[55883, 2024, 819, 29, 70, "MathCaption",
 CellID->14460],
Cell[CellGroupData[{
Cell[56727, 2057, 210, 7, 70, "Input",
 CellID->22428],
Cell[56940, 2066, 286, 10, 39, "Output",
 CellID->12993]
}, Open  ]],
Cell[57241, 2079, 74, 1, 70, "MathCaption",
 CellID->27384],
Cell[57318, 2082, 384, 14, 70, "Input",
 CellID->19405],
Cell[57705, 2098, 87, 1, 70, "MathCaption",
 CellID->6540],
Cell[CellGroupData[{
Cell[57817, 2103, 159, 5, 70, "Input",
 CellID->31111],
Cell[57979, 2110, 536, 18, 36, "Output",
 CellID->28704]
}, Open  ]],
Cell[58530, 2131, 209, 7, 70, "MathCaption",
 CellID->12835],
Cell[CellGroupData[{
Cell[58764, 2142, 126, 4, 70, "Input",
 CellID->32356],
Cell[58893, 2148, 361, 13, 39, "Output",
 CellID->6072]
}, Open  ]],
Cell[59269, 2164, 862, 26, 70, "Text",
 CellID->29350],
Cell[60134, 2192, 1495, 53, 70, "Text",
 CellID->18823],
Cell[61632, 2247, 2314, 72, 70, "DefinitionBox",
 CellID->14485],
Cell[63949, 2321, 73, 1, 70, "Caption",
 CellID->20556],
Cell[64025, 2324, 131, 4, 70, "MathCaption",
 CellID->23216],
Cell[CellGroupData[{
Cell[64181, 2332, 380, 13, 70, "Input",
 CellID->1626],
Cell[64564, 2347, 346, 13, 36, "Output",
 CellID->9357]
}, Open  ]],
Cell[64925, 2363, 238, 9, 70, "MathCaption",
 CellID->8526],
Cell[CellGroupData[{
Cell[65188, 2376, 115, 4, 70, "Input",
 CellID->13357],
Cell[65306, 2382, 156, 5, 36, "Output",
 CellID->29337]
}, Open  ]],
Cell[CellGroupData[{
Cell[65499, 2392, 72, 1, 70, "RelatedTutorialsSection",
 CellID->122719223],
Cell[65574, 2395, 175, 4, 70, "RelatedTutorials",
 CellID->91103315]
}, Open  ]]
}, Open  ]],
Cell[65776, 2403, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

