(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     26248,        948]
NotebookOptionsPosition[     20838,        778]
NotebookOutlinePosition[     23582,        849]
CellTagsIndexPosition[     23489,        843]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Patterns" :> 
          Documentation`HelpLookup["paclet:tutorial/PatternsOverview"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Patterns\"\>"}, "\<\"related tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Exp" :> Documentation`HelpLookup["paclet:ref/Exp"], "FreeQ" :> 
          Documentation`HelpLookup["paclet:ref/FreeQ"], "Log" :> 
          Documentation`HelpLookup["paclet:ref/Log"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Exp\"\>", 2->"\<\"FreeQ\"\>", 
       3->"\<\"Log\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["An Example: Defining Your Own Integration Function", "Title",
 CellTags->{"S2.3.14", "14.1"},
 CellID->23271],

Cell[TextData[{
 "Now that we have introduced the basic features of patterns in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", we can use them to give a more or less complete example. We will show how \
you could define your own simple integration function in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "."
}], "Text",
 CellID->23869],

Cell[TextData[{
 "From a mathematical point of view, the integration function is defined by a \
sequence of mathematical relations. By setting up transformation rules for \
patterns, you can implement these mathematical relations quite directly in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". "
}], "Text",
 CellID->29361],

Cell[BoxData[GridBox[{
   {Cell[TextData[StyleBox["mathematical form",
     FontSlant->"Italic"]], "TableText"], Cell[TextData[{
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " ",
     StyleBox["definition",
      FontSlant->"Italic"]
    }], "TableText"]},
   {Cell[TextData[Cell[BoxData[
     FormBox[
      RowBox[{
       RowBox[{"\[Integral]", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"y", "+", "z"}], ")"}], 
         RowBox[{"\[DifferentialD]", "x"}]}]}], "=", 
       RowBox[{
        RowBox[{"\[Integral]", 
         RowBox[{"y", 
          RowBox[{"\[DifferentialD]", "x"}]}]}], "+", 
        RowBox[{"\[Integral]", 
         RowBox[{"z", 
          RowBox[{"\[DifferentialD]", "x"}]}]}]}]}], TraditionalForm]], 
     "InlineMath"]], "TableText"], 
    RowBox[{
     RowBox[{
      StyleBox["integrate", "TI"], "[", 
      RowBox[{
       RowBox[{
        StyleBox["y_", "TI"], "+", 
        StyleBox["z_", "TI"]}], ",", 
       StyleBox["x_", "TI"]}], "]"}], ":=", 
     RowBox[{
      RowBox[{
       StyleBox["integrate", "TI"], "[", 
       RowBox[{
        StyleBox["y", "TI"], ",", 
        StyleBox["x", "TI"]}], "]"}], "+", 
      RowBox[{
       StyleBox["integrate", "TI"], "[", 
       RowBox[{
        StyleBox["z", "TI"], ",", 
        StyleBox["x", "TI"]}], "]"}]}]}]},
   {Cell[TextData[{
     Cell[BoxData[
      FormBox[
       RowBox[{
        RowBox[{"\[Integral]", 
         RowBox[{"c", "\[InvisibleSpace]", "y", 
          RowBox[{"\[DifferentialD]", "x"}]}]}], "=", 
        RowBox[{"c", 
         RowBox[{"\[Integral]", 
          RowBox[{"y", 
           RowBox[{"\[DifferentialD]", "x"}]}]}]}]}], TraditionalForm]], 
      "InlineMath"],
     " (",
     Cell[BoxData[
      FormBox["c", TraditionalForm]], "InlineMath"],
     " independent of ",
     Cell[BoxData[
      FormBox["x", TraditionalForm]], "InlineMath"],
     ")"
    }], "TableText"], 
    RowBox[{
     RowBox[{
      StyleBox["integrate", "TI"], "[", 
      RowBox[{
       RowBox[{
        StyleBox["c_y", "TI"], "_"}], ",", 
       StyleBox["x_", "TI"]}], "]"}], ":=", 
     RowBox[{
      RowBox[{
       StyleBox["c", "TI"], 
       StyleBox[" ", "TI"], 
       RowBox[{
        StyleBox["integrate", "TI"], "[", 
        RowBox[{
         StyleBox["y", "TI"], ",", 
         StyleBox["x", "TI"]}], "]"}]}], "/;", 
      RowBox[{
       ButtonBox["FreeQ",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/FreeQ"], "[", 
       RowBox[{
        StyleBox["c", "TI"], ",", 
        StyleBox["x", "TI"]}], "]"}]}]}]},
   {Cell[TextData[Cell[BoxData[
     FormBox[
      RowBox[{
       RowBox[{"\[Integral]", 
        RowBox[{"c", 
         RowBox[{"\[DifferentialD]", "x"}]}]}], "=", 
       RowBox[{"c", "\[InvisibleSpace]", "x"}]}], TraditionalForm]], 
     "InlineMath"]], "TableText"], 
    RowBox[{
     RowBox[{
      StyleBox["integrate", "TI"], "[", 
      RowBox[{
       StyleBox["c_", "TI"], ",", 
       StyleBox["x_", "TI"]}], "]"}], ":=", 
     RowBox[{
      StyleBox["cx", "TI"], "/;", 
      RowBox[{
       ButtonBox["FreeQ",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/FreeQ"], "[", 
       RowBox[{
        StyleBox["c", "TI"], ",", 
        StyleBox["x", "TI"]}], "]"}]}]}]},
   {Cell[TextData[{
     Cell[BoxData[
      FormBox[
       RowBox[{
        RowBox[{"\[Integral]", 
         RowBox[{
          SuperscriptBox["x", "n"], 
          RowBox[{"\[DifferentialD]", "x"}]}]}], "=", 
        FractionBox[
         SuperscriptBox["x", 
          RowBox[{"(", 
           RowBox[{"n", "+", "1"}], ")"}]], 
         RowBox[{"n", "+", "1"}]]}], TraditionalForm]], "InlineMath"],
     ", ",
     Cell[BoxData[
      FormBox[
       RowBox[{"n", "\[NotEqual]", 
        RowBox[{"-", "1"}]}], TraditionalForm]], "InlineMath"]
    }], "TableText"], 
    RowBox[{
     RowBox[{
      StyleBox["integrate", "TI"], "[", 
      RowBox[{
       RowBox[{
        StyleBox["x_", "TI"], "^", 
        StyleBox["n_.", "TI"]}], ",", 
       StyleBox["x_", "TI"]}], "]"}], ":=", 
     RowBox[{
      RowBox[{
       RowBox[{
        StyleBox["x", "TI"], "^", 
        RowBox[{"(", 
         RowBox[{
          StyleBox["n", "TI"], "+", "1"}], ")"}]}], "/", 
       RowBox[{"(", 
        RowBox[{
         StyleBox["n", "TI"], "+", "1"}], ")"}]}], "/;", 
      RowBox[{
       RowBox[{
        ButtonBox["FreeQ",
         BaseStyle->"Link",
         ButtonData->"paclet:ref/FreeQ"], "[", 
        RowBox[{
         StyleBox["n", "TI"], ",", 
         StyleBox["x", "TI"]}], "]"}], "&&", 
       RowBox[{
        StyleBox["n", "TI"], "!=", 
        RowBox[{"-", "1"}]}]}]}]}]},
   {Cell[TextData[Cell[BoxData[
     FormBox[
      RowBox[{
       RowBox[{"\[Integral]", 
        RowBox[{
         FractionBox["1", 
          RowBox[{"a", "x", "+", "b"}]], 
         RowBox[{"\[DifferentialD]", "x"}]}]}], "=", 
       FractionBox[
        RowBox[{"log", "(", 
         RowBox[{"a", "x", "+", "b"}], ")"}], "a"]}], TraditionalForm]], 
     "InlineMath"]], "TableText"], 
    RowBox[{
     RowBox[{
      StyleBox["integrate", "TI"], "[", 
      RowBox[{
       RowBox[{"1", "/", 
        RowBox[{"(", 
         RowBox[{
          StyleBox[
           RowBox[{"a_.", "x_"}], "TI"], "+", 
          StyleBox["b_.", "TI"]}], ")"}]}], ",", 
       StyleBox["x_", "TI"]}], "]"}], ":=", 
     RowBox[{
      RowBox[{
       RowBox[{
        ButtonBox["Log",
         BaseStyle->"Link",
         ButtonData->"paclet:ref/Log"], "[", 
        RowBox[{
         StyleBox["ax", "TI"], "+", 
         StyleBox["b", "TI"]}], "]"}], "/", 
       StyleBox["a", "TI"]}], "/;", 
      RowBox[{
       ButtonBox["FreeQ",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/FreeQ"], "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          StyleBox["a", "TI"], ",", 
          StyleBox["b", "TI"]}], "}"}], ",", 
        StyleBox["x", "TI"]}], "]"}]}]}]},
   {Cell[TextData[Cell[BoxData[
     FormBox[
      RowBox[{
       RowBox[{"\[Integral]", 
        RowBox[{
         SuperscriptBox["e", 
          RowBox[{"a", "x", "+", "b"}]], 
         RowBox[{"\[DifferentialD]", "x"}]}]}], "=", 
       RowBox[{
        FractionBox["1", "a"], " ", 
        SuperscriptBox["e", 
         RowBox[{"a", "x", "+", "b"}]]}]}], TraditionalForm]], "InlineMath"]],
      "TableText"], 
    RowBox[{
     RowBox[{
      StyleBox["integrate", "TI"], "[", 
      RowBox[{
       RowBox[{
        ButtonBox["Exp",
         BaseStyle->"Link",
         ButtonData->"paclet:ref/Exp"], "[", 
        RowBox[{
         StyleBox[
          RowBox[{"a_.", "x_"}], "TI"], "+", 
         StyleBox["b_.", "TI"]}], "]"}], ",", 
       StyleBox["x_", "TI"]}], "]"}], ":=", 
     RowBox[{
      RowBox[{
       RowBox[{
        ButtonBox["Exp",
         BaseStyle->"Link",
         ButtonData->"paclet:ref/Exp"], "[", 
        RowBox[{
         StyleBox["ax", "TI"], "+", 
         StyleBox["b", "TI"]}], "]"}], "/", 
       StyleBox["a", "TI"]}], "/;", 
      RowBox[{
       ButtonBox["FreeQ",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/FreeQ"], "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          StyleBox["a", "TI"], ",", 
          StyleBox["b", "TI"]}], "}"}], ",", 
        StyleBox["x", "TI"]}], "]"}]}]}]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, True, False, False, False, False, False, {False}, False},
    "RowsIndexed" -> {}}},
 CellID->2096742444],

Cell["Definitions for an integration function. ", "Caption",
 CellID->13022],

Cell[TextData[{
 "This implements the linearity relation for integrals: ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Integral]", 
    RowBox[{"(", 
     RowBox[{"y", "+", "z"}], ")"}], "\[DifferentialD]", "x", "=", 
    "\[Integral]", "y", "\[DifferentialD]", "x", "+", "\[Integral]", "z", 
    "\[DifferentialD]", "x"}], TraditionalForm]], "InlineMath"],
 ". "
}], "MathCaption",
 CellID->29617],

Cell[BoxData[
 RowBox[{
  RowBox[{"integrate", "[", 
   RowBox[{
    RowBox[{"y_", "+", "z_"}], ",", "x_"}], "]"}], ":=", 
  RowBox[{
   RowBox[{"integrate", "[", 
    RowBox[{"y", ",", "x"}], "]"}], "+", 
   RowBox[{"integrate", "[", 
    RowBox[{"z", ",", "x"}], "]"}]}]}]], "Input",
 CellLabel->"In[1]:= ",
 CellID->10112],

Cell[TextData[{
 "The associativity of ",
 Cell[BoxData[
  ButtonBox["Plus",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Plus"]], "InlineFormula"],
 " makes the linearity relation work with any number of terms in the sum. "
}], "MathCaption",
 CellID->12717],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"integrate", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"a", " ", "x"}], "+", 
    RowBox[{"b", " ", 
     RowBox[{"x", "^", "2"}]}], "+", "3"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[2]:= ",
 CellID->18696],

Cell[BoxData[
 RowBox[{
  RowBox[{"integrate", "[", 
   RowBox[{"3", ",", "x"}], "]"}], "+", 
  RowBox[{"integrate", "[", 
   RowBox[{
    RowBox[{"a", " ", "x"}], ",", "x"}], "]"}], "+", 
  RowBox[{"integrate", "[", 
   RowBox[{
    RowBox[{"b", " ", 
     SuperscriptBox["x", "2"]}], ",", "x"}], "]"}]}]], "Output",
 ImageSize->{362, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]= ",
 CellID->11585]
}, Open  ]],

Cell[TextData[{
 "This makes ",
 Cell[BoxData["integrate"], "InlineFormula"],
 " pull out factors that are independent of the integration variable ",
 Cell[BoxData["x"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->24041],

Cell[BoxData[
 RowBox[{
  RowBox[{"integrate", "[", 
   RowBox[{
    RowBox[{"c_", " ", "y_"}], ",", "x_"}], "]"}], ":=", 
  RowBox[{
   RowBox[{"c", " ", 
    RowBox[{"integrate", "[", 
     RowBox[{"y", ",", "x"}], "]"}]}], "/;", 
   RowBox[{"FreeQ", "[", 
    RowBox[{"c", ",", "x"}], "]"}]}]}]], "Input",
 CellLabel->"In[3]:= ",
 CellID->24423],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " tests each term in each product to see whether it satisfies the ",
 Cell[BoxData[
  ButtonBox["FreeQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FreeQ"]], "InlineFormula"],
 " condition, and so can be pulled out. "
}], "MathCaption",
 CellID->24129],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"integrate", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"a", " ", "x"}], "+", 
    RowBox[{"b", " ", 
     RowBox[{"x", "^", "2"}]}], "+", "3"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[4]:= ",
 CellID->24229],

Cell[BoxData[
 RowBox[{
  RowBox[{"integrate", "[", 
   RowBox[{"3", ",", "x"}], "]"}], "+", 
  RowBox[{"a", " ", 
   RowBox[{"integrate", "[", 
    RowBox[{"x", ",", "x"}], "]"}]}], "+", 
  RowBox[{"b", " ", 
   RowBox[{"integrate", "[", 
    RowBox[{
     SuperscriptBox["x", "2"], ",", "x"}], "]"}]}]}]], "Output",
 ImageSize->{362, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]= ",
 CellID->4565]
}, Open  ]],

Cell[TextData[{
 "This gives the integral ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Integral]", "c", "\[DifferentialD]", "x", "=", "c", " ", "x"}], 
   TraditionalForm]], "InlineMath"],
 " of a constant. "
}], "MathCaption",
 CellID->6559],

Cell[BoxData[
 RowBox[{
  RowBox[{"integrate", "[", 
   RowBox[{"c_", ",", "x_"}], "]"}], ":=", 
  RowBox[{
   RowBox[{"c", " ", "x"}], "/;", 
   RowBox[{"FreeQ", "[", 
    RowBox[{"c", ",", "x"}], "]"}]}]}]], "Input",
 CellLabel->"In[5]:= ",
 CellID->8932],

Cell["Now the constant term in the sum can be integrated. ", "MathCaption",
 CellID->22296],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"integrate", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"a", " ", "x"}], "+", 
    RowBox[{"b", " ", 
     RowBox[{"x", "^", "2"}]}], "+", "3"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[6]:= ",
 CellID->29855],

Cell[BoxData[
 RowBox[{
  RowBox[{"3", " ", "x"}], "+", 
  RowBox[{"a", " ", 
   RowBox[{"integrate", "[", 
    RowBox[{"x", ",", "x"}], "]"}]}], "+", 
  RowBox[{"b", " ", 
   RowBox[{"integrate", "[", 
    RowBox[{
     SuperscriptBox["x", "2"], ",", "x"}], "]"}]}]}]], "Output",
 ImageSize->{277, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]= ",
 CellID->12053]
}, Open  ]],

Cell[TextData[{
 "This gives the standard formula for the integral of ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["x", "n"], TraditionalForm]], "InlineMath"],
 ". By using the pattern ",
 Cell[BoxData[
  RowBox[{"x_", "^", "n_."}]], "InlineFormula"],
 ", rather than ",
 Cell[BoxData[
  RowBox[{"x_", "^", "n_"}]], "InlineFormula"],
 ", we include the case of ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox["x", "1"], "=", "x"}], TraditionalForm]], "InlineMath"],
 ". "
}], "MathCaption",
 CellID->16962],

Cell[BoxData[
 RowBox[{
  RowBox[{"integrate", "[", 
   RowBox[{
    RowBox[{"x_", "^", "n_."}], ",", "x_"}], "]"}], ":=", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", 
     RowBox[{"(", 
      RowBox[{"n", "+", "1"}], ")"}]}], "/", 
    RowBox[{"(", 
     RowBox[{"n", "+", "1"}], ")"}]}], "/;", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{"n", ",", "x"}], "]"}], "&&", 
    RowBox[{"n", "!=", 
     RowBox[{"-", "1"}]}]}]}]}]], "Input",
 CellLabel->"In[7]:= ",
 CellID->3584],

Cell["Now this integral can be done completely. ", "MathCaption",
 CellID->29734],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"integrate", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"a", " ", "x"}], "+", 
    RowBox[{"b", " ", 
     RowBox[{"x", "^", "2"}]}], "+", "3"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[8]:= ",
 CellID->6654],

Cell[BoxData[
 RowBox[{
  RowBox[{"3", " ", "x"}], "+", 
  FractionBox[
   RowBox[{"a", " ", 
    SuperscriptBox["x", "2"]}], "2"], "+", 
  FractionBox[
   RowBox[{"b", " ", 
    SuperscriptBox["x", "3"]}], "3"]}]], "Output",
 ImageSize->{100, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]= ",
 CellID->16972]
}, Open  ]],

Cell[TextData[{
 "Of course, the built\[Hyphen]in integration function ",
 Cell[BoxData[
  ButtonBox["Integrate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Integrate"]], "InlineFormula"],
 " (with a capital ",
 Cell[BoxData[
  ButtonBox["I",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/I"]], "InlineFormula"],
 ") could have done the integral anyway. "
}], "MathCaption",
 CellID->21457],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"a", " ", "x"}], "+", 
    RowBox[{"b", " ", 
     RowBox[{"x", "^", "2"}]}], "+", "3"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[9]:= ",
 CellID->14369],

Cell[BoxData[
 RowBox[{
  RowBox[{"3", " ", "x"}], "+", 
  FractionBox[
   RowBox[{"a", " ", 
    SuperscriptBox["x", "2"]}], "2"], "+", 
  FractionBox[
   RowBox[{"b", " ", 
    SuperscriptBox["x", "3"]}], "3"]}]], "Output",
 ImageSize->{100, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[9]= ",
 CellID->22532]
}, Open  ]],

Cell[TextData[{
 "Here is the rule for integrating the reciprocal of a linear function. The \
pattern ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"a_.", "x_"}], "+", "b_."}]], "InlineFormula"],
 " stands for any linear function of ",
 Cell[BoxData["x"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->2963],

Cell[BoxData[
 RowBox[{
  RowBox[{"integrate", "[", 
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"a_.", " ", "x_"}], "+", "b_."}], ")"}]}], ",", "x_"}], "]"}], 
  ":=", 
  RowBox[{
   RowBox[{
    RowBox[{"Log", "[", 
     RowBox[{
      RowBox[{"a", " ", "x"}], "+", "b"}], "]"}], "/", "a"}], "/;", 
   RowBox[{"FreeQ", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}]}]}]], "Input",
 CellLabel->"In[10]:= ",
 CellID->2607],

Cell[TextData[{
 "Here both ",
 Cell[BoxData["a"], "InlineFormula"],
 " and ",
 Cell[BoxData["b"], "InlineFormula"],
 " take on their default values. "
}], "MathCaption",
 CellID->2483],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"integrate", "[", 
  RowBox[{
   RowBox[{"1", "/", "x"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[11]:= ",
 CellID->911],

Cell[BoxData[
 RowBox[{"Log", "[", "x", "]"}]], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[11]= ",
 CellID->11635]
}, Open  ]],

Cell[TextData[{
 "Here is a more complicated case. The symbol ",
 Cell[BoxData["a"], "InlineFormula"],
 " now matches ",
 Cell[BoxData[
  RowBox[{"2", "p"}]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->10067],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"integrate", "[", 
  RowBox[{
   RowBox[{"1", "/", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"2", " ", "p", " ", "x"}], "-", "1"}], ")"}]}], ",", "x"}], 
  "]"}]], "Input",
 CellLabel->"In[12]:= ",
 CellID->22848],

Cell[BoxData[
 FractionBox[
  RowBox[{"Log", "[", 
   RowBox[{
    RowBox[{"-", "1"}], "+", 
    RowBox[{"2", " ", "p", " ", "x"}]}], "]"}], 
  RowBox[{"2", " ", "p"}]]], "Output",
 ImageSize->{98, 32},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[12]= ",
 CellID->4675]
}, Open  ]],

Cell["\<\
You can go on and add many more rules for integration. Here is a rule for \
integrating exponentials. \
\>", "MathCaption",
 CellID->12938],

Cell[BoxData[
 RowBox[{
  RowBox[{"integrate", "[", 
   RowBox[{
    RowBox[{"Exp", "[", 
     RowBox[{
      RowBox[{"a_.", " ", "x_"}], "+", "b_."}], "]"}], ",", "x_"}], "]"}], ":=",
   
  RowBox[{
   RowBox[{
    RowBox[{"Exp", "[", 
     RowBox[{
      RowBox[{"a", " ", "x"}], "+", "b"}], "]"}], "/", "a"}], "/;", 
   RowBox[{"FreeQ", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}]}]}]], "Input",
 CellLabel->"In[13]:= ",
 CellID->2223],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->273459389],

Cell[TextData[ButtonBox["Patterns",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/PatternsOverview"]], "RelatedTutorials",
 CellID->423797385]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"An Example: Defining Your Own Integration Function - Wolfram \
Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Patterns", "OverviewNavText"], BaseStyle -> "Link", 
        ButtonData -> "paclet:tutorial/PatternsOverview"]], "Text", 
      FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/PatternsForSomeCommonTypesOfExpression"]}], "Text", 
      FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 32, 36.9977774}", "context" -> "", 
    "keywords" -> {
     "custom integration", "extending integration", "mathematical relations", 
      "patterns", "simplification"}, "index" -> True, "label" -> 
    "Mathematica Tutorial", "language" -> "en", "paclet" -> "Mathematica", 
    "status" -> "None", "summary" -> 
    "Now that we have introduced the basic features of patterns in \
Mathematica, we can use them to give a more or less complete example. We will \
show how you could define your own simple integration function in \
Mathematica. From a mathematical point of view, the integration function is \
defined by a sequence of mathematical relations. By setting up transformation \
rules for patterns, you can implement these mathematical relations quite \
directly in Mathematica. Definitions for an integration function. ", 
    "synonyms" -> {"2.3.14"}, "title" -> 
    "An Example: Defining Your Own Integration Function", "type" -> 
    "Tutorial", "uri" -> 
    "tutorial/AnExampleDefiningYourOwnIntegrationFunction"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S2.3.14"->{
  Cell[1914, 59, 115, 2, 70, "Title",
   CellTags->{"S2.3.14", "14.1"},
   CellID->23271]},
 "14.1"->{
  Cell[1914, 59, 115, 2, 70, "Title",
   CellTags->{"S2.3.14", "14.1"},
   CellID->23271]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S2.3.14", 23271, 832},
 {"14.1", 23374, 836}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1289, 32, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1914, 59, 115, 2, 70, "Title",
 CellTags->{"S2.3.14", "14.1"},
 CellID->23271],
Cell[2032, 63, 353, 10, 70, "Text",
 CellID->23869],
Cell[2388, 75, 333, 8, 70, "Text",
 CellID->29361],
Cell[2724, 85, 7528, 253, 70, "DefinitionBox",
 CellID->2096742444],
Cell[10255, 340, 76, 1, 70, "Caption",
 CellID->13022],
Cell[10334, 343, 394, 11, 70, "MathCaption",
 CellID->29617],
Cell[10731, 356, 325, 11, 70, "Input",
 CellID->10112],
Cell[11059, 369, 263, 8, 70, "MathCaption",
 CellID->12717],
Cell[CellGroupData[{
Cell[11347, 381, 235, 8, 28, "Input",
 CellID->18696],
Cell[11585, 391, 445, 15, 39, "Output",
 CellID->11585]
}, Open  ]],
Cell[12045, 409, 228, 7, 70, "MathCaption",
 CellID->24041],
Cell[12276, 418, 348, 12, 70, "Input",
 CellID->24423],
Cell[12627, 432, 324, 10, 70, "MathCaption",
 CellID->24129],
Cell[CellGroupData[{
Cell[12976, 446, 235, 8, 70, "Input",
 CellID->24229],
Cell[13214, 456, 444, 15, 39, "Output",
 CellID->4565]
}, Open  ]],
Cell[13673, 474, 240, 8, 70, "MathCaption",
 CellID->6559],
Cell[13916, 484, 257, 9, 70, "Input",
 CellID->8932],
Cell[14176, 495, 91, 1, 70, "MathCaption",
 CellID->22296],
Cell[CellGroupData[{
Cell[14292, 500, 235, 8, 70, "Input",
 CellID->29855],
Cell[14530, 510, 408, 14, 39, "Output",
 CellID->12053]
}, Open  ]],
Cell[14953, 527, 520, 18, 70, "MathCaption",
 CellID->16962],
Cell[15476, 547, 487, 18, 70, "Input",
 CellID->3584],
Cell[15966, 567, 81, 1, 70, "MathCaption",
 CellID->29734],
Cell[CellGroupData[{
Cell[16072, 572, 234, 8, 70, "Input",
 CellID->6654],
Cell[16309, 582, 353, 13, 54, "Output",
 CellID->16972]
}, Open  ]],
Cell[16677, 598, 399, 13, 70, "MathCaption",
 CellID->21457],
Cell[CellGroupData[{
Cell[17101, 615, 235, 8, 70, "Input",
 CellID->14369],
Cell[17339, 625, 353, 13, 54, "Output",
 CellID->22532]
}, Open  ]],
Cell[17707, 641, 307, 10, 70, "MathCaption",
 CellID->2963],
Cell[18017, 653, 509, 19, 70, "Input",
 CellID->2607],
Cell[18529, 674, 185, 7, 70, "MathCaption",
 CellID->2483],
Cell[CellGroupData[{
Cell[18739, 685, 148, 5, 70, "Input",
 CellID->911],
Cell[18890, 692, 185, 6, 36, "Output",
 CellID->11635]
}, Open  ]],
Cell[19090, 701, 217, 8, 70, "MathCaption",
 CellID->10067],
Cell[CellGroupData[{
Cell[19332, 713, 241, 9, 70, "Input",
 CellID->22848],
Cell[19576, 724, 307, 11, 53, "Output",
 CellID->4675]
}, Open  ]],
Cell[19898, 738, 149, 4, 70, "MathCaption",
 CellID->12938],
Cell[20050, 744, 488, 18, 70, "Input",
 CellID->2223],
Cell[CellGroupData[{
Cell[20563, 766, 72, 1, 70, "RelatedTutorialsSection",
 CellID->273459389],
Cell[20638, 769, 146, 3, 70, "RelatedTutorials",
 CellID->423797385]
}, Open  ]]
}, Open  ]],
Cell[20811, 776, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

