(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     34702,       1227]
NotebookOptionsPosition[     27044,        981]
NotebookOutlinePosition[     30170,       1058]
CellTagsIndexPosition[     30077,       1052]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Functional Operations" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/FunctionalOperationsOverview"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Functional Operations\"\>"}, "\<\"related tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"All" :> Documentation`HelpLookup["paclet:ref/All"], 
          "FixedPoint" :> Documentation`HelpLookup["paclet:ref/FixedPoint"], 
          "FixedPointList" :> 
          Documentation`HelpLookup["paclet:ref/FixedPointList"], "Fold" :> 
          Documentation`HelpLookup["paclet:ref/Fold"], "FoldList" :> 
          Documentation`HelpLookup["paclet:ref/FoldList"], "Nest" :> 
          Documentation`HelpLookup["paclet:ref/Nest"], "NestList" :> 
          Documentation`HelpLookup["paclet:ref/NestList"], "NestWhile" :> 
          Documentation`HelpLookup["paclet:ref/NestWhile"], "NestWhileList" :> 
          Documentation`HelpLookup["paclet:ref/NestWhileList"], "True" :> 
          Documentation`HelpLookup["paclet:ref/True"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"All\"\>", 2->"\<\"FixedPoint\"\>", 
       3->"\<\"FixedPointList\"\>", 4->"\<\"Fold\"\>", 5->"\<\"FoldList\"\>", 
       6->"\<\"Nest\"\>", 7->"\<\"NestList\"\>", 8->"\<\"NestWhile\"\>", 
       9->"\<\"NestWhileList\"\>", 10->"\<\"True\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Applying Functions Repeatedly", "Title",
 CellTags->{"S2.2.2", "2.1"},
 CellID->23850],

Cell[TextData[{
 "Many programs you write will involve operations that need to be iterated \
several times. ",
 Cell[BoxData[
  ButtonBox["Nest",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Nest"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["NestList",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NestList"]], "InlineFormula"],
 " are powerful constructs for doing this. "
}], "Text",
 CellID->17398],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Nest",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Nest"], "[", 
     StyleBox["f", "TI"], ",", 
     StyleBox["x", "TI"], ",", 
     StyleBox["n", "TI"], "]"}], Cell[TextData[{
     "apply the function ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     " nested ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " times to ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["NestList",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/NestList"], "[", 
     StyleBox["f", "TI"], ",", 
     StyleBox["x", "TI"], ",", 
     StyleBox["n", "TI"], "]"}], Cell[TextData[{
     "generate the list ",
     Cell[BoxData[
      FormBox[
       RowBox[{"{", 
        RowBox[{"x", ",", 
         RowBox[{"f", "[", "x", "]"}], ",", 
         RowBox[{"f", "[", 
          RowBox[{"f", "[", "x", "]"}], "]"}], ",", "\[Ellipsis]"}], "}"}], 
       TraditionalForm]], "InlineMath"],
     ", where ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     " is nested up to ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " deep"
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->22279],

Cell["Applying functions of one argument repeatedly. ", "Caption",
 CellID->22701],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Nest",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Nest"], "[", 
   RowBox[{
    StyleBox["f", "TI"], ",", 
    StyleBox["x", "TI"], ",", 
    StyleBox["n", "TI"]}], "]"}]], "InlineFormula"],
 " takes the \[OpenCurlyDoubleQuote]name\[CloseCurlyDoubleQuote] ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 " of a function, and applies the function ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " times to ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->12193],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Nest", "[", 
  RowBox[{"f", ",", "x", ",", "4"}], "]"}]], "Input",
 CellLabel->"In[1]:= ",
 CellID->12734],

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{"f", "[", 
   RowBox[{"f", "[", 
    RowBox[{"f", "[", "x", "]"}], "]"}], "]"}], "]"}]], "Output",
 ImageSize->{95, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]= ",
 CellID->1637]
}, Open  ]],

Cell["This makes a list of each successive nesting. ", "MathCaption",
 CellID->26534],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NestList", "[", 
  RowBox[{"f", ",", "x", ",", "4"}], "]"}]], "Input",
 CellLabel->"In[2]:= ",
 CellID->5556],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", ",", 
   RowBox[{"f", "[", "x", "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{"f", "[", "x", "]"}], "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{"f", "[", 
     RowBox[{"f", "[", "x", "]"}], "]"}], "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{"f", "[", 
     RowBox[{"f", "[", 
      RowBox[{"f", "[", "x", "]"}], "]"}], "]"}], "]"}]}], "}"}]], "Output",
 ImageSize->{308, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]= ",
 CellID->1993]
}, Open  ]],

Cell["Here is a simple function. ", "MathCaption",
 CellID->10176],

Cell[BoxData[
 RowBox[{
  RowBox[{"recip", "[", "x_", "]"}], ":=", 
  RowBox[{"1", "/", 
   RowBox[{"(", 
    RowBox[{"1", "+", "x"}], ")"}]}]}]], "Input",
 CellLabel->"In[3]:= ",
 CellID->25705],

Cell[TextData[{
 "You can iterate the function using ",
 Cell[BoxData[
  ButtonBox["Nest",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Nest"]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->6962],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Nest", "[", 
  RowBox[{"recip", ",", "x", ",", "3"}], "]"}]], "Input",
 CellLabel->"In[4]:= ",
 CellID->10548],

Cell[BoxData[
 FractionBox["1", 
  RowBox[{"1", "+", 
   FractionBox["1", 
    RowBox[{"1", "+", 
     FractionBox["1", 
      RowBox[{"1", "+", "x"}]]}]]}]]], "Output",
 ImageSize->{60, 47},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]= ",
 CellID->15881]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Nest",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Nest"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["NestList",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NestList"]], "InlineFormula"],
 " allow you to apply functions a fixed number of times. Often you may want \
to apply functions until the result no longer changes. You can do this using \
",
 Cell[BoxData[
  ButtonBox["FixedPoint",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FixedPoint"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["FixedPointList",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FixedPointList"]], "InlineFormula"],
 "."
}], "Text",
 CellID->300],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["FixedPoint",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/FixedPoint"], "[", 
     StyleBox["f", "TI"], ",", 
     StyleBox["x", "TI"], "]"}], Cell[TextData[{
     "apply the function ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     " repeatedly until the result no longer changes"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["FixedPointList",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/FixedPointList"], "[", 
     StyleBox["f", "TI"], ",", 
     StyleBox["x", "TI"], "]"}], Cell[TextData[{
     "generate the list ",
     Cell[BoxData[
      FormBox[
       RowBox[{"{", 
        RowBox[{"x", ",", 
         RowBox[{"f", "[", "x", "]"}], ",", 
         RowBox[{"f", "[", 
          RowBox[{"f", "[", "x", "]"}], "]"}], ",", "\[Ellipsis]"}], "}"}], 
       TraditionalForm]], "InlineMath"],
     ", stopping when the elements no longer change"
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->14413],

Cell["Applying functions until the result no longer changes. ", "Caption",
 CellID->16641],

Cell[TextData[{
 "Here is a function that takes one step in Newton\[CloseCurlyQuote]s \
approximation to ",
 Cell[BoxData[
  FormBox[
   SqrtBox["3"], TraditionalForm]], "InlineMath"],
 ". "
}], "MathCaption",
 CellID->19855],

Cell[BoxData[
 RowBox[{
  RowBox[{"newton3", "[", "x_", "]"}], ":=", 
  RowBox[{"N", "[", 
   RowBox[{
    RowBox[{"1", "/", "2"}], " ", 
    RowBox[{"(", 
     RowBox[{"x", "+", 
      RowBox[{"3", "/", "x"}]}], ")"}]}], "]"}]}]], "Input",
 CellLabel->"In[5]:= ",
 CellID->24855],

Cell[TextData[{
 "Here are five successive iterates of the function, starting at ",
 Cell[BoxData[
  FormBox[
   RowBox[{"x", "=", "1"}], TraditionalForm]], "InlineMath"],
 ". "
}], "MathCaption",
 CellID->13142],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NestList", "[", 
  RowBox[{"newton3", ",", "1.0", ",", "5"}], "]"}]], "Input",
 CellLabel->"In[6]:= ",
 CellID->11462],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1.`", ",", "2.`", ",", "1.75`", ",", "1.7321428571428572`", ",", 
   "1.7320508100147274`", ",", "1.7320508075688774`"}], "}"}]], "Output",
 ImageSize->{277, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]= ",
 CellID->27611]
}, Open  ]],

Cell[TextData[{
 "Using the function ",
 Cell[BoxData[
  ButtonBox["FixedPoint",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FixedPoint"]], "InlineFormula"],
 ", you can automatically continue applying ",
 Cell[BoxData["newton3"], "InlineFormula"],
 " until the result no longer changes. "
}], "MathCaption",
 CellID->30877],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FixedPoint", "[", 
  RowBox[{"newton3", ",", "1.0"}], "]"}]], "Input",
 CellLabel->"In[7]:= ",
 CellID->20424],

Cell[BoxData["1.7320508075688772`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]= ",
 CellID->32678]
}, Open  ]],

Cell["Here is the sequence of results. ", "MathCaption",
 CellID->1752],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FixedPointList", "[", 
  RowBox[{"newton3", ",", "1.0"}], "]"}]], "Input",
 CellLabel->"In[8]:= ",
 CellID->18443],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1.`", ",", "2.`", ",", "1.75`", ",", "1.7321428571428572`", ",", 
   "1.7320508100147274`", ",", "1.7320508075688774`", ",", 
   "1.7320508075688772`"}], "}"}]], "Output",
 ImageSize->{338, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]= ",
 CellID->28296]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["NestWhile",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/NestWhile"], "[", 
     StyleBox["f", "TI"], ",", 
     StyleBox["x", "TI"], ",", 
     StyleBox["test", "TI"], "]"}], Cell[TextData[{
     "apply the function ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     " repeatedly until applying ",
     Cell[BoxData[
      StyleBox["test", "TI"]], "InlineFormula"],
     " to the result no longer yields ",
     Cell[BoxData[
      ButtonBox["True",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/True"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["NestWhileList",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/NestWhileList"], "[", 
     StyleBox["f", "TI"], ",", 
     StyleBox["x", "TI"], ",", 
     StyleBox["test", "TI"], "]"}], Cell[TextData[{
     "generate the list ",
     Cell[BoxData[
      FormBox[
       RowBox[{"{", 
        RowBox[{"x", ",", 
         RowBox[{"f", "[", "x", "]"}], ",", 
         RowBox[{"f", "[", 
          RowBox[{"f", "[", "x", "]"}], "]"}], ",", "\[Ellipsis]"}], "}"}], 
       TraditionalForm]], "InlineMath"],
     ", stopping when applying ",
     Cell[BoxData[
      StyleBox["test", "TI"]], "InlineFormula"],
     " to the result no longer yields ",
     Cell[BoxData[
      ButtonBox["True",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/True"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["NestWhile",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/NestWhile"], "[", 
     StyleBox["f", "TI"], ",", 
     StyleBox["x", "TI"], ",", 
     StyleBox["test", "TI"], ",", 
     StyleBox["m", "TI"], "]", Cell[", \[ThinSpace]", "TableText"], 
     ButtonBox["NestWhileList",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/NestWhileList"], "[", 
     StyleBox["f", "TI"], ",", 
     StyleBox["x", "TI"], ",", 
     StyleBox["test", "TI"], ",", 
     StyleBox["m", "TI"], "]"}], "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "supply the ",
     Cell[BoxData[
      StyleBox["m", "TI"]], "InlineFormula"],
     " most recent results as arguments for ",
     Cell[BoxData[
      StyleBox["test", "TI"]], "InlineFormula"],
     " at each step"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["NestWhile",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/NestWhile"], "[", 
     StyleBox["f", "TI"], ",", 
     StyleBox["x", "TI"], ",", 
     StyleBox["test", "TI"], ",", 
     ButtonBox["All",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/All"], "]", Cell[", \[ThinSpace]", "TableText"],
      
     ButtonBox["NestWhileList",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/NestWhileList"], "[", 
     StyleBox["f", "TI"], ",", 
     StyleBox["x", "TI"], ",", 
     StyleBox["test", "TI"], ",", 
     ButtonBox["All",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/All"], "]"}], "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "supply all results so far as arguments for ",
     Cell[BoxData[
      StyleBox["test", "TI"]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, False, False, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {18, {
      Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->12673],

Cell["Applying functions repeatedly until a test fails. ", "Caption",
 CellID->10040],

Cell["Here is a function which divides a number by 2. ", "MathCaption",
 CellID->9313],

Cell[BoxData[
 RowBox[{
  RowBox[{"divide2", "[", "n_", "]"}], ":=", 
  RowBox[{"n", "/", "2"}]}]], "Input",
 CellLabel->"In[9]:= ",
 CellID->875],

Cell[TextData[{
 "This repeatedly applies ",
 Cell[BoxData["divide2"], "InlineFormula"],
 " until the result is no longer an even number. "
}], "MathCaption",
 CellID->20072],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NestWhileList", "[", 
  RowBox[{"divide2", ",", "123456", ",", "EvenQ"}], "]"}]], "Input",
 CellLabel->"In[10]:= ",
 CellID->12818],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "123456", ",", "61728", ",", "30864", ",", "15432", ",", "7716", ",", 
   "3858", ",", "1929"}], "}"}]], "Output",
 ImageSize->{325, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[10]= ",
 CellID->610]
}, Open  ]],

Cell[TextData[{
 "This repeatedly applies ",
 Cell[BoxData["newton3"], "InlineFormula"],
 ", stopping when two successive results are no longer considered unequal, \
just as in ",
 Cell[BoxData[
  ButtonBox["FixedPointList",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FixedPointList"]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->1017],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NestWhileList", "[", 
  RowBox[{"newton3", ",", "1.0", ",", "Unequal", ",", "2"}], "]"}]], "Input",
 CellLabel->"In[11]:= ",
 CellID->14932],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1.`", ",", "2.`", ",", "1.75`", ",", "1.7321428571428572`", ",", 
   "1.7320508100147274`", ",", "1.7320508075688774`", ",", 
   "1.7320508075688772`"}], "}"}]], "Output",
 ImageSize->{338, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[11]= ",
 CellID->28112]
}, Open  ]],

Cell["\<\
This goes on until the first time a result that has been seen before \
reappears. \
\>", "MathCaption",
 CellID->30695],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NestWhileList", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Mod", "[", 
     RowBox[{
      RowBox[{"5", "#"}], ",", "7"}], "]"}], "&"}], ",", "1", ",", "Unequal", 
   ",", "All"}], "]"}]], "Input",
 CellLabel->"In[12]:= ",
 CellID->13169],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "5", ",", "4", ",", "6", ",", "2", ",", "3", ",", "1"}], 
  "}"}]], "Output",
 ImageSize->{135, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[12]= ",
 CellID->23831]
}, Open  ]],

Cell[TextData[{
 "Operations such as ",
 Cell[BoxData[
  ButtonBox["Nest",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Nest"]], "InlineFormula"],
 " take a function ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 " of one argument, and apply it repeatedly. At each step, they use the \
result of the previous step as the new argument of ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 ". "
}], "Text",
 CellID->20040],

Cell["\<\
It is important to generalize this notion to functions of two arguments. You \
can again apply the function repeatedly, but now each result you get supplies \
only one of the new arguments you need. A convenient approach is to get the \
other argument at each step from the successive elements of a\
\[NonBreakingSpace]list. \
\>", "Text",
 CellID->26488],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["FoldList",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/FoldList"], "[", 
     StyleBox["f", "TI"], ",", 
     StyleBox["x", "TI"], ",", "{", 
     StyleBox["a", "TI"], ",", 
     StyleBox["b", "TI"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "}", "]"}], Cell[TextData[{
     "create the list ",
     Cell[BoxData[
      FormBox[
       RowBox[{"{", 
        RowBox[{"x", ",", 
         RowBox[{"f", "[", 
          RowBox[{"x", ",", "a"}], "]"}], ",", 
         RowBox[{"f", "[", 
          RowBox[{
           RowBox[{"f", "[", 
            RowBox[{"x", ",", "a"}], "]"}], ",", "b"}], "]"}], ",", 
         "\[Ellipsis]"}], "}"}], TraditionalForm]], "InlineMath"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Fold",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Fold"], "[", 
     StyleBox["f", "TI"], ",", 
     StyleBox["x", "TI"], ",", "{", 
     StyleBox["a", "TI"], ",", 
     StyleBox["b", "TI"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "}", "]"}], Cell[TextData[{
     "give the last element of the list produced by ",
     Cell[BoxData[
      RowBox[{
       ButtonBox["FoldList",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/FoldList"], "[", 
       StyleBox["f", "TI"], ",", 
       StyleBox["x", "TI"], ",", "{", 
       StyleBox["a", "TI"], ",", 
       StyleBox["b", "TI"], ",", 
       StyleBox["\[Ellipsis]", "TR"], "}", "]"}]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->28685],

Cell["Ways to repeatedly apply functions of two arguments. ", "Caption",
 CellID->19090],

Cell[TextData[{
 "Here is an example of what ",
 Cell[BoxData[
  ButtonBox["FoldList",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FoldList"]], "InlineFormula"],
 " does. "
}], "MathCaption",
 CellID->19497],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FoldList", "[", 
  RowBox[{"f", ",", "x", ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[13]:= ",
 CellID->2589],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", ",", 
   RowBox[{"f", "[", 
    RowBox[{"x", ",", "a"}], "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{
     RowBox[{"f", "[", 
      RowBox[{"x", ",", "a"}], "]"}], ",", "b"}], "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{
     RowBox[{"f", "[", 
      RowBox[{
       RowBox[{"f", "[", 
        RowBox[{"x", ",", "a"}], "]"}], ",", "b"}], "]"}], ",", "c"}], 
    "]"}]}], "}"}]], "Output",
 ImageSize->{315, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[13]= ",
 CellID->25990]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Fold",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Fold"]], "InlineFormula"],
 " gives the last element of the list produced by ",
 Cell[BoxData[
  ButtonBox["FoldList",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FoldList"]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->15145],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Fold", "[", 
  RowBox[{"f", ",", "x", ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[14]:= ",
 CellID->19353],

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{
     RowBox[{"f", "[", 
      RowBox[{"x", ",", "a"}], "]"}], ",", "b"}], "]"}], ",", "c"}], 
  "]"}]], "Output",
 ImageSize->{129, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[14]= ",
 CellID->19314]
}, Open  ]],

Cell["This gives a list of cumulative sums. ", "MathCaption",
 CellID->18651],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FoldList", "[", 
  RowBox[{"Plus", ",", "0", ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[15]:= ",
 CellID->26740],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "a", ",", 
   RowBox[{"a", "+", "b"}], ",", 
   RowBox[{"a", "+", "b", "+", "c"}]}], "}"}]], "Output",
 ImageSize->{139, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[15]= ",
 CellID->22044]
}, Open  ]],

Cell[TextData[{
 "Using ",
 Cell[BoxData[
  ButtonBox["Fold",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Fold"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["FoldList",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FoldList"]], "InlineFormula"],
 " you can write many elegant and efficient programs in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". In some cases, you may find it helpful to think of ",
 Cell[BoxData[
  ButtonBox["Fold",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Fold"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["FoldList",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FoldList"]], "InlineFormula"],
 " as producing a simple nesting of a family of functions indexed by their \
second argument. "
}], "Text",
 CellID->11258],

Cell[TextData[{
 "This defines a function ",
 Cell[BoxData["nextdigit"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->335],

Cell[BoxData[
 RowBox[{
  RowBox[{"nextdigit", "[", 
   RowBox[{"a_", ",", "b_"}], "]"}], ":=", 
  RowBox[{
   RowBox[{"10", " ", "a"}], "+", "b"}]}]], "Input",
 CellLabel->"In[16]:= ",
 CellID->8759],

Cell[TextData[{
 "This is now like the built\[Hyphen]in function ",
 Cell[BoxData[
  ButtonBox["FromDigits",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FromDigits"]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->11192],

Cell[BoxData[
 RowBox[{
  RowBox[{"fromdigits", "[", "digits_", "]"}], ":=", 
  RowBox[{"Fold", "[", 
   RowBox[{"nextdigit", ",", "0", ",", "digits"}], "]"}]}]], "Input",
 CellLabel->"In[17]:= ",
 CellID->7605],

Cell["Here is an example of the function in action. ", "MathCaption",
 CellID->25264],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"fromdigits", "[", 
  RowBox[{"{", 
   RowBox[{"1", ",", "3", ",", "7", ",", "2", ",", "9", ",", "1"}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[18]:= ",
 CellID->12181],

Cell[BoxData["137291"], "Output",
 ImageSize->{49, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[18]= ",
 CellID->28503]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->49461981],

Cell[TextData[ButtonBox["Functional Operations",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/FunctionalOperationsOverview"]], "RelatedTutorials",
 CellID->222363673]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED WOLFRAM EDUCATION GROUP COURSES", "TutorialRelatedLinksSection",
 CellID->165329949],

Cell[TextData[{
 ButtonBox["M101: A First Course in ",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolfram.com/services/education/courses/m101.html"], 
    None}],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolfram.com/services/education/courses/m101.html"], 
    None}],
  FontSlant->"Italic"]
}], "TutorialRelatedLinks",
 CellID->337406942],

Cell[TextData[{
 ButtonBox["M221: Introduction to Programming in ",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolfram.com/services/education/courses/m221.html"], 
    None}],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolfram.com/services/education/courses/m221.html"], 
    None}],
  FontSlant->"Italic"]
}], "TutorialRelatedLinks",
 CellID->115487804]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Applying Functions Repeatedly - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Functional Operations", "OverviewNavText"], BaseStyle -> 
        "Link", ButtonData -> 
        "paclet:tutorial/FunctionalOperationsOverview"]], "Text", FontFamily -> 
      "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/FunctionNamesAsExpressions"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/ApplyingFunctionsToListsAndOtherExpressions"]}], 
      "Text", FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 32, 44.4042170}", "context" -> "", 
    "keywords" -> {
     "accumulate", "binary operators", "cascade", "composition", 
      "continued fractions", "cumulative sums", "cycle detection", 
      "FixedPoint", "FixedPointList", "fold", "FoldList", 
      "functional composition", "functions", "iterated functions", 
      "iteration", "least fixed point", "mu operator", "nest", "NestList", 
      "NestWhile", "NestWhileList", "newtons approximation", 
      "prefix operation", "repetitive operations", "Unary operators", "until",
       "while"}, "index" -> True, "label" -> "Mathematica Tutorial", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "Many programs you write will involve operations that need to be iterated \
several times. Nest and NestList are powerful constructs for doing this. \
Applying functions of one argument repeatedly. Nest[f,x,n] takes the 'name' f \
of a function, and applies the function n times to x. ", 
    "synonyms" -> {"2.2.2"}, "title" -> "Applying Functions Repeatedly", 
    "type" -> "Tutorial", "uri" -> "tutorial/ApplyingFunctionsRepeatedly"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S2.2.2"->{
  Cell[2700, 70, 92, 2, 70, "Title",
   CellTags->{"S2.2.2", "2.1"},
   CellID->23850]},
 "2.1"->{
  Cell[2700, 70, 92, 2, 70, "Title",
   CellTags->{"S2.2.2", "2.1"},
   CellID->23850]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S2.2.2", 29866, 1041},
 {"2.1", 29965, 1045}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 2075, 43, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2700, 70, 92, 2, 70, "Title",
 CellTags->{"S2.2.2", "2.1"},
 CellID->23850],
Cell[2795, 74, 423, 14, 70, "Text",
 CellID->17398],
Cell[3221, 90, 1579, 52, 70, "DefinitionBox",
 CellID->22279],
Cell[4803, 144, 82, 1, 70, "Caption",
 CellID->22701],
Cell[4888, 147, 595, 21, 70, "MathCaption",
 CellID->12193],
Cell[CellGroupData[{
Cell[5508, 172, 130, 4, 28, "Input",
 CellID->12734],
Cell[5641, 178, 268, 9, 36, "Output",
 CellID->1637]
}, Open  ]],
Cell[5924, 190, 85, 1, 70, "MathCaption",
 CellID->26534],
Cell[CellGroupData[{
Cell[6034, 195, 133, 4, 28, "Input",
 CellID->5556],
Cell[6170, 201, 530, 17, 36, "Output",
 CellID->1993]
}, Open  ]],
Cell[6715, 221, 66, 1, 70, "MathCaption",
 CellID->10176],
Cell[6784, 224, 195, 7, 70, "Input",
 CellID->25705],
Cell[6982, 233, 206, 8, 70, "MathCaption",
 CellID->6962],
Cell[CellGroupData[{
Cell[7213, 245, 134, 4, 70, "Input",
 CellID->10548],
Cell[7350, 251, 296, 11, 68, "Output",
 CellID->15881]
}, Open  ]],
Cell[7661, 265, 710, 24, 70, "Text",
 CellID->300],
Cell[8374, 291, 1295, 39, 70, "DefinitionBox",
 CellID->14413],
Cell[9672, 332, 90, 1, 70, "Caption",
 CellID->16641],
Cell[9765, 335, 225, 8, 70, "MathCaption",
 CellID->19855],
Cell[9993, 345, 280, 10, 70, "Input",
 CellID->24855],
Cell[10276, 357, 212, 7, 70, "MathCaption",
 CellID->13142],
Cell[CellGroupData[{
Cell[10513, 368, 142, 4, 70, "Input",
 CellID->11462],
Cell[10658, 374, 310, 9, 36, "Output",
 CellID->27611]
}, Open  ]],
Cell[10983, 386, 329, 10, 70, "MathCaption",
 CellID->30877],
Cell[CellGroupData[{
Cell[11337, 400, 134, 4, 70, "Input",
 CellID->20424],
Cell[11474, 406, 173, 5, 36, "Output",
 CellID->32678]
}, Open  ]],
Cell[11662, 414, 71, 1, 70, "MathCaption",
 CellID->1752],
Cell[CellGroupData[{
Cell[11758, 419, 138, 4, 70, "Input",
 CellID->18443],
Cell[11899, 425, 342, 10, 36, "Output",
 CellID->28296]
}, Open  ]],
Cell[12256, 438, 3624, 110, 70, "DefinitionBox",
 CellID->12673],
Cell[15883, 550, 85, 1, 70, "Caption",
 CellID->10040],
Cell[15971, 553, 86, 1, 70, "MathCaption",
 CellID->9313],
Cell[16060, 556, 146, 5, 70, "Input",
 CellID->875],
Cell[16209, 563, 174, 5, 70, "MathCaption",
 CellID->20072],
Cell[CellGroupData[{
Cell[16408, 572, 155, 4, 70, "Input",
 CellID->12818],
Cell[16566, 578, 283, 9, 36, "Output",
 CellID->610]
}, Open  ]],
Cell[16864, 590, 350, 11, 70, "MathCaption",
 CellID->1017],
Cell[CellGroupData[{
Cell[17239, 605, 164, 4, 70, "Input",
 CellID->14932],
Cell[17406, 611, 343, 10, 36, "Output",
 CellID->28112]
}, Open  ]],
Cell[17764, 624, 129, 4, 70, "MathCaption",
 CellID->30695],
Cell[CellGroupData[{
Cell[17918, 632, 261, 9, 70, "Input",
 CellID->13169],
Cell[18182, 643, 255, 8, 36, "Output",
 CellID->23831]
}, Open  ]],
Cell[18452, 654, 448, 15, 70, "Text",
 CellID->20040],
Cell[18903, 671, 365, 7, 70, "Text",
 CellID->26488],
Cell[19271, 680, 1802, 54, 70, "DefinitionBox",
 CellID->28685],
Cell[21076, 736, 88, 1, 70, "Caption",
 CellID->19090],
Cell[21167, 739, 212, 8, 70, "MathCaption",
 CellID->19497],
Cell[CellGroupData[{
Cell[21404, 751, 193, 6, 70, "Input",
 CellID->2589],
Cell[21600, 759, 567, 20, 36, "Output",
 CellID->25990]
}, Open  ]],
Cell[22182, 782, 339, 12, 70, "MathCaption",
 CellID->15145],
Cell[CellGroupData[{
Cell[22546, 798, 190, 6, 70, "Input",
 CellID->19353],
Cell[22739, 806, 322, 12, 36, "Output",
 CellID->19314]
}, Open  ]],
Cell[23076, 821, 77, 1, 70, "MathCaption",
 CellID->18651],
Cell[CellGroupData[{
Cell[23178, 826, 197, 6, 70, "Input",
 CellID->26740],
Cell[23378, 834, 280, 9, 36, "Output",
 CellID->22044]
}, Open  ]],
Cell[23673, 846, 796, 27, 70, "Text",
 CellID->11258],
Cell[24472, 875, 129, 5, 70, "MathCaption",
 CellID->335],
Cell[24604, 882, 200, 7, 70, "Input",
 CellID->8759],
Cell[24807, 891, 231, 8, 70, "MathCaption",
 CellID->11192],
Cell[25041, 901, 211, 6, 70, "Input",
 CellID->7605],
Cell[25255, 909, 85, 1, 70, "MathCaption",
 CellID->25264],
Cell[CellGroupData[{
Cell[25365, 914, 194, 6, 70, "Input",
 CellID->12181],
Cell[25562, 922, 161, 5, 36, "Output",
 CellID->28503]
}, Open  ]],
Cell[CellGroupData[{
Cell[25760, 932, 71, 1, 70, "RelatedTutorialsSection",
 CellID->49461981],
Cell[25834, 935, 174, 4, 70, "RelatedTutorials",
 CellID->222363673]
}, Open  ]],
Cell[CellGroupData[{
Cell[26045, 944, 98, 1, 70, "TutorialRelatedLinksSection",
 CellID->165329949],
Cell[26146, 947, 414, 13, 70, "TutorialRelatedLinks",
 CellID->337406942],
Cell[26563, 962, 427, 13, 70, "TutorialRelatedLinks",
 CellID->115487804]
}, Open  ]]
}, Open  ]],
Cell[27017, 979, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

