(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     46786,       1781]
NotebookOptionsPosition[     36886,       1444]
NotebookOutlinePosition[     40009,       1522]
CellTagsIndexPosition[     39916,       1516]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Functional Operations" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/FunctionalOperationsOverview"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Functional Operations\"\>"}, "\<\"related tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Map" :> Documentation`HelpLookup["paclet:ref/Map"], "MapAll" :> 
          Documentation`HelpLookup["paclet:ref/MapAll"], "MapAt" :> 
          Documentation`HelpLookup["paclet:ref/MapAt"], "MapIndexed" :> 
          Documentation`HelpLookup["paclet:ref/MapIndexed"], "MapThread" :> 
          Documentation`HelpLookup["paclet:ref/MapThread"], "Scan" :> 
          Documentation`HelpLookup["paclet:ref/Scan"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Map\"\>", 2->"\<\"MapAll\"\>", 
       3->"\<\"MapAt\"\>", 4->"\<\"MapIndexed\"\>", 5->"\<\"MapThread\"\>", 
       6->"\<\"Scan\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Applying Functions to Parts of Expressions", "Title",
 CellTags->{"S2.2.4", "4.1"},
 CellID->28027],

Cell[TextData[{
 "If you have a list of elements, it is often important to be able to apply a \
function separately to each of the elements. You can do this in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " using ",
 Cell[BoxData[
  ButtonBox["Map",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Map"]], "InlineFormula"],
 ". "
}], "Text",
 CellID->4084],

Cell[TextData[{
 "This applies ",
 Cell[BoxData["f"], "InlineFormula"],
 " separately to each element in a list. "
}], "MathCaption",
 CellID->10075],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Map", "[", 
  RowBox[{"f", ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:= ",
 CellID->18786],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"f", "[", "a", "]"}], ",", 
   RowBox[{"f", "[", "b", "]"}], ",", 
   RowBox[{"f", "[", "c", "]"}]}], "}"}]], "Output",
 ImageSize->{125, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]= ",
 CellID->15498]
}, Open  ]],

Cell["\<\
This defines a function which takes the first two elements from a list. \
\>", "MathCaption",
 CellID->24970],

Cell[BoxData[
 RowBox[{
  RowBox[{"take2", "[", "list_", "]"}], ":=", 
  RowBox[{"Take", "[", 
   RowBox[{"list", ",", "2"}], "]"}]}]], "Input",
 CellLabel->"In[2]:= ",
 CellID->6287],

Cell[TextData[{
 "You can use ",
 Cell[BoxData[
  ButtonBox["Map",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Map"]], "InlineFormula"],
 " to apply ",
 Cell[BoxData["take2"], "InlineFormula"],
 " to each element of a list. "
}], "MathCaption",
 CellID->23847],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Map", "[", 
  RowBox[{"take2", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "3", ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"5", ",", "6", ",", "7"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "1", ",", "6", ",", "6"}], "}"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[3]:= ",
 CellID->32604],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "6"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "1"}], "}"}]}], "}"}]], "Output",
 ImageSize->{158, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]= ",
 CellID->503]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Map",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Map"], "[", 
     StyleBox["f", "TI"], ",", "{", 
     StyleBox["a", "TI"], ",", 
     StyleBox["b", "TI"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "}", "]"}], Cell[TextData[{
     "apply ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     " to each element in a list, giving ",
     Cell[BoxData[
      FormBox[
       RowBox[{"{", 
        RowBox[{
         RowBox[{"f", "[", "a", "]"}], ",", 
         RowBox[{"f", "[", "b", "]"}], ",", "\[Ellipsis]"}], "}"}], 
       TraditionalForm]], "InlineMath"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {False, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->21221],

Cell["Applying a function to each element in a list. ", "Caption",
 CellID->22663],

Cell[TextData[{
 "What ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Map",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Map"], "[", 
   RowBox[{
    StyleBox["f", "TI"], ",", 
    StyleBox["expr", "TI"]}], "]"}]], "InlineFormula"],
 " effectively does is to \[OpenCurlyDoubleQuote]wrap\[CloseCurlyDoubleQuote] \
the function ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 " around each element of the expression ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 ". You can use ",
 Cell[BoxData[
  ButtonBox["Map",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Map"]], "InlineFormula"],
 " on any expression, not just a list. "
}], "Text",
 CellID->5706],

Cell[TextData[{
 "This applies ",
 Cell[BoxData["f"], "InlineFormula"],
 " to each element in the sum. "
}], "MathCaption",
 CellID->2363],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Map", "[", 
  RowBox[{"f", ",", 
   RowBox[{"a", "+", "b", "+", "c"}]}], "]"}]], "Input",
 CellLabel->"In[4]:= ",
 CellID->9010],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", "a", "]"}], "+", 
  RowBox[{"f", "[", "b", "]"}], "+", 
  RowBox[{"f", "[", "c", "]"}]}]], "Output",
 ImageSize->{114, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]= ",
 CellID->22171]
}, Open  ]],

Cell[TextData[{
 "This applies ",
 Cell[BoxData[
  ButtonBox["Sqrt",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sqrt"]], "InlineFormula"],
 " to each argument of\[NonBreakingSpace]",
 Cell[BoxData["g"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->27489],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Map", "[", 
  RowBox[{"Sqrt", ",", 
   RowBox[{"g", "[", 
    RowBox[{
     RowBox[{"x", "^", "2"}], ",", 
     RowBox[{"x", "^", "3"}]}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[5]:= ",
 CellID->18240],

Cell[BoxData[
 RowBox[{"g", "[", 
  RowBox[{
   SqrtBox[
    SuperscriptBox["x", "2"]], ",", 
   SqrtBox[
    SuperscriptBox["x", "3"]]}], "]"}]], "Output",
 ImageSize->{99, 27},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]= ",
 CellID->12164]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Map",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Map"], "[", 
   RowBox[{
    StyleBox["f", "TI"], ",", 
    StyleBox["expr", "TI"]}], "]"}]], "InlineFormula"],
 " applies ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 " to the first level of parts in ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 ". You can use ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["MapAll",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MapAll"], "[", 
   RowBox[{
    StyleBox["f", "TI"], ",", 
    StyleBox["expr", "TI"]}], "]"}]], "InlineFormula"],
 " to apply ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 " to ",
 StyleBox["all",
  FontSlant->"Italic"],
 " the parts of ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 "."
}], "Text",
 CellID->25542],

Cell[TextData[{
 "This defines a 2x2 matrix ",
 Cell[BoxData["m"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->7619],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"m", "=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"a", ",", "b"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"c", ",", "d"}], "}"}]}], "}"}]}]], "Input",
 CellLabel->"In[6]:= ",
 CellID->20913],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"c", ",", "d"}], "}"}]}], "}"}]], "Output",
 ImageSize->{108, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]= ",
 CellID->7591]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Map",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Map"]], "InlineFormula"],
 " applies ",
 Cell[BoxData["f"], "InlineFormula"],
 " to the first level of ",
 Cell[BoxData["m"], "InlineFormula"],
 ", in this case the rows of the matrix. "
}], "MathCaption",
 CellID->6704],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Map", "[", 
  RowBox[{"f", ",", "m"}], "]"}]], "Input",
 CellLabel->"In[7]:= ",
 CellID->31818],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"{", 
     RowBox[{"a", ",", "b"}], "}"}], "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{"{", 
     RowBox[{"c", ",", "d"}], "}"}], "]"}]}], "}"}]], "Output",
 ImageSize->{150, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]= ",
 CellID->9232]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["MapAll",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MapAll"]], "InlineFormula"],
 " applies ",
 Cell[BoxData["f"], "InlineFormula"],
 " at ",
 StyleBox["all",
  FontSlant->"Italic"],
 " levels in ",
 Cell[BoxData["m"], "InlineFormula"],
 ". If you look carefully at this expression, you will see an ",
 Cell[BoxData["f"], "InlineFormula"],
 " wrapped around every part. "
}], "MathCaption",
 CellID->750],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MapAll", "[", 
  RowBox[{"f", ",", "m"}], "]"}]], "Input",
 CellLabel->"In[8]:= ",
 CellID->25205],

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"f", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"f", "[", "a", "]"}], ",", 
       RowBox[{"f", "[", "b", "]"}]}], "}"}], "]"}], ",", 
    RowBox[{"f", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"f", "[", "c", "]"}], ",", 
       RowBox[{"f", "[", "d", "]"}]}], "}"}], "]"}]}], "}"}], "]"}]], "Output",\

 ImageSize->{255, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]= ",
 CellID->4975]
}, Open  ]],

Cell[TextData[{
 "In general, you can use level specifications as described in\
\[NonBreakingSpace]\"",
 ButtonBox["Levels in Expressions\"",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/LevelsInExpressions"],
 " to tell ",
 Cell[BoxData[
  ButtonBox["Map",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Map"]], "InlineFormula"],
 " to which parts of an expression to apply your function. "
}], "Text",
 CellID->1539],

Cell[TextData[{
 "This applies ",
 Cell[BoxData["f"], "InlineFormula"],
 " only to the parts of ",
 Cell[BoxData["m"], "InlineFormula"],
 " at level 2. "
}], "MathCaption",
 CellID->303],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Map", "[", 
  RowBox[{"f", ",", "m", ",", 
   RowBox[{"{", "2", "}"}]}], "]"}]], "Input",
 CellLabel->"In[9]:= ",
 CellID->11422],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"f", "[", "a", "]"}], ",", 
     RowBox[{"f", "[", "b", "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"f", "[", "c", "]"}], ",", 
     RowBox[{"f", "[", "d", "]"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{192, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[9]= ",
 CellID->21098]
}, Open  ]],

Cell[TextData[{
 "Setting the option ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Heads",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Heads"], "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 " wraps ",
 Cell[BoxData["f"], "InlineFormula"],
 " around the head of each part, as well as its elements. "
}], "MathCaption",
 CellID->11247],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Map", "[", 
  RowBox[{"f", ",", "m", ",", 
   RowBox[{"Heads", "->", "True"}]}], "]"}]], "Input",
 CellLabel->"In[10]:= ",
 CellID->13584],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", "List", "]"}], "[", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"{", 
     RowBox[{"a", ",", "b"}], "}"}], "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{"{", 
     RowBox[{"c", ",", "d"}], "}"}], "]"}]}], "]"}]], "Output",
 ImageSize->{199, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[10]= ",
 CellID->13648]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     RowBox[{
      ButtonBox["Map",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Map"], "[", 
      RowBox[{
       StyleBox["f", "TI"], ",", 
       StyleBox["expr", "TI"]}], "]"}], 
     StyleBox["   ", "TableText"], 
     StyleBox["or", "TableText"], 
     StyleBox["   ", "TableText"], 
     RowBox[{
      StyleBox["f", "TI"], "/@", 
      StyleBox["expr", "TI"]}]}], Cell[TextData[{
     "apply ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     " to the first\[Hyphen]level parts of ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     RowBox[{
      ButtonBox["MapAll",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/MapAll"], "[", 
      RowBox[{
       StyleBox["f", "TI"], ",", 
       StyleBox["expr", "TI"]}], "]"}], 
     StyleBox["   ", "TableText"], 
     StyleBox["or", "TableText"], 
     StyleBox["   ", "TableText"], 
     RowBox[{
      StyleBox["f", "TI"], "//@", 
      StyleBox["expr", "TI"]}]}], Cell[TextData[{
     "apply ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     " to all parts of ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Map",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Map"], "[", 
     StyleBox["f", "TI"], ",", 
     StyleBox["expr", "TI"], ",", 
     StyleBox["lev", "TI"], "]"}], Cell[TextData[{
     "apply ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     " to each part of ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " at levels specified by ",
     Cell[BoxData[
      StyleBox["lev", "TI"]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->2971],

Cell["Ways to apply a function to different parts of expressions. ", "Caption",
 CellID->17864],

Cell[TextData[{
 "Level specifications allow you to tell ",
 Cell[BoxData[
  ButtonBox["Map",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Map"]], "InlineFormula"],
 " to which levels of parts in an expression you want a function applied. \
With ",
 Cell[BoxData[
  ButtonBox["MapAt",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MapAt"]], "InlineFormula"],
 ", however, you can instead give an explicit list of parts where you want a \
function applied. You specify each part by giving its indices, as discussed \
in \"",
 ButtonBox["Parts of Expressions\"",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/PartsOfExpressions"],
 ". "
}], "Text",
 CellID->22913],

Cell["Here is a 2x3 matrix. ", "MathCaption",
 CellID->11075],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"mm", "=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"b", ",", "c", ",", "d"}], "}"}]}], "}"}]}]], "Input",
 CellLabel->"In[11]:= ",
 CellID->21545],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b", ",", "c", ",", "d"}], "}"}]}], "}"}]], "Output",
 ImageSize->{144, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[11]= ",
 CellID->28712]
}, Open  ]],

Cell[TextData[{
 "This applies ",
 Cell[BoxData["f"], "InlineFormula"],
 " to parts ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{"1", ",", "2"}], "}"}]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{"2", ",", "3"}], "}"}]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->17546],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MapAt", "[", 
  RowBox[{"f", ",", "mm", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "3"}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[12]:= ",
 CellID->18678],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", 
     RowBox[{"f", "[", "b", "]"}], ",", "c"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b", ",", "c", ",", 
     RowBox[{"f", "[", "d", "]"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{186, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[12]= ",
 CellID->1769]
}, Open  ]],

Cell[TextData[{
 "This gives a list of the positions at which ",
 Cell[BoxData["b"], "InlineFormula"],
 " occurs in ",
 Cell[BoxData["mm"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->15262],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Position", "[", 
  RowBox[{"mm", ",", "b"}], "]"}]], "Input",
 CellLabel->"In[13]:= ",
 CellID->8519],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "1"}], "}"}]}], "}"}]], "Output",
 ImageSize->{108, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[13]= ",
 CellID->13985]
}, Open  ]],

Cell[TextData[{
 "You can feed the list of positions you get from ",
 Cell[BoxData[
  ButtonBox["Position",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Position"]], "InlineFormula"],
 " directly into ",
 Cell[BoxData[
  ButtonBox["MapAt",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MapAt"]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->28289],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MapAt", "[", 
  RowBox[{"f", ",", "mm", ",", "%"}], "]"}]], "Input",
 CellLabel->"In[14]:= ",
 CellID->15944],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", 
     RowBox[{"f", "[", "b", "]"}], ",", "c"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"f", "[", "b", "]"}], ",", "c", ",", "d"}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{186, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[14]= ",
 CellID->2865]
}, Open  ]],

Cell["\<\
To avoid ambiguity, you must put each part specification in a list, even when \
it involves only one index. \
\>", "MathCaption",
 CellID->18540],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MapAt", "[", 
  RowBox[{"f", ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", "2", "}"}], ",", 
     RowBox[{"{", "3", "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[15]:= ",
 CellID->23245],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"a", ",", 
   RowBox[{"f", "[", "b", "]"}], ",", 
   RowBox[{"f", "[", "c", "]"}], ",", "d"}], "}"}]], "Output",
 ImageSize->{122, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[15]= ",
 CellID->25508]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["MapAt",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/MapAt"], "[", 
     StyleBox["f", "TI"], ",", 
     StyleBox["expr", "TI"], ",", "{", 
     SubscriptBox[
      StyleBox["part", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["part", "TI"], "2"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "}", "]"}], "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "apply ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     " to specified parts of ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {18, {
      Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->28318],

Cell["Applying a function to specific parts of an expression. ", "Caption",
 CellID->27870],

Cell["Here is an expression. ", "MathCaption",
 CellID->9601],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"t", "=", 
  RowBox[{"1", "+", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"3", "+", "x"}], ")"}], "^", "2"}], "/", "x"}]}]}]], "Input",
 CellLabel->"In[16]:= ",
 CellID->28323],

Cell[BoxData[
 RowBox[{"1", "+", 
  FractionBox[
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"3", "+", "x"}], ")"}], "2"], "x"]}]], "Output",
 ImageSize->{74, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[16]= ",
 CellID->21132]
}, Open  ]],

Cell[TextData[{
 "This is the full form of ",
 Cell[BoxData["t"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->24472],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullForm", "[", "t", "]"}]], "Input",
 CellLabel->"In[17]:= ",
 CellID->27152],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"Plus", "[", 
    RowBox[{"1", ",", 
     RowBox[{"Times", "[", 
      RowBox[{
       RowBox[{"Power", "[", 
        RowBox[{"x", ",", 
         RowBox[{"-", "1"}]}], "]"}], ",", 
       RowBox[{"Power", "[", 
        RowBox[{
         RowBox[{"Plus", "[", 
          RowBox[{"3", ",", "x"}], "]"}], ",", "2"}], "]"}]}], "]"}]}], "]"}],
   
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Output",
 ImageSize->{341, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[17]//FullForm= ",
 CellID->25087]
}, Open  ]],

Cell[TextData[{
 "You can use ",
 Cell[BoxData[
  ButtonBox["MapAt",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MapAt"]], "InlineFormula"],
 " on any expression. Remember that parts are numbered on the basis of the \
full forms of expressions. "
}], "MathCaption",
 CellID->28570],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MapAt", "[", 
  RowBox[{"f", ",", "t", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"2", ",", "1", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "2"}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[18]:= ",
 CellID->29763],

Cell[BoxData[
 RowBox[{"1", "+", 
  FractionBox[
   RowBox[{"f", "[", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"3", "+", "x"}], ")"}], "2"], "]"}], 
   RowBox[{"f", "[", "x", "]"}]]}]], "Output",
 ImageSize->{95, 37},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[18]= ",
 CellID->29901]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["MapIndexed",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/MapIndexed"], "[", 
     StyleBox["f", "TI"], ",", 
     StyleBox["expr", "TI"], "]"}], Cell[TextData[{
     "apply ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     " to the elements of an expression, giving the part specification of \
each element as a second argument to ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["MapIndexed",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/MapIndexed"], "[", 
     StyleBox["f", "TI"], ",", 
     StyleBox["expr", "TI"], ",", 
     StyleBox["lev", "TI"], "]"}], Cell[TextData[{
     "apply ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     " to parts at specified levels, giving the list of indices for each part \
as a second argument to ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->17103],

Cell["Applying a function to parts and their indices. ", "Caption",
 CellID->14423],

Cell[TextData[{
 "This applies ",
 Cell[BoxData["f"], "InlineFormula"],
 " to each element in a list, giving the index of the element as a second \
argument to ",
 Cell[BoxData["f"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->3527],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MapIndexed", "[", 
  RowBox[{"f", ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[19]:= ",
 CellID->11600],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"a", ",", 
     RowBox[{"{", "1", "}"}]}], "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{"b", ",", 
     RowBox[{"{", "2", "}"}]}], "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{"c", ",", 
     RowBox[{"{", "3", "}"}]}], "]"}]}], "}"}]], "Output",
 ImageSize->{221, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[19]= ",
 CellID->26969]
}, Open  ]],

Cell[TextData[{
 "This applies ",
 Cell[BoxData["f"], "InlineFormula"],
 " to both levels in a matrix. "
}], "MathCaption",
 CellID->14015],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MapIndexed", "[", 
  RowBox[{"f", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"c", ",", "d"}], "}"}]}], "}"}], ",", "2"}], "]"}]], "Input",
 CellLabel->"In[20]:= ",
 CellID->5565],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"f", "[", 
        RowBox[{"a", ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", "1"}], "}"}]}], "]"}], ",", 
       RowBox[{"f", "[", 
        RowBox[{"b", ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", "2"}], "}"}]}], "]"}]}], "}"}], ",", 
     RowBox[{"{", "1", "}"}]}], "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"f", "[", 
        RowBox[{"c", ",", 
         RowBox[{"{", 
          RowBox[{"2", ",", "1"}], "}"}]}], "]"}], ",", 
       RowBox[{"f", "[", 
        RowBox[{"d", ",", 
         RowBox[{"{", 
          RowBox[{"2", ",", "2"}], "}"}]}], "]"}]}], "}"}], ",", 
     RowBox[{"{", "2", "}"}]}], "]"}]}], "}"}]], "Output",
 ImageSize->{500, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[20]= ",
 CellID->28]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Map",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Map"]], "InlineFormula"],
 " allows you to apply a function of one argument to parts of an expression. \
Sometimes, however, you may instead want to apply a function of several \
arguments to corresponding parts of several different expressions. You can do \
this using ",
 Cell[BoxData[
  ButtonBox["MapThread",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MapThread"]], "InlineFormula"],
 ". "
}], "Text",
 CellID->21543],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["MapThread",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/MapThread"], "[", 
     StyleBox["f", "TI"], ",", "{", 
     SubscriptBox[
      StyleBox["expr", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["expr", "TI"], "2"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "}", "]"}], "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "apply ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     " to corresponding elements in each of the ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["MapThread",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/MapThread"], "[", 
     StyleBox["f", "TI"], ",", "{", 
     SubscriptBox[
      StyleBox["expr", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["expr", "TI"], "2"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "}", ",", 
     StyleBox["lev", "TI"], "]"}], "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "apply ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     " to parts of the ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     " at the specified level"
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {18, {
      Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->25347],

Cell["Applying a function to several expressions at once. ", "Caption",
 CellID->2088],

Cell[TextData[{
 "This applies ",
 Cell[BoxData["f"], "InlineFormula"],
 " to corresponding pairs of list elements. "
}], "MathCaption",
 CellID->2943],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MapThread", "[", 
  RowBox[{"f", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"ap", ",", "bp", ",", "cp"}], "}"}]}], "}"}]}], "]"}]], "Input",\

 CellLabel->"In[21]:= ",
 CellID->12637],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"a", ",", "ap"}], "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{"b", ",", "bp"}], "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{"c", ",", "cp"}], "]"}]}], "}"}]], "Output",
 ImageSize->{200, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[21]= ",
 CellID->22409]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["MapThread",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MapThread"]], "InlineFormula"],
 " works with any number of expressions, so long as they have the same \
structure. "
}], "MathCaption",
 CellID->26463],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MapThread", "[", 
  RowBox[{"f", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"ap", ",", "bp"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"app", ",", "bpp"}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[22]:= ",
 CellID->5049],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"a", ",", "ap", ",", "app"}], "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{"b", ",", "bp", ",", "bpp"}], "]"}]}], "}"}]], "Output",
 ImageSize->{200, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[22]= ",
 CellID->4681]
}, Open  ]],

Cell[TextData[{
 "Functions like ",
 Cell[BoxData[
  ButtonBox["Map",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Map"]], "InlineFormula"],
 " allow you to create expressions with parts modified. Sometimes you simply \
want to go through an expression, and apply a particular function to some \
parts of it, without building a new expression. A typical case is when the \
function you apply has certain \[OpenCurlyDoubleQuote]side effects\
\[CloseCurlyDoubleQuote], such as making assignments, or generating output. "
}], "Text",
 CellID->1588],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Scan",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Scan"], "[", 
     StyleBox["f", "TI"], ",", 
     StyleBox["expr", "TI"], "]"}], Cell[TextData[{
     "evaluate ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     " applied to each element of ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " in turn"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Scan",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Scan"], "[", 
     StyleBox["f", "TI"], ",", 
     StyleBox["expr", "TI"], ",", 
     StyleBox["lev", "TI"], "]"}], Cell[TextData[{
     "evaluate ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     " applied to parts of ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " on levels specified by ",
     Cell[BoxData[
      StyleBox["lev", "TI"]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->11342],

Cell["Evaluating functions on parts of expressions. ", "Caption",
 CellID->608],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Map",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Map"]], "InlineFormula"],
 " constructs a new list in which ",
 Cell[BoxData["f"], "InlineFormula"],
 " has been applied to each element of the list. "
}], "MathCaption",
 CellID->32060],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Map", "[", 
  RowBox[{"f", ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[23]:= ",
 CellID->1758],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"f", "[", "a", "]"}], ",", 
   RowBox[{"f", "[", "b", "]"}], ",", 
   RowBox[{"f", "[", "c", "]"}]}], "}"}]], "Output",
 ImageSize->{125, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[23]= ",
 CellID->29954]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Scan",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Scan"]], "InlineFormula"],
 " evaluates the result of applying a function to each element, but does not \
construct a new expression. "
}], "MathCaption",
 CellID->20888],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Scan", "[", 
  RowBox[{"Print", ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[24]:= ",
 CellID->14146],

Cell[CellGroupData[{

Cell[BoxData["a"], "Print",
 CellID->690],

Cell[BoxData["b"], "Print",
 CellID->7949],

Cell[BoxData["c"], "Print",
 CellID->12843]
}, Open  ]]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Scan",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Scan"]], "InlineFormula"],
 " visits the parts of an expression in a depth\[Hyphen]first walk, with the \
leaves visited first. "
}], "MathCaption",
 CellID->21430],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Scan", "[", 
  RowBox[{"Print", ",", 
   RowBox[{"1", "+", 
    RowBox[{"x", "^", "2"}]}], ",", "Infinity"}], "]"}]], "Input",
 CellLabel->"In[25]:= ",
 CellID->25620],

Cell[CellGroupData[{

Cell[BoxData["1"], "Print",
 CellID->748],

Cell[BoxData["x"], "Print",
 CellID->27067],

Cell[BoxData["2"], "Print",
 CellID->4536],

Cell[BoxData[
 SuperscriptBox["x", "2"]], "Print",
 CellID->20783]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->137620175],

Cell[TextData[ButtonBox["Functional Operations",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/FunctionalOperationsOverview"]], "RelatedTutorials",
 CellID->222363673]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Applying Functions to Parts of Expressions - Wolfram \
Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Functional Operations", "OverviewNavText"], BaseStyle -> 
        "Link", ButtonData -> 
        "paclet:tutorial/FunctionalOperationsOverview"]], "Text", FontFamily -> 
      "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledLeftTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/ApplyingFunctionsToListsAndOtherExpressions"], 
        "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]", 
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> "paclet:tutorial/PureFunctions"]}], "Text", 
      FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 32, 46.4511444}", "context" -> "", 
    "keywords" -> {
     "all parts of expressions", "applying functions", "depth-first walks", 
      "expression walking", "heads", "indexed functions", "indices", "levels",
       "lists", "map", "MapAll", "MapAt", "MapIndexed", "MapThread", 
      "matrices", "multiple arguments", "parallel form of Map", 
      "parts of expressions", "position", "Scan", "tree walking", 
      "walking through expressions", 
      "wrapping functions around elements of lists"}, "index" -> True, 
    "label" -> "Mathematica Tutorial", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "If you have a list of elements, it is often important to be able to \
apply a function separately to each of the elements. You can do this in \
Mathematica using Map. This applies f separately to each element in a list. \
This defines a function which takes the first two elements from a list. ", 
    "synonyms" -> {"2.2.4"}, "title" -> 
    "Applying Functions to Parts of Expressions", "type" -> "Tutorial", "uri" -> 
    "tutorial/ApplyingFunctionsToPartsOfExpressions"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S2.2.4"->{
  Cell[2268, 64, 105, 2, 70, "Title",
   CellTags->{"S2.2.4", "4.1"},
   CellID->28027]},
 "4.1"->{
  Cell[2268, 64, 105, 2, 70, "Title",
   CellTags->{"S2.2.4", "4.1"},
   CellID->28027]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S2.2.4", 39703, 1505},
 {"4.1", 39803, 1509}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1643, 37, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2268, 64, 105, 2, 70, "Title",
 CellTags->{"S2.2.4", "4.1"},
 CellID->28027],
Cell[2376, 68, 365, 12, 70, "Text",
 CellID->4084],
Cell[2744, 82, 149, 5, 70, "MathCaption",
 CellID->10075],
Cell[CellGroupData[{
Cell[2918, 91, 178, 6, 28, "Input",
 CellID->18786],
Cell[3099, 99, 298, 10, 36, "Output",
 CellID->15498]
}, Open  ]],
Cell[3412, 112, 119, 3, 70, "MathCaption",
 CellID->24970],
Cell[3534, 117, 183, 6, 70, "Input",
 CellID->6287],
Cell[3720, 125, 265, 10, 70, "MathCaption",
 CellID->23847],
Cell[CellGroupData[{
Cell[4010, 139, 384, 13, 28, "Input",
 CellID->32604],
Cell[4397, 154, 356, 13, 36, "Output",
 CellID->503]
}, Open  ]],
Cell[4768, 170, 986, 30, 70, "DefinitionBox",
 CellID->21221],
Cell[5757, 202, 82, 1, 70, "Caption",
 CellID->22663],
Cell[5842, 205, 687, 24, 70, "Text",
 CellID->5706],
Cell[6532, 231, 138, 5, 70, "MathCaption",
 CellID->2363],
Cell[CellGroupData[{
Cell[6695, 240, 152, 5, 70, "Input",
 CellID->9010],
Cell[6850, 247, 272, 9, 36, "Output",
 CellID->22171]
}, Open  ]],
Cell[7137, 259, 267, 10, 70, "MathCaption",
 CellID->27489],
Cell[CellGroupData[{
Cell[7429, 273, 228, 8, 70, "Input",
 CellID->18240],
Cell[7660, 283, 283, 11, 48, "Output",
 CellID->12164]
}, Open  ]],
Cell[7958, 297, 860, 35, 70, "Text",
 CellID->25542],
Cell[8821, 334, 124, 5, 70, "MathCaption",
 CellID->7619],
Cell[CellGroupData[{
Cell[8970, 343, 238, 9, 70, "Input",
 CellID->20913],
Cell[9211, 354, 298, 11, 36, "Output",
 CellID->7591]
}, Open  ]],
Cell[9524, 368, 319, 11, 70, "MathCaption",
 CellID->6704],
Cell[CellGroupData[{
Cell[9868, 383, 119, 4, 70, "Input",
 CellID->31818],
Cell[9990, 389, 360, 13, 36, "Output",
 CellID->9232]
}, Open  ]],
Cell[10365, 405, 454, 16, 70, "MathCaption",
 CellID->750],
Cell[CellGroupData[{
Cell[10844, 425, 122, 4, 70, "Input",
 CellID->25205],
Cell[10969, 431, 529, 19, 36, "Output",
 CellID->4975]
}, Open  ]],
Cell[11513, 453, 427, 13, 70, "Text",
 CellID->1539],
Cell[11943, 468, 186, 7, 70, "MathCaption",
 CellID->303],
Cell[CellGroupData[{
Cell[12154, 479, 153, 5, 70, "Input",
 CellID->11422],
Cell[12310, 486, 423, 15, 36, "Output",
 CellID->21098]
}, Open  ]],
Cell[12748, 504, 400, 14, 70, "MathCaption",
 CellID->11247],
Cell[CellGroupData[{
Cell[13173, 522, 162, 5, 70, "Input",
 CellID->13584],
Cell[13338, 529, 398, 14, 36, "Output",
 CellID->13648]
}, Open  ]],
Cell[13751, 546, 2136, 71, 70, "DefinitionBox",
 CellID->2971],
Cell[15890, 619, 95, 1, 70, "Caption",
 CellID->17864],
Cell[15988, 622, 675, 20, 70, "Text",
 CellID->22913],
Cell[16666, 644, 61, 1, 70, "MathCaption",
 CellID->11075],
Cell[CellGroupData[{
Cell[16752, 649, 260, 9, 70, "Input",
 CellID->21545],
Cell[17015, 660, 320, 11, 36, "Output",
 CellID->28712]
}, Open  ]],
Cell[17350, 674, 307, 13, 70, "MathCaption",
 CellID->17546],
Cell[CellGroupData[{
Cell[17682, 691, 288, 10, 70, "Input",
 CellID->18678],
Cell[17973, 703, 381, 13, 36, "Output",
 CellID->1769]
}, Open  ]],
Cell[18369, 719, 198, 7, 70, "MathCaption",
 CellID->15262],
Cell[CellGroupData[{
Cell[18592, 730, 125, 4, 70, "Input",
 CellID->8519],
Cell[18720, 736, 300, 11, 36, "Output",
 CellID->13985]
}, Open  ]],
Cell[19035, 750, 361, 13, 70, "MathCaption",
 CellID->28289],
Cell[CellGroupData[{
Cell[19421, 767, 133, 4, 70, "Input",
 CellID->15944],
Cell[19557, 773, 384, 14, 36, "Output",
 CellID->2865]
}, Open  ]],
Cell[19956, 790, 155, 4, 70, "MathCaption",
 CellID->18540],
Cell[CellGroupData[{
Cell[20136, 798, 302, 10, 70, "Input",
 CellID->23245],
Cell[20441, 810, 280, 9, 36, "Output",
 CellID->25508]
}, Open  ]],
Cell[20736, 822, 1063, 32, 70, "DefinitionBox",
 CellID->28318],
Cell[21802, 856, 91, 1, 70, "Caption",
 CellID->27870],
Cell[21896, 859, 61, 1, 70, "MathCaption",
 CellID->9601],
Cell[CellGroupData[{
Cell[21982, 864, 215, 8, 70, "Input",
 CellID->28323],
Cell[22200, 874, 275, 10, 54, "Output",
 CellID->21132]
}, Open  ]],
Cell[22490, 887, 124, 5, 70, "MathCaption",
 CellID->24472],
Cell[CellGroupData[{
Cell[22639, 896, 102, 3, 70, "Input",
 CellID->27152],
Cell[22744, 901, 637, 23, 50, "Output",
 CellID->25087]
}, Open  ]],
Cell[23396, 927, 286, 9, 70, "MathCaption",
 CellID->28570],
Cell[CellGroupData[{
Cell[23707, 940, 297, 10, 70, "Input",
 CellID->29763],
Cell[24007, 952, 336, 12, 58, "Output",
 CellID->29901]
}, Open  ]],
Cell[24358, 967, 1338, 40, 70, "DefinitionBox",
 CellID->17103],
Cell[25699, 1009, 83, 1, 70, "Caption",
 CellID->14423],
Cell[25785, 1012, 240, 8, 70, "MathCaption",
 CellID->3527],
Cell[CellGroupData[{
Cell[26050, 1024, 186, 6, 70, "Input",
 CellID->11600],
Cell[26239, 1032, 452, 16, 36, "Output",
 CellID->26969]
}, Open  ]],
Cell[26706, 1051, 139, 5, 70, "MathCaption",
 CellID->14015],
Cell[CellGroupData[{
Cell[26870, 1060, 291, 10, 70, "Input",
 CellID->5565],
Cell[27164, 1072, 957, 33, 36, "Output",
 CellID->28]
}, Open  ]],
Cell[28136, 1108, 526, 15, 70, "Text",
 CellID->21543],
Cell[28665, 1125, 1818, 56, 70, "DefinitionBox",
 CellID->25347],
Cell[30486, 1183, 86, 1, 70, "Caption",
 CellID->2088],
Cell[30575, 1186, 151, 5, 70, "MathCaption",
 CellID->2943],
Cell[CellGroupData[{
Cell[30751, 1195, 306, 11, 70, "Input",
 CellID->12637],
Cell[31060, 1208, 377, 13, 36, "Output",
 CellID->22409]
}, Open  ]],
Cell[31452, 1224, 257, 8, 70, "MathCaption",
 CellID->26463],
Cell[CellGroupData[{
Cell[31734, 1236, 349, 12, 70, "Input",
 CellID->5049],
Cell[32086, 1250, 335, 11, 36, "Output",
 CellID->4681]
}, Open  ]],
Cell[32436, 1264, 549, 12, 70, "Text",
 CellID->1588],
Cell[32988, 1278, 1287, 42, 70, "DefinitionBox",
 CellID->11342],
Cell[34278, 1322, 79, 1, 70, "Caption",
 CellID->608],
Cell[34360, 1325, 285, 9, 70, "MathCaption",
 CellID->32060],
Cell[CellGroupData[{
Cell[34670, 1338, 178, 6, 70, "Input",
 CellID->1758],
Cell[34851, 1346, 299, 10, 36, "Output",
 CellID->29954]
}, Open  ]],
Cell[35165, 1359, 270, 8, 70, "MathCaption",
 CellID->20888],
Cell[CellGroupData[{
Cell[35460, 1371, 184, 6, 70, "Input",
 CellID->14146],
Cell[CellGroupData[{
Cell[35669, 1381, 41, 1, 70, "Print",
 CellID->690],
Cell[35713, 1384, 42, 1, 70, "Print",
 CellID->7949],
Cell[35758, 1387, 43, 1, 70, "Print",
 CellID->12843]
}, Open  ]]
}, Open  ]],
Cell[35828, 1392, 264, 8, 70, "MathCaption",
 CellID->21430],
Cell[CellGroupData[{
Cell[36117, 1404, 191, 6, 70, "Input",
 CellID->25620],
Cell[CellGroupData[{
Cell[36333, 1414, 41, 1, 70, "Print",
 CellID->748],
Cell[36377, 1417, 43, 1, 70, "Print",
 CellID->27067],
Cell[36423, 1420, 42, 1, 70, "Print",
 CellID->4536],
Cell[36468, 1423, 66, 2, 70, "Print",
 CellID->20783]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[36583, 1431, 72, 1, 70, "RelatedTutorialsSection",
 CellID->137620175],
Cell[36658, 1434, 174, 4, 70, "RelatedTutorials",
 CellID->222363673]
}, Open  ]]
}, Open  ]],
Cell[36859, 1442, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

