(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     41297,       1555]
NotebookOptionsPosition[     32141,       1247]
NotebookOutlinePosition[     34896,       1316]
CellTagsIndexPosition[     34803,       1310]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Transformation Rules and Definitions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/TransformationRulesAndDefinitionsOverview"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Transformation Rules and Definitions\"\>"}, "\<\"related \
tutorials\"\>", 
       StyleBox["\<\"related tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Replace" :> Documentation`HelpLookup["paclet:ref/Replace"], 
          "ReplaceList" :> 
          Documentation`HelpLookup["paclet:ref/ReplaceList"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Replace\"\>", 
       2->"\<\"ReplaceList\"\>"}, "\<\"functions\"\>", 
       StyleBox["\<\"functions\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Applying Transformation Rules", "Title",
 CellTags->{"S2.5.1", "1.1"},
 CellID->18035],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     StyleBox["expr", "TI"], "/.", 
     StyleBox["lhs", "TI"], "->", 
     StyleBox["rhs", "TI"]}], Cell[TextData[{
     "apply a transformation rule to ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     StyleBox["expr", "TI"], "/.", "{", 
     SubscriptBox[
      StyleBox["lhs", "TI"], "1"], "->", 
     SubscriptBox[
      StyleBox["rhs", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["lhs", "TI"], "2"], "->", 
     SubscriptBox[
      StyleBox["rhs", "TI"], "2"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "}"}], Cell[TextData[{
     "try a sequence of rules on each part of ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxItemSize->{"Columns" -> {18, {
      Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->32226],

Cell["Applying transformation rules. ", "Caption",
 CellID->15185],

Cell[TextData[{
 "The replacement operator ",
 Cell[BoxData["/."], "InlineFormula"],
 " (pronounced \[OpenCurlyDoubleQuote]slash\[Hyphen]dot\
\[CloseCurlyDoubleQuote]) applies rules to expressions. "
}], "MathCaption",
 CellID->7038],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "+", "y"}], "/.", 
  RowBox[{"x", "->", "3"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->9853],

Cell[BoxData[
 RowBox[{"3", "+", "y"}]], "Output",
 ImageSize->{31, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->67894008]
}, Open  ]],

Cell["\<\
You can give a list of rules to apply. Each rule will be tried once on each \
part of the expression. \
\>", "MathCaption",
 CellID->11224],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "+", "y"}], "/.", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"x", "->", "a"}], ",", 
    RowBox[{"y", "->", "b"}]}], "}"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->15748],

Cell[BoxData[
 RowBox[{"a", "+", "b"}]], "Output",
 ImageSize->{31, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->88229515]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     StyleBox["expr", "TI"], "/.", "{", 
     SubscriptBox[
      StyleBox["rules", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["rules", "TI"], "2"], ",", 
     StyleBox["\[Ellipsis]", "TR"], "}"}], Cell[TextData[{
     "give a list of the results from applying each of the ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["rules", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     " to ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {False, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->3359],

Cell["Applying lists of transformation rules. ", "Caption",
 CellID->32257],

Cell["\<\
If you give a list of lists of rules, you get a list of results. \
\>", "MathCaption",
 CellID->24766],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "+", "y"}], "/.", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"x", "->", "1"}], ",", 
      RowBox[{"y", "->", "2"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"x", "->", "4"}], ",", 
      RowBox[{"y", "->", "2"}]}], "}"}]}], "}"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->4944],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"3", ",", "6"}], "}"}]], "Output",
 ImageSize->{44, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->107781619]
}, Open  ]],

Cell[TextData[{
 "Functions such as ",
 Cell[BoxData[
  ButtonBox["Solve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Solve"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["NSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NSolve"]], "InlineFormula"],
 " return lists whose elements are lists of rules, each representing a \
solution. "
}], "MathCaption",
 CellID->23318],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "3"}], "-", 
     RowBox[{"5", 
      RowBox[{"x", "^", "2"}]}], "+", 
     RowBox[{"2", "x"}], "+", "8"}], "==", "0"}], ",", "x"}], "]"}]], "Input",\

 CellLabel->"In[4]:=",
 CellID->32726],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"-", "1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", "4"}], "}"}]}], "}"}]], "Output",
 ImageSize->{181, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->174782082]
}, Open  ]],

Cell["\<\
When you apply these rules, you get a list of results, one corresponding to \
each solution. \
\>", "MathCaption",
 CellID->21025],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"x", "^", "2"}], "+", "6"}], "/.", "%"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->20355],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"7", ",", "10", ",", "22"}], "}"}]], "Output",
 ImageSize->{76, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->595352735]
}, Open  ]],

Cell[TextData[{
 "When you use ",
 Cell[BoxData[
  RowBox[{
   StyleBox["expr", "TI"], "/.", 
   StyleBox["rules", "TI"]}]], "InlineFormula"],
 ", each rule is tried in turn on each part of ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 ". As soon as a rule applies, the appropriate transformation is made, and \
the resulting part is returned. "
}], "Text",
 CellID->22549],

Cell[TextData[{
 "The rule for ",
 Cell[BoxData[
  RowBox[{"x", "^", "3"}]], "InlineFormula"],
 " is tried first; if it does not apply, the rule for ",
 Cell[BoxData[
  RowBox[{"x", "^", "n_"}]], "InlineFormula"],
 " is used. "
}], "MathCaption",
 CellID->9496],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{"x", "^", "2"}], ",", 
    RowBox[{"x", "^", "3"}], ",", 
    RowBox[{"x", "^", "4"}]}], "}"}], "/.", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "3"}], "->", "u"}], ",", 
    RowBox[{
     RowBox[{"x", "^", "n_"}], "->", 
     RowBox[{"p", "[", "n", "]"}]}]}], "}"}]}]], "Input",
 CellLabel->"In[6]:=",
 CellID->18584],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"p", "[", "2", "]"}], ",", "u", ",", 
   RowBox[{"p", "[", "4", "]"}]}], "}"}]], "Output",
 ImageSize->{104, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->195090573]
}, Open  ]],

Cell[TextData[{
 "A result is returned as soon as the rule has been applied, so the inner \
instance of ",
 Cell[BoxData["h"], "InlineFormula"],
 " is not replaced. "
}], "MathCaption",
 CellID->17964],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"h", "[", 
   RowBox[{"x", "+", 
    RowBox[{"h", "[", "y", "]"}]}], "]"}], "/.", 
  RowBox[{
   RowBox[{"h", "[", "u_", "]"}], "->", 
   RowBox[{"u", "^", "2"}]}]}]], "Input",
 CellLabel->"In[7]:=",
 CellID->23342],

Cell[BoxData[
 SuperscriptBox[
  RowBox[{"(", 
   RowBox[{"x", "+", 
    RowBox[{"h", "[", "y", "]"}]}], ")"}], "2"]], "Output",
 ImageSize->{72, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->209674999]
}, Open  ]],

Cell[TextData[{
 "The replacement ",
 Cell[BoxData[
  RowBox[{
   StyleBox["expr", "TI"], "/.", 
   StyleBox["rules", "TI"]}]], "InlineFormula"],
 " tries each rule just once on each part of ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 ". "
}], "Text",
 CellID->17913],

Cell[TextData[{
 "Since each rule is tried just once, this serves to swap ",
 Cell[BoxData["x"], "InlineFormula"],
 " and ",
 Cell[BoxData["y"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->16142],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{"x", "^", "2"}], ",", 
    RowBox[{"y", "^", "3"}]}], "}"}], "/.", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"x", "->", "y"}], ",", 
    RowBox[{"y", "->", "x"}]}], "}"}]}]], "Input",
 CellLabel->"In[8]:=",
 CellID->31196],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SuperscriptBox["y", "2"], ",", 
   SuperscriptBox["x", "3"]}], "}"}]], "Output",
 ImageSize->{55, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]=",
 CellID->17966048]
}, Open  ]],

Cell["\<\
You can use this notation to apply one set of rules, followed by another. \
\>", "MathCaption",
 CellID->25072],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"x", "^", "2"}], "/.", 
   RowBox[{"x", "->", 
    RowBox[{"(", 
     RowBox[{"1", "+", "y"}], ")"}]}]}], "/.", 
  RowBox[{"y", "->", "b"}]}]], "Input",
 CellLabel->"In[9]:=",
 CellID->20426],

Cell[BoxData[
 SuperscriptBox[
  RowBox[{"(", 
   RowBox[{"1", "+", "b"}], ")"}], "2"]], "Output",
 ImageSize->{51, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[9]=",
 CellID->171200153]
}, Open  ]],

Cell[TextData[{
 "Sometimes you may need to go on applying rules over and over again, until \
the expression you are working on no longer changes. You can do this using \
the repeated replacement operation ",
 Cell[BoxData[
  RowBox[{
   StyleBox["expr", "TI"], "//.", 
   StyleBox["rules", "TI"]}]], "InlineFormula"],
 " (or ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ReplaceRepeated",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ReplaceRepeated"], "[", 
   RowBox[{
    StyleBox["expr", "TI"], ",", 
    StyleBox["rules", "TI"]}], "]"}]], "InlineFormula"],
 "). "
}], "Text",
 CellID->26173],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     StyleBox["expr", "TI"], "/.", 
     StyleBox["rules", "TI"]}], Cell[TextData[{
     "try rules once on each part of ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     StyleBox["expr", "TI"], "//.", 
     StyleBox["rules", "TI"]}], Cell[
    "try rules repeatedly until the result no longer changes", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->24429],

Cell["Single and repeated rule application. ", "Caption",
 CellID->32404],

Cell[TextData[{
 "With the single replacement operator ",
 Cell[BoxData["/."], "InlineFormula"],
 " each rule is tried only once on each part of the expression. "
}], "MathCaption",
 CellID->6705],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"x", "^", "2"}], "+", 
   RowBox[{"y", "^", "6"}]}], "/.", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"x", "->", 
     RowBox[{"2", "+", "a"}]}], ",", 
    RowBox[{"a", "->", "3"}]}], "}"}]}]], "Input",
 CellLabel->"In[10]:=",
 CellID->20626],

Cell[BoxData[
 RowBox[{
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{"2", "+", "a"}], ")"}], "2"], "+", 
  SuperscriptBox["y", "6"]}]], "Output",
 ImageSize->{76, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[10]=",
 CellID->198687133]
}, Open  ]],

Cell[TextData[{
 "With the repeated replacement operator ",
 Cell[BoxData["//."], "InlineFormula"],
 " the rules are tried repeatedly until the expression no longer changes. "
}], "MathCaption",
 CellID->19375],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"x", "^", "2"}], "+", 
   RowBox[{"y", "^", "6"}]}], "//.", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"x", "->", 
     RowBox[{"2", "+", "a"}]}], ",", 
    RowBox[{"a", "->", "3"}]}], "}"}]}]], "Input",
 CellLabel->"In[11]:=",
 CellID->30093],

Cell[BoxData[
 RowBox[{"25", "+", 
  SuperscriptBox["y", "6"]}]], "Output",
 ImageSize->{44, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[11]=",
 CellID->138965063]
}, Open  ]],

Cell["Here the rule is applied only once. ", "MathCaption",
 CellID->16036],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"log", "[", 
   RowBox[{"a", " ", "b", " ", "c", " ", "d"}], "]"}], "/.", 
  RowBox[{
   RowBox[{"log", "[", 
    RowBox[{"x_", " ", "y_"}], "]"}], "->", 
   RowBox[{
    RowBox[{"log", "[", "x", "]"}], "+", 
    RowBox[{"log", "[", "y", "]"}]}]}]}]], "Input",
 CellLabel->"In[12]:=",
 CellID->14736],

Cell[BoxData[
 RowBox[{
  RowBox[{"log", "[", "a", "]"}], "+", 
  RowBox[{"log", "[", 
   RowBox[{"b", " ", "c", " ", "d"}], "]"}]}]], "Output",
 ImageSize->{121, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[12]=",
 CellID->5947179]
}, Open  ]],

Cell["\<\
With the repeated replacement operator, the rule is applied repeatedly, until \
the result no longer changes. \
\>", "MathCaption",
 CellID->30814],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"log", "[", 
   RowBox[{"a", " ", "b", " ", "c", " ", "d"}], "]"}], "//.", 
  RowBox[{
   RowBox[{"log", "[", 
    RowBox[{"x_", " ", "y_"}], "]"}], "->", 
   RowBox[{
    RowBox[{"log", "[", "x", "]"}], "+", 
    RowBox[{"log", "[", "y", "]"}]}]}]}]], "Input",
 CellLabel->"In[13]:=",
 CellID->5994],

Cell[BoxData[
 RowBox[{
  RowBox[{"log", "[", "a", "]"}], "+", 
  RowBox[{"log", "[", "b", "]"}], "+", 
  RowBox[{"log", "[", "c", "]"}], "+", 
  RowBox[{"log", "[", "d", "]"}]}]], "Output",
 ImageSize->{210, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[13]=",
 CellID->50821759]
}, Open  ]],

Cell[TextData[{
 "When you use ",
 Cell[BoxData["//."], "InlineFormula"],
 " (pronounced \[OpenCurlyDoubleQuote]slash\[Hyphen]slash\[Hyphen]dot\
\[CloseCurlyDoubleQuote]), ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " repeatedly passes through your expression, trying each of the rules given. \
It goes on doing this until it gets the same result on two successive passes. \
"
}], "Text",
 CellID->6652],

Cell[TextData[{
 "If you give a set of rules that is circular, then ",
 Cell[BoxData["//."], "InlineFormula"],
 " can keep on getting different results forever. In practice, the maximum \
number of passes that ",
 Cell[BoxData["//."], "InlineFormula"],
 " makes on a particular expression is determined by the setting for the \
option ",
 Cell[BoxData[
  ButtonBox["MaxIterations",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MaxIterations"]], "InlineFormula"],
 ". If you want to keep going for as long as possible, you can use ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ReplaceRepeated",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ReplaceRepeated"], "[", 
   RowBox[{
    StyleBox["expr", "TI"], ",", 
    StyleBox["rules", "TI"], ",", 
    RowBox[{
     ButtonBox["MaxIterations",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/MaxIterations"], "->", 
     ButtonBox["Infinity",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Infinity"]}]}], "]"}]], "InlineFormula"],
 ". You can always stop by explicitly interrupting ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". "
}], "Text",
 CellID->23936],

Cell[TextData[{
 "By setting the option ",
 Cell[BoxData[
  ButtonBox["MaxIterations",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MaxIterations"]], "InlineFormula"],
 ", you can explicitly tell ",
 Cell[BoxData[
  ButtonBox["ReplaceRepeated",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ReplaceRepeated"]], "InlineFormula"],
 " how many times to try the rules you give. "
}], "MathCaption",
 CellID->30838],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ReplaceRepeated", "[", 
  RowBox[{"x", ",", 
   RowBox[{"x", "->", 
    RowBox[{"x", "+", "1"}]}], ",", 
   RowBox[{"MaxIterations", "->", "1000"}]}], "]"}]], "Input",
 CellLabel->"In[14]:=",
 CellID->20482],

Cell[BoxData[
 RowBox[{
  RowBox[{"ReplaceRepeated", "::", "\<\"rrlim\"\>"}], ":", 
  " ", "\<\"Exiting after \\!\\(x\\) scanned \\!\\(1000\\) times. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/ReplaceRepeated/rrlim\\\
\", ButtonNote -> \\\"ReplaceRepeated::rrlim\\\"]\\)\"\>"}]], "Message", \
"MSG",
 CellLabel->"During evaluation of In[14]:=",
 CellID->884000438],

Cell[BoxData[
 RowBox[{"1000", "+", "x"}]], "Output",
 ImageSize->{52, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[14]=",
 CellID->526868339]
}, Open  ]],

Cell[TextData[{
 "The replacement operators ",
 Cell[BoxData["/."], "InlineFormula"],
 " and ",
 Cell[BoxData["//."], "InlineFormula"],
 " share the feature that they try each rule on every subpart of your \
expression. On the other hand, ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Replace",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Replace"], "[", 
   RowBox[{
    StyleBox["expr", "TI"], ",", 
    StyleBox["rules", "TI"]}], "]"}]], "InlineFormula"],
 " tries the rules only on the whole of ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 ", and not on any of its subparts. "
}], "Text",
 CellID->1131],

Cell[TextData[{
 "You can use ",
 Cell[BoxData[
  ButtonBox["Replace",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Replace"]], "InlineFormula"],
 ", together with functions like ",
 Cell[BoxData[
  ButtonBox["Map",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Map"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["MapAt",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MapAt"]], "InlineFormula"],
 ", to control exactly which parts of an expression a replacement is applied \
to. Remember that you can use the function ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ReplacePart",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ReplacePart"], "[", 
   RowBox[{
    StyleBox["expr", "TI"], ",", 
    StyleBox["new", "TI"], ",", 
    StyleBox["pos", "TI"]}], "]"}]], "InlineFormula"],
 " to replace part of an expression with a specific object. "
}], "Text",
 CellID->18230],

Cell[TextData[{
 "The operator ",
 Cell[BoxData["/."], "InlineFormula"],
 " applies rules to all subparts of an expression. "
}], "MathCaption",
 CellID->17841],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "^", "2"}], "/.", 
  RowBox[{"x", "->", "a"}]}]], "Input",
 CellLabel->"In[15]:=",
 CellID->14625],

Cell[BoxData[
 SuperscriptBox["a", "2"]], "Output",
 ImageSize->{17, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[15]=",
 CellID->110566386]
}, Open  ]],

Cell[TextData[{
 "Without a level specification, ",
 Cell[BoxData[
  ButtonBox["Replace",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Replace"]], "InlineFormula"],
 " applies rules only to the whole expression. "
}], "MathCaption",
 CellID->32637],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Replace", "[", 
  RowBox[{
   RowBox[{"x", "^", "2"}], ",", 
   RowBox[{
    RowBox[{"x", "^", "2"}], "->", "b"}]}], "]"}]], "Input",
 CellLabel->"In[16]:=",
 CellID->4186],

Cell[BoxData["b"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[16]=",
 CellID->50712317]
}, Open  ]],

Cell["No replacement is done here. ", "MathCaption",
 CellID->1650],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Replace", "[", 
  RowBox[{
   RowBox[{"x", "^", "2"}], ",", 
   RowBox[{"x", "->", "a"}]}], "]"}]], "Input",
 CellLabel->"In[17]:=",
 CellID->5662],

Cell[BoxData[
 SuperscriptBox["x", "2"]], "Output",
 ImageSize->{17, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[17]=",
 CellID->78751181]
}, Open  ]],

Cell[TextData[{
 "This applies rules down to level 2, and so replaces ",
 Cell[BoxData["x"], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->10893],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Replace", "[", 
  RowBox[{
   RowBox[{"x", "^", "2"}], ",", 
   RowBox[{"x", "->", "a"}], ",", "2"}], "]"}]], "Input",
 CellLabel->"In[18]:=",
 CellID->10353],

Cell[BoxData[
 SuperscriptBox["a", "2"]], "Output",
 ImageSize->{17, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[18]=",
 CellID->6458758]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     StyleBox["expr", "TI"], "/.", 
     StyleBox["rules", "TI"]}], Cell[TextData[{
     "apply rules to all subparts of ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Replace",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Replace"], "[", 
     StyleBox["expr", "TI"], ",", 
     StyleBox["rules", "TI"], "]"}], Cell[TextData[{
     "apply rules to the whole of ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " only"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Replace",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Replace"], "[", 
     StyleBox["expr", "TI"], ",", 
     StyleBox["rules", "TI"], ",", 
     StyleBox["levspec", "TI"], "]"}], Cell[TextData[{
     "apply rules to parts of ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " on levels specified by ",
     Cell[BoxData[
      StyleBox["levspec", "TI"]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, {False}, False}, "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->13452],

Cell["Applying rules to whole expressions. ", "Caption",
 CellID->14008],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Replace",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Replace"]], "InlineFormula"],
 " returns the result from using the first rule that applies. "
}], "MathCaption",
 CellID->7262],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Replace", "[", 
  RowBox[{
   RowBox[{"f", "[", "u", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"f", "[", "x_", "]"}], "->", 
      RowBox[{"x", "^", "2"}]}], ",", 
     RowBox[{
      RowBox[{"f", "[", "x_", "]"}], "->", 
      RowBox[{"x", "^", "3"}]}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[19]:=",
 CellID->22233],

Cell[BoxData[
 SuperscriptBox["u", "2"]], "Output",
 ImageSize->{17, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[19]=",
 CellID->565464835]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ReplaceList",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ReplaceList"]], "InlineFormula"],
 " gives a list of the results from every rule that applies. "
}], "MathCaption",
 CellID->16303],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ReplaceList", "[", 
  RowBox[{
   RowBox[{"f", "[", "u", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"f", "[", "x_", "]"}], "->", 
      RowBox[{"x", "^", "2"}]}], ",", 
     RowBox[{
      RowBox[{"f", "[", "x_", "]"}], "->", 
      RowBox[{"x", "^", "3"}]}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[20]:=",
 CellID->16634],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SuperscriptBox["u", "2"], ",", 
   SuperscriptBox["u", "3"]}], "}"}]], "Output",
 ImageSize->{55, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[20]=",
 CellID->402602276]
}, Open  ]],

Cell[TextData[{
 "If a single rule can be applied in several ways, ",
 Cell[BoxData[
  ButtonBox["ReplaceList",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ReplaceList"]], "InlineFormula"],
 " gives a list of all the results. "
}], "MathCaption",
 CellID->14256],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ReplaceList", "[", 
  RowBox[{
   RowBox[{"a", "+", "b", "+", "c"}], ",", 
   RowBox[{
    RowBox[{"x_", "+", "y_"}], "->", 
    RowBox[{"g", "[", 
     RowBox[{"x", ",", "y"}], "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[21]:=",
 CellID->148],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"g", "[", 
    RowBox[{"a", ",", 
     RowBox[{"b", "+", "c"}]}], "]"}], ",", 
   RowBox[{"g", "[", 
    RowBox[{"b", ",", 
     RowBox[{"a", "+", "c"}]}], "]"}], ",", 
   RowBox[{"g", "[", 
    RowBox[{"c", ",", 
     RowBox[{"a", "+", "b"}]}], "]"}], ",", 
   RowBox[{"g", "[", 
    RowBox[{
     RowBox[{"a", "+", "b"}], ",", "c"}], "]"}], ",", 
   RowBox[{"g", "[", 
    RowBox[{
     RowBox[{"a", "+", "c"}], ",", "b"}], "]"}], ",", 
   RowBox[{"g", "[", 
    RowBox[{
     RowBox[{"b", "+", "c"}], ",", "a"}], "]"}]}], "}"}]], "Output",
 ImageSize->{469, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[21]=",
 CellID->53746002]
}, Open  ]],

Cell["\<\
This gives a list of ways of breaking the original list in two. \
\>", "MathCaption",
 CellID->12317],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ReplaceList", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"x__", ",", "y__"}], "}"}], "->", 
    RowBox[{"g", "[", 
     RowBox[{
      RowBox[{"{", "x", "}"}], ",", 
      RowBox[{"{", "y", "}"}]}], "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[22]:=",
 CellID->4213],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"g", "[", 
    RowBox[{
     RowBox[{"{", "a", "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"b", ",", "c", ",", "d"}], "}"}]}], "]"}], ",", 
   RowBox[{"g", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"c", ",", "d"}], "}"}]}], "]"}], ",", 
   RowBox[{"g", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
     RowBox[{"{", "d", "}"}]}], "]"}]}], "}"}]], "Output",
 ImageSize->{373, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[22]=",
 CellID->870157504]
}, Open  ]],

Cell["\<\
This finds all sublists that are flanked by the same element. \
\>", "MathCaption",
 CellID->24028],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ReplaceList", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "a", ",", "d", ",", "b", ",", "d"}],
     "}"}], ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"___", ",", "x_", ",", "y__", ",", "x_", ",", "___"}], "}"}], "->",
     
    RowBox[{"g", "[", 
     RowBox[{"x", ",", 
      RowBox[{"{", "y", "}"}]}], "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[23]:=",
 CellID->29200],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"g", "[", 
    RowBox[{"a", ",", 
     RowBox[{"{", 
      RowBox[{"b", ",", "c"}], "}"}]}], "]"}], ",", 
   RowBox[{"g", "[", 
    RowBox[{"b", ",", 
     RowBox[{"{", 
      RowBox[{"c", ",", "a", ",", "d"}], "}"}]}], "]"}], ",", 
   RowBox[{"g", "[", 
    RowBox[{"d", ",", 
     RowBox[{"{", "b", "}"}]}], "]"}]}], "}"}]], "Output",
 ImageSize->{276, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[23]=",
 CellID->390781415]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Replace",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Replace"], "[", 
     StyleBox["expr", "TI"], ",", 
     StyleBox["rules", "TI"], "]"}], Cell[TextData[{
     "apply ",
     Cell[BoxData[
      StyleBox["rules", "TI"]], "InlineFormula"],
     " in one way only"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["ReplaceList",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ReplaceList"], "[", 
     StyleBox["expr", "TI"], ",", 
     StyleBox["rules", "TI"], "]"}], Cell[TextData[{
     "apply ",
     Cell[BoxData[
      StyleBox["rules", "TI"]], "InlineFormula"],
     " in all possible ways"
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->21318],

Cell["Applying rules in one way or all possible ways. ", "Caption",
 CellID->16858],

Cell[CellGroupData[{

Cell["RELATED TUTORIALS", "RelatedTutorialsSection",
 CellID->334244817],

Cell[TextData[ButtonBox["Transformation Rules and Definitions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/TransformationRulesAndDefinitionsOverview"]], \
"RelatedTutorials",
 CellID->97729659]
}, Open  ]],

Cell[CellGroupData[{

Cell["RELATED WOLFRAM EDUCATION GROUP COURSES", "TutorialRelatedLinksSection",
 CellID->364399102],

Cell[TextData[{
 ButtonBox["M101: A First Course in ",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolfram.com/services/education/courses/m101.html"], 
    None}],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolfram.com/services/education/courses/m101.html"], 
    None}],
  FontSlant->"Italic"]
}], "TutorialRelatedLinks",
 CellID->437868897],

Cell[TextData[{
 ButtonBox["M221: Introduction to Programming in ",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolfram.com/services/education/courses/m221.html"], 
    None}],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolfram.com/services/education/courses/m221.html"], 
    None}],
  FontSlant->"Italic"]
}], "TutorialRelatedLinks",
 CellID->304353503]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Applying Transformation Rules - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Transformation Rules and Definitions", "OverviewNavText"], 
        BaseStyle -> "Link", ButtonData -> 
        "paclet:tutorial/TransformationRulesAndDefinitionsOverview"]], "Text",
       FontFamily -> "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/ManipulatingSetsOfTransformationRules"]}], "Text", 
      FontFamily -> "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 32, 46.9042810}", "context" -> "", 
    "keywords" -> {
     "//.", "/.", "->", "arrow", "lists", "multiple matches for patterns", 
      "parser construction", "production rules", "repeated rule application", 
      "replace", "ReplaceAll", "ReplaceList", "ReplaceRepeated", 
      "rewrite rules", "rewriting rules", "rule", "RuleDelayed", "rules", 
      "searching", "selecting sublists", "slash-dot", "slash-slash-dot", 
      "sublists", "subparts", "swapping", "transformation rules"}, "index" -> 
    True, "label" -> "Mathematica Tutorial", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Applying transformation rules. The replacement operator /. (pronounced \
'slash-dot') applies rules to expressions. You can give a list of rules to \
apply. Each rule will be tried once on each part of the expression. ", 
    "synonyms" -> {"2.5.1"}, "title" -> "Applying Transformation Rules", 
    "type" -> "Tutorial", "uri" -> "tutorial/ApplyingTransformationRules"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S2.5.1"->{
  Cell[1968, 61, 92, 2, 70, "Title",
   CellTags->{"S2.5.1", "1.1"},
   CellID->18035]},
 "1.1"->{
  Cell[1968, 61, 92, 2, 70, "Title",
   CellTags->{"S2.5.1", "1.1"},
   CellID->18035]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S2.5.1", 34592, 1299},
 {"1.1", 34691, 1303}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1343, 34, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1968, 61, 92, 2, 70, "Title",
 CellTags->{"S2.5.1", "1.1"},
 CellID->18035],
Cell[2063, 65, 1248, 37, 70, "DefinitionBox",
 CellID->32226],
Cell[3314, 104, 66, 1, 70, "Caption",
 CellID->15185],
Cell[3383, 107, 233, 6, 70, "MathCaption",
 CellID->7038],
Cell[CellGroupData[{
Cell[3641, 117, 135, 5, 28, "Input",
 CellID->9853],
Cell[3779, 124, 179, 6, 36, "Output",
 CellID->67894008]
}, Open  ]],
Cell[3973, 133, 149, 4, 70, "MathCaption",
 CellID->11224],
Cell[CellGroupData[{
Cell[4147, 141, 211, 8, 28, "Input",
 CellID->15748],
Cell[4361, 151, 179, 6, 36, "Output",
 CellID->88229515]
}, Open  ]],
Cell[4555, 160, 866, 26, 70, "DefinitionBox",
 CellID->3359],
Cell[5424, 188, 75, 1, 70, "Caption",
 CellID->32257],
Cell[5502, 191, 112, 3, 70, "MathCaption",
 CellID->24766],
Cell[CellGroupData[{
Cell[5639, 198, 372, 14, 70, "Input",
 CellID->4944],
Cell[6014, 214, 203, 7, 36, "Output",
 CellID->107781619]
}, Open  ]],
Cell[6232, 224, 396, 14, 70, "MathCaption",
 CellID->23318],
Cell[CellGroupData[{
Cell[6653, 242, 287, 11, 70, "Input",
 CellID->32726],
Cell[6943, 255, 400, 14, 36, "Output",
 CellID->174782082]
}, Open  ]],
Cell[7358, 272, 140, 4, 70, "MathCaption",
 CellID->21025],
Cell[CellGroupData[{
Cell[7523, 280, 136, 5, 70, "Input",
 CellID->20355],
Cell[7662, 287, 215, 7, 36, "Output",
 CellID->595352735]
}, Open  ]],
Cell[7892, 297, 391, 12, 70, "Text",
 CellID->22549],
Cell[8286, 311, 261, 9, 70, "MathCaption",
 CellID->9496],
Cell[CellGroupData[{
Cell[8572, 324, 404, 15, 70, "Input",
 CellID->18584],
Cell[8979, 341, 272, 9, 36, "Output",
 CellID->195090573]
}, Open  ]],
Cell[9266, 353, 201, 6, 70, "MathCaption",
 CellID->17964],
Cell[CellGroupData[{
Cell[9492, 363, 249, 9, 70, "Input",
 CellID->23342],
Cell[9744, 374, 258, 9, 36, "Output",
 CellID->209674999]
}, Open  ]],
Cell[10017, 386, 287, 11, 70, "Text",
 CellID->17913],
Cell[10307, 399, 203, 7, 70, "MathCaption",
 CellID->16142],
Cell[CellGroupData[{
Cell[10535, 410, 285, 11, 70, "Input",
 CellID->31196],
Cell[10823, 423, 252, 9, 39, "Output",
 CellID->17966048]
}, Open  ]],
Cell[11090, 435, 121, 3, 70, "MathCaption",
 CellID->25072],
Cell[CellGroupData[{
Cell[11236, 442, 237, 9, 70, "Input",
 CellID->20426],
Cell[11476, 453, 228, 8, 36, "Output",
 CellID->171200153]
}, Open  ]],
Cell[11719, 464, 600, 19, 70, "Text",
 CellID->26173],
Cell[12322, 485, 738, 22, 70, "DefinitionBox",
 CellID->24429],
Cell[13063, 509, 73, 1, 70, "Caption",
 CellID->32404],
Cell[13139, 512, 196, 5, 70, "MathCaption",
 CellID->6705],
Cell[CellGroupData[{
Cell[13360, 521, 286, 11, 70, "Input",
 CellID->20626],
Cell[13649, 534, 278, 10, 36, "Output",
 CellID->198687133]
}, Open  ]],
Cell[13942, 547, 210, 5, 70, "MathCaption",
 CellID->19375],
Cell[CellGroupData[{
Cell[14177, 556, 287, 11, 70, "Input",
 CellID->30093],
Cell[14467, 569, 206, 7, 36, "Output",
 CellID->138965063]
}, Open  ]],
Cell[14688, 579, 75, 1, 70, "MathCaption",
 CellID->16036],
Cell[CellGroupData[{
Cell[14788, 584, 334, 11, 70, "Input",
 CellID->14736],
Cell[15125, 597, 274, 9, 36, "Output",
 CellID->5947179]
}, Open  ]],
Cell[15414, 609, 157, 4, 70, "MathCaption",
 CellID->30814],
Cell[CellGroupData[{
Cell[15596, 617, 334, 11, 70, "Input",
 CellID->5994],
Cell[15933, 630, 321, 10, 36, "Output",
 CellID->50821759]
}, Open  ]],
Cell[16269, 643, 412, 11, 70, "Text",
 CellID->6652],
Cell[16684, 656, 1136, 33, 70, "Text",
 CellID->23936],
Cell[17823, 691, 417, 13, 70, "MathCaption",
 CellID->30838],
Cell[CellGroupData[{
Cell[18265, 708, 231, 7, 70, "Input",
 CellID->20482],
Cell[18499, 717, 451, 9, 70, "Message",
 CellID->884000438],
Cell[18953, 728, 184, 6, 36, "Output",
 CellID->526868339]
}, Open  ]],
Cell[19152, 737, 630, 20, 70, "Text",
 CellID->1131],
Cell[19785, 759, 892, 29, 70, "Text",
 CellID->18230],
Cell[20680, 790, 160, 5, 70, "MathCaption",
 CellID->17841],
Cell[CellGroupData[{
Cell[20865, 799, 137, 5, 70, "Input",
 CellID->14625],
Cell[21005, 806, 182, 6, 36, "Output",
 CellID->110566386]
}, Open  ]],
Cell[21202, 815, 252, 8, 70, "MathCaption",
 CellID->32637],
Cell[CellGroupData[{
Cell[21479, 827, 196, 7, 70, "Input",
 CellID->4186],
Cell[21678, 836, 158, 5, 36, "Output",
 CellID->50712317]
}, Open  ]],
Cell[21851, 844, 67, 1, 70, "MathCaption",
 CellID->1650],
Cell[CellGroupData[{
Cell[21943, 849, 171, 6, 70, "Input",
 CellID->5662],
Cell[22117, 857, 181, 6, 36, "Output",
 CellID->78751181]
}, Open  ]],
Cell[22313, 866, 151, 5, 70, "MathCaption",
 CellID->10893],
Cell[CellGroupData[{
Cell[22489, 875, 182, 6, 70, "Input",
 CellID->10353],
Cell[22674, 883, 180, 6, 36, "Output",
 CellID->6458758]
}, Open  ]],
Cell[22869, 892, 1402, 44, 70, "DefinitionBox",
 CellID->13452],
Cell[24274, 938, 72, 1, 70, "Caption",
 CellID->14008],
Cell[24349, 941, 230, 7, 70, "MathCaption",
 CellID->7262],
Cell[CellGroupData[{
Cell[24604, 952, 375, 13, 70, "Input",
 CellID->22233],
Cell[24982, 967, 182, 6, 36, "Output",
 CellID->565464835]
}, Open  ]],
Cell[25179, 976, 238, 7, 70, "MathCaption",
 CellID->16303],
Cell[CellGroupData[{
Cell[25442, 987, 379, 13, 70, "Input",
 CellID->16634],
Cell[25824, 1002, 254, 9, 39, "Output",
 CellID->402602276]
}, Open  ]],
Cell[26093, 1014, 267, 8, 70, "MathCaption",
 CellID->14256],
Cell[CellGroupData[{
Cell[26385, 1026, 267, 9, 70, "Input",
 CellID->148],
Cell[26655, 1037, 724, 25, 36, "Output",
 CellID->53746002]
}, Open  ]],
Cell[27394, 1065, 111, 3, 70, "MathCaption",
 CellID->12317],
Cell[CellGroupData[{
Cell[27530, 1072, 385, 13, 70, "Input",
 CellID->4213],
Cell[27918, 1087, 661, 23, 36, "Output",
 CellID->870157504]
}, Open  ]],
Cell[28594, 1113, 109, 3, 70, "MathCaption",
 CellID->24028],
Cell[CellGroupData[{
Cell[28728, 1120, 433, 14, 70, "Input",
 CellID->29200],
Cell[29164, 1136, 519, 18, 36, "Output",
 CellID->390781415]
}, Open  ]],
Cell[29698, 1157, 1018, 33, 70, "DefinitionBox",
 CellID->21318],
Cell[30719, 1192, 83, 1, 70, "Caption",
 CellID->16858],
Cell[CellGroupData[{
Cell[30827, 1197, 72, 1, 70, "RelatedTutorialsSection",
 CellID->334244817],
Cell[30902, 1200, 203, 5, 70, "RelatedTutorials",
 CellID->97729659]
}, Open  ]],
Cell[CellGroupData[{
Cell[31142, 1210, 98, 1, 70, "TutorialRelatedLinksSection",
 CellID->364399102],
Cell[31243, 1213, 414, 13, 70, "TutorialRelatedLinks",
 CellID->437868897],
Cell[31660, 1228, 427, 13, 70, "TutorialRelatedLinks",
 CellID->304353503]
}, Open  ]]
}, Open  ]],
Cell[32114, 1245, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

