(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     11854,        451]
NotebookOptionsPosition[      7226,        303]
NotebookOutlinePosition[      9849,        372]
CellTagsIndexPosition[      9760,        366]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA TUTORIAL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Numerical Calculations" :> 
         Documentation`HelpLookup[
          "paclet:tutorial/NumericalCalculationsOverview"]}, #, 2]& , 
       Evaluator -> Automatic], {
      1->"\<\"Numerical Calculations\"\>"}, "\<\"related tutorials\"\>", 
      StyleBox["\<\"related tutorials\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Arithmetic", "Title",
 CellTags->{"S1.1.1", "1.1"},
 CellID->5565],

Cell[TextData[{
 "You can do arithmetic with ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " just as you would on an electronic calculator. "
}], "Text",
 CellID->3805],

Cell["This is the sum of two numbers. ", "MathCaption",
 CellID->7585],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"2.3", "+", "5.63"}]], "Input",
 CellLabel->"In[1]:= ",
 CellID->16216],

Cell[BoxData["7.93`"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]= ",
 CellID->31450]
}, Open  ]],

Cell[TextData[{
 "Here the ",
 Cell[BoxData["/"], "InlineFormula"],
 " stands for division, and the ",
 Cell[BoxData["^"], "InlineFormula"],
 " stands for power."
}], "MathCaption",
 CellID->1615],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"2.4", "/", 
  RowBox[{"8.9", "^", "2"}]}]], "Input",
 CellLabel->"In[2]:= ",
 CellID->2609],

Cell[BoxData["0.030299204645878042`"], "Output",
 ImageSize->{67, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]= ",
 CellID->11064]
}, Open  ]],

Cell[TextData[{
 "Spaces denote multiplication in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". You can use a ",
 Cell[BoxData["*"], "InlineFormula"],
 " for multiplication if you want to. "
}], "MathCaption",
 CellID->9166],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"2", " ", "3", " ", "4"}]], "Input",
 CellLabel->"In[3]:= ",
 CellID->16893],

Cell[BoxData["24"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]= ",
 CellID->16074]
}, Open  ]],

Cell["You can type arithmetic expressions with parentheses. ", "MathCaption",
 CellID->13509],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"(", 
    RowBox[{"3", "+", "4"}], ")"}], "^", "2"}], "-", 
  RowBox[{"2", " ", 
   RowBox[{"(", 
    RowBox[{"3", "+", "1"}], ")"}]}]}]], "Input",
 CellLabel->"In[4]:= ",
 CellID->30300],

Cell[BoxData["41"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]= ",
 CellID->19695]
}, Open  ]],

Cell["\<\
Spaces are not needed, though they often make your input easier to read. \
\>", "MathCaption",
 CellID->9573],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"(", 
    RowBox[{"3", "+", "4"}], ")"}], "^", "2"}], "-", 
  RowBox[{"2", 
   RowBox[{"(", 
    RowBox[{"3", "+", "1"}], ")"}]}]}]], "Input",
 CellLabel->"In[5]:= ",
 CellID->15589],

Cell[BoxData["41"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]= ",
 CellID->13161]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     StyleBox["x", "TI"], "^", 
     StyleBox["y", "TI"]}], Cell["power", "TableText"]},
   {
    RowBox[{"-", 
     StyleBox["x", "TI"]}], Cell["minus", "TableText"]},
   {
    RowBox[{
     StyleBox["x", "TI"], "/", 
     StyleBox["y", "TI"]}], Cell["divide", "TableText"]},
   {
    RowBox[{
     StyleBox["x", "TI"], " ", 
     StyleBox["y", "TI"], " ", 
     StyleBox["z", "TI"], Cell[" \[ThinSpace]or \[ThinSpace]", "TableText"], 
     StyleBox["x", "TI"], "*", 
     StyleBox["y", "TI"], "*", 
     StyleBox["z", "TI"]}], Cell["multiply", "TableText"]},
   {
    RowBox[{
     StyleBox["x", "TI"], "+", 
     StyleBox["y", "TI"], "+", 
     StyleBox["z", "TI"]}], Cell["add", "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, False, {False}, False}, 
   "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->31172],

Cell[TextData[{
 "Arithmetic operations in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". "
}], "Caption",
 CellID->17968],

Cell[TextData[{
 "Arithmetic operations in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " are grouped according to the standard mathematical conventions. As usual, \
",
 Cell[BoxData[
  RowBox[{
   RowBox[{"2", "^", "3"}], "+", "4"}]], "InlineFormula"],
 ", for example, means ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"(", 
    RowBox[{"2", "^", "3"}], ")"}], "+", "4"}]], "InlineFormula"],
 ", and not ",
 Cell[BoxData[
  RowBox[{"2", "^", 
   RowBox[{"(", 
    RowBox[{"3", "+", "4"}], ")"}]}]], "InlineFormula"],
 ". You can always control grouping by explicitly using parentheses."
}], "Text",
 CellID->27358],

Cell["This result is given in scientific notation. ", "MathCaption",
 CellID->26031],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"2.4", "^", "45"}]], "Input",
 CellLabel->"In[6]:= ",
 CellID->26268],

Cell[BoxData["1.2867846661244414`*^17"], "Output",
 ImageSize->{89, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]= ",
 CellID->19426]
}, Open  ]],

Cell["You can enter numbers in scientific notation like this. ", "MathCaption",
 CellID->28510],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"2.3", " ", 
  RowBox[{"10", "^", "70"}]}]], "Input",
 CellLabel->"In[7]:= ",
 CellID->10422],

Cell[BoxData["2.3`*^70"], "Output",
 ImageSize->{61, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]= ",
 CellID->30774]
}, Open  ]],

Cell["Or like this. ", "MathCaption",
 CellID->8779],

Cell[CellGroupData[{

Cell[BoxData["2.3*^70"], "Input",
 CellLabel->"In[8]:= ",
 CellID->30910],

Cell[BoxData["2.3`*^70"], "Output",
 ImageSize->{61, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]= ",
 CellID->23552]
}, Open  ]],

Cell[TextData[ButtonBox["Numerical Calculations",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/NumericalCalculationsOverview"]], "RelatedTutorials",
 CellID->21356267]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Arithmetic - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, "Overview" -> {"toc" -> Cell[
      BoxData[
       ButtonBox[
        StyleBox["Numerical Calculations", "OverviewNavText"], BaseStyle -> 
        "Link", ButtonData -> 
        "paclet:tutorial/NumericalCalculationsOverview"]], "Text", FontFamily -> 
      "Verdana"], "prevnext" -> Cell[
      TextData[{
        ButtonBox[
         StyleBox["\[FilledRightTriangle]", "OverviewNavText"], BaseStyle -> 
         "Link", ButtonData -> 
         "paclet:tutorial/ExactAndApproximateResults"]}], "Text", FontFamily -> 
      "Verdana"]}, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 32, 52.2637932}", "context" -> "", 
    "keywords" -> {
     "-", "+", "/", "*", "addition", "arithmetic", "asterisk", 
      "binding of operators", "calculator mode", "caret", "divide", 
      "exponential notation", "grouping of input expressions", "minus", 
      "multiply", "numerical calculations", "operators", "parentheses", 
      "plus", "power", "precedence", "raise to a power", "reciprocal", 
      "scientific notation", "spaces", "standard form", "subtract", "times", 
      "wedge"}, "index" -> True, "label" -> "Mathematica Tutorial", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "You can do arithmetic with Mathematica just as you would on an \
electronic calculator. This is the sum of two numbers. Here the / stands for \
division, and the ^ stands for power.", "synonyms" -> {"1.1.1"}, "title" -> 
    "Arithmetic", "type" -> "Tutorial", "uri" -> "tutorial/Arithmetic"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "S1.1.1"->{
  Cell[1266, 43, 72, 2, 70, "Title",
   CellTags->{"S1.1.1", "1.1"},
   CellID->5565]},
 "1.1"->{
  Cell[1266, 43, 72, 2, 70, "Title",
   CellTags->{"S1.1.1", "1.1"},
   CellID->5565]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"S1.1.1", 9551, 355},
 {"1.1", 9649, 359}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 641, 16, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1266, 43, 72, 2, 70, "Title",
 CellTags->{"S1.1.1", "1.1"},
 CellID->5565],
Cell[1341, 47, 175, 6, 70, "Text",
 CellID->3805],
Cell[1519, 55, 70, 1, 70, "MathCaption",
 CellID->7585],
Cell[CellGroupData[{
Cell[1614, 60, 94, 3, 28, "Input",
 CellID->16216],
Cell[1711, 65, 159, 5, 36, "Output",
 CellID->31450]
}, Open  ]],
Cell[1885, 73, 196, 7, 70, "MathCaption",
 CellID->1615],
Cell[CellGroupData[{
Cell[2106, 84, 115, 4, 28, "Input",
 CellID->2609],
Cell[2224, 90, 175, 5, 36, "Output",
 CellID->11064]
}, Open  ]],
Cell[2414, 98, 234, 8, 70, "MathCaption",
 CellID->9166],
Cell[CellGroupData[{
Cell[2673, 110, 99, 3, 28, "Input",
 CellID->16893],
Cell[2775, 115, 156, 5, 36, "Output",
 CellID->16074]
}, Open  ]],
Cell[2946, 123, 93, 1, 70, "MathCaption",
 CellID->13509],
Cell[CellGroupData[{
Cell[3064, 128, 233, 9, 70, "Input",
 CellID->30300],
Cell[3300, 139, 156, 5, 36, "Output",
 CellID->19695]
}, Open  ]],
Cell[3471, 147, 119, 3, 70, "MathCaption",
 CellID->9573],
Cell[CellGroupData[{
Cell[3615, 154, 228, 9, 70, "Input",
 CellID->15589],
Cell[3846, 165, 156, 5, 36, "Output",
 CellID->13161]
}, Open  ]],
Cell[4017, 173, 1090, 34, 70, "DefinitionBox",
 CellID->31172],
Cell[5110, 209, 131, 6, 70, "Caption",
 CellID->17968],
Cell[5244, 217, 620, 21, 70, "Text",
 CellID->27358],
Cell[5867, 240, 84, 1, 70, "MathCaption",
 CellID->26031],
Cell[CellGroupData[{
Cell[5976, 245, 92, 3, 70, "Input",
 CellID->26268],
Cell[6071, 250, 177, 5, 36, "Output",
 CellID->19426]
}, Open  ]],
Cell[6263, 258, 95, 1, 70, "MathCaption",
 CellID->28510],
Cell[CellGroupData[{
Cell[6383, 263, 116, 4, 70, "Input",
 CellID->10422],
Cell[6502, 269, 162, 5, 36, "Output",
 CellID->30774]
}, Open  ]],
Cell[6679, 277, 52, 1, 70, "MathCaption",
 CellID->8779],
Cell[CellGroupData[{
Cell[6756, 282, 73, 2, 70, "Input",
 CellID->30910],
Cell[6832, 286, 162, 5, 36, "Output",
 CellID->23552]
}, Open  ]],
Cell[7009, 294, 175, 4, 70, "RelatedTutorials",
 CellID->21356267]
}, Open  ]],
Cell[7199, 301, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

